import { IFormRenderer, IFormRendererRegistry } from './tokens';
/**
 * A registry for property renderers used in the FormEditor component.
 */
export declare class FormRendererRegistry implements IFormRendererRegistry {
    /**
     * Adds a renderer for a given property of a given settings plugin.
     *
     * The id must follow that structure `<ISettingRegistry.IPlugin.id>.<propertyName>`
     *
     * @param id - Unique ID for the given renderer.
     * @param renderer - A renderer interfacing IFormRenderer.
     */
    addRenderer(id: string, renderer: IFormRenderer): void;
    /**
     * Returns all registered renderers in dictionary form.
     * @returns - A dictionary that maps an id to a renderer.
     */
    get renderers(): {
        [id: string]: IFormRenderer;
    };
    /**
     * Returns the renderer for the given id
     * @param id - The unique id for the renderer.
     * @returns - A renderer interfacing IFormRenderer.
     */
    getRenderer(id: string): IFormRenderer;
    private _renderers;
}
