---
title: Hugging Face Hub Endpoints
---

# Hugging Face Hub API Endpoints


We have open endpoints that you can use to retrieve information from the Hub as well as perform certain actions such as creating model repos. We offer a wrapper Python library, [`huggingface_hub`](https://github.com/huggingface/huggingface_hub), that allows easy access to these endpoints. We also provide a [webhook](#webhook) to receive real-time incremental info about models. Enjoy!


## Endpoints table

| Endpoint                                                                         | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | `huggingface_hub` root methods       | Payload                                                                                                                                  |
| -------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------- |
| /api/models  <br/>  GET                                                          | Get information from all models in the Hub. You can specify additional parameters to have more specific results.  <br/>- `filter`: Filter based on tags, such as `text-classification` or `spacy`.<br/>- `sort`: Property to use when sorting. <br/>- `direction`: Direction in which to sort. <br/>- `limit`: Limit the number of models fetched. <br/>- `full`: Whether to fetch most model data, such as all tags, the files, etc. <br/>- `config`: Whether to also fetch the repo config. | `list_models()`                        | ```params= {   "filter":"filter", "full":"full", "sort": "sort",   "direction": "direction",   "limit": "limit",   "config": "config" }```                   |
| /api/models/{repo_id} <br/> /api/models/{repo_id}/revision/{revision} <br/>  GET | Get all information for a specific model.                                                                                                                                                                                                                                                                                                                                                                                                                                         | `model_info(repo_id, revision)`        | ```headers = { "authorization" :  "Bearer $token" }```                                                                                     |
| /api/datasets  <br/>  GET                                                        | Get information from all datasets in the Hub.  You can specify additional parameters to have more specific results.  <br/>- `filter`: Filter based on tags, such as `task_categories:text-classification` or `languages:en`.<br/>- `sort`: Property to use when sorting. <br/>- `direction`: Direction in which to sort. <br/>- `limit`: Limit the number of datasets fetched. <br/>- `full`: Whether to fetch most dataset data, such as all tags, the files, etc.                                                                                                                                                                                                                                                                                                                                                | `list_datasets()`                      | ```params= { "filter":"filter", "full":"full", "sort": "sort", "direction": "direction", "limit": "limit" }```                   |
| /api/datasets/{repo_id} <br/> /api/datasets/{repo_id}/revision/{revision} <br/>  GET | Get all information for a specific dataset.  <br/>- `full`: Whether to fetch most dataset data, such as all tags, the files, etc.                                                                                                                                                                                                                                                                                                                                             | `dataset_info(repo_id, revision)`        | ```headers = { "authorization" :  "Bearer $token", "full" : "full"  }```                                                                                     |
| /api/repos/ls <br/>  GET                                                         | Get list of all stored files for user or organization.                                                                                                                                                                                                                                                                                                                                                                                                                               | `list_repos_objs(token, organization)` | ```headers = { "authorization" :  "Bearer $token" }``` <br/>```params= {   "organization":"organization"}```                                   |
| /api/repos/create  <br/>  POST                                                   | Create a repository. It's a model repo by default. <br> -         type: Type of repo (datasets or spaces; model by default). <br> - name: Name of repo. <br> - organization: Name of organization. - <br> - private: Whether the repo is private.                                                                                                                                                                                                                                 | `create_repo()`                        | ```headers = { authorization :  "Bearer $token" }``` <br/>```json= {"type":"type", "name":"name", "organization":"organization", "private":"private"}``` |
| /api/repos/delete  <br/> DELETE                                                  | Delete a repository. It's a model repo by default. <br> -         type: Type of repo (datasets or spaces; model by default). <br> - name: Name of repo. <br> - organization: Name of organization.                                                                                                                                                                                                                                                                                | `delete_repo()`                        | ```headers = { "authorization" :  "Bearer $token" }``` <br/>```json= {"type":"type", "name":"name", "organization":"organization"}```                  |
| /api/repos/{type}/{repo_id}/settings <br/> PUT                                   | Update repo visibility.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | `update_repo_visibility()`             | ```headers = { "authorization" :  "Bearer $token" }``` <br/>```json= {"private":"private"}```                                                  |
| /api/{type}/{repo_id}/ <br/>  upload/{revision}/{path_in_repo} <br/>  POST       | Upload a file to a specific repository.                                                                                                                                                                                                                                                                                                                                                                                                                                           | `upload_file()`                        | ```headers = { "authorization" :  "Bearer $token" }``` <br/>```"data"="bytestream"```                                                          |
| /api/login <br/>  POST                                                           | Login user and obtain authentication token.                                                                                                                                                                                                                                                                                                                                                                                                                                       | `login(username, password)`            | ```json = { "username" :  "username", "password": "password" }```                                                                                | Get username and organizations the user belongs to.
| /api/whoami  <br/> GET                                                           | Get username and organizations the user belongs to.                                                                                                                                                                                                                                                                                                                                                                                                                               | `whoami(token)`                        | ```headers = { "authorization" :  "Bearer $token" }```                                                                                     |
/api/logout  <br/>                 POST                                          | Log out user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | `logout(token)`                        | ```headers = { "authorization" :  "Bearer $token" }```                                                                                     |

## Webhook

If you ever need to programmatically get notified about all the changes/additions to model repositories on the Hugging Face Hub, you can subscribe to the Hugging Face Hub webhook.

When you're subscribed – meaning you sent us a URL on your side that you want us to ping – we will call it over HTTP with the following payload:

```python
{ "add": "user/model_id" }
# or
{ "update": "organization/model_id" }
# or
{ "remove": "user/model_id" }
```

✉️ Contact us at `website at huggingface.co` if you would like to subscribe to the webhook.
