#!/usr/bin/env python
import os
import sys
import subprocess

if len(sys.argv) < 2:
    execname = os.path.basename(sys.argv[0])
    print >> sys.stderr, "usage: %s CLIENT_ID" % execname

client_id = sys.argv[1]

subprocess.check_call(['hg', 'branch', "--force", "hammer-branch-%s" % client_id])

while True:
    subprocess.check_call([
        'hg', 'commit',
        "--config", "ui.allowemptycommit=yes",
        "--message", "hammer-%s" % client_id,
    ])
    nodeid = subprocess.check_output([
        'hg', 'log', '--rev', '.', '--template', '{node}'
    ])
    subprocess.check_call([
        'hg', 'debugobsolete', ''.join(reversed(nodeid)), nodeid
    ])
    subprocess.check_call(['hg', 'pull'])
    subprocess.check_call(['hg', 'push', '--force'])
