  $ cat >> $HGRCPATH <<EOF
  > [defaults]
  > amend=-d "0 0"
  > [web]
  > push_ssl = false
  > allow_push = *
  > [phases]
  > publish = False
  > [alias]
  > qlog = log --template='{rev} - {node|short} {desc} ({phase})\n'
  > mqlog = log --mq --template='{rev} - {desc}\n'
  > [diff]
  > git = 1
  > unified = 0
  > [extensions]
  > hgext.rebase=
  > hgext.graphlog=
  > hgext.mq=
  > EOF
  $ echo "evolve=$(echo $(dirname $TESTDIR))/hgext/evolve.py" >> $HGRCPATH
  $ echo "qsync=$(echo $(dirname $TESTDIR))/hgext/qsync.py" >> $HGRCPATH
  $ mkcommit() {
  >    echo "$1" > "$1"
  >    hg add "$1"
  >    hg ci -m "add $1"
  > }

basic sync

  $ hg init local
  $ cd local
  $ hg qinit -c
  $ hg qci -m "initial commit"
  $ mkcommit a
  $ mkcommit b
  $ hg qlog
  1 - 7c3bad9141dc add b (draft)
  0 - 1f0dee641bb7 add a (draft)
  $ hg qsync -a
  $ hg mqlog
  2 - qsubmit commit
  
  * DEFAULT-add_a.diff ready for review
  * DEFAULT-add_b.diff ready for review
  1 - qsubmit init
  0 - initial commit

basic sync II

  $ hg init local
  $ cd local
  $ hg qinit -c
  $ hg qci -m "initial commit"
  $ mkcommit a
  $ mkcommit b
  $ hg qlog
  1 - 7c3bad9141dc add b (draft)
  0 - 1f0dee641bb7 add a (draft)
  $ hg qsync -a
  $ hg mqlog
  2 - qsubmit commit
  
  * DEFAULT-add_a.diff ready for review
  * DEFAULT-add_b.diff ready for review
  1 - qsubmit init
  0 - initial commit

  $ echo "b" >> b
  $ hg amend
  $ hg qsync -a
  $ hg mqlog
  3 - qsubmit commit
  
  * DEFAULT-add_b.diff ready for review
  2 - qsubmit commit
  
  * DEFAULT-add_a.diff ready for review
  * DEFAULT-add_b.diff ready for review
  1 - qsubmit init
  0 - initial commit

  $ hg up -r 0
  0 files updated, 0 files merged, 1 files removed, 0 files unresolved
  $ echo "a" >> a
  $ hg amend
  1 new unstable changesets
  $ hg graft -O 3
  grafting revision 3
  $ hg qsync -a
  $ hg mqlog
  4 - qsubmit commit
  
  * DEFAULT-add_a.diff ready for review
  * DEFAULT-add_b.diff ready for review
  3 - qsubmit commit
  
  * DEFAULT-add_b.diff ready for review
  2 - qsubmit commit
  
  * DEFAULT-add_a.diff ready for review
  * DEFAULT-add_b.diff ready for review
  1 - qsubmit init
  0 - initial commit

sync with published changeset

  $ hg init local
  $ cd local
  $ hg qinit -c
  $ hg qci -m "initial commit"
  $ mkcommit a
  $ mkcommit b
  $ hg qlog
  1 - 7c3bad9141dc add b (draft)
  0 - 1f0dee641bb7 add a (draft)
  $ hg qsync -a
  $ hg mqlog
  2 - qsubmit commit
  
  * DEFAULT-add_a.diff ready for review
  * DEFAULT-add_b.diff ready for review
  1 - qsubmit init
  0 - initial commit

  $ hg phase -p 0
  $ hg qsync -a
  $ hg mqlog
  3 - qsubmit commit
  
  * applied DEFAULT-add_a.diff
  2 - qsubmit commit
  
  * DEFAULT-add_a.diff ready for review
  * DEFAULT-add_b.diff ready for review
  1 - qsubmit init
  0 - initial commit

  $ mkcommit c
  $ mkcommit d
  $ hg qsync -a
  $ hg mqlog
  4 - qsubmit commit
  
  * DEFAULT-add_c.diff ready for review
  * DEFAULT-add_d.diff ready for review
  3 - qsubmit commit
  
  * applied DEFAULT-add_a.diff
  2 - qsubmit commit
  
  * DEFAULT-add_a.diff ready for review
  * DEFAULT-add_b.diff ready for review
  1 - qsubmit init
  0 - initial commit

  $ cd ..
  $ hg qclone -U local local2
  $ cd local2
  $ hg qlog
  3 - 47d2a3944de8 add d (draft)
  2 - 4538525df7e2 add c (draft)
  1 - 7c3bad9141dc add b (draft)
  0 - 1f0dee641bb7 add a (public)
  $ hg strip -n 1 --no-backup
  $ hg up
  1 files updated, 0 files merged, 0 files removed, 0 files unresolved
  $ hg up --mq 4
  6 files updated, 0 files merged, 0 files removed, 0 files unresolved
  $ hg qseries
  DEFAULT-add_b.diff
  DEFAULT-add_c.diff
  DEFAULT-add_d.diff
  $ hg qpush
  applying DEFAULT-add_b.diff
  now at: DEFAULT-add_b.diff
  $ hg qfinish -a
  $ hg phase -p .
  $ hg qci -m "applied DEFAULT-add_b.diff"
  $ cd ../local
  $ hg pull ../local2
  pulling from ../local2
  searching for changes
  no changes found
  $ hg pull --mq ../local2/.hg/patches
  pulling from ../local2/.hg/patches
  searching for changes
  adding changesets
  adding manifests
  adding file changes
  added 1 changesets with 1 changes to 1 files
  (run 'hg update' to get a working copy)
  $ hg qlog
  3 - 47d2a3944de8 add d (draft)
  2 - 4538525df7e2 add c (draft)
  1 - 7c3bad9141dc add b (public)
  0 - 1f0dee641bb7 add a (public)
  $ hg mqlog -l 1
  5 - applied DEFAULT-add_b.diff
  $ hg status --mq --rev tip:-2
  M series
  A DEFAULT-add_b.diff
  $ hg qsync -a
  $ hg status --mq --rev tip:-2
  M qsubmitdata
  $ hg mqlog -l 1
  6 - qsubmit commit
  
  * applied DEFAULT-add_b.diff
  $ hg qsync -a
  abort: Nothing changed
  [255]

mixed sync

  $ hg init local
  $ cd local
  $ hg qinit -c
  $ mkcommit a
  $ mkcommit b
  $ hg qlog
  1 - 7c3bad9141dc add b (draft)
  0 - 1f0dee641bb7 add a (draft)
  $ hg qsync -a
  $ hg mqlog
  1 - qsubmit commit
  
  * DEFAULT-add_a.diff ready for review
  * DEFAULT-add_b.diff ready for review
  0 - qsubmit init
  $ hg phase -p 0
  $ echo "b" >> b
  $ hg amend
  $ hg qsync -a
  $ hg mqlog -l 1
  2 - qsubmit commit
  
  * applied DEFAULT-add_a.diff
  * DEFAULT-add_b.diff ready for review

