# randomname.py - topic extension
#
# This software may be used and distributed according to the terms of the
# GNU General Public License version 2 or any later version.
"""random topic generator utils
"""

import random

animals = [
    'aardvark',
    'albatross',
    'alligator',
    'alpaca',
    'ant',
    'anteater',
    'antelope',
    'ape',
    'armadillo',
    'baboon',
    'badger',
    'barracuda',
    'bat',
    'bear',
    'beaver',
    'bee',
    'beetle',
    'bison',
    'boar',
    'buffalo',
    'bushbaby',
    'bustard',
    'butterfly',
    'camel',
    'capuchin',
    'carabao',
    'caribou',
    'cat',
    'caterpillar',
    'cattle',
    'chameleon',
    'chamois',
    'cheetah',
    'chicken',
    'chimpanzee',
    'chinchilla',
    'chipmunk',
    'chough',
    'cicada',
    'clam',
    'cobra',
    'cockroach',
    'cod',
    'cormorant',
    'coyote',
    'crab',
    'crane',
    'cricket',
    'crocodile',
    'crow',
    'curlew',
    'deer',
    'dinosaur',
    'dog',
    'dogfish',
    'dolphin',
    'donkey',
    'dotterel',
    'dove',
    'dragon',
    'dragonfly',
    'duck',
    'dugong',
    'dunlin',
    'eagle',
    'echidna',
    'eel',
    'eland',
    'elephant',
    'elk',
    'emu',
    'falcon',
    'ferret',
    'finch',
    'fish',
    'flamingo',
    'fly',
    'fox',
    'frog',
    'gaur',
    'gazelle',
    'gecko',
    'gerbil',
    'giraffe',
    'gnat',
    'gnu',
    'goat',
    'goldfish',
    'goose',
    'gorilla',
    'goshawk',
    'grasshopper',
    'grouse',
    'guanaco',
    'guinea',
    'gull',
    'hamster',
    'hare',
    'hawk',
    'hedgehog',
    'heron',
    'herring',
    'hippopotamus',
    'hornet',
    'horse',
    'horsecrab',
    'hound',
    'hummingbird',
    'hyena',
    'hyrax',
    'ibex',
    'ibis',
    'iguana',
    'impala',
    'insect',
    'jackal',
    'jaguar',
    'jay',
    'jellyfish',
    'kangaroo',
    'koala',
    'kouprey',
    'kudu',
    'lapwing',
    'lark',
    'lemming',
    'lemur',
    'leopard',
    'lion',
    'lizard',
    'llama',
    'lobster',
    'locust',
    'loris',
    'louse',
    'lynx',
    'lyrebird',
    'magpie',
    'mallard',
    'mammoth',
    'manatee',
    'marten',
    'meerkat',
    'mink',
    'minnow',
    'mole',
    'mongoose',
    'monkey',
    'moose',
    'mosquito',
    'mouse',
    'mule',
    'muskrat',
    'narwhal',
    'newt',
    'nightingale',
    'numbat',
    'octopus',
    'okapi',
    'opossum',
    'oryx',
    'ostrich',
    'otter',
    'owl',
    'ox',
    'oyster',
    'panda',
    'panther',
    'parrot',
    'partridge',
    'peacock',
    'peafowl',
    'pelican',
    'penguin',
    'pheasant',
    'pig',
    'pigeon',
    'platypus',
    'pony',
    'porcupine',
    'porpoise',
    'prairie',
    'puffin',
    'pug',
    'quagga',
    'quail',
    'quelea',
    'rabbit',
    'raccoon',
    'ram',
    'rat',
    'raven',
    'reindeer',
    'rhea',
    'rhinoceros',
    'rook',
    'ruff',
    'salamander',
    'salmon',
    'sambar',
    'sandpiper',
    'sardine',
    'scorpion',
    'seahorse',
    'seal',
    'serval',
    'shark',
    'sheep',
    'shrew',
    'shrimp',
    'skink',
    'skunk',
    'snail',
    'snake',
    'spider',
    'squid',
    'squirrel',
    'starling',
    'stinkbug',
    'stork',
    'swan',
    'tapir',
    'tarsier',
    'termite',
    'tern',
    'tiger',
    'toad',
    'trout',
    'turkey',
    'turtle',
    'unicorn',
    'viper',
    'vulture',
    'wallaby',
    'walrus',
    'wasp',
    'weasel',
    'whale',
    'wolf',
    'wolverine',
    'wombat',
    'woodchuck',
    'woodcock',
    'woodpecker',
    'worm',
    'wren',
    'yak',
    'zebra',
    'zorilla'
]

adjectives = [
    'abiding',
    'abject',
    'ablaze',
    'able',
    'aboard',
    'abounding',
    'absorbed',
    'absorbing',
    'abstracted',
    'abundant',
    'acceptable',
    'accessible',
    'accurate',
    'acoustic',
    'adamant',
    'adaptable',
    'adhesive',
    'adjoining',
    'adorable',
    'adventurous',
    'affable',
    'affectionate',
    'agreeable',
    'alert',
    'alive',
    'alluring',
    'amazing',
    'ambiguous',
    'ambitious',
    'amiable',
    'amicable',
    'amused',
    'amusing',
    'ancient',
    'animated',
    'apricot',
    'aquatic',
    'arctic',
    'arenaceous',
    'aromatic',
    'aspiring',
    'assiduous',
    'assorted',
    'astonishing',
    'attractive',
    'auspicious',
    'automatic',
    'available',
    'average',
    'awake',
    'aware',
    'awesome',
    'axiomatic',
    'bashful',
    'bawdy',
    'beautiful',
    'beefy',
    'befitting',
    'beneficial',
    'benevolent',
    'bent',
    'best',
    'better',
    'bewildered',
    'bewitching',
    'big',
    'billowy',
    'bizarre',
    'black',
    'blithe',
    'blue',
    'blushing',
    'bouncy',
    'boundless',
    'brainy',
    'brash',
    'brave',
    'brawny',
    'brazen',
    'breezy',
    'brief',
    'bright',
    'brilliant',
    'broad',
    'brown',
    'bucolic',
    'bulky',
    'bumpy',
    'burgundy',
    'burly',
    'bustling',
    'busy',
    'calm',
    'capable',
    'capricious',
    'captivating',
    'carefree',
    'careful',
    'caring',
    'carrot',
    'ceaseless',
    'cerise',
    'certain',
    'challenging',
    'changeable',
    'charming',
    'cheerful',
    'chief',
    'chilly',
    'chipper',
    'classy',
    'clean',
    'clear',
    'clever',
    'cloudy',
    'coherent',
    'colorful',
    'colossal',
    'comfortable',
    'common',
    'communicative',
    'compassionate',
    'complete',
    'complex',
    'compulsive',
    'confused',
    'conscientious',
    'conscious',
    'conservative',
    'considerate',
    'convivial',
    'cooing',
    'cool',
    'cooperative',
    'coordinated',
    'courageous',
    'courteous',
    'crazy',
    'creative',
    'crispy',
    'crooked',
    'crowded',
    'cuddly',
    'cultured',
    'cunning',
    'curious',
    'curly',
    'curved',
    'curvy',
    'cut',
    'cute',
    'daily',
    'damp',
    'dapper',
    'dashing',
    'dazzling',
    'dear',
    'debonair',
    'decisive',
    'decorous',
    'deep',
    'defiant',
    'delicate',
    'delicious',
    'delighted',
    'delightful',
    'delirious',
    'descriptive',
    'detached',
    'detailed',
    'determined',
    'different',
    'diligent',
    'diminutive',
    'diplomatic',
    'discreet',
    'distinct',
    'distinctive',
    'dramatic',
    'dry',
    'dynamic',
    'dynamite',
    'eager',
    'early',
    'earthy',
    'easy',
    'easygoing',
    'eatable',
    'economic',
    'ecstatic',
    'educated',
    'efficacious',
    'efficient',
    'effortless',
    'eight',
    'elastic',
    'elated',
    'electric',
    'elegant',
    'elfin',
    'elite',
    'eminent',
    'emotional',
    'enchanted',
    'enchanting',
    'encouraging',
    'endless',
    'energetic',
    'enormous',
    'entertaining',
    'enthusiastic',
    'envious',
    'epicurean',
    'equable',
    'equal',
    'eternal',
    'ethereal',
    'evanescent',
    'even',
    'excellent',
    'excited',
    'exciting',
    'exclusive',
    'exotic',
    'expensive',
    'exquisite',
    'extroverted',
    'exuberant',
    'exultant',
    'fabulous',
    'fair',
    'faithful',
    'familiar',
    'famous',
    'fancy',
    'fantastic',
    'far',
    'fascinated',
    'fast',
    'fearless',
    'female',
    'fertile',
    'festive',
    'few',
    'fine',
    'first',
    'five',
    'fixed',
    'flamboyant',
    'flashy',
    'flat',
    'flawless',
    'flirtatious',
    'florid',
    'flowery',
    'fluffy',
    'fluttering',
    'foamy',
    'foolish',
    'foregoing',
    'fortunate',
    'four',
    'frank',
    'free',
    'frequent',
    'fresh',
    'friendly',
    'full',
    'functional',
    'funny',
    'furry',
    'future',
    'futuristic',
    'fuzzy',
    'gabby',
    'gainful',
    'garrulous',
    'general',
    'generous',
    'gentle',
    'giant',
    'giddy',
    'gifted',
    'gigantic',
    'gilded',
    'glamorous',
    'gleaming',
    'glorious',
    'glossy',
    'glowing',
    'godly',
    'good',
    'goofy',
    'gorgeous',
    'graceful',
    'grandiose',
    'grateful',
    'gratis',
    'gray',
    'great',
    'green',
    'gregarious',
    'grey',
    'groovy',
    'guiltless',
    'gusty',
    'guttural',
    'habitual',
    'half',
    'hallowed',
    'halting',
    'handsome',
    'happy',
    'hard',
    'hardworking',
    'harmonious',
    'heady',
    'healthy',
    'heavenly',
    'helpful',
    'hilarious',
    'historical',
    'holistic',
    'hollow',
    'honest',
    'honorable',
    'hopeful',
    'hospitable',
    'hot',
    'huge',
    'humorous',
    'hungry',
    'hushed',
    'hypnotic',
    'illustrious',
    'imaginary',
    'imaginative',
    'immense',
    'imminent',
    'impartial',
    'important',
    'imported',
    'impossible',
    'incandescent',
    'inconclusive',
    'incredible',
    'independent',
    'industrious',
    'inexpensive',
    'innate',
    'innocent',
    'inquisitive',
    'instinctive',
    'intellectual',
    'intelligent',
    'intense',
    'interesting',
    'internal',
    'intuitive',
    'inventive',
    'invincible',
    'jazzy',
    'jolly',
    'joyful',
    'joyous',
    'judicious',
    'juicy',
    'jumpy',
    'keen',
    'kind',
    'kindhearted',
    'kindly',
    'knotty',
    'knowing',
    'knowledgeable',
    'known',
    'laconic',
    'large',
    'lavish',
    'lean',
    'learned',
    'left',
    'legal',
    'level',
    'light',
    'likeable',
    'literate',
    'little',
    'lively',
    'living',
    'long',
    'longing',
    'loud',
    'lovely',
    'loving',
    'loyal',
    'lucky',
    'luminous',
    'lush',
    'luxuriant',
    'luxurious',
    'lyrical',
    'magenta',
    'magical',
    'magnificent',
    'majestic',
    'male',
    'mammoth',
    'many',
    'marvelous',
    'massive',
    'material',
    'mature',
    'meandering',
    'meaty',
    'medical',
    'mellow',
    'melodic',
    'melted',
    'merciful',
    'mighty',
    'miniature',
    'miniscule',
    'minor',
    'minute',
    'misty',
    'modern',
    'modest',
    'momentous',
    'motionless',
    'mountainous',
    'mute',
    'mysterious',
    'narrow',
    'natural',
    'near',
    'neat',
    'nebulous',
    'necessary',
    'neighborly',
    'new',
    'next',
    'nice',
    'nifty',
    'nimble',
    'nine',
    'nippy',
    'noiseless',
    'noisy',
    'nonchalant',
    'normal',
    'numberless',
    'numerous',
    'nutritious',
    'obedient',
    'observant',
    'obtainable',
    'oceanic',
    'omniscient',
    'one',
    'open',
    'opposite',
    'optimal',
    'optimistic',
    'opulent',
    'orange',
    'ordinary',
    'organic',
    'outgoing',
    'outrageous',
    'outstanding',
    'oval',
    'overjoyed',
    'overt',
    'palatial',
    'panoramic',
    'parallel',
    'passionate',
    'past',
    'pastoral',
    'patient',
    'peaceful',
    'perfect',
    'periodic',
    'permissible',
    'perpetual',
    'persistent',
    'petite',
    'philosophical',
    'physical',
    'picturesque',
    'pink',
    'pioneering',
    'piquant',
    'plausible',
    'pleasant',
    'plucky',
    'poised',
    'polite',
    'possible',
    'powerful',
    'practical',
    'precious',
    'premium',
    'present',
    'pretty',
    'previous',
    'private',
    'probable',
    'productive',
    'profound',
    'profuse',
    'protective',
    'proud',
    'psychedelic',
    'public',
    'pumped',
    'purple',
    'purring',
    'puzzled',
    'puzzling',
    'quaint',
    'quick',
    'quicker',
    'quickest',
    'quiet',
    'quirky',
    'quixotic',
    'quizzical',
    'rainy',
    'rapid',
    'rare',
    'rational',
    'ready',
    'real',
    'rebel',
    'receptive',
    'red',
    'reflective',
    'regular',
    'relaxed',
    'reliable',
    'relieved',
    'remarkable',
    'reminiscent',
    'reserved',
    'resolute',
    'resonant',
    'resourceful',
    'responsible',
    'rich',
    'ridiculous',
    'right',
    'rightful',
    'ripe',
    'ritzy',
    'roasted',
    'robust',
    'romantic',
    'roomy',
    'round',
    'royal',
    'ruddy',
    'rural',
    'rustic',
    'sable',
    'safe',
    'salty',
    'same',
    'satisfying',
    'savory',
    'scientific',
    'scintillating',
    'scrumptious',
    'second',
    'secret',
    'secretive',
    'seemly',
    'selective',
    'sensible',
    'separate',
    'shaggy',
    'shaky',
    'shining',
    'shiny',
    'short',
    'shy',
    'silent',
    'silky',
    'silly',
    'simple',
    'simplistic',
    'sincere',
    'six',
    'sizzling',
    'skillful',
    'sleepy',
    'slick',
    'slim',
    'smart',
    'smiling',
    'smooth',
    'soaring',
    'sociable',
    'soft',
    'solid',
    'sophisticated',
    'sparkling',
    'special',
    'spectacular',
    'speedy',
    'spicy',
    'spiffy',
    'spiritual',
    'splendid',
    'spooky',
    'spotless',
    'spotted',
    'square',
    'standing',
    'statuesque',
    'steadfast',
    'steady',
    'steep',
    'stimulating',
    'straight',
    'straightforward',
    'striking',
    'striped',
    'strong',
    'stunning',
    'stupendous',
    'sturdy',
    'subsequent',
    'substantial',
    'subtle',
    'successful',
    'succinct',
    'sudden',
    'super',
    'superb',
    'supreme',
    'swanky',
    'sweet',
    'swift',
    'sympathetic',
    'synonymous',
    'talented',
    'tall',
    'tame',
    'tan',
    'tangible',
    'tangy',
    'tasteful',
    'tasty',
    'telling',
    'temporary',
    'tempting',
    'ten',
    'tender',
    'terrific',
    'tested',
    'thankful',
    'therapeutic',
    'thin',
    'thinkable',
    'third',
    'thoughtful',
    'three',
    'thrifty',
    'tidy',
    'tiny',
    'toothsome',
    'towering',
    'tranquil',
    'tremendous',
    'tricky',
    'true',
    'truthful',
    'two',
    'typical',
    'ubiquitous',
    'ultra',
    'unassuming',
    'unbiased',
    'uncovered',
    'understanding',
    'understood',
    'unequaled',
    'unique',
    'unusual',
    'unwritten',
    'upbeat',
    'useful',
    'utopian',
    'utter',
    'uttermost',
    'valuable',
    'various',
    'vast',
    'verdant',
    'vermilion',
    'versatile',
    'versed',
    'victorious',
    'vigorous',
    'violet',
    'vivacious',
    'voiceless',
    'voluptuous',
    'wacky',
    'waiting',
    'wakeful',
    'wandering',
    'warm',
    'warmhearted',
    'wealthy',
    'whimsical',
    'whispering',
    'white',
    'whole',
    'wholesale',
    'whopping',
    'wide',
    'wiggly',
    'wild',
    'willing',
    'windy',
    'winsome',
    'wiry',
    'wise',
    'wistful',
    'witty',
    'womanly',
    'wonderful',
    'workable',
    'young',
    'youthful',
    'yummy',
    'zany',
    'zealous',
    'zesty',
    'zippy'
]

def randomtopicname(ui):
    if ui.configint("devel", "randomseed"):
        random.seed(ui.configint("devel", "randomseed"))
    return random.choice(adjectives) + "-" + random.choice(animals)
