#!/usr/bin/env python
from __future__ import print_function
import sys
sys.stdout = sys.stderr
import unittest
import pygsl._numobj as numx
import pygsl.testing.sf as sf

class PolarToRectangle(unittest.TestCase):
    def test_rect_to_polar(self):
        value = numx.exp(1j * (2 * numx.pi / 4 * numx.arange(4+1)))
        result =  sf.rect_to_polar(value)
        
    def test_polar_to_rect(self):
        angle = numx.arange(4+1) * 2 * numx.pi/4
        radius = 1.0
        result = sf.polar_to_rect(radius, angle)
        print(result)

class EDOMTest(unittest.TestCase):
    def test0(self):
        sf.psi(0)
        
if __name__ == '__main__':
    unittest.main()
