#!/usr/bin/env python

# patch distutils if it can't cope with the "classifiers" or
# "download_url" keywords
import sys
if sys.version <= '2.2.3':
    from distutils.dist import DistributionMetadata
    DistributionMetadata.classifiers = None
    DistributionMetadata.download_url = None

from distutils.core import setup

setup(name="GraphPath",
      version="0.7",
      author="Arnold deVos",
      author_email="adv@langdale.com.au",
      url="http://www.langdale.com.au/GraphPath/",
      packages=['graphpath', 'graphpath.util'],
      description="A little-language for analysing" +
      " graph-structured data, especially RDF.",
      long_description=""""A little-language for analysing RDF,
      the syntax of the GraphPath is reminiscent of Xpath.
      The graphpath package provides a query evaluator
      and a goal-driven inference engine for this language,
      which work together to perform graph analysis. The package
      can be teamed up with your favourite python RDF API
      (e.g. Redland, rdflib, or your own API).
      """,
      license='GNU General Public License (GPL)',
      classifiers = [
          'Development Status :: 4 - Beta',
          'Environment :: Console',
          'Intended Audience :: Developers',
          'License :: OSI Approved :: GNU General Public License (GPL)',
          'Operating System :: OS Independent',
          'Programming Language :: Python',
          'Topic :: Software Development :: Libraries :: Python Modules',
	  'Topic :: Scientific/Engineering :: Information Analysis',
	  'Topic :: Internet :: RDF'
          ],
     )


