""" Provide DBPopulation class as a convenience for dealing with BDB hashes.
"""
import RDF
from graphpath.redadapt import Population
from anysets import Set
from os.path import split

def resource(uri_string, fragment=""):
	return RDF.Node( uri_string=uri_string+fragment )

def uriref( res ):
	return str(res.uri)

def local(res):
	uri = uriref( res )
	end = uri.find('#')
	if end == -1:
		return ""
	else:
		return uri[end+1:]

Namespace = RDF.NS # renamed the redland version to match local convention

class MemPopulation(Population):
	def __init__(self):
		Population.__init__(self, RDF.Model())


class DBPopulation(Population):
	def __init__(self, pathname, mode="r"):
		self._pathname, self._mode = pathname, mode
		dirname, name = split(pathname)
		dirname = dirname or "."
		if mode == 'w':
			create, write = 'yes', 'yes'
		elif mode == 'a':
			create, write = 'no', 'yes'
		else:
			create, write = 'no', 'no'

		options="hash-type='bdb',new='%s',write='%s',dir='%s'" % (create, write, dirname)

		Population.__init__(self,
			RDF.Model(
				RDF.Storage(
					storage_name="hashes",
					name=name,
					options_string=options)))

	def __getstate__(self):
		return self._pathname

	def __setstate__(self, pathname):
		print "unpickling DBPopulation at",pathname
		self.__init__(pathname)
		print "unpickled"

# 	def sync(self):
# 		self._model.sync()

def test01():
	ex = RDF.NS("example:#")
	pop = DBPopulation("testing", "w")
	pop.add(ex.julie, ex.motherOf, ex.david )
# 	pop.sync()
	del pop
	pop = DBPopulation("testing", "a")
	pop.add(ex.adrian, ex.fatherOf, ex.david)
	pop.add(ex.julie, ex.childOf, ex.john )
	assert pop.match(ex.motherOf, ex.david) == Set([ex.julie])
	assert pop.values(ex.julie, ex.childOf) == Set([ex.john])
	del pop
	pop = DBPopulation("testing", "r")
	for subj in pop:
		for pred, obj in pop[subj]:
			print subj, pred, obj

if __name__ == "__main__":
	test01()
