""" Provide DBPopulation class as a convenience for dealing with BDB hashes.
"""
from __future__ import generators
from rdflib.URIRef import URIRef
from rdflib.TripleStore import TripleStore
from graphpath.libadapt import Population

def resource(uri_string, fragment=""):
	return URIRef( uri_string+fragment )

def uriref( res ):
	return str(res)

def local(res):
	uri = uriref( res )
	end = uri.find('#')
	if end == -1:
		return ""
	else:
		return uri[end+1:]


class Namespace:
	def __init__(self, uri,):
		self._uri = uri
	def __str__(self):
		return self._uri
	def __getattr__(self, name):
		if name.startswith('_'):
			raise AttributeError, name
		else:
			return resource(self._uri + name)

class MemPopulation(Population):
	def __init__(self):
		Population.__init__(self, TripleStore())
