"""Utilities for converting populations to and from CSV format.
"""
import csv
from identity import genid, resource, rdf, rdfs
from store import Population
from re import sub
from os.path import abspath
from urllib import pathname2url


def normalize(name):
	unwanted ='[ /)(!@#$%^&*-+=|"\';:,.]+'
	return sub(unwanted, '_', sub( "^" + unwanted + "|" + unwanted + "$", '', name ))

sequ=1

def makeprop( ns, name ):
	""""Convert a heading into a property resource."""
	global sequ
	norm = normalize( name )
	if not norm:
		norm = "unnamed" + str(sequ)
		sequ += 1
	return resource( ns, norm )

def load(name, pop=None, uri=None, type_node=None, ns="#", convert=str):
	"""Load the CSV data from the named file into the given population.

	If not given, a population is instantiated.  The loaded population is
	returned.

	If given, uri is the (true) URI for the file and forms the namespace for
	the row resources. Otherwise the filename is convertedto a namespace uri.

	If geven, type_node is assigned to the rdf:type of each row resource.

	If given, ns is the namespace URI for the properties assigned to each
	row. Otherwise the properties are local identifiers, namespace "#".

	"""
	if not uri:
		uri = "file:" + pathname2url(abspath(name))
	ref = resource( uri )
	if not uri.endswith( "#" ):
		uri = uri + "#"
	raw = file(name, "rb")
	try:
		if pop is None:
			pop = Population()
		rows = csv.reader(raw)
		heads = [makeprop(ns, head) for head in rows.next()]
		#print heads
		ix = 0
		for row in rows:
			node = resource( uri, str(ix))
			ix += 1
			for head, value in zip( heads, row ):
				#print head, repr(value)
				pop.add( node, head, convert(value.strip()))
			if type_node:
				pop.add( node, rdf.type, type_node)
			pop.add( node, rdfs.isDefinedBy, ref )
	finally:
		raw.close()
	return pop

