"""adapt rdflib RDF API for use in expressions and inference.

essential methods for expressions are Population.match and Population.values.
some extra features are adapted for completeness
"""

from __future__ import generators
from rdflib.TripleStore import TripleStore
from rdflib.Identifier import Identifier
from rdflib.URIRef import URIRef
from rdflib.BNode import BNode
from rdflib.Literal import Literal
from graphpath.expr import adapters, StrategyError
from util.anysets import Set, ImmutableSet
from cPickle import loads, dumps

empty_set = ImmutableSet()
rdf_type = URIRef("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")

def node(maybe_value):
	if isinstance(maybe_value, Identifier):
		return maybe_value
	elif isinstance(maybe_value, (str, unicode)):
		return Literal(maybe_value, '', 'python:string')
	else:
		return Literal( dumps(maybe_value), '', 'python:pickle' )

def value(maybe_literal):
	assert isinstance(maybe_literal, Identifier)
	if isinstance(maybe_literal, Literal):
		if maybe_literal.datatype == 'python:string':
			return unicode(maybe_literal)
		elif maybe_literal.datatype == 'python:pickle':
			return loads(str(maybe_literal))
		else :
			return maybe_literal
	else:
		return maybe_literal

class Population:
	def __init__(self, model):
		if not isinstance( model, TripleStore ):
			raise StrategyError
		self.rdf_type = rdf_type
		self._model = model

        def match( self, prop, value ):
		def items():
			for subj, p, o in self._model.triples((None, prop, node(value))):
				yield subj
		
		if isinstance(prop, URIRef):
			return Set(items())
		else:
			return empty_set

        def values( self, subj, prop):
		def items():
			for s, p, obj in self._model.triples((subj, prop, None)):
				yield value(obj)

		if isinstance(subj, (URIRef, BNode)) and isinstance(prop, URIRef):
			return Set(items())
		else:
			return empty_set

	def add( self, subj, prop, value):
		assert isinstance(subj, (URIRef,BNode))
		assert isinstance(prop, URIRef)
		self._model.add( (subj, prop, node(value)))

	def update( self, other ):
		for subj in other:
			for prop, value in other[subj]:
				self.add(subj, prop, value)

	def __contains__(self, subj):
		if isinstance(subj, URIRef):
			for s in self._model.triples((subj, None, None)):
				return True
		return False

	def __iter__(self):
		def items():
			for subj, p, o in self._model.triples((None, None, None)):
				yield subj
		return iter(Set(items()))

	def __getitem__(self, subj):
		def items():
			for s, pred, obj in self._model.triples((subj, None, None)):
				yield pred, value(obj)

		if isinstance(subj, (URIRef, BNode)):
			return Set(items())
		else:
			return empty_set

	def __eq__(self, other):
		return self.__class__ == other.__class__ and \
			self._model == other._model

	def __repr__(self):
		return "Population(%r)" % self._model

	__str__=__repr__
# register me
adapters.append( Population )
