# An example script that demonstrates most of the module's capabilities.
# Run the script thusly 'python test.py @test.opt'

import sys
import getargs

usage = '''
   -vb  --verbose             enable verbose output
   -f   --file <args>         use these files as input ['default']
   -f   --log <args>          use these files as input ['default']
   -bs  --block-size arg      size of block [128]
   -n   --nodes arg1 [arg2]   use these nodes as compute nodes
   -s   --shell               enable the interactive shell
   -l   --shell               enable the interactive shell
   -c   --color c1 c2 <args>  use these colors to paint output
   -iv  --incr-value arg      size of increment [5]
   -d   --debug [arg]         debug level [4]
'''

dic = { 'verbose' : ('vb', 0), 'file/log':('f', str, -1, 1, 'default'), 
        'block-size':('bs', int, 1, 1, 128), 'nodes':('n', int, 2, 1), 
        'shell':('s/l', 0), 'color/hue':('c', -1, 2), 
        'incr-value':('iv', int, 1, 1, 5), 'debug':('d', int, 1, 0, 4) }

try:
    ap = getargs.CLParser(dic, sys.argv, 1)
except getargs.UsageError, err:
    sys.exit('%s%s' % (err, usage))
except getargs.HelpQuery:
    sys.exit(usage)
except getargs.VersionQuery:
    sys.exit('test.py v1.1')
    
if ap.isset('vb'):
    print 'verbose is set'
if ap.isset('l'):
    print 'shell is set'
print 'files:', ap.getargs('f')
print 'nodes:', ap.getargs('nodes')
print 'incr-value:', ap.getargs('incr-value')
print 'block-size:', ap.getargs('bs')
print 'debug:', ap.getargs('debug')
