# Contributing

## Cloning

To work on `geoplot` locally, you will need to clone it.

```git
git clone https://github.com/ResidentMario/geoplot.git
```

You can then set up your own branch version of the code, and work on your changes for a pull request from there.

```bash
cd geoplot
git checkout -B new-branch-name
```

## Environment

To install the `geoplot` development environment run the following in the root directory:

```bash
conda env create -f environment.yml
conda activate geoplot-dev
pip install -e .[develop]
```

## Testing

`geoplot` tests are located in the `tests` folder. Any PRs you submit should eventually pass all of the tests located in this folder.

`mixin_tests.py` are static unit tests which can be run via `pytest` the usual way (by running `pytest mixin_tests.py` from the command line).

`proj_tests.py` and `viz_tests.py` are visual tests run via the `pytest-mpl` plugin to be run: [see here](https://github.com/matplotlib/pytest-mpl#using) for instructions on how it's used. These tests are passed by visual inspection: e.g. does the output figure look the way it _should_ look, given the inputs?

## Documentation

Documentation is provided via `sphinx`. To regenerate the documentation from the current source in one shot, navigate to the `docs` folder and run `make docs`. Alternatively, to regenerate a single specific section, see the following section.

### Static example images

The static example images on the repo and documentation homepages are located in the `figures/` folder.

### Plot reference images

The images used in the plot reference are generated by running the  `notebooks/generate-api-reference-images.ipynb` Jupyter notebook. To update the images, update or rerun this notebook. Note: because these files are time-consuming to regenerate completely from scratch, they are not included in the `make docs` scipt; modify/rerun the notebook cells yourself instead.

### Gallery

The gallery is generated using `sphinx-gallery`, and use the `examples/` folder as their source. The webmap examples are hosted on [bl.ocks.org](http://bl.ocks.org/) and linked to from their gallery landing pages.

### Quickstart

The Quickstart is a Jupyter notebook in the `notebooks/` directory. To rebuild the quickstart, edit the notebook, then `cd notebooks/tutorials; jupyter nbconvert --to rst --output-dir ../../docs/quickstart/ Quickstart.ipynb`. Then run `make html` again.

### Tutorials

The tutorials are Jupyter notebooks the `notebooks/` directory. To rebuild the tutorials, edit the notebook(s), then `cd notebooks/tutorials/; jupyter nbconvert --to rst --output-dir ../../docs/user_guide/ $NOTEBOOK_NAME.ipynb`. Then run `make html` again.

### Example data

Most of the image resources in the documentation use real-world example data that is packaged as an accessory to this library. The home repo for these datasets is the [`geoplot-data`](https://github.com/ResidentMario/geoplot-data) repository. Use the `geoplot.datasets.get_path` function to get a path to a specific dataset readable by `geopandas`.

### Everything else

The remaining pages are all written as `rst` files accessible from the top level of the `docs` folder.

### Serving

The documentation is served at [residentmario.github.io](https://residentmario.github.io/geoplot/index.html) via GitHub's site export feature, served out of the `gh-pages` branch. To export a new version of the documentation to the website, run the following:

```bash
git checkout gh-pages
rm -rf *
git checkout master -- docs/ examples/ geoplot/ .gitignore
cd docs
make html
cd ..
mv docs/_build/html/* ./
rm -rf docs/ examples/ geoplot/
git add .
git commit -m "Publishing update docs..."
git push origin gh-pages
git checkout master
```
