#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Distributed Environment
# File:         $Source: /cvsroot/fnorb/fnorb/script/fnmkior.py,v $
# Version:      @(#)$RCSfile: fnmkior.py,v $ $Revision: 1.1 $
#
#############################################################################
""" Make a CORBA IOR with a single IIOP profile. """


# Standard/built-in modules.
import sys

# Fnorb modules.
from Fnorb.orb import CORBA, IIOP, IOP


def usage():
    """ Print the usage! """

    print 'Usage: fnmkior Hostname Port TypeId ObjectKey'
    print
    print 'e.g.'
    print
    print '% fnmkior sundial.dstc.edu.au 1234 IDL:dstc.edu.au/Foo:1.0 fred' 

    sys.exit(1)


def main(argv):
    """ Do it! """

    if len(argv) < 5:
	usage()

    # fixme: This should do some error checking!
    host = argv[1]
    port = int(argv[2])
    type = argv[3]
    key  = argv[4]

    # Create an IOR.
    version = IIOP.Version(1, 0)
    profile_body = IIOP.ProfileBody_1_0(version, host, port, key)
    profile = IOP.TaggedProfile(IOP.TAG_INTERNET_IOP, profile_body)
    ior = IOP.IOR(type, [profile])

    # Stringify it.
    sys.stdout.write(ior._fnorb_to_string())
    sys.stdout.write('\n')
    sys.stdout.flush()

    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv))

#############################################################################
