#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /cvsroot/fnorb/fnorb/orb/GIOPServerWorker.py,v $
# Version:      @(#)$RCSfile: GIOPServerWorker.py,v $ $Revision: 1.5 $
#
#############################################################################
""" GIOPServerWorker classes. """


# Fnorb modules.
import CORBA, Util


#############################################################################
# GIOPServerWorker factory.
#############################################################################

def GIOPServerWorkerFactory_init():
    """ Return the GIOPServerWorker factory. 

    This is a factory function for the GIOPServerWorkerFactory class
    (the GIOPServerWorker factory is a singleton (ie. there can only be one
    instance per process)).

    """
    try:
	factory = GIOPServerWorkerFactory()

    except GIOPServerWorkerFactory, factory:
	pass

    return factory


class GIOPServerWorkerFactory:
    """ Factory for GIOPServerWorker instances. 

    The factory is a singleton (ie. there can only be one instance per
    process).

    """
    __instance = None

    def __init__(self):
	""" Constructor. """

	# The factory is a singleton (ie. there can only be one instance per
	# process).
	if GIOPServerWorkerFactory.__instance is not None:
	    raise GIOPServerWorkerFactory.__instance

	GIOPServerWorkerFactory.__instance = self

	return

    #########################################################################
    # GIOPServerWorkerFactory interface.
    #########################################################################

    def create_worker(self, giop_version, protocol, connection):
	""" Create a new GIOP Server worker. """

	# Find out what threading-model we are using.
	model = CORBA.ORB_init()._fnorb_threading_model()

	# Reactive.
	if model == Util.REACTIVE:
	    from GIOPServerWorkerReactive import GIOPServerWorkerReactive
	    worker = GIOPServerWorkerReactive(giop_version,
                                              protocol,
                                              connection)

	# Multi-threaded.
        else:
	    from GIOPServerWorkerThreaded import GIOPServerWorkerThreaded
	    worker = GIOPServerWorkerThreaded(giop_version,
                                              protocol,
                                              connection)

	return worker


class GIOPServerWorker:
    """  Abstract base class for GIOPServer workers. """

    def send(self, message):
	""" Send a message. """

	pass

    def close_connection(self):
	""" Close down the server.

	Currently, Fnorb does not close down servers, so this is not used.

	"""
	pass

#############################################################################
