#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999, 1999, 2000
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
#
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
#
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /cvsroot/fnorb/fnorb/examples/misc/client.py,v $
# Version:      @(#)$RCSfile: client.py,v $ $Revision: 1.17 $
#
#############################################################################
""" Client of the ExampleIF interface. """


# Standard/built-in modules.
import sys

# Fnorb modules.
from Fnorb.orb import CORBA

# Stubs generated by 'fnidl'.
import Example


def main(argv):
    """ Do it! """

    print 'Initialising the ORB...'

    # Initialise the ORB.
    orb = CORBA.ORB_init(argv, CORBA.ORB_ID)

    # Read the server's stringified IOR from a file.
    stringified_ior = open('Server.ref', 'r').read()

    # Convert the stringified IOR into an active object reference.
    server = orb.string_to_object(stringified_ior)

    # Make sure that the server is not a 'nil object reference' (represented
    # in Python by the value 'None').
    if server is None:
        raise 'Nil object reference!'

    # Make sure that the object implements the expected interface!
    if not server._is_a('IDL:dstc.edu.au/Example/ExampleIF:1.0'):
        raise 'This is not an "ExampleIF" server!'

    # Call the server!
    print server.hello_world()

    print server.double_it(25)
    print server.double_it_again(25)
    print server.double_it_one_last_time(25)

    point = Example.ExampleIF.Point(20, 50)
    new_point = server.move_by(point, 30, 50)

    print 'New point:', new_point.x, new_point.y

    left = Example.ExampleIF.Tree("Left", [])
    right = Example.ExampleIF.Tree("Right", [])
    root = Example.ExampleIF.Tree("Root", [ left, right ])

    server.take_tree(root)

    server.take_that(Example.ExampleIF.OneOfThese(0, 123))
    server.take_that(Example.ExampleIF.OneOfThese(1, 123.456))
    server.take_that(Example.ExampleIF.OneOfThese(2, "Yowza!"))

    print server.ten_hello_worlds(['1', '2', '3', '4', '5',
                                   '6', '7', '8', '9', '10'])
    print server.lots_of_hello_worlds(30)

    print "Next color:", server.next_color(Example.ExampleIF.red)
    print "Next color:", server.next_color(Example.ExampleIF.green)
    print "Next color:", server.next_color(Example.ExampleIF.blue)

    try:
        server.get_beer()

    except Example.ExampleIF.DOH, ex:
        print 'Got user exception:', ex.message

    try:
        server.get_peanuts()

    except CORBA.SystemException, ex:
        print 'Got system exception:', ex

    sprite = server.create_sprite('first')
    print sprite.get_name()

    width = server._get_width()
    print 'Width:', width
    server._set_width(width+10)
    width = server._get_width()
    print 'Width:', width

    print 'Quality:', server._get_quality()

    sprite = server.create_sprite('first')
    print sprite.get_name()

    inner_struct = Example.ExampleIF.OuterStruct.InnerStruct(1, 3)
    outer_struct = Example.ExampleIF.OuterStruct(42, inner_struct)
    server.take_nested_struct(outer_struct)

    inner_union = Example.ExampleIF.OuterStructWithUnion.InnerUnion(1, 7)
    outer_struct_with_union = \
        Example.ExampleIF.OuterStructWithUnion(42, inner_union)
    server.take_nested_struct_with_union(outer_struct_with_union)
    
    inner_struct = Example.ExampleIF.OuterUnionWithStruct.InnerStruct(1, 3)
    outer_union_with_struct = \
        Example.ExampleIF.OuterUnionWithStruct(0, inner_struct)
    server.take_nested_union_with_struct(outer_union_with_struct)

    inner_union = Example.ExampleIF.OuterUnion.InnerUnion(1, 7)
    outer_union = Example.ExampleIF.OuterUnion(0, inner_union)
    server.take_nested_union(outer_union)

    print 'Close down the server!'
    server.quit()

    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv))

#############################################################################
