
#include "bdl.h"

static BDL_Record moonrecords[] = {

     {
          2455197.4,
          {2.4229,-0.01595,390.9993,1.51238,0.004405,0.8081}, /*cmx*/
          {4.337874,2.6853,1.9331,4.2391}, /*cfx*/
          {0.9883,-0.0043,158.1821,0.64227,0.002914,0.3402}, /*cmy*/
          {4.360994,3.2983,2.167,4.2648}, /*cfy*/
          {0.4441,0.04,421.7442,1.63957,0.003985,0.8368}, /*cmz*/
          {5.912224,4.3401,3.3421,5.8165} /*cfz*/
     },
     {
          2455227.4,
          {1.9155,-0.03445,387.3688,1.68709,0.002546,0.8101}, /*cmx*/
          {3.948414,2.2957,0.7136,3.936}, /*cfx*/
          {0.8536,-0.01349,167.0989,0.71785,0.002451,0.3604}, /*cmy*/
          {3.981757,2.7998,1.2102,3.9783}, /*cfy*/
          {1.5979,0.03047,421.6877,1.79084,0.003987,0.8593}, /*cmz*/
          {5.524391,3.9558,2.4124,5.5717} /*cfz*/
     },
     {
          2455257.4,
          {0.9669,-0.04505,384.1499,1.69636,0.003757,0.8099}, /*cmx*/
          {3.551737,1.9218,5.8473,3.6867}, /*cfx*/
          {0.4887,-0.02002,174.3919,0.72709,0.002688,0.3741}, /*cmy*/
          {3.59718,2.3066,0.193,3.7404}, /*cfy*/
          {2.3771,0.00986,421.7105,1.8032,0.003743,0.8463}, /*cmz*/
          {5.130474,3.5504,1.4016,5.3411} /*cfz*/
     },
     {
          2455287.4,
          {-0.2437,-0.04088,382.0081,1.55209,0.004536,0.7804}, /*cmx*/
          {3.158935,1.5454,5.1381,3.4507}, /*cfx*/
          {-0.0461,-0.0196,179.2637,0.65984,0.002758,0.3685}, /*cmy*/
          {3.217469,1.8157,5.6857,3.516}, /*cfy*/
          {2.6251,-0.01734,421.592,1.69763,0.005546,0.8366}, /*cmz*/
          {4.740815,3.163,0.4826,5.0866} /*cfz*/
     },
     {
          2455317.4,
          {-1.4004,-0.02452,381.0289,1.31469,0.006345,0.7598}, /*cmx*/
          {2.780428,1.1687,4.3872,3.2263}, /*cfx*/
          {-0.5976,-0.01267,181.6627,0.54486,0.003009,0.3641}, /*cmy*/
          {2.852385,1.3213,4.7187,3.3061}, /*cfy*/
          {2.1795,-0.03495,421.4999,1.42309,0.007334,0.8518}, /*cmz*/
          {4.364625,2.7989,6.2153,4.7906} /*cfz*/
     },
     {
          2455347.4,
          {-2.1582,-0.00712,380.7788,0.95849,0.009317,0.7866}, /*cmx*/
          {2.425966,0.8308,3.9494,3.006}, /*cfx*/
          {-0.9846,-0.00473,182.1034,0.38095,0.0042,0.3777}, /*cmy*/
          {2.511003,0.8794,4.0329,3.0968}, /*cfy*/
          {1.1918,-0.0391,421.5807,0.98959,0.008766,0.8642}, /*cmz*/
          {4.012162,2.4317,5.636,4.5463} /*cfz*/
     },
     {
          2455377.4,
          {-2.3233,0.00264,380.8995,0.43135,0.011035,0.8166}, /*cmx*/
          {2.106298,0.5594,3.6921,2.8642}, /*cfx*/
          {-1.1035,-0.0002,181.7023,0.14475,0.004847,0.3925}, /*cmy*/
          {2.202851,0.5403,3.6904,2.9611}, /*cfy*/
          {0.0025,-0.03311,421.5918,0.42946,0.011079,0.8615}, /*cmz*/
          {3.694629,2.0508,5.1769,4.3646} /*cfz*/
     },
     {
          2455407.4,
          {-2.066,0.00868,380.9659,0.22887,0.009203,0.8195}, /*cmx*/
          {1.831929,3.3611,3.4936,2.7713}, /*cfx*/
          {-1.0265,0.00273,181.5997,0.14279,0.003774,0.3944}, /*cmy*/
          {1.936466,3.3805,3.5553,2.8669}, /*cfy*/
          {-1.0104,-0.02698,421.405,0.26292,0.010104,0.8242}, /*cmz*/
          {3.42175,5.0334,4.973,4.2561} /*cfz*/
     },
     {
          2455437.4,
          {-1.6094,0.01478,380.7766,0.79234,0.002152,0.7694}, /*cmx*/
          {1.605202,3.1855,3.6076,2.6736}, /*cfx*/
          {-0.8478,0.00615,182.1193,0.37162,0.000886,0.3713}, /*cmy*/
          {1.711971,3.2241,4.434,2.7745}, /*cfy*/
          {-1.7303,-0.02173,421.3302,0.88886,0.002047,0.835}, /*cmz*/
          {3.195216,4.7615,5.2463,4.1895} /*cfz*/
     },
     {
          2455467.4,
          {-1.0962,0.02441,380.6101,0.87737,0.007063,0.7489}, /*cmx*/
          {1.406014,2.9837,6.0754,2.5586}, /*cfx*/
          {-0.6234,0.01135,182.4307,0.37516,0.003517,0.3614}, /*cmy*/
          {1.508537,3.1079,6.1446,2.6611}, /*cfy*/
          {-2.2235,-0.01547,421.4676,0.99925,0.009183,0.8727}, /*cmz*/
          {2.995306,4.5785,1.4152,4.0957} /*cfz*/
     },
     {
          2455497.4,
          {-0.4009,0.03043,380.6589,0.38677,0.011369,0.7649}, /*cmx*/
          {1.192241,2.7234,5.8632,2.4191}, /*cfx*/
          {-0.2953,0.01465,182.0515,0.13255,0.005017,0.3673}, /*cmy*/
          {1.28685,2.9494,6.0353,2.517}, /*cfy*/
          {-2.5554,-0.00293,421.6294,0.43206,0.013396,0.9169}, /*cmz*/
          {2.780549,4.4131,1.2808,3.964} /*cfz*/
     },
     {
          2455527.4,
          {0.5128,0.02932,380.6878,0.33082,0.010661,0.7897}, /*cmx*/
          {0.929501,5.6901,5.5269,2.2758}, /*cfx*/
          {0.1457,0.0146,181.8277,0.18777,0.004527,0.3805}, /*cmy*/
          {1.017491,5.8175,5.625,2.3637}, /*cfy*/
          {-2.6156,0.01419,421.5947,0.40485,0.010743,0.907}, /*cmz*/
          {2.517071,0.9183,0.936,3.7711} /*cfz*/
     },
     {
          2455557.4,
          {1.5041,0.01947,380.5449,0.96037,0.007558,0.7712}, /*cmx*/
          {0.612302,5.3257,5.1045,2.0465}, /*cfx*/
          {0.6385,0.01028,182.1168,0.45622,0.003335,0.3717}, /*cmy*/
          {0.698308,5.4518,4.9656,2.1344}, /*cfy*/
          {-2.1672,0.02876,421.4995,1.09615,0.007198,0.871}, /*cmz*/
          {2.199405,0.6447,0.2675,3.5539} /*cfz*/
     },
     {
          2455587.4,
          {2.2055,0.00749,380.5645,1.39393,0.004361,0.74}, /*cmx*/
          {0.253263,4.9795,4.39,1.7446}, /*cfx*/
          {1.0078,0.00454,182.0301,0.63529,0.002563,0.3531}, /*cmy*/
          {0.342498,5.0289,3.9093,1.8425}, /*cfy*/
          {-1.1902,0.03735,421.5114,1.52831,0.005293,0.8522}, /*cmz*/
          {1.840621,0.2761,5.7893,3.3061} /*cfz*/
     },
     {
          2455617.4,
          {2.387,-0.00725,381.4165,1.61353,0.003392,0.7658}, /*cmx*/
          {6.152039,4.6191,3.3327,1.4056}, /*cfx*/
          {1.1317,-0.0027,180.412,0.71475,0.002951,0.354}, /*cmy*/
          {6.248851,4.5612,2.9226,1.5095}, /*cfy*/
          {0.1057,0.03831,421.4881,1.77602,0.003546,0.8473}, /*cmz*/
          {1.457591,6.162,4.7869,3.0702} /*cfz*/
     },
     {
          2455647.4,
          {2.0156,-0.0241,383.4768,1.67219,0.002975,0.7971}, /*cmx*/
          {5.75707,4.2343,2.3699,1.1294}, /*cfx*/
          {0.9847,-0.01036,176.5054,0.7191,0.00297,0.3532}, /*cmy*/
          {5.864775,4.0444,2.1498,1.2435}, /*cfy*/
          {1.3404,0.03156,421.2823,1.85799,0.004505,0.8729}, /*cmz*/
          {1.063787,5.7763,3.6422,2.8295} /*cfz*/
     },
     {
          2455677.4,
          {1.1889,-0.03825,386.5179,1.63584,0.00401,0.804}, /*cmx*/
          {5.36317,3.8498,1.2232,0.9051}, /*cfx*/
          {0.6294,-0.01601,170.1043,0.68423,0.003045,0.3398}, /*cmy*/
          {5.484476,3.5142,1.2529,1.0331}, /*cfy*/
          {2.2781,0.01224,421.1338,1.75484,0.005408,0.875}, /*cmz*/
          {0.670082,5.3932,3.0431,2.5663} /*cfz*/
     },
     {
          2455707.4,
          {0.0554,-0.03984,390.0921,1.46966,0.006314,0.7859}, /*cmx*/
          {4.979312,3.4904,0.6079,0.6574}, /*cfx*/
          {0.1601,-0.01583,161.7372,0.5975,0.003372,0.3124}, /*cmy*/
          {5.11653,3.0004,0.4744,0.8031}, /*cfy*/
          {2.6736,-0.01152,421.1813,1.52729,0.005489,0.8583}, /*cmz*/
          {0.286489,4.9953,2.2579,2.3075} /*cfz*/
     },
     {
          2455737.4,
          {-1.1655,-0.0259,393.7478,1.14527,0.008086,0.7959}, /*cmx*/
          {4.61486,3.1449,0.1241,0.4403}, /*cfx*/
          {-0.3133,-0.01004,152.7705,0.45629,0.003514,0.2997}, /*cmy*/
          {4.769425,2.4903,5.9953,0.5945}, /*cfy*/
          {2.4185,-0.02937,421.1595,1.20794,0.008117,0.8274}, /*cmz*/
          {6.205662,4.6167,1.5303,2.029} /*cfz*/
     },
     {
          2455767.4,
          {-2.0931,-0.00765,396.6506,0.67949,0.010274,0.8484}, /*cmx*/
          {4.280315,2.8099,5.9425,0.2706}, /*cfx*/
          {-0.6615,-0.00377,145.1919,0.26901,0.004199,0.3067}, /*cmy*/
          {4.451704,1.977,5.3011,0.425}, /*cfy*/
          {1.5795,-0.0327,421.0242,0.7201,0.011121,0.8075}, /*cmz*/
          {5.871022,4.303,1.166,1.815} /*cfz*/
     },
     {
          2455797.4,
          {-2.5213,0.00585,397.8971,0.07204,0.011313,0.8665}, /*cmx*/
          {3.986495,2.7979,5.6863,0.1629}, /*cfx*/
          {-0.8491,-8e-05,141.3429,0.03735,0.004387,0.3107}, /*cmy*/
          {4.170327,0.6221,4.9696,0.3281}, /*cfy*/
          {0.5063,-0.0286,420.9856,0.04078,0.011259,0.8238}, /*cmz*/
          {5.577073,4.4578,0.9238,1.6936} /*cfz*/
     },
     {
          2455827.4,
          {-2.4571,0.01133,397.2324,0.60967,0.006582,0.8494}, /*cmx*/
          {3.740343,5.3388,5.7096,0.0611}, /*cfx*/
          {-0.9006,0.0012,142.9707,0.26156,0.002205,0.312}, /*cmy*/
          {3.926973,4.7739,5.051,0.2319}, /*cfy*/
          {-0.4566,-0.02471,421.0544,0.68898,0.005698,0.8287}, /*cmz*/
          {5.331745,0.623,0.7627,1.6393} /*cfz*/
     },
     {
          2455857.4,
          {-2.1476,0.01749,395.0842,0.97863,0.004843,0.7981}, /*cmx*/
          {3.533473,5.173,1.6487,6.2326}, /*cfx*/
          {-0.8804,0.00415,149.1047,0.3986,0.002271,0.3072}, /*cmy*/
          {3.711658,4.5695,1.2317,0.1242}, /*cfy*/
          {-1.2166,-0.02347,421.1227,1.04197,0.004565,0.8475}, /*cmz*/
          {5.126123,0.4391,3.5421,1.5542} /*cfz*/
     },
     {
          2455887.4,
          {-1.6762,0.0269,392.704,0.69072,0.011849,0.7986}, /*cmx*/
          {3.33094,4.9969,1.8069,6.1262}, /*cfx*/
          {-0.7725,0.00939,155.5211,0.26448,0.004993,0.3221}, /*cmy*/
          {3.49512,4.3491,1.35,0.0007}, /*cfy*/
          {-1.8626,-0.0189,421.0998,0.70588,0.011663,0.8483}, /*cmz*/
          {4.923887,0.2278,3.3867,1.3887} /*cfz*/
     },
     {
          2455917.4,
          {-1.0054,0.03781,391.4605,0.03923,0.01171,0.8155}, /*cmx*/
          {3.090423,1.3704,1.584,5.9976}, /*cfx*/
          {-0.542,0.01504,158.3519,0.06563,0.00478,0.3337}, /*cmy*/
          {3.243011,1.9663,1.0645,6.1419}, /*cfy*/
          {-2.4424,-0.00539,421.0796,0.06338,0.0123,0.8697}, /*cmz*/
          {4.682607,3.4761,3.0448,1.2101} /*cfz*/
     },
     {
          2455947.4,
          {-0.016,0.03899,392.0197,0.7539,0.008451,0.826}, /*cmx*/
          {2.794573,1.3267,1.1072,5.8279}, /*cfx*/
          {-0.1522,0.01564,156.5334,0.33476,0.003623,0.3307}, /*cmy*/
          {2.9425,0.9772,0.3647,5.968}, /*cfy*/
          {-2.7292,0.01347,421.1575,0.81257,0.009482,0.8727}, /*cmz*/
          {4.385841,2.8381,2.6055,1.02} /*cfz*/
     },
     {
          2455977.4,
          {1.1392,0.02971,394.4781,1.24699,0.006176,0.8177}, /*cmx*/
          {2.45191,0.9891,0.4479,5.5495}, /*cfx*/
          {0.2999,0.01107,150.2824,0.52107,0.003227,0.304}, /*cmy*/
          {2.602978,0.4811,5.7557,5.7018}, /*cfy*/
          {-2.4766,0.03039,421.1657,1.3739,0.005659,0.86}, /*cmz*/
          {4.042431,2.4773,1.9319,0.8276} /*cfz*/
     },
     {
          2456007.4,
          {2.1105,0.01357,398.448,1.54523,0.004075,0.8164}, /*cmx*/
          {2.079574,0.6028,6.0319,5.2304}, /*cfx*/
          {0.6465,0.00389,139.8609,0.63231,0.003007,0.2718}, /*cmy*/
          {2.241387,6.2288,4.8583,5.4047}, /*cfy*/
          {-1.5827,0.03933,421.0978,1.69391,0.004397,0.8567}, /*cmz*/
          {3.668419,2.1104,0.7906,0.5536} /*cfz*/
     },
     {
          2456037.4,
          {2.5585,-0.00404,403.1741,1.70797,0.003212,0.8396}, /*cmx*/
          {1.692622,0.2153,4.7377,4.921}, /*cfx*/
          {0.7604,-0.00216,125.6268,0.68823,0.003226,0.241}, /*cmy*/
          {1.873447,5.6837,3.9774,5.124}, /*cfy*/
          {-0.3354,0.04359,421.1029,1.79213,0.004705,0.8757}, /*cmz*/
          {3.278925,1.7205,6.2832,0.2583} /*cfz*/
     },
     {
          2456067.4,
          {2.3693,-0.02282,408.0877,1.70522,0.004753,0.8282}, /*cmx*/
          {1.302085,6.1178,3.8705,4.657}, /*cfx*/
          {0.6548,-0.00609,108.4502,0.69041,0.003223,0.1967}, /*cmy*/
          {1.512459,5.1265,3.256,4.9171}, /*cfy*/
          {0.9449,0.03948,421.1772,1.75787,0.004103,0.9201}, /*cmz*/
          {2.886155,1.3116,5.4295,0.0015} /*cfz*/
     },
     {
          2456097.4,
          {1.6549,-0.03959,412.6998,1.5523,0.005206,0.8234}, /*cmx*/
          {0.917792,5.7211,3.196,4.4345}, /*cfx*/
          {0.4388,-0.00736,89.8066,0.65658,0.002755,0.1553}, /*cmy*/
          {1.172524,4.5692,2.395,4.7533}, /*cfy*/
          {1.9638,0.02488,421.131,1.62088,0.00528,0.9063}, /*cmz*/
          {2.499565,0.9214,4.5076,6.0525} /*cfz*/
     },
     {
          2456127.4,
          {0.5418,-0.04458,416.3103,1.3046,0.006972,0.8319}, /*cmx*/
          {0.548815,5.3201,2.3578,4.2061}, /*cfx*/
          {0.2133,-0.00601,71.7369,0.57887,0.003049,0.1215}, /*cmy*/
          {0.868764,4.0542,1.3646,4.5832}, /*cfy*/
          {2.5615,0.00011,421.0857,1.33109,0.007023,0.8598}, /*cmz*/
          {2.127785,0.5576,3.9114,5.826} /*cfz*/
     },
     {
          2456157.4,
          {-0.684,-0.03642,418.4419,0.91446,0.010363,0.8641}, /*cmx*/
          {0.204251,4.9771,1.8834,4.0051}, /*cfx*/
          {0.0476,-0.00411,56.8647,0.42341,0.00409,0.1039}, /*cmy*/
          {0.611473,3.5996,0.5994,4.4423}, /*cfy*/
          {2.5706,-0.02044,421.1487,0.89095,0.009077,0.8376}, /*cmz*/
          {1.781135,0.2037,3.3791,5.5758} /*cfz*/
     },
     {
          2456187.4,
          {-1.7271,-0.02098,419.4107,0.3082,0.011702,0.9082}, /*cmx*/
          {6.177991,4.7785,1.6149,3.8145}, /*cfx*/
          {-0.0644,-0.0034,48.0421,0.17581,0.004921,0.0988}, /*cmy*/
          {0.384144,3.1848,0.1367,4.2934}, /*cfy*/
          {1.999,-0.0277,421.1842,0.30074,0.011311,0.8403}, /*cmz*/
          {1.471071,6.1416,3.0004,5.4242} /*cfz*/
     },
     {
          2456217.4,
          {-2.315,-0.01058,419.5219,0.43994,0.00815,0.9016}, /*cmx*/
          {5.914363,1.1692,1.47,3.6868}, /*cfx*/
          {-0.1653,-0.00412,47.3304,0.14135,0.003908,0.1063}, /*cmy*/
          {0.132193,6.2394,6.2322,4.1513}, /*cfy*/
          {1.1141,-0.02468,421.1748,0.41745,0.009187,0.8549}, /*cmz*/
          {1.207713,2.7729,2.8444,5.3576} /*cfz*/
     },
     {
          2456247.4,
          {-2.5069,-0.00373,418.6985,0.97961,0.001944,0.8705}, /*cmx*/
          {5.696106,1.0372,3.4148,3.6136}, /*cfx*/
          {-0.2885,-0.0043,54.8848,0.39337,0.000422,0.1244}, /*cmy*/
          {6.124294,5.9978,1.0953,3.9968}, /*cfy*/
          {0.2215,-0.02277,421.2759,0.98594,0.001282,0.8321}, /*cmz*/
          {0.990177,2.5646,4.5046,5.3066} /*cfz*/
     },
     {
          2456277.4,
          {-2.4214,0.00384,416.9681,0.89446,0.010186,0.8355}, /*cmx*/
          {5.496924,0.8604,3.9547,3.553}, /*cfx*/
          {-0.3994,-0.00241,66.6152,0.39183,0.003859,0.1427}, /*cmy*/
          {5.841254,5.816,2.7575,3.867}, /*cfy*/
          {-0.5456,-0.02697,421.3502,0.93515,0.010647,0.8199}, /*cmz*/
          {0.79228,2.3839,5.4958,5.1685} /*cfz*/
     },
     {
          2456307.4,
          {-2.1336,0.0184,415.4782,0.25723,0.012737,0.8658}, /*cmx*/
          {5.27293,0.5754,3.7139,3.4445}, /*cfx*/
          {-0.4409,0.00188,74.8523,0.1546,0.00518,0.1589}, /*cmy*/
          {5.568427,5.3712,2.57,3.7056}, /*cfy*/
          {-1.3046,-0.02859,421.3118,0.26599,0.013124,0.8213}, /*cmz*/
          {0.569507,2.2087,5.318,4.9646} /*cfz*/
     },
     {
          2456337.4,
          {-1.5152,0.03289,415.5192,0.48978,0.010976,0.8957}, /*cmx*/
          {4.997609,3.5331,3.3376,3.2552}, /*cfx*/
          {-0.3625,0.00529,74.8245,0.17277,0.004443,0.1543}, /*cmy*/
          {5.281413,2.6297,2.1071,3.5169}, /*cfy*/
          {-2.0512,-0.01866,421.1721,0.54433,0.009949,0.8499}, /*cmz*/
          {0.294324,5.0189,4.9161,4.7764} /*cfz*/
     },
     {
          2456367.4,
          {-0.5039,0.03956,417.049,1.09333,0.007254,0.9064}, /*cmx*/
          {4.673131,3.1548,2.8735,3.0324}, /*cfx*/
          {-0.1905,0.00525,66.3642,0.42238,0.00335,0.1287}, /*cmy*/
          {4.981203,2.0259,1.3207,3.3293}, /*cfy*/
          {-2.6079,0.00301,421.1399,1.15474,0.00681,0.8409}, /*cmz*/
          {6.251546,4.7085,4.2172,4.5672} /*cfz*/
     },
     {
          2456397.4,
          {0.7705,0.03315,419.0994,1.49653,0.004041,0.8717}, /*cmx*/
          {4.314129,2.7847,1.9244,2.7633}, /*cfx*/
          {-0.0167,0.00168,51.3584,0.59351,0.003071,0.0874}, /*cmy*/
          {4.69955,1.5193,0.3671,3.1734}, /*cfy*/
          {-2.5952,0.0228,421.2576,1.51634,0.005121,0.8171}, /*cmz*/
          {5.890237,4.3338,3.4655,4.3247} /*cfz*/
     },
     {
          2456427.4,
          {1.9252,0.01909,420.8941,1.67482,0.004246,0.8181}, /*cmx*/
          {3.935335,2.3959,0.8251,2.4886}, /*cfx*/
          {0.0533,-0.00221,32.7447,0.6935,0.003003,0.0493}, /*cmy*/
          {4.533287,0.9955,5.7944,3.2872}, /*cfy*/
          {-1.8988,0.03469,421.3662,1.70835,0.003577,0.8417}, /*cmz*/
          {5.509294,3.9378,2.5135,4.0262} /*cfz*/
     },
     {
          2456457.4,
          {2.5621,0.00264,421.8192,1.68903,0.003999,0.8095}, /*cmx*/
          {3.549239,1.9754,0.0582,2.2099}, /*cfx*/
          {0.0022,-0.00381,17.8746,0.73484,0.002845,0.0395}, /*cmy*/
          {4.900172,0.472,4.936,4.0822}, /*cfy*/
          {-0.6834,0.03727,421.36,1.74507,0.004054,0.8885}, /*cmz*/
          {5.120609,3.5528,1.4662,3.7696} /*cfz*/
     },
     {
          2456487.4,
          {2.5709,-0.01618,421.4023,1.61429,0.004556,0.822}, /*cmx*/
          {3.165645,1.5544,5.2779,1.9672}, /*cfx*/
          {-0.0955,-0.002,25.5485,0.71613,0.002733,0.0697}, /*cmy*/
          {5.613465,6.2471,4.0332,4.527}, /*cfy*/
          {0.6268,0.03525,421.4699,1.62012,0.004374,0.9246}, /*cmz*/
          {4.734088,3.1638,0.7331,3.5469} /*cfz*/
     },
     {
          2456517.4,
          {2.0016,-0.03292,419.6991,1.40717,0.00683,0.8421}, /*cmx*/
          {2.792751,1.1703,4.609,1.7657}, /*cfx*/
          {-0.1387,0.00216,43.9963,0.63615,0.003008,0.1056}, /*cmy*/
          {5.582838,5.768,3.0753,4.5692}, /*cfy*/
          {1.7451,0.0242,421.6479,1.38958,0.005398,0.8977}, /*cmz*/
          {4.359374,2.7663,6.0929,3.311} /*cfz*/
     },
     {
          2456547.4,
          {1.0432,-0.04095,417.5642,1.02504,0.008666,0.8344}, /*cmx*/
          {2.43999,0.8093,4.0972,1.5293}, /*cfx*/
          {-0.0692,0.00577,60.5613,0.48536,0.003924,0.1341}, /*cmy*/
          {5.348812,5.3465,2.2978,4.4431}, /*cfy*/
          {2.4815,0.0051,421.6526,1.04856,0.009032,0.8639}, /*cmz*/
          {4.005992,2.3994,5.5158,3.0902} /*cfz*/
     },
     {
          2456577.4,
          {-0.141,-0.03322,415.8362,0.4819,0.010553,0.8379}, /*cmx*/
          {2.119007,0.4529,3.6266,1.3035}, /*cfx*/
          {0.1071,0.0054,71.5951,0.25321,0.004902,0.1513}, /*cmy*/
          {5.078496,5.0412,1.7902,4.2718}, /*cfy*/
          {2.7199,-0.01439,421.5633,0.50488,0.011646,0.8566}, /*cmz*/
          {3.684644,2.1027,5.233,2.9122} /*cfz*/
     },
     {
          2456607.4,
          {-1.2199,-0.01965,415.234,0.20273,0.010029,0.8658}, /*cmx*/
          {1.841465,3.3854,3.3594,1.131}, /*cfx*/
          {0.2916,0.00199,74.8434,0.06578,0.004753,0.1537}, /*cmy*/
          {4.817644,0.8774,1.5829,4.1184}, /*cfy*/
          {2.4639,-0.02459,421.6742,0.22083,0.010101,0.8693}, /*cmz*/
          {3.407118,4.9783,5.0144,2.836} /*cfz*/
     },
     {
          2456637.4,
          {-1.9991,-0.00895,416.1448,0.84811,0.002827,0.8641}, /*cmx*/
          {1.611279,3.1097,3.5541,1.0725}, /*cfx*/
          {0.3841,-0.00152,69.3115,0.35166,0.002094,0.1311}, /*cmy*/
          {4.577319,1.2032,1.8912,4.0315}, /*cfy*/
          {1.8569,-0.02571,421.8433,0.87076,0.002295,0.8982}, /*cmz*/
          {3.177864,4.7824,4.8523,2.775} /*cfz*/
     },
     {
          2456667.4,
          {-2.4212,-0.00522,417.9585,1.01311,0.00841,0.857}, /*cmx*/
          {1.410593,2.9228,5.9839,1.0323}, /*cfx*/
          {0.3569,-0.00249,57.5022,0.45045,0.002933,0.1029}, /*cmy*/
          {4.338801,1.1365,4.0353,3.9301}, /*cfy*/
          {1.1182,-0.02714,421.8586,0.98855,0.007391,0.8802}, /*cmz*/
          {2.97839,4.5946,1.4879,2.6691} /*cfz*/
     },
     {
          2456697.4,
          {-2.6064,0.00203,419.3518,0.51821,0.013473,0.8511}, /*cmx*/
          {1.198343,2.7264,5.8874,0.9138}, /*cfx*/
          {0.2826,-0.00183,46.6067,0.26692,0.005192,0.0883}, /*cmy*/
          {4.073637,1.0011,4.1125,3.756}, /*cfy*/
          {0.2798,-0.03197,421.653,0.47109,0.011739,0.8609}, /*cmz*/
          {2.76666,4.3648,1.226,2.4861} /*cfz*/
     },
     {
          2456727.4,
          {-2.5405,0.01725,419.7306,0.26476,0.011335,0.8871}, /*cmx*/
          {0.9407,5.5969,5.61,0.7099}, /*cfx*/
          {0.2302,-0.00164,43.2805,0.04874,0.004819,0.0972}, /*cmy*/
          {3.799009,3.9084,3.7967,3.6036}, /*cfy*/
          {-0.6372,-0.03574,421.5491,0.27838,0.010895,0.839}, /*cmz*/
          {2.508749,0.9947,0.8475,2.2816} /*cfz*/
     },
     {
          2456757.4,
          {-2.1134,0.03686,419.0727,0.934,0.007153,0.9077}, /*cmx*/
          {0.632045,5.307,5.0402,0.4838}, /*cfx*/
          {0.2002,-0.00364,49.0202,0.33476,0.003483,0.1218}, /*cmy*/
          {3.53557,3.5516,3.163,3.4749}, /*cfy*/
          {-1.612,-0.02733,421.5948,0.92293,0.007916,0.8389}, /*cmz*/
          {2.199713,0.6319,0.4161,2.0913} /*cfz*/
     },
     {
          2456787.4,
          {-1.1982,0.04695,417.4079,1.35462,0.004808,0.8888}, /*cmx*/
          {0.284424,4.9422,4.2013,0.2768}, /*cfx*/
          {0.1247,-0.00705,61.9442,0.53135,0.002654,0.1508}, /*cmy*/
          {3.253312,3.1271,2.2211,3.3334}, /*cfy*/
          {-2.3903,-0.00763,421.5954,1.38047,0.004358,0.8318}, /*cmz*/
          {1.851945,0.2769,6.0044,1.864} /*cfz*/
     },
     {
          2456817.4,
          {0.1036,0.04162,414.5533,1.57718,0.003204,0.8355}, /*cmx*/
          {6.196255,4.5371,3.3047,0.0171}, /*cfx*/
          {-0.0697,-0.00929,79.0789,0.6382,0.002501,0.1767}, /*cmy*/
          {2.935874,2.6528,1.279,3.0976}, /*cfy*/
          {-2.6896,0.01655,421.5332,1.62028,0.003635,0.8382}, /*cmz*/
          {1.479963,6.2023,4.8243,1.6047} /*cfz*/
     },
     {
          2456847.4,
          {1.3841,0.02696,410.5148,1.66554,0.003222,0.8022}, /*cmx*/
          {5.813601,4.1365,1.9836,6.0198}, /*cfx*/
          {-0.3648,-0.00885,97.5591,0.67917,0.002322,0.2054}, /*cmy*/
          {2.59223,2.1521,0.3605,2.8254}, /*cfy*/
          {-2.2666,0.03276,421.6523,1.6676,0.00362,0.8635}, /*cmz*/
          {1.096668,5.8159,4.0966,1.3016} /*cfz*/
     },
     {
          2456877.4,
          {2.2333,0.01047,405.7678,1.59785,0.004537,0.8223}, /*cmx*/
          {5.429264,3.7529,1.2324,5.7682}, /*cfx*/
          {-0.6514,-0.00569,115.1389,0.66347,0.002442,0.2463}, /*cmy*/
          {2.236385,1.6623,5.7149,2.5872}, /*cfy*/
          {-1.2653,0.04149,421.8441,1.61452,0.003161,0.8722}, /*cmz*/
          {0.712922,5.4105,2.9698,1.0117} /*cfz*/
     },
     {
          2456907.4,
          {2.4413,-0.00461,401.1329,1.39849,0.005483,0.8187}, /*cmx*/
          {5.052753,3.3703,0.556,5.576}, /*cfx*/
          {-0.7974,-0.0006,130.2728,0.58565,0.002628,0.2767}, /*cmy*/
          {1.881687,1.1921,4.8552,2.411}, /*cfy*/
          {-0.0131,0.04269,421.8564,1.46519,0.005911,0.8809}, /*cmz*/
          {0.337648,5.0302,2.0664,0.7674} /*cfz*/
     },
     {
          2456937.4,
          {2.1362,-0.02113,397.1332,1.09319,0.007951,0.7947}, /*cmx*/
          {4.694004,3.0035,6.2131,5.3956}, /*cfx*/
          {-0.7645,0.00646,141.895,0.45226,0.003295,0.2924}, /*cmy*/
          {1.540125,0.7521,3.9642,2.2454}, /*cfy*/
          {1.161,0.03605,421.7938,1.13655,0.008698,0.8616}, /*cmz*/
          {6.263124,4.6848,1.6224,0.571} /*cfz*/
     },
     {
          2456967.4,
          {1.4485,-0.03189,394.2785,0.62659,0.010784,0.7718}, /*cmx*/
          {4.364088,2.6949,5.8577,5.1633}, /*cfx*/
          {-0.5529,0.01171,149.364,0.25639,0.004592,0.2968}, /*cmy*/
          {1.223493,0.4358,3.4261,2.0265}, /*cfy*/
          {2.053,0.02064,421.8724,0.62062,0.010812,0.8543}, /*cmz*/
          {5.934572,4.336,1.193,0.436} /*cfz*/
     },
     {
          2456997.4,
          {0.5674,-0.03327,393.1719,0.03354,0.010471,0.7801}, /*cmx*/
          {4.075166,5.0893,5.6284,4.9731}, /*cfx*/
          {-0.2277,0.01262,152.3158,0.05455,0.004652,0.3006}, /*cmy*/
          {0.943647,2.0046,3.2486,1.8457}, /*cfy*/
          {2.5504,0.00344,421.8944,0.05223,0.011206,0.882}, /*cmz*/
          {5.647434,1.5554,0.8601,0.3048} /*cfz*/
     },
     {
          2457027.4,
          {-0.365,-0.02529,394.051,0.70207,0.004336,0.7983}, /*cmx*/
          {3.834708,5.3155,5.5037,4.8602}, /*cfx*/
          {0.1306,0.00897,150.4291,0.31477,0.002319,0.2968}, /*cmy*/
          {0.707186,2.7886,3.5671,1.7378}, /*cfy*/
          {2.6024,-0.00701,421.8045,0.70327,0.005881,0.9308}, /*cmz*/
          {5.408005,0.7178,0.7312,0.2077} /*cfz*/
     },
     {
          2457057.4,
          {-1.1792,-0.01858,396.4071,0.98272,0.005451,0.787}, /*cmx*/
          {3.630742,5.1256,1.9814,4.8259}, /*cfx*/
          {0.4216,0.00567,144.1916,0.4324,0.002654,0.2767}, /*cmy*/
          {0.501706,2.7712,5.5027,1.7034}, /*cfy*/
          {2.3267,-0.01272,421.7314,0.99148,0.004559,0.951}, /*cmz*/
          {5.203623,0.4904,3.4629,0.1069} /*cfz*/
     },
     {
          2457087.4,
          {-1.8348,-0.01477,398.8828,0.63135,0.011106,0.7848}, /*cmx*/
          {3.425736,4.9012,1.8096,4.7243}, /*cfx*/
          {0.624,0.00435,136.7781,0.28617,0.004799,0.2635}, /*cmy*/
          {0.29131,2.7396,5.743,1.5914}, /*cfy*/
          {1.7839,-0.01882,421.7525,0.64545,0.011423,0.9026}, /*cmz*/
          {4.99766,0.275,3.3921,6.2818} /*cfz*/
     },
     {
          2457117.4,
          {-2.2788,-0.01039,400.056,0.0638,0.010954,0.7927}, /*cmx*/
          {3.181643,2.0115,1.4733,4.5222}, /*cfx*/
          {0.7531,0.00403,133.028,0.03594,0.004551,0.2659}, /*cmy*/
          {0.042341,4.2283,5.4993,1.383}, /*cfy*/
          {1.0282,-0.02946,421.7855,0.07666,0.011214,0.8645}, /*cmz*/
          {4.753087,3.133,3.1687,6.125} /*cfz*/
     },
     {
          2457147.4,
          {-2.45,0.0027,399.4489,0.70487,0.008221,0.838}, /*cmx*/
          {2.88674,1.2541,1.0443,4.2776}, /*cfx*/
          {0.8251,0.00084,135.2284,0.28434,0.003421,0.2933}, /*cmy*/
          {6.030186,5.1269,4.9388,1.1417}, /*cfy*/
          {0.0381,-0.03678,421.7021,0.77824,0.00737,0.8514}, /*cmz*/
          {4.458247,2.8908,2.7228,5.9216} /*cfz*/
     },
     {
          2457177.4,
          {-2.244,0.02217,397.1556,1.18126,0.004653,0.8426}, /*cmx*/
          {2.549955,0.8827,0.4968,4.0363}, /*cfx*/
          {0.8044,-0.00604,142.1964,0.48161,0.002389,0.3141}, /*cmy*/
          {5.698035,4.7673,4.1653,0.9082}, /*cfy*/
          {-1.0628,-0.03369,421.5872,1.25338,0.004953,0.8777}, /*cmz*/
          {4.12151,2.5715,1.8965,5.7013} /*cfz*/
     },
     {
          2457207.4,
          {-1.5529,0.03735,393.6752,1.4679,0.00265,0.8082}, /*cmx*/
          {2.185239,0.5246,5.5232,3.7989}, /*cfx*/
          {0.6107,-0.01333,151.4732,0.60931,0.001835,0.3228}, /*cmy*/
          {5.34163,4.3359,2.9988,0.6796}, /*cfy*/
          {-2.089,-0.01527,421.6086,1.50365,0.00416,0.8704}, /*cmz*/
          {3.757489,2.1994,1.1693,5.4444} /*cfz*/
     },
     {
          2457237.4,
          {-0.4338,0.03904,389.8614,1.55735,0.00327,0.7731}, /*cmx*/
          {1.805166,0.1592,4.5259,3.53}, /*cfx*/
          {0.2078,-0.01625,160.9227,0.65922,0.002277,0.3285}, /*cmy*/
          {4.97207,3.8853,2.0251,0.4213}, /*cfy*/
          {-2.6594,0.0071,421.673,1.62257,0.002743,0.8294}, /*cmz*/
          {3.379498,1.804,0.2522,5.1673} /*cfz*/
     },
     {
          2457267.4,
          {0.8467,0.02779,386.4549,1.51723,0.003348,0.7633}, /*cmx*/
          {1.421123,6.0602,3.6696,3.3023}, /*cfx*/
          {-0.3308,-0.01318,169.0972,0.64282,0.002292,0.342}, /*cmy*/
          {4.599763,3.4087,1.2646,0.2056}, /*cfy*/
          {-2.5242,0.02433,421.6331,1.62532,0.0037,0.8093}, /*cmz*/
          {2.997899,1.4244,5.2926,4.8431} /*cfz*/
     },
     {
          2457297.4,
          {1.8413,0.01361,383.7145,1.39104,0.005216,0.7875}, /*cmx*/
          {1.042889,5.6924,2.8019,3.1073}, /*cfx*/
          {-0.8039,-0.0076,175.1242,0.58479,0.002586,0.3665}, /*cmy*/
          {4.233842,2.9332,0.2498,0.0203}, /*cfy*/
          {-1.714,0.03225,421.6283,1.47072,0.005389,0.8187}, /*cmz*/
          {2.62191,1.0545,4.6076,4.5772} /*cfz*/
     },
     {
          2457327.4,
          {2.3307,-0.00104,381.8315,1.12057,0.00783,0.7892}, /*cmx*/
          {0.679953,5.3688,2.3723,2.9168}, /*cfx*/
          {-1.0756,-0.00094,178.824,0.46494,0.003682,0.3745}, /*cmy*/
          {3.8832,2.5194,5.8411,6.1254}, /*cfy*/
          {-0.5641,0.03556,421.7156,1.17881,0.007612,0.8447}, /*cmz*/
          {2.261707,0.6786,3.932,4.4046} /*cfz*/
     },
     {
          2457357.4,
          {2.2904,-0.01379,381.0025,0.66452,0.009376,0.7871}, /*cmx*/
          {0.34373,5.073,1.998,2.7246}, /*cfx*/
          {-1.1031,0.00519,180.6951,0.25785,0.004274,0.3756}, /*cmy*/
          {3.558341,2.1851,5.3584,5.9414}, /*cfy*/
          {0.5808,0.03358,421.6833,0.73544,0.011026,0.831}, /*cmz*/
          {1.928332,0.325,3.4581,4.2586} /*cfz*/
     },
     {
          2457387.4,
          {1.894,-0.02471,380.8683,0.06573,0.009534,0.7618}, /*cmx*/
          {0.04717,4.864,1.6354,2.537}, /*cfx*/
          {-0.956,0.01081,181.4042,0.02127,0.004072,0.3628}, /*cmy*/
          {3.270845,4.0057,4.997,5.7627}, /*cfy*/
          {1.5607,0.02318,421.5465,0.10018,0.012089,0.8329}, /*cmz*/
          {1.633509,0.0645,3.2162,4.1189} /*cfz*/
     },
     {
          2457417.4,
          {1.2688,-0.02874,380.9636,0.55527,0.005802,0.7434}, /*cmx*/
          {6.081524,1.3523,1.4301,2.4379}, /*cfx*/
          {-0.6879,0.01345,181.3539,0.27901,0.002228,0.355}, /*cmy*/
          {3.026944,4.6433,5.0077,5.6711}, /*cfy*/
          {2.2702,0.00802,421.4725,0.61171,0.006853,0.872}, /*cmz*/
          {1.38518,2.9344,3.1396,3.9687} /*cfz*/
     },
     {
          2457447.4,
          {0.5431,-0.02879,381.3518,0.90883,0.002868,0.7515}, /*cmx*/
          {5.872155,1.1236,3.9726,2.3853}, /*cfx*/
          {-0.3552,0.014,180.3957,0.4083,0.001882,0.3566}, /*cmy*/
          {2.81687,4.5119,0.8849,5.6173}, /*cfy*/
          {2.6913,-0.00578,421.4686,1.00137,0.003662,0.9136}, /*cmz*/
          {1.175751,2.7443,5.6012,3.8898} /*cfz*/
     },
     {
          2457477.4,
          {-0.2621,-0.0262,382.1719,0.7246,0.010064,0.7741}, /*cmx*/
          {5.669968,0.8967,4.0056,2.3206}, /*cfx*/
          {0.0287,0.0128,178.5583,0.29878,0.004581,0.363}, /*cmy*/
          {2.609113,4.3901,1.1251,5.5439}, /*cfy*/
          {2.7524,-0.01383,421.4666,0.74906,0.010429,0.9153}, /*cmz*/
          {0.972834,2.5448,5.6747,3.8115} /*cfz*/
     },
     {
          2457507.4,
          {-1.0979,-0.02332,382.905,0.12693,0.011318,0.7975}, /*cmx*/
          {5.436432,0.6247,3.8118,2.1321}, /*cfx*/
          {0.4307,0.01156,177.1315,0.03166,0.004947,0.3695}, /*cmy*/
          {2.368796,4.6737,0.9769,5.3456}, /*cfy*/
          {2.4624,-0.02158,421.4191,0.07471,0.0108,0.8794}, /*cmz*/
          {0.737926,1.9984,5.3876,3.6953} /*cfz*/
     },
     {
          2457537.4,
          {-1.837,-0.01683,382.8418,0.53657,0.008178,0.7963}, /*cmx*/
          {5.153944,3.5317,3.5047,1.8743}, /*cfx*/
          {0.7975,0.00902,177.3356,0.26003,0.003582,0.3702}, /*cmy*/
          {2.082192,0.6479,0.6026,5.0866}, /*cfy*/
          {1.7869,-0.0312,421.4547,0.61098,0.008562,0.8807}, /*cmz*/
          {0.454077,5.2285,4.9138,3.4736} /*cfz*/
     },
     {
          2457567.4,
          {-2.3181,-0.00367,382.0065,1.04161,0.004706,0.802}, /*cmx*/
          {4.826968,3.2342,2.8451,1.5994}, /*cfx*/
          {1.0608,0.00341,178.938,0.47935,0.002169,0.377}, /*cmy*/
          {1.755379,0.3397,5.9728,4.8146}, /*cfy*/
          {0.8329,-0.04295,421.5366,1.11386,0.006207,0.9063}, /*cmz*/
          {0.126876,4.8562,4.382,3.2235} /*cfz*/
     },
     {
          2457597.4,
          {-2.3903,0.016,381.1192,1.32575,0.003603,0.7816}, /*cmx*/
          {4.468482,2.8943,1.9758,1.3368}, /*cfx*/
          {1.1443,-0.00583,180.8537,0.59901,0.002299,0.3701}, /*cmy*/
          {1.40107,6.2253,4.9118,4.5615}, /*cfy*/
          {-0.3376,-0.04458,421.5286,1.44556,0.003776,0.9325}, /*cmz*/
          {6.052791,4.4815,3.6454,2.9945} /*cfz*/
     },
     {
          2457627.4,
          {-1.9697,0.03462,380.77,1.46285,0.00251,0.7705}, /*cmx*/
          {4.092429,2.5202,1.1547,1.1066}, /*cfx*/
          {0.9923,-0.01515,181.9123,0.64734,0.002243,0.3659}, /*cmy*/
          {1.032403,5.7593,4.1186,4.3378}, /*cfy*/
          {-1.5217,-0.03107,421.4194,1.6049,0.003321,0.8957}, /*cmz*/
          {5.678111,4.1128,2.5394,2.7371} /*cfz*/
     },
     {
          2457657.4,
          {-1.0211,0.04126,381.1335,1.50346,0.002959,0.7683}, /*cmx*/
          {3.710127,2.1528,6.0238,0.8508}, /*cfx*/
          {0.5772,-0.01887,181.2529,0.65231,0.002401,0.3615}, /*cmy*/
          {0.659986,5.278,3.095,4.0869}, /*cfy*/
          {-2.4198,-0.00587,421.4112,1.59914,0.003436,0.8474}, /*cmz*/
          {5.297136,3.73,1.6957,2.4508} /*cfz*/
     },
     {
          2457687.4,
          {0.1938,0.03666,382.2729,1.40281,0.005162,0.7801}, /*cmx*/
          {3.331239,1.8113,5.3887,0.5969}, /*cfx*/
          {0.0244,-0.01689,178.662,0.59202,0.003052,0.3605}, /*cmy*/
          {0.292832,4.8161,2.351,3.8424}, /*cfy*/
          {-2.6748,0.01576,421.4426,1.48739,0.004311,0.8404}, /*cmz*/
          {4.920258,3.3377,0.6137,2.1527} /*cfz*/
     },
     {
          2457717.4,
          {1.3159,0.02561,384.1807,1.13633,0.006558,0.8192}, /*cmx*/
          {2.966072,1.4698,4.8508,0.3563}, /*cfx*/
          {-0.4901,-0.01185,174.7341,0.4605,0.003128,0.3663}, /*cmy*/
          {6.223596,4.3418,1.6324,3.6077}, /*cfy*/
          {-2.1978,0.02737,421.3512,1.24813,0.007638,0.824}, /*cmz*/
          {4.557071,2.9734,6.224,1.9482} /*cfz*/
     },
     {
          2457747.4,
          {2.0127,0.0151,386.1809,0.73045,0.008584,0.8222}, /*cmx*/
          {2.62638,1.1267,4.2899,0.1781}, /*cfx*/
          {-0.8158,-0.00762,170.6169,0.2809,0.003667,0.3566}, /*cmy*/
          {5.896536,3.8461,0.8476,3.4394}, /*cfy*/
          {-1.2651,0.03188,421.2705,0.8078,0.010365,0.8047}, /*cmz*/
          {4.218422,2.6534,5.8465,1.8108} /*cfz*/
     },
     {
          2457777.4,
          {2.2717,0.00282,387.3647,0.17615,0.009994,0.7968}, /*cmx*/
          {2.323793,0.8768,3.9664,0.0703}, /*cfx*/
          {-0.9635,-0.00313,167.9314,0.05235,0.004109,0.3439}, /*cmy*/
          {5.604511,3.0118,0.4385,3.3411}, /*cfy*/
          {-0.2192,0.03289,421.333,0.17814,0.010908,0.7767}, /*cmz*/
          {3.916604,2.329,5.5105,1.6804} /*cfz*/
     },
     {
          2457807.4,
          {2.1799,-0.00841,387.2442,0.46869,0.006646,0.7567}, /*cmx*/
          {2.066745,3.6487,3.8898,6.2652}, /*cfx*/
          {-0.9804,0.00132,168.1411,0.22424,0.002449,0.3333}, /*cmy*/
          {5.352882,0.2781,0.424,3.2661}, /*cfy*/
          {0.6909,0.03139,421.2994,0.5053,0.00735,0.8029}, /*cmz*/
          {3.660737,5.2623,5.2781,1.552} /*cfz*/
     },
     {
          2457837.4,
          {1.8562,-0.01779,386.0375,0.91012,0.002686,0.7752}, /*cmx*/
          {1.850969,3.4707,6.0927,6.2049}, /*cfx*/
          {-0.9057,0.00619,171.1236,0.39365,0.001544,0.3528}, /*cmy*/
          {5.135119,0.0629,2.8295,3.2009}, /*cfy*/
          {1.4699,0.02459,421.1635,0.94356,0.001306,0.84}, /*cmz*/
          {3.44573,5.0265,1.3056,1.4245} /*cfz*/
     },
     {
          2457867.4,
          {1.3133,-0.02311,384.5553,0.80694,0.009693,0.8194}, /*cmx*/
          {1.649567,3.2951,0.1252,6.1074}, /*cfx*/
          {-0.7129,0.00983,174.6729,0.32514,0.004421,0.3783}, /*cmy*/
          {4.92573,6.1959,3.094,3.0884}, /*cfy*/
          {2.1103,0.01451,421.0634,0.83081,0.00924,0.8551}, /*cmz*/
          {3.243771,4.7968,1.5891,1.3437} /*cfz*/
     },
     {
          2457897.4,
          {0.5402,-0.02623,383.5975,0.24096,0.010786,0.8326}, /*cmx*/
          {1.4239,3.1484,6.2371,5.9842}, /*cfx*/
          {-0.3829,0.0122,176.691,0.06669,0.004653,0.3866}, /*cmy*/
          {4.69079,5.8787,2.945,2.9536}, /*cfy*/
          {2.5801,0.00146,421.1628,0.25056,0.01188,0.8403}, /*cmz*/
          {3.016748,4.4821,1.3704,1.2225} /*cfz*/
     },
     {
          2457927.4,
          {-0.4031,-0.02708,383.4485,0.41415,0.008353,0.8003}, /*cmx*/
          {1.151494,5.8984,5.8495,5.777}, /*cfx*/
          {0.0545,0.01276,176.7116,0.21676,0.00346,0.3685}, /*cmy*/
          {4.412199,2.7074,2.4404,2.7469}, /*cfy*/
          {2.6539,-0.00999,421.3046,0.45396,0.009861,0.8341}, /*cmz*/
          {2.743347,1.1986,1.057,1.0458} /*cfz*/
     },
     {
          2457957.4,
          {-1.3457,-0.02489,384.2839,0.91994,0.006118,0.7624}, /*cmx*/
          {0.833247,5.6008,5.3271,5.5186}, /*cfx*/
          {0.5039,0.01139,174.8542,0.42311,0.002683,0.3441}, /*cmy*/
          {4.092679,2.303,1.6515,2.5037}, /*cfy*/
          {2.2516,-0.02281,421.3071,1.03606,0.00632,0.8849}, /*cmz*/
          {2.424628,0.8621,0.5213,0.7983} /*cfz*/
     },
     {
          2457987.4,
          {-2.0742,-0.01545,386.1257,1.26608,0.003998,0.7797}, /*cmx*/
          {0.481522,5.2486,4.7745,5.239}, /*cfx*/
          {0.8509,0.00658,170.865,0.55577,0.002194,0.3379}, /*cmy*/
          {3.74468,1.8458,0.7469,2.2373}, /*cfy*/
          {1.3855,-0.03468,421.2397,1.39939,0.004643,0.9303}, /*cmz*/
          {2.072075,0.5173,5.9558,0.5519} /*cfz*/
     },
     {
          2458017.4,
          {-2.4587,0.00447,388.9244,1.4822,0.002326,0.7991}, /*cmx*/
          {0.109486,4.8938,3.5994,4.9823}, /*cfx*/
          {1.0252,-0.0021,164.35,0.62953,0.002391,0.3272}, /*cmy*/
          {3.380989,1.3669,5.95,1.994}, /*cfy*/
          {0.2338,-0.04185,421.3171,1.56769,0.003665,0.9466}, /*cmz*/
          {1.699172,0.1303,5.268,0.2997} /*cfz*/
     },
     {
          2458047.4,
          {-2.3191,0.02627,392.6059,1.53979,0.003395,0.8025}, /*cmx*/
          {6.011746,4.5409,2.4776,4.7389}, /*cfx*/
          {0.9641,-0.01033,155.2344,0.63466,0.002884,0.3064}, /*cmy*/
          {3.012667,0.8659,5.2084,1.7625}, /*cfy*/
          {-1.0383,-0.0341,421.3706,1.62654,0.002396,0.9041}, /*cmz*/
          {1.318032,6.012,3.9861,0.0186} /*cfz*/
     },
     {
          2458077.4,
          {-1.5977,0.03895,396.9674,1.44975,0.004185,0.7961}, /*cmx*/
          {5.632745,4.1683,1.6716,4.4396}, /*cfx*/
          {0.6852,-0.01376,144.0592,0.59085,0.002693,0.2742}, /*cmy*/
          {2.650302,0.3289,4.4349,1.4789}, /*cfy*/
          {-2.1268,-0.01402,421.2528,1.55877,0.004786,0.8554}, /*cmz*/
          {0.938578,5.6356,2.8621,6.0424} /*cfz*/
     },
     {
          2458107.4,
          {-0.3951,0.03526,401.2421,1.23757,0.006193,0.82}, /*cmx*/
          {5.266094,3.7928,0.8287,4.1708}, /*cfx*/
          {0.2748,-0.01113,131.9928,0.50889,0.002883,0.2516}, /*cmy*/
          {2.304092,6.0794,3.4323,1.2195}, /*cfy*/
          {-2.6835,0.00749,421.1743,1.3018,0.006954,0.8277}, /*cmz*/
          {0.570779,5.2786,2.3397,5.8175} /*cfz*/
     },
     {
          2458137.4,
          {0.8519,0.02494,404.6835,0.85863,0.009068,0.8624}, /*cmx*/
          {4.922347,3.4555,0.3359,3.975}, /*cfx*/
          {-0.1027,-0.00739,121.0731,0.36283,0.003725,0.2408}, /*cmy*/
          {1.982862,5.5817,2.6547,1.0274}, /*cfy*/
          {-2.5671,0.02115,421.2773,0.881,0.009013,0.8144}, /*cmz*/
          {0.226294,4.9102,1.7834,5.6618} /*cfz*/
     },
     {
          2458167.4,
          {1.7903,0.01446,406.7795,0.28321,0.009959,0.8444}, /*cmx*/
          {4.612934,3.1926,0.0173,3.8584}, /*cfx*/
          {-0.374,-0.00526,113.9926,0.14374,0.004189,0.2286}, /*cmy*/
          {1.692571,4.9962,2.1474,0.9323}, /*cfy*/
          {-1.9237,0.02658,421.2499,0.32356,0.011166,0.8349}, /*cmz*/
          {6.200251,4.5289,1.4016,5.5341} /*cfz*/
     },
     {
          2458197.4,
          {2.2838,0.00676,407.1068,0.38691,0.006958,0.8096}, /*cmx*/
          {4.347489,6.0101,6.0627,3.7692}, /*cfx*/
          {-0.5498,-0.00488,113.1131,0.13841,0.003191,0.2286}, /*cmy*/
          {1.43443,2.2318,1.8587,0.8513}, /*cfy*/
          {-1.0974,0.02947,421.086,0.34188,0.009336,0.8287}, /*cmz*/
          {5.935211,1.2304,1.2618,5.408} /*cfz*/
     },
     {
          2458227.4,
          {2.4704,-0.00364,405.5479,0.87661,0.000589,0.7957}, /*cmx*/
          {4.124669,5.8134,2.0245,3.6721}, /*cfx*/
          {-0.6921,-0.00273,118.637,0.337,0.000225,0.2431}, /*cmy*/
          {1.203005,1.8133,1.1844,0.745}, /*cfy*/
          {-0.2515,0.03027,420.9977,0.88563,0.001679,0.8156}, /*cmz*/
          {5.712802,0.9863,2.0456,5.2894} /*cfz*/
     },
     {
          2458257.4,
          {2.4436,-0.01645,402.936,0.86735,0.007993,0.8397}, /*cmx*/
          {3.922067,5.6226,2.4707,3.5919}, /*cfx*/
          {-0.7958,0.00214,127.1768,0.33938,0.002971,0.2745}, /*cmy*/
          {0.982387,1.5878,4.8861,0.6332}, /*cfy*/
          {0.5566,0.03008,421.0893,0.91631,0.00856,0.7886}, /*cmz*/
          {5.510889,0.8036,3.8793,5.1816} /*cfz*/
     },
     {
          2458287.4,
          {2.1563,-0.02914,400.8189,0.37434,0.01097,0.8679}, /*cmx*/
          {3.702511,5.4193,2.2431,3.4916}, /*cfx*/
          {-0.7945,0.00818,133.6311,0.15047,0.004281,0.2908}, /*cmy*/
          {0.745897,1.1617,4.6617,0.5122}, /*cfy*/
          {1.4115,0.02363,421.1507,0.38669,0.011743,0.7999}, /*cmz*/
          {5.291813,0.6227,3.7668,5.0977} /*cfz*/
     },
     {
          2458317.4,
          {1.4831,-0.03614,400.3855,0.28737,0.009836,0.8519}, /*cmx*/
          {3.439745,1.8827,1.9462,3.3593}, /*cfx*/
          {-0.6155,0.0117,135.0318,0.13377,0.003825,0.2823}, /*cmy*/
          {0.473469,4.7855,4.2498,0.3745}, /*cfy*/
          {2.1806,0.01245,421.0965,0.34029,0.009682,0.8281}, /*cmz*/
          {5.02868,3.4701,3.4129,4.9436} /*cfz*/
     },
     {
          2458347.4,
          {0.4352,-0.03726,401.6991,0.87517,0.006831,0.8223}, /*cmx*/
          {3.130399,1.6196,1.5486,3.1208}, /*cfx*/
          {-0.2799,0.01181,130.8744,0.35758,0.002842,0.2578}, /*cmy*/
          {0.163754,4.1523,3.5211,0.1459}, /*cfy*/
          {2.6529,-0.0032,421.066,0.93737,0.007354,0.8609}, /*cmz*/
          {4.717798,3.1783,2.8181,4.7198} /*cfz*/
     },
     {
          2458377.4,
          {-0.739,-0.03501,404.451,1.30026,0.003998,0.8261}, /*cmx*/
          {2.784381,1.2989,0.7628,2.8448}, /*cfx*/
          {0.0872,0.00945,121.5849,0.51847,0.002724,0.2369}, /*cmy*/
          {6.110548,3.6655,2.502,6.1716}, /*cfy*/
          {2.5779,-0.01902,421.2034,1.33672,0.005592,0.8952}, /*cmz*/
          {4.369944,2.8073,2.2473,4.4194} /*cfz*/
     },
     {
          2458407.4,
          {-1.7751,-0.02658,408.2463,1.52858,0.003591,0.8704}, /*cmx*/
          {2.414773,0.9412,6.0157,2.5873}, /*cfx*/
          {0.3606,0.00521,107.8135,0.61356,0.003022,0.2184}, /*cmy*/
          {5.762135,3.1413,1.6897,5.939}, /*cfy*/
          {1.9664,-0.0364,421.3093,1.59519,0.003034,0.9075}, /*cmz*/
          {3.998708,2.4168,1.4294,4.1158} /*cfz*/
     },
     {
          2458437.4,
          {-2.4345,-0.00907,412.4802,1.61248,0.003273,0.875}, /*cmx*/
          {2.034329,0.545,5.0397,2.3533}, /*cfx*/
          {0.4698,0.00024,90.5101,0.66594,0.002955,0.1803}, /*cmy*/
          {5.418895,2.5947,0.8952,5.7662}, /*cfy*/
          {0.9207,-0.04762,421.2731,1.69969,0.003276,0.9154}, /*cmz*/
          {3.615882,2.0383,6.2016,3.8491} /*cfz*/
     },
     {
          2458467.4,
          {-2.609,0.01671,416.2146,1.58197,0.004558,0.8625}, /*cmx*/
          {1.65372,0.1465,3.8722,2.0969}, /*cfx*/
          {0.4339,-0.00352,71.1637,0.67024,0.002824,0.1326}, /*cmy*/
          {5.101996,2.0606,0.0095,5.6143}, /*cfy*/
          {-0.3657,-0.04512,421.2818,1.61573,0.00457,0.8866}, /*cmz*/
          {3.23225,1.6579,5.4058,3.6042} /*cfz*/
     },
     {
          2458497.4,
          {-2.1501,0.03553,418.9509,1.37941,0.006921,0.8598}, /*cmx*/
          {1.28273,6.0542,3.2244,1.793}, /*cfx*/
          {0.3102,-0.00383,52.1332,0.60933,0.00284,0.0881}, /*cmy*/
          {4.842235,1.552,5.3162,5.4818}, /*cfy*/
          {-1.6018,-0.02788,421.4072,1.395,0.006209,0.8628}, /*cmz*/
          {2.858951,1.2636,4.5596,3.3825} /*cfz*/
     },
     {
          2458527.4,
          {-1.164,0.04049,420.6954,0.98627,0.008396,0.8641}, /*cmx*/
          {0.932182,5.6826,2.6476,1.542}, /*cfx*/
          {0.192,-0.00222,36.5577,0.47473,0.003612,0.0614}, /*cmy*/
          {4.680691,1.0871,4.4093,5.4787}, /*cfy*/
          {-2.4323,-0.00724,421.3737,1.04037,0.009572,0.8788}, /*cmz*/
          {2.506906,0.8979,4.0112,3.158} /*cfz*/
     },
     {
          2458557.4,
          {0.0498,0.03295,421.4902,0.45281,0.010163,0.8527}, /*cmx*/
          {0.61385,5.2984,2.1354,1.3591}, /*cfx*/
          {0.1239,-0.00125,27.4141,0.2567,0.004662,0.0518}, /*cmy*/
          {4.608894,0.6914,3.8595,5.524}, /*cfy*/
          {-2.6171,0.00507,421.2408,0.50242,0.011806,0.9055}, /*cmz*/
          {2.187261,0.606,3.7354,3.0048} /*cfz*/
     },
     {
          2458587.4,
          {1.091,0.0248,421.5208,0.18856,0.009597,0.8025}, /*cmx*/
          {0.337391,1.9872,1.8893,1.2557}, /*cfx*/
          {0.0817,-0.00231,25.1171,0.03254,0.004466,0.0537}, /*cmy*/
          {4.443785,3.6265,3.621,5.3898}, /*cfy*/
          {-2.3007,0.01103,421.1794,0.18711,0.01004,0.9068}, /*cmz*/
          {1.910212,3.3899,3.5568,2.9043} /*cfz*/
     },
     {
          2458617.4,
          {1.8046,0.01887,421.1902,0.77951,0.003157,0.7974}, /*cmx*/
          {0.104659,1.6897,2.0228,1.183}, /*cfx*/
          {0.0083,-0.00419,28.6927,0.30991,0.001869,0.065}, /*cmy*/
          {4.052571,3.3609,3.7344,5.0451}, /*cfy*/
          {-1.7351,0.01602,421.2231,0.7903,0.003218,0.8442}, /*cmz*/
          {1.678353,3.2412,3.6142,2.8231} /*cfz*/
     },
     {
          2458647.4,
          {2.2384,0.01346,420.5358,0.95975,0.006773,0.8237}, /*cmx*/
          {6.182788,1.5109,4.5567,1.0903}, /*cfx*/
          {-0.1118,-0.00484,37.8702,0.4125,0.002211,0.0846}, /*cmy*/
          {3.616967,3.2121,6.2633,4.731}, /*cfy*/
          {-1.1178,0.02542,421.2568,0.94047,0.00579,0.8073}, /*cmz*/
          {1.4748,3.0569,6.1193,2.734} /*cfz*/
     },
     {
          2458677.4,
          {2.4871,0.00208,419.6757,0.5487,0.011659,0.8708}, /*cmx*/
          {5.970436,1.3549,4.5033,0.9748}, /*cfx*/
          {-0.2427,-0.00265,47.5707,0.26708,0.00445,0.101}, /*cmy*/
          {3.268316,2.9879,6.2763,4.5094}, /*cfy*/
          {-0.3515,0.03219,421.1981,0.52097,0.010545,0.815}, /*cmz*/
          {1.263301,2.8245,5.9575,2.6203} /*cfz*/
     },
     {
          2458707.4,
          {2.4945,-0.01446,419.1903,0.17218,0.010405,0.867}, /*cmx*/
          {5.718882,4.0433,4.2404,0.8175}, /*cfx*/
          {-0.3158,0.0011,51.3242,0.04494,0.0045,0.0972}, /*cmy*/
          {2.969738,0.9951,5.9377,4.3589}, /*cfy*/
          {0.6052,0.03171,421.1617,0.16717,0.01081,0.8565}, /*cmz*/
          {1.011509,5.8785,5.6252,2.4945} /*cfz*/
     },
     {
          2458737.4,
          {2.0581,-0.02921,419.573,0.83613,0.007211,0.8428}, /*cmx*/
          {5.418559,3.8968,3.6574,0.635}, /*cfx*/
          {-0.285,0.00353,46.8326,0.29019,0.003799,0.078}, /*cmy*/
          {2.692796,5.8328,5.3054,4.2449}, /*cfy*/
          {1.6553,0.02057,421.2077,0.81356,0.008764,0.8518}, /*cmz*/
          {0.710451,5.4433,5.2212,2.2938} /*cfz*/
     },
     {
          2458767.4,
          {1.1139,-0.03679,420.6542,1.29292,0.005673,0.8386}, /*cmx*/
          {5.077439,3.5496,2.8884,0.4027}, /*cfx*/
          {-0.1794,0.00271,35.2597,0.5033,0.003263,0.0511}, /*cmy*/
          {2.476382,5.3333,4.4774,4.2037}, /*cfy*/
          {2.4259,0.00651,421.2392,1.31311,0.005591,0.8206}, /*cmz*/
          {0.368256,5.0865,4.6283,2.0267} /*cfz*/
     },
     {
          2458797.4,
          {-0.1672,-0.03615,421.6268,1.58288,0.004105,0.8604}, /*cmx*/
          {4.709407,3.1465,2.0392,0.1782}, /*cfx*/
          {-0.0952,-0.00056,20.7706,0.65016,0.003056,0.0299}, /*cmy*/
          {2.548789,4.8312,3.5698,4.7253}, /*cfy*/
          {2.64,-0.00915,421.2663,1.61519,0.003984,0.8301}, /*cmz*/
          {6.281278,4.7222,3.5901,1.6912} /*cfz*/
     },
     {
          2458827.4,
          {-1.3908,-0.02941,421.5295,1.72876,0.004189,0.9032}, /*cmx*/
          {4.326942,2.7413,0.7808,6.2219}, /*cfx*/
          {-0.1125,-0.00395,19.5209,0.72725,0.002894,0.0515}, /*cmy*/
          {3.346024,4.3155,2.67,5.6089}, /*cfy*/
          {2.2259,-0.02529,421.4246,1.72285,0.003742,0.8628}, /*cmz*/
          {5.896371,4.3315,2.6255,1.4065} /*cfz*/
     },
     {
          2458857.4,
          {-2.2966,-0.01238,420.1212,1.68231,0.005673,0.9045}, /*cmx*/
          {3.940858,2.3446,0.0368,5.9591}, /*cfx*/
          {-0.2296,-0.00456,37.553,0.73509,0.002789,0.0976}, /*cmy*/
          {3.52959,3.8052,1.7085,5.6606}, /*cfy*/
          {1.326,-0.04005,421.6055,1.7015,0.004126,0.8849}, /*cmz*/
          {5.508772,3.9269,1.4477,1.1755} /*cfz*/
     },
     {
          2458887.4,
          {-2.6696,0.00985,417.8118,1.46798,0.005775,0.8864}, /*cmx*/
          {3.561948,1.9334,5.5791,5.6923}, /*cfx*/
          {-0.3647,-0.00131,58.1985,0.66652,0.002929,0.1389}, /*cmy*/
          {3.324986,3.3211,0.7789,5.51}, /*cfy*/
          {0.1275,-0.04352,421.615,1.53956,0.006747,0.8616}, /*cmz*/
          {5.128828,3.5458,0.6509,0.9294} /*cfz*/
     },
     {
          2458917.4,
          {-2.448,0.02891,415.0154,1.14758,0.007722,0.8415}, /*cmx*/
          {3.201209,1.5305,4.7638,5.4188}, /*cfx*/
          {-0.4112,0.00389,75.9858,0.52498,0.003359,0.1654}, /*cmy*/
          {3.039009,2.8734,6.1702,5.2788}, /*cfy*/
          {-1.1586,-0.03032,421.5975,1.19384,0.008986,0.8649}, /*cmz*/
          {4.766978,3.1945,0.1716,0.6926} /*cfz*/
     },
     {
          2458947.4,
          {-1.6717,0.03401,412.4394,0.67944,0.010558,0.8043}, /*cmx*/
          {2.869209,1.1953,4.348,5.2155}, /*cfx*/
          {-0.3015,0.00687,88.4627,0.32162,0.00442,0.1783}, /*cmy*/
          {2.744436,2.5184,5.5439,5.0891}, /*cfy*/
          {-2.1786,-0.00999,421.6118,0.68244,0.010671,0.9127}, /*cmz*/
          {4.434599,2.8563,6.0122,0.4899} /*cfz*/
     },
     {
          2458977.4,
          {-0.6397,0.03009,411.131,0.03912,0.010487,0.8048}, /*cmx*/
          {2.576558,1.2754,4.1242,5.0858}, /*cfx*/
          {-0.0826,0.0067,94.061,0.06675,0.004812,0.1835}, /*cmy*/
          {2.469232,2.84,5.2913,4.9662}, /*cfy*/
          {-2.7047,0.00597,421.4983,0.04817,0.011083,0.9336}, /*cmz*/
          {4.142618,2.6962,5.7289,0.3767} /*cfz*/
     },
     {
          2459007.4,
          {0.3339,0.02482,411.7041,0.63665,0.00522,0.8118}, /*cmx*/
          {2.329814,3.8077,4.0099,5.0225}, /*cfx*/
          {0.1332,0.0048,91.8838,0.25212,0.003056,0.1725}, /*cmy*/
          {2.224977,4.8305,5.3986,4.8975}, /*cfy*/
          {-2.697,0.01195,421.3875,0.61283,0.006628,0.9104}, /*cmz*/
          {3.896502,5.4169,5.7076,0.2832} /*cfz*/
     },
     {
          2459037.4,
          {1.1162,0.02316,413.725,0.97596,0.003838,0.8319}, /*cmx*/
          {2.120209,3.6334,0.4279,4.924}, /*cfx*/
          {0.2726,0.00298,82.8466,0.42718,0.001619,0.1545}, /*cmy*/
          {2.004058,4.8194,1.0015,4.7887}, /*cfy*/
          {-2.3922,0.01719,421.4385,0.97875,0.003978,0.8487}, /*cmz*/
          {3.687029,5.2241,1.5922,0.1905} /*cfz*/
     },
     {
          2459067.4,
          {1.7612,0.01981,415.7705,0.71289,0.010257,0.821}, /*cmx*/
          {1.915721,3.4349,0.3307,4.767}, /*cfx*/
          {0.3399,0.00171,71.6406,0.35117,0.00442,0.1338}, /*cmy*/
          {1.77835,4.7444,1.5391,4.613}, /*cfy*/
          {-1.8993,0.02654,421.5764,0.74305,0.011195,0.8497}, /*cmz*/
          {3.482615,5.0331,1.8325,0.0789} /*cfz*/
     },
     {
          2459097.4,
          {2.3198,0.00846,416.7336,0.04886,0.011396,0.8251}, /*cmx*/
          {1.67832,2.642,6.2777,4.5957}, /*cfx*/
          {0.3834,0.00074,65.1355,0.0775,0.004988,0.1308}, /*cmy*/
          {1.52577,4.6826,1.3513,4.4395}, /*cfy*/
          {-1.2195,0.03964,421.5856,0.05744,0.012205,0.8733}, /*cmz*/
          {3.245438,4.7356,1.6458,6.2376} /*cfz*/
     },
     {
          2459127.4,
          {2.627,-0.01029,416.4225,0.66137,0.009657,0.8159}, /*cmx*/
          {1.390298,6.0829,5.8319,4.4206}, /*cfx*/
          {0.4265,-0.00088,67.1965,0.23222,0.004054,0.1436}, /*cmy*/
          {1.246745,1.0316,0.8165,4.2875}, /*cfy*/
          {-0.216,0.04338,421.4877,0.68252,0.009344,0.8905}, /*cmz*/
          {2.957427,1.4122,1.2249,6.0878} /*cfz*/
     },
     {
          2459157.4,
          {2.4518,-0.02884,414.6924,1.22663,0.006411,0.8173}, /*cmx*/
          {1.056346,5.7031,5.2416,4.2445}, /*cfx*/
          {0.4432,-0.00417,77.3238,0.47806,0.003108,0.1705}, /*cmy*/
          {0.941464,0.6524,6.2667,4.1555}, /*cfy*/
          {0.9968,0.03432,421.4676,1.23525,0.006886,0.8612}, /*cmz*/
          {2.62283,1.0784,0.559,5.8436} /*cfz*/
     },
     {
          2459187.4,
          {1.6425,-0.03855,411.4159,1.59502,0.004279,0.8194}, /*cmx*/
          {0.689342,5.3246,4.1442,3.9856}, /*cfx*/
          {0.3458,-0.00822,92.8087,0.64156,0.002642,0.2058}, /*cmy*/
          {0.606972,0.1908,5.2084,3.9349}, /*cfy*/
          {2.0818,0.01558,421.6206,1.57639,0.005017,0.8408}, /*cmz*/
          {2.255595,0.6928,6.1503,5.5434} /*cfz*/
     },
     {
          2455197.4,
          {-8.6942,0.06463,622.1359,2.31108,0.006624,2.8863}, /*cmx*/
          {1.299683,5.9257,5.141,1.3701}, /*cfx*/
          {-3.5189,0.01885,251.2913,0.9895,0.004425,1.2056}, /*cmy*/
          {1.299933,0.2804,5.3826,1.3754}, /*cfy*/
          {-2.0298,-0.14409,671.1626,2.44852,0.007569,3.1417}, /*cmz*/
          {2.870478,1.3001,0.5336,2.9619} /*cfz*/
     },
     {
          2455227.4,
          {-6.7866,0.12247,615.9987,2.61856,0.004896,2.9556}, /*cmx*/
          {3.994989,2.3489,0.7639,0.9706}, /*cfx*/
          {-2.9791,0.04853,266.0121,1.12685,0.004226,1.3125}, /*cmy*/
          {4.006667,2.8659,1.1818,0.9902}, /*cfy*/
          {-6.4551,-0.09134,670.8892,2.77832,0.006104,3.1714}, /*cmz*/
          {5.567307,4.0,2.5325,2.5523} /*cfz*/
     },
     {
          2455257.4,
          {-3.0506,0.14344,610.6628,2.63098,0.005015,2.9313}, /*cmx*/
          {0.397236,5.0457,2.9408,0.562}, /*cfx*/
          {-1.4989,0.06382,278.2958,1.12599,0.004256,1.364}, /*cmy*/
          {0.421981,5.4435,3.504,0.5951}, /*cfy*/
          {-9.3108,-0.01889,671.1075,2.82647,0.005938,3.2287}, /*cmz*/
          {1.972432,0.3967,4.6527,2.1316} /*cfz*/
     },
     {
          2455287.4,
          {1.4105,0.12976,606.7499,2.49189,0.007277,2.8985}, /*cmx*/
          {3.085324,1.4727,5.0713,0.1536}, /*cfx*/
          {0.4953,0.06191,286.5465,1.06045,0.004445,1.3838}, /*cmy*/
          {3.124399,1.7454,5.6171,0.2009}, /*cfy*/
          {-9.8649,0.05757,670.9921,2.69576,0.008442,3.2325}, /*cmz*/
          {4.663175,3.0866,0.4692,1.738} /*cfz*/
     },
     {
          2455317.4,
          {5.3433,0.08993,604.9979,2.10697,0.009129,2.9272}, /*cmx*/
          {5.784793,4.1915,1.2871,6.0613}, /*cfx*/
          {2.3779,0.04542,290.9329,0.87551,0.004615,1.41}, /*cmy*/
          {5.838485,4.35,1.6286,6.1207}, /*cfy*/
          {-7.9848,0.11096,670.8205,2.28959,0.010858,3.1934}, /*cmz*/
          {1.082707,5.7885,2.9044,1.3679} /*cfz*/
     },
     {
          2455347.4,
          {7.9519,0.03077,604.317,1.5543,0.013793,2.8901}, /*cmx*/
          {2.22418,0.6525,3.8449,5.7228}, /*cfx*/
          {3.6998,0.01851,291.9705,0.61861,0.006285,1.3977}, /*cmy*/
          {2.292044,0.7161,3.949,5.7977}, /*cfy*/
          {-4.5397,0.1378,670.8681,1.67506,0.015172,3.2202}, /*cmz*/
          {3.808103,2.2176,5.3755,0.9931} /*cfz*/
     },
     {
          2455377.4,
          {8.7866,-0.02258,604.8478,0.73909,0.017317,2.8054}, /*cmx*/
          {4.981433,3.3988,0.2553,5.3992}, /*cfx*/
          {4.2113,-0.00618,291.8129,0.25056,0.007516,1.3545}, /*cmy*/
          {5.061528,3.3867,0.2537,5.4868}, /*cfy*/
          {-0.4555,0.1267,670.65,0.74524,0.017929,3.1927}, /*cmz*/
          {0.283719,4.9942,1.873,0.6916} /*cfz*/
     },
     {
          2455407.4,
          {8.1125,-0.05787,604.7219,0.33813,0.014857,2.76}, /*cmx*/
          {1.500318,3.0508,3.1371,5.1282}, /*cfx*/
          {4.0273,-0.02365,291.587,0.21982,0.006014,1.3299}, /*cmy*/
          {1.58874,3.049,3.2022,5.2202}, /*cfy*/
          {3.2611,0.09467,670.3655,0.36455,0.017166,3.1035}, /*cmz*/
          {3.088419,4.5852,4.7207,0.4608} /*cfz*/
     },
     {
          2455437.4,
          {6.4422,-0.07442,604.4122,1.29188,0.003722,2.7442}, /*cmx*/
          {4.352397,5.9308,0.0592,4.9441}, /*cfx*/
          {3.3498,-0.03395,292.286,0.60703,0.001498,1.3287}, /*cmy*/
          {4.442939,5.9673,0.8231,5.0321}, /*cfy*/
          {6.0925,0.05885,670.8551,1.42636,0.003469,3.0423}, /*cmz*/
          {5.940106,1.2395,1.6451,0.2445} /*cfz*/
     },
     {
          2455467.4,
          {4.2314,-0.08607,604.3722,1.50081,0.011616,2.722}, /*cmx*/
          {0.95118,2.5294,5.6312,4.7341}, /*cfx*/
          {2.3416,-0.04158,292.6111,0.6483,0.005803,1.3144}, /*cmy*/
          {1.03686,2.6422,5.6771,4.8145}, /*cfy*/
          {7.9287,0.03269,670.4566,1.60575,0.011937,2.9889}, /*cmz*/
          {2.538424,4.1074,0.8834,0.0458} /*cfz*/
     },
     {
          2455497.4,
          {1.5603,-0.10161,604.4417,0.76137,0.018734,2.6415}, /*cmx*/
          {3.821737,5.3724,2.2201,4.5182}, /*cfx*/
          {1.0518,-0.04983,291.8318,0.2826,0.008327,1.276}, /*cmy*/
          {3.899103,5.5591,2.3841,4.5933}, /*cfy*/
          {8.9566,-0.00047,670.9574,0.81749,0.020912,2.9758}, /*cmz*/
          {5.407049,0.7204,3.8635,6.0964} /*cfz*/
     },
     {
          2455527.4,
          {-1.5796,-0.10943,604.6554,0.39863,0.01636,2.638}, /*cmx*/
          {0.362252,5.0701,5.0294,4.2406}, /*cfx*/
          {-0.4866,-0.05461,291.6027,0.23391,0.006994,1.272}, /*cmy*/
          {0.432983,5.2171,5.1453,4.3122}, /*cfy*/
          {8.9028,-0.04846,670.5478,0.44111,0.018151,2.9644}, /*cmz*/
          {1.946052,0.4375,0.296,5.8401} /*cfz*/
     },
     {
          2455557.4,
          {-4.8559,-0.08717,604.262,1.38593,0.012243,2.6989}, /*cmx*/
          {3.131508,1.5689,1.3043,3.9198}, /*cfx*/
          {-2.1276,-0.04498,292.2353,0.65784,0.005381,1.3064}, /*cmy*/
          {3.200921,1.6996,1.1689,3.9898}, /*cfy*/
          {7.3222,-0.10617,670.7997,1.54349,0.012802,2.96}, /*cmz*/
          {4.71592,3.1492,2.9147,5.5149} /*cfz*/
     },
     {
          2455587.4,
          {-7.4225,-0.03176,604.1108,2.0973,0.006908,2.7374}, /*cmx*/
          {5.859119,4.3016,3.7144,3.5643}, /*cfx*/
          {-3.4574,-0.01903,292.4454,0.9517,0.004021,1.3213}, /*cmy*/
          {5.932877,4.3487,3.2269,3.6396}, /*cfy*/
          {4.1138,-0.15297,670.71,2.28094,0.008409,2.9704}, /*cmz*/
          {1.160545,5.8763,5.2724,5.135} /*cfz*/
     },
     {
          2455617.4,
          {-8.3911,0.04275,605.4989,2.46171,0.004805,2.699}, /*cmx*/
          {2.276519,0.7294,5.9782,3.1804}, /*cfx*/
          {-4.029,0.01703,290.3667,1.08536,0.00412,1.28}, /*cmy*/
          {2.359279,0.6627,5.4299,3.2705}, /*cfy*/
          {-0.4551,-0.15235,670.5679,2.70633,0.006383,3.0452}, /*cmz*/
          {3.862993,2.2951,1.0196,4.762} /*cfz*/
     },
     {
          2455647.4,
          {-7.1557,0.1049,608.1609,2.61478,0.004905,2.8027}, /*cmx*/
          {4.964772,3.446,1.5634,2.7864}, /*cfx*/
          {-3.5327,0.0458,284.3025,1.12169,0.004747,1.2831}, /*cmy*/
          {5.060233,3.2489,1.3446,2.8902}, /*cfy*/
          {-5.1089,-0.11021,670.5862,2.85433,0.006056,3.0827}, /*cmz*/
          {0.26974,4.9803,3.0582,4.3865} /*cfz*/
     },
     {
          2455677.4,
          {-3.9224,0.13725,612.9685,2.54776,0.005342,2.9159}, /*cmx*/
          {1.368894,6.1461,3.7387,2.3953}, /*cfx*/
          {-2.1191,0.05781,274.4936,1.06701,0.00442,1.2709}, /*cmy*/
          {1.479786,5.8017,3.6233,2.5114}, /*cfy*/
          {-8.5291,-0.03967,670.444,2.74447,0.007087,3.1073}, /*cmz*/
          {2.957845,1.3879,5.4325,3.9866} /*cfz*/
     },
     {
          2455707.4,
          {0.3485,0.13678,618.8301,2.29594,0.007579,2.9164}, /*cmx*/
          {4.064282,2.5722,6.0215,2.013}, /*cfx*/
          {-0.319,0.05366,261.5047,0.9322,0.004385,1.1947}, /*cmy*/
          {4.192564,2.0778,5.867,2.1501}, /*cfy*/
          {-9.7226,0.03297,670.3342,2.50358,0.010078,3.2}, /*cmz*/
          {5.654867,4.073,1.2381,3.5893} /*cfz*/
     },
     {
          2455737.4,
          {4.5473,0.10335,624.4341,1.86814,0.012361,2.9576}, /*cmx*/
          {0.49514,5.3148,2.333,1.6505}, /*cfx*/
          {1.324,0.03926,247.3908,0.73314,0.005351,1.1358}, /*cmy*/
          {0.642484,4.6775,1.8985,1.8113}, /*cfy*/
          {-8.589,0.09012,670.4172,1.97492,0.012778,3.199}, /*cmz*/
          {2.085704,0.493,3.7206,3.2408} /*cfz*/
     },
     {
          2455767.4,
          {7.5957,0.05469,629.4271,1.15234,0.016608,3.032}, /*cmx*/
          {3.23746,1.766,4.8937,1.3118}, /*cfx*/
          {2.4775,0.02313,235.6258,0.44108,0.006763,1.1109}, /*cmy*/
          {3.402597,0.9728,4.2497,1.4838}, /*cfy*/
          {-5.7224,0.1181,669.8518,1.17583,0.016865,3.2208}, /*cmz*/
          {4.827791,3.2567,0.1423,2.9272} /*cfz*/
     },
     {
          2455797.4,
          {9.1177,0.00196,631.7566,0.12708,0.01704,3.0411}, /*cmx*/
          {6.019735,4.6438,1.4364,1.0338}, /*cfx*/
          {3.1314,0.00932,229.6206,0.0599,0.006749,1.109}, /*cmy*/
          {6.198042,2.7419,0.6986,1.2128}, /*cfy*/
          {-2.1408,0.11886,669.9325,0.14405,0.018892,3.1937}, /*cmz*/
          {1.328432,5.9857,2.8906,2.6246} /*cfz*/
     },
     {
          2455827.4,
          {9.1337,-0.03518,630.65,0.94357,0.011149,2.9709}, /*cmx*/
          {2.568558,4.219,4.3829,0.7988}, /*cfx*/
          {3.3975,-0.00152,232.2181,0.40419,0.003987,1.1162}, /*cmy*/
          {2.749578,3.623,3.8208,0.9768}, /*cfy*/
          {1.3435,0.09866,669.8326,1.07634,0.00969,3.1562}, /*cmz*/
          {4.159983,5.7226,5.8925,2.3797} /*cfz*/
     },
     {
          2455857.4,
          {8.1695,-0.06415,627.2939,1.59127,0.00644,2.9014}, /*cmx*/
          {5.441272,0.8426,3.8325,0.5825}, /*cfx*/
          {3.395,-0.01645,241.9389,0.63428,0.002986,1.149}, /*cmy*/
          {5.613249,0.2458,3.2547,0.7532}, /*cfy*/
          {4.2845,0.07811,669.8044,1.68351,0.006613,3.1387}, /*cmz*/
          {0.751323,2.3224,5.2422,2.1966} /*cfz*/
     },
     {
          2455887.4,
          {6.2793,-0.08355,622.7833,1.16876,0.017011,2.9113}, /*cmx*/
          {2.038267,3.6981,0.5279,0.3591}, /*cfx*/
          {2.9229,-0.02995,251.8206,0.44186,0.00723,1.1893}, /*cmy*/
          {2.195885,3.1043,0.0273,0.5091}, /*cfy*/
          {6.7302,0.05708,670.2385,1.25426,0.019284,3.0982}, /*cmz*/
          {3.630871,5.2168,2.075,1.9718} /*cfz*/
     },
     {
          2455917.4,
          {3.6399,-0.11116,621.181,0.08511,0.019022,2.8744}, /*cmx*/
          {4.882965,0.4702,3.4128,0.0943}, /*cfx*/
          {1.9669,-0.04485,256.4447,0.04649,0.007617,1.1812}, /*cmy*/
          {5.028657,4.0033,2.9084,0.2333}, /*cfy*/
          {8.5686,0.0261,669.952,0.06374,0.019851,3.0325}, /*cmz*/
          {0.191506,1.231,4.8384,1.6849} /*cfz*/
     },
     {
          2455947.4,
          {0.1747,-0.12669,621.9805,1.02308,0.014523,2.8125}, /*cmx*/
          {1.389983,6.2106,6.0422,6.0799}, /*cfx*/
          {0.5579,-0.05082,253.5544,0.4698,0.005882,1.1301}, /*cmy*/
          {1.531671,5.7946,5.3296,6.2202}, /*cfy*/
          {9.3285,-0.0267,670.3559,1.16009,0.013884,2.99}, /*cmz*/
          {2.981309,1.403,1.3079,1.3548} /*cfz*/
     },
     {
          2455977.4,
          {-3.6829,-0.11023,625.9212,1.90312,0.00834,2.7792}, /*cmx*/
          {4.134741,2.6687,2.1776,5.72}, /*cfx*/
          {-0.9978,-0.04029,243.79,0.80862,0.004637,1.0442}, /*cmy*/
          {4.280857,2.1342,1.0719,5.871}, /*cfy*/
          {8.4307,-0.09319,670.2148,2.00681,0.00975,3.005}, /*cmz*/
          {5.724047,4.1573,3.7114,1.0304} /*cfz*/
     },
     {
          2456007.4,
          {-6.9778,-0.05832,632.3501,2.36977,0.0062,2.8353}, /*cmx*/
          {0.563982,5.3797,4.4837,5.3477}, /*cfx*/
          {-2.2033,-0.0166,227.3331,0.98002,0.004712,0.9626}, /*cmy*/
          {0.722634,4.6911,3.3298,5.5164}, /*cfy*/
          {5.5597,-0.14363,669.9488,2.52859,0.006742,3.0042}, /*cmz*/
          {2.1529,0.5905,5.8255,0.6566} /*cfz*/
     },
     {
          2456037.4,
          {-8.7291,0.01815,639.8899,2.61396,0.005972,2.876}, /*cmx*/
          {3.260873,1.8004,0.24,4.972}, /*cfx*/
          {-2.6826,0.00951,204.7205,1.07043,0.005159,0.8556}, /*cmy*/
          {3.441478,0.9566,5.6012,5.1666}, /*cfy*/
          {1.2269,-0.15817,670.1992,2.75357,0.005156,2.9515}, /*cmz*/
          {4.848278,3.2717,1.7257,0.2686} /*cfz*/
     },
     {
          2456067.4,
          {-8.234,0.09213,648.3343,2.65427,0.00573,2.8678}, /*cmx*/
          {5.953259,4.472,2.194,4.5993}, /*cfx*/
          {-2.39,0.02676,177.5911,1.09942,0.004793,0.7157}, /*cmy*/
          {6.166101,3.4761,1.5657,4.8341}, /*cfy*/
          {-3.5688,-0.12454,669.9677,2.74386,0.006134,3.013}, /*cmz*/
          {1.254936,5.967,3.8778,6.1854} /*cfz*/
     },
     {
          2456097.4,
          {-5.4542,0.13457,655.6761,2.45809,0.007196,2.9687}, /*cmx*/
          {2.366581,0.8806,4.6081,4.2272}, /*cfx*/
          {-1.5829,0.02794,147.7842,1.04433,0.004414,0.5917}, /*cmy*/
          {2.627698,6.0187,3.8264,4.5183}, /*cfy*/
          {-7.4472,-0.06028,669.8359,2.59582,0.008847,3.0461}, /*cmz*/
          {3.950085,2.382,6.0384,5.8244} /*cfz*/
     },
     {
          2456127.4,
          {-1.2311,0.13953,661.3238,2.08862,0.011054,3.1027}, /*cmx*/
          {5.076852,3.5831,0.6855,3.8667}, /*cfx*/
          {-0.7205,0.02011,119.0148,0.91391,0.004791,0.4919}, /*cmy*/
          {5.407099,2.3067,5.9319,4.2323}, /*cfy*/
          {-9.3404,0.00881,670.2149,2.1544,0.010703,3.0411}, /*cmz*/
          {0.374123,5.0691,2.0856,5.4605} /*cfz*/
     },
     {
          2456157.4,
          {3.1121,0.1176,665.4681,1.48195,0.015519,3.0832}, /*cmx*/
          {1.527518,6.2831,3.1504,3.5536}, /*cfx*/
          {-0.1108,0.01382,95.4211,0.6696,0.006443,0.4066}, /*cmy*/
          {1.947039,4.926,1.9119,3.9965}, /*cfy*/
          {-8.9674,0.06159,669.7837,1.5086,0.01549,3.083}, /*cmz*/
          {3.105631,1.5373,4.7507,5.1112} /*cfz*/
     },
     {
          2456187.4,
          {6.6245,0.07572,667.1202,0.50057,0.017434,3.1148}, /*cmx*/
          {4.294996,2.7981,5.9294,3.267}, /*cfx*/
          {0.2906,0.01292,81.4449,0.27968,0.007864,0.3726}, /*cmy*/
          {4.797657,1.303,4.5274,3.7821}, /*cfy*/
          {-6.9566,0.0956,670.0194,0.56552,0.019443,3.1303}, /*cmz*/
          {5.872748,4.2742,1.1384,4.8315} /*cfz*/
     },
     {
          2456217.4,
          {8.7971,0.03123,667.2678,0.59305,0.015226,3.1516}, /*cmx*/
          {0.826868,2.4117,2.5279,3.0097}, /*cfx*/
          {0.6749,0.01569,80.4086,0.21599,0.006533,0.4}, /*cmy*/
          {1.341178,1.1133,1.1792,3.5047}, /*cfy*/
          {-4.0874,0.10448,669.8628,0.63061,0.015126,3.1901}, /*cmz*/
          {2.40336,3.9773,4.0265,4.5876} /*cfz*/
     },
     {
          2456247.4,
          {9.7389,-0.01027,665.9647,1.55933,0.002501,3.1911}, /*cmx*/
          {3.686364,5.3167,0.9681,2.7833}, /*cfx*/
          {1.1578,0.01518,92.3831,0.61877,0.000997,0.4956}, /*cmy*/
          {4.128785,3.989,5.2777,3.1826}, /*cfy*/
          {-1.0054,0.09808,669.6913,1.56683,0.002389,3.1644}, /*cmz*/
          {5.265136,0.5415,1.8551,4.3692} /*cfz*/
     },
     {
          2456277.4,
          {9.543,-0.04178,662.761,1.47813,0.014902,3.134}, /*cmx*/
          {0.285743,1.9318,5.0135,2.5775}, /*cfx*/
          {1.64,0.00456,110.9708,0.62133,0.006074,0.5586}, /*cmy*/
          {0.643532,0.6223,3.7793,2.906}, /*cfy*/
          {1.9068,0.09894,670.0276,1.55569,0.016608,3.1678}, /*cmz*/
          {1.865181,3.4494,0.2927,4.1378} /*cfz*/
     },
     {
          2456307.4,
          {8.379,-0.08247,660.8735,0.53468,0.01988,3.105}, /*cmx*/
          {3.145461,4.8897,1.7164,2.3265}, /*cfx*/
          {1.7993,-0.01042,124.1535,0.22738,0.007826,0.594}, /*cmy*/
          {3.453333,3.3697,0.4692,2.6291}, /*cfy*/
          {4.9581,0.08644,669.8334,0.538,0.020253,3.2061}, /*cmz*/
          {4.726233,6.2607,3.1251,3.8828} /*cfz*/
     },
     {
          2456337.4,
          {5.8737,-0.11871,660.1857,0.67357,0.016075,3.1163}, /*cmx*/
          {5.956133,4.5014,4.333,1.9878}, /*cfx*/
          {1.4682,-0.02048,123.9506,0.26516,0.006955,0.5564}, /*cmy*/
          {6.253962,3.5091,3.056,2.3023}, /*cfy*/
          {7.7268,0.05356,670.0821,0.74586,0.015303,3.1805}, /*cmz*/
          {1.253889,5.9872,5.8781,3.585} /*cfz*/
     },
     {
          2456367.4,
          {2.1425,-0.14244,662.7155,1.62499,0.010787,3.1075}, /*cmx*/
          {2.434679,0.9443,0.5725,1.6362}, /*cfx*/
          {0.8149,-0.02082,110.5111,0.66768,0.005278,0.4598}, /*cmy*/
          {2.759951,6.0384,5.3853,1.9828}, /*cfy*/
          {9.4108,-0.00221,670.153,1.6609,0.011384,3.1113}, /*cmz*/
          {4.013313,2.4492,2.1392,3.228} /*cfz*/
     },
     {
          2456397.4,
          {-2.2339,-0.13496,666.3135,2.23894,0.007248,3.0644}, /*cmx*/
          {5.161202,3.6456,2.8641,1.2889}, /*cfx*/
          {0.1707,-0.00951,86.5838,0.94119,0.004887,0.3267}, /*cmy*/
          {5.569954,2.3531,1.2425,1.7748}, /*cfy*/
          {9.2521,-0.07103,670.0268,2.31851,0.006878,3.0455}, /*cmz*/
          {0.455216,5.1767,4.3318,2.8432} /*cfz*/
     },
     {
          2456427.4,
          {-6.2615,-0.08682,669.3191,2.54922,0.00672,3.0243}, /*cmx*/
          {1.584158,0.0515,4.9477,0.8983}, /*cfx*/
          {-0.1052,0.00349,57.2233,1.10682,0.00472,0.1931}, /*cmy*/
          {2.209118,4.9234,3.4504,1.7746}, /*cfy*/
          {7.0557,-0.13442,670.3902,2.61196,0.005029,3.0753}, /*cmz*/
          {3.158426,1.5814,0.2856,2.4813} /*cfz*/
     },
     {
          2456457.4,
          {-8.8571,-0.00669,670.992,2.66931,0.006622,3.0222}, /*cmx*/
          {4.281996,2.7165,0.6895,0.5098}, /*cfx*/
          {0.0338,0.00926,33.4688,1.16796,0.00445,0.1431}, /*cmy*/
          {5.580257,1.2021,5.7033,2.4086}, /*cfy*/
          {3.0367,-0.15803,670.1011,2.69899,0.00565,3.0256}, /*cmz*/
          {5.85313,4.2841,2.3235,2.095} /*cfz*/
     },
     {
          2456487.4,
          {-9.1425,0.07133,670.4972,2.51302,0.007077,3.0071}, /*cmx*/
          {0.6963,5.3809,3.0311,0.1499}, /*cfx*/
          {0.3391,0.00353,42.4252,1.13531,0.004283,0.2488}, /*cmy*/
          {3.022823,3.7794,1.6206,2.7561}, /*cfy*/
          {-1.7383,-0.13813,670.3754,2.58862,0.00695,2.9535}, /*cmz*/
          {2.265545,0.6894,4.4351,1.7147} /*cfz*/
     },
     {
          2456517.4,
          {-7.0132,0.11871,667.7648,2.23392,0.010387,2.9522}, /*cmx*/
          {3.404278,1.7883,5.2895,6.0963}, /*cfx*/
          {0.4517,-0.00973,70.4357,1.01604,0.004829,0.3674}, /*cmy*/
          {6.117655,0.0916,3.6879,2.6075}, /*cfy*/
          {-5.9949,-0.08304,670.4747,2.26951,0.009618,2.9724}, /*cmz*/
          {4.970654,3.3904,0.4808,1.3635} /*cfz*/
     },
     {
          2456547.4,
          {-3.3586,0.13377,664.8524,1.6645,0.013617,2.9504}, /*cmx*/
          {6.130255,4.4653,1.3798,5.7654}, /*cfx*/
          {0.139,-0.0195,96.7652,0.76792,0.005945,0.4703}, /*cmy*/
          {2.699736,2.7366,5.9573,2.3762}, /*cfy*/
          {-8.5823,-0.02145,670.4404,1.68862,0.013704,3.0233}, /*cmz*/
          {1.412138,6.1194,3.0563,1.0408} /*cfz*/
     },
     {
          2456577.4,
          {0.7812,0.11651,661.5639,0.8391,0.018212,2.9766}, /*cmx*/
          {2.604243,0.9403,4.0919,5.4584}, /*cfx*/
          {-0.4852,-0.01941,114.3913,0.40752,0.007797,0.5342}, /*cmy*/
          {5.515454,5.4911,2.2384,2.101}, /*cfy*/
          {-9.1815,0.03151,670.5533,0.88237,0.019264,3.0111}, /*cmz*/
          {4.169005,2.5974,5.7309,0.7532} /*cfz*/
     },
     {
          2456607.4,
          {4.3079,0.09005,660.7688,0.28606,0.01672,3.0046}, /*cmx*/
          {5.404518,0.616,0.6599,5.2354}, /*cfx*/
          {-1.0839,-0.01024,119.6865,0.09647,0.007632,0.5286}, /*cmy*/
          {2.051225,4.4344,5.1312,1.877}, /*cfy*/
          {-8.1289,0.06377,670.5078,0.31561,0.016656,3.0034}, /*cmz*/
          {0.685203,2.2014,2.3355,0.4964} /*cfz*/
     },
     {
          2456637.4,
          {6.8836,0.06215,662.1448,1.35483,0.005089,3.0182}, /*cmx*/
          {1.96964,3.4613,3.9097,5.0214}, /*cfx*/
          {-1.3683,0.00177,110.8699,0.55578,0.003266,0.4562}, /*cmy*/
          {4.88583,1.5603,2.2129,1.6254}, /*cfy*/
          {-6.1719,0.08279,670.5102,1.35374,0.005878,3.1138}, /*cmz*/
          {3.535206,5.109,5.3245,0.2976} /*cfz*/
     },
     {
          2456667.4,
          {8.6795,0.02847,665.1664,1.61616,0.01102,3.0588}, /*cmx*/
          {4.850377,0.0819,3.0958,4.8118}, /*cfx*/
          {-1.2895,0.00857,92.0608,0.71462,0.004588,0.3861}, /*cmy*/
          {1.43546,4.5762,1.2524,1.3534}, /*cfy*/
          {-3.8006,0.1025,670.8401,1.6914,0.012545,3.2001}, /*cmz*/
          {0.132585,1.7275,4.8134,0.0881} /*cfz*/
     },
     {
          2456697.4,
          {9.6435,-0.01257,667.3807,0.87632,0.018982,3.1466}, /*cmx*/
          {1.438049,2.9688,6.1217,4.5463}, /*cfx*/
          {-1.0306,0.00815,74.8096,0.42054,0.00822,0.3359}, /*cmy*/
          {4.239457,1.2265,4.3763,1.0469}, /*cfy*/
          {-0.8295,0.11637,670.2381,0.89446,0.019121,3.1537}, /*cmz*/
          {3.005142,4.5517,1.4069,6.1391} /*cfz*/
     },
     {
          2456727.4,
          {9.4006,-0.06118,667.7931,0.27558,0.017544,3.1709}, /*cmx*/
          {4.265386,2.6952,2.5952,4.2703}, /*cfx*/
          {-0.8057,0.00615,69.598,0.08599,0.007497,0.3455}, /*cmy*/
          {0.760588,1.1194,0.8466,0.7927}, /*cfy*/
          {2.7092,0.11527,670.771,0.28759,0.017746,3.1555}, /*cmz*/
          {5.832772,4.2406,4.2412,5.8448} /*cfz*/
     },
     {
          2456757.4,
          {7.5614,-0.11234,666.7291,1.34552,0.011274,3.1806}, /*cmx*/
          {0.76031,5.4412,5.1509,3.9366}, /*cfx*/
          {-0.6404,0.01056,78.6856,0.53887,0.005393,0.4204}, /*cmy*/
          {3.593021,3.7032,3.3215,0.5453}, /*cfy*/
          {6.3258,0.08428,670.4556,1.34388,0.012112,3.1927}, /*cmz*/
          {2.326725,0.773,0.5336,5.4983} /*cfz*/
     },
     {
          2456787.4,
          {4.0696,-0.14426,663.9781,2.0052,0.008293,3.1599}, /*cmx*/
          {3.498378,1.8698,1.2439,3.5516}, /*cfx*/
          {-0.3212,0.02121,99.3899,0.84317,0.004314,0.5424}, /*cmy*/
          {0.127142,0.0835,5.4609,0.2228}, /*cfy*/
          {8.9255,0.03047,670.715,2.04398,0.008048,3.1991}, /*cmz*/
          {5.064502,3.4974,2.9776,5.1268} /*cfz*/
     },
     {
          2456817.4,
          {-0.3862,-0.1455,659.0976,2.42013,0.005605,3.1064}, /*cmx*/
          {6.212423,4.5645,3.295,3.1619}, /*cfx*/
          {0.3321,0.03312,126.8428,1.02508,0.003973,0.6676}, /*cmy*/
          {2.907207,2.6902,1.2339,6.1709}, /*cfy*/
          {9.7727,-0.0451,670.7362,2.47073,0.005225,3.1492}, /*cmz*/
          {1.494157,6.2088,5.0354,4.7361} /*cfz*/
     },
     {
          2456847.4,
          {-4.7261,-0.1082,652.8107,2.53886,0.005328,3.0598}, /*cmx*/
          {2.629702,0.9612,5.558,2.7903}, /*cfx*/
          {1.328,0.03448,156.8285,1.07936,0.004143,0.8048}, /*cmy*/
          {5.655841,5.2759,3.479,5.8433}, /*cfy*/
          {8.3272,-0.11241,670.7258,2.61416,0.005301,3.1095}, /*cmz*/
          {4.194378,2.6254,0.8666,4.3421} /*cfz*/
     },
     {
          2456877.4,
          {-7.9168,-0.03588,645.0009,2.49478,0.006272,2.9449}, /*cmx*/
          {5.327383,3.6501,1.2815,2.4067}, /*cfx*/
          {2.3733,0.01935,185.3275,1.0495,0.004025,0.908}, /*cmy*/
          {2.104935,1.5722,5.7126,5.4811}, /*cfy*/
          {4.9392,-0.15378,670.8522,2.58524,0.006222,3.1565}, /*cmz*/
          {0.609208,5.3184,2.867,3.9502} /*cfz*/
     },
     {
          2456907.4,
          {-9.0138,0.03697,637.5959,2.24874,0.008691,2.8682}, /*cmx*/
          {1.748076,0.0565,3.5031,2.0137}, /*cfx*/
          {2.9787,-0.00499,209.9428,0.93466,0.004128,0.9927}, /*cmy*/
          {4.835107,4.1624,1.5375,5.1097}, /*cfy*/
          {0.3607,-0.1476,671.0113,2.30683,0.008314,3.0953}, /*cmz*/
          {3.313237,1.7347,5.2309,3.595} /*cfz*/
     },
     {
          2456937.4,
          {-7.9422,0.09006,630.8929,1.77677,0.012866,2.8302}, /*cmx*/
          {4.467587,2.7793,6.0174,1.6764}, /*cfx*/
          {2.8498,-0.02903,228.8477,0.73349,0.005427,1.0601}, /*cmy*/
          {1.291888,0.5127,3.7253,4.795}, /*cfy*/
          {-4.1456,-0.10486,670.7978,1.84466,0.013552,2.9907}, /*cmz*/
          {6.034602,4.4646,1.427,3.2605} /*cfz*/
     },
     {
          2456967.4,
          {-5.175,0.10697,626.1666,1.00858,0.016436,2.7901}, /*cmx*/
          {0.931976,5.5252,2.4088,1.4006}, /*cfx*/
          {1.9517,-0.03992,241.0354,0.40618,0.007019,1.0898}, /*cmy*/
          {4.054613,3.2766,0.0076,4.5281}, /*cfy*/
          {-7.3712,-0.05246,671.1993,1.02856,0.016678,2.9866}, /*cmz*/
          {2.500291,0.9165,4.0695,2.9555} /*cfz*/
     },
     {
          2456997.4,
          {-1.8453,0.10414,624.3975,0.02258,0.017484,2.7787}, /*cmx*/
          {3.721104,0.4356,5.1678,1.1297}, /*cfx*/
          {0.6974,-0.04042,245.9372,0.06795,0.007135,1.091}, /*cmy*/
          {0.570508,1.7517,2.7927,4.2639}, /*cfy*/
          {-8.9055,-0.00615,670.82,0.03361,0.018481,2.999}, /*cmz*/
          {5.29052,6.19,0.6204,2.7092} /*cfz*/
     },
     {
          2457027.4,
          {1.3088,0.09126,625.4319,1.10281,0.008043,2.7671}, /*cmx*/
          {0.275879,1.7437,1.9825,0.9097}, /*cfx*/
          {-0.5293,-0.03356,242.7994,0.49563,0.003923,1.0469}, /*cmy*/
          {3.412082,5.4987,6.2146,4.0452}, /*cfy*/
          {-8.9817,0.02852,671.1878,1.1525,0.008897,2.9874}, /*cmz*/
          {1.846477,3.4209,3.5784,2.5114} /*cfz*/
     },
     {
          2457057.4,
          {3.9659,0.0822,629.2621,1.57591,0.006547,2.8465}, /*cmx*/
          {3.153084,4.6243,1.3316,0.7405}, /*cfx*/
          {-1.5087,-0.02547,232.7814,0.68744,0.003535,1.0259}, /*cmy*/
          {0.003057,2.2687,5.0223,3.8648}, /*cfy*/
          {-8.0451,0.0558,670.9067,1.70488,0.008673,2.9475}, /*cmz*/
          {4.72212,0.0076,2.9562,2.3109} /*cfz*/
     },
     {
          2457087.4,
          {6.3379,0.06313,633.8491,1.12616,0.017814,2.9044}, /*cmx*/
          {6.030812,1.235,4.3758,0.5299}, /*cfx*/
          {-2.2347,-0.01903,221.0182,0.48416,0.007585,0.9897}, /*cmy*/
          {2.87379,5.2701,2.0364,3.6527}, /*cfy*/
          {-6.3717,0.09334,671.0079,1.15256,0.017951,3.0207}, /*cmz*/
          {1.317254,2.8992,6.0328,2.0957} /*cfz*/
     },
     {
          2457117.4,
          {8.2549,0.02452,635.4605,0.04632,0.01671,2.9237}, /*cmx*/
          {2.58946,3.3967,0.874,0.2638}, /*cfx*/
          {-2.8016,-0.00948,214.9327,0.02685,0.007012,0.9915}, /*cmy*/
          {5.710064,2.7679,4.9225,3.3845}, /*cfy*/
          {-3.6717,0.12715,670.9935,0.04208,0.017923,3.0815}, /*cmz*/
          {4.158033,5.6355,2.5804,1.8113} /*cfz*/
     },
     {
          2457147.4,
          {9.0928,-0.03166,634.5666,0.97857,0.013039,2.8985}, /*cmx*/
          {5.380906,3.7115,3.5976,6.2149}, /*cfx*/
          {-3.128,0.0063,218.6524,0.4106,0.005495,1.0272}, /*cmy*/
          {2.218936,1.4043,1.1838,3.0605}, /*cfy*/
          {0.1561,0.1341,670.8827,1.0388,0.013191,3.1222}, /*cmz*/
          {0.666575,5.3957,5.2217,1.5113} /*cfz*/
     },
     {
          2457177.4,
          {8.1746,-0.08757,630.253,1.74162,0.007881,2.9693}, /*cmx*/
          {1.847045,0.1884,5.9977,5.8679}, /*cfx*/
          {-2.9655,0.02632,229.8541,0.73392,0.003813,1.122}, /*cmy*/
          {4.975059,4.1207,3.3843,2.718}, /*cfy*/
          {4.3329,0.11451,671.0068,1.83304,0.008193,3.1275}, /*cmz*/
          {3.416555,1.8524,1.4267,1.1613} /*cfz*/
     },
     {
          2457207.4,
          {5.3957,-0.12817,624.6797,2.18444,0.00504,2.9818}, /*cmx*/
          {4.567651,2.8997,2.0776,5.4925}, /*cfx*/
          {-2.1263,0.04724,245.0261,0.91769,0.003617,1.2101}, /*cmy*/
          {1.423625,0.4745,5.5598,2.3562}, /*cfy*/
          {7.8699,0.06257,670.965,2.2844,0.006899,3.1816}, /*cmz*/
          {6.137787,4.5788,3.667,0.7684} /*cfz*/
     },
     {
          2457237.4,
          {1.4057,-0.14454,618.4641,2.37628,0.003518,2.9044}, /*cmx*/
          {0.987843,5.6077,4.1317,5.0837}, /*cfx*/
          {-0.6545,0.06165,260.4745,1.00444,0.003403,1.2615}, /*cmy*/
          {4.140681,3.0793,1.482,1.9623}, /*cfy*/
          {9.6987,-0.00885,670.9732,2.5523,0.004711,3.2538}, /*cmz*/
          {2.560718,0.989,5.5315,0.374} /*cfz*/
     },
     {
          2457267.4,
          {-2.9551,-0.12054,612.5041,2.40206,0.005508,2.8996}, /*cmx*/
          {3.685744,2.048,6.0536,4.6878}, /*cfx*/
          {1.2111,0.05739,273.688,1.01841,0.003868,1.3254}, /*cmy*/
          {0.570068,5.685,3.5776,1.5793}, /*cfy*/
          {9.3108,-0.08428,671.2133,2.55295,0.005106,3.1813}, /*cmz*/
          {5.260798,3.679,1.3792,6.2753} /*cfz*/
     },
     {
          2457297.4,
          {-6.527,-0.0671,608.2351,2.2152,0.007622,2.9056}, /*cmx*/
          {0.103626,4.7571,1.9387,4.3106}, /*cfx*/
          {2.9214,0.03648,283.6588,0.93037,0.004035,1.3733}, /*cmy*/
          {3.286374,2.0024,5.6881,1.2168}, /*cfy*/
          {6.7276,-0.13539,670.8112,2.34814,0.008016,3.1715}, /*cmz*/
          {1.681383,0.1089,3.686,5.8972} /*cfz*/
     },
     {
          2457327.4,
          {-8.5153,0.00016,605.4679,1.78566,0.010559,2.837}, /*cmx*/
          {2.818178,1.2029,4.4771,3.9563}, /*cfx*/
          {4.0073,0.00557,289.8965,0.73028,0.004929,1.3686}, /*cmy*/
          {6.015739,4.6394,1.7214,0.8784}, /*cfy*/
          {2.6465,-0.14602,670.8965,1.92938,0.012087,3.1813}, /*cmz*/
          {4.399819,2.8143,6.0543,5.5245} /*cfz*/
     },
     {
          2457357.4,
          {-8.5377,0.05314,603.933,1.15376,0.016195,2.7951}, /*cmx*/
          {5.55946,3.9605,0.8329,3.6176}, /*cfx*/
          {4.188,-0.0208,292.9106,0.44333,0.007237,1.3586}, /*cmy*/
          {2.487274,1.0448,4.1673,0.5514}, /*cfy*/
          {-1.7706,-0.11994,670.8409,1.18869,0.016281,3.1052}, /*cmz*/
          {0.859862,5.5539,2.4107,5.211} /*cfz*/
     },
     {
          2457387.4,
          {-6.9351,0.07863,603.7487,0.18806,0.016499,2.7582}, /*cmx*/
          {2.056208,0.3728,3.5867,3.3475}, /*cfx*/
          {3.5648,-0.03512,294.0853,0.0114,0.006967,1.3418}, /*cmy*/
          {5.277444,4.4331,0.6356,0.2884}, /*cfy*/
          {-5.4774,-0.0752,670.4238,0.18587,0.018357,3.0326}, /*cmz*/
          {3.642446,2.2059,5.2609,4.9558} /*cfz*/
     },
     {
          2457417.4,
          {-4.4445,0.08021,603.3677,0.88143,0.010218,2.7667}, /*cmx*/
          {4.884534,0.1196,0.3494,3.1391}, /*cfx*/
          {2.4509,-0.03799,293.7202,0.44461,0.004232,1.3441}, /*cmy*/
          {1.827807,3.4113,3.8855,0.0799}, /*cfy*/
          {-7.7893,-0.03977,670.8299,0.95586,0.011062,3.0054}, /*cmz*/
          {0.188894,1.7717,1.8189,4.7193} /*cfz*/
     },
     {
          2457447.4,
          {-1.9224,0.08934,604.4695,1.48203,0.003859,2.7326}, /*cmx*/
          {1.473021,3.0268,5.9633,2.9499}, /*cfx*/
          {1.25,-0.04356,292.4179,0.67321,0.002671,1.3174}, /*cmy*/
          {4.697892,0.1269,2.8499,6.1679}, /*cfy*/
          {-8.9145,-0.01013,670.6447,1.6355,0.005341,2.9817}, /*cmz*/
          {3.059131,4.6298,1.1323,4.5051} /*cfz*/
     },
     {
          2457477.4,
          {0.739,0.0956,605.6497,1.25548,0.015735,2.6559}, /*cmx*/
          {4.353409,5.8866,2.7228,2.7387}, /*cfx*/
          {-0.0539,-0.04677,289.3771,0.52802,0.007205,1.263}, /*cmy*/
          {1.288569,3.0694,6.1257,5.9546}, /*cfy*/
          {-9.106,0.0248,670.8114,1.29334,0.01536,2.9855}, /*cmz*/
          {5.939193,1.2425,4.3875,4.3071} /*cfz*/
     },
     {
          2457507.4,
          {3.576,0.09036,606.6989,0.27551,0.016017,2.6844}, /*cmx*/
          {0.923067,2.4137,5.5807,2.4889}, /*cfx*/
          {-1.4415,-0.04524,287.0769,0.08137,0.006959,1.2683}, /*cmy*/
          {4.134257,6.157,2.7933,5.6983}, /*cfy*/
          {-8.355,0.07415,670.8918,0.31125,0.018245,2.969}, /*cmz*/
          {2.506071,4.1173,0.9521,4.0838} /*cfz*/
     },
     {
          2457537.4,
          {6.3142,0.05824,606.6558,0.7061,0.013088,2.7286}, /*cmx*/
          {3.726316,2.1277,2.0211,2.2036}, /*cfx*/
          {-2.8086,-0.03234,287.4548,0.34702,0.005566,1.301}, /*cmy*/
          {0.650855,5.5625,5.405,5.4125}, /*cfy*/
          {-6.1797,0.11875,670.5574,0.7855,0.013727,3.0068}, /*cmz*/
          {5.309446,3.7748,3.6045,3.7763} /*cfz*/
     },
     {
          2457567.4,
          {8.1646,0.00369,605.1866,1.48956,0.008874,2.7255}, /*cmx*/
          {0.202682,4.899,4.5328,1.8654}, /*cfx*/
          {-3.8309,-0.00778,289.9998,0.68353,0.00402,1.3153}, /*cmy*/
          {3.412233,2.0272,1.3738,5.0766}, /*cfy*/
          {-2.5926,0.1446,670.8654,1.60791,0.010112,3.0214}, /*cmz*/
          {1.786195,0.214,6.2445,3.4351} /*cfz*/
     },
     {
          2457597.4,
          {8.3366,-0.05796,604.1271,2.00848,0.004343,2.7039}, /*cmx*/
          {2.930223,1.327,0.7998,1.4931}, /*cfx*/
          {-4.1002,0.02206,293.2532,0.89476,0.002766,1.3159}, /*cmy*/
          {6.146219,4.6623,3.5731,4.7167}, /*cfy*/
          {1.8751,0.13604,670.599,2.15393,0.006919,3.0949}, /*cmz*/
          {4.514804,2.9518,2.2219,3.093} /*cfz*/
     },
     {
          2457627.4,
          {6.5289,-0.10908,603.2671,2.2527,0.003822,2.8062}, /*cmx*/
          {5.637889,4.0659,2.8729,1.1163}, /*cfx*/
          {-3.4086,0.04845,294.6952,0.98874,0.003433,1.3664}, /*cmy*/
          {2.580826,1.0222,5.7571,4.3484}, /*cfy*/
          {6.1227,0.09345,670.5078,2.50248,0.005238,3.1043}, /*cmz*/
          {0.942394,5.6614,4.0799,2.7212} /*cfz*/
     },
     {
          2457657.4,
          {3.0757,-0.13602,603.787,2.32616,0.004332,2.9016}, /*cmx*/
          {2.054264,0.5093,4.663,0.7304}, /*cfx*/
          {-1.8674,0.06276,293.44,1.00367,0.003751,1.3982}, /*cmy*/
          {5.293141,3.6324,1.6032,3.9726}, /*cfy*/
          {8.9672,0.02725,670.7405,2.53032,0.0046,3.1294}, /*cmz*/
          {3.643522,2.0628,6.2513,2.3236} /*cfz*/
     },
     {
          2457687.4,
          {-1.1015,-0.13364,606.2651,2.21872,0.006366,2.8585}, /*cmx*/
          {4.755798,3.2181,0.4094,0.3549}, /*cfx*/
          {0.0654,0.06199,289.3634,0.9346,0.003938,1.3486}, /*cmy*/
          {1.725737,6.2189,3.7117,3.6143}, /*cfy*/
          {9.674,-0.04586,670.321,2.39611,0.007571,3.1882}, /*cmz*/
          {0.063848,4.7748,2.17,1.9309} /*cfz*/
     },
     {
          2457717.4,
          {-5.0745,-0.09444,609.3207,1.84222,0.009621,2.9061}, /*cmx*/
          {1.185427,5.9584,2.9761,6.2729}, /*cfx*/
          {1.9094,0.04467,282.7946,0.74719,0.004666,1.3261}, /*cmy*/
          {4.45377,2.5513,6.0456,3.2647}, /*cfy*/
          {8.2181,-0.10816,670.421,2.02493,0.011732,3.1843}, /*cmz*/
          {2.779125,1.1895,4.4505,1.5835} /*cfz*/
     },
     {
          2457747.4,
          {-7.8962,-0.03547,612.5655,1.27869,0.015159,2.9553}, /*cmx*/
          {3.923396,2.4304,5.5848,5.9346}, /*cfx*/
          {3.2345,0.02078,276.0316,0.49052,0.006543,1.3167}, /*cmy*/
          {0.923122,5.1896,2.166,2.9398}, /*cfy*/
          {5.0034,-0.13111,670.1499,1.33516,0.015553,3.1906}, /*cmz*/
          {5.517394,3.9249,0.7959,1.2536} /*cfz*/
     },
     {
          2457777.4,
          {-9.0305,0.01744,614.9437,0.34431,0.016172,2.9391}, /*cmx*/
          {0.413242,5.2042,2.0589,5.6504}, /*cfx*/
          {3.8857,-1e-05,271.7315,0.10095,0.006618,1.3018}, /*cmy*/
          {3.7078,1.2658,4.8317,2.6646}, /*cfy*/
          {1.0325,-0.11727,669.7542,0.37091,0.018486,3.1976}, /*cmz*/
          {2.00917,0.469,3.6039,0.9392} /*cfz*/
     },
     {
          2457807.4,
          {-8.556,0.0466,614.449,0.67255,0.012025,2.8381}, /*cmx*/
          {3.233739,4.833,5.0172,5.3988}, /*cfx*/
          {3.9208,-0.01239,271.9074,0.32845,0.004575,1.2695}, /*cmy*/
          {0.250959,1.4449,1.6004,2.417}, /*cfy*/
          {-2.5696,-0.09279,669.9639,0.76266,0.012142,3.1808}, /*cmz*/
          {4.830216,0.1248,0.1673,0.7018} /*cfz*/
     },
     {
          2457837.4,
          {-7.1198,0.06545,612.9022,1.40438,0.000944,2.811}, /*cmx*/
          {6.096953,1.4835,4.4833,5.1887}, /*cfx*/
          {3.545,-0.02345,276.9143,0.60256,0.000939,1.2868}, /*cmy*/
          {3.111455,4.3636,0.8222,2.2042}, /*cfy*/
          {-5.4563,-0.06594,669.6692,1.56987,0.003336,3.1352}, /*cmz*/
          {1.410355,2.9668,5.3141,0.5051} /*cfz*/
     },
     {
          2457867.4,
          {-5.0902,0.08523,609.7918,1.30832,0.012962,2.8094}, /*cmx*/
          {2.693929,4.3325,1.1558,4.9606}, /*cfx*/
          {2.8108,-0.03673,282.3033,0.5305,0.005946,1.308}, /*cmy*/
          {5.982951,0.9671,4.0803,1.9614}, /*cfy*/
          {-7.4867,-0.0481,670.0359,1.37746,0.013384,3.0871}, /*cmz*/
          {4.291122,5.8663,2.6995,0.2956} /*cfz*/
     },
     {
          2457897.4,
          {-2.4687,0.10775,608.2446,0.49253,0.01622,2.7717}, /*cmx*/
          {5.552702,0.8944,4.0345,4.7225}, /*cfx*/
          {1.6733,-0.05037,285.5669,0.15854,0.007012,1.3025}, /*cmy*/
          {2.548763,3.7859,0.7303,1.7136}, /*cfy*/
          {-8.9023,-0.0128,670.0983,0.53737,0.018384,3.026}, /*cmz*/
          {0.864509,2.4221,5.554,0.031} /*cfz*/
     },
     {
          2457927.4,
          {0.7563,0.11669,608.1773,0.49203,0.014266,2.7024}, /*cmx*/
          {2.083019,0.5684,0.5204,4.4469}, /*cfx*/
          {0.1586,-0.05596,285.5315,0.26678,0.005917,1.2644}, /*cmy*/
          {5.356376,3.6086,3.4049,1.4366}, /*cfy*/
          {-9.2614,0.03969,670.0693,0.59138,0.014325,2.9881}, /*cmz*/
          {3.677962,2.1324,2.0298,6.0224} /*cfz*/
     },
     {
          2457957.4,
          {4.245,0.09485,609.5125,1.33458,0.009648,2.7027}, /*cmx*/
          {4.851858,3.3535,3.0831,4.107}, /*cfx*/
          {-1.514,-0.0461,282.3668,0.61496,0.004179,1.2321}, /*cmy*/
          {1.84199,0.0211,5.6902,1.1003}, /*cfy*/
          {-8.1267,0.10217,670.3997,1.45657,0.010656,3.0099}, /*cmz*/
          {0.162425,4.8655,4.6795,5.7247} /*cfz*/
     },
     {
          2457987.4,
          {7.1878,0.04049,612.7398,1.93128,0.005774,2.7563}, /*cmx*/
          {1.3034,6.0884,5.5361,3.758}, /*cfx*/
          {-2.9336,-0.02007,275.7469,0.84642,0.00349,1.2103}, /*cmy*/
          {4.582107,2.6639,1.4842,0.7556}, /*cfy*/
          {-5.119,0.14233,669.8763,2.07854,0.00748,2.972}, /*cmz*/
          {2.896848,1.3399,0.6487,5.3593} /*cfz*/
     },
     {
          2458017.4,
          {8.5464,-0.02538,617.5909,2.22282,0.004685,2.779}, /*cmx*/
          {4.015495,2.5288,1.5478,3.4022}, /*cfx*/
          {-3.5929,0.0093,264.995,0.94651,0.003815,1.1566}, /*cmy*/
          {1.021679,5.2591,3.7681,0.4116}, /*cfy*/
          {-0.7513,0.1489,670.1103,2.4377,0.004812,2.9568}, /*cmz*/
          {5.609577,4.0364,2.8116,4.9824} /*cfz*/
     },
     {
          2458047.4,
          {7.7613,-0.08541,623.656,2.39829,0.004912,2.7819}, /*cmx*/
          {0.435484,5.2515,3.2374,3.0364}, /*cfx*/
          {-3.2983,0.03192,250.0537,0.98959,0.004337,1.0733}, /*cmy*/
          {3.739951,1.5604,5.9486,0.0663}, /*cfy*/
          {3.892,0.11896,670.0077,2.55949,0.004655,3.0142}, /*cmz*/
          {2.028283,0.4516,4.7512,4.6246} /*cfz*/
     },
     {
          2458077.4,
          {5.0647,-0.12998,631.1669,2.29129,0.005674,2.8993}, /*cmx*/
          {3.137539,1.6619,5.3288,2.6678}, /*cfx*/
          {-2.2872,0.04416,231.8513,0.93988,0.003872,1.0119}, /*cmy*/
          {0.178197,4.0989,1.8727,5.9984}, /*cfy*/
          {7.5289,0.06369,669.8103,2.43924,0.006651,3.0604}, /*cmz*/
          {4.729716,3.1559,0.6283,4.2627} /*cfz*/
     },
     {
          2458107.4,
          {1.0603,-0.13956,637.8883,1.99902,0.009918,2.9909}, /*cmx*/
          {5.850456,4.3827,1.4177,2.3058}, /*cfx*/
          {-0.9291,0.04216,212.0516,0.81662,0.004674,0.944}, /*cmy*/
          {2.914877,0.392,4.0217,5.6647}, /*cfy*/
          {9.3616,-0.00795,669.8219,2.14127,0.011336,3.0798}, /*cmz*/
          {1.158498,5.8629,2.8985,3.8992} /*cfz*/
     },
     {
          2458137.4,
          {-3.1142,-0.11797,643.7802,1.41394,0.01407,3.0084}, /*cmx*/
          {2.30159,0.8328,4.0028,1.9902}, /*cfx*/
          {0.3229,0.03447,194.3811,0.58784,0.005837,0.8816}, /*cmy*/
          {5.674276,2.9757,0.0084,5.3717}, /*cfy*/
          {9.0605,-0.06924,669.6659,1.47532,0.014665,3.1282}, /*cmz*/
          {3.890869,2.3152,5.5304,3.5591} /*cfz*/
     },
     {
          2458167.4,
          {-6.5861,-0.06939,647.1311,0.53698,0.01636,3.0233}, /*cmx*/
          {5.069082,3.619,0.4481,1.6888}, /*cfx*/
          {1.3218,0.02496,182.7788,0.23784,0.006736,0.846}, /*cmy*/
          {2.179594,5.534,2.6042,5.0932}, /*cfy*/
          {6.9945,-0.1022,669.4378,0.59432,0.018436,3.2071}, /*cmz*/
          {0.37534,5.0912,1.941,3.2794} /*cfz*/
     },
     {
          2458197.4,
          {-8.701,-0.02105,647.5572,0.50013,0.013872,3.0611}, /*cmx*/
          {1.59766,3.2128,3.3701,1.421}, /*cfx*/
          {2.0721,0.018,181.2944,0.19568,0.00538,0.8714}, /*cmy*/
          {4.999039,5.6548,5.533,4.8248}, /*cfy*/
          {4.0071,-0.10717,669.7856,0.55471,0.013618,3.2436}, /*cmz*/
          {3.186348,4.8008,4.7719,3.0316} /*cfz*/
     },
     {
          2458227.4,
          {-9.4178,0.01358,645.1843,1.32988,0.002462,3.1124}, /*cmx*/
          {4.452773,6.1236,0.5016,1.1917}, /*cfx*/
          {2.6518,0.01,190.1391,0.52614,0.000861,0.953}, /*cmy*/
          {1.560676,2.1116,2.9057,4.5746}, /*cfy*/
          {0.8081,-0.09801,669.1584,1.40558,0.003094,3.1517}, /*cmz*/
          {6.042983,1.3125,2.0763,2.7991} /*cfz*/
     },
     {
          2458257.4,
          {-9.0638,0.0424,640.8082,1.4472,0.012054,3.0136}, /*cmx*/
          {1.046903,2.7259,5.7701,0.992}, /*cfx*/
          {2.9863,-0.00209,203.7827,0.5577,0.004873,0.9906}, /*cmy*/
          {4.41796,5.0254,1.9106,4.3526}, /*cfy*/
          {-2.2151,-0.093,669.8318,1.50726,0.012484,3.1842}, /*cmz*/
          {2.63854,4.2273,1.055,2.5758} /*cfz*/
     },
     {
          2458287.4,
          {-7.7478,0.07502,637.3939,0.6778,0.016273,3.0062}, /*cmx*/
          {3.911257,5.6099,2.4706,0.7369}, /*cfx*/
          {2.9116,-0.01904,214.1584,0.25092,0.006531,1.0192}, /*cmy*/
          {0.98077,1.4875,4.8389,4.0852}, /*cfy*/
          {-5.0865,-0.08484,669.5149,0.72192,0.017711,3.1792}, /*cmz*/
          {5.502634,0.7781,3.9275,2.3314} /*cfz*/
     },
     {
          2458317.4,
          {-5.4333,0.11344,636.5328,0.31773,0.015601,3.0148}, /*cmx*/
          {0.450124,5.2752,5.2029,0.4255}, /*cfx*/
          {2.3069,-0.0357,216.2228,0.16834,0.00626,1.005}, /*cmy*/
          {3.793199,1.7223,1.2464,3.7661}, /*cfy*/
          {-7.6092,-0.05768,669.8795,0.37163,0.016037,3.1358}, /*cmz*/
          {2.041714,0.4769,0.4338,2.0415} /*cfz*/
     },
     {
          2458347.4,
          {-2.029,0.13874,638.5646,1.263,0.010738,2.9809}, /*cmx*/
          {3.22743,1.7755,1.5332,0.1002}, /*cfx*/
          {1.2169,-0.04338,209.3282,0.53053,0.00483,0.9421}, /*cmy*/
          {0.28797,4.2227,3.5889,3.4411}, /*cfy*/
          {-9.2991,0.00253,669.8075,1.33707,0.011662,3.0591}, /*cmz*/
          {4.817127,3.2565,3.0417,1.6909} /*cfz*/
     },
     {
          2458377.4,
          {2.0905,0.13018,643.6522,1.89909,0.00809,2.9486}, /*cmx*/
          {5.967302,4.4998,4.0091,6.0464}, /*cfx*/
          {-0.0766,-0.03583,194.2382,0.7872,0.004447,0.8384}, /*cmy*/
          {3.039356,0.5248,5.8633,3.1227}, /*cfy*/
          {-9.2462,0.07172,669.7929,2.02056,0.008046,3.0221}, /*cmz*/
          {1.272513,5.9913,5.4381,1.3289} /*cfz*/
     },
     {
          2458407.4,
          {6.0478,0.08105,649.6703,2.32364,0.005866,2.9077}, /*cmx*/
          {2.400224,0.935,6.1232,5.6715}, /*cfx*/
          {-1.1538,-0.01567,171.8098,0.96153,0.004658,0.7108}, /*cmy*/
          {5.780293,3.1051,1.7323,2.7919}, /*cfy*/
          {-7.1443,0.13159,669.833,2.45943,0.005251,3.0488}, /*cmz*/
          {3.986495,2.4187,1.2554,0.96} /*cfz*/
     },
     {
          2458437.4,
          {8.5919,0.01166,656.6985,2.49422,0.005101,2.921}, /*cmx*/
          {5.10375,3.6183,1.9049,5.2836}, /*cfx*/
          {-1.6279,0.00348,143.9011,1.05928,0.004351,0.5691}, /*cmy*/
          {2.243185,5.6485,3.9698,2.4517}, /*cfy*/
          {-3.1765,0.15279,669.9216,2.5976,0.004904,2.9957}, /*cmz*/
          {0.403537,5.1126,3.3628,0.594} /*cfz*/
     },
     {
          2458467.4,
          {8.9746,-0.06082,662.6415,2.47728,0.007117,2.9423}, /*cmx*/
          {1.522045,0.0197,3.8291,4.9306}, /*cfx*/
          {-1.5054,0.01365,112.7075,1.06159,0.004227,0.4257}, /*cmy*/
          {5.017653,1.922,6.1949,2.1865}, /*cfy*/
          {1.5687,0.1363,669.795,2.56055,0.007017,2.9336}, /*cmz*/
          {3.102228,1.5307,5.2846,0.2265} /*cfz*/
     },
     {
          2458497.4,
          {7.0146,-0.11063,666.9703,2.16937,0.009595,2.9474}, /*cmx*/
          {4.231497,2.708,6.1747,4.6011}, /*cfx*/
          {-1.0722,0.01276,82.4843,0.97461,0.004484,0.3088}, /*cmy*/
          {1.5723,4.4997,1.9391,2.0474}, /*cfy*/
          {5.7408,0.09233,670.0825,2.22151,0.009093,2.9862}, /*cmz*/
          {5.808372,4.2328,1.4008,6.164} /*cfz*/
     },
     {
          2458527.4,
          {3.5487,-0.13575,669.6356,1.6336,0.013816,3.007}, /*cmx*/
          {0.676938,5.4036,2.2922,4.2512}, /*cfx*/
          {-0.6772,0.00666,58.204,0.76202,0.005888,0.2211}, /*cmy*/
          {4.515414,0.8291,4.1133,1.9406}, /*cfy*/
          {8.4357,0.03006,669.8775,1.6803,0.014376,3.0284}, /*cmz*/
          {2.251298,0.6772,3.8841,5.8543} /*cfz*/
     },
     {
          2458557.4,
          {-0.5076,-0.12578,670.4795,0.78529,0.016604,3.0642}, /*cmx*/
          {3.435793,1.8915,5.0543,3.9621}, /*cfx*/
          {-0.4855,0.005,44.6235,0.40898,0.007431,0.1876}, /*cmy*/
          {1.265902,3.5279,0.4,1.8902}, /*cfy*/
          {9.21,-0.02661,670.2191,0.83538,0.017843,3.0082}, /*cmz*/
          {5.009126,3.411,0.2663,5.5534} /*cfz*/
     },
     {
          2458587.4,
          {-4.1816,-0.09558,670.5162,0.2357,0.016405,3.1044}, /*cmx*/
          {6.236949,1.4204,1.5933,3.7336}, /*cfx*/
          {-0.3572,0.00956,41.3675,0.05459,0.006969,0.1971}, /*cmy*/
          {4.185385,3.1296,3.2442,1.6121}, /*cfy*/
          {8.3769,-0.06573,669.9371,0.27748,0.015557,3.0309}, /*cmz*/
          {1.525515,3.0493,3.1441,5.2885} /*cfz*/
     },
     {
          2458617.4,
          {-7.0033,-0.05758,670.6841,1.24106,0.00499,3.1307}, /*cmx*/
          {2.798752,4.4001,4.7064,3.5131}, /*cfx*/
          {-0.0677,0.01486,46.2602,0.49123,0.002915,0.2549}, /*cmy*/
          {0.576936,6.046,0.1804,1.1497}, /*cfy*/
          {6.4739,-0.08536,669.9423,1.26669,0.005495,3.1258}, /*cmz*/
          {4.372185,5.939,6.2585,5.0844} /*cfz*/
     },
     {
          2458647.4,
          {-8.7901,-0.02703,669.1504,1.52035,0.008381,3.1508}, /*cmx*/
          {5.674184,0.992,3.9597,3.2977}, /*cfx*/
          {0.3977,0.01664,59.7724,0.65488,0.003661,0.3173}, /*cmy*/
          {3.195273,2.6985,5.6805,0.7355}, /*cfy*/
          {3.9739,-0.09716,670.0838,1.5867,0.009606,3.188}, /*cmz*/
          {0.965505,2.5449,5.6065,4.857} /*cfz*/
     },
     {
          2458677.4,
          {-9.6755,0.00799,668.0846,0.9617,0.017792,3.1813}, /*cmx*/
          {2.260806,3.9082,0.7649,3.0427}, /*cfx*/
          {0.915,0.00825,74.6781,0.42188,0.007136,0.375}, /*cmy*/
          {5.909606,5.5835,2.5557,0.3791}, /*cfy*/
          {0.9875,-0.10985,669.9393,0.97511,0.017829,3.1679}, /*cmz*/
          {3.837052,5.4061,2.2509,4.6323} /*cfz*/
     },
     {
          2458707.4,
          {-9.4211,0.0511,666.8829,0.11398,0.016807,3.2179}, /*cmx*/
          {5.093599,3.7409,3.5174,2.769}, /*cfx*/
          {1.168,-0.00293,80.4125,0.05859,0.007306,0.3775}, /*cmy*/
          {2.407005,0.3492,5.3021,0.0821}, /*cfy*/
          {-2.4278,-0.1159,670.1541,0.13227,0.017059,3.1814}, /*cmz*/
          {0.387265,5.1217,5.093,4.3391} /*cfz*/
     },
     {
          2458737.4,
          {-7.7422,0.10391,667.8975,1.14003,0.013288,3.217}, /*cmx*/
          {1.596444,0.0731,6.1868,2.4362}, /*cfx*/
          {1.0476,-0.01056,73.2977,0.46474,0.005899,0.3127}, /*cmy*/
          {5.22132,1.9745,1.5218,6.0983}, /*cfy*/
          {-5.938,-0.09361,670.0954,1.16387,0.013881,3.2297}, /*cmz*/
          {3.171775,1.6288,1.3847,3.9957} /*cfz*/
     },
     {
          2458767.4,
          {-4.5665,0.14978,669.4916,1.90498,0.009525,3.1603}, /*cmx*/
          {4.341246,2.8078,2.3193,2.0473}, /*cfx*/
          {0.6962,-0.0092,55.1246,0.80258,0.005085,0.2074}, /*cmy*/
          {1.830225,4.5829,3.7933,6.0227}, /*cfy*/
          {-8.6878,-0.03808,670.1368,1.97916,0.008446,3.2423}, /*cmz*/
          {5.915583,4.354,3.8625,3.6268} /*cfz*/
     },
     {
          2458797.4,
          {-0.0911,0.15237,670.7355,2.42159,0.007107,3.1573}, /*cmx*/
          {0.775406,5.5052,4.3846,1.6608}, /*cfx*/
          {0.411,0.0017,33.9827,1.0372,0.004866,0.14}, /*cmy*/
          {5.048716,0.9018,5.9312,0.1991}, /*cfy*/
          {-9.8033,0.04187,670.4759,2.45107,0.006107,3.1121}, /*cmz*/
          {2.346938,0.7741,6.1747,3.2442} /*cfz*/
     },
     {
          2458827.4,
          {4.5212,0.11294,670.6952,2.65001,0.006361,3.1113}, /*cmx*/
          {3.47635,1.8907,0.163,1.2872}, /*cfx*/
          {0.4706,0.01353,35.695,1.16475,0.004371,0.2214}, /*cmy*/
          {2.552953,3.4651,1.7878,0.7154}, /*cfy*/
          {-8.59,0.1114,670.2484,2.68643,0.005659,3.0912}, /*cmz*/
          {5.045579,3.48,1.7674,2.8493} /*cfz*/
     },
     {
          2458857.4,
          {8.0012,0.04192,668.3702,2.60979,0.007232,3.015}, /*cmx*/
          {6.17205,4.5603,2.4085,0.904}, /*cfx*/
          {0.905,0.01425,64.8503,1.1662,0.004556,0.3714}, /*cmy*/
          {5.759524,6.044,3.9569,0.6015}, /*cfy*/
          {-5.1945,0.14744,670.5801,2.66199,0.005793,3.0955}, /*cmz*/
          {1.456578,6.1623,3.8136,2.4604} /*cfz*/
     },
     {
          2458887.4,
          {9.2994,-0.03077,664.3573,2.40054,0.010055,2.9822}, /*cmx*/
          {2.590824,0.9413,4.4155,0.5194}, /*cfx*/
          {1.3614,0.00373,97.563,1.05905,0.004568,0.5071}, /*cmy*/
          {2.350556,2.3426,6.043,0.3303}, /*cfy*/
          {-0.6274,0.14544,670.6758,2.40196,0.008578,2.9984}, /*cmz*/
          {4.156325,2.5786,6.0594,2.1044} /*cfz*/
     },
     {
          2458917.4,
          {8.2704,-0.08462,659.662,1.87517,0.012409,2.9213}, /*cmx*/
          {5.308298,3.6314,0.5896,0.1957}, /*cfx*/
          {1.4594,-0.01222,125.8634,0.83304,0.005422,0.6047}, /*cmy*/
          {5.145281,4.9738,2.0077,0.0668}, /*cfy*/
          {3.8722,0.10926,670.4971,1.92861,0.013474,2.9406}, /*cmz*/
          {0.590549,5.3108,2.3275,1.7725} /*cfz*/
     },
     {
          2458947.4,
          {5.5497,-0.11049,655.0622,1.09665,0.016093,2.9221}, /*cmx*/
          {1.770263,0.1026,3.282,6.2011}, /*cfx*/
          {1.0504,-0.02435,145.5779,0.51105,0.007085,0.6748}, /*cmy*/
          {1.646368,1.4183,4.4762,6.0916}, /*cfy*/
          {7.1412,0.06054,670.9245,1.14719,0.017189,2.9581}, /*cmz*/
          {3.3358,1.7493,4.8798,1.4579} /*cfz*/
     },
     {
          2458977.4,
          {2.1563,-0.11471,653.2337,0.12601,0.017495,2.8816}, /*cmx*/
          {4.556036,2.7552,6.0221,5.9328}, /*cfx*/
          {0.2945,-0.02681,154.4852,0.09228,0.007441,0.6788}, /*cmy*/
          {4.450486,4.7261,0.9459,5.8282}, /*cfy*/
          {8.8242,0.00981,670.8558,0.09088,0.017052,2.9926}, /*cmz*/
          {6.120767,4.6153,1.44,1.204} /*cfz*/
     },
     {
          2459007.4,
          {-1.2099,-0.10066,653.9182,0.9981,0.009018,2.8848}, /*cmx*/
          {1.103789,2.5808,2.7531,5.7092}, /*cfx*/
          {-0.5057,-0.0189,150.959,0.40105,0.004874,0.6326}, /*cmy*/
          {1.000454,3.5997,4.1507,5.5946}, /*cfy*/
          {9.0249,-0.02916,670.7717,0.97068,0.011162,2.9835}, /*cmz*/
          {2.670181,4.2279,4.3735,0.9998} /*cfz*/
     },
     {
          2459037.4,
          {-4.174,-0.0831,657.0893,1.56252,0.004884,2.9732}, /*cmx*/
          {3.975029,5.4641,2.0183,5.5354}, /*cfx*/
          {-1.0575,-0.01001,136.5577,0.67117,0.002224,0.5812}, /*cmy*/
          {3.85942,0.3776,2.7921,5.4121}, /*cfy*/
          {8.2304,-0.06316,671.0144,1.61739,0.005447,2.9899}, /*cmz*/
          {5.54067,0.8437,3.8013,0.8083} /*cfz*/
     },
     {
          2459067.4,
          {-6.7467,-0.05959,660.8158,1.25616,0.016845,3.0513}, /*cmx*/
          {0.569148,2.0784,5.2093,5.3257}, /*cfx*/
          {-1.3563,-0.00358,118.8335,0.55921,0.006889,0.5147}, /*cmy*/
          {0.431242,3.3546,0.1619,5.1693}, /*cfy*/
          {6.4061,-0.08725,670.5874,1.26016,0.01614,3.0878}, /*cmz*/
          {2.13601,3.6997,0.5263,0.5873} /*cfz*/
     },
     {
          2459097.4,
          {-8.6876,-0.02774,662.2144,0.21412,0.018694,3.0645}, /*cmx*/
          {3.416688,4.7793,1.7249,5.0485}, /*cfx*/
          {-1.4813,-0.00315,108.4726,0.12681,0.007952,0.503}, /*cmy*/
          {3.263233,6.2275,3.0805,4.8954}, /*cfy*/
          {3.6985,-0.11804,670.9601,0.23353,0.019777,3.158}, /*cmz*/
          {4.98361,0.3224,3.4317,0.3219} /*cfz*/
     },
     {
          2459127.4,
          {-9.5442,0.02374,662.0496,0.93341,0.014316,3.0725}, /*cmx*/
          {6.214728,4.5603,4.5055,4.7159}, /*cfx*/
          {-1.579,-0.00098,111.7662,0.35831,0.006587,0.5553}, /*cmy*/
          {6.071254,5.9014,5.704,4.5941}, /*cfy*/
          {0.0093,-0.1347,670.6468,0.91411,0.015863,3.2024}, /*cmz*/
          {1.498089,6.2435,6.0667,0.0219} /*cfz*/
     },
     {
          2459157.4,
          {-8.7428,0.08763,658.8205,1.80571,0.010797,3.1601}, /*cmx*/
          {2.683091,1.0442,0.6193,4.3646}, /*cfx*/
          {-1.6103,0.01086,127.844,0.74848,0.005017,0.6779}, /*cmy*/
          {2.569708,2.3173,1.6179,4.2692}, /*cfy*/
          {-4.1444,-0.12058,670.7947,1.88483,0.009654,3.1852}, /*cmz*/
          {4.250486,2.6925,2.2472,5.9384} /*cfz*/
     },
     {
          2459187.4,
          {-5.9912,0.13876,653.3864,2.39104,0.007352,3.1711}, /*cmx*/
          {5.401105,3.7496,2.8004,3.9696}, /*cfx*/
          {-1.2776,0.02879,152.3275,1.0048,0.004433,0.8086}, /*cmy*/
          {5.322337,4.9346,3.6569,3.9109}, /*cfy*/
          {-7.7679,-0.06885,671.0244,2.43247,0.007207,3.2274}, /*cmz*/
          {0.684465,5.3989,4.6015,5.5374} /*cfz*/
     },
     {
          2455197.4,
          {2.0989,-0.00447,991.7362,3.73142,0.009487,0.9254}, /*cmx*/
          {1.346722,5.9792,5.027,3.3494}, /*cfx*/
          {0.8415,-0.00023,402.2787,1.60421,0.006716,0.3878}, /*cmy*/
          {1.363393,0.3306,5.2852,3.3661}, /*cfy*/
          {-2.7446,0.03631,1070.1802,3.91262,0.011445,0.9716}, /*cmz*/
          {2.919575,1.3562,0.4622,4.9402} /*cfz*/
     },
     {
          2455237.4,
          {1.7466,0.00707,979.3948,4.22446,0.007758,0.7638}, /*cmx*/
          {4.898435,3.2582,1.5041,4.2594}, /*cfx*/
          {0.7412,0.00466,431.9498,1.8184,0.007083,0.3489}, /*cmy*/
          {4.93021,3.7362,1.9449,4.2963}, /*cfy*/
          {-1.9065,0.02418,1070.4544,4.53883,0.009064,0.8074}, /*cmz*/
          {0.191332,4.8981,3.1239,5.8956} /*cfz*/
     },
     {
          2455277.4,
          {1.4449,0.00446,970.1482,4.12349,0.009939,0.6309}, /*cmx*/
          {2.15639,0.5349,4.2538,5.1702}, /*cfx*/
          {0.6602,0.00196,452.9869,1.76326,0.006682,0.3005}, /*cmy*/
          {2.205957,0.8389,4.8346,5.2285}, /*cfy*/
          {-1.031,-0.00309,1070.2447,4.46554,0.012035,0.6462}, /*cmz*/
          {3.736269,2.1576,5.9494,0.4919} /*cfz*/
     },
     {
          2455317.4,
          {1.3053,-0.00287,965.9559,3.48527,0.016419,0.5628}, /*cmx*/
          {5.712044,4.1122,1.1177,5.8905}, /*cfx*/
          {0.5998,-0.00198,462.5928,1.45627,0.007921,0.2673}, /*cmy*/
          {5.780211,4.2564,1.4035,5.9638}, /*cfy*/
          {-0.637,-0.02455,1069.9482,3.76719,0.01827,0.5569}, /*cmz*/
          {1.012477,5.714,2.7824,1.2008} /*cfz*/
     },
     {
          2455357.4,
          {1.5117,-0.01265,965.4949,2.19448,0.024965,0.6033}, /*cmx*/
          {3.023815,1.4525,4.6107,0.4763}, /*cfx*/
          {0.6892,-0.00728,463.59,0.8586,0.011052,0.2895}, /*cmy*/
          {3.109654,1.4772,4.6439,0.5597}, /*cfy*/
          {-1.1094,-0.01599,1069.8727,2.31699,0.026364,0.6506}, /*cmz*/
          {4.610479,3.0204,6.1783,2.0671} /*cfz*/
     },
     {
          2455397.4,
          {1.5691,-0.00515,965.954,0.11407,0.025955,0.7532}, /*cmx*/
          {0.403095,5.4512,2.0376,1.5581}, /*cfx*/
          {0.6678,-0.0026,462.3874,0.06915,0.010788,0.3629}, /*cmy*/
          {0.502498,1.681,2.0779,1.6568}, /*cfy*/
          {-1.9641,0.00147,1069.527,0.0764,0.028219,0.8499}, /*cmz*/
          {1.992427,0.4312,3.5774,3.1069} /*cfz*/
     },
     {
          2455437.4,
          {1.4952,0.00699,965.6828,2.14152,0.00291,0.8556}, /*cmx*/
          {4.152097,5.7358,0.271,2.7736}, /*cfx*/
          {0.597,0.00392,463.7712,1.00101,0.002116,0.4152}, /*cmy*/
          {4.255811,5.7759,1.3031,2.8764}, /*cfy*/
          {-2.5113,0.00176,1069.5545,2.32003,0.003479,0.9828}, /*cmz*/
          {5.742691,1.0329,1.8246,4.3148} /*cfz*/
     },
     {
          2455477.4,
          {1.2935,0.02418,965.4101,2.21163,0.02555,1.0377}, /*cmx*/
          {1.671674,3.2549,0.1082,4.0424}, /*cfx*/
          {0.5178,0.01095,464.2903,0.924,0.011883,0.5007}, /*cmy*/
          {1.768338,3.408,0.2375,4.1369}, /*cfy*/
          {-2.6369,-0.0123,1069.7267,2.37095,0.027751,1.1247}, /*cmz*/
          {3.260754,4.8456,1.6908,5.5846} /*cfz*/
     },
     {
          2455517.4,
          {1.9473,0.01087,965.7706,0.01886,0.027587,1.1066}, /*cmx*/
          {5.432889,0.4425,3.8308,5.2862}, /*cfx*/
          {0.8419,0.00467,462.8531,0.0858,0.011915,0.5345}, /*cmy*/
          {5.519007,3.9811,3.9625,5.368}, /*cfy*/
          {-2.5178,-0.01198,1069.5373,0.04446,0.030133,1.2012}, /*cmz*/
          {0.736593,0.356,5.3989,0.5506} /*cfz*/
     },
     {
          2455557.4,
          {2.7903,-0.00193,965.1459,2.21949,0.017485,1.1116}, /*cmx*/
          {2.817371,1.2618,0.9743,0.208}, /*cfx*/
          {1.2405,-0.00012,463.4636,1.05696,0.007776,0.5329}, /*cmy*/
          {2.899963,1.3934,0.787,0.2963}, /*cfy*/
          {-2.5394,0.01666,1069.684,2.41772,0.019941,1.2177}, /*cmz*/
          {4.403474,2.8516,2.5395,1.7807} /*cfz*/
     },
     {
          2455597.4,
          {3.2791,-0.00677,965.5764,3.58051,0.010013,1.0836}, /*cmx*/
          {0.126655,4.8678,4.0286,1.3205}, /*cfx*/
          {1.4937,-0.00301,462.5174,1.6174,0.006899,0.5125}, /*cmy*/
          {0.215014,4.8799,3.5115,1.4149}, /*cfy*/
          {-2.0497,0.03658,1069.6996,3.94106,0.010874,1.2339}, /*cmz*/
          {1.714059,0.1459,5.5191,2.9053} /*cfz*/
     },
     {
          2455637.4,
          {3.14,0.00073,970.5705,4.14499,0.007013,1.0216}, /*cmx*/
          {3.679469,2.1489,0.5204,2.3913}, /*cfx*/
          {1.4148,0.00012,453.528,1.80768,0.006988,0.4665}, /*cmy*/
          {3.780727,1.9936,0.1564,2.501}, /*cfy*/
          {-1.1965,0.04101,1069.5645,4.54834,0.009652,1.1596}, /*cmz*/
          {5.268553,3.6961,1.9497,3.9504} /*cfz*/
     },
     {
          2455677.4,
          {2.6893,0.00205,980.0887,4.14031,0.009462,0.8817}, /*cmx*/
          {0.939261,5.7143,3.2352,3.4604}, /*cfx*/
          {1.1787,-0.00046,433.2222,1.7384,0.007234,0.3802}, /*cmy*/
          {1.058542,5.3713,3.1271,3.5962}, /*cfy*/
          {0.087,0.01386,1069.3705,4.47391,0.01146,1.0097}, /*cmz*/
          {2.529392,0.9518,4.8249,5.0434} /*cfz*/
     },
     {
          2455717.4,
          {2.2259,-0.00278,992.4971,3.61345,0.016233,0.7111}, /*cmx*/
          {4.496245,3.004,0.0594,4.4498}, /*cfx*/
          {0.9645,-0.00405,404.5042,1.45728,0.007988,0.2754}, /*cmy*/
          {4.637339,2.472,6.0471,4.6359}, /*cfy*/
          {0.9683,-0.0132,1069.1621,3.82902,0.017,0.8387}, /*cmz*/
          {6.086713,4.5015,1.5881,6.0405} /*cfz*/
     },
     {
          2455757.4,
          {2.162,-0.01829,1003.898,2.34973,0.024453,0.6178}, /*cmx*/
          {1.806467,0.3307,3.502,5.4753}, /*cfx*/
          {0.8509,-0.00855,375.8213,0.90822,0.010047,0.2259}, /*cmy*/
          {1.970897,5.893,2.8632,5.6364}, /*cfy*/
          {1.0787,-0.02184,1069.0594,2.49758,0.026457,0.6667}, /*cmz*/
          {3.397382,1.8004,4.9557,0.7526} /*cfz*/
     },
     {
          2455797.4,
          {2.0722,-0.01545,1009.6188,0.26679,0.027404,0.6014}, /*cmx*/
          {5.464449,4.091,0.8774,0.0398}, /*cfx*/
          {0.7551,-0.00605,360.4048,0.0759,0.010621,0.2145}, /*cmy*/
          {5.646678,2.5251,0.1769,0.2072}, /*cfy*/
          {0.3302,-0.00723,1068.3577,0.29013,0.029864,0.621}, /*cmz*/
          {0.77262,5.5718,2.375,1.7006} /*cfz*/
     },
     {
          2455837.4,
          {1.7866,0.005,1006.9789,2.10217,0.004936,0.6122}, /*cmx*/
          {2.925129,4.6029,5.0281,0.9429}, /*cfx*/
          {0.5825,0.00465,368.9343,0.86377,0.001644,0.2322}, /*cmy*/
          {3.108065,3.9788,4.8154,1.1785}, /*cfy*/
          {-0.4107,-0.00542,1068.3306,2.257,0.005655,0.6309}, /*cmz*/
          {4.517155,6.0792,0.3911,2.587} /*cfz*/
     },
     {
          2455877.4,
          {1.5851,0.02652,998.3489,2.36277,0.025585,0.7887}, /*cmx*/
          {0.443303,2.133,5.2612,2.0505}, /*cfx*/
          {0.5664,0.01053,391.618,0.89963,0.010736,0.3115}, /*cmy*/
          {0.609887,1.5644,4.7529,2.1947}, /*cfy*/
          {-1.0164,-0.00776,1068.6956,2.52366,0.027978,0.8147}, /*cmz*/
          {2.035992,3.6174,0.4571,3.7174} /*cfz*/
     },
     {
          2455917.4,
          {2.0687,0.01989,992.8087,0.13774,0.027854,0.9124}, /*cmx*/
          {4.20888,5.7438,2.6965,3.1964}, /*cfx*/
          {0.7788,0.00683,403.3566,0.089,0.011303,0.3654}, /*cmy*/
          {4.358999,3.3919,2.1433,3.3405}, /*cfy*/
          {-0.9939,-0.01629,1068.8102,0.14194,0.030599,0.9915}, /*cmz*/
          {5.800504,0.9323,4.2039,4.8644} /*cfz*/
     },
     {
          2455957.4,
          {3.0456,4e-05,996.019,2.12049,0.018877,1.0207}, /*cmx*/
          {1.598876,0.1448,6.1356,4.4009}, /*cfx*/
          {1.1623,-0.00288,394.8026,0.95353,0.008081,0.3912}, /*cmy*/
          {1.744506,5.9579,5.2604,4.5579}, /*cfy*/
          {-1.0275,0.00537,1068.9716,2.32661,0.019223,1.0836}, /*cmz*/
          {3.189424,1.6344,1.349,5.9989} /*cfz*/
     },
     {
          2455997.4,
          {3.6615,-0.00726,1006.8981,3.54529,0.011069,1.1743}, /*cmx*/
          {5.198097,3.7357,2.9426,5.5125}, /*cfx*/
          {1.268,-0.00449,366.6006,1.49672,0.00736,0.3927}, /*cmy*/
          {5.353116,3.0913,1.7653,5.6765}, /*cfy*/
          {-0.7143,0.02971,1068.7869,3.83275,0.011107,1.2074}, /*cmz*/
          {0.504014,5.2268,4.2989,0.8244} /*cfz*/
     },
     {
          2456037.4,
          {3.7489,-0.00666,1022.8118,4.21153,0.008446,1.2399}, /*cmx*/
          {2.475786,1.0037,5.6468,0.3154}, /*cfx*/
          {1.1729,-0.00586,320.711,1.73964,0.007835,0.3546}, /*cmy*/
          {2.654436,0.1654,4.7167,0.4872}, /*cfy*/
          {0.0055,0.04507,1068.8516,4.43736,0.009336,1.2634}, /*cmz*/
          {4.062278,2.4928,0.8185,1.9057} /*cfz*/
     },
     {
          2456077.4,
          {3.1772,-0.00029,1039.4745,4.24145,0.010939,1.2186}, /*cmx*/
          {6.025872,4.5456,2.212,1.4472}, /*cfx*/
          {0.8291,-0.00269,261.65,1.75637,0.007373,0.271}, /*cmy*/
          {6.247045,3.5011,1.4478,1.6996}, /*cfy*/
          {1.2615,0.02716,1069.0611,4.39963,0.010348,1.1828}, /*cmz*/
          {1.326163,6.0296,3.6467,3.0107} /*cfz*/
     },
     {
          2456117.4,
          {2.5125,-0.00495,1053.2415,3.70702,0.016199,1.161}, /*cmx*/
          {3.304538,1.8032,5.2345,2.5531}, /*cfx*/
          {0.6052,-0.00546,198.7576,1.56407,0.007365,0.1799}, /*cmy*/
          {3.597775,0.579,4.2429,2.9097}, /*cfy*/
          {2.3886,0.00022,1069.1198,3.84269,0.016741,1.108}, /*cmz*/
          {4.885,3.2969,0.3699,4.1059} /*cfz*/
     },
     {
          2456157.4,
          {2.0675,-0.01869,1062.0044,2.461,0.024965,1.0107}, /*cmx*/
          {0.617045,5.3681,2.2482,3.722}, /*cfx*/
          {0.3901,-0.00329,146.3535,1.07901,0.010738,0.1256}, /*cmy*/
          {1.020495,4.0136,0.9438,4.0913}, /*cfy*/
          {2.9808,-0.02186,1068.9495,2.56469,0.026493,0.9973}, /*cmz*/
          {2.194925,0.609,3.7775,5.2932} /*cfz*/
     },
     {
          2456197.4,
          {1.8371,-0.02224,1065.0566,0.34281,0.029105,0.8812}, /*cmx*/
          {4.274457,2.786,5.9079,4.8877}, /*cfx*/
          {0.3112,-0.00241,120.9696,0.17951,0.012298,0.1021}, /*cmy*/
          {4.773832,1.2848,4.5343,5.3319}, /*cfy*/
          {2.5404,-0.0143,1068.5233,0.34617,0.029691,0.8825}, /*cmz*/
          {5.850659,4.38,1.1753,0.1511} /*cfz*/
     },
     {
          2456237.4,
          {1.3946,0.00292,1063.5916,2.14012,0.006769,0.6726}, /*cmx*/
          {1.733111,3.3501,3.8582,5.9549}, /*cfx*/
          {0.2377,0.00277,132.8539,0.88749,0.002872,0.0979}, /*cmy*/
          {2.187199,2.0048,2.6986,0.2092}, /*cfy*/
          {1.6466,-0.00316,1068.8355,2.23291,0.005898,0.6828}, /*cmz*/
          {3.309858,4.8801,5.3796,1.1946} /*cfz*/
     },
     {
          2456277.4,
          {1.2606,0.02059,1058.2179,2.4722,0.025912,0.6196}, /*cmx*/
          {5.533217,0.9046,4.0131,0.7146}, /*cfx*/
          {0.2727,0.00291,171.1621,1.02058,0.010679,0.1111}, /*cmy*/
          {5.874335,5.8875,2.7868,0.9295}, /*cfy*/
          {0.9297,-0.00191,1069.1554,2.573,0.027388,0.6595}, /*cmz*/
          {0.828682,2.4229,5.5536,2.1963} /*cfz*/
     },
     {
          2456317.4,
          {1.4247,0.02433,1053.6138,0.24158,0.029094,0.6732}, /*cmx*/
          {3.016132,4.5517,1.4854,1.6239}, /*cfx*/
          {0.3115,0.00232,194.778,0.13823,0.012194,0.1245}, /*cmy*/
          {3.301133,2.6774,0.2476,1.8711}, /*cfy*/
          {0.8099,-0.01634,1068.9884,0.21536,0.029477,0.6944}, /*cmz*/
          {4.596041,6.121,3.0105,3.0808} /*cfz*/
     },
     {
          2456357.4,
          {2.2847,0.00315,1056.1779,2.09478,0.019043,0.7737}, /*cmx*/
          {0.410533,5.2132,4.9162,2.5287}, /*cfx*/
          {0.412,-0.00294,180.0953,0.88919,0.008795,0.1192}, /*cmy*/
          {0.70371,4.0727,3.4378,2.9232}, /*cfy*/
          {0.7791,-0.0105,1068.9853,2.18921,0.018807,0.7934}, /*cmz*/
          {1.989353,0.4421,0.1457,4.0968} /*cfz*/
     },
     {
          2456397.4,
          {2.9635,-0.00759,1063.1649,3.55242,0.011415,0.988}, /*cmx*/
          {4.016591,2.5048,1.6203,3.5573}, /*cfx*/
          {0.3798,-0.00448,132.8387,1.52275,0.007495,0.0908}, /*cmy*/
          {4.398882,1.2076,0.0075,4.025}, /*cfy*/
          {0.72,0.01709,1068.952,3.63263,0.011408,1.0173}, /*cmz*/
          {5.592651,4.0364,3.1867,5.1162} /*cfz*/
     },
     {
          2456437.4,
          {3.2184,-0.01361,1069.0153,4.22474,0.010256,1.1661}, /*cmx*/
          {1.301443,6.0383,4.3243,4.5874}, /*cfx*/
          {0.1863,-0.00376,69.9903,1.83127,0.007378,0.0464}, /*cmy*/
          {2.034854,4.5944,2.9232,5.8382}, /*cfy*/
          {1.1293,0.03809,1069.355,4.27021,0.008277,1.1717}, /*cmz*/
          {2.874125,1.302,5.9708,6.1588} /*cfz*/
     },
     {
          2456477.4,
          {2.6504,-0.00347,1070.0805,4.1939,0.011014,1.2002}, /*cmx*/
          {4.856936,3.268,1.0104,5.6467}, /*cfx*/
          {0.0143,-0.00309,51.8426,1.86298,0.007141,0.097}, /*cmy*/
          {0.713062,1.6919,5.8312,1.8747}, /*cfy*/
          {2.0153,0.03525,1069.6653,4.29397,0.010111,1.2464}, /*cmz*/
          {0.14364,4.8471,2.4257,0.9837} /*cfz*/
     },
     {
          2456517.4,
          {1.9059,-0.00596,1065.6386,3.66698,0.016115,1.2623}, /*cmx*/
          {2.139183,0.505,3.9059,0.5017}, /*cfx*/
          {-0.0725,-0.00181,110.29,1.61834,0.007717,0.1687}, /*cmy*/
          {4.909554,5.0946,2.356,3.3877}, /*cfy*/
          {3.1864,0.00951,1069.6552,3.7521,0.016731,1.31}, /*cmz*/
          {3.706545,2.1263,5.4983,2.1097} /*cfz*/
     },
     {
          2456557.4,
          {1.2258,-0.01351,1058.6745,2.43629,0.025929,1.2312}, /*cmx*/
          {5.737169,4.0713,0.9454,1.7113}, /*cfx*/
          {-0.0556,0.00112,163.5008,1.06617,0.011057,0.2056}, /*cmy*/
          {2.370817,2.2972,5.4316,4.6511}, /*cfy*/
          {4.0086,-0.01702,1069.7123,2.47762,0.026348,1.2642}, /*cmz*/
          {1.019725,5.723,2.6057,3.3077} /*cfz*/
     },
     {
          2456597.4,
          {0.9464,-0.02264,1054.0463,0.26597,0.028771,1.1818}, /*cmx*/
          {3.113333,1.5319,4.6395,2.974}, /*cfx*/
          {-0.0529,0.00409,188.3402,0.14951,0.012562,0.2038}, /*cmy*/
          {6.073985,0.055,2.7941,5.9335}, /*cfy*/
          {3.9395,-0.01635,1069.7871,0.22735,0.028504,1.2302}, /*cmz*/
          {4.6784,3.1862,6.2767,4.5443} /*cfz*/
     },
     {
          2456637.4,
          {0.6166,-0.0063,1056.3649,2.20436,0.005882,1.0544}, /*cmx*/
          {0.574486,2.0635,2.7691,4.1805}, /*cfx*/
          {0.046,-0.00033,174.7711,0.94651,0.003632,0.1684}, /*cmy*/
          {3.526506,0.1808,1.0968,0.7396}, /*cfy*/
          {3.0899,0.00531,1069.8469,2.24339,0.005357,1.0316}, /*cmz*/
          {2.14053,3.714,4.1843,5.7923} /*cfz*/
     },
     {
          2456677.4,
          {0.3839,0.00896,1062.5902,2.46337,0.02655,0.9092}, /*cmx*/
          {4.374903,5.909,2.7457,5.4548}, /*cfx*/
          {0.0363,-0.00107,134.0662,1.08532,0.011113,0.0946}, /*cmy*/
          {0.984646,4.1385,0.9653,2.0849}, /*cfy*/
          {2.6166,0.001,1070.1016,2.46908,0.026122,0.9053}, /*cmz*/
          {5.942341,1.2522,4.3799,0.8095} /*cfz*/
     },
     {
          2456717.4,
          {0.2139,0.01835,1065.3611,0.22256,0.028438,0.7583}, /*cmx*/
          {1.85633,3.3292,0.2202,0.237}, /*cfx*/
          {0.0691,-0.00338,108.525,0.1322,0.012396,0.0776}, /*cmy*/
          {4.688945,1.4276,4.7623,3.1424}, /*cfy*/
          {2.3997,-0.01544,1069.6951,0.21009,0.028421,0.749}, /*cmz*/
          {3.42435,4.8862,1.825,1.8986} /*cfz*/
     },
     {
          2456757.4,
          {0.5973,0.00606,1063.6845,2.0686,0.017703,0.6339}, /*cmx*/
          {5.534651,3.9303,3.6362,1.1305}, /*cfx*/
          {-0.021,-0.00125,122.8174,0.87656,0.008194,0.0894}, /*cmy*/
          {2.133123,2.2299,1.7121,3.9515}, /*cfy*/
          {2.2883,-0.02385,1069.6024,2.09266,0.018274,0.6378}, /*cmz*/
          {0.818994,5.5591,5.2649,2.759} /*cfz*/
     },
     {
          2456797.4,
          {1.2136,-0.00795,1057.0356,3.45828,0.010695,0.7181}, /*cmx*/
          {2.860342,1.2318,0.3139,1.9312}, /*cfx*/
          {-0.1179,-0.00155,169.2928,1.48721,0.006342,0.1424}, /*cmy*/
          {5.832578,5.7043,4.4615,4.9842}, /*cfy*/
          {1.865,-0.00045,1069.9544,3.47892,0.010726,0.7135}, /*cmz*/
          {4.426765,2.8629,2.1201,3.5189} /*cfz*/
     },
     {
          2456837.4,
          {1.5039,-0.01237,1045.2463,4.03898,0.008934,0.8506}, /*cmx*/
          {0.147811,4.776,3.1208,2.7805}, /*cfx*/
          {-0.3173,0.00231,230.6631,1.72657,0.006674,0.2083}, /*cmy*/
          {3.185398,2.8341,1.0504,5.838}, /*cfy*/
          {1.7871,0.02215,1070.2128,4.14333,0.007614,0.8524}, /*cmz*/
          {1.71401,0.1401,4.7627,4.3353} /*cfz*/
     },
     {
          2456877.4,
          {1.2562,-0.00502,1030.2689,4.02564,0.009519,0.9568}, /*cmx*/
          {3.705597,2.0224,5.8619,3.7643}, /*cfx*/
          {-0.3101,-0.00048,291.5239,1.68872,0.006406,0.2992}, /*cmy*/
          {0.502237,6.2205,4.0152,0.5661}, /*cfy*/
          {2.1041,0.03463,1070.2495,4.16328,0.010212,0.9928}, /*cmz*/
          {5.272081,3.6974,1.2773,5.2654} /*cfz*/
     },
     {
          2456917.4,
          {0.6297,-0.00064,1014.803,3.47631,0.016291,1.1032}, /*cmx*/
          {0.989363,5.5812,2.6203,4.8537}, /*cfx*/
          {-0.1952,-4e-05,341.3028,1.43247,0.007248,0.3974}, /*cmy*/
          {4.098322,3.344,0.5091,1.7003}, /*cfy*/
          {3.057,0.01508,1070.3666,3.59307,0.016619,1.1617}, /*cmz*/
          {2.556762,0.9755,4.3261,0.0854} /*cfz*/
     },
     {
          2456957.4,
          {0.0474,-0.00458,1002.9503,2.22911,0.026023,1.1663}, /*cmx*/
          {4.590118,2.9027,6.0591,6.0185}, /*cfx*/
          {0.0055,0.001,374.1298,0.89196,0.010955,0.4434}, /*cmy*/
          {1.436618,0.5698,3.6544,2.8702}, /*cfy*/
          {3.9186,-0.00835,1070.4055,2.27856,0.026522,1.24}, /*cmz*/
          {6.159148,4.5733,1.4421,1.2667} /*cfz*/
     },
     {
          2456997.4,
          {-0.1663,-0.0164,997.7276,0.04586,0.026137,1.2534}, /*cmx*/
          {1.971464,0.981,3.496,0.995}, /*cfx*/
          {0.0637,0.00615,386.8052,0.10025,0.01117,0.4805}, /*cmy*/
          {5.114244,6.1062,1.1313,4.139}, /*cfy*/
          {4.2408,-0.01456,1070.4701,0.00849,0.027393,1.2952}, /*cmz*/
          {3.542488,2.0101,5.133,2.5469} /*cfz*/
     },
     {
          2457037.4,
          {-0.1836,-0.01921,1001.3683,2.22142,0.003018,1.2084}, /*cmx*/
          {5.722587,0.9121,1.8344,2.2652}, /*cfx*/
          {0.0997,0.00497,377.7718,0.98991,0.002921,0.452}, /*cmy*/
          {2.58614,4.7628,0.0367,5.4165}, /*cfy*/
          {3.7289,0.00919,1070.2951,2.33092,0.003606,1.3403}, /*cmz*/
          {1.010972,2.5784,3.5099,3.8083} /*cfz*/
     },
     {
          2457077.4,
          {-0.6326,-0.00085,1010.7974,2.24471,0.025302,1.1473}, /*cmx*/
          {3.24107,4.735,1.5931,3.6484}, /*cfx*/
          {0.2005,0.00097,353.1504,0.96644,0.011077,0.3836}, /*cmy*/
          {0.099079,2.4657,5.5365,0.5088}, /*cfy*/
          {3.4677,0.0062,1070.3907,2.32686,0.02627,1.2251}, /*cmz*/
          {4.811968,0.1118,3.2337,5.1668} /*cfz*/
     },
     {
          2457117.4,
          {-1.0751,0.01045,1015.7537,0.10123,0.026123,1.0299}, /*cmx*/
          {0.718366,2.0733,5.3101,4.8793}, /*cfx*/
          {0.3612,-0.0033,337.6395,0.0459,0.011107,0.3445}, /*cmy*/
          {3.852075,0.5175,3.0421,1.7362}, /*cfy*/
          {3.3362,-0.01236,1070.2155,0.11026,0.027481,1.1204}, /*cmz*/
          {2.288347,3.6173,0.6784,0.1189} /*cfz*/
     },
     {
          2457157.4,
          {-1.182,0.0069,1012.0046,2.03084,0.015732,0.8712}, /*cmx*/
          {4.394081,2.7448,2.453,5.9959}, /*cfx*/
          {0.4123,-0.00153,347.9913,0.86431,0.006953,0.3132}, /*cmy*/
          {1.245347,0.4412,6.25,2.8323}, /*cfy*/
          {3.1837,-0.03124,1070.1392,2.08343,0.017409,0.9175}, /*cmz*/
          {5.963858,4.4122,4.1458,1.206} /*cfz*/
     },
     {
          2457197.4,
          {-0.7852,-0.00821,1001.7535,3.25422,0.009522,0.7568}, /*cmx*/
          {1.718779,0.061,5.5812,0.6325}, /*cfx*/
          {0.2984,0.00338,376.5474,1.3902,0.005972,0.2993}, /*cmy*/
          {4.862885,3.9589,2.7545,3.7998}, /*cfy*/
          {2.566,-0.02055,1070.3912,3.4356,0.009708,0.8155}, /*cmz*/
          {3.290018,1.7215,0.9727,2.1939} /*cfz*/
     },
     {
          2457237.4,
          {-0.5338,-0.00811,989.056,3.80236,0.006299,0.6281}, /*cmx*/
          {5.289613,3.6321,1.9863,1.392}, /*cfx*/
          {0.2057,0.00386,409.2545,1.61664,0.00575,0.269}, /*cmy*/
          {2.165117,1.1028,5.6656,4.5611}, /*cfy*/
          {1.882,0.00318,1070.1978,4.05857,0.008042,0.7315}, /*cmz*/
          {0.579988,5.2959,3.6005,2.9708} /*cfz*/
     },
     {
          2457277.4,
          {-0.4479,-0.00228,977.7304,3.80589,0.009093,0.6384}, /*cmx*/
          {2.565152,0.919,4.5847,2.102}, /*cfx*/
          {0.1759,0.00056,436.2778,1.61094,0.005671,0.2927}, /*cmy*/
          {5.740613,4.5118,2.1883,5.279}, /*cfy*/
          {1.5622,0.02544,1070.234,4.05544,0.010178,0.7008}, /*cmz*/
          {4.141554,2.5663,0.0903,3.7212} /*cfz*/
     },
     {
          2457317.4,
          {-0.7727,0.00857,970.0599,3.21912,0.016412,0.775}, /*cmx*/
          {6.134157,4.5099,1.5111,3.0021}, /*cfx*/
          {0.3229,-0.00496,453.2676,1.34305,0.007718,0.3658}, /*cmy*/
          {3.043767,1.6758,5.0593,6.2023}, /*cfy*/
          {2.0169,0.01826,1070.386,3.43184,0.017147,0.8443}, /*cmz*/
          {1.43086,6.1253,3.1371,4.6727} /*cfz*/
     },
     {
          2457357.4,
          {-1.0272,0.0045,966.4053,1.91734,0.025262,0.8929}, /*cmx*/
          {3.457272,1.8603,5.0144,4.057}, /*cfx*/
          {0.4051,-0.00236,460.7524,0.74982,0.011207,0.4259}, /*cmy*/
          {0.382945,5.219,2.0667,0.992}, /*cfy*/
          {2.7986,0.00115,1070.1512,2.05223,0.027703,0.9992}, /*cmz*/
          {5.040579,3.4448,0.3022,5.6907} /*cfz*/
     },
     {
          2457397.4,
          {-1.0789,-0.0089,965.7185,0.24814,0.023186,1.0362}, /*cmx*/
          {0.848246,2.3526,2.443,5.2838}, /*cfx*/
          {0.3992,0.00428,462.6105,0.21673,0.009608,0.4933}, /*cmy*/
          {4.068734,5.5507,5.8351,2.2252}, /*cfy*/
          {3.398,-0.00639,1069.7299,0.27824,0.025844,1.1582}, /*cmz*/
          {2.43406,3.925,4.0515,0.6306} /*cfz*/
     },
     {
          2457437.4,
          {-0.8968,-0.02435,966.6149,2.24454,0.002211,1.2041}, /*cmx*/
          {4.607745,6.1612,2.1581,0.2731}, /*cfx*/
          {0.3105,0.01091,461.0452,1.03824,0.002705,0.5689}, /*cmy*/
          {1.547923,3.2348,5.5711,3.4964}, /*cfy*/
          {3.4687,0.00759,1069.7541,2.44846,0.003459,1.3029}, /*cmz*/
          {6.193843,1.4787,3.6954,1.887} /*cfz*/
     },
     {
          2457477.4,
          {-1.3745,-0.00833,969.3957,1.97036,0.023936,1.195}, /*cmx*/
          {2.125941,3.6747,0.533,1.6216}, /*cfx*/
          {0.5275,0.00414,455.2327,0.82669,0.010982,0.5531}, /*cmy*/
          {5.342528,0.8814,3.9844,4.8269}, /*cfy*/
          {3.3375,0.01308,1069.9939,2.14191,0.026804,1.2826}, /*cmz*/
          {3.710054,5.2916,2.1374,3.2327} /*cfz*/
     },
     {
          2457517.4,
          {-1.9975,0.00367,970.9905,0.07511,0.023823,1.2036}, /*cmx*/
          {5.879621,4.619,4.22,2.8911}, /*cfx*/
          {0.8251,-0.00093,450.9019,0.10223,0.010192,0.5571}, /*cmy*/
          {2.804355,1.371,1.3928,6.0962}, /*cfy*/
          {3.3628,-0.00481,1070.0393,0.08119,0.026346,1.289}, /*cmz*/
          {1.178893,6.0225,5.8613,4.5007} /*cfz*/
     },
     {
          2457557.4,
          {-2.4519,0.00483,969.1758,1.99071,0.015152,1.1217}, /*cmx*/
          {3.266832,1.6809,1.4028,4.032}, /*cfx*/
          {1.0692,-0.00153,454.2498,0.93191,0.006698,0.5299}, /*cmy*/
          {0.18929,5.1192,4.579,0.9514}, /*cfy*/
          {3.2651,-0.0293,1069.9935,2.18619,0.016141,1.222}, /*cmz*/
          {4.849252,3.2876,3.0245,5.6715} /*cfz*/
     },
     {
          2457597.4,
          {-2.401,-0.00721,966.3656,3.15323,0.008504,1.0447}, /*cmx*/
          {0.589435,5.2836,4.6325,5.1655}, /*cfx*/
          {1.0584,0.00484,461.0972,1.41643,0.005378,0.5016}, /*cmy*/
          {3.800558,2.3427,1.1722,2.1}, /*cfy*/
          {2.7064,-0.03667,1069.883,3.46885,0.009634,1.1415}, /*cmz*/
          {2.173343,0.6086,6.0586,0.4815} /*cfz*/
     },
     {
          2457637.4,
          {-2.2171,-0.00754,965.2529,3.70324,0.005558,0.9036}, /*cmx*/
          {4.159979,2.5916,0.8845,6.1623}, /*cfx*/
          {1.0119,0.00344,463.8903,1.62772,0.005437,0.4313}, /*cmy*/
          {1.099365,5.7919,3.9543,3.1084}, /*cfy*/
          {1.5774,-0.01575,1069.6346,4.02696,0.008123,0.9495}, /*cmz*/
          {5.745811,4.1793,2.4969,1.4706} /*cfz*/
     },
     {
          2457677.4,
          {-1.976,-0.00149,967.9763,3.71286,0.009665,0.7081}, /*cmx*/
          {1.437138,6.1769,3.5082,0.808}, /*cfx*/
          {0.9088,-0.00064,458.6269,1.58573,0.006334,0.3288}, /*cmy*/
          {4.675146,2.9359,0.515,4.0539}, /*cfy*/
          {0.6711,0.00961,1069.7181,4.0016,0.010513,0.7868}, /*cmz*/
          {3.025294,1.4448,5.1475,2.385} /*cfz*/
     },
     {
          2457717.4,
          {-2.0268,0.01592,974.1645,3.05124,0.01675,0.6445}, /*cmx*/
          {5.010541,3.4891,0.4746,1.7559}, /*cfx*/
          {0.903,-0.00913,446.1674,1.24558,0.007871,0.2961}, /*cmy*/
          {1.983037,0.0858,3.484,5.0116}, /*cfy*/
          {0.3963,0.02002,1069.6844,3.31001,0.018854,0.7069}, /*cmz*/
          {0.317981,5.008,1.9767,3.2329} /*cfz*/
     },
     {
          2457757.4,
          {-1.9622,0.01483,980.426,1.66762,0.025717,0.6708}, /*cmx*/
          {2.342419,0.8339,3.9701,2.5525}, /*cfx*/
          {0.8056,-0.00715,432.7338,0.62249,0.010831,0.2955}, /*cmy*/
          {5.61529,3.5666,0.4884,5.833}, /*cfy*/
          {0.984,0.00781,1069.0336,1.80257,0.028574,0.7045}, /*cmz*/
          {3.934767,2.352,5.4986,4.0626} /*cfz*/
     },
     {
          2457797.4,
          {-1.7174,-0.00253,982.6186,0.52771,0.021316,0.7639}, /*cmx*/
          {6.02829,1.3771,1.4294,3.5657}, /*cfx*/
          {0.6264,0.00232,428.246,0.30042,0.008331,0.3368}, /*cmy*/
          {3.029304,4.2751,4.2671,0.5852}, /*cfy*/
          {1.7386,0.00073,1068.6591,0.60287,0.023103,0.8439}, /*cmz*/
          {1.338493,2.853,2.9866,5.0934} /*cfz*/
     },
     {
          2457837.4,
          {-1.4214,-0.02306,978.9991,2.32143,0.005116,0.9771}, /*cmx*/
          {3.512131,5.16,1.6883,4.7399}, /*cfx*/
          {0.5116,0.0103,436.8547,0.99767,0.003224,0.4448}, /*cmy*/
          {0.512049,1.7496,4.5224,1.7243}, /*cfy*/
          {2.2906,0.00516,1068.7715,2.55261,0.006643,1.0682}, /*cmz*/
          {5.106073,0.3928,3.1603,0.0033} /*cfz*/
     },
     {
          2457877.4,
          {-1.7484,-0.01489,973.521,1.77039,0.024001,1.0225}, /*cmx*/
          {1.027175,2.6572,5.7865,5.9541}, /*cfx*/
          {0.6731,0.00643,447.7554,0.68801,0.010572,0.4744}, /*cmy*/
          {4.298867,5.5862,2.4621,2.9402}, /*cfy*/
          {2.2911,0.02086,1069.2036,1.92386,0.026939,1.1663}, /*cmz*/
          {2.620425,4.2077,1.0699,1.2699} /*cfz*/
     },
     {
          2457917.4,
          {-2.4692,-0.00193,971.724,0.2444,0.02351,1.1275}, /*cmx*/
          {4.772255,3.3412,3.1988,0.9368}, /*cfx*/
          {1.0212,0.00022,451.1129,0.2022,0.009822,0.5224}, /*cmy*/
          {1.749962,0.1415,6.1076,4.2007}, /*cfy*/
          {2.5062,0.00541,1069.3069,0.32886,0.024793,1.2832}, /*cmz*/
          {0.0811,4.8319,4.7525,2.5004} /*cfz*/
     },
     {
          2457957.4,
          {-3.1341,0.00093,974.0535,2.09553,0.01509,1.2045}, /*cmx*/
          {2.153087,0.6507,0.3932,2.0911}, /*cfx*/
          {1.3012,-0.00058,445.8872,0.9708,0.006522,0.543}, /*cmy*/
          {5.41148,3.6046,2.9587,5.3528}, /*cfy*/
          {2.5823,-0.02279,1069.1509,2.33703,0.015742,1.3607}, /*cmz*/
          {3.744319,2.1904,1.8583,3.648} /*cfz*/
     },
     {
          2457997.4,
          {-3.432,-0.00634,981.0044,3.27007,0.008356,1.2223}, /*cmx*/
          {5.756023,4.258,3.5431,3.2251}, /*cfx*/
          {1.403,0.00168,431.028,1.42607,0.005668,0.5243}, /*cmy*/
          {2.737882,0.7934,5.7261,0.2164}, /*cfy*/
          {2.1841,-0.04348,1069.0345,3.57014,0.009733,1.3776}, /*cmz*/
          {1.063631,5.7845,4.8869,4.8005} /*cfz*/
     },
     {
          2458037.4,
          {-3.35,-0.00965,992.2195,3.81992,0.006872,1.1784}, /*cmx*/
          {3.042667,1.5634,6.0661,4.2861}, /*cfx*/
          {1.2991,0.00204,404.5599,1.59743,0.006482,0.4553}, /*cmy*/
          {0.039223,4.2076,2.3485,1.3014}, /*cfy*/
          {0.9425,-0.02993,1069.1149,4.08057,0.007674,1.2939}, /*cmz*/
          {4.632787,3.0599,1.3276,5.8734} /*cfz*/
     },
     {
          2458077.4,
          {-3.1344,-0.00177,1006.6084,3.77214,0.010796,1.0783}, /*cmx*/
          {0.321535,5.1333,2.5112,5.3558}, /*cfx*/
          {1.1739,-0.00368,367.7349,1.52919,0.006585,0.3608}, /*cmy*/
          {3.623299,1.2985,5.2725,2.3851}, /*cfy*/
          {-0.3251,-0.00764,1069.1587,4.02345,0.01174,1.132}, /*cmz*/
          {1.911066,0.3266,3.917,0.6716} /*cfz*/
     },
     {
          2458117.4,
          {-2.9417,0.01706,1021.0231,3.03496,0.018575,0.9443}, /*cmx*/
          {3.900319,2.4184,5.6538,0.1589}, /*cfx*/
          {0.9682,-0.00715,327.2102,1.22157,0.008021,0.2903}, /*cmy*/
          {0.947423,4.676,1.7923,3.4907}, /*cfy*/
          {-1.2363,0.0156,1068.9442,3.22138,0.020486,0.9946}, /*cmz*/
          {5.488643,3.9021,0.8666,1.8031} /*cfz*/
     },
     {
          2458157.4,
          {-2.7041,0.02375,1030.6465,1.5,0.027081,0.7903}, /*cmx*/
          {1.240661,6.0409,2.8894,1.1614}, /*cfx*/
          {0.8244,-0.00791,295.8046,0.59937,0.010923,0.2181}, /*cmy*/
          {4.60026,1.8482,5.0903,4.5504}, /*cfy*/
          {-1.0479,0.01014,1068.5049,1.55681,0.028286,0.8455}, /*cmz*/
          {2.82767,1.2492,4.3952,2.8248} /*cfz*/
     },
     {
          2458197.4,
          {-2.1978,0.00492,1032.547,0.78515,0.020357,0.6946}, /*cmx*/
          {4.936361,0.2923,0.3997,2.148}, /*cfx*/
          {0.6137,0.00021,288.8523,0.33031,0.007758,0.1933}, /*cmy*/
          {2.025873,2.6218,2.6297,5.5489}, /*cfy*/
          {-0.2999,0.00173,1068.3248,0.86364,0.020538,0.7329}, /*cmz*/
          {0.240149,1.7822,1.8996,3.8143} /*cfz*/
     },
     {
          2458237.4,
          {-1.8038,-0.01462,1026.4951,2.44163,0.00819,0.7442}, /*cmx*/
          {2.425604,4.1,0.6828,3.1703}, /*cfx*/
          {0.5361,0.00438,309.7751,0.96739,0.003734,0.2402}, /*cmy*/
          {5.783619,0.089,2.9898,0.1925}, /*cfy*/
          {0.4231,0.00274,1068.6517,2.60877,0.00935,0.8022}, /*cmz*/
          {4.013759,5.597,2.2699,4.8158} /*cfz*/
     },
     {
          2458277.4,
          {-1.7782,-0.01976,1017.7724,1.66594,0.025873,0.8169}, /*cmx*/
          {6.219647,1.615,4.7451,4.2144}, /*cfx*/
          {0.539,0.0061,336.6095,0.62464,0.010531,0.2761}, /*cmy*/
          {3.269443,3.8922,0.8545,1.2558}, /*cfy*/
          {0.5893,0.0238,1068.6825,1.71882,0.026875,0.8309}, /*cmz*/
          {1.525987,3.1101,6.2581,5.7903} /*cfz*/
     },
     {
          2458317.4,
          {-2.446,-0.00657,1015.0633,0.46724,0.023856,0.9825}, /*cmx*/
          {3.673184,2.2201,2.1535,5.3176}, /*cfx*/
          {0.7784,-0.00019,344.3721,0.265,0.009405,0.3218}, /*cmy*/
          {0.708246,4.925,4.4391,2.3523}, /*cfy*/
          {0.8971,0.01686,1068.7224,0.54787,0.024546,0.977}, /*cmz*/
          {5.262112,3.7608,3.613,0.6514} /*cfz*/
     },
     {
          2458357.4,
          {-3.2159,-0.00063,1020.5138,2.35901,0.01532,1.1714}, /*cmx*/
          {1.047094,5.8714,5.5453,0.1317}, /*cfx*/
          {0.9482,-0.00187,327.3418,1.00395,0.007087,0.3544}, /*cmy*/
          {4.367308,1.9816,1.1891,3.4397}, /*cfy*/
          {1.23,-0.01311,1068.7165,2.51335,0.015892,1.166}, /*cmz*/
          {2.634298,1.0835,0.703,1.7349} /*cfz*/
     },
     {
          2458397.4,
          {-3.7629,-0.0021,1032.2362,3.57149,0.009221,1.3041}, /*cmx*/
          {4.645557,3.1778,2.205,1.2494}, /*cfx*/
          {0.9848,-0.00332,288.1659,1.47749,0.007152,0.3297}, /*cmy*/
          {1.703135,5.4005,4.0336,4.5973}, /*cfy*/
          {1.0642,-0.04041,1068.7888,3.71578,0.009763,1.2759}, /*cmz*/
          {6.230227,4.6662,3.7344,2.8349} /*cfz*/
     },
     {
          2458437.4,
          {-3.7132,-0.01088,1046.3879,4.04945,0.009246,1.3657}, /*cmx*/
          {1.929273,0.4506,4.9368,2.3084}, /*cfx*/
          {0.7884,-0.00174,231.4131,1.69784,0.007,0.2505}, /*cmy*/
          {5.316488,2.4779,0.7287,5.7573}, /*cfy*/
          {0.0659,-0.03874,1069.0749,4.21666,0.007802,1.3655}, /*cmz*/
          {3.51124,1.9343,0.0296,3.8961} /*cfz*/
     },
     {
          2458477.4,
          {-3.5524,-0.00173,1059.0194,3.92383,0.012344,1.3435}, /*cmx*/
          {5.490892,3.9761,1.3511,3.4345}, /*cfx*/
          {0.6039,-0.00534,165.794,1.68572,0.006661,0.1691}, /*cmy*/
          {2.689511,5.8382,3.4971,0.6667}, /*cfy*/
          {-1.346,-0.0184,1068.9169,4.07878,0.01328,1.3475}, /*cmz*/
          {0.786345,5.4926,2.7872,4.9949} /*cfz*/
     },
     {
          2458517.4,
          {-3.1669,0.01281,1066.7721,3.09054,0.020731,1.2867}, /*cmx*/
          {2.788659,1.2356,4.4673,4.6184}, /*cfx*/
          {0.3821,-0.00361,106.2364,1.36126,0.008975,0.1113}, /*cmy*/
          {0.183937,2.9709,0.0232,2.1284}, /*cfy*/
          {-2.5561,0.00797,1069.0164,3.16766,0.021179,1.2787}, /*cmz*/
          {4.363802,2.7818,6.0191,6.1642} /*cfz*/
     },
     {
          2458557.4,
          {-2.9166,0.02853,1069.3924,1.40454,0.028029,1.1773}, /*cmx*/
          {0.133022,4.8521,1.7104,5.7933}, /*cfx*/
          {0.2652,-0.00224,71.3537,0.64916,0.012081,0.076}, /*cmy*/
          {4.127769,0.2191,3.3694,3.5815}, /*cfy*/
          {-2.815,0.00954,1069.0925,1.41122,0.027984,1.188}, /*cmz*/
          {1.705865,0.1231,3.2659,1.0205} /*cfz*/
     },
     {
          2458597.4,
          {-2.3664,0.01369,1069.3929,0.96792,0.019496,1.0429}, /*cmx*/
          {3.833994,5.3734,5.5621,0.7008}, /*cfx*/
          {0.2305,-0.00032,66.7644,0.38319,0.008451,0.0745}, /*cmy*/
          {1.630421,0.7464,0.9521,4.7816}, /*cfy*/
          {-2.219,-0.00357,1068.9538,0.9942,0.01968,1.0035}, /*cmz*/
          {5.406693,0.6844,0.7683,2.2227} /*cfz*/
     },
     {
          2458637.4,
          {-1.8733,-0.0042,1068.006,2.57072,0.010891,0.9032}, /*cmx*/
          {1.326391,2.9344,5.8538,1.8907}, /*cfx*/
          {0.2101,0.00149,88.8245,1.07627,0.004298,0.0983}, /*cmy*/
          {5.116054,4.636,1.2604,5.4403}, /*cfy*/
          {-1.6854,0.00157,1069.2458,2.59774,0.010278,0.89}, /*cmz*/
          {2.900908,4.4877,1.205,3.4384} /*cfz*/
     },
     {
          2458677.4,
          {-1.5142,-0.01845,1064.6957,1.60245,0.028024,0.7264}, /*cmx*/
          {5.118114,0.4699,3.6095,2.9006}, /*cfx*/
          {0.2226,0.00182,122.3811,0.683,0.011667,0.0882}, /*cmy*/
          {2.419201,2.1744,5.4093,0.1995}, /*cfy*/
          {-1.4008,0.02067,1068.9965,1.61225,0.028086,0.734}, /*cmz*/
          {0.411048,1.9838,5.1229,4.4411} /*cfz*/
     },
     {
          2458717.4,
          {-1.8895,-0.00659,1063.5305,0.71379,0.024108,0.7142}, /*cmx*/
          {2.565343,1.073,0.9655,3.8196}, /*cfx*/
          {0.2591,-0.00135,130.5693,0.30224,0.010587,0.0798}, /*cmy*/
          {6.102711,3.1483,2.6711,1.1941}, /*cfy*/
          {-1.123,0.02533,1068.9478,0.7328,0.024925,0.7541}, /*cmz*/
          {4.141419,2.6385,2.4741,5.3793} /*cfz*/
     },
     {
          2458757.4,
          {-2.529,0.00325,1066.3045,2.67154,0.01563,0.852}, /*cmx*/
          {6.214997,4.7008,4.2249,4.701}, /*cfx*/
          {0.2682,-0.00457,102.7803,1.1397,0.008128,0.0604}, /*cmy*/
          {3.55835,0.2213,5.7342,2.1352}, /*cfy*/
          {-0.5966,0.00025,1069.2289,2.70356,0.016177,0.9158}, /*cmz*/
          {1.506223,6.2328,5.8484,6.2584} /*cfz*/
     },
     {
          2458797.4,
          {-3.0288,0.00448,1069.6143,3.85277,0.011233,0.9982}, /*cmx*/
          {3.523013,1.9768,0.8127,5.6484}, /*cfx*/
          {0.0832,-0.00338,54.6174,1.67712,0.007435,0.0502}, /*cmy*/
          {1.353453,3.6448,2.2891,4.1407}, /*cfy*/
          {-0.4471,-0.02639,1069.4899,3.91696,0.009277,1.0522}, /*cmz*/
          {5.094985,3.525,2.5122,0.9517} /*cfz*/
     },
     {
          2458837.4,
          {-2.9939,-0.00665,1069.4011,4.2737,0.010001,1.1908}, /*cmx*/
          {0.800551,5.4882,3.594,0.3584}, /*cfx*/
          {-0.0791,-0.00545,62.2085,1.89335,0.007312,0.1118}, /*cmy*/
          {0.067192,0.747,5.1325,6.2243}, /*cfy*/
          {-0.8905,-0.03932,1069.5863,4.37645,0.009034,1.2227}, /*cmz*/
          {2.369967,0.7973,5.0769,1.9362} /*cfz*/
     },
     {
          2458877.4,
          {-2.7555,-0.00371,1063.3149,4.07003,0.013638,1.2794}, /*cmx*/
          {4.357123,2.7176,0.0409,1.4365}, /*cfx*/
          {-0.275,-0.00351,130.0918,1.77918,0.007256,0.1987}, /*cmy*/
          {4.065461,4.1289,1.6574,1.263}, /*cfy*/
          {-2.1258,-0.02258,1069.6278,4.12784,0.013393,1.3026}, /*cmz*/
          {5.923767,4.3495,1.6742,3.0178} /*cfz*/
     },
     {
          2458917.4,
          {-2.3313,0.00536,1053.6269,3.15989,0.02171,1.3156}, /*cmx*/
          {1.651174,6.2669,3.2241,2.6027}, /*cfx*/
          {-0.3045,-0.00216,192.2903,1.358,0.009247,0.2654}, /*cmy*/
          {1.47907,1.2801,4.5476,2.4335}, /*cfy*/
          {-3.3129,-0.00015,1069.9733,3.18739,0.021297,1.336}, /*cmz*/
          {3.216231,1.6317,4.8595,4.186} /*cfz*/
     },
     {
          2458957.4,
          {-2.1149,0.02397,1045.5047,1.40108,0.02765,1.3685}, /*cmx*/
          {5.276104,3.6071,0.4761,3.7846}, /*cfx*/
          {-0.365,0.00466,230.8967,0.6154,0.012016,0.3116}, /*cmy*/
          {5.150046,4.8896,1.6502,3.676}, /*cfy*/
          {-3.9634,0.01008,1070.1969,1.42765,0.028464,1.3541}, /*cmz*/
          {0.557907,5.2473,2.1033,5.3887} /*cfz*/
     },
     {
          2458997.4,
          {-1.8251,0.02224,1043.9436,0.97746,0.01937,1.2797}, /*cmx*/
          {2.693399,4.1515,4.2762,5.0403}, /*cfx*/
          {-0.2976,0.00443,236.8811,0.42284,0.008681,0.2849}, /*cmy*/
          {2.58013,5.1459,5.583,4.9408}, /*cfy*/
          {-3.6431,-0.00605,1069.947,0.99012,0.02046,1.3334}, /*cmz*/
          {4.258849,5.8032,5.9277,0.3771} /*cfz*/
     },
     {
          2459037.4,
          {-1.253,0.00109,1050.2107,2.59341,0.011212,1.1869}, /*cmx*/
          {0.187398,1.6952,4.6958,0.1132}, /*cfx*/
          {-0.2092,0.00321,209.8745,1.12864,0.004889,0.2009}, /*cmy*/
          {0.061168,2.8944,5.648,6.2615}, /*cfy*/
          {-3.3227,-0.00238,1070.0231,2.63532,0.011051,1.2199}, /*cmz*/
          {1.753609,3.3308,0.0122,1.6961} /*cfz*/
     },
     {
          2459077.4,
          {-0.7803,-0.01389,1056.6628,1.56712,0.02907,1.0006}, /*cmx*/
          {3.980196,5.4962,2.3578,1.3033}, /*cfx*/
          {-0.0408,-0.00238,173.5368,0.70667,0.012565,0.1608}, /*cmy*/
          {3.823603,0.5146,3.6624,1.1388}, /*cfy*/
          {-3.0804,0.01131,1069.8909,1.60805,0.029877,1.0248}, /*cmz*/
          {5.546943,0.8331,3.9692,2.9179} /*cfz*/
     },
     {
          2459117.4,
          {-0.7481,-0.00471,1057.6195,0.87616,0.024392,0.8654}, /*cmx*/
          {1.424693,6.1303,5.9513,2.4436}, /*cfx*/
          {-0.0491,-0.00141,165.4203,0.34492,0.010826,0.1519}, /*cmy*/
          {1.261093,1.2001,0.9411,2.2836}, /*cfy*/
          {-2.992,0.02875,1069.8378,0.8517,0.025676,0.8516}, /*cmz*/
          {2.991427,1.466,1.3301,3.9975} /*cfz*/
     },
     {
          2459157.4,
          {-1.0909,0.01197,1052.4769,2.84021,0.016152,0.8064}, /*cmx*/
          {5.067283,3.438,2.9363,3.3055}, /*cfx*/
          {-0.1207,-0.00068,195.397,1.22222,0.007646,0.1625}, /*cmy*/
          {4.93975,4.7247,3.882,3.257}, /*cfy*/
          {-2.463,0.0172,1070.0916,2.90506,0.015666,0.7528}, /*cmz*/
          {0.350809,5.0716,4.665,4.9007} /*cfz*/
     },
     {
          2459197.4,
          {-1.2354,0.00938,1040.9229,3.98542,0.010008,0.7394}, /*cmx*/
          {2.366426,0.7053,5.835,4.0847}, /*cfx*/
          {-0.2809,0.00171,249.728,1.69782,0.007326,0.1991}, /*cmy*/
          {2.283981,1.8682,0.3656,3.9955}, /*cfy*/
          {-1.8815,-0.00663,1070.0728,4.10135,0.009886,0.7263}, /*cmz*/
          {3.932987,2.3681,1.2188,5.636} /*cfz*/
     },
     {
          2455197.3,
          {-10.5365,0.06295,1747.1836,6.50155,0.016937,6.3771}, /*cmx*/
          {1.055156,5.6862,4.8496,1.4473}, /*cfx*/
          {-4.3604,0.01205,700.7649,2.78981,0.011979,2.6779}, /*cmy*/
          {1.08278,0.0421,5.0756,1.4835}, /*cfy*/
          {-17.1046,-0.05485,1882.0337,6.86488,0.021089,6.9599}, /*cmz*/
          {2.629807,1.0702,0.1826,3.0267} /*cfz*/
     },
     {
          2455237.3,
          {-7.6069,0.06811,1726.0071,7.44926,0.014508,6.2869}, /*cmx*/
          {3.388799,1.7542,0.0269,6.2753}, /*cfx*/
          {-3.6689,0.02386,751.9967,3.22085,0.012999,2.8257}, /*cmy*/
          {3.429356,2.2316,0.4313,0.0413}, /*cfy*/
          {-19.0051,-0.02682,1882.8179,7.96213,0.016067,6.8919}, /*cmz*/
          {4.966092,3.3897,1.721,1.5583} /*cfz*/
     },
     {
          2455277.3,
          {-4.6292,0.0741,1710.3482,7.30496,0.016669,6.2585}, /*cmx*/
          {5.711019,4.0907,1.561,4.8071}, /*cfx*/
          {-2.647,0.03118,788.4155,3.12412,0.011508,2.9313}, /*cmy*/
          {5.766935,4.3924,2.149,4.8717}, /*cfy*/
          {-20.0823,-0.01417,1882.1746,7.96906,0.02182,6.9427}, /*cmz*/
          {1.008844,5.7149,3.2402,0.0952} /*cfz*/
     },
     {
          2455317.3,
          {-1.5181,0.04893,1703.0936,6.2887,0.03039,6.2291}, /*cmx*/
          {1.763782,0.1694,3.4806,3.3738}, /*cfx*/
          {-1.3602,0.01941,804.7554,2.64514,0.014817,2.9507}, /*cmy*/
          {1.836359,0.3101,3.7444,3.4574}, /*cfy*/
          {-20.7048,-0.00101,1882.0029,6.68516,0.031088,6.8839}, /*cmz*/
          {3.347277,1.7644,5.1314,4.9467} /*cfz*/
     },
     {
          2455357.3,
          {0.3882,0.03454,1702.7932,3.97154,0.043545,6.3001}, /*cmx*/
          {4.137869,2.5588,5.7086,1.9752}, /*cfx*/
          {-0.5856,0.01218,806.3296,1.56251,0.01924,2.9793}, /*cmy*/
          {4.226507,2.5878,5.7487,2.0712}, /*cfy*/
          {-21.125,0.01419,1882.0767,4.27656,0.047966,6.933}, /*cmz*/
          {5.724957,4.1268,0.9963,3.5668} /*cfz*/
     },
     {
          2455397.3,
          {1.3766,-0.01132,1703.821,0.2971,0.045857,6.2881}, /*cmx*/
          {0.296055,5.057,1.9011,0.6779}, /*cfx*/
          {-0.2325,-0.00805,804.2714,0.06436,0.01908,2.9733}, /*cmy*/
          {0.397668,1.6792,1.9319,0.784}, /*cfy*/
          {-20.8502,0.00314,1880.7207,0.22167,0.049129,6.9504}, /*cmz*/
          {1.885176,0.589,3.5034,2.2596} /*cfz*/
     },
     {
          2455437.3,
          {0.3308,-0.03025,1702.5229,3.59112,0.007656,6.3943}, /*cmx*/
          {2.824834,4.4026,4.898,5.723}, /*cfx*/
          {-0.762,-0.01483,806.4367,1.67912,0.003551,3.0304}, /*cmy*/
          {2.931245,4.4443,5.8558,5.825}, /*cfy*/
          {-20.0609,-0.035,1881.0235,4.14598,0.005275,6.851}, /*cmz*/
          {4.414161,5.9854,0.8468,1.0191} /*cfz*/
     },
     {
          2455477.3,
          {-0.7259,-0.04696,1702.2792,3.85831,0.043555,6.2471}, /*cmx*/
          {5.407414,0.7035,3.8347,4.5012}, /*cfx*/
          {-1.2849,-0.01705,807.6591,1.60885,0.020253,2.951}, /*cmy*/
          {5.507948,0.8627,3.9758,4.5966}, /*cfy*/
          {-20.9259,0.0154,1881.488,4.2034,0.049137,6.9206}, /*cmz*/
          {0.713345,2.2993,5.4252,6.0967} /*cfz*/
     },
     {
          2455517.3,
          {-2.035,0.01211,1702.955,0.06617,0.048317,6.2705}, /*cmx*/
          {1.667113,2.9334,0.0614,3.2089}, /*cfx*/
          {-1.7518,0.00674,805.1945,0.13458,0.020904,2.9718}, /*cmy*/
          {1.757614,0.2389,0.1948,3.2945}, /*cfy*/
          {-20.8693,0.01103,1881.0192,0.07303,0.052822,6.9057}, /*cmz*/
          {3.254322,3.5399,1.637,4.792} /*cfz*/
     },
     {
          2455557.3,
          {-1.7808,0.07215,1702.0058,3.89499,0.030475,6.3019}, /*cmx*/
          {4.11768,2.5611,2.2814,1.8204}, /*cfx*/
          {-1.6567,0.03573,806.1735,1.85647,0.013446,2.9784}, /*cmy*/
          {4.204068,2.6901,2.098,1.9066}, /*cfy*/
          {-21.0107,0.00783,1881.5253,4.26026,0.034014,6.9253}, /*cmz*/
          {5.704065,4.1486,3.841,3.4169} /*cfz*/
     },
     {
          2455597.3,
          {0.6774,0.07695,1703.0848,6.2892,0.017072,6.3001}, /*cmx*/
          {0.209445,4.9442,4.1653,0.3779}, /*cfx*/
          {-0.4582,0.03278,804.3088,2.83905,0.011772,2.9464}, /*cmy*/
          {0.299946,4.9567,3.6194,0.4707}, /*cfy*/
          {-20.5241,-0.01012,1881.1307,6.86762,0.020392,6.9101}, /*cmz*/
          {1.796674,0.2317,5.6699,1.9707} /*cfz*/
     },
     {
          2455637.3,
          {3.9359,0.06787,1711.3713,7.2714,0.013753,6.2408}, /*cmx*/
          {2.544075,1.0183,5.7555,5.1979}, /*cfx*/
          {1.0104,0.02313,788.193,3.17377,0.012503,2.8081}, /*cmy*/
          {2.645405,0.8602,5.3504,5.3077}, /*cfy*/
          {-20.3477,0.0184,1881.3023,7.99268,0.016884,6.8956}, /*cmz*/
          {4.132792,2.5601,0.8615,0.5073} /*cfz*/
     },
     {
          2455677.3,
          {6.8977,0.06894,1728.1287,7.34989,0.016081,6.346}, /*cmx*/
          {4.868558,3.3547,0.8762,3.7347}, /*cfx*/
          {2.1141,0.0204,752.5838,3.0929,0.01256,2.6578}, /*cmy*/
          {4.985513,3.0156,0.7643,3.86}, /*cfy*/
          {-19.5327,0.03846,1880.6788,7.93897,0.020295,6.9317}, /*cmz*/
          {0.174721,4.8841,2.5312,5.327} /*cfz*/
     },
     {
          2455717.3,
          {9.8271,0.04541,1748.7809,6.44201,0.028852,6.3551}, /*cmx*/
          {0.922258,5.7208,2.8375,2.2982}, /*cfx*/
          {2.8893,0.01395,701.8324,2.57037,0.013779,2.4363}, /*cmy*/
          {1.05862,5.1966,2.543,2.4468}, /*cfy*/
          {-18.0446,0.03074,1881.1313,6.85934,0.030107,6.9077}, /*cmz*/
          {2.511761,0.9204,4.273,3.8921} /*cfz*/
     },
     {
          2455757.3,
          {11.8217,0.0232,1769.36,4.28583,0.043764,6.5305}, /*cmx*/
          {3.295343,1.7985,4.9529,0.9109}, /*cfx*/
          {3.424,-5e-05,652.075,1.64965,0.018074,2.3282}, /*cmy*/
          {3.452926,1.1016,4.3225,1.0746}, /*cfy*/
          {-17.0904,0.0334,1880.5075,4.57224,0.047527,6.9083}, /*cmz*/
          {4.885051,3.2922,0.1717,2.497} /*cfz*/
     },
     {
          2455797.3,
          {12.6032,-0.01016,1778.5921,0.6093,0.049169,6.5041}, /*cmx*/
          {5.73219,4.3362,1.1489,5.8824}, /*cfx*/
          {3.4454,-0.00408,624.7554,0.14319,0.018969,2.3078}, /*cmy*/
          {5.906942,3.1827,0.4607,6.0573}, /*cfy*/
          {-16.0686,-0.00856,1879.7245,0.56501,0.051103,6.9046}, /*cmz*/
          {1.038615,5.7723,2.6274,1.1927} /*cfz*/
     },
     {
          2455837.3,
          {11.3505,-0.00674,1772.8456,3.65196,0.010888,6.4336}, /*cmx*/
          {1.971562,3.6115,4.2856,4.6582}, /*cfx*/
          {3.0737,0.00359,639.1667,1.55194,0.003194,2.3738}, /*cmy*/
          {2.147451,2.9964,4.2461,4.8199}, /*cfy*/
          {-16.2536,-0.04091,1880.4052,3.90104,0.008967,6.9801}, /*cmz*/
          {3.562631,5.156,5.4142,6.219} /*cfz*/
     },
     {
          2455877.3,
          {10.8953,-0.05045,1758.9265,4.15693,0.044424,6.4053}, /*cmx*/
          {4.553444,6.2283,3.0588,3.4316}, /*cfx*/
          {3.1546,-0.01412,679.1667,1.60056,0.019068,2.5307}, /*cmy*/
          {4.714458,5.6644,2.5559,3.5888}, /*cfy*/
          {-17.4191,-0.02083,1880.0903,4.39248,0.047696,6.8173}, /*cmz*/
          {6.145226,1.4496,4.5803,5.0198} /*cfz*/
     },
     {
          2455917.3,
          {9.595,0.00509,1749.8565,0.29064,0.049219,6.3611}, /*cmx*/
          {0.817624,2.3586,5.5887,2.1397}, /*cfx*/
          {2.8621,0.00113,699.8803,0.15013,0.019908,2.517}, /*cmy*/
          {0.963023,0.0819,5.0272,2.2825}, /*cfy*/
          {-18.2577,0.01381,1880.1882,0.28834,0.05382,6.8799}, /*cmz*/
          {2.408133,3.8709,0.8132,3.7277} /*cfz*/
     },
     {
          2455957.3,
          {9.8501,0.05649,1755.3104,3.72055,0.032598,6.4607}, /*cmx*/
          {3.27353,1.8176,1.5268,0.7678}, /*cfx*/
          {2.9756,0.01331,684.9537,1.66691,0.014207,2.4351}, /*cmy*/
          {3.413474,1.3445,0.6466,0.9164}, /*cfy*/
          {-18.2749,0.05164,1880.4771,4.09323,0.03332,6.8378}, /*cmz*/
          {4.862997,3.3081,3.0147,2.3497} /*cfz*/
     },
     {
          2455997.3,
          {11.6248,0.07298,1773.9115,6.25435,0.019436,6.5194}, /*cmx*/
          {5.655341,4.1911,3.3984,5.6134}, /*cfx*/
          {3.2809,0.01419,635.6872,2.64013,0.012677,2.1824}, /*cmy*/
          {5.802761,3.5439,2.232,5.7726}, /*cfy*/
          {-16.3161,0.0387,1880.3006,6.70278,0.019185,6.8241}, /*cmz*/
          {0.959633,5.6768,4.8409,0.9111} /*cfz*/
     },
     {
          2456037.3,
          {14.3796,0.04957,1801.2687,7.36457,0.015754,6.5606}, /*cmx*/
          {1.714227,0.2431,5.0131,4.1511}, /*cfx*/
          {3.7106,-0.00818,555.2137,3.05885,0.01392,1.8417}, /*cmy*/
          {1.882395,5.6905,3.968,4.3537}, /*cfy*/
          {-14.1348,0.05345,1880.4816,7.78565,0.016851,6.7596}, /*cmz*/
          {3.299421,1.7307,0.1058,5.74} /*cfz*/
     },
     {
          2456077.3,
          {16.5992,0.03856,1829.9968,7.55796,0.01923,6.6827}, /*cmx*/
          {4.045662,2.5601,0.2254,2.695}, /*cfx*/
          {3.5834,-0.02283,452.1134,3.09355,0.012763,1.4403}, /*cmy*/
          {4.251017,1.5217,5.7661,2.9365}, /*cfy*/
          {-11.8052,0.07427,1880.6304,7.78122,0.017691,6.8156}, /*cmz*/
          {5.627696,4.0489,1.723,4.2845} /*cfz*/
     },
     {
          2456117.3,
          {18.2926,0.02638,1853.5021,6.58754,0.027771,6.7286}, /*cmx*/
          {0.103667,4.8851,2.0735,1.2567}, /*cfx*/
          {2.7224,-0.01372,342.0205,2.7673,0.013046,1.083}, /*cmy*/
          {0.374896,3.6631,1.0117,1.5953}, /*cfy*/
          {-8.9132,0.05602,1880.6152,6.9061,0.030751,6.7448}, /*cmz*/
          {1.683541,0.0995,3.472,2.8536} /*cfz*/
     },
     {
          2456157.3,
          {19.5829,8e-05,1869.0408,4.52897,0.045575,6.7927}, /*cmx*/
          {2.47906,0.933,4.0915,6.1612}, /*cfx*/
          {2.0222,-0.01034,249.866,1.90642,0.019142,0.8104}, /*cmy*/
          {2.852237,5.889,2.8216,0.2809}, /*cfy*/
          {-6.8253,0.03978,1880.5494,4.62777,0.04637,6.8417}, /*cmz*/
          {4.055792,2.4697,5.6389,1.4561} /*cfz*/
     },
     {
          2456197.3,
          {19.6438,-0.00341,1873.4115,0.69816,0.050912,6.7964}, /*cmx*/
          {4.914888,3.466,0.2826,4.852}, /*cfx*/
          {1.5564,0.00633,204.827,0.31167,0.021669,0.7685}, /*cmy*/
          {5.379454,1.9872,5.181,5.3155}, /*cfy*/
          {-5.4713,-0.01476,1880.298,0.74297,0.052918,6.7852}, /*cmz*/
          {0.207428,4.9347,1.7902,0.1446} /*cfz*/
     },
     {
          2456237.3,
          {18.8354,0.01198,1871.4711,3.85923,0.009336,6.708}, /*cmx*/
          {1.15216,2.7723,3.4348,3.5988}, /*cfx*/
          {1.9777,0.00883,226.0769,1.53357,0.005279,0.9304}, /*cmy*/
          {1.573924,1.4317,1.9244,3.909}, /*cfy*/
          {-6.4655,-0.02971,1879.9335,3.75209,0.013534,6.9228}, /*cmz*/
          {2.729364,4.2922,4.6777,5.2013} /*cfz*/
     },
     {
          2456277.3,
          {18.989,-0.03173,1862.3676,4.38007,0.045652,6.6573}, /*cmx*/
          {3.733432,5.394,2.2272,2.4018}, /*cfx*/
          {2.41,0.01125,293.5776,1.77238,0.018129,1.1222}, /*cmy*/
          {4.048593,4.0889,0.9901,2.6924}, /*cfy*/
          {-7.4753,-0.04965,1880.203,4.47135,0.046271,6.8064}, /*cmz*/
          {5.311531,0.6063,3.7205,3.9739} /*cfz*/
     },
     {
          2456317.3,
          {18.3062,-0.00146,1854.1317,0.46243,0.051255,6.6968}, /*cmx*/
          {6.281564,1.5227,4.7459,1.1058}, /*cfx*/
          {2.7962,-0.00231,334.9011,0.24587,0.021862,1.1771}, /*cmy*/
          {0.260191,6.0196,3.5229,1.3543}, /*cfy*/
          {-9.0017,0.01234,1880.7346,0.41972,0.052019,6.7926}, /*cmz*/
          {1.577343,3.139,6.2819,2.6953} /*cfz*/
     },
     {
          2456357.3,
          {18.5856,0.0191,1858.7547,3.67233,0.0332,6.7039}, /*cmx*/
          {2.458422,0.9746,0.6747,6.03}, /*cfx*/
          {2.7946,-0.02257,309.642,1.5889,0.015009,0.9773}, /*cmy*/
          {2.725935,6.1114,5.4793,0.0383}, /*cfy*/
          {-8.8528,0.06953,1880.2629,3.8452,0.032805,6.819}, /*cmz*/
          {4.036458,2.4966,2.1749,1.3196} /*cfz*/
     },
     {
          2456397.3,
          {18.9494,0.04129,1870.2947,6.24629,0.020497,6.7431}, /*cmx*/
          {4.846592,3.3342,2.4828,4.6004}, /*cfx*/
          {1.8942,-0.02413,226.4603,2.69226,0.013216,0.5974}, /*cmy*/
          {5.194238,2.0406,0.8207,5.0539}, /*cfy*/
          {-6.3892,0.07101,1880.7851,6.40936,0.01887,6.7927}, /*cmz*/
          {0.138889,4.8585,4.0549,6.1695} /*cfz*/
     },
     {
          2456437.3,
          {20.0602,0.00842,1880.5391,7.38657,0.017815,6.7284}, /*cmx*/
          {0.912227,5.6472,4.0466,3.1518}, /*cfx*/
          {0.7247,-0.03,114.1059,3.20833,0.012936,0.2761}, /*cmy*/
          {1.59147,4.2037,2.5539,4.5322}, /*cfy*/
          {-3.1208,0.06573,1881.3197,7.4983,0.015547,6.7364}, /*cmz*/
          {2.48483,0.9157,5.6474,4.7149} /*cfz*/
     },
     {
          2456477.3,
          {20.6166,-0.01914,1882.0721,7.48743,0.019873,6.7835}, /*cmx*/
          {3.248775,1.6608,5.6924,1.6991}, /*cfx*/
          {-0.4748,-0.03686,82.4442,3.2923,0.012456,0.4911}, /*cmy*/
          {5.466866,0.077,4.1927,4.3553}, /*cfy*/
          {-0.128,0.07704,1881.898,7.5907,0.016807,6.756}, /*cmz*/
          {4.818613,3.2365,0.85,3.2694} /*cfz*/
     },
     {
          2456517.3,
          {20.0891,-0.01171,1874.5442,6.55736,0.027959,6.7541}, /*cmx*/
          {5.5936,3.9592,1.0763,0.2728}, /*cfx*/
          {-1.8325,-0.02544,189.6985,2.84305,0.013925,0.8932}, /*cmy*/
          {2.132392,2.2706,5.8604,3.1393}, /*cfy*/
          {2.9621,0.06084,1881.2451,6.7205,0.030327,6.6794}, /*cmz*/
          {0.878451,5.5898,2.7224,1.8301} /*cfz*/
     },
     {
          2456557.3,
          {19.7233,-0.01864,1862.3616,4.45969,0.046733,6.7365}, /*cmx*/
          {1.687707,0.0307,3.1989,5.1678}, /*cfx*/
          {-2.9702,-0.00393,283.4647,1.8762,0.019401,1.1223}, /*cmy*/
          {4.641078,4.5079,1.3623,1.8559}, /*cfy*/
          {5.3685,0.02965,1882.3291,4.45749,0.04592,6.7874}, /*cmz*/
          {3.253962,1.6612,4.818,0.4512} /*cfz*/
     },
     {
          2456597.3,
          {18.9785,0.01113,1854.5764,0.55288,0.050303,6.6708}, /*cmx*/
          {4.125618,2.5121,5.641,3.8631}, /*cfx*/
          {-3.2787,0.00737,327.1076,0.24864,0.021775,1.1572}, /*cmy*/
          {0.833762,1.0679,3.8195,0.577}, /*cfy*/
          {6.4727,-0.0179,1881.625,0.5883,0.052287,6.7841}, /*cmz*/
          {5.692097,4.2081,1.0121,5.4221} /*cfz*/
     },
     {
          2456637.3,
          {19.234,0.0204,1859.4678,3.81992,0.008918,6.8657}, /*cmx*/
          {0.366326,1.8928,2.1985,2.6142}, /*cfx*/
          {-2.6899,0.00124,303.673,1.70022,0.00647,0.9771}, /*cmy*/
          {3.351292,6.25,1.0252,5.5632}, /*cfy*/
          {5.141,-0.0166,1881.0343,3.93558,0.010931,6.7348}, /*cmz*/
          {1.932903,3.4768,4.2326,4.199} /*cfz*/
     },
     {
          2456677.3,
          {19.8325,0.00705,1869.1195,4.27303,0.044563,6.7092}, /*cmx*/
          {2.947772,4.4826,1.3192,1.4008}, /*cfx*/
          {-2.4246,0.01935,232.2826,1.92842,0.019822,0.7239}, /*cmy*/
          {5.884306,2.7039,5.8017,4.3196}, /*cfy*/
          {4.3429,-0.05235,1882.0311,4.4175,0.046748,6.7814}, /*cmz*/
          {4.515147,6.0984,2.9303,2.9824} /*cfz*/
     },
     {
          2456717.3,
          {20.2447,-0.00591,1873.8689,0.43696,0.050396,6.7989}, /*cmx*/
          {5.49411,0.6913,3.8611,0.119}, /*cfx*/
          {-1.8829,-0.00239,186.9951,0.22431,0.021615,0.702}, /*cmy*/
          {2.098407,5.0767,2.1297,3.0127}, /*cfy*/
          {2.7739,0.0124,1881.7458,0.37571,0.04921,6.7444}, /*cmz*/
          {0.779682,2.249,5.4656,1.6883} /*cfz*/
     },
     {
          2456757.3,
          {20.4079,-0.02649,1871.1344,3.65186,0.030778,6.7335}, /*cmx*/
          {1.671882,0.0701,6.0427,5.0336}, /*cfx*/
          {-2.1112,-0.02082,212.402,1.53757,0.014751,0.8687}, /*cmy*/
          {4.60123,4.6656,4.1032,1.7023}, /*cfy*/
          {3.1454,0.062,1881.4754,3.61838,0.032892,6.7796}, /*cmz*/
          {3.239727,1.7008,1.3969,0.3259} /*cfz*/
     },
     {
          2456797.3,
          {19.2086,-0.01121,1859.6789,6.08007,0.018473,6.6522}, /*cmx*/
          {4.062584,2.4311,1.5813,3.6075}, /*cfx*/
          {-2.8189,-0.03,293.9589,2.60242,0.011331,1.2425}, /*cmy*/
          {0.786633,0.6242,5.7094,0.3674}, /*cfy*/
          {5.1854,0.07859,1882.0073,6.15996,0.01821,6.795}, /*cmz*/
          {5.630176,4.0657,3.3053,5.1782} /*cfz*/
     },
     {
          2456837.3,
          {18.0945,-0.03127,1839.7609,7.11456,0.015089,6.5252}, /*cmx*/
          {0.131057,4.7564,3.1468,2.1592}, /*cfx*/
          {-3.8916,-0.01582,401.1265,3.04058,0.011935,1.618}, /*cmy*/
          {3.193928,2.8178,1.032,5.2396}, /*cfy*/
          {8.387,0.05693,1882.3122,7.24791,0.014172,6.7866}, /*cmz*/
          {1.698414,0.1286,4.8827,3.7315} /*cfz*/
     },
     {
          2456877.3,
          {16.8713,-0.06045,1813.5367,7.14724,0.016584,6.5055}, /*cmx*/
          {2.469663,0.7916,4.6894,0.7173}, /*cfx*/
          {-4.6321,-0.00295,507.0128,2.98953,0.011651,1.9992}, /*cmy*/
          {5.56851,4.9826,2.8045,3.8307}, /*cfy*/
          {11.1508,0.05218,1882.8308,7.38868,0.017296,6.7941}, /*cmz*/
          {4.037541,2.4579,0.0343,2.283} /*cfz*/
     },
     {
          2456917.3,
          {14.7582,-0.04338,1786.9288,6.25506,0.029418,6.3666}, /*cmx*/
          {4.816472,3.1307,0.1707,5.5753}, /*cfx*/
          {-4.7915,-0.00281,593.7752,2.54366,0.012612,2.2523}, /*cmy*/
          {1.657258,0.8758,4.3352,2.4257}, /*cfy*/
          {13.3652,0.04731,1882.248,6.40703,0.028935,6.8094}, /*cmz*/
          {0.102035,4.8125,1.9326,0.8448} /*cfz*/
     },
     {
          2456957.3,
          {13.1152,-0.0241,1766.6255,4.00814,0.045111,6.3939}, /*cmx*/
          {0.912931,5.5202,2.4026,4.1926}, /*cfx*/
          {-4.9193,0.00501,650.6805,1.61518,0.019533,2.4211}, /*cmy*/
          {4.055583,3.1651,6.2779,1.0593}, /*cfy*/
          {15.2267,0.0134,1883.3786,4.17398,0.047629,6.8385}, /*cmz*/
          {2.483854,0.8823,4.026,5.7558} /*cfz*/
     },
     {
          2456997.3,
          {12.0602,0.02464,1758.189,0.217,0.047604,6.3335}, /*cmx*/
          {3.356811,1.7406,4.8518,2.8834}, /*cfx*/
          {-4.758,-0.00468,673.0824,0.1126,0.019509,2.3969}, /*cmy*/
          {0.228235,1.1873,2.4689,6.0452}, /*cfy*/
          {15.7936,-0.01723,1882.1392,0.15458,0.04902,6.8528}, /*cmz*/
          {4.929136,3.822,0.2683,4.4593} /*cfz*/
     },
     {
          2457037.3,
          {13.2147,0.02055,1764.0722,3.77054,0.007377,6.5096}, /*cmx*/
          {5.887522,1.0782,1.6677,1.6685}, /*cfx*/
          {-4.8806,-0.00515,657.3858,1.71769,0.00409,2.3655}, /*cmy*/
          {2.763687,4.9578,0.1017,4.8283}, /*cfy*/
          {14.7193,-0.01109,1882.6969,4.18982,0.004735,6.8453}, /*cmz*/
          {1.176401,2.7503,4.1756,3.2139} /*cfz*/
     },
     {
          2457077.3,
          {14.0617,0.0313,1779.3149,3.95792,0.04368,6.5124}, /*cmx*/
          {2.186329,3.66,0.4932,0.4331}, /*cfx*/
          {-4.9728,0.00093,614.3113,1.68842,0.019016,2.1719}, /*cmy*/
          {5.342128,1.4099,4.4849,3.5775}, /*cfy*/
          {14.0983,-0.03612,1883.0512,4.13671,0.046299,6.7699}, /*cmz*/
          {3.758525,5.352,2.2,2.0101} /*cfz*/
     },
     {
          2457117.3,
          {15.1496,-0.01091,1788.8033,0.20218,0.045685,6.4961}, /*cmx*/
          {4.729014,6.2237,3.0564,5.4327}, /*cfx*/
          {-4.9796,0.00038,587.4521,0.0883,0.019631,2.1677}, /*cmy*/
          {1.595049,4.4169,0.7809,2.298}, /*cfy*/
          {13.0378,0.01181,1882.1331,0.21311,0.047671,6.8341}, /*cmz*/
          {0.017388,1.2745,4.6842,0.7084} /*cfz*/
     },
     {
          2457157.3,
          {14.9486,-0.04836,1781.9902,3.53102,0.028476,6.461}, /*cmx*/
          {0.904046,5.552,5.2175,4.0622}, /*cfx*/
          {-5.1722,0.0079,605.3543,1.51534,0.012358,2.2834}, /*cmy*/
          {4.05338,3.2417,2.7589,0.9189}, /*cfy*/
          {13.5536,0.03896,1882.6381,3.60842,0.031154,6.7989}, /*cmz*/
          {2.475282,0.9175,0.6677,5.6272} /*cfz*/
     },
     {
          2457197.3,
          {13.0489,-0.04879,1764.8396,5.74825,0.015808,6.3719}, /*cmx*/
          {3.294389,1.6345,0.9011,2.6282}, /*cfx*/
          {-4.8502,0.0011,654.8823,2.45658,0.009947,2.4842}, /*cmy*/
          {0.168031,5.5296,4.3457,5.7879}, /*cfy*/
          {14.6707,0.06261,1882.3687,6.04894,0.017474,6.8317}, /*cmz*/
          {4.867187,3.3019,2.5449,4.2047} /*cfz*/
     },
     {
          2457237.3,
          {10.587,-0.05027,1743.1657,6.71885,0.011395,6.295}, /*cmx*/
          {5.646748,3.9924,2.3642,1.179}, /*cfx*/
          {-4.5059,0.01041,711.7325,2.8513,0.010429,2.6659}, /*cmy*/
          {2.532286,1.4618,6.042,4.3485}, /*cfy*/
          {16.9029,0.03347,1882.3773,7.10871,0.013465,6.7886}, /*cmz*/
          {0.938211,5.651,4.0705,2.7643} /*cfz*/
     },
     {
          2457277.3,
          {8.3531,-0.0692,1723.8001,6.71929,0.014815,6.2435}, /*cmx*/
          {1.703058,0.0586,3.7879,6.0217}, /*cfx*/
          {-4.0369,0.02574,758.5378,2.85064,0.009803,2.8216}, /*cmy*/
          {4.886309,3.6482,1.3855,2.9273}, /*cfy*/
          {18.7669,0.01227,1882.6973,7.19742,0.017382,6.8479}, /*cmz*/
          {3.280667,1.7016,5.5344,1.3168} /*cfz*/
     },
     {
          2457317.3,
          {5.7895,-0.05458,1710.2252,5.80713,0.029884,6.1603}, /*cmx*/
          {4.052475,2.437,5.7445,4.5873}, /*cfx*/
          {-3.1497,0.02108,787.694,2.43302,0.014129,2.867}, /*cmy*/
          {0.967654,5.8795,2.9968,1.5093}, /*cfy*/
          {19.513,0.02182,1882.3126,6.14459,0.029774,6.8898}, /*cmz*/
          {5.632877,4.0484,1.0818,6.1755} /*cfz*/
     },
     {
          2457357.3,
          {3.7373,-0.02019,1704.804,3.46457,0.043802,6.195}, /*cmx*/
          {0.154522,4.831,1.697,3.2191}, /*cfx*/
          {-2.3648,0.00626,800.9098,1.35995,0.019335,2.9211}, /*cmy*/
          {3.367459,1.9006,5.0353,0.1549}, /*cfy*/
          {20.2451,0.0025,1882.3003,3.78334,0.049691,6.9149}, /*cmz*/
          {1.738621,0.1443,3.2918,4.8044} /*cfz*/
     },
     {
          2457397.3,
          {2.7614,0.0355,1703.054,0.26309,0.043342,6.211}, /*cmx*/
          {2.608033,3.9912,4.2077,1.9175}, /*cfx*/
          {-2.0013,-0.01823,803.829,0.29411,0.01818,2.9243}, /*cmy*/
          {5.832116,0.9824,1.299,5.1435}, /*cfy*/
          {20.2536,-0.00405,1881.4953,0.43289,0.044582,6.8489}, /*cmz*/
          {4.19359,5.6872,5.8099,3.5188} /*cfz*/
     },
     {
          2457437.3,
          {4.3991,0.02052,1704.073,3.8899,0.005371,6.1955}, /*cmx*/
          {5.146607,0.3945,2.2728,0.7041}, /*cfx*/
          {-2.7707,-0.00885,800.9704,1.78163,0.004848,2.896}, /*cmy*/
          {2.091165,3.7578,5.8679,3.9354}, /*cfy*/
          {19.9961,-0.00798,1882.4874,4.28659,0.004206,7.0185}, /*cmz*/
          {0.449788,2.0486,4.7742,2.2838} /*cfz*/
     },
     {
          2457477.3,
          {5.4449,0.03227,1709.1972,3.55027,0.043174,6.2536}, /*cmx*/
          {1.44498,2.9834,6.1109,5.7629}, /*cfx*/
          {-3.1779,-0.01139,791.0578,1.47853,0.019488,2.885}, /*cmy*/
          {4.667147,0.1811,3.2707,2.6946}, /*cfy*/
          {19.6584,-0.01436,1881.9583,3.74186,0.045676,6.8366}, /*cmz*/
          {3.030319,4.6172,1.4687,1.0522} /*cfz*/
     },
     {
          2457517.3,
          {6.6039,-0.01852,1712.4029,0.10968,0.041182,6.2272}, /*cmx*/
          {3.981313,2.523,2.3444,4.4595}, /*cfx*/
          {-3.5615,0.00681,783.8169,0.17112,0.017712,2.8617}, /*cmy*/
          {0.912105,5.6686,5.811,1.3907}, /*cfy*/
          {19.2868,0.00766,1881.6378,0.11019,0.046246,6.9152}, /*cmz*/
          {5.564397,4.4196,3.9545,6.0392} /*cfz*/
     },
     {
          2457557.3,
          {6.0259,-0.0533,1709.0347,3.43215,0.027784,6.1816}, /*cmx*/
          {0.150986,4.8575,4.5518,3.0896}, /*cfx*/
          {-3.4087,0.02522,789.3346,1.61831,0.012161,2.8868}, /*cmy*/
          {3.362101,2.0179,1.4368,0.0195}, /*cfy*/
          {19.7112,0.00979,1882.1332,3.81203,0.028506,6.8844}, /*cmz*/
          {1.73431,0.1712,6.1921,4.6629} /*cfz*/
     },
     {
          2457597.3,
          {4.0616,-0.06655,1704.4552,5.5729,0.014361,6.221}, /*cmx*/
          {2.539801,0.9499,0.2909,1.6547}, /*cfx*/
          {-2.5193,0.02783,801.1788,2.50049,0.009306,2.9455}, /*cmy*/
          {5.754711,4.2926,3.1077,4.8747}, /*cfy*/
          {19.7704,0.02863,1881.4812,6.08996,0.017275,6.8682}, /*cmz*/
          {4.123968,2.5609,1.7516,3.2407} /*cfz*/
     },
     {
          2457637.3,
          {1.094,-0.05504,1702.4296,6.51514,0.010215,6.2274}, /*cmx*/
          {4.89202,3.327,1.7129,0.214}, /*cfx*/
          {-1.2142,0.02183,805.784,2.86962,0.009654,2.933}, /*cmy*/
          {1.833273,0.2433,4.7244,3.4456}, /*cfy*/
          {20.4754,0.00276,1881.624,7.09802,0.013371,6.8056}, /*cmz*/
          {0.194627,4.9059,3.2559,1.7935} /*cfz*/
     },
     {
          2457677.3,
          {-1.5617,-0.06204,1707.6833,6.53989,0.015395,6.2551}, /*cmx*/
          {0.950094,5.6848,3.0631,5.0505}, /*cfx*/
          {-0.0721,0.02359,796.5716,2.79098,0.010459,2.8796}, /*cmy*/
          {4.187616,2.4457,0.0785,2.0141}, /*cfy*/
          {21.0133,-0.02862,1881.8488,7.11026,0.018008,6.8627}, /*cmz*/
          {2.538023,0.9551,4.6926,0.3545} /*cfz*/
     },
     {
          2457717.3,
          {-3.964,-0.05568,1717.4831,5.51313,0.030363,6.3133}, /*cmx*/
          {3.303954,1.7883,5.0897,3.6193}, /*cfx*/
          {0.7861,0.02405,774.4359,2.24496,0.013984,2.7901}, /*cmy*/
          {0.273942,4.6738,1.8058,0.6018}, /*cfy*/
          {20.2692,-0.01032,1881.2329,5.96005,0.033274,6.8587}, /*cmz*/
          {4.893597,3.3035,0.276,5.22} /*cfz*/
     },
     {
          2457757.3,
          {-5.9698,-0.01395,1729.1098,3.06414,0.045331,6.3393}, /*cmx*/
          {5.698054,4.172,1.0256,2.2588}, /*cfx*/
          {1.5505,0.0039,751.1464,1.15493,0.019233,2.7332}, /*cmy*/
          {2.683797,0.6469,3.8281,5.5333}, /*cfy*/
          {19.7426,-0.00297,1880.4913,3.30834,0.050218,6.898}, /*cmz*/
          {1.006002,5.7091,2.5786,3.8613} /*cfz*/
     },
     {
          2457797.3,
          {-6.7407,0.04259,1731.8421,0.82646,0.038618,6.3672}, /*cmx*/
          {1.87928,3.4229,3.6102,0.9788}, /*cfx*/
          {1.7987,-0.01802,742.8235,0.49926,0.014736,2.7616}, /*cmy*/
          {5.15916,0.0363,0.1745,4.2634}, /*cfy*/
          {19.3053,0.02015,1880.2573,0.95278,0.040977,6.8007}, /*cmz*/
          {3.471524,5.0395,5.0794,2.5737} /*cfz*/
     },
     {
          2457837.3,
          {-5.0181,0.02558,1725.9637,4.11022,0.01038,6.3276}, /*cmx*/
          {4.42539,6.0626,2.5475,6.0334}, /*cfx*/
          {1.131,-0.01096,757.9586,1.76911,0.006305,2.8273}, /*cmy*/
          {1.421893,2.6525,5.4208,3.0228}, /*cfy*/
          {20.1637,-0.00314,1880.4658,4.31456,0.007601,6.9352}, /*cmz*/
          {6.019186,1.3221,4.1376,1.3686} /*cfz*/
     },
     {
          2457877.3,
          {-3.8125,0.02652,1717.2879,3.19119,0.043382,6.2271}, /*cmx*/
          {0.721212,2.3619,5.499,4.8115}, /*cfx*/
          {0.6422,-0.00918,777.3677,1.24137,0.019082,2.8412}, /*cmy*/
          {3.990635,5.2994,2.1786,1.7929}, /*cfy*/
          {20.2763,0.00212,1880.2553,3.37795,0.04643,6.8878}, /*cmz*/
          {2.313908,3.8868,0.7369,0.1136} /*cfz*/
     },
     {
          2457917.3,
          {-2.8357,-0.02456,1713.7036,0.44049,0.039956,6.2638}, /*cmx*/
          {3.248896,1.8264,1.6755,3.4987}, /*cfx*/
          {0.3064,0.0115,783.0323,0.36,0.01668,2.8477}, /*cmy*/
          {0.224758,4.9051,4.5728,0.4713}, /*cfy*/
          {20.4314,-0.00128,1880.7551,0.50366,0.044384,6.8972}, /*cmz*/
          {4.839763,3.2998,3.2405,5.0959} /*cfz*/
     },
     {
          2457957.3,
          {-3.6813,-0.05243,1717.8658,3.61141,0.027718,6.2223}, /*cmx*/
          {5.695283,4.1957,3.9284,2.1167}, /*cfx*/
          {0.7337,0.02043,773.915,1.67327,0.011968,2.7471}, /*cmy*/
          {2.667821,0.8605,0.2403,5.3756}, /*cfy*/
          {20.4493,-0.01847,1880.4651,4.10304,0.02736,6.8794}, /*cmz*/
          {1.002681,5.738,5.3732,3.7182} /*cfz*/
     },
     {
          2457997.3,
          {-5.4861,-0.07337,1729.6253,5.7737,0.014762,6.3457}, /*cmx*/
          {1.798038,0.2994,5.8434,0.6922}, /*cfx*/
          {1.4267,0.02657,747.9451,2.52117,0.009962,2.6507}, /*cmy*/
          {5.058716,3.1163,1.7588,3.9594}, /*cfy*/
          {19.5173,-0.0141,1880.4802,6.24187,0.017547,6.8617}, /*cmz*/
          {3.387309,1.8241,0.9856,2.2831} /*cfz*/
     },
     {
          2458037.3,
          {-8.5215,-0.05202,1748.8197,6.71506,0.011734,6.365}, /*cmx*/
          {4.149285,2.6674,0.9761,5.5362}, /*cfx*/
          {2.4814,0.01166,701.466,2.81189,0.011348,2.4118}, /*cmy*/
          {1.139138,5.3166,3.4787,2.5384}, /*cfy*/
          {18.4631,-0.0275,1880.7579,7.2372,0.013597,6.8422}, /*cmz*/
          {5.738239,4.1648,2.3938,0.8332} /*cfz*/
     },
     {
          2458077.3,
          {-11.2513,-0.0432,1774.2549,6.68348,0.017708,6.4926}, /*cmx*/
          {0.20899,5.0083,2.3896,4.0927}, /*cfx*/
          {3.2388,-0.00233,637.6711,2.7162,0.010944,2.1825}, /*cmy*/
          {3.500825,1.1757,5.1157,1.1149}, /*cfy*/
          {17.4766,-0.05805,1880.9589,7.12272,0.019745,6.8519}, /*cmz*/
          {1.796981,0.2131,3.8602,5.675} /*cfz*/
     },
     {
          2458117.3,
          {-13.0288,-0.04812,1797.9407,5.46116,0.032507,6.6148}, /*cmx*/
          {2.56759,1.0885,4.3583,2.6739}, /*cfx*/
          {3.2084,0.00421,566.5957,2.18737,0.0144,1.9372}, /*cmy*/
          {5.885537,3.36,0.4663,6.0162}, /*cfy*/
          {15.6178,-0.04032,1880.2736,5.8106,0.036571,6.8394}, /*cmz*/
          {4.154325,2.5699,5.8206,4.2563} /*cfz*/
     },
     {
          2458157.3,
          {-14.5626,-0.01087,1814.923,2.79756,0.048301,6.6627}, /*cmx*/
          {4.970109,3.4732,0.3271,1.3197}, /*cfx*/
          {3.1595,0.00209,511.6106,1.06903,0.019188,1.8357}, /*cmy*/
          {2.031303,5.6086,2.537,4.6734}, /*cfy*/
          {14.085,-0.00507,1879.8883,2.86801,0.04957,6.8253}, /*cmz*/
          {0.272191,4.9773,1.8422,2.9083} /*cfz*/
     },
     {
          2458197.3,
          {-15.0211,0.0343,1817.8846,1.35334,0.034718,6.5974}, /*cmx*/
          {1.160797,2.7792,2.9357,0.0538}, /*cfx*/
          {3.125,0.00223,499.3972,0.56948,0.013618,1.8614}, /*cmy*/
          {4.518229,5.0983,5.1196,3.4116}, /*cfy*/
          {13.3797,0.04617,1879.4386,1.35858,0.038373,6.8109}, /*cmz*/
          {2.746707,4.2863,4.3913,1.6231} /*cfz*/
     },
     {
          2458237.3,
          {-13.7904,0.03054,1808.5463,4.31747,0.014974,6.6712}, /*cmx*/
          {3.712936,5.4094,2.1447,5.1153}, /*cfx*/
          {3.3403,-0.0078,536.1883,1.67355,0.00584,2.088}, /*cmy*/
          {0.774034,1.3824,4.341,2.1651}, /*cfy*/
          {15.25,0.00564,1879.2462,4.43836,0.013696,6.784}, /*cmz*/
          {5.300106,0.581,3.3798,0.4196} /*cfz*/
     },
     {
          2458277.3,
          {-12.587,0.01844,1793.0828,2.93154,0.044958,6.4786}, /*cmx*/
          {0.005006,1.6954,4.8338,3.8668}, /*cfx*/
          {3.1522,-0.00061,582.9908,1.08213,0.018019,2.1486}, /*cmy*/
          {3.325994,3.9681,0.9298,0.8952}, /*cfy*/
          {15.9555,0.00852,1879.8077,3.08375,0.048143,6.8436}, /*cmz*/
          {1.592636,3.1639,0.0178,5.4589} /*cfz*/
     },
     {
          2458317.3,
          {-11.9009,-0.02701,1787.701,0.80677,0.041592,6.5392}, /*cmx*/
          {2.523801,1.122,0.9815,2.5544}, /*cfx*/
          {3.0562,0.00782,596.3603,0.44998,0.016838,2.1404}, /*cmy*/
          {5.830409,3.7781,3.2855,5.8597}, /*cfy*/
          {16.3967,-0.01755,1880.2957,0.92588,0.042933,6.8402}, /*cmz*/
          {4.111045,2.5636,2.497,4.1441} /*cfz*/
     },
     {
          2458357.3,
          {-12.8817,-0.04193,1797.684,4.10034,0.027586,6.5639}, /*cmx*/
          {4.963238,3.4982,3.1959,1.1615}, /*cfx*/
          {3.3393,-0.00297,566.8495,1.77357,0.012182,1.9573}, /*cmy*/
          {1.987394,5.8898,5.1015,4.4817}, /*cfy*/
          {15.7461,-0.04348,1879.6135,4.38925,0.028632,6.7474}, /*cmz*/
          {0.265727,5.0128,4.5705,2.7626} /*cfz*/
     },
     {
          2458397.3,
          {-14.2663,-0.06202,1817.2146,6.28256,0.017374,6.6509}, /*cmx*/
          {1.060826,5.8784,4.9071,6.0216}, /*cfx*/
          {3.2599,-0.00635,498.381,2.59364,0.012707,1.6471}, /*cmy*/
          {4.385169,1.8152,0.4786,3.0768}, /*cfy*/
          {13.9789,-0.05562,1880.6472,6.5264,0.016864,6.8093}, /*cmz*/
          {2.643897,1.074,0.2041,1.3214} /*cfz*/
     },
     {
          2458437.3,
          {-16.659,-0.03551,1841.6654,7.1743,0.015655,6.6512}, /*cmx*/
          {3.408873,1.9244,0.1187,4.5715}, /*cfx*/
          {2.9162,-0.014,399.2344,2.98854,0.012069,1.2359}, /*cmy*/
          {0.490409,3.9562,2.2122,1.6933}, /*cfy*/
          {11.329,-0.05222,1880.4672,7.47365,0.014641,6.7899}, /*cmz*/
          {4.989691,3.4183,1.5139,6.1583} /*cfz*/
     },
     {
          2458477.3,
          {-18.7737,-0.00685,1863.8584,7.00958,0.021427,6.7446}, /*cmx*/
          {5.750871,4.2271,1.5976,3.1328}, /*cfx*/
          {2.3339,-0.02611,284.4973,2.98786,0.012263,0.8323}, /*cmy*/
          {2.916722,6.1032,3.7446,0.3519}, /*cfy*/
          {8.9315,-0.06914,1881.04,7.19752,0.021572,6.8309}, /*cmz*/
          {1.045086,5.7464,3.0678,4.7112} /*cfz*/
     },
     {
          2458517.3,
          {-19.3437,-0.02092,1876.2873,5.55067,0.035873,6.802}, /*cmx*/
          {1.827753,0.2764,3.5192,1.7213}, /*cfx*/
          {1.3926,-0.02139,178.9318,2.38111,0.015676,0.4918}, /*cmy*/
          {5.458348,2.0212,5.3837,5.493}, /*cfy*/
          {6.5449,-0.05976,1880.7043,5.69347,0.03734,6.8474}, /*cmz*/
          {3.402376,1.823,5.0783,3.2936} /*cfz*/
     },
     {
          2458557.3,
          {-19.7813,-0.00953,1880.9743,2.63479,0.050154,6.8337}, /*cmx*/
          {4.234247,2.6726,5.8161,0.3788}, /*cfx*/
          {0.5262,-0.00039,115.7507,1.13744,0.021307,0.3828}, /*cmy*/
          {1.887463,4.3113,1.1712,4.384}, /*cfy*/
          {4.4762,-0.00675,1880.924,2.63775,0.049865,6.8035}, /*cmz*/
          {5.806763,4.2205,1.0783,1.9443} /*cfz*/
     },
     {
          2458597.3,
          {-19.7795,0.00218,1881.3804,1.63948,0.033785,6.7271}, /*cmx*/
          {0.430609,2.0015,2.1131,5.3897}, /*cfx*/
          {0.2957,0.02245,107.2848,0.6953,0.01484,0.444}, /*cmy*/
          {4.45812,3.5859,3.8719,2.9546}, /*cfy*/
          {3.6777,0.06112,1880.1841,1.66216,0.035406,6.8332}, /*cmz*/
          {2.002966,3.5213,3.6991,0.6761} /*cfz*/
     },
     {
          2458637.3,
          {-19.8731,0.02988,1879.2784,4.39065,0.015841,6.8028}, /*cmx*/
          {2.986642,4.6151,1.3457,4.1927}, /*cfx*/
          {1.3027,0.00271,147.5781,1.9163,0.008051,0.6297}, /*cmy*/
          {0.439627,6.2797,2.8333,1.5147}, /*cfy*/
          {5.955,0.0209,1880.6311,4.60177,0.019326,6.8407}, /*cmz*/
          {4.559739,6.1301,2.7598,5.738} /*cfz*/
     },
     {
          2458677.3,
          {-19.0304,0.00838,1872.8104,2.78466,0.04791,6.7706}, /*cmx*/
          {5.559307,0.9039,4.0417,2.9244}, /*cfx*/
          {1.6705,0.00527,207.8808,1.20059,0.020455,0.8026}, /*cmy*/
          {2.816391,2.6024,5.8288,0.1534}, /*cfy*/
          {7.2602,0.00937,1880.9315,2.88061,0.049987,6.7862}, /*cmz*/
          {0.85117,2.4324,5.5747,4.5025} /*cfz*/
     },
     {
          2458717.3,
          {-18.6663,-0.02105,1870.8069,1.1929,0.043571,6.7979}, /*cmx*/
          {1.788285,0.3074,0.188,1.6079}, /*cfx*/
          {1.7619,-0.00554,222.5954,0.53884,0.018393,0.7288}, /*cmy*/
          {5.283348,2.3552,1.9038,5.1288}, /*cfy*/
          {7.8299,-0.03558,1880.8463,1.27743,0.043088,6.8208}, /*cmz*/
          {3.36383,1.8358,1.7157,3.1803} /*cfz*/
     },
     {
          2458757.3,
          {-19.3598,-0.01406,1875.7955,4.69818,0.027302,6.8067}, /*cmx*/
          {4.220306,2.704,2.2375,0.2175}, /*cfx*/
          {1.4049,-0.02403,173.2775,1.99281,0.014823,0.4799}, /*cmy*/
          {1.511399,4.5201,3.7234,4.0207}, /*cfy*/
          {6.4974,-0.05898,1880.6669,4.68441,0.030042,6.7032}, /*cmz*/
          {5.79387,4.2491,3.8252,1.7784} /*cfz*/
     },
     {
          2458797.3,
          {-19.7677,-0.01764,1881.3639,6.7718,0.02064,6.818}, /*cmx*/
          {0.309923,5.0476,3.9341,5.0623}, /*cfx*/
          {0.5921,-0.04049,85.8326,2.95922,0.012604,0.25}, /*cmy*/
          {4.352318,0.4247,5.3657,3.6408}, /*cfy*/
          {4.2144,-0.0823,1881.7199,6.91922,0.016129,6.7804}, /*cmz*/
          {1.881935,0.3091,5.588,0.3433} /*cfz*/
     },
     {
          2458837.3,
          {-20.2465,0.0015,1881.0575,7.61334,0.017825,6.7496}, /*cmx*/
          {2.651597,1.0559,5.4107,3.6053}, /*cfx*/
          {-0.9347,-0.03199,101.2283,3.34331,0.013218,0.6}, /*cmy*/
          {1.999436,2.6007,0.6743,3.1718}, /*cfy*/
          {0.662,-0.06663,1881.1233,7.72979,0.016411,6.7236}, /*cmz*/
          {4.221093,2.6536,0.6836,5.1736} /*cfz*/
     },
     {
          2458877.3,
          {-20.5324,0.03575,1870.8125,7.27412,0.024069,6.7374}, /*cmx*/
          {4.988126,3.3498,0.6937,2.156}, /*cfx*/
          {-2.4646,-0.01889,223.3075,3.11819,0.012689,1.002}, /*cmy*/
          {4.744173,4.7548,2.3153,1.9627}, /*cfy*/
          {-2.5769,-0.06186,1882.4153,7.32675,0.022373,6.7876}, /*cmz*/
          {0.272164,4.9712,2.2727,3.731} /*cfz*/
     },
     {
          2458917.3,
          {-19.5818,0.02158,1853.9074,5.65069,0.037465,6.6943}, /*cmx*/
          {1.061052,5.6809,2.6433,0.7412}, /*cfx*/
          {-3.3223,-0.01859,332.3424,2.39143,0.016063,1.3425}, /*cmy*/
          {0.920858,0.6806,3.9582,0.6173}, /*cfy*/
          {-4.8374,-0.06309,1882.1871,5.72426,0.037147,6.8141}, /*cmz*/
          {2.627512,1.0443,4.2868,2.3144} /*cfz*/
     },
     {
          2458957.3,
          {-18.5923,-0.00556,1840.1093,2.6161,0.049491,6.6284}, /*cmx*/
          {3.465139,1.8006,4.9472,5.6817}, /*cfx*/
          {-3.9598,-0.00342,399.7272,1.10335,0.021472,1.4726}, /*cmy*/
          {3.365073,3.0489,6.1169,5.5932}, /*cfy*/
          {-6.8437,-0.01064,1882.3865,2.66169,0.050754,6.8187}, /*cmz*/
          {5.031475,3.4429,0.2983,0.9615} /*cfz*/
     },
     {
          2458997.3,
          {-18.1226,-0.03746,1837.2094,1.6072,0.035565,6.6381}, /*cmx*/
          {5.944545,1.1028,1.252,4.4042}, /*cfx*/
          {-4.0471,0.00945,410.5306,0.74479,0.014903,1.3912}, /*cmy*/
          {5.856643,2.1709,2.5096,4.2956}, /*cfy*/
          {-7.5182,0.05201,1882.0852,1.72346,0.034598,6.7783}, /*cmz*/
          {1.227747,2.7684,2.9084,5.9828} /*cfz*/
     },
     {
          2459037.3,
          {-19.7783,0.01735,1847.3071,4.46387,0.017279,6.6275}, /*cmx*/
          {2.218634,3.7077,0.2978,3.1987}, /*cfx*/
          {-3.6163,0.01313,363.3196,1.97868,0.008113,1.1498}, /*cmy*/
          {2.122562,4.9533,1.5296,3.1325}, /*cfy*/
          {-5.7882,0.03894,1883.005,4.67208,0.020556,6.9365}, /*cmz*/
          {3.785515,5.3801,2.1382,4.7736} /*cfz*/
     },
     {
          2459077.3,
          {-19.8212,0.00113,1858.8131,2.76466,0.050734,6.741}, /*cmx*/
          {4.792599,0.0132,3.1533,1.9508}, /*cfx*/
          {-3.0185,0.00393,299.8555,1.24388,0.022105,1.0463}, /*cmy*/
          {4.671899,1.3213,4.4704,1.8247}, /*cfy*/
          {-4.0654,0.00773,1882.3456,2.80071,0.051277,6.824}, /*cmz*/
          {0.077279,1.6626,4.8058,3.5167} /*cfz*/
     },
     {
          2459117.3,
          {-19.7963,0.00223,1861.0301,1.46587,0.044038,6.7484}, /*cmx*/
          {1.018992,5.6989,5.5806,0.6251}, /*cfx*/
          {-2.8695,-0.01449,285.7292,0.59435,0.019474,1.1086}, /*cmy*/
          {0.893452,0.8101,0.5393,0.5288}, /*cfy*/
          {-3.4595,-0.04653,1882.0183,1.47801,0.045034,6.8471}, /*cmz*/
          {2.586988,1.0601,0.925,2.1954} /*cfz*/
     },
     {
          2459157.3,
          {-19.4624,0.022,1851.4706,5.01128,0.028336,6.5874}, /*cmx*/
          {3.444004,1.828,1.2664,5.5117}, /*cfx*/
          {-3.5729,-0.01405,337.9877,2.15769,0.01301,1.3907}, /*cmy*/
          {3.34879,3.0941,2.282,5.4358}, /*cfy*/
          {-5.1511,-0.05706,1882.313,5.02187,0.029239,6.8231}, /*cmz*/
          {5.011557,3.451,3.0628,0.7821} /*cfz*/
     },
     {
          2459197.3,
          {-18.4981,0.04126,1832.5072,7.00383,0.017822,6.5656}, /*cmx*/
          {5.807959,4.1466,3.0719,4.0658}, /*cfx*/
          {-4.1736,-0.02162,432.5953,2.9999,0.013249,1.7592}, /*cmy*/
          {5.749494,5.3126,3.8038,4.0233}, /*cfy*/
          {-7.4252,-0.07816,1882.2874,7.25301,0.017734,6.8436}, /*cmz*/
          {1.093032,5.8112,4.6545,5.6257} /*cfz*/
     }

};

static unsigned idn_list[] = {2,136,270,371};
static double freq_list[] = {3.5516,1.7693,0.8782,0.3765};
static double delt_list[] = {30.0,30.0,40.0,40.0};

BDL_Dataset jupiter_1020 = {
     4, /*nsat*/
     2455197.5, /*djj*/
     idn_list,
     freq_list,
     delt_list,
     moonrecords
};

