"""Ensure that document models used in API do not change fields."""

import pytest
from importlib import import_module


ref_model_fields = {
    "emmet.core._general_store.GeneralStoreDoc": [
        "kind",
        "markdown",
        "meta",
        "last_updated",
    ],
    "emmet.core._messages.MessagesDoc": [
        "title",
        "body",
        "authors",
        "type",
        "last_updated",
    ],
    "emmet.core._user_settings.UserSettingsDoc": ["consumer_id", "settings"],
    "emmet.core.absorption.AbsorptionDoc": [
        "builder_meta",
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "material_id",
        "deprecated",
        "deprecation_reasons",
        "last_updated",
        "origins",
        "warnings",
        "structure",
        "property_name",
        "task_id",
        "energies",
        "energy_max",
        "absorption_coefficient",
        "average_imaginary_dielectric",
        "average_real_dielectric",
        "bandgap",
        "nkpoints",
    ],
    "emmet.core.alloys.AlloyPairDoc": ["builder_meta", "alloy_pair", "pair_id"],
    "emmet.core.bonds.BondingDoc": [
        "builder_meta",
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "material_id",
        "deprecated",
        "deprecation_reasons",
        "last_updated",
        "origins",
        "warnings",
        "structure",
        "property_name",
        "structure_graph",
        "method",
        "bond_types",
        "bond_length_stats",
        "coordination_envs",
        "coordination_envs_anonymous",
    ],
    "emmet.core.chemenv.ChemEnvDoc": [
        "builder_meta",
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "material_id",
        "deprecated",
        "deprecation_reasons",
        "last_updated",
        "origins",
        "warnings",
        "structure",
        "property_name",
        "valences",
        "species",
        "chemenv_symbol",
        "chemenv_iupac",
        "chemenv_iucr",
        "chemenv_name",
        "chemenv_name_with_alternatives",
        "csm",
        "method",
        "mol_from_site_environments",
        "wyckoff_positions",
    ],
    "emmet.core.dois.DOIDoc": ["doi", "bibtex", "material_id"],
    "emmet.core.elasticity.ElasticityDoc": [
        "builder_meta",
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "material_id",
        "deprecated",
        "deprecation_reasons",
        "last_updated",
        "origins",
        "warnings",
        "structure",
        "property_name",
        "order",
        "elastic_tensor",
        "compliance_tensor",
        "bulk_modulus",
        "shear_modulus",
        "sound_velocity",
        "thermal_conductivity",
        "young_modulus",
        "universal_anisotropy",
        "homogeneous_poisson",
        "debye_temperature",
        "fitting_data",
        "fitting_method",
        "state",
    ],
    "emmet.core.electrode.InsertionElectrodeDoc": [
        "builder_meta",
        "battery_type",
        "battery_id",
        "thermo_type",
        "battery_formula",
        "working_ion",
        "num_steps",
        "max_voltage_step",
        "last_updated",
        "framework",
        "framework_formula",
        "elements",
        "nelements",
        "chemsys",
        "formula_anonymous",
        "warnings",
        "formula_charge",
        "formula_discharge",
        "max_delta_volume",
        "average_voltage",
        "capacity_grav",
        "capacity_vol",
        "energy_grav",
        "energy_vol",
        "fracA_charge",
        "fracA_discharge",
        "stability_charge",
        "stability_discharge",
        "id_charge",
        "id_discharge",
        "host_structure",
        "adj_pairs",
        "material_ids",
        "entries_composition_summary",
        "electrode_object",
    ],
    "emmet.core.electronic_structure.ElectronicStructureDoc": [
        "task_id",
        "band_gap",
        "cbm",
        "vbm",
        "efermi",
        "is_gap_direct",
        "is_metal",
        "magnetic_ordering",
        "builder_meta",
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "material_id",
        "deprecated",
        "deprecation_reasons",
        "last_updated",
        "origins",
        "warnings",
        "structure",
        "property_name",
        "bandstructure",
        "dos",
    ],
    "emmet.core.eos.EOSDoc": [
        "builder_meta",
        "chemsys",
        "composition",
        "composition_reduced",
        "density",
        "density_atomic",
        "deprecated",
        "deprecation_reasons",
        "elements",
        "energies",
        "eos",
        "formula_anonymous",
        "formula_pretty",
        "last_updated",
        "material_id",
        "nelements",
        "nsites",
        "origins",
        "structure",
        "symmetry",
        "volume",
        "volumes",
        "warnings",
    ],
    "emmet.core.grain_boundary.GrainBoundaryDoc": [
        "material_id",
        "sigma",
        "type",
        "rotation_axis",
        "gb_plane",
        "rotation_angle",
        "gb_energy",
        "initial_structure",
        "final_structure",
        "pretty_formula",
        "w_sep",
        "cif",
        "chemsys",
        "last_updated",
    ],
    "emmet.core.magnetism.MagnetismDoc": [
        "builder_meta",
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "material_id",
        "deprecated",
        "deprecation_reasons",
        "last_updated",
        "origins",
        "warnings",
        "structure",
        "property_name",
        "ordering",
        "is_magnetic",
        "exchange_symmetry",
        "num_magnetic_sites",
        "num_unique_magnetic_sites",
        "types_of_magnetic_species",
        "magmoms",
        "total_magnetization",
        "total_magnetization_normalized_vol",
        "total_magnetization_normalized_formula_units",
    ],
    "emmet.core.molecules.atomic.PartialChargesDoc": [
        "charge",
        "spin_multiplicity",
        "natoms",
        "elements",
        "nelements",
        "nelectrons",
        "composition",
        "composition_reduced",
        "formula_alphabetical",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "symmetry",
        "species_hash",
        "coord_hash",
        "property_name",
        "property_id",
        "molecule_id",
        "deprecated",
        "deprecation_reasons",
        "level_of_theory",
        "solvent",
        "lot_solvent",
        "last_updated",
        "origins",
        "warnings",
        "method",
        "partial_charges",
    ],
    "emmet.core.molecules.atomic.PartialSpinsDoc": [
        "charge",
        "spin_multiplicity",
        "natoms",
        "elements",
        "nelements",
        "nelectrons",
        "composition",
        "composition_reduced",
        "formula_alphabetical",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "symmetry",
        "species_hash",
        "coord_hash",
        "property_name",
        "property_id",
        "molecule_id",
        "deprecated",
        "deprecation_reasons",
        "level_of_theory",
        "solvent",
        "lot_solvent",
        "last_updated",
        "origins",
        "warnings",
        "method",
        "partial_spins",
    ],
    "emmet.core.molecules.bonds.MoleculeBondingDoc": [
        "charge",
        "spin_multiplicity",
        "natoms",
        "elements",
        "nelements",
        "nelectrons",
        "composition",
        "composition_reduced",
        "formula_alphabetical",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "symmetry",
        "species_hash",
        "coord_hash",
        "property_name",
        "property_id",
        "molecule_id",
        "deprecated",
        "deprecation_reasons",
        "level_of_theory",
        "solvent",
        "lot_solvent",
        "last_updated",
        "origins",
        "warnings",
        "molecule_graph",
        "method",
        "bond_types",
        "bonds",
        "bonds_nometal",
    ],
    "emmet.core.molecules.orbitals.OrbitalDoc": [
        "charge",
        "spin_multiplicity",
        "natoms",
        "elements",
        "nelements",
        "nelectrons",
        "composition",
        "composition_reduced",
        "formula_alphabetical",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "symmetry",
        "species_hash",
        "coord_hash",
        "property_name",
        "property_id",
        "molecule_id",
        "deprecated",
        "deprecation_reasons",
        "level_of_theory",
        "solvent",
        "lot_solvent",
        "last_updated",
        "origins",
        "warnings",
        "open_shell",
        "nbo_population",
        "nbo_lone_pairs",
        "nbo_bonds",
        "nbo_three_center_bonds",
        "nbo_hyperbonds",
        "nbo_interactions",
        "alpha_population",
        "beta_population",
        "alpha_lone_pairs",
        "beta_lone_pairs",
        "alpha_bonds",
        "beta_bonds",
        "alpha_three_center_bonds",
        "beta_three_center_bonds",
        "alpha_hyperbonds",
        "beta_hyperbonds",
        "alpha_interactions",
        "beta_interactions",
    ],
    "emmet.core.molecules.redox.RedoxDoc": [
        "charge",
        "spin_multiplicity",
        "natoms",
        "elements",
        "nelements",
        "nelectrons",
        "composition",
        "composition_reduced",
        "formula_alphabetical",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "symmetry",
        "species_hash",
        "coord_hash",
        "property_name",
        "property_id",
        "molecule_id",
        "deprecated",
        "deprecation_reasons",
        "level_of_theory",
        "solvent",
        "lot_solvent",
        "last_updated",
        "origins",
        "warnings",
        "base_property_id",
        "electron_affinity",
        "ea_task_id",
        "ionization_energy",
        "ie_task_id",
        "reduction_energy",
        "reduction_free_energy",
        "red_molecule_id",
        "red_property_id",
        "oxidation_energy",
        "oxidation_free_energy",
        "ox_molecule_id",
        "ox_property_id",
        "reduction_potential",
        "oxidation_potential",
    ],
    "emmet.core.molecules.summary.MoleculeSummaryDoc": [
        "charge",
        "spin_multiplicity",
        "natoms",
        "elements",
        "nelements",
        "nelectrons",
        "composition",
        "composition_reduced",
        "formula_alphabetical",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "symmetry",
        "species_hash",
        "coord_hash",
        "property_name",
        "property_id",
        "molecule_id",
        "deprecated",
        "deprecation_reasons",
        "level_of_theory",
        "solvent",
        "lot_solvent",
        "last_updated",
        "origins",
        "warnings",
        "molecules",
        "molecule_levels_of_theory",
        "inchi",
        "inchi_key",
        "task_ids",
        "similar_molecules",
        "constituent_molecules",
        "unique_calc_types",
        "unique_task_types",
        "unique_levels_of_theory",
        "unique_solvents",
        "unique_lot_solvents",
        "thermo",
        "vibration",
        "orbitals",
        "partial_charges",
        "partial_spins",
        "bonding",
        "multipole_moments",
        "redox",
        "metal_binding",
        "has_props",
    ],
    "emmet.core.molecules.thermo.MoleculeThermoDoc": [
        "charge",
        "spin_multiplicity",
        "natoms",
        "elements",
        "nelements",
        "nelectrons",
        "composition",
        "composition_reduced",
        "formula_alphabetical",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "symmetry",
        "species_hash",
        "coord_hash",
        "property_name",
        "property_id",
        "molecule_id",
        "deprecated",
        "deprecation_reasons",
        "level_of_theory",
        "solvent",
        "lot_solvent",
        "last_updated",
        "origins",
        "warnings",
        "electronic_energy",
        "correction",
        "base_level_of_theory",
        "base_solvent",
        "base_lot_solvent",
        "correction_level_of_theory",
        "correction_solvent",
        "correction_lot_solvent",
        "combined_lot_solvent",
        "zero_point_energy",
        "rt",
        "total_enthalpy",
        "total_entropy",
        "translational_enthalpy",
        "translational_entropy",
        "rotational_enthalpy",
        "rotational_entropy",
        "vibrational_enthalpy",
        "vibrational_entropy",
        "free_energy",
    ],
    "emmet.core.molecules.vibration.VibrationDoc": [
        "charge",
        "spin_multiplicity",
        "natoms",
        "elements",
        "nelements",
        "nelectrons",
        "composition",
        "composition_reduced",
        "formula_alphabetical",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "symmetry",
        "species_hash",
        "coord_hash",
        "property_name",
        "property_id",
        "molecule_id",
        "deprecated",
        "deprecation_reasons",
        "level_of_theory",
        "solvent",
        "lot_solvent",
        "last_updated",
        "origins",
        "warnings",
        "molecule",
        "frequencies",
        "frequency_modes",
        "ir_intensities",
        "ir_activities",
        "raman_intensities",
        "raman_activities",
    ],
    "emmet.core.molecules_jcesr.MoleculesDoc": [
        "elements",
        "nelements",
        "EA",
        "IE",
        "charge",
        "pointgroup",
        "smiles",
        "task_id",
        "molecule",
        "formula_pretty",
        "svg",
    ],
    "emmet.core.oxidation_states.OxidationStateDoc": [
        "builder_meta",
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "material_id",
        "deprecated",
        "deprecation_reasons",
        "last_updated",
        "origins",
        "warnings",
        "structure",
        "property_name",
        "possible_species",
        "possible_valences",
        "average_oxidation_states",
        "method",
    ],
    "emmet.core.phonon.PhononBSDOSDoc": [
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "identifier",
        "phonon_method",
        "phonon_bandstructure",
        "phonon_dos",
        "epsilon_static",
        "epsilon_electronic",
        "born",
        "force_constants",
        "last_updated",
        "sum_rules_breaking",
        "structure",
        "total_dft_energy",
        "volume_per_formula_unit",
        "formula_units",
        "supercell_matrix",
        "primitive_matrix",
        "code",
        "post_process_settings",
        "thermal_displacement_data",
        "calc_meta",
        "material_id",
        "task_ids",
    ],
    "emmet.core.polar.DielectricDoc": [
        "builder_meta",
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "material_id",
        "deprecated",
        "deprecation_reasons",
        "last_updated",
        "origins",
        "warnings",
        "structure",
        "property_name",
        "total",
        "ionic",
        "electronic",
        "e_total",
        "e_ionic",
        "e_electronic",
        "n",
    ],
    "emmet.core.polar.PiezoelectricDoc": [
        "builder_meta",
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "material_id",
        "deprecated",
        "deprecation_reasons",
        "last_updated",
        "origins",
        "warnings",
        "structure",
        "property_name",
        "total",
        "ionic",
        "electronic",
        "e_ij_max",
        "max_direction",
        "strain_for_max",
    ],
    "emmet.core.provenance.ProvenanceDoc": [
        "builder_meta",
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "material_id",
        "deprecated",
        "deprecation_reasons",
        "last_updated",
        "origins",
        "warnings",
        "structure",
        "property_name",
        "created_at",
        "references",
        "authors",
        "remarks",
        "tags",
        "theoretical",
        "database_IDs",
        "history",
    ],
    "emmet.core.qchem.molecule.MoleculeDoc": [
        "builder_meta",
        "charge",
        "spin_multiplicity",
        "natoms",
        "elements",
        "nelements",
        "nelectrons",
        "composition",
        "composition_reduced",
        "formula_alphabetical",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "symmetry",
        "species_hash",
        "coord_hash",
        "molecule_id",
        "molecule",
        "deprecated",
        "deprecation_reasons",
        "initial_molecules",
        "task_ids",
        "deprecated_tasks",
        "calc_types",
        "last_updated",
        "created_at",
        "origins",
        "warnings",
        "species",
        "molecules",
        "molecule_levels_of_theory",
        "inchi",
        "inchi_key",
        "task_types",
        "levels_of_theory",
        "solvents",
        "lot_solvents",
        "unique_calc_types",
        "unique_task_types",
        "unique_levels_of_theory",
        "unique_solvents",
        "unique_lot_solvents",
        "entries",
        "best_entries",
        "constituent_molecules",
        "similar_molecules",
    ],
    "emmet.core.qchem.task.TaskDocument": [
        "charge",
        "spin_multiplicity",
        "natoms",
        "elements",
        "nelements",
        "nelectrons",
        "composition",
        "composition_reduced",
        "formula_alphabetical",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "symmetry",
        "species_hash",
        "coord_hash",
        "builder_meta",
        "calc_code",
        "version",
        "dir_name",
        "task_id",
        "completed",
        "completed_at",
        "last_updated",
        "is_valid",
        "state",
        "cputime",
        "walltime",
        "calcs_reversed",
        "orig",
        "output",
        "critic2",
        "custom_smd",
        "special_run_type",
        "smiles",
        "tags",
        "warnings",
    ],
    "emmet.core.robocrys.RobocrystallogapherDoc": [
        "builder_meta",
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "material_id",
        "deprecated",
        "deprecation_reasons",
        "last_updated",
        "origins",
        "warnings",
        "structure",
        "property_name",
        "description",
        "condensed_structure",
        "robocrys_version",
    ],
    "emmet.core.similarity.SimilarityDoc": [
        "builder_meta",
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "material_id",
        "method",
        "deprecated",
        "deprecation_reasons",
        "last_updated",
        "origins",
        "warnings",
        "structure",
        "property_name",
        "sim",
        "feature_vector",
    ],
    "emmet.core.substrates.SubstratesDoc": [
        "sub_form",
        "sub_id",
        "film_orient",
        "area",
        "energy",
        "film_id",
        "norients",
        "orient",
    ],
    "emmet.core.summary.SummaryDoc": [
        "builder_meta",
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "material_id",
        "deprecated",
        "deprecation_reasons",
        "last_updated",
        "origins",
        "warnings",
        "structure",
        "property_name",
        "task_ids",
        "uncorrected_energy_per_atom",
        "energy_per_atom",
        "formation_energy_per_atom",
        "energy_above_hull",
        "is_stable",
        "equilibrium_reaction_energy_per_atom",
        "decomposes_to",
        "xas",
        "grain_boundaries",
        "band_gap",
        "cbm",
        "vbm",
        "efermi",
        "is_gap_direct",
        "is_metal",
        "es_source_calc_id",
        "bandstructure",
        "dos",
        "dos_energy_up",
        "dos_energy_down",
        "is_magnetic",
        "ordering",
        "total_magnetization",
        "total_magnetization_normalized_vol",
        "total_magnetization_normalized_formula_units",
        "num_magnetic_sites",
        "num_unique_magnetic_sites",
        "types_of_magnetic_species",
        "bulk_modulus",
        "shear_modulus",
        "universal_anisotropy",
        "homogeneous_poisson",
        "e_total",
        "e_ionic",
        "e_electronic",
        "n",
        "e_ij_max",
        "weighted_surface_energy_EV_PER_ANG2",
        "weighted_surface_energy",
        "weighted_work_function",
        "surface_anisotropy",
        "shape_factor",
        "has_reconstructed",
        "possible_species",
        "has_props",
        "theoretical",
        "database_IDs",
    ],
    "emmet.core.surface_properties.SurfacePropDoc": [
        "surfaces",
        "weighted_surface_energy_EV_PER_ANG2",
        "weighted_surface_energy",
        "surface_anisotropy",
        "pretty_formula",
        "shape_factor",
        "weighted_work_function",
        "has_reconstructed",
        "material_id",
        "structure",
    ],
    "emmet.core.synthesis.core.SynthesisSearchResultModel": [
        "doi",
        "paragraph_string",
        "synthesis_type",
        "reaction_string",
        "reaction",
        "target",
        "targets_formula",
        "precursors_formula",
        "targets_formula_s",
        "precursors_formula_s",
        "precursors",
        "operations",
        "search_score",
        "highlights",
    ],
    "emmet.core.tasks.TaskDoc": [
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "batch_id",
        "calc_type",
        "completed_at",
        "dir_name",
        "icsd_id",
        "input",
        "last_updated",
        "orig_inputs",
        "output",
        "run_type",
        "structure",
        "tags",
        "task_id",
        "task_type",
        "transformations",
        "vasp_objects",
        "additional_json",
        "analysis",
        "author",
        "calcs_reversed",
        "custodian",
        "entry",
        "included_objects",
        "run_stats",
        "state",
        "task_label",
    ],
    "emmet.core.thermo.ThermoDoc": [
        "builder_meta",
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "material_id",
        "deprecated",
        "deprecation_reasons",
        "last_updated",
        "origins",
        "warnings",
        "structure",
        "property_name",
        "thermo_type",
        "thermo_id",
        "uncorrected_energy_per_atom",
        "energy_per_atom",
        "energy_uncertainy_per_atom",
        "formation_energy_per_atom",
        "energy_above_hull",
        "is_stable",
        "equilibrium_reaction_energy_per_atom",
        "decomposes_to",
        "decomposition_enthalpy",
        "decomposition_enthalpy_decomposes_to",
        "energy_type",
        "entry_types",
        "entries",
    ],
    "emmet.core.vasp.material.MaterialsDoc": [
        "builder_meta",
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "material_id",
        "deprecated",
        "deprecation_reasons",
        "last_updated",
        "origins",
        "warnings",
        "structure",
        "initial_structures",
        "task_ids",
        "deprecated_tasks",
        "calc_types",
        "created_at",
        "task_types",
        "run_types",
        "entries",
    ],
    "emmet.core.xas.XASDoc": [
        "builder_meta",
        "nsites",
        "elements",
        "nelements",
        "composition",
        "composition_reduced",
        "formula_pretty",
        "formula_anonymous",
        "chemsys",
        "volume",
        "density",
        "density_atomic",
        "symmetry",
        "spectrum_name",
        "material_id",
        "spectrum_id",
        "last_updated",
        "warnings",
        "spectrum",
        "task_ids",
        "absorbing_element",
        "spectrum_type",
        "edge",
    ],
}


@pytest.mark.parametrize("import_str,ref_fields", ref_model_fields.items())
def test_model_field_drift(import_str, ref_fields):
    module, class_name = import_str.rsplit(".", 1)
    model_class = getattr(import_module(module), class_name)
    assert set(model_class.model_fields) == set(ref_fields)
