package diStorm3;

import java.util.HashMap;
import java.util.Map;

public class Opcodes {
	private static Map<Integer, OpcodeEnum> mOpcodes;
	
	public static OpcodeEnum lookup(int op)
	{
		return mOpcodes.get(op);
	}
	
	static {
		mOpcodes = new HashMap<Integer, OpcodeEnum>();
		mOpcodes.put(0, OpcodeEnum.UNDEFINED);
		mOpcodes.put(0x669, OpcodeEnum.SLDT);
		mOpcodes.put(0x62, OpcodeEnum.POPA);
		mOpcodes.put(0x8ee, OpcodeEnum.UNPCKHPS);
		mOpcodes.put(0x115, OpcodeEnum.POPF);
		mOpcodes.put(0x11b9, OpcodeEnum.CMPLTSS);
		mOpcodes.put(0x85f, OpcodeEnum.VMOVSD);
		mOpcodes.put(0x789, OpcodeEnum.PFPNACC);
		mOpcodes.put(0xb14, OpcodeEnum.VMOVMSKPD);
		mOpcodes.put(0x737, OpcodeEnum.INVLPGA);
		mOpcodes.put(0x8f8, OpcodeEnum.UNPCKHPD);
		mOpcodes.put(0x270, OpcodeEnum.SYSEXIT);
		mOpcodes.put(0x7b2, OpcodeEnum.PFSUB);
		mOpcodes.put(0x1208, OpcodeEnum.CMPLTSD);
		mOpcodes.put(0x1a5d, OpcodeEnum.VPMULHUW);
		mOpcodes.put(0x1d35, OpcodeEnum.VPHSUBSW);
		mOpcodes.put(0x12b2, OpcodeEnum.VCMPNGEPS);
		mOpcodes.put(0x857, OpcodeEnum.VMOVSS);
		mOpcodes.put(0x6f, OpcodeEnum.ARPL);
		mOpcodes.put(0x52a, OpcodeEnum.FICOMP);
		mOpcodes.put(0x162, OpcodeEnum.RETF);
		mOpcodes.put(0x44d, OpcodeEnum.FCHS);
		mOpcodes.put(0x1124, OpcodeEnum.CMPLEPS);
		mOpcodes.put(0xef2, OpcodeEnum.PUNPCKHDQ);
		mOpcodes.put(0x2401, OpcodeEnum.VAESDEC);
		mOpcodes.put(0x5ee, OpcodeEnum.FUCOM);
		mOpcodes.put(0x129a, OpcodeEnum.VCMPORDPS);
		mOpcodes.put(0x19ab, OpcodeEnum.PSUBUSW);
		mOpcodes.put(0x1b45, OpcodeEnum.PXOR);
		mOpcodes.put(0x1e0f, OpcodeEnum.VPABSB);
		mOpcodes.put(0x24a, OpcodeEnum.WRMSR);
		mOpcodes.put(0x12a5, OpcodeEnum.VCMPEQ_UQPS);
		mOpcodes.put(0x22b6, OpcodeEnum.VFMADDSUB231PD);
		mOpcodes.put(0x7c9, OpcodeEnum.PFMAX);
		mOpcodes.put(0x16cd, OpcodeEnum.VCMPNEQ_OSSS);
		mOpcodes.put(0x2244, OpcodeEnum.VFNMADD213PD);
		mOpcodes.put(0x3b8, OpcodeEnum.MOVNTI);
		mOpcodes.put(0x7c0, OpcodeEnum.PFCMPGT);
		mOpcodes.put(0x236a, OpcodeEnum.VFNMADD231SS);
		mOpcodes.put(0x2450, OpcodeEnum.ROUNDPD);
		mOpcodes.put(0x12ed, OpcodeEnum.VCMPGTPS);
		mOpcodes.put(0xb9f, OpcodeEnum.VRCPSS);
		mOpcodes.put(0x213a, OpcodeEnum.VFNMADD132SS);
		mOpcodes.put(0x1444, OpcodeEnum.VCMPNGEPD);
		mOpcodes.put(0x220f, OpcodeEnum.VFMSUB213PD);
		mOpcodes.put(0x185f, OpcodeEnum.VCMPNEQ_OSSD);
		mOpcodes.put(0x267f, OpcodeEnum.VPSLLDQ);
		mOpcodes.put(0x792, OpcodeEnum.PFCMPGE);
		mOpcodes.put(0x147f, OpcodeEnum.VCMPGTPD);
		mOpcodes.put(0x1a83, OpcodeEnum.CVTDQ2PD);
		mOpcodes.put(0x1211, OpcodeEnum.CMPLESD);
		mOpcodes.put(0xae, OpcodeEnum.JNS);
		mOpcodes.put(0xdd8, OpcodeEnum.VDIVSD);
		mOpcodes.put(0xb7, OpcodeEnum.JNP);
		mOpcodes.put(0x2508, OpcodeEnum.EXTRACTPS);
		mOpcodes.put(0x1f43, OpcodeEnum.PMOVZXBQ);
		mOpcodes.put(0x9c, OpcodeEnum.JNZ);
		mOpcodes.put(0x5d8, OpcodeEnum.FCOMI);
		mOpcodes.put(0xee6, OpcodeEnum.VPUNPCKHWD);
		mOpcodes.put(0x1f2e, OpcodeEnum.PMOVZXBD);
		mOpcodes.put(0x1aca, OpcodeEnum.VMOVNTDQ);
		mOpcodes.put(0x1e74, OpcodeEnum.PMOVSXWD);
		mOpcodes.put(0x10f2, OpcodeEnum.POPCNT);
		mOpcodes.put(0x8a, OpcodeEnum.JNO);
		mOpcodes.put(0x1c8f, OpcodeEnum.FNSAVE);
		mOpcodes.put(0x1a5, OpcodeEnum.LOOP);
		mOpcodes.put(0xb09, OpcodeEnum.VMOVMSKPS);
		mOpcodes.put(0x46b, OpcodeEnum.FLDL2T);
		mOpcodes.put(0x12d, OpcodeEnum.CMPS);
		mOpcodes.put(0x408, OpcodeEnum.FSUB);
		mOpcodes.put(0xda4, OpcodeEnum.DIVPS);
		mOpcodes.put(0x1d1b, OpcodeEnum.PHSUBD);
		mOpcodes.put(0x11b0, OpcodeEnum.CMPEQSS);
		mOpcodes.put(0x1e7, OpcodeEnum.CMC);
		mOpcodes.put(0xcff, OpcodeEnum.CVTTPS2DQ);
		mOpcodes.put(0xdab, OpcodeEnum.DIVPD);
		mOpcodes.put(0xf5c, OpcodeEnum.VMOVD);
		mOpcodes.put(0x104, OpcodeEnum.CALL_FAR);
		mOpcodes.put(0x1d72, OpcodeEnum.PMULHRSW);
		mOpcodes.put(0x1d7c, OpcodeEnum.VPMULHRSW);
		mOpcodes.put(0x1d0a, OpcodeEnum.PHSUBW);
		mOpcodes.put(0x11ff, OpcodeEnum.CMPEQSD);
		mOpcodes.put(0x3b2, OpcodeEnum.XADD);
		mOpcodes.put(0x2ae, OpcodeEnum.CMOVBE);
		mOpcodes.put(0x47, OpcodeEnum.CMP);
		mOpcodes.put(0x24, OpcodeEnum.SBB);
		mOpcodes.put(0x106e, OpcodeEnum.VHADDPS);
		mOpcodes.put(0x26ad, OpcodeEnum.FXRSTOR64);
		mOpcodes.put(0x2064, OpcodeEnum.INVVPID);
		mOpcodes.put(0x20f, OpcodeEnum.LSL);
		mOpcodes.put(0x165d, OpcodeEnum.VCMPNEQ_USSS);
		mOpcodes.put(0x1065, OpcodeEnum.VHADDPD);
		mOpcodes.put(0x38b, OpcodeEnum.LSS);
		mOpcodes.put(0x20f7, OpcodeEnum.VFMSUB132PD);
		mOpcodes.put(0x121, OpcodeEnum.LAHF);
		mOpcodes.put(0x7ec, OpcodeEnum.PFACC);
		mOpcodes.put(0x803, OpcodeEnum.PFRCPIT2);
		mOpcodes.put(0xe27, OpcodeEnum.VPUNPCKLBW);
		mOpcodes.put(0x7d0, OpcodeEnum.PFRCPIT1);
		mOpcodes.put(0x1f97, OpcodeEnum.PCMPGTQ);
		mOpcodes.put(0x49f, OpcodeEnum.FYL2X);
		mOpcodes.put(0x1819, OpcodeEnum.VCMPORD_SSD);
		mOpcodes.put(0x1933, OpcodeEnum.PSRLD);
		mOpcodes.put(0x10e1, OpcodeEnum.SFENCE);
		mOpcodes.put(0xcf5, OpcodeEnum.CVTPS2DQ);
		mOpcodes.put(0x24af, OpcodeEnum.PBLENDW);
		mOpcodes.put(0x21ae, OpcodeEnum.VFMSUBADD213PS);
		mOpcodes.put(0xe76, OpcodeEnum.PCMPGTB);
		mOpcodes.put(0xe9c, OpcodeEnum.PCMPGTD);
		mOpcodes.put(0x23d7, OpcodeEnum.VAESENC);
		mOpcodes.put(0x957, OpcodeEnum.VMOVSHDUP);
		mOpcodes.put(0x259c, OpcodeEnum.MPSADBW);
		mOpcodes.put(0x14e7, OpcodeEnum.VCMPNLE_UQPD);
		mOpcodes.put(0x70a, OpcodeEnum.VMMCALL);
		mOpcodes.put(0x102f, OpcodeEnum.INSERTQ);
		mOpcodes.put(0x2252, OpcodeEnum.VFNMADD213SS);
		mOpcodes.put(0x9bf, OpcodeEnum.CVTPI2PD);
		mOpcodes.put(0x16f, OpcodeEnum.INT);
		mOpcodes.put(0x1d87, OpcodeEnum.VPERMILPS);
		mOpcodes.put(0x1e2, OpcodeEnum.HLT);
		mOpcodes.put(0x2043, OpcodeEnum.PHMINPOSUW);
		mOpcodes.put(0x5b1, OpcodeEnum.FCMOVNU);
		mOpcodes.put(0x206d, OpcodeEnum.INVPCID);
		mOpcodes.put(0x7b, OpcodeEnum.INS);
		mOpcodes.put(0x647, OpcodeEnum.FCOMIP);
		mOpcodes.put(0x9b5, OpcodeEnum.CVTPI2PS);
		mOpcodes.put(0x2260, OpcodeEnum.VFNMADD213SD);
		mOpcodes.put(0xeaf, OpcodeEnum.PACKUSWB);
		mOpcodes.put(0xe4, OpcodeEnum.CBW);
		mOpcodes.put(0x71b, OpcodeEnum.VMSAVE);
		mOpcodes.put(0x10e, OpcodeEnum.PUSHF);
		mOpcodes.put(0x64f, OpcodeEnum.NOT);
		mOpcodes.put(0x595, OpcodeEnum.FCMOVNB);
		mOpcodes.put(0x245, OpcodeEnum.NOP);
		mOpcodes.put(0x4e8, OpcodeEnum.FSQRT);
		mOpcodes.put(0x1d92, OpcodeEnum.VPERMILPD);
		mOpcodes.put(0x51, OpcodeEnum.INC);
		mOpcodes.put(0x239, OpcodeEnum.UD2);
		mOpcodes.put(0xfe7, OpcodeEnum.VPCMPEQW);
		mOpcodes.put(0x2615, OpcodeEnum.PCMPISTRM);
		mOpcodes.put(0x1ecd, OpcodeEnum.VPCMPEQQ);
		mOpcodes.put(0x114d, OpcodeEnum.CMPNLEPS);
		mOpcodes.put(0x1826, OpcodeEnum.VCMPEQ_USSD);
		mOpcodes.put(0x13fe, OpcodeEnum.VCMPUNORDPD);
		mOpcodes.put(0x5fd, OpcodeEnum.FADDP);
		mOpcodes.put(0x145, OpcodeEnum.RET);
		mOpcodes.put(0xffa, OpcodeEnum.VPCMPEQD);
		mOpcodes.put(0x1fc3, OpcodeEnum.VPMINSD);
		mOpcodes.put(0x2542, OpcodeEnum.VPINSRB);
		mOpcodes.put(0xfd4, OpcodeEnum.VPCMPEQB);
		mOpcodes.put(0x18fa, OpcodeEnum.ADDSUBPD);
		mOpcodes.put(0x22a6, OpcodeEnum.VFMADDSUB231PS);
		mOpcodes.put(0x1694, OpcodeEnum.VCMPEQ_USSS);
		mOpcodes.put(0x1d50, OpcodeEnum.PSIGNW);
		mOpcodes.put(0x1ea8, OpcodeEnum.VPMOVSXDQ);
		mOpcodes.put(0x2007, OpcodeEnum.VPMAXSD);
		mOpcodes.put(0x35b, OpcodeEnum.SETG);
		mOpcodes.put(0x1ff6, OpcodeEnum.VPMAXSB);
		mOpcodes.put(0x327, OpcodeEnum.SETA);
		mOpcodes.put(0x306, OpcodeEnum.SETB);
		mOpcodes.put(0x26df, OpcodeEnum.STMXCSR);
		mOpcodes.put(0x347, OpcodeEnum.SETL);
		mOpcodes.put(0x20ea, OpcodeEnum.VFMSUB132PS);
		mOpcodes.put(0x2f9, OpcodeEnum.SETO);
		mOpcodes.put(0xbcd, OpcodeEnum.ANDNPD);
		mOpcodes.put(0x1106, OpcodeEnum.BSR);
		mOpcodes.put(0x8ba, OpcodeEnum.VMOVDDUP);
		mOpcodes.put(0x1b3c, OpcodeEnum.VPMAXSW);
		mOpcodes.put(0x1d61, OpcodeEnum.PSIGND);
		mOpcodes.put(0x33a, OpcodeEnum.SETP);
		mOpcodes.put(0x1d3f, OpcodeEnum.PSIGNB);
		mOpcodes.put(0x395, OpcodeEnum.LFS);
		mOpcodes.put(0x32d, OpcodeEnum.SETS);
		mOpcodes.put(0x1590, OpcodeEnum.VCMPUNORDSS);
		mOpcodes.put(0xbc5, OpcodeEnum.ANDNPS);
		mOpcodes.put(0x270e, OpcodeEnum.VMXON);
		mOpcodes.put(0xbb5, OpcodeEnum.VANDPS);
		mOpcodes.put(0x6f3, OpcodeEnum.XSETBV);
		mOpcodes.put(0x1c3, OpcodeEnum.OUT);
		mOpcodes.put(0x67a, OpcodeEnum.LTR);
		mOpcodes.put(0x2570, OpcodeEnum.VPINSRD);
		mOpcodes.put(0x10ff, OpcodeEnum.TZCNT);
		mOpcodes.put(0xa57, OpcodeEnum.VCVTTSS2SI);
		mOpcodes.put(0x266e, OpcodeEnum.VPSRLDQ);
		mOpcodes.put(0x4c6, OpcodeEnum.FDECSTP);
		mOpcodes.put(0x2666, OpcodeEnum.PSRLDQ);
		mOpcodes.put(0x186d, OpcodeEnum.VCMPGE_OQSD);
		mOpcodes.put(0x2677, OpcodeEnum.PSLLDQ);
		mOpcodes.put(0x50f, OpcodeEnum.FCOS);
		mOpcodes.put(0x4b5, OpcodeEnum.FXTRACT);
		mOpcodes.put(0x16db, OpcodeEnum.VCMPGE_OQSS);
		mOpcodes.put(0x1ee1, OpcodeEnum.VMOVNTDQA);
		mOpcodes.put(0x151d, OpcodeEnum.VCMPNGT_UQPD);
		mOpcodes.put(0x3f5, OpcodeEnum.FMUL);
		mOpcodes.put(0x13c4, OpcodeEnum.VCMPGT_OQPS);
		mOpcodes.put(0x60b, OpcodeEnum.FCOMPP);
		mOpcodes.put(0x77a, OpcodeEnum.PF2ID);
		mOpcodes.put(0xf5, OpcodeEnum.CWD);
		mOpcodes.put(0x132a, OpcodeEnum.VCMPUNORD_SPS);
		mOpcodes.put(0x2ea, OpcodeEnum.CMOVLE);
		mOpcodes.put(0xfb7, OpcodeEnum.VPSHUFHW);
		mOpcodes.put(0x1556, OpcodeEnum.VCMPGT_OQPD);
		mOpcodes.put(0x1ce0, OpcodeEnum.PHADDSW);
		mOpcodes.put(0x773, OpcodeEnum.PF2IW);
		mOpcodes.put(0xa21, OpcodeEnum.VMOVNTPD);
		mOpcodes.put(0x401, OpcodeEnum.FCOMP);
		mOpcodes.put(0x8c4, OpcodeEnum.UNPCKLPS);
		mOpcodes.put(0x1bcf, OpcodeEnum.MASKMOVDQU);
		mOpcodes.put(0x560, OpcodeEnum.FCMOVBE);
		mOpcodes.put(0x14a2, OpcodeEnum.VCMPLT_OQPD);
		mOpcodes.put(0xe14, OpcodeEnum.VMAXSD);
		mOpcodes.put(0x1416, OpcodeEnum.VCMPNLTPD);
		mOpcodes.put(0x987, OpcodeEnum.PREFETCHT2);
		mOpcodes.put(0x97b, OpcodeEnum.PREFETCHT1);
		mOpcodes.put(0x96f, OpcodeEnum.PREFETCHT0);
		mOpcodes.put(0x8ce, OpcodeEnum.UNPCKLPD);
		mOpcodes.put(0xa41, OpcodeEnum.CVTTSS2SI);
		mOpcodes.put(0x65e, OpcodeEnum.DIV);
		mOpcodes.put(0x1e9e, OpcodeEnum.PMOVSXDQ);
		mOpcodes.put(0x1607, OpcodeEnum.VCMPGESS);
		mOpcodes.put(0xef, OpcodeEnum.CDQE);
		mOpcodes.put(0x26f2, OpcodeEnum.VSTMXCSR);
		mOpcodes.put(0x539, OpcodeEnum.FISUBR);
		mOpcodes.put(0x1fb2, OpcodeEnum.VPMINSB);
		mOpcodes.put(0x2202, OpcodeEnum.VFMSUB213PS);
		mOpcodes.put(0x1310, OpcodeEnum.VCMPLT_OQPS);
		mOpcodes.put(0x11c2, OpcodeEnum.CMPLESS);
		mOpcodes.put(0x1afe, OpcodeEnum.VPMINSW);
		mOpcodes.put(0x1c5a, OpcodeEnum.FSTENV);
		mOpcodes.put(0x1799, OpcodeEnum.VCMPGESD);
		mOpcodes.put(0x1dd4, OpcodeEnum.VPTEST);
		mOpcodes.put(0x532, OpcodeEnum.FISUB);
		mOpcodes.put(0x205, OpcodeEnum.STD);
		mOpcodes.put(0xf13, OpcodeEnum.VPACKSSDW);
		mOpcodes.put(0x3d, OpcodeEnum.XOR);
		mOpcodes.put(0xc7f, OpcodeEnum.VMULPD);
		mOpcodes.put(0x1f1, OpcodeEnum.STC);
		mOpcodes.put(0x1fb, OpcodeEnum.STI);
		mOpcodes.put(0x26c2, OpcodeEnum.LDMXCSR);
		mOpcodes.put(0x116a, OpcodeEnum.CMPLTPD);
		mOpcodes.put(0xbe7, OpcodeEnum.ORPS);
		mOpcodes.put(0x1ef6, OpcodeEnum.VPACKUSDW);
		mOpcodes.put(0x61b, OpcodeEnum.FSUBP);
		mOpcodes.put(0x66f, OpcodeEnum.STR);
		mOpcodes.put(0x40e, OpcodeEnum.FSUBR);
		mOpcodes.put(0x111b, OpcodeEnum.CMPLTPS);
		mOpcodes.put(0x230d, OpcodeEnum.VFMADD231SD);
		mOpcodes.put(0x271d, OpcodeEnum.PAUSE);
		mOpcodes.put(0x1a8d, OpcodeEnum.CVTPD2DQ);
		mOpcodes.put(0x372, OpcodeEnum.RSM);
		mOpcodes.put(0xb5a, OpcodeEnum.VSQRTSD);
		mOpcodes.put(0xbf3, OpcodeEnum.VORPS);
		mOpcodes.put(0x218e, OpcodeEnum.VFMADDSUB213PS);
		mOpcodes.put(0x23cf, OpcodeEnum.AESENC);
		mOpcodes.put(0x1437, OpcodeEnum.VCMPEQ_UQPD);
		mOpcodes.put(0x902, OpcodeEnum.VUNPCKHPS);
		mOpcodes.put(0x1cf3, OpcodeEnum.PMADDUBSW);
		mOpcodes.put(0x1355, OpcodeEnum.VCMPNLE_UQPS);
		mOpcodes.put(0x1b68, OpcodeEnum.VPSLLW);
		mOpcodes.put(0x1bc5, OpcodeEnum.MASKMOVQ);
		mOpcodes.put(0x1c8, OpcodeEnum.CALL);
		mOpcodes.put(0xb51, OpcodeEnum.VSQRTSS);
		mOpcodes.put(0x19dc, OpcodeEnum.PADDUSB);
		mOpcodes.put(0x1020, OpcodeEnum.VMREAD);
		mOpcodes.put(0x10d5, OpcodeEnum.XSAVEOPT64);
		mOpcodes.put(0x90d, OpcodeEnum.VUNPCKHPD);
		mOpcodes.put(0xd48, OpcodeEnum.VSUBPS);
		mOpcodes.put(0xcd5, OpcodeEnum.VCVTSS2SD);
		mOpcodes.put(0x2416, OpcodeEnum.VAESDECLAST);
		mOpcodes.put(0x107f, OpcodeEnum.HSUBPS);
		mOpcodes.put(0xa97, OpcodeEnum.VCVTSS2SI);
		mOpcodes.put(0x25dc, OpcodeEnum.VPBLENDVB);
		mOpcodes.put(0x17a3, OpcodeEnum.VCMPGTSD);
		mOpcodes.put(0x57a, OpcodeEnum.FILD);
		mOpcodes.put(0xae3, OpcodeEnum.VCOMISS);
		mOpcodes.put(0x1077, OpcodeEnum.HSUBPD);
		mOpcodes.put(0x23a2, OpcodeEnum.VFNMSUB231SS);
		mOpcodes.put(0x1a3d, OpcodeEnum.VPSRAD);
		mOpcodes.put(0x128f, OpcodeEnum.VCMPNLEPS);
		mOpcodes.put(0x3e5, OpcodeEnum.SAL);
		mOpcodes.put(0x214, OpcodeEnum.SYSCALL);
		mOpcodes.put(0xb7f, OpcodeEnum.VRSQRTSS);
		mOpcodes.put(0x2579, OpcodeEnum.VPINSRQ);
		mOpcodes.put(0x26e8, OpcodeEnum.WRGSBASE);
		mOpcodes.put(0xfae, OpcodeEnum.VPSHUFD);
		mOpcodes.put(0x1e35, OpcodeEnum.PMOVSXBW);
		mOpcodes.put(0x1a2e, OpcodeEnum.VPSRAW);
		mOpcodes.put(0x1421, OpcodeEnum.VCMPNLEPD);
		mOpcodes.put(0x3ef, OpcodeEnum.FADD);
		mOpcodes.put(0x3ea, OpcodeEnum.SAR);
		mOpcodes.put(0x1ab9, OpcodeEnum.MOVNTQ);
		mOpcodes.put(0x2643, OpcodeEnum.AESKEYGENASSIST);
		mOpcodes.put(0xf09, OpcodeEnum.PACKSSDW);
		mOpcodes.put(0x21e8, OpcodeEnum.VFMADD213SS);
		mOpcodes.put(0xf7a, OpcodeEnum.VMOVDQA);
		mOpcodes.put(0x8af, OpcodeEnum.VMOVSLDUP);
		mOpcodes.put(0x4f8, OpcodeEnum.FRNDINT);
		mOpcodes.put(0x1960, OpcodeEnum.PMULLW);
		mOpcodes.put(0xdb9, OpcodeEnum.DIVSD);
		mOpcodes.put(0xaf5, OpcodeEnum.MOVMSKPS);
		mOpcodes.put(0x2018, OpcodeEnum.VPMAXUW);
		mOpcodes.put(0xdc8, OpcodeEnum.VDIVPD);
		mOpcodes.put(0x1e3f, OpcodeEnum.VPMOVSXBW);
		mOpcodes.put(0x1e89, OpcodeEnum.PMOVSXWQ);
		mOpcodes.put(0x2032, OpcodeEnum.PMULLD);
		mOpcodes.put(0xf83, OpcodeEnum.VMOVDQU);
		mOpcodes.put(0x2298, OpcodeEnum.VFNMSUB213SD);
		mOpcodes.put(0x297, OpcodeEnum.CMOVAE);
		mOpcodes.put(0x1495, OpcodeEnum.VCMPEQ_OSPD);
		mOpcodes.put(0xdc0, OpcodeEnum.VDIVPS);
		mOpcodes.put(0x93, OpcodeEnum.JAE);
		mOpcodes.put(0xaff, OpcodeEnum.MOVMSKPD);
		mOpcodes.put(0xdb2, OpcodeEnum.DIVSS);
		mOpcodes.put(0x1c97, OpcodeEnum.FSAVE);
		mOpcodes.put(0x1ec4, OpcodeEnum.PCMPEQQ);
		mOpcodes.put(0xfc1, OpcodeEnum.VPSHUFLW);
		mOpcodes.put(0xfde, OpcodeEnum.PCMPEQW);
		mOpcodes.put(0x26d5, OpcodeEnum.VLDMXCSR);
		mOpcodes.put(0x2104, OpcodeEnum.VFMSUB132SS);
		mOpcodes.put(0x11a6, OpcodeEnum.CMPORDPD);
		mOpcodes.put(0xb90, OpcodeEnum.RCPSS);
		mOpcodes.put(0x1b77, OpcodeEnum.VPSLLD);
		mOpcodes.put(0x663, OpcodeEnum.IDIV);
		mOpcodes.put(0x142c, OpcodeEnum.VCMPORDPD);
		mOpcodes.put(0xfcb, OpcodeEnum.PCMPEQB);
		mOpcodes.put(0xff1, OpcodeEnum.PCMPEQD);
		mOpcodes.put(0x1b86, OpcodeEnum.VPSLLQ);
		mOpcodes.put(0x1f4d, OpcodeEnum.VPMOVZXBQ);
		mOpcodes.put(0x21be, OpcodeEnum.VFMSUBADD213PD);
		mOpcodes.put(0x25d1, OpcodeEnum.VBLENDVPD);
		mOpcodes.put(0x1157, OpcodeEnum.CMPORDPS);
		mOpcodes.put(0xf1e, OpcodeEnum.PUNPCKLQDQ);
		mOpcodes.put(0x19d5, OpcodeEnum.VPAND);
		mOpcodes.put(0x1467, OpcodeEnum.VCMPNEQ_OQPD);
		mOpcodes.put(0x1055, OpcodeEnum.HADDPD);
		mOpcodes.put(0x1919, OpcodeEnum.VADDSUBPS);
		mOpcodes.put(0x18d1, OpcodeEnum.VSHUFPD);
		mOpcodes.put(0xd60, OpcodeEnum.VSUBSD);
		mOpcodes.put(0xb3f, OpcodeEnum.VSQRTPS);
		mOpcodes.put(0x931, OpcodeEnum.MOVSHDUP);
		mOpcodes.put(0x2378, OpcodeEnum.VFNMADD231SD);
		mOpcodes.put(0x6bf, OpcodeEnum.VMLAUNCH);
		mOpcodes.put(0x1f0d, OpcodeEnum.VMASKMOVPD);
		mOpcodes.put(0x105d, OpcodeEnum.HADDPS);
		mOpcodes.put(0x12d5, OpcodeEnum.VCMPNEQ_OQPS);
		mOpcodes.put(0xe33, OpcodeEnum.PUNPCKLWD);
		mOpcodes.put(0x16af, OpcodeEnum.VCMPNGT_UQSS);
		mOpcodes.put(0xb48, OpcodeEnum.VSQRTPD);
		mOpcodes.put(0xd58, OpcodeEnum.VSUBSS);
		mOpcodes.put(0x18c8, OpcodeEnum.VSHUFPS);
		mOpcodes.put(0x159d, OpcodeEnum.VCMPNEQSS);
		mOpcodes.put(0x1b59, OpcodeEnum.VLDDQU);
		mOpcodes.put(0x1634, OpcodeEnum.VCMPLT_OQSS);
		mOpcodes.put(0x272a, OpcodeEnum.RDRAND);
		mOpcodes.put(0x1b23, OpcodeEnum.PADDSW);
		mOpcodes.put(0x1370, OpcodeEnum.VCMPEQ_USPS);
		mOpcodes.put(0xbed, OpcodeEnum.ORPD);
		mOpcodes.put(0x1a09, OpcodeEnum.PANDN);
		mOpcodes.put(0x4a6, OpcodeEnum.FPTAN);
		mOpcodes.put(0x541, OpcodeEnum.FIDIV);
		mOpcodes.put(0x17c6, OpcodeEnum.VCMPLT_OQSD);
		mOpcodes.put(0x26fc, OpcodeEnum.VMPTRLD);
		mOpcodes.put(0x231a, OpcodeEnum.VFMSUB231PS);
		mOpcodes.put(0x172f, OpcodeEnum.VCMPNEQSD);
		mOpcodes.put(0x1ebb, OpcodeEnum.VPMULDQ);
		mOpcodes.put(0x196, OpcodeEnum.LOOPNZ);
		mOpcodes.put(0x126c, OpcodeEnum.VCMPUNORDPS);
		mOpcodes.put(0x3e0, OpcodeEnum.SHR);
		mOpcodes.put(0x37c, OpcodeEnum.SHRD);
		mOpcodes.put(0x6db, OpcodeEnum.MONITOR);
		mOpcodes.put(0x23e0, OpcodeEnum.AESENCLAST);
		mOpcodes.put(0x83e, OpcodeEnum.MOVSD);
		mOpcodes.put(0x189e, OpcodeEnum.VPINSRW);
		mOpcodes.put(0x713, OpcodeEnum.VMLOAD);
		mOpcodes.put(0x918, OpcodeEnum.MOVLHPS);
		mOpcodes.put(0x8a6, OpcodeEnum.VMOVLPD);
		mOpcodes.put(0x1971, OpcodeEnum.MOVQ2DQ);
		mOpcodes.put(0xb2f, OpcodeEnum.SQRTSS);
		mOpcodes.put(0x2588, OpcodeEnum.VDPPS);
		mOpcodes.put(0xd3a, OpcodeEnum.SUBSS);
		mOpcodes.put(0x3ab, OpcodeEnum.MOVSX);
		mOpcodes.put(0x93b, OpcodeEnum.VMOVLHPS);
		mOpcodes.put(0x89d, OpcodeEnum.VMOVLPS);
		mOpcodes.put(0xefd, OpcodeEnum.VPUNPCKHDQ);
		mOpcodes.put(0x1aae, OpcodeEnum.VCVTPD2DQ);
		mOpcodes.put(0x3db, OpcodeEnum.SHL);
		mOpcodes.put(0x837, OpcodeEnum.MOVSS);
		mOpcodes.put(0x2568, OpcodeEnum.PINSRQ);
		mOpcodes.put(0x781, OpcodeEnum.PFNACC);
		mOpcodes.put(0xf72, OpcodeEnum.MOVDQU);
		mOpcodes.put(0x80, OpcodeEnum.OUTS);
		mOpcodes.put(0x1be8, OpcodeEnum.PSUBB);
		mOpcodes.put(0x377, OpcodeEnum.BTS);
		mOpcodes.put(0x390, OpcodeEnum.BTR);
		mOpcodes.put(0x17ef, OpcodeEnum.VCMPNEQ_USSD);
		mOpcodes.put(0x68b, OpcodeEnum.SGDT);
		mOpcodes.put(0x2300, OpcodeEnum.VFMADD231SS);
		mOpcodes.put(0x501, OpcodeEnum.FSCALE);
		mOpcodes.put(0x1bf7, OpcodeEnum.PSUBW);
		mOpcodes.put(0x1192, OpcodeEnum.CMPNLTPD);
		mOpcodes.put(0x1eec, OpcodeEnum.PACKUSDW);
		mOpcodes.put(0x20a, OpcodeEnum.LAR);
		mOpcodes.put(0x3a6, OpcodeEnum.BTC);
		mOpcodes.put(0x2148, OpcodeEnum.VFNMADD132SD);
		mOpcodes.put(0x144f, OpcodeEnum.VCMPNGTPD);
		mOpcodes.put(0x1f23, OpcodeEnum.VPMOVZXBW);
		mOpcodes.put(0x2111, OpcodeEnum.VFMSUB132SD);
		mOpcodes.put(0x23be, OpcodeEnum.AESIMC);
		mOpcodes.put(0x3fb, OpcodeEnum.FCOM);
		mOpcodes.put(0x1f38, OpcodeEnum.VPMOVZXBD);
		mOpcodes.put(0x190e, OpcodeEnum.VADDSUBPD);
		mOpcodes.put(0x1c88, OpcodeEnum.FINIT);
		mOpcodes.put(0x11f5, OpcodeEnum.CMPORDSS);
		mOpcodes.put(0x231, OpcodeEnum.WBINVD);
		mOpcodes.put(0x19cf, OpcodeEnum.PAND);
		mOpcodes.put(0x24cb, OpcodeEnum.VPALIGNR);
		mOpcodes.put(0x1244, OpcodeEnum.CMPORDSD);
		mOpcodes.put(0x1b4b, OpcodeEnum.VPXOR);
		mOpcodes.put(0xa1, OpcodeEnum.JBE);
		mOpcodes.put(0x45f, OpcodeEnum.FXAM);
		mOpcodes.put(0x10cb, OpcodeEnum.XSAVEOPT);
		mOpcodes.put(0x659, OpcodeEnum.MUL);
		mOpcodes.put(0x19c6, OpcodeEnum.VPMINUB);
		mOpcodes.put(0x1b2b, OpcodeEnum.VPADDSW);
		mOpcodes.put(0x1b34, OpcodeEnum.PMAXSW);
		mOpcodes.put(0x2555, OpcodeEnum.VINSERTPS);
		mOpcodes.put(0x13e0, OpcodeEnum.VCMPEQPD);
		mOpcodes.put(0x5e7, OpcodeEnum.FFREE);
		mOpcodes.put(0x1f01, OpcodeEnum.VMASKMOVPS);
		mOpcodes.put(0x18da, OpcodeEnum.CMPXCHG8B);
		mOpcodes.put(0x1fff, OpcodeEnum.PMAXSD);
		mOpcodes.put(0x1b1a, OpcodeEnum.VPADDSB);
		mOpcodes.put(0x10, OpcodeEnum.PUSH);
		mOpcodes.put(0x25ba, OpcodeEnum.VPCLMULQDQ);
		mOpcodes.put(0x124e, OpcodeEnum.VCMPEQPS);
		mOpcodes.put(0x7da, OpcodeEnum.PFRSQIT1);
		mOpcodes.put(0x243d, OpcodeEnum.ROUNDPS);
		mOpcodes.put(0x2ff, OpcodeEnum.SETNO);
		mOpcodes.put(0x6eb, OpcodeEnum.XGETBV);
		mOpcodes.put(0x1fbb, OpcodeEnum.PMINSD);
		mOpcodes.put(0x1c24, OpcodeEnum.PADDB);
		mOpcodes.put(0x4be, OpcodeEnum.FPREM1);
		mOpcodes.put(0x200, OpcodeEnum.CLD);
		mOpcodes.put(0x51c, OpcodeEnum.FIMUL);
		mOpcodes.put(0xc08, OpcodeEnum.XORPD);
		mOpcodes.put(0x1ec, OpcodeEnum.CLC);
		mOpcodes.put(0x42c, OpcodeEnum.FSTP);
		mOpcodes.put(0x249c, OpcodeEnum.BLENDPD);
		mOpcodes.put(0x19ef, OpcodeEnum.PADDUSW);
		mOpcodes.put(0x1c80, OpcodeEnum.FNINIT);
		mOpcodes.put(0x319, OpcodeEnum.SETNZ);
		mOpcodes.put(0x1951, OpcodeEnum.PADDQ);
		mOpcodes.put(0xc01, OpcodeEnum.XORPS);
		mOpcodes.put(0x228a, OpcodeEnum.VFNMSUB213SS);
		mOpcodes.put(0x333, OpcodeEnum.SETNS);
		mOpcodes.put(0x515, OpcodeEnum.FIADD);
		mOpcodes.put(0x340, OpcodeEnum.SETNP);
		mOpcodes.put(0xf43, OpcodeEnum.VPUNPCKHQDQ);
		mOpcodes.put(0xd2c, OpcodeEnum.SUBPS);
		mOpcodes.put(0x1230, OpcodeEnum.CMPNLTSD);
		mOpcodes.put(0x674, OpcodeEnum.LLDT);
		mOpcodes.put(0x2229, OpcodeEnum.VFMSUB213SD);
		mOpcodes.put(0x1dcd, OpcodeEnum.PTEST);
		mOpcodes.put(0x2164, OpcodeEnum.VFNMSUB132PD);
		mOpcodes.put(0x279, OpcodeEnum.GETSEC);
		mOpcodes.put(0x1d69, OpcodeEnum.VPSIGND);
		mOpcodes.put(0x1ab, OpcodeEnum.JCXZ);
		mOpcodes.put(0x11e1, OpcodeEnum.CMPNLTSS);
		mOpcodes.put(0x34d, OpcodeEnum.SETGE);
		mOpcodes.put(0x1112, OpcodeEnum.CMPEQPS);
		mOpcodes.put(0x1bb4, OpcodeEnum.PSADBW);
		mOpcodes.put(0x2715, OpcodeEnum.MOVSXD);
		mOpcodes.put(0x2156, OpcodeEnum.VFNMSUB132PS);
		mOpcodes.put(0x185, OpcodeEnum.AAD);
		mOpcodes.put(0x23ec, OpcodeEnum.VAESENCLAST);
		mOpcodes.put(0xf37, OpcodeEnum.PUNPCKHQDQ);
		mOpcodes.put(0x878, OpcodeEnum.MOVLPD);
		mOpcodes.put(0x19e5, OpcodeEnum.VPADDUSW);
		mOpcodes.put(0x12c8, OpcodeEnum.VCMPFALSEPS);
		mOpcodes.put(0x180, OpcodeEnum.AAM);
		mOpcodes.put(0xf2a, OpcodeEnum.VPUNPCKLQDQ);
		mOpcodes.put(0xd76, OpcodeEnum.MINSS);
		mOpcodes.put(0x1c42, OpcodeEnum.PADDD);
		mOpcodes.put(0x145a, OpcodeEnum.VCMPFALSEPD);
		mOpcodes.put(0xe3e, OpcodeEnum.VPUNPCKLWD);
		mOpcodes.put(0x870, OpcodeEnum.MOVLPS);
		mOpcodes.put(0x729, OpcodeEnum.CLGI);
		mOpcodes.put(0x4c, OpcodeEnum.AAS);
		mOpcodes.put(0x139, OpcodeEnum.LODS);
		mOpcodes.put(0x2d3, OpcodeEnum.CMOVNP);
		mOpcodes.put(0xd7d, OpcodeEnum.MINSD);
		mOpcodes.put(0x1f6, OpcodeEnum.CLI);
		mOpcodes.put(0xa4c, OpcodeEnum.CVTTSD2SI);
		mOpcodes.put(0x523, OpcodeEnum.FICOM);
		mOpcodes.put(0x1f19, OpcodeEnum.PMOVZXBW);
		mOpcodes.put(0xc26, OpcodeEnum.ADDPD);
		mOpcodes.put(0x75a, OpcodeEnum.PREFETCHW);
		mOpcodes.put(0x1339, OpcodeEnum.VCMPNEQ_USPS);
		mOpcodes.put(0xc17, OpcodeEnum.VXORPD);
		mOpcodes.put(0x1b07, OpcodeEnum.POR);
		mOpcodes.put(0x16, OpcodeEnum.POP);
		mOpcodes.put(0x2431, OpcodeEnum.VPERM2F128);
		mOpcodes.put(0x19e, OpcodeEnum.LOOPZ);
		mOpcodes.put(0x1ac1, OpcodeEnum.MOVNTDQ);
		mOpcodes.put(0x1dc, OpcodeEnum.INT1);
		mOpcodes.put(0x382, OpcodeEnum.CMPXCHG);
		mOpcodes.put(0x1df8, OpcodeEnum.VBROADCASTF128);
		mOpcodes.put(0x150f, OpcodeEnum.VCMPNGE_UQPD);
		mOpcodes.put(0x1cbe, OpcodeEnum.PHADDW);
		mOpcodes.put(0xc0f, OpcodeEnum.VXORPS);
		mOpcodes.put(0x14cb, OpcodeEnum.VCMPNEQ_USPD);
		mOpcodes.put(0xc1f, OpcodeEnum.ADDPS);
		mOpcodes.put(0x7fc, OpcodeEnum.PFMUL);
		mOpcodes.put(0x697, OpcodeEnum.LGDT);
		mOpcodes.put(0x67f, OpcodeEnum.VERR);
		mOpcodes.put(0x685, OpcodeEnum.VERW);
		mOpcodes.put(0x1087, OpcodeEnum.VHSUBPD);
		mOpcodes.put(0x1968, OpcodeEnum.VPMULLW);
		mOpcodes.put(0x845, OpcodeEnum.VMOVUPS);
		mOpcodes.put(0x174, OpcodeEnum.INTO);
		mOpcodes.put(0x1c79, OpcodeEnum.FCLEX);
		mOpcodes.put(0x1090, OpcodeEnum.VHSUBPS);
		mOpcodes.put(0xcb5, OpcodeEnum.CVTSD2SS);
		mOpcodes.put(0x47b, OpcodeEnum.FLDPI);
		mOpcodes.put(0x1e17, OpcodeEnum.PABSW);
		mOpcodes.put(0xe04, OpcodeEnum.VMAXPD);
		mOpcodes.put(0x1d3, OpcodeEnum.JMP_FAR);
		mOpcodes.put(0xeb9, OpcodeEnum.VPACKUSWB);
		mOpcodes.put(0x571, OpcodeEnum.FUCOMPP);
		mOpcodes.put(0x84e, OpcodeEnum.VMOVUPD);
		mOpcodes.put(0x816, OpcodeEnum.PSWAPD);
		mOpcodes.put(0x1c33, OpcodeEnum.PADDW);
		mOpcodes.put(0x1b70, OpcodeEnum.PSLLD);
		mOpcodes.put(0x740, OpcodeEnum.SWAPGS);
		mOpcodes.put(0x880, OpcodeEnum.MOVSLDUP);
		mOpcodes.put(0x9c9, OpcodeEnum.CVTSI2SS);
		mOpcodes.put(0x17ad, OpcodeEnum.VCMPTRUESD);
		mOpcodes.put(0x11cb, OpcodeEnum.CMPUNORDSS);
		mOpcodes.put(0xd20, OpcodeEnum.VCVTTPS2DQ);
		mOpcodes.put(0xb37, OpcodeEnum.SQRTSD);
		mOpcodes.put(0x1dea, OpcodeEnum.VBROADCASTSD);
		mOpcodes.put(0x1c06, OpcodeEnum.PSUBD);
		mOpcodes.put(0xce, OpcodeEnum.TEST);
		mOpcodes.put(0x39a, OpcodeEnum.LGS);
		mOpcodes.put(0x161b, OpcodeEnum.VCMPTRUESS);
		mOpcodes.put(0x266, OpcodeEnum.SYSENTER);
		mOpcodes.put(0x9d3, OpcodeEnum.CVTSI2SD);
		mOpcodes.put(0x1745, OpcodeEnum.VCMPNLESD);
		mOpcodes.put(0x1da6, OpcodeEnum.VTESTPD);
		mOpcodes.put(0x98, OpcodeEnum.JZ);
		mOpcodes.put(0xdd0, OpcodeEnum.VDIVSS);
		mOpcodes.put(0xbfa, OpcodeEnum.VORPD);
		mOpcodes.put(0xb3, OpcodeEnum.JP);
		mOpcodes.put(0xaa, OpcodeEnum.JS);
		mOpcodes.put(0xbc, OpcodeEnum.JL);
		mOpcodes.put(0xb6c, OpcodeEnum.RSQRTSS);
		mOpcodes.put(0x1d9d, OpcodeEnum.VTESTPS);
		mOpcodes.put(0x86, OpcodeEnum.JO);
		mOpcodes.put(0xdfc, OpcodeEnum.VMAXPS);
		mOpcodes.put(0x1998, OpcodeEnum.PSUBUSB);
		mOpcodes.put(0xca, OpcodeEnum.JG);
		mOpcodes.put(0x1ddc, OpcodeEnum.VBROADCASTSS);
		mOpcodes.put(0xa6, OpcodeEnum.JA);
		mOpcodes.put(0x8f, OpcodeEnum.JB);
		mOpcodes.put(0xe9, OpcodeEnum.CWDE);
		mOpcodes.put(0x13f4, OpcodeEnum.VCMPLEPD);
		mOpcodes.put(0x1038, OpcodeEnum.VMWRITE);
		mOpcodes.put(0x1262, OpcodeEnum.VCMPLEPS);
		mOpcodes.put(0x1983, OpcodeEnum.PMOVMSKB);
		mOpcodes.put(0x254b, OpcodeEnum.INSERTPS);
		mOpcodes.put(0x25fe, OpcodeEnum.PCMPESTRI);
		mOpcodes.put(0x2724, OpcodeEnum.WAIT);
		mOpcodes.put(0x152b, OpcodeEnum.VCMPFALSE_OSPD);
		mOpcodes.put(0x25e7, OpcodeEnum.PCMPESTRM);
		mOpcodes.put(0xe4a, OpcodeEnum.PUNPCKLDQ);
		mOpcodes.put(0xc69, OpcodeEnum.MULSS);
		mOpcodes.put(0xd50, OpcodeEnum.VSUBPD);
		mOpcodes.put(0x1161, OpcodeEnum.CMPEQPD);
		mOpcodes.put(0x178b, OpcodeEnum.VCMPNEQ_OQSD);
		mOpcodes.put(0xaec, OpcodeEnum.VCOMISD);
		mOpcodes.put(0xd94, OpcodeEnum.VMINSS);
		mOpcodes.put(0x1c49, OpcodeEnum.VPADDD);
		mOpcodes.put(0x258, OpcodeEnum.RDMSR);
		mOpcodes.put(0x1d58, OpcodeEnum.VPSIGNW);
		mOpcodes.put(0x1b1, OpcodeEnum.JECXZ);
		mOpcodes.put(0xc70, OpcodeEnum.MULSD);
		mOpcodes.put(0x154, OpcodeEnum.ENTER);
		mOpcodes.put(0x2423, OpcodeEnum.MOVBE);
		mOpcodes.put(0x1016, OpcodeEnum.VZEROALL);
		mOpcodes.put(0x2732, OpcodeEnum._3DNOW);
		mOpcodes.put(0xd9c, OpcodeEnum.VMINSD);
		mOpcodes.put(0x15f9, OpcodeEnum.VCMPNEQ_OQSS);
		mOpcodes.put(0x7e4, OpcodeEnum.PFSUBR);
		mOpcodes.put(0x12e3, OpcodeEnum.VCMPGEPS);
		mOpcodes.put(0x19a1, OpcodeEnum.VPSUBUSB);
		mOpcodes.put(0x2341, OpcodeEnum.VFMSUB231SD);
		mOpcodes.put(0x2021, OpcodeEnum.PMAXUD);
		mOpcodes.put(0x2688, OpcodeEnum.FXSAVE);
		mOpcodes.put(0x580, OpcodeEnum.FISTTP);
		mOpcodes.put(0x1475, OpcodeEnum.VCMPGEPD);
		mOpcodes.put(0x2489, OpcodeEnum.BLENDPS);
		mOpcodes.put(0x1718, OpcodeEnum.VCMPLESD);
		mOpcodes.put(0x5a7, OpcodeEnum.FCMOVNBE);
		mOpcodes.put(0x2334, OpcodeEnum.VFMSUB231SS);
		mOpcodes.put(0x25c6, OpcodeEnum.VBLENDVPS);
		mOpcodes.put(0x25a5, OpcodeEnum.VMPSADBW);
		mOpcodes.put(0x19b4, OpcodeEnum.VPSUBUSW);
		mOpcodes.put(0x170e, OpcodeEnum.VCMPLTSD);
		mOpcodes.put(0x1ed7, OpcodeEnum.MOVNTDQA);
		mOpcodes.put(0x18c0, OpcodeEnum.SHUFPD);
		mOpcodes.put(0xd33, OpcodeEnum.SUBPD);
		mOpcodes.put(0xb27, OpcodeEnum.SQRTPD);
		mOpcodes.put(0x94e, OpcodeEnum.VMOVHPD);
		mOpcodes.put(0x6b7, OpcodeEnum.VMCALL);
		mOpcodes.put(0x20c3, OpcodeEnum.VFMADD132PD);
		mOpcodes.put(0x15b, OpcodeEnum.LEAVE);
		mOpcodes.put(0x18b8, OpcodeEnum.SHUFPS);
		mOpcodes.put(0x1303, OpcodeEnum.VCMPEQ_OSPS);
		mOpcodes.put(0x2609, OpcodeEnum.VPCMPESTRI);
		mOpcodes.put(0x157c, OpcodeEnum.VCMPLTSS);
		mOpcodes.put(0x25f2, OpcodeEnum.VPCMPESTRM);
		mOpcodes.put(0x20b6, OpcodeEnum.VFMADD132PS);
		mOpcodes.put(0x69d, OpcodeEnum.LIDT);
		mOpcodes.put(0x498, OpcodeEnum.F2XM1);
		mOpcodes.put(0x945, OpcodeEnum.VMOVHPS);
		mOpcodes.put(0x1f82, OpcodeEnum.PMOVZXDQ);
		mOpcodes.put(0x100a, OpcodeEnum.VZEROUPPER);
		mOpcodes.put(0xb1f, OpcodeEnum.SQRTPS);
		mOpcodes.put(0xbd5, OpcodeEnum.VANDNPS);
		mOpcodes.put(0x1958, OpcodeEnum.VPADDQ);
		mOpcodes.put(0x4d8, OpcodeEnum.FPREM);
		mOpcodes.put(0x1c3a, OpcodeEnum.VPADDW);
		mOpcodes.put(0x24c2, OpcodeEnum.PALIGNR);
		mOpcodes.put(0x1faa, OpcodeEnum.PMINSB);
		mOpcodes.put(0xe89, OpcodeEnum.PCMPGTW);
		mOpcodes.put(0x36c, OpcodeEnum.SHLD);
		mOpcodes.put(0x14f, OpcodeEnum.LDS);
		mOpcodes.put(0x1c2b, OpcodeEnum.VPADDB);
		mOpcodes.put(0x703, OpcodeEnum.VMRUN);
		mOpcodes.put(0x269a, OpcodeEnum.RDFSBASE);
		mOpcodes.put(0xbde, OpcodeEnum.VANDNPD);
		mOpcodes.put(0x190, OpcodeEnum.XLAT);
		mOpcodes.put(0xd4, OpcodeEnum.XCHG);
		mOpcodes.put(0x4cf, OpcodeEnum.FINCSTP);
		mOpcodes.put(0x197a, OpcodeEnum.MOVDQ2Q);
		mOpcodes.put(0x1af6, OpcodeEnum.PMINSW);
		mOpcodes.put(0x6a3, OpcodeEnum.SMSW);
		mOpcodes.put(0x1d47, OpcodeEnum.VPSIGNB);
		mOpcodes.put(0x10b1, OpcodeEnum.XRSTOR);
		mOpcodes.put(0x24a5, OpcodeEnum.VBLENDPD);
		mOpcodes.put(0xc0, OpcodeEnum.JGE);
		mOpcodes.put(0x1347, OpcodeEnum.VCMPNLT_UQPS);
		mOpcodes.put(0x1750, OpcodeEnum.VCMPORDSD);
		mOpcodes.put(0x2492, OpcodeEnum.VBLENDPS);
		mOpcodes.put(0x459, OpcodeEnum.FTST);
		mOpcodes.put(0x1a78, OpcodeEnum.CVTTPD2DQ);
		mOpcodes.put(0x15be, OpcodeEnum.VCMPORDSS);
		mOpcodes.put(0x14d9, OpcodeEnum.VCMPNLT_UQPD);
		mOpcodes.put(0x2172, OpcodeEnum.VFNMSUB132SS);
		mOpcodes.put(0x10b9, OpcodeEnum.XRSTOR64);
		mOpcodes.put(0x29, OpcodeEnum.AND);
		mOpcodes.put(0xb75, OpcodeEnum.VRSQRTPS);
		mOpcodes.put(0x10e9, OpcodeEnum.CLFLUSH);
		mOpcodes.put(0x1cad, OpcodeEnum.PSHUFB);
		mOpcodes.put(0x432, OpcodeEnum.FLDENV);
		mOpcodes.put(0xda, OpcodeEnum.MOV);
		mOpcodes.put(0xf94, OpcodeEnum.PSHUFD);
		mOpcodes.put(0xc5, OpcodeEnum.JLE);
		mOpcodes.put(0x5c0, OpcodeEnum.FEDISI);
		mOpcodes.put(0x6fb, OpcodeEnum.VMFUNC);
		mOpcodes.put(0xe92, OpcodeEnum.VPCMPGTW);
		mOpcodes.put(0x7f3, OpcodeEnum.PFCMPEQ);
		mOpcodes.put(0x1687, OpcodeEnum.VCMPORD_SSS);
		mOpcodes.put(0xf8c, OpcodeEnum.PSHUFW);
		mOpcodes.put(0x24dd, OpcodeEnum.VPEXTRB);
		mOpcodes.put(0x1aa3, OpcodeEnum.VCVTDQ2PD);
		mOpcodes.put(0xf63, OpcodeEnum.VMOVQ);
		mOpcodes.put(0x473, OpcodeEnum.FLDL2E);
		mOpcodes.put(0x24f6, OpcodeEnum.VPEXTRD);
		mOpcodes.put(0x1d12, OpcodeEnum.VPHSUBW);
		mOpcodes.put(0x226e, OpcodeEnum.VFNMSUB213PS);
		mOpcodes.put(0x21db, OpcodeEnum.VFMADD213PD);
		mOpcodes.put(0x723, OpcodeEnum.STGI);
		mOpcodes.put(0x4ad, OpcodeEnum.FPATAN);
		mOpcodes.put(0x24ff, OpcodeEnum.VPEXTRQ);
		mOpcodes.put(0x427, OpcodeEnum.FST);
		mOpcodes.put(0x168, OpcodeEnum.INT_3);
		mOpcodes.put(0x588, OpcodeEnum.FIST);
		mOpcodes.put(0x2705, OpcodeEnum.VMCLEAR);
		mOpcodes.put(0x1e5f, OpcodeEnum.PMOVSXBQ);
		mOpcodes.put(0x42, OpcodeEnum.AAA);
		mOpcodes.put(0x1d23, OpcodeEnum.VPHSUBD);
		mOpcodes.put(0xa2b, OpcodeEnum.CVTTPS2PI);
		mOpcodes.put(0x1139, OpcodeEnum.CMPNEQPS);
		mOpcodes.put(0x1549, OpcodeEnum.VCMPGE_OQPD);
		mOpcodes.put(0x1b52, OpcodeEnum.LDDQU);
		mOpcodes.put(0xb63, OpcodeEnum.RSQRTPS);
		mOpcodes.put(0xc43, OpcodeEnum.VADDPD);
		mOpcodes.put(0x7a2, OpcodeEnum.PFRCP);
		mOpcodes.put(0xcab, OpcodeEnum.CVTSS2SD);
		mOpcodes.put(0x2180, OpcodeEnum.VFNMSUB132SD);
		mOpcodes.put(0x622, OpcodeEnum.FDIVRP);
		mOpcodes.put(0x631, OpcodeEnum.FBLD);
		mOpcodes.put(0x361, OpcodeEnum.CPUID);
		mOpcodes.put(0x251, OpcodeEnum.RDTSC);
		mOpcodes.put(0x24b8, OpcodeEnum.VPBLENDW);
		mOpcodes.put(0xd15, OpcodeEnum.VCVTPS2DQ);
		mOpcodes.put(0x1b0c, OpcodeEnum.VPOR);
		mOpcodes.put(0xc3b, OpcodeEnum.VADDPS);
		mOpcodes.put(0x765, OpcodeEnum.PI2FW);
		mOpcodes.put(0xd68, OpcodeEnum.MINPS);
		mOpcodes.put(0x17b9, OpcodeEnum.VCMPEQ_OSSD);
		mOpcodes.put(0x1b97, OpcodeEnum.VPMULUDQ);
		mOpcodes.put(0xdf5, OpcodeEnum.MAXSD);
		mOpcodes.put(0x203a, OpcodeEnum.VPMULLD);
		mOpcodes.put(0x548, OpcodeEnum.FIDIVR);
		mOpcodes.put(0xabf, OpcodeEnum.VUCOMISS);
		mOpcodes.put(0x88a, OpcodeEnum.MOVDDUP);
		mOpcodes.put(0x1cb5, OpcodeEnum.VPSHUFB);
		mOpcodes.put(0x1d2c, OpcodeEnum.PHSUBSW);
		mOpcodes.put(0x2637, OpcodeEnum.VPCMPISTRI);
		mOpcodes.put(0xdee, OpcodeEnum.MAXSS);
		mOpcodes.put(0x1a1f, OpcodeEnum.VPAVGB);
		mOpcodes.put(0x16bd, OpcodeEnum.VCMPFALSE_OSSS);
		mOpcodes.put(0xd6f, OpcodeEnum.MINPD);
		mOpcodes.put(0x4df, OpcodeEnum.FYL2XP1);
		mOpcodes.put(0xac9, OpcodeEnum.VUCOMISD);
		mOpcodes.put(0x2394, OpcodeEnum.VFNMSUB231PD);
		mOpcodes.put(0x1833, OpcodeEnum.VCMPNGE_UQSD);
		mOpcodes.put(0xc34, OpcodeEnum.ADDSD);
		mOpcodes.put(0x6d3, OpcodeEnum.VMXOFF);
		mOpcodes.put(0x1942, OpcodeEnum.PSRLQ);
		mOpcodes.put(0x1279, OpcodeEnum.VCMPNEQPS);
		mOpcodes.put(0x1924, OpcodeEnum.PSRLW);
		mOpcodes.put(0x1a36, OpcodeEnum.PSRAD);
		mOpcodes.put(0x691, OpcodeEnum.SIDT);
		mOpcodes.put(0xe61, OpcodeEnum.PACKSSWB);
		mOpcodes.put(0x1099, OpcodeEnum.XSAVE);
		mOpcodes.put(0x140b, OpcodeEnum.VCMPNEQPD);
		mOpcodes.put(0xfa, OpcodeEnum.CDQ);
		mOpcodes.put(0xc2d, OpcodeEnum.ADDSS);
		mOpcodes.put(0x16a1, OpcodeEnum.VCMPNGE_UQSS);
		mOpcodes.put(0x242a, OpcodeEnum.CRC32);
		mOpcodes.put(0x23c6, OpcodeEnum.VAESIMC);
		mOpcodes.put(0x1fee, OpcodeEnum.PMAXSB);
		mOpcodes.put(0x2513, OpcodeEnum.VEXTRACTPS);
		mOpcodes.put(0x17fd, OpcodeEnum.VCMPNLT_UQSD);
		mOpcodes.put(0x1bef, OpcodeEnum.VPSUBB);
		mOpcodes.put(0x1f77, OpcodeEnum.VPMOVZXWQ);
		mOpcodes.put(0x13a9, OpcodeEnum.VCMPNEQ_OSPS);
		mOpcodes.put(0xa05, OpcodeEnum.MOVNTSS);
		mOpcodes.put(0x252c, OpcodeEnum.VEXTRACTF128);
		mOpcodes.put(0x1b12, OpcodeEnum.PADDSB);
		mOpcodes.put(0x75, OpcodeEnum.IMUL);
		mOpcodes.put(0x3d6, OpcodeEnum.RCR);
		mOpcodes.put(0x14bc, OpcodeEnum.VCMPUNORD_SPD);
		mOpcodes.put(0x3d1, OpcodeEnum.RCL);
		mOpcodes.put(0xa0e, OpcodeEnum.MOVNTSD);
		mOpcodes.put(0x153b, OpcodeEnum.VCMPNEQ_OSPD);
		mOpcodes.put(0x166b, OpcodeEnum.VCMPNLT_UQSS);
		mOpcodes.put(0xd41, OpcodeEnum.SUBSD);
		mOpcodes.put(0x13f, OpcodeEnum.SCAS);
		mOpcodes.put(0x25af, OpcodeEnum.PCLMULQDQ);
		mOpcodes.put(0x7a9, OpcodeEnum.PFRSQRT);
		mOpcodes.put(0x2560, OpcodeEnum.PINSRD);
		mOpcodes.put(0x613, OpcodeEnum.FSUBRP);
		mOpcodes.put(0x5b, OpcodeEnum.PUSHA);
		mOpcodes.put(0x1a00, OpcodeEnum.VPMAXUB);
		mOpcodes.put(0x112d, OpcodeEnum.CMPUNORDPS);
		mOpcodes.put(0x2029, OpcodeEnum.VPMAXUD);
		mOpcodes.put(0x453, OpcodeEnum.FABS);
		mOpcodes.put(0x1e69, OpcodeEnum.VPMOVSXBQ);
		mOpcodes.put(0x1489, OpcodeEnum.VCMPTRUEPD);
		mOpcodes.put(0x23e, OpcodeEnum.FEMMS);
		mOpcodes.put(0x1627, OpcodeEnum.VCMPEQ_OSSS);
		mOpcodes.put(0x21f5, OpcodeEnum.VFMADD213SD);
		mOpcodes.put(0x1e54, OpcodeEnum.VPMOVSXBD);
		mOpcodes.put(0x117c, OpcodeEnum.CMPUNORDPD);
		mOpcodes.put(0x18f1, OpcodeEnum.VMPTRST);
		mOpcodes.put(0x18e5, OpcodeEnum.CMPXCHG16B);
		mOpcodes.put(0x12f7, OpcodeEnum.VCMPTRUEPS);
		mOpcodes.put(0x12bd, OpcodeEnum.VCMPNGTPS);
		mOpcodes.put(0x1c71, OpcodeEnum.FNCLEX);
		mOpcodes.put(0x1226, OpcodeEnum.CMPNEQSD);
		mOpcodes.put(0x175b, OpcodeEnum.VCMPEQ_UQSD);
		mOpcodes.put(0x569, OpcodeEnum.FCMOVU);
		mOpcodes.put(0x1028, OpcodeEnum.EXTRQ);
		mOpcodes.put(0x258f, OpcodeEnum.DPPD);
		mOpcodes.put(0x2e2, OpcodeEnum.CMOVGE);
		mOpcodes.put(0x253a, OpcodeEnum.PINSRB);
		mOpcodes.put(0x15c9, OpcodeEnum.VCMPEQ_UQSS);
		mOpcodes.put(0x1cfe, OpcodeEnum.VPMADDUBSW);
		mOpcodes.put(0x11d7, OpcodeEnum.CMPNEQSS);
		mOpcodes.put(0x22f3, OpcodeEnum.VFMADD231PD);
		mOpcodes.put(0x509, OpcodeEnum.FSIN);
		mOpcodes.put(0x1bf, OpcodeEnum.IN);
		mOpcodes.put(0x558, OpcodeEnum.FCMOVE);
		mOpcodes.put(0x43a, OpcodeEnum.FLDCW);
		mOpcodes.put(0x2582, OpcodeEnum.DPPS);
		mOpcodes.put(0x550, OpcodeEnum.FCMOVB);
		mOpcodes.put(0x192b, OpcodeEnum.VPSRLW);
		mOpcodes.put(0x10a9, OpcodeEnum.LFENCE);
		mOpcodes.put(0xa8d, OpcodeEnum.CVTSD2SI);
		mOpcodes.put(0x30c, OpcodeEnum.SETAE);
		mOpcodes.put(0x2a6, OpcodeEnum.CMOVNZ);
		mOpcodes.put(0x1949, OpcodeEnum.VPSRLQ);
		mOpcodes.put(0x604, OpcodeEnum.FMULP);
		mOpcodes.put(0x9ac, OpcodeEnum.VMOVAPD);
		mOpcodes.put(0x1641, OpcodeEnum.VCMPLE_OQSS);
		mOpcodes.put(0x2c4, OpcodeEnum.CMOVNS);
		mOpcodes.put(0x59e, OpcodeEnum.FCMOVNE);
		mOpcodes.put(0x288, OpcodeEnum.CMOVNO);
		mOpcodes.put(0x1a6f, OpcodeEnum.VPMULHW);
		mOpcodes.put(0x193a, OpcodeEnum.VPSRLD);
		mOpcodes.put(0x104b, OpcodeEnum.CVTPS2PH);
		mOpcodes.put(0xa6f, OpcodeEnum.CVTPS2PI);
		mOpcodes.put(0x1ccf, OpcodeEnum.PHADDD);
		mOpcodes.put(0xc97, OpcodeEnum.CVTPS2PD);
		mOpcodes.put(0x1e1e, OpcodeEnum.VPABSW);
		mOpcodes.put(0x17d3, OpcodeEnum.VCMPLE_OQSD);
		mOpcodes.put(0x9a3, OpcodeEnum.VMOVAPS);
		mOpcodes.put(0x1bfe, OpcodeEnum.VPSUBW);
		mOpcodes.put(0x80d, OpcodeEnum.PMULHRW);
		mOpcodes.put(0x993, OpcodeEnum.MOVAPS);
		mOpcodes.put(0x79b, OpcodeEnum.PFMIN);
		mOpcodes.put(0xf50, OpcodeEnum.MOVD);
		mOpcodes.put(0x921, OpcodeEnum.MOVHPS);
		mOpcodes.put(0xc5b, OpcodeEnum.MULPS);
		mOpcodes.put(0x1258, OpcodeEnum.VCMPLTPS);
		mOpcodes.put(0x368, OpcodeEnum.BT);
		mOpcodes.put(0x99b, OpcodeEnum.MOVAPD);
		mOpcodes.put(0x137d, OpcodeEnum.VCMPNGE_UQPS);
		mOpcodes.put(0x1b8, OpcodeEnum.JRCXZ);
		mOpcodes.put(0xc62, OpcodeEnum.MULPD);
		mOpcodes.put(0x127, OpcodeEnum.MOVS);
		mOpcodes.put(0x6af, OpcodeEnum.INVLPG);
		mOpcodes.put(0xf56, OpcodeEnum.MOVQ);
		mOpcodes.put(0xd8c, OpcodeEnum.VMINPD);
		mOpcodes.put(0x1e26, OpcodeEnum.PABSD);
		mOpcodes.put(0x11b, OpcodeEnum.SAHF);
		mOpcodes.put(0x13d1, OpcodeEnum.VCMPTRUE_USPS);
		mOpcodes.put(0x76c, OpcodeEnum.PI2FD);
		mOpcodes.put(0x1e08, OpcodeEnum.PABSB);
		mOpcodes.put(0x247f, OpcodeEnum.VROUNDSD);
		mOpcodes.put(0x1a10, OpcodeEnum.VPANDN);
		mOpcodes.put(0xe55, OpcodeEnum.VPUNPCKLDQ);
		mOpcodes.put(0x62a, OpcodeEnum.FDIVP);
		mOpcodes.put(0x1c15, OpcodeEnum.PSUBQ);
		mOpcodes.put(0x41b, OpcodeEnum.FDIVR);
		mOpcodes.put(0x415, OpcodeEnum.FDIV);
		mOpcodes.put(0x1563, OpcodeEnum.VCMPTRUE_USPD);
		mOpcodes.put(0x750, OpcodeEnum.PREFETCH);
		mOpcodes.put(0x1004, OpcodeEnum.EMMS);
		mOpcodes.put(0xd84, OpcodeEnum.VMINPS);
		mOpcodes.put(0x22e6, OpcodeEnum.VFMADD231PS);
		mOpcodes.put(0x227c, OpcodeEnum.VFNMSUB213PD);
		mOpcodes.put(0xa83, OpcodeEnum.CVTSS2SI);
		mOpcodes.put(0x929, OpcodeEnum.MOVHPD);
		mOpcodes.put(0x29f, OpcodeEnum.CMOVZ);
		mOpcodes.put(0x1a4c, OpcodeEnum.VPAVGW);
		mOpcodes.put(0xff, OpcodeEnum.CQO);
		mOpcodes.put(0x1c0d, OpcodeEnum.VPSUBD);
		mOpcodes.put(0x2cc, OpcodeEnum.CMOVP);
		mOpcodes.put(0x1572, OpcodeEnum.VCMPEQSS);
		mOpcodes.put(0x2bd, OpcodeEnum.CMOVS);
		mOpcodes.put(0x1e4a, OpcodeEnum.PMOVSXBD);
		mOpcodes.put(0x246c, OpcodeEnum.VROUNDSS);
		mOpcodes.put(0x1c1c, OpcodeEnum.VPSUBQ);
		mOpcodes.put(0x2db, OpcodeEnum.CMOVL);
		mOpcodes.put(0x1904, OpcodeEnum.ADDSUBPS);
		mOpcodes.put(0x281, OpcodeEnum.CMOVO);
		mOpcodes.put(0x2b6, OpcodeEnum.CMOVA);
		mOpcodes.put(0x290, OpcodeEnum.CMOVB);
		mOpcodes.put(0xec4, OpcodeEnum.PUNPCKHBW);
		mOpcodes.put(0x262c, OpcodeEnum.PCMPISTRI);
		mOpcodes.put(0x2f2, OpcodeEnum.CMOVG);
		mOpcodes.put(0x198d, OpcodeEnum.VPMOVMSKB);
		mOpcodes.put(0x240a, OpcodeEnum.AESDECLAST);
		mOpcodes.put(0x82f, OpcodeEnum.MOVUPD);
		mOpcodes.put(0x20a6, OpcodeEnum.VFMSUBADD132PD);
		mOpcodes.put(0x1bbc, OpcodeEnum.VPSADBW);
		mOpcodes.put(0x2459, OpcodeEnum.VROUNDPD);
		mOpcodes.put(0x6a9, OpcodeEnum.LMSW);
		mOpcodes.put(0x205c, OpcodeEnum.INVEPT);
		mOpcodes.put(0x39f, OpcodeEnum.MOVZX);
		mOpcodes.put(0xba7, OpcodeEnum.ANDPS);
		mOpcodes.put(0x2096, OpcodeEnum.VFMSUBADD132PS);
		mOpcodes.put(0x827, OpcodeEnum.MOVUPS);
		mOpcodes.put(0x1611, OpcodeEnum.VCMPGTSS);
		mOpcodes.put(0x1a54, OpcodeEnum.PMULHUW);
		mOpcodes.put(0x2595, OpcodeEnum.VDPPD);
		mOpcodes.put(0x24e6, OpcodeEnum.PEXTRD);
		mOpcodes.put(0x15ec, OpcodeEnum.VCMPFALSESS);
		mOpcodes.put(0x26b8, OpcodeEnum.RDGSBASE);
		mOpcodes.put(0x1b, OpcodeEnum.OR);
		mOpcodes.put(0x18af, OpcodeEnum.VPEXTRW);
		mOpcodes.put(0x1adc, OpcodeEnum.VPSUBSB);
		mOpcodes.put(0x26a4, OpcodeEnum.FXRSTOR);
		mOpcodes.put(0x21d, OpcodeEnum.CLTS);
		mOpcodes.put(0x1841, OpcodeEnum.VCMPNGT_UQSD);
		mOpcodes.put(0x15e1, OpcodeEnum.VCMPNGTSS);
		mOpcodes.put(0x5df, OpcodeEnum.FRSTOR);
		mOpcodes.put(0x177e, OpcodeEnum.VCMPFALSESD);
		mOpcodes.put(0x48a, OpcodeEnum.FLDLN2);
		mOpcodes.put(0x251f, OpcodeEnum.VINSERTF128);
		mOpcodes.put(0x1aed, OpcodeEnum.VPSUBSW);
		mOpcodes.put(0x1b8e, OpcodeEnum.PMULUDQ);
		mOpcodes.put(0x56, OpcodeEnum.DEC);
		mOpcodes.put(0x1399, OpcodeEnum.VCMPFALSE_OSPS);
		mOpcodes.put(0x422, OpcodeEnum.FLD);
		mOpcodes.put(0x1f8c, OpcodeEnum.VPMOVZXDQ);
		mOpcodes.put(0x2463, OpcodeEnum.ROUNDSS);
		mOpcodes.put(0x9dd, OpcodeEnum.VCVTSI2SS);
		mOpcodes.put(0x18a7, OpcodeEnum.PEXTRW);
		mOpcodes.put(0x2690, OpcodeEnum.FXSAVE64);
		mOpcodes.put(0x3c7, OpcodeEnum.ROL);
		mOpcodes.put(0x20dd, OpcodeEnum.VFMADD132SD);
		mOpcodes.put(0x1173, OpcodeEnum.CMPLEPD);
		mOpcodes.put(0xce0, OpcodeEnum.VCVTSD2SS);
		mOpcodes.put(0x5f5, OpcodeEnum.FUCOMP);
		mOpcodes.put(0x1ce, OpcodeEnum.JMP);
		mOpcodes.put(0x1704, OpcodeEnum.VCMPEQSD);
		mOpcodes.put(0xceb, OpcodeEnum.CVTDQ2PS);
		mOpcodes.put(0x16e8, OpcodeEnum.VCMPGT_OQSS);
		mOpcodes.put(0x5d0, OpcodeEnum.FUCOMI);
		mOpcodes.put(0x110b, OpcodeEnum.LZCNT);
		mOpcodes.put(0xb97, OpcodeEnum.VRCPPS);
		mOpcodes.put(0x19f8, OpcodeEnum.PMAXUB);
		mOpcodes.put(0x1cd7, OpcodeEnum.VPHADDD);
		mOpcodes.put(0x9e8, OpcodeEnum.VCVTSI2SD);
		mOpcodes.put(0x187a, OpcodeEnum.VCMPGT_OQSD);
		mOpcodes.put(0x3cc, OpcodeEnum.ROR);
		mOpcodes.put(0x22b, OpcodeEnum.INVD);
		mOpcodes.put(0xaa2, OpcodeEnum.VCVTSD2SI);
		mOpcodes.put(0x23f9, OpcodeEnum.AESDEC);
		mOpcodes.put(0x123a, OpcodeEnum.CMPNLESD);
		mOpcodes.put(0x354, OpcodeEnum.SETLE);
		mOpcodes.put(0x22c6, OpcodeEnum.VFMSUBADD231PS);
		mOpcodes.put(0x234e, OpcodeEnum.VFNMADD231PS);
		mOpcodes.put(0x10a0, OpcodeEnum.XSAVE64);
		mOpcodes.put(0xedb, OpcodeEnum.PUNPCKHWD);
		mOpcodes.put(0x1e7e, OpcodeEnum.VPMOVSXWD);
		mOpcodes.put(0xca1, OpcodeEnum.CVTPD2PS);
		mOpcodes.put(0x893, OpcodeEnum.VMOVHLPS);
		mOpcodes.put(0x22d6, OpcodeEnum.VFMSUBADD231PD);
		mOpcodes.put(0xa79, OpcodeEnum.CVTPD2PI);
		mOpcodes.put(0x11eb, OpcodeEnum.CMPNLESS);
		mOpcodes.put(0x1eb3, OpcodeEnum.PMULDQ);
		mOpcodes.put(0x1e93, OpcodeEnum.VPMOVSXWQ);
		mOpcodes.put(0x173a, OpcodeEnum.VCMPNLTSD);
		mOpcodes.put(0x235c, OpcodeEnum.VFNMADD231PD);
		mOpcodes.put(0x1ca6, OpcodeEnum.FSTSW);
		mOpcodes.put(0x748, OpcodeEnum.RDTSCP);
		mOpcodes.put(0x10c3, OpcodeEnum.MFENCE);
		mOpcodes.put(0x20d0, OpcodeEnum.VFMADD132SS);
		mOpcodes.put(0x1fdd, OpcodeEnum.PMINUD);
		mOpcodes.put(0x5ba, OpcodeEnum.FENI);
		mOpcodes.put(0x68, OpcodeEnum.BOUND);
		mOpcodes.put(0x2446, OpcodeEnum.VROUNDPS);
		mOpcodes.put(0xfa5, OpcodeEnum.PSHUFLW);
		mOpcodes.put(0xc87, OpcodeEnum.VMULSS);
		mOpcodes.put(0x184f, OpcodeEnum.VCMPFALSE_OSSD);
		mOpcodes.put(0xd0a, OpcodeEnum.VCVTDQ2PS);
		mOpcodes.put(0x1586, OpcodeEnum.VCMPLESS);
		mOpcodes.put(0x447, OpcodeEnum.FNOP);
		mOpcodes.put(0x1143, OpcodeEnum.CMPNLTPS);
		mOpcodes.put(0x1284, OpcodeEnum.VCMPNLTPS);
		mOpcodes.put(0x482, OpcodeEnum.FLDLG2);
		mOpcodes.put(0x223, OpcodeEnum.SYSRET);
		mOpcodes.put(0x1c6a, OpcodeEnum.FSTCW);
		mOpcodes.put(0x221c, OpcodeEnum.VFMSUB213SS);
		mOpcodes.put(0x72f, OpcodeEnum.SKINIT);
		mOpcodes.put(0xbbd, OpcodeEnum.VANDPD);
		mOpcodes.put(0x492, OpcodeEnum.FLDZ);
		mOpcodes.put(0x33, OpcodeEnum.SUB);
		mOpcodes.put(0x1cc6, OpcodeEnum.VPHADDW);
		mOpcodes.put(0x654, OpcodeEnum.NEG);
		mOpcodes.put(0x1fcc, OpcodeEnum.PMINUW);
		mOpcodes.put(0xde7, OpcodeEnum.MAXPD);
		mOpcodes.put(0x1363, OpcodeEnum.VCMPORD_SPS);
		mOpcodes.put(0x133, OpcodeEnum.STOS);
		mOpcodes.put(0x23b0, OpcodeEnum.VFNMSUB231SD);
		mOpcodes.put(0x1722, OpcodeEnum.VCMPUNORDSD);
		mOpcodes.put(0x81e, OpcodeEnum.PAVGUSB);
		mOpcodes.put(0x14f5, OpcodeEnum.VCMPORD_SPD);
		mOpcodes.put(0xde0, OpcodeEnum.MAXPS);
		mOpcodes.put(0x19be, OpcodeEnum.PMINUB);
		mOpcodes.put(0x1bdb, OpcodeEnum.VMASKMOVDQU);
		mOpcodes.put(0x637, OpcodeEnum.FBSTP);
		mOpcodes.put(0x1896, OpcodeEnum.PINSRW);
		mOpcodes.put(0x1f62, OpcodeEnum.VPMOVZXWD);
		mOpcodes.put(0x1fd4, OpcodeEnum.VPMINUW);
		mOpcodes.put(0x180b, OpcodeEnum.VCMPNLE_UQSD);
		mOpcodes.put(0x18a, OpcodeEnum.SALC);
		mOpcodes.put(0x24d5, OpcodeEnum.PEXTRB);
		mOpcodes.put(0x8d8, OpcodeEnum.VUNPCKLPS);
		mOpcodes.put(0x1679, OpcodeEnum.VCMPNLE_UQSS);
		mOpcodes.put(0xf6a, OpcodeEnum.MOVDQA);
		mOpcodes.put(0x15a8, OpcodeEnum.VCMPNLTSS);
		mOpcodes.put(0x1b7f, OpcodeEnum.PSLLQ);
		mOpcodes.put(0xa17, OpcodeEnum.VMOVNTPS);
		mOpcodes.put(0x1fe5, OpcodeEnum.VPMINUD);
		mOpcodes.put(0x962, OpcodeEnum.PREFETCHNTA);
		mOpcodes.put(0x8e3, OpcodeEnum.VUNPCKLPD);
		mOpcodes.put(0x1041, OpcodeEnum.CVTPH2PS);
		mOpcodes.put(0x2654, OpcodeEnum.VAESKEYGENASSIST);
		mOpcodes.put(0x1ae5, OpcodeEnum.PSUBSW);
		mOpcodes.put(0x1768, OpcodeEnum.VCMPNGESD);
		mOpcodes.put(0x1c51, OpcodeEnum.FNSTENV);
		mOpcodes.put(0x1c9e, OpcodeEnum.FNSTSW);
		mOpcodes.put(0x1188, OpcodeEnum.CMPNEQPD);
		mOpcodes.put(0x1a45, OpcodeEnum.PAVGW);
		mOpcodes.put(0x9fc, OpcodeEnum.MOVNTPD);
		mOpcodes.put(0x1502, OpcodeEnum.VCMPEQ_USPD);
		mOpcodes.put(0x5c8, OpcodeEnum.FSETPM);
		mOpcodes.put(0x1db9, OpcodeEnum.BLENDVPS);
		mOpcodes.put(0x219e, OpcodeEnum.VFMADDSUB213PD);
		mOpcodes.put(0xb, OpcodeEnum.ADD);
		mOpcodes.put(0x15d6, OpcodeEnum.VCMPNGESS);
		mOpcodes.put(0x1f, OpcodeEnum.ADC);
		mOpcodes.put(0x1ad4, OpcodeEnum.PSUBSB);
		mOpcodes.put(0x1dc3, OpcodeEnum.BLENDVPD);
		mOpcodes.put(0xecf, OpcodeEnum.VPUNPCKHBW);
		mOpcodes.put(0x25f, OpcodeEnum.RDPMC);
		mOpcodes.put(0x9f3, OpcodeEnum.MOVNTPS);
		mOpcodes.put(0x10fa, OpcodeEnum.BSF);
		mOpcodes.put(0x13ea, OpcodeEnum.VCMPLTPD);
		mOpcodes.put(0x1a18, OpcodeEnum.PAVGB);
		mOpcodes.put(0xdf, OpcodeEnum.LEA);
		mOpcodes.put(0x1a97, OpcodeEnum.VCVTTPD2DQ);
		mOpcodes.put(0xe7f, OpcodeEnum.VPCMPGTB);
		mOpcodes.put(0xea5, OpcodeEnum.VPCMPGTD);
		mOpcodes.put(0x465, OpcodeEnum.FLD1);
		mOpcodes.put(0x1baa, OpcodeEnum.VPMADDWD);
		mOpcodes.put(0x17e0, OpcodeEnum.VCMPUNORD_SSD);
		mOpcodes.put(0x14a, OpcodeEnum.LES);
		mOpcodes.put(0x313, OpcodeEnum.SETZ);
		mOpcodes.put(0x1fa0, OpcodeEnum.VPCMPGTQ);
		mOpcodes.put(0xc8f, OpcodeEnum.VMULSD);
		mOpcodes.put(0x21ce, OpcodeEnum.VFMADD213PS);
		mOpcodes.put(0x15b3, OpcodeEnum.VCMPNLESS);
		mOpcodes.put(0x867, OpcodeEnum.MOVHLPS);
		mOpcodes.put(0x204f, OpcodeEnum.VPHMINPOSUW);
		mOpcodes.put(0x1e2d, OpcodeEnum.VPABSD);
		mOpcodes.put(0x1a27, OpcodeEnum.PSRAW);
		mOpcodes.put(0x7b9, OpcodeEnum.PFADD);
		mOpcodes.put(0x2086, OpcodeEnum.VFMADDSUB132PD);
		mOpcodes.put(0xadb, OpcodeEnum.COMISD);
		mOpcodes.put(0x13b7, OpcodeEnum.VCMPGE_OQPS);
		mOpcodes.put(0xe0c, OpcodeEnum.VMAXSS);
		mOpcodes.put(0x121a, OpcodeEnum.CMPUNORDSD);
		mOpcodes.put(0x4ef, OpcodeEnum.FSINCOS);
		mOpcodes.put(0xad3, OpcodeEnum.COMISS);
		mOpcodes.put(0x2076, OpcodeEnum.VFMADDSUB132PS);
		mOpcodes.put(0xb89, OpcodeEnum.RCPPS);
		mOpcodes.put(0x212c, OpcodeEnum.VFNMADD132PD);
		mOpcodes.put(0x441, OpcodeEnum.FXCH);
		mOpcodes.put(0x2e, OpcodeEnum.DAA);
		mOpcodes.put(0x320, OpcodeEnum.SETBE);
		mOpcodes.put(0xcbf, OpcodeEnum.VCVTPS2PD);
		mOpcodes.put(0x1ba1, OpcodeEnum.PMADDWD);
		mOpcodes.put(0xbae, OpcodeEnum.ANDPD);
		mOpcodes.put(0x131d, OpcodeEnum.VCMPLE_OQPS);
		mOpcodes.put(0x1773, OpcodeEnum.VCMPNGTSD);
		mOpcodes.put(0x2386, OpcodeEnum.VFNMSUB231PS);
		mOpcodes.put(0x63e, OpcodeEnum.FUCOMIP);
		mOpcodes.put(0xc77, OpcodeEnum.VMULPS);
		mOpcodes.put(0x211e, OpcodeEnum.VFNMADD132PS);
		mOpcodes.put(0x26cb, OpcodeEnum.WRFSBASE);
		mOpcodes.put(0x38, OpcodeEnum.DAS);
		mOpcodes.put(0x14af, OpcodeEnum.VCMPLE_OQPD);
		mOpcodes.put(0x17a, OpcodeEnum.IRET);
		mOpcodes.put(0x3c0, OpcodeEnum.BSWAP);
		mOpcodes.put(0xe1c, OpcodeEnum.PUNPCKLBW);
		mOpcodes.put(0x2010, OpcodeEnum.PMAXUW);
		mOpcodes.put(0x2620, OpcodeEnum.VPCMPISTRM);
		mOpcodes.put(0x1b61, OpcodeEnum.PSLLW);
		mOpcodes.put(0x164e, OpcodeEnum.VCMPUNORD_SSS);
		mOpcodes.put(0x2236, OpcodeEnum.VFNMADD213PS);
		mOpcodes.put(0xa63, OpcodeEnum.VCVTTSD2SI);
		mOpcodes.put(0x2327, OpcodeEnum.VFMSUB231PD);
		mOpcodes.put(0x138b, OpcodeEnum.VCMPNGT_UQPS);
		mOpcodes.put(0x1c62, OpcodeEnum.FNSTCW);
		mOpcodes.put(0x2476, OpcodeEnum.ROUNDSD);
		mOpcodes.put(0x119c, OpcodeEnum.CMPNLEPD);
		mOpcodes.put(0x24ee, OpcodeEnum.PEXTRQ);
		mOpcodes.put(0x1a67, OpcodeEnum.PMULHW);
		mOpcodes.put(0x1ce9, OpcodeEnum.VPHADDSW);
		mOpcodes.put(0x58e, OpcodeEnum.FISTP);
		mOpcodes.put(0x1f6d, OpcodeEnum.PMOVZXWQ);
		mOpcodes.put(0xcca, OpcodeEnum.VCVTPD2PS);
		mOpcodes.put(0x16f5, OpcodeEnum.VCMPTRUE_USSS);
		mOpcodes.put(0xc53, OpcodeEnum.VADDSD);
		mOpcodes.put(0x1daf, OpcodeEnum.PBLENDVB);
		mOpcodes.put(0x6c9, OpcodeEnum.VMRESUME);
		mOpcodes.put(0xab6, OpcodeEnum.UCOMISD);
		mOpcodes.put(0x1f58, OpcodeEnum.PMOVZXWD);
		mOpcodes.put(0xa36, OpcodeEnum.CVTTPD2PI);
		mOpcodes.put(0xaad, OpcodeEnum.UCOMISS);
		mOpcodes.put(0xe6b, OpcodeEnum.VPACKSSWB);
		mOpcodes.put(0xc4b, OpcodeEnum.VADDSS);
		mOpcodes.put(0xf9c, OpcodeEnum.PSHUFHW);
		mOpcodes.put(0x1887, OpcodeEnum.VCMPTRUE_USSD);
		mOpcodes.put(0x6e4, OpcodeEnum.MWAIT);
	}
}
