info = {
    "name": "se",
    "date_order": "YMD",
    "january": [
        "ođđajagemánnu",
        "ođđj"
    ],
    "february": [
        "guov",
        "guovvamánnu"
    ],
    "march": [
        "njuk",
        "njukčamánnu"
    ],
    "april": [
        "cuo",
        "cuoŋománnu"
    ],
    "may": [
        "mies",
        "miessemánnu"
    ],
    "june": [
        "geas",
        "geassemánnu"
    ],
    "july": [
        "suoi",
        "suoidnemánnu"
    ],
    "august": [
        "borg",
        "borgemánnu"
    ],
    "september": [
        "čakč",
        "čakčamánnu"
    ],
    "october": [
        "golg",
        "golggotmánnu"
    ],
    "november": [
        "skáb",
        "skábmamánnu"
    ],
    "december": [
        "juov",
        "juovlamánnu"
    ],
    "monday": [
        "vuos",
        "vuossárga"
    ],
    "tuesday": [
        "maŋ",
        "maŋŋebárga"
    ],
    "wednesday": [
        "gask",
        "gaskavahkku"
    ],
    "thursday": [
        "duor",
        "duorasdat"
    ],
    "friday": [
        "bear",
        "bearjadat"
    ],
    "saturday": [
        "láv",
        "lávvardat"
    ],
    "sunday": [
        "sotn",
        "sotnabeaivi"
    ],
    "am": [
        "ib",
        "iđitbeaivet",
        "iđitbeaivi"
    ],
    "pm": [
        "eahketbeaivet",
        "eahketbeaivi",
        "eb"
    ],
    "year": [
        "jáhki"
    ],
    "month": [
        "mánnu"
    ],
    "week": [
        "váhkku"
    ],
    "day": [
        "beaivi"
    ],
    "hour": [
        "diibmu"
    ],
    "minute": [
        "minuhtta"
    ],
    "second": [
        "sekunda"
    ],
    "relative-type": {
        "0 day ago": [
            "odne"
        ],
        "0 hour ago": [
            "this hour"
        ],
        "0 minute ago": [
            "this minute"
        ],
        "0 month ago": [
            "this month"
        ],
        "0 second ago": [
            "now"
        ],
        "0 week ago": [
            "this week"
        ],
        "0 year ago": [
            "this year"
        ],
        "1 day ago": [
            "ikte"
        ],
        "1 month ago": [
            "last month"
        ],
        "1 week ago": [
            "last week"
        ],
        "1 year ago": [
            "last year"
        ],
        "in 1 day": [
            "ihttin"
        ],
        "in 1 month": [
            "next month"
        ],
        "in 1 week": [
            "next week"
        ],
        "in 1 year": [
            "next year"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+) jándor árat",
            "(\\d+) jándora árat"
        ],
        "\\1 hour ago": [
            "(\\d+) diibmu árat",
            "(\\d+) diibmur árat"
        ],
        "\\1 minute ago": [
            "(\\d+) minuhta árat",
            "(\\d+) minuhtta árat"
        ],
        "\\1 month ago": [
            "(\\d+) mánotbadji árat"
        ],
        "\\1 second ago": [
            "(\\d+) sekunda árat",
            "(\\d+) sekundda árat"
        ],
        "\\1 week ago": [
            "(\\d+) vahkku árat",
            "(\\d+) vahku árat"
        ],
        "\\1 year ago": [
            "(\\d+) jahki árat",
            "(\\d+) jahkki árat"
        ],
        "in \\1 day": [
            "(\\d+) jándor maŋŋilit",
            "(\\d+) jándora maŋŋilit"
        ],
        "in \\1 hour": [
            "(\\d+) diibmu maŋŋilit",
            "(\\d+) diibmur maŋŋilit"
        ],
        "in \\1 minute": [
            "(\\d+) minuhta maŋŋilit",
            "(\\d+) minuhtta maŋŋilit"
        ],
        "in \\1 month": [
            "(\\d+) mánotbadji maŋŋilit"
        ],
        "in \\1 second": [
            "(\\d+) sekunda maŋŋilit",
            "(\\d+) sekundda maŋŋilit"
        ],
        "in \\1 week": [
            "(\\d+) vahkku maŋŋilit",
            "(\\d+) vahku maŋŋilit"
        ],
        "in \\1 year": [
            "(\\d+) jahki maŋŋilit",
            "(\\d+) jahkki maŋŋilit"
        ]
    },
    "locale_specific": {
        "se-FI": {
            "name": "se-FI",
            "monday": [
                "vuossárgga"
            ],
            "tuesday": [
                "maŋŋebárgga"
            ],
            "wednesday": [
                "gaskavahku"
            ],
            "thursday": [
                "duorastaga"
            ],
            "friday": [
                "bearjadaga"
            ],
            "saturday": [
                "lávvardaga"
            ],
            "year": [
                "j",
                "jahki"
            ],
            "week": [
                "vahkku"
            ],
            "relative-type": {
                "0 year ago": [
                    "dán jagi"
                ],
                "1 year ago": [
                    "mannan jagi"
                ],
                "in 1 year": [
                    "boahtte jagi"
                ]
            },
            "relative-type-regex": {
                "\\1 year ago": [
                    "(\\d+) jagi árat"
                ],
                "in \\1 year": [
                    "(\\d+) jagi siste"
                ]
            }
        },
        "se-SE": {
            "name": "se-SE"
        }
    },
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
