---
annotations_creators:
- no-annotation
language_creators:
- found
languages:
- aa
- ab
- ace
- acu
- ada
- ady
- af
- agr
- aii
- ajg
- als
- alt
- am
- amc
- ame
- ami
- amr
- arb
- arl
- arn
- ast
- auc
- ayr
- azj
- ban
- bax
- bba
- bci
- bcl
- be
- bem
- bfa
- bg
- bho
- bi
- bin
- blt
- bm
- bn
- bo
- boa
- br
- bs
- buc
- bug
- bum
- ca
- cab
- cak
- cbi
- cbr
- cbs
- cbt
- cbu
- ccp
- ceb
- cfm
- ch
- chj
- chk
- chr
- cic
- cjk
- cjs
- cjy
- ckb
- cmn
- cnh
- cni
- co
- cof
- cot
- cpu
- crh
- cri
- crs
- cs
- csa
- csw
- ctd
- cy
- da
- dag
- ddn
- de
- dga
- dip
- duu
- dv
- dyo
- dyu
- dz
- ee
- ekk
- el
- emk
- en
- eo
- es
- ese
- eu
- eve
- evn
- fat
- fi
- fj
- fkv
- fo
- fon
- fr
- fuf
- fur
- fuv
- fy
- ga
- gaa
- gag
- gan
- gaz
- gd
- gjn
- gkp
- gl
- gld
- gu
- guc
- gug
- guu
- gv
- gyr
- ha
- hak
- haw
- he
- hea
- hi
- hil
- hlt
- hms
- hna
- hni
- hnj
- hns
- hr
- hsb
- ht
- hu
- hus
- huu
- hy
- ia
- ibb
- id
- ig
- ii
- ike
- ilo
- io
- is
- it
- ja
- jiv
- jv
- ka
- kbd
- kbp
- kde
- kdh
- kea
- kek
- kha
- khk
- kjh
- kk
- kkh
- kl
- km
- kmb
- kmr
- kn
- knc
- kng
- ko
- koi
- koo
- kqn
- kqs
- kri
- krl
- ktu
- kwi
- ky
- la
- lad
- lb
- lg
- lia
- lij
- lld
- ln
- lns
- lo
- lob
- lot
- loz
- lt
- lua
- lue
- lun
- lus
- lvs
- mad
- mag
- mai
- mam
- maz
- mcd
- mcf
- men
- mfq
- mh
- mi
- mic
- min
- miq
- mk
- ml
- mnw
- mos
- mr
- mt
- mto
- mxi
- mxv
- my
- mzi
- nan
- nb
- nba
- nds
- ng
- nhn
- nio
- niu
- njo
- nku
- nl
- nn
- not
- npi
- nr
- nso
- nv
- ny
- nym
- nyn
- nzi
- oaa
- oc
- ojb
- oki
- orh
- os
- ote
- pa
- pam
- pap
- pau
- pbb
- pbu
- pcd
- pcm
- pes
- pis
- piu
- pl
- plt
- pnb
- pon
- pov
- ppl
- prq
- prs
- pt
- qu
- quc
- qug
- quh
- quy
- quz
- qva
- qvc
- qvh
- qvm
- qvn
- qwh
- qxn
- qxu
- rar
- rgn
- rm
- rmn
- rn
- ro
- ru
- rup
- rw
- sa
- sah
- sco
- se
- sey
- sg
- shk
- shn
- shp
- si
- sk
- skr
- sl
- sm
- sn
- snk
- snn
- so
- sr
- src
- srr
- ss
- st
- su
- suk
- sus
- sv
- swb
- swh
- ta
- taj
- tbz
- tca
- tdt
- te
- tem
- tet
- tg
- th
- ti
- tiv
- tk
- tl
- tly
- tn
- to
- tob
- toi
- toj
- top
- tpi
- tr
- ts
- tsz
- tt
- tw
- ty
- tyv
- tzh
- tzm
- tzo
- ug
- uk
- umb
- und
- ur
- ura
- uzn
- vai
- ve
- vec
- vep
- vi
- vmw
- wa
- war
- wo
- wuu
- wwa
- xh
- xsm
- yad
- yao
- yap
- ydd
- ykg
- yo
- yua
- yue
- zam
- zdj
- zgh
- zlm
- zro
- ztu
- zu
- zyb
licenses:
- unknown
multilinguality:
- multilingual
size_categories:
- n<1K
source_datasets:
- original
task_categories:
- conditional-text-generation
task_ids:
- machine-translation
---

# Dataset Card for The Universal Declaration of Human Rights (UDHR)

## Table of Contents
- [Dataset Description](#dataset-description)
  - [Dataset Summary](#dataset-summary)
  - [Supported Tasks](#supported-tasks-and-leaderboards)
  - [Languages](#languages)
- [Dataset Structure](#dataset-structure)
  - [Data Instances](#data-instances)
  - [Data Fields](#data-instances)
  - [Data Splits](#data-instances)
- [Dataset Creation](#dataset-creation)
  - [Curation Rationale](#curation-rationale)
  - [Source Data](#source-data)
  - [Annotations](#annotations)
  - [Personal and Sensitive Information](#personal-and-sensitive-information)
- [Considerations for Using the Data](#considerations-for-using-the-data)
  - [Social Impact of Dataset](#social-impact-of-dataset)
  - [Discussion of Biases](#discussion-of-biases)
  - [Other Known Limitations](#other-known-limitations)
- [Additional Information](#additional-information)
  - [Dataset Curators](#dataset-curators)
  - [Licensing Information](#licensing-information)
  - [Citation Information](#citation-information)
  - [Contributions](#contributions)

## Dataset Description

- **Homepage:** https://www.ohchr.org/EN/UDHR/Pages/UDHRIndex.aspx, https://unicode.org/udhr/index.html
- **Repository:**
- **Paper:**
- **Leaderboard:**
- **Point of Contact:**

### Dataset Summary

The Universal Declaration of Human Rights (UDHR) is a milestone document in the history of human rights. Drafted by
representatives with different legal and cultural backgrounds from all regions of the world, it set out, for the
first time, fundamental human rights to be universally protected. The Declaration was adopted by the UN General
Assembly in Paris on 10 December 1948 during its 183rd plenary meeting.

© 1996 – 2009 The Office of the High Commissioner for Human Rights

This plain text version prepared by the “UDHR in Unicode” project, https://www.unicode.org/udhr.

### Supported Tasks and Leaderboards

[More Information Needed]

### Languages

The dataset includes translations of the document in 467 languages and dialects. The list of languages can be found
[here](https://unicode.org/udhr/translations.html).

## Dataset Structure

### Data Instances

Each instance corresponds to a different language and includes information about the language and the full document
text.

### Data Fields

- `text`: The full document text with each line of text delimitted by a newline (`\n`).
- `lang_key`: The unique identifier of a given translation.
- `lang_name`: The textual description of language/dialect.
- `iso639-3`: The [iso639-3](https://iso639-3.sil.org/) language identifier.
- `iso15924`: The [iso15924](https://unicode.org/iso15924/iso15924-codes.html) language identifier.

### Data Splits

Only a `train` split included which includes the full document in all languages.

## Dataset Creation

### Curation Rationale

In addition to its social significance, the document set a world record in 1999 for being the most translated
document in the world and as such can be useful for settings requiring paired text between many languages.

### Source Data

#### Initial Data Collection and Normalization

[More Information Needed]

#### Who are the source language producers?

[More Information Needed]

### Annotations

#### Annotation process

[More Information Needed]

#### Who are the annotators?

[More Information Needed]

### Personal and Sensitive Information

[More Information Needed]

## Considerations for Using the Data

### Social Impact of Dataset

In addition to the social and political significance of the United Nations' Universal Declaration of Human Rights,
the document set a world record in 1999 for being the most translated document in the world and as such can be useful
for settings requiring paired text between many languagers including those that are low resource and significantly
underrepresented in NLP research.

### Discussion of Biases

[More Information Needed]

### Other Known Limitations

Although the document is translated into a very large number of languages, the text is very short and therefore may
have limited usefulness for most types of modeling and evaluation.

## Additional Information

### Dataset Curators

The txt/xml data files used here were compiled by The Unicode Consortium, which can be found
[here](https://unicode.org/udhr/index.html). The original texts can be found on the
[United Nations website](https://www.ohchr.org/EN/UDHR/Pages/UDHRIndex.aspx).

### Licensing Information

© 1996 – 2009 The Office of the High Commissioner for Human Rights

[More Information Needed]

### Citation Information

[More Information Needed]

### Contributions

Thanks to [@joeddav](https://github.com/joeddav) for adding this dataset.