"""
Tile providers.

This file is autogenerated! It is a python representation of the leaflet
providers defined by the leaflet-providers.js extension to Leaflet
(https://github.com/leaflet-extras/leaflet-providers).
Credit to the leaflet-providers.js  project (BSD 2-Clause "Simplified" License)
and the Leaflet Providers contributors.

Generated by parse_leaflet_providers.py at 2019-08-01 from leaflet-providers
at commit 9eb968f8442ea492626c9c8f0dac8ede484e6905 (Bumped version to 1.8.0).

"""


class Bunch(dict):
    """A dict with attribute-access"""

    def __getattr__(self, key):
        try:
            return self.__getitem__(key)
        except KeyError:
            raise AttributeError(key)

    def __dir__(self):
        return self.keys()


class TileProvider(Bunch):
    """
    A dict with attribute-access and that
    can be called to update keys
    """

    def __call__(self, **kwargs):
        new = TileProvider(self)  # takes a copy preserving the class
        new.update(kwargs)
        return new


providers = Bunch(
    OpenStreetMap = Bunch(
        Mapnik = TileProvider(
            url = 'https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png',
            max_zoom = 19,
            attribution = '(C) OpenStreetMap contributors',
            name = 'OpenStreetMap.Mapnik'
        ),
        DE = TileProvider(
            url = 'https://{s}.tile.openstreetmap.de/tiles/osmde/{z}/{x}/{y}.png',
            max_zoom = 18,
            attribution = '(C) OpenStreetMap contributors',
            name = 'OpenStreetMap.DE'
        ),
        CH = TileProvider(
            url = 'https://tile.osm.ch/switzerland/{z}/{x}/{y}.png',
            max_zoom = 18,
            attribution = '(C) OpenStreetMap contributors',
            bounds = [[45, 5], [48, 11]],
            name = 'OpenStreetMap.CH'
        ),
        France = TileProvider(
            url = 'https://{s}.tile.openstreetmap.fr/osmfr/{z}/{x}/{y}.png',
            max_zoom = 20,
            attribution = '(C) Openstreetmap France | (C) OpenStreetMap contributors',
            name = 'OpenStreetMap.France'
        ),
        HOT = TileProvider(
            url = 'https://{s}.tile.openstreetmap.fr/hot/{z}/{x}/{y}.png',
            max_zoom = 19,
            attribution = '(C) OpenStreetMap contributors, Tiles style by Humanitarian OpenStreetMap Team hosted by OpenStreetMap France',
            name = 'OpenStreetMap.HOT'
        ),
        BZH = TileProvider(
            url = 'https://tile.openstreetmap.bzh/br/{z}/{x}/{y}.png',
            max_zoom = 19,
            attribution = '(C) OpenStreetMap contributors, Tiles courtesy of Breton OpenStreetMap Team',
            bounds = [[46.2, -5.5], [50, 0.7]],
            name = 'OpenStreetMap.BZH'
        )
    ),
    OpenSeaMap = TileProvider(
        url = 'https://tiles.openseamap.org/seamark/{z}/{x}/{y}.png',
        attribution = 'Map data: (C) OpenSeaMap contributors',
        name = 'OpenSeaMap'
    ),
    OpenPtMap = TileProvider(
        url = 'http://openptmap.org/tiles/{z}/{x}/{y}.png',
        max_zoom = 17,
        attribution = 'Map data: (C) OpenPtMap contributors',
        name = 'OpenPtMap'
    ),
    OpenTopoMap = TileProvider(
        url = 'https://{s}.tile.opentopomap.org/{z}/{x}/{y}.png',
        max_zoom = 17,
        attribution = 'Map data: (C) OpenStreetMap contributors, SRTM | Map style: (C) OpenTopoMap (CC-BY-SA)',
        name = 'OpenTopoMap'
    ),
    OpenRailwayMap = TileProvider(
        url = 'https://{s}.tiles.openrailwaymap.org/standard/{z}/{x}/{y}.png',
        max_zoom = 19,
        attribution = 'Map data: (C) OpenStreetMap contributors | Map style: (C) OpenRailwayMap (CC-BY-SA)',
        name = 'OpenRailwayMap'
    ),
    OpenFireMap = TileProvider(
        url = 'http://openfiremap.org/hytiles/{z}/{x}/{y}.png',
        max_zoom = 19,
        attribution = 'Map data: (C) OpenStreetMap contributors | Map style: (C) OpenFireMap (CC-BY-SA)',
        name = 'OpenFireMap'
    ),
    SafeCast = TileProvider(
        url = 'https://s3.amazonaws.com/te512.safecast.org/{z}/{x}/{y}.png',
        max_zoom = 16,
        attribution = 'Map data: (C) OpenStreetMap contributors | Map style: (C) SafeCast (CC-BY-SA)',
        name = 'SafeCast'
    ),
    Thunderforest = Bunch(
        OpenCycleMap = TileProvider(
            url = 'https://{s}.tile.thunderforest.com/{variant}/{z}/{x}/{y}.png?apikey={apikey}',
            attribution = '(C) Thunderforest, (C) OpenStreetMap contributors',
            variant = 'cycle',
            apikey = '<insert your api key here>',
            max_zoom = 22,
            name = 'Thunderforest.OpenCycleMap'
        ),
        Transport = TileProvider(
            url = 'https://{s}.tile.thunderforest.com/{variant}/{z}/{x}/{y}.png?apikey={apikey}',
            attribution = '(C) Thunderforest, (C) OpenStreetMap contributors',
            variant = 'transport',
            apikey = '<insert your api key here>',
            max_zoom = 22,
            name = 'Thunderforest.Transport'
        ),
        TransportDark = TileProvider(
            url = 'https://{s}.tile.thunderforest.com/{variant}/{z}/{x}/{y}.png?apikey={apikey}',
            attribution = '(C) Thunderforest, (C) OpenStreetMap contributors',
            variant = 'transport-dark',
            apikey = '<insert your api key here>',
            max_zoom = 22,
            name = 'Thunderforest.TransportDark'
        ),
        SpinalMap = TileProvider(
            url = 'https://{s}.tile.thunderforest.com/{variant}/{z}/{x}/{y}.png?apikey={apikey}',
            attribution = '(C) Thunderforest, (C) OpenStreetMap contributors',
            variant = 'spinal-map',
            apikey = '<insert your api key here>',
            max_zoom = 22,
            name = 'Thunderforest.SpinalMap'
        ),
        Landscape = TileProvider(
            url = 'https://{s}.tile.thunderforest.com/{variant}/{z}/{x}/{y}.png?apikey={apikey}',
            attribution = '(C) Thunderforest, (C) OpenStreetMap contributors',
            variant = 'landscape',
            apikey = '<insert your api key here>',
            max_zoom = 22,
            name = 'Thunderforest.Landscape'
        ),
        Outdoors = TileProvider(
            url = 'https://{s}.tile.thunderforest.com/{variant}/{z}/{x}/{y}.png?apikey={apikey}',
            attribution = '(C) Thunderforest, (C) OpenStreetMap contributors',
            variant = 'outdoors',
            apikey = '<insert your api key here>',
            max_zoom = 22,
            name = 'Thunderforest.Outdoors'
        ),
        Pioneer = TileProvider(
            url = 'https://{s}.tile.thunderforest.com/{variant}/{z}/{x}/{y}.png?apikey={apikey}',
            attribution = '(C) Thunderforest, (C) OpenStreetMap contributors',
            variant = 'pioneer',
            apikey = '<insert your api key here>',
            max_zoom = 22,
            name = 'Thunderforest.Pioneer'
        ),
        MobileAtlas = TileProvider(
            url = 'https://{s}.tile.thunderforest.com/{variant}/{z}/{x}/{y}.png?apikey={apikey}',
            attribution = '(C) Thunderforest, (C) OpenStreetMap contributors',
            variant = 'mobile-atlas',
            apikey = '<insert your api key here>',
            max_zoom = 22,
            name = 'Thunderforest.MobileAtlas'
        ),
        Neighbourhood = TileProvider(
            url = 'https://{s}.tile.thunderforest.com/{variant}/{z}/{x}/{y}.png?apikey={apikey}',
            attribution = '(C) Thunderforest, (C) OpenStreetMap contributors',
            variant = 'neighbourhood',
            apikey = '<insert your api key here>',
            max_zoom = 22,
            name = 'Thunderforest.Neighbourhood'
        )
    ),
    OpenMapSurfer = Bunch(
        Roads = TileProvider(
            url = 'https://maps.heigit.org/openmapsurfer/tiles/{variant}/webmercator/{z}/{x}/{y}.png',
            max_zoom = 19,
            variant = 'roads',
            attribution = 'Imagery from GIScience Research Group @ University of Heidelberg | Map data (C) OpenStreetMap contributors',
            name = 'OpenMapSurfer.Roads'
        ),
        Hybrid = TileProvider(
            url = 'https://maps.heigit.org/openmapsurfer/tiles/{variant}/webmercator/{z}/{x}/{y}.png',
            max_zoom = 19,
            variant = 'hybrid',
            attribution = 'Imagery from GIScience Research Group @ University of Heidelberg | Map data (C) OpenStreetMap contributors',
            name = 'OpenMapSurfer.Hybrid'
        ),
        AdminBounds = TileProvider(
            url = 'https://maps.heigit.org/openmapsurfer/tiles/{variant}/webmercator/{z}/{x}/{y}.png',
            max_zoom = 18,
            variant = 'adminb',
            attribution = 'Imagery from GIScience Research Group @ University of Heidelberg | Map data (C) OpenStreetMap contributors',
            name = 'OpenMapSurfer.AdminBounds'
        ),
        ContourLines = TileProvider(
            url = 'https://maps.heigit.org/openmapsurfer/tiles/{variant}/webmercator/{z}/{x}/{y}.png',
            max_zoom = 18,
            variant = 'asterc',
            attribution = 'Imagery from GIScience Research Group @ University of Heidelberg | Map data ASTER GDEM',
            min_zoom = 13,
            name = 'OpenMapSurfer.ContourLines'
        ),
        Hillshade = TileProvider(
            url = 'https://maps.heigit.org/openmapsurfer/tiles/{variant}/webmercator/{z}/{x}/{y}.png',
            max_zoom = 18,
            variant = 'asterh',
            attribution = 'Imagery from GIScience Research Group @ University of Heidelberg | Map data ASTER GDEM, SRTM',
            name = 'OpenMapSurfer.Hillshade'
        ),
        ElementsAtRisk = TileProvider(
            url = 'https://maps.heigit.org/openmapsurfer/tiles/{variant}/webmercator/{z}/{x}/{y}.png',
            max_zoom = 19,
            variant = 'elements_at_risk',
            attribution = 'Imagery from GIScience Research Group @ University of Heidelberg | Map data (C) OpenStreetMap contributors',
            name = 'OpenMapSurfer.ElementsAtRisk'
        )
    ),
    Hydda = Bunch(
        Full = TileProvider(
            url = 'https://{s}.tile.openstreetmap.se/hydda/{variant}/{z}/{x}/{y}.png',
            max_zoom = 18,
            variant = 'full',
            attribution = 'Tiles courtesy of OpenStreetMap Sweden -- Map data (C) OpenStreetMap contributors',
            name = 'Hydda.Full'
        ),
        Base = TileProvider(
            url = 'https://{s}.tile.openstreetmap.se/hydda/{variant}/{z}/{x}/{y}.png',
            max_zoom = 18,
            variant = 'base',
            attribution = 'Tiles courtesy of OpenStreetMap Sweden -- Map data (C) OpenStreetMap contributors',
            name = 'Hydda.Base'
        ),
        RoadsAndLabels = TileProvider(
            url = 'https://{s}.tile.openstreetmap.se/hydda/{variant}/{z}/{x}/{y}.png',
            max_zoom = 18,
            variant = 'roads_and_labels',
            attribution = 'Tiles courtesy of OpenStreetMap Sweden -- Map data (C) OpenStreetMap contributors',
            name = 'Hydda.RoadsAndLabels'
        )
    ),
    MapBox = TileProvider(
        url = 'https://api.tiles.mapbox.com/v4/{id}/{z}/{x}/{y}{r}.png?access_token={accessToken}',
        attribution = '(C) Mapbox (C) OpenStreetMap contributors Improve this map',
        subdomains = 'abcd',
        id = 'mapbox.streets',
        accessToken = '<insert your access token here>',
        name = 'MapBox'
    ),
    Stamen = Bunch(
        Toner = TileProvider(
            url = 'https://stamen-tiles-{s}.a.ssl.fastly.net/{variant}/{z}/{x}/{y}{r}.{ext}',
            attribution = 'Map tiles by Stamen Design, CC BY 3.0 -- Map data (C) OpenStreetMap contributors',
            subdomains = 'abcd',
            min_zoom = 0,
            max_zoom = 20,
            variant = 'toner',
            ext = 'png',
            name = 'Stamen.Toner'
        ),
        TonerBackground = TileProvider(
            url = 'https://stamen-tiles-{s}.a.ssl.fastly.net/{variant}/{z}/{x}/{y}{r}.{ext}',
            attribution = 'Map tiles by Stamen Design, CC BY 3.0 -- Map data (C) OpenStreetMap contributors',
            subdomains = 'abcd',
            min_zoom = 0,
            max_zoom = 20,
            variant = 'toner-background',
            ext = 'png',
            name = 'Stamen.TonerBackground'
        ),
        TonerHybrid = TileProvider(
            url = 'https://stamen-tiles-{s}.a.ssl.fastly.net/{variant}/{z}/{x}/{y}{r}.{ext}',
            attribution = 'Map tiles by Stamen Design, CC BY 3.0 -- Map data (C) OpenStreetMap contributors',
            subdomains = 'abcd',
            min_zoom = 0,
            max_zoom = 20,
            variant = 'toner-hybrid',
            ext = 'png',
            name = 'Stamen.TonerHybrid'
        ),
        TonerLines = TileProvider(
            url = 'https://stamen-tiles-{s}.a.ssl.fastly.net/{variant}/{z}/{x}/{y}{r}.{ext}',
            attribution = 'Map tiles by Stamen Design, CC BY 3.0 -- Map data (C) OpenStreetMap contributors',
            subdomains = 'abcd',
            min_zoom = 0,
            max_zoom = 20,
            variant = 'toner-lines',
            ext = 'png',
            name = 'Stamen.TonerLines'
        ),
        TonerLabels = TileProvider(
            url = 'https://stamen-tiles-{s}.a.ssl.fastly.net/{variant}/{z}/{x}/{y}{r}.{ext}',
            attribution = 'Map tiles by Stamen Design, CC BY 3.0 -- Map data (C) OpenStreetMap contributors',
            subdomains = 'abcd',
            min_zoom = 0,
            max_zoom = 20,
            variant = 'toner-labels',
            ext = 'png',
            name = 'Stamen.TonerLabels'
        ),
        TonerLite = TileProvider(
            url = 'https://stamen-tiles-{s}.a.ssl.fastly.net/{variant}/{z}/{x}/{y}{r}.{ext}',
            attribution = 'Map tiles by Stamen Design, CC BY 3.0 -- Map data (C) OpenStreetMap contributors',
            subdomains = 'abcd',
            min_zoom = 0,
            max_zoom = 20,
            variant = 'toner-lite',
            ext = 'png',
            name = 'Stamen.TonerLite'
        ),
        Watercolor = TileProvider(
            url = 'https://stamen-tiles-{s}.a.ssl.fastly.net/{variant}/{z}/{x}/{y}.{ext}',
            attribution = 'Map tiles by Stamen Design, CC BY 3.0 -- Map data (C) OpenStreetMap contributors',
            subdomains = 'abcd',
            min_zoom = 1,
            max_zoom = 16,
            variant = 'watercolor',
            ext = 'jpg',
            name = 'Stamen.Watercolor'
        ),
        Terrain = TileProvider(
            url = 'https://stamen-tiles-{s}.a.ssl.fastly.net/{variant}/{z}/{x}/{y}{r}.{ext}',
            attribution = 'Map tiles by Stamen Design, CC BY 3.0 -- Map data (C) OpenStreetMap contributors',
            subdomains = 'abcd',
            min_zoom = 0,
            max_zoom = 18,
            variant = 'terrain',
            ext = 'png',
            name = 'Stamen.Terrain'
        ),
        TerrainBackground = TileProvider(
            url = 'https://stamen-tiles-{s}.a.ssl.fastly.net/{variant}/{z}/{x}/{y}{r}.{ext}',
            attribution = 'Map tiles by Stamen Design, CC BY 3.0 -- Map data (C) OpenStreetMap contributors',
            subdomains = 'abcd',
            min_zoom = 0,
            max_zoom = 18,
            variant = 'terrain-background',
            ext = 'png',
            name = 'Stamen.TerrainBackground'
        ),
        TopOSMRelief = TileProvider(
            url = 'https://stamen-tiles-{s}.a.ssl.fastly.net/{variant}/{z}/{x}/{y}.{ext}',
            attribution = 'Map tiles by Stamen Design, CC BY 3.0 -- Map data (C) OpenStreetMap contributors',
            subdomains = 'abcd',
            min_zoom = 0,
            max_zoom = 20,
            variant = 'toposm-color-relief',
            ext = 'jpg',
            bounds = [[22, -132], [51, -56]],
            name = 'Stamen.TopOSMRelief'
        ),
        TopOSMFeatures = TileProvider(
            url = 'https://stamen-tiles-{s}.a.ssl.fastly.net/{variant}/{z}/{x}/{y}{r}.{ext}',
            attribution = 'Map tiles by Stamen Design, CC BY 3.0 -- Map data (C) OpenStreetMap contributors',
            subdomains = 'abcd',
            min_zoom = 0,
            max_zoom = 20,
            variant = 'toposm-features',
            ext = 'png',
            bounds = [[22, -132], [51, -56]],
            opacity = 0.9,
            name = 'Stamen.TopOSMFeatures'
        )
    ),
    Esri = Bunch(
        WorldStreetMap = TileProvider(
            url = 'https://server.arcgisonline.com/ArcGIS/rest/services/{variant}/MapServer/tile/{z}/{y}/{x}',
            variant = 'World_Street_Map',
            attribution = 'Tiles (C) Esri -- Source: Esri, DeLorme, NAVTEQ, USGS, Intermap, iPC, NRCAN, Esri Japan, METI, Esri China (Hong Kong), Esri (Thailand), TomTom, 2012',
            name = 'Esri.WorldStreetMap'
        ),
        DeLorme = TileProvider(
            url = 'https://server.arcgisonline.com/ArcGIS/rest/services/{variant}/MapServer/tile/{z}/{y}/{x}',
            variant = 'Specialty/DeLorme_World_Base_Map',
            attribution = 'Tiles (C) Esri -- Copyright: (C)2012 DeLorme',
            min_zoom = 1,
            max_zoom = 11,
            name = 'Esri.DeLorme'
        ),
        WorldTopoMap = TileProvider(
            url = 'https://server.arcgisonline.com/ArcGIS/rest/services/{variant}/MapServer/tile/{z}/{y}/{x}',
            variant = 'World_Topo_Map',
            attribution = 'Tiles (C) Esri -- Esri, DeLorme, NAVTEQ, TomTom, Intermap, iPC, USGS, FAO, NPS, NRCAN, GeoBase, Kadaster NL, Ordnance Survey, Esri Japan, METI, Esri China (Hong Kong), and the GIS User Community',
            name = 'Esri.WorldTopoMap'
        ),
        WorldImagery = TileProvider(
            url = 'https://server.arcgisonline.com/ArcGIS/rest/services/{variant}/MapServer/tile/{z}/{y}/{x}',
            variant = 'World_Imagery',
            attribution = 'Tiles (C) Esri -- Source: Esri, i-cubed, USDA, USGS, AEX, GeoEye, Getmapping, Aerogrid, IGN, IGP, UPR-EGP, and the GIS User Community',
            name = 'Esri.WorldImagery'
        ),
        WorldTerrain = TileProvider(
            url = 'https://server.arcgisonline.com/ArcGIS/rest/services/{variant}/MapServer/tile/{z}/{y}/{x}',
            variant = 'World_Terrain_Base',
            attribution = 'Tiles (C) Esri -- Source: USGS, Esri, TANA, DeLorme, and NPS',
            max_zoom = 13,
            name = 'Esri.WorldTerrain'
        ),
        WorldShadedRelief = TileProvider(
            url = 'https://server.arcgisonline.com/ArcGIS/rest/services/{variant}/MapServer/tile/{z}/{y}/{x}',
            variant = 'World_Shaded_Relief',
            attribution = 'Tiles (C) Esri -- Source: Esri',
            max_zoom = 13,
            name = 'Esri.WorldShadedRelief'
        ),
        WorldPhysical = TileProvider(
            url = 'https://server.arcgisonline.com/ArcGIS/rest/services/{variant}/MapServer/tile/{z}/{y}/{x}',
            variant = 'World_Physical_Map',
            attribution = 'Tiles (C) Esri -- Source: US National Park Service',
            max_zoom = 8,
            name = 'Esri.WorldPhysical'
        ),
        OceanBasemap = TileProvider(
            url = 'https://server.arcgisonline.com/ArcGIS/rest/services/{variant}/MapServer/tile/{z}/{y}/{x}',
            variant = 'Ocean_Basemap',
            attribution = 'Tiles (C) Esri -- Sources: GEBCO, NOAA, CHS, OSU, UNH, CSUMB, National Geographic, DeLorme, NAVTEQ, and Esri',
            max_zoom = 13,
            name = 'Esri.OceanBasemap'
        ),
        NatGeoWorldMap = TileProvider(
            url = 'https://server.arcgisonline.com/ArcGIS/rest/services/{variant}/MapServer/tile/{z}/{y}/{x}',
            variant = 'NatGeo_World_Map',
            attribution = 'Tiles (C) Esri -- National Geographic, Esri, DeLorme, NAVTEQ, UNEP-WCMC, USGS, NASA, ESA, METI, NRCAN, GEBCO, NOAA, iPC',
            max_zoom = 16,
            name = 'Esri.NatGeoWorldMap'
        ),
        WorldGrayCanvas = TileProvider(
            url = 'https://server.arcgisonline.com/ArcGIS/rest/services/{variant}/MapServer/tile/{z}/{y}/{x}',
            variant = 'Canvas/World_Light_Gray_Base',
            attribution = 'Tiles (C) Esri -- Esri, DeLorme, NAVTEQ',
            max_zoom = 16,
            name = 'Esri.WorldGrayCanvas'
        )
    ),
    OpenWeatherMap = Bunch(
        Clouds = TileProvider(
            url = 'http://{s}.tile.openweathermap.org/map/{variant}/{z}/{x}/{y}.png?appid={apiKey}',
            max_zoom = 19,
            attribution = 'Map data (C) OpenWeatherMap',
            apiKey = '<insert your api key here>',
            opacity = 0.5,
            variant = 'clouds',
            name = 'OpenWeatherMap.Clouds'
        ),
        CloudsClassic = TileProvider(
            url = 'http://{s}.tile.openweathermap.org/map/{variant}/{z}/{x}/{y}.png?appid={apiKey}',
            max_zoom = 19,
            attribution = 'Map data (C) OpenWeatherMap',
            apiKey = '<insert your api key here>',
            opacity = 0.5,
            variant = 'clouds_cls',
            name = 'OpenWeatherMap.CloudsClassic'
        ),
        Precipitation = TileProvider(
            url = 'http://{s}.tile.openweathermap.org/map/{variant}/{z}/{x}/{y}.png?appid={apiKey}',
            max_zoom = 19,
            attribution = 'Map data (C) OpenWeatherMap',
            apiKey = '<insert your api key here>',
            opacity = 0.5,
            variant = 'precipitation',
            name = 'OpenWeatherMap.Precipitation'
        ),
        PrecipitationClassic = TileProvider(
            url = 'http://{s}.tile.openweathermap.org/map/{variant}/{z}/{x}/{y}.png?appid={apiKey}',
            max_zoom = 19,
            attribution = 'Map data (C) OpenWeatherMap',
            apiKey = '<insert your api key here>',
            opacity = 0.5,
            variant = 'precipitation_cls',
            name = 'OpenWeatherMap.PrecipitationClassic'
        ),
        Rain = TileProvider(
            url = 'http://{s}.tile.openweathermap.org/map/{variant}/{z}/{x}/{y}.png?appid={apiKey}',
            max_zoom = 19,
            attribution = 'Map data (C) OpenWeatherMap',
            apiKey = '<insert your api key here>',
            opacity = 0.5,
            variant = 'rain',
            name = 'OpenWeatherMap.Rain'
        ),
        RainClassic = TileProvider(
            url = 'http://{s}.tile.openweathermap.org/map/{variant}/{z}/{x}/{y}.png?appid={apiKey}',
            max_zoom = 19,
            attribution = 'Map data (C) OpenWeatherMap',
            apiKey = '<insert your api key here>',
            opacity = 0.5,
            variant = 'rain_cls',
            name = 'OpenWeatherMap.RainClassic'
        ),
        Pressure = TileProvider(
            url = 'http://{s}.tile.openweathermap.org/map/{variant}/{z}/{x}/{y}.png?appid={apiKey}',
            max_zoom = 19,
            attribution = 'Map data (C) OpenWeatherMap',
            apiKey = '<insert your api key here>',
            opacity = 0.5,
            variant = 'pressure',
            name = 'OpenWeatherMap.Pressure'
        ),
        PressureContour = TileProvider(
            url = 'http://{s}.tile.openweathermap.org/map/{variant}/{z}/{x}/{y}.png?appid={apiKey}',
            max_zoom = 19,
            attribution = 'Map data (C) OpenWeatherMap',
            apiKey = '<insert your api key here>',
            opacity = 0.5,
            variant = 'pressure_cntr',
            name = 'OpenWeatherMap.PressureContour'
        ),
        Wind = TileProvider(
            url = 'http://{s}.tile.openweathermap.org/map/{variant}/{z}/{x}/{y}.png?appid={apiKey}',
            max_zoom = 19,
            attribution = 'Map data (C) OpenWeatherMap',
            apiKey = '<insert your api key here>',
            opacity = 0.5,
            variant = 'wind',
            name = 'OpenWeatherMap.Wind'
        ),
        Temperature = TileProvider(
            url = 'http://{s}.tile.openweathermap.org/map/{variant}/{z}/{x}/{y}.png?appid={apiKey}',
            max_zoom = 19,
            attribution = 'Map data (C) OpenWeatherMap',
            apiKey = '<insert your api key here>',
            opacity = 0.5,
            variant = 'temp',
            name = 'OpenWeatherMap.Temperature'
        ),
        Snow = TileProvider(
            url = 'http://{s}.tile.openweathermap.org/map/{variant}/{z}/{x}/{y}.png?appid={apiKey}',
            max_zoom = 19,
            attribution = 'Map data (C) OpenWeatherMap',
            apiKey = '<insert your api key here>',
            opacity = 0.5,
            variant = 'snow',
            name = 'OpenWeatherMap.Snow'
        )
    ),
    HERE = Bunch(
        normalDay = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'normal.day',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.normalDay'
        ),
        normalDayCustom = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'normal.day.custom',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.normalDayCustom'
        ),
        normalDayGrey = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'normal.day.grey',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.normalDayGrey'
        ),
        normalDayMobile = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'normal.day.mobile',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.normalDayMobile'
        ),
        normalDayGreyMobile = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'normal.day.grey.mobile',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.normalDayGreyMobile'
        ),
        normalDayTransit = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'normal.day.transit',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.normalDayTransit'
        ),
        normalDayTransitMobile = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'normal.day.transit.mobile',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.normalDayTransitMobile'
        ),
        normalNight = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'normal.night',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.normalNight'
        ),
        normalNightMobile = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'normal.night.mobile',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.normalNightMobile'
        ),
        normalNightGrey = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'normal.night.grey',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.normalNightGrey'
        ),
        normalNightGreyMobile = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'normal.night.grey.mobile',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.normalNightGreyMobile'
        ),
        normalNightTransit = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'normal.night.transit',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.normalNightTransit'
        ),
        normalNightTransitMobile = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'normal.night.transit.mobile',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.normalNightTransitMobile'
        ),
        reducedDay = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'reduced.day',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.reducedDay'
        ),
        reducedNight = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'reduced.night',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.reducedNight'
        ),
        basicMap = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'normal.day',
            max_zoom = 20,
            type = 'basetile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.basicMap'
        ),
        mapLabels = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'normal.day',
            max_zoom = 20,
            type = 'labeltile',
            language = 'eng',
            format = 'png',
            size = '256',
            name = 'HERE.mapLabels'
        ),
        trafficFlow = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'traffic',
            variant = 'normal.day',
            max_zoom = 20,
            type = 'flowtile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.trafficFlow'
        ),
        carnavDayGrey = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'carnav.day.grey',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.carnavDayGrey'
        ),
        hybridDay = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'aerial',
            variant = 'hybrid.day',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.hybridDay'
        ),
        hybridDayMobile = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'aerial',
            variant = 'hybrid.day.mobile',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.hybridDayMobile'
        ),
        hybridDayTransit = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'aerial',
            variant = 'hybrid.day.transit',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.hybridDayTransit'
        ),
        hybridDayGrey = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'aerial',
            variant = 'hybrid.grey.day',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.hybridDayGrey'
        ),
        pedestrianDay = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'pedestrian.day',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.pedestrianDay'
        ),
        pedestrianNight = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'base',
            variant = 'pedestrian.night',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.pedestrianNight'
        ),
        satelliteDay = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'aerial',
            variant = 'satellite.day',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.satelliteDay'
        ),
        terrainDay = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'aerial',
            variant = 'terrain.day',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.terrainDay'
        ),
        terrainDayMobile = TileProvider(
            url = 'https://{s}.{base}.maps.api.here.com/maptile/2.1/{type}/{mapID}/{variant}/{z}/{x}/{y}/{size}/{format}?app_id={app_id}&app_code={app_code}&lg={language}',
            attribution = 'Map (C) 1987-2019 HERE',
            subdomains = '1234',
            mapID = 'newest',
            app_id = '<insert your app_id here>',
            app_code = '<insert your app_code here>',
            base = 'aerial',
            variant = 'terrain.day.mobile',
            max_zoom = 20,
            type = 'maptile',
            language = 'eng',
            format = 'png8',
            size = '256',
            name = 'HERE.terrainDayMobile'
        )
    ),
    FreeMapSK = TileProvider(
        url = 'http://t{s}.freemap.sk/T/{z}/{x}/{y}.jpeg',
        min_zoom = 8,
        max_zoom = 16,
        subdomains = '1234',
        bounds = [[47.204642, 15.996093], [49.830896, 22.576904]],
        attribution = '(C) OpenStreetMap contributors, vizualization CC-By-SA 2.0 Freemap.sk',
        name = 'FreeMapSK'
    ),
    MtbMap = TileProvider(
        url = 'http://tile.mtbmap.cz/mtbmap_tiles/{z}/{x}/{y}.png',
        attribution = '(C) OpenStreetMap contributors & USGS',
        name = 'MtbMap'
    ),
    CartoDB = Bunch(
        Positron = TileProvider(
            url = 'https://{s}.basemaps.cartocdn.com/{variant}/{z}/{x}/{y}{r}.png',
            attribution = '(C) OpenStreetMap contributors (C) CARTO',
            subdomains = 'abcd',
            max_zoom = 19,
            variant = 'light_all',
            name = 'CartoDB.Positron'
        ),
        PositronNoLabels = TileProvider(
            url = 'https://{s}.basemaps.cartocdn.com/{variant}/{z}/{x}/{y}{r}.png',
            attribution = '(C) OpenStreetMap contributors (C) CARTO',
            subdomains = 'abcd',
            max_zoom = 19,
            variant = 'light_nolabels',
            name = 'CartoDB.PositronNoLabels'
        ),
        PositronOnlyLabels = TileProvider(
            url = 'https://{s}.basemaps.cartocdn.com/{variant}/{z}/{x}/{y}{r}.png',
            attribution = '(C) OpenStreetMap contributors (C) CARTO',
            subdomains = 'abcd',
            max_zoom = 19,
            variant = 'light_only_labels',
            name = 'CartoDB.PositronOnlyLabels'
        ),
        DarkMatter = TileProvider(
            url = 'https://{s}.basemaps.cartocdn.com/{variant}/{z}/{x}/{y}{r}.png',
            attribution = '(C) OpenStreetMap contributors (C) CARTO',
            subdomains = 'abcd',
            max_zoom = 19,
            variant = 'dark_all',
            name = 'CartoDB.DarkMatter'
        ),
        DarkMatterNoLabels = TileProvider(
            url = 'https://{s}.basemaps.cartocdn.com/{variant}/{z}/{x}/{y}{r}.png',
            attribution = '(C) OpenStreetMap contributors (C) CARTO',
            subdomains = 'abcd',
            max_zoom = 19,
            variant = 'dark_nolabels',
            name = 'CartoDB.DarkMatterNoLabels'
        ),
        DarkMatterOnlyLabels = TileProvider(
            url = 'https://{s}.basemaps.cartocdn.com/{variant}/{z}/{x}/{y}{r}.png',
            attribution = '(C) OpenStreetMap contributors (C) CARTO',
            subdomains = 'abcd',
            max_zoom = 19,
            variant = 'dark_only_labels',
            name = 'CartoDB.DarkMatterOnlyLabels'
        ),
        Voyager = TileProvider(
            url = 'https://{s}.basemaps.cartocdn.com/{variant}/{z}/{x}/{y}{r}.png',
            attribution = '(C) OpenStreetMap contributors (C) CARTO',
            subdomains = 'abcd',
            max_zoom = 19,
            variant = 'rastertiles/voyager',
            name = 'CartoDB.Voyager'
        ),
        VoyagerNoLabels = TileProvider(
            url = 'https://{s}.basemaps.cartocdn.com/{variant}/{z}/{x}/{y}{r}.png',
            attribution = '(C) OpenStreetMap contributors (C) CARTO',
            subdomains = 'abcd',
            max_zoom = 19,
            variant = 'rastertiles/voyager_nolabels',
            name = 'CartoDB.VoyagerNoLabels'
        ),
        VoyagerOnlyLabels = TileProvider(
            url = 'https://{s}.basemaps.cartocdn.com/{variant}/{z}/{x}/{y}{r}.png',
            attribution = '(C) OpenStreetMap contributors (C) CARTO',
            subdomains = 'abcd',
            max_zoom = 19,
            variant = 'rastertiles/voyager_only_labels',
            name = 'CartoDB.VoyagerOnlyLabels'
        ),
        VoyagerLabelsUnder = TileProvider(
            url = 'https://{s}.basemaps.cartocdn.com/{variant}/{z}/{x}/{y}{r}.png',
            attribution = '(C) OpenStreetMap contributors (C) CARTO',
            subdomains = 'abcd',
            max_zoom = 19,
            variant = 'rastertiles/voyager_labels_under',
            name = 'CartoDB.VoyagerLabelsUnder'
        )
    ),
    HikeBike = Bunch(
        HikeBike = TileProvider(
            url = 'https://tiles.wmflabs.org/{variant}/{z}/{x}/{y}.png',
            max_zoom = 19,
            attribution = '(C) OpenStreetMap contributors',
            variant = 'hikebike',
            name = 'HikeBike.HikeBike'
        ),
        HillShading = TileProvider(
            url = 'https://tiles.wmflabs.org/{variant}/{z}/{x}/{y}.png',
            max_zoom = 15,
            attribution = '(C) OpenStreetMap contributors',
            variant = 'hillshading',
            name = 'HikeBike.HillShading'
        )
    ),
    BasemapAT = Bunch(
        basemap = TileProvider(
            url = 'https://maps{s}.wien.gv.at/basemap/{variant}/normal/google3857/{z}/{y}/{x}.{format}',
            max_zoom = 20,
            attribution = 'Datenquelle: basemap.at',
            subdomains = ['', '1', '2', '3', '4'],
            format = 'png',
            bounds = [[46.35877, 8.782379], [49.037872, 17.189532]],
            variant = 'geolandbasemap',
            name = 'BasemapAT.basemap'
        ),
        grau = TileProvider(
            url = 'https://maps{s}.wien.gv.at/basemap/{variant}/normal/google3857/{z}/{y}/{x}.{format}',
            max_zoom = 19,
            attribution = 'Datenquelle: basemap.at',
            subdomains = ['', '1', '2', '3', '4'],
            format = 'png',
            bounds = [[46.35877, 8.782379], [49.037872, 17.189532]],
            variant = 'bmapgrau',
            name = 'BasemapAT.grau'
        ),
        overlay = TileProvider(
            url = 'https://maps{s}.wien.gv.at/basemap/{variant}/normal/google3857/{z}/{y}/{x}.{format}',
            max_zoom = 19,
            attribution = 'Datenquelle: basemap.at',
            subdomains = ['', '1', '2', '3', '4'],
            format = 'png',
            bounds = [[46.35877, 8.782379], [49.037872, 17.189532]],
            variant = 'bmapoverlay',
            name = 'BasemapAT.overlay'
        ),
        highdpi = TileProvider(
            url = 'https://maps{s}.wien.gv.at/basemap/{variant}/normal/google3857/{z}/{y}/{x}.{format}',
            max_zoom = 19,
            attribution = 'Datenquelle: basemap.at',
            subdomains = ['', '1', '2', '3', '4'],
            format = 'jpeg',
            bounds = [[46.35877, 8.782379], [49.037872, 17.189532]],
            variant = 'bmaphidpi',
            name = 'BasemapAT.highdpi'
        ),
        orthofoto = TileProvider(
            url = 'https://maps{s}.wien.gv.at/basemap/{variant}/normal/google3857/{z}/{y}/{x}.{format}',
            max_zoom = 20,
            attribution = 'Datenquelle: basemap.at',
            subdomains = ['', '1', '2', '3', '4'],
            format = 'jpeg',
            bounds = [[46.35877, 8.782379], [49.037872, 17.189532]],
            variant = 'bmaporthofoto30cm',
            name = 'BasemapAT.orthofoto'
        )
    ),
    nlmaps = Bunch(
        standaard = TileProvider(
            url = 'https://geodata.nationaalgeoregister.nl/tiles/service/wmts/{variant}/EPSG:3857/{z}/{x}/{y}.png',
            min_zoom = 6,
            max_zoom = 19,
            bounds = [[50.5, 3.25], [54, 7.6]],
            attribution = 'Kaartgegevens (C) Kadaster',
            variant = 'brtachtergrondkaart',
            name = 'nlmaps.standaard'
        ),
        pastel = TileProvider(
            url = 'https://geodata.nationaalgeoregister.nl/tiles/service/wmts/{variant}/EPSG:3857/{z}/{x}/{y}.png',
            min_zoom = 6,
            max_zoom = 19,
            bounds = [[50.5, 3.25], [54, 7.6]],
            attribution = 'Kaartgegevens (C) Kadaster',
            variant = 'brtachtergrondkaartpastel',
            name = 'nlmaps.pastel'
        ),
        grijs = TileProvider(
            url = 'https://geodata.nationaalgeoregister.nl/tiles/service/wmts/{variant}/EPSG:3857/{z}/{x}/{y}.png',
            min_zoom = 6,
            max_zoom = 19,
            bounds = [[50.5, 3.25], [54, 7.6]],
            attribution = 'Kaartgegevens (C) Kadaster',
            variant = 'brtachtergrondkaartgrijs',
            name = 'nlmaps.grijs'
        ),
        luchtfoto = TileProvider(
            url = 'https://geodata.nationaalgeoregister.nl/luchtfoto/rgb/wmts/1.0.0/2016_ortho25/EPSG:3857/{z}/{x}/{y}.png',
            min_zoom = 6,
            max_zoom = 19,
            bounds = [[50.5, 3.25], [54, 7.6]],
            attribution = 'Kaartgegevens (C) Kadaster',
            name = 'nlmaps.luchtfoto'
        )
    ),
    NASAGIBS = Bunch(
        ModisTerraTrueColorCR = TileProvider(
            url = 'https://map1.vis.earthdata.nasa.gov/wmts-webmerc/{variant}/default/{time}/{tilematrixset}{max_zoom}/{z}/{y}/{x}.{format}',
            attribution = 'Imagery provided by services from the Global Imagery Browse Services (GIBS), operated by the NASA/GSFC/Earth Science Data and Information System (ESDIS) with funding provided by NASA/HQ.',
            bounds = [[-85.0511287776, -179.999999975], [85.0511287776, 179.999999975]],
            min_zoom = 1,
            max_zoom = 9,
            format = 'jpg',
            time = '',
            tilematrixset = 'GoogleMapsCompatible_Level',
            variant = 'MODIS_Terra_CorrectedReflectance_TrueColor',
            name = 'NASAGIBS.ModisTerraTrueColorCR'
        ),
        ModisTerraBands367CR = TileProvider(
            url = 'https://map1.vis.earthdata.nasa.gov/wmts-webmerc/{variant}/default/{time}/{tilematrixset}{max_zoom}/{z}/{y}/{x}.{format}',
            attribution = 'Imagery provided by services from the Global Imagery Browse Services (GIBS), operated by the NASA/GSFC/Earth Science Data and Information System (ESDIS) with funding provided by NASA/HQ.',
            bounds = [[-85.0511287776, -179.999999975], [85.0511287776, 179.999999975]],
            min_zoom = 1,
            max_zoom = 9,
            format = 'jpg',
            time = '',
            tilematrixset = 'GoogleMapsCompatible_Level',
            variant = 'MODIS_Terra_CorrectedReflectance_Bands367',
            name = 'NASAGIBS.ModisTerraBands367CR'
        ),
        ViirsEarthAtNight2012 = TileProvider(
            url = 'https://map1.vis.earthdata.nasa.gov/wmts-webmerc/{variant}/default/{time}/{tilematrixset}{max_zoom}/{z}/{y}/{x}.{format}',
            attribution = 'Imagery provided by services from the Global Imagery Browse Services (GIBS), operated by the NASA/GSFC/Earth Science Data and Information System (ESDIS) with funding provided by NASA/HQ.',
            bounds = [[-85.0511287776, -179.999999975], [85.0511287776, 179.999999975]],
            min_zoom = 1,
            max_zoom = 8,
            format = 'jpg',
            time = '',
            tilematrixset = 'GoogleMapsCompatible_Level',
            variant = 'VIIRS_CityLights_2012',
            name = 'NASAGIBS.ViirsEarthAtNight2012'
        ),
        ModisTerraLSTDay = TileProvider(
            url = 'https://map1.vis.earthdata.nasa.gov/wmts-webmerc/{variant}/default/{time}/{tilematrixset}{max_zoom}/{z}/{y}/{x}.{format}',
            attribution = 'Imagery provided by services from the Global Imagery Browse Services (GIBS), operated by the NASA/GSFC/Earth Science Data and Information System (ESDIS) with funding provided by NASA/HQ.',
            bounds = [[-85.0511287776, -179.999999975], [85.0511287776, 179.999999975]],
            min_zoom = 1,
            max_zoom = 7,
            format = 'png',
            time = '',
            tilematrixset = 'GoogleMapsCompatible_Level',
            variant = 'MODIS_Terra_Land_Surface_Temp_Day',
            opacity = 0.75,
            name = 'NASAGIBS.ModisTerraLSTDay'
        ),
        ModisTerraSnowCover = TileProvider(
            url = 'https://map1.vis.earthdata.nasa.gov/wmts-webmerc/{variant}/default/{time}/{tilematrixset}{max_zoom}/{z}/{y}/{x}.{format}',
            attribution = 'Imagery provided by services from the Global Imagery Browse Services (GIBS), operated by the NASA/GSFC/Earth Science Data and Information System (ESDIS) with funding provided by NASA/HQ.',
            bounds = [[-85.0511287776, -179.999999975], [85.0511287776, 179.999999975]],
            min_zoom = 1,
            max_zoom = 8,
            format = 'png',
            time = '',
            tilematrixset = 'GoogleMapsCompatible_Level',
            variant = 'MODIS_Terra_Snow_Cover',
            opacity = 0.75,
            name = 'NASAGIBS.ModisTerraSnowCover'
        ),
        ModisTerraAOD = TileProvider(
            url = 'https://map1.vis.earthdata.nasa.gov/wmts-webmerc/{variant}/default/{time}/{tilematrixset}{max_zoom}/{z}/{y}/{x}.{format}',
            attribution = 'Imagery provided by services from the Global Imagery Browse Services (GIBS), operated by the NASA/GSFC/Earth Science Data and Information System (ESDIS) with funding provided by NASA/HQ.',
            bounds = [[-85.0511287776, -179.999999975], [85.0511287776, 179.999999975]],
            min_zoom = 1,
            max_zoom = 6,
            format = 'png',
            time = '',
            tilematrixset = 'GoogleMapsCompatible_Level',
            variant = 'MODIS_Terra_Aerosol',
            opacity = 0.75,
            name = 'NASAGIBS.ModisTerraAOD'
        ),
        ModisTerraChlorophyll = TileProvider(
            url = 'https://map1.vis.earthdata.nasa.gov/wmts-webmerc/{variant}/default/{time}/{tilematrixset}{max_zoom}/{z}/{y}/{x}.{format}',
            attribution = 'Imagery provided by services from the Global Imagery Browse Services (GIBS), operated by the NASA/GSFC/Earth Science Data and Information System (ESDIS) with funding provided by NASA/HQ.',
            bounds = [[-85.0511287776, -179.999999975], [85.0511287776, 179.999999975]],
            min_zoom = 1,
            max_zoom = 7,
            format = 'png',
            time = '',
            tilematrixset = 'GoogleMapsCompatible_Level',
            variant = 'MODIS_Terra_Chlorophyll_A',
            opacity = 0.75,
            name = 'NASAGIBS.ModisTerraChlorophyll'
        )
    ),
    NLS = TileProvider(
        url = 'https://nls-{s}.tileserver.com/nls/{z}/{x}/{y}.jpg',
        attribution = 'National Library of Scotland Historic Maps',
        bounds = [[49.6, -12], [61.7, 3]],
        min_zoom = 1,
        max_zoom = 18,
        subdomains = '0123',
        name = 'NLS'
    ),
    JusticeMap = Bunch(
        income = TileProvider(
            url = 'http://www.justicemap.org/tile/{size}/{variant}/{z}/{x}/{y}.png',
            attribution = 'Justice Map',
            size = 'county',
            bounds = [[14, -180], [72, -56]],
            variant = 'income',
            name = 'JusticeMap.income'
        ),
        americanIndian = TileProvider(
            url = 'http://www.justicemap.org/tile/{size}/{variant}/{z}/{x}/{y}.png',
            attribution = 'Justice Map',
            size = 'county',
            bounds = [[14, -180], [72, -56]],
            variant = 'indian',
            name = 'JusticeMap.americanIndian'
        ),
        asian = TileProvider(
            url = 'http://www.justicemap.org/tile/{size}/{variant}/{z}/{x}/{y}.png',
            attribution = 'Justice Map',
            size = 'county',
            bounds = [[14, -180], [72, -56]],
            variant = 'asian',
            name = 'JusticeMap.asian'
        ),
        black = TileProvider(
            url = 'http://www.justicemap.org/tile/{size}/{variant}/{z}/{x}/{y}.png',
            attribution = 'Justice Map',
            size = 'county',
            bounds = [[14, -180], [72, -56]],
            variant = 'black',
            name = 'JusticeMap.black'
        ),
        hispanic = TileProvider(
            url = 'http://www.justicemap.org/tile/{size}/{variant}/{z}/{x}/{y}.png',
            attribution = 'Justice Map',
            size = 'county',
            bounds = [[14, -180], [72, -56]],
            variant = 'hispanic',
            name = 'JusticeMap.hispanic'
        ),
        multi = TileProvider(
            url = 'http://www.justicemap.org/tile/{size}/{variant}/{z}/{x}/{y}.png',
            attribution = 'Justice Map',
            size = 'county',
            bounds = [[14, -180], [72, -56]],
            variant = 'multi',
            name = 'JusticeMap.multi'
        ),
        nonWhite = TileProvider(
            url = 'http://www.justicemap.org/tile/{size}/{variant}/{z}/{x}/{y}.png',
            attribution = 'Justice Map',
            size = 'county',
            bounds = [[14, -180], [72, -56]],
            variant = 'nonwhite',
            name = 'JusticeMap.nonWhite'
        ),
        white = TileProvider(
            url = 'http://www.justicemap.org/tile/{size}/{variant}/{z}/{x}/{y}.png',
            attribution = 'Justice Map',
            size = 'county',
            bounds = [[14, -180], [72, -56]],
            variant = 'white',
            name = 'JusticeMap.white'
        ),
        plurality = TileProvider(
            url = 'http://www.justicemap.org/tile/{size}/{variant}/{z}/{x}/{y}.png',
            attribution = 'Justice Map',
            size = 'county',
            bounds = [[14, -180], [72, -56]],
            variant = 'plural',
            name = 'JusticeMap.plurality'
        )
    ),
    Wikimedia = TileProvider(
        url = 'https://maps.wikimedia.org/osm-intl/{z}/{x}/{y}{r}.png',
        attribution = 'Wikimedia',
        min_zoom = 1,
        max_zoom = 19,
        name = 'Wikimedia'
    ),
    GeoportailFrance = Bunch(
        parcels = TileProvider(
            url = 'https://wxs.ign.fr/{apikey}/geoportail/wmts?REQUEST=GetTile&SERVICE=WMTS&VERSION=1.0.0&STYLE={style}&TILEMATRIXSET=PM&FORMAT={format}&LAYER={variant}&TILEMATRIX={z}&TILEROW={y}&TILECOL={x}',
            attribution = 'Geoportail France',
            bounds = [[-75, -180], [81, 180]],
            min_zoom = 2,
            max_zoom = 20,
            apikey = 'choisirgeoportail',
            format = 'image/png',
            style = 'bdparcellaire',
            variant = 'CADASTRALPARCELS.PARCELS',
            name = 'GeoportailFrance.parcels'
        ),
        ignMaps = TileProvider(
            url = 'https://wxs.ign.fr/{apikey}/geoportail/wmts?REQUEST=GetTile&SERVICE=WMTS&VERSION=1.0.0&STYLE={style}&TILEMATRIXSET=PM&FORMAT={format}&LAYER={variant}&TILEMATRIX={z}&TILEROW={y}&TILECOL={x}',
            attribution = 'Geoportail France',
            bounds = [[-75, -180], [81, 180]],
            min_zoom = 2,
            max_zoom = 18,
            apikey = 'choisirgeoportail',
            format = 'image/jpeg',
            style = 'normal',
            variant = 'GEOGRAPHICALGRIDSYSTEMS.MAPS',
            name = 'GeoportailFrance.ignMaps'
        ),
        maps = TileProvider(
            url = 'https://wxs.ign.fr/{apikey}/geoportail/wmts?REQUEST=GetTile&SERVICE=WMTS&VERSION=1.0.0&STYLE={style}&TILEMATRIXSET=PM&FORMAT={format}&LAYER={variant}&TILEMATRIX={z}&TILEROW={y}&TILECOL={x}',
            attribution = 'Geoportail France',
            bounds = [[-75, -180], [81, 180]],
            min_zoom = 2,
            max_zoom = 18,
            apikey = 'choisirgeoportail',
            format = 'image/jpeg',
            style = 'normal',
            variant = 'GEOGRAPHICALGRIDSYSTEMS.MAPS.SCAN-EXPRESS.STANDARD',
            name = 'GeoportailFrance.maps'
        ),
        orthos = TileProvider(
            url = 'https://wxs.ign.fr/{apikey}/geoportail/wmts?REQUEST=GetTile&SERVICE=WMTS&VERSION=1.0.0&STYLE={style}&TILEMATRIXSET=PM&FORMAT={format}&LAYER={variant}&TILEMATRIX={z}&TILEROW={y}&TILECOL={x}',
            attribution = 'Geoportail France',
            bounds = [[-75, -180], [81, 180]],
            min_zoom = 2,
            max_zoom = 19,
            apikey = 'choisirgeoportail',
            format = 'image/jpeg',
            style = 'normal',
            variant = 'ORTHOIMAGERY.ORTHOPHOTOS',
            name = 'GeoportailFrance.orthos'
        )
    ),
    OneMapSG = Bunch(
        Default = TileProvider(
            url = 'https://maps-{s}.onemap.sg/v3/{variant}/{z}/{x}/{y}.png',
            variant = 'Default',
            min_zoom = 11,
            max_zoom = 18,
            bounds = [[1.56073, 104.11475], [1.16, 103.502]],
            attribution = '![](https://docs.onemap.sg/maps/images/oneMap64-01.png) New OneMap | Map data (C) contributors, Singapore Land Authority',
            name = 'OneMapSG.Default'
        ),
        Night = TileProvider(
            url = 'https://maps-{s}.onemap.sg/v3/{variant}/{z}/{x}/{y}.png',
            variant = 'Night',
            min_zoom = 11,
            max_zoom = 18,
            bounds = [[1.56073, 104.11475], [1.16, 103.502]],
            attribution = '![](https://docs.onemap.sg/maps/images/oneMap64-01.png) New OneMap | Map data (C) contributors, Singapore Land Authority',
            name = 'OneMapSG.Night'
        ),
        Original = TileProvider(
            url = 'https://maps-{s}.onemap.sg/v3/{variant}/{z}/{x}/{y}.png',
            variant = 'Original',
            min_zoom = 11,
            max_zoom = 18,
            bounds = [[1.56073, 104.11475], [1.16, 103.502]],
            attribution = '![](https://docs.onemap.sg/maps/images/oneMap64-01.png) New OneMap | Map data (C) contributors, Singapore Land Authority',
            name = 'OneMapSG.Original'
        ),
        Grey = TileProvider(
            url = 'https://maps-{s}.onemap.sg/v3/{variant}/{z}/{x}/{y}.png',
            variant = 'Grey',
            min_zoom = 11,
            max_zoom = 18,
            bounds = [[1.56073, 104.11475], [1.16, 103.502]],
            attribution = '![](https://docs.onemap.sg/maps/images/oneMap64-01.png) New OneMap | Map data (C) contributors, Singapore Land Authority',
            name = 'OneMapSG.Grey'
        ),
        LandLot = TileProvider(
            url = 'https://maps-{s}.onemap.sg/v3/{variant}/{z}/{x}/{y}.png',
            variant = 'LandLot',
            min_zoom = 11,
            max_zoom = 18,
            bounds = [[1.56073, 104.11475], [1.16, 103.502]],
            attribution = '![](https://docs.onemap.sg/maps/images/oneMap64-01.png) New OneMap | Map data (C) contributors, Singapore Land Authority',
            name = 'OneMapSG.LandLot'
        )
    )
)

