# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Type, Optional, cast

import httpx

from ...._types import NOT_GIVEN, Body, Query, Headers, NotGiven
from ...._utils import (
    maybe_transform,
    async_maybe_transform,
)
from ...._compat import cached_property
from ...._resource import SyncAPIResource, AsyncAPIResource
from ...._response import (
    to_raw_response_wrapper,
    to_streamed_response_wrapper,
    async_to_raw_response_wrapper,
    async_to_streamed_response_wrapper,
)
from ...._wrappers import ResultWrapper
from ...._base_client import make_request_options
from ....types.ssl.universal import setting_edit_params
from ....types.ssl.universal.universal_ssl_settings import UniversalSSLSettings

__all__ = ["SettingsResource", "AsyncSettingsResource"]


class SettingsResource(SyncAPIResource):
    @cached_property
    def with_raw_response(self) -> SettingsResourceWithRawResponse:
        return SettingsResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> SettingsResourceWithStreamingResponse:
        return SettingsResourceWithStreamingResponse(self)

    def edit(
        self,
        *,
        zone_id: str,
        enabled: bool | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[UniversalSSLSettings]:
        """
        Patch Universal SSL Settings for a Zone.

        Args:
          zone_id: Identifier

          enabled: Disabling Universal SSL removes any currently active Universal SSL certificates
              for your zone from the edge and prevents any future Universal SSL certificates
              from being ordered. If there are no advanced certificates or custom certificates
              uploaded for the domain, visitors will be unable to access the domain over
              HTTPS.

              By disabling Universal SSL, you understand that the following Cloudflare
              settings and preferences will result in visitors being unable to visit your
              domain unless you have uploaded a custom certificate or purchased an advanced
              certificate.

              - HSTS
              - Always Use HTTPS
              - Opportunistic Encryption
              - Onion Routing
              - Any Page Rules redirecting traffic to HTTPS

              Similarly, any HTTP redirect to HTTPS at the origin while the Cloudflare proxy
              is enabled will result in users being unable to visit your site without a valid
              certificate at Cloudflare's edge.

              If you do not have a valid custom or advanced certificate at Cloudflare's edge
              and are unsure if any of the above Cloudflare settings are enabled, or if any
              HTTP redirects exist at your origin, we advise leaving Universal SSL enabled for
              your domain.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not zone_id:
            raise ValueError(f"Expected a non-empty value for `zone_id` but received {zone_id!r}")
        return self._patch(
            f"/zones/{zone_id}/ssl/universal/settings",
            body=maybe_transform({"enabled": enabled}, setting_edit_params.SettingEditParams),
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                post_parser=ResultWrapper[Optional[UniversalSSLSettings]]._unwrapper,
            ),
            cast_to=cast(Type[Optional[UniversalSSLSettings]], ResultWrapper[UniversalSSLSettings]),
        )

    def get(
        self,
        *,
        zone_id: str,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[UniversalSSLSettings]:
        """
        Get Universal SSL Settings for a Zone.

        Args:
          zone_id: Identifier

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not zone_id:
            raise ValueError(f"Expected a non-empty value for `zone_id` but received {zone_id!r}")
        return self._get(
            f"/zones/{zone_id}/ssl/universal/settings",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                post_parser=ResultWrapper[Optional[UniversalSSLSettings]]._unwrapper,
            ),
            cast_to=cast(Type[Optional[UniversalSSLSettings]], ResultWrapper[UniversalSSLSettings]),
        )


class AsyncSettingsResource(AsyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AsyncSettingsResourceWithRawResponse:
        return AsyncSettingsResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncSettingsResourceWithStreamingResponse:
        return AsyncSettingsResourceWithStreamingResponse(self)

    async def edit(
        self,
        *,
        zone_id: str,
        enabled: bool | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[UniversalSSLSettings]:
        """
        Patch Universal SSL Settings for a Zone.

        Args:
          zone_id: Identifier

          enabled: Disabling Universal SSL removes any currently active Universal SSL certificates
              for your zone from the edge and prevents any future Universal SSL certificates
              from being ordered. If there are no advanced certificates or custom certificates
              uploaded for the domain, visitors will be unable to access the domain over
              HTTPS.

              By disabling Universal SSL, you understand that the following Cloudflare
              settings and preferences will result in visitors being unable to visit your
              domain unless you have uploaded a custom certificate or purchased an advanced
              certificate.

              - HSTS
              - Always Use HTTPS
              - Opportunistic Encryption
              - Onion Routing
              - Any Page Rules redirecting traffic to HTTPS

              Similarly, any HTTP redirect to HTTPS at the origin while the Cloudflare proxy
              is enabled will result in users being unable to visit your site without a valid
              certificate at Cloudflare's edge.

              If you do not have a valid custom or advanced certificate at Cloudflare's edge
              and are unsure if any of the above Cloudflare settings are enabled, or if any
              HTTP redirects exist at your origin, we advise leaving Universal SSL enabled for
              your domain.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not zone_id:
            raise ValueError(f"Expected a non-empty value for `zone_id` but received {zone_id!r}")
        return await self._patch(
            f"/zones/{zone_id}/ssl/universal/settings",
            body=await async_maybe_transform({"enabled": enabled}, setting_edit_params.SettingEditParams),
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                post_parser=ResultWrapper[Optional[UniversalSSLSettings]]._unwrapper,
            ),
            cast_to=cast(Type[Optional[UniversalSSLSettings]], ResultWrapper[UniversalSSLSettings]),
        )

    async def get(
        self,
        *,
        zone_id: str,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> Optional[UniversalSSLSettings]:
        """
        Get Universal SSL Settings for a Zone.

        Args:
          zone_id: Identifier

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not zone_id:
            raise ValueError(f"Expected a non-empty value for `zone_id` but received {zone_id!r}")
        return await self._get(
            f"/zones/{zone_id}/ssl/universal/settings",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                post_parser=ResultWrapper[Optional[UniversalSSLSettings]]._unwrapper,
            ),
            cast_to=cast(Type[Optional[UniversalSSLSettings]], ResultWrapper[UniversalSSLSettings]),
        )


class SettingsResourceWithRawResponse:
    def __init__(self, settings: SettingsResource) -> None:
        self._settings = settings

        self.edit = to_raw_response_wrapper(
            settings.edit,
        )
        self.get = to_raw_response_wrapper(
            settings.get,
        )


class AsyncSettingsResourceWithRawResponse:
    def __init__(self, settings: AsyncSettingsResource) -> None:
        self._settings = settings

        self.edit = async_to_raw_response_wrapper(
            settings.edit,
        )
        self.get = async_to_raw_response_wrapper(
            settings.get,
        )


class SettingsResourceWithStreamingResponse:
    def __init__(self, settings: SettingsResource) -> None:
        self._settings = settings

        self.edit = to_streamed_response_wrapper(
            settings.edit,
        )
        self.get = to_streamed_response_wrapper(
            settings.get,
        )


class AsyncSettingsResourceWithStreamingResponse:
    def __init__(self, settings: AsyncSettingsResource) -> None:
        self._settings = settings

        self.edit = async_to_streamed_response_wrapper(
            settings.edit,
        )
        self.get = async_to_streamed_response_wrapper(
            settings.get,
        )
