/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.StringCharacterIterator;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.debug.ParseTreeBuilder;
import org.antlr.runtime.tree.ParseTree;

public class TreeProducer {
    public static String forXML(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            if (c == '<') {
                stringBuilder.append("&lt;");
            } else if (c == '>') {
                stringBuilder.append("&gt;");
            } else if (c == '\"') {
                stringBuilder.append("&quot;");
            } else if (c == '\'') {
                stringBuilder.append("&#039;");
            } else if (c == '&') {
                stringBuilder.append("&amp;");
            } else {
                stringBuilder.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    public static void printTree(ParseTree parseTree, PrintWriter printWriter, String string) {
        int n;
        String string2 = "node";
        if (parseTree.payload instanceof Token) {
            Token token = (Token)parseTree.payload;
            n = token.getLine();
        } else {
            n = 0;
        }
        printWriter.println(string + "<" + string2 + " name=\"" + TreeProducer.forXML("" + parseTree) + "\"" + " line_number=\"" + n + "\" " + ">");
        for (int i = 0; i < parseTree.getChildCount(); ++i) {
            TreeProducer.printTree((ParseTree)parseTree.getChild(i), printWriter, string + "  ");
        }
        printWriter.println(string + "</" + string2 + ">");
    }

    public static void main(String[] stringArray) throws Exception {
        ANTLRFileStream aNTLRFileStream = new ANTLRFileStream(stringArray[0]);
        LuaLexer luaLexer = new LuaLexer((CharStream)aNTLRFileStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)luaLexer);
        ParseTreeBuilder parseTreeBuilder = new ParseTreeBuilder("chunk");
        LuaParser luaParser = new LuaParser((TokenStream)commonTokenStream, (DebugEventListener)parseTreeBuilder);
        luaParser.chunk();
        ParseTree parseTree = parseTreeBuilder.getTree();
        PrintWriter printWriter = new PrintWriter(new FileWriter(stringArray[1], false));
        printWriter.println("<?xml version=\"1.0\" ?>");
        TreeProducer.printTree(parseTree, printWriter, "");
        printWriter.close();
    }
}

