#pragma once

#include <ciphey/ciphers.hpp>

namespace ciphey::test {
  inline ciphey::prob_table const& expected() {
    static ciphey::prob_table ret = {
      { '\n', 0.020121350628948882 },
      { '\r', 0.020056591298643917 },
      { ' ', 0.16097080503159106 },
      { '!', 0.0015134882195466637 },
      { '"', 0.0001232516286449319 },
      { '#', 1.044505327499423e-06 },
      { '$', 2.089010654998846e-06 },
      { '%', 1.044505327499423e-06 },
      { '\'', 0.011756951966333504 },
      { '(', 0.00010131701676744402 },
      { ')', 0.00010131701676744402 },
      { '*', 4.491372908247519e-05 },
      { '+', 6.2670319649965374e-06 },
      { ',', 0.017218670323827987 },
      { '-', 0.0028316539428509353 },
      { '.', 0.008763399697720158 },
      { '/', 2.6112633187485574e-05 },
      { '0', 2.506812785998615e-05 },
      { '1', 6.37148249774648e-05 },
      { '2', 1.2534063929993075e-05 },
      { '3', 1.775659056749019e-05 },
      { '4', 9.400547947494807e-06 },
      { '5', 1.2534063929993075e-05 },
      { '6', 8.356042619995384e-06 },
      { '7', 1.1489558602493652e-05 },
      { '8', 1.044505327499423e-05 },
      { '9', 1.1489558602493652e-05 },
      { ':', 0.0006987740640971139 },
      { ';', 0.0027721171391834683 },
      { '=', 3.1335159824982687e-06 },
      { '>', 6.2670319649965374e-06 },
      { '?', 0.0010674844447044103 },
      { '@', 2.089010654998846e-06 },
      { 'A', 0.0015322893154416533 },
      { 'B', 0.0014737970171016857 },
      { 'C', 0.0009640784172819674 },
      { 'D', 0.0007154861493371047 },
      { 'E', 0.0011771575040918497 },
      { 'F', 0.000696685053442115 },
      { 'G', 0.0006173026485521589 },
      { 'H', 0.0014142602134342185 },
      { 'I', 0.0034646241713155858 },
      { 'J', 0.00040317905641477724 },
      { 'K', 7.938240488995614e-05 },
      { 'L', 0.0006329702284646503 },
      { 'M', 0.002157948006613808 },
      { 'N', 0.0013693464843517434 },
      { 'O', 0.0017892376260065115 },
      { 'P', 0.0004658493760647426 },
      { 'Q', 3.6557686462479805e-05 },
      { 'R', 0.0008899185390295083 },
      { 'S', 0.001578247549851628 },
      { 'T', 0.0025527710204085894 },
      { 'U', 0.0002600818265473563 },
      { 'V', 0.00021099007615488344 },
      { 'W', 0.0010549503807744172 },
      { 'X', 0.0001692098630549065 },
      { 'Y', 0.0005410537596447011 },
      { 'Z', 2.089010654998846e-06 },
      { '[', 2.089010654998846e-06 },
      { ']', 2.089010654998846e-06 },
      { '^', 4.178021309997692e-06 },
      { '_', 0.0002381472146698684 },
      { 'a', 0.056775131581558634 },
      { 'b', 0.010749004325296562 },
      { 'c', 0.017029614859550592 },
      { 'd', 0.034307821987046044 },
      { 'e', 0.09271969341679627 },
      { 'f', 0.015382429958084 },
      { 'g', 0.01567489144978384 },
      { 'h', 0.04749679075738126 },
      { 'i', 0.04871468396924559 },
      { 'j', 0.000684150989512122 },
      { 'k', 0.006584561584556362 },
      { 'l', 0.029912543568928474 },
      { 'm', 0.017723166397010208 },
      { 'n', 0.04964324920539257 },
      { 'o', 0.05626227946575642 },
      { 'p', 0.013063628131035282 },
      { 'q', 0.0007415987825245903 },
      { 'r', 0.04402172153279068 },
      { 's', 0.04330414637279857 },
      { 't', 0.06387985681920971 },
      { 'u', 0.020303094555933782 },
      { 'v', 0.0069564054811461565 },
      { 'w', 0.017116308801733045 },
      { 'x', 0.0009651229226094668 },
      { 'y', 0.014921803108656756 },
      { 'z', 0.0001869664536223967 },
      { '{', 4.178021309997692e-06 },
      { '}', 4.178021309997692e-06 },
    };
    return ret;
  }

  inline ciphey::group_t const& group() {
    static ciphey::group_t ret = {
      'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h',
      'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
      'q', 'r', 's', 't', 'u', 'v', 'w', 'x',
      'y', 'z'
    };
    return ret;
  }

  inline std::set<ciphey::char_t> const& domain() {
    static std::set<ciphey::char_t> ret(group().begin(), group().end());

    return ret;
  }
}
