# Rules

## Rule levels
A rule returns feedback on a specific level: Error, Warning or Informational.

### Errors
Errors will start with the letter `E`. Errors will (or can) result in a hard failure for the template being validated.

### Warnings
Warnings start with the letter `W`. Warnings alert you when the template doesn't follow best practices but should still function.  *Example: If you use a parameter for a RDS master password you should have the parameter property NoEcho set to true.*

### Informational
Informational results start with the letter `I`. Informational alert you when the template doesn't follow best practices, just like the Warnings, but in a non-blocking way. The Informational level is disabled by default and has to be enabled explicitly using `-c I` or `--include-checks I`.

## Categories

| Rule Numbers          | Category |
| --------------------- | ------------- |
| (E&#124;W&#124;I)0XXX | Basic Template Errors. Examples: Not parseable, main sections (Outputs, Resources, etc.) |
| (E&#124;W&#124;I)1XXX | Functions (Ref, GetAtt, etc.) |
| (E&#124;W&#124;I)2XXX | Parameters |
| (E&#124;W&#124;I)3XXX | Resources |
| (E&#124;W&#124;I)4XXX | Metadata |
| (E&#124;W&#124;I)6xxx | Outputs |
| (E&#124;W&#124;I)7xxx | Mappings |
| (E&#124;W&#124;I)8xxx | Conditions |
| (E&#124;W&#124;I)9xxx | Reserved for users rules |

*Warning*
Rule `E3012` is used to check the types for value of a resource property. A number is a number, string is a string, etc.  There are occasions where this could be just a warning and other times it could be an error. cfn-lint doesn't have an exception process so all instances of this issue are considered errors. You can disable this rule using `--ignore-checks` if it is not required for your internal best practices.

## Experimental rules
Sometimes there are (new) rules that might be complex, that doesn't have enough solid test templates and examples and/or might have unexpected results. We support adding in these rules so they can be tested, tweaked and improved before they become generally available.

A rule can be marked as experimental by setting the `experimental` flag in the Rule's MetaData:

```Python
class MyExperimentalRule(CloudFormationLintRule):
    id = 'E1234'
    ...
    experimental = True
```
To include these rules, use the `-e/include-experimental` argument when running cfn-lint.


## Rules
(_This documentation is generated by running `cfn-lint --update-documentation`, do not alter this manually_)

The following **141** rules are applied by this linter:

| Rule ID  | Title | Description | Config<br />(Name:Type:Default) | Source | Tags |
| -------- | ----- | ----------- | ---------- | ------ | ---- |
| E0000<a name="E0000"></a> | Parsing error found when parsing the template | Checks for Null values and Duplicate values in resources |  | [Source]() | `base` |
| E0001<a name="E0001"></a> | Error found when transforming the template | Errors found when performing transformation on the template |  | [Source]() | `base`,`transform` |
| E0002<a name="E0002"></a> | Error processing rule on the template | Errors found when processing a rule on the template |  | [Source]() | `base`,`rule` |
| E1001<a name="E1001"></a> | Basic CloudFormation Template Configuration | Making sure the basic CloudFormation template components are properly configured |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint) | `base` |
| E1002<a name="E1002"></a> | Template size limit | Check the size of the template is less than the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `limits` |
| E1003<a name="E1003"></a> | Template description limit | Check if the size of the template description is less than the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `limits` |
| E1004<a name="E1004"></a> | Template description can only be a string | Template description can only be a string |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-description-structure.html) | `description` |
| E1010<a name="E1010"></a> | GetAtt validation of parameters | Validates that GetAtt parameters are to valid resources and properties of those resources |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-getatt.html) | `functions`,`getatt` |
| E1011<a name="E1011"></a> | FindInMap validation of configuration | Making sure the function is a list of appropriate config |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-findinmap.html) | `functions`,`findinmap` |
| E1012<a name="E1012"></a> | Check if Refs exist | Making sure the refs exist |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html) | `functions`,`ref` |
| E1015<a name="E1015"></a> | GetAz validation of parameters | Making sure the function not is of list |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-getavailabilityzones.html) | `functions`,`getaz` |
| E1016<a name="E1016"></a> | ImportValue validation of parameters | Making sure the function not is of list |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html) | `functions`,`importvalue` |
| E1017<a name="E1017"></a> | Select validation of parameters | Making sure the function not is of list |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-select.html) | `functions`,`select` |
| E1018<a name="E1018"></a> | Split validation of parameters | Making sure the split function is properly configured |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-split.html) | `functions`,`split` |
| E1019<a name="E1019"></a> | Sub validation of parameters | Making sure the sub function is properly configured |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-sub.html) | `functions`,`sub` |
| E1020<a name="E1020"></a> | Ref validation of value | Making the Ref has a value of String (no other functions are supported) |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html) | `functions`,`ref` |
| E1021<a name="E1021"></a> | Base64 validation of parameters | Making sure the function not is of list |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-base64.html) | `functions`,`base64` |
| E1022<a name="E1022"></a> | Join validation of parameters | Making sure the join function is properly configured |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-join.html) | `functions`,`join` |
| E1023<a name="E1023"></a> | Validation NOT function configuration | Making sure that NOT functions are list |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-conditions.html#intrinsic-function-reference-conditions-not) | `functions`,`not` |
| E1024<a name="E1024"></a> | Cidr validation of parameters | Making sure the function CIDR is a list with valid values |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-cidr.html) | `functions`,`cidr` |
| E1026<a name="E1026"></a> | Cannot reference resources in the Conditions block of the template | Check that any Refs in the Conditions block uses no resources |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-conditions.html#w2ab2c21c28c21c45) | `functions`,`ref` |
| E1027<a name="E1027"></a> | Check dynamic references secure strings are in supported locations | Dynamic References Secure Strings are only supported for a small set of resource properties.  Validate that they are being used in the correct location when checking values and Fn::Sub in resource properties. Currently doesn't check outputs, maps, conditions, parameters, and descriptions. |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html) | `functions`,`dynamic reference` |
| E1028<a name="E1028"></a> | Check Fn::If structure for validity | Check Fn::If to make sure its valid.  Condition has to be a string. |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-conditions.html#intrinsic-function-reference-conditions-if) | `functions`,`if` |
| E1029<a name="E1029"></a> | Sub is required if a variable is used in a string | If a substitution variable exists in a string but isn't wrapped with the Fn::Sub function the deployment will fail. | custom_excludes:string: | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-sub.html) | `functions`,`sub` |
| E2001<a name="E2001"></a> | Parameters have appropriate properties | Making sure the parameters are properly configured |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html) | `parameters` |
| E2002<a name="E2002"></a> | Parameters have appropriate type | Making sure the parameters have a correct type |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/best-practices.html#parmtypes) | `parameters` |
| E2003<a name="E2003"></a> | Parameters have appropriate names | Check if Parameters are properly named (A-Za-z0-9) |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#parameters-section-structure-requirements) | `parameters` |
| E2004<a name="E2004"></a> | CIDR Allowed Values should be a Cidr Range | Check if a parameter is being used as a CIDR. If it is make sure allowed values are proper CIDRs |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html) | `parameters`,`cidr` |
| E2010<a name="E2010"></a> | Parameter limit not exceeded | Check the number of Parameters in the template is less than the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `parameters`,`limits` |
| E2011<a name="E2011"></a> | Parameter name limit not exceeded | Check the size of Parameter names in the template is less than the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `parameters`,`limits` |
| E2012<a name="E2012"></a> | Parameter value limit not exceeded | Check if the size of Parameter values in the template is less than the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `parameters`,`limits` |
| E2014<a name="E2014"></a> | Default value cannot use Refs | Check if Refs are not used in Parameter Defaults |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html) | `parameters` |
| E2015<a name="E2015"></a> | Default value is within parameter constraints | Making sure the parameters have a default value inside AllowedValues, MinValue, MaxValue, AllowedPattern |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html) | `parameters` |
| E2503<a name="E2503"></a> | Resource ELB Properties | See if Elb Resource Properties are set correctly HTTPS has certificate HTTP has no certificate |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html) | `properties`,`elb` |
| E2504<a name="E2504"></a> | Check Ec2 Ebs Properties | See if Ec2 Eb2 Properties are valid |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html) | `properties`,`ec2`,`ebs` |
| E2505<a name="E2505"></a> | Resource EC2 VPC Properties | Check if the default tenancy is default or dedicated and that CidrBlock is a valid CIDR range. |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html) | `properties`,`vpc` |
| E2506<a name="E2506"></a> | Resource EC2 Security Group Ingress Properties | See if EC2 Security Group Ingress Properties are set correctly. Check that "SourceSecurityGroupId" or "SourceSecurityGroupName" are  are exclusive and using the type of Ref or GetAtt  |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html) | `resources`,`securitygroup` |
| E2507<a name="E2507"></a> | Check if IAM Policies are properly configured | See if there elements inside an IAM policy are correct |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html) | `properties`,`iam` |
| E2510<a name="E2510"></a> | Resource EC2 PropertiesEc2Subnet Properties | See if EC2 Subnet Properties are set correctly |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html) | `properties`,`subnet` |
| E2520<a name="E2520"></a> | Check Properties that are mutually exclusive | Making sure CloudFormation properties that are exclusive are not defined |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint) | `resources` |
| E2521<a name="E2521"></a> | Check Properties that are required together | Make sure CloudFormation resource properties are included together when required |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint) | `resources` |
| E2522<a name="E2522"></a> | Check Properties that need at least one of a list of properties | Making sure CloudFormation properties that require at least one property from a list. More than one can be included. |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint) | `resources` |
| E2523<a name="E2523"></a> | Check Properties that need only one of a list of properties | Making sure CloudFormation properties that require only one property from a list. One has to be specified. |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint) | `resources` |
| E2529<a name="E2529"></a> | Check for duplicate Lambda events | Check if there are any duplicate log groups in the Lambda event trigger element. |  | [Source](https://github.com/awslabs/serverless-application-model/blob/master/versions/2016-10-31.md#user-content-cloudwatchlogs) | `resources`,`lambda` |
| E2530<a name="E2530"></a> | Check Lambda Memory Size Properties | See if Lambda Memory Size is valid |  | [Source](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-MemorySize) | `resources`,`lambda` |
| E2531<a name="E2531"></a> | Check if EOL Lambda Function Runtimes are used | Check if an EOL Lambda Runtime is specified and give an error if used.  |  | [Source](https://docs.aws.amazon.com/lambda/latest/dg/runtime-support-policy.html) | `resources`,`lambda`,`runtime` |
| E2532<a name="E2532"></a> | Check State Machine Definition for proper syntax | Check the State Machine String Definition to make sure its JSON. Validate basic syntax of the file to determine validity. |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachine.html) | `resources`,`stepfunctions` |
| E2540<a name="E2540"></a> | CodePipeline Stages | See if CodePipeline stages are set correctly |  | [Source](https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#pipeline-requirements) | `properties`,`codepipeline` |
| E2541<a name="E2541"></a> | CodePipeline Stage Actions | See if CodePipeline stage actions are set correctly |  | [Source](https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#pipeline-requirements) | `resources`,`codepipeline` |
| E3001<a name="E3001"></a> | Basic CloudFormation Resource Check | Making sure the basic CloudFormation resources are properly configured |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint) | `resources` |
| E3002<a name="E3002"></a> | Resource properties are valid | Making sure that resources properties are properly configured |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint/blob/master/docs/cfn-resource-specification.md#properties) | `resources` |
| E3003<a name="E3003"></a> | Required Resource Parameters are missing | Making sure that Resources properties that are required exist |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint/blob/master/docs/cfn-resource-specification.md#required) | `resources` |
| E3004<a name="E3004"></a> | Resource dependencies are not circular | Check that Resources are not circularly dependent by Ref, Sub, or GetAtt |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint) | `resources`,`circularly` |
| E3005<a name="E3005"></a> | Check DependsOn values for Resources | Check that the DependsOn values are valid |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html) | `resources`,`dependson` |
| E3006<a name="E3006"></a> | Resources have appropriate names | Check if Resources are properly named (A-Za-z0-9) |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-logicalid) | `resources` |
| E3008<a name="E3008"></a> | Check values of properties for valid Refs and GetAtts | Checks resource properties for Ref and GetAtt values |  | [Source]() | `resources` |
| E3010<a name="E3010"></a> | Resource limit not exceeded | Check the number of Resources in the template is less than the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `resources`,`limits` |
| E3011<a name="E3011"></a> | Resource name limit not exceeded | Check the size of Resource names in the template is less than the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `resources`,`limits` |
| E3012<a name="E3012"></a> | Check resource properties values | Checks resource property values with Primitive Types for values that match those types. | strict:boolean:True | [Source](https://github.com/aws-cloudformation/cfn-python-lint/blob/master/docs/cfn-resource-specification.md#valueprimitivetype) | `resources` |
| E3013<a name="E3013"></a> | CloudFront Aliases | CloudFront aliases should contain valid domain names |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-aliases) | `properties`,`cloudfront` |
| E3016<a name="E3016"></a> | Check the configuration of a resources UpdatePolicy | Make sure a resources UpdatePolicy is properly configured |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html) | `resources`,`updatepolicy` |
| E3020<a name="E3020"></a> | Validate Route53 RecordSets | Check if all RecordSets are correctly configured |  | [Source](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html) | `resources`,`route53`,`record_set` |
| E3021<a name="E3021"></a> | Check Events Rule Targets are less than or equal to 5 | CloudWatch Events Rule can only support up to 5 targets |  | [Source](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/cloudwatch_limits_cwe.html) | `resources`,`events` |
| E3022<a name="E3022"></a> | Resource SubnetRouteTableAssociation Properties | Validate there is only one SubnetRouteTableAssociation per subnet |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html) | `resources`,`subnet`,`route table` |
| E3023<a name="E3023"></a> | Validate that AlarmIdentifier is specified when using CloudWatch Metrics | When using a CloudWatch Metric for Route53 Health Checks you must also specify the AlarmIdentifier |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-alarmidentifier) | `resources`,`route53`,`alarm_identifier` |
| E3024<a name="E3024"></a> | Validate that ProvisionedThroughput is not specified with BillingMode PAY_PER_REQUEST | When using ProvisionedThroughput with BillingMode PAY_PER_REQUEST will result in BillingMode being changed to PROVISIONED |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html) | `resources`,`dynamodb`,`provisioned_throughput`,`billing_mode` |
| E3025<a name="E3025"></a> | RDS instance type is compatible with the RDS type | Check the RDS instance types are supported by the type of RDS engine. Only if the values are strings will this be checked. |  | [Source](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) | `resources`,`rds` |
| E3026<a name="E3026"></a> | Check Elastic Cache Redis Cluster settings | Evaluate Redis Cluster groups to make sure automatic failover is enabled when cluster mode is enabled |  | [Source](https://github.com/awslabs/cfn-python-lint) | `resources`,`elasticcache` |
| E3027<a name="E3027"></a> | Validate AWS Event ScheduleExpression format | Validate the formation of the AWS::Event ScheduleExpression |  | [Source](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html) | `resources`,`events` |
| E3028<a name="E3028"></a> | ScalingConfiguration only set for Aurora Serverless | You cannot specify ScalingConfiguration for non Aurora Serverless AWS::RDS::DBCluster |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-scalingconfiguration) | `resources`,`rds` |
| E3030<a name="E3030"></a> | Check if properties have a valid value | Check if properties have a valid value in case of an enumator |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint/blob/master/docs/cfn-resource-specification.md#allowedvalue) | `resources`,`property`,`allowed value` |
| E3031<a name="E3031"></a> | Check if property values adhere to a specific pattern | Check if properties have a valid value in case of a pattern (Regular Expression) |  | [Source](https://github.com/awslabs/cfn-python-lint/blob/master/docs/cfn-resource-specification.md#allowedpattern) | `resources`,`property`,`allowed pattern`,`regex` |
| E3032<a name="E3032"></a> | Check if a list has between min and max number of values specified | Check lists for the number of items in the list to validate they are between the minimum and maximum |  | [Source](https://github.com/awslabs/cfn-python-lint/blob/master/docs/cfn-resource-specification.md#allowedpattern) | `resources`,`property`,`list`,`size` |
| E3033<a name="E3033"></a> | Check if a string has between min and max number of values specified | Check strings for its length between the minimum and maximum |  | [Source](https://github.com/awslabs/cfn-python-lint/blob/master/docs/cfn-resource-specification.md#allowedpattern) | `resources`,`property`,`string`,`size` |
| E3034<a name="E3034"></a> | Check if a number is between min and max | Check numbers (integers and floats) for its value being between the minimum and maximum |  | [Source](https://github.com/awslabs/cfn-python-lint/blob/master/docs/cfn-resource-specification.md#allowedpattern) | `resources`,`property`,`number`,`size` |
| E3035<a name="E3035"></a> | Check DeletionPolicy values for Resources | Check that the DeletionPolicy values are valid |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html) | `resources`,`deletionpolicy` |
| E3036<a name="E3036"></a> | Check UpdateReplacePolicy values for Resources | Check that the UpdateReplacePolicy values are valid |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html) | `resources`,`updatereplacepolicy` |
| E3037<a name="E3037"></a> | Check if a list has duplicate values | Certain lists don't support duplicate items. Check when duplicates are provided but not supported. |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint/blob/master/docs/cfn-resource-specification.md#allowedvalue) | `resources`,`property`,`list` |
| E3038<a name="E3038"></a> | Check if Serverless Resources have Serverless Transform | Check that a template with Serverless Resources also includes the Serverless Transform |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint) | `resources`,`transform` |
| E3039<a name="E3039"></a> | AttributeDefinitions / KeySchemas mismatch | Verify the set of Attributes in AttributeDefinitions and KeySchemas match |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html) | `resources`,`dynamodb` |
| E3050<a name="E3050"></a> | Check if REFing to a IAM resource with path set | Some resources don't support looking up the IAM resource by name. This check validates when a REF is being used and the Path is not '/' |  | [Source](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements.html) | `properties`,`iam` |
| E3502<a name="E3502"></a> | Check if a JSON Object is within size limits | Validate properties that are JSON values so that their length is within the limits |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `resources`,`limits`,`json` |
| E3503<a name="E3503"></a> | ValidationDomain is superdomain of DomainName | In ValidationDomainOptions, the ValidationDomain must be a superdomain of the DomainName being validated |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoption-validationdomain) | `certificate`,`certificatemanager`,`domainvalidationoptions`,`validationdomain` |
| E4001<a name="E4001"></a> | Metadata Interface have appropriate properties | Metadata Interface properties are properly configured |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-interface.html) | `metadata` |
| E6001<a name="E6001"></a> | Outputs have appropriate properties | Making sure the outputs are properly configured |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/outputs-section-structure.html) | `outputs` |
| E6002<a name="E6002"></a> | Outputs have required properties | Making sure the outputs have required properties |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/outputs-section-structure.html) | `outputs` |
| E6003<a name="E6003"></a> | Outputs have values of strings | Making sure the outputs have strings as values |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/outputs-section-structure.html) | `outputs` |
| E6004<a name="E6004"></a> | Outputs have appropriate names | Check if Outputs are properly named (A-Za-z0-9) |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/outputs-section-structure.html) | `outputs` |
| E6005<a name="E6005"></a> | Outputs descriptions can only be strings | Outputs descriptions can only be strings |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/outputs-section-structure.html) | `outputs` |
| E6010<a name="E6010"></a> | Output limit not exceeded | Check the number of Outputs in the template is less than the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `outputs`,`limits` |
| E6011<a name="E6011"></a> | Output name limit not exceeded | Check the size of Output names in the template is less than the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `outputs`,`limits` |
| E6012<a name="E6012"></a> | Output description limit not exceeded | Check the size of Output description in the template is less than the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/outputs-section-structure.html) | `outputs`,`limits` |
| E7001<a name="E7001"></a> | Mappings are appropriately configured | Check if Mappings are properly configured |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/mappings-section-structure.html) | `mappings` |
| E7002<a name="E7002"></a> | Mappings have appropriate names | Check if Mappings are properly named (A-Za-z0-9) |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/mappings-section-structure.html) | `mapping` |
| E7003<a name="E7003"></a> | Mapping keys are strings and alphanumeric | Check if Mappings keys are properly typed as strings and alphanumeric |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/mappings-section-structure.html) | `mapping` |
| E7010<a name="E7010"></a> | Mapping limit not exceeded | Check the number of Mappings in the template is less than the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `mappings`,`limits` |
| E7011<a name="E7011"></a> | Mapping name limit not exceeded | Check the size of Mapping names in the template is less than the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `mappings`,`limits` |
| E7012<a name="E7012"></a> | Mapping attribute limit not exceeded | Check if the amount of Mapping attributes in the template is less than the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `mappings`,`limits` |
| E8001<a name="E8001"></a> | Conditions have appropriate properties | Check if Conditions are properly configured |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/conditions-section-structure.html) | `conditions` |
| E8002<a name="E8002"></a> | Check if the referenced Conditions are defined | Making sure the used conditions are actually defined in the Conditions section |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/conditions-section-structure.html) | `conditions` |
| E8003<a name="E8003"></a> | Check Fn::Equals structure for validity | Check Fn::Equals is a list of two elements |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-conditions.html#intrinsic-function-reference-conditions-equals) | `functions`,`equals` |
| E8004<a name="E8004"></a> | Check Fn::And structure for validity | Check Fn::And is a list of two elements |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-conditions.html#intrinsic-function-reference-conditions-and) | `functions`,`and` |
| E8005<a name="E8005"></a> | Check Fn::Not structure for validity | Check Fn::Not is a list of two elements |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-conditions.html#intrinsic-function-reference-conditions-not) | `functions`,`not` |
| E8006<a name="E8006"></a> | Check Fn::Or structure for validity | Check Fn::Or is a list of two elements |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-conditions.html#intrinsic-function-reference-conditions-or) | `functions`,`or` |
| I1002<a name="I1002"></a> | Template size limit | Check the size of the template is approaching the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `limits` |
| I1003<a name="I1003"></a> | Template description limit | Check if the size of the template description is approaching the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `limits` |
| I1022<a name="I1022"></a> | Use Sub instead of Join | Prefer a sub instead of Join when using a join delimiter that is empty |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-sub.html) | `functions`,`sub`,`join` |
| I2010<a name="I2010"></a> | Parameter limit | Check the number of Parameters in the template is approaching the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `parameters`,`limits` |
| I2011<a name="I2011"></a> | Parameter name limit | Check the size of Parameter names in the template is approaching the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `parameters`,`limits` |
| I2012<a name="I2012"></a> | Parameter value limit | Check if the size of Parameter values in the template is approaching the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `parameters`,`limits` |
| I3010<a name="I3010"></a> | Resource limit | Check the number of Resources in the template is approaching the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `resources`,`limits` |
| I3011<a name="I3011"></a> | Check stateful resources have a set UpdateReplacePolicy/DeletionPolicy | The default action when replacing/removing a resource is to delete it. This check requires you to explicitly set policies |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html) | `resources`,`updatereplacepolicy`,`deletionpolicy` |
| I3011<a name="I3011"></a> | Resource name limit | Check the size of Resource names in the template is approaching the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `resources`,`limits` |
| I3037<a name="I3037"></a> | Check if a list that allows duplicates has any duplicates | Certain lists support duplicate items.Provide an alert when list of strings or numbers have repeats. |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint/blob/master/docs/rules.md#rules-1) | `resources`,`property`,`list` |
| I6010<a name="I6010"></a> | Output limit | Check the number of Outputs in the template is approaching the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `outputs`,`limits` |
| I6011<a name="I6011"></a> | Output name limit | Check the size of Output names in the template is approaching the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `outputs`,`limits` |
| I6012<a name="I6012"></a> | Output description limit | Check the size of Output description in the template is approaching the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/outputs-section-structure.html) | `outputs`,`limits` |
| I7010<a name="I7010"></a> | Mapping limit | Check the number of Mappings in the template is approaching the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `mappings`,`limits` |
| I7011<a name="I7011"></a> | Mapping name limit | Check the size of Mapping names in the template is approaching the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `mappings`,`limits` |
| I7012<a name="I7012"></a> | Mapping attribute limit | Check if the amount of Mapping attributes in the template is approaching the upper limit |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html) | `mappings`,`limits` |
| W1001<a name="W1001"></a> | Ref/GetAtt to resource that is available when conditions are applied | Check the Conditions that affect a Ref/GetAtt to make sure the resource being related to is available when there is a resource condition. |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html) | `resources`,`relationships` |
| W1011<a name="W1011"></a> | FindInMap keys exist in the map | Checks the keys in a FindInMap to make sure they exist. Check only if the Map Name is a string and if the key is a string. |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-findinmap.html) | `functions`,`findinmap` |
| W1019<a name="W1019"></a> | Sub validation of parameters | Validate that Fn::Sub Parameters are used |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-sub.html) | `functions`,`sub` |
| W1020<a name="W1020"></a> | Sub isn't needed if it doesn't have a variable defined | Checks sub strings to see if a variable is defined. |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-sub.html) | `functions`,`sub` |
| W2001<a name="W2001"></a> | Check if Parameters are Used | Making sure the parameters defined are used |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint) | `parameters` |
| W2030<a name="W2030"></a> | Check if parameters have a valid value | Check if parameters have a valid value in case of an enumator. The Parameters allowed values is based on the usages in property (Ref) |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint/blob/master/docs/cfn-resource-specification.md#allowedvalue) | `resources`,`property`,`allowed value` |
| W2501<a name="W2501"></a> | Check if Password Properties are correctly configured | Password properties should be strings and if parameter using NoEcho |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/best-practices.html#creds) | `parameters`,`passwords`,`security` |
| W2506<a name="W2506"></a> | Check if ImageId Parameters have the correct type | See if there are any refs for ImageId to a parameter of inappropriate type. Appropriate Types are [AWS::EC2::Image::Id, AWS::SSM::Parameter::Value<AWS::EC2::Image::Id>] |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/best-practices.html#parmtypes) | `parameters`,`imageid` |
| W2509<a name="W2509"></a> | CIDR Parameters have allowed values | Check if a parameter is being used as a CIDR. If it is make sure it has allowed values regex comparisons |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html) | `parameters`,`cidr` |
| W2510<a name="W2510"></a> | Parameter Memory Size attributes should have max and min | Check if a parameter that is used for Lambda memory size  should have a min and max size that matches Lambda constraints |  | [Source](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-MemorySize) | `parameters`,`lambda` |
| W2511<a name="W2511"></a> | Check IAM Resource Policies syntax | See if the elements inside an IAM Resource policy are configured correctly. |  | [Source](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements.html) | `properties`,`iam` |
| W2531<a name="W2531"></a> | Check if EOL Lambda Function Runtimes are used | Check if an EOL Lambda Runtime is specified and give a warning if used.  |  | [Source](https://docs.aws.amazon.com/lambda/latest/dg/runtime-support-policy.html) | `resources`,`lambda`,`runtime` |
| W3002<a name="W3002"></a> | Warn when properties are configured to only work with the package command | Some properties can be configured to only work with the CloudFormationpackage command. Warn when this is the case so user is aware. |  | [Source](https://docs.aws.amazon.com/cli/latest/reference/cloudformation/package.html) | `resources` |
| W3005<a name="W3005"></a> | Check obsolete DependsOn configuration for Resources | Check if DependsOn is specified if not needed. A Ref or a Fn::GetAtt already is an implicit dependency. |  | [Source](https://aws.amazon.com/blogs/devops/optimize-aws-cloudformation-templates/) | `resources`,`dependson` |
| W3010<a name="W3010"></a> | Availability Zone Parameters should not be hardcoded | Check if an Availability Zone property is hardcoded. |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint) | `parameters`,`availabilityzone` |
| W3011<a name="W3011"></a> | Check resources with UpdateReplacePolicy/DeletionPolicy have both | Both UpdateReplacePolicy and DeletionPolicy are needed to protect resources from deletion |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html) | `resources`,`updatereplacepolicy`,`deletionpolicy` |
| W4001<a name="W4001"></a> | Metadata Interface parameters exist | Metadata Interface parameters actually exist |  | [Source](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-interface.html) | `metadata` |
| W6001<a name="W6001"></a> | Check Outputs using ImportValue | Check if the Output value is set using ImportValue, so creating an Output of an Output |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint) | `outputs`,`importvalue` |
| W7001<a name="W7001"></a> | Check if Mappings are Used | Making sure the mappings defined are used |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint) | `conditions` |
| W8001<a name="W8001"></a> | Check if Conditions are Used | Making sure the conditions defined are used |  | [Source](https://github.com/aws-cloudformation/cfn-python-lint) | `conditions` |
### Experimental rules
| Rule ID  | Title | Description | Source | Tags |
| -------- | ----- | ----------- | ------ | ---- |
| W3037<a name="W3037"></a> | Check IAM Permission configuration | Check for valid IAM Permissions |  | [Source](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_action.html) | `properties`,`iam`,`permissions` |
