/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"

/********* Language model for: Thai *********/

/**
 * Generated by BuildLangModel.py
 * On: 2017-03-27 20:13:41.617263
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_11_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 65, 61, 57, 71, 83, 67, 81, 80, 87, 84, 89, 82, 64, 85, 88, /* 4X */
   63,104, 77, 59, 62, 93, 98, 75,102, 99, 97,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 31, 69, 52, 49, 29, 79, 60, 48, 36,100, 74, 44, 53, 34, 37, /* 6X */
   68,103, 32, 45, 39, 51, 76, 73, 91, 54, 95,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,  3, 25,106, 17,107, 94,  6, 21, 72, 23, 38,101, 43, 66, 70, /* AX */
   47, 90, 86, 41, 11, 15, 35, 13, 33,  2, 18, 19, 46, 58, 16, 50, /* BX */
   42,  7,  8,  1, 56, 10,105,  9, 24, 40, 12, 20, 96,  4, 55, 92, /* CX */
   14,SYM,  0, 30,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,ILL,ILL,ILL,SYM, /* DX */
    5, 22, 28, 26, 27,108, 78,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,109, /* EX */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,110,111,ILL,ILL,ILL,ILL, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Tis_620_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 65, 61, 57, 71, 83, 67, 81, 80, 87, 84, 89, 82, 64, 85, 88, /* 4X */
   63,104, 77, 59, 62, 93, 98, 75,102, 99, 97,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 31, 69, 52, 49, 29, 79, 60, 48, 36,100, 74, 44, 53, 34, 37, /* 6X */
   68,103, 32, 45, 39, 51, 76, 73, 91, 54, 95,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  ILL,  3, 25,112, 17,113, 94,  6, 21, 72, 23, 38,101, 43, 66, 70, /* AX */
   47, 90, 86, 41, 11, 15, 35, 13, 33,  2, 18, 19, 46, 58, 16, 50, /* BX */
   42,  7,  8,  1, 56, 10,105,  9, 24, 40, 12, 20, 96,  4, 55, 92, /* CX */
   14,SYM,  0, 30,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,ILL,ILL,ILL,SYM, /* DX */
    5, 22, 28, 26, 27,114, 78,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,115, /* EX */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,116,117,ILL,ILL,ILL,ILL, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 2524
 * First 512 sequences: 0.8546375003626447
 * Next 512 sequences (512-1024): 0.10880307909522566
 * Rest: 0.0365594205421296
 * Negative sequences: TODO
 */
static const PRUint8 ThaiLangModel[] =
{
  0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,
   0,3,0,3,0,0,3,0,3,3,3,2,0,0,2,1,0,0,3,0,0,0,0,1,1,0,1,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,2,2,0,1,0,
   0,1,0,3,0,0,2,0,3,3,2,1,0,0,2,1,0,0,1,0,0,0,0,1,1,0,2,0,0,0,0,0,
  3,3,3,3,3,3,2,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,0,3,0,
   0,3,0,3,0,0,2,0,1,0,2,1,0,0,3,2,0,0,2,0,0,0,0,1,1,0,1,0,0,0,0,0,
  3,3,3,3,3,3,2,3,2,3,3,3,3,3,2,3,3,3,2,3,2,3,3,2,2,3,3,2,2,0,3,0,
   0,1,0,2,0,0,2,0,3,1,2,1,0,0,2,1,0,0,2,0,0,0,0,1,3,0,1,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,2,2,3,2,3,2,2,2,1,2,2,2,2,0,3,0,
   0,2,0,2,0,0,1,0,0,0,2,1,0,0,2,1,0,0,2,0,0,0,0,1,0,0,1,0,0,0,0,0,
  0,3,3,3,3,0,2,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,0,3,3,3,0,0,0,0,0,0,
   0,3,0,1,0,0,3,0,1,1,2,0,0,0,2,0,0,0,2,0,0,0,0,2,0,0,1,0,0,0,0,0,
  3,3,3,3,3,3,2,3,3,3,2,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,
   0,1,0,3,0,0,2,0,1,0,2,1,0,0,3,1,0,0,1,0,0,0,0,2,1,0,2,0,0,0,0,0,
  3,3,3,3,3,3,2,3,2,3,3,3,3,3,2,3,3,3,3,3,3,2,3,3,2,3,3,2,3,0,0,0,
   0,1,0,2,0,0,1,0,2,2,3,1,0,0,2,1,0,0,1,0,0,0,0,1,1,0,1,0,0,0,0,0,
  3,3,3,3,3,3,3,3,2,3,2,2,3,3,2,3,3,3,3,2,2,2,3,3,2,2,3,3,2,0,1,0,
   0,2,0,2,0,0,2,0,0,1,2,2,0,0,1,1,0,0,1,0,0,0,0,1,1,0,1,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,2,3,2,2,2,2,2,3,2,2,2,2,3,2,2,1,2,2,3,3,0,0,0,
   0,1,0,1,0,0,1,0,0,2,2,1,0,0,1,0,0,0,1,0,0,0,0,1,2,0,1,0,0,0,0,0,
  3,2,3,3,3,3,3,2,3,3,3,2,2,3,3,2,2,2,2,2,1,2,2,2,1,2,2,2,2,0,2,0,
   0,1,0,1,0,0,2,0,0,0,1,1,0,0,1,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,2,3,3,2,2,3,3,1,2,2,3,2,2,2,2,2,3,1,3,3,2,2,0,3,0,
   0,1,0,1,0,0,1,0,0,0,1,0,0,0,1,1,0,0,1,0,0,0,0,1,1,0,1,0,0,0,0,0,
  3,3,3,2,3,3,3,3,2,3,2,3,1,2,2,3,1,1,2,1,3,1,2,1,0,1,1,1,2,0,3,0,
   0,1,0,3,0,0,1,0,0,1,3,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
  3,3,3,1,3,2,1,2,3,2,1,1,3,1,2,1,2,3,2,1,3,1,1,1,3,1,1,1,1,0,3,0,
   0,3,0,0,0,0,1,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,
  0,3,3,3,3,3,1,3,3,3,2,3,3,3,0,3,3,3,3,3,3,3,3,3,2,2,2,3,3,0,0,0,
   0,3,0,2,0,0,1,0,0,1,2,1,0,0,2,1,0,0,1,0,0,0,0,1,1,0,1,0,0,0,0,0,
  3,3,3,3,3,3,0,2,3,2,2,1,2,2,3,2,1,1,2,2,1,2,2,2,1,2,2,2,1,0,3,0,
   0,1,0,2,0,0,1,0,0,0,1,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,
  3,3,2,1,2,2,2,2,3,2,3,1,2,2,1,1,1,1,3,1,1,2,2,2,1,1,1,1,2,0,1,0,
   0,1,0,1,0,0,1,0,0,1,1,1,0,0,0,0,0,0,1,0,0,0,0,0,3,0,1,0,0,0,0,0,
  3,3,3,2,3,2,2,3,2,3,3,1,1,1,2,2,1,2,1,1,1,3,1,1,0,1,1,1,2,0,3,0,
   0,1,0,1,0,0,1,0,0,3,1,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,
  3,3,3,3,3,3,1,2,1,3,2,3,3,3,1,2,2,3,3,3,2,2,2,2,1,2,2,3,2,0,1,0,
   0,1,0,2,0,0,1,0,0,0,1,1,0,0,2,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,
  3,3,2,3,2,2,1,1,2,1,3,2,2,2,2,2,1,1,1,2,1,2,3,1,1,1,2,3,1,0,0,0,
   0,1,0,2,0,0,1,0,0,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,
  3,3,3,2,1,1,1,3,2,3,3,1,1,1,1,3,1,1,1,1,0,0,0,0,1,0,0,0,1,0,0,0,
   0,0,0,0,0,0,0,0,0,1,2,3,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
  3,3,3,3,3,2,1,2,1,1,1,2,2,2,3,2,3,1,1,1,1,3,2,1,1,2,2,2,1,0,3,0,
   0,0,0,1,0,0,1,0,1,0,1,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,3,3,0,1,3,2,2,3,3,3,3,0,3,3,3,3,2,3,1,0,1,0,2,0,0,0,0,0,0,
   0,0,0,2,0,0,2,0,0,0,0,0,0,0,2,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,
  3,2,3,3,3,2,1,2,2,3,2,2,3,2,1,1,2,1,2,2,1,1,1,2,1,1,1,1,2,0,1,0,
   0,1,0,0,0,0,1,0,1,0,1,1,0,0,1,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,
  3,3,2,2,2,2,0,2,1,2,1,1,3,2,0,2,2,1,2,1,1,2,1,1,1,1,2,2,1,0,0,0,
   0,0,0,1,0,0,1,0,2,1,1,1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,
  3,1,2,1,3,1,1,1,1,2,1,1,1,2,1,2,1,1,1,1,1,1,1,1,0,1,1,1,1,0,1,0,
   0,0,0,1,0,0,1,0,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
  0,0,3,2,0,0,0,0,1,0,0,2,1,0,0,3,0,1,1,0,3,3,0,3,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
  0,3,1,2,2,0,1,3,0,2,2,3,1,3,0,3,2,1,1,3,2,0,0,1,0,2,0,0,0,0,0,0,
   0,1,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,1,0,0,0,0,0,0,0,0,
  0,3,2,3,3,0,1,2,3,2,3,3,2,2,0,3,1,3,2,3,2,2,0,1,1,2,0,0,0,0,0,0,
   0,1,0,1,0,0,3,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,2,0,2,
   3,0,3,0,2,2,1,3,0,0,0,0,3,3,0,0,1,3,0,1,2,2,2,0,0,0,0,0,2,1,0,0,
  0,3,3,3,2,3,2,2,1,2,3,2,2,1,0,1,2,3,2,1,3,1,3,1,1,2,3,2,2,0,0,0,
   0,1,0,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,
   3,0,3,0,2,1,0,3,0,0,0,0,3,2,0,0,1,2,0,2,2,3,3,0,0,1,0,0,2,0,0,0,
  0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,
   2,0,2,0,3,3,0,3,0,0,0,0,2,2,0,0,0,2,0,1,2,2,3,0,0,0,0,0,2,0,0,0,
  3,3,2,2,3,1,1,2,2,1,0,1,1,1,0,1,1,1,1,1,0,1,1,1,2,1,1,1,1,0,1,0,
   0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,2,
   1,0,2,0,3,2,0,3,0,0,0,0,1,2,0,0,1,3,0,1,2,1,2,0,0,0,0,1,3,0,0,0,
  3,1,2,1,2,2,0,1,1,2,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,0,0,0,
   0,1,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,3,
   2,0,3,0,1,3,0,3,0,0,0,0,3,3,0,0,1,2,0,1,3,2,1,0,0,1,0,1,2,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,
   3,0,3,0,1,2,0,2,0,0,0,0,3,3,0,0,2,2,0,3,2,2,1,0,0,0,0,0,1,0,0,0,
  3,1,2,1,2,3,1,1,1,1,1,1,1,1,1,2,1,1,1,1,0,0,1,1,0,0,1,1,1,0,1,0,
   0,1,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,
   2,0,1,0,3,2,0,2,0,0,0,0,1,2,0,0,3,1,0,3,1,1,2,0,0,0,0,0,1,0,0,0,
  3,2,1,2,1,1,0,1,2,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,
   0,0,0,1,0,0,1,0,0,2,2,1,0,0,1,3,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
  3,2,1,1,1,1,0,1,1,2,1,1,2,1,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,
   0,1,0,1,0,0,1,0,0,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,2,0,1,1,0,0,1,0,1,0,1,1,1,0,0,2,1,0,0,0,1,0,1,0,0,0,1,1,0,0,0,
   0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,1,1,2,1,2,0,1,1,1,1,1,1,2,0,1,1,1,1,0,2,2,2,2,1,1,1,1,1,0,0,0,
   0,1,0,0,0,0,1,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,
   0,0,1,0,3,2,0,1,0,0,0,0,3,1,0,0,1,3,0,2,1,2,1,0,0,0,0,1,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,
   1,0,1,0,2,2,0,3,0,0,0,0,1,2,0,0,2,1,0,1,1,1,1,0,0,0,0,0,1,0,1,0,
  1,0,2,0,0,0,1,1,2,1,3,1,1,0,1,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,1,1,2,2,1,0,3,1,1,1,1,2,1,0,1,1,1,3,1,1,1,1,1,1,1,1,1,1,0,0,0,
   0,2,0,1,0,0,1,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,
   1,0,2,0,2,2,0,2,0,0,0,0,1,1,0,0,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,
   1,0,1,0,2,2,0,1,0,0,0,0,1,1,0,0,1,1,0,2,1,1,1,0,0,0,0,0,1,0,0,0,
  1,2,1,1,2,1,1,1,1,1,2,1,1,1,1,1,0,1,1,1,0,1,1,1,0,1,1,1,1,0,0,0,
   0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,
   3,0,2,0,1,1,0,2,0,0,0,0,2,2,0,0,1,1,0,0,2,2,1,0,0,0,0,0,1,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,
   1,0,1,0,2,2,0,2,0,0,0,0,1,1,0,0,3,0,0,1,1,0,1,0,0,1,0,0,0,0,0,0,
  0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,
   0,0,1,0,2,2,0,0,0,0,0,0,1,2,0,0,1,1,0,1,0,1,1,0,0,0,0,0,1,0,0,0,
  0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,
   1,0,2,0,1,1,0,1,0,0,0,0,1,1,0,0,1,1,0,1,1,1,0,0,0,0,0,0,1,0,0,0,
  2,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,1,1,1,0,0,0,0,0,1,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,2,0,1,0,0,0,0,0,1,0,1,0,1,0,0,1,0,1,0,0,0,2,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,
   1,0,0,0,1,3,0,1,0,0,0,0,1,0,0,0,2,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,
  1,2,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,
   0,0,1,0,1,2,0,2,0,0,0,0,1,0,0,0,1,0,0,1,1,1,1,0,0,1,0,1,0,1,1,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,
   1,0,1,0,1,1,0,1,0,0,0,0,1,1,0,0,2,0,0,1,0,1,1,0,0,0,0,0,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,
   2,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,2,0,1,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,
   1,0,0,0,1,2,0,0,0,0,0,0,0,1,0,0,3,0,0,1,0,0,1,0,0,1,0,0,0,0,0,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,
   2,0,0,0,2,1,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,1,0,0,1,0,1,0,1,0,1,
};


const SequenceModel Iso_8859_11ThaiModel =
{
  Iso_8859_11_CharToOrderMap,
  ThaiLangModel,
  64,
  (float)0.8546375003626447,
  PR_FALSE,
  "ISO-8859-11"
};

const SequenceModel Tis_620ThaiModel =
{
  Tis_620_CharToOrderMap,
  ThaiLangModel,
  64,
  (float)0.8546375003626447,
  PR_FALSE,
  "TIS-620"
};