/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"

/********* Language model for: Slovak *********/

/**
 * Generated by BuildLangModel.py
 * On: 2017-03-27 19:53:33.189723
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_2_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 20, 15, 11,  2, 29, 30, 16,  4, 18,  8, 10, 12,  3,  0, /* 4X */
   13, 40,  6,  7,  5, 14,  9, 36, 35, 19, 17,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 20, 15, 11,  2, 29, 30, 16,  4, 18,  8, 10, 12,  3,  0, /* 6X */
   13, 40,  6,  7,  5, 14,  9, 36, 35, 19, 17,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 61,SYM, 49,SYM, 33, 62,SYM,SYM, 28, 58, 31, 63,SYM, 26, 60, /* AX */
  SYM, 64,SYM, 49,SYM, 33, 65,SYM,SYM, 28, 58, 31, 66,SYM, 26, 60, /* BX */
   45, 21, 67, 55, 39, 42, 47, 50, 24, 25, 68, 51, 41, 23, 69, 38, /* CX */
   53, 54, 37, 34, 32, 70, 43,SYM, 44, 48, 27, 56, 46, 22, 71, 59, /* DX */
   45, 21, 72, 55, 39, 42, 47, 50, 24, 25, 73, 51, 41, 23, 74, 38, /* EX */
   53, 54, 37, 34, 32, 75, 43,SYM, 44, 48, 27, 56, 46, 22, 76,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1250_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 20, 15, 11,  2, 29, 30, 16,  4, 18,  8, 10, 12,  3,  0, /* 4X */
   13, 40,  6,  7,  5, 14,  9, 36, 35, 19, 17,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 20, 15, 11,  2, 29, 30, 16,  4, 18,  8, 10, 12,  3,  0, /* 6X */
   13, 40,  6,  7,  5, 14,  9, 36, 35, 19, 17,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM,ILL,SYM,SYM,SYM,SYM,ILL,SYM, 28,SYM, 77, 31, 26, 78, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM, 28,SYM, 79, 31, 26, 80, /* 9X */
  SYM,SYM,SYM, 49,SYM, 81,SYM,SYM,SYM,SYM, 58,SYM,SYM,SYM,SYM, 60, /* AX */
  SYM,SYM,SYM, 49,SYM,SYM,SYM,SYM,SYM, 82, 58,SYM, 33,SYM, 33, 60, /* BX */
   45, 21, 83, 55, 39, 42, 47, 50, 24, 25, 84, 51, 41, 23, 85, 38, /* CX */
   53, 54, 37, 34, 32, 86, 43,SYM, 44, 48, 27, 56, 46, 22, 87, 59, /* DX */
   45, 21, 88, 55, 39, 42, 47, 50, 24, 25, 89, 51, 41, 23, 90, 38, /* EX */
   53, 54, 37, 34, 32, 91, 43,SYM, 44, 48, 27, 56, 46, 22, 92,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Ibm852_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 20, 15, 11,  2, 29, 30, 16,  4, 18,  8, 10, 12,  3,  0, /* 4X */
   13, 40,  6,  7,  5, 14,  9, 36, 35, 19, 17,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 20, 15, 11,  2, 29, 30, 16,  4, 18,  8, 10, 12,  3,  0, /* 6X */
   13, 40,  6,  7,  5, 14,  9, 36, 35, 19, 17,SYM,SYM,SYM,SYM,CTR, /* 7X */
   50, 46, 25, 93, 39, 48, 47, 50, 49, 51, 94, 95, 96, 97, 39, 47, /* 8X */
   25, 42, 42, 32, 43, 33, 33, 98, 99, 43, 46, 31, 31, 49,SYM, 24, /* 9X */
   21, 23, 34, 27,100,101, 26, 26,102,103,SYM,104, 24, 58,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 21,105, 41, 58,SYM,SYM,SYM,SYM, 60, 60,SYM, /* BX */
  SYM,SYM,SYM,SYM,SYM,SYM, 55, 55,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* CX */
   53, 53, 38, 51, 38, 37, 23,106, 41,SYM,SYM,SYM,SYM,107, 48,SYM, /* DX */
   34, 59, 32, 54, 54, 37, 28, 28, 45, 27, 45, 56, 22, 22,108,SYM, /* EX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 56, 44, 44,SYM,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Maccentraleurope_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 20, 15, 11,  2, 29, 30, 16,  4, 18,  8, 10, 12,  3,  0, /* 4X */
   13, 40,  6,  7,  5, 14,  9, 36, 35, 19, 17,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 20, 15, 11,  2, 29, 30, 16,  4, 18,  8, 10, 12,  3,  0, /* 6X */
   13, 40,  6,  7,  5, 14,  9, 36, 35, 19, 17,SYM,SYM,SYM,SYM,CTR, /* 7X */
   39,109,110, 25,111, 43, 46, 21,112, 24, 39, 24, 47, 47, 25,113, /* 8X */
  114, 38, 23, 38,115,116,117, 34,118, 32, 43,119, 27, 41, 41, 46, /* 9X */
  SYM,SYM,120,SYM,SYM,SYM,SYM, 59,SYM,SYM,SYM,121,SYM,SYM,122,123, /* AX */
  124, 57,SYM,SYM, 57,125,SYM,SYM, 49,126,127, 33, 33, 42, 42,128, /* BX */
  129, 54,SYM,SYM, 54, 37,SYM,SYM,SYM,SYM,SYM, 37,130,131,132, 52, /* CX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 52, 45, 45, 44,SYM,SYM, 44,133, /* DX */
  134, 28,SYM,SYM, 28,135,136, 21, 31, 31, 23, 26, 26,137, 34, 32, /* EX */
  138, 48, 27, 48, 56, 56,139,140, 22, 22,141, 60, 49, 60,142,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 1189
 * First 512 sequences: 0.9718024351837476
 * Next 512 sequences (512-1024): 0.027811661380824592
 * Rest: 0.00038590343542775976
 * Negative sequences: TODO
 */
static const PRUint8 SlovakLangModel[] =
{
  2,2,2,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,0,
   0,3,2,3,1,2,3,3,1,0,3,0,2,2,3,1,0,2,0,0,0,2,0,
  2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,
   0,3,0,3,0,3,3,3,3,0,2,1,3,2,2,2,0,1,0,0,0,2,0,
  3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,
   2,3,0,3,2,3,3,3,2,0,3,3,3,2,3,3,0,2,0,0,1,0,0,
  3,3,3,3,3,3,2,3,3,2,2,3,2,2,3,3,2,2,2,3,2,3,3,
   3,3,3,2,3,3,2,3,0,2,0,2,0,2,0,0,0,2,2,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,0,
   3,3,2,3,0,3,3,3,3,0,2,3,2,2,2,0,0,2,0,0,0,2,0,
  3,3,3,3,3,3,3,3,3,3,3,1,3,2,3,2,3,3,2,3,2,3,3,
   3,2,3,0,3,2,2,2,1,0,2,3,0,2,2,2,2,1,2,1,1,0,2,
  3,3,3,3,3,3,2,3,3,3,3,3,3,2,3,3,2,3,2,3,3,3,3,
   3,3,3,2,2,2,2,3,2,3,0,3,2,2,2,0,2,2,0,0,2,0,0,
  3,3,3,3,3,3,2,3,3,3,3,2,3,3,3,3,2,2,2,3,2,3,2,
   3,2,2,1,3,0,2,2,3,2,2,2,0,2,2,0,0,2,0,0,0,0,0,
  3,3,3,2,3,3,3,2,2,3,3,3,2,1,3,3,2,2,2,3,2,3,3,
   2,2,3,2,3,2,2,2,0,3,2,2,0,2,2,0,0,0,0,0,2,2,1,
  3,3,3,3,3,2,3,3,2,0,3,3,2,3,3,2,2,3,0,3,2,3,3,
   3,2,3,2,2,3,1,2,0,2,0,0,0,0,2,2,3,0,2,2,1,1,2,
  3,3,3,3,3,3,2,3,3,2,3,2,2,2,3,2,2,2,2,3,3,3,3,
   3,2,3,2,3,2,2,3,0,1,0,3,0,1,2,0,0,0,0,0,0,0,0,
  3,3,3,3,3,2,3,3,3,3,3,2,3,3,3,3,2,3,2,3,3,3,3,
   3,2,2,2,2,2,2,2,0,3,3,2,2,2,2,0,0,0,2,2,0,2,0,
  3,3,3,3,3,3,2,3,2,0,2,2,3,3,3,2,0,0,2,3,3,3,2,
   3,1,2,2,2,0,1,2,0,3,0,2,1,1,2,0,2,1,0,0,0,0,2,
  3,3,3,3,3,3,3,2,2,0,3,2,2,2,3,2,2,1,0,2,2,3,2,
   3,1,2,0,2,2,0,0,2,3,1,2,0,0,2,0,2,0,2,2,0,2,0,
  2,2,2,3,2,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,3,3,0,
   2,3,1,3,1,2,2,3,2,0,2,0,2,2,1,2,0,2,0,0,0,0,0,
  3,3,3,3,3,2,2,2,3,2,2,2,2,0,3,2,3,2,0,2,0,2,1,
   3,0,2,0,3,0,1,2,2,0,0,2,0,0,2,0,0,2,0,0,0,0,0,
  3,3,3,3,3,3,3,2,2,2,3,2,3,1,3,2,2,0,1,3,2,3,3,
   2,1,2,0,2,2,1,0,0,0,2,1,0,2,2,0,1,0,0,2,1,2,2,
  3,3,3,3,3,2,3,3,3,3,3,3,3,2,3,2,3,2,2,3,2,3,3,
   3,1,2,1,2,2,0,2,2,0,2,2,0,2,2,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,2,3,2,3,2,2,3,2,3,2,2,2,2,0,2,2,0,
   2,2,0,0,3,3,1,2,0,0,2,2,0,0,0,0,1,0,0,0,0,0,0,
  2,2,2,3,2,3,3,3,3,3,3,2,3,3,2,3,3,3,2,0,3,0,0,
   0,2,0,2,2,3,1,2,3,0,1,1,0,1,2,0,0,0,0,0,0,0,0,
  3,3,3,3,3,1,3,3,2,2,3,3,2,0,3,2,2,2,3,3,2,3,2,
   2,2,2,1,2,2,0,2,0,1,0,1,0,0,2,0,1,0,0,0,1,1,0,
  0,0,0,3,0,3,3,3,3,3,3,3,3,3,2,3,2,3,3,0,3,0,0,
   0,2,0,2,0,3,0,1,0,0,2,0,0,0,2,2,0,0,0,0,0,2,0,
  0,0,0,2,0,2,3,2,2,3,2,2,3,2,0,3,2,3,2,0,2,0,0,
   0,1,0,2,0,2,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
  0,2,0,3,0,3,3,3,3,3,3,2,3,3,0,3,2,2,2,0,2,0,0,
   0,2,0,2,0,3,0,1,2,0,2,0,0,0,1,0,0,0,0,0,0,1,0,
  3,3,3,3,3,3,2,2,3,0,3,0,2,0,2,2,0,0,0,0,0,2,0,
   3,0,1,1,2,3,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,
  1,0,0,2,0,3,3,2,2,2,2,2,3,2,0,3,3,2,0,0,1,0,0,
   0,2,0,0,0,2,2,2,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,0,1,3,2,1,1,3,1,0,3,0,0,0,1,0,2,2,0,
   3,0,2,0,0,2,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,
  1,0,0,3,0,3,3,3,2,3,3,3,2,3,0,3,2,3,0,0,2,0,0,
   0,3,0,2,0,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,0,2,2,2,3,1,2,3,2,0,2,0,0,0,2,1,0,
   3,2,1,0,1,2,0,0,2,0,2,0,0,0,1,0,0,0,0,0,0,0,0,
  3,3,3,2,3,2,3,2,1,1,2,0,2,0,3,0,1,0,0,3,0,2,0,
   2,0,2,0,1,0,2,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,2,3,2,3,2,0,2,3,2,2,0,3,2,2,0,0,2,0,2,0,
   0,0,2,0,2,0,0,2,0,0,0,2,0,2,0,0,0,0,0,0,2,0,0,
  3,3,0,0,1,0,2,0,1,0,0,2,1,1,2,0,0,0,0,0,0,1,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,2,3,3,3,3,3,2,1,0,0,2,0,2,1,0,2,0,0,
   0,0,0,3,0,1,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,0,3,0,1,0,2,3,2,0,0,2,0,3,0,1,1,0,0,2,0,0,
   0,1,0,0,2,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,3,0,2,3,2,1,1,2,3,3,3,0,2,0,2,0,0,3,0,0,
   0,0,0,1,0,0,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,2,2,2,3,2,0,0,1,0,2,0,2,2,2,1,0,0,0,1,0,0,0,
   2,0,0,0,0,0,2,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
  2,2,2,2,3,2,2,2,1,0,2,0,1,0,0,0,2,0,0,2,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,
  3,3,0,0,0,0,0,0,0,0,0,1,2,0,2,0,2,0,0,0,0,2,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,3,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,
   0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,2,0,2,1,0,1,0,0,2,0,0,0,2,0,2,0,0,2,0,0,
   0,3,0,0,0,0,0,2,2,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
  0,0,0,0,0,0,2,0,0,1,0,0,0,0,2,0,0,0,0,0,0,2,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,2,0,2,2,0,2,1,1,0,1,0,0,1,0,2,2,0,0,0,0,
   0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,2,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,2,0,0,
   0,0,0,2,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,
  0,0,0,2,0,2,2,2,0,0,1,2,1,0,0,0,2,0,0,0,0,0,0,
   0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,2,0,2,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,1,0,
   2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,2,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,
   0,0,0,0,0,2,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,
};


const SequenceModel Iso_8859_2SlovakModel =
{
  Iso_8859_2_CharToOrderMap,
  SlovakLangModel,
  46,
  (float)0.9718024351837476,
  PR_TRUE,
  "ISO-8859-2"
};

const SequenceModel Windows_1250SlovakModel =
{
  Windows_1250_CharToOrderMap,
  SlovakLangModel,
  46,
  (float)0.9718024351837476,
  PR_TRUE,
  "WINDOWS-1250"
};

const SequenceModel Ibm852SlovakModel =
{
  Ibm852_CharToOrderMap,
  SlovakLangModel,
  46,
  (float)0.9718024351837476,
  PR_TRUE,
  "IBM852"
};

const SequenceModel MaccentraleuropeSlovakModel =
{
  Maccentraleurope_CharToOrderMap,
  SlovakLangModel,
  46,
  (float)0.9718024351837476,
  PR_TRUE,
  "MacCentralEurope"
};