/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"

/********* Language model for: Polish *********/

/**
 * Generated by BuildLangModel.py
 * On: 2017-03-27 19:32:58.419043
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_2_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 21, 11, 15,  3, 24, 20, 22,  1, 18,  7, 14, 16,  5,  2, /* 4X */
   13, 36,  4,  6, 10, 17, 30,  9, 33, 12,  8,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 21, 11, 15,  3, 24, 20, 22,  1, 18,  7, 14, 16,  5,  2, /* 6X */
   13, 36,  4,  6, 10, 17, 30,  9, 33, 12,  8,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 26,SYM, 19,SYM, 77, 29,SYM,SYM, 40, 55, 80, 32,SYM, 48, 28, /* AX */
  SYM, 26,SYM, 19,SYM, 77, 29,SYM,SYM, 40, 55, 80, 32,SYM, 48, 28, /* BX */
   87, 35, 60, 56, 41, 88, 31, 45, 44, 34, 23, 57, 49, 37, 74, 79, /* CX */
   69, 27, 76, 25, 61, 53, 39,SYM, 50, 86, 47, 84, 38, 52, 70, 58, /* DX */
   89, 35, 60, 56, 41, 90, 31, 45, 44, 34, 23, 57, 49, 37, 74, 79, /* EX */
   69, 27, 76, 25, 61, 53, 39,SYM, 50, 86, 47, 84, 38, 52, 70,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_13_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 21, 11, 15,  3, 24, 20, 22,  1, 18,  7, 14, 16,  5,  2, /* 4X */
   13, 36,  4,  6, 10, 17, 30,  9, 33, 12,  8,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 21, 11, 15,  3, 24, 20, 22,  1, 18,  7, 14, 16,  5,  2, /* 6X */
   13, 36,  4,  6, 10, 17, 30,  9, 33, 12,  8,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 46,SYM, 91,SYM,SYM,SYM,SYM, 67, /* AX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 46,SYM, 92,SYM,SYM,SYM,SYM, 67, /* BX */
   26, 93, 64, 31, 41, 51, 23, 75, 44, 34, 32, 59, 94, 85, 78, 95, /* CX */
   40, 27, 83, 25, 43, 66, 39,SYM, 96, 19, 29, 54, 38, 28, 48, 58, /* DX */
   26, 97, 64, 31, 41, 51, 23, 75, 44, 34, 32, 59, 98, 85, 78, 99, /* EX */
   40, 27, 83, 25, 43, 66, 39,SYM,100, 19, 29, 54, 38, 28, 48,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_16_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 21, 11, 15,  3, 24, 20, 22,  1, 18,  7, 14, 16,  5,  2, /* 4X */
   13, 36,  4,  6, 10, 17, 30,  9, 33, 12,  8,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 21, 11, 15,  3, 24, 20, 22,  1, 18,  7, 14, 16,  5,  2, /* 6X */
   13, 36,  4,  6, 10, 17, 30,  9, 33, 12,  8,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 26, 26, 19,SYM,SYM, 40,SYM, 40,SYM, 63,SYM, 32,SYM, 32, 28, /* AX */
  SYM,SYM, 44, 19, 48,SYM,SYM,SYM, 48, 44, 63,SYM, 81, 81, 82, 28, /* BX */
   62, 35, 60, 56, 41, 31, 67, 45, 42, 34, 71, 57,101, 37, 74, 68, /* CX */
   69, 27, 65, 25, 61, 53, 39, 29, 84, 73, 47,102, 38, 23, 72, 58, /* DX */
   62, 35, 60, 56, 41, 31, 67, 45, 42, 34, 71, 57,103, 37, 74, 68, /* EX */
   69, 27, 65, 25, 61, 53, 39, 29, 84, 73, 47,104, 38, 23, 72, 82, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1250_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 21, 11, 15,  3, 24, 20, 22,  1, 18,  7, 14, 16,  5,  2, /* 4X */
   13, 36,  4,  6, 10, 17, 30,  9, 33, 12,  8,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 21, 11, 15,  3, 24, 20, 22,  1, 18,  7, 14, 16,  5,  2, /* 6X */
   13, 36,  4,  6, 10, 17, 30,  9, 33, 12,  8,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM,ILL,SYM,SYM,SYM,SYM,ILL,SYM, 40,SYM, 29, 80, 48, 32, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM, 40,SYM, 29, 80, 48, 32, /* 9X */
  SYM,SYM,SYM, 19,SYM, 26,SYM,SYM,SYM,SYM, 55,SYM,SYM,SYM,SYM, 28, /* AX */
  SYM,SYM,SYM, 19,SYM,SYM,SYM,SYM,SYM, 26, 55,SYM, 77,SYM, 77, 28, /* BX */
  105, 35, 60, 56, 41,106, 31, 45, 44, 34, 23, 57, 49, 37, 74, 79, /* CX */
   69, 27, 76, 25, 61, 53, 39,SYM, 50, 86, 47, 84, 38, 52, 70, 58, /* DX */
  107, 35, 60, 56, 41,108, 31, 45, 44, 34, 23, 57, 49, 37, 74, 79, /* EX */
   69, 27, 76, 25, 61, 53, 39,SYM, 50, 86, 47, 84, 38, 52, 70,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Ibm852_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 21, 11, 15,  3, 24, 20, 22,  1, 18,  7, 14, 16,  5,  2, /* 4X */
   13, 36,  4,  6, 10, 17, 30,  9, 33, 12,  8,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 21, 11, 15,  3, 24, 20, 22,  1, 18,  7, 14, 16,  5,  2, /* 6X */
   13, 36,  4,  6, 10, 17, 30,  9, 33, 12,  8,SYM,SYM,SYM,SYM,CTR, /* 7X */
   45, 38, 34, 60, 41, 86, 31, 45, 19, 57, 53, 53, 74, 32, 41, 31, /* 8X */
   34,109,110, 61, 39, 77, 77, 29, 29, 39, 38, 80, 80, 19,SYM, 44, /* 9X */
   35, 37, 25, 47, 26, 26, 48, 48, 23, 23,SYM, 32, 44, 55,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 35, 60, 49, 55,SYM,SYM,SYM,SYM, 28, 28,SYM, /* BX */
  SYM,SYM,SYM,SYM,SYM,SYM, 56, 56,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* CX */
   69, 69, 79, 57, 79, 76, 37, 74, 49,SYM,SYM,SYM,SYM, 70, 86,SYM, /* DX */
   25, 58, 61, 27, 27, 76, 40, 40,111, 47,112, 84, 52, 52, 70,SYM, /* EX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 84, 50, 50,SYM,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Maccentraleurope_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 21, 11, 15,  3, 24, 20, 22,  1, 18,  7, 14, 16,  5,  2, /* 4X */
   13, 36,  4,  6, 10, 17, 30,  9, 33, 12,  8,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 21, 11, 15,  3, 24, 20, 22,  1, 18,  7, 14, 16,  5,  2, /* 6X */
   13, 36,  4,  6, 10, 17, 30,  9, 33, 12,  8,SYM,SYM,SYM,SYM,CTR, /* 7X */
   41, 64, 64, 34, 26, 39, 38, 35, 26, 44, 41, 44, 31, 31, 34, 32, /* 8X */
   32, 79, 37, 79, 75, 75, 59, 25, 59, 61, 39, 66, 47, 49, 49, 38, /* 9X */
  SYM,SYM, 23,SYM,SYM,SYM,SYM, 58,SYM,SYM,SYM, 23,SYM,SYM,113,114, /* AX */
  115, 78,SYM,SYM, 78, 85,SYM,SYM, 19,116,117, 77, 77,118,119, 83, /* BX */
   83, 27,SYM,SYM, 27, 76,SYM,SYM,SYM,SYM,SYM, 76, 53, 66, 53, 43, /* CX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 43,120,121, 50,SYM,SYM, 50,122, /* DX */
  123, 40,SYM,SYM, 40, 29, 29, 35, 80, 80, 37, 48, 48, 54, 25, 61, /* EX */
   54, 86, 47, 86, 84, 84,124,125, 52, 52, 85, 28, 19, 28,126,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 1503
 * First 512 sequences: 0.9881992924733806
 * Next 512 sequences (512-1024): 0.011313455204503076
 * Rest: 0.00048725232211636015
 * Negative sequences: TODO
 */
static const PRUint8 PolishLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,0,0,3,3,3,3,3,3,2,1,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,2,3,2,3,3,3,3,2,3,3,1,2,2,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,0,0,3,3,3,3,2,2,2,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,3,2,2,3,3,3,3,2,3,2,0,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,2,3,2,3,3,0,2,2,2,2,0,2,2,2,2,
  3,3,3,3,3,3,3,3,3,2,3,3,3,2,2,3,2,3,2,1,3,3,2,3,3,3,3,0,3,1,2,0,0,2,2,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,3,3,2,2,3,3,0,0,0,2,0,0,0,2,2,2,
  3,3,3,3,3,2,3,3,2,3,3,3,2,2,3,2,3,3,2,3,2,2,2,3,2,3,3,0,3,1,2,0,0,1,2,2,0,
  3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,2,3,0,1,0,1,0,0,0,2,2,2,
  3,3,3,3,3,3,3,3,3,2,2,3,3,3,2,2,2,3,2,3,2,2,2,3,2,3,3,0,0,2,0,0,0,0,1,0,0,
  3,3,3,3,3,3,3,3,3,3,3,2,3,2,3,2,2,3,2,3,2,2,3,3,2,3,3,0,1,1,2,0,0,0,2,2,0,
  3,3,3,3,2,3,2,3,3,2,3,2,3,1,3,2,2,3,3,2,2,1,3,2,1,3,3,0,0,0,1,0,0,0,2,2,2,
  3,2,2,2,3,3,3,3,3,3,3,3,0,3,3,3,3,2,3,3,3,3,2,0,3,0,0,3,3,3,2,3,2,1,0,1,0,
  3,3,3,3,3,3,3,2,2,2,2,3,3,3,3,2,2,3,1,3,2,2,3,2,2,3,2,0,0,0,1,0,0,0,2,2,0,
  3,3,3,3,2,3,3,3,2,3,3,3,2,3,3,3,3,3,2,0,3,3,2,3,3,2,3,1,2,0,2,0,0,1,2,2,0,
  3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,2,3,2,3,2,2,2,3,3,0,3,1,2,0,2,0,2,2,2,
  3,3,3,3,2,3,3,3,2,2,2,3,3,3,2,2,3,3,2,2,2,3,2,3,2,3,2,0,2,1,1,0,0,1,2,2,1,
  3,3,2,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,3,3,3,3,2,0,3,1,0,3,3,2,2,1,2,2,2,2,2,
  3,3,3,3,2,3,3,2,2,3,2,3,0,2,2,3,3,3,2,2,2,2,1,3,1,3,3,1,2,2,1,0,0,0,1,2,0,
  3,1,3,3,2,3,2,3,2,2,3,2,3,2,1,2,2,3,0,2,3,2,1,3,1,3,3,0,2,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,2,2,2,3,2,1,2,2,3,3,2,3,2,3,2,2,3,2,2,3,2,0,1,0,2,0,0,0,2,2,2,
  3,3,3,3,3,3,3,2,2,2,1,2,3,2,3,2,2,3,2,3,1,2,2,3,2,2,2,0,0,0,0,0,0,0,2,2,0,
  3,3,3,3,3,3,2,2,2,2,2,2,3,2,3,2,3,3,2,2,1,2,1,2,2,2,2,0,1,1,2,0,0,0,2,2,1,
  0,0,0,0,0,0,3,3,3,1,3,3,0,3,2,3,0,0,0,3,3,3,0,0,0,0,0,0,3,3,0,2,2,0,0,0,0,
  3,3,3,3,3,2,2,2,0,1,2,2,2,1,3,1,2,3,2,2,2,2,1,2,3,2,2,0,0,0,1,0,0,0,2,2,1,
  0,0,0,0,3,2,2,2,3,3,2,3,1,2,3,3,2,0,3,3,2,3,1,0,1,0,0,0,3,1,1,0,3,0,0,0,0,
  0,0,0,0,0,0,2,2,3,2,3,3,0,3,0,3,1,0,0,3,3,2,0,0,0,0,0,0,3,0,0,2,0,0,0,0,0,
  1,0,0,0,0,0,3,2,0,0,0,3,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,2,3,3,0,3,2,2,0,2,0,2,3,0,2,2,2,3,0,0,1,2,1,2,0,2,2,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,3,3,1,2,0,3,0,3,0,2,3,0,3,0,0,0,0,2,0,0,0,0,0,2,0,0,0,3,0,0,0,0,0,
  3,3,3,3,2,2,2,2,1,0,1,1,2,2,2,1,0,2,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,1,2,0,
  1,0,0,1,0,0,0,2,0,2,0,0,0,0,0,2,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,2,3,2,1,0,2,0,2,0,0,2,3,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
  2,3,2,2,0,1,1,1,0,1,2,1,1,2,2,0,1,2,1,0,0,1,2,0,2,0,0,0,0,0,2,0,0,2,0,0,0,
  2,1,2,2,2,2,2,0,2,0,2,2,1,1,2,2,2,1,1,0,2,2,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
  0,1,0,1,2,2,2,2,2,0,2,2,0,2,2,2,2,0,0,0,1,2,1,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
  2,2,1,1,1,0,0,0,0,0,0,0,1,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
};


const SequenceModel Iso_8859_2PolishModel =
{
  Iso_8859_2_CharToOrderMap,
  PolishLangModel,
  37,
  (float)0.9881992924733806,
  PR_TRUE,
  "ISO-8859-2"
};

const SequenceModel Iso_8859_13PolishModel =
{
  Iso_8859_13_CharToOrderMap,
  PolishLangModel,
  37,
  (float)0.9881992924733806,
  PR_TRUE,
  "ISO-8859-13"
};

const SequenceModel Iso_8859_16PolishModel =
{
  Iso_8859_16_CharToOrderMap,
  PolishLangModel,
  37,
  (float)0.9881992924733806,
  PR_TRUE,
  "ISO-8859-16"
};

const SequenceModel Windows_1250PolishModel =
{
  Windows_1250_CharToOrderMap,
  PolishLangModel,
  37,
  (float)0.9881992924733806,
  PR_TRUE,
  "WINDOWS-1250"
};

const SequenceModel Ibm852PolishModel =
{
  Ibm852_CharToOrderMap,
  PolishLangModel,
  37,
  (float)0.9881992924733806,
  PR_TRUE,
  "IBM852"
};

const SequenceModel MaccentraleuropePolishModel =
{
  Maccentraleurope_CharToOrderMap,
  PolishLangModel,
  37,
  (float)0.9881992924733806,
  PR_TRUE,
  "MacCentralEurope"
};