/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"

/********* Language model for: Czech *********/

/**
 * Generated by BuildLangModel.py
 * On: 2017-03-27 17:37:24.963255
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_2_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  3, 22, 14, 13,  1, 30, 31, 17,  4, 21, 12, 10, 16,  2,  0, /* 4X */
    8, 40,  9,  6,  5, 15,  7, 36, 34, 20, 19,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  3, 22, 14, 13,  1, 30, 31, 17,  4, 21, 12, 10, 16,  2,  0, /* 6X */
    8, 40,  9,  6,  5, 15,  7, 36, 34, 20, 19,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 47,SYM, 48,SYM, 44, 45,SYM,SYM, 29, 49, 38, 50,SYM, 26, 51, /* AX */
  SYM, 52,SYM, 53,SYM, 44, 45,SYM,SYM, 29, 54, 38, 55,SYM, 26, 56, /* BX */
   57, 18, 58, 59, 42, 60, 61, 62, 25, 24, 63, 64, 23, 11, 65, 39, /* CX */
   66, 67, 35, 37, 68, 69, 41,SYM, 27, 32, 33, 70, 43, 28, 71, 72, /* DX */
   73, 18, 74, 75, 42, 76, 77, 78, 25, 24, 79, 80, 23, 11, 81, 39, /* EX */
   82, 83, 35, 37, 84, 85, 41,SYM, 27, 32, 33, 86, 43, 28, 87,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1250_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  3, 22, 14, 13,  1, 30, 31, 17,  4, 21, 12, 10, 16,  2,  0, /* 4X */
    8, 40,  9,  6,  5, 15,  7, 36, 34, 20, 19,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  3, 22, 14, 13,  1, 30, 31, 17,  4, 21, 12, 10, 16,  2,  0, /* 6X */
    8, 40,  9,  6,  5, 15,  7, 36, 34, 20, 19,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM,ILL,SYM,SYM,SYM,SYM,ILL,SYM, 29,SYM, 45, 38, 26, 88, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM, 29,SYM, 45, 38, 26, 89, /* 9X */
  SYM,SYM,SYM, 90,SYM, 91,SYM,SYM,SYM,SYM, 92,SYM,SYM,SYM,SYM, 93, /* AX */
  SYM,SYM,SYM, 94,SYM,SYM,SYM,SYM,SYM, 95, 96,SYM, 44,SYM, 44, 97, /* BX */
   98, 18, 99,100, 42,101,102,103, 25, 24,104,105, 23, 11,106, 39, /* CX */
  107,108, 35, 37,109,110, 41,SYM, 27, 32, 33,111, 43, 28,112,113, /* DX */
  114, 18,115,116, 42,117,118,119, 25, 24,120,121, 23, 11,122, 39, /* EX */
  123,124, 35, 37,125,126, 41,SYM, 27, 32, 33,127, 43, 28,128,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Ibm852_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  3, 22, 14, 13,  1, 30, 31, 17,  4, 21, 12, 10, 16,  2,  0, /* 4X */
    8, 40,  9,  6,  5, 15,  7, 36, 34, 20, 19,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  3, 22, 14, 13,  1, 30, 31, 17,  4, 21, 12, 10, 16,  2,  0, /* 6X */
    8, 40,  9,  6,  5, 15,  7, 36, 34, 20, 19,SYM,SYM,SYM,SYM,CTR, /* 7X */
  129, 43, 24,130, 42, 32,131,132,133,134,135,136,137,138, 42,139, /* 8X */
   24,140,141,142, 41, 44, 44, 45, 45, 41, 43, 38, 38,143,SYM, 25, /* 9X */
   18, 11, 37, 33,144,145, 26, 26,146,147,SYM,148, 25,149,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 18,150, 23,151,SYM,SYM,SYM,SYM,152,153,SYM, /* BX */
  SYM,SYM,SYM,SYM,SYM,SYM,154,155,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* CX */
  156,157, 39,158, 39, 35, 11,159, 23,SYM,SYM,SYM,SYM,160, 32,SYM, /* DX */
   37,161,162,163,164, 35, 29, 29,165, 33,166,167, 28, 28,168,SYM, /* EX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,169, 27, 27,SYM,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Maccentraleurope_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  3, 22, 14, 13,  1, 30, 31, 17,  4, 21, 12, 10, 16,  2,  0, /* 4X */
    8, 40,  9,  6,  5, 15,  7, 36, 34, 20, 19,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  3, 22, 14, 13,  1, 30, 31, 17,  4, 21, 12, 10, 16,  2,  0, /* 6X */
    8, 40,  9,  6,  5, 15,  7, 36, 34, 20, 19,SYM,SYM,SYM,SYM,CTR, /* 7X */
   42,170,171, 24,172, 41, 43, 18,173, 25, 42, 25,174,175, 24,176, /* 8X */
  177, 39, 11, 39, 46, 46,178, 37,179,180, 41,181, 33, 23, 23, 43, /* 9X */
  SYM,SYM,182,SYM,SYM,SYM,SYM,183,SYM,SYM,SYM,184,SYM,SYM,185,186, /* AX */
  187,188,SYM,SYM,189,190,SYM,SYM,191,192,193, 44, 44,194,195,196, /* BX */
  197,198,SYM,SYM,199, 35,SYM,SYM,SYM,SYM,SYM, 35,200,201,202,203, /* CX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,204,205,206, 27,SYM,SYM, 27,207, /* DX */
  208, 29,SYM,SYM, 29, 45, 45, 18, 38, 38, 11, 26, 26,209, 37,210, /* EX */
  211, 32, 33, 32,212,213,214,215, 28, 28,216,217,218,219,220,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 1011
 * First 512 sequences: 0.9775196375975984
 * Next 512 sequences (512-1024): 0.022480362402401553
 * Rest: 3.469446951953614e-17
 * Negative sequences: TODO
 */
static const PRUint8 CzechLangModel[] =
{
  2,2,3,2,3,3,3,3,3,3,3,2,3,3,3,3,3,3,2,3,
   2,3,3,0,0,3,3,3,0,2,3,3,0,0,3,2,2,0,2,0,0,
  3,2,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,2,3,
   2,3,3,0,0,3,3,3,0,3,3,3,2,2,3,2,2,2,2,2,2,
  3,3,3,3,3,3,3,2,2,2,3,3,3,3,3,3,2,3,3,3,
   3,2,2,3,3,3,2,0,3,2,3,3,3,0,2,0,2,2,0,0,2,
  2,2,3,2,2,3,3,3,3,3,3,0,3,3,3,3,3,3,0,3,
   3,3,3,0,0,3,3,3,0,3,3,3,0,0,3,2,2,0,2,2,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,
   0,2,3,0,2,3,3,2,0,3,3,3,0,0,2,2,2,2,2,0,2,
  3,3,3,3,3,2,2,3,2,3,3,3,3,2,2,3,2,3,3,3,
   3,2,2,3,3,2,0,3,3,3,0,2,3,0,0,2,2,2,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,3,2,
   3,2,3,0,2,2,0,0,2,0,2,2,2,2,0,0,2,0,2,0,0,
  3,3,3,3,3,2,2,0,2,3,3,3,3,3,2,3,0,2,3,3,
   3,2,2,3,3,2,2,2,3,3,2,0,3,0,0,2,0,2,0,0,0,
  3,3,3,3,3,3,3,0,2,3,3,3,2,2,2,3,2,2,3,0,
   3,2,2,3,2,2,0,3,2,2,0,2,3,0,2,2,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,2,2,2,3,3,2,3,3,2,3,3,
   3,0,3,0,3,3,2,0,3,3,2,3,3,0,0,2,2,2,0,0,2,
  3,3,3,3,3,3,2,2,2,2,2,3,3,2,2,3,2,2,3,3,
   3,0,2,0,3,2,2,0,3,3,2,2,3,0,0,2,0,0,0,0,0,
  0,0,3,0,2,3,3,3,3,3,3,0,3,3,3,0,3,3,0,3,
   0,3,2,0,0,3,3,2,0,2,0,2,0,0,0,0,0,0,2,0,0,
  3,3,3,3,3,3,2,3,0,3,3,0,2,3,3,3,2,2,3,2,
   3,2,2,0,3,2,2,2,3,0,2,2,3,0,0,0,2,3,0,0,0,
  3,3,3,3,3,2,3,3,3,3,3,3,3,2,3,3,3,2,3,2,
   3,0,2,3,3,2,2,2,2,2,2,2,3,0,2,2,2,0,0,0,0,
  3,3,3,3,3,3,2,2,2,2,2,3,3,3,2,2,2,3,2,2,
   2,0,2,0,2,0,0,0,0,0,2,0,2,0,0,2,0,0,0,0,2,
  2,2,3,3,2,3,3,3,3,3,3,0,3,3,3,2,3,3,3,3,
   2,3,3,0,0,3,3,2,0,3,2,2,0,0,2,2,2,0,2,2,0,
  3,3,3,3,3,2,2,0,3,3,3,3,2,2,2,3,2,2,3,2,
   3,2,3,3,3,2,3,2,2,2,2,2,3,0,0,0,0,2,0,0,0,
  3,3,3,3,3,3,2,3,0,3,3,2,2,2,2,3,2,0,3,0,
   3,2,2,0,2,2,2,2,3,0,0,0,2,2,0,0,2,2,2,0,0,
  0,0,3,0,0,3,3,3,2,3,3,0,3,3,3,0,3,3,0,3,
   0,2,2,0,0,2,3,2,0,3,2,0,0,0,0,2,0,0,0,0,0,
  3,3,3,3,3,3,2,3,3,2,3,3,3,3,2,3,3,3,3,2,
   3,2,2,0,2,2,0,2,2,2,0,0,2,2,0,2,0,2,0,0,0,
  2,2,3,2,2,3,3,3,3,2,3,0,3,2,3,2,3,3,0,3,
   0,2,3,0,0,2,3,2,0,3,2,2,0,2,0,0,0,0,2,0,0,
  2,3,3,3,3,2,3,2,2,2,2,3,2,3,2,2,3,2,3,2,
   0,2,2,0,0,2,0,0,0,3,2,0,2,2,0,2,0,2,0,2,0,
  3,3,3,3,3,3,3,3,0,3,3,3,2,2,2,3,2,2,3,2,
   3,3,2,3,2,2,0,2,3,2,0,0,2,0,2,2,0,2,0,0,0,
  0,0,3,2,0,3,3,2,3,3,3,0,3,3,3,0,2,3,0,2,
   0,3,0,0,0,2,3,3,0,3,0,0,0,0,0,2,0,0,2,2,0,
  2,0,3,0,0,3,2,2,2,2,2,0,3,2,0,0,3,3,0,2,
   0,0,0,0,0,3,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,2,0,0,2,3,3,3,0,2,3,0,0,3,0,
   0,0,3,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,
  3,3,3,2,3,2,2,0,0,2,2,3,2,3,2,2,2,0,3,0,
   0,0,2,0,0,0,0,0,0,2,0,0,2,0,0,2,0,0,0,2,0,
  2,3,2,3,3,0,2,0,0,0,0,3,2,0,0,2,0,0,2,2,
   0,0,2,0,0,2,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,
  0,0,2,0,0,3,3,3,2,3,2,0,2,2,3,2,3,2,0,3,
   0,2,3,0,0,2,2,2,0,3,2,0,0,0,0,0,0,0,0,0,0,
  2,3,3,3,3,3,2,2,2,0,3,3,3,0,0,3,0,0,2,0,
   0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,2,0,0,
  3,3,2,3,3,2,2,0,2,3,3,2,0,2,2,3,2,0,2,2,
   3,0,0,0,2,0,0,0,2,0,2,0,2,2,0,0,0,2,0,0,0,
  3,3,3,3,3,2,2,2,2,3,3,0,0,2,2,3,2,2,2,0,
   2,0,0,0,2,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,
  0,0,2,2,0,0,3,3,0,2,2,0,2,2,2,0,3,2,0,3,
   0,2,2,0,0,2,3,2,0,0,0,0,0,0,0,2,0,0,0,0,0,
  0,0,2,0,0,2,3,2,2,2,2,0,2,2,2,0,2,2,0,3,
   0,2,2,0,0,3,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,
  2,2,2,2,3,3,0,0,2,2,2,2,2,2,2,2,2,0,2,0,
   2,0,0,0,0,0,0,0,0,0,2,0,2,0,2,0,2,0,0,0,0,
  2,0,0,0,0,0,2,0,0,0,0,0,2,0,0,3,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,
  2,2,2,2,3,0,2,0,0,0,2,0,2,0,2,2,0,2,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,
  0,0,2,0,0,0,2,0,0,0,2,0,0,2,0,0,2,0,0,3,
   0,0,2,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,
  2,0,0,2,0,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,0,0,2,0,2,0,0,0,0,0,0,0,0,0,2,2,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Iso_8859_2CzechModel =
{
  Iso_8859_2_CharToOrderMap,
  CzechLangModel,
  41,
  (float)0.9775196375975984,
  PR_TRUE,
  "ISO-8859-2"
};

const SequenceModel Windows_1250CzechModel =
{
  Windows_1250_CharToOrderMap,
  CzechLangModel,
  41,
  (float)0.9775196375975984,
  PR_TRUE,
  "WINDOWS-1250"
};

const SequenceModel Ibm852CzechModel =
{
  Ibm852_CharToOrderMap,
  CzechLangModel,
  41,
  (float)0.9775196375975984,
  PR_TRUE,
  "IBM852"
};

const SequenceModel MaccentraleuropeCzechModel =
{
  Maccentraleurope_CharToOrderMap,
  CzechLangModel,
  41,
  (float)0.9775196375975984,
  PR_TRUE,
  "MacCentralEurope"
};