/*!
 * Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  const bokeh = factory();
  if (root.Bokeh === undefined) {
    root.Bokeh = bokeh;
  }
  const Bokeh = root.Bokeh;
  Bokeh[bokeh.version] = bokeh;
})(this, function() {
  var define;
  var parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
    if (aliases === undefined) aliases = {};
    if (externals === undefined) externals = {};

    var cache = {};

    var normalize = function(name) {
      if (typeof name === "number")
        return name;

      if (name === "bokehjs")
        return entry;

      var prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)

      var alias = aliases[name]
      if (alias != null)
        return alias;

      var trailing = name.length > 0 && name[name.lenght-1] === "/";
      var index = aliases[name + (trailing ? "" : "/") + "index"];
      if (index != null)
        return index;

      return name;
    }

    var require = function(name) {
      var mod = cache[name];
      if (!mod) {
        var id = normalize(name);

        mod = cache[id];
        if (!mod) {
          if (!modules[id]) {
            if (externals[id] === false || (externals[id] == true && parent_require)) {
              try {
                mod = {exports: externals[id] ? parent_require(id) : {}};
                cache[id] = cache[name] = mod;
                return mod.exports;
              } catch (e) {}
            }

            var err = new Error("Cannot find module '" + name + "'");
            err.code = 'MODULE_NOT_FOUND';
            throw err;
          }

          mod = {exports: {}};
          cache[id] = cache[name] = mod;
          modules[id].call(mod.exports, require, mod, mod.exports);
        } else
          cache[name] = mod;
      }

      return mod.exports;
    }

    var main = require(entry);
    main.require = require;

    if (typeof Proxy !== "undefined") {
      // allow Bokeh.loader["@bokehjs/module/name"] syntax
      main.loader = new Proxy({}, {
        get: function(_obj, module) {
          return require(module);
        }
      });
    }

    main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
      if (plugin_aliases === undefined) plugin_aliases = {};
      if (plugin_externals === undefined) plugin_externals = {};

      for (var name in plugin_modules) {
        modules[name] = plugin_modules[name];
      }

      for (var name in plugin_aliases) {
        aliases[name] = plugin_aliases[name];
      }

      for (var name in plugin_externals) {
        externals[name] = plugin_externals[name];
      }

      var plugin = require(plugin_entry);

      for (var name in plugin) {
        main[name] = plugin[name];
      }

      return plugin;
    }

    return main;
  })
([
/* main.js */ function _(require, module, exports) {
    var __asyncValues = (this && this.__asyncValues) || function (o) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function (v) { resolve({ value: v, done: d }); }, reject); }
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    const yargs_1 = require(1) /* yargs */;
    const path_1 = require("path");
    const sys_1 = require(43) /* ./sys */;
    const build_1 = require(58) /* ./build */;
    const compile_1 = require(823) /* ./compile */;
    async function read_stdin() {
        var e_1, _a;
        const stdin = process.stdin;
        stdin.setEncoding("utf-8");
        stdin.resume();
        let data = "";
        try {
            for (var stdin_1 = __asyncValues(stdin), stdin_1_1; stdin_1_1 = await stdin_1.next(), !stdin_1_1.done;) {
                const chunk = stdin_1_1.value;
                data += chunk;
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (stdin_1_1 && !stdin_1_1.done && (_a = stdin_1.return))
                    await _a.call(stdin_1);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        return data;
    }
    function reply(data) {
        process.stdout.write(JSON.stringify(data));
        process.stdout.write("\n");
    }
    async function compile() {
        if (yargs_1.argv.file != null) {
            const input = {
                code: yargs_1.argv.code != null ? yargs_1.argv.code : sys_1.read(yargs_1.argv.file),
                lang: yargs_1.argv.lang || "typescript",
                file: yargs_1.argv.file,
                bokehjs_dir: yargs_1.argv.bokehjsDir || "./build",
            };
            return await compile_1.compile_and_resolve_deps(input);
        }
        else {
            const input = JSON.parse(await read_stdin());
            return await compile_1.compile_and_resolve_deps(input);
        }
    }
    async function main() {
        const cmd = yargs_1.argv._[0];
        if (cmd == "build") {
            try {
                const base_dir = path_1.resolve(yargs_1.argv.baseDir);
                const bokehjs_dir = path_1.resolve(yargs_1.argv.bokehjsDir);
                const rebuild = yargs_1.argv.rebuild;
                const bokeh_version = yargs_1.argv.bokehVersion;
                const result = await build_1.build(base_dir, bokehjs_dir, { rebuild, bokeh_version });
                process.exit(result ? 0 : 1);
            }
            catch (error) {
                console.log(error.stack);
                process.exit(1);
            }
        }
        else if (cmd == "init") {
            try {
                const base_dir = path_1.resolve(yargs_1.argv.baseDir);
                const bokehjs_dir = path_1.resolve(yargs_1.argv.bokehjsDir);
                const interactive = yargs_1.argv.interactive;
                const bokehjs_version = yargs_1.argv.bokehjsVersion;
                const bokeh_version = yargs_1.argv.bokehVersion;
                const result = await build_1.init(base_dir, bokehjs_dir, { interactive, bokehjs_version, bokeh_version });
                process.exit(result ? 0 : 1);
            }
            catch (error) {
                console.log(error.stack);
                process.exit(1);
            }
        }
        else {
            try {
                reply(await compile());
            }
            catch (error) {
                reply({ error: error.stack });
            }
        }
    }
    main();
},
/* yargs/index.js */ function _(require, module, exports) {
    // classic singleton yargs API, to use yargs
    // without running as a singleton do:
    // require('yargs/yargs')(process.argv.slice(2))
    const yargs = require(2) /* ./yargs */;
    const processArgv = require(34) /* ./lib/process-argv */;
    Argv(processArgv.getProcessArgvWithoutBin());
    module.exports = Argv;
    function Argv(processArgs, cwd) {
        const argv = yargs(processArgs, cwd, require);
        singletonify(argv);
        return argv;
    }
    /*  Hack an instance of Argv with process.argv into Argv
        so people can do
        require('yargs')(['--beeble=1','-z','zizzle']).argv
        to parse a list of args and
        require('yargs').argv
        to get a parsed version of process.argv.
    */
    function singletonify(inst) {
        Object.keys(inst).forEach((key) => {
            if (key === 'argv') {
                Argv.__defineGetter__(key, inst.__lookupGetter__(key));
            }
            else if (typeof inst[key] === 'function') {
                Argv[key] = inst[key].bind(inst);
            }
            else {
                Argv.__defineGetter__('$0', () => {
                    return inst.$0;
                });
                Argv.__defineGetter__('parsed', () => {
                    return inst.parsed;
                });
            }
        });
    }
},
/* yargs/yargs.js */ function _(require, module, exports) {
    // an async function fails early in Node.js versions prior to 8.
    async function requiresNode8OrGreater() { }
    requiresNode8OrGreater();
    const argsert = require(3) /* ./lib/argsert */;
    const fs = require('fs');
    const Command = require(4) /* ./lib/command */;
    const Completion = require(14) /* ./lib/completion */;
    const Parser = require(7) /* yargs-parser */;
    const path = require('path');
    const Usage = require(16) /* ./lib/usage */;
    const Validation = require(30) /* ./lib/validation */;
    const Y18n = require(32) /* y18n */;
    const objFilter = require(21) /* ./lib/obj-filter */;
    const setBlocking = require(22) /* set-blocking */;
    const applyExtends = require(33) /* ./lib/apply-extends */;
    const { globalMiddlewareFactory } = require(6) /* ./lib/middleware */;
    const YError = require(13) /* ./lib/yerror */;
    const processArgv = require(34) /* ./lib/process-argv */;
    exports = module.exports = Yargs;
    function Yargs(processArgs, cwd, parentRequire) {
        processArgs = processArgs || []; // handle calling yargs().
        const self = {};
        let command = null;
        let completion = null;
        let groups = {};
        const globalMiddleware = [];
        let output = '';
        const preservedGroups = {};
        let usage = null;
        let validation = null;
        let handlerFinishCommand = null;
        const y18n = Y18n({
            directory: path.resolve(__dirname, './locales'),
            updateFiles: false
        });
        self.middleware = globalMiddlewareFactory(globalMiddleware, self);
        if (!cwd)
            cwd = process.cwd();
        self.scriptName = function (scriptName) {
            self.customScriptName = true;
            self.$0 = scriptName;
            return self;
        };
        // ignore the node bin, specify this in your
        // bin file with #!/usr/bin/env node
        if (/\b(node|iojs|electron)(\.exe)?$/.test(process.argv[0])) {
            self.$0 = process.argv.slice(1, 2);
        }
        else {
            self.$0 = process.argv.slice(0, 1);
        }
        self.$0 = self.$0
            .map((x, i) => {
            const b = rebase(cwd, x);
            return x.match(/^(\/|([a-zA-Z]:)?\\)/) && b.length < x.length ? b : x;
        })
            .join(' ').trim();
        if (process.env._ !== undefined && processArgv.getProcessArgvBin() === process.env._) {
            self.$0 = process.env._.replace(`${path.dirname(process.execPath)}/`, '');
        }
        // use context object to keep track of resets, subcommand execution, etc
        // submodules should modify and check the state of context as necessary
        const context = { resets: -1, commands: [], fullCommands: [], files: [] };
        self.getContext = () => context;
        // puts yargs back into an initial state. any keys
        // that have been set to "global" will not be reset
        // by this action.
        let options;
        self.resetOptions = self.reset = function resetOptions(aliases) {
            context.resets++;
            aliases = aliases || {};
            options = options || {};
            // put yargs back into an initial state, this
            // logic is used to build a nested command
            // hierarchy.
            const tmpOptions = {};
            tmpOptions.local = options.local ? options.local : [];
            tmpOptions.configObjects = options.configObjects ? options.configObjects : [];
            // if a key has been explicitly set as local,
            // we should reset it before passing options to command.
            const localLookup = {};
            tmpOptions.local.forEach((l) => {
                localLookup[l] = true;
                (aliases[l] || []).forEach((a) => {
                    localLookup[a] = true;
                });
            });
            // add all groups not set to local to preserved groups
            Object.assign(preservedGroups, Object.keys(groups).reduce((acc, groupName) => {
                const keys = groups[groupName].filter(key => !(key in localLookup));
                if (keys.length > 0) {
                    acc[groupName] = keys;
                }
                return acc;
            }, {}));
            // groups can now be reset
            groups = {};
            const arrayOptions = [
                'array', 'boolean', 'string', 'skipValidation',
                'count', 'normalize', 'number',
                'hiddenOptions'
            ];
            const objectOptions = [
                'narg', 'key', 'alias', 'default', 'defaultDescription',
                'config', 'choices', 'demandedOptions', 'demandedCommands', 'coerce',
                'deprecatedOptions'
            ];
            arrayOptions.forEach((k) => {
                tmpOptions[k] = (options[k] || []).filter(k => !localLookup[k]);
            });
            objectOptions.forEach((k) => {
                tmpOptions[k] = objFilter(options[k], (k, v) => !localLookup[k]);
            });
            tmpOptions.envPrefix = options.envPrefix;
            options = tmpOptions;
            // if this is the first time being executed, create
            // instances of all our helpers -- otherwise just reset.
            usage = usage ? usage.reset(localLookup) : Usage(self, y18n);
            validation = validation ? validation.reset(localLookup) : Validation(self, usage, y18n);
            command = command ? command.reset() : Command(self, usage, validation, globalMiddleware);
            if (!completion)
                completion = Completion(self, usage, command);
            completionCommand = null;
            output = '';
            exitError = null;
            hasOutput = false;
            self.parsed = false;
            return self;
        };
        self.resetOptions();
        // temporary hack: allow "freezing" of reset-able state for parse(msg, cb)
        const frozens = [];
        function freeze() {
            const frozen = {};
            frozens.push(frozen);
            frozen.options = options;
            frozen.configObjects = options.configObjects.slice(0);
            frozen.exitProcess = exitProcess;
            frozen.groups = groups;
            usage.freeze();
            validation.freeze();
            command.freeze();
            frozen.strict = strict;
            frozen.strictCommands = strictCommands;
            frozen.completionCommand = completionCommand;
            frozen.output = output;
            frozen.exitError = exitError;
            frozen.hasOutput = hasOutput;
            frozen.parsed = self.parsed;
            frozen.parseFn = parseFn;
            frozen.parseContext = parseContext;
            frozen.handlerFinishCommand = handlerFinishCommand;
        }
        function unfreeze() {
            const frozen = frozens.pop();
            options = frozen.options;
            options.configObjects = frozen.configObjects;
            exitProcess = frozen.exitProcess;
            groups = frozen.groups;
            output = frozen.output;
            exitError = frozen.exitError;
            hasOutput = frozen.hasOutput;
            self.parsed = frozen.parsed;
            usage.unfreeze();
            validation.unfreeze();
            command.unfreeze();
            strict = frozen.strict;
            strictCommands = frozen.strictCommands;
            completionCommand = frozen.completionCommand;
            parseFn = frozen.parseFn;
            parseContext = frozen.parseContext;
            handlerFinishCommand = frozen.handlerFinishCommand;
        }
        self.boolean = function (keys) {
            argsert('<array|string>', [keys], arguments.length);
            populateParserHintArray('boolean', keys);
            return self;
        };
        self.array = function (keys) {
            argsert('<array|string>', [keys], arguments.length);
            populateParserHintArray('array', keys);
            return self;
        };
        self.number = function (keys) {
            argsert('<array|string>', [keys], arguments.length);
            populateParserHintArray('number', keys);
            return self;
        };
        self.normalize = function (keys) {
            argsert('<array|string>', [keys], arguments.length);
            populateParserHintArray('normalize', keys);
            return self;
        };
        self.count = function (keys) {
            argsert('<array|string>', [keys], arguments.length);
            populateParserHintArray('count', keys);
            return self;
        };
        self.string = function (keys) {
            argsert('<array|string>', [keys], arguments.length);
            populateParserHintArray('string', keys);
            return self;
        };
        self.requiresArg = function (keys, value) {
            argsert('<array|string|object> [number]', [keys], arguments.length);
            // If someone configures nargs at the same time as requiresArg,
            // nargs should take precedent,
            // see: https://github.com/yargs/yargs/pull/1572
            // TODO: make this work with aliases, using a check similar to
            // checkAllAliases() in yargs-parser.
            if (typeof keys === 'string' && options.narg[keys]) {
                return self;
            }
            else {
                populateParserHintObject(self.requiresArg, false, 'narg', keys, NaN);
            }
            return self;
        };
        self.skipValidation = function (keys) {
            argsert('<array|string>', [keys], arguments.length);
            populateParserHintArray('skipValidation', keys);
            return self;
        };
        function populateParserHintArray(type, keys, value) {
            keys = [].concat(keys);
            keys.forEach((key) => {
                key = sanitizeKey(key);
                options[type].push(key);
            });
        }
        self.nargs = function (key, value) {
            argsert('<string|object|array> [number]', [key, value], arguments.length);
            populateParserHintObject(self.nargs, false, 'narg', key, value);
            return self;
        };
        self.choices = function (key, value) {
            argsert('<object|string|array> [string|array]', [key, value], arguments.length);
            populateParserHintObject(self.choices, true, 'choices', key, value);
            return self;
        };
        self.alias = function (key, value) {
            argsert('<object|string|array> [string|array]', [key, value], arguments.length);
            populateParserHintObject(self.alias, true, 'alias', key, value);
            return self;
        };
        // TODO: actually deprecate self.defaults.
        self.default = self.defaults = function (key, value, defaultDescription) {
            argsert('<object|string|array> [*] [string]', [key, value, defaultDescription], arguments.length);
            if (defaultDescription)
                options.defaultDescription[key] = defaultDescription;
            if (typeof value === 'function') {
                if (!options.defaultDescription[key])
                    options.defaultDescription[key] = usage.functionDescription(value);
                value = value.call();
            }
            populateParserHintObject(self.default, false, 'default', key, value);
            return self;
        };
        self.describe = function (key, desc) {
            argsert('<object|string|array> [string]', [key, desc], arguments.length);
            populateParserHintObject(self.describe, false, 'key', key, true);
            usage.describe(key, desc);
            return self;
        };
        self.demandOption = function (keys, msg) {
            argsert('<object|string|array> [string]', [keys, msg], arguments.length);
            populateParserHintObject(self.demandOption, false, 'demandedOptions', keys, msg);
            return self;
        };
        self.coerce = function (keys, value) {
            argsert('<object|string|array> [function]', [keys, value], arguments.length);
            populateParserHintObject(self.coerce, false, 'coerce', keys, value);
            return self;
        };
        function populateParserHintObject(builder, isArray, type, key, value) {
            if (Array.isArray(key)) {
                const temp = Object.create(null);
                // an array of keys with one value ['x', 'y', 'z'], function parse () {}
                key.forEach((k) => {
                    temp[k] = value;
                });
                builder(temp);
            }
            else if (typeof key === 'object') {
                // an object of key value pairs: {'x': parse () {}, 'y': parse() {}}
                Object.keys(key).forEach((k) => {
                    builder(k, key[k]);
                });
            }
            else {
                key = sanitizeKey(key);
                // a single key value pair 'x', parse() {}
                if (isArray) {
                    options[type][key] = (options[type][key] || []).concat(value);
                }
                else {
                    options[type][key] = value;
                }
            }
        }
        // TODO(bcoe): in future major versions move more objects towards
        // Object.create(null):
        function sanitizeKey(key) {
            if (key === '__proto__')
                return '___proto___';
            return key;
        }
        function deleteFromParserHintObject(optionKey) {
            // delete from all parsing hints:
            // boolean, array, key, alias, etc.
            Object.keys(options).forEach((hintKey) => {
                const hint = options[hintKey];
                if (Array.isArray(hint)) {
                    if (~hint.indexOf(optionKey))
                        hint.splice(hint.indexOf(optionKey), 1);
                }
                else if (typeof hint === 'object') {
                    delete hint[optionKey];
                }
            });
            // now delete the description from usage.js.
            delete usage.getDescriptions()[optionKey];
        }
        self.config = function config(key, msg, parseFn) {
            argsert('[object|string] [string|function] [function]', [key, msg, parseFn], arguments.length);
            // allow a config object to be provided directly.
            if (typeof key === 'object') {
                key = applyExtends(key, cwd, self.getParserConfiguration()['deep-merge-config']);
                options.configObjects = (options.configObjects || []).concat(key);
                return self;
            }
            // allow for a custom parsing function.
            if (typeof msg === 'function') {
                parseFn = msg;
                msg = null;
            }
            key = key || 'config';
            self.describe(key, msg || usage.deferY18nLookup('Path to JSON config file'));
            (Array.isArray(key) ? key : [key]).forEach((k) => {
                options.config[k] = parseFn || true;
            });
            return self;
        };
        self.example = function (cmd, description) {
            argsert('<string> [string]', [cmd, description], arguments.length);
            usage.example(cmd, description);
            return self;
        };
        self.command = function (cmd, description, builder, handler, middlewares) {
            argsert('<string|array|object> [string|boolean] [function|object] [function] [array]', [cmd, description, builder, handler, middlewares], arguments.length);
            command.addHandler(cmd, description, builder, handler, middlewares);
            return self;
        };
        self.commandDir = function (dir, opts) {
            argsert('<string> [object]', [dir, opts], arguments.length);
            const req = parentRequire || require;
            command.addDirectory(dir, self.getContext(), req, require(35) /* get-caller-file */(), opts);
            return self;
        };
        // TODO: deprecate self.demand in favor of
        // .demandCommand() .demandOption().
        self.demand = self.required = self.require = function demand(keys, max, msg) {
            // you can optionally provide a 'max' key,
            // which will raise an exception if too many '_'
            // options are provided.
            if (Array.isArray(max)) {
                max.forEach((key) => {
                    self.demandOption(key, msg);
                });
                max = Infinity;
            }
            else if (typeof max !== 'number') {
                msg = max;
                max = Infinity;
            }
            if (typeof keys === 'number') {
                self.demandCommand(keys, max, msg, msg);
            }
            else if (Array.isArray(keys)) {
                keys.forEach((key) => {
                    self.demandOption(key, msg);
                });
            }
            else {
                if (typeof msg === 'string') {
                    self.demandOption(keys, msg);
                }
                else if (msg === true || typeof msg === 'undefined') {
                    self.demandOption(keys);
                }
            }
            return self;
        };
        self.demandCommand = function demandCommand(min, max, minMsg, maxMsg) {
            argsert('[number] [number|string] [string|null|undefined] [string|null|undefined]', [min, max, minMsg, maxMsg], arguments.length);
            if (typeof min === 'undefined')
                min = 1;
            if (typeof max !== 'number') {
                minMsg = max;
                max = Infinity;
            }
            self.global('_', false);
            options.demandedCommands._ = {
                min,
                max,
                minMsg,
                maxMsg
            };
            return self;
        };
        self.getDemandedOptions = () => {
            argsert([], 0);
            return options.demandedOptions;
        };
        self.getDemandedCommands = () => {
            argsert([], 0);
            return options.demandedCommands;
        };
        self.deprecateOption = function deprecateOption(option, message) {
            argsert('<string> [string|boolean]', [option, message], arguments.length);
            options.deprecatedOptions[option] = message;
            return self;
        };
        self.getDeprecatedOptions = () => {
            argsert([], 0);
            return options.deprecatedOptions;
        };
        self.implies = function (key, value) {
            argsert('<string|object> [number|string|array]', [key, value], arguments.length);
            validation.implies(key, value);
            return self;
        };
        self.conflicts = function (key1, key2) {
            argsert('<string|object> [string|array]', [key1, key2], arguments.length);
            validation.conflicts(key1, key2);
            return self;
        };
        self.usage = function (msg, description, builder, handler) {
            argsert('<string|null|undefined> [string|boolean] [function|object] [function]', [msg, description, builder, handler], arguments.length);
            if (description !== undefined) {
                // .usage() can be used as an alias for defining
                // a default command.
                if ((msg || '').match(/^\$0( |$)/)) {
                    return self.command(msg, description, builder, handler);
                }
                else {
                    throw new YError('.usage() description must start with $0 if being used as alias for .command()');
                }
            }
            else {
                usage.usage(msg);
                return self;
            }
        };
        self.epilogue = self.epilog = function (msg) {
            argsert('<string>', [msg], arguments.length);
            usage.epilog(msg);
            return self;
        };
        self.fail = function (f) {
            argsert('<function>', [f], arguments.length);
            usage.failFn(f);
            return self;
        };
        self.onFinishCommand = function (f) {
            argsert('<function>', [f], arguments.length);
            handlerFinishCommand = f;
            return self;
        };
        self.getHandlerFinishCommand = () => handlerFinishCommand;
        self.check = function (f, _global) {
            argsert('<function> [boolean]', [f, _global], arguments.length);
            validation.check(f, _global !== false);
            return self;
        };
        self.global = function global(globals, global) {
            argsert('<string|array> [boolean]', [globals, global], arguments.length);
            globals = [].concat(globals);
            if (global !== false) {
                options.local = options.local.filter(l => globals.indexOf(l) === -1);
            }
            else {
                globals.forEach((g) => {
                    if (options.local.indexOf(g) === -1)
                        options.local.push(g);
                });
            }
            return self;
        };
        self.pkgConf = function pkgConf(key, rootPath) {
            argsert('<string> [string]', [key, rootPath], arguments.length);
            let conf = null;
            // prefer cwd to require-main-filename in this method
            // since we're looking for e.g. "nyc" config in nyc consumer
            // rather than "yargs" config in nyc (where nyc is the main filename)
            const obj = pkgUp(rootPath || cwd);
            // If an object exists in the key, add it to options.configObjects
            if (obj[key] && typeof obj[key] === 'object') {
                conf = applyExtends(obj[key], rootPath || cwd, self.getParserConfiguration()['deep-merge-config']);
                options.configObjects = (options.configObjects || []).concat(conf);
            }
            return self;
        };
        const pkgs = {};
        function pkgUp(rootPath) {
            const npath = rootPath || '*';
            if (pkgs[npath])
                return pkgs[npath];
            const findUp = require(36) /* find-up */;
            let obj = {};
            try {
                let startDir = rootPath || require(42) /* require-main-filename */(parentRequire || require);
                // When called in an environment that lacks require.main.filename, such as a jest test runner,
                // startDir is already process.cwd(), and should not be shortened.
                // Whether or not it is _actually_ a directory (e.g., extensionless bin) is irrelevant, find-up handles it.
                if (!rootPath && path.extname(startDir)) {
                    startDir = path.dirname(startDir);
                }
                const pkgJsonPath = findUp.sync('package.json', {
                    cwd: startDir
                });
                obj = JSON.parse(fs.readFileSync(pkgJsonPath));
            }
            catch (noop) { }
            pkgs[npath] = obj || {};
            return pkgs[npath];
        }
        let parseFn = null;
        let parseContext = null;
        self.parse = function parse(args, shortCircuit, _parseFn) {
            argsert('[string|array] [function|boolean|object] [function]', [args, shortCircuit, _parseFn], arguments.length);
            freeze();
            if (typeof args === 'undefined') {
                const argv = self._parseArgs(processArgs);
                const tmpParsed = self.parsed;
                unfreeze();
                // TODO: remove this compatibility hack when we release yargs@15.x:
                self.parsed = tmpParsed;
                return argv;
            }
            // a context object can optionally be provided, this allows
            // additional information to be passed to a command handler.
            if (typeof shortCircuit === 'object') {
                parseContext = shortCircuit;
                shortCircuit = _parseFn;
            }
            // by providing a function as a second argument to
            // parse you can capture output that would otherwise
            // default to printing to stdout/stderr.
            if (typeof shortCircuit === 'function') {
                parseFn = shortCircuit;
                shortCircuit = null;
            }
            // completion short-circuits the parsing process,
            // skipping validation, etc.
            if (!shortCircuit)
                processArgs = args;
            if (parseFn)
                exitProcess = false;
            const parsed = self._parseArgs(args, shortCircuit);
            completion.setParsed(self.parsed);
            if (parseFn)
                parseFn(exitError, parsed, output);
            unfreeze();
            return parsed;
        };
        self._getParseContext = () => parseContext || {};
        self._hasParseCallback = () => !!parseFn;
        self.option = self.options = function option(key, opt) {
            argsert('<string|object> [object]', [key, opt], arguments.length);
            if (typeof key === 'object') {
                Object.keys(key).forEach((k) => {
                    self.options(k, key[k]);
                });
            }
            else {
                if (typeof opt !== 'object') {
                    opt = {};
                }
                options.key[key] = true; // track manually set keys.
                if (opt.alias)
                    self.alias(key, opt.alias);
                const deprecate = opt.deprecate || opt.deprecated;
                if (deprecate) {
                    self.deprecateOption(key, deprecate);
                }
                const demand = opt.demand || opt.required || opt.require;
                // A required option can be specified via "demand: true".
                if (demand) {
                    self.demand(key, demand);
                }
                if (opt.demandOption) {
                    self.demandOption(key, typeof opt.demandOption === 'string' ? opt.demandOption : undefined);
                }
                if ('conflicts' in opt) {
                    self.conflicts(key, opt.conflicts);
                }
                if ('default' in opt) {
                    self.default(key, opt.default);
                }
                if ('implies' in opt) {
                    self.implies(key, opt.implies);
                }
                if ('nargs' in opt) {
                    self.nargs(key, opt.nargs);
                }
                if (opt.config) {
                    self.config(key, opt.configParser);
                }
                if (opt.normalize) {
                    self.normalize(key);
                }
                if ('choices' in opt) {
                    self.choices(key, opt.choices);
                }
                if ('coerce' in opt) {
                    self.coerce(key, opt.coerce);
                }
                if ('group' in opt) {
                    self.group(key, opt.group);
                }
                if (opt.boolean || opt.type === 'boolean') {
                    self.boolean(key);
                    if (opt.alias)
                        self.boolean(opt.alias);
                }
                if (opt.array || opt.type === 'array') {
                    self.array(key);
                    if (opt.alias)
                        self.array(opt.alias);
                }
                if (opt.number || opt.type === 'number') {
                    self.number(key);
                    if (opt.alias)
                        self.number(opt.alias);
                }
                if (opt.string || opt.type === 'string') {
                    self.string(key);
                    if (opt.alias)
                        self.string(opt.alias);
                }
                if (opt.count || opt.type === 'count') {
                    self.count(key);
                }
                if (typeof opt.global === 'boolean') {
                    self.global(key, opt.global);
                }
                if (opt.defaultDescription) {
                    options.defaultDescription[key] = opt.defaultDescription;
                }
                if (opt.skipValidation) {
                    self.skipValidation(key);
                }
                const desc = opt.describe || opt.description || opt.desc;
                self.describe(key, desc);
                if (opt.hidden) {
                    self.hide(key);
                }
                if (opt.requiresArg) {
                    self.requiresArg(key);
                }
            }
            return self;
        };
        self.getOptions = () => options;
        self.positional = function (key, opts) {
            argsert('<string> <object>', [key, opts], arguments.length);
            if (context.resets === 0) {
                throw new YError(".positional() can only be called in a command's builder function");
            }
            // .positional() only supports a subset of the configuration
            // options available to .option().
            const supportedOpts = ['default', 'defaultDescription', 'implies', 'normalize',
                'choices', 'conflicts', 'coerce', 'type', 'describe',
                'desc', 'description', 'alias'];
            opts = objFilter(opts, (k, v) => {
                let accept = supportedOpts.indexOf(k) !== -1;
                // type can be one of string|number|boolean.
                if (k === 'type' && ['string', 'number', 'boolean'].indexOf(v) === -1)
                    accept = false;
                return accept;
            });
            // copy over any settings that can be inferred from the command string.
            const fullCommand = context.fullCommands[context.fullCommands.length - 1];
            const parseOptions = fullCommand ? command.cmdToParseOptions(fullCommand) : {
                array: [],
                alias: {},
                default: {},
                demand: {}
            };
            Object.keys(parseOptions).forEach((pk) => {
                if (Array.isArray(parseOptions[pk])) {
                    if (parseOptions[pk].indexOf(key) !== -1)
                        opts[pk] = true;
                }
                else {
                    if (parseOptions[pk][key] && !(pk in opts))
                        opts[pk] = parseOptions[pk][key];
                }
            });
            self.group(key, usage.getPositionalGroupName());
            return self.option(key, opts);
        };
        self.group = function group(opts, groupName) {
            argsert('<string|array> <string>', [opts, groupName], arguments.length);
            const existing = preservedGroups[groupName] || groups[groupName];
            if (preservedGroups[groupName]) {
                // we now only need to track this group name in groups.
                delete preservedGroups[groupName];
            }
            const seen = {};
            groups[groupName] = (existing || []).concat(opts).filter((key) => {
                if (seen[key])
                    return false;
                return (seen[key] = true);
            });
            return self;
        };
        // combine explicit and preserved groups. explicit groups should be first
        self.getGroups = () => Object.assign({}, groups, preservedGroups);
        // as long as options.envPrefix is not undefined,
        // parser will apply env vars matching prefix to argv
        self.env = function (prefix) {
            argsert('[string|boolean]', [prefix], arguments.length);
            if (prefix === false)
                options.envPrefix = undefined;
            else
                options.envPrefix = prefix || '';
            return self;
        };
        self.wrap = function (cols) {
            argsert('<number|null|undefined>', [cols], arguments.length);
            usage.wrap(cols);
            return self;
        };
        let strict = false;
        self.strict = function (enabled) {
            argsert('[boolean]', [enabled], arguments.length);
            strict = enabled !== false;
            return self;
        };
        self.getStrict = () => strict;
        let strictCommands = false;
        self.strictCommands = function (enabled) {
            argsert('[boolean]', [enabled], arguments.length);
            strictCommands = enabled !== false;
            return self;
        };
        self.getStrictCommands = () => strictCommands;
        let parserConfig = {};
        self.parserConfiguration = function parserConfiguration(config) {
            argsert('<object>', [config], arguments.length);
            parserConfig = config;
            return self;
        };
        self.getParserConfiguration = () => parserConfig;
        self.showHelp = function (level) {
            argsert('[string|function]', [level], arguments.length);
            if (!self.parsed)
                self._parseArgs(processArgs); // run parser, if it has not already been executed.
            if (command.hasDefaultCommand()) {
                context.resets++; // override the restriction on top-level positoinals.
                command.runDefaultBuilderOn(self, true);
            }
            usage.showHelp(level);
            return self;
        };
        let versionOpt = null;
        self.version = function version(opt, msg, ver) {
            const defaultVersionOpt = 'version';
            argsert('[boolean|string] [string] [string]', [opt, msg, ver], arguments.length);
            // nuke the key previously configured
            // to return version #.
            if (versionOpt) {
                deleteFromParserHintObject(versionOpt);
                usage.version(undefined);
                versionOpt = null;
            }
            if (arguments.length === 0) {
                ver = guessVersion();
                opt = defaultVersionOpt;
            }
            else if (arguments.length === 1) {
                if (opt === false) { // disable default 'version' key.
                    return self;
                }
                ver = opt;
                opt = defaultVersionOpt;
            }
            else if (arguments.length === 2) {
                ver = msg;
                msg = null;
            }
            versionOpt = typeof opt === 'string' ? opt : defaultVersionOpt;
            msg = msg || usage.deferY18nLookup('Show version number');
            usage.version(ver || undefined);
            self.boolean(versionOpt);
            self.describe(versionOpt, msg);
            return self;
        };
        function guessVersion() {
            const obj = pkgUp();
            return obj.version || 'unknown';
        }
        let helpOpt = null;
        self.addHelpOpt = self.help = function addHelpOpt(opt, msg) {
            const defaultHelpOpt = 'help';
            argsert('[string|boolean] [string]', [opt, msg], arguments.length);
            // nuke the key previously configured
            // to return help.
            if (helpOpt) {
                deleteFromParserHintObject(helpOpt);
                helpOpt = null;
            }
            if (arguments.length === 1) {
                if (opt === false)
                    return self;
            }
            // use arguments, fallback to defaults for opt and msg
            helpOpt = typeof opt === 'string' ? opt : defaultHelpOpt;
            self.boolean(helpOpt);
            self.describe(helpOpt, msg || usage.deferY18nLookup('Show help'));
            return self;
        };
        const defaultShowHiddenOpt = 'show-hidden';
        options.showHiddenOpt = defaultShowHiddenOpt;
        self.addShowHiddenOpt = self.showHidden = function addShowHiddenOpt(opt, msg) {
            argsert('[string|boolean] [string]', [opt, msg], arguments.length);
            if (arguments.length === 1) {
                if (opt === false)
                    return self;
            }
            const showHiddenOpt = typeof opt === 'string' ? opt : defaultShowHiddenOpt;
            self.boolean(showHiddenOpt);
            self.describe(showHiddenOpt, msg || usage.deferY18nLookup('Show hidden options'));
            options.showHiddenOpt = showHiddenOpt;
            return self;
        };
        self.hide = function hide(key) {
            argsert('<string|object>', [key], arguments.length);
            options.hiddenOptions.push(key);
            return self;
        };
        self.showHelpOnFail = function showHelpOnFail(enabled, message) {
            argsert('[boolean|string] [string]', [enabled, message], arguments.length);
            usage.showHelpOnFail(enabled, message);
            return self;
        };
        var exitProcess = true;
        self.exitProcess = function (enabled) {
            argsert('[boolean]', [enabled], arguments.length);
            if (typeof enabled !== 'boolean') {
                enabled = true;
            }
            exitProcess = enabled;
            return self;
        };
        self.getExitProcess = () => exitProcess;
        var completionCommand = null;
        self.completion = function (cmd, desc, fn) {
            argsert('[string] [string|boolean|function] [function]', [cmd, desc, fn], arguments.length);
            // a function to execute when generating
            // completions can be provided as the second
            // or third argument to completion.
            if (typeof desc === 'function') {
                fn = desc;
                desc = null;
            }
            // register the completion command.
            completionCommand = cmd || completionCommand || 'completion';
            if (!desc && desc !== false) {
                desc = 'generate completion script';
            }
            self.command(completionCommand, desc);
            // a function can be provided
            if (fn)
                completion.registerFunction(fn);
            return self;
        };
        self.showCompletionScript = function ($0, cmd) {
            argsert('[string] [string]', [$0, cmd], arguments.length);
            $0 = $0 || self.$0;
            _logger.log(completion.generateCompletionScript($0, cmd || completionCommand || 'completion'));
            return self;
        };
        self.getCompletion = function (args, done) {
            argsert('<array> <function>', [args, done], arguments.length);
            completion.getCompletion(args, done);
        };
        self.locale = function (locale) {
            argsert('[string]', [locale], arguments.length);
            if (arguments.length === 0) {
                guessLocale();
                return y18n.getLocale();
            }
            detectLocale = false;
            y18n.setLocale(locale);
            return self;
        };
        self.updateStrings = self.updateLocale = function (obj) {
            argsert('<object>', [obj], arguments.length);
            detectLocale = false;
            y18n.updateLocale(obj);
            return self;
        };
        let detectLocale = true;
        self.detectLocale = function (detect) {
            argsert('<boolean>', [detect], arguments.length);
            detectLocale = detect;
            return self;
        };
        self.getDetectLocale = () => detectLocale;
        var hasOutput = false;
        var exitError = null;
        // maybe exit, always capture
        // context about why we wanted to exit.
        self.exit = (code, err) => {
            hasOutput = true;
            exitError = err;
            if (exitProcess)
                process.exit(code);
        };
        // we use a custom logger that buffers output,
        // so that we can print to non-CLIs, e.g., chat-bots.
        const _logger = {
            log() {
                const args = [];
                for (let i = 0; i < arguments.length; i++)
                    args.push(arguments[i]);
                if (!self._hasParseCallback())
                    console.log.apply(console, args);
                hasOutput = true;
                if (output.length)
                    output += '\n';
                output += args.join(' ');
            },
            error() {
                const args = [];
                for (let i = 0; i < arguments.length; i++)
                    args.push(arguments[i]);
                if (!self._hasParseCallback())
                    console.error.apply(console, args);
                hasOutput = true;
                if (output.length)
                    output += '\n';
                output += args.join(' ');
            }
        };
        self._getLoggerInstance = () => _logger;
        // has yargs output an error our help
        // message in the current execution context.
        self._hasOutput = () => hasOutput;
        self._setHasOutput = () => {
            hasOutput = true;
        };
        let recommendCommands;
        self.recommendCommands = function (recommend) {
            argsert('[boolean]', [recommend], arguments.length);
            recommendCommands = typeof recommend === 'boolean' ? recommend : true;
            return self;
        };
        self.getUsageInstance = () => usage;
        self.getValidationInstance = () => validation;
        self.getCommandInstance = () => command;
        self.terminalWidth = () => {
            argsert([], 0);
            return typeof process.stdout.columns !== 'undefined' ? process.stdout.columns : null;
        };
        Object.defineProperty(self, 'argv', {
            get: () => self._parseArgs(processArgs),
            enumerable: true
        });
        self._parseArgs = function parseArgs(args, shortCircuit, _calledFromCommand, commandIndex) {
            let skipValidation = !!_calledFromCommand;
            args = args || processArgs;
            options.__ = y18n.__;
            options.configuration = self.getParserConfiguration();
            const populateDoubleDash = !!options.configuration['populate--'];
            const config = Object.assign({}, options.configuration, {
                'populate--': true
            });
            const parsed = Parser.detailed(args, Object.assign({}, options, {
                configuration: config
            }));
            let argv = parsed.argv;
            if (parseContext)
                argv = Object.assign({}, argv, parseContext);
            const aliases = parsed.aliases;
            argv.$0 = self.$0;
            self.parsed = parsed;
            try {
                guessLocale(); // guess locale lazily, so that it can be turned off in chain.
                // while building up the argv object, there
                // are two passes through the parser. If completion
                // is being performed short-circuit on the first pass.
                if (shortCircuit) {
                    return (populateDoubleDash || _calledFromCommand) ? argv : self._copyDoubleDash(argv);
                }
                // if there's a handler associated with a
                // command defer processing to it.
                if (helpOpt) {
                    // consider any multi-char helpOpt alias as a valid help command
                    // unless all helpOpt aliases are single-char
                    // note that parsed.aliases is a normalized bidirectional map :)
                    const helpCmds = [helpOpt]
                        .concat(aliases[helpOpt] || [])
                        .filter(k => k.length > 1);
                    // check if help should trigger and strip it from _.
                    if (~helpCmds.indexOf(argv._[argv._.length - 1])) {
                        argv._.pop();
                        argv[helpOpt] = true;
                    }
                }
                const handlerKeys = command.getCommands();
                const requestCompletions = completion.completionKey in argv;
                const skipRecommendation = argv[helpOpt] || requestCompletions;
                const skipDefaultCommand = skipRecommendation && (handlerKeys.length > 1 || handlerKeys[0] !== '$0');
                if (argv._.length) {
                    if (handlerKeys.length) {
                        let firstUnknownCommand;
                        for (let i = (commandIndex || 0), cmd; argv._[i] !== undefined; i++) {
                            cmd = String(argv._[i]);
                            if (~handlerKeys.indexOf(cmd) && cmd !== completionCommand) {
                                // commands are executed using a recursive algorithm that executes
                                // the deepest command first; we keep track of the position in the
                                // argv._ array that is currently being executed.
                                const innerArgv = command.runCommand(cmd, self, parsed, i + 1);
                                return populateDoubleDash ? innerArgv : self._copyDoubleDash(innerArgv);
                            }
                            else if (!firstUnknownCommand && cmd !== completionCommand) {
                                firstUnknownCommand = cmd;
                                break;
                            }
                        }
                        // run the default command, if defined
                        if (command.hasDefaultCommand() && !skipDefaultCommand) {
                            const innerArgv = command.runCommand(null, self, parsed);
                            return populateDoubleDash ? innerArgv : self._copyDoubleDash(innerArgv);
                        }
                        // recommend a command if recommendCommands() has
                        // been enabled, and no commands were found to execute
                        if (recommendCommands && firstUnknownCommand && !skipRecommendation) {
                            validation.recommendCommands(firstUnknownCommand, handlerKeys);
                        }
                    }
                    // generate a completion script for adding to ~/.bashrc.
                    if (completionCommand && ~argv._.indexOf(completionCommand) && !requestCompletions) {
                        if (exitProcess)
                            setBlocking(true);
                        self.showCompletionScript();
                        self.exit(0);
                    }
                }
                else if (command.hasDefaultCommand() && !skipDefaultCommand) {
                    const innerArgv = command.runCommand(null, self, parsed);
                    return populateDoubleDash ? innerArgv : self._copyDoubleDash(innerArgv);
                }
                // we must run completions first, a user might
                // want to complete the --help or --version option.
                if (requestCompletions) {
                    if (exitProcess)
                        setBlocking(true);
                    // we allow for asynchronous completions,
                    // e.g., loading in a list of commands from an API.
                    const completionArgs = args.slice(args.indexOf(`--${completion.completionKey}`) + 1);
                    completion.getCompletion(completionArgs, (completions) => {
                        ;
                        (completions || []).forEach((completion) => {
                            _logger.log(completion);
                        });
                        self.exit(0);
                    });
                    return (populateDoubleDash || _calledFromCommand) ? argv : self._copyDoubleDash(argv);
                }
                // Handle 'help' and 'version' options
                // if we haven't already output help!
                if (!hasOutput) {
                    Object.keys(argv).forEach((key) => {
                        if (key === helpOpt && argv[key]) {
                            if (exitProcess)
                                setBlocking(true);
                            skipValidation = true;
                            self.showHelp('log');
                            self.exit(0);
                        }
                        else if (key === versionOpt && argv[key]) {
                            if (exitProcess)
                                setBlocking(true);
                            skipValidation = true;
                            usage.showVersion();
                            self.exit(0);
                        }
                    });
                }
                // Check if any of the options to skip validation were provided
                if (!skipValidation && options.skipValidation.length > 0) {
                    skipValidation = Object.keys(argv).some(key => options.skipValidation.indexOf(key) >= 0 && argv[key] === true);
                }
                // If the help or version options where used and exitProcess is false,
                // or if explicitly skipped, we won't run validations.
                if (!skipValidation) {
                    if (parsed.error)
                        throw new YError(parsed.error.message);
                    // if we're executed via bash completion, don't
                    // bother with validation.
                    if (!requestCompletions) {
                        self._runValidation(argv, aliases, {}, parsed.error);
                    }
                }
            }
            catch (err) {
                if (err instanceof YError)
                    usage.fail(err.message, err);
                else
                    throw err;
            }
            return (populateDoubleDash || _calledFromCommand) ? argv : self._copyDoubleDash(argv);
        };
        // to simplify the parsing of positionals in commands,
        // we temporarily populate '--' rather than _, with arguments
        // after the '--' directive. After the parse, we copy these back.
        self._copyDoubleDash = function (argv) {
            if (!argv._ || !argv['--'])
                return argv;
            argv._.push.apply(argv._, argv['--']);
            // TODO(bcoe): refactor command parsing such that this delete is not
            // necessary: https://github.com/yargs/yargs/issues/1482
            try {
                delete argv['--'];
            }
            catch (_err) { }
            return argv;
        };
        self._runValidation = function runValidation(argv, aliases, positionalMap, parseErrors) {
            if (parseErrors)
                throw new YError(parseErrors.message);
            validation.nonOptionCount(argv);
            validation.requiredArguments(argv);
            let failedStrictCommands = false;
            if (strictCommands) {
                failedStrictCommands = validation.unknownCommands(argv, aliases, positionalMap);
            }
            if (strict && !failedStrictCommands) {
                validation.unknownArguments(argv, aliases, positionalMap);
            }
            validation.customChecks(argv, aliases);
            validation.limitedChoices(argv);
            validation.implications(argv);
            validation.conflicting(argv);
        };
        function guessLocale() {
            if (!detectLocale)
                return;
            const locale = process.env.LC_ALL || process.env.LC_MESSAGES || process.env.LANG || process.env.LANGUAGE || 'en_US';
            self.locale(locale.replace(/[.:].*/, ''));
        }
        // an app should almost always have --version and --help,
        // if you *really* want to disable this use .help(false)/.version(false).
        self.help();
        self.version();
        return self;
    }
    // allow consumers to directly use the version of yargs-parser used by yargs
    exports.Parser = Parser;
    // rebase an absolute path to a relative one with respect to a base directory
    // exported for tests
    exports.rebase = rebase;
    function rebase(base, dir) {
        return path.relative(base, dir);
    }
},
/* yargs/lib/argsert.js */ function _(require, module, exports) {
    // hoisted due to circular dependency on command.
    module.exports = argsert;
    const command = require(4) /* ./command */();
    const YError = require(13) /* ./yerror */;
    const positionName = ['first', 'second', 'third', 'fourth', 'fifth', 'sixth'];
    function argsert(expected, callerArguments, length) {
        // TODO: should this eventually raise an exception.
        try {
            // preface the argument description with "cmd", so
            // that we can run it through yargs' command parser.
            let position = 0;
            let parsed = { demanded: [], optional: [] };
            if (typeof expected === 'object') {
                length = callerArguments;
                callerArguments = expected;
            }
            else {
                parsed = command.parseCommand(`cmd ${expected}`);
            }
            const args = [].slice.call(callerArguments);
            while (args.length && args[args.length - 1] === undefined)
                args.pop();
            length = length || args.length;
            if (length < parsed.demanded.length) {
                throw new YError(`Not enough arguments provided. Expected ${parsed.demanded.length} but received ${args.length}.`);
            }
            const totalCommands = parsed.demanded.length + parsed.optional.length;
            if (length > totalCommands) {
                throw new YError(`Too many arguments provided. Expected max ${totalCommands} but received ${length}.`);
            }
            parsed.demanded.forEach((demanded) => {
                const arg = args.shift();
                const observedType = guessType(arg);
                const matchingTypes = demanded.cmd.filter(type => type === observedType || type === '*');
                if (matchingTypes.length === 0)
                    argumentTypeError(observedType, demanded.cmd, position, false);
                position += 1;
            });
            parsed.optional.forEach((optional) => {
                if (args.length === 0)
                    return;
                const arg = args.shift();
                const observedType = guessType(arg);
                const matchingTypes = optional.cmd.filter(type => type === observedType || type === '*');
                if (matchingTypes.length === 0)
                    argumentTypeError(observedType, optional.cmd, position, true);
                position += 1;
            });
        }
        catch (err) {
            console.warn(err.stack);
        }
    }
    function guessType(arg) {
        if (Array.isArray(arg)) {
            return 'array';
        }
        else if (arg === null) {
            return 'null';
        }
        return typeof arg;
    }
    function argumentTypeError(observedType, allowedTypes, position, optional) {
        throw new YError(`Invalid ${positionName[position] || 'manyith'} argument. Expected ${allowedTypes.join(' or ')} but received ${observedType}.`);
    }
},
/* yargs/lib/command.js */ function _(require, module, exports) {
    const inspect = require('util').inspect;
    const isPromise = require(5) /* ./is-promise */;
    const { applyMiddleware, commandMiddlewareFactory } = require(6) /* ./middleware */;
    const path = require('path');
    const Parser = require(7) /* yargs-parser */;
    const DEFAULT_MARKER = /(^\*)|(^\$0)/;
    // handles parsing positional arguments,
    // and populating argv with said positional
    // arguments.
    module.exports = function command(yargs, usage, validation, globalMiddleware) {
        const self = {};
        let handlers = {};
        let aliasMap = {};
        let defaultCommand;
        globalMiddleware = globalMiddleware || [];
        self.addHandler = function addHandler(cmd, description, builder, handler, commandMiddleware) {
            let aliases = [];
            const middlewares = commandMiddlewareFactory(commandMiddleware);
            handler = handler || (() => { });
            if (Array.isArray(cmd)) {
                aliases = cmd.slice(1);
                cmd = cmd[0];
            }
            else if (typeof cmd === 'object') {
                let command = (Array.isArray(cmd.command) || typeof cmd.command === 'string') ? cmd.command : moduleName(cmd);
                if (cmd.aliases)
                    command = [].concat(command).concat(cmd.aliases);
                self.addHandler(command, extractDesc(cmd), cmd.builder, cmd.handler, cmd.middlewares);
                return;
            }
            // allow a module to be provided instead of separate builder and handler
            if (typeof builder === 'object' && builder.builder && typeof builder.handler === 'function') {
                self.addHandler([cmd].concat(aliases), description, builder.builder, builder.handler, builder.middlewares);
                return;
            }
            // parse positionals out of cmd string
            const parsedCommand = self.parseCommand(cmd);
            // remove positional args from aliases only
            aliases = aliases.map(alias => self.parseCommand(alias).cmd);
            // check for default and filter out '*''
            let isDefault = false;
            const parsedAliases = [parsedCommand.cmd].concat(aliases).filter((c) => {
                if (DEFAULT_MARKER.test(c)) {
                    isDefault = true;
                    return false;
                }
                return true;
            });
            // standardize on $0 for default command.
            if (parsedAliases.length === 0 && isDefault)
                parsedAliases.push('$0');
            // shift cmd and aliases after filtering out '*'
            if (isDefault) {
                parsedCommand.cmd = parsedAliases[0];
                aliases = parsedAliases.slice(1);
                cmd = cmd.replace(DEFAULT_MARKER, parsedCommand.cmd);
            }
            // populate aliasMap
            aliases.forEach((alias) => {
                aliasMap[alias] = parsedCommand.cmd;
            });
            if (description !== false) {
                usage.command(cmd, description, isDefault, aliases);
            }
            handlers[parsedCommand.cmd] = {
                original: cmd,
                description: description,
                handler,
                builder: builder || {},
                middlewares,
                demanded: parsedCommand.demanded,
                optional: parsedCommand.optional
            };
            if (isDefault)
                defaultCommand = handlers[parsedCommand.cmd];
        };
        self.addDirectory = function addDirectory(dir, context, req, callerFile, opts) {
            opts = opts || {};
            // disable recursion to support nested directories of subcommands
            if (typeof opts.recurse !== 'boolean')
                opts.recurse = false;
            // exclude 'json', 'coffee' from require-directory defaults
            if (!Array.isArray(opts.extensions))
                opts.extensions = ['js'];
            // allow consumer to define their own visitor function
            const parentVisit = typeof opts.visit === 'function' ? opts.visit : o => o;
            // call addHandler via visitor function
            opts.visit = function visit(obj, joined, filename) {
                const visited = parentVisit(obj, joined, filename);
                // allow consumer to skip modules with their own visitor
                if (visited) {
                    // check for cyclic reference
                    // each command file path should only be seen once per execution
                    if (~context.files.indexOf(joined))
                        return visited;
                    // keep track of visited files in context.files
                    context.files.push(joined);
                    self.addHandler(visited);
                }
                return visited;
            };
            require(11) /* require-directory */({ require: req, filename: callerFile }, dir, opts);
        };
        // lookup module object from require()d command and derive name
        // if module was not require()d and no name given, throw error
        function moduleName(obj) {
            const mod = require(12) /* which-module */(obj);
            if (!mod)
                throw new Error(`No command name given for module: ${inspect(obj)}`);
            return commandFromFilename(mod.filename);
        }
        // derive command name from filename
        function commandFromFilename(filename) {
            return path.basename(filename, path.extname(filename));
        }
        function extractDesc(obj) {
            for (let keys = ['describe', 'description', 'desc'], i = 0, l = keys.length, test; i < l; i++) {
                test = obj[keys[i]];
                if (typeof test === 'string' || typeof test === 'boolean')
                    return test;
            }
            return false;
        }
        self.parseCommand = function parseCommand(cmd) {
            const extraSpacesStrippedCommand = cmd.replace(/\s{2,}/g, ' ');
            const splitCommand = extraSpacesStrippedCommand.split(/\s+(?![^[]*]|[^<]*>)/);
            const bregex = /\.*[\][<>]/g;
            const parsedCommand = {
                cmd: (splitCommand.shift()).replace(bregex, ''),
                demanded: [],
                optional: []
            };
            splitCommand.forEach((cmd, i) => {
                let variadic = false;
                cmd = cmd.replace(/\s/g, '');
                if (/\.+[\]>]/.test(cmd) && i === splitCommand.length - 1)
                    variadic = true;
                if (/^\[/.test(cmd)) {
                    parsedCommand.optional.push({
                        cmd: cmd.replace(bregex, '').split('|'),
                        variadic
                    });
                }
                else {
                    parsedCommand.demanded.push({
                        cmd: cmd.replace(bregex, '').split('|'),
                        variadic
                    });
                }
            });
            return parsedCommand;
        };
        self.getCommands = () => Object.keys(handlers).concat(Object.keys(aliasMap));
        self.getCommandHandlers = () => handlers;
        self.hasDefaultCommand = () => !!defaultCommand;
        self.runCommand = function runCommand(command, yargs, parsed, commandIndex) {
            let aliases = parsed.aliases;
            const commandHandler = handlers[command] || handlers[aliasMap[command]] || defaultCommand;
            const currentContext = yargs.getContext();
            let numFiles = currentContext.files.length;
            const parentCommands = currentContext.commands.slice();
            // what does yargs look like after the builder is run?
            let innerArgv = parsed.argv;
            let innerYargs = null;
            let positionalMap = {};
            if (command) {
                currentContext.commands.push(command);
                currentContext.fullCommands.push(commandHandler.original);
            }
            if (typeof commandHandler.builder === 'function') {
                // a function can be provided, which builds
                // up a yargs chain and possibly returns it.
                innerYargs = commandHandler.builder(yargs.reset(parsed.aliases));
                if (!innerYargs || (typeof innerYargs._parseArgs !== 'function')) {
                    innerYargs = yargs;
                }
                if (shouldUpdateUsage(innerYargs)) {
                    innerYargs.getUsageInstance().usage(usageFromParentCommandsCommandHandler(parentCommands, commandHandler), commandHandler.description);
                }
                innerArgv = innerYargs._parseArgs(null, null, true, commandIndex);
                aliases = innerYargs.parsed.aliases;
            }
            else if (typeof commandHandler.builder === 'object') {
                // as a short hand, an object can instead be provided, specifying
                // the options that a command takes.
                innerYargs = yargs.reset(parsed.aliases);
                if (shouldUpdateUsage(innerYargs)) {
                    innerYargs.getUsageInstance().usage(usageFromParentCommandsCommandHandler(parentCommands, commandHandler), commandHandler.description);
                }
                Object.keys(commandHandler.builder).forEach((key) => {
                    innerYargs.option(key, commandHandler.builder[key]);
                });
                innerArgv = innerYargs._parseArgs(null, null, true, commandIndex);
                aliases = innerYargs.parsed.aliases;
            }
            if (!yargs._hasOutput()) {
                positionalMap = populatePositionals(commandHandler, innerArgv, currentContext, yargs);
            }
            const middlewares = globalMiddleware.slice(0).concat(commandHandler.middlewares);
            applyMiddleware(innerArgv, yargs, middlewares, true);
            // we apply validation post-hoc, so that custom
            // checks get passed populated positional arguments.
            if (!yargs._hasOutput())
                yargs._runValidation(innerArgv, aliases, positionalMap, yargs.parsed.error);
            if (commandHandler.handler && !yargs._hasOutput()) {
                yargs._setHasOutput();
                // to simplify the parsing of positionals in commands,
                // we temporarily populate '--' rather than _, with arguments
                const populateDoubleDash = !!yargs.getOptions().configuration['populate--'];
                if (!populateDoubleDash)
                    yargs._copyDoubleDash(innerArgv);
                innerArgv = applyMiddleware(innerArgv, yargs, middlewares, false);
                let handlerResult;
                if (isPromise(innerArgv)) {
                    handlerResult = innerArgv.then(argv => commandHandler.handler(argv));
                }
                else {
                    handlerResult = commandHandler.handler(innerArgv);
                }
                const handlerFinishCommand = yargs.getHandlerFinishCommand();
                if (isPromise(handlerResult)) {
                    yargs.getUsageInstance().cacheHelpMessage();
                    handlerResult
                        .then(value => {
                        if (handlerFinishCommand) {
                            handlerFinishCommand(value);
                        }
                    })
                        .catch(error => {
                        try {
                            yargs.getUsageInstance().fail(null, error);
                        }
                        catch (err) {
                            // fail's throwing would cause an unhandled rejection.
                        }
                    })
                        .then(() => {
                        yargs.getUsageInstance().clearCachedHelpMessage();
                    });
                }
                else {
                    if (handlerFinishCommand) {
                        handlerFinishCommand(handlerResult);
                    }
                }
            }
            if (command) {
                currentContext.commands.pop();
                currentContext.fullCommands.pop();
            }
            numFiles = currentContext.files.length - numFiles;
            if (numFiles > 0)
                currentContext.files.splice(numFiles * -1, numFiles);
            return innerArgv;
        };
        function shouldUpdateUsage(yargs) {
            return !yargs.getUsageInstance().getUsageDisabled() &&
                yargs.getUsageInstance().getUsage().length === 0;
        }
        function usageFromParentCommandsCommandHandler(parentCommands, commandHandler) {
            const c = DEFAULT_MARKER.test(commandHandler.original) ? commandHandler.original.replace(DEFAULT_MARKER, '').trim() : commandHandler.original;
            const pc = parentCommands.filter((c) => { return !DEFAULT_MARKER.test(c); });
            pc.push(c);
            return `$0 ${pc.join(' ')}`;
        }
        self.runDefaultBuilderOn = function (yargs) {
            if (shouldUpdateUsage(yargs)) {
                // build the root-level command string from the default string.
                const commandString = DEFAULT_MARKER.test(defaultCommand.original)
                    ? defaultCommand.original : defaultCommand.original.replace(/^[^[\]<>]*/, '$0 ');
                yargs.getUsageInstance().usage(commandString, defaultCommand.description);
            }
            const builder = defaultCommand.builder;
            if (typeof builder === 'function') {
                builder(yargs);
            }
            else {
                Object.keys(builder).forEach((key) => {
                    yargs.option(key, builder[key]);
                });
            }
        };
        // transcribe all positional arguments "command <foo> <bar> [apple]"
        // onto argv.
        function populatePositionals(commandHandler, argv, context, yargs) {
            argv._ = argv._.slice(context.commands.length); // nuke the current commands
            const demanded = commandHandler.demanded.slice(0);
            const optional = commandHandler.optional.slice(0);
            const positionalMap = {};
            validation.positionalCount(demanded.length, argv._.length);
            while (demanded.length) {
                const demand = demanded.shift();
                populatePositional(demand, argv, positionalMap);
            }
            while (optional.length) {
                const maybe = optional.shift();
                populatePositional(maybe, argv, positionalMap);
            }
            argv._ = context.commands.concat(argv._);
            postProcessPositionals(argv, positionalMap, self.cmdToParseOptions(commandHandler.original));
            return positionalMap;
        }
        function populatePositional(positional, argv, positionalMap, parseOptions) {
            const cmd = positional.cmd[0];
            if (positional.variadic) {
                positionalMap[cmd] = argv._.splice(0).map(String);
            }
            else {
                if (argv._.length)
                    positionalMap[cmd] = [String(argv._.shift())];
            }
        }
        // we run yargs-parser against the positional arguments
        // applying the same parsing logic used for flags.
        function postProcessPositionals(argv, positionalMap, parseOptions) {
            // combine the parsing hints we've inferred from the command
            // string with explicitly configured parsing hints.
            const options = Object.assign({}, yargs.getOptions());
            options.default = Object.assign(parseOptions.default, options.default);
            options.alias = Object.assign(parseOptions.alias, options.alias);
            options.array = options.array.concat(parseOptions.array);
            delete options.config; //  don't load config when processing positionals.
            const unparsed = [];
            Object.keys(positionalMap).forEach((key) => {
                positionalMap[key].map((value) => {
                    if (options.configuration['unknown-options-as-args'])
                        options.key[key] = true;
                    unparsed.push(`--${key}`);
                    unparsed.push(value);
                });
            });
            // short-circuit parse.
            if (!unparsed.length)
                return;
            const config = Object.assign({}, options.configuration, {
                'populate--': true
            });
            const parsed = Parser.detailed(unparsed, Object.assign({}, options, {
                configuration: config
            }));
            if (parsed.error) {
                yargs.getUsageInstance().fail(parsed.error.message, parsed.error);
            }
            else {
                // only copy over positional keys (don't overwrite
                // flag arguments that were already parsed).
                const positionalKeys = Object.keys(positionalMap);
                Object.keys(positionalMap).forEach((key) => {
                    [].push.apply(positionalKeys, parsed.aliases[key]);
                });
                Object.keys(parsed.argv).forEach((key) => {
                    if (positionalKeys.indexOf(key) !== -1) {
                        // any new aliases need to be placed in positionalMap, which
                        // is used for validation.
                        if (!positionalMap[key])
                            positionalMap[key] = parsed.argv[key];
                        argv[key] = parsed.argv[key];
                    }
                });
            }
        }
        self.cmdToParseOptions = function (cmdString) {
            const parseOptions = {
                array: [],
                default: {},
                alias: {},
                demand: {}
            };
            const parsed = self.parseCommand(cmdString);
            parsed.demanded.forEach((d) => {
                const cmds = d.cmd.slice(0);
                const cmd = cmds.shift();
                if (d.variadic) {
                    parseOptions.array.push(cmd);
                    parseOptions.default[cmd] = [];
                }
                cmds.forEach((c) => {
                    parseOptions.alias[cmd] = c;
                });
                parseOptions.demand[cmd] = true;
            });
            parsed.optional.forEach((o) => {
                const cmds = o.cmd.slice(0);
                const cmd = cmds.shift();
                if (o.variadic) {
                    parseOptions.array.push(cmd);
                    parseOptions.default[cmd] = [];
                }
                cmds.forEach((c) => {
                    parseOptions.alias[cmd] = c;
                });
            });
            return parseOptions;
        };
        self.reset = () => {
            handlers = {};
            aliasMap = {};
            defaultCommand = undefined;
            return self;
        };
        // used by yargs.parse() to freeze
        // the state of commands such that
        // we can apply .parse() multiple times
        // with the same yargs instance.
        const frozens = [];
        self.freeze = () => {
            const frozen = {};
            frozens.push(frozen);
            frozen.handlers = handlers;
            frozen.aliasMap = aliasMap;
            frozen.defaultCommand = defaultCommand;
        };
        self.unfreeze = () => {
            const frozen = frozens.pop();
            handlers = frozen.handlers;
            aliasMap = frozen.aliasMap;
            defaultCommand = frozen.defaultCommand;
        };
        return self;
    };
},
/* yargs/lib/is-promise.js */ function _(require, module, exports) {
    module.exports = function isPromise(maybePromise) {
        return !!maybePromise && !!maybePromise.then && (typeof maybePromise.then === 'function');
    };
},
/* yargs/lib/middleware.js */ function _(require, module, exports) {
    // hoisted due to circular dependency on command.
    module.exports = {
        applyMiddleware,
        commandMiddlewareFactory,
        globalMiddlewareFactory
    };
    const isPromise = require(5) /* ./is-promise */;
    const argsert = require(3) /* ./argsert */;
    function globalMiddlewareFactory(globalMiddleware, context) {
        return function (callback, applyBeforeValidation = false) {
            argsert('<array|function> [boolean]', [callback, applyBeforeValidation], arguments.length);
            if (Array.isArray(callback)) {
                for (let i = 0; i < callback.length; i++) {
                    if (typeof callback[i] !== 'function') {
                        throw Error('middleware must be a function');
                    }
                    callback[i].applyBeforeValidation = applyBeforeValidation;
                }
                Array.prototype.push.apply(globalMiddleware, callback);
            }
            else if (typeof callback === 'function') {
                callback.applyBeforeValidation = applyBeforeValidation;
                globalMiddleware.push(callback);
            }
            return context;
        };
    }
    function commandMiddlewareFactory(commandMiddleware) {
        if (!commandMiddleware)
            return [];
        return commandMiddleware.map(middleware => {
            middleware.applyBeforeValidation = false;
            return middleware;
        });
    }
    function applyMiddleware(argv, yargs, middlewares, beforeValidation) {
        const beforeValidationError = new Error('middleware cannot return a promise when applyBeforeValidation is true');
        return middlewares
            .reduce((accumulation, middleware) => {
            if (middleware.applyBeforeValidation !== beforeValidation) {
                return accumulation;
            }
            if (isPromise(accumulation)) {
                return accumulation
                    .then(initialObj => Promise.all([initialObj, middleware(initialObj, yargs)]))
                    .then(([initialObj, middlewareObj]) => Object.assign(initialObj, middlewareObj));
            }
            else {
                const result = middleware(argv, yargs);
                if (beforeValidation && isPromise(result))
                    throw beforeValidationError;
                return isPromise(result)
                    ? result.then(middlewareObj => Object.assign(accumulation, middlewareObj))
                    : Object.assign(accumulation, result);
            }
        }, argv);
    }
},
/* yargs-parser/index.js */ function _(require, module, exports) {
    var camelCase = require(8) /* camelcase */;
    var decamelize = require(9) /* decamelize */;
    var path = require('path');
    var tokenizeArgString = require(10) /* ./lib/tokenize-arg-string */;
    var util = require('util');
    function parse(args, opts) {
        if (!opts)
            opts = {};
        // allow a string argument to be passed in rather
        // than an argv array.
        args = tokenizeArgString(args);
        // aliases might have transitive relationships, normalize this.
        var aliases = combineAliases(opts.alias || {});
        var configuration = Object.assign({
            'short-option-groups': true,
            'camel-case-expansion': true,
            'dot-notation': true,
            'parse-numbers': true,
            'boolean-negation': true,
            'negation-prefix': 'no-',
            'duplicate-arguments-array': true,
            'flatten-duplicate-arrays': true,
            'populate--': false,
            'combine-arrays': false,
            'set-placeholder-key': false,
            'halt-at-non-option': false,
            'strip-aliased': false,
            'strip-dashed': false
        }, opts.configuration);
        var defaults = opts.default || {};
        var configObjects = opts.configObjects || [];
        var envPrefix = opts.envPrefix;
        var notFlagsOption = configuration['populate--'];
        var notFlagsArgv = notFlagsOption ? '--' : '_';
        var newAliases = {};
        // allow a i18n handler to be passed in, default to a fake one (util.format).
        var __ = opts.__ || util.format;
        var error = null;
        var flags = {
            aliases: {},
            arrays: {},
            bools: {},
            strings: {},
            numbers: {},
            counts: {},
            normalize: {},
            configs: {},
            defaulted: {},
            nargs: {},
            coercions: {},
            keys: []
        };
        var negative = /^-[0-9]+(\.[0-9]+)?/;
        var negatedBoolean = new RegExp('^--' + configuration['negation-prefix'] + '(.+)');
        [].concat(opts.array).filter(Boolean).forEach(function (opt) {
            var key = opt.key || opt;
            // assign to flags[bools|strings|numbers]
            const assignment = Object.keys(opt).map(function (key) {
                return ({
                    boolean: 'bools',
                    string: 'strings',
                    number: 'numbers'
                })[key];
            }).filter(Boolean).pop();
            // assign key to be coerced
            if (assignment) {
                flags[assignment][key] = true;
            }
            flags.arrays[key] = true;
            flags.keys.push(key);
        });
        [].concat(opts.boolean).filter(Boolean).forEach(function (key) {
            flags.bools[key] = true;
            flags.keys.push(key);
        });
        [].concat(opts.string).filter(Boolean).forEach(function (key) {
            flags.strings[key] = true;
            flags.keys.push(key);
        });
        [].concat(opts.number).filter(Boolean).forEach(function (key) {
            flags.numbers[key] = true;
            flags.keys.push(key);
        });
        [].concat(opts.count).filter(Boolean).forEach(function (key) {
            flags.counts[key] = true;
            flags.keys.push(key);
        });
        [].concat(opts.normalize).filter(Boolean).forEach(function (key) {
            flags.normalize[key] = true;
            flags.keys.push(key);
        });
        Object.keys(opts.narg || {}).forEach(function (k) {
            flags.nargs[k] = opts.narg[k];
            flags.keys.push(k);
        });
        Object.keys(opts.coerce || {}).forEach(function (k) {
            flags.coercions[k] = opts.coerce[k];
            flags.keys.push(k);
        });
        if (Array.isArray(opts.config) || typeof opts.config === 'string') {
            ;
            [].concat(opts.config).filter(Boolean).forEach(function (key) {
                flags.configs[key] = true;
            });
        }
        else {
            Object.keys(opts.config || {}).forEach(function (k) {
                flags.configs[k] = opts.config[k];
            });
        }
        // create a lookup table that takes into account all
        // combinations of aliases: {f: ['foo'], foo: ['f']}
        extendAliases(opts.key, aliases, opts.default, flags.arrays);
        // apply default values to all aliases.
        Object.keys(defaults).forEach(function (key) {
            (flags.aliases[key] || []).forEach(function (alias) {
                defaults[alias] = defaults[key];
            });
        });
        var argv = { _: [] };
        Object.keys(flags.bools).forEach(function (key) {
            if (Object.prototype.hasOwnProperty.call(defaults, key)) {
                setArg(key, defaults[key]);
                setDefaulted(key);
            }
        });
        var notFlags = [];
        for (var i = 0; i < args.length; i++) {
            var arg = args[i];
            var broken;
            var key;
            var letters;
            var m;
            var next;
            var value;
            // -- separated by =
            if (arg.match(/^--.+=/) || (!configuration['short-option-groups'] && arg.match(/^-.+=/))) {
                // Using [\s\S] instead of . because js doesn't support the
                // 'dotall' regex modifier. See:
                // http://stackoverflow.com/a/1068308/13216
                m = arg.match(/^--?([^=]+)=([\s\S]*)$/);
                // nargs format = '--f=monkey washing cat'
                if (checkAllAliases(m[1], flags.nargs)) {
                    args.splice(i + 1, 0, m[2]);
                    i = eatNargs(i, m[1], args);
                    // arrays format = '--f=a b c'
                }
                else if (checkAllAliases(m[1], flags.arrays) && args.length > i + 1) {
                    args.splice(i + 1, 0, m[2]);
                    i = eatArray(i, m[1], args);
                }
                else {
                    setArg(m[1], m[2]);
                }
            }
            else if (arg.match(negatedBoolean) && configuration['boolean-negation']) {
                key = arg.match(negatedBoolean)[1];
                setArg(key, false);
                // -- seperated by space.
            }
            else if (arg.match(/^--.+/) || (!configuration['short-option-groups'] && arg.match(/^-[^-]+/))) {
                key = arg.match(/^--?(.+)/)[1];
                // nargs format = '--foo a b c'
                if (checkAllAliases(key, flags.nargs)) {
                    i = eatNargs(i, key, args);
                    // array format = '--foo a b c'
                }
                else if (checkAllAliases(key, flags.arrays) && args.length > i + 1) {
                    i = eatArray(i, key, args);
                }
                else {
                    next = flags.nargs[key] === 0 ? undefined : args[i + 1];
                    if (next !== undefined && (!next.match(/^-/) ||
                        next.match(negative)) &&
                        !checkAllAliases(key, flags.bools) &&
                        !checkAllAliases(key, flags.counts)) {
                        setArg(key, next);
                        i++;
                    }
                    else if (/^(true|false)$/.test(next)) {
                        setArg(key, next);
                        i++;
                    }
                    else {
                        setArg(key, defaultValue(key));
                    }
                }
                // dot-notation flag seperated by '='.
            }
            else if (arg.match(/^-.\..+=/)) {
                m = arg.match(/^-([^=]+)=([\s\S]*)$/);
                setArg(m[1], m[2]);
                // dot-notation flag seperated by space.
            }
            else if (arg.match(/^-.\..+/)) {
                next = args[i + 1];
                key = arg.match(/^-(.\..+)/)[1];
                if (next !== undefined && !next.match(/^-/) &&
                    !checkAllAliases(key, flags.bools) &&
                    !checkAllAliases(key, flags.counts)) {
                    setArg(key, next);
                    i++;
                }
                else {
                    setArg(key, defaultValue(key));
                }
            }
            else if (arg.match(/^-[^-]+/) && !arg.match(negative)) {
                letters = arg.slice(1, -1).split('');
                broken = false;
                for (var j = 0; j < letters.length; j++) {
                    next = arg.slice(j + 2);
                    if (letters[j + 1] && letters[j + 1] === '=') {
                        value = arg.slice(j + 3);
                        key = letters[j];
                        // nargs format = '-f=monkey washing cat'
                        if (checkAllAliases(key, flags.nargs)) {
                            args.splice(i + 1, 0, value);
                            i = eatNargs(i, key, args);
                            // array format = '-f=a b c'
                        }
                        else if (checkAllAliases(key, flags.arrays) && args.length > i + 1) {
                            args.splice(i + 1, 0, value);
                            i = eatArray(i, key, args);
                        }
                        else {
                            setArg(key, value);
                        }
                        broken = true;
                        break;
                    }
                    if (next === '-') {
                        setArg(letters[j], next);
                        continue;
                    }
                    // current letter is an alphabetic character and next value is a number
                    if (/[A-Za-z]/.test(letters[j]) &&
                        /^-?\d+(\.\d*)?(e-?\d+)?$/.test(next)) {
                        setArg(letters[j], next);
                        broken = true;
                        break;
                    }
                    if (letters[j + 1] && letters[j + 1].match(/\W/)) {
                        setArg(letters[j], next);
                        broken = true;
                        break;
                    }
                    else {
                        setArg(letters[j], defaultValue(letters[j]));
                    }
                }
                key = arg.slice(-1)[0];
                if (!broken && key !== '-') {
                    // nargs format = '-f a b c'
                    if (checkAllAliases(key, flags.nargs)) {
                        i = eatNargs(i, key, args);
                        // array format = '-f a b c'
                    }
                    else if (checkAllAliases(key, flags.arrays) && args.length > i + 1) {
                        i = eatArray(i, key, args);
                    }
                    else {
                        next = args[i + 1];
                        if (next !== undefined && (!/^(-|--)[^-]/.test(next) ||
                            next.match(negative)) &&
                            !checkAllAliases(key, flags.bools) &&
                            !checkAllAliases(key, flags.counts)) {
                            setArg(key, next);
                            i++;
                        }
                        else if (/^(true|false)$/.test(next)) {
                            setArg(key, next);
                            i++;
                        }
                        else {
                            setArg(key, defaultValue(key));
                        }
                    }
                }
            }
            else if (arg === '--') {
                notFlags = args.slice(i + 1);
                break;
            }
            else if (configuration['halt-at-non-option']) {
                notFlags = args.slice(i);
                break;
            }
            else {
                argv._.push(maybeCoerceNumber('_', arg));
            }
        }
        // order of precedence:
        // 1. command line arg
        // 2. value from env var
        // 3. value from config file
        // 4. value from config objects
        // 5. configured default value
        applyEnvVars(argv, true); // special case: check env vars that point to config file
        applyEnvVars(argv, false);
        setConfig(argv);
        setConfigObjects();
        applyDefaultsAndAliases(argv, flags.aliases, defaults);
        applyCoercions(argv);
        if (configuration['set-placeholder-key'])
            setPlaceholderKeys(argv);
        // for any counts either not in args or without an explicit default, set to 0
        Object.keys(flags.counts).forEach(function (key) {
            if (!hasKey(argv, key.split('.')))
                setArg(key, 0);
        });
        // '--' defaults to undefined.
        if (notFlagsOption && notFlags.length)
            argv[notFlagsArgv] = [];
        notFlags.forEach(function (key) {
            argv[notFlagsArgv].push(key);
        });
        if (configuration['camel-case-expansion'] && configuration['strip-dashed']) {
            Object.keys(argv).filter(key => key !== '--' && key.includes('-')).forEach(key => {
                delete argv[key];
            });
        }
        if (configuration['strip-aliased']) {
            // XXX Switch to [].concat(...Object.values(aliases)) once node.js 6 is dropped
            ;
            [].concat(...Object.keys(aliases).map(k => aliases[k])).forEach(alias => {
                if (configuration['camel-case-expansion']) {
                    delete argv[alias.split('.').map(prop => camelCase(prop)).join('.')];
                }
                delete argv[alias];
            });
        }
        // how many arguments should we consume, based
        // on the nargs option?
        function eatNargs(i, key, args) {
            var ii;
            const toEat = checkAllAliases(key, flags.nargs);
            // nargs will not consume flag arguments, e.g., -abc, --foo,
            // and terminates when one is observed.
            var available = 0;
            for (ii = i + 1; ii < args.length; ii++) {
                if (!args[ii].match(/^-[^0-9]/))
                    available++;
                else
                    break;
            }
            if (available < toEat)
                error = Error(__('Not enough arguments following: %s', key));
            const consumed = Math.min(available, toEat);
            for (ii = i + 1; ii < (consumed + i + 1); ii++) {
                setArg(key, args[ii]);
            }
            return (i + consumed);
        }
        // if an option is an array, eat all non-hyphenated arguments
        // following it... YUM!
        // e.g., --foo apple banana cat becomes ["apple", "banana", "cat"]
        function eatArray(i, key, args) {
            var start = i + 1;
            var argsToSet = [];
            var multipleArrayFlag = i > 0;
            for (var ii = i + 1; ii < args.length; ii++) {
                if (/^-/.test(args[ii]) && !negative.test(args[ii])) {
                    if (ii === start) {
                        setArg(key, defaultForType('array'));
                    }
                    multipleArrayFlag = true;
                    break;
                }
                i = ii;
                argsToSet.push(args[ii]);
            }
            if (multipleArrayFlag) {
                setArg(key, argsToSet.map(function (arg) {
                    return processValue(key, arg);
                }));
            }
            else {
                argsToSet.forEach(function (arg) {
                    setArg(key, arg);
                });
            }
            return i;
        }
        function setArg(key, val) {
            unsetDefaulted(key);
            if (/-/.test(key) && configuration['camel-case-expansion']) {
                var alias = key.split('.').map(function (prop) {
                    return camelCase(prop);
                }).join('.');
                addNewAlias(key, alias);
            }
            var value = processValue(key, val);
            var splitKey = key.split('.');
            setKey(argv, splitKey, value);
            // handle populating aliases of the full key
            if (flags.aliases[key] && flags.aliases[key].forEach) {
                flags.aliases[key].forEach(function (x) {
                    x = x.split('.');
                    setKey(argv, x, value);
                });
            }
            // handle populating aliases of the first element of the dot-notation key
            if (splitKey.length > 1 && configuration['dot-notation']) {
                ;
                (flags.aliases[splitKey[0]] || []).forEach(function (x) {
                    x = x.split('.');
                    // expand alias with nested objects in key
                    var a = [].concat(splitKey);
                    a.shift(); // nuke the old key.
                    x = x.concat(a);
                    setKey(argv, x, value);
                });
            }
            // Set normalize getter and setter when key is in 'normalize' but isn't an array
            if (checkAllAliases(key, flags.normalize) && !checkAllAliases(key, flags.arrays)) {
                var keys = [key].concat(flags.aliases[key] || []);
                keys.forEach(function (key) {
                    argv.__defineSetter__(key, function (v) {
                        val = path.normalize(v);
                    });
                    argv.__defineGetter__(key, function () {
                        return typeof val === 'string' ? path.normalize(val) : val;
                    });
                });
            }
        }
        function addNewAlias(key, alias) {
            if (!(flags.aliases[key] && flags.aliases[key].length)) {
                flags.aliases[key] = [alias];
                newAliases[alias] = true;
            }
            if (!(flags.aliases[alias] && flags.aliases[alias].length)) {
                addNewAlias(alias, key);
            }
        }
        function processValue(key, val) {
            // strings may be quoted, clean this up as we assign values.
            if (typeof val === 'string' &&
                (val[0] === "'" || val[0] === '"') &&
                val[val.length - 1] === val[0]) {
                val = val.substring(1, val.length - 1);
            }
            // handle parsing boolean arguments --foo=true --bar false.
            if (checkAllAliases(key, flags.bools) || checkAllAliases(key, flags.counts)) {
                if (typeof val === 'string')
                    val = val === 'true';
            }
            var value = maybeCoerceNumber(key, val);
            // increment a count given as arg (either no value or value parsed as boolean)
            if (checkAllAliases(key, flags.counts) && (isUndefined(value) || typeof value === 'boolean')) {
                value = increment;
            }
            // Set normalized value when key is in 'normalize' and in 'arrays'
            if (checkAllAliases(key, flags.normalize) && checkAllAliases(key, flags.arrays)) {
                if (Array.isArray(val))
                    value = val.map(path.normalize);
                else
                    value = path.normalize(val);
            }
            return value;
        }
        function maybeCoerceNumber(key, value) {
            if (!checkAllAliases(key, flags.strings) && !checkAllAliases(key, flags.coercions)) {
                const shouldCoerceNumber = isNumber(value) && configuration['parse-numbers'] && (Number.isSafeInteger(Math.floor(value)));
                if (shouldCoerceNumber || (!isUndefined(value) && checkAllAliases(key, flags.numbers)))
                    value = Number(value);
            }
            return value;
        }
        // set args from config.json file, this should be
        // applied last so that defaults can be applied.
        function setConfig(argv) {
            var configLookup = {};
            // expand defaults/aliases, in-case any happen to reference
            // the config.json file.
            applyDefaultsAndAliases(configLookup, flags.aliases, defaults);
            Object.keys(flags.configs).forEach(function (configKey) {
                var configPath = argv[configKey] || configLookup[configKey];
                if (configPath) {
                    try {
                        var config = null;
                        var resolvedConfigPath = path.resolve(process.cwd(), configPath);
                        if (typeof flags.configs[configKey] === 'function') {
                            try {
                                config = flags.configs[configKey](resolvedConfigPath);
                            }
                            catch (e) {
                                config = e;
                            }
                            if (config instanceof Error) {
                                error = config;
                                return;
                            }
                        }
                        else {
                            config = require(resolvedConfigPath);
                        }
                        setConfigObject(config);
                    }
                    catch (ex) {
                        if (argv[configKey])
                            error = Error(__('Invalid JSON config file: %s', configPath));
                    }
                }
            });
        }
        // set args from config object.
        // it recursively checks nested objects.
        function setConfigObject(config, prev) {
            Object.keys(config).forEach(function (key) {
                var value = config[key];
                var fullKey = prev ? prev + '.' + key : key;
                // if the value is an inner object and we have dot-notation
                // enabled, treat inner objects in config the same as
                // heavily nested dot notations (foo.bar.apple).
                if (typeof value === 'object' && value !== null && !Array.isArray(value) && configuration['dot-notation']) {
                    // if the value is an object but not an array, check nested object
                    setConfigObject(value, fullKey);
                }
                else {
                    // setting arguments via CLI takes precedence over
                    // values within the config file.
                    if (!hasKey(argv, fullKey.split('.')) || (flags.defaulted[fullKey]) || (flags.arrays[fullKey] && configuration['combine-arrays'])) {
                        setArg(fullKey, value);
                    }
                }
            });
        }
        // set all config objects passed in opts
        function setConfigObjects() {
            if (typeof configObjects === 'undefined')
                return;
            configObjects.forEach(function (configObject) {
                setConfigObject(configObject);
            });
        }
        function applyEnvVars(argv, configOnly) {
            if (typeof envPrefix === 'undefined')
                return;
            var prefix = typeof envPrefix === 'string' ? envPrefix : '';
            Object.keys(process.env).forEach(function (envVar) {
                if (prefix === '' || envVar.lastIndexOf(prefix, 0) === 0) {
                    // get array of nested keys and convert them to camel case
                    var keys = envVar.split('__').map(function (key, i) {
                        if (i === 0) {
                            key = key.substring(prefix.length);
                        }
                        return camelCase(key);
                    });
                    if (((configOnly && flags.configs[keys.join('.')]) || !configOnly) && (!hasKey(argv, keys) || flags.defaulted[keys.join('.')])) {
                        setArg(keys.join('.'), process.env[envVar]);
                    }
                }
            });
        }
        function applyCoercions(argv) {
            var coerce;
            var applied = {};
            Object.keys(argv).forEach(function (key) {
                if (!applied.hasOwnProperty(key)) { // If we haven't already coerced this option via one of its aliases
                    coerce = checkAllAliases(key, flags.coercions);
                    if (typeof coerce === 'function') {
                        try {
                            var value = coerce(argv[key]);
                            ([].concat(flags.aliases[key] || [], key)).forEach(ali => {
                                applied[ali] = argv[ali] = value;
                            });
                        }
                        catch (err) {
                            error = err;
                        }
                    }
                }
            });
        }
        function setPlaceholderKeys(argv) {
            flags.keys.forEach((key) => {
                // don't set placeholder keys for dot notation options 'foo.bar'.
                if (~key.indexOf('.'))
                    return;
                if (typeof argv[key] === 'undefined')
                    argv[key] = undefined;
            });
            return argv;
        }
        function applyDefaultsAndAliases(obj, aliases, defaults) {
            Object.keys(defaults).forEach(function (key) {
                if (!hasKey(obj, key.split('.'))) {
                    setKey(obj, key.split('.'), defaults[key]);
                    (aliases[key] || []).forEach(function (x) {
                        if (hasKey(obj, x.split('.')))
                            return;
                        setKey(obj, x.split('.'), defaults[key]);
                    });
                }
            });
        }
        function hasKey(obj, keys) {
            var o = obj;
            if (!configuration['dot-notation'])
                keys = [keys.join('.')];
            keys.slice(0, -1).forEach(function (key) {
                o = (o[key] || {});
            });
            var key = keys[keys.length - 1];
            if (typeof o !== 'object')
                return false;
            else
                return key in o;
        }
        function setKey(obj, keys, value) {
            var o = obj;
            if (!configuration['dot-notation'])
                keys = [keys.join('.')];
            keys.slice(0, -1).forEach(function (key, index) {
                // TODO(bcoe): in the next major version of yargs, switch to
                // Object.create(null) for dot notation:
                key = sanitizeKey(key);
                if (typeof o === 'object' && o[key] === undefined) {
                    o[key] = {};
                }
                if (typeof o[key] !== 'object' || Array.isArray(o[key])) {
                    // ensure that o[key] is an array, and that the last item is an empty object.
                    if (Array.isArray(o[key])) {
                        o[key].push({});
                    }
                    else {
                        o[key] = [o[key], {}];
                    }
                    // we want to update the empty object at the end of the o[key] array, so set o to that object
                    o = o[key][o[key].length - 1];
                }
                else {
                    o = o[key];
                }
            });
            // TODO(bcoe): in the next major version of yargs, switch to
            // Object.create(null) for dot notation:
            const key = sanitizeKey(keys[keys.length - 1]);
            const isTypeArray = checkAllAliases(keys.join('.'), flags.arrays);
            const isValueArray = Array.isArray(value);
            let duplicate = configuration['duplicate-arguments-array'];
            // nargs has higher priority than duplicate
            if (!duplicate && checkAllAliases(key, flags.nargs)) {
                duplicate = true;
                if ((!isUndefined(o[key]) && flags.nargs[key] === 1) || (Array.isArray(o[key]) && o[key].length === flags.nargs[key])) {
                    o[key] = undefined;
                }
            }
            if (value === increment) {
                o[key] = increment(o[key]);
            }
            else if (Array.isArray(o[key])) {
                if (duplicate && isTypeArray && isValueArray) {
                    o[key] = configuration['flatten-duplicate-arrays'] ? o[key].concat(value) : (Array.isArray(o[key][0]) ? o[key] : [o[key]]).concat([value]);
                }
                else if (!duplicate && Boolean(isTypeArray) === Boolean(isValueArray)) {
                    o[key] = value;
                }
                else {
                    o[key] = o[key].concat([value]);
                }
            }
            else if (o[key] === undefined && isTypeArray) {
                o[key] = isValueArray ? value : [value];
            }
            else if (duplicate && !(o[key] === undefined || checkAllAliases(key, flags.bools) || checkAllAliases(keys.join('.'), flags.bools) || checkAllAliases(key, flags.counts))) {
                o[key] = [o[key], value];
            }
            else {
                o[key] = value;
            }
        }
        // extend the aliases list with inferred aliases.
        function extendAliases(...args) {
            args.forEach(function (obj) {
                Object.keys(obj || {}).forEach(function (key) {
                    // short-circuit if we've already added a key
                    // to the aliases array, for example it might
                    // exist in both 'opts.default' and 'opts.key'.
                    if (flags.aliases[key])
                        return;
                    flags.aliases[key] = [].concat(aliases[key] || []);
                    // For "--option-name", also set argv.optionName
                    flags.aliases[key].concat(key).forEach(function (x) {
                        if (/-/.test(x) && configuration['camel-case-expansion']) {
                            var c = camelCase(x);
                            if (c !== key && flags.aliases[key].indexOf(c) === -1) {
                                flags.aliases[key].push(c);
                                newAliases[c] = true;
                            }
                        }
                    });
                    // For "--optionName", also set argv['option-name']
                    flags.aliases[key].concat(key).forEach(function (x) {
                        if (x.length > 1 && /[A-Z]/.test(x) && configuration['camel-case-expansion']) {
                            var c = decamelize(x, '-');
                            if (c !== key && flags.aliases[key].indexOf(c) === -1) {
                                flags.aliases[key].push(c);
                                newAliases[c] = true;
                            }
                        }
                    });
                    flags.aliases[key].forEach(function (x) {
                        flags.aliases[x] = [key].concat(flags.aliases[key].filter(function (y) {
                            return x !== y;
                        }));
                    });
                });
            });
        }
        // check if a flag is set for any of a key's aliases.
        function checkAllAliases(key, flag) {
            var isSet = false;
            var toCheck = [].concat(flags.aliases[key] || [], key);
            toCheck.forEach(function (key) {
                if (flag[key])
                    isSet = flag[key];
            });
            return isSet;
        }
        function setDefaulted(key) {
            [].concat(flags.aliases[key] || [], key).forEach(function (k) {
                flags.defaulted[k] = true;
            });
        }
        function unsetDefaulted(key) {
            [].concat(flags.aliases[key] || [], key).forEach(function (k) {
                delete flags.defaulted[k];
            });
        }
        // make a best effor to pick a default value
        // for an option based on name and type.
        function defaultValue(key) {
            if (!checkAllAliases(key, flags.bools) &&
                !checkAllAliases(key, flags.counts) &&
                `${key}` in defaults) {
                return defaults[key];
            }
            else {
                return defaultForType(guessType(key));
            }
        }
        // return a default value, given the type of a flag.,
        // e.g., key of type 'string' will default to '', rather than 'true'.
        function defaultForType(type) {
            var def = {
                boolean: true,
                string: '',
                number: undefined,
                array: []
            };
            return def[type];
        }
        // given a flag, enforce a default type.
        function guessType(key) {
            var type = 'boolean';
            if (checkAllAliases(key, flags.strings))
                type = 'string';
            else if (checkAllAliases(key, flags.numbers))
                type = 'number';
            else if (checkAllAliases(key, flags.arrays))
                type = 'array';
            return type;
        }
        function isNumber(x) {
            if (x === null || x === undefined)
                return false;
            // if loaded from config, may already be a number.
            if (typeof x === 'number')
                return true;
            // hexadecimal.
            if (/^0x[0-9a-f]+$/i.test(x))
                return true;
            // don't treat 0123 as a number; as it drops the leading '0'.
            if (x.length > 1 && x[0] === '0')
                return false;
            return /^[-]?(?:\d+(?:\.\d*)?|\.\d+)(e[-+]?\d+)?$/.test(x);
        }
        function isUndefined(num) {
            return num === undefined;
        }
        return {
            argv: argv,
            error: error,
            aliases: flags.aliases,
            newAliases: newAliases,
            configuration: configuration
        };
    }
    // if any aliases reference each other, we should
    // merge them together.
    function combineAliases(aliases) {
        var aliasArrays = [];
        var change = true;
        var combined = {};
        // turn alias lookup hash {key: ['alias1', 'alias2']} into
        // a simple array ['key', 'alias1', 'alias2']
        Object.keys(aliases).forEach(function (key) {
            aliasArrays.push([].concat(aliases[key], key));
        });
        // combine arrays until zero changes are
        // made in an iteration.
        while (change) {
            change = false;
            for (var i = 0; i < aliasArrays.length; i++) {
                for (var ii = i + 1; ii < aliasArrays.length; ii++) {
                    var intersect = aliasArrays[i].filter(function (v) {
                        return aliasArrays[ii].indexOf(v) !== -1;
                    });
                    if (intersect.length) {
                        aliasArrays[i] = aliasArrays[i].concat(aliasArrays[ii]);
                        aliasArrays.splice(ii, 1);
                        change = true;
                        break;
                    }
                }
            }
        }
        // map arrays back to the hash-lookup (de-dupe while
        // we're at it).
        aliasArrays.forEach(function (aliasArray) {
            aliasArray = aliasArray.filter(function (v, i, self) {
                return self.indexOf(v) === i;
            });
            combined[aliasArray.pop()] = aliasArray;
        });
        return combined;
    }
    // this function should only be called when a count is given as an arg
    // it is NOT called to set a default value
    // thus we can start the count at 1 instead of 0
    function increment(orig) {
        return orig !== undefined ? orig + 1 : 1;
    }
    function Parser(args, opts) {
        var result = parse(args.slice(), opts);
        return result.argv;
    }
    // parse arguments and return detailed
    // meta information, aliases, etc.
    Parser.detailed = function (args, opts) {
        return parse(args.slice(), opts);
    };
    // TODO(bcoe): in the next major version of yargs, switch to
    // Object.create(null) for dot notation:
    function sanitizeKey(key) {
        if (key === '__proto__')
            return '___proto___';
        return key;
    }
    module.exports = Parser;
},
/* camelcase/index.js */ function _(require, module, exports) {
    const preserveCamelCase = string => {
        let isLastCharLower = false;
        let isLastCharUpper = false;
        let isLastLastCharUpper = false;
        for (let i = 0; i < string.length; i++) {
            const character = string[i];
            if (isLastCharLower && /[a-zA-Z]/.test(character) && character.toUpperCase() === character) {
                string = string.slice(0, i) + '-' + string.slice(i);
                isLastCharLower = false;
                isLastLastCharUpper = isLastCharUpper;
                isLastCharUpper = true;
                i++;
            }
            else if (isLastCharUpper && isLastLastCharUpper && /[a-zA-Z]/.test(character) && character.toLowerCase() === character) {
                string = string.slice(0, i - 1) + '-' + string.slice(i - 1);
                isLastLastCharUpper = isLastCharUpper;
                isLastCharUpper = false;
                isLastCharLower = true;
            }
            else {
                isLastCharLower = character.toLowerCase() === character && character.toUpperCase() !== character;
                isLastLastCharUpper = isLastCharUpper;
                isLastCharUpper = character.toUpperCase() === character && character.toLowerCase() !== character;
            }
        }
        return string;
    };
    const camelCase = (input, options) => {
        if (!(typeof input === 'string' || Array.isArray(input))) {
            throw new TypeError('Expected the input to be `string | string[]`');
        }
        options = Object.assign({
            pascalCase: false
        }, options);
        const postProcess = x => options.pascalCase ? x.charAt(0).toUpperCase() + x.slice(1) : x;
        if (Array.isArray(input)) {
            input = input.map(x => x.trim())
                .filter(x => x.length)
                .join('-');
        }
        else {
            input = input.trim();
        }
        if (input.length === 0) {
            return '';
        }
        if (input.length === 1) {
            return options.pascalCase ? input.toUpperCase() : input.toLowerCase();
        }
        const hasUpperCase = input !== input.toLowerCase();
        if (hasUpperCase) {
            input = preserveCamelCase(input);
        }
        input = input
            .replace(/^[_.\- ]+/, '')
            .toLowerCase()
            .replace(/[_.\- ]+(\w|$)/g, (_, p1) => p1.toUpperCase())
            .replace(/\d+(\w|$)/g, m => m.toUpperCase());
        return postProcess(input);
    };
    module.exports = camelCase;
    // TODO: Remove this for the next major release
    module.exports.default = camelCase;
},
/* decamelize/index.js */ function _(require, module, exports) {
    module.exports = function (str, sep) {
        if (typeof str !== 'string') {
            throw new TypeError('Expected a string');
        }
        sep = typeof sep === 'undefined' ? '_' : sep;
        return str
            .replace(/([a-z\d])([A-Z])/g, '$1' + sep + '$2')
            .replace(/([A-Z]+)([A-Z][a-z\d]+)/g, '$1' + sep + '$2')
            .toLowerCase();
    };
},
/* yargs-parser/lib/tokenize-arg-string.js */ function _(require, module, exports) {
    // take an un-split argv string and tokenize it.
    module.exports = function (argString) {
        if (Array.isArray(argString)) {
            return argString.map(e => typeof e !== 'string' ? e + '' : e);
        }
        argString = argString.trim();
        var i = 0;
        var prevC = null;
        var c = null;
        var opening = null;
        var args = [];
        for (var ii = 0; ii < argString.length; ii++) {
            prevC = c;
            c = argString.charAt(ii);
            // split on spaces unless we're in quotes.
            if (c === ' ' && !opening) {
                if (!(prevC === ' ')) {
                    i++;
                }
                continue;
            }
            // don't split the string if we're in matching
            // opening or closing single and double quotes.
            if (c === opening) {
                opening = null;
            }
            else if ((c === "'" || c === '"') && !opening) {
                opening = c;
            }
            if (!args[i])
                args[i] = '';
            args[i] += c;
        }
        return args;
    };
},
/* require-directory/index.js */ function _(require, module, exports) {
    var fs = require('fs'), join = require('path').join, resolve = require('path').resolve, dirname = require('path').dirname, defaultOptions = {
        extensions: ['js', 'json', 'coffee'],
        recurse: true,
        rename: function (name) {
            return name;
        },
        visit: function (obj) {
            return obj;
        }
    };
    function checkFileInclusion(path, filename, options) {
        return (
        // verify file has valid extension
        (new RegExp('\\.(' + options.extensions.join('|') + ')$', 'i').test(filename)) &&
            // if options.include is a RegExp, evaluate it and make sure the path passes
            !(options.include && options.include instanceof RegExp && !options.include.test(path)) &&
            // if options.include is a function, evaluate it and make sure the path passes
            !(options.include && typeof options.include === 'function' && !options.include(path, filename)) &&
            // if options.exclude is a RegExp, evaluate it and make sure the path doesn't pass
            !(options.exclude && options.exclude instanceof RegExp && options.exclude.test(path)) &&
            // if options.exclude is a function, evaluate it and make sure the path doesn't pass
            !(options.exclude && typeof options.exclude === 'function' && options.exclude(path, filename)));
    }
    function requireDirectory(m, path, options) {
        var retval = {};
        // path is optional
        if (path && !options && typeof path !== 'string') {
            options = path;
            path = null;
        }
        // default options
        options = options || {};
        for (var prop in defaultOptions) {
            if (typeof options[prop] === 'undefined') {
                options[prop] = defaultOptions[prop];
            }
        }
        // if no path was passed in, assume the equivelant of __dirname from caller
        // otherwise, resolve path relative to the equivalent of __dirname
        path = !path ? dirname(m.filename) : resolve(dirname(m.filename), path);
        // get the path of each file in specified directory, append to current tree node, recurse
        fs.readdirSync(path).forEach(function (filename) {
            var joined = join(path, filename), files, key, obj;
            if (fs.statSync(joined).isDirectory() && options.recurse) {
                // this node is a directory; recurse
                files = requireDirectory(m, joined, options);
                // exclude empty directories
                if (Object.keys(files).length) {
                    retval[options.rename(filename, joined, filename)] = files;
                }
            }
            else {
                if (joined !== m.filename && checkFileInclusion(joined, filename, options)) {
                    // hash node key shouldn't include file extension
                    key = filename.substring(0, filename.lastIndexOf('.'));
                    obj = m.require(joined);
                    retval[options.rename(key, joined, filename)] = options.visit(obj, joined, filename) || obj;
                }
            }
        });
        return retval;
    }
    module.exports = requireDirectory;
    module.exports.defaults = defaultOptions;
},
/* which-module/index.js */ function _(require, module, exports) {
    module.exports = function whichModule(exported) {
        for (var i = 0, files = Object.keys(require.cache), mod; i < files.length; i++) {
            mod = require.cache[files[i]];
            if (mod.exports === exported)
                return mod;
        }
        return null;
    };
},
/* yargs/lib/yerror.js */ function _(require, module, exports) {
    function YError(msg) {
        this.name = 'YError';
        this.message = msg || 'yargs error';
        Error.captureStackTrace(this, YError);
    }
    YError.prototype = Object.create(Error.prototype);
    YError.prototype.constructor = YError;
    module.exports = YError;
},
/* yargs/lib/completion.js */ function _(require, module, exports) {
    const path = require('path');
    // add bash completions to your
    //  yargs-powered applications.
    module.exports = function completion(yargs, usage, command) {
        const self = {
            completionKey: 'get-yargs-completions'
        };
        let aliases;
        self.setParsed = function setParsed(parsed) {
            aliases = parsed.aliases;
        };
        const zshShell = (process.env.SHELL && process.env.SHELL.indexOf('zsh') !== -1) ||
            (process.env.ZSH_NAME && process.env.ZSH_NAME.indexOf('zsh') !== -1);
        // get a list of completion commands.
        // 'args' is the array of strings from the line to be completed
        self.getCompletion = function getCompletion(args, done) {
            const completions = [];
            const current = args.length ? args[args.length - 1] : '';
            const argv = yargs.parse(args, true);
            const parentCommands = yargs.getContext().commands;
            // a custom completion function can be provided
            // to completion().
            if (completionFunction) {
                if (completionFunction.length < 3) {
                    const result = completionFunction(current, argv);
                    // promise based completion function.
                    if (typeof result.then === 'function') {
                        return result.then((list) => {
                            process.nextTick(() => { done(list); });
                        }).catch((err) => {
                            process.nextTick(() => { throw err; });
                        });
                    }
                    // synchronous completion function.
                    return done(result);
                }
                else {
                    // asynchronous completion function
                    return completionFunction(current, argv, (completions) => {
                        done(completions);
                    });
                }
            }
            const handlers = command.getCommandHandlers();
            for (let i = 0, ii = args.length; i < ii; ++i) {
                if (handlers[args[i]] && handlers[args[i]].builder) {
                    const builder = handlers[args[i]].builder;
                    if (typeof builder === 'function') {
                        const y = yargs.reset();
                        builder(y);
                        return y.argv;
                    }
                }
            }
            if (!current.match(/^-/) && parentCommands[parentCommands.length - 1] !== current) {
                usage.getCommands().forEach((usageCommand) => {
                    const commandName = command.parseCommand(usageCommand[0]).cmd;
                    if (args.indexOf(commandName) === -1) {
                        if (!zshShell) {
                            completions.push(commandName);
                        }
                        else {
                            const desc = usageCommand[1] || '';
                            completions.push(commandName.replace(/:/g, '\\:') + ':' + desc);
                        }
                    }
                });
            }
            if (current.match(/^-/) || (current === '' && completions.length === 0)) {
                const descs = usage.getDescriptions();
                const options = yargs.getOptions();
                Object.keys(options.key).forEach((key) => {
                    const negable = !!options.configuration['boolean-negation'] && options.boolean.includes(key);
                    // If the key and its aliases aren't in 'args', add the key to 'completions'
                    let keyAndAliases = [key].concat(aliases[key] || []);
                    if (negable)
                        keyAndAliases = keyAndAliases.concat(keyAndAliases.map(key => `no-${key}`));
                    function completeOptionKey(key) {
                        const notInArgs = keyAndAliases.every(val => args.indexOf(`--${val}`) === -1);
                        if (notInArgs) {
                            const startsByTwoDashes = s => /^--/.test(s);
                            const isShortOption = s => /^[^0-9]$/.test(s);
                            const dashes = !startsByTwoDashes(current) && isShortOption(key) ? '-' : '--';
                            if (!zshShell) {
                                completions.push(dashes + key);
                            }
                            else {
                                const desc = descs[key] || '';
                                completions.push(dashes + `${key.replace(/:/g, '\\:')}:${desc.replace('__yargsString__:', '')}`);
                            }
                        }
                    }
                    completeOptionKey(key);
                    if (negable && !!options.default[key])
                        completeOptionKey(`no-${key}`);
                });
            }
            done(completions);
        };
        // generate the completion script to add to your .bashrc.
        self.generateCompletionScript = function generateCompletionScript($0, cmd) {
            const templates = require(15) /* ./completion-templates */;
            let script = zshShell ? templates.completionZshTemplate : templates.completionShTemplate;
            const name = path.basename($0);
            // add ./to applications not yet installed as bin.
            if ($0.match(/\.js$/))
                $0 = `./${$0}`;
            script = script.replace(/{{app_name}}/g, name);
            script = script.replace(/{{completion_command}}/g, cmd);
            return script.replace(/{{app_path}}/g, $0);
        };
        // register a function to perform your own custom
        // completions., this function can be either
        // synchrnous or asynchronous.
        let completionFunction = null;
        self.registerFunction = (fn) => {
            completionFunction = fn;
        };
        return self;
    };
},
/* yargs/lib/completion-templates.js */ function _(require, module, exports) {
    exports.completionShTemplate =
        `###-begin-{{app_name}}-completions-###
#
# yargs command completion script
#
# Installation: {{app_path}} {{completion_command}} >> ~/.bashrc
#    or {{app_path}} {{completion_command}} >> ~/.bash_profile on OSX.
#
_yargs_completions()
{
    local cur_word args type_list

    cur_word="\${COMP_WORDS[COMP_CWORD]}"
    args=("\${COMP_WORDS[@]}")

    # ask yargs to generate completions.
    type_list=$({{app_path}} --get-yargs-completions "\${args[@]}")

    COMPREPLY=( $(compgen -W "\${type_list}" -- \${cur_word}) )

    # if no match was found, fall back to filename completion
    if [ \${#COMPREPLY[@]} -eq 0 ]; then
      COMPREPLY=()
    fi

    return 0
}
complete -o default -F _yargs_completions {{app_name}}
###-end-{{app_name}}-completions-###
`;
    exports.completionZshTemplate = `###-begin-{{app_name}}-completions-###
#
# yargs command completion script
#
# Installation: {{app_path}} {{completion_command}} >> ~/.zshrc
#    or {{app_path}} {{completion_command}} >> ~/.zsh_profile on OSX.
#
_{{app_name}}_yargs_completions()
{
  local reply
  local si=$IFS
  IFS=$'\n' reply=($(COMP_CWORD="$((CURRENT-1))" COMP_LINE="$BUFFER" COMP_POINT="$CURSOR" {{app_path}} --get-yargs-completions "\${words[@]}"))
  IFS=$si
  _describe 'values' reply
}
compdef _{{app_name}}_yargs_completions {{app_name}}
###-end-{{app_name}}-completions-###
`;
},
/* yargs/lib/usage.js */ function _(require, module, exports) {
    // this file handles outputting usage instructions,
    // failures, etc. keeps logging in one place.
    const decamelize = require(9) /* decamelize */;
    const stringWidth = require(17) /* string-width */;
    const objFilter = require(21) /* ./obj-filter */;
    const path = require('path');
    const setBlocking = require(22) /* set-blocking */;
    const YError = require(13) /* ./yerror */;
    module.exports = function usage(yargs, y18n) {
        const __ = y18n.__;
        const self = {};
        // methods for ouputting/building failure message.
        const fails = [];
        self.failFn = function failFn(f) {
            fails.push(f);
        };
        let failMessage = null;
        let showHelpOnFail = true;
        self.showHelpOnFail = function showHelpOnFailFn(enabled, message) {
            if (typeof enabled === 'string') {
                message = enabled;
                enabled = true;
            }
            else if (typeof enabled === 'undefined') {
                enabled = true;
            }
            failMessage = message;
            showHelpOnFail = enabled;
            return self;
        };
        let failureOutput = false;
        self.fail = function fail(msg, err) {
            const logger = yargs._getLoggerInstance();
            if (fails.length) {
                for (let i = fails.length - 1; i >= 0; --i) {
                    fails[i](msg, err, self);
                }
            }
            else {
                if (yargs.getExitProcess())
                    setBlocking(true);
                // don't output failure message more than once
                if (!failureOutput) {
                    failureOutput = true;
                    if (showHelpOnFail) {
                        yargs.showHelp('error');
                        logger.error();
                    }
                    if (msg || err)
                        logger.error(msg || err);
                    if (failMessage) {
                        if (msg || err)
                            logger.error('');
                        logger.error(failMessage);
                    }
                }
                err = err || new YError(msg);
                if (yargs.getExitProcess()) {
                    return yargs.exit(1);
                }
                else if (yargs._hasParseCallback()) {
                    return yargs.exit(1, err);
                }
                else {
                    throw err;
                }
            }
        };
        // methods for ouputting/building help (usage) message.
        let usages = [];
        let usageDisabled = false;
        self.usage = (msg, description) => {
            if (msg === null) {
                usageDisabled = true;
                usages = [];
                return;
            }
            usageDisabled = false;
            usages.push([msg, description || '']);
            return self;
        };
        self.getUsage = () => {
            return usages;
        };
        self.getUsageDisabled = () => {
            return usageDisabled;
        };
        self.getPositionalGroupName = () => {
            return __('Positionals:');
        };
        let examples = [];
        self.example = (cmd, description) => {
            examples.push([cmd, description || '']);
        };
        let commands = [];
        self.command = function command(cmd, description, isDefault, aliases) {
            // the last default wins, so cancel out any previously set default
            if (isDefault) {
                commands = commands.map((cmdArray) => {
                    cmdArray[2] = false;
                    return cmdArray;
                });
            }
            commands.push([cmd, description || '', isDefault, aliases]);
        };
        self.getCommands = () => commands;
        let descriptions = {};
        self.describe = function describe(key, desc) {
            if (typeof key === 'object') {
                Object.keys(key).forEach((k) => {
                    self.describe(k, key[k]);
                });
            }
            else {
                descriptions[key] = desc;
            }
        };
        self.getDescriptions = () => descriptions;
        let epilogs = [];
        self.epilog = (msg) => {
            epilogs.push(msg);
        };
        let wrapSet = false;
        let wrap;
        self.wrap = (cols) => {
            wrapSet = true;
            wrap = cols;
        };
        function getWrap() {
            if (!wrapSet) {
                wrap = windowWidth();
                wrapSet = true;
            }
            return wrap;
        }
        const deferY18nLookupPrefix = '__yargsString__:';
        self.deferY18nLookup = str => deferY18nLookupPrefix + str;
        const defaultGroup = __('Options:');
        self.help = function help() {
            if (cachedHelpMessage)
                return cachedHelpMessage;
            normalizeAliases();
            // handle old demanded API
            const base$0 = yargs.customScriptName ? yargs.$0 : path.basename(yargs.$0);
            const demandedOptions = yargs.getDemandedOptions();
            const demandedCommands = yargs.getDemandedCommands();
            const deprecatedOptions = yargs.getDeprecatedOptions();
            const groups = yargs.getGroups();
            const options = yargs.getOptions();
            let keys = [];
            keys = keys.concat(Object.keys(descriptions));
            keys = keys.concat(Object.keys(demandedOptions));
            keys = keys.concat(Object.keys(demandedCommands));
            keys = keys.concat(Object.keys(options.default));
            keys = keys.filter(filterHiddenOptions);
            keys = Object.keys(keys.reduce((acc, key) => {
                if (key !== '_')
                    acc[key] = true;
                return acc;
            }, {}));
            const theWrap = getWrap();
            const ui = require(23) /* cliui */({
                width: theWrap,
                wrap: !!theWrap
            });
            // the usage string.
            if (!usageDisabled) {
                if (usages.length) {
                    // user-defined usage.
                    usages.forEach((usage) => {
                        ui.div(`${usage[0].replace(/\$0/g, base$0)}`);
                        if (usage[1]) {
                            ui.div({ text: `${usage[1]}`, padding: [1, 0, 0, 0] });
                        }
                    });
                    ui.div();
                }
                else if (commands.length) {
                    let u = null;
                    // demonstrate how commands are used.
                    if (demandedCommands._) {
                        u = `${base$0} <${__('command')}>\n`;
                    }
                    else {
                        u = `${base$0} [${__('command')}]\n`;
                    }
                    ui.div(`${u}`);
                }
            }
            // your application's commands, i.e., non-option
            // arguments populated in '_'.
            if (commands.length) {
                ui.div(__('Commands:'));
                const context = yargs.getContext();
                const parentCommands = context.commands.length ? `${context.commands.join(' ')} ` : '';
                if (yargs.getParserConfiguration()['sort-commands'] === true) {
                    commands = commands.sort((a, b) => a[0].localeCompare(b[0]));
                }
                commands.forEach((command) => {
                    const commandString = `${base$0} ${parentCommands}${command[0].replace(/^\$0 ?/, '')}`; // drop $0 from default commands.
                    ui.span({
                        text: commandString,
                        padding: [0, 2, 0, 2],
                        width: maxWidth(commands, theWrap, `${base$0}${parentCommands}`) + 4
                    }, { text: command[1] });
                    const hints = [];
                    if (command[2])
                        hints.push(`[${__('default')}]`);
                    if (command[3] && command[3].length) {
                        hints.push(`[${__('aliases:')} ${command[3].join(', ')}]`);
                    }
                    if (hints.length) {
                        ui.div({ text: hints.join(' '), padding: [0, 0, 0, 2], align: 'right' });
                    }
                    else {
                        ui.div();
                    }
                });
                ui.div();
            }
            // perform some cleanup on the keys array, making it
            // only include top-level keys not their aliases.
            const aliasKeys = (Object.keys(options.alias) || [])
                .concat(Object.keys(yargs.parsed.newAliases) || []);
            keys = keys.filter(key => !yargs.parsed.newAliases[key] && aliasKeys.every(alias => (options.alias[alias] || []).indexOf(key) === -1));
            // populate 'Options:' group with any keys that have not
            // explicitly had a group set.
            if (!groups[defaultGroup])
                groups[defaultGroup] = [];
            addUngroupedKeys(keys, options.alias, groups);
            // display 'Options:' table along with any custom tables:
            Object.keys(groups).forEach((groupName) => {
                if (!groups[groupName].length)
                    return;
                // if we've grouped the key 'f', but 'f' aliases 'foobar',
                // normalizedKeys should contain only 'foobar'.
                const normalizedKeys = groups[groupName].filter(filterHiddenOptions).map((key) => {
                    if (~aliasKeys.indexOf(key))
                        return key;
                    for (let i = 0, aliasKey; (aliasKey = aliasKeys[i]) !== undefined; i++) {
                        if (~(options.alias[aliasKey] || []).indexOf(key))
                            return aliasKey;
                    }
                    return key;
                });
                if (normalizedKeys.length < 1)
                    return;
                ui.div(groupName);
                // actually generate the switches string --foo, -f, --bar.
                const switches = normalizedKeys.reduce((acc, key) => {
                    acc[key] = [key].concat(options.alias[key] || [])
                        .map(sw => {
                        // for the special positional group don't
                        // add '--' or '-' prefix.
                        if (groupName === self.getPositionalGroupName())
                            return sw;
                        else {
                            return (
                            // matches yargs-parser logic in which single-digits
                            // aliases declared with a boolean type are now valid
                            /^[0-9]$/.test(sw)
                                ? ~options.boolean.indexOf(key) ? '-' : '--'
                                : sw.length > 1 ? '--' : '-') + sw;
                        }
                    })
                        .join(', ');
                    return acc;
                }, {});
                normalizedKeys.forEach((key) => {
                    const kswitch = switches[key];
                    let desc = descriptions[key] || '';
                    let type = null;
                    if (~desc.lastIndexOf(deferY18nLookupPrefix))
                        desc = __(desc.substring(deferY18nLookupPrefix.length));
                    if (~options.boolean.indexOf(key))
                        type = `[${__('boolean')}]`;
                    if (~options.count.indexOf(key))
                        type = `[${__('count')}]`;
                    if (~options.string.indexOf(key))
                        type = `[${__('string')}]`;
                    if (~options.normalize.indexOf(key))
                        type = `[${__('string')}]`;
                    if (~options.array.indexOf(key))
                        type = `[${__('array')}]`;
                    if (~options.number.indexOf(key))
                        type = `[${__('number')}]`;
                    const extra = [
                        (key in deprecatedOptions) ? (typeof deprecatedOptions[key] === 'string'
                            ? `[${__('deprecated: %s', deprecatedOptions[key])}]`
                            : `[${__('deprecated')}]`) : null,
                        type,
                        (key in demandedOptions) ? `[${__('required')}]` : null,
                        options.choices && options.choices[key] ? `[${__('choices:')} ${self.stringifiedValues(options.choices[key])}]` : null,
                        defaultString(options.default[key], options.defaultDescription[key])
                    ].filter(Boolean).join(' ');
                    ui.span({ text: kswitch, padding: [0, 2, 0, 2], width: maxWidth(switches, theWrap) + 4 }, desc);
                    if (extra)
                        ui.div({ text: extra, padding: [0, 0, 0, 2], align: 'right' });
                    else
                        ui.div();
                });
                ui.div();
            });
            // describe some common use-cases for your application.
            if (examples.length) {
                ui.div(__('Examples:'));
                examples.forEach((example) => {
                    example[0] = example[0].replace(/\$0/g, base$0);
                });
                examples.forEach((example) => {
                    if (example[1] === '') {
                        ui.div({
                            text: example[0],
                            padding: [0, 2, 0, 2]
                        });
                    }
                    else {
                        ui.div({
                            text: example[0],
                            padding: [0, 2, 0, 2],
                            width: maxWidth(examples, theWrap) + 4
                        }, {
                            text: example[1]
                        });
                    }
                });
                ui.div();
            }
            // the usage string.
            if (epilogs.length > 0) {
                const e = epilogs.map(epilog => epilog.replace(/\$0/g, base$0)).join('\n');
                ui.div(`${e}\n`);
            }
            // Remove the trailing white spaces
            return ui.toString().replace(/\s*$/, '');
        };
        // return the maximum width of a string
        // in the left-hand column of a table.
        function maxWidth(table, theWrap, modifier) {
            let width = 0;
            // table might be of the form [leftColumn],
            // or {key: leftColumn}
            if (!Array.isArray(table)) {
                table = Object.keys(table).map(key => [table[key]]);
            }
            table.forEach((v) => {
                width = Math.max(stringWidth(modifier ? `${modifier} ${v[0]}` : v[0]), width);
            });
            // if we've enabled 'wrap' we should limit
            // the max-width of the left-column.
            if (theWrap)
                width = Math.min(width, parseInt(theWrap * 0.5, 10));
            return width;
        }
        // make sure any options set for aliases,
        // are copied to the keys being aliased.
        function normalizeAliases() {
            // handle old demanded API
            const demandedOptions = yargs.getDemandedOptions();
            const options = yargs.getOptions();
            (Object.keys(options.alias) || []).forEach((key) => {
                options.alias[key].forEach((alias) => {
                    // copy descriptions.
                    if (descriptions[alias])
                        self.describe(key, descriptions[alias]);
                    // copy demanded.
                    if (alias in demandedOptions)
                        yargs.demandOption(key, demandedOptions[alias]);
                    // type messages.
                    if (~options.boolean.indexOf(alias))
                        yargs.boolean(key);
                    if (~options.count.indexOf(alias))
                        yargs.count(key);
                    if (~options.string.indexOf(alias))
                        yargs.string(key);
                    if (~options.normalize.indexOf(alias))
                        yargs.normalize(key);
                    if (~options.array.indexOf(alias))
                        yargs.array(key);
                    if (~options.number.indexOf(alias))
                        yargs.number(key);
                });
            });
        }
        // if yargs is executing an async handler, we take a snapshot of the
        // help message to display on failure:
        let cachedHelpMessage;
        self.cacheHelpMessage = function () {
            cachedHelpMessage = this.help();
        };
        // however this snapshot must be cleared afterwards
        // not to be be used by next calls to parse
        self.clearCachedHelpMessage = function () {
            cachedHelpMessage = undefined;
        };
        // given a set of keys, place any keys that are
        // ungrouped under the 'Options:' grouping.
        function addUngroupedKeys(keys, aliases, groups) {
            let groupedKeys = [];
            let toCheck = null;
            Object.keys(groups).forEach((group) => {
                groupedKeys = groupedKeys.concat(groups[group]);
            });
            keys.forEach((key) => {
                toCheck = [key].concat(aliases[key]);
                if (!toCheck.some(k => groupedKeys.indexOf(k) !== -1)) {
                    groups[defaultGroup].push(key);
                }
            });
            return groupedKeys;
        }
        function filterHiddenOptions(key) {
            return yargs.getOptions().hiddenOptions.indexOf(key) < 0 || yargs.parsed.argv[yargs.getOptions().showHiddenOpt];
        }
        self.showHelp = (level) => {
            const logger = yargs._getLoggerInstance();
            if (!level)
                level = 'error';
            const emit = typeof level === 'function' ? level : logger[level];
            emit(self.help());
        };
        self.functionDescription = (fn) => {
            const description = fn.name ? decamelize(fn.name, '-') : __('generated-value');
            return ['(', description, ')'].join('');
        };
        self.stringifiedValues = function stringifiedValues(values, separator) {
            let string = '';
            const sep = separator || ', ';
            const array = [].concat(values);
            if (!values || !array.length)
                return string;
            array.forEach((value) => {
                if (string.length)
                    string += sep;
                string += JSON.stringify(value);
            });
            return string;
        };
        // format the default-value-string displayed in
        // the right-hand column.
        function defaultString(value, defaultDescription) {
            let string = `[${__('default:')} `;
            if (value === undefined && !defaultDescription)
                return null;
            if (defaultDescription) {
                string += defaultDescription;
            }
            else {
                switch (typeof value) {
                    case 'string':
                        string += `"${value}"`;
                        break;
                    case 'object':
                        string += JSON.stringify(value);
                        break;
                    default:
                        string += value;
                }
            }
            return `${string}]`;
        }
        // guess the width of the console window, max-width 80.
        function windowWidth() {
            const maxWidth = 80;
            // CI is not a TTY
            /* c8 ignore next 2 */
            if (typeof process === 'object' && process.stdout && process.stdout.columns) {
                return Math.min(maxWidth, process.stdout.columns);
            }
            else {
                return maxWidth;
            }
        }
        // logic for displaying application version.
        let version = null;
        self.version = (ver) => {
            version = ver;
        };
        self.showVersion = () => {
            const logger = yargs._getLoggerInstance();
            logger.log(version);
        };
        self.reset = function reset(localLookup) {
            // do not reset wrap here
            // do not reset fails here
            failMessage = null;
            failureOutput = false;
            usages = [];
            usageDisabled = false;
            epilogs = [];
            examples = [];
            commands = [];
            descriptions = objFilter(descriptions, (k, v) => !localLookup[k]);
            return self;
        };
        const frozens = [];
        self.freeze = function freeze() {
            const frozen = {};
            frozens.push(frozen);
            frozen.failMessage = failMessage;
            frozen.failureOutput = failureOutput;
            frozen.usages = usages;
            frozen.usageDisabled = usageDisabled;
            frozen.epilogs = epilogs;
            frozen.examples = examples;
            frozen.commands = commands;
            frozen.descriptions = descriptions;
        };
        self.unfreeze = function unfreeze() {
            const frozen = frozens.pop();
            failMessage = frozen.failMessage;
            failureOutput = frozen.failureOutput;
            usages = frozen.usages;
            usageDisabled = frozen.usageDisabled;
            epilogs = frozen.epilogs;
            examples = frozen.examples;
            commands = frozen.commands;
            descriptions = frozen.descriptions;
        };
        return self;
    };
},
/* string-width/index.js */ function _(require, module, exports) {
    const stripAnsi = require(18) /* strip-ansi */;
    const isFullwidthCodePoint = require(20) /* is-fullwidth-code-point */;
    module.exports = str => {
        if (typeof str !== 'string' || str.length === 0) {
            return 0;
        }
        str = stripAnsi(str);
        let width = 0;
        for (let i = 0; i < str.length; i++) {
            const code = str.codePointAt(i);
            // Ignore control characters
            if (code <= 0x1F || (code >= 0x7F && code <= 0x9F)) {
                continue;
            }
            // Ignore combining characters
            if (code >= 0x300 && code <= 0x36F) {
                continue;
            }
            // Surrogates
            if (code > 0xFFFF) {
                i++;
            }
            width += isFullwidthCodePoint(code) ? 2 : 1;
        }
        return width;
    };
},
/* strip-ansi/index.js */ function _(require, module, exports) {
    const ansiRegex = require(19) /* ansi-regex */;
    module.exports = input => typeof input === 'string' ? input.replace(ansiRegex(), '') : input;
},
/* ansi-regex/index.js */ function _(require, module, exports) {
    module.exports = () => {
        const pattern = [
            '[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:[a-zA-Z\\d]*(?:;[a-zA-Z\\d]*)*)?\\u0007)',
            '(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PRZcf-ntqry=><~]))'
        ].join('|');
        return new RegExp(pattern, 'g');
    };
},
/* is-fullwidth-code-point/index.js */ function _(require, module, exports) {
    /* eslint-disable yoda */
    module.exports = x => {
        if (Number.isNaN(x)) {
            return false;
        }
        // code points are derived from:
        // http://www.unix.org/Public/UNIDATA/EastAsianWidth.txt
        if (x >= 0x1100 && (x <= 0x115f || // Hangul Jamo
            x === 0x2329 || // LEFT-POINTING ANGLE BRACKET
            x === 0x232a || // RIGHT-POINTING ANGLE BRACKET
            // CJK Radicals Supplement .. Enclosed CJK Letters and Months
            (0x2e80 <= x && x <= 0x3247 && x !== 0x303f) ||
            // Enclosed CJK Letters and Months .. CJK Unified Ideographs Extension A
            (0x3250 <= x && x <= 0x4dbf) ||
            // CJK Unified Ideographs .. Yi Radicals
            (0x4e00 <= x && x <= 0xa4c6) ||
            // Hangul Jamo Extended-A
            (0xa960 <= x && x <= 0xa97c) ||
            // Hangul Syllables
            (0xac00 <= x && x <= 0xd7a3) ||
            // CJK Compatibility Ideographs
            (0xf900 <= x && x <= 0xfaff) ||
            // Vertical Forms
            (0xfe10 <= x && x <= 0xfe19) ||
            // CJK Compatibility Forms .. Small Form Variants
            (0xfe30 <= x && x <= 0xfe6b) ||
            // Halfwidth and Fullwidth Forms
            (0xff01 <= x && x <= 0xff60) ||
            (0xffe0 <= x && x <= 0xffe6) ||
            // Kana Supplement
            (0x1b000 <= x && x <= 0x1b001) ||
            // Enclosed Ideographic Supplement
            (0x1f200 <= x && x <= 0x1f251) ||
            // CJK Unified Ideographs Extension B .. Tertiary Ideographic Plane
            (0x20000 <= x && x <= 0x3fffd))) {
            return true;
        }
        return false;
    };
},
/* yargs/lib/obj-filter.js */ function _(require, module, exports) {
    module.exports = function objFilter(original, filter) {
        const obj = {};
        filter = filter || ((k, v) => true);
        Object.keys(original || {}).forEach((key) => {
            if (filter(key, original[key])) {
                obj[key] = original[key];
            }
        });
        return obj;
    };
},
/* set-blocking/index.js */ function _(require, module, exports) {
    module.exports = function (blocking) {
        [process.stdout, process.stderr].forEach(function (stream) {
            if (stream._handle && stream.isTTY && typeof stream._handle.setBlocking === 'function') {
                stream._handle.setBlocking(blocking);
            }
        });
    };
},
/* cliui/index.js */ function _(require, module, exports) {
    var stringWidth = require(17) /* string-width */;
    var stripAnsi = require(18) /* strip-ansi */;
    var wrap = require(24) /* wrap-ansi */;
    var align = {
        right: alignRight,
        center: alignCenter
    };
    var top = 0;
    var right = 1;
    var bottom = 2;
    var left = 3;
    function UI(opts) {
        this.width = opts.width;
        this.wrap = opts.wrap;
        this.rows = [];
    }
    UI.prototype.span = function () {
        var cols = this.div.apply(this, arguments);
        cols.span = true;
    };
    UI.prototype.resetOutput = function () {
        this.rows = [];
    };
    UI.prototype.div = function () {
        if (arguments.length === 0)
            this.div('');
        if (this.wrap && this._shouldApplyLayoutDSL.apply(this, arguments)) {
            return this._applyLayoutDSL(arguments[0]);
        }
        var cols = [];
        for (var i = 0, arg; (arg = arguments[i]) !== undefined; i++) {
            if (typeof arg === 'string')
                cols.push(this._colFromString(arg));
            else
                cols.push(arg);
        }
        this.rows.push(cols);
        return cols;
    };
    UI.prototype._shouldApplyLayoutDSL = function () {
        return arguments.length === 1 && typeof arguments[0] === 'string' &&
            /[\t\n]/.test(arguments[0]);
    };
    UI.prototype._applyLayoutDSL = function (str) {
        var _this = this;
        var rows = str.split('\n');
        var leftColumnWidth = 0;
        // simple heuristic for layout, make sure the
        // second column lines up along the left-hand.
        // don't allow the first column to take up more
        // than 50% of the screen.
        rows.forEach(function (row) {
            var columns = row.split('\t');
            if (columns.length > 1 && stringWidth(columns[0]) > leftColumnWidth) {
                leftColumnWidth = Math.min(Math.floor(_this.width * 0.5), stringWidth(columns[0]));
            }
        });
        // generate a table:
        //  replacing ' ' with padding calculations.
        //  using the algorithmically generated width.
        rows.forEach(function (row) {
            var columns = row.split('\t');
            _this.div.apply(_this, columns.map(function (r, i) {
                return {
                    text: r.trim(),
                    padding: _this._measurePadding(r),
                    width: (i === 0 && columns.length > 1) ? leftColumnWidth : undefined
                };
            }));
        });
        return this.rows[this.rows.length - 1];
    };
    UI.prototype._colFromString = function (str) {
        return {
            text: str,
            padding: this._measurePadding(str)
        };
    };
    UI.prototype._measurePadding = function (str) {
        // measure padding without ansi escape codes
        var noAnsi = stripAnsi(str);
        return [0, noAnsi.match(/\s*$/)[0].length, 0, noAnsi.match(/^\s*/)[0].length];
    };
    UI.prototype.toString = function () {
        var _this = this;
        var lines = [];
        _this.rows.forEach(function (row, i) {
            _this.rowToString(row, lines);
        });
        // don't display any lines with the
        // hidden flag set.
        lines = lines.filter(function (line) {
            return !line.hidden;
        });
        return lines.map(function (line) {
            return line.text;
        }).join('\n');
    };
    UI.prototype.rowToString = function (row, lines) {
        var _this = this;
        var padding;
        var rrows = this._rasterize(row);
        var str = '';
        var ts;
        var width;
        var wrapWidth;
        rrows.forEach(function (rrow, r) {
            str = '';
            rrow.forEach(function (col, c) {
                ts = ''; // temporary string used during alignment/padding.
                width = row[c].width; // the width with padding.
                wrapWidth = _this._negatePadding(row[c]); // the width without padding.
                ts += col;
                for (var i = 0; i < wrapWidth - stringWidth(col); i++) {
                    ts += ' ';
                }
                // align the string within its column.
                if (row[c].align && row[c].align !== 'left' && _this.wrap) {
                    ts = align[row[c].align](ts, wrapWidth);
                    if (stringWidth(ts) < wrapWidth)
                        ts += new Array(width - stringWidth(ts)).join(' ');
                }
                // apply border and padding to string.
                padding = row[c].padding || [0, 0, 0, 0];
                if (padding[left])
                    str += new Array(padding[left] + 1).join(' ');
                str += addBorder(row[c], ts, '| ');
                str += ts;
                str += addBorder(row[c], ts, ' |');
                if (padding[right])
                    str += new Array(padding[right] + 1).join(' ');
                // if prior row is span, try to render the
                // current row on the prior line.
                if (r === 0 && lines.length > 0) {
                    str = _this._renderInline(str, lines[lines.length - 1]);
                }
            });
            // remove trailing whitespace.
            lines.push({
                text: str.replace(/ +$/, ''),
                span: row.span
            });
        });
        return lines;
    };
    function addBorder(col, ts, style) {
        if (col.border) {
            if (/[.']-+[.']/.test(ts))
                return '';
            else if (ts.trim().length)
                return style;
            else
                return '  ';
        }
        return '';
    }
    // if the full 'source' can render in
    // the target line, do so.
    UI.prototype._renderInline = function (source, previousLine) {
        var leadingWhitespace = source.match(/^ */)[0].length;
        var target = previousLine.text;
        var targetTextWidth = stringWidth(target.trimRight());
        if (!previousLine.span)
            return source;
        // if we're not applying wrapping logic,
        // just always append to the span.
        if (!this.wrap) {
            previousLine.hidden = true;
            return target + source;
        }
        if (leadingWhitespace < targetTextWidth)
            return source;
        previousLine.hidden = true;
        return target.trimRight() + new Array(leadingWhitespace - targetTextWidth + 1).join(' ') + source.trimLeft();
    };
    UI.prototype._rasterize = function (row) {
        var _this = this;
        var i;
        var rrow;
        var rrows = [];
        var widths = this._columnWidths(row);
        var wrapped;
        // word wrap all columns, and create
        // a data-structure that is easy to rasterize.
        row.forEach(function (col, c) {
            // leave room for left and right padding.
            col.width = widths[c];
            if (_this.wrap)
                wrapped = wrap(col.text, _this._negatePadding(col), { hard: true }).split('\n');
            else
                wrapped = col.text.split('\n');
            if (col.border) {
                wrapped.unshift('.' + new Array(_this._negatePadding(col) + 3).join('-') + '.');
                wrapped.push("'" + new Array(_this._negatePadding(col) + 3).join('-') + "'");
            }
            // add top and bottom padding.
            if (col.padding) {
                for (i = 0; i < (col.padding[top] || 0); i++)
                    wrapped.unshift('');
                for (i = 0; i < (col.padding[bottom] || 0); i++)
                    wrapped.push('');
            }
            wrapped.forEach(function (str, r) {
                if (!rrows[r])
                    rrows.push([]);
                rrow = rrows[r];
                for (var i = 0; i < c; i++) {
                    if (rrow[i] === undefined)
                        rrow.push('');
                }
                rrow.push(str);
            });
        });
        return rrows;
    };
    UI.prototype._negatePadding = function (col) {
        var wrapWidth = col.width;
        if (col.padding)
            wrapWidth -= (col.padding[left] || 0) + (col.padding[right] || 0);
        if (col.border)
            wrapWidth -= 4;
        return wrapWidth;
    };
    UI.prototype._columnWidths = function (row) {
        var _this = this;
        var widths = [];
        var unset = row.length;
        var unsetWidth;
        var remainingWidth = this.width;
        // column widths can be set in config.
        row.forEach(function (col, i) {
            if (col.width) {
                unset--;
                widths[i] = col.width;
                remainingWidth -= col.width;
            }
            else {
                widths[i] = undefined;
            }
        });
        // any unset widths should be calculated.
        if (unset)
            unsetWidth = Math.floor(remainingWidth / unset);
        widths.forEach(function (w, i) {
            if (!_this.wrap)
                widths[i] = row[i].width || stringWidth(row[i].text);
            else if (w === undefined)
                widths[i] = Math.max(unsetWidth, _minWidth(row[i]));
        });
        return widths;
    };
    // calculates the minimum width of
    // a column, based on padding preferences.
    function _minWidth(col) {
        var padding = col.padding || [];
        var minWidth = 1 + (padding[left] || 0) + (padding[right] || 0);
        if (col.border)
            minWidth += 4;
        return minWidth;
    }
    function getWindowWidth() {
        if (typeof process === 'object' && process.stdout && process.stdout.columns)
            return process.stdout.columns;
    }
    function alignRight(str, width) {
        str = str.trim();
        var padding = '';
        var strWidth = stringWidth(str);
        if (strWidth < width) {
            padding = new Array(width - strWidth + 1).join(' ');
        }
        return padding + str;
    }
    function alignCenter(str, width) {
        str = str.trim();
        var padding = '';
        var strWidth = stringWidth(str.trim());
        if (strWidth < width) {
            padding = new Array(parseInt((width - strWidth) / 2, 10) + 1).join(' ');
        }
        return padding + str;
    }
    module.exports = function (opts) {
        opts = opts || {};
        return new UI({
            width: (opts || {}).width || getWindowWidth() || 80,
            wrap: typeof opts.wrap === 'boolean' ? opts.wrap : true
        });
    };
},
/* wrap-ansi/index.js */ function _(require, module, exports) {
    const stringWidth = require(17) /* string-width */;
    const stripAnsi = require(18) /* strip-ansi */;
    const ansiStyles = require(25) /* ansi-styles */;
    const ESCAPES = new Set([
        '\u001B',
        '\u009B'
    ]);
    const END_CODE = 39;
    const wrapAnsi = code => `${ESCAPES.values().next().value}[${code}m`;
    // Calculate the length of words split on ' ', ignoring
    // the extra characters added by ansi escape codes
    const wordLengths = string => string.split(' ').map(character => stringWidth(character));
    // Wrap a long word across multiple rows
    // Ansi escape codes do not count towards length
    const wrapWord = (rows, word, columns) => {
        const characters = [...word];
        let insideEscape = false;
        let visible = stringWidth(stripAnsi(rows[rows.length - 1]));
        for (const [index, character] of characters.entries()) {
            const characterLength = stringWidth(character);
            if (visible + characterLength <= columns) {
                rows[rows.length - 1] += character;
            }
            else {
                rows.push(character);
                visible = 0;
            }
            if (ESCAPES.has(character)) {
                insideEscape = true;
            }
            else if (insideEscape && character === 'm') {
                insideEscape = false;
                continue;
            }
            if (insideEscape) {
                continue;
            }
            visible += characterLength;
            if (visible === columns && index < characters.length - 1) {
                rows.push('');
                visible = 0;
            }
        }
        // It's possible that the last row we copy over is only
        // ansi escape characters, handle this edge-case
        if (!visible && rows[rows.length - 1].length > 0 && rows.length > 1) {
            rows[rows.length - 2] += rows.pop();
        }
    };
    // Trims spaces from a string ignoring invisible sequences
    const stringVisibleTrimSpacesRight = str => {
        const words = str.split(' ');
        let last = words.length;
        while (last > 0) {
            if (stringWidth(words[last - 1]) > 0) {
                break;
            }
            last--;
        }
        if (last === words.length) {
            return str;
        }
        return words.slice(0, last).join(' ') + words.slice(last).join('');
    };
    // The wrap-ansi module can be invoked
    // in either 'hard' or 'soft' wrap mode
    //
    // 'hard' will never allow a string to take up more
    // than columns characters
    //
    // 'soft' allows long words to expand past the column length
    const exec = (string, columns, options = {}) => {
        if (options.trim !== false && string.trim() === '') {
            return '';
        }
        let pre = '';
        let ret = '';
        let escapeCode;
        const lengths = wordLengths(string);
        let rows = [''];
        for (const [index, word] of string.split(' ').entries()) {
            if (options.trim !== false) {
                rows[rows.length - 1] = rows[rows.length - 1].trimLeft();
            }
            let rowLength = stringWidth(rows[rows.length - 1]);
            if (index !== 0) {
                if (rowLength >= columns && (options.wordWrap === false || options.trim === false)) {
                    // If we start with a new word but the current row length equals the length of the columns, add a new row
                    rows.push('');
                    rowLength = 0;
                }
                if (rowLength > 0 || options.trim === false) {
                    rows[rows.length - 1] += ' ';
                    rowLength++;
                }
            }
            // In 'hard' wrap mode, the length of a line is
            // never allowed to extend past 'columns'
            if (options.hard && lengths[index] > columns) {
                const remainingColumns = (columns - rowLength);
                const breaksStartingThisLine = 1 + Math.floor((lengths[index] - remainingColumns - 1) / columns);
                const breaksStartingNextLine = Math.floor((lengths[index] - 1) / columns);
                if (breaksStartingNextLine < breaksStartingThisLine) {
                    rows.push('');
                }
                wrapWord(rows, word, columns);
                continue;
            }
            if (rowLength + lengths[index] > columns && rowLength > 0 && lengths[index] > 0) {
                if (options.wordWrap === false && rowLength < columns) {
                    wrapWord(rows, word, columns);
                    continue;
                }
                rows.push('');
            }
            if (rowLength + lengths[index] > columns && options.wordWrap === false) {
                wrapWord(rows, word, columns);
                continue;
            }
            rows[rows.length - 1] += word;
        }
        if (options.trim !== false) {
            rows = rows.map(stringVisibleTrimSpacesRight);
        }
        pre = rows.join('\n');
        for (const [index, character] of [...pre].entries()) {
            ret += character;
            if (ESCAPES.has(character)) {
                const code = parseFloat(/\d[^m]*/.exec(pre.slice(index, index + 4)));
                escapeCode = code === END_CODE ? null : code;
            }
            const code = ansiStyles.codes.get(Number(escapeCode));
            if (escapeCode && code) {
                if (pre[index + 1] === '\n') {
                    ret += wrapAnsi(code);
                }
                else if (character === '\n') {
                    ret += wrapAnsi(escapeCode);
                }
            }
        }
        return ret;
    };
    // For each newline, invoke the method separately
    module.exports = (string, columns, options) => {
        return String(string)
            .normalize()
            .split('\n')
            .map(line => exec(line, columns, options))
            .join('\n');
    };
},
/* ansi-styles/index.js */ function _(require, module, exports) {
    const wrapAnsi16 = (fn, offset) => (...args) => {
        const code = fn(...args);
        return `\u001B[${code + offset}m`;
    };
    const wrapAnsi256 = (fn, offset) => (...args) => {
        const code = fn(...args);
        return `\u001B[${38 + offset};5;${code}m`;
    };
    const wrapAnsi16m = (fn, offset) => (...args) => {
        const rgb = fn(...args);
        return `\u001B[${38 + offset};2;${rgb[0]};${rgb[1]};${rgb[2]}m`;
    };
    const ansi2ansi = n => n;
    const rgb2rgb = (r, g, b) => [r, g, b];
    const setLazyProperty = (object, property, get) => {
        Object.defineProperty(object, property, {
            get: () => {
                const value = get();
                Object.defineProperty(object, property, {
                    value,
                    enumerable: true,
                    configurable: true
                });
                return value;
            },
            enumerable: true,
            configurable: true
        });
    };
    /** @type {typeof import('color-convert')} */
    let colorConvert;
    const makeDynamicStyles = (wrap, targetSpace, identity, isBackground) => {
        if (colorConvert === undefined) {
            colorConvert = require(26) /* color-convert */;
        }
        const offset = isBackground ? 10 : 0;
        const styles = {};
        for (const [sourceSpace, suite] of Object.entries(colorConvert)) {
            const name = sourceSpace === 'ansi16' ? 'ansi' : sourceSpace;
            if (sourceSpace === targetSpace) {
                styles[name] = wrap(identity, offset);
            }
            else if (typeof suite === 'object') {
                styles[name] = wrap(suite[targetSpace], offset);
            }
        }
        return styles;
    };
    function assembleStyles() {
        const codes = new Map();
        const styles = {
            modifier: {
                reset: [0, 0],
                // 21 isn't widely supported and 22 does the same thing
                bold: [1, 22],
                dim: [2, 22],
                italic: [3, 23],
                underline: [4, 24],
                inverse: [7, 27],
                hidden: [8, 28],
                strikethrough: [9, 29]
            },
            color: {
                black: [30, 39],
                red: [31, 39],
                green: [32, 39],
                yellow: [33, 39],
                blue: [34, 39],
                magenta: [35, 39],
                cyan: [36, 39],
                white: [37, 39],
                // Bright color
                blackBright: [90, 39],
                redBright: [91, 39],
                greenBright: [92, 39],
                yellowBright: [93, 39],
                blueBright: [94, 39],
                magentaBright: [95, 39],
                cyanBright: [96, 39],
                whiteBright: [97, 39]
            },
            bgColor: {
                bgBlack: [40, 49],
                bgRed: [41, 49],
                bgGreen: [42, 49],
                bgYellow: [43, 49],
                bgBlue: [44, 49],
                bgMagenta: [45, 49],
                bgCyan: [46, 49],
                bgWhite: [47, 49],
                // Bright color
                bgBlackBright: [100, 49],
                bgRedBright: [101, 49],
                bgGreenBright: [102, 49],
                bgYellowBright: [103, 49],
                bgBlueBright: [104, 49],
                bgMagentaBright: [105, 49],
                bgCyanBright: [106, 49],
                bgWhiteBright: [107, 49]
            }
        };
        // Alias bright black as gray (and grey)
        styles.color.gray = styles.color.blackBright;
        styles.bgColor.bgGray = styles.bgColor.bgBlackBright;
        styles.color.grey = styles.color.blackBright;
        styles.bgColor.bgGrey = styles.bgColor.bgBlackBright;
        for (const [groupName, group] of Object.entries(styles)) {
            for (const [styleName, style] of Object.entries(group)) {
                styles[styleName] = {
                    open: `\u001B[${style[0]}m`,
                    close: `\u001B[${style[1]}m`
                };
                group[styleName] = styles[styleName];
                codes.set(style[0], style[1]);
            }
            Object.defineProperty(styles, groupName, {
                value: group,
                enumerable: false
            });
        }
        Object.defineProperty(styles, 'codes', {
            value: codes,
            enumerable: false
        });
        styles.color.close = '\u001B[39m';
        styles.bgColor.close = '\u001B[49m';
        setLazyProperty(styles.color, 'ansi', () => makeDynamicStyles(wrapAnsi16, 'ansi16', ansi2ansi, false));
        setLazyProperty(styles.color, 'ansi256', () => makeDynamicStyles(wrapAnsi256, 'ansi256', ansi2ansi, false));
        setLazyProperty(styles.color, 'ansi16m', () => makeDynamicStyles(wrapAnsi16m, 'rgb', rgb2rgb, false));
        setLazyProperty(styles.bgColor, 'ansi', () => makeDynamicStyles(wrapAnsi16, 'ansi16', ansi2ansi, true));
        setLazyProperty(styles.bgColor, 'ansi256', () => makeDynamicStyles(wrapAnsi256, 'ansi256', ansi2ansi, true));
        setLazyProperty(styles.bgColor, 'ansi16m', () => makeDynamicStyles(wrapAnsi16m, 'rgb', rgb2rgb, true));
        return styles;
    }
    // Make the export immutable
    Object.defineProperty(module, 'exports', {
        enumerable: true,
        get: assembleStyles
    });
},
/* color-convert/index.js */ function _(require, module, exports) {
    const conversions = require(27) /* ./conversions */;
    const route = require(29) /* ./route */;
    const convert = {};
    const models = Object.keys(conversions);
    function wrapRaw(fn) {
        const wrappedFn = function (...args) {
            const arg0 = args[0];
            if (arg0 === undefined || arg0 === null) {
                return arg0;
            }
            if (arg0.length > 1) {
                args = arg0;
            }
            return fn(args);
        };
        // Preserve .conversion property if there is one
        if ('conversion' in fn) {
            wrappedFn.conversion = fn.conversion;
        }
        return wrappedFn;
    }
    function wrapRounded(fn) {
        const wrappedFn = function (...args) {
            const arg0 = args[0];
            if (arg0 === undefined || arg0 === null) {
                return arg0;
            }
            if (arg0.length > 1) {
                args = arg0;
            }
            const result = fn(args);
            // We're assuming the result is an array here.
            // see notice in conversions.js; don't use box types
            // in conversion functions.
            if (typeof result === 'object') {
                for (let len = result.length, i = 0; i < len; i++) {
                    result[i] = Math.round(result[i]);
                }
            }
            return result;
        };
        // Preserve .conversion property if there is one
        if ('conversion' in fn) {
            wrappedFn.conversion = fn.conversion;
        }
        return wrappedFn;
    }
    models.forEach(fromModel => {
        convert[fromModel] = {};
        Object.defineProperty(convert[fromModel], 'channels', { value: conversions[fromModel].channels });
        Object.defineProperty(convert[fromModel], 'labels', { value: conversions[fromModel].labels });
        const routes = route(fromModel);
        const routeModels = Object.keys(routes);
        routeModels.forEach(toModel => {
            const fn = routes[toModel];
            convert[fromModel][toModel] = wrapRounded(fn);
            convert[fromModel][toModel].raw = wrapRaw(fn);
        });
    });
    module.exports = convert;
},
/* color-convert/conversions.js */ function _(require, module, exports) {
    /* MIT license */
    /* eslint-disable no-mixed-operators */
    const cssKeywords = require(28) /* color-name */;
    // NOTE: conversions should only return primitive values (i.e. arrays, or
    //       values that give correct `typeof` results).
    //       do not use box values types (i.e. Number(), String(), etc.)
    const reverseKeywords = {};
    for (const key of Object.keys(cssKeywords)) {
        reverseKeywords[cssKeywords[key]] = key;
    }
    const convert = {
        rgb: { channels: 3, labels: 'rgb' },
        hsl: { channels: 3, labels: 'hsl' },
        hsv: { channels: 3, labels: 'hsv' },
        hwb: { channels: 3, labels: 'hwb' },
        cmyk: { channels: 4, labels: 'cmyk' },
        xyz: { channels: 3, labels: 'xyz' },
        lab: { channels: 3, labels: 'lab' },
        lch: { channels: 3, labels: 'lch' },
        hex: { channels: 1, labels: ['hex'] },
        keyword: { channels: 1, labels: ['keyword'] },
        ansi16: { channels: 1, labels: ['ansi16'] },
        ansi256: { channels: 1, labels: ['ansi256'] },
        hcg: { channels: 3, labels: ['h', 'c', 'g'] },
        apple: { channels: 3, labels: ['r16', 'g16', 'b16'] },
        gray: { channels: 1, labels: ['gray'] }
    };
    module.exports = convert;
    // Hide .channels and .labels properties
    for (const model of Object.keys(convert)) {
        if (!('channels' in convert[model])) {
            throw new Error('missing channels property: ' + model);
        }
        if (!('labels' in convert[model])) {
            throw new Error('missing channel labels property: ' + model);
        }
        if (convert[model].labels.length !== convert[model].channels) {
            throw new Error('channel and label counts mismatch: ' + model);
        }
        const { channels, labels } = convert[model];
        delete convert[model].channels;
        delete convert[model].labels;
        Object.defineProperty(convert[model], 'channels', { value: channels });
        Object.defineProperty(convert[model], 'labels', { value: labels });
    }
    convert.rgb.hsl = function (rgb) {
        const r = rgb[0] / 255;
        const g = rgb[1] / 255;
        const b = rgb[2] / 255;
        const min = Math.min(r, g, b);
        const max = Math.max(r, g, b);
        const delta = max - min;
        let h;
        let s;
        if (max === min) {
            h = 0;
        }
        else if (r === max) {
            h = (g - b) / delta;
        }
        else if (g === max) {
            h = 2 + (b - r) / delta;
        }
        else if (b === max) {
            h = 4 + (r - g) / delta;
        }
        h = Math.min(h * 60, 360);
        if (h < 0) {
            h += 360;
        }
        const l = (min + max) / 2;
        if (max === min) {
            s = 0;
        }
        else if (l <= 0.5) {
            s = delta / (max + min);
        }
        else {
            s = delta / (2 - max - min);
        }
        return [h, s * 100, l * 100];
    };
    convert.rgb.hsv = function (rgb) {
        let rdif;
        let gdif;
        let bdif;
        let h;
        let s;
        const r = rgb[0] / 255;
        const g = rgb[1] / 255;
        const b = rgb[2] / 255;
        const v = Math.max(r, g, b);
        const diff = v - Math.min(r, g, b);
        const diffc = function (c) {
            return (v - c) / 6 / diff + 1 / 2;
        };
        if (diff === 0) {
            h = 0;
            s = 0;
        }
        else {
            s = diff / v;
            rdif = diffc(r);
            gdif = diffc(g);
            bdif = diffc(b);
            if (r === v) {
                h = bdif - gdif;
            }
            else if (g === v) {
                h = (1 / 3) + rdif - bdif;
            }
            else if (b === v) {
                h = (2 / 3) + gdif - rdif;
            }
            if (h < 0) {
                h += 1;
            }
            else if (h > 1) {
                h -= 1;
            }
        }
        return [
            h * 360,
            s * 100,
            v * 100
        ];
    };
    convert.rgb.hwb = function (rgb) {
        const r = rgb[0];
        const g = rgb[1];
        let b = rgb[2];
        const h = convert.rgb.hsl(rgb)[0];
        const w = 1 / 255 * Math.min(r, Math.min(g, b));
        b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));
        return [h, w * 100, b * 100];
    };
    convert.rgb.cmyk = function (rgb) {
        const r = rgb[0] / 255;
        const g = rgb[1] / 255;
        const b = rgb[2] / 255;
        const k = Math.min(1 - r, 1 - g, 1 - b);
        const c = (1 - r - k) / (1 - k) || 0;
        const m = (1 - g - k) / (1 - k) || 0;
        const y = (1 - b - k) / (1 - k) || 0;
        return [c * 100, m * 100, y * 100, k * 100];
    };
    function comparativeDistance(x, y) {
        /*
            See https://en.m.wikipedia.org/wiki/Euclidean_distance#Squared_Euclidean_distance
        */
        return (((x[0] - y[0]) ** 2) +
            ((x[1] - y[1]) ** 2) +
            ((x[2] - y[2]) ** 2));
    }
    convert.rgb.keyword = function (rgb) {
        const reversed = reverseKeywords[rgb];
        if (reversed) {
            return reversed;
        }
        let currentClosestDistance = Infinity;
        let currentClosestKeyword;
        for (const keyword of Object.keys(cssKeywords)) {
            const value = cssKeywords[keyword];
            // Compute comparative distance
            const distance = comparativeDistance(rgb, value);
            // Check if its less, if so set as closest
            if (distance < currentClosestDistance) {
                currentClosestDistance = distance;
                currentClosestKeyword = keyword;
            }
        }
        return currentClosestKeyword;
    };
    convert.keyword.rgb = function (keyword) {
        return cssKeywords[keyword];
    };
    convert.rgb.xyz = function (rgb) {
        let r = rgb[0] / 255;
        let g = rgb[1] / 255;
        let b = rgb[2] / 255;
        // Assume sRGB
        r = r > 0.04045 ? (((r + 0.055) / 1.055) ** 2.4) : (r / 12.92);
        g = g > 0.04045 ? (((g + 0.055) / 1.055) ** 2.4) : (g / 12.92);
        b = b > 0.04045 ? (((b + 0.055) / 1.055) ** 2.4) : (b / 12.92);
        const x = (r * 0.4124) + (g * 0.3576) + (b * 0.1805);
        const y = (r * 0.2126) + (g * 0.7152) + (b * 0.0722);
        const z = (r * 0.0193) + (g * 0.1192) + (b * 0.9505);
        return [x * 100, y * 100, z * 100];
    };
    convert.rgb.lab = function (rgb) {
        const xyz = convert.rgb.xyz(rgb);
        let x = xyz[0];
        let y = xyz[1];
        let z = xyz[2];
        x /= 95.047;
        y /= 100;
        z /= 108.883;
        x = x > 0.008856 ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
        y = y > 0.008856 ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
        z = z > 0.008856 ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);
        const l = (116 * y) - 16;
        const a = 500 * (x - y);
        const b = 200 * (y - z);
        return [l, a, b];
    };
    convert.hsl.rgb = function (hsl) {
        const h = hsl[0] / 360;
        const s = hsl[1] / 100;
        const l = hsl[2] / 100;
        let t2;
        let t3;
        let val;
        if (s === 0) {
            val = l * 255;
            return [val, val, val];
        }
        if (l < 0.5) {
            t2 = l * (1 + s);
        }
        else {
            t2 = l + s - l * s;
        }
        const t1 = 2 * l - t2;
        const rgb = [0, 0, 0];
        for (let i = 0; i < 3; i++) {
            t3 = h + 1 / 3 * -(i - 1);
            if (t3 < 0) {
                t3++;
            }
            if (t3 > 1) {
                t3--;
            }
            if (6 * t3 < 1) {
                val = t1 + (t2 - t1) * 6 * t3;
            }
            else if (2 * t3 < 1) {
                val = t2;
            }
            else if (3 * t3 < 2) {
                val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
            }
            else {
                val = t1;
            }
            rgb[i] = val * 255;
        }
        return rgb;
    };
    convert.hsl.hsv = function (hsl) {
        const h = hsl[0];
        let s = hsl[1] / 100;
        let l = hsl[2] / 100;
        let smin = s;
        const lmin = Math.max(l, 0.01);
        l *= 2;
        s *= (l <= 1) ? l : 2 - l;
        smin *= lmin <= 1 ? lmin : 2 - lmin;
        const v = (l + s) / 2;
        const sv = l === 0 ? (2 * smin) / (lmin + smin) : (2 * s) / (l + s);
        return [h, sv * 100, v * 100];
    };
    convert.hsv.rgb = function (hsv) {
        const h = hsv[0] / 60;
        const s = hsv[1] / 100;
        let v = hsv[2] / 100;
        const hi = Math.floor(h) % 6;
        const f = h - Math.floor(h);
        const p = 255 * v * (1 - s);
        const q = 255 * v * (1 - (s * f));
        const t = 255 * v * (1 - (s * (1 - f)));
        v *= 255;
        switch (hi) {
            case 0:
                return [v, t, p];
            case 1:
                return [q, v, p];
            case 2:
                return [p, v, t];
            case 3:
                return [p, q, v];
            case 4:
                return [t, p, v];
            case 5:
                return [v, p, q];
        }
    };
    convert.hsv.hsl = function (hsv) {
        const h = hsv[0];
        const s = hsv[1] / 100;
        const v = hsv[2] / 100;
        const vmin = Math.max(v, 0.01);
        let sl;
        let l;
        l = (2 - s) * v;
        const lmin = (2 - s) * vmin;
        sl = s * vmin;
        sl /= (lmin <= 1) ? lmin : 2 - lmin;
        sl = sl || 0;
        l /= 2;
        return [h, sl * 100, l * 100];
    };
    // http://dev.w3.org/csswg/css-color/#hwb-to-rgb
    convert.hwb.rgb = function (hwb) {
        const h = hwb[0] / 360;
        let wh = hwb[1] / 100;
        let bl = hwb[2] / 100;
        const ratio = wh + bl;
        let f;
        // Wh + bl cant be > 1
        if (ratio > 1) {
            wh /= ratio;
            bl /= ratio;
        }
        const i = Math.floor(6 * h);
        const v = 1 - bl;
        f = 6 * h - i;
        if ((i & 0x01) !== 0) {
            f = 1 - f;
        }
        const n = wh + f * (v - wh); // Linear interpolation
        let r;
        let g;
        let b;
        /* eslint-disable max-statements-per-line,no-multi-spaces */
        switch (i) {
            default:
            case 6:
            case 0:
                r = v;
                g = n;
                b = wh;
                break;
            case 1:
                r = n;
                g = v;
                b = wh;
                break;
            case 2:
                r = wh;
                g = v;
                b = n;
                break;
            case 3:
                r = wh;
                g = n;
                b = v;
                break;
            case 4:
                r = n;
                g = wh;
                b = v;
                break;
            case 5:
                r = v;
                g = wh;
                b = n;
                break;
        }
        /* eslint-enable max-statements-per-line,no-multi-spaces */
        return [r * 255, g * 255, b * 255];
    };
    convert.cmyk.rgb = function (cmyk) {
        const c = cmyk[0] / 100;
        const m = cmyk[1] / 100;
        const y = cmyk[2] / 100;
        const k = cmyk[3] / 100;
        const r = 1 - Math.min(1, c * (1 - k) + k);
        const g = 1 - Math.min(1, m * (1 - k) + k);
        const b = 1 - Math.min(1, y * (1 - k) + k);
        return [r * 255, g * 255, b * 255];
    };
    convert.xyz.rgb = function (xyz) {
        const x = xyz[0] / 100;
        const y = xyz[1] / 100;
        const z = xyz[2] / 100;
        let r;
        let g;
        let b;
        r = (x * 3.2406) + (y * -1.5372) + (z * -0.4986);
        g = (x * -0.9689) + (y * 1.8758) + (z * 0.0415);
        b = (x * 0.0557) + (y * -0.2040) + (z * 1.0570);
        // Assume sRGB
        r = r > 0.0031308
            ? ((1.055 * (r ** (1.0 / 2.4))) - 0.055)
            : r * 12.92;
        g = g > 0.0031308
            ? ((1.055 * (g ** (1.0 / 2.4))) - 0.055)
            : g * 12.92;
        b = b > 0.0031308
            ? ((1.055 * (b ** (1.0 / 2.4))) - 0.055)
            : b * 12.92;
        r = Math.min(Math.max(0, r), 1);
        g = Math.min(Math.max(0, g), 1);
        b = Math.min(Math.max(0, b), 1);
        return [r * 255, g * 255, b * 255];
    };
    convert.xyz.lab = function (xyz) {
        let x = xyz[0];
        let y = xyz[1];
        let z = xyz[2];
        x /= 95.047;
        y /= 100;
        z /= 108.883;
        x = x > 0.008856 ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
        y = y > 0.008856 ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
        z = z > 0.008856 ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);
        const l = (116 * y) - 16;
        const a = 500 * (x - y);
        const b = 200 * (y - z);
        return [l, a, b];
    };
    convert.lab.xyz = function (lab) {
        const l = lab[0];
        const a = lab[1];
        const b = lab[2];
        let x;
        let y;
        let z;
        y = (l + 16) / 116;
        x = a / 500 + y;
        z = y - b / 200;
        const y2 = y ** 3;
        const x2 = x ** 3;
        const z2 = z ** 3;
        y = y2 > 0.008856 ? y2 : (y - 16 / 116) / 7.787;
        x = x2 > 0.008856 ? x2 : (x - 16 / 116) / 7.787;
        z = z2 > 0.008856 ? z2 : (z - 16 / 116) / 7.787;
        x *= 95.047;
        y *= 100;
        z *= 108.883;
        return [x, y, z];
    };
    convert.lab.lch = function (lab) {
        const l = lab[0];
        const a = lab[1];
        const b = lab[2];
        let h;
        const hr = Math.atan2(b, a);
        h = hr * 360 / 2 / Math.PI;
        if (h < 0) {
            h += 360;
        }
        const c = Math.sqrt(a * a + b * b);
        return [l, c, h];
    };
    convert.lch.lab = function (lch) {
        const l = lch[0];
        const c = lch[1];
        const h = lch[2];
        const hr = h / 360 * 2 * Math.PI;
        const a = c * Math.cos(hr);
        const b = c * Math.sin(hr);
        return [l, a, b];
    };
    convert.rgb.ansi16 = function (args, saturation = null) {
        const [r, g, b] = args;
        let value = saturation === null ? convert.rgb.hsv(args)[2] : saturation; // Hsv -> ansi16 optimization
        value = Math.round(value / 50);
        if (value === 0) {
            return 30;
        }
        let ansi = 30
            + ((Math.round(b / 255) << 2)
                | (Math.round(g / 255) << 1)
                | Math.round(r / 255));
        if (value === 2) {
            ansi += 60;
        }
        return ansi;
    };
    convert.hsv.ansi16 = function (args) {
        // Optimization here; we already know the value and don't need to get
        // it converted for us.
        return convert.rgb.ansi16(convert.hsv.rgb(args), args[2]);
    };
    convert.rgb.ansi256 = function (args) {
        const r = args[0];
        const g = args[1];
        const b = args[2];
        // We use the extended greyscale palette here, with the exception of
        // black and white. normal palette only has 4 greyscale shades.
        if (r === g && g === b) {
            if (r < 8) {
                return 16;
            }
            if (r > 248) {
                return 231;
            }
            return Math.round(((r - 8) / 247) * 24) + 232;
        }
        const ansi = 16
            + (36 * Math.round(r / 255 * 5))
            + (6 * Math.round(g / 255 * 5))
            + Math.round(b / 255 * 5);
        return ansi;
    };
    convert.ansi16.rgb = function (args) {
        let color = args % 10;
        // Handle greyscale
        if (color === 0 || color === 7) {
            if (args > 50) {
                color += 3.5;
            }
            color = color / 10.5 * 255;
            return [color, color, color];
        }
        const mult = (~~(args > 50) + 1) * 0.5;
        const r = ((color & 1) * mult) * 255;
        const g = (((color >> 1) & 1) * mult) * 255;
        const b = (((color >> 2) & 1) * mult) * 255;
        return [r, g, b];
    };
    convert.ansi256.rgb = function (args) {
        // Handle greyscale
        if (args >= 232) {
            const c = (args - 232) * 10 + 8;
            return [c, c, c];
        }
        args -= 16;
        let rem;
        const r = Math.floor(args / 36) / 5 * 255;
        const g = Math.floor((rem = args % 36) / 6) / 5 * 255;
        const b = (rem % 6) / 5 * 255;
        return [r, g, b];
    };
    convert.rgb.hex = function (args) {
        const integer = ((Math.round(args[0]) & 0xFF) << 16)
            + ((Math.round(args[1]) & 0xFF) << 8)
            + (Math.round(args[2]) & 0xFF);
        const string = integer.toString(16).toUpperCase();
        return '000000'.substring(string.length) + string;
    };
    convert.hex.rgb = function (args) {
        const match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
        if (!match) {
            return [0, 0, 0];
        }
        let colorString = match[0];
        if (match[0].length === 3) {
            colorString = colorString.split('').map(char => {
                return char + char;
            }).join('');
        }
        const integer = parseInt(colorString, 16);
        const r = (integer >> 16) & 0xFF;
        const g = (integer >> 8) & 0xFF;
        const b = integer & 0xFF;
        return [r, g, b];
    };
    convert.rgb.hcg = function (rgb) {
        const r = rgb[0] / 255;
        const g = rgb[1] / 255;
        const b = rgb[2] / 255;
        const max = Math.max(Math.max(r, g), b);
        const min = Math.min(Math.min(r, g), b);
        const chroma = (max - min);
        let grayscale;
        let hue;
        if (chroma < 1) {
            grayscale = min / (1 - chroma);
        }
        else {
            grayscale = 0;
        }
        if (chroma <= 0) {
            hue = 0;
        }
        else if (max === r) {
            hue = ((g - b) / chroma) % 6;
        }
        else if (max === g) {
            hue = 2 + (b - r) / chroma;
        }
        else {
            hue = 4 + (r - g) / chroma;
        }
        hue /= 6;
        hue %= 1;
        return [hue * 360, chroma * 100, grayscale * 100];
    };
    convert.hsl.hcg = function (hsl) {
        const s = hsl[1] / 100;
        const l = hsl[2] / 100;
        const c = l < 0.5 ? (2.0 * s * l) : (2.0 * s * (1.0 - l));
        let f = 0;
        if (c < 1.0) {
            f = (l - 0.5 * c) / (1.0 - c);
        }
        return [hsl[0], c * 100, f * 100];
    };
    convert.hsv.hcg = function (hsv) {
        const s = hsv[1] / 100;
        const v = hsv[2] / 100;
        const c = s * v;
        let f = 0;
        if (c < 1.0) {
            f = (v - c) / (1 - c);
        }
        return [hsv[0], c * 100, f * 100];
    };
    convert.hcg.rgb = function (hcg) {
        const h = hcg[0] / 360;
        const c = hcg[1] / 100;
        const g = hcg[2] / 100;
        if (c === 0.0) {
            return [g * 255, g * 255, g * 255];
        }
        const pure = [0, 0, 0];
        const hi = (h % 1) * 6;
        const v = hi % 1;
        const w = 1 - v;
        let mg = 0;
        /* eslint-disable max-statements-per-line */
        switch (Math.floor(hi)) {
            case 0:
                pure[0] = 1;
                pure[1] = v;
                pure[2] = 0;
                break;
            case 1:
                pure[0] = w;
                pure[1] = 1;
                pure[2] = 0;
                break;
            case 2:
                pure[0] = 0;
                pure[1] = 1;
                pure[2] = v;
                break;
            case 3:
                pure[0] = 0;
                pure[1] = w;
                pure[2] = 1;
                break;
            case 4:
                pure[0] = v;
                pure[1] = 0;
                pure[2] = 1;
                break;
            default:
                pure[0] = 1;
                pure[1] = 0;
                pure[2] = w;
        }
        /* eslint-enable max-statements-per-line */
        mg = (1.0 - c) * g;
        return [
            (c * pure[0] + mg) * 255,
            (c * pure[1] + mg) * 255,
            (c * pure[2] + mg) * 255
        ];
    };
    convert.hcg.hsv = function (hcg) {
        const c = hcg[1] / 100;
        const g = hcg[2] / 100;
        const v = c + g * (1.0 - c);
        let f = 0;
        if (v > 0.0) {
            f = c / v;
        }
        return [hcg[0], f * 100, v * 100];
    };
    convert.hcg.hsl = function (hcg) {
        const c = hcg[1] / 100;
        const g = hcg[2] / 100;
        const l = g * (1.0 - c) + 0.5 * c;
        let s = 0;
        if (l > 0.0 && l < 0.5) {
            s = c / (2 * l);
        }
        else if (l >= 0.5 && l < 1.0) {
            s = c / (2 * (1 - l));
        }
        return [hcg[0], s * 100, l * 100];
    };
    convert.hcg.hwb = function (hcg) {
        const c = hcg[1] / 100;
        const g = hcg[2] / 100;
        const v = c + g * (1.0 - c);
        return [hcg[0], (v - c) * 100, (1 - v) * 100];
    };
    convert.hwb.hcg = function (hwb) {
        const w = hwb[1] / 100;
        const b = hwb[2] / 100;
        const v = 1 - b;
        const c = v - w;
        let g = 0;
        if (c < 1) {
            g = (v - c) / (1 - c);
        }
        return [hwb[0], c * 100, g * 100];
    };
    convert.apple.rgb = function (apple) {
        return [(apple[0] / 65535) * 255, (apple[1] / 65535) * 255, (apple[2] / 65535) * 255];
    };
    convert.rgb.apple = function (rgb) {
        return [(rgb[0] / 255) * 65535, (rgb[1] / 255) * 65535, (rgb[2] / 255) * 65535];
    };
    convert.gray.rgb = function (args) {
        return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
    };
    convert.gray.hsl = function (args) {
        return [0, 0, args[0]];
    };
    convert.gray.hsv = convert.gray.hsl;
    convert.gray.hwb = function (gray) {
        return [0, 100, gray[0]];
    };
    convert.gray.cmyk = function (gray) {
        return [0, 0, 0, gray[0]];
    };
    convert.gray.lab = function (gray) {
        return [gray[0], 0, 0];
    };
    convert.gray.hex = function (gray) {
        const val = Math.round(gray[0] / 100 * 255) & 0xFF;
        const integer = (val << 16) + (val << 8) + val;
        const string = integer.toString(16).toUpperCase();
        return '000000'.substring(string.length) + string;
    };
    convert.rgb.gray = function (rgb) {
        const val = (rgb[0] + rgb[1] + rgb[2]) / 3;
        return [val / 255 * 100];
    };
},
/* color-name/index.js */ function _(require, module, exports) {
    module.exports = {
        "aliceblue": [240, 248, 255],
        "antiquewhite": [250, 235, 215],
        "aqua": [0, 255, 255],
        "aquamarine": [127, 255, 212],
        "azure": [240, 255, 255],
        "beige": [245, 245, 220],
        "bisque": [255, 228, 196],
        "black": [0, 0, 0],
        "blanchedalmond": [255, 235, 205],
        "blue": [0, 0, 255],
        "blueviolet": [138, 43, 226],
        "brown": [165, 42, 42],
        "burlywood": [222, 184, 135],
        "cadetblue": [95, 158, 160],
        "chartreuse": [127, 255, 0],
        "chocolate": [210, 105, 30],
        "coral": [255, 127, 80],
        "cornflowerblue": [100, 149, 237],
        "cornsilk": [255, 248, 220],
        "crimson": [220, 20, 60],
        "cyan": [0, 255, 255],
        "darkblue": [0, 0, 139],
        "darkcyan": [0, 139, 139],
        "darkgoldenrod": [184, 134, 11],
        "darkgray": [169, 169, 169],
        "darkgreen": [0, 100, 0],
        "darkgrey": [169, 169, 169],
        "darkkhaki": [189, 183, 107],
        "darkmagenta": [139, 0, 139],
        "darkolivegreen": [85, 107, 47],
        "darkorange": [255, 140, 0],
        "darkorchid": [153, 50, 204],
        "darkred": [139, 0, 0],
        "darksalmon": [233, 150, 122],
        "darkseagreen": [143, 188, 143],
        "darkslateblue": [72, 61, 139],
        "darkslategray": [47, 79, 79],
        "darkslategrey": [47, 79, 79],
        "darkturquoise": [0, 206, 209],
        "darkviolet": [148, 0, 211],
        "deeppink": [255, 20, 147],
        "deepskyblue": [0, 191, 255],
        "dimgray": [105, 105, 105],
        "dimgrey": [105, 105, 105],
        "dodgerblue": [30, 144, 255],
        "firebrick": [178, 34, 34],
        "floralwhite": [255, 250, 240],
        "forestgreen": [34, 139, 34],
        "fuchsia": [255, 0, 255],
        "gainsboro": [220, 220, 220],
        "ghostwhite": [248, 248, 255],
        "gold": [255, 215, 0],
        "goldenrod": [218, 165, 32],
        "gray": [128, 128, 128],
        "green": [0, 128, 0],
        "greenyellow": [173, 255, 47],
        "grey": [128, 128, 128],
        "honeydew": [240, 255, 240],
        "hotpink": [255, 105, 180],
        "indianred": [205, 92, 92],
        "indigo": [75, 0, 130],
        "ivory": [255, 255, 240],
        "khaki": [240, 230, 140],
        "lavender": [230, 230, 250],
        "lavenderblush": [255, 240, 245],
        "lawngreen": [124, 252, 0],
        "lemonchiffon": [255, 250, 205],
        "lightblue": [173, 216, 230],
        "lightcoral": [240, 128, 128],
        "lightcyan": [224, 255, 255],
        "lightgoldenrodyellow": [250, 250, 210],
        "lightgray": [211, 211, 211],
        "lightgreen": [144, 238, 144],
        "lightgrey": [211, 211, 211],
        "lightpink": [255, 182, 193],
        "lightsalmon": [255, 160, 122],
        "lightseagreen": [32, 178, 170],
        "lightskyblue": [135, 206, 250],
        "lightslategray": [119, 136, 153],
        "lightslategrey": [119, 136, 153],
        "lightsteelblue": [176, 196, 222],
        "lightyellow": [255, 255, 224],
        "lime": [0, 255, 0],
        "limegreen": [50, 205, 50],
        "linen": [250, 240, 230],
        "magenta": [255, 0, 255],
        "maroon": [128, 0, 0],
        "mediumaquamarine": [102, 205, 170],
        "mediumblue": [0, 0, 205],
        "mediumorchid": [186, 85, 211],
        "mediumpurple": [147, 112, 219],
        "mediumseagreen": [60, 179, 113],
        "mediumslateblue": [123, 104, 238],
        "mediumspringgreen": [0, 250, 154],
        "mediumturquoise": [72, 209, 204],
        "mediumvioletred": [199, 21, 133],
        "midnightblue": [25, 25, 112],
        "mintcream": [245, 255, 250],
        "mistyrose": [255, 228, 225],
        "moccasin": [255, 228, 181],
        "navajowhite": [255, 222, 173],
        "navy": [0, 0, 128],
        "oldlace": [253, 245, 230],
        "olive": [128, 128, 0],
        "olivedrab": [107, 142, 35],
        "orange": [255, 165, 0],
        "orangered": [255, 69, 0],
        "orchid": [218, 112, 214],
        "palegoldenrod": [238, 232, 170],
        "palegreen": [152, 251, 152],
        "paleturquoise": [175, 238, 238],
        "palevioletred": [219, 112, 147],
        "papayawhip": [255, 239, 213],
        "peachpuff": [255, 218, 185],
        "peru": [205, 133, 63],
        "pink": [255, 192, 203],
        "plum": [221, 160, 221],
        "powderblue": [176, 224, 230],
        "purple": [128, 0, 128],
        "rebeccapurple": [102, 51, 153],
        "red": [255, 0, 0],
        "rosybrown": [188, 143, 143],
        "royalblue": [65, 105, 225],
        "saddlebrown": [139, 69, 19],
        "salmon": [250, 128, 114],
        "sandybrown": [244, 164, 96],
        "seagreen": [46, 139, 87],
        "seashell": [255, 245, 238],
        "sienna": [160, 82, 45],
        "silver": [192, 192, 192],
        "skyblue": [135, 206, 235],
        "slateblue": [106, 90, 205],
        "slategray": [112, 128, 144],
        "slategrey": [112, 128, 144],
        "snow": [255, 250, 250],
        "springgreen": [0, 255, 127],
        "steelblue": [70, 130, 180],
        "tan": [210, 180, 140],
        "teal": [0, 128, 128],
        "thistle": [216, 191, 216],
        "tomato": [255, 99, 71],
        "turquoise": [64, 224, 208],
        "violet": [238, 130, 238],
        "wheat": [245, 222, 179],
        "white": [255, 255, 255],
        "whitesmoke": [245, 245, 245],
        "yellow": [255, 255, 0],
        "yellowgreen": [154, 205, 50]
    };
},
/* color-convert/route.js */ function _(require, module, exports) {
    const conversions = require(27) /* ./conversions */;
    /*
        This function routes a model to all other models.
    
        all functions that are routed have a property `.conversion` attached
        to the returned synthetic function. This property is an array
        of strings, each with the steps in between the 'from' and 'to'
        color models (inclusive).
    
        conversions that are not possible simply are not included.
    */
    function buildGraph() {
        const graph = {};
        // https://jsperf.com/object-keys-vs-for-in-with-closure/3
        const models = Object.keys(conversions);
        for (let len = models.length, i = 0; i < len; i++) {
            graph[models[i]] = {
                // http://jsperf.com/1-vs-infinity
                // micro-opt, but this is simple.
                distance: -1,
                parent: null
            };
        }
        return graph;
    }
    // https://en.wikipedia.org/wiki/Breadth-first_search
    function deriveBFS(fromModel) {
        const graph = buildGraph();
        const queue = [fromModel]; // Unshift -> queue -> pop
        graph[fromModel].distance = 0;
        while (queue.length) {
            const current = queue.pop();
            const adjacents = Object.keys(conversions[current]);
            for (let len = adjacents.length, i = 0; i < len; i++) {
                const adjacent = adjacents[i];
                const node = graph[adjacent];
                if (node.distance === -1) {
                    node.distance = graph[current].distance + 1;
                    node.parent = current;
                    queue.unshift(adjacent);
                }
            }
        }
        return graph;
    }
    function link(from, to) {
        return function (args) {
            return to(from(args));
        };
    }
    function wrapConversion(toModel, graph) {
        const path = [graph[toModel].parent, toModel];
        let fn = conversions[graph[toModel].parent][toModel];
        let cur = graph[toModel].parent;
        while (graph[cur].parent) {
            path.unshift(graph[cur].parent);
            fn = link(conversions[graph[cur].parent][cur], fn);
            cur = graph[cur].parent;
        }
        fn.conversion = path;
        return fn;
    }
    module.exports = function (fromModel) {
        const graph = deriveBFS(fromModel);
        const conversion = {};
        const models = Object.keys(graph);
        for (let len = models.length, i = 0; i < len; i++) {
            const toModel = models[i];
            const node = graph[toModel];
            if (node.parent === null) {
                // No possible conversion, or this node is the source model.
                continue;
            }
            conversion[toModel] = wrapConversion(toModel, graph);
        }
        return conversion;
    };
},
/* yargs/lib/validation.js */ function _(require, module, exports) {
    const argsert = require(3) /* ./argsert */;
    const objFilter = require(21) /* ./obj-filter */;
    const specialKeys = ['$0', '--', '_'];
    // validation-type-stuff, missing params,
    // bad implications, custom checks.
    module.exports = function validation(yargs, usage, y18n) {
        const __ = y18n.__;
        const __n = y18n.__n;
        const self = {};
        // validate appropriate # of non-option
        // arguments were provided, i.e., '_'.
        self.nonOptionCount = function nonOptionCount(argv) {
            const demandedCommands = yargs.getDemandedCommands();
            // don't count currently executing commands
            const _s = argv._.length - yargs.getContext().commands.length;
            if (demandedCommands._ && (_s < demandedCommands._.min || _s > demandedCommands._.max)) {
                if (_s < demandedCommands._.min) {
                    if (demandedCommands._.minMsg !== undefined) {
                        usage.fail(
                        // replace $0 with observed, $1 with expected.
                        demandedCommands._.minMsg ? demandedCommands._.minMsg.replace(/\$0/g, _s).replace(/\$1/, demandedCommands._.min) : null);
                    }
                    else {
                        usage.fail(__n('Not enough non-option arguments: got %s, need at least %s', 'Not enough non-option arguments: got %s, need at least %s', _s, _s, demandedCommands._.min));
                    }
                }
                else if (_s > demandedCommands._.max) {
                    if (demandedCommands._.maxMsg !== undefined) {
                        usage.fail(
                        // replace $0 with observed, $1 with expected.
                        demandedCommands._.maxMsg ? demandedCommands._.maxMsg.replace(/\$0/g, _s).replace(/\$1/, demandedCommands._.max) : null);
                    }
                    else {
                        usage.fail(__n('Too many non-option arguments: got %s, maximum of %s', 'Too many non-option arguments: got %s, maximum of %s', _s, _s, demandedCommands._.max));
                    }
                }
            }
        };
        // validate the appropriate # of <required>
        // positional arguments were provided:
        self.positionalCount = function positionalCount(required, observed) {
            if (observed < required) {
                usage.fail(__n('Not enough non-option arguments: got %s, need at least %s', 'Not enough non-option arguments: got %s, need at least %s', observed, observed, required));
            }
        };
        // make sure all the required arguments are present.
        self.requiredArguments = function requiredArguments(argv) {
            const demandedOptions = yargs.getDemandedOptions();
            let missing = null;
            Object.keys(demandedOptions).forEach((key) => {
                if (!Object.prototype.hasOwnProperty.call(argv, key) || typeof argv[key] === 'undefined') {
                    missing = missing || {};
                    missing[key] = demandedOptions[key];
                }
            });
            if (missing) {
                const customMsgs = [];
                Object.keys(missing).forEach((key) => {
                    const msg = missing[key];
                    if (msg && customMsgs.indexOf(msg) < 0) {
                        customMsgs.push(msg);
                    }
                });
                const customMsg = customMsgs.length ? `\n${customMsgs.join('\n')}` : '';
                usage.fail(__n('Missing required argument: %s', 'Missing required arguments: %s', Object.keys(missing).length, Object.keys(missing).join(', ') + customMsg));
            }
        };
        // check for unknown arguments (strict-mode).
        self.unknownArguments = function unknownArguments(argv, aliases, positionalMap) {
            const commandKeys = yargs.getCommandInstance().getCommands();
            const unknown = [];
            const currentContext = yargs.getContext();
            Object.keys(argv).forEach((key) => {
                if (specialKeys.indexOf(key) === -1 &&
                    !Object.prototype.hasOwnProperty.call(positionalMap, key) &&
                    !Object.prototype.hasOwnProperty.call(yargs._getParseContext(), key) &&
                    !self.isValidAndSomeAliasIsNotNew(key, aliases)) {
                    unknown.push(key);
                }
            });
            if ((currentContext.commands.length > 0) || (commandKeys.length > 0)) {
                argv._.slice(currentContext.commands.length).forEach((key) => {
                    if (commandKeys.indexOf(key) === -1) {
                        unknown.push(key);
                    }
                });
            }
            if (unknown.length > 0) {
                usage.fail(__n('Unknown argument: %s', 'Unknown arguments: %s', unknown.length, unknown.join(', ')));
            }
        };
        self.unknownCommands = function unknownCommands(argv, aliases, positionalMap) {
            const commandKeys = yargs.getCommandInstance().getCommands();
            const unknown = [];
            const currentContext = yargs.getContext();
            if ((currentContext.commands.length > 0) || (commandKeys.length > 0)) {
                argv._.slice(currentContext.commands.length).forEach((key) => {
                    if (commandKeys.indexOf(key) === -1) {
                        unknown.push(key);
                    }
                });
            }
            if (unknown.length > 0) {
                usage.fail(__n('Unknown command: %s', 'Unknown commands: %s', unknown.length, unknown.join(', ')));
                return true;
            }
            else {
                return false;
            }
        };
        // check for a key that is not an alias, or for which every alias is new,
        // implying that it was invented by the parser, e.g., during camelization
        self.isValidAndSomeAliasIsNotNew = function isValidAndSomeAliasIsNotNew(key, aliases) {
            if (!Object.prototype.hasOwnProperty.call(aliases, key)) {
                return false;
            }
            const newAliases = yargs.parsed.newAliases;
            for (const a of [key, ...aliases[key]]) {
                if (!Object.prototype.hasOwnProperty.call(newAliases, a) || !newAliases[key]) {
                    return true;
                }
            }
            return false;
        };
        // validate arguments limited to enumerated choices
        self.limitedChoices = function limitedChoices(argv) {
            const options = yargs.getOptions();
            const invalid = {};
            if (!Object.keys(options.choices).length)
                return;
            Object.keys(argv).forEach((key) => {
                if (specialKeys.indexOf(key) === -1 &&
                    Object.prototype.hasOwnProperty.call(options.choices, key)) {
                    [].concat(argv[key]).forEach((value) => {
                        // TODO case-insensitive configurability
                        if (options.choices[key].indexOf(value) === -1 &&
                            value !== undefined) {
                            invalid[key] = (invalid[key] || []).concat(value);
                        }
                    });
                }
            });
            const invalidKeys = Object.keys(invalid);
            if (!invalidKeys.length)
                return;
            let msg = __('Invalid values:');
            invalidKeys.forEach((key) => {
                msg += `\n  ${__('Argument: %s, Given: %s, Choices: %s', key, usage.stringifiedValues(invalid[key]), usage.stringifiedValues(options.choices[key]))}`;
            });
            usage.fail(msg);
        };
        // custom checks, added using the `check` option on yargs.
        let checks = [];
        self.check = function check(f, global) {
            checks.push({
                func: f,
                global
            });
        };
        self.customChecks = function customChecks(argv, aliases) {
            for (let i = 0, f; (f = checks[i]) !== undefined; i++) {
                const func = f.func;
                let result = null;
                try {
                    result = func(argv, aliases);
                }
                catch (err) {
                    usage.fail(err.message ? err.message : err, err);
                    continue;
                }
                if (!result) {
                    usage.fail(__('Argument check failed: %s', func.toString()));
                }
                else if (typeof result === 'string' || result instanceof Error) {
                    usage.fail(result.toString(), result);
                }
            }
        };
        // check implications, argument foo implies => argument bar.
        let implied = {};
        self.implies = function implies(key, value) {
            argsert('<string|object> [array|number|string]', [key, value], arguments.length);
            if (typeof key === 'object') {
                Object.keys(key).forEach((k) => {
                    self.implies(k, key[k]);
                });
            }
            else {
                yargs.global(key);
                if (!implied[key]) {
                    implied[key] = [];
                }
                if (Array.isArray(value)) {
                    value.forEach((i) => self.implies(key, i));
                }
                else {
                    implied[key].push(value);
                }
            }
        };
        self.getImplied = function getImplied() {
            return implied;
        };
        function keyExists(argv, val) {
            // convert string '1' to number 1
            const num = Number(val);
            val = isNaN(num) ? val : num;
            if (typeof val === 'number') {
                // check length of argv._
                val = argv._.length >= val;
            }
            else if (val.match(/^--no-.+/)) {
                // check if key/value doesn't exist
                val = val.match(/^--no-(.+)/)[1];
                val = !argv[val];
            }
            else {
                // check if key/value exists
                val = argv[val];
            }
            return val;
        }
        self.implications = function implications(argv) {
            const implyFail = [];
            Object.keys(implied).forEach((key) => {
                const origKey = key;
                (implied[key] || []).forEach((value) => {
                    let key = origKey;
                    const origValue = value;
                    key = keyExists(argv, key);
                    value = keyExists(argv, value);
                    if (key && !value) {
                        implyFail.push(` ${origKey} -> ${origValue}`);
                    }
                });
            });
            if (implyFail.length) {
                let msg = `${__('Implications failed:')}\n`;
                implyFail.forEach((value) => {
                    msg += (value);
                });
                usage.fail(msg);
            }
        };
        let conflicting = {};
        self.conflicts = function conflicts(key, value) {
            argsert('<string|object> [array|string]', [key, value], arguments.length);
            if (typeof key === 'object') {
                Object.keys(key).forEach((k) => {
                    self.conflicts(k, key[k]);
                });
            }
            else {
                yargs.global(key);
                if (!conflicting[key]) {
                    conflicting[key] = [];
                }
                if (Array.isArray(value)) {
                    value.forEach((i) => self.conflicts(key, i));
                }
                else {
                    conflicting[key].push(value);
                }
            }
        };
        self.getConflicting = () => conflicting;
        self.conflicting = function conflictingFn(argv) {
            Object.keys(argv).forEach((key) => {
                if (conflicting[key]) {
                    conflicting[key].forEach((value) => {
                        // we default keys to 'undefined' that have been configured, we should not
                        // apply conflicting check unless they are a value other than 'undefined'.
                        if (value && argv[key] !== undefined && argv[value] !== undefined) {
                            usage.fail(__('Arguments %s and %s are mutually exclusive', key, value));
                        }
                    });
                }
            });
        };
        self.recommendCommands = function recommendCommands(cmd, potentialCommands) {
            const distance = require(31) /* ./levenshtein */;
            const threshold = 3; // if it takes more than three edits, let's move on.
            potentialCommands = potentialCommands.sort((a, b) => b.length - a.length);
            let recommended = null;
            let bestDistance = Infinity;
            for (let i = 0, candidate; (candidate = potentialCommands[i]) !== undefined; i++) {
                const d = distance(cmd, candidate);
                if (d <= threshold && d < bestDistance) {
                    bestDistance = d;
                    recommended = candidate;
                }
            }
            if (recommended)
                usage.fail(__('Did you mean %s?', recommended));
        };
        self.reset = function reset(localLookup) {
            implied = objFilter(implied, (k, v) => !localLookup[k]);
            conflicting = objFilter(conflicting, (k, v) => !localLookup[k]);
            checks = checks.filter(c => c.global);
            return self;
        };
        const frozens = [];
        self.freeze = function freeze() {
            const frozen = {};
            frozens.push(frozen);
            frozen.implied = implied;
            frozen.checks = checks;
            frozen.conflicting = conflicting;
        };
        self.unfreeze = function unfreeze() {
            const frozen = frozens.pop();
            implied = frozen.implied;
            checks = frozen.checks;
            conflicting = frozen.conflicting;
        };
        return self;
    };
},
/* yargs/lib/levenshtein.js */ function _(require, module, exports) {
    // Compute the edit distance between the two given strings
    module.exports = function levenshtein(a, b) {
        if (a.length === 0)
            return b.length;
        if (b.length === 0)
            return a.length;
        const matrix = [];
        // increment along the first column of each row
        let i;
        for (i = 0; i <= b.length; i++) {
            matrix[i] = [i];
        }
        // increment each column in the first row
        let j;
        for (j = 0; j <= a.length; j++) {
            matrix[0][j] = j;
        }
        // Fill in the rest of the matrix
        for (i = 1; i <= b.length; i++) {
            for (j = 1; j <= a.length; j++) {
                if (b.charAt(i - 1) === a.charAt(j - 1)) {
                    matrix[i][j] = matrix[i - 1][j - 1];
                }
                else {
                    matrix[i][j] = Math.min(matrix[i - 1][j - 1] + 1, // substitution
                    Math.min(matrix[i][j - 1] + 1, // insertion
                    matrix[i - 1][j] + 1)); // deletion
                }
            }
        }
        return matrix[b.length][a.length];
    };
},
/* y18n/index.js */ function _(require, module, exports) {
    var fs = require('fs');
    var path = require('path');
    var util = require('util');
    function Y18N(opts) {
        // configurable options.
        opts = opts || {};
        this.directory = opts.directory || './locales';
        this.updateFiles = typeof opts.updateFiles === 'boolean' ? opts.updateFiles : true;
        this.locale = opts.locale || 'en';
        this.fallbackToLanguage = typeof opts.fallbackToLanguage === 'boolean' ? opts.fallbackToLanguage : true;
        // internal stuff.
        this.cache = {};
        this.writeQueue = [];
    }
    Y18N.prototype.__ = function () {
        if (typeof arguments[0] !== 'string') {
            return this._taggedLiteral.apply(this, arguments);
        }
        var args = Array.prototype.slice.call(arguments);
        var str = args.shift();
        var cb = function () { }; // start with noop.
        if (typeof args[args.length - 1] === 'function')
            cb = args.pop();
        cb = cb || function () { }; // noop.
        if (!this.cache[this.locale])
            this._readLocaleFile();
        // we've observed a new string, update the language file.
        if (!this.cache[this.locale][str] && this.updateFiles) {
            this.cache[this.locale][str] = str;
            // include the current directory and locale,
            // since these values could change before the
            // write is performed.
            this._enqueueWrite([this.directory, this.locale, cb]);
        }
        else {
            cb();
        }
        return util.format.apply(util, [this.cache[this.locale][str] || str].concat(args));
    };
    Y18N.prototype._taggedLiteral = function (parts) {
        var args = arguments;
        var str = '';
        parts.forEach(function (part, i) {
            var arg = args[i + 1];
            str += part;
            if (typeof arg !== 'undefined') {
                str += '%s';
            }
        });
        return this.__.apply(null, [str].concat([].slice.call(arguments, 1)));
    };
    Y18N.prototype._enqueueWrite = function (work) {
        this.writeQueue.push(work);
        if (this.writeQueue.length === 1)
            this._processWriteQueue();
    };
    Y18N.prototype._processWriteQueue = function () {
        var _this = this;
        var work = this.writeQueue[0];
        // destructure the enqueued work.
        var directory = work[0];
        var locale = work[1];
        var cb = work[2];
        var languageFile = this._resolveLocaleFile(directory, locale);
        var serializedLocale = JSON.stringify(this.cache[locale], null, 2);
        fs.writeFile(languageFile, serializedLocale, 'utf-8', function (err) {
            _this.writeQueue.shift();
            if (_this.writeQueue.length > 0)
                _this._processWriteQueue();
            cb(err);
        });
    };
    Y18N.prototype._readLocaleFile = function () {
        var localeLookup = {};
        var languageFile = this._resolveLocaleFile(this.directory, this.locale);
        try {
            localeLookup = JSON.parse(fs.readFileSync(languageFile, 'utf-8'));
        }
        catch (err) {
            if (err instanceof SyntaxError) {
                err.message = 'syntax error in ' + languageFile;
            }
            if (err.code === 'ENOENT')
                localeLookup = {};
            else
                throw err;
        }
        this.cache[this.locale] = localeLookup;
    };
    Y18N.prototype._resolveLocaleFile = function (directory, locale) {
        var file = path.resolve(directory, './', locale + '.json');
        if (this.fallbackToLanguage && !this._fileExistsSync(file) && ~locale.lastIndexOf('_')) {
            // attempt fallback to language only
            var languageFile = path.resolve(directory, './', locale.split('_')[0] + '.json');
            if (this._fileExistsSync(languageFile))
                file = languageFile;
        }
        return file;
    };
    // this only exists because fs.existsSync() "will be deprecated"
    // see https://nodejs.org/api/fs.html#fs_fs_existssync_path
    Y18N.prototype._fileExistsSync = function (file) {
        try {
            return fs.statSync(file).isFile();
        }
        catch (err) {
            return false;
        }
    };
    Y18N.prototype.__n = function () {
        var args = Array.prototype.slice.call(arguments);
        var singular = args.shift();
        var plural = args.shift();
        var quantity = args.shift();
        var cb = function () { }; // start with noop.
        if (typeof args[args.length - 1] === 'function')
            cb = args.pop();
        if (!this.cache[this.locale])
            this._readLocaleFile();
        var str = quantity === 1 ? singular : plural;
        if (this.cache[this.locale][singular]) {
            str = this.cache[this.locale][singular][quantity === 1 ? 'one' : 'other'];
        }
        // we've observed a new string, update the language file.
        if (!this.cache[this.locale][singular] && this.updateFiles) {
            this.cache[this.locale][singular] = {
                one: singular,
                other: plural
            };
            // include the current directory and locale,
            // since these values could change before the
            // write is performed.
            this._enqueueWrite([this.directory, this.locale, cb]);
        }
        else {
            cb();
        }
        // if a %d placeholder is provided, add quantity
        // to the arguments expanded by util.format.
        var values = [str];
        if (~str.indexOf('%d'))
            values.push(quantity);
        return util.format.apply(util, values.concat(args));
    };
    Y18N.prototype.setLocale = function (locale) {
        this.locale = locale;
    };
    Y18N.prototype.getLocale = function () {
        return this.locale;
    };
    Y18N.prototype.updateLocale = function (obj) {
        if (!this.cache[this.locale])
            this._readLocaleFile();
        for (var key in obj) {
            this.cache[this.locale][key] = obj[key];
        }
    };
    module.exports = function (opts) {
        var y18n = new Y18N(opts);
        // bind all functions to y18n, so that
        // they can be used in isolation.
        for (var key in y18n) {
            if (typeof y18n[key] === 'function') {
                y18n[key] = y18n[key].bind(y18n);
            }
        }
        return y18n;
    };
},
/* yargs/lib/apply-extends.js */ function _(require, module, exports) {
    const fs = require('fs');
    const path = require('path');
    const YError = require(13) /* ./yerror */;
    let previouslyVisitedConfigs = [];
    function checkForCircularExtends(cfgPath) {
        if (previouslyVisitedConfigs.indexOf(cfgPath) > -1) {
            throw new YError(`Circular extended configurations: '${cfgPath}'.`);
        }
    }
    function getPathToDefaultConfig(cwd, pathToExtend) {
        return path.resolve(cwd, pathToExtend);
    }
    function mergeDeep(config1, config2) {
        const target = {};
        const isObject = obj => obj && typeof obj === 'object' && !Array.isArray(obj);
        Object.assign(target, config1);
        for (const key of Object.keys(config2)) {
            if (isObject(config2[key]) && isObject(target[key])) {
                target[key] = mergeDeep(config1[key], config2[key]);
            }
            else {
                target[key] = config2[key];
            }
        }
        return target;
    }
    function applyExtends(config, cwd, mergeExtends) {
        let defaultConfig = {};
        if (Object.prototype.hasOwnProperty.call(config, 'extends')) {
            if (typeof config.extends !== 'string')
                return defaultConfig;
            const isPath = /\.json|\..*rc$/.test(config.extends);
            let pathToDefault = null;
            if (!isPath) {
                try {
                    pathToDefault = require.resolve(config.extends);
                }
                catch (err) {
                    // most likely this simply isn't a module.
                }
            }
            else {
                pathToDefault = getPathToDefaultConfig(cwd, config.extends);
            }
            // maybe the module uses key for some other reason,
            // err on side of caution.
            if (!pathToDefault && !isPath)
                return config;
            checkForCircularExtends(pathToDefault);
            previouslyVisitedConfigs.push(pathToDefault);
            defaultConfig = isPath ? JSON.parse(fs.readFileSync(pathToDefault, 'utf8')) : require(config.extends);
            delete config.extends;
            defaultConfig = applyExtends(defaultConfig, path.dirname(pathToDefault), mergeExtends);
        }
        previouslyVisitedConfigs = [];
        return mergeExtends ? mergeDeep(defaultConfig, config) : Object.assign({}, defaultConfig, config);
    }
    module.exports = applyExtends;
},
/* yargs/lib/process-argv.js */ function _(require, module, exports) {
    function getProcessArgvBinIndex() {
        // The binary name is the first command line argument for:
        // - bundled Electron apps: bin argv1 argv2 ... argvn
        if (isBundledElectronApp())
            return 0;
        // or the second one (default) for:
        // - standard node apps: node bin.js argv1 argv2 ... argvn
        // - unbundled Electron apps: electron bin.js argv1 arg2 ... argvn
        return 1;
    }
    function isBundledElectronApp() {
        // process.defaultApp is either set by electron in an electron unbundled app, or undefined
        // see https://github.com/electron/electron/blob/master/docs/api/process.md#processdefaultapp-readonly
        return isElectronApp() && !process.defaultApp;
    }
    function isElectronApp() {
        // process.versions.electron is either set by electron, or undefined
        // see https://github.com/electron/electron/blob/master/docs/api/process.md#processversionselectron-readonly
        return !!process.versions.electron;
    }
    function getProcessArgvWithoutBin() {
        return process.argv.slice(getProcessArgvBinIndex() + 1);
    }
    function getProcessArgvBin() {
        return process.argv[getProcessArgvBinIndex()];
    }
    module.exports = {
        getProcessArgvBin,
        getProcessArgvWithoutBin
    };
},
/* get-caller-file/index.js */ function _(require, module, exports) {
    // Call this function in a another function to find out the file from
    // which that function was called from. (Inspects the v8 stack trace)
    //
    // Inspired by http://stackoverflow.com/questions/13227489
    module.exports = function getCallerFile(position) {
        if (position === void 0) {
            position = 2;
        }
        if (position >= Error.stackTraceLimit) {
            throw new TypeError('getCallerFile(position) requires position be less then Error.stackTraceLimit but position was: `' + position + '` and Error.stackTraceLimit was: `' + Error.stackTraceLimit + '`');
        }
        var oldPrepareStackTrace = Error.prepareStackTrace;
        Error.prepareStackTrace = function (_, stack) { return stack; };
        var stack = new Error().stack;
        Error.prepareStackTrace = oldPrepareStackTrace;
        if (stack !== null && typeof stack === 'object') {
            // stack[0] holds this file
            // stack[1] holds where this function was called
            // stack[2] holds the file we're interested in
            return stack[position] ? stack[position].getFileName() : undefined;
        }
    };
},
/* find-up/index.js */ function _(require, module, exports) {
    const path = require('path');
    const locatePath = require(37) /* locate-path */;
    module.exports = (filename, opts = {}) => {
        const startDir = path.resolve(opts.cwd || '');
        const { root } = path.parse(startDir);
        const filenames = [].concat(filename);
        return new Promise(resolve => {
            (function find(dir) {
                locatePath(filenames, { cwd: dir }).then(file => {
                    if (file) {
                        resolve(path.join(dir, file));
                    }
                    else if (dir === root) {
                        resolve(null);
                    }
                    else {
                        find(path.dirname(dir));
                    }
                });
            })(startDir);
        });
    };
    module.exports.sync = (filename, opts = {}) => {
        let dir = path.resolve(opts.cwd || '');
        const { root } = path.parse(dir);
        const filenames = [].concat(filename);
        // eslint-disable-next-line no-constant-condition
        while (true) {
            const file = locatePath.sync(filenames, { cwd: dir });
            if (file) {
                return path.join(dir, file);
            }
            if (dir === root) {
                return null;
            }
            dir = path.dirname(dir);
        }
    };
},
/* locate-path/index.js */ function _(require, module, exports) {
    const path = require('path');
    const pathExists = require(38) /* path-exists */;
    const pLocate = require(39) /* p-locate */;
    module.exports = (iterable, options) => {
        options = Object.assign({
            cwd: process.cwd()
        }, options);
        return pLocate(iterable, el => pathExists(path.resolve(options.cwd, el)), options);
    };
    module.exports.sync = (iterable, options) => {
        options = Object.assign({
            cwd: process.cwd()
        }, options);
        for (const el of iterable) {
            if (pathExists.sync(path.resolve(options.cwd, el))) {
                return el;
            }
        }
    };
},
/* path-exists/index.js */ function _(require, module, exports) {
    const fs = require('fs');
    module.exports = fp => new Promise(resolve => {
        fs.access(fp, err => {
            resolve(!err);
        });
    });
    module.exports.sync = fp => {
        try {
            fs.accessSync(fp);
            return true;
        }
        catch (err) {
            return false;
        }
    };
},
/* p-locate/index.js */ function _(require, module, exports) {
    const pLimit = require(40) /* p-limit */;
    class EndError extends Error {
        constructor(value) {
            super();
            this.value = value;
        }
    }
    // The input can also be a promise, so we `Promise.resolve()` it
    const testElement = (el, tester) => Promise.resolve(el).then(tester);
    // The input can also be a promise, so we `Promise.all()` them both
    const finder = el => Promise.all(el).then(val => val[1] === true && Promise.reject(new EndError(val[0])));
    module.exports = (iterable, tester, opts) => {
        opts = Object.assign({
            concurrency: Infinity,
            preserveOrder: true
        }, opts);
        const limit = pLimit(opts.concurrency);
        // Start all the promises concurrently with optional limit
        const items = [...iterable].map(el => [el, limit(testElement, el, tester)]);
        // Check the promises either serially or concurrently
        const checkLimit = pLimit(opts.preserveOrder ? 1 : Infinity);
        return Promise.all(items.map(el => checkLimit(finder, el)))
            .then(() => { })
            .catch(err => err instanceof EndError ? err.value : Promise.reject(err));
    };
},
/* p-limit/index.js */ function _(require, module, exports) {
    const pTry = require(41) /* p-try */;
    const pLimit = concurrency => {
        if (!((Number.isInteger(concurrency) || concurrency === Infinity) && concurrency > 0)) {
            return Promise.reject(new TypeError('Expected `concurrency` to be a number from 1 and up'));
        }
        const queue = [];
        let activeCount = 0;
        const next = () => {
            activeCount--;
            if (queue.length > 0) {
                queue.shift()();
            }
        };
        const run = (fn, resolve, ...args) => {
            activeCount++;
            const result = pTry(fn, ...args);
            resolve(result);
            result.then(next, next);
        };
        const enqueue = (fn, resolve, ...args) => {
            if (activeCount < concurrency) {
                run(fn, resolve, ...args);
            }
            else {
                queue.push(run.bind(null, fn, resolve, ...args));
            }
        };
        const generator = (fn, ...args) => new Promise(resolve => enqueue(fn, resolve, ...args));
        Object.defineProperties(generator, {
            activeCount: {
                get: () => activeCount
            },
            pendingCount: {
                get: () => queue.length
            }
        });
        return generator;
    };
    module.exports = pLimit;
    module.exports.default = pLimit;
},
/* p-try/index.js */ function _(require, module, exports) {
    const pTry = (fn, ...arguments_) => new Promise(resolve => {
        resolve(fn(...arguments_));
    });
    module.exports = pTry;
    // TODO: remove this in the next major version
    module.exports.default = pTry;
},
/* require-main-filename/index.js */ function _(require, module, exports) {
    module.exports = function (_require) {
        _require = _require || require;
        var main = _require.main;
        if (main && isIISNode(main))
            return handleIISNode(main);
        else
            return main ? main.filename : process.cwd();
    };
    function isIISNode(main) {
        return /\\iisnode\\/.test(main.filename);
    }
    function handleIISNode(main) {
        if (!main.children.length) {
            return main.filename;
        }
        else {
            return main.children[0].filename;
        }
    }
},
/* sys.js */ function _(require, module, exports) {
    var __importStar = (this && this.__importStar) || function (mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (Object.hasOwnProperty.call(mod, k))
                    result[k] = mod[k];
        result["default"] = mod;
        return result;
    };
    var __importDefault = (this && this.__importDefault) || function (mod) {
        return (mod && mod.__esModule) ? mod : { "default": mod };
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    const ts = __importStar(require(44) /* typescript */);
    const crypto_1 = __importDefault(require("crypto"));
    const path_1 = require("path");
    function scan(path, extensions, exclude, include, depth) {
        return ts.sys.readDirectory(path, extensions, exclude, include, depth).map((p) => path_1.normalize(p));
    }
    exports.scan = scan;
    function glob(...patterns) {
        return scan(".", undefined, undefined, patterns);
    }
    exports.glob = glob;
    exports.read = ts.sys.readFile;
    exports.write = ts.sys.writeFile;
    exports.file_exists = ts.sys.fileExists;
    exports.directory_exists = ts.sys.directoryExists;
    function rename(path, options) {
        let { dir, name, ext } = path_1.parse(path);
        if (options.dir != null) {
            if (options.base != null)
                dir = dir.replace(options.base, options.dir);
            else
                dir = options.dir;
        }
        if (options.name != null)
            name = options.name(name);
        if (options.ext != null)
            ext = options.ext;
        return path_1.format({ dir, name, ext });
    }
    exports.rename = rename;
    function hash(data) {
        return crypto_1.default.createHash("sha256").update(data).digest("hex");
    }
    exports.hash = hash;
    function hash_file(path) {
        const contents = exports.read(path);
        return contents != null ? hash(contents) : null;
    }
    exports.hash_file = hash_file;
    function read_json(path) {
        const data = exports.read(path);
        if (data == null)
            return undefined;
        else {
            try {
                return JSON.parse(data);
            }
            catch (_a) {
                return undefined;
            }
        }
    }
    exports.read_json = read_json;
},
/* typescript/lib/typescript.js */ function _(require, module, exports) {
    var __spreadArrays = (this && this.__spreadArrays) || function () {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++)
            s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    };
    var __assign = (this && this.__assign) || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    var __generator = (this && this.__generator) || function (thisArg, body) {
        var _ = { label: 0, sent: function () { if (t[0] & 1)
                throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function () { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f)
                throw new TypeError("Generator is already executing.");
            while (_)
                try {
                    if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
                        return t;
                    if (y = 0, t)
                        op = [op[0] & 2, t.value];
                    switch (op[0]) {
                        case 0:
                        case 1:
                            t = op;
                            break;
                        case 4:
                            _.label++;
                            return { value: op[1], done: false };
                        case 5:
                            _.label++;
                            y = op[1];
                            op = [0];
                            continue;
                        case 7:
                            op = _.ops.pop();
                            _.trys.pop();
                            continue;
                        default:
                            if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                                _ = 0;
                                continue;
                            }
                            if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                                _.label = op[1];
                                break;
                            }
                            if (op[0] === 6 && _.label < t[1]) {
                                _.label = t[1];
                                t = op;
                                break;
                            }
                            if (t && _.label < t[2]) {
                                _.label = t[2];
                                _.ops.push(op);
                                break;
                            }
                            if (t[2])
                                _.ops.pop();
                            _.trys.pop();
                            continue;
                    }
                    op = body.call(thisArg, _);
                }
                catch (e) {
                    op = [6, e];
                    y = 0;
                }
                finally {
                    f = t = 0;
                }
            if (op[0] & 5)
                throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
        }
    };
    var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
        if (Object.defineProperty) {
            Object.defineProperty(cooked, "raw", { value: raw });
        }
        else {
            cooked.raw = raw;
        }
        return cooked;
    };
    var __rest = (this && this.__rest) || function (s, e) {
        var t = {};
        for (var p in s)
            if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
                t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    };
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b)
                    if (b.hasOwnProperty(p))
                        d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    /* @internal */
    var ts;
    (function (ts) {
        function createMapShim() {
            /** Create a MapLike with good performance. */
            function createDictionaryObject() {
                var map = Object.create(/*prototype*/ null); // eslint-disable-line no-null/no-null
                // Using 'delete' on an object causes V8 to put the object in dictionary mode.
                // This disables creation of hidden classes, which are expensive when an object is
                // constantly changing shape.
                map.__ = undefined;
                delete map.__;
                return map;
            }
            var MapIterator = /** @class */ (function () {
                function MapIterator(currentEntry, selector) {
                    this.currentEntry = currentEntry;
                    this.selector = selector;
                }
                MapIterator.prototype.next = function () {
                    // Navigate to the next entry.
                    while (this.currentEntry) {
                        var skipNext = !!this.currentEntry.skipNext;
                        this.currentEntry = this.currentEntry.nextEntry;
                        if (!skipNext) {
                            break;
                        }
                    }
                    if (this.currentEntry) {
                        return { value: this.selector(this.currentEntry.key, this.currentEntry.value), done: false };
                    }
                    else {
                        return { value: undefined, done: true };
                    }
                };
                return MapIterator;
            }());
            return /** @class */ (function () {
                function class_1() {
                    this.data = createDictionaryObject();
                    this.size = 0;
                    // Create a first (stub) map entry that will not contain a key
                    // and value but serves as starting point for iterators.
                    this.firstEntry = {};
                    // When the map is empty, the last entry is the same as the
                    // first one.
                    this.lastEntry = this.firstEntry;
                }
                class_1.prototype.get = function (key) {
                    var entry = this.data[key];
                    return entry && entry.value;
                };
                class_1.prototype.set = function (key, value) {
                    if (!this.has(key)) {
                        this.size++;
                        // Create a new entry that will be appended at the
                        // end of the linked list.
                        var newEntry = {
                            key: key,
                            value: value
                        };
                        this.data[key] = newEntry;
                        // Adjust the references.
                        var previousLastEntry = this.lastEntry;
                        previousLastEntry.nextEntry = newEntry;
                        newEntry.previousEntry = previousLastEntry;
                        this.lastEntry = newEntry;
                    }
                    else {
                        this.data[key].value = value;
                    }
                    return this;
                };
                class_1.prototype.has = function (key) {
                    // eslint-disable-next-line no-in-operator
                    return key in this.data;
                };
                class_1.prototype.delete = function (key) {
                    if (this.has(key)) {
                        this.size--;
                        var entry = this.data[key];
                        delete this.data[key];
                        // Adjust the linked list references of the neighbor entries.
                        var previousEntry = entry.previousEntry;
                        previousEntry.nextEntry = entry.nextEntry;
                        if (entry.nextEntry) {
                            entry.nextEntry.previousEntry = previousEntry;
                        }
                        // When the deleted entry was the last one, we need to
                        // adjust the lastEntry reference.
                        if (this.lastEntry === entry) {
                            this.lastEntry = previousEntry;
                        }
                        // Adjust the forward reference of the deleted entry
                        // in case an iterator still references it. This allows us
                        // to throw away the entry, but when an active iterator
                        // (which points to the current entry) continues, it will
                        // navigate to the entry that originally came before the
                        // current one and skip it.
                        entry.previousEntry = undefined;
                        entry.nextEntry = previousEntry;
                        entry.skipNext = true;
                        return true;
                    }
                    return false;
                };
                class_1.prototype.clear = function () {
                    this.data = createDictionaryObject();
                    this.size = 0;
                    // Reset the linked list. Note that we must adjust the forward
                    // references of the deleted entries to ensure iterators stuck
                    // in the middle of the list don't continue with deleted entries,
                    // but can continue with new entries added after the clear()
                    // operation.
                    var firstEntry = this.firstEntry;
                    var currentEntry = firstEntry.nextEntry;
                    while (currentEntry) {
                        var nextEntry = currentEntry.nextEntry;
                        currentEntry.previousEntry = undefined;
                        currentEntry.nextEntry = firstEntry;
                        currentEntry.skipNext = true;
                        currentEntry = nextEntry;
                    }
                    firstEntry.nextEntry = undefined;
                    this.lastEntry = firstEntry;
                };
                class_1.prototype.keys = function () {
                    return new MapIterator(this.firstEntry, function (key) { return key; });
                };
                class_1.prototype.values = function () {
                    return new MapIterator(this.firstEntry, function (_key, value) { return value; });
                };
                class_1.prototype.entries = function () {
                    return new MapIterator(this.firstEntry, function (key, value) { return [key, value]; });
                };
                class_1.prototype.forEach = function (action) {
                    var iterator = this.entries();
                    while (true) {
                        var iterResult = iterator.next();
                        if (iterResult.done) {
                            break;
                        }
                        var _a = iterResult.value, key = _a[0], value = _a[1];
                        action(value, key);
                    }
                };
                return class_1;
            }());
        }
        ts.createMapShim = createMapShim;
    })(ts || (ts = {}));
    var ts;
    (function (ts) {
        // WARNING: The script `configurePrerelease.ts` uses a regexp to parse out these values.
        // If changing the text in this section, be sure to test `configurePrerelease` too.
        ts.versionMajorMinor = "3.8";
        /** The version of the TypeScript compiler release */
        ts.version = "3.8.3";
        /**
         * Returns the native Map implementation if it is available and compatible (i.e. supports iteration).
         */
        /* @internal */
        function tryGetNativeMap() {
            // eslint-disable-next-line no-in-operator
            return typeof Map !== "undefined" && "entries" in Map.prototype ? Map : undefined;
        }
        ts.tryGetNativeMap = tryGetNativeMap;
        /* @internal */
        ts.Map = tryGetNativeMap() || (function () {
            // NOTE: createMapShim will be defined for typescriptServices.js but not for tsc.js, so we must test for it.
            if (typeof ts.createMapShim === "function") {
                return ts.createMapShim();
            }
            throw new Error("TypeScript requires an environment that provides a compatible native Map implementation.");
        })();
        /* @internal */
        var Comparison;
        (function (Comparison) {
            Comparison[Comparison["LessThan"] = -1] = "LessThan";
            Comparison[Comparison["EqualTo"] = 0] = "EqualTo";
            Comparison[Comparison["GreaterThan"] = 1] = "GreaterThan";
        })(Comparison = ts.Comparison || (ts.Comparison = {}));
    })(ts || (ts = {}));
    /* @internal */
    var ts;
    (function (ts) {
        ts.emptyArray = [];
        /** Create a new map. */
        function createMap() {
            return new ts.Map();
        }
        ts.createMap = createMap;
        /** Create a new map from an array of entries. */
        function createMapFromEntries(entries) {
            var map = createMap();
            for (var _i = 0, entries_1 = entries; _i < entries_1.length; _i++) {
                var _a = entries_1[_i], key = _a[0], value = _a[1];
                map.set(key, value);
            }
            return map;
        }
        ts.createMapFromEntries = createMapFromEntries;
        /** Create a new map from a template object is provided, the map will copy entries from it. */
        function createMapFromTemplate(template) {
            var map = new ts.Map();
            // Copies keys/values from template. Note that for..in will not throw if
            // template is undefined, and instead will just exit the loop.
            for (var key in template) {
                if (hasOwnProperty.call(template, key)) {
                    map.set(key, template[key]);
                }
            }
            return map;
        }
        ts.createMapFromTemplate = createMapFromTemplate;
        function length(array) {
            return array ? array.length : 0;
        }
        ts.length = length;
        /**
         * Iterates through 'array' by index and performs the callback on each element of array until the callback
         * returns a truthy value, then returns that value.
         * If no such value is found, the callback is applied to each element of array and undefined is returned.
         */
        function forEach(array, callback) {
            if (array) {
                for (var i = 0; i < array.length; i++) {
                    var result = callback(array[i], i);
                    if (result) {
                        return result;
                    }
                }
            }
            return undefined;
        }
        ts.forEach = forEach;
        /**
         * Like `forEach`, but iterates in reverse order.
         */
        function forEachRight(array, callback) {
            if (array) {
                for (var i = array.length - 1; i >= 0; i--) {
                    var result = callback(array[i], i);
                    if (result) {
                        return result;
                    }
                }
            }
            return undefined;
        }
        ts.forEachRight = forEachRight;
        /** Like `forEach`, but suitable for use with numbers and strings (which may be falsy). */
        function firstDefined(array, callback) {
            if (array === undefined) {
                return undefined;
            }
            for (var i = 0; i < array.length; i++) {
                var result = callback(array[i], i);
                if (result !== undefined) {
                    return result;
                }
            }
            return undefined;
        }
        ts.firstDefined = firstDefined;
        function firstDefinedIterator(iter, callback) {
            while (true) {
                var iterResult = iter.next();
                if (iterResult.done) {
                    return undefined;
                }
                var result = callback(iterResult.value);
                if (result !== undefined) {
                    return result;
                }
            }
        }
        ts.firstDefinedIterator = firstDefinedIterator;
        function zipWith(arrayA, arrayB, callback) {
            var result = [];
            ts.Debug.assertEqual(arrayA.length, arrayB.length);
            for (var i = 0; i < arrayA.length; i++) {
                result.push(callback(arrayA[i], arrayB[i], i));
            }
            return result;
        }
        ts.zipWith = zipWith;
        function zipToIterator(arrayA, arrayB) {
            ts.Debug.assertEqual(arrayA.length, arrayB.length);
            var i = 0;
            return {
                next: function () {
                    if (i === arrayA.length) {
                        return { value: undefined, done: true };
                    }
                    i++;
                    return { value: [arrayA[i - 1], arrayB[i - 1]], done: false };
                }
            };
        }
        ts.zipToIterator = zipToIterator;
        function zipToMap(keys, values) {
            ts.Debug.assert(keys.length === values.length);
            var map = createMap();
            for (var i = 0; i < keys.length; ++i) {
                map.set(keys[i], values[i]);
            }
            return map;
        }
        ts.zipToMap = zipToMap;
        /**
         * Iterates through `array` by index and performs the callback on each element of array until the callback
         * returns a falsey value, then returns false.
         * If no such value is found, the callback is applied to each element of array and `true` is returned.
         */
        function every(array, callback) {
            if (array) {
                for (var i = 0; i < array.length; i++) {
                    if (!callback(array[i], i)) {
                        return false;
                    }
                }
            }
            return true;
        }
        ts.every = every;
        function find(array, predicate) {
            for (var i = 0; i < array.length; i++) {
                var value = array[i];
                if (predicate(value, i)) {
                    return value;
                }
            }
            return undefined;
        }
        ts.find = find;
        function findLast(array, predicate) {
            for (var i = array.length - 1; i >= 0; i--) {
                var value = array[i];
                if (predicate(value, i)) {
                    return value;
                }
            }
            return undefined;
        }
        ts.findLast = findLast;
        /** Works like Array.prototype.findIndex, returning `-1` if no element satisfying the predicate is found. */
        function findIndex(array, predicate, startIndex) {
            for (var i = startIndex || 0; i < array.length; i++) {
                if (predicate(array[i], i)) {
                    return i;
                }
            }
            return -1;
        }
        ts.findIndex = findIndex;
        function findLastIndex(array, predicate, startIndex) {
            for (var i = startIndex === undefined ? array.length - 1 : startIndex; i >= 0; i--) {
                if (predicate(array[i], i)) {
                    return i;
                }
            }
            return -1;
        }
        ts.findLastIndex = findLastIndex;
        /**
         * Returns the first truthy result of `callback`, or else fails.
         * This is like `forEach`, but never returns undefined.
         */
        function findMap(array, callback) {
            for (var i = 0; i < array.length; i++) {
                var result = callback(array[i], i);
                if (result) {
                    return result;
                }
            }
            return ts.Debug.fail();
        }
        ts.findMap = findMap;
        function contains(array, value, equalityComparer) {
            if (equalityComparer === void 0) {
                equalityComparer = equateValues;
            }
            if (array) {
                for (var _i = 0, array_1 = array; _i < array_1.length; _i++) {
                    var v = array_1[_i];
                    if (equalityComparer(v, value)) {
                        return true;
                    }
                }
            }
            return false;
        }
        ts.contains = contains;
        function arraysEqual(a, b, equalityComparer) {
            if (equalityComparer === void 0) {
                equalityComparer = equateValues;
            }
            return a.length === b.length && a.every(function (x, i) { return equalityComparer(x, b[i]); });
        }
        ts.arraysEqual = arraysEqual;
        function indexOfAnyCharCode(text, charCodes, start) {
            for (var i = start || 0; i < text.length; i++) {
                if (contains(charCodes, text.charCodeAt(i))) {
                    return i;
                }
            }
            return -1;
        }
        ts.indexOfAnyCharCode = indexOfAnyCharCode;
        function countWhere(array, predicate) {
            var count = 0;
            if (array) {
                for (var i = 0; i < array.length; i++) {
                    var v = array[i];
                    if (predicate(v, i)) {
                        count++;
                    }
                }
            }
            return count;
        }
        ts.countWhere = countWhere;
        function filter(array, f) {
            if (array) {
                var len = array.length;
                var i = 0;
                while (i < len && f(array[i]))
                    i++;
                if (i < len) {
                    var result = array.slice(0, i);
                    i++;
                    while (i < len) {
                        var item = array[i];
                        if (f(item)) {
                            result.push(item);
                        }
                        i++;
                    }
                    return result;
                }
            }
            return array;
        }
        ts.filter = filter;
        function filterMutate(array, f) {
            var outIndex = 0;
            for (var i = 0; i < array.length; i++) {
                if (f(array[i], i, array)) {
                    array[outIndex] = array[i];
                    outIndex++;
                }
            }
            array.length = outIndex;
        }
        ts.filterMutate = filterMutate;
        function clear(array) {
            array.length = 0;
        }
        ts.clear = clear;
        function map(array, f) {
            var result;
            if (array) {
                result = [];
                for (var i = 0; i < array.length; i++) {
                    result.push(f(array[i], i));
                }
            }
            return result;
        }
        ts.map = map;
        function mapIterator(iter, mapFn) {
            return {
                next: function () {
                    var iterRes = iter.next();
                    return iterRes.done ? iterRes : { value: mapFn(iterRes.value), done: false };
                }
            };
        }
        ts.mapIterator = mapIterator;
        function sameMap(array, f) {
            if (array) {
                for (var i = 0; i < array.length; i++) {
                    var item = array[i];
                    var mapped = f(item, i);
                    if (item !== mapped) {
                        var result = array.slice(0, i);
                        result.push(mapped);
                        for (i++; i < array.length; i++) {
                            result.push(f(array[i], i));
                        }
                        return result;
                    }
                }
            }
            return array;
        }
        ts.sameMap = sameMap;
        /**
         * Flattens an array containing a mix of array or non-array elements.
         *
         * @param array The array to flatten.
         */
        function flatten(array) {
            var result = [];
            for (var _i = 0, array_2 = array; _i < array_2.length; _i++) {
                var v = array_2[_i];
                if (v) {
                    if (isArray(v)) {
                        addRange(result, v);
                    }
                    else {
                        result.push(v);
                    }
                }
            }
            return result;
        }
        ts.flatten = flatten;
        /**
         * Maps an array. If the mapped value is an array, it is spread into the result.
         *
         * @param array The array to map.
         * @param mapfn The callback used to map the result into one or more values.
         */
        function flatMap(array, mapfn) {
            var result;
            if (array) {
                for (var i = 0; i < array.length; i++) {
                    var v = mapfn(array[i], i);
                    if (v) {
                        if (isArray(v)) {
                            result = addRange(result, v);
                        }
                        else {
                            result = append(result, v);
                        }
                    }
                }
            }
            return result || ts.emptyArray;
        }
        ts.flatMap = flatMap;
        function flatMapToMutable(array, mapfn) {
            var result = [];
            if (array) {
                for (var i = 0; i < array.length; i++) {
                    var v = mapfn(array[i], i);
                    if (v) {
                        if (isArray(v)) {
                            addRange(result, v);
                        }
                        else {
                            result.push(v);
                        }
                    }
                }
            }
            return result;
        }
        ts.flatMapToMutable = flatMapToMutable;
        function flatMapIterator(iter, mapfn) {
            var first = iter.next();
            if (first.done) {
                return ts.emptyIterator;
            }
            var currentIter = getIterator(first.value);
            return {
                next: function () {
                    while (true) {
                        var currentRes = currentIter.next();
                        if (!currentRes.done) {
                            return currentRes;
                        }
                        var iterRes = iter.next();
                        if (iterRes.done) {
                            return iterRes;
                        }
                        currentIter = getIterator(iterRes.value);
                    }
                },
            };
            function getIterator(x) {
                var res = mapfn(x);
                return res === undefined ? ts.emptyIterator : isArray(res) ? arrayIterator(res) : res;
            }
        }
        ts.flatMapIterator = flatMapIterator;
        function sameFlatMap(array, mapfn) {
            var result;
            if (array) {
                for (var i = 0; i < array.length; i++) {
                    var item = array[i];
                    var mapped = mapfn(item, i);
                    if (result || item !== mapped || isArray(mapped)) {
                        if (!result) {
                            result = array.slice(0, i);
                        }
                        if (isArray(mapped)) {
                            addRange(result, mapped);
                        }
                        else {
                            result.push(mapped);
                        }
                    }
                }
            }
            return result || array;
        }
        ts.sameFlatMap = sameFlatMap;
        function mapAllOrFail(array, mapFn) {
            var result = [];
            for (var i = 0; i < array.length; i++) {
                var mapped = mapFn(array[i], i);
                if (mapped === undefined) {
                    return undefined;
                }
                result.push(mapped);
            }
            return result;
        }
        ts.mapAllOrFail = mapAllOrFail;
        function mapDefined(array, mapFn) {
            var result = [];
            if (array) {
                for (var i = 0; i < array.length; i++) {
                    var mapped = mapFn(array[i], i);
                    if (mapped !== undefined) {
                        result.push(mapped);
                    }
                }
            }
            return result;
        }
        ts.mapDefined = mapDefined;
        function mapDefinedIterator(iter, mapFn) {
            return {
                next: function () {
                    while (true) {
                        var res = iter.next();
                        if (res.done) {
                            return res;
                        }
                        var value = mapFn(res.value);
                        if (value !== undefined) {
                            return { value: value, done: false };
                        }
                    }
                }
            };
        }
        ts.mapDefinedIterator = mapDefinedIterator;
        function mapDefinedMap(map, mapValue, mapKey) {
            if (mapKey === void 0) {
                mapKey = identity;
            }
            var result = createMap();
            map.forEach(function (value, key) {
                var mapped = mapValue(value, key);
                if (mapped !== undefined) {
                    result.set(mapKey(key), mapped);
                }
            });
            return result;
        }
        ts.mapDefinedMap = mapDefinedMap;
        ts.emptyIterator = { next: function () { return ({ value: undefined, done: true }); } };
        function singleIterator(value) {
            var done = false;
            return {
                next: function () {
                    var wasDone = done;
                    done = true;
                    return wasDone ? { value: undefined, done: true } : { value: value, done: false };
                }
            };
        }
        ts.singleIterator = singleIterator;
        function spanMap(array, keyfn, mapfn) {
            var result;
            if (array) {
                result = [];
                var len = array.length;
                var previousKey = void 0;
                var key = void 0;
                var start = 0;
                var pos = 0;
                while (start < len) {
                    while (pos < len) {
                        var value = array[pos];
                        key = keyfn(value, pos);
                        if (pos === 0) {
                            previousKey = key;
                        }
                        else if (key !== previousKey) {
                            break;
                        }
                        pos++;
                    }
                    if (start < pos) {
                        var v = mapfn(array.slice(start, pos), previousKey, start, pos);
                        if (v) {
                            result.push(v);
                        }
                        start = pos;
                    }
                    previousKey = key;
                    pos++;
                }
            }
            return result;
        }
        ts.spanMap = spanMap;
        function mapEntries(map, f) {
            if (!map) {
                return undefined;
            }
            var result = createMap();
            map.forEach(function (value, key) {
                var _a = f(key, value), newKey = _a[0], newValue = _a[1];
                result.set(newKey, newValue);
            });
            return result;
        }
        ts.mapEntries = mapEntries;
        function some(array, predicate) {
            if (array) {
                if (predicate) {
                    for (var _i = 0, array_3 = array; _i < array_3.length; _i++) {
                        var v = array_3[_i];
                        if (predicate(v)) {
                            return true;
                        }
                    }
                }
                else {
                    return array.length > 0;
                }
            }
            return false;
        }
        ts.some = some;
        /** Calls the callback with (start, afterEnd) index pairs for each range where 'pred' is true. */
        function getRangesWhere(arr, pred, cb) {
            var start;
            for (var i = 0; i < arr.length; i++) {
                if (pred(arr[i])) {
                    start = start === undefined ? i : start;
                }
                else {
                    if (start !== undefined) {
                        cb(start, i);
                        start = undefined;
                    }
                }
            }
            if (start !== undefined)
                cb(start, arr.length);
        }
        ts.getRangesWhere = getRangesWhere;
        function concatenate(array1, array2) {
            if (!some(array2))
                return array1;
            if (!some(array1))
                return array2;
            return __spreadArrays(array1, array2);
        }
        ts.concatenate = concatenate;
        function selectIndex(_, i) {
            return i;
        }
        function indicesOf(array) {
            return array.map(selectIndex);
        }
        ts.indicesOf = indicesOf;
        function deduplicateRelational(array, equalityComparer, comparer) {
            // Perform a stable sort of the array. This ensures the first entry in a list of
            // duplicates remains the first entry in the result.
            var indices = indicesOf(array);
            stableSortIndices(array, indices, comparer);
            var last = array[indices[0]];
            var deduplicated = [indices[0]];
            for (var i = 1; i < indices.length; i++) {
                var index = indices[i];
                var item = array[index];
                if (!equalityComparer(last, item)) {
                    deduplicated.push(index);
                    last = item;
                }
            }
            // restore original order
            deduplicated.sort();
            return deduplicated.map(function (i) { return array[i]; });
        }
        function deduplicateEquality(array, equalityComparer) {
            var result = [];
            for (var _i = 0, array_4 = array; _i < array_4.length; _i++) {
                var item = array_4[_i];
                pushIfUnique(result, item, equalityComparer);
            }
            return result;
        }
        /**
         * Deduplicates an unsorted array.
         * @param equalityComparer An `EqualityComparer` used to determine if two values are duplicates.
         * @param comparer An optional `Comparer` used to sort entries before comparison, though the
         * result will remain in the original order in `array`.
         */
        function deduplicate(array, equalityComparer, comparer) {
            return array.length === 0 ? [] :
                array.length === 1 ? array.slice() :
                    comparer ? deduplicateRelational(array, equalityComparer, comparer) :
                        deduplicateEquality(array, equalityComparer);
        }
        ts.deduplicate = deduplicate;
        /**
         * Deduplicates an array that has already been sorted.
         */
        function deduplicateSorted(array, comparer) {
            if (array.length === 0)
                return ts.emptyArray;
            var last = array[0];
            var deduplicated = [last];
            for (var i = 1; i < array.length; i++) {
                var next = array[i];
                switch (comparer(next, last)) {
                    // equality comparison
                    case true:
                    // relational comparison
                    // falls through
                    case 0 /* EqualTo */:
                        continue;
                    case -1 /* LessThan */:
                        // If `array` is sorted, `next` should **never** be less than `last`.
                        return ts.Debug.fail("Array is unsorted.");
                }
                deduplicated.push(last = next);
            }
            return deduplicated;
        }
        function insertSorted(array, insert, compare) {
            if (array.length === 0) {
                array.push(insert);
                return;
            }
            var insertIndex = binarySearch(array, insert, identity, compare);
            if (insertIndex < 0) {
                array.splice(~insertIndex, 0, insert);
            }
        }
        ts.insertSorted = insertSorted;
        function sortAndDeduplicate(array, comparer, equalityComparer) {
            return deduplicateSorted(sort(array, comparer), equalityComparer || comparer || compareStringsCaseSensitive);
        }
        ts.sortAndDeduplicate = sortAndDeduplicate;
        function arrayIsEqualTo(array1, array2, equalityComparer) {
            if (equalityComparer === void 0) {
                equalityComparer = equateValues;
            }
            if (!array1 || !array2) {
                return array1 === array2;
            }
            if (array1.length !== array2.length) {
                return false;
            }
            for (var i = 0; i < array1.length; i++) {
                if (!equalityComparer(array1[i], array2[i], i)) {
                    return false;
                }
            }
            return true;
        }
        ts.arrayIsEqualTo = arrayIsEqualTo;
        function compact(array) {
            var result;
            if (array) {
                for (var i = 0; i < array.length; i++) {
                    var v = array[i];
                    if (result || !v) {
                        if (!result) {
                            result = array.slice(0, i);
                        }
                        if (v) {
                            result.push(v);
                        }
                    }
                }
            }
            return result || array;
        }
        ts.compact = compact;
        /**
         * Gets the relative complement of `arrayA` with respect to `arrayB`, returning the elements that
         * are not present in `arrayA` but are present in `arrayB`. Assumes both arrays are sorted
         * based on the provided comparer.
         */
        function relativeComplement(arrayA, arrayB, comparer) {
            if (!arrayB || !arrayA || arrayB.length === 0 || arrayA.length === 0)
                return arrayB;
            var result = [];
            loopB: for (var offsetA = 0, offsetB = 0; offsetB < arrayB.length; offsetB++) {
                if (offsetB > 0) {
                    // Ensure `arrayB` is properly sorted.
                    ts.Debug.assertGreaterThanOrEqual(comparer(arrayB[offsetB], arrayB[offsetB - 1]), 0 /* EqualTo */);
                }
                loopA: for (var startA = offsetA; offsetA < arrayA.length; offsetA++) {
                    if (offsetA > startA) {
                        // Ensure `arrayA` is properly sorted. We only need to perform this check if
                        // `offsetA` has changed since we entered the loop.
                        ts.Debug.assertGreaterThanOrEqual(comparer(arrayA[offsetA], arrayA[offsetA - 1]), 0 /* EqualTo */);
                    }
                    switch (comparer(arrayB[offsetB], arrayA[offsetA])) {
                        case -1 /* LessThan */:
                            // If B is less than A, B does not exist in arrayA. Add B to the result and
                            // move to the next element in arrayB without changing the current position
                            // in arrayA.
                            result.push(arrayB[offsetB]);
                            continue loopB;
                        case 0 /* EqualTo */:
                            // If B is equal to A, B exists in arrayA. Move to the next element in
                            // arrayB without adding B to the result or changing the current position
                            // in arrayA.
                            continue loopB;
                        case 1 /* GreaterThan */:
                            // If B is greater than A, we need to keep looking for B in arrayA. Move to
                            // the next element in arrayA and recheck.
                            continue loopA;
                    }
                }
            }
            return result;
        }
        ts.relativeComplement = relativeComplement;
        function sum(array, prop) {
            var result = 0;
            for (var _i = 0, array_5 = array; _i < array_5.length; _i++) {
                var v = array_5[_i];
                result += v[prop];
            }
            return result;
        }
        ts.sum = sum;
        function append(to, value) {
            if (value === undefined)
                return to;
            if (to === undefined)
                return [value];
            to.push(value);
            return to;
        }
        ts.append = append;
        /**
         * Gets the actual offset into an array for a relative offset. Negative offsets indicate a
         * position offset from the end of the array.
         */
        function toOffset(array, offset) {
            return offset < 0 ? array.length + offset : offset;
        }
        function addRange(to, from, start, end) {
            if (from === undefined || from.length === 0)
                return to;
            if (to === undefined)
                return from.slice(start, end);
            start = start === undefined ? 0 : toOffset(from, start);
            end = end === undefined ? from.length : toOffset(from, end);
            for (var i = start; i < end && i < from.length; i++) {
                if (from[i] !== undefined) {
                    to.push(from[i]);
                }
            }
            return to;
        }
        ts.addRange = addRange;
        /**
         * @return Whether the value was added.
         */
        function pushIfUnique(array, toAdd, equalityComparer) {
            if (contains(array, toAdd, equalityComparer)) {
                return false;
            }
            else {
                array.push(toAdd);
                return true;
            }
        }
        ts.pushIfUnique = pushIfUnique;
        /**
         * Unlike `pushIfUnique`, this can take `undefined` as an input, and returns a new array.
         */
        function appendIfUnique(array, toAdd, equalityComparer) {
            if (array) {
                pushIfUnique(array, toAdd, equalityComparer);
                return array;
            }
            else {
                return [toAdd];
            }
        }
        ts.appendIfUnique = appendIfUnique;
        function stableSortIndices(array, indices, comparer) {
            // sort indices by value then position
            indices.sort(function (x, y) { return comparer(array[x], array[y]) || compareValues(x, y); });
        }
        /**
         * Returns a new sorted array.
         */
        function sort(array, comparer) {
            return (array.length === 0 ? array : array.slice().sort(comparer));
        }
        ts.sort = sort;
        function arrayIterator(array) {
            var i = 0;
            return { next: function () {
                    if (i === array.length) {
                        return { value: undefined, done: true };
                    }
                    else {
                        i++;
                        return { value: array[i - 1], done: false };
                    }
                } };
        }
        ts.arrayIterator = arrayIterator;
        function arrayReverseIterator(array) {
            var i = array.length;
            return {
                next: function () {
                    if (i === 0) {
                        return { value: undefined, done: true };
                    }
                    else {
                        i--;
                        return { value: array[i], done: false };
                    }
                }
            };
        }
        ts.arrayReverseIterator = arrayReverseIterator;
        /**
         * Stable sort of an array. Elements equal to each other maintain their relative position in the array.
         */
        function stableSort(array, comparer) {
            var indices = indicesOf(array);
            stableSortIndices(array, indices, comparer);
            return indices.map(function (i) { return array[i]; });
        }
        ts.stableSort = stableSort;
        function rangeEquals(array1, array2, pos, end) {
            while (pos < end) {
                if (array1[pos] !== array2[pos]) {
                    return false;
                }
                pos++;
            }
            return true;
        }
        ts.rangeEquals = rangeEquals;
        /**
         * Returns the element at a specific offset in an array if non-empty, `undefined` otherwise.
         * A negative offset indicates the element should be retrieved from the end of the array.
         */
        function elementAt(array, offset) {
            if (array) {
                offset = toOffset(array, offset);
                if (offset < array.length) {
                    return array[offset];
                }
            }
            return undefined;
        }
        ts.elementAt = elementAt;
        /**
         * Returns the first element of an array if non-empty, `undefined` otherwise.
         */
        function firstOrUndefined(array) {
            return array.length === 0 ? undefined : array[0];
        }
        ts.firstOrUndefined = firstOrUndefined;
        function first(array) {
            ts.Debug.assert(array.length !== 0);
            return array[0];
        }
        ts.first = first;
        /**
         * Returns the last element of an array if non-empty, `undefined` otherwise.
         */
        function lastOrUndefined(array) {
            return array.length === 0 ? undefined : array[array.length - 1];
        }
        ts.lastOrUndefined = lastOrUndefined;
        function last(array) {
            ts.Debug.assert(array.length !== 0);
            return array[array.length - 1];
        }
        ts.last = last;
        /**
         * Returns the only element of an array if it contains only one element, `undefined` otherwise.
         */
        function singleOrUndefined(array) {
            return array && array.length === 1
                ? array[0]
                : undefined;
        }
        ts.singleOrUndefined = singleOrUndefined;
        function singleOrMany(array) {
            return array && array.length === 1
                ? array[0]
                : array;
        }
        ts.singleOrMany = singleOrMany;
        function replaceElement(array, index, value) {
            var result = array.slice(0);
            result[index] = value;
            return result;
        }
        ts.replaceElement = replaceElement;
        /**
         * Performs a binary search, finding the index at which `value` occurs in `array`.
         * If no such index is found, returns the 2's-complement of first index at which
         * `array[index]` exceeds `value`.
         * @param array A sorted array whose first element must be no larger than number
         * @param value The value to be searched for in the array.
         * @param keySelector A callback used to select the search key from `value` and each element of
         * `array`.
         * @param keyComparer A callback used to compare two keys in a sorted array.
         * @param offset An offset into `array` at which to start the search.
         */
        function binarySearch(array, value, keySelector, keyComparer, offset) {
            return binarySearchKey(array, keySelector(value), keySelector, keyComparer, offset);
        }
        ts.binarySearch = binarySearch;
        /**
         * Performs a binary search, finding the index at which an object with `key` occurs in `array`.
         * If no such index is found, returns the 2's-complement of first index at which
         * `array[index]` exceeds `key`.
         * @param array A sorted array whose first element must be no larger than number
         * @param key The key to be searched for in the array.
         * @param keySelector A callback used to select the search key from each element of `array`.
         * @param keyComparer A callback used to compare two keys in a sorted array.
         * @param offset An offset into `array` at which to start the search.
         */
        function binarySearchKey(array, key, keySelector, keyComparer, offset) {
            if (!some(array)) {
                return -1;
            }
            var low = offset || 0;
            var high = array.length - 1;
            while (low <= high) {
                var middle = low + ((high - low) >> 1);
                var midKey = keySelector(array[middle]);
                switch (keyComparer(midKey, key)) {
                    case -1 /* LessThan */:
                        low = middle + 1;
                        break;
                    case 0 /* EqualTo */:
                        return middle;
                    case 1 /* GreaterThan */:
                        high = middle - 1;
                        break;
                }
            }
            return ~low;
        }
        ts.binarySearchKey = binarySearchKey;
        function reduceLeft(array, f, initial, start, count) {
            if (array && array.length > 0) {
                var size = array.length;
                if (size > 0) {
                    var pos = start === undefined || start < 0 ? 0 : start;
                    var end = count === undefined || pos + count > size - 1 ? size - 1 : pos + count;
                    var result = void 0;
                    if (arguments.length <= 2) {
                        result = array[pos];
                        pos++;
                    }
                    else {
                        result = initial;
                    }
                    while (pos <= end) {
                        result = f(result, array[pos], pos);
                        pos++;
                    }
                    return result;
                }
            }
            return initial;
        }
        ts.reduceLeft = reduceLeft;
        var hasOwnProperty = Object.prototype.hasOwnProperty;
        /**
         * Indicates whether a map-like contains an own property with the specified key.
         *
         * @param map A map-like.
         * @param key A property key.
         */
        function hasProperty(map, key) {
            return hasOwnProperty.call(map, key);
        }
        ts.hasProperty = hasProperty;
        /**
         * Gets the value of an owned property in a map-like.
         *
         * @param map A map-like.
         * @param key A property key.
         */
        function getProperty(map, key) {
            return hasOwnProperty.call(map, key) ? map[key] : undefined;
        }
        ts.getProperty = getProperty;
        /**
         * Gets the owned, enumerable property keys of a map-like.
         */
        function getOwnKeys(map) {
            var keys = [];
            for (var key in map) {
                if (hasOwnProperty.call(map, key)) {
                    keys.push(key);
                }
            }
            return keys;
        }
        ts.getOwnKeys = getOwnKeys;
        function getAllKeys(obj) {
            var result = [];
            do {
                var names = Object.getOwnPropertyNames(obj);
                for (var _i = 0, names_1 = names; _i < names_1.length; _i++) {
                    var name = names_1[_i];
                    pushIfUnique(result, name);
                }
            } while (obj = Object.getPrototypeOf(obj));
            return result;
        }
        ts.getAllKeys = getAllKeys;
        function getOwnValues(sparseArray) {
            var values = [];
            for (var key in sparseArray) {
                if (hasOwnProperty.call(sparseArray, key)) {
                    values.push(sparseArray[key]);
                }
            }
            return values;
        }
        ts.getOwnValues = getOwnValues;
        function arrayFrom(iterator, map) {
            var result = [];
            for (var iterResult = iterator.next(); !iterResult.done; iterResult = iterator.next()) {
                result.push(map ? map(iterResult.value) : iterResult.value);
            }
            return result;
        }
        ts.arrayFrom = arrayFrom;
        function assign(t) {
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                args[_i - 1] = arguments[_i];
            }
            for (var _a = 0, args_1 = args; _a < args_1.length; _a++) {
                var arg = args_1[_a];
                if (arg === undefined)
                    continue;
                for (var p in arg) {
                    if (hasProperty(arg, p)) {
                        t[p] = arg[p];
                    }
                }
            }
            return t;
        }
        ts.assign = assign;
        /**
         * Performs a shallow equality comparison of the contents of two map-likes.
         *
         * @param left A map-like whose properties should be compared.
         * @param right A map-like whose properties should be compared.
         */
        function equalOwnProperties(left, right, equalityComparer) {
            if (equalityComparer === void 0) {
                equalityComparer = equateValues;
            }
            if (left === right)
                return true;
            if (!left || !right)
                return false;
            for (var key in left) {
                if (hasOwnProperty.call(left, key)) {
                    if (!hasOwnProperty.call(right, key))
                        return false;
                    if (!equalityComparer(left[key], right[key]))
                        return false;
                }
            }
            for (var key in right) {
                if (hasOwnProperty.call(right, key)) {
                    if (!hasOwnProperty.call(left, key))
                        return false;
                }
            }
            return true;
        }
        ts.equalOwnProperties = equalOwnProperties;
        function arrayToMap(array, makeKey, makeValue) {
            if (makeValue === void 0) {
                makeValue = identity;
            }
            var result = createMap();
            for (var _i = 0, array_6 = array; _i < array_6.length; _i++) {
                var value = array_6[_i];
                var key = makeKey(value);
                if (key !== undefined)
                    result.set(key, makeValue(value));
            }
            return result;
        }
        ts.arrayToMap = arrayToMap;
        function arrayToNumericMap(array, makeKey, makeValue) {
            if (makeValue === void 0) {
                makeValue = identity;
            }
            var result = [];
            for (var _i = 0, array_7 = array; _i < array_7.length; _i++) {
                var value = array_7[_i];
                result[makeKey(value)] = makeValue(value);
            }
            return result;
        }
        ts.arrayToNumericMap = arrayToNumericMap;
        function arrayToMultiMap(values, makeKey, makeValue) {
            if (makeValue === void 0) {
                makeValue = identity;
            }
            var result = createMultiMap();
            for (var _i = 0, values_1 = values; _i < values_1.length; _i++) {
                var value = values_1[_i];
                result.add(makeKey(value), makeValue(value));
            }
            return result;
        }
        ts.arrayToMultiMap = arrayToMultiMap;
        function group(values, getGroupId, resultSelector) {
            if (resultSelector === void 0) {
                resultSelector = identity;
            }
            return arrayFrom(arrayToMultiMap(values, getGroupId).values(), resultSelector);
        }
        ts.group = group;
        function clone(object) {
            var result = {};
            for (var id in object) {
                if (hasOwnProperty.call(object, id)) {
                    result[id] = object[id];
                }
            }
            return result;
        }
        ts.clone = clone;
        /**
         * Creates a new object by adding the own properties of `second`, then the own properties of `first`.
         *
         * NOTE: This means that if a property exists in both `first` and `second`, the property in `first` will be chosen.
         */
        function extend(first, second) {
            var result = {};
            for (var id in second) {
                if (hasOwnProperty.call(second, id)) {
                    result[id] = second[id];
                }
            }
            for (var id in first) {
                if (hasOwnProperty.call(first, id)) {
                    result[id] = first[id];
                }
            }
            return result;
        }
        ts.extend = extend;
        function copyProperties(first, second) {
            for (var id in second) {
                if (hasOwnProperty.call(second, id)) {
                    first[id] = second[id];
                }
            }
        }
        ts.copyProperties = copyProperties;
        function maybeBind(obj, fn) {
            return fn ? fn.bind(obj) : undefined;
        }
        ts.maybeBind = maybeBind;
        function mapMap(map, f) {
            var result = createMap();
            map.forEach(function (t, key) { return result.set.apply(result, (f(t, key))); });
            return result;
        }
        ts.mapMap = mapMap;
        function createMultiMap() {
            var map = createMap();
            map.add = multiMapAdd;
            map.remove = multiMapRemove;
            return map;
        }
        ts.createMultiMap = createMultiMap;
        function multiMapAdd(key, value) {
            var values = this.get(key);
            if (values) {
                values.push(value);
            }
            else {
                this.set(key, values = [value]);
            }
            return values;
        }
        function multiMapRemove(key, value) {
            var values = this.get(key);
            if (values) {
                unorderedRemoveItem(values, value);
                if (!values.length) {
                    this.delete(key);
                }
            }
        }
        /**
         * Tests whether a value is an array.
         */
        function isArray(value) {
            return Array.isArray ? Array.isArray(value) : value instanceof Array;
        }
        ts.isArray = isArray;
        function toArray(value) {
            return isArray(value) ? value : [value];
        }
        ts.toArray = toArray;
        /**
         * Tests whether a value is string
         */
        function isString(text) {
            return typeof text === "string";
        }
        ts.isString = isString;
        function isNumber(x) {
            return typeof x === "number";
        }
        ts.isNumber = isNumber;
        function tryCast(value, test) {
            return value !== undefined && test(value) ? value : undefined;
        }
        ts.tryCast = tryCast;
        function cast(value, test) {
            if (value !== undefined && test(value))
                return value;
            return ts.Debug.fail("Invalid cast. The supplied value " + value + " did not pass the test '" + ts.Debug.getFunctionName(test) + "'.");
        }
        ts.cast = cast;
        /** Does nothing. */
        function noop(_) { }
        ts.noop = noop;
        /** Do nothing and return false */
        function returnFalse() { return false; }
        ts.returnFalse = returnFalse;
        /** Do nothing and return true */
        function returnTrue() { return true; }
        ts.returnTrue = returnTrue;
        /** Do nothing and return undefined */
        function returnUndefined() { return undefined; }
        ts.returnUndefined = returnUndefined;
        /** Returns its argument. */
        function identity(x) { return x; }
        ts.identity = identity;
        /** Returns lower case string */
        function toLowerCase(x) { return x.toLowerCase(); }
        ts.toLowerCase = toLowerCase;
        // We convert the file names to lower case as key for file name on case insensitive file system
        // While doing so we need to handle special characters (eg \u0130) to ensure that we dont convert
        // it to lower case, fileName with its lowercase form can exist along side it.
        // Handle special characters and make those case sensitive instead
        //
        // |-#--|-Unicode--|-Char code-|-Desc-------------------------------------------------------------------|
        // | 1. | i        | 105       | Ascii i                                                                |
        // | 2. | I        | 73        | Ascii I                                                                |
        // |-------- Special characters ------------------------------------------------------------------------|
        // | 3. | \u0130   | 304       | Uppper case I with dot above                                           |
        // | 4. | i,\u0307 | 105,775   | i, followed by 775: Lower case of (3rd item)                           |
        // | 5. | I,\u0307 | 73,775    | I, followed by 775: Upper case of (4th item), lower case is (4th item) |
        // | 6. | \u0131   | 305       | Lower case i without dot, upper case is I (2nd item)                   |
        // | 7. | \u00DF   | 223       | Lower case sharp s                                                     |
        //
        // Because item 3 is special where in its lowercase character has its own
        // upper case form we cant convert its case.
        // Rest special characters are either already in lower case format or
        // they have corresponding upper case character so they dont need special handling
        //
        // But to avoid having to do string building for most common cases, also ignore
        // a-z, 0-9, \u0131, \u00DF, \, /, ., : and space
        var fileNameLowerCaseRegExp = /[^\u0130\u0131\u00DFa-z0-9\\/:\-_\. ]+/g;
        /**
         * Case insensitive file systems have descripencies in how they handle some characters (eg. turkish Upper case I with dot on top - \u0130)
         * This function is used in places where we want to make file name as a key on these systems
         * It is possible on mac to be able to refer to file name with I with dot on top as a fileName with its lower case form
         * But on windows we cannot. Windows can have fileName with I with dot on top next to its lower case and they can not each be referred with the lowercase forms
         * Technically we would want this function to be platform sepcific as well but
         * our api has till now only taken caseSensitive as the only input and just for some characters we dont want to update API and ensure all customers use those api
         * We could use upper case and we would still need to deal with the descripencies but
         * we want to continue using lower case since in most cases filenames are lowercasewe and wont need any case changes and avoid having to store another string for the key
         * So for this function purpose, we go ahead and assume character I with dot on top it as case sensitive since its very unlikely to use lower case form of that special character
         */
        function toFileNameLowerCase(x) {
            return fileNameLowerCaseRegExp.test(x) ?
                x.replace(fileNameLowerCaseRegExp, toLowerCase) :
                x;
        }
        ts.toFileNameLowerCase = toFileNameLowerCase;
        /** Throws an error because a function is not implemented. */
        function notImplemented() {
            throw new Error("Not implemented");
        }
        ts.notImplemented = notImplemented;
        function memoize(callback) {
            var value;
            return function () {
                if (callback) {
                    value = callback();
                    callback = undefined;
                }
                return value;
            };
        }
        ts.memoize = memoize;
        function compose(a, b, c, d, e) {
            if (!!e) {
                var args_2 = [];
                for (var i = 0; i < arguments.length; i++) {
                    args_2[i] = arguments[i];
                }
                return function (t) { return reduceLeft(args_2, function (u, f) { return f(u); }, t); };
            }
            else if (d) {
                return function (t) { return d(c(b(a(t)))); };
            }
            else if (c) {
                return function (t) { return c(b(a(t))); };
            }
            else if (b) {
                return function (t) { return b(a(t)); };
            }
            else if (a) {
                return function (t) { return a(t); };
            }
            else {
                return function (t) { return t; };
            }
        }
        ts.compose = compose;
        var AssertionLevel;
        (function (AssertionLevel) {
            AssertionLevel[AssertionLevel["None"] = 0] = "None";
            AssertionLevel[AssertionLevel["Normal"] = 1] = "Normal";
            AssertionLevel[AssertionLevel["Aggressive"] = 2] = "Aggressive";
            AssertionLevel[AssertionLevel["VeryAggressive"] = 3] = "VeryAggressive";
        })(AssertionLevel = ts.AssertionLevel || (ts.AssertionLevel = {}));
        function equateValues(a, b) {
            return a === b;
        }
        ts.equateValues = equateValues;
        /**
         * Compare the equality of two strings using a case-sensitive ordinal comparison.
         *
         * Case-sensitive comparisons compare both strings one code-point at a time using the integer
         * value of each code-point after applying `toUpperCase` to each string. We always map both
         * strings to their upper-case form as some unicode characters do not properly round-trip to
         * lowercase (such as `ẞ` (German sharp capital s)).
         */
        function equateStringsCaseInsensitive(a, b) {
            return a === b
                || a !== undefined
                    && b !== undefined
                    && a.toUpperCase() === b.toUpperCase();
        }
        ts.equateStringsCaseInsensitive = equateStringsCaseInsensitive;
        /**
         * Compare the equality of two strings using a case-sensitive ordinal comparison.
         *
         * Case-sensitive comparisons compare both strings one code-point at a time using the
         * integer value of each code-point.
         */
        function equateStringsCaseSensitive(a, b) {
            return equateValues(a, b);
        }
        ts.equateStringsCaseSensitive = equateStringsCaseSensitive;
        function compareComparableValues(a, b) {
            return a === b ? 0 /* EqualTo */ :
                a === undefined ? -1 /* LessThan */ :
                    b === undefined ? 1 /* GreaterThan */ :
                        a < b ? -1 /* LessThan */ :
                            1 /* GreaterThan */;
        }
        /**
         * Compare two numeric values for their order relative to each other.
         * To compare strings, use any of the `compareStrings` functions.
         */
        function compareValues(a, b) {
            return compareComparableValues(a, b);
        }
        ts.compareValues = compareValues;
        /**
         * Compare two TextSpans, first by `start`, then by `length`.
         */
        function compareTextSpans(a, b) {
            return compareValues(a === null || a === void 0 ? void 0 : a.start, b === null || b === void 0 ? void 0 : b.start) || compareValues(a === null || a === void 0 ? void 0 : a.length, b === null || b === void 0 ? void 0 : b.length);
        }
        ts.compareTextSpans = compareTextSpans;
        function min(a, b, compare) {
            return compare(a, b) === -1 /* LessThan */ ? a : b;
        }
        ts.min = min;
        /**
         * Compare two strings using a case-insensitive ordinal comparison.
         *
         * Ordinal comparisons are based on the difference between the unicode code points of both
         * strings. Characters with multiple unicode representations are considered unequal. Ordinal
         * comparisons provide predictable ordering, but place "a" after "B".
         *
         * Case-insensitive comparisons compare both strings one code-point at a time using the integer
         * value of each code-point after applying `toUpperCase` to each string. We always map both
         * strings to their upper-case form as some unicode characters do not properly round-trip to
         * lowercase (such as `áºž` (German sharp capital s)).
         */
        function compareStringsCaseInsensitive(a, b) {
            if (a === b)
                return 0 /* EqualTo */;
            if (a === undefined)
                return -1 /* LessThan */;
            if (b === undefined)
                return 1 /* GreaterThan */;
            a = a.toUpperCase();
            b = b.toUpperCase();
            return a < b ? -1 /* LessThan */ : a > b ? 1 /* GreaterThan */ : 0 /* EqualTo */;
        }
        ts.compareStringsCaseInsensitive = compareStringsCaseInsensitive;
        /**
         * Compare two strings using a case-sensitive ordinal comparison.
         *
         * Ordinal comparisons are based on the difference between the unicode code points of both
         * strings. Characters with multiple unicode representations are considered unequal. Ordinal
         * comparisons provide predictable ordering, but place "a" after "B".
         *
         * Case-sensitive comparisons compare both strings one code-point at a time using the integer
         * value of each code-point.
         */
        function compareStringsCaseSensitive(a, b) {
            return compareComparableValues(a, b);
        }
        ts.compareStringsCaseSensitive = compareStringsCaseSensitive;
        function getStringComparer(ignoreCase) {
            return ignoreCase ? compareStringsCaseInsensitive : compareStringsCaseSensitive;
        }
        ts.getStringComparer = getStringComparer;
        /**
         * Creates a string comparer for use with string collation in the UI.
         */
        var createUIStringComparer = (function () {
            var defaultComparer;
            var enUSComparer;
            var stringComparerFactory = getStringComparerFactory();
            return createStringComparer;
            function compareWithCallback(a, b, comparer) {
                if (a === b)
                    return 0 /* EqualTo */;
                if (a === undefined)
                    return -1 /* LessThan */;
                if (b === undefined)
                    return 1 /* GreaterThan */;
                var value = comparer(a, b);
                return value < 0 ? -1 /* LessThan */ : value > 0 ? 1 /* GreaterThan */ : 0 /* EqualTo */;
            }
            function createIntlCollatorStringComparer(locale) {
                // Intl.Collator.prototype.compare is bound to the collator. See NOTE in
                // http://www.ecma-international.org/ecma-402/2.0/#sec-Intl.Collator.prototype.compare
                var comparer = new Intl.Collator(locale, { usage: "sort", sensitivity: "variant" }).compare;
                return function (a, b) { return compareWithCallback(a, b, comparer); };
            }
            function createLocaleCompareStringComparer(locale) {
                // if the locale is not the default locale (`undefined`), use the fallback comparer.
                if (locale !== undefined)
                    return createFallbackStringComparer();
                return function (a, b) { return compareWithCallback(a, b, compareStrings); };
                function compareStrings(a, b) {
                    return a.localeCompare(b);
                }
            }
            function createFallbackStringComparer() {
                // An ordinal comparison puts "A" after "b", but for the UI we want "A" before "b".
                // We first sort case insensitively.  So "Aaa" will come before "baa".
                // Then we sort case sensitively, so "aaa" will come before "Aaa".
                //
                // For case insensitive comparisons we always map both strings to their
                // upper-case form as some unicode characters do not properly round-trip to
                // lowercase (such as `áºž` (German sharp capital s)).
                return function (a, b) { return compareWithCallback(a, b, compareDictionaryOrder); };
                function compareDictionaryOrder(a, b) {
                    return compareStrings(a.toUpperCase(), b.toUpperCase()) || compareStrings(a, b);
                }
                function compareStrings(a, b) {
                    return a < b ? -1 /* LessThan */ : a > b ? 1 /* GreaterThan */ : 0 /* EqualTo */;
                }
            }
            function getStringComparerFactory() {
                // If the host supports Intl, we use it for comparisons using the default locale.
                if (typeof Intl === "object" && typeof Intl.Collator === "function") {
                    return createIntlCollatorStringComparer;
                }
                // If the host does not support Intl, we fall back to localeCompare.
                // localeCompare in Node v0.10 is just an ordinal comparison, so don't use it.
                if (typeof String.prototype.localeCompare === "function" &&
                    typeof String.prototype.toLocaleUpperCase === "function" &&
                    "a".localeCompare("B") < 0) {
                    return createLocaleCompareStringComparer;
                }
                // Otherwise, fall back to ordinal comparison:
                return createFallbackStringComparer;
            }
            function createStringComparer(locale) {
                // Hold onto common string comparers. This avoids constantly reallocating comparers during
                // tests.
                if (locale === undefined) {
                    return defaultComparer || (defaultComparer = stringComparerFactory(locale));
                }
                else if (locale === "en-US") {
                    return enUSComparer || (enUSComparer = stringComparerFactory(locale));
                }
                else {
                    return stringComparerFactory(locale);
                }
            }
        })();
        var uiComparerCaseSensitive;
        var uiLocale;
        function getUILocale() {
            return uiLocale;
        }
        ts.getUILocale = getUILocale;
        function setUILocale(value) {
            if (uiLocale !== value) {
                uiLocale = value;
                uiComparerCaseSensitive = undefined;
            }
        }
        ts.setUILocale = setUILocale;
        /**
         * Compare two strings in a using the case-sensitive sort behavior of the UI locale.
         *
         * Ordering is not predictable between different host locales, but is best for displaying
         * ordered data for UI presentation. Characters with multiple unicode representations may
         * be considered equal.
         *
         * Case-sensitive comparisons compare strings that differ in base characters, or
         * accents/diacritic marks, or case as unequal.
         */
        function compareStringsCaseSensitiveUI(a, b) {
            var comparer = uiComparerCaseSensitive || (uiComparerCaseSensitive = createUIStringComparer(uiLocale));
            return comparer(a, b);
        }
        ts.compareStringsCaseSensitiveUI = compareStringsCaseSensitiveUI;
        function compareProperties(a, b, key, comparer) {
            return a === b ? 0 /* EqualTo */ :
                a === undefined ? -1 /* LessThan */ :
                    b === undefined ? 1 /* GreaterThan */ :
                        comparer(a[key], b[key]);
        }
        ts.compareProperties = compareProperties;
        /** True is greater than false. */
        function compareBooleans(a, b) {
            return compareValues(a ? 1 : 0, b ? 1 : 0);
        }
        ts.compareBooleans = compareBooleans;
        /**
         * Given a name and a list of names that are *not* equal to the name, return a spelling suggestion if there is one that is close enough.
         * Names less than length 3 only check for case-insensitive equality, not Levenshtein distance.
         *
         * If there is a candidate that's the same except for case, return that.
         * If there is a candidate that's within one edit of the name, return that.
         * Otherwise, return the candidate with the smallest Levenshtein distance,
         *    except for candidates:
         *      * With no name
         *      * Whose length differs from the target name by more than 0.34 of the length of the name.
         *      * Whose levenshtein distance is more than 0.4 of the length of the name
         *        (0.4 allows 1 substitution/transposition for every 5 characters,
         *         and 1 insertion/deletion at 3 characters)
         */
        function getSpellingSuggestion(name, candidates, getName) {
            var maximumLengthDifference = Math.min(2, Math.floor(name.length * 0.34));
            var bestDistance = Math.floor(name.length * 0.4) + 1; // If the best result isn't better than this, don't bother.
            var bestCandidate;
            var justCheckExactMatches = false;
            var nameLowerCase = name.toLowerCase();
            for (var _i = 0, candidates_1 = candidates; _i < candidates_1.length; _i++) {
                var candidate = candidates_1[_i];
                var candidateName = getName(candidate);
                if (candidateName !== undefined && Math.abs(candidateName.length - nameLowerCase.length) <= maximumLengthDifference) {
                    var candidateNameLowerCase = candidateName.toLowerCase();
                    if (candidateNameLowerCase === nameLowerCase) {
                        if (candidateName === name) {
                            continue;
                        }
                        return candidate;
                    }
                    if (justCheckExactMatches) {
                        continue;
                    }
                    if (candidateName.length < 3) {
                        // Don't bother, user would have noticed a 2-character name having an extra character
                        continue;
                    }
                    // Only care about a result better than the best so far.
                    var distance = levenshteinWithMax(nameLowerCase, candidateNameLowerCase, bestDistance - 1);
                    if (distance === undefined) {
                        continue;
                    }
                    if (distance < 3) {
                        justCheckExactMatches = true;
                        bestCandidate = candidate;
                    }
                    else {
                        ts.Debug.assert(distance < bestDistance); // Else `levenshteinWithMax` should return undefined
                        bestDistance = distance;
                        bestCandidate = candidate;
                    }
                }
            }
            return bestCandidate;
        }
        ts.getSpellingSuggestion = getSpellingSuggestion;
        function levenshteinWithMax(s1, s2, max) {
            var previous = new Array(s2.length + 1);
            var current = new Array(s2.length + 1);
            /** Represents any value > max. We don't care about the particular value. */
            var big = max + 1;
            for (var i = 0; i <= s2.length; i++) {
                previous[i] = i;
            }
            for (var i = 1; i <= s1.length; i++) {
                var c1 = s1.charCodeAt(i - 1);
                var minJ = i > max ? i - max : 1;
                var maxJ = s2.length > max + i ? max + i : s2.length;
                current[0] = i;
                /** Smallest value of the matrix in the ith column. */
                var colMin = i;
                for (var j = 1; j < minJ; j++) {
                    current[j] = big;
                }
                for (var j = minJ; j <= maxJ; j++) {
                    var dist = c1 === s2.charCodeAt(j - 1)
                        ? previous[j - 1]
                        : Math.min(/*delete*/ previous[j] + 1, /*insert*/ current[j - 1] + 1, /*substitute*/ previous[j - 1] + 2);
                    current[j] = dist;
                    colMin = Math.min(colMin, dist);
                }
                for (var j = maxJ + 1; j <= s2.length; j++) {
                    current[j] = big;
                }
                if (colMin > max) {
                    // Give up -- everything in this column is > max and it can't get better in future columns.
                    return undefined;
                }
                var temp = previous;
                previous = current;
                current = temp;
            }
            var res = previous[s2.length];
            return res > max ? undefined : res;
        }
        function endsWith(str, suffix) {
            var expectedPos = str.length - suffix.length;
            return expectedPos >= 0 && str.indexOf(suffix, expectedPos) === expectedPos;
        }
        ts.endsWith = endsWith;
        function removeSuffix(str, suffix) {
            return endsWith(str, suffix) ? str.slice(0, str.length - suffix.length) : str;
        }
        ts.removeSuffix = removeSuffix;
        function tryRemoveSuffix(str, suffix) {
            return endsWith(str, suffix) ? str.slice(0, str.length - suffix.length) : undefined;
        }
        ts.tryRemoveSuffix = tryRemoveSuffix;
        function stringContains(str, substring) {
            return str.indexOf(substring) !== -1;
        }
        ts.stringContains = stringContains;
        /**
         * Takes a string like "jquery-min.4.2.3" and returns "jquery"
         */
        function removeMinAndVersionNumbers(fileName) {
            // Match a "." or "-" followed by a version number or 'min' at the end of the name
            var trailingMinOrVersion = /[.-]((min)|(\d+(\.\d+)*))$/;
            // The "min" or version may both be present, in either order, so try applying the above twice.
            return fileName.replace(trailingMinOrVersion, "").replace(trailingMinOrVersion, "");
        }
        ts.removeMinAndVersionNumbers = removeMinAndVersionNumbers;
        /** Remove an item from an array, moving everything to its right one space left. */
        function orderedRemoveItem(array, item) {
            for (var i = 0; i < array.length; i++) {
                if (array[i] === item) {
                    orderedRemoveItemAt(array, i);
                    return true;
                }
            }
            return false;
        }
        ts.orderedRemoveItem = orderedRemoveItem;
        /** Remove an item by index from an array, moving everything to its right one space left. */
        function orderedRemoveItemAt(array, index) {
            // This seems to be faster than either `array.splice(i, 1)` or `array.copyWithin(i, i+ 1)`.
            for (var i = index; i < array.length - 1; i++) {
                array[i] = array[i + 1];
            }
            array.pop();
        }
        ts.orderedRemoveItemAt = orderedRemoveItemAt;
        function unorderedRemoveItemAt(array, index) {
            // Fill in the "hole" left at `index`.
            array[index] = array[array.length - 1];
            array.pop();
        }
        ts.unorderedRemoveItemAt = unorderedRemoveItemAt;
        /** Remove the *first* occurrence of `item` from the array. */
        function unorderedRemoveItem(array, item) {
            return unorderedRemoveFirstItemWhere(array, function (element) { return element === item; });
        }
        ts.unorderedRemoveItem = unorderedRemoveItem;
        /** Remove the *first* element satisfying `predicate`. */
        function unorderedRemoveFirstItemWhere(array, predicate) {
            for (var i = 0; i < array.length; i++) {
                if (predicate(array[i])) {
                    unorderedRemoveItemAt(array, i);
                    return true;
                }
            }
            return false;
        }
        function createGetCanonicalFileName(useCaseSensitiveFileNames) {
            return useCaseSensitiveFileNames ? identity : toFileNameLowerCase;
        }
        ts.createGetCanonicalFileName = createGetCanonicalFileName;
        function patternText(_a) {
            var prefix = _a.prefix, suffix = _a.suffix;
            return prefix + "*" + suffix;
        }
        ts.patternText = patternText;
        /**
         * Given that candidate matches pattern, returns the text matching the '*'.
         * E.g.: matchedText(tryParsePattern("foo*baz"), "foobarbaz") === "bar"
         */
        function matchedText(pattern, candidate) {
            ts.Debug.assert(isPatternMatch(pattern, candidate));
            return candidate.substring(pattern.prefix.length, candidate.length - pattern.suffix.length);
        }
        ts.matchedText = matchedText;
        /** Return the object corresponding to the best pattern to match `candidate`. */
        function findBestPatternMatch(values, getPattern, candidate) {
            var matchedValue;
            // use length of prefix as betterness criteria
            var longestMatchPrefixLength = -1;
            for (var _i = 0, values_2 = values; _i < values_2.length; _i++) {
                var v = values_2[_i];
                var pattern = getPattern(v);
                if (isPatternMatch(pattern, candidate) && pattern.prefix.length > longestMatchPrefixLength) {
                    longestMatchPrefixLength = pattern.prefix.length;
                    matchedValue = v;
                }
            }
            return matchedValue;
        }
        ts.findBestPatternMatch = findBestPatternMatch;
        function startsWith(str, prefix) {
            return str.lastIndexOf(prefix, 0) === 0;
        }
        ts.startsWith = startsWith;
        function removePrefix(str, prefix) {
            return startsWith(str, prefix) ? str.substr(prefix.length) : str;
        }
        ts.removePrefix = removePrefix;
        function tryRemovePrefix(str, prefix, getCanonicalFileName) {
            if (getCanonicalFileName === void 0) {
                getCanonicalFileName = identity;
            }
            return startsWith(getCanonicalFileName(str), getCanonicalFileName(prefix)) ? str.substring(prefix.length) : undefined;
        }
        ts.tryRemovePrefix = tryRemovePrefix;
        function isPatternMatch(_a, candidate) {
            var prefix = _a.prefix, suffix = _a.suffix;
            return candidate.length >= prefix.length + suffix.length &&
                startsWith(candidate, prefix) &&
                endsWith(candidate, suffix);
        }
        function and(f, g) {
            return function (arg) { return f(arg) && g(arg); };
        }
        ts.and = and;
        function or() {
            var fs = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                fs[_i] = arguments[_i];
            }
            return function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                for (var _a = 0, fs_1 = fs; _a < fs_1.length; _a++) {
                    var f = fs_1[_a];
                    if (f.apply(void 0, args)) {
                        return true;
                    }
                }
                return false;
            };
        }
        ts.or = or;
        function not(fn) {
            return function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                return !fn.apply(void 0, args);
            };
        }
        ts.not = not;
        function assertType(_) { }
        ts.assertType = assertType;
        function singleElementArray(t) {
            return t === undefined ? undefined : [t];
        }
        ts.singleElementArray = singleElementArray;
        function enumerateInsertsAndDeletes(newItems, oldItems, comparer, inserted, deleted, unchanged) {
            unchanged = unchanged || noop;
            var newIndex = 0;
            var oldIndex = 0;
            var newLen = newItems.length;
            var oldLen = oldItems.length;
            while (newIndex < newLen && oldIndex < oldLen) {
                var newItem = newItems[newIndex];
                var oldItem = oldItems[oldIndex];
                var compareResult = comparer(newItem, oldItem);
                if (compareResult === -1 /* LessThan */) {
                    inserted(newItem);
                    newIndex++;
                }
                else if (compareResult === 1 /* GreaterThan */) {
                    deleted(oldItem);
                    oldIndex++;
                }
                else {
                    unchanged(oldItem, newItem);
                    newIndex++;
                    oldIndex++;
                }
            }
            while (newIndex < newLen) {
                inserted(newItems[newIndex++]);
            }
            while (oldIndex < oldLen) {
                deleted(oldItems[oldIndex++]);
            }
        }
        ts.enumerateInsertsAndDeletes = enumerateInsertsAndDeletes;
        function fill(length, cb) {
            var result = Array(length);
            for (var i = 0; i < length; i++) {
                result[i] = cb(i);
            }
            return result;
        }
        ts.fill = fill;
        function cartesianProduct(arrays) {
            var result = [];
            cartesianProductWorker(arrays, result, /*outer*/ undefined, 0);
            return result;
        }
        ts.cartesianProduct = cartesianProduct;
        function cartesianProductWorker(arrays, result, outer, index) {
            for (var _i = 0, _a = arrays[index]; _i < _a.length; _i++) {
                var element = _a[_i];
                var inner = void 0;
                if (outer) {
                    inner = outer.slice();
                    inner.push(element);
                }
                else {
                    inner = [element];
                }
                if (index === arrays.length - 1) {
                    result.push(inner);
                }
                else {
                    cartesianProductWorker(arrays, result, inner, index + 1);
                }
            }
        }
    })(ts || (ts = {}));
    /* @internal */
    var ts;
    (function (ts) {
        var Debug;
        (function (Debug) {
            /* eslint-disable prefer-const */
            Debug.currentAssertionLevel = 0 /* None */;
            Debug.isDebugging = false;
            /* eslint-enable prefer-const */
            function shouldAssert(level) {
                return Debug.currentAssertionLevel >= level;
            }
            Debug.shouldAssert = shouldAssert;
            function assert(expression, message, verboseDebugInfo, stackCrawlMark) {
                if (!expression) {
                    if (verboseDebugInfo) {
                        message += "\r\nVerbose Debug Information: " + (typeof verboseDebugInfo === "string" ? verboseDebugInfo : verboseDebugInfo());
                    }
                    fail(message ? "False expression: " + message : "False expression.", stackCrawlMark || assert);
                }
            }
            Debug.assert = assert;
            function assertEqual(a, b, msg, msg2) {
                if (a !== b) {
                    var message = msg ? msg2 ? msg + " " + msg2 : msg : "";
                    fail("Expected " + a + " === " + b + ". " + message);
                }
            }
            Debug.assertEqual = assertEqual;
            function assertLessThan(a, b, msg) {
                if (a >= b) {
                    fail("Expected " + a + " < " + b + ". " + (msg || ""));
                }
            }
            Debug.assertLessThan = assertLessThan;
            function assertLessThanOrEqual(a, b) {
                if (a > b) {
                    fail("Expected " + a + " <= " + b);
                }
            }
            Debug.assertLessThanOrEqual = assertLessThanOrEqual;
            function assertGreaterThanOrEqual(a, b) {
                if (a < b) {
                    fail("Expected " + a + " >= " + b);
                }
            }
            Debug.assertGreaterThanOrEqual = assertGreaterThanOrEqual;
            function fail(message, stackCrawlMark) {
                debugger;
                var e = new Error(message ? "Debug Failure. " + message : "Debug Failure.");
                if (Error.captureStackTrace) {
                    Error.captureStackTrace(e, stackCrawlMark || fail);
                }
                throw e;
            }
            Debug.fail = fail;
            function assertDefined(value, message) {
                // eslint-disable-next-line no-null/no-null
                if (value === undefined || value === null)
                    return fail(message);
                return value;
            }
            Debug.assertDefined = assertDefined;
            function assertEachDefined(value, message) {
                for (var _i = 0, value_1 = value; _i < value_1.length; _i++) {
                    var v = value_1[_i];
                    assertDefined(v, message);
                }
                return value;
            }
            Debug.assertEachDefined = assertEachDefined;
            function assertNever(member, message, stackCrawlMark) {
                if (message === void 0) {
                    message = "Illegal value:";
                }
                var detail = typeof member === "object" && ts.hasProperty(member, "kind") && ts.hasProperty(member, "pos") && formatSyntaxKind ? "SyntaxKind: " + formatSyntaxKind(member.kind) : JSON.stringify(member);
                return fail(message + " " + detail, stackCrawlMark || assertNever);
            }
            Debug.assertNever = assertNever;
            function getFunctionName(func) {
                if (typeof func !== "function") {
                    return "";
                }
                else if (func.hasOwnProperty("name")) {
                    return func.name;
                }
                else {
                    var text = Function.prototype.toString.call(func);
                    var match = /^function\s+([\w\$]+)\s*\(/.exec(text);
                    return match ? match[1] : "";
                }
            }
            Debug.getFunctionName = getFunctionName;
            function formatSymbol(symbol) {
                return "{ name: " + ts.unescapeLeadingUnderscores(symbol.escapedName) + "; flags: " + formatSymbolFlags(symbol.flags) + "; declarations: " + ts.map(symbol.declarations, function (node) { return formatSyntaxKind(node.kind); }) + " }";
            }
            Debug.formatSymbol = formatSymbol;
            /**
             * Formats an enum value as a string for debugging and debug assertions.
             */
            function formatEnum(value, enumObject, isFlags) {
                if (value === void 0) {
                    value = 0;
                }
                var members = getEnumMembers(enumObject);
                if (value === 0) {
                    return members.length > 0 && members[0][0] === 0 ? members[0][1] : "0";
                }
                if (isFlags) {
                    var result = "";
                    var remainingFlags = value;
                    for (var _i = 0, members_1 = members; _i < members_1.length; _i++) {
                        var _a = members_1[_i], enumValue = _a[0], enumName = _a[1];
                        if (enumValue > value) {
                            break;
                        }
                        if (enumValue !== 0 && enumValue & value) {
                            result = "" + result + (result ? "|" : "") + enumName;
                            remainingFlags &= ~enumValue;
                        }
                    }
                    if (remainingFlags === 0) {
                        return result;
                    }
                }
                else {
                    for (var _b = 0, members_2 = members; _b < members_2.length; _b++) {
                        var _c = members_2[_b], enumValue = _c[0], enumName = _c[1];
                        if (enumValue === value) {
                            return enumName;
                        }
                    }
                }
                return value.toString();
            }
            Debug.formatEnum = formatEnum;
            function getEnumMembers(enumObject) {
                var result = [];
                for (var name in enumObject) {
                    var value = enumObject[name];
                    if (typeof value === "number") {
                        result.push([value, name]);
                    }
                }
                return ts.stableSort(result, function (x, y) { return ts.compareValues(x[0], y[0]); });
            }
            function formatSyntaxKind(kind) {
                return formatEnum(kind, ts.SyntaxKind, /*isFlags*/ false);
            }
            Debug.formatSyntaxKind = formatSyntaxKind;
            function formatNodeFlags(flags) {
                return formatEnum(flags, ts.NodeFlags, /*isFlags*/ true);
            }
            Debug.formatNodeFlags = formatNodeFlags;
            function formatModifierFlags(flags) {
                return formatEnum(flags, ts.ModifierFlags, /*isFlags*/ true);
            }
            Debug.formatModifierFlags = formatModifierFlags;
            function formatTransformFlags(flags) {
                return formatEnum(flags, ts.TransformFlags, /*isFlags*/ true);
            }
            Debug.formatTransformFlags = formatTransformFlags;
            function formatEmitFlags(flags) {
                return formatEnum(flags, ts.EmitFlags, /*isFlags*/ true);
            }
            Debug.formatEmitFlags = formatEmitFlags;
            function formatSymbolFlags(flags) {
                return formatEnum(flags, ts.SymbolFlags, /*isFlags*/ true);
            }
            Debug.formatSymbolFlags = formatSymbolFlags;
            function formatTypeFlags(flags) {
                return formatEnum(flags, ts.TypeFlags, /*isFlags*/ true);
            }
            Debug.formatTypeFlags = formatTypeFlags;
            function formatObjectFlags(flags) {
                return formatEnum(flags, ts.ObjectFlags, /*isFlags*/ true);
            }
            Debug.formatObjectFlags = formatObjectFlags;
            function failBadSyntaxKind(node, message) {
                return fail((message || "Unexpected node.") + "\r\nNode " + formatSyntaxKind(node.kind) + " was unexpected.", failBadSyntaxKind);
            }
            Debug.failBadSyntaxKind = failBadSyntaxKind;
            Debug.assertEachNode = shouldAssert(1 /* Normal */)
                ? function (nodes, test, message) { return assert(test === undefined || ts.every(nodes, test), message || "Unexpected node.", function () { return "Node array did not pass test '" + getFunctionName(test) + "'."; }, Debug.assertEachNode); }
                : ts.noop;
            Debug.assertNode = shouldAssert(1 /* Normal */)
                ? function (node, test, message) { return assert(test === undefined || test(node), message || "Unexpected node.", function () { return "Node " + formatSyntaxKind(node.kind) + " did not pass test '" + getFunctionName(test) + "'."; }, Debug.assertNode); }
                : ts.noop;
            Debug.assertNotNode = shouldAssert(1 /* Normal */)
                ? function (node, test, message) { return assert(test === undefined || !test(node), message || "Unexpected node.", function () { return "Node " + formatSyntaxKind(node.kind) + " should not have passed test '" + getFunctionName(test) + "'."; }, Debug.assertNode); }
                : ts.noop;
            Debug.assertOptionalNode = shouldAssert(1 /* Normal */)
                ? function (node, test, message) { return assert(test === undefined || node === undefined || test(node), message || "Unexpected node.", function () { return "Node " + formatSyntaxKind(node.kind) + " did not pass test '" + getFunctionName(test) + "'."; }, Debug.assertOptionalNode); }
                : ts.noop;
            Debug.assertOptionalToken = shouldAssert(1 /* Normal */)
                ? function (node, kind, message) { return assert(kind === undefined || node === undefined || node.kind === kind, message || "Unexpected node.", function () { return "Node " + formatSyntaxKind(node.kind) + " was not a '" + formatSyntaxKind(kind) + "' token."; }, Debug.assertOptionalToken); }
                : ts.noop;
            Debug.assertMissingNode = shouldAssert(1 /* Normal */)
                ? function (node, message) { return assert(node === undefined, message || "Unexpected node.", function () { return "Node " + formatSyntaxKind(node.kind) + " was unexpected'."; }, Debug.assertMissingNode); }
                : ts.noop;
            var isDebugInfoEnabled = false;
            var extendedDebugModule;
            function extendedDebug() {
                enableDebugInfo();
                if (!extendedDebugModule) {
                    throw new Error("Debugging helpers could not be loaded.");
                }
                return extendedDebugModule;
            }
            function printControlFlowGraph(flowNode) {
                return console.log(formatControlFlowGraph(flowNode));
            }
            Debug.printControlFlowGraph = printControlFlowGraph;
            function formatControlFlowGraph(flowNode) {
                return extendedDebug().formatControlFlowGraph(flowNode);
            }
            Debug.formatControlFlowGraph = formatControlFlowGraph;
            function attachFlowNodeDebugInfo(flowNode) {
                if (isDebugInfoEnabled) {
                    if (!("__debugFlowFlags" in flowNode)) { // eslint-disable-line no-in-operator
                        Object.defineProperties(flowNode, {
                            __debugFlowFlags: { get: function () { return formatEnum(this.flags, ts.FlowFlags, /*isFlags*/ true); } },
                            __debugToString: { value: function () { return formatControlFlowGraph(this); } }
                        });
                    }
                }
            }
            Debug.attachFlowNodeDebugInfo = attachFlowNodeDebugInfo;
            /**
             * Injects debug information into frequently used types.
             */
            function enableDebugInfo() {
                if (isDebugInfoEnabled)
                    return;
                // Add additional properties in debug mode to assist with debugging.
                Object.defineProperties(ts.objectAllocator.getSymbolConstructor().prototype, {
                    __debugFlags: { get: function () { return formatSymbolFlags(this.flags); } }
                });
                Object.defineProperties(ts.objectAllocator.getTypeConstructor().prototype, {
                    __debugFlags: { get: function () { return formatTypeFlags(this.flags); } },
                    __debugObjectFlags: { get: function () { return this.flags & 524288 /* Object */ ? formatObjectFlags(this.objectFlags) : ""; } },
                    __debugTypeToString: { value: function () { return this.checker.typeToString(this); } },
                });
                var nodeConstructors = [
                    ts.objectAllocator.getNodeConstructor(),
                    ts.objectAllocator.getIdentifierConstructor(),
                    ts.objectAllocator.getTokenConstructor(),
                    ts.objectAllocator.getSourceFileConstructor()
                ];
                for (var _i = 0, nodeConstructors_1 = nodeConstructors; _i < nodeConstructors_1.length; _i++) {
                    var ctor = nodeConstructors_1[_i];
                    if (!ctor.prototype.hasOwnProperty("__debugKind")) {
                        Object.defineProperties(ctor.prototype, {
                            __debugKind: { get: function () { return formatSyntaxKind(this.kind); } },
                            __debugNodeFlags: { get: function () { return formatNodeFlags(this.flags); } },
                            __debugModifierFlags: { get: function () { return formatModifierFlags(ts.getModifierFlagsNoCache(this)); } },
                            __debugTransformFlags: { get: function () { return formatTransformFlags(this.transformFlags); } },
                            __debugIsParseTreeNode: { get: function () { return ts.isParseTreeNode(this); } },
                            __debugEmitFlags: { get: function () { return formatEmitFlags(ts.getEmitFlags(this)); } },
                            __debugGetText: {
                                value: function (includeTrivia) {
                                    if (ts.nodeIsSynthesized(this))
                                        return "";
                                    var parseNode = ts.getParseTreeNode(this);
                                    var sourceFile = parseNode && ts.getSourceFileOfNode(parseNode);
                                    return sourceFile ? ts.getSourceTextOfNodeFromSourceFile(sourceFile, parseNode, includeTrivia) : "";
                                }
                            }
                        });
                    }
                }
                // attempt to load extended debugging information
                try {
                    if (ts.sys && ts.sys.require) {
                        var basePath = ts.getDirectoryPath(ts.resolvePath(ts.sys.getExecutingFilePath()));
                        var result = ts.sys.require(basePath, "./compiler-debug");
                        if (!result.error) {
                            result.module.init(ts);
                            extendedDebugModule = result.module;
                        }
                    }
                }
                catch (_a) {
                    // do nothing
                }
                isDebugInfoEnabled = true;
            }
            Debug.enableDebugInfo = enableDebugInfo;
        })(Debug = ts.Debug || (ts.Debug = {}));
    })(ts || (ts = {}));
    /*@internal*/
    var ts;
    (function (ts) {
        /** Gets a timestamp with (at least) ms resolution */
        ts.timestamp = typeof performance !== "undefined" && performance.now ? function () { return performance.now(); } : Date.now ? Date.now : function () { return +(new Date()); };
    })(ts || (ts = {}));
    /*@internal*/
    /** Performance measurements for the compiler. */
    var ts;
    (function (ts) {
        var performance;
        (function (performance) {
            // NOTE: cannot use ts.noop as core.ts loads after this
            var profilerEvent = typeof onProfilerEvent === "function" && onProfilerEvent.profiler === true ? onProfilerEvent : function () { };
            var enabled = false;
            var profilerStart = 0;
            var counts;
            var marks;
            var measures;
            function createTimerIf(condition, measureName, startMarkName, endMarkName) {
                return condition ? createTimer(measureName, startMarkName, endMarkName) : performance.nullTimer;
            }
            performance.createTimerIf = createTimerIf;
            function createTimer(measureName, startMarkName, endMarkName) {
                var enterCount = 0;
                return {
                    enter: enter,
                    exit: exit
                };
                function enter() {
                    if (++enterCount === 1) {
                        mark(startMarkName);
                    }
                }
                function exit() {
                    if (--enterCount === 0) {
                        mark(endMarkName);
                        measure(measureName, startMarkName, endMarkName);
                    }
                    else if (enterCount < 0) {
                        ts.Debug.fail("enter/exit count does not match.");
                    }
                }
            }
            performance.createTimer = createTimer;
            performance.nullTimer = { enter: ts.noop, exit: ts.noop };
            /**
             * Marks a performance event.
             *
             * @param markName The name of the mark.
             */
            function mark(markName) {
                if (enabled) {
                    marks.set(markName, ts.timestamp());
                    counts.set(markName, (counts.get(markName) || 0) + 1);
                    profilerEvent(markName);
                }
            }
            performance.mark = mark;
            /**
             * Adds a performance measurement with the specified name.
             *
             * @param measureName The name of the performance measurement.
             * @param startMarkName The name of the starting mark. If not supplied, the point at which the
             *      profiler was enabled is used.
             * @param endMarkName The name of the ending mark. If not supplied, the current timestamp is
             *      used.
             */
            function measure(measureName, startMarkName, endMarkName) {
                if (enabled) {
                    var end = endMarkName && marks.get(endMarkName) || ts.timestamp();
                    var start = startMarkName && marks.get(startMarkName) || profilerStart;
                    measures.set(measureName, (measures.get(measureName) || 0) + (end - start));
                }
            }
            performance.measure = measure;
            /**
             * Gets the number of times a marker was encountered.
             *
             * @param markName The name of the mark.
             */
            function getCount(markName) {
                return counts && counts.get(markName) || 0;
            }
            performance.getCount = getCount;
            /**
             * Gets the total duration of all measurements with the supplied name.
             *
             * @param measureName The name of the measure whose durations should be accumulated.
             */
            function getDuration(measureName) {
                return measures && measures.get(measureName) || 0;
            }
            performance.getDuration = getDuration;
            /**
             * Iterate over each measure, performing some action
             *
             * @param cb The action to perform for each measure
             */
            function forEachMeasure(cb) {
                measures.forEach(function (measure, key) {
                    cb(key, measure);
                });
            }
            performance.forEachMeasure = forEachMeasure;
            /** Enables (and resets) performance measurements for the compiler. */
            function enable() {
                counts = ts.createMap();
                marks = ts.createMap();
                measures = ts.createMap();
                enabled = true;
                profilerStart = ts.timestamp();
            }
            performance.enable = enable;
            /** Disables performance measurements for the compiler. */
            function disable() {
                enabled = false;
            }
            performance.disable = disable;
        })(performance = ts.performance || (ts.performance = {}));
    })(ts || (ts = {}));
    /* @internal */
    var ts;
    (function (ts) {
        var nullLogger = {
            logEvent: ts.noop,
            logErrEvent: ts.noop,
            logPerfEvent: ts.noop,
            logInfoEvent: ts.noop,
            logStartCommand: ts.noop,
            logStopCommand: ts.noop,
            logStartUpdateProgram: ts.noop,
            logStopUpdateProgram: ts.noop,
            logStartUpdateGraph: ts.noop,
            logStopUpdateGraph: ts.noop,
            logStartResolveModule: ts.noop,
            logStopResolveModule: ts.noop,
            logStartParseSourceFile: ts.noop,
            logStopParseSourceFile: ts.noop,
            logStartReadFile: ts.noop,
            logStopReadFile: ts.noop,
            logStartBindFile: ts.noop,
            logStopBindFile: ts.noop,
            logStartScheduledOperation: ts.noop,
            logStopScheduledOperation: ts.noop,
        };
        // Load optional module to enable Event Tracing for Windows
        // See https://github.com/microsoft/typescript-etw for more information
        var etwModule;
        try {
            // require() will throw an exception if the module is not installed
            // It may also return undefined if not installed properly
            etwModule = require("@microsoft/typescript-etw");
        }
        catch (e) {
            etwModule = undefined;
        }
        /** Performance logger that will generate ETW events if possible - check for `logEvent` member, as `etwModule` will be `{}` when browserified */
        ts.perfLogger = etwModule && etwModule.logEvent ? etwModule : nullLogger;
    })(ts || (ts = {}));
    /* @internal */
    var ts;
    (function (ts) {
        // https://semver.org/#spec-item-2
        // > A normal version number MUST take the form X.Y.Z where X, Y, and Z are non-negative
        // > integers, and MUST NOT contain leading zeroes. X is the major version, Y is the minor
        // > version, and Z is the patch version. Each element MUST increase numerically.
        //
        // NOTE: We differ here in that we allow X and X.Y, with missing parts having the default
        // value of `0`.
        var versionRegExp = /^(0|[1-9]\d*)(?:\.(0|[1-9]\d*)(?:\.(0|[1-9]\d*)(?:\-([a-z0-9-.]+))?(?:\+([a-z0-9-.]+))?)?)?$/i;
        // https://semver.org/#spec-item-9
        // > A pre-release version MAY be denoted by appending a hyphen and a series of dot separated
        // > identifiers immediately following the patch version. Identifiers MUST comprise only ASCII
        // > alphanumerics and hyphen [0-9A-Za-z-]. Identifiers MUST NOT be empty. Numeric identifiers
        // > MUST NOT include leading zeroes.
        var prereleaseRegExp = /^(?:0|[1-9]\d*|[a-z-][a-z0-9-]*)(?:\.(?:0|[1-9]\d*|[a-z-][a-z0-9-]*))*$/i;
        // https://semver.org/#spec-item-10
        // > Build metadata MAY be denoted by appending a plus sign and a series of dot separated
        // > identifiers immediately following the patch or pre-release version. Identifiers MUST
        // > comprise only ASCII alphanumerics and hyphen [0-9A-Za-z-]. Identifiers MUST NOT be empty.
        var buildRegExp = /^[a-z0-9-]+(?:\.[a-z0-9-]+)*$/i;
        // https://semver.org/#spec-item-9
        // > Numeric identifiers MUST NOT include leading zeroes.
        var numericIdentifierRegExp = /^(0|[1-9]\d*)$/;
        /**
         * Describes a precise semantic version number, https://semver.org
         */
        var Version = /** @class */ (function () {
            function Version(major, minor, patch, prerelease, build) {
                if (minor === void 0) {
                    minor = 0;
                }
                if (patch === void 0) {
                    patch = 0;
                }
                if (prerelease === void 0) {
                    prerelease = "";
                }
                if (build === void 0) {
                    build = "";
                }
                if (typeof major === "string") {
                    var result = ts.Debug.assertDefined(tryParseComponents(major), "Invalid version");
                    (major = result.major, minor = result.minor, patch = result.patch, prerelease = result.prerelease, build = result.build);
                }
                ts.Debug.assert(major >= 0, "Invalid argument: major");
                ts.Debug.assert(minor >= 0, "Invalid argument: minor");
                ts.Debug.assert(patch >= 0, "Invalid argument: patch");
                ts.Debug.assert(!prerelease || prereleaseRegExp.test(prerelease), "Invalid argument: prerelease");
                ts.Debug.assert(!build || buildRegExp.test(build), "Invalid argument: build");
                this.major = major;
                this.minor = minor;
                this.patch = patch;
                this.prerelease = prerelease ? prerelease.split(".") : ts.emptyArray;
                this.build = build ? build.split(".") : ts.emptyArray;
            }
            Version.tryParse = function (text) {
                var result = tryParseComponents(text);
                if (!result)
                    return undefined;
                var major = result.major, minor = result.minor, patch = result.patch, prerelease = result.prerelease, build = result.build;
                return new Version(major, minor, patch, prerelease, build);
            };
            Version.prototype.compareTo = function (other) {
                // https://semver.org/#spec-item-11
                // > Precedence is determined by the first difference when comparing each of these
                // > identifiers from left to right as follows: Major, minor, and patch versions are
                // > always compared numerically.
                //
                // https://semver.org/#spec-item-11
                // > Precedence for two pre-release versions with the same major, minor, and patch version
                // > MUST be determined by comparing each dot separated identifier from left to right until
                // > a difference is found [...]
                //
                // https://semver.org/#spec-item-11
                // > Build metadata does not figure into precedence
                if (this === other)
                    return 0 /* EqualTo */;
                if (other === undefined)
                    return 1 /* GreaterThan */;
                return ts.compareValues(this.major, other.major)
                    || ts.compareValues(this.minor, other.minor)
                    || ts.compareValues(this.patch, other.patch)
                    || comparePrerelaseIdentifiers(this.prerelease, other.prerelease);
            };
            Version.prototype.increment = function (field) {
                switch (field) {
                    case "major": return new Version(this.major + 1, 0, 0);
                    case "minor": return new Version(this.major, this.minor + 1, 0);
                    case "patch": return new Version(this.major, this.minor, this.patch + 1);
                    default: return ts.Debug.assertNever(field);
                }
            };
            Version.prototype.toString = function () {
                var result = this.major + "." + this.minor + "." + this.patch;
                if (ts.some(this.prerelease))
                    result += "-" + this.prerelease.join(".");
                if (ts.some(this.build))
                    result += "+" + this.build.join(".");
                return result;
            };
            Version.zero = new Version(0, 0, 0);
            return Version;
        }());
        ts.Version = Version;
        function tryParseComponents(text) {
            var match = versionRegExp.exec(text);
            if (!match)
                return undefined;
            var major = match[1], _a = match[2], minor = _a === void 0 ? "0" : _a, _b = match[3], patch = _b === void 0 ? "0" : _b, _c = match[4], prerelease = _c === void 0 ? "" : _c, _d = match[5], build = _d === void 0 ? "" : _d;
            if (prerelease && !prereleaseRegExp.test(prerelease))
                return undefined;
            if (build && !buildRegExp.test(build))
                return undefined;
            return {
                major: parseInt(major, 10),
                minor: parseInt(minor, 10),
                patch: parseInt(patch, 10),
                prerelease: prerelease,
                build: build
            };
        }
        function comparePrerelaseIdentifiers(left, right) {
            // https://semver.org/#spec-item-11
            // > When major, minor, and patch are equal, a pre-release version has lower precedence
            // > than a normal version.
            if (left === right)
                return 0 /* EqualTo */;
            if (left.length === 0)
                return right.length === 0 ? 0 /* EqualTo */ : 1 /* GreaterThan */;
            if (right.length === 0)
                return -1 /* LessThan */;
            // https://semver.org/#spec-item-11
            // > Precedence for two pre-release versions with the same major, minor, and patch version
            // > MUST be determined by comparing each dot separated identifier from left to right until
            // > a difference is found [...]
            var length = Math.min(left.length, right.length);
            for (var i = 0; i < length; i++) {
                var leftIdentifier = left[i];
                var rightIdentifier = right[i];
                if (leftIdentifier === rightIdentifier)
                    continue;
                var leftIsNumeric = numericIdentifierRegExp.test(leftIdentifier);
                var rightIsNumeric = numericIdentifierRegExp.test(rightIdentifier);
                if (leftIsNumeric || rightIsNumeric) {
                    // https://semver.org/#spec-item-11
                    // > Numeric identifiers always have lower precedence than non-numeric identifiers.
                    if (leftIsNumeric !== rightIsNumeric)
                        return leftIsNumeric ? -1 /* LessThan */ : 1 /* GreaterThan */;
                    // https://semver.org/#spec-item-11
                    // > identifiers consisting of only digits are compared numerically
                    var result = ts.compareValues(+leftIdentifier, +rightIdentifier);
                    if (result)
                        return result;
                }
                else {
                    // https://semver.org/#spec-item-11
                    // > identifiers with letters or hyphens are compared lexically in ASCII sort order.
                    var result = ts.compareStringsCaseSensitive(leftIdentifier, rightIdentifier);
                    if (result)
                        return result;
                }
            }
            // https://semver.org/#spec-item-11
            // > A larger set of pre-release fields has a higher precedence than a smaller set, if all
            // > of the preceding identifiers are equal.
            return ts.compareValues(left.length, right.length);
        }
        /**
         * Describes a semantic version range, per https://github.com/npm/node-semver#ranges
         */
        var VersionRange = /** @class */ (function () {
            function VersionRange(spec) {
                this._alternatives = spec ? ts.Debug.assertDefined(parseRange(spec), "Invalid range spec.") : ts.emptyArray;
            }
            VersionRange.tryParse = function (text) {
                var sets = parseRange(text);
                if (sets) {
                    var range = new VersionRange("");
                    range._alternatives = sets;
                    return range;
                }
                return undefined;
            };
            VersionRange.prototype.test = function (version) {
                if (typeof version === "string")
                    version = new Version(version);
                return testDisjunction(version, this._alternatives);
            };
            VersionRange.prototype.toString = function () {
                return formatDisjunction(this._alternatives);
            };
            return VersionRange;
        }());
        ts.VersionRange = VersionRange;
        // https://github.com/npm/node-semver#range-grammar
        //
        // range-set    ::= range ( logical-or range ) *
        // range        ::= hyphen | simple ( ' ' simple ) * | ''
        // logical-or   ::= ( ' ' ) * '||' ( ' ' ) *
        var logicalOrRegExp = /\s*\|\|\s*/g;
        var whitespaceRegExp = /\s+/g;
        // https://github.com/npm/node-semver#range-grammar
        //
        // partial      ::= xr ( '.' xr ( '.' xr qualifier ? )? )?
        // xr           ::= 'x' | 'X' | '*' | nr
        // nr           ::= '0' | ['1'-'9'] ( ['0'-'9'] ) *
        // qualifier    ::= ( '-' pre )? ( '+' build )?
        // pre          ::= parts
        // build        ::= parts
        // parts        ::= part ( '.' part ) *
        // part         ::= nr | [-0-9A-Za-z]+
        var partialRegExp = /^([xX*0]|[1-9]\d*)(?:\.([xX*0]|[1-9]\d*)(?:\.([xX*0]|[1-9]\d*)(?:-([a-z0-9-.]+))?(?:\+([a-z0-9-.]+))?)?)?$/i;
        // https://github.com/npm/node-semver#range-grammar
        //
        // hyphen       ::= partial ' - ' partial
        var hyphenRegExp = /^\s*([a-z0-9-+.*]+)\s+-\s+([a-z0-9-+.*]+)\s*$/i;
        // https://github.com/npm/node-semver#range-grammar
        //
        // simple       ::= primitive | partial | tilde | caret
        // primitive    ::= ( '<' | '>' | '>=' | '<=' | '=' ) partial
        // tilde        ::= '~' partial
        // caret        ::= '^' partial
        var rangeRegExp = /^\s*(~|\^|<|<=|>|>=|=)?\s*([a-z0-9-+.*]+)$/i;
        function parseRange(text) {
            var alternatives = [];
            for (var _i = 0, _a = text.trim().split(logicalOrRegExp); _i < _a.length; _i++) {
                var range = _a[_i];
                if (!range)
                    continue;
                var comparators = [];
                var match = hyphenRegExp.exec(range);
                if (match) {
                    if (!parseHyphen(match[1], match[2], comparators))
                        return undefined;
                }
                else {
                    for (var _b = 0, _c = range.split(whitespaceRegExp); _b < _c.length; _b++) {
                        var simple = _c[_b];
                        var match_1 = rangeRegExp.exec(simple);
                        if (!match_1 || !parseComparator(match_1[1], match_1[2], comparators))
                            return undefined;
                    }
                }
                alternatives.push(comparators);
            }
            return alternatives;
        }
        function parsePartial(text) {
            var match = partialRegExp.exec(text);
            if (!match)
                return undefined;
            var major = match[1], _a = match[2], minor = _a === void 0 ? "*" : _a, _b = match[3], patch = _b === void 0 ? "*" : _b, prerelease = match[4], build = match[5];
            var version = new Version(isWildcard(major) ? 0 : parseInt(major, 10), isWildcard(major) || isWildcard(minor) ? 0 : parseInt(minor, 10), isWildcard(major) || isWildcard(minor) || isWildcard(patch) ? 0 : parseInt(patch, 10), prerelease, build);
            return { version: version, major: major, minor: minor, patch: patch };
        }
        function parseHyphen(left, right, comparators) {
            var leftResult = parsePartial(left);
            if (!leftResult)
                return false;
            var rightResult = parsePartial(right);
            if (!rightResult)
                return false;
            if (!isWildcard(leftResult.major)) {
                comparators.push(createComparator(">=", leftResult.version));
            }
            if (!isWildcard(rightResult.major)) {
                comparators.push(isWildcard(rightResult.minor) ? createComparator("<", rightResult.version.increment("major")) :
                    isWildcard(rightResult.patch) ? createComparator("<", rightResult.version.increment("minor")) :
                        createComparator("<=", rightResult.version));
            }
            return true;
        }
        function parseComparator(operator, text, comparators) {
            var result = parsePartial(text);
            if (!result)
                return false;
            var version = result.version, major = result.major, minor = result.minor, patch = result.patch;
            if (!isWildcard(major)) {
                switch (operator) {
                    case "~":
                        comparators.push(createComparator(">=", version));
                        comparators.push(createComparator("<", version.increment(isWildcard(minor) ? "major" :
                            "minor")));
                        break;
                    case "^":
                        comparators.push(createComparator(">=", version));
                        comparators.push(createComparator("<", version.increment(version.major > 0 || isWildcard(minor) ? "major" :
                            version.minor > 0 || isWildcard(patch) ? "minor" :
                                "patch")));
                        break;
                    case "<":
                    case ">=":
                        comparators.push(createComparator(operator, version));
                        break;
                    case "<=":
                    case ">":
                        comparators.push(isWildcard(minor) ? createComparator(operator === "<=" ? "<" : ">=", version.increment("major")) :
                            isWildcard(patch) ? createComparator(operator === "<=" ? "<" : ">=", version.increment("minor")) :
                                createComparator(operator, version));
                        break;
                    case "=":
                    case undefined:
                        if (isWildcard(minor) || isWildcard(patch)) {
                            comparators.push(createComparator(">=", version));
                            comparators.push(createComparator("<", version.increment(isWildcard(minor) ? "major" : "minor")));
                        }
                        else {
                            comparators.push(createComparator("=", version));
                        }
                        break;
                    default:
                        // unrecognized
                        return false;
                }
            }
            else if (operator === "<" || operator === ">") {
                comparators.push(createComparator("<", Version.zero));
            }
            return true;
        }
        function isWildcard(part) {
            return part === "*" || part === "x" || part === "X";
        }
        function createComparator(operator, operand) {
            return { operator: operator, operand: operand };
        }
        function testDisjunction(version, alternatives) {
            // an empty disjunction is treated as "*" (all versions)
            if (alternatives.length === 0)
                return true;
            for (var _i = 0, alternatives_1 = alternatives; _i < alternatives_1.length; _i++) {
                var alternative = alternatives_1[_i];
                if (testAlternative(version, alternative))
                    return true;
            }
            return false;
        }
        function testAlternative(version, comparators) {
            for (var _i = 0, comparators_1 = comparators; _i < comparators_1.length; _i++) {
                var comparator = comparators_1[_i];
                if (!testComparator(version, comparator.operator, comparator.operand))
                    return false;
            }
            return true;
        }
        function testComparator(version, operator, operand) {
            var cmp = version.compareTo(operand);
            switch (operator) {
                case "<": return cmp < 0;
                case "<=": return cmp <= 0;
                case ">": return cmp > 0;
                case ">=": return cmp >= 0;
                case "=": return cmp === 0;
                default: return ts.Debug.assertNever(operator);
            }
        }
        function formatDisjunction(alternatives) {
            return ts.map(alternatives, formatAlternative).join(" || ") || "*";
        }
        function formatAlternative(comparators) {
            return ts.map(comparators, formatComparator).join(" ");
        }
        function formatComparator(comparator) {
            return "" + comparator.operator + comparator.operand;
        }
    })(ts || (ts = {}));
    var ts;
    (function (ts) {
        // token > SyntaxKind.Identifier => token is a keyword
        // Also, If you add a new SyntaxKind be sure to keep the `Markers` section at the bottom in sync
        var SyntaxKind;
        (function (SyntaxKind) {
            SyntaxKind[SyntaxKind["Unknown"] = 0] = "Unknown";
            SyntaxKind[SyntaxKind["EndOfFileToken"] = 1] = "EndOfFileToken";
            SyntaxKind[SyntaxKind["SingleLineCommentTrivia"] = 2] = "SingleLineCommentTrivia";
            SyntaxKind[SyntaxKind["MultiLineCommentTrivia"] = 3] = "MultiLineCommentTrivia";
            SyntaxKind[SyntaxKind["NewLineTrivia"] = 4] = "NewLineTrivia";
            SyntaxKind[SyntaxKind["WhitespaceTrivia"] = 5] = "WhitespaceTrivia";
            // We detect and preserve #! on the first line
            SyntaxKind[SyntaxKind["ShebangTrivia"] = 6] = "ShebangTrivia";
            // We detect and provide better error recovery when we encounter a git merge marker.  This
            // allows us to edit files with git-conflict markers in them in a much more pleasant manner.
            SyntaxKind[SyntaxKind["ConflictMarkerTrivia"] = 7] = "ConflictMarkerTrivia";
            // Literals
            SyntaxKind[SyntaxKind["NumericLiteral"] = 8] = "NumericLiteral";
            SyntaxKind[SyntaxKind["BigIntLiteral"] = 9] = "BigIntLiteral";
            SyntaxKind[SyntaxKind["StringLiteral"] = 10] = "StringLiteral";
            SyntaxKind[SyntaxKind["JsxText"] = 11] = "JsxText";
            SyntaxKind[SyntaxKind["JsxTextAllWhiteSpaces"] = 12] = "JsxTextAllWhiteSpaces";
            SyntaxKind[SyntaxKind["RegularExpressionLiteral"] = 13] = "RegularExpressionLiteral";
            SyntaxKind[SyntaxKind["NoSubstitutionTemplateLiteral"] = 14] = "NoSubstitutionTemplateLiteral";
            // Pseudo-literals
            SyntaxKind[SyntaxKind["TemplateHead"] = 15] = "TemplateHead";
            SyntaxKind[SyntaxKind["TemplateMiddle"] = 16] = "TemplateMiddle";
            SyntaxKind[SyntaxKind["TemplateTail"] = 17] = "TemplateTail";
            // Punctuation
            SyntaxKind[SyntaxKind["OpenBraceToken"] = 18] = "OpenBraceToken";
            SyntaxKind[SyntaxKind["CloseBraceToken"] = 19] = "CloseBraceToken";
            SyntaxKind[SyntaxKind["OpenParenToken"] = 20] = "OpenParenToken";
            SyntaxKind[SyntaxKind["CloseParenToken"] = 21] = "CloseParenToken";
            SyntaxKind[SyntaxKind["OpenBracketToken"] = 22] = "OpenBracketToken";
            SyntaxKind[SyntaxKind["CloseBracketToken"] = 23] = "CloseBracketToken";
            SyntaxKind[SyntaxKind["DotToken"] = 24] = "DotToken";
            SyntaxKind[SyntaxKind["DotDotDotToken"] = 25] = "DotDotDotToken";
            SyntaxKind[SyntaxKind["SemicolonToken"] = 26] = "SemicolonToken";
            SyntaxKind[SyntaxKind["CommaToken"] = 27] = "CommaToken";
            SyntaxKind[SyntaxKind["QuestionDotToken"] = 28] = "QuestionDotToken";
            SyntaxKind[SyntaxKind["LessThanToken"] = 29] = "LessThanToken";
            SyntaxKind[SyntaxKind["LessThanSlashToken"] = 30] = "LessThanSlashToken";
            SyntaxKind[SyntaxKind["GreaterThanToken"] = 31] = "GreaterThanToken";
            SyntaxKind[SyntaxKind["LessThanEqualsToken"] = 32] = "LessThanEqualsToken";
            SyntaxKind[SyntaxKind["GreaterThanEqualsToken"] = 33] = "GreaterThanEqualsToken";
            SyntaxKind[SyntaxKind["EqualsEqualsToken"] = 34] = "EqualsEqualsToken";
            SyntaxKind[SyntaxKind["ExclamationEqualsToken"] = 35] = "ExclamationEqualsToken";
            SyntaxKind[SyntaxKind["EqualsEqualsEqualsToken"] = 36] = "EqualsEqualsEqualsToken";
            SyntaxKind[SyntaxKind["ExclamationEqualsEqualsToken"] = 37] = "ExclamationEqualsEqualsToken";
            SyntaxKind[SyntaxKind["EqualsGreaterThanToken"] = 38] = "EqualsGreaterThanToken";
            SyntaxKind[SyntaxKind["PlusToken"] = 39] = "PlusToken";
            SyntaxKind[SyntaxKind["MinusToken"] = 40] = "MinusToken";
            SyntaxKind[SyntaxKind["AsteriskToken"] = 41] = "AsteriskToken";
            SyntaxKind[SyntaxKind["AsteriskAsteriskToken"] = 42] = "AsteriskAsteriskToken";
            SyntaxKind[SyntaxKind["SlashToken"] = 43] = "SlashToken";
            SyntaxKind[SyntaxKind["PercentToken"] = 44] = "PercentToken";
            SyntaxKind[SyntaxKind["PlusPlusToken"] = 45] = "PlusPlusToken";
            SyntaxKind[SyntaxKind["MinusMinusToken"] = 46] = "MinusMinusToken";
            SyntaxKind[SyntaxKind["LessThanLessThanToken"] = 47] = "LessThanLessThanToken";
            SyntaxKind[SyntaxKind["GreaterThanGreaterThanToken"] = 48] = "GreaterThanGreaterThanToken";
            SyntaxKind[SyntaxKind["GreaterThanGreaterThanGreaterThanToken"] = 49] = "GreaterThanGreaterThanGreaterThanToken";
            SyntaxKind[SyntaxKind["AmpersandToken"] = 50] = "AmpersandToken";
            SyntaxKind[SyntaxKind["BarToken"] = 51] = "BarToken";
            SyntaxKind[SyntaxKind["CaretToken"] = 52] = "CaretToken";
            SyntaxKind[SyntaxKind["ExclamationToken"] = 53] = "ExclamationToken";
            SyntaxKind[SyntaxKind["TildeToken"] = 54] = "TildeToken";
            SyntaxKind[SyntaxKind["AmpersandAmpersandToken"] = 55] = "AmpersandAmpersandToken";
            SyntaxKind[SyntaxKind["BarBarToken"] = 56] = "BarBarToken";
            SyntaxKind[SyntaxKind["QuestionToken"] = 57] = "QuestionToken";
            SyntaxKind[SyntaxKind["ColonToken"] = 58] = "ColonToken";
            SyntaxKind[SyntaxKind["AtToken"] = 59] = "AtToken";
            SyntaxKind[SyntaxKind["QuestionQuestionToken"] = 60] = "QuestionQuestionToken";
            /** Only the JSDoc scanner produces BacktickToken. The normal scanner produces NoSubstitutionTemplateLiteral and related kinds. */
            SyntaxKind[SyntaxKind["BacktickToken"] = 61] = "BacktickToken";
            // Assignments
            SyntaxKind[SyntaxKind["EqualsToken"] = 62] = "EqualsToken";
            SyntaxKind[SyntaxKind["PlusEqualsToken"] = 63] = "PlusEqualsToken";
            SyntaxKind[SyntaxKind["MinusEqualsToken"] = 64] = "MinusEqualsToken";
            SyntaxKind[SyntaxKind["AsteriskEqualsToken"] = 65] = "AsteriskEqualsToken";
            SyntaxKind[SyntaxKind["AsteriskAsteriskEqualsToken"] = 66] = "AsteriskAsteriskEqualsToken";
            SyntaxKind[SyntaxKind["SlashEqualsToken"] = 67] = "SlashEqualsToken";
            SyntaxKind[SyntaxKind["PercentEqualsToken"] = 68] = "PercentEqualsToken";
            SyntaxKind[SyntaxKind["LessThanLessThanEqualsToken"] = 69] = "LessThanLessThanEqualsToken";
            SyntaxKind[SyntaxKind["GreaterThanGreaterThanEqualsToken"] = 70] = "GreaterThanGreaterThanEqualsToken";
            SyntaxKind[SyntaxKind["GreaterThanGreaterThanGreaterThanEqualsToken"] = 71] = "GreaterThanGreaterThanGreaterThanEqualsToken";
            SyntaxKind[SyntaxKind["AmpersandEqualsToken"] = 72] = "AmpersandEqualsToken";
            SyntaxKind[SyntaxKind["BarEqualsToken"] = 73] = "BarEqualsToken";
            SyntaxKind[SyntaxKind["CaretEqualsToken"] = 74] = "CaretEqualsToken";
            // Identifiers and PrivateIdentifiers
            SyntaxKind[SyntaxKind["Identifier"] = 75] = "Identifier";
            SyntaxKind[SyntaxKind["PrivateIdentifier"] = 76] = "PrivateIdentifier";
            // Reserved words
            SyntaxKind[SyntaxKind["BreakKeyword"] = 77] = "BreakKeyword";
            SyntaxKind[SyntaxKind["CaseKeyword"] = 78] = "CaseKeyword";
            SyntaxKind[SyntaxKind["CatchKeyword"] = 79] = "CatchKeyword";
            SyntaxKind[SyntaxKind["ClassKeyword"] = 80] = "ClassKeyword";
            SyntaxKind[SyntaxKind["ConstKeyword"] = 81] = "ConstKeyword";
            SyntaxKind[SyntaxKind["ContinueKeyword"] = 82] = "ContinueKeyword";
            SyntaxKind[SyntaxKind["DebuggerKeyword"] = 83] = "DebuggerKeyword";
            SyntaxKind[SyntaxKind["DefaultKeyword"] = 84] = "DefaultKeyword";
            SyntaxKind[SyntaxKind["DeleteKeyword"] = 85] = "DeleteKeyword";
            SyntaxKind[SyntaxKind["DoKeyword"] = 86] = "DoKeyword";
            SyntaxKind[SyntaxKind["ElseKeyword"] = 87] = "ElseKeyword";
            SyntaxKind[SyntaxKind["EnumKeyword"] = 88] = "EnumKeyword";
            SyntaxKind[SyntaxKind["ExportKeyword"] = 89] = "ExportKeyword";
            SyntaxKind[SyntaxKind["ExtendsKeyword"] = 90] = "ExtendsKeyword";
            SyntaxKind[SyntaxKind["FalseKeyword"] = 91] = "FalseKeyword";
            SyntaxKind[SyntaxKind["FinallyKeyword"] = 92] = "FinallyKeyword";
            SyntaxKind[SyntaxKind["ForKeyword"] = 93] = "ForKeyword";
            SyntaxKind[SyntaxKind["FunctionKeyword"] = 94] = "FunctionKeyword";
            SyntaxKind[SyntaxKind["IfKeyword"] = 95] = "IfKeyword";
            SyntaxKind[SyntaxKind["ImportKeyword"] = 96] = "ImportKeyword";
            SyntaxKind[SyntaxKind["InKeyword"] = 97] = "InKeyword";
            SyntaxKind[SyntaxKind["InstanceOfKeyword"] = 98] = "InstanceOfKeyword";
            SyntaxKind[SyntaxKind["NewKeyword"] = 99] = "NewKeyword";
            SyntaxKind[SyntaxKind["NullKeyword"] = 100] = "NullKeyword";
            SyntaxKind[SyntaxKind["ReturnKeyword"] = 101] = "ReturnKeyword";
            SyntaxKind[SyntaxKind["SuperKeyword"] = 102] = "SuperKeyword";
            SyntaxKind[SyntaxKind["SwitchKeyword"] = 103] = "SwitchKeyword";
            SyntaxKind[SyntaxKind["ThisKeyword"] = 104] = "ThisKeyword";
            SyntaxKind[SyntaxKind["ThrowKeyword"] = 105] = "ThrowKeyword";
            SyntaxKind[SyntaxKind["TrueKeyword"] = 106] = "TrueKeyword";
            SyntaxKind[SyntaxKind["TryKeyword"] = 107] = "TryKeyword";
            SyntaxKind[SyntaxKind["TypeOfKeyword"] = 108] = "TypeOfKeyword";
            SyntaxKind[SyntaxKind["VarKeyword"] = 109] = "VarKeyword";
            SyntaxKind[SyntaxKind["VoidKeyword"] = 110] = "VoidKeyword";
            SyntaxKind[SyntaxKind["WhileKeyword"] = 111] = "WhileKeyword";
            SyntaxKind[SyntaxKind["WithKeyword"] = 112] = "WithKeyword";
            // Strict mode reserved words
            SyntaxKind[SyntaxKind["ImplementsKeyword"] = 113] = "ImplementsKeyword";
            SyntaxKind[SyntaxKind["InterfaceKeyword"] = 114] = "InterfaceKeyword";
            SyntaxKind[SyntaxKind["LetKeyword"] = 115] = "LetKeyword";
            SyntaxKind[SyntaxKind["PackageKeyword"] = 116] = "PackageKeyword";
            SyntaxKind[SyntaxKind["PrivateKeyword"] = 117] = "PrivateKeyword";
            SyntaxKind[SyntaxKind["ProtectedKeyword"] = 118] = "ProtectedKeyword";
            SyntaxKind[SyntaxKind["PublicKeyword"] = 119] = "PublicKeyword";
            SyntaxKind[SyntaxKind["StaticKeyword"] = 120] = "StaticKeyword";
            SyntaxKind[SyntaxKind["YieldKeyword"] = 121] = "YieldKeyword";
            // Contextual keywords
            SyntaxKind[SyntaxKind["AbstractKeyword"] = 122] = "AbstractKeyword";
            SyntaxKind[SyntaxKind["AsKeyword"] = 123] = "AsKeyword";
            SyntaxKind[SyntaxKind["AssertsKeyword"] = 124] = "AssertsKeyword";
            SyntaxKind[SyntaxKind["AnyKeyword"] = 125] = "AnyKeyword";
            SyntaxKind[SyntaxKind["AsyncKeyword"] = 126] = "AsyncKeyword";
            SyntaxKind[SyntaxKind["AwaitKeyword"] = 127] = "AwaitKeyword";
            SyntaxKind[SyntaxKind["BooleanKeyword"] = 128] = "BooleanKeyword";
            SyntaxKind[SyntaxKind["ConstructorKeyword"] = 129] = "ConstructorKeyword";
            SyntaxKind[SyntaxKind["DeclareKeyword"] = 130] = "DeclareKeyword";
            SyntaxKind[SyntaxKind["GetKeyword"] = 131] = "GetKeyword";
            SyntaxKind[SyntaxKind["InferKeyword"] = 132] = "InferKeyword";
            SyntaxKind[SyntaxKind["IsKeyword"] = 133] = "IsKeyword";
            SyntaxKind[SyntaxKind["KeyOfKeyword"] = 134] = "KeyOfKeyword";
            SyntaxKind[SyntaxKind["ModuleKeyword"] = 135] = "ModuleKeyword";
            SyntaxKind[SyntaxKind["NamespaceKeyword"] = 136] = "NamespaceKeyword";
            SyntaxKind[SyntaxKind["NeverKeyword"] = 137] = "NeverKeyword";
            SyntaxKind[SyntaxKind["ReadonlyKeyword"] = 138] = "ReadonlyKeyword";
            SyntaxKind[SyntaxKind["RequireKeyword"] = 139] = "RequireKeyword";
            SyntaxKind[SyntaxKind["NumberKeyword"] = 140] = "NumberKeyword";
            SyntaxKind[SyntaxKind["ObjectKeyword"] = 141] = "ObjectKeyword";
            SyntaxKind[SyntaxKind["SetKeyword"] = 142] = "SetKeyword";
            SyntaxKind[SyntaxKind["StringKeyword"] = 143] = "StringKeyword";
            SyntaxKind[SyntaxKind["SymbolKeyword"] = 144] = "SymbolKeyword";
            SyntaxKind[SyntaxKind["TypeKeyword"] = 145] = "TypeKeyword";
            SyntaxKind[SyntaxKind["UndefinedKeyword"] = 146] = "UndefinedKeyword";
            SyntaxKind[SyntaxKind["UniqueKeyword"] = 147] = "UniqueKeyword";
            SyntaxKind[SyntaxKind["UnknownKeyword"] = 148] = "UnknownKeyword";
            SyntaxKind[SyntaxKind["FromKeyword"] = 149] = "FromKeyword";
            SyntaxKind[SyntaxKind["GlobalKeyword"] = 150] = "GlobalKeyword";
            SyntaxKind[SyntaxKind["BigIntKeyword"] = 151] = "BigIntKeyword";
            SyntaxKind[SyntaxKind["OfKeyword"] = 152] = "OfKeyword";
            // Parse tree nodes
            // Names
            SyntaxKind[SyntaxKind["QualifiedName"] = 153] = "QualifiedName";
            SyntaxKind[SyntaxKind["ComputedPropertyName"] = 154] = "ComputedPropertyName";
            // Signature elements
            SyntaxKind[SyntaxKind["TypeParameter"] = 155] = "TypeParameter";
            SyntaxKind[SyntaxKind["Parameter"] = 156] = "Parameter";
            SyntaxKind[SyntaxKind["Decorator"] = 157] = "Decorator";
            // TypeMember
            SyntaxKind[SyntaxKind["PropertySignature"] = 158] = "PropertySignature";
            SyntaxKind[SyntaxKind["PropertyDeclaration"] = 159] = "PropertyDeclaration";
            SyntaxKind[SyntaxKind["MethodSignature"] = 160] = "MethodSignature";
            SyntaxKind[SyntaxKind["MethodDeclaration"] = 161] = "MethodDeclaration";
            SyntaxKind[SyntaxKind["Constructor"] = 162] = "Constructor";
            SyntaxKind[SyntaxKind["GetAccessor"] = 163] = "GetAccessor";
            SyntaxKind[SyntaxKind["SetAccessor"] = 164] = "SetAccessor";
            SyntaxKind[SyntaxKind["CallSignature"] = 165] = "CallSignature";
            SyntaxKind[SyntaxKind["ConstructSignature"] = 166] = "ConstructSignature";
            SyntaxKind[SyntaxKind["IndexSignature"] = 167] = "IndexSignature";
            // Type
            SyntaxKind[SyntaxKind["TypePredicate"] = 168] = "TypePredicate";
            SyntaxKind[SyntaxKind["TypeReference"] = 169] = "TypeReference";
            SyntaxKind[SyntaxKind["FunctionType"] = 170] = "FunctionType";
            SyntaxKind[SyntaxKind["ConstructorType"] = 171] = "ConstructorType";
            SyntaxKind[SyntaxKind["TypeQuery"] = 172] = "TypeQuery";
            SyntaxKind[SyntaxKind["TypeLiteral"] = 173] = "TypeLiteral";
            SyntaxKind[SyntaxKind["ArrayType"] = 174] = "ArrayType";
            SyntaxKind[SyntaxKind["TupleType"] = 175] = "TupleType";
            SyntaxKind[SyntaxKind["OptionalType"] = 176] = "OptionalType";
            SyntaxKind[SyntaxKind["RestType"] = 177] = "RestType";
            SyntaxKind[SyntaxKind["UnionType"] = 178] = "UnionType";
            SyntaxKind[SyntaxKind["IntersectionType"] = 179] = "IntersectionType";
            SyntaxKind[SyntaxKind["ConditionalType"] = 180] = "ConditionalType";
            SyntaxKind[SyntaxKind["InferType"] = 181] = "InferType";
            SyntaxKind[SyntaxKind["ParenthesizedType"] = 182] = "ParenthesizedType";
            SyntaxKind[SyntaxKind["ThisType"] = 183] = "ThisType";
            SyntaxKind[SyntaxKind["TypeOperator"] = 184] = "TypeOperator";
            SyntaxKind[SyntaxKind["IndexedAccessType"] = 185] = "IndexedAccessType";
            SyntaxKind[SyntaxKind["MappedType"] = 186] = "MappedType";
            SyntaxKind[SyntaxKind["LiteralType"] = 187] = "LiteralType";
            SyntaxKind[SyntaxKind["ImportType"] = 188] = "ImportType";
            // Binding patterns
            SyntaxKind[SyntaxKind["ObjectBindingPattern"] = 189] = "ObjectBindingPattern";
            SyntaxKind[SyntaxKind["ArrayBindingPattern"] = 190] = "ArrayBindingPattern";
            SyntaxKind[SyntaxKind["BindingElement"] = 191] = "BindingElement";
            // Expression
            SyntaxKind[SyntaxKind["ArrayLiteralExpression"] = 192] = "ArrayLiteralExpression";
            SyntaxKind[SyntaxKind["ObjectLiteralExpression"] = 193] = "ObjectLiteralExpression";
            SyntaxKind[SyntaxKind["PropertyAccessExpression"] = 194] = "PropertyAccessExpression";
            SyntaxKind[SyntaxKind["ElementAccessExpression"] = 195] = "ElementAccessExpression";
            SyntaxKind[SyntaxKind["CallExpression"] = 196] = "CallExpression";
            SyntaxKind[SyntaxKind["NewExpression"] = 197] = "NewExpression";
            SyntaxKind[SyntaxKind["TaggedTemplateExpression"] = 198] = "TaggedTemplateExpression";
            SyntaxKind[SyntaxKind["TypeAssertionExpression"] = 199] = "TypeAssertionExpression";
            SyntaxKind[SyntaxKind["ParenthesizedExpression"] = 200] = "ParenthesizedExpression";
            SyntaxKind[SyntaxKind["FunctionExpression"] = 201] = "FunctionExpression";
            SyntaxKind[SyntaxKind["ArrowFunction"] = 202] = "ArrowFunction";
            SyntaxKind[SyntaxKind["DeleteExpression"] = 203] = "DeleteExpression";
            SyntaxKind[SyntaxKind["TypeOfExpression"] = 204] = "TypeOfExpression";
            SyntaxKind[SyntaxKind["VoidExpression"] = 205] = "VoidExpression";
            SyntaxKind[SyntaxKind["AwaitExpression"] = 206] = "AwaitExpression";
            SyntaxKind[SyntaxKind["PrefixUnaryExpression"] = 207] = "PrefixUnaryExpression";
            SyntaxKind[SyntaxKind["PostfixUnaryExpression"] = 208] = "PostfixUnaryExpression";
            SyntaxKind[SyntaxKind["BinaryExpression"] = 209] = "BinaryExpression";
            SyntaxKind[SyntaxKind["ConditionalExpression"] = 210] = "ConditionalExpression";
            SyntaxKind[SyntaxKind["TemplateExpression"] = 211] = "TemplateExpression";
            SyntaxKind[SyntaxKind["YieldExpression"] = 212] = "YieldExpression";
            SyntaxKind[SyntaxKind["SpreadElement"] = 213] = "SpreadElement";
            SyntaxKind[SyntaxKind["ClassExpression"] = 214] = "ClassExpression";
            SyntaxKind[SyntaxKind["OmittedExpression"] = 215] = "OmittedExpression";
            SyntaxKind[SyntaxKind["ExpressionWithTypeArguments"] = 216] = "ExpressionWithTypeArguments";
            SyntaxKind[SyntaxKind["AsExpression"] = 217] = "AsExpression";
            SyntaxKind[SyntaxKind["NonNullExpression"] = 218] = "NonNullExpression";
            SyntaxKind[SyntaxKind["MetaProperty"] = 219] = "MetaProperty";
            SyntaxKind[SyntaxKind["SyntheticExpression"] = 220] = "SyntheticExpression";
            // Misc
            SyntaxKind[SyntaxKind["TemplateSpan"] = 221] = "TemplateSpan";
            SyntaxKind[SyntaxKind["SemicolonClassElement"] = 222] = "SemicolonClassElement";
            // Element
            SyntaxKind[SyntaxKind["Block"] = 223] = "Block";
            SyntaxKind[SyntaxKind["EmptyStatement"] = 224] = "EmptyStatement";
            SyntaxKind[SyntaxKind["VariableStatement"] = 225] = "VariableStatement";
            SyntaxKind[SyntaxKind["ExpressionStatement"] = 226] = "ExpressionStatement";
            SyntaxKind[SyntaxKind["IfStatement"] = 227] = "IfStatement";
            SyntaxKind[SyntaxKind["DoStatement"] = 228] = "DoStatement";
            SyntaxKind[SyntaxKind["WhileStatement"] = 229] = "WhileStatement";
            SyntaxKind[SyntaxKind["ForStatement"] = 230] = "ForStatement";
            SyntaxKind[SyntaxKind["ForInStatement"] = 231] = "ForInStatement";
            SyntaxKind[SyntaxKind["ForOfStatement"] = 232] = "ForOfStatement";
            SyntaxKind[SyntaxKind["ContinueStatement"] = 233] = "ContinueStatement";
            SyntaxKind[SyntaxKind["BreakStatement"] = 234] = "BreakStatement";
            SyntaxKind[SyntaxKind["ReturnStatement"] = 235] = "ReturnStatement";
            SyntaxKind[SyntaxKind["WithStatement"] = 236] = "WithStatement";
            SyntaxKind[SyntaxKind["SwitchStatement"] = 237] = "SwitchStatement";
            SyntaxKind[SyntaxKind["LabeledStatement"] = 238] = "LabeledStatement";
            SyntaxKind[SyntaxKind["ThrowStatement"] = 239] = "ThrowStatement";
            SyntaxKind[SyntaxKind["TryStatement"] = 240] = "TryStatement";
            SyntaxKind[SyntaxKind["DebuggerStatement"] = 241] = "DebuggerStatement";
            SyntaxKind[SyntaxKind["VariableDeclaration"] = 242] = "VariableDeclaration";
            SyntaxKind[SyntaxKind["VariableDeclarationList"] = 243] = "VariableDeclarationList";
            SyntaxKind[SyntaxKind["FunctionDeclaration"] = 244] = "FunctionDeclaration";
            SyntaxKind[SyntaxKind["ClassDeclaration"] = 245] = "ClassDeclaration";
            SyntaxKind[SyntaxKind["InterfaceDeclaration"] = 246] = "InterfaceDeclaration";
            SyntaxKind[SyntaxKind["TypeAliasDeclaration"] = 247] = "TypeAliasDeclaration";
            SyntaxKind[SyntaxKind["EnumDeclaration"] = 248] = "EnumDeclaration";
            SyntaxKind[SyntaxKind["ModuleDeclaration"] = 249] = "ModuleDeclaration";
            SyntaxKind[SyntaxKind["ModuleBlock"] = 250] = "ModuleBlock";
            SyntaxKind[SyntaxKind["CaseBlock"] = 251] = "CaseBlock";
            SyntaxKind[SyntaxKind["NamespaceExportDeclaration"] = 252] = "NamespaceExportDeclaration";
            SyntaxKind[SyntaxKind["ImportEqualsDeclaration"] = 253] = "ImportEqualsDeclaration";
            SyntaxKind[SyntaxKind["ImportDeclaration"] = 254] = "ImportDeclaration";
            SyntaxKind[SyntaxKind["ImportClause"] = 255] = "ImportClause";
            SyntaxKind[SyntaxKind["NamespaceImport"] = 256] = "NamespaceImport";
            SyntaxKind[SyntaxKind["NamedImports"] = 257] = "NamedImports";
            SyntaxKind[SyntaxKind["ImportSpecifier"] = 258] = "ImportSpecifier";
            SyntaxKind[SyntaxKind["ExportAssignment"] = 259] = "ExportAssignment";
            SyntaxKind[SyntaxKind["ExportDeclaration"] = 260] = "ExportDeclaration";
            SyntaxKind[SyntaxKind["NamedExports"] = 261] = "NamedExports";
            SyntaxKind[SyntaxKind["NamespaceExport"] = 262] = "NamespaceExport";
            SyntaxKind[SyntaxKind["ExportSpecifier"] = 263] = "ExportSpecifier";
            SyntaxKind[SyntaxKind["MissingDeclaration"] = 264] = "MissingDeclaration";
            // Module references
            SyntaxKind[SyntaxKind["ExternalModuleReference"] = 265] = "ExternalModuleReference";
            // JSX
            SyntaxKind[SyntaxKind["JsxElement"] = 266] = "JsxElement";
            SyntaxKind[SyntaxKind["JsxSelfClosingElement"] = 267] = "JsxSelfClosingElement";
            SyntaxKind[SyntaxKind["JsxOpeningElement"] = 268] = "JsxOpeningElement";
            SyntaxKind[SyntaxKind["JsxClosingElement"] = 269] = "JsxClosingElement";
            SyntaxKind[SyntaxKind["JsxFragment"] = 270] = "JsxFragment";
            SyntaxKind[SyntaxKind["JsxOpeningFragment"] = 271] = "JsxOpeningFragment";
            SyntaxKind[SyntaxKind["JsxClosingFragment"] = 272] = "JsxClosingFragment";
            SyntaxKind[SyntaxKind["JsxAttribute"] = 273] = "JsxAttribute";
            SyntaxKind[SyntaxKind["JsxAttributes"] = 274] = "JsxAttributes";
            SyntaxKind[SyntaxKind["JsxSpreadAttribute"] = 275] = "JsxSpreadAttribute";
            SyntaxKind[SyntaxKind["JsxExpression"] = 276] = "JsxExpression";
            // Clauses
            SyntaxKind[SyntaxKind["CaseClause"] = 277] = "CaseClause";
            SyntaxKind[SyntaxKind["DefaultClause"] = 278] = "DefaultClause";
            SyntaxKind[SyntaxKind["HeritageClause"] = 279] = "HeritageClause";
            SyntaxKind[SyntaxKind["CatchClause"] = 280] = "CatchClause";
            // Property assignments
            SyntaxKind[SyntaxKind["PropertyAssignment"] = 281] = "PropertyAssignment";
            SyntaxKind[SyntaxKind["ShorthandPropertyAssignment"] = 282] = "ShorthandPropertyAssignment";
            SyntaxKind[SyntaxKind["SpreadAssignment"] = 283] = "SpreadAssignment";
            // Enum
            SyntaxKind[SyntaxKind["EnumMember"] = 284] = "EnumMember";
            // Unparsed
            SyntaxKind[SyntaxKind["UnparsedPrologue"] = 285] = "UnparsedPrologue";
            SyntaxKind[SyntaxKind["UnparsedPrepend"] = 286] = "UnparsedPrepend";
            SyntaxKind[SyntaxKind["UnparsedText"] = 287] = "UnparsedText";
            SyntaxKind[SyntaxKind["UnparsedInternalText"] = 288] = "UnparsedInternalText";
            SyntaxKind[SyntaxKind["UnparsedSyntheticReference"] = 289] = "UnparsedSyntheticReference";
            // Top-level nodes
            SyntaxKind[SyntaxKind["SourceFile"] = 290] = "SourceFile";
            SyntaxKind[SyntaxKind["Bundle"] = 291] = "Bundle";
            SyntaxKind[SyntaxKind["UnparsedSource"] = 292] = "UnparsedSource";
            SyntaxKind[SyntaxKind["InputFiles"] = 293] = "InputFiles";
            // JSDoc nodes
            SyntaxKind[SyntaxKind["JSDocTypeExpression"] = 294] = "JSDocTypeExpression";
            // The * type
            SyntaxKind[SyntaxKind["JSDocAllType"] = 295] = "JSDocAllType";
            // The ? type
            SyntaxKind[SyntaxKind["JSDocUnknownType"] = 296] = "JSDocUnknownType";
            SyntaxKind[SyntaxKind["JSDocNullableType"] = 297] = "JSDocNullableType";
            SyntaxKind[SyntaxKind["JSDocNonNullableType"] = 298] = "JSDocNonNullableType";
            SyntaxKind[SyntaxKind["JSDocOptionalType"] = 299] = "JSDocOptionalType";
            SyntaxKind[SyntaxKind["JSDocFunctionType"] = 300] = "JSDocFunctionType";
            SyntaxKind[SyntaxKind["JSDocVariadicType"] = 301] = "JSDocVariadicType";
            // https://jsdoc.app/about-namepaths.html
            SyntaxKind[SyntaxKind["JSDocNamepathType"] = 302] = "JSDocNamepathType";
            SyntaxKind[SyntaxKind["JSDocComment"] = 303] = "JSDocComment";
            SyntaxKind[SyntaxKind["JSDocTypeLiteral"] = 304] = "JSDocTypeLiteral";
            SyntaxKind[SyntaxKind["JSDocSignature"] = 305] = "JSDocSignature";
            SyntaxKind[SyntaxKind["JSDocTag"] = 306] = "JSDocTag";
            SyntaxKind[SyntaxKind["JSDocAugmentsTag"] = 307] = "JSDocAugmentsTag";
            SyntaxKind[SyntaxKind["JSDocAuthorTag"] = 308] = "JSDocAuthorTag";
            SyntaxKind[SyntaxKind["JSDocClassTag"] = 309] = "JSDocClassTag";
            SyntaxKind[SyntaxKind["JSDocPublicTag"] = 310] = "JSDocPublicTag";
            SyntaxKind[SyntaxKind["JSDocPrivateTag"] = 311] = "JSDocPrivateTag";
            SyntaxKind[SyntaxKind["JSDocProtectedTag"] = 312] = "JSDocProtectedTag";
            SyntaxKind[SyntaxKind["JSDocReadonlyTag"] = 313] = "JSDocReadonlyTag";
            SyntaxKind[SyntaxKind["JSDocCallbackTag"] = 314] = "JSDocCallbackTag";
            SyntaxKind[SyntaxKind["JSDocEnumTag"] = 315] = "JSDocEnumTag";
            SyntaxKind[SyntaxKind["JSDocParameterTag"] = 316] = "JSDocParameterTag";
            SyntaxKind[SyntaxKind["JSDocReturnTag"] = 317] = "JSDocReturnTag";
            SyntaxKind[SyntaxKind["JSDocThisTag"] = 318] = "JSDocThisTag";
            SyntaxKind[SyntaxKind["JSDocTypeTag"] = 319] = "JSDocTypeTag";
            SyntaxKind[SyntaxKind["JSDocTemplateTag"] = 320] = "JSDocTemplateTag";
            SyntaxKind[SyntaxKind["JSDocTypedefTag"] = 321] = "JSDocTypedefTag";
            SyntaxKind[SyntaxKind["JSDocPropertyTag"] = 322] = "JSDocPropertyTag";
            // Synthesized list
            SyntaxKind[SyntaxKind["SyntaxList"] = 323] = "SyntaxList";
            // Transformation nodes
            SyntaxKind[SyntaxKind["NotEmittedStatement"] = 324] = "NotEmittedStatement";
            SyntaxKind[SyntaxKind["PartiallyEmittedExpression"] = 325] = "PartiallyEmittedExpression";
            SyntaxKind[SyntaxKind["CommaListExpression"] = 326] = "CommaListExpression";
            SyntaxKind[SyntaxKind["MergeDeclarationMarker"] = 327] = "MergeDeclarationMarker";
            SyntaxKind[SyntaxKind["EndOfDeclarationMarker"] = 328] = "EndOfDeclarationMarker";
            SyntaxKind[SyntaxKind["SyntheticReferenceExpression"] = 329] = "SyntheticReferenceExpression";
            // Enum value count
            SyntaxKind[SyntaxKind["Count"] = 330] = "Count";
            // Markers
            SyntaxKind[SyntaxKind["FirstAssignment"] = 62] = "FirstAssignment";
            SyntaxKind[SyntaxKind["LastAssignment"] = 74] = "LastAssignment";
            SyntaxKind[SyntaxKind["FirstCompoundAssignment"] = 63] = "FirstCompoundAssignment";
            SyntaxKind[SyntaxKind["LastCompoundAssignment"] = 74] = "LastCompoundAssignment";
            SyntaxKind[SyntaxKind["FirstReservedWord"] = 77] = "FirstReservedWord";
            SyntaxKind[SyntaxKind["LastReservedWord"] = 112] = "LastReservedWord";
            SyntaxKind[SyntaxKind["FirstKeyword"] = 77] = "FirstKeyword";
            SyntaxKind[SyntaxKind["LastKeyword"] = 152] = "LastKeyword";
            SyntaxKind[SyntaxKind["FirstFutureReservedWord"] = 113] = "FirstFutureReservedWord";
            SyntaxKind[SyntaxKind["LastFutureReservedWord"] = 121] = "LastFutureReservedWord";
            SyntaxKind[SyntaxKind["FirstTypeNode"] = 168] = "FirstTypeNode";
            SyntaxKind[SyntaxKind["LastTypeNode"] = 188] = "LastTypeNode";
            SyntaxKind[SyntaxKind["FirstPunctuation"] = 18] = "FirstPunctuation";
            SyntaxKind[SyntaxKind["LastPunctuation"] = 74] = "LastPunctuation";
            SyntaxKind[SyntaxKind["FirstToken"] = 0] = "FirstToken";
            SyntaxKind[SyntaxKind["LastToken"] = 152] = "LastToken";
            SyntaxKind[SyntaxKind["FirstTriviaToken"] = 2] = "FirstTriviaToken";
            SyntaxKind[SyntaxKind["LastTriviaToken"] = 7] = "LastTriviaToken";
            SyntaxKind[SyntaxKind["FirstLiteralToken"] = 8] = "FirstLiteralToken";
            SyntaxKind[SyntaxKind["LastLiteralToken"] = 14] = "LastLiteralToken";
            SyntaxKind[SyntaxKind["FirstTemplateToken"] = 14] = "FirstTemplateToken";
            SyntaxKind[SyntaxKind["LastTemplateToken"] = 17] = "LastTemplateToken";
            SyntaxKind[SyntaxKind["FirstBinaryOperator"] = 29] = "FirstBinaryOperator";
            SyntaxKind[SyntaxKind["LastBinaryOperator"] = 74] = "LastBinaryOperator";
            SyntaxKind[SyntaxKind["FirstStatement"] = 225] = "FirstStatement";
            SyntaxKind[SyntaxKind["LastStatement"] = 241] = "LastStatement";
            SyntaxKind[SyntaxKind["FirstNode"] = 153] = "FirstNode";
            SyntaxKind[SyntaxKind["FirstJSDocNode"] = 294] = "FirstJSDocNode";
            SyntaxKind[SyntaxKind["LastJSDocNode"] = 322] = "LastJSDocNode";
            SyntaxKind[SyntaxKind["FirstJSDocTagNode"] = 306] = "FirstJSDocTagNode";
            SyntaxKind[SyntaxKind["LastJSDocTagNode"] = 322] = "LastJSDocTagNode";
            /* @internal */ SyntaxKind[SyntaxKind["FirstContextualKeyword"] = 122] = "FirstContextualKeyword";
            /* @internal */ SyntaxKind[SyntaxKind["LastContextualKeyword"] = 152] = "LastContextualKeyword";
        })(SyntaxKind = ts.SyntaxKind || (ts.SyntaxKind = {}));
        var NodeFlags;
        (function (NodeFlags) {
            NodeFlags[NodeFlags["None"] = 0] = "None";
            NodeFlags[NodeFlags["Let"] = 1] = "Let";
            NodeFlags[NodeFlags["Const"] = 2] = "Const";
            NodeFlags[NodeFlags["NestedNamespace"] = 4] = "NestedNamespace";
            NodeFlags[NodeFlags["Synthesized"] = 8] = "Synthesized";
            NodeFlags[NodeFlags["Namespace"] = 16] = "Namespace";
            NodeFlags[NodeFlags["OptionalChain"] = 32] = "OptionalChain";
            NodeFlags[NodeFlags["ExportContext"] = 64] = "ExportContext";
            NodeFlags[NodeFlags["ContainsThis"] = 128] = "ContainsThis";
            NodeFlags[NodeFlags["HasImplicitReturn"] = 256] = "HasImplicitReturn";
            NodeFlags[NodeFlags["HasExplicitReturn"] = 512] = "HasExplicitReturn";
            NodeFlags[NodeFlags["GlobalAugmentation"] = 1024] = "GlobalAugmentation";
            NodeFlags[NodeFlags["HasAsyncFunctions"] = 2048] = "HasAsyncFunctions";
            NodeFlags[NodeFlags["DisallowInContext"] = 4096] = "DisallowInContext";
            NodeFlags[NodeFlags["YieldContext"] = 8192] = "YieldContext";
            NodeFlags[NodeFlags["DecoratorContext"] = 16384] = "DecoratorContext";
            NodeFlags[NodeFlags["AwaitContext"] = 32768] = "AwaitContext";
            NodeFlags[NodeFlags["ThisNodeHasError"] = 65536] = "ThisNodeHasError";
            NodeFlags[NodeFlags["JavaScriptFile"] = 131072] = "JavaScriptFile";
            NodeFlags[NodeFlags["ThisNodeOrAnySubNodesHasError"] = 262144] = "ThisNodeOrAnySubNodesHasError";
            NodeFlags[NodeFlags["HasAggregatedChildData"] = 524288] = "HasAggregatedChildData";
            // These flags will be set when the parser encounters a dynamic import expression or 'import.meta' to avoid
            // walking the tree if the flags are not set. However, these flags are just a approximation
            // (hence why it's named "PossiblyContainsDynamicImport") because once set, the flags never get cleared.
            // During editing, if a dynamic import is removed, incremental parsing will *NOT* clear this flag.
            // This means that the tree will always be traversed during module resolution, or when looking for external module indicators.
            // However, the removal operation should not occur often and in the case of the
            // removal, it is likely that users will add the import anyway.
            // The advantage of this approach is its simplicity. For the case of batch compilation,
            // we guarantee that users won't have to pay the price of walking the tree if a dynamic import isn't used.
            /* @internal */ NodeFlags[NodeFlags["PossiblyContainsDynamicImport"] = 1048576] = "PossiblyContainsDynamicImport";
            /* @internal */ NodeFlags[NodeFlags["PossiblyContainsImportMeta"] = 2097152] = "PossiblyContainsImportMeta";
            NodeFlags[NodeFlags["JSDoc"] = 4194304] = "JSDoc";
            /* @internal */ NodeFlags[NodeFlags["Ambient"] = 8388608] = "Ambient";
            /* @internal */ NodeFlags[NodeFlags["InWithStatement"] = 16777216] = "InWithStatement";
            NodeFlags[NodeFlags["JsonFile"] = 33554432] = "JsonFile";
            /* @internal */ NodeFlags[NodeFlags["TypeCached"] = 67108864] = "TypeCached";
            NodeFlags[NodeFlags["BlockScoped"] = 3] = "BlockScoped";
            NodeFlags[NodeFlags["ReachabilityCheckFlags"] = 768] = "ReachabilityCheckFlags";
            NodeFlags[NodeFlags["ReachabilityAndEmitFlags"] = 2816] = "ReachabilityAndEmitFlags";
            // Parsing context flags
            NodeFlags[NodeFlags["ContextFlags"] = 25358336] = "ContextFlags";
            // Exclude these flags when parsing a Type
            NodeFlags[NodeFlags["TypeExcludesFlags"] = 40960] = "TypeExcludesFlags";
            // Represents all flags that are potentially set once and
            // never cleared on SourceFiles which get re-used in between incremental parses.
            // See the comment above on `PossiblyContainsDynamicImport` and `PossiblyContainsImportMeta`.
            /* @internal */ NodeFlags[NodeFlags["PermanentlySetIncrementalFlags"] = 3145728] = "PermanentlySetIncrementalFlags";
        })(NodeFlags = ts.NodeFlags || (ts.NodeFlags = {}));
        var ModifierFlags;
        (function (ModifierFlags) {
            ModifierFlags[ModifierFlags["None"] = 0] = "None";
            ModifierFlags[ModifierFlags["Export"] = 1] = "Export";
            ModifierFlags[ModifierFlags["Ambient"] = 2] = "Ambient";
            ModifierFlags[ModifierFlags["Public"] = 4] = "Public";
            ModifierFlags[ModifierFlags["Private"] = 8] = "Private";
            ModifierFlags[ModifierFlags["Protected"] = 16] = "Protected";
            ModifierFlags[ModifierFlags["Static"] = 32] = "Static";
            ModifierFlags[ModifierFlags["Readonly"] = 64] = "Readonly";
            ModifierFlags[ModifierFlags["Abstract"] = 128] = "Abstract";
            ModifierFlags[ModifierFlags["Async"] = 256] = "Async";
            ModifierFlags[ModifierFlags["Default"] = 512] = "Default";
            ModifierFlags[ModifierFlags["Const"] = 2048] = "Const";
            ModifierFlags[ModifierFlags["HasComputedFlags"] = 536870912] = "HasComputedFlags";
            ModifierFlags[ModifierFlags["AccessibilityModifier"] = 28] = "AccessibilityModifier";
            // Accessibility modifiers and 'readonly' can be attached to a parameter in a constructor to make it a property.
            ModifierFlags[ModifierFlags["ParameterPropertyModifier"] = 92] = "ParameterPropertyModifier";
            ModifierFlags[ModifierFlags["NonPublicAccessibilityModifier"] = 24] = "NonPublicAccessibilityModifier";
            ModifierFlags[ModifierFlags["TypeScriptModifier"] = 2270] = "TypeScriptModifier";
            ModifierFlags[ModifierFlags["ExportDefault"] = 513] = "ExportDefault";
            ModifierFlags[ModifierFlags["All"] = 3071] = "All";
        })(ModifierFlags = ts.ModifierFlags || (ts.ModifierFlags = {}));
        var JsxFlags;
        (function (JsxFlags) {
            JsxFlags[JsxFlags["None"] = 0] = "None";
            /** An element from a named property of the JSX.IntrinsicElements interface */
            JsxFlags[JsxFlags["IntrinsicNamedElement"] = 1] = "IntrinsicNamedElement";
            /** An element inferred from the string index signature of the JSX.IntrinsicElements interface */
            JsxFlags[JsxFlags["IntrinsicIndexedElement"] = 2] = "IntrinsicIndexedElement";
            JsxFlags[JsxFlags["IntrinsicElement"] = 3] = "IntrinsicElement";
        })(JsxFlags = ts.JsxFlags || (ts.JsxFlags = {}));
        /* @internal */
        var RelationComparisonResult;
        (function (RelationComparisonResult) {
            RelationComparisonResult[RelationComparisonResult["Succeeded"] = 1] = "Succeeded";
            RelationComparisonResult[RelationComparisonResult["Failed"] = 2] = "Failed";
            RelationComparisonResult[RelationComparisonResult["Reported"] = 4] = "Reported";
            RelationComparisonResult[RelationComparisonResult["ReportsUnmeasurable"] = 8] = "ReportsUnmeasurable";
            RelationComparisonResult[RelationComparisonResult["ReportsUnreliable"] = 16] = "ReportsUnreliable";
            RelationComparisonResult[RelationComparisonResult["ReportsMask"] = 24] = "ReportsMask";
        })(RelationComparisonResult = ts.RelationComparisonResult || (ts.RelationComparisonResult = {}));
        /*@internal*/
        var GeneratedIdentifierFlags;
        (function (GeneratedIdentifierFlags) {
            // Kinds
            GeneratedIdentifierFlags[GeneratedIdentifierFlags["None"] = 0] = "None";
            GeneratedIdentifierFlags[GeneratedIdentifierFlags["Auto"] = 1] = "Auto";
            GeneratedIdentifierFlags[GeneratedIdentifierFlags["Loop"] = 2] = "Loop";
            GeneratedIdentifierFlags[GeneratedIdentifierFlags["Unique"] = 3] = "Unique";
            GeneratedIdentifierFlags[GeneratedIdentifierFlags["Node"] = 4] = "Node";
            GeneratedIdentifierFlags[GeneratedIdentifierFlags["KindMask"] = 7] = "KindMask";
            // Flags
            GeneratedIdentifierFlags[GeneratedIdentifierFlags["ReservedInNestedScopes"] = 8] = "ReservedInNestedScopes";
            GeneratedIdentifierFlags[GeneratedIdentifierFlags["Optimistic"] = 16] = "Optimistic";
            GeneratedIdentifierFlags[GeneratedIdentifierFlags["FileLevel"] = 32] = "FileLevel";
        })(GeneratedIdentifierFlags = ts.GeneratedIdentifierFlags || (ts.GeneratedIdentifierFlags = {}));
        var TokenFlags;
        (function (TokenFlags) {
            TokenFlags[TokenFlags["None"] = 0] = "None";
            /* @internal */
            TokenFlags[TokenFlags["PrecedingLineBreak"] = 1] = "PrecedingLineBreak";
            /* @internal */
            TokenFlags[TokenFlags["PrecedingJSDocComment"] = 2] = "PrecedingJSDocComment";
            /* @internal */
            TokenFlags[TokenFlags["Unterminated"] = 4] = "Unterminated";
            /* @internal */
            TokenFlags[TokenFlags["ExtendedUnicodeEscape"] = 8] = "ExtendedUnicodeEscape";
            TokenFlags[TokenFlags["Scientific"] = 16] = "Scientific";
            TokenFlags[TokenFlags["Octal"] = 32] = "Octal";
            TokenFlags[TokenFlags["HexSpecifier"] = 64] = "HexSpecifier";
            TokenFlags[TokenFlags["BinarySpecifier"] = 128] = "BinarySpecifier";
            TokenFlags[TokenFlags["OctalSpecifier"] = 256] = "OctalSpecifier";
            /* @internal */
            TokenFlags[TokenFlags["ContainsSeparator"] = 512] = "ContainsSeparator";
            /* @internal */
            TokenFlags[TokenFlags["UnicodeEscape"] = 1024] = "UnicodeEscape";
            /* @internal */
            TokenFlags[TokenFlags["BinaryOrOctalSpecifier"] = 384] = "BinaryOrOctalSpecifier";
            /* @internal */
            TokenFlags[TokenFlags["NumericLiteralFlags"] = 1008] = "NumericLiteralFlags";
        })(TokenFlags = ts.TokenFlags || (ts.TokenFlags = {}));
        // NOTE: Ensure this is up-to-date with src/debug/debug.ts
        var FlowFlags;
        (function (FlowFlags) {
            FlowFlags[FlowFlags["Unreachable"] = 1] = "Unreachable";
            FlowFlags[FlowFlags["Start"] = 2] = "Start";
            FlowFlags[FlowFlags["BranchLabel"] = 4] = "BranchLabel";
            FlowFlags[FlowFlags["LoopLabel"] = 8] = "LoopLabel";
            FlowFlags[FlowFlags["Assignment"] = 16] = "Assignment";
            FlowFlags[FlowFlags["TrueCondition"] = 32] = "TrueCondition";
            FlowFlags[FlowFlags["FalseCondition"] = 64] = "FalseCondition";
            FlowFlags[FlowFlags["SwitchClause"] = 128] = "SwitchClause";
            FlowFlags[FlowFlags["ArrayMutation"] = 256] = "ArrayMutation";
            FlowFlags[FlowFlags["Call"] = 512] = "Call";
            FlowFlags[FlowFlags["Referenced"] = 1024] = "Referenced";
            FlowFlags[FlowFlags["Shared"] = 2048] = "Shared";
            FlowFlags[FlowFlags["PreFinally"] = 4096] = "PreFinally";
            FlowFlags[FlowFlags["AfterFinally"] = 8192] = "AfterFinally";
            FlowFlags[FlowFlags["Label"] = 12] = "Label";
            FlowFlags[FlowFlags["Condition"] = 96] = "Condition";
        })(FlowFlags = ts.FlowFlags || (ts.FlowFlags = {}));
        var OperationCanceledException = /** @class */ (function () {
            function OperationCanceledException() {
            }
            return OperationCanceledException;
        }());
        ts.OperationCanceledException = OperationCanceledException;
        /*@internal*/
        var RefFileKind;
        (function (RefFileKind) {
            RefFileKind[RefFileKind["Import"] = 0] = "Import";
            RefFileKind[RefFileKind["ReferenceFile"] = 1] = "ReferenceFile";
            RefFileKind[RefFileKind["TypeReferenceDirective"] = 2] = "TypeReferenceDirective";
        })(RefFileKind = ts.RefFileKind || (ts.RefFileKind = {}));
        /* @internal */
        var StructureIsReused;
        (function (StructureIsReused) {
            StructureIsReused[StructureIsReused["Not"] = 0] = "Not";
            StructureIsReused[StructureIsReused["SafeModules"] = 1] = "SafeModules";
            StructureIsReused[StructureIsReused["Completely"] = 2] = "Completely";
        })(StructureIsReused = ts.StructureIsReused || (ts.StructureIsReused = {}));
        /** Return code used by getEmitOutput function to indicate status of the function */
        var ExitStatus;
        (function (ExitStatus) {
            // Compiler ran successfully.  Either this was a simple do-nothing compilation (for example,
            // when -version or -help was provided, or this was a normal compilation, no diagnostics
            // were produced, and all outputs were generated successfully.
            ExitStatus[ExitStatus["Success"] = 0] = "Success";
            // Diagnostics were produced and because of them no code was generated.
            ExitStatus[ExitStatus["DiagnosticsPresent_OutputsSkipped"] = 1] = "DiagnosticsPresent_OutputsSkipped";
            // Diagnostics were produced and outputs were generated in spite of them.
            ExitStatus[ExitStatus["DiagnosticsPresent_OutputsGenerated"] = 2] = "DiagnosticsPresent_OutputsGenerated";
            // When build skipped because passed in project is invalid
            ExitStatus[ExitStatus["InvalidProject_OutputsSkipped"] = 3] = "InvalidProject_OutputsSkipped";
            // When build is skipped because project references form cycle
            ExitStatus[ExitStatus["ProjectReferenceCycle_OutputsSkipped"] = 4] = "ProjectReferenceCycle_OutputsSkipped";
            /** @deprecated Use ProjectReferenceCycle_OutputsSkipped instead. */
            ExitStatus[ExitStatus["ProjectReferenceCycle_OutputsSkupped"] = 4] = "ProjectReferenceCycle_OutputsSkupped";
        })(ExitStatus = ts.ExitStatus || (ts.ExitStatus = {}));
        /* @internal */
        var UnionReduction;
        (function (UnionReduction) {
            UnionReduction[UnionReduction["None"] = 0] = "None";
            UnionReduction[UnionReduction["Literal"] = 1] = "Literal";
            UnionReduction[UnionReduction["Subtype"] = 2] = "Subtype";
        })(UnionReduction = ts.UnionReduction || (ts.UnionReduction = {}));
        /* @internal */
        var ContextFlags;
        (function (ContextFlags) {
            ContextFlags[ContextFlags["None"] = 0] = "None";
            ContextFlags[ContextFlags["Signature"] = 1] = "Signature";
            ContextFlags[ContextFlags["NoConstraints"] = 2] = "NoConstraints";
            ContextFlags[ContextFlags["Completions"] = 4] = "Completions";
        })(ContextFlags = ts.ContextFlags || (ts.ContextFlags = {}));
        // NOTE: If modifying this enum, must modify `TypeFormatFlags` too!
        var NodeBuilderFlags;
        (function (NodeBuilderFlags) {
            NodeBuilderFlags[NodeBuilderFlags["None"] = 0] = "None";
            // Options
            NodeBuilderFlags[NodeBuilderFlags["NoTruncation"] = 1] = "NoTruncation";
            NodeBuilderFlags[NodeBuilderFlags["WriteArrayAsGenericType"] = 2] = "WriteArrayAsGenericType";
            NodeBuilderFlags[NodeBuilderFlags["GenerateNamesForShadowedTypeParams"] = 4] = "GenerateNamesForShadowedTypeParams";
            NodeBuilderFlags[NodeBuilderFlags["UseStructuralFallback"] = 8] = "UseStructuralFallback";
            NodeBuilderFlags[NodeBuilderFlags["ForbidIndexedAccessSymbolReferences"] = 16] = "ForbidIndexedAccessSymbolReferences";
            NodeBuilderFlags[NodeBuilderFlags["WriteTypeArgumentsOfSignature"] = 32] = "WriteTypeArgumentsOfSignature";
            NodeBuilderFlags[NodeBuilderFlags["UseFullyQualifiedType"] = 64] = "UseFullyQualifiedType";
            NodeBuilderFlags[NodeBuilderFlags["UseOnlyExternalAliasing"] = 128] = "UseOnlyExternalAliasing";
            NodeBuilderFlags[NodeBuilderFlags["SuppressAnyReturnType"] = 256] = "SuppressAnyReturnType";
            NodeBuilderFlags[NodeBuilderFlags["WriteTypeParametersInQualifiedName"] = 512] = "WriteTypeParametersInQualifiedName";
            NodeBuilderFlags[NodeBuilderFlags["MultilineObjectLiterals"] = 1024] = "MultilineObjectLiterals";
            NodeBuilderFlags[NodeBuilderFlags["WriteClassExpressionAsTypeLiteral"] = 2048] = "WriteClassExpressionAsTypeLiteral";
            NodeBuilderFlags[NodeBuilderFlags["UseTypeOfFunction"] = 4096] = "UseTypeOfFunction";
            NodeBuilderFlags[NodeBuilderFlags["OmitParameterModifiers"] = 8192] = "OmitParameterModifiers";
            NodeBuilderFlags[NodeBuilderFlags["UseAliasDefinedOutsideCurrentScope"] = 16384] = "UseAliasDefinedOutsideCurrentScope";
            NodeBuilderFlags[NodeBuilderFlags["UseSingleQuotesForStringLiteralType"] = 268435456] = "UseSingleQuotesForStringLiteralType";
            // Error handling
            NodeBuilderFlags[NodeBuilderFlags["AllowThisInObjectLiteral"] = 32768] = "AllowThisInObjectLiteral";
            NodeBuilderFlags[NodeBuilderFlags["AllowQualifedNameInPlaceOfIdentifier"] = 65536] = "AllowQualifedNameInPlaceOfIdentifier";
            NodeBuilderFlags[NodeBuilderFlags["AllowAnonymousIdentifier"] = 131072] = "AllowAnonymousIdentifier";
            NodeBuilderFlags[NodeBuilderFlags["AllowEmptyUnionOrIntersection"] = 262144] = "AllowEmptyUnionOrIntersection";
            NodeBuilderFlags[NodeBuilderFlags["AllowEmptyTuple"] = 524288] = "AllowEmptyTuple";
            NodeBuilderFlags[NodeBuilderFlags["AllowUniqueESSymbolType"] = 1048576] = "AllowUniqueESSymbolType";
            NodeBuilderFlags[NodeBuilderFlags["AllowEmptyIndexInfoType"] = 2097152] = "AllowEmptyIndexInfoType";
            // Errors (cont.)
            NodeBuilderFlags[NodeBuilderFlags["AllowNodeModulesRelativePaths"] = 67108864] = "AllowNodeModulesRelativePaths";
            /* @internal */ NodeBuilderFlags[NodeBuilderFlags["DoNotIncludeSymbolChain"] = 134217728] = "DoNotIncludeSymbolChain";
            NodeBuilderFlags[NodeBuilderFlags["IgnoreErrors"] = 70221824] = "IgnoreErrors";
            // State
            NodeBuilderFlags[NodeBuilderFlags["InObjectTypeLiteral"] = 4194304] = "InObjectTypeLiteral";
            NodeBuilderFlags[NodeBuilderFlags["InTypeAlias"] = 8388608] = "InTypeAlias";
            NodeBuilderFlags[NodeBuilderFlags["InInitialEntityName"] = 16777216] = "InInitialEntityName";
            NodeBuilderFlags[NodeBuilderFlags["InReverseMappedType"] = 33554432] = "InReverseMappedType";
        })(NodeBuilderFlags = ts.NodeBuilderFlags || (ts.NodeBuilderFlags = {}));
        // Ensure the shared flags between this and `NodeBuilderFlags` stay in alignment
        var TypeFormatFlags;
        (function (TypeFormatFlags) {
            TypeFormatFlags[TypeFormatFlags["None"] = 0] = "None";
            TypeFormatFlags[TypeFormatFlags["NoTruncation"] = 1] = "NoTruncation";
            TypeFormatFlags[TypeFormatFlags["WriteArrayAsGenericType"] = 2] = "WriteArrayAsGenericType";
            // hole because there's a hole in node builder flags
            TypeFormatFlags[TypeFormatFlags["UseStructuralFallback"] = 8] = "UseStructuralFallback";
            // hole because there's a hole in node builder flags
            TypeFormatFlags[TypeFormatFlags["WriteTypeArgumentsOfSignature"] = 32] = "WriteTypeArgumentsOfSignature";
            TypeFormatFlags[TypeFormatFlags["UseFullyQualifiedType"] = 64] = "UseFullyQualifiedType";
            // hole because `UseOnlyExternalAliasing` is here in node builder flags, but functions which take old flags use `SymbolFormatFlags` instead
            TypeFormatFlags[TypeFormatFlags["SuppressAnyReturnType"] = 256] = "SuppressAnyReturnType";
            // hole because `WriteTypeParametersInQualifiedName` is here in node builder flags, but functions which take old flags use `SymbolFormatFlags` for this instead
            TypeFormatFlags[TypeFormatFlags["MultilineObjectLiterals"] = 1024] = "MultilineObjectLiterals";
            TypeFormatFlags[TypeFormatFlags["WriteClassExpressionAsTypeLiteral"] = 2048] = "WriteClassExpressionAsTypeLiteral";
            TypeFormatFlags[TypeFormatFlags["UseTypeOfFunction"] = 4096] = "UseTypeOfFunction";
            TypeFormatFlags[TypeFormatFlags["OmitParameterModifiers"] = 8192] = "OmitParameterModifiers";
            TypeFormatFlags[TypeFormatFlags["UseAliasDefinedOutsideCurrentScope"] = 16384] = "UseAliasDefinedOutsideCurrentScope";
            TypeFormatFlags[TypeFormatFlags["UseSingleQuotesForStringLiteralType"] = 268435456] = "UseSingleQuotesForStringLiteralType";
            // Error Handling
            TypeFormatFlags[TypeFormatFlags["AllowUniqueESSymbolType"] = 1048576] = "AllowUniqueESSymbolType";
            // TypeFormatFlags exclusive
            TypeFormatFlags[TypeFormatFlags["AddUndefined"] = 131072] = "AddUndefined";
            TypeFormatFlags[TypeFormatFlags["WriteArrowStyleSignature"] = 262144] = "WriteArrowStyleSignature";
            // State
            TypeFormatFlags[TypeFormatFlags["InArrayType"] = 524288] = "InArrayType";
            TypeFormatFlags[TypeFormatFlags["InElementType"] = 2097152] = "InElementType";
            TypeFormatFlags[TypeFormatFlags["InFirstTypeArgument"] = 4194304] = "InFirstTypeArgument";
            TypeFormatFlags[TypeFormatFlags["InTypeAlias"] = 8388608] = "InTypeAlias";
            /** @deprecated */ TypeFormatFlags[TypeFormatFlags["WriteOwnNameForAnyLike"] = 0] = "WriteOwnNameForAnyLike";
            TypeFormatFlags[TypeFormatFlags["NodeBuilderFlagsMask"] = 277904747] = "NodeBuilderFlagsMask";
        })(TypeFormatFlags = ts.TypeFormatFlags || (ts.TypeFormatFlags = {}));
        var SymbolFormatFlags;
        (function (SymbolFormatFlags) {
            SymbolFormatFlags[SymbolFormatFlags["None"] = 0] = "None";
            // Write symbols's type argument if it is instantiated symbol
            // eg. class C<T> { p: T }   <-- Show p as C<T>.p here
            //     var a: C<number>;
            //     var p = a.p; <--- Here p is property of C<number> so show it as C<number>.p instead of just C.p
            SymbolFormatFlags[SymbolFormatFlags["WriteTypeParametersOrArguments"] = 1] = "WriteTypeParametersOrArguments";
            // Use only external alias information to get the symbol name in the given context
            // eg.  module m { export class c { } } import x = m.c;
            // When this flag is specified m.c will be used to refer to the class instead of alias symbol x
            SymbolFormatFlags[SymbolFormatFlags["UseOnlyExternalAliasing"] = 2] = "UseOnlyExternalAliasing";
            // Build symbol name using any nodes needed, instead of just components of an entity name
            SymbolFormatFlags[SymbolFormatFlags["AllowAnyNodeKind"] = 4] = "AllowAnyNodeKind";
            // Prefer aliases which are not directly visible
            SymbolFormatFlags[SymbolFormatFlags["UseAliasDefinedOutsideCurrentScope"] = 8] = "UseAliasDefinedOutsideCurrentScope";
            // Skip building an accessible symbol chain
            /* @internal */ SymbolFormatFlags[SymbolFormatFlags["DoNotIncludeSymbolChain"] = 16] = "DoNotIncludeSymbolChain";
        })(SymbolFormatFlags = ts.SymbolFormatFlags || (ts.SymbolFormatFlags = {}));
        /* @internal */
        var SymbolAccessibility;
        (function (SymbolAccessibility) {
            SymbolAccessibility[SymbolAccessibility["Accessible"] = 0] = "Accessible";
            SymbolAccessibility[SymbolAccessibility["NotAccessible"] = 1] = "NotAccessible";
            SymbolAccessibility[SymbolAccessibility["CannotBeNamed"] = 2] = "CannotBeNamed";
        })(SymbolAccessibility = ts.SymbolAccessibility || (ts.SymbolAccessibility = {}));
        /* @internal */
        var SyntheticSymbolKind;
        (function (SyntheticSymbolKind) {
            SyntheticSymbolKind[SyntheticSymbolKind["UnionOrIntersection"] = 0] = "UnionOrIntersection";
            SyntheticSymbolKind[SyntheticSymbolKind["Spread"] = 1] = "Spread";
        })(SyntheticSymbolKind = ts.SyntheticSymbolKind || (ts.SyntheticSymbolKind = {}));
        var TypePredicateKind;
        (function (TypePredicateKind) {
            TypePredicateKind[TypePredicateKind["This"] = 0] = "This";
            TypePredicateKind[TypePredicateKind["Identifier"] = 1] = "Identifier";
            TypePredicateKind[TypePredicateKind["AssertsThis"] = 2] = "AssertsThis";
            TypePredicateKind[TypePredicateKind["AssertsIdentifier"] = 3] = "AssertsIdentifier";
        })(TypePredicateKind = ts.TypePredicateKind || (ts.TypePredicateKind = {}));
        /** Indicates how to serialize the name for a TypeReferenceNode when emitting decorator metadata */
        /* @internal */
        var TypeReferenceSerializationKind;
        (function (TypeReferenceSerializationKind) {
            // The TypeReferenceNode could not be resolved.
            // The type name should be emitted using a safe fallback.
            TypeReferenceSerializationKind[TypeReferenceSerializationKind["Unknown"] = 0] = "Unknown";
            // The TypeReferenceNode resolves to a type with a constructor
            // function that can be reached at runtime (e.g. a `class`
            // declaration or a `var` declaration for the static side
            // of a type, such as the global `Promise` type in lib.d.ts).
            TypeReferenceSerializationKind[TypeReferenceSerializationKind["TypeWithConstructSignatureAndValue"] = 1] = "TypeWithConstructSignatureAndValue";
            // The TypeReferenceNode resolves to a Void-like, Nullable, or Never type.
            TypeReferenceSerializationKind[TypeReferenceSerializationKind["VoidNullableOrNeverType"] = 2] = "VoidNullableOrNeverType";
            // The TypeReferenceNode resolves to a Number-like type.
            TypeReferenceSerializationKind[TypeReferenceSerializationKind["NumberLikeType"] = 3] = "NumberLikeType";
            // The TypeReferenceNode resolves to a BigInt-like type.
            TypeReferenceSerializationKind[TypeReferenceSerializationKind["BigIntLikeType"] = 4] = "BigIntLikeType";
            // The TypeReferenceNode resolves to a String-like type.
            TypeReferenceSerializationKind[TypeReferenceSerializationKind["StringLikeType"] = 5] = "StringLikeType";
            // The TypeReferenceNode resolves to a Boolean-like type.
            TypeReferenceSerializationKind[TypeReferenceSerializationKind["BooleanType"] = 6] = "BooleanType";
            // The TypeReferenceNode resolves to an Array-like type.
            TypeReferenceSerializationKind[TypeReferenceSerializationKind["ArrayLikeType"] = 7] = "ArrayLikeType";
            // The TypeReferenceNode resolves to the ESSymbol type.
            TypeReferenceSerializationKind[TypeReferenceSerializationKind["ESSymbolType"] = 8] = "ESSymbolType";
            // The TypeReferenceNode resolved to the global Promise constructor symbol.
            TypeReferenceSerializationKind[TypeReferenceSerializationKind["Promise"] = 9] = "Promise";
            // The TypeReferenceNode resolves to a Function type or a type with call signatures.
            TypeReferenceSerializationKind[TypeReferenceSerializationKind["TypeWithCallSignature"] = 10] = "TypeWithCallSignature";
            // The TypeReferenceNode resolves to any other type.
            TypeReferenceSerializationKind[TypeReferenceSerializationKind["ObjectType"] = 11] = "ObjectType";
        })(TypeReferenceSerializationKind = ts.TypeReferenceSerializationKind || (ts.TypeReferenceSerializationKind = {}));
        var SymbolFlags;
        (function (SymbolFlags) {
            SymbolFlags[SymbolFlags["None"] = 0] = "None";
            SymbolFlags[SymbolFlags["FunctionScopedVariable"] = 1] = "FunctionScopedVariable";
            SymbolFlags[SymbolFlags["BlockScopedVariable"] = 2] = "BlockScopedVariable";
            SymbolFlags[SymbolFlags["Property"] = 4] = "Property";
            SymbolFlags[SymbolFlags["EnumMember"] = 8] = "EnumMember";
            SymbolFlags[SymbolFlags["Function"] = 16] = "Function";
            SymbolFlags[SymbolFlags["Class"] = 32] = "Class";
            SymbolFlags[SymbolFlags["Interface"] = 64] = "Interface";
            SymbolFlags[SymbolFlags["ConstEnum"] = 128] = "ConstEnum";
            SymbolFlags[SymbolFlags["RegularEnum"] = 256] = "RegularEnum";
            SymbolFlags[SymbolFlags["ValueModule"] = 512] = "ValueModule";
            SymbolFlags[SymbolFlags["NamespaceModule"] = 1024] = "NamespaceModule";
            SymbolFlags[SymbolFlags["TypeLiteral"] = 2048] = "TypeLiteral";
            SymbolFlags[SymbolFlags["ObjectLiteral"] = 4096] = "ObjectLiteral";
            SymbolFlags[SymbolFlags["Method"] = 8192] = "Method";
            SymbolFlags[SymbolFlags["Constructor"] = 16384] = "Constructor";
            SymbolFlags[SymbolFlags["GetAccessor"] = 32768] = "GetAccessor";
            SymbolFlags[SymbolFlags["SetAccessor"] = 65536] = "SetAccessor";
            SymbolFlags[SymbolFlags["Signature"] = 131072] = "Signature";
            SymbolFlags[SymbolFlags["TypeParameter"] = 262144] = "TypeParameter";
            SymbolFlags[SymbolFlags["TypeAlias"] = 524288] = "TypeAlias";
            SymbolFlags[SymbolFlags["ExportValue"] = 1048576] = "ExportValue";
            SymbolFlags[SymbolFlags["Alias"] = 2097152] = "Alias";
            SymbolFlags[SymbolFlags["Prototype"] = 4194304] = "Prototype";
            SymbolFlags[SymbolFlags["ExportStar"] = 8388608] = "ExportStar";
            SymbolFlags[SymbolFlags["Optional"] = 16777216] = "Optional";
            SymbolFlags[SymbolFlags["Transient"] = 33554432] = "Transient";
            SymbolFlags[SymbolFlags["Assignment"] = 67108864] = "Assignment";
            SymbolFlags[SymbolFlags["ModuleExports"] = 134217728] = "ModuleExports";
            /* @internal */
            SymbolFlags[SymbolFlags["All"] = 67108863] = "All";
            SymbolFlags[SymbolFlags["Enum"] = 384] = "Enum";
            SymbolFlags[SymbolFlags["Variable"] = 3] = "Variable";
            SymbolFlags[SymbolFlags["Value"] = 111551] = "Value";
            SymbolFlags[SymbolFlags["Type"] = 788968] = "Type";
            SymbolFlags[SymbolFlags["Namespace"] = 1920] = "Namespace";
            SymbolFlags[SymbolFlags["Module"] = 1536] = "Module";
            SymbolFlags[SymbolFlags["Accessor"] = 98304] = "Accessor";
            // Variables can be redeclared, but can not redeclare a block-scoped declaration with the
            // same name, or any other value that is not a variable, e.g. ValueModule or Class
            SymbolFlags[SymbolFlags["FunctionScopedVariableExcludes"] = 111550] = "FunctionScopedVariableExcludes";
            // Block-scoped declarations are not allowed to be re-declared
            // they can not merge with anything in the value space
            SymbolFlags[SymbolFlags["BlockScopedVariableExcludes"] = 111551] = "BlockScopedVariableExcludes";
            SymbolFlags[SymbolFlags["ParameterExcludes"] = 111551] = "ParameterExcludes";
            SymbolFlags[SymbolFlags["PropertyExcludes"] = 0] = "PropertyExcludes";
            SymbolFlags[SymbolFlags["EnumMemberExcludes"] = 900095] = "EnumMemberExcludes";
            SymbolFlags[SymbolFlags["FunctionExcludes"] = 110991] = "FunctionExcludes";
            SymbolFlags[SymbolFlags["ClassExcludes"] = 899503] = "ClassExcludes";
            SymbolFlags[SymbolFlags["InterfaceExcludes"] = 788872] = "InterfaceExcludes";
            SymbolFlags[SymbolFlags["RegularEnumExcludes"] = 899327] = "RegularEnumExcludes";
            SymbolFlags[SymbolFlags["ConstEnumExcludes"] = 899967] = "ConstEnumExcludes";
            SymbolFlags[SymbolFlags["ValueModuleExcludes"] = 110735] = "ValueModuleExcludes";
            SymbolFlags[SymbolFlags["NamespaceModuleExcludes"] = 0] = "NamespaceModuleExcludes";
            SymbolFlags[SymbolFlags["MethodExcludes"] = 103359] = "MethodExcludes";
            SymbolFlags[SymbolFlags["GetAccessorExcludes"] = 46015] = "GetAccessorExcludes";
            SymbolFlags[SymbolFlags["SetAccessorExcludes"] = 78783] = "SetAccessorExcludes";
            SymbolFlags[SymbolFlags["TypeParameterExcludes"] = 526824] = "TypeParameterExcludes";
            SymbolFlags[SymbolFlags["TypeAliasExcludes"] = 788968] = "TypeAliasExcludes";
            SymbolFlags[SymbolFlags["AliasExcludes"] = 2097152] = "AliasExcludes";
            SymbolFlags[SymbolFlags["ModuleMember"] = 2623475] = "ModuleMember";
            SymbolFlags[SymbolFlags["ExportHasLocal"] = 944] = "ExportHasLocal";
            SymbolFlags[SymbolFlags["BlockScoped"] = 418] = "BlockScoped";
            SymbolFlags[SymbolFlags["PropertyOrAccessor"] = 98308] = "PropertyOrAccessor";
            SymbolFlags[SymbolFlags["ClassMember"] = 106500] = "ClassMember";
            /* @internal */
            SymbolFlags[SymbolFlags["ExportSupportsDefaultModifier"] = 112] = "ExportSupportsDefaultModifier";
            /* @internal */
            SymbolFlags[SymbolFlags["ExportDoesNotSupportDefaultModifier"] = -113] = "ExportDoesNotSupportDefaultModifier";
            /* @internal */
            // The set of things we consider semantically classifiable.  Used to speed up the LS during
            // classification.
            SymbolFlags[SymbolFlags["Classifiable"] = 2885600] = "Classifiable";
            /* @internal */
            SymbolFlags[SymbolFlags["LateBindingContainer"] = 6256] = "LateBindingContainer";
        })(SymbolFlags = ts.SymbolFlags || (ts.SymbolFlags = {}));
        /* @internal */
        var EnumKind;
        (function (EnumKind) {
            EnumKind[EnumKind["Numeric"] = 0] = "Numeric";
            EnumKind[EnumKind["Literal"] = 1] = "Literal"; // Literal enum (each member has a TypeFlags.EnumLiteral type)
        })(EnumKind = ts.EnumKind || (ts.EnumKind = {}));
        /* @internal */
        var CheckFlags;
        (function (CheckFlags) {
            CheckFlags[CheckFlags["Instantiated"] = 1] = "Instantiated";
            CheckFlags[CheckFlags["SyntheticProperty"] = 2] = "SyntheticProperty";
            CheckFlags[CheckFlags["SyntheticMethod"] = 4] = "SyntheticMethod";
            CheckFlags[CheckFlags["Readonly"] = 8] = "Readonly";
            CheckFlags[CheckFlags["ReadPartial"] = 16] = "ReadPartial";
            CheckFlags[CheckFlags["WritePartial"] = 32] = "WritePartial";
            CheckFlags[CheckFlags["HasNonUniformType"] = 64] = "HasNonUniformType";
            CheckFlags[CheckFlags["HasLiteralType"] = 128] = "HasLiteralType";
            CheckFlags[CheckFlags["ContainsPublic"] = 256] = "ContainsPublic";
            CheckFlags[CheckFlags["ContainsProtected"] = 512] = "ContainsProtected";
            CheckFlags[CheckFlags["ContainsPrivate"] = 1024] = "ContainsPrivate";
            CheckFlags[CheckFlags["ContainsStatic"] = 2048] = "ContainsStatic";
            CheckFlags[CheckFlags["Late"] = 4096] = "Late";
            CheckFlags[CheckFlags["ReverseMapped"] = 8192] = "ReverseMapped";
            CheckFlags[CheckFlags["OptionalParameter"] = 16384] = "OptionalParameter";
            CheckFlags[CheckFlags["RestParameter"] = 32768] = "RestParameter";
            CheckFlags[CheckFlags["DeferredType"] = 65536] = "DeferredType";
            CheckFlags[CheckFlags["Synthetic"] = 6] = "Synthetic";
            CheckFlags[CheckFlags["Discriminant"] = 192] = "Discriminant";
            CheckFlags[CheckFlags["Partial"] = 48] = "Partial";
        })(CheckFlags = ts.CheckFlags || (ts.CheckFlags = {}));
        var InternalSymbolName;
        (function (InternalSymbolName) {
            InternalSymbolName["Call"] = "__call";
            InternalSymbolName["Constructor"] = "__constructor";
            InternalSymbolName["New"] = "__new";
            InternalSymbolName["Index"] = "__index";
            InternalSymbolName["ExportStar"] = "__export";
            InternalSymbolName["Global"] = "__global";
            InternalSymbolName["Missing"] = "__missing";
            InternalSymbolName["Type"] = "__type";
            InternalSymbolName["Object"] = "__object";
            InternalSymbolName["JSXAttributes"] = "__jsxAttributes";
            InternalSymbolName["Class"] = "__class";
            InternalSymbolName["Function"] = "__function";
            InternalSymbolName["Computed"] = "__computed";
            InternalSymbolName["Resolving"] = "__resolving__";
            InternalSymbolName["ExportEquals"] = "export=";
            InternalSymbolName["Default"] = "default";
            InternalSymbolName["This"] = "this";
        })(InternalSymbolName = ts.InternalSymbolName || (ts.InternalSymbolName = {}));
        /* @internal */
        var NodeCheckFlags;
        (function (NodeCheckFlags) {
            NodeCheckFlags[NodeCheckFlags["TypeChecked"] = 1] = "TypeChecked";
            NodeCheckFlags[NodeCheckFlags["LexicalThis"] = 2] = "LexicalThis";
            NodeCheckFlags[NodeCheckFlags["CaptureThis"] = 4] = "CaptureThis";
            NodeCheckFlags[NodeCheckFlags["CaptureNewTarget"] = 8] = "CaptureNewTarget";
            NodeCheckFlags[NodeCheckFlags["SuperInstance"] = 256] = "SuperInstance";
            NodeCheckFlags[NodeCheckFlags["SuperStatic"] = 512] = "SuperStatic";
            NodeCheckFlags[NodeCheckFlags["ContextChecked"] = 1024] = "ContextChecked";
            NodeCheckFlags[NodeCheckFlags["AsyncMethodWithSuper"] = 2048] = "AsyncMethodWithSuper";
            NodeCheckFlags[NodeCheckFlags["AsyncMethodWithSuperBinding"] = 4096] = "AsyncMethodWithSuperBinding";
            NodeCheckFlags[NodeCheckFlags["CaptureArguments"] = 8192] = "CaptureArguments";
            NodeCheckFlags[NodeCheckFlags["EnumValuesComputed"] = 16384] = "EnumValuesComputed";
            NodeCheckFlags[NodeCheckFlags["LexicalModuleMergesWithClass"] = 32768] = "LexicalModuleMergesWithClass";
            NodeCheckFlags[NodeCheckFlags["LoopWithCapturedBlockScopedBinding"] = 65536] = "LoopWithCapturedBlockScopedBinding";
            NodeCheckFlags[NodeCheckFlags["ContainsCapturedBlockScopeBinding"] = 131072] = "ContainsCapturedBlockScopeBinding";
            NodeCheckFlags[NodeCheckFlags["CapturedBlockScopedBinding"] = 262144] = "CapturedBlockScopedBinding";
            NodeCheckFlags[NodeCheckFlags["BlockScopedBindingInLoop"] = 524288] = "BlockScopedBindingInLoop";
            NodeCheckFlags[NodeCheckFlags["ClassWithBodyScopedClassBinding"] = 1048576] = "ClassWithBodyScopedClassBinding";
            NodeCheckFlags[NodeCheckFlags["BodyScopedClassBinding"] = 2097152] = "BodyScopedClassBinding";
            NodeCheckFlags[NodeCheckFlags["NeedsLoopOutParameter"] = 4194304] = "NeedsLoopOutParameter";
            NodeCheckFlags[NodeCheckFlags["AssignmentsMarked"] = 8388608] = "AssignmentsMarked";
            NodeCheckFlags[NodeCheckFlags["ClassWithConstructorReference"] = 16777216] = "ClassWithConstructorReference";
            NodeCheckFlags[NodeCheckFlags["ConstructorReferenceInClass"] = 33554432] = "ConstructorReferenceInClass";
            NodeCheckFlags[NodeCheckFlags["ContainsClassWithPrivateIdentifiers"] = 67108864] = "ContainsClassWithPrivateIdentifiers";
        })(NodeCheckFlags = ts.NodeCheckFlags || (ts.NodeCheckFlags = {}));
        var TypeFlags;
        (function (TypeFlags) {
            TypeFlags[TypeFlags["Any"] = 1] = "Any";
            TypeFlags[TypeFlags["Unknown"] = 2] = "Unknown";
            TypeFlags[TypeFlags["String"] = 4] = "String";
            TypeFlags[TypeFlags["Number"] = 8] = "Number";
            TypeFlags[TypeFlags["Boolean"] = 16] = "Boolean";
            TypeFlags[TypeFlags["Enum"] = 32] = "Enum";
            TypeFlags[TypeFlags["BigInt"] = 64] = "BigInt";
            TypeFlags[TypeFlags["StringLiteral"] = 128] = "StringLiteral";
            TypeFlags[TypeFlags["NumberLiteral"] = 256] = "NumberLiteral";
            TypeFlags[TypeFlags["BooleanLiteral"] = 512] = "BooleanLiteral";
            TypeFlags[TypeFlags["EnumLiteral"] = 1024] = "EnumLiteral";
            TypeFlags[TypeFlags["BigIntLiteral"] = 2048] = "BigIntLiteral";
            TypeFlags[TypeFlags["ESSymbol"] = 4096] = "ESSymbol";
            TypeFlags[TypeFlags["UniqueESSymbol"] = 8192] = "UniqueESSymbol";
            TypeFlags[TypeFlags["Void"] = 16384] = "Void";
            TypeFlags[TypeFlags["Undefined"] = 32768] = "Undefined";
            TypeFlags[TypeFlags["Null"] = 65536] = "Null";
            TypeFlags[TypeFlags["Never"] = 131072] = "Never";
            TypeFlags[TypeFlags["TypeParameter"] = 262144] = "TypeParameter";
            TypeFlags[TypeFlags["Object"] = 524288] = "Object";
            TypeFlags[TypeFlags["Union"] = 1048576] = "Union";
            TypeFlags[TypeFlags["Intersection"] = 2097152] = "Intersection";
            TypeFlags[TypeFlags["Index"] = 4194304] = "Index";
            TypeFlags[TypeFlags["IndexedAccess"] = 8388608] = "IndexedAccess";
            TypeFlags[TypeFlags["Conditional"] = 16777216] = "Conditional";
            TypeFlags[TypeFlags["Substitution"] = 33554432] = "Substitution";
            TypeFlags[TypeFlags["NonPrimitive"] = 67108864] = "NonPrimitive";
            /* @internal */
            TypeFlags[TypeFlags["AnyOrUnknown"] = 3] = "AnyOrUnknown";
            /* @internal */
            TypeFlags[TypeFlags["Nullable"] = 98304] = "Nullable";
            TypeFlags[TypeFlags["Literal"] = 2944] = "Literal";
            TypeFlags[TypeFlags["Unit"] = 109440] = "Unit";
            TypeFlags[TypeFlags["StringOrNumberLiteral"] = 384] = "StringOrNumberLiteral";
            /* @internal */
            TypeFlags[TypeFlags["StringOrNumberLiteralOrUnique"] = 8576] = "StringOrNumberLiteralOrUnique";
            /* @internal */
            TypeFlags[TypeFlags["DefinitelyFalsy"] = 117632] = "DefinitelyFalsy";
            TypeFlags[TypeFlags["PossiblyFalsy"] = 117724] = "PossiblyFalsy";
            /* @internal */
            TypeFlags[TypeFlags["Intrinsic"] = 67359327] = "Intrinsic";
            /* @internal */
            TypeFlags[TypeFlags["Primitive"] = 131068] = "Primitive";
            TypeFlags[TypeFlags["StringLike"] = 132] = "StringLike";
            TypeFlags[TypeFlags["NumberLike"] = 296] = "NumberLike";
            TypeFlags[TypeFlags["BigIntLike"] = 2112] = "BigIntLike";
            TypeFlags[TypeFlags["BooleanLike"] = 528] = "BooleanLike";
            TypeFlags[TypeFlags["EnumLike"] = 1056] = "EnumLike";
            TypeFlags[TypeFlags["ESSymbolLike"] = 12288] = "ESSymbolLike";
            TypeFlags[TypeFlags["VoidLike"] = 49152] = "VoidLike";
            /* @internal */
            TypeFlags[TypeFlags["DisjointDomains"] = 67238908] = "DisjointDomains";
            TypeFlags[TypeFlags["UnionOrIntersection"] = 3145728] = "UnionOrIntersection";
            TypeFlags[TypeFlags["StructuredType"] = 3670016] = "StructuredType";
            TypeFlags[TypeFlags["TypeVariable"] = 8650752] = "TypeVariable";
            TypeFlags[TypeFlags["InstantiableNonPrimitive"] = 58982400] = "InstantiableNonPrimitive";
            TypeFlags[TypeFlags["InstantiablePrimitive"] = 4194304] = "InstantiablePrimitive";
            TypeFlags[TypeFlags["Instantiable"] = 63176704] = "Instantiable";
            TypeFlags[TypeFlags["StructuredOrInstantiable"] = 66846720] = "StructuredOrInstantiable";
            /* @internal */
            TypeFlags[TypeFlags["ObjectFlagsType"] = 3899393] = "ObjectFlagsType";
            /* @internal */
            TypeFlags[TypeFlags["Simplifiable"] = 25165824] = "Simplifiable";
            // 'Narrowable' types are types where narrowing actually narrows.
            // This *should* be every type other than null, undefined, void, and never
            TypeFlags[TypeFlags["Narrowable"] = 133970943] = "Narrowable";
            TypeFlags[TypeFlags["NotUnionOrUnit"] = 67637251] = "NotUnionOrUnit";
            /* @internal */
            TypeFlags[TypeFlags["NotPrimitiveUnion"] = 66994211] = "NotPrimitiveUnion";
            // The following flags are aggregated during union and intersection type construction
            /* @internal */
            TypeFlags[TypeFlags["IncludesMask"] = 68943871] = "IncludesMask";
            // The following flags are used for different purposes during union and intersection type construction
            /* @internal */
            TypeFlags[TypeFlags["IncludesStructuredOrInstantiable"] = 262144] = "IncludesStructuredOrInstantiable";
            /* @internal */
            TypeFlags[TypeFlags["IncludesNonWideningType"] = 2097152] = "IncludesNonWideningType";
            /* @internal */
            TypeFlags[TypeFlags["IncludesWildcard"] = 4194304] = "IncludesWildcard";
            /* @internal */
            TypeFlags[TypeFlags["IncludesEmptyObject"] = 8388608] = "IncludesEmptyObject";
            // The following flag is used for different purposes by maybeTypeOfKind
            /* @internal */
            TypeFlags[TypeFlags["GenericMappedType"] = 131072] = "GenericMappedType";
        })(TypeFlags = ts.TypeFlags || (ts.TypeFlags = {}));
        var ObjectFlags;
        (function (ObjectFlags) {
            ObjectFlags[ObjectFlags["Class"] = 1] = "Class";
            ObjectFlags[ObjectFlags["Interface"] = 2] = "Interface";
            ObjectFlags[ObjectFlags["Reference"] = 4] = "Reference";
            ObjectFlags[ObjectFlags["Tuple"] = 8] = "Tuple";
            ObjectFlags[ObjectFlags["Anonymous"] = 16] = "Anonymous";
            ObjectFlags[ObjectFlags["Mapped"] = 32] = "Mapped";
            ObjectFlags[ObjectFlags["Instantiated"] = 64] = "Instantiated";
            ObjectFlags[ObjectFlags["ObjectLiteral"] = 128] = "ObjectLiteral";
            ObjectFlags[ObjectFlags["EvolvingArray"] = 256] = "EvolvingArray";
            ObjectFlags[ObjectFlags["ObjectLiteralPatternWithComputedProperties"] = 512] = "ObjectLiteralPatternWithComputedProperties";
            ObjectFlags[ObjectFlags["ContainsSpread"] = 1024] = "ContainsSpread";
            ObjectFlags[ObjectFlags["ReverseMapped"] = 2048] = "ReverseMapped";
            ObjectFlags[ObjectFlags["JsxAttributes"] = 4096] = "JsxAttributes";
            ObjectFlags[ObjectFlags["MarkerType"] = 8192] = "MarkerType";
            ObjectFlags[ObjectFlags["JSLiteral"] = 16384] = "JSLiteral";
            ObjectFlags[ObjectFlags["FreshLiteral"] = 32768] = "FreshLiteral";
            ObjectFlags[ObjectFlags["ArrayLiteral"] = 65536] = "ArrayLiteral";
            ObjectFlags[ObjectFlags["ObjectRestType"] = 131072] = "ObjectRestType";
            /* @internal */
            ObjectFlags[ObjectFlags["PrimitiveUnion"] = 262144] = "PrimitiveUnion";
            /* @internal */
            ObjectFlags[ObjectFlags["ContainsWideningType"] = 524288] = "ContainsWideningType";
            /* @internal */
            ObjectFlags[ObjectFlags["ContainsObjectOrArrayLiteral"] = 1048576] = "ContainsObjectOrArrayLiteral";
            /* @internal */
            ObjectFlags[ObjectFlags["NonInferrableType"] = 2097152] = "NonInferrableType";
            ObjectFlags[ObjectFlags["ClassOrInterface"] = 3] = "ClassOrInterface";
            /* @internal */
            ObjectFlags[ObjectFlags["RequiresWidening"] = 1572864] = "RequiresWidening";
            /* @internal */
            ObjectFlags[ObjectFlags["PropagatingFlags"] = 3670016] = "PropagatingFlags";
        })(ObjectFlags = ts.ObjectFlags || (ts.ObjectFlags = {}));
        /* @internal */
        var VarianceFlags;
        (function (VarianceFlags) {
            VarianceFlags[VarianceFlags["Invariant"] = 0] = "Invariant";
            VarianceFlags[VarianceFlags["Covariant"] = 1] = "Covariant";
            VarianceFlags[VarianceFlags["Contravariant"] = 2] = "Contravariant";
            VarianceFlags[VarianceFlags["Bivariant"] = 3] = "Bivariant";
            VarianceFlags[VarianceFlags["Independent"] = 4] = "Independent";
            VarianceFlags[VarianceFlags["VarianceMask"] = 7] = "VarianceMask";
            VarianceFlags[VarianceFlags["Unmeasurable"] = 8] = "Unmeasurable";
            VarianceFlags[VarianceFlags["Unreliable"] = 16] = "Unreliable";
            VarianceFlags[VarianceFlags["AllowsStructuralFallback"] = 24] = "AllowsStructuralFallback";
        })(VarianceFlags = ts.VarianceFlags || (ts.VarianceFlags = {}));
        /* @internal */
        var JsxReferenceKind;
        (function (JsxReferenceKind) {
            JsxReferenceKind[JsxReferenceKind["Component"] = 0] = "Component";
            JsxReferenceKind[JsxReferenceKind["Function"] = 1] = "Function";
            JsxReferenceKind[JsxReferenceKind["Mixed"] = 2] = "Mixed";
        })(JsxReferenceKind = ts.JsxReferenceKind || (ts.JsxReferenceKind = {}));
        var SignatureKind;
        (function (SignatureKind) {
            SignatureKind[SignatureKind["Call"] = 0] = "Call";
            SignatureKind[SignatureKind["Construct"] = 1] = "Construct";
        })(SignatureKind = ts.SignatureKind || (ts.SignatureKind = {}));
        /* @internal */
        var SignatureFlags;
        (function (SignatureFlags) {
            SignatureFlags[SignatureFlags["None"] = 0] = "None";
            SignatureFlags[SignatureFlags["HasRestParameter"] = 1] = "HasRestParameter";
            SignatureFlags[SignatureFlags["HasLiteralTypes"] = 2] = "HasLiteralTypes";
            SignatureFlags[SignatureFlags["IsInnerCallChain"] = 4] = "IsInnerCallChain";
            SignatureFlags[SignatureFlags["IsOuterCallChain"] = 8] = "IsOuterCallChain";
            // We do not propagate `IsInnerCallChain` to instantiated signatures, as that would result in us
            // attempting to add `| undefined` on each recursive call to `getReturnTypeOfSignature` when
            // instantiating the return type.
            SignatureFlags[SignatureFlags["PropagatingFlags"] = 3] = "PropagatingFlags";
            SignatureFlags[SignatureFlags["CallChainFlags"] = 12] = "CallChainFlags";
        })(SignatureFlags = ts.SignatureFlags || (ts.SignatureFlags = {}));
        var IndexKind;
        (function (IndexKind) {
            IndexKind[IndexKind["String"] = 0] = "String";
            IndexKind[IndexKind["Number"] = 1] = "Number";
        })(IndexKind = ts.IndexKind || (ts.IndexKind = {}));
        var InferencePriority;
        (function (InferencePriority) {
            InferencePriority[InferencePriority["NakedTypeVariable"] = 1] = "NakedTypeVariable";
            InferencePriority[InferencePriority["HomomorphicMappedType"] = 2] = "HomomorphicMappedType";
            InferencePriority[InferencePriority["PartialHomomorphicMappedType"] = 4] = "PartialHomomorphicMappedType";
            InferencePriority[InferencePriority["MappedTypeConstraint"] = 8] = "MappedTypeConstraint";
            InferencePriority[InferencePriority["ContravariantConditional"] = 16] = "ContravariantConditional";
            InferencePriority[InferencePriority["ReturnType"] = 32] = "ReturnType";
            InferencePriority[InferencePriority["LiteralKeyof"] = 64] = "LiteralKeyof";
            InferencePriority[InferencePriority["NoConstraints"] = 128] = "NoConstraints";
            InferencePriority[InferencePriority["AlwaysStrict"] = 256] = "AlwaysStrict";
            InferencePriority[InferencePriority["MaxValue"] = 512] = "MaxValue";
            InferencePriority[InferencePriority["PriorityImpliesCombination"] = 104] = "PriorityImpliesCombination";
            InferencePriority[InferencePriority["Circularity"] = -1] = "Circularity";
        })(InferencePriority = ts.InferencePriority || (ts.InferencePriority = {}));
        /* @internal */
        var InferenceFlags;
        (function (InferenceFlags) {
            InferenceFlags[InferenceFlags["None"] = 0] = "None";
            InferenceFlags[InferenceFlags["NoDefault"] = 1] = "NoDefault";
            InferenceFlags[InferenceFlags["AnyDefault"] = 2] = "AnyDefault";
            InferenceFlags[InferenceFlags["SkippedGenericFunction"] = 4] = "SkippedGenericFunction";
        })(InferenceFlags = ts.InferenceFlags || (ts.InferenceFlags = {}));
        /**
         * Ternary values are defined such that
         * x & y is False if either x or y is False.
         * x & y is Maybe if either x or y is Maybe, but neither x or y is False.
         * x & y is True if both x and y are True.
         * x | y is False if both x and y are False.
         * x | y is Maybe if either x or y is Maybe, but neither x or y is True.
         * x | y is True if either x or y is True.
         */
        /* @internal */
        var Ternary;
        (function (Ternary) {
            Ternary[Ternary["False"] = 0] = "False";
            Ternary[Ternary["Maybe"] = 1] = "Maybe";
            Ternary[Ternary["True"] = -1] = "True";
        })(Ternary = ts.Ternary || (ts.Ternary = {}));
        /* @internal */
        var AssignmentDeclarationKind;
        (function (AssignmentDeclarationKind) {
            AssignmentDeclarationKind[AssignmentDeclarationKind["None"] = 0] = "None";
            /// exports.name = expr
            AssignmentDeclarationKind[AssignmentDeclarationKind["ExportsProperty"] = 1] = "ExportsProperty";
            /// module.exports = expr
            AssignmentDeclarationKind[AssignmentDeclarationKind["ModuleExports"] = 2] = "ModuleExports";
            /// className.prototype.name = expr
            AssignmentDeclarationKind[AssignmentDeclarationKind["PrototypeProperty"] = 3] = "PrototypeProperty";
            /// this.name = expr
            AssignmentDeclarationKind[AssignmentDeclarationKind["ThisProperty"] = 4] = "ThisProperty";
            // F.name = expr
            AssignmentDeclarationKind[AssignmentDeclarationKind["Property"] = 5] = "Property";
            // F.prototype = { ... }
            AssignmentDeclarationKind[AssignmentDeclarationKind["Prototype"] = 6] = "Prototype";
            // Object.defineProperty(x, 'name', { value: any, writable?: boolean (false by default) });
            // Object.defineProperty(x, 'name', { get: Function, set: Function });
            // Object.defineProperty(x, 'name', { get: Function });
            // Object.defineProperty(x, 'name', { set: Function });
            AssignmentDeclarationKind[AssignmentDeclarationKind["ObjectDefinePropertyValue"] = 7] = "ObjectDefinePropertyValue";
            // Object.defineProperty(exports || module.exports, 'name', ...);
            AssignmentDeclarationKind[AssignmentDeclarationKind["ObjectDefinePropertyExports"] = 8] = "ObjectDefinePropertyExports";
            // Object.defineProperty(Foo.prototype, 'name', ...);
            AssignmentDeclarationKind[AssignmentDeclarationKind["ObjectDefinePrototypeProperty"] = 9] = "ObjectDefinePrototypeProperty";
        })(AssignmentDeclarationKind = ts.AssignmentDeclarationKind || (ts.AssignmentDeclarationKind = {}));
        var DiagnosticCategory;
        (function (DiagnosticCategory) {
            DiagnosticCategory[DiagnosticCategory["Warning"] = 0] = "Warning";
            DiagnosticCategory[DiagnosticCategory["Error"] = 1] = "Error";
            DiagnosticCategory[DiagnosticCategory["Suggestion"] = 2] = "Suggestion";
            DiagnosticCategory[DiagnosticCategory["Message"] = 3] = "Message";
        })(DiagnosticCategory = ts.DiagnosticCategory || (ts.DiagnosticCategory = {}));
        /* @internal */
        function diagnosticCategoryName(d, lowerCase) {
            if (lowerCase === void 0) {
                lowerCase = true;
            }
            var name = DiagnosticCategory[d.category];
            return lowerCase ? name.toLowerCase() : name;
        }
        ts.diagnosticCategoryName = diagnosticCategoryName;
        var ModuleResolutionKind;
        (function (ModuleResolutionKind) {
            ModuleResolutionKind[ModuleResolutionKind["Classic"] = 1] = "Classic";
            ModuleResolutionKind[ModuleResolutionKind["NodeJs"] = 2] = "NodeJs";
        })(ModuleResolutionKind = ts.ModuleResolutionKind || (ts.ModuleResolutionKind = {}));
        var WatchFileKind;
        (function (WatchFileKind) {
            WatchFileKind[WatchFileKind["FixedPollingInterval"] = 0] = "FixedPollingInterval";
            WatchFileKind[WatchFileKind["PriorityPollingInterval"] = 1] = "PriorityPollingInterval";
            WatchFileKind[WatchFileKind["DynamicPriorityPolling"] = 2] = "DynamicPriorityPolling";
            WatchFileKind[WatchFileKind["UseFsEvents"] = 3] = "UseFsEvents";
            WatchFileKind[WatchFileKind["UseFsEventsOnParentDirectory"] = 4] = "UseFsEventsOnParentDirectory";
        })(WatchFileKind = ts.WatchFileKind || (ts.WatchFileKind = {}));
        var WatchDirectoryKind;
        (function (WatchDirectoryKind) {
            WatchDirectoryKind[WatchDirectoryKind["UseFsEvents"] = 0] = "UseFsEvents";
            WatchDirectoryKind[WatchDirectoryKind["FixedPollingInterval"] = 1] = "FixedPollingInterval";
            WatchDirectoryKind[WatchDirectoryKind["DynamicPriorityPolling"] = 2] = "DynamicPriorityPolling";
        })(WatchDirectoryKind = ts.WatchDirectoryKind || (ts.WatchDirectoryKind = {}));
        var PollingWatchKind;
        (function (PollingWatchKind) {
            PollingWatchKind[PollingWatchKind["FixedInterval"] = 0] = "FixedInterval";
            PollingWatchKind[PollingWatchKind["PriorityInterval"] = 1] = "PriorityInterval";
            PollingWatchKind[PollingWatchKind["DynamicPriority"] = 2] = "DynamicPriority";
        })(PollingWatchKind = ts.PollingWatchKind || (ts.PollingWatchKind = {}));
        var ModuleKind;
        (function (ModuleKind) {
            ModuleKind[ModuleKind["None"] = 0] = "None";
            ModuleKind[ModuleKind["CommonJS"] = 1] = "CommonJS";
            ModuleKind[ModuleKind["AMD"] = 2] = "AMD";
            ModuleKind[ModuleKind["UMD"] = 3] = "UMD";
            ModuleKind[ModuleKind["System"] = 4] = "System";
            // NOTE: ES module kinds should be contiguous to more easily check whether a module kind is *any* ES module kind.
            //       Non-ES module kinds should not come between ES2015 (the earliest ES module kind) and ESNext (the last ES
            //       module kind).
            ModuleKind[ModuleKind["ES2015"] = 5] = "ES2015";
            ModuleKind[ModuleKind["ES2020"] = 6] = "ES2020";
            ModuleKind[ModuleKind["ESNext"] = 99] = "ESNext";
        })(ModuleKind = ts.ModuleKind || (ts.ModuleKind = {}));
        var JsxEmit;
        (function (JsxEmit) {
            JsxEmit[JsxEmit["None"] = 0] = "None";
            JsxEmit[JsxEmit["Preserve"] = 1] = "Preserve";
            JsxEmit[JsxEmit["React"] = 2] = "React";
            JsxEmit[JsxEmit["ReactNative"] = 3] = "ReactNative";
        })(JsxEmit = ts.JsxEmit || (ts.JsxEmit = {}));
        var ImportsNotUsedAsValues;
        (function (ImportsNotUsedAsValues) {
            ImportsNotUsedAsValues[ImportsNotUsedAsValues["Remove"] = 0] = "Remove";
            ImportsNotUsedAsValues[ImportsNotUsedAsValues["Preserve"] = 1] = "Preserve";
            ImportsNotUsedAsValues[ImportsNotUsedAsValues["Error"] = 2] = "Error";
        })(ImportsNotUsedAsValues = ts.ImportsNotUsedAsValues || (ts.ImportsNotUsedAsValues = {}));
        var NewLineKind;
        (function (NewLineKind) {
            NewLineKind[NewLineKind["CarriageReturnLineFeed"] = 0] = "CarriageReturnLineFeed";
            NewLineKind[NewLineKind["LineFeed"] = 1] = "LineFeed";
        })(NewLineKind = ts.NewLineKind || (ts.NewLineKind = {}));
        var ScriptKind;
        (function (ScriptKind) {
            ScriptKind[ScriptKind["Unknown"] = 0] = "Unknown";
            ScriptKind[ScriptKind["JS"] = 1] = "JS";
            ScriptKind[ScriptKind["JSX"] = 2] = "JSX";
            ScriptKind[ScriptKind["TS"] = 3] = "TS";
            ScriptKind[ScriptKind["TSX"] = 4] = "TSX";
            ScriptKind[ScriptKind["External"] = 5] = "External";
            ScriptKind[ScriptKind["JSON"] = 6] = "JSON";
            /**
             * Used on extensions that doesn't define the ScriptKind but the content defines it.
             * Deferred extensions are going to be included in all project contexts.
             */
            ScriptKind[ScriptKind["Deferred"] = 7] = "Deferred";
        })(ScriptKind = ts.ScriptKind || (ts.ScriptKind = {}));
        var ScriptTarget;
        (function (ScriptTarget) {
            ScriptTarget[ScriptTarget["ES3"] = 0] = "ES3";
            ScriptTarget[ScriptTarget["ES5"] = 1] = "ES5";
            ScriptTarget[ScriptTarget["ES2015"] = 2] = "ES2015";
            ScriptTarget[ScriptTarget["ES2016"] = 3] = "ES2016";
            ScriptTarget[ScriptTarget["ES2017"] = 4] = "ES2017";
            ScriptTarget[ScriptTarget["ES2018"] = 5] = "ES2018";
            ScriptTarget[ScriptTarget["ES2019"] = 6] = "ES2019";
            ScriptTarget[ScriptTarget["ES2020"] = 7] = "ES2020";
            ScriptTarget[ScriptTarget["ESNext"] = 99] = "ESNext";
            ScriptTarget[ScriptTarget["JSON"] = 100] = "JSON";
            ScriptTarget[ScriptTarget["Latest"] = 99] = "Latest";
        })(ScriptTarget = ts.ScriptTarget || (ts.ScriptTarget = {}));
        var LanguageVariant;
        (function (LanguageVariant) {
            LanguageVariant[LanguageVariant["Standard"] = 0] = "Standard";
            LanguageVariant[LanguageVariant["JSX"] = 1] = "JSX";
        })(LanguageVariant = ts.LanguageVariant || (ts.LanguageVariant = {}));
        var WatchDirectoryFlags;
        (function (WatchDirectoryFlags) {
            WatchDirectoryFlags[WatchDirectoryFlags["None"] = 0] = "None";
            WatchDirectoryFlags[WatchDirectoryFlags["Recursive"] = 1] = "Recursive";
        })(WatchDirectoryFlags = ts.WatchDirectoryFlags || (ts.WatchDirectoryFlags = {}));
        /* @internal */
        var CharacterCodes;
        (function (CharacterCodes) {
            CharacterCodes[CharacterCodes["nullCharacter"] = 0] = "nullCharacter";
            CharacterCodes[CharacterCodes["maxAsciiCharacter"] = 127] = "maxAsciiCharacter";
            CharacterCodes[CharacterCodes["lineFeed"] = 10] = "lineFeed";
            CharacterCodes[CharacterCodes["carriageReturn"] = 13] = "carriageReturn";
            CharacterCodes[CharacterCodes["lineSeparator"] = 8232] = "lineSeparator";
            CharacterCodes[CharacterCodes["paragraphSeparator"] = 8233] = "paragraphSeparator";
            CharacterCodes[CharacterCodes["nextLine"] = 133] = "nextLine";
            // Unicode 3.0 space characters
            CharacterCodes[CharacterCodes["space"] = 32] = "space";
            CharacterCodes[CharacterCodes["nonBreakingSpace"] = 160] = "nonBreakingSpace";
            CharacterCodes[CharacterCodes["enQuad"] = 8192] = "enQuad";
            CharacterCodes[CharacterCodes["emQuad"] = 8193] = "emQuad";
            CharacterCodes[CharacterCodes["enSpace"] = 8194] = "enSpace";
            CharacterCodes[CharacterCodes["emSpace"] = 8195] = "emSpace";
            CharacterCodes[CharacterCodes["threePerEmSpace"] = 8196] = "threePerEmSpace";
            CharacterCodes[CharacterCodes["fourPerEmSpace"] = 8197] = "fourPerEmSpace";
            CharacterCodes[CharacterCodes["sixPerEmSpace"] = 8198] = "sixPerEmSpace";
            CharacterCodes[CharacterCodes["figureSpace"] = 8199] = "figureSpace";
            CharacterCodes[CharacterCodes["punctuationSpace"] = 8200] = "punctuationSpace";
            CharacterCodes[CharacterCodes["thinSpace"] = 8201] = "thinSpace";
            CharacterCodes[CharacterCodes["hairSpace"] = 8202] = "hairSpace";
            CharacterCodes[CharacterCodes["zeroWidthSpace"] = 8203] = "zeroWidthSpace";
            CharacterCodes[CharacterCodes["narrowNoBreakSpace"] = 8239] = "narrowNoBreakSpace";
            CharacterCodes[CharacterCodes["ideographicSpace"] = 12288] = "ideographicSpace";
            CharacterCodes[CharacterCodes["mathematicalSpace"] = 8287] = "mathematicalSpace";
            CharacterCodes[CharacterCodes["ogham"] = 5760] = "ogham";
            CharacterCodes[CharacterCodes["_"] = 95] = "_";
            CharacterCodes[CharacterCodes["$"] = 36] = "$";
            CharacterCodes[CharacterCodes["_0"] = 48] = "_0";
            CharacterCodes[CharacterCodes["_1"] = 49] = "_1";
            CharacterCodes[CharacterCodes["_2"] = 50] = "_2";
            CharacterCodes[CharacterCodes["_3"] = 51] = "_3";
            CharacterCodes[CharacterCodes["_4"] = 52] = "_4";
            CharacterCodes[CharacterCodes["_5"] = 53] = "_5";
            CharacterCodes[CharacterCodes["_6"] = 54] = "_6";
            CharacterCodes[CharacterCodes["_7"] = 55] = "_7";
            CharacterCodes[CharacterCodes["_8"] = 56] = "_8";
            CharacterCodes[CharacterCodes["_9"] = 57] = "_9";
            CharacterCodes[CharacterCodes["a"] = 97] = "a";
            CharacterCodes[CharacterCodes["b"] = 98] = "b";
            CharacterCodes[CharacterCodes["c"] = 99] = "c";
            CharacterCodes[CharacterCodes["d"] = 100] = "d";
            CharacterCodes[CharacterCodes["e"] = 101] = "e";
            CharacterCodes[CharacterCodes["f"] = 102] = "f";
            CharacterCodes[CharacterCodes["g"] = 103] = "g";
            CharacterCodes[CharacterCodes["h"] = 104] = "h";
            CharacterCodes[CharacterCodes["i"] = 105] = "i";
            CharacterCodes[CharacterCodes["j"] = 106] = "j";
            CharacterCodes[CharacterCodes["k"] = 107] = "k";
            CharacterCodes[CharacterCodes["l"] = 108] = "l";
            CharacterCodes[CharacterCodes["m"] = 109] = "m";
            CharacterCodes[CharacterCodes["n"] = 110] = "n";
            CharacterCodes[CharacterCodes["o"] = 111] = "o";
            CharacterCodes[CharacterCodes["p"] = 112] = "p";
            CharacterCodes[CharacterCodes["q"] = 113] = "q";
            CharacterCodes[CharacterCodes["r"] = 114] = "r";
            CharacterCodes[CharacterCodes["s"] = 115] = "s";
            CharacterCodes[CharacterCodes["t"] = 116] = "t";
            CharacterCodes[CharacterCodes["u"] = 117] = "u";
            CharacterCodes[CharacterCodes["v"] = 118] = "v";
            CharacterCodes[CharacterCodes["w"] = 119] = "w";
            CharacterCodes[CharacterCodes["x"] = 120] = "x";
            CharacterCodes[CharacterCodes["y"] = 121] = "y";
            CharacterCodes[CharacterCodes["z"] = 122] = "z";
            CharacterCodes[CharacterCodes["A"] = 65] = "A";
            CharacterCodes[CharacterCodes["B"] = 66] = "B";
            CharacterCodes[CharacterCodes["C"] = 67] = "C";
            CharacterCodes[CharacterCodes["D"] = 68] = "D";
            CharacterCodes[CharacterCodes["E"] = 69] = "E";
            CharacterCodes[CharacterCodes["F"] = 70] = "F";
            CharacterCodes[CharacterCodes["G"] = 71] = "G";
            CharacterCodes[CharacterCodes["H"] = 72] = "H";
            CharacterCodes[CharacterCodes["I"] = 73] = "I";
            CharacterCodes[CharacterCodes["J"] = 74] = "J";
            CharacterCodes[CharacterCodes["K"] = 75] = "K";
            CharacterCodes[CharacterCodes["L"] = 76] = "L";
            CharacterCodes[CharacterCodes["M"] = 77] = "M";
            CharacterCodes[CharacterCodes["N"] = 78] = "N";
            CharacterCodes[CharacterCodes["O"] = 79] = "O";
            CharacterCodes[CharacterCodes["P"] = 80] = "P";
            CharacterCodes[CharacterCodes["Q"] = 81] = "Q";
            CharacterCodes[CharacterCodes["R"] = 82] = "R";
            CharacterCodes[CharacterCodes["S"] = 83] = "S";
            CharacterCodes[CharacterCodes["T"] = 84] = "T";
            CharacterCodes[CharacterCodes["U"] = 85] = "U";
            CharacterCodes[CharacterCodes["V"] = 86] = "V";
            CharacterCodes[CharacterCodes["W"] = 87] = "W";
            CharacterCodes[CharacterCodes["X"] = 88] = "X";
            CharacterCodes[CharacterCodes["Y"] = 89] = "Y";
            CharacterCodes[CharacterCodes["Z"] = 90] = "Z";
            CharacterCodes[CharacterCodes["ampersand"] = 38] = "ampersand";
            CharacterCodes[CharacterCodes["asterisk"] = 42] = "asterisk";
            CharacterCodes[CharacterCodes["at"] = 64] = "at";
            CharacterCodes[CharacterCodes["backslash"] = 92] = "backslash";
            CharacterCodes[CharacterCodes["backtick"] = 96] = "backtick";
            CharacterCodes[CharacterCodes["bar"] = 124] = "bar";
            CharacterCodes[CharacterCodes["caret"] = 94] = "caret";
            CharacterCodes[CharacterCodes["closeBrace"] = 125] = "closeBrace";
            CharacterCodes[CharacterCodes["closeBracket"] = 93] = "closeBracket";
            CharacterCodes[CharacterCodes["closeParen"] = 41] = "closeParen";
            CharacterCodes[CharacterCodes["colon"] = 58] = "colon";
            CharacterCodes[CharacterCodes["comma"] = 44] = "comma";
            CharacterCodes[CharacterCodes["dot"] = 46] = "dot";
            CharacterCodes[CharacterCodes["doubleQuote"] = 34] = "doubleQuote";
            CharacterCodes[CharacterCodes["equals"] = 61] = "equals";
            CharacterCodes[CharacterCodes["exclamation"] = 33] = "exclamation";
            CharacterCodes[CharacterCodes["greaterThan"] = 62] = "greaterThan";
            CharacterCodes[CharacterCodes["hash"] = 35] = "hash";
            CharacterCodes[CharacterCodes["lessThan"] = 60] = "lessThan";
            CharacterCodes[CharacterCodes["minus"] = 45] = "minus";
            CharacterCodes[CharacterCodes["openBrace"] = 123] = "openBrace";
            CharacterCodes[CharacterCodes["openBracket"] = 91] = "openBracket";
            CharacterCodes[CharacterCodes["openParen"] = 40] = "openParen";
            CharacterCodes[CharacterCodes["percent"] = 37] = "percent";
            CharacterCodes[CharacterCodes["plus"] = 43] = "plus";
            CharacterCodes[CharacterCodes["question"] = 63] = "question";
            CharacterCodes[CharacterCodes["semicolon"] = 59] = "semicolon";
            CharacterCodes[CharacterCodes["singleQuote"] = 39] = "singleQuote";
            CharacterCodes[CharacterCodes["slash"] = 47] = "slash";
            CharacterCodes[CharacterCodes["tilde"] = 126] = "tilde";
            CharacterCodes[CharacterCodes["backspace"] = 8] = "backspace";
            CharacterCodes[CharacterCodes["formFeed"] = 12] = "formFeed";
            CharacterCodes[CharacterCodes["byteOrderMark"] = 65279] = "byteOrderMark";
            CharacterCodes[CharacterCodes["tab"] = 9] = "tab";
            CharacterCodes[CharacterCodes["verticalTab"] = 11] = "verticalTab";
        })(CharacterCodes = ts.CharacterCodes || (ts.CharacterCodes = {}));
        var Extension;
        (function (Extension) {
            Extension["Ts"] = ".ts";
            Extension["Tsx"] = ".tsx";
            Extension["Dts"] = ".d.ts";
            Extension["Js"] = ".js";
            Extension["Jsx"] = ".jsx";
            Extension["Json"] = ".json";
            Extension["TsBuildInfo"] = ".tsbuildinfo";
        })(Extension = ts.Extension || (ts.Extension = {}));
        /* @internal */
        var TransformFlags;
        (function (TransformFlags) {
            TransformFlags[TransformFlags["None"] = 0] = "None";
            // Facts
            // - Flags used to indicate that a node or subtree contains syntax that requires transformation.
            TransformFlags[TransformFlags["ContainsTypeScript"] = 1] = "ContainsTypeScript";
            TransformFlags[TransformFlags["ContainsJsx"] = 2] = "ContainsJsx";
            TransformFlags[TransformFlags["ContainsESNext"] = 4] = "ContainsESNext";
            TransformFlags[TransformFlags["ContainsES2020"] = 8] = "ContainsES2020";
            TransformFlags[TransformFlags["ContainsES2019"] = 16] = "ContainsES2019";
            TransformFlags[TransformFlags["ContainsES2018"] = 32] = "ContainsES2018";
            TransformFlags[TransformFlags["ContainsES2017"] = 64] = "ContainsES2017";
            TransformFlags[TransformFlags["ContainsES2016"] = 128] = "ContainsES2016";
            TransformFlags[TransformFlags["ContainsES2015"] = 256] = "ContainsES2015";
            TransformFlags[TransformFlags["ContainsGenerator"] = 512] = "ContainsGenerator";
            TransformFlags[TransformFlags["ContainsDestructuringAssignment"] = 1024] = "ContainsDestructuringAssignment";
            // Markers
            // - Flags used to indicate that a subtree contains a specific transformation.
            TransformFlags[TransformFlags["ContainsTypeScriptClassSyntax"] = 2048] = "ContainsTypeScriptClassSyntax";
            TransformFlags[TransformFlags["ContainsLexicalThis"] = 4096] = "ContainsLexicalThis";
            TransformFlags[TransformFlags["ContainsRestOrSpread"] = 8192] = "ContainsRestOrSpread";
            TransformFlags[TransformFlags["ContainsObjectRestOrSpread"] = 16384] = "ContainsObjectRestOrSpread";
            TransformFlags[TransformFlags["ContainsComputedPropertyName"] = 32768] = "ContainsComputedPropertyName";
            TransformFlags[TransformFlags["ContainsBlockScopedBinding"] = 65536] = "ContainsBlockScopedBinding";
            TransformFlags[TransformFlags["ContainsBindingPattern"] = 131072] = "ContainsBindingPattern";
            TransformFlags[TransformFlags["ContainsYield"] = 262144] = "ContainsYield";
            TransformFlags[TransformFlags["ContainsAwait"] = 524288] = "ContainsAwait";
            TransformFlags[TransformFlags["ContainsHoistedDeclarationOrCompletion"] = 1048576] = "ContainsHoistedDeclarationOrCompletion";
            TransformFlags[TransformFlags["ContainsDynamicImport"] = 2097152] = "ContainsDynamicImport";
            TransformFlags[TransformFlags["ContainsClassFields"] = 4194304] = "ContainsClassFields";
            // Please leave this as 1 << 29.
            // It is the maximum bit we can set before we outgrow the size of a v8 small integer (SMI) on an x86 system.
            // It is a good reminder of how much room we have left
            TransformFlags[TransformFlags["HasComputedFlags"] = 536870912] = "HasComputedFlags";
            // Assertions
            // - Bitmasks that are used to assert facts about the syntax of a node and its subtree.
            TransformFlags[TransformFlags["AssertTypeScript"] = 1] = "AssertTypeScript";
            TransformFlags[TransformFlags["AssertJsx"] = 2] = "AssertJsx";
            TransformFlags[TransformFlags["AssertESNext"] = 4] = "AssertESNext";
            TransformFlags[TransformFlags["AssertES2020"] = 8] = "AssertES2020";
            TransformFlags[TransformFlags["AssertES2019"] = 16] = "AssertES2019";
            TransformFlags[TransformFlags["AssertES2018"] = 32] = "AssertES2018";
            TransformFlags[TransformFlags["AssertES2017"] = 64] = "AssertES2017";
            TransformFlags[TransformFlags["AssertES2016"] = 128] = "AssertES2016";
            TransformFlags[TransformFlags["AssertES2015"] = 256] = "AssertES2015";
            TransformFlags[TransformFlags["AssertGenerator"] = 512] = "AssertGenerator";
            TransformFlags[TransformFlags["AssertDestructuringAssignment"] = 1024] = "AssertDestructuringAssignment";
            // Scope Exclusions
            // - Bitmasks that exclude flags from propagating out of a specific context
            //   into the subtree flags of their container.
            TransformFlags[TransformFlags["OuterExpressionExcludes"] = 536870912] = "OuterExpressionExcludes";
            TransformFlags[TransformFlags["PropertyAccessExcludes"] = 536870912] = "PropertyAccessExcludes";
            TransformFlags[TransformFlags["NodeExcludes"] = 536870912] = "NodeExcludes";
            TransformFlags[TransformFlags["ArrowFunctionExcludes"] = 538920960] = "ArrowFunctionExcludes";
            TransformFlags[TransformFlags["FunctionExcludes"] = 538925056] = "FunctionExcludes";
            TransformFlags[TransformFlags["ConstructorExcludes"] = 538923008] = "ConstructorExcludes";
            TransformFlags[TransformFlags["MethodOrAccessorExcludes"] = 538923008] = "MethodOrAccessorExcludes";
            TransformFlags[TransformFlags["PropertyExcludes"] = 536875008] = "PropertyExcludes";
            TransformFlags[TransformFlags["ClassExcludes"] = 536905728] = "ClassExcludes";
            TransformFlags[TransformFlags["ModuleExcludes"] = 537991168] = "ModuleExcludes";
            TransformFlags[TransformFlags["TypeExcludes"] = -2] = "TypeExcludes";
            TransformFlags[TransformFlags["ObjectLiteralExcludes"] = 536922112] = "ObjectLiteralExcludes";
            TransformFlags[TransformFlags["ArrayLiteralOrCallOrNewExcludes"] = 536879104] = "ArrayLiteralOrCallOrNewExcludes";
            TransformFlags[TransformFlags["VariableDeclarationListExcludes"] = 537018368] = "VariableDeclarationListExcludes";
            TransformFlags[TransformFlags["ParameterExcludes"] = 536870912] = "ParameterExcludes";
            TransformFlags[TransformFlags["CatchClauseExcludes"] = 536887296] = "CatchClauseExcludes";
            TransformFlags[TransformFlags["BindingPatternExcludes"] = 536879104] = "BindingPatternExcludes";
            // Propagating flags
            // - Bitmasks for flags that should propagate from a child
            TransformFlags[TransformFlags["PropertyNamePropagatingFlags"] = 4096] = "PropertyNamePropagatingFlags";
            // Masks
            // - Additional bitmasks
        })(TransformFlags = ts.TransformFlags || (ts.TransformFlags = {}));
        var EmitFlags;
        (function (EmitFlags) {
            EmitFlags[EmitFlags["None"] = 0] = "None";
            EmitFlags[EmitFlags["SingleLine"] = 1] = "SingleLine";
            EmitFlags[EmitFlags["AdviseOnEmitNode"] = 2] = "AdviseOnEmitNode";
            EmitFlags[EmitFlags["NoSubstitution"] = 4] = "NoSubstitution";
            EmitFlags[EmitFlags["CapturesThis"] = 8] = "CapturesThis";
            EmitFlags[EmitFlags["NoLeadingSourceMap"] = 16] = "NoLeadingSourceMap";
            EmitFlags[EmitFlags["NoTrailingSourceMap"] = 32] = "NoTrailingSourceMap";
            EmitFlags[EmitFlags["NoSourceMap"] = 48] = "NoSourceMap";
            EmitFlags[EmitFlags["NoNestedSourceMaps"] = 64] = "NoNestedSourceMaps";
            EmitFlags[EmitFlags["NoTokenLeadingSourceMaps"] = 128] = "NoTokenLeadingSourceMaps";
            EmitFlags[EmitFlags["NoTokenTrailingSourceMaps"] = 256] = "NoTokenTrailingSourceMaps";
            EmitFlags[EmitFlags["NoTokenSourceMaps"] = 384] = "NoTokenSourceMaps";
            EmitFlags[EmitFlags["NoLeadingComments"] = 512] = "NoLeadingComments";
            EmitFlags[EmitFlags["NoTrailingComments"] = 1024] = "NoTrailingComments";
            EmitFlags[EmitFlags["NoComments"] = 1536] = "NoComments";
            EmitFlags[EmitFlags["NoNestedComments"] = 2048] = "NoNestedComments";
            EmitFlags[EmitFlags["HelperName"] = 4096] = "HelperName";
            EmitFlags[EmitFlags["ExportName"] = 8192] = "ExportName";
            EmitFlags[EmitFlags["LocalName"] = 16384] = "LocalName";
            EmitFlags[EmitFlags["InternalName"] = 32768] = "InternalName";
            EmitFlags[EmitFlags["Indented"] = 65536] = "Indented";
            EmitFlags[EmitFlags["NoIndentation"] = 131072] = "NoIndentation";
            EmitFlags[EmitFlags["AsyncFunctionBody"] = 262144] = "AsyncFunctionBody";
            EmitFlags[EmitFlags["ReuseTempVariableScope"] = 524288] = "ReuseTempVariableScope";
            EmitFlags[EmitFlags["CustomPrologue"] = 1048576] = "CustomPrologue";
            EmitFlags[EmitFlags["NoHoisting"] = 2097152] = "NoHoisting";
            EmitFlags[EmitFlags["HasEndOfDeclarationMarker"] = 4194304] = "HasEndOfDeclarationMarker";
            EmitFlags[EmitFlags["Iterator"] = 8388608] = "Iterator";
            EmitFlags[EmitFlags["NoAsciiEscaping"] = 16777216] = "NoAsciiEscaping";
            /*@internal*/ EmitFlags[EmitFlags["TypeScriptClassWrapper"] = 33554432] = "TypeScriptClassWrapper";
            /*@internal*/ EmitFlags[EmitFlags["NeverApplyImportHelper"] = 67108864] = "NeverApplyImportHelper";
        })(EmitFlags = ts.EmitFlags || (ts.EmitFlags = {}));
        /**
         * Used by the checker, this enum keeps track of external emit helpers that should be type
         * checked.
         */
        /* @internal */
        var ExternalEmitHelpers;
        (function (ExternalEmitHelpers) {
            ExternalEmitHelpers[ExternalEmitHelpers["Extends"] = 1] = "Extends";
            ExternalEmitHelpers[ExternalEmitHelpers["Assign"] = 2] = "Assign";
            ExternalEmitHelpers[ExternalEmitHelpers["Rest"] = 4] = "Rest";
            ExternalEmitHelpers[ExternalEmitHelpers["Decorate"] = 8] = "Decorate";
            ExternalEmitHelpers[ExternalEmitHelpers["Metadata"] = 16] = "Metadata";
            ExternalEmitHelpers[ExternalEmitHelpers["Param"] = 32] = "Param";
            ExternalEmitHelpers[ExternalEmitHelpers["Awaiter"] = 64] = "Awaiter";
            ExternalEmitHelpers[ExternalEmitHelpers["Generator"] = 128] = "Generator";
            ExternalEmitHelpers[ExternalEmitHelpers["Values"] = 256] = "Values";
            ExternalEmitHelpers[ExternalEmitHelpers["Read"] = 512] = "Read";
            ExternalEmitHelpers[ExternalEmitHelpers["Spread"] = 1024] = "Spread";
            ExternalEmitHelpers[ExternalEmitHelpers["SpreadArrays"] = 2048] = "SpreadArrays";
            ExternalEmitHelpers[ExternalEmitHelpers["Await"] = 4096] = "Await";
            ExternalEmitHelpers[ExternalEmitHelpers["AsyncGenerator"] = 8192] = "AsyncGenerator";
            ExternalEmitHelpers[ExternalEmitHelpers["AsyncDelegator"] = 16384] = "AsyncDelegator";
            ExternalEmitHelpers[ExternalEmitHelpers["AsyncValues"] = 32768] = "AsyncValues";
            ExternalEmitHelpers[ExternalEmitHelpers["ExportStar"] = 65536] = "ExportStar";
            ExternalEmitHelpers[ExternalEmitHelpers["MakeTemplateObject"] = 131072] = "MakeTemplateObject";
            ExternalEmitHelpers[ExternalEmitHelpers["ClassPrivateFieldGet"] = 262144] = "ClassPrivateFieldGet";
            ExternalEmitHelpers[ExternalEmitHelpers["ClassPrivateFieldSet"] = 524288] = "ClassPrivateFieldSet";
            ExternalEmitHelpers[ExternalEmitHelpers["FirstEmitHelper"] = 1] = "FirstEmitHelper";
            ExternalEmitHelpers[ExternalEmitHelpers["LastEmitHelper"] = 524288] = "LastEmitHelper";
            // Helpers included by ES2015 for..of
            ExternalEmitHelpers[ExternalEmitHelpers["ForOfIncludes"] = 256] = "ForOfIncludes";
            // Helpers included by ES2017 for..await..of
            ExternalEmitHelpers[ExternalEmitHelpers["ForAwaitOfIncludes"] = 32768] = "ForAwaitOfIncludes";
            // Helpers included by ES2017 async generators
            ExternalEmitHelpers[ExternalEmitHelpers["AsyncGeneratorIncludes"] = 12288] = "AsyncGeneratorIncludes";
            // Helpers included by yield* in ES2017 async generators
            ExternalEmitHelpers[ExternalEmitHelpers["AsyncDelegatorIncludes"] = 53248] = "AsyncDelegatorIncludes";
            // Helpers included by ES2015 spread
            ExternalEmitHelpers[ExternalEmitHelpers["SpreadIncludes"] = 1536] = "SpreadIncludes";
        })(ExternalEmitHelpers = ts.ExternalEmitHelpers || (ts.ExternalEmitHelpers = {}));
        var EmitHint;
        (function (EmitHint) {
            EmitHint[EmitHint["SourceFile"] = 0] = "SourceFile";
            EmitHint[EmitHint["Expression"] = 1] = "Expression";
            EmitHint[EmitHint["IdentifierName"] = 2] = "IdentifierName";
            EmitHint[EmitHint["MappedTypeParameter"] = 3] = "MappedTypeParameter";
            EmitHint[EmitHint["Unspecified"] = 4] = "Unspecified";
            EmitHint[EmitHint["EmbeddedStatement"] = 5] = "EmbeddedStatement";
            EmitHint[EmitHint["JsxAttributeValue"] = 6] = "JsxAttributeValue";
        })(EmitHint = ts.EmitHint || (ts.EmitHint = {}));
        /*@internal*/
        var BundleFileSectionKind;
        (function (BundleFileSectionKind) {
            BundleFileSectionKind["Prologue"] = "prologue";
            BundleFileSectionKind["EmitHelpers"] = "emitHelpers";
            BundleFileSectionKind["NoDefaultLib"] = "no-default-lib";
            BundleFileSectionKind["Reference"] = "reference";
            BundleFileSectionKind["Type"] = "type";
            BundleFileSectionKind["Lib"] = "lib";
            BundleFileSectionKind["Prepend"] = "prepend";
            BundleFileSectionKind["Text"] = "text";
            BundleFileSectionKind["Internal"] = "internal";
            // comments?
        })(BundleFileSectionKind = ts.BundleFileSectionKind || (ts.BundleFileSectionKind = {}));
        var ListFormat;
        (function (ListFormat) {
            ListFormat[ListFormat["None"] = 0] = "None";
            // Line separators
            ListFormat[ListFormat["SingleLine"] = 0] = "SingleLine";
            ListFormat[ListFormat["MultiLine"] = 1] = "MultiLine";
            ListFormat[ListFormat["PreserveLines"] = 2] = "PreserveLines";
            ListFormat[ListFormat["LinesMask"] = 3] = "LinesMask";
            // Delimiters
            ListFormat[ListFormat["NotDelimited"] = 0] = "NotDelimited";
            ListFormat[ListFormat["BarDelimited"] = 4] = "BarDelimited";
            ListFormat[ListFormat["AmpersandDelimited"] = 8] = "AmpersandDelimited";
            ListFormat[ListFormat["CommaDelimited"] = 16] = "CommaDelimited";
            ListFormat[ListFormat["AsteriskDelimited"] = 32] = "AsteriskDelimited";
            ListFormat[ListFormat["DelimitersMask"] = 60] = "DelimitersMask";
            ListFormat[ListFormat["AllowTrailingComma"] = 64] = "AllowTrailingComma";
            // Whitespace
            ListFormat[ListFormat["Indented"] = 128] = "Indented";
            ListFormat[ListFormat["SpaceBetweenBraces"] = 256] = "SpaceBetweenBraces";
            ListFormat[ListFormat["SpaceBetweenSiblings"] = 512] = "SpaceBetweenSiblings";
            // Brackets/Braces
            ListFormat[ListFormat["Braces"] = 1024] = "Braces";
            ListFormat[ListFormat["Parenthesis"] = 2048] = "Parenthesis";
            ListFormat[ListFormat["AngleBrackets"] = 4096] = "AngleBrackets";
            ListFormat[ListFormat["SquareBrackets"] = 8192] = "SquareBrackets";
            ListFormat[ListFormat["BracketsMask"] = 15360] = "BracketsMask";
            ListFormat[ListFormat["OptionalIfUndefined"] = 16384] = "OptionalIfUndefined";
            ListFormat[ListFormat["OptionalIfEmpty"] = 32768] = "OptionalIfEmpty";
            ListFormat[ListFormat["Optional"] = 49152] = "Optional";
            // Other
            ListFormat[ListFormat["PreferNewLine"] = 65536] = "PreferNewLine";
            ListFormat[ListFormat["NoTrailingNewLine"] = 131072] = "NoTrailingNewLine";
            ListFormat[ListFormat["NoInterveningComments"] = 262144] = "NoInterveningComments";
            ListFormat[ListFormat["NoSpaceIfEmpty"] = 524288] = "NoSpaceIfEmpty";
            ListFormat[ListFormat["SingleElement"] = 1048576] = "SingleElement";
            // Precomputed Formats
            ListFormat[ListFormat["Modifiers"] = 262656] = "Modifiers";
            ListFormat[ListFormat["HeritageClauses"] = 512] = "HeritageClauses";
            ListFormat[ListFormat["SingleLineTypeLiteralMembers"] = 768] = "SingleLineTypeLiteralMembers";
            ListFormat[ListFormat["MultiLineTypeLiteralMembers"] = 32897] = "MultiLineTypeLiteralMembers";
            ListFormat[ListFormat["TupleTypeElements"] = 528] = "TupleTypeElements";
            ListFormat[ListFormat["UnionTypeConstituents"] = 516] = "UnionTypeConstituents";
            ListFormat[ListFormat["IntersectionTypeConstituents"] = 520] = "IntersectionTypeConstituents";
            ListFormat[ListFormat["ObjectBindingPatternElements"] = 525136] = "ObjectBindingPatternElements";
            ListFormat[ListFormat["ArrayBindingPatternElements"] = 524880] = "ArrayBindingPatternElements";
            ListFormat[ListFormat["ObjectLiteralExpressionProperties"] = 526226] = "ObjectLiteralExpressionProperties";
            ListFormat[ListFormat["ArrayLiteralExpressionElements"] = 8914] = "ArrayLiteralExpressionElements";
            ListFormat[ListFormat["CommaListElements"] = 528] = "CommaListElements";
            ListFormat[ListFormat["CallExpressionArguments"] = 2576] = "CallExpressionArguments";
            ListFormat[ListFormat["NewExpressionArguments"] = 18960] = "NewExpressionArguments";
            ListFormat[ListFormat["TemplateExpressionSpans"] = 262144] = "TemplateExpressionSpans";
            ListFormat[ListFormat["SingleLineBlockStatements"] = 768] = "SingleLineBlockStatements";
            ListFormat[ListFormat["MultiLineBlockStatements"] = 129] = "MultiLineBlockStatements";
            ListFormat[ListFormat["VariableDeclarationList"] = 528] = "VariableDeclarationList";
            ListFormat[ListFormat["SingleLineFunctionBodyStatements"] = 768] = "SingleLineFunctionBodyStatements";
            ListFormat[ListFormat["MultiLineFunctionBodyStatements"] = 1] = "MultiLineFunctionBodyStatements";
            ListFormat[ListFormat["ClassHeritageClauses"] = 0] = "ClassHeritageClauses";
            ListFormat[ListFormat["ClassMembers"] = 129] = "ClassMembers";
            ListFormat[ListFormat["InterfaceMembers"] = 129] = "InterfaceMembers";
            ListFormat[ListFormat["EnumMembers"] = 145] = "EnumMembers";
            ListFormat[ListFormat["CaseBlockClauses"] = 129] = "CaseBlockClauses";
            ListFormat[ListFormat["NamedImportsOrExportsElements"] = 525136] = "NamedImportsOrExportsElements";
            ListFormat[ListFormat["JsxElementOrFragmentChildren"] = 262144] = "JsxElementOrFragmentChildren";
            ListFormat[ListFormat["JsxElementAttributes"] = 262656] = "JsxElementAttributes";
            ListFormat[ListFormat["CaseOrDefaultClauseStatements"] = 163969] = "CaseOrDefaultClauseStatements";
            ListFormat[ListFormat["HeritageClauseTypes"] = 528] = "HeritageClauseTypes";
            ListFormat[ListFormat["SourceFileStatements"] = 131073] = "SourceFileStatements";
            ListFormat[ListFormat["Decorators"] = 49153] = "Decorators";
            ListFormat[ListFormat["TypeArguments"] = 53776] = "TypeArguments";
            ListFormat[ListFormat["TypeParameters"] = 53776] = "TypeParameters";
            ListFormat[ListFormat["Parameters"] = 2576] = "Parameters";
            ListFormat[ListFormat["IndexSignatureParameters"] = 8848] = "IndexSignatureParameters";
            ListFormat[ListFormat["JSDocComment"] = 33] = "JSDocComment";
        })(ListFormat = ts.ListFormat || (ts.ListFormat = {}));
        /* @internal */
        var PragmaKindFlags;
        (function (PragmaKindFlags) {
            PragmaKindFlags[PragmaKindFlags["None"] = 0] = "None";
            /**
             * Triple slash comment of the form
             * /// <pragma-name argname="value" />
             */
            PragmaKindFlags[PragmaKindFlags["TripleSlashXML"] = 1] = "TripleSlashXML";
            /**
             * Single line comment of the form
             * // @pragma-name argval1 argval2
             * or
             * /// @pragma-name argval1 argval2
             */
            PragmaKindFlags[PragmaKindFlags["SingleLine"] = 2] = "SingleLine";
            /**
             * Multiline non-jsdoc pragma of the form
             * /* @pragma-name argval1 argval2 * /
             */
            PragmaKindFlags[PragmaKindFlags["MultiLine"] = 4] = "MultiLine";
            PragmaKindFlags[PragmaKindFlags["All"] = 7] = "All";
            PragmaKindFlags[PragmaKindFlags["Default"] = 7] = "Default";
        })(PragmaKindFlags = ts.PragmaKindFlags || (ts.PragmaKindFlags = {}));
        // While not strictly a type, this is here because `PragmaMap` needs to be here to be used with `SourceFile`, and we don't
        //  fancy effectively defining it twice, once in value-space and once in type-space
        /* @internal */
        ts.commentPragmas = {
            "reference": {
                args: [
                    { name: "types", optional: true, captureSpan: true },
                    { name: "lib", optional: true, captureSpan: true },
                    { name: "path", optional: true, captureSpan: true },
                    { name: "no-default-lib", optional: true }
                ],
                kind: 1 /* TripleSlashXML */
            },
            "amd-dependency": {
                args: [{ name: "path" }, { name: "name", optional: true }],
                kind: 1 /* TripleSlashXML */
            },
            "amd-module": {
                args: [{ name: "name" }],
                kind: 1 /* TripleSlashXML */
            },
            "ts-check": {
                kind: 2 /* SingleLine */
            },
            "ts-nocheck": {
                kind: 2 /* SingleLine */
            },
            "jsx": {
                args: [{ name: "factory" }],
                kind: 4 /* MultiLine */
            },
        };
    })(ts || (ts = {}));
    var ts;
    (function (ts) {
        /**
         * djb2 hashing algorithm
         * http://www.cse.yorku.ca/~oz/hash.html
         */
        /* @internal */
        function generateDjb2Hash(data) {
            var acc = 5381;
            for (var i = 0; i < data.length; i++) {
                acc = ((acc << 5) + acc) + data.charCodeAt(i);
            }
            return acc.toString();
        }
        ts.generateDjb2Hash = generateDjb2Hash;
        /**
         * Set a high stack trace limit to provide more information in case of an error.
         * Called for command-line and server use cases.
         * Not called if TypeScript is used as a library.
         */
        /* @internal */
        function setStackTraceLimit() {
            if (Error.stackTraceLimit < 100) { // Also tests that we won't set the property if it doesn't exist.
                Error.stackTraceLimit = 100;
            }
        }
        ts.setStackTraceLimit = setStackTraceLimit;
        var FileWatcherEventKind;
        (function (FileWatcherEventKind) {
            FileWatcherEventKind[FileWatcherEventKind["Created"] = 0] = "Created";
            FileWatcherEventKind[FileWatcherEventKind["Changed"] = 1] = "Changed";
            FileWatcherEventKind[FileWatcherEventKind["Deleted"] = 2] = "Deleted";
        })(FileWatcherEventKind = ts.FileWatcherEventKind || (ts.FileWatcherEventKind = {}));
        /* @internal */
        var PollingInterval;
        (function (PollingInterval) {
            PollingInterval[PollingInterval["High"] = 2000] = "High";
            PollingInterval[PollingInterval["Medium"] = 500] = "Medium";
            PollingInterval[PollingInterval["Low"] = 250] = "Low";
        })(PollingInterval = ts.PollingInterval || (ts.PollingInterval = {}));
        /* @internal */
        ts.missingFileModifiedTime = new Date(0); // Any subsequent modification will occur after this time
        function createPollingIntervalBasedLevels(levels) {
            var _a;
            return _a = {},
                _a[PollingInterval.Low] = levels.Low,
                _a[PollingInterval.Medium] = levels.Medium,
                _a[PollingInterval.High] = levels.High,
                _a;
        }
        var defaultChunkLevels = { Low: 32, Medium: 64, High: 256 };
        var pollingChunkSize = createPollingIntervalBasedLevels(defaultChunkLevels);
        /* @internal */
        ts.unchangedPollThresholds = createPollingIntervalBasedLevels(defaultChunkLevels);
        /* @internal */
        function setCustomPollingValues(system) {
            if (!system.getEnvironmentVariable) {
                return;
            }
            var pollingIntervalChanged = setCustomLevels("TSC_WATCH_POLLINGINTERVAL", PollingInterval);
            pollingChunkSize = getCustomPollingBasedLevels("TSC_WATCH_POLLINGCHUNKSIZE", defaultChunkLevels) || pollingChunkSize;
            ts.unchangedPollThresholds = getCustomPollingBasedLevels("TSC_WATCH_UNCHANGEDPOLLTHRESHOLDS", defaultChunkLevels) || ts.unchangedPollThresholds;
            function getLevel(envVar, level) {
                return system.getEnvironmentVariable(envVar + "_" + level.toUpperCase());
            }
            function getCustomLevels(baseVariable) {
                var customLevels;
                setCustomLevel("Low");
                setCustomLevel("Medium");
                setCustomLevel("High");
                return customLevels;
                function setCustomLevel(level) {
                    var customLevel = getLevel(baseVariable, level);
                    if (customLevel) {
                        (customLevels || (customLevels = {}))[level] = Number(customLevel);
                    }
                }
            }
            function setCustomLevels(baseVariable, levels) {
                var customLevels = getCustomLevels(baseVariable);
                if (customLevels) {
                    setLevel("Low");
                    setLevel("Medium");
                    setLevel("High");
                    return true;
                }
                return false;
                function setLevel(level) {
                    levels[level] = customLevels[level] || levels[level];
                }
            }
            function getCustomPollingBasedLevels(baseVariable, defaultLevels) {
                var customLevels = getCustomLevels(baseVariable);
                return (pollingIntervalChanged || customLevels) &&
                    createPollingIntervalBasedLevels(customLevels ? __assign(__assign({}, defaultLevels), customLevels) : defaultLevels);
            }
        }
        ts.setCustomPollingValues = setCustomPollingValues;
        /* @internal */
        function createDynamicPriorityPollingWatchFile(host) {
            var watchedFiles = [];
            var changedFilesInLastPoll = [];
            var lowPollingIntervalQueue = createPollingIntervalQueue(PollingInterval.Low);
            var mediumPollingIntervalQueue = createPollingIntervalQueue(PollingInterval.Medium);
            var highPollingIntervalQueue = createPollingIntervalQueue(PollingInterval.High);
            return watchFile;
            function watchFile(fileName, callback, defaultPollingInterval) {
                var file = {
                    fileName: fileName,
                    callback: callback,
                    unchangedPolls: 0,
                    mtime: getModifiedTime(fileName)
                };
                watchedFiles.push(file);
                addToPollingIntervalQueue(file, defaultPollingInterval);
                return {
                    close: function () {
                        file.isClosed = true;
                        // Remove from watchedFiles
                        ts.unorderedRemoveItem(watchedFiles, file);
                        // Do not update polling interval queue since that will happen as part of polling
                    }
                };
            }
            function createPollingIntervalQueue(pollingInterval) {
                var queue = [];
                queue.pollingInterval = pollingInterval;
                queue.pollIndex = 0;
                queue.pollScheduled = false;
                return queue;
            }
            function pollPollingIntervalQueue(queue) {
                queue.pollIndex = pollQueue(queue, queue.pollingInterval, queue.pollIndex, pollingChunkSize[queue.pollingInterval]);
                // Set the next polling index and timeout
                if (queue.length) {
                    scheduleNextPoll(queue.pollingInterval);
                }
                else {
                    ts.Debug.assert(queue.pollIndex === 0);
                    queue.pollScheduled = false;
                }
            }
            function pollLowPollingIntervalQueue(queue) {
                // Always poll complete list of changedFilesInLastPoll
                pollQueue(changedFilesInLastPoll, PollingInterval.Low, /*pollIndex*/ 0, changedFilesInLastPoll.length);
                // Finally do the actual polling of the queue
                pollPollingIntervalQueue(queue);
                // Schedule poll if there are files in changedFilesInLastPoll but no files in the actual queue
                // as pollPollingIntervalQueue wont schedule for next poll
                if (!queue.pollScheduled && changedFilesInLastPoll.length) {
                    scheduleNextPoll(PollingInterval.Low);
                }
            }
            function pollQueue(queue, pollingInterval, pollIndex, chunkSize) {
                // Max visit would be all elements of the queue
                var needsVisit = queue.length;
                var definedValueCopyToIndex = pollIndex;
                for (var polled = 0; polled < chunkSize && needsVisit > 0; nextPollIndex(), needsVisit--) {
                    var watchedFile = queue[pollIndex];
                    if (!watchedFile) {
                        continue;
                    }
                    else if (watchedFile.isClosed) {
                        queue[pollIndex] = undefined;
                        continue;
                    }
                    polled++;
                    var fileChanged = onWatchedFileStat(watchedFile, getModifiedTime(watchedFile.fileName));
                    if (watchedFile.isClosed) {
                        // Closed watcher as part of callback
                        queue[pollIndex] = undefined;
                    }
                    else if (fileChanged) {
                        watchedFile.unchangedPolls = 0;
                        // Changed files go to changedFilesInLastPoll queue
                        if (queue !== changedFilesInLastPoll) {
                            queue[pollIndex] = undefined;
                            addChangedFileToLowPollingIntervalQueue(watchedFile);
                        }
                    }
                    else if (watchedFile.unchangedPolls !== ts.unchangedPollThresholds[pollingInterval]) {
                        watchedFile.unchangedPolls++;
                    }
                    else if (queue === changedFilesInLastPoll) {
                        // Restart unchangedPollCount for unchanged file and move to low polling interval queue
                        watchedFile.unchangedPolls = 1;
                        queue[pollIndex] = undefined;
                        addToPollingIntervalQueue(watchedFile, PollingInterval.Low);
                    }
                    else if (pollingInterval !== PollingInterval.High) {
                        watchedFile.unchangedPolls++;
                        queue[pollIndex] = undefined;
                        addToPollingIntervalQueue(watchedFile, pollingInterval === PollingInterval.Low ? PollingInterval.Medium : PollingInterval.High);
                    }
                    if (queue[pollIndex]) {
                        // Copy this file to the non hole location
                        if (definedValueCopyToIndex < pollIndex) {
                            queue[definedValueCopyToIndex] = watchedFile;
                            queue[pollIndex] = undefined;
                        }
                        definedValueCopyToIndex++;
                    }
                }
                // Return next poll index
                return pollIndex;
                function nextPollIndex() {
                    pollIndex++;
                    if (pollIndex === queue.length) {
                        if (definedValueCopyToIndex < pollIndex) {
                            // There are holes from nextDefinedValueIndex to end of queue, change queue size
                            queue.length = definedValueCopyToIndex;
                        }
                        pollIndex = 0;
                        definedValueCopyToIndex = 0;
                    }
                }
            }
            function pollingIntervalQueue(pollingInterval) {
                switch (pollingInterval) {
                    case PollingInterval.Low:
                        return lowPollingIntervalQueue;
                    case PollingInterval.Medium:
                        return mediumPollingIntervalQueue;
                    case PollingInterval.High:
                        return highPollingIntervalQueue;
                }
            }
            function addToPollingIntervalQueue(file, pollingInterval) {
                pollingIntervalQueue(pollingInterval).push(file);
                scheduleNextPollIfNotAlreadyScheduled(pollingInterval);
            }
            function addChangedFileToLowPollingIntervalQueue(file) {
                changedFilesInLastPoll.push(file);
                scheduleNextPollIfNotAlreadyScheduled(PollingInterval.Low);
            }
            function scheduleNextPollIfNotAlreadyScheduled(pollingInterval) {
                if (!pollingIntervalQueue(pollingInterval).pollScheduled) {
                    scheduleNextPoll(pollingInterval);
                }
            }
            function scheduleNextPoll(pollingInterval) {
                pollingIntervalQueue(pollingInterval).pollScheduled = host.setTimeout(pollingInterval === PollingInterval.Low ? pollLowPollingIntervalQueue : pollPollingIntervalQueue, pollingInterval, pollingIntervalQueue(pollingInterval));
            }
            function getModifiedTime(fileName) {
                return host.getModifiedTime(fileName) || ts.missingFileModifiedTime;
            }
        }
        ts.createDynamicPriorityPollingWatchFile = createDynamicPriorityPollingWatchFile;
        function createUseFsEventsOnParentDirectoryWatchFile(fsWatch, useCaseSensitiveFileNames) {
            // One file can have multiple watchers
            var fileWatcherCallbacks = ts.createMultiMap();
            var dirWatchers = ts.createMap();
            var toCanonicalName = ts.createGetCanonicalFileName(useCaseSensitiveFileNames);
            return nonPollingWatchFile;
            function nonPollingWatchFile(fileName, callback, _pollingInterval, fallbackOptions) {
                var filePath = toCanonicalName(fileName);
                fileWatcherCallbacks.add(filePath, callback);
                var dirPath = ts.getDirectoryPath(filePath) || ".";
                var watcher = dirWatchers.get(dirPath) ||
                    createDirectoryWatcher(ts.getDirectoryPath(fileName) || ".", dirPath, fallbackOptions);
                watcher.referenceCount++;
                return {
                    close: function () {
                        if (watcher.referenceCount === 1) {
                            watcher.close();
                            dirWatchers.delete(dirPath);
                        }
                        else {
                            watcher.referenceCount--;
                        }
                        fileWatcherCallbacks.remove(filePath, callback);
                    }
                };
            }
            function createDirectoryWatcher(dirName, dirPath, fallbackOptions) {
                var watcher = fsWatch(dirName, 1 /* Directory */, function (_eventName, relativeFileName) {
                    // When files are deleted from disk, the triggered "rename" event would have a relativefileName of "undefined"
                    if (!ts.isString(relativeFileName)) {
                        return;
                    }
                    var fileName = ts.getNormalizedAbsolutePath(relativeFileName, dirName);
                    // Some applications save a working file via rename operations
                    var callbacks = fileName && fileWatcherCallbacks.get(toCanonicalName(fileName));
                    if (callbacks) {
                        for (var _i = 0, callbacks_1 = callbacks; _i < callbacks_1.length; _i++) {
                            var fileCallback = callbacks_1[_i];
                            fileCallback(fileName, FileWatcherEventKind.Changed);
                        }
                    }
                }, 
                /*recursive*/ false, PollingInterval.Medium, fallbackOptions);
                watcher.referenceCount = 0;
                dirWatchers.set(dirPath, watcher);
                return watcher;
            }
        }
        /* @internal */
        function createSingleFileWatcherPerName(watchFile, useCaseSensitiveFileNames) {
            var cache = ts.createMap();
            var callbacksCache = ts.createMultiMap();
            var toCanonicalFileName = ts.createGetCanonicalFileName(useCaseSensitiveFileNames);
            return function (fileName, callback, pollingInterval, options) {
                var path = toCanonicalFileName(fileName);
                var existing = cache.get(path);
                if (existing) {
                    existing.refCount++;
                }
                else {
                    cache.set(path, {
                        watcher: watchFile(fileName, function (fileName, eventKind) { return ts.forEach(callbacksCache.get(path), function (cb) { return cb(fileName, eventKind); }); }, pollingInterval, options),
                        refCount: 1
                    });
                }
                callbacksCache.add(path, callback);
                return {
                    close: function () {
                        var watcher = ts.Debug.assertDefined(cache.get(path));
                        callbacksCache.remove(path, callback);
                        watcher.refCount--;
                        if (watcher.refCount)
                            return;
                        cache.delete(path);
                        ts.closeFileWatcherOf(watcher);
                    }
                };
            };
        }
        ts.createSingleFileWatcherPerName = createSingleFileWatcherPerName;
        /**
         * Returns true if file status changed
         */
        /*@internal*/
        function onWatchedFileStat(watchedFile, modifiedTime) {
            var oldTime = watchedFile.mtime.getTime();
            var newTime = modifiedTime.getTime();
            if (oldTime !== newTime) {
                watchedFile.mtime = modifiedTime;
                watchedFile.callback(watchedFile.fileName, getFileWatcherEventKind(oldTime, newTime));
                return true;
            }
            return false;
        }
        ts.onWatchedFileStat = onWatchedFileStat;
        /*@internal*/
        function getFileWatcherEventKind(oldTime, newTime) {
            return oldTime === 0
                ? FileWatcherEventKind.Created
                : newTime === 0
                    ? FileWatcherEventKind.Deleted
                    : FileWatcherEventKind.Changed;
        }
        ts.getFileWatcherEventKind = getFileWatcherEventKind;
        /*@internal*/
        ts.ignoredPaths = ["/node_modules/.", "/.git", "/.#"];
        /*@internal*/
        ts.sysLog = ts.noop; // eslint-disable-line prefer-const
        /*@internal*/
        function setSysLog(logger) {
            ts.sysLog = logger;
        }
        ts.setSysLog = setSysLog;
        /**
         * Watch the directory recursively using host provided method to watch child directories
         * that means if this is recursive watcher, watch the children directories as well
         * (eg on OS that dont support recursive watch using fs.watch use fs.watchFile)
         */
        /*@internal*/
        function createDirectoryWatcherSupportingRecursive(host) {
            var cache = ts.createMap();
            var callbackCache = ts.createMultiMap();
            var cacheToUpdateChildWatches = ts.createMap();
            var timerToUpdateChildWatches;
            var filePathComparer = ts.getStringComparer(!host.useCaseSensitiveFileNames);
            var toCanonicalFilePath = ts.createGetCanonicalFileName(host.useCaseSensitiveFileNames);
            return function (dirName, callback, recursive, options) {
                return recursive ?
                    createDirectoryWatcher(dirName, options, callback) :
                    host.watchDirectory(dirName, callback, recursive, options);
            };
            /**
             * Create the directory watcher for the dirPath.
             */
            function createDirectoryWatcher(dirName, options, callback) {
                var dirPath = toCanonicalFilePath(dirName);
                var directoryWatcher = cache.get(dirPath);
                if (directoryWatcher) {
                    directoryWatcher.refCount++;
                }
                else {
                    directoryWatcher = {
                        watcher: host.watchDirectory(dirName, function (fileName) {
                            if (isIgnoredPath(fileName))
                                return;
                            if (options === null || options === void 0 ? void 0 : options.synchronousWatchDirectory) {
                                // Call the actual callback
                                invokeCallbacks(dirPath, fileName);
                                // Iterate through existing children and update the watches if needed
                                updateChildWatches(dirName, dirPath, options);
                            }
                            else {
                                nonSyncUpdateChildWatches(dirName, dirPath, fileName, options);
                            }
                        }, /*recursive*/ false, options),
                        refCount: 1,
                        childWatches: ts.emptyArray
                    };
                    cache.set(dirPath, directoryWatcher);
                    updateChildWatches(dirName, dirPath, options);
                }
                var callbackToAdd = callback && { dirName: dirName, callback: callback };
                if (callbackToAdd) {
                    callbackCache.add(dirPath, callbackToAdd);
                }
                return {
                    dirName: dirName,
                    close: function () {
                        var directoryWatcher = ts.Debug.assertDefined(cache.get(dirPath));
                        if (callbackToAdd)
                            callbackCache.remove(dirPath, callbackToAdd);
                        directoryWatcher.refCount--;
                        if (directoryWatcher.refCount)
                            return;
                        cache.delete(dirPath);
                        ts.closeFileWatcherOf(directoryWatcher);
                        directoryWatcher.childWatches.forEach(ts.closeFileWatcher);
                    }
                };
            }
            function invokeCallbacks(dirPath, fileNameOrInvokeMap) {
                var fileName;
                var invokeMap;
                if (ts.isString(fileNameOrInvokeMap)) {
                    fileName = fileNameOrInvokeMap;
                }
                else {
                    invokeMap = fileNameOrInvokeMap;
                }
                // Call the actual callback
                callbackCache.forEach(function (callbacks, rootDirName) {
                    if (invokeMap && invokeMap.has(rootDirName))
                        return;
                    if (rootDirName === dirPath || (ts.startsWith(dirPath, rootDirName) && dirPath[rootDirName.length] === ts.directorySeparator)) {
                        if (invokeMap) {
                            invokeMap.set(rootDirName, true);
                        }
                        else {
                            callbacks.forEach(function (_a) {
                                var callback = _a.callback;
                                return callback(fileName);
                            });
                        }
                    }
                });
            }
            function nonSyncUpdateChildWatches(dirName, dirPath, fileName, options) {
                // Iterate through existing children and update the watches if needed
                var parentWatcher = cache.get(dirPath);
                if (parentWatcher && host.directoryExists(dirName)) {
                    // Schedule the update and postpone invoke for callbacks
                    scheduleUpdateChildWatches(dirName, dirPath, options);
                    return;
                }
                // Call the actual callbacks and remove child watches
                invokeCallbacks(dirPath, fileName);
                removeChildWatches(parentWatcher);
            }
            function scheduleUpdateChildWatches(dirName, dirPath, options) {
                if (!cacheToUpdateChildWatches.has(dirPath)) {
                    cacheToUpdateChildWatches.set(dirPath, { dirName: dirName, options: options });
                }
                if (timerToUpdateChildWatches) {
                    host.clearTimeout(timerToUpdateChildWatches);
                    timerToUpdateChildWatches = undefined;
                }
                timerToUpdateChildWatches = host.setTimeout(onTimerToUpdateChildWatches, 1000);
            }
            function onTimerToUpdateChildWatches() {
                timerToUpdateChildWatches = undefined;
                ts.sysLog("sysLog:: onTimerToUpdateChildWatches:: " + cacheToUpdateChildWatches.size);
                var start = ts.timestamp();
                var invokeMap = ts.createMap();
                while (!timerToUpdateChildWatches && cacheToUpdateChildWatches.size) {
                    var _a = cacheToUpdateChildWatches.entries().next(), _b = _a.value, dirPath = _b[0], _c = _b[1], dirName = _c.dirName, options = _c.options, done = _a.done;
                    ts.Debug.assert(!done);
                    cacheToUpdateChildWatches.delete(dirPath);
                    // Because the child refresh is fresh, we would need to invalidate whole root directory being watched
                    // to ensure that all the changes are reflected at this time
                    invokeCallbacks(dirPath, invokeMap);
                    updateChildWatches(dirName, dirPath, options);
                }
                ts.sysLog("sysLog:: invokingWatchers:: " + (ts.timestamp() - start) + "ms:: " + cacheToUpdateChildWatches.size);
                callbackCache.forEach(function (callbacks, rootDirName) {
                    if (invokeMap.has(rootDirName)) {
                        callbacks.forEach(function (_a) {
                            var callback = _a.callback, dirName = _a.dirName;
                            return callback(dirName);
                        });
                    }
                });
                var elapsed = ts.timestamp() - start;
                ts.sysLog("sysLog:: Elapsed " + elapsed + "ms:: onTimerToUpdateChildWatches:: " + cacheToUpdateChildWatches.size + " " + timerToUpdateChildWatches);
            }
            function removeChildWatches(parentWatcher) {
                if (!parentWatcher)
                    return;
                var existingChildWatches = parentWatcher.childWatches;
                parentWatcher.childWatches = ts.emptyArray;
                for (var _i = 0, existingChildWatches_1 = existingChildWatches; _i < existingChildWatches_1.length; _i++) {
                    var childWatcher = existingChildWatches_1[_i];
                    childWatcher.close();
                    removeChildWatches(cache.get(toCanonicalFilePath(childWatcher.dirName)));
                }
            }
            function updateChildWatches(dirName, dirPath, options) {
                // Iterate through existing children and update the watches if needed
                var parentWatcher = cache.get(dirPath);
                if (parentWatcher) {
                    parentWatcher.childWatches = watchChildDirectories(dirName, parentWatcher.childWatches, options);
                }
            }
            /**
             * Watch the directories in the parentDir
             */
            function watchChildDirectories(parentDir, existingChildWatches, options) {
                var newChildWatches;
                ts.enumerateInsertsAndDeletes(host.directoryExists(parentDir) ? ts.mapDefined(host.getAccessibleSortedChildDirectories(parentDir), function (child) {
                    var childFullName = ts.getNormalizedAbsolutePath(child, parentDir);
                    // Filter our the symbolic link directories since those arent included in recursive watch
                    // which is same behaviour when recursive: true is passed to fs.watch
                    return !isIgnoredPath(childFullName) && filePathComparer(childFullName, ts.normalizePath(host.realpath(childFullName))) === 0 /* EqualTo */ ? childFullName : undefined;
                }) : ts.emptyArray, existingChildWatches, function (child, childWatcher) { return filePathComparer(child, childWatcher.dirName); }, createAndAddChildDirectoryWatcher, ts.closeFileWatcher, addChildDirectoryWatcher);
                return newChildWatches || ts.emptyArray;
                /**
                 * Create new childDirectoryWatcher and add it to the new ChildDirectoryWatcher list
                 */
                function createAndAddChildDirectoryWatcher(childName) {
                    var result = createDirectoryWatcher(childName, options);
                    addChildDirectoryWatcher(result);
                }
                /**
                 * Add child directory watcher to the new ChildDirectoryWatcher list
                 */
                function addChildDirectoryWatcher(childWatcher) {
                    (newChildWatches || (newChildWatches = [])).push(childWatcher);
                }
            }
            function isIgnoredPath(path) {
                return ts.some(ts.ignoredPaths, function (searchPath) { return isInPath(path, searchPath); });
            }
            function isInPath(path, searchPath) {
                if (ts.stringContains(path, searchPath))
                    return true;
                if (host.useCaseSensitiveFileNames)
                    return false;
                return ts.stringContains(toCanonicalFilePath(path), searchPath);
            }
        }
        ts.createDirectoryWatcherSupportingRecursive = createDirectoryWatcherSupportingRecursive;
        /*@internal*/
        var FileSystemEntryKind;
        (function (FileSystemEntryKind) {
            FileSystemEntryKind[FileSystemEntryKind["File"] = 0] = "File";
            FileSystemEntryKind[FileSystemEntryKind["Directory"] = 1] = "Directory";
        })(FileSystemEntryKind = ts.FileSystemEntryKind || (ts.FileSystemEntryKind = {}));
        /*@internal*/
        function createFileWatcherCallback(callback) {
            return function (_fileName, eventKind) { return callback(eventKind === FileWatcherEventKind.Changed ? "change" : "rename", ""); };
        }
        ts.createFileWatcherCallback = createFileWatcherCallback;
        function createFsWatchCallbackForFileWatcherCallback(fileName, callback, fileExists) {
            return function (eventName) {
                if (eventName === "rename") {
                    callback(fileName, fileExists(fileName) ? FileWatcherEventKind.Created : FileWatcherEventKind.Deleted);
                }
                else {
                    // Change
                    callback(fileName, FileWatcherEventKind.Changed);
                }
            };
        }
        function createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback) {
            return function (eventName, relativeFileName) {
                // In watchDirectory we only care about adding and removing files (when event name is
                // "rename"); changes made within files are handled by corresponding fileWatchers (when
                // event name is "change")
                if (eventName === "rename") {
                    // When deleting a file, the passed baseFileName is null
                    callback(!relativeFileName ? directoryName : ts.normalizePath(ts.combinePaths(directoryName, relativeFileName)));
                }
            };
        }
        /*@internal*/
        function createSystemWatchFunctions(_a) {
            var pollingWatchFile = _a.pollingWatchFile, getModifiedTime = _a.getModifiedTime, setTimeout = _a.setTimeout, clearTimeout = _a.clearTimeout, fsWatch = _a.fsWatch, fileExists = _a.fileExists, useCaseSensitiveFileNames = _a.useCaseSensitiveFileNames, fsSupportsRecursiveFsWatch = _a.fsSupportsRecursiveFsWatch, directoryExists = _a.directoryExists, getAccessibleSortedChildDirectories = _a.getAccessibleSortedChildDirectories, realpath = _a.realpath, tscWatchFile = _a.tscWatchFile, useNonPollingWatchers = _a.useNonPollingWatchers, tscWatchDirectory = _a.tscWatchDirectory;
            var dynamicPollingWatchFile;
            var nonPollingWatchFile;
            var hostRecursiveDirectoryWatcher;
            return {
                watchFile: watchFile,
                watchDirectory: watchDirectory
            };
            function watchFile(fileName, callback, pollingInterval, options) {
                options = updateOptionsForWatchFile(options, useNonPollingWatchers);
                var watchFileKind = ts.Debug.assertDefined(options.watchFile);
                switch (watchFileKind) {
                    case ts.WatchFileKind.FixedPollingInterval:
                        return pollingWatchFile(fileName, callback, PollingInterval.Low, /*options*/ undefined);
                    case ts.WatchFileKind.PriorityPollingInterval:
                        return pollingWatchFile(fileName, callback, pollingInterval, /*options*/ undefined);
                    case ts.WatchFileKind.DynamicPriorityPolling:
                        return ensureDynamicPollingWatchFile()(fileName, callback, pollingInterval, /*options*/ undefined);
                    case ts.WatchFileKind.UseFsEvents:
                        return fsWatch(fileName, 0 /* File */, createFsWatchCallbackForFileWatcherCallback(fileName, callback, fileExists), 
                        /*recursive*/ false, pollingInterval, ts.getFallbackOptions(options));
                    case ts.WatchFileKind.UseFsEventsOnParentDirectory:
                        if (!nonPollingWatchFile) {
                            nonPollingWatchFile = createUseFsEventsOnParentDirectoryWatchFile(fsWatch, useCaseSensitiveFileNames);
                        }
                        return nonPollingWatchFile(fileName, callback, pollingInterval, ts.getFallbackOptions(options));
                    default:
                        ts.Debug.assertNever(watchFileKind);
                }
            }
            function ensureDynamicPollingWatchFile() {
                return dynamicPollingWatchFile ||
                    (dynamicPollingWatchFile = createDynamicPriorityPollingWatchFile({ getModifiedTime: getModifiedTime, setTimeout: setTimeout }));
            }
            function updateOptionsForWatchFile(options, useNonPollingWatchers) {
                if (options && options.watchFile !== undefined)
                    return options;
                switch (tscWatchFile) {
                    case "PriorityPollingInterval":
                        // Use polling interval based on priority when create watch using host.watchFile
                        return { watchFile: ts.WatchFileKind.PriorityPollingInterval };
                    case "DynamicPriorityPolling":
                        // Use polling interval but change the interval depending on file changes and their default polling interval
                        return { watchFile: ts.WatchFileKind.DynamicPriorityPolling };
                    case "UseFsEvents":
                        // Use notifications from FS to watch with falling back to fs.watchFile
                        return generateWatchFileOptions(ts.WatchFileKind.UseFsEvents, ts.PollingWatchKind.PriorityInterval, options);
                    case "UseFsEventsWithFallbackDynamicPolling":
                        // Use notifications from FS to watch with falling back to dynamic watch file
                        return generateWatchFileOptions(ts.WatchFileKind.UseFsEvents, ts.PollingWatchKind.DynamicPriority, options);
                    case "UseFsEventsOnParentDirectory":
                        useNonPollingWatchers = true;
                    // fall through
                    default:
                        return useNonPollingWatchers ?
                            // Use notifications from FS to watch with falling back to fs.watchFile
                            generateWatchFileOptions(ts.WatchFileKind.UseFsEventsOnParentDirectory, ts.PollingWatchKind.PriorityInterval, options) :
                            // Default to do not use fixed polling interval
                            { watchFile: ts.WatchFileKind.FixedPollingInterval };
                }
            }
            function generateWatchFileOptions(watchFile, fallbackPolling, options) {
                var defaultFallbackPolling = options === null || options === void 0 ? void 0 : options.fallbackPolling;
                return {
                    watchFile: watchFile,
                    fallbackPolling: defaultFallbackPolling === undefined ?
                        fallbackPolling :
                        defaultFallbackPolling
                };
            }
            function watchDirectory(directoryName, callback, recursive, options) {
                if (fsSupportsRecursiveFsWatch) {
                    return fsWatch(directoryName, 1 /* Directory */, createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback), recursive, PollingInterval.Medium, ts.getFallbackOptions(options));
                }
                if (!hostRecursiveDirectoryWatcher) {
                    hostRecursiveDirectoryWatcher = createDirectoryWatcherSupportingRecursive({
                        useCaseSensitiveFileNames: useCaseSensitiveFileNames,
                        directoryExists: directoryExists,
                        getAccessibleSortedChildDirectories: getAccessibleSortedChildDirectories,
                        watchDirectory: nonRecursiveWatchDirectory,
                        realpath: realpath,
                        setTimeout: setTimeout,
                        clearTimeout: clearTimeout
                    });
                }
                return hostRecursiveDirectoryWatcher(directoryName, callback, recursive, options);
            }
            function nonRecursiveWatchDirectory(directoryName, callback, recursive, options) {
                ts.Debug.assert(!recursive);
                options = updateOptionsForWatchDirectory(options);
                var watchDirectoryKind = ts.Debug.assertDefined(options.watchDirectory);
                switch (watchDirectoryKind) {
                    case ts.WatchDirectoryKind.FixedPollingInterval:
                        return pollingWatchFile(directoryName, function () { return callback(directoryName); }, PollingInterval.Medium, 
                        /*options*/ undefined);
                    case ts.WatchDirectoryKind.DynamicPriorityPolling:
                        return ensureDynamicPollingWatchFile()(directoryName, function () { return callback(directoryName); }, PollingInterval.Medium, 
                        /*options*/ undefined);
                    case ts.WatchDirectoryKind.UseFsEvents:
                        return fsWatch(directoryName, 1 /* Directory */, createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback), recursive, PollingInterval.Medium, ts.getFallbackOptions(options));
                    default:
                        ts.Debug.assertNever(watchDirectoryKind);
                }
            }
            function updateOptionsForWatchDirectory(options) {
                if (options && options.watchDirectory !== undefined)
                    return options;
                switch (tscWatchDirectory) {
                    case "RecursiveDirectoryUsingFsWatchFile":
                        // Use polling interval based on priority when create watch using host.watchFile
                        return { watchDirectory: ts.WatchDirectoryKind.FixedPollingInterval };
                    case "RecursiveDirectoryUsingDynamicPriorityPolling":
                        // Use polling interval but change the interval depending on file changes and their default polling interval
                        return { watchDirectory: ts.WatchDirectoryKind.DynamicPriorityPolling };
                    default:
                        var defaultFallbackPolling = options === null || options === void 0 ? void 0 : options.fallbackPolling;
                        return {
                            watchDirectory: ts.WatchDirectoryKind.UseFsEvents,
                            fallbackPolling: defaultFallbackPolling !== undefined ?
                                defaultFallbackPolling :
                                undefined
                        };
                }
            }
        }
        ts.createSystemWatchFunctions = createSystemWatchFunctions;
        /**
         * patch writefile to create folder before writing the file
         */
        /*@internal*/
        function patchWriteFileEnsuringDirectory(sys) {
            // patch writefile to create folder before writing the file
            var originalWriteFile = sys.writeFile;
            sys.writeFile = function (path, data, writeBom) {
                return ts.writeFileEnsuringDirectories(path, data, !!writeBom, function (path, data, writeByteOrderMark) { return originalWriteFile.call(sys, path, data, writeByteOrderMark); }, function (path) { return sys.createDirectory(path); }, function (path) { return sys.directoryExists(path); });
            };
        }
        ts.patchWriteFileEnsuringDirectory = patchWriteFileEnsuringDirectory;
        function getNodeMajorVersion() {
            if (typeof process === "undefined") {
                return undefined;
            }
            var version = process.version;
            if (!version) {
                return undefined;
            }
            var dot = version.indexOf(".");
            if (dot === -1) {
                return undefined;
            }
            return parseInt(version.substring(1, dot));
        }
        ts.getNodeMajorVersion = getNodeMajorVersion;
        // TODO: GH#18217 this is used as if it's certainly defined in many places.
        // eslint-disable-next-line prefer-const
        ts.sys = (function () {
            // NodeJS detects "\uFEFF" at the start of the string and *replaces* it with the actual
            // byte order mark from the specified encoding. Using any other byte order mark does
            // not actually work.
            var byteOrderMarkIndicator = "\uFEFF";
            function getNodeSystem() {
                var nativePattern = /^native |^\([^)]+\)$|^(internal[\\/]|[a-zA-Z0-9_\s]+(\.js)?$)/;
                var _fs = require("fs");
                var _path = require("path");
                var _os = require("os");
                // crypto can be absent on reduced node installations
                var _crypto;
                try {
                    _crypto = require("crypto");
                }
                catch (_a) {
                    _crypto = undefined;
                }
                var activeSession;
                var profilePath = "./profile.cpuprofile";
                var Buffer = require("buffer").Buffer;
                var nodeVersion = getNodeMajorVersion();
                var isNode4OrLater = nodeVersion >= 4;
                var isLinuxOrMacOs = process.platform === "linux" || process.platform === "darwin";
                var platform = _os.platform();
                var useCaseSensitiveFileNames = isFileSystemCaseSensitive();
                var fsSupportsRecursiveFsWatch = isNode4OrLater && (process.platform === "win32" || process.platform === "darwin");
                var _b = createSystemWatchFunctions({
                    pollingWatchFile: createSingleFileWatcherPerName(fsWatchFileWorker, useCaseSensitiveFileNames),
                    getModifiedTime: getModifiedTime,
                    setTimeout: setTimeout,
                    clearTimeout: clearTimeout,
                    fsWatch: fsWatch,
                    useCaseSensitiveFileNames: useCaseSensitiveFileNames,
                    fileExists: fileExists,
                    // Node 4.0 `fs.watch` function supports the "recursive" option on both OSX and Windows
                    // (ref: https://github.com/nodejs/node/pull/2649 and https://github.com/Microsoft/TypeScript/issues/4643)
                    fsSupportsRecursiveFsWatch: fsSupportsRecursiveFsWatch,
                    directoryExists: directoryExists,
                    getAccessibleSortedChildDirectories: function (path) { return getAccessibleFileSystemEntries(path).directories; },
                    realpath: realpath,
                    tscWatchFile: process.env.TSC_WATCHFILE,
                    useNonPollingWatchers: process.env.TSC_NONPOLLING_WATCHER,
                    tscWatchDirectory: process.env.TSC_WATCHDIRECTORY,
                }), watchFile = _b.watchFile, watchDirectory = _b.watchDirectory;
                var nodeSystem = {
                    args: process.argv.slice(2),
                    newLine: _os.EOL,
                    useCaseSensitiveFileNames: useCaseSensitiveFileNames,
                    write: function (s) {
                        process.stdout.write(s);
                    },
                    writeOutputIsTTY: function () {
                        return process.stdout.isTTY;
                    },
                    readFile: readFile,
                    writeFile: writeFile,
                    watchFile: watchFile,
                    watchDirectory: watchDirectory,
                    resolvePath: function (path) { return _path.resolve(path); },
                    fileExists: fileExists,
                    directoryExists: directoryExists,
                    createDirectory: function (directoryName) {
                        if (!nodeSystem.directoryExists(directoryName)) {
                            // Wrapped in a try-catch to prevent crashing if we are in a race
                            // with another copy of ourselves to create the same directory
                            try {
                                _fs.mkdirSync(directoryName);
                            }
                            catch (e) {
                                if (e.code !== "EEXIST") {
                                    // Failed for some other reason (access denied?); still throw
                                    throw e;
                                }
                            }
                        }
                    },
                    getExecutingFilePath: function () {
                        return __filename;
                    },
                    getCurrentDirectory: function () {
                        return process.cwd();
                    },
                    getDirectories: getDirectories,
                    getEnvironmentVariable: function (name) {
                        return process.env[name] || "";
                    },
                    readDirectory: readDirectory,
                    getModifiedTime: getModifiedTime,
                    setModifiedTime: setModifiedTime,
                    deleteFile: deleteFile,
                    createHash: _crypto ? createSHA256Hash : generateDjb2Hash,
                    createSHA256Hash: _crypto ? createSHA256Hash : undefined,
                    getMemoryUsage: function () {
                        if (global.gc) {
                            global.gc();
                        }
                        return process.memoryUsage().heapUsed;
                    },
                    getFileSize: function (path) {
                        try {
                            var stat = _fs.statSync(path);
                            if (stat.isFile()) {
                                return stat.size;
                            }
                        }
                        catch ( /*ignore*/_a) { /*ignore*/ }
                        return 0;
                    },
                    exit: function (exitCode) {
                        disableCPUProfiler(function () { return process.exit(exitCode); });
                    },
                    enableCPUProfiler: enableCPUProfiler,
                    disableCPUProfiler: disableCPUProfiler,
                    realpath: realpath,
                    debugMode: ts.some(process.execArgv, function (arg) { return /^--(inspect|debug)(-brk)?(=\d+)?$/i.test(arg); }),
                    tryEnableSourceMapsForHost: function () {
                        try {
                            require(45) /* source-map-support */.install();
                        }
                        catch (_a) {
                            // Could not enable source maps.
                        }
                    },
                    setTimeout: setTimeout,
                    clearTimeout: clearTimeout,
                    clearScreen: function () {
                        process.stdout.write("\x1Bc");
                    },
                    setBlocking: function () {
                        if (process.stdout && process.stdout._handle && process.stdout._handle.setBlocking) {
                            process.stdout._handle.setBlocking(true);
                        }
                    },
                    bufferFrom: bufferFrom,
                    base64decode: function (input) { return bufferFrom(input, "base64").toString("utf8"); },
                    base64encode: function (input) { return bufferFrom(input).toString("base64"); },
                    require: function (baseDir, moduleName) {
                        try {
                            var modulePath = ts.resolveJSModule(moduleName, baseDir, nodeSystem);
                            return { module: require(modulePath), modulePath: modulePath, error: undefined };
                        }
                        catch (error) {
                            return { module: undefined, modulePath: undefined, error: error };
                        }
                    }
                };
                return nodeSystem;
                /**
                 * Uses the builtin inspector APIs to capture a CPU profile
                 * See https://nodejs.org/api/inspector.html#inspector_example_usage for details
                 */
                function enableCPUProfiler(path, cb) {
                    if (activeSession) {
                        cb();
                        return false;
                    }
                    var inspector = require("inspector");
                    if (!inspector || !inspector.Session) {
                        cb();
                        return false;
                    }
                    var session = new inspector.Session();
                    session.connect();
                    session.post("Profiler.enable", function () {
                        session.post("Profiler.start", function () {
                            activeSession = session;
                            profilePath = path;
                            cb();
                        });
                    });
                    return true;
                }
                /**
                 * Strips non-TS paths from the profile, so users with private projects shouldn't
                 * need to worry about leaking paths by submitting a cpu profile to us
                 */
                function cleanupPaths(profile) {
                    var externalFileCounter = 0;
                    var remappedPaths = ts.createMap();
                    var normalizedDir = ts.normalizeSlashes(__dirname);
                    // Windows rooted dir names need an extra `/` prepended to be valid file:/// urls
                    var fileUrlRoot = "file://" + (ts.getRootLength(normalizedDir) === 1 ? "" : "/") + normalizedDir;
                    for (var _i = 0, _a = profile.nodes; _i < _a.length; _i++) {
                        var node = _a[_i];
                        if (node.callFrame.url) {
                            var url = ts.normalizeSlashes(node.callFrame.url);
                            if (ts.containsPath(fileUrlRoot, url, useCaseSensitiveFileNames)) {
                                node.callFrame.url = ts.getRelativePathToDirectoryOrUrl(fileUrlRoot, url, fileUrlRoot, ts.createGetCanonicalFileName(useCaseSensitiveFileNames), /*isAbsolutePathAnUrl*/ true);
                            }
                            else if (!nativePattern.test(url)) {
                                node.callFrame.url = (remappedPaths.has(url) ? remappedPaths : remappedPaths.set(url, "external" + externalFileCounter + ".js")).get(url);
                                externalFileCounter++;
                            }
                        }
                    }
                    return profile;
                }
                function disableCPUProfiler(cb) {
                    if (activeSession && activeSession !== "stopping") {
                        var s_1 = activeSession;
                        activeSession.post("Profiler.stop", function (err, _a) {
                            var profile = _a.profile;
                            if (!err) {
                                try {
                                    if (_fs.statSync(profilePath).isDirectory()) {
                                        profilePath = _path.join(profilePath, (new Date()).toISOString().replace(/:/g, "-") + "+P" + process.pid + ".cpuprofile");
                                    }
                                }
                                catch (_b) {
                                    // do nothing and ignore fallible fs operation
                                }
                                try {
                                    _fs.mkdirSync(_path.dirname(profilePath), { recursive: true });
                                }
                                catch (_c) {
                                    // do nothing and ignore fallible fs operation
                                }
                                _fs.writeFileSync(profilePath, JSON.stringify(cleanupPaths(profile)));
                            }
                            activeSession = undefined;
                            s_1.disconnect();
                            cb();
                        });
                        activeSession = "stopping";
                        return true;
                    }
                    else {
                        cb();
                        return false;
                    }
                }
                function bufferFrom(input, encoding) {
                    // See https://github.com/Microsoft/TypeScript/issues/25652
                    return Buffer.from && Buffer.from !== Int8Array.from
                        ? Buffer.from(input, encoding)
                        : new Buffer(input, encoding);
                }
                function isFileSystemCaseSensitive() {
                    // win32\win64 are case insensitive platforms
                    if (platform === "win32" || platform === "win64") {
                        return false;
                    }
                    // If this file exists under a different case, we must be case-insensitve.
                    return !fileExists(swapCase(__filename));
                }
                /** Convert all lowercase chars to uppercase, and vice-versa */
                function swapCase(s) {
                    return s.replace(/\w/g, function (ch) {
                        var up = ch.toUpperCase();
                        return ch === up ? ch.toLowerCase() : up;
                    });
                }
                function fsWatchFileWorker(fileName, callback, pollingInterval) {
                    _fs.watchFile(fileName, { persistent: true, interval: pollingInterval }, fileChanged);
                    var eventKind;
                    return {
                        close: function () { return _fs.unwatchFile(fileName, fileChanged); }
                    };
                    function fileChanged(curr, prev) {
                        // previous event kind check is to ensure we recongnize the file as previously also missing when it is restored or renamed twice (that is it disappears and reappears)
                        // In such case, prevTime returned is same as prev time of event when file was deleted as per node documentation
                        var isPreviouslyDeleted = +prev.mtime === 0 || eventKind === FileWatcherEventKind.Deleted;
                        if (+curr.mtime === 0) {
                            if (isPreviouslyDeleted) {
                                // Already deleted file, no need to callback again
                                return;
                            }
                            eventKind = FileWatcherEventKind.Deleted;
                        }
                        else if (isPreviouslyDeleted) {
                            eventKind = FileWatcherEventKind.Created;
                        }
                        // If there is no change in modified time, ignore the event
                        else if (+curr.mtime === +prev.mtime) {
                            return;
                        }
                        else {
                            // File changed
                            eventKind = FileWatcherEventKind.Changed;
                        }
                        callback(fileName, eventKind);
                    }
                }
                function fsWatch(fileOrDirectory, entryKind, callback, recursive, fallbackPollingInterval, fallbackOptions) {
                    var options;
                    var lastDirectoryPartWithDirectorySeparator;
                    var lastDirectoryPart;
                    if (isLinuxOrMacOs) {
                        lastDirectoryPartWithDirectorySeparator = fileOrDirectory.substr(fileOrDirectory.lastIndexOf(ts.directorySeparator));
                        lastDirectoryPart = lastDirectoryPartWithDirectorySeparator.slice(ts.directorySeparator.length);
                    }
                    /** Watcher for the file system entry depending on whether it is missing or present */
                    var watcher = !fileSystemEntryExists(fileOrDirectory, entryKind) ?
                        watchMissingFileSystemEntry() :
                        watchPresentFileSystemEntry();
                    return {
                        close: function () {
                            // Close the watcher (either existing file system entry watcher or missing file system entry watcher)
                            watcher.close();
                            watcher = undefined;
                        }
                    };
                    /**
                     * Invoke the callback with rename and update the watcher if not closed
                     * @param createWatcher
                     */
                    function invokeCallbackAndUpdateWatcher(createWatcher) {
                        ts.sysLog("sysLog:: " + fileOrDirectory + ":: Changing watcher to " + (createWatcher === watchPresentFileSystemEntry ? "Present" : "Missing") + "FileSystemEntryWatcher");
                        // Call the callback for current directory
                        callback("rename", "");
                        // If watcher is not closed, update it
                        if (watcher) {
                            watcher.close();
                            watcher = createWatcher();
                        }
                    }
                    /**
                     * Watch the file or directory that is currently present
                     * and when the watched file or directory is deleted, switch to missing file system entry watcher
                     */
                    function watchPresentFileSystemEntry() {
                        // Node 4.0 `fs.watch` function supports the "recursive" option on both OSX and Windows
                        // (ref: https://github.com/nodejs/node/pull/2649 and https://github.com/Microsoft/TypeScript/issues/4643)
                        if (options === undefined) {
                            if (fsSupportsRecursiveFsWatch) {
                                options = { persistent: true, recursive: !!recursive };
                            }
                            else {
                                options = { persistent: true };
                            }
                        }
                        try {
                            var presentWatcher = _fs.watch(fileOrDirectory, options, isLinuxOrMacOs ?
                                callbackChangingToMissingFileSystemEntry :
                                callback);
                            // Watch the missing file or directory or error
                            presentWatcher.on("error", function () { return invokeCallbackAndUpdateWatcher(watchMissingFileSystemEntry); });
                            return presentWatcher;
                        }
                        catch (e) {
                            // Catch the exception and use polling instead
                            // Eg. on linux the number of watches are limited and one could easily exhaust watches and the exception ENOSPC is thrown when creating watcher at that point
                            // so instead of throwing error, use fs.watchFile
                            return watchPresentFileSystemEntryWithFsWatchFile();
                        }
                    }
                    function callbackChangingToMissingFileSystemEntry(event, relativeName) {
                        // because relativeName is not guaranteed to be correct we need to check on each rename with few combinations
                        // Eg on ubuntu while watching app/node_modules the relativeName is "node_modules" which is neither relative nor full path
                        return event === "rename" &&
                            (!relativeName ||
                                relativeName === lastDirectoryPart ||
                                relativeName.lastIndexOf(lastDirectoryPartWithDirectorySeparator) === relativeName.length - lastDirectoryPartWithDirectorySeparator.length) &&
                            !fileSystemEntryExists(fileOrDirectory, entryKind) ?
                            invokeCallbackAndUpdateWatcher(watchMissingFileSystemEntry) :
                            callback(event, relativeName);
                    }
                    /**
                     * Watch the file or directory using fs.watchFile since fs.watch threw exception
                     * Eg. on linux the number of watches are limited and one could easily exhaust watches and the exception ENOSPC is thrown when creating watcher at that point
                     */
                    function watchPresentFileSystemEntryWithFsWatchFile() {
                        ts.sysLog("sysLog:: " + fileOrDirectory + ":: Changing to fsWatchFile");
                        return watchFile(fileOrDirectory, createFileWatcherCallback(callback), fallbackPollingInterval, fallbackOptions);
                    }
                    /**
                     * Watch the file or directory that is missing
                     * and switch to existing file or directory when the missing filesystem entry is created
                     */
                    function watchMissingFileSystemEntry() {
                        return watchFile(fileOrDirectory, function (_fileName, eventKind) {
                            if (eventKind === FileWatcherEventKind.Created && fileSystemEntryExists(fileOrDirectory, entryKind)) {
                                // Call the callback for current file or directory
                                // For now it could be callback for the inner directory creation,
                                // but just return current directory, better than current no-op
                                invokeCallbackAndUpdateWatcher(watchPresentFileSystemEntry);
                            }
                        }, fallbackPollingInterval, fallbackOptions);
                    }
                }
                function readFileWorker(fileName, _encoding) {
                    var buffer;
                    try {
                        buffer = _fs.readFileSync(fileName);
                    }
                    catch (e) {
                        return undefined;
                    }
                    var len = buffer.length;
                    if (len >= 2 && buffer[0] === 0xFE && buffer[1] === 0xFF) {
                        // Big endian UTF-16 byte order mark detected. Since big endian is not supported by node.js,
                        // flip all byte pairs and treat as little endian.
                        len &= ~1; // Round down to a multiple of 2
                        for (var i = 0; i < len; i += 2) {
                            var temp = buffer[i];
                            buffer[i] = buffer[i + 1];
                            buffer[i + 1] = temp;
                        }
                        return buffer.toString("utf16le", 2);
                    }
                    if (len >= 2 && buffer[0] === 0xFF && buffer[1] === 0xFE) {
                        // Little endian UTF-16 byte order mark detected
                        return buffer.toString("utf16le", 2);
                    }
                    if (len >= 3 && buffer[0] === 0xEF && buffer[1] === 0xBB && buffer[2] === 0xBF) {
                        // UTF-8 byte order mark detected
                        return buffer.toString("utf8", 3);
                    }
                    // Default is UTF-8 with no byte order mark
                    return buffer.toString("utf8");
                }
                function readFile(fileName, _encoding) {
                    ts.perfLogger.logStartReadFile(fileName);
                    var file = readFileWorker(fileName, _encoding);
                    ts.perfLogger.logStopReadFile();
                    return file;
                }
                function writeFile(fileName, data, writeByteOrderMark) {
                    ts.perfLogger.logEvent("WriteFile: " + fileName);
                    // If a BOM is required, emit one
                    if (writeByteOrderMark) {
                        data = byteOrderMarkIndicator + data;
                    }
                    var fd;
                    try {
                        fd = _fs.openSync(fileName, "w");
                        _fs.writeSync(fd, data, /*position*/ undefined, "utf8");
                    }
                    finally {
                        if (fd !== undefined) {
                            _fs.closeSync(fd);
                        }
                    }
                }
                function getAccessibleFileSystemEntries(path) {
                    ts.perfLogger.logEvent("ReadDir: " + (path || "."));
                    try {
                        var entries = _fs.readdirSync(path || ".", { withFileTypes: true });
                        var files = [];
                        var directories = [];
                        for (var _i = 0, entries_2 = entries; _i < entries_2.length; _i++) {
                            var dirent = entries_2[_i];
                            // withFileTypes is not supported before Node 10.10.
                            var entry = typeof dirent === "string" ? dirent : dirent.name;
                            // This is necessary because on some file system node fails to exclude
                            // "." and "..". See https://github.com/nodejs/node/issues/4002
                            if (entry === "." || entry === "..") {
                                continue;
                            }
                            var stat = void 0;
                            if (typeof dirent === "string" || dirent.isSymbolicLink()) {
                                var name = ts.combinePaths(path, entry);
                                try {
                                    stat = _fs.statSync(name);
                                }
                                catch (e) {
                                    continue;
                                }
                            }
                            else {
                                stat = dirent;
                            }
                            if (stat.isFile()) {
                                files.push(entry);
                            }
                            else if (stat.isDirectory()) {
                                directories.push(entry);
                            }
                        }
                        files.sort();
                        directories.sort();
                        return { files: files, directories: directories };
                    }
                    catch (e) {
                        return ts.emptyFileSystemEntries;
                    }
                }
                function readDirectory(path, extensions, excludes, includes, depth) {
                    return ts.matchFiles(path, extensions, excludes, includes, useCaseSensitiveFileNames, process.cwd(), depth, getAccessibleFileSystemEntries, realpath);
                }
                function fileSystemEntryExists(path, entryKind) {
                    try {
                        var stat = _fs.statSync(path);
                        switch (entryKind) {
                            case 0 /* File */: return stat.isFile();
                            case 1 /* Directory */: return stat.isDirectory();
                            default: return false;
                        }
                    }
                    catch (e) {
                        return false;
                    }
                }
                function fileExists(path) {
                    return fileSystemEntryExists(path, 0 /* File */);
                }
                function directoryExists(path) {
                    return fileSystemEntryExists(path, 1 /* Directory */);
                }
                function getDirectories(path) {
                    return getAccessibleFileSystemEntries(path).directories.slice();
                }
                function realpath(path) {
                    try {
                        return _fs.realpathSync(path);
                    }
                    catch (_a) {
                        return path;
                    }
                }
                function getModifiedTime(path) {
                    try {
                        return _fs.statSync(path).mtime;
                    }
                    catch (e) {
                        return undefined;
                    }
                }
                function setModifiedTime(path, time) {
                    try {
                        _fs.utimesSync(path, time, time);
                    }
                    catch (e) {
                        return;
                    }
                }
                function deleteFile(path) {
                    try {
                        return _fs.unlinkSync(path);
                    }
                    catch (e) {
                        return;
                    }
                }
                function createSHA256Hash(data) {
                    var hash = _crypto.createHash("sha256");
                    hash.update(data);
                    return hash.digest("hex");
                }
            }
            function getChakraSystem() {
                var realpath = ChakraHost.realpath && (function (path) { return ChakraHost.realpath(path); });
                return {
                    newLine: ChakraHost.newLine || "\r\n",
                    args: ChakraHost.args,
                    useCaseSensitiveFileNames: !!ChakraHost.useCaseSensitiveFileNames,
                    write: ChakraHost.echo,
                    readFile: function (path, _encoding) {
                        // encoding is automatically handled by the implementation in ChakraHost
                        return ChakraHost.readFile(path);
                    },
                    writeFile: function (path, data, writeByteOrderMark) {
                        // If a BOM is required, emit one
                        if (writeByteOrderMark) {
                            data = byteOrderMarkIndicator + data;
                        }
                        ChakraHost.writeFile(path, data);
                    },
                    resolvePath: ChakraHost.resolvePath,
                    fileExists: ChakraHost.fileExists,
                    deleteFile: ChakraHost.deleteFile,
                    getModifiedTime: ChakraHost.getModifiedTime,
                    setModifiedTime: ChakraHost.setModifiedTime,
                    directoryExists: ChakraHost.directoryExists,
                    createDirectory: ChakraHost.createDirectory,
                    getExecutingFilePath: function () { return ChakraHost.executingFile; },
                    getCurrentDirectory: function () { return ChakraHost.currentDirectory; },
                    getDirectories: ChakraHost.getDirectories,
                    getEnvironmentVariable: ChakraHost.getEnvironmentVariable || (function () { return ""; }),
                    readDirectory: function (path, extensions, excludes, includes, _depth) {
                        var pattern = ts.getFileMatcherPatterns(path, excludes, includes, !!ChakraHost.useCaseSensitiveFileNames, ChakraHost.currentDirectory);
                        return ChakraHost.readDirectory(path, extensions, pattern.basePaths, pattern.excludePattern, pattern.includeFilePattern, pattern.includeDirectoryPattern);
                    },
                    exit: ChakraHost.quit,
                    realpath: realpath
                };
            }
            var sys;
            if (typeof ChakraHost !== "undefined") {
                sys = getChakraSystem();
            }
            else if (typeof process !== "undefined" && process.nextTick && !process.browser && typeof require !== "undefined") {
                // process and process.nextTick checks if current environment is node-like
                // process.browser check excludes webpack and browserify
                sys = getNodeSystem();
            }
            if (sys) {
                // patch writefile to create folder before writing the file
                patchWriteFileEnsuringDirectory(sys);
            }
            return sys;
        })();
        if (ts.sys && ts.sys.getEnvironmentVariable) {
            setCustomPollingValues(ts.sys);
            ts.Debug.currentAssertionLevel = /^development$/i.test(ts.sys.getEnvironmentVariable("NODE_ENV"))
                ? 1 /* Normal */
                : 0 /* None */;
        }
        if (ts.sys && ts.sys.debugMode) {
            ts.Debug.isDebugging = true;
        }
    })(ts || (ts = {}));
    /* @internal */
    var ts;
    (function (ts) {
        /**
         * Internally, we represent paths as strings with '/' as the directory separator.
         * When we make system calls (eg: LanguageServiceHost.getDirectory()),
         * we expect the host to correctly handle paths in our specified format.
         */
        ts.directorySeparator = "/";
        var altDirectorySeparator = "\\";
        var urlSchemeSeparator = "://";
        var backslashRegExp = /\\/g;
        //// Path Tests
        /**
         * Determines whether a charCode corresponds to `/` or `\`.
         */
        function isAnyDirectorySeparator(charCode) {
            return charCode === 47 /* slash */ || charCode === 92 /* backslash */;
        }
        ts.isAnyDirectorySeparator = isAnyDirectorySeparator;
        /**
         * Determines whether a path starts with a URL scheme (e.g. starts with `http://`, `ftp://`, `file://`, etc.).
         */
        function isUrl(path) {
            return getEncodedRootLength(path) < 0;
        }
        ts.isUrl = isUrl;
        /**
         * Determines whether a path is an absolute disk path (e.g. starts with `/`, or a dos path
         * like `c:`, `c:\` or `c:/`).
         */
        function isRootedDiskPath(path) {
            return getEncodedRootLength(path) > 0;
        }
        ts.isRootedDiskPath = isRootedDiskPath;
        /**
         * Determines whether a path consists only of a path root.
         */
        function isDiskPathRoot(path) {
            var rootLength = getEncodedRootLength(path);
            return rootLength > 0 && rootLength === path.length;
        }
        ts.isDiskPathRoot = isDiskPathRoot;
        /**
         * Determines whether a path starts with an absolute path component (i.e. `/`, `c:/`, `file://`, etc.).
         *
         * ```ts
         * // POSIX
         * pathIsAbsolute("/path/to/file.ext") === true
         * // DOS
         * pathIsAbsolute("c:/path/to/file.ext") === true
         * // URL
         * pathIsAbsolute("file:///path/to/file.ext") === true
         * // Non-absolute
         * pathIsAbsolute("path/to/file.ext") === false
         * pathIsAbsolute("./path/to/file.ext") === false
         * ```
         */
        function pathIsAbsolute(path) {
            return getEncodedRootLength(path) !== 0;
        }
        ts.pathIsAbsolute = pathIsAbsolute;
        /**
         * Determines whether a path starts with a relative path component (i.e. `.` or `..`).
         */
        function pathIsRelative(path) {
            return /^\.\.?($|[\\/])/.test(path);
        }
        ts.pathIsRelative = pathIsRelative;
        function hasExtension(fileName) {
            return ts.stringContains(getBaseFileName(fileName), ".");
        }
        ts.hasExtension = hasExtension;
        function fileExtensionIs(path, extension) {
            return path.length > extension.length && ts.endsWith(path, extension);
        }
        ts.fileExtensionIs = fileExtensionIs;
        function fileExtensionIsOneOf(path, extensions) {
            for (var _i = 0, extensions_1 = extensions; _i < extensions_1.length; _i++) {
                var extension = extensions_1[_i];
                if (fileExtensionIs(path, extension)) {
                    return true;
                }
            }
            return false;
        }
        ts.fileExtensionIsOneOf = fileExtensionIsOneOf;
        /**
         * Determines whether a path has a trailing separator (`/` or `\\`).
         */
        function hasTrailingDirectorySeparator(path) {
            return path.length > 0 && isAnyDirectorySeparator(path.charCodeAt(path.length - 1));
        }
        ts.hasTrailingDirectorySeparator = hasTrailingDirectorySeparator;
        //// Path Parsing
        function isVolumeCharacter(charCode) {
            return (charCode >= 97 /* a */ && charCode <= 122 /* z */) ||
                (charCode >= 65 /* A */ && charCode <= 90 /* Z */);
        }
        function getFileUrlVolumeSeparatorEnd(url, start) {
            var ch0 = url.charCodeAt(start);
            if (ch0 === 58 /* colon */)
                return start + 1;
            if (ch0 === 37 /* percent */ && url.charCodeAt(start + 1) === 51 /* _3 */) {
                var ch2 = url.charCodeAt(start + 2);
                if (ch2 === 97 /* a */ || ch2 === 65 /* A */)
                    return start + 3;
            }
            return -1;
        }
        /**
         * Returns length of the root part of a path or URL (i.e. length of "/", "x:/", "//server/share/, file:///user/files").
         * If the root is part of a URL, the twos-complement of the root length is returned.
         */
        function getEncodedRootLength(path) {
            if (!path)
                return 0;
            var ch0 = path.charCodeAt(0);
            // POSIX or UNC
            if (ch0 === 47 /* slash */ || ch0 === 92 /* backslash */) {
                if (path.charCodeAt(1) !== ch0)
                    return 1; // POSIX: "/" (or non-normalized "\")
                var p1 = path.indexOf(ch0 === 47 /* slash */ ? ts.directorySeparator : altDirectorySeparator, 2);
                if (p1 < 0)
                    return path.length; // UNC: "//server" or "\\server"
                return p1 + 1; // UNC: "//server/" or "\\server\"
            }
            // DOS
            if (isVolumeCharacter(ch0) && path.charCodeAt(1) === 58 /* colon */) {
                var ch2 = path.charCodeAt(2);
                if (ch2 === 47 /* slash */ || ch2 === 92 /* backslash */)
                    return 3; // DOS: "c:/" or "c:\"
                if (path.length === 2)
                    return 2; // DOS: "c:" (but not "c:d")
            }
            // URL
            var schemeEnd = path.indexOf(urlSchemeSeparator);
            if (schemeEnd !== -1) {
                var authorityStart = schemeEnd + urlSchemeSeparator.length;
                var authorityEnd = path.indexOf(ts.directorySeparator, authorityStart);
                if (authorityEnd !== -1) { // URL: "file:///", "file://server/", "file://server/path"
                    // For local "file" URLs, include the leading DOS volume (if present).
                    // Per https://www.ietf.org/rfc/rfc1738.txt, a host of "" or "localhost" is a
                    // special case interpreted as "the machine from which the URL is being interpreted".
                    var scheme = path.slice(0, schemeEnd);
                    var authority = path.slice(authorityStart, authorityEnd);
                    if (scheme === "file" && (authority === "" || authority === "localhost") &&
                        isVolumeCharacter(path.charCodeAt(authorityEnd + 1))) {
                        var volumeSeparatorEnd = getFileUrlVolumeSeparatorEnd(path, authorityEnd + 2);
                        if (volumeSeparatorEnd !== -1) {
                            if (path.charCodeAt(volumeSeparatorEnd) === 47 /* slash */) {
                                // URL: "file:///c:/", "file://localhost/c:/", "file:///c%3a/", "file://localhost/c%3a/"
                                return ~(volumeSeparatorEnd + 1);
                            }
                            if (volumeSeparatorEnd === path.length) {
                                // URL: "file:///c:", "file://localhost/c:", "file:///c$3a", "file://localhost/c%3a"
                                // but not "file:///c:d" or "file:///c%3ad"
                                return ~volumeSeparatorEnd;
                            }
                        }
                    }
                    return ~(authorityEnd + 1); // URL: "file://server/", "http://server/"
                }
                return ~path.length; // URL: "file://server", "http://server"
            }
            // relative
            return 0;
        }
        /**
         * Returns length of the root part of a path or URL (i.e. length of "/", "x:/", "//server/share/, file:///user/files").
         *
         * For example:
         * ```ts
         * getRootLength("a") === 0                   // ""
         * getRootLength("/") === 1                   // "/"
         * getRootLength("c:") === 2                  // "c:"
         * getRootLength("c:d") === 0                 // ""
         * getRootLength("c:/") === 3                 // "c:/"
         * getRootLength("c:\\") === 3                // "c:\\"
         * getRootLength("//server") === 7            // "//server"
         * getRootLength("//server/share") === 8      // "//server/"
         * getRootLength("\\\\server") === 7          // "\\\\server"
         * getRootLength("\\\\server\\share") === 8   // "\\\\server\\"
         * getRootLength("file:///path") === 8        // "file:///"
         * getRootLength("file:///c:") === 10         // "file:///c:"
         * getRootLength("file:///c:d") === 8         // "file:///"
         * getRootLength("file:///c:/path") === 11    // "file:///c:/"
         * getRootLength("file://server") === 13      // "file://server"
         * getRootLength("file://server/path") === 14 // "file://server/"
         * getRootLength("http://server") === 13      // "http://server"
         * getRootLength("http://server/path") === 14 // "http://server/"
         * ```
         */
        function getRootLength(path) {
            var rootLength = getEncodedRootLength(path);
            return rootLength < 0 ? ~rootLength : rootLength;
        }
        ts.getRootLength = getRootLength;
        function getDirectoryPath(path) {
            path = normalizeSlashes(path);
            // If the path provided is itself the root, then return it.
            var rootLength = getRootLength(path);
            if (rootLength === path.length)
                return path;
            // return the leading portion of the path up to the last (non-terminal) directory separator
            // but not including any trailing directory separator.
            path = removeTrailingDirectorySeparator(path);
            return path.slice(0, Math.max(rootLength, path.lastIndexOf(ts.directorySeparator)));
        }
        ts.getDirectoryPath = getDirectoryPath;
        function getBaseFileName(path, extensions, ignoreCase) {
            path = normalizeSlashes(path);
            // if the path provided is itself the root, then it has not file name.
            var rootLength = getRootLength(path);
            if (rootLength === path.length)
                return "";
            // return the trailing portion of the path starting after the last (non-terminal) directory
            // separator but not including any trailing directory separator.
            path = removeTrailingDirectorySeparator(path);
            var name = path.slice(Math.max(getRootLength(path), path.lastIndexOf(ts.directorySeparator) + 1));
            var extension = extensions !== undefined && ignoreCase !== undefined ? getAnyExtensionFromPath(name, extensions, ignoreCase) : undefined;
            return extension ? name.slice(0, name.length - extension.length) : name;
        }
        ts.getBaseFileName = getBaseFileName;
        function tryGetExtensionFromPath(path, extension, stringEqualityComparer) {
            if (!ts.startsWith(extension, "."))
                extension = "." + extension;
            if (path.length >= extension.length && path.charCodeAt(path.length - extension.length) === 46 /* dot */) {
                var pathExtension = path.slice(path.length - extension.length);
                if (stringEqualityComparer(pathExtension, extension)) {
                    return pathExtension;
                }
            }
        }
        function getAnyExtensionFromPathWorker(path, extensions, stringEqualityComparer) {
            if (typeof extensions === "string") {
                return tryGetExtensionFromPath(path, extensions, stringEqualityComparer) || "";
            }
            for (var _i = 0, extensions_2 = extensions; _i < extensions_2.length; _i++) {
                var extension = extensions_2[_i];
                var result = tryGetExtensionFromPath(path, extension, stringEqualityComparer);
                if (result)
                    return result;
            }
            return "";
        }
        function getAnyExtensionFromPath(path, extensions, ignoreCase) {
            // Retrieves any string from the final "." onwards from a base file name.
            // Unlike extensionFromPath, which throws an exception on unrecognized extensions.
            if (extensions) {
                return getAnyExtensionFromPathWorker(removeTrailingDirectorySeparator(path), extensions, ignoreCase ? ts.equateStringsCaseInsensitive : ts.equateStringsCaseSensitive);
            }
            var baseFileName = getBaseFileName(path);
            var extensionIndex = baseFileName.lastIndexOf(".");
            if (extensionIndex >= 0) {
                return baseFileName.substring(extensionIndex);
            }
            return "";
        }
        ts.getAnyExtensionFromPath = getAnyExtensionFromPath;
        function pathComponents(path, rootLength) {
            var root = path.substring(0, rootLength);
            var rest = path.substring(rootLength).split(ts.directorySeparator);
            if (rest.length && !ts.lastOrUndefined(rest))
                rest.pop();
            return __spreadArrays([root], rest);
        }
        /**
         * Parse a path into an array containing a root component (at index 0) and zero or more path
         * components (at indices > 0). The result is not normalized.
         * If the path is relative, the root component is `""`.
         * If the path is absolute, the root component includes the first path separator (`/`).
         *
         * ```ts
         * // POSIX
         * getPathComponents("/path/to/file.ext") === ["/", "path", "to", "file.ext"]
         * getPathComponents("/path/to/") === ["/", "path", "to"]
         * getPathComponents("/") === ["/"]
         * // DOS
         * getPathComponents("c:/path/to/file.ext") === ["c:/", "path", "to", "file.ext"]
         * getPathComponents("c:/path/to/") === ["c:/", "path", "to"]
         * getPathComponents("c:/") === ["c:/"]
         * getPathComponents("c:") === ["c:"]
         * // URL
         * getPathComponents("http://typescriptlang.org/path/to/file.ext") === ["http://typescriptlang.org/", "path", "to", "file.ext"]
         * getPathComponents("http://typescriptlang.org/path/to/") === ["http://typescriptlang.org/", "path", "to"]
         * getPathComponents("http://typescriptlang.org/") === ["http://typescriptlang.org/"]
         * getPathComponents("http://typescriptlang.org") === ["http://typescriptlang.org"]
         * getPathComponents("file://server/path/to/file.ext") === ["file://server/", "path", "to", "file.ext"]
         * getPathComponents("file://server/path/to/") === ["file://server/", "path", "to"]
         * getPathComponents("file://server/") === ["file://server/"]
         * getPathComponents("file://server") === ["file://server"]
         * getPathComponents("file:///path/to/file.ext") === ["file:///", "path", "to", "file.ext"]
         * getPathComponents("file:///path/to/") === ["file:///", "path", "to"]
         * getPathComponents("file:///") === ["file:///"]
         * getPathComponents("file://") === ["file://"]
         */
        function getPathComponents(path, currentDirectory) {
            if (currentDirectory === void 0) {
                currentDirectory = "";
            }
            path = combinePaths(currentDirectory, path);
            return pathComponents(path, getRootLength(path));
        }
        ts.getPathComponents = getPathComponents;
        //// Path Formatting
        /**
         * Formats a parsed path consisting of a root component (at index 0) and zero or more path
         * segments (at indices > 0).
         *
         * ```ts
         * getPathFromPathComponents(["/", "path", "to", "file.ext"]) === "/path/to/file.ext"
         * ```
         */
        function getPathFromPathComponents(pathComponents) {
            if (pathComponents.length === 0)
                return "";
            var root = pathComponents[0] && ensureTrailingDirectorySeparator(pathComponents[0]);
            return root + pathComponents.slice(1).join(ts.directorySeparator);
        }
        ts.getPathFromPathComponents = getPathFromPathComponents;
        //// Path Normalization
        /**
         * Normalize path separators, converting `\` into `/`.
         */
        function normalizeSlashes(path) {
            return path.replace(backslashRegExp, ts.directorySeparator);
        }
        ts.normalizeSlashes = normalizeSlashes;
        /**
         * Reduce an array of path components to a more simplified path by navigating any
         * `"."` or `".."` entries in the path.
         */
        function reducePathComponents(components) {
            if (!ts.some(components))
                return [];
            var reduced = [components[0]];
            for (var i = 1; i < components.length; i++) {
                var component = components[i];
                if (!component)
                    continue;
                if (component === ".")
                    continue;
                if (component === "..") {
                    if (reduced.length > 1) {
                        if (reduced[reduced.length - 1] !== "..") {
                            reduced.pop();
                            continue;
                        }
                    }
                    else if (reduced[0])
                        continue;
                }
                reduced.push(component);
            }
            return reduced;
        }
        ts.reducePathComponents = reducePathComponents;
        /**
         * Combines paths. If a path is absolute, it replaces any previous path. Relative paths are not simplified.
         *
         * ```ts
         * // Non-rooted
         * combinePaths("path", "to", "file.ext") === "path/to/file.ext"
         * combinePaths("path", "dir", "..", "to", "file.ext") === "path/dir/../to/file.ext"
         * // POSIX
         * combinePaths("/path", "to", "file.ext") === "/path/to/file.ext"
         * combinePaths("/path", "/to", "file.ext") === "/to/file.ext"
         * // DOS
         * combinePaths("c:/path", "to", "file.ext") === "c:/path/to/file.ext"
         * combinePaths("c:/path", "c:/to", "file.ext") === "c:/to/file.ext"
         * // URL
         * combinePaths("file:///path", "to", "file.ext") === "file:///path/to/file.ext"
         * combinePaths("file:///path", "file:///to", "file.ext") === "file:///to/file.ext"
         * ```
         */
        function combinePaths(path) {
            var paths = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                paths[_i - 1] = arguments[_i];
            }
            if (path)
                path = normalizeSlashes(path);
            for (var _a = 0, paths_1 = paths; _a < paths_1.length; _a++) {
                var relativePath = paths_1[_a];
                if (!relativePath)
                    continue;
                relativePath = normalizeSlashes(relativePath);
                if (!path || getRootLength(relativePath) !== 0) {
                    path = relativePath;
                }
                else {
                    path = ensureTrailingDirectorySeparator(path) + relativePath;
                }
            }
            return path;
        }
        ts.combinePaths = combinePaths;
        /**
         * Combines and resolves paths. If a path is absolute, it replaces any previous path. Any
         * `.` and `..` path components are resolved. Trailing directory separators are preserved.
         *
         * ```ts
         * resolvePath("/path", "to", "file.ext") === "path/to/file.ext"
         * resolvePath("/path", "to", "file.ext/") === "path/to/file.ext/"
         * resolvePath("/path", "dir", "..", "to", "file.ext") === "path/to/file.ext"
         * ```
         */
        function resolvePath(path) {
            var paths = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                paths[_i - 1] = arguments[_i];
            }
            return normalizePath(ts.some(paths) ? combinePaths.apply(void 0, __spreadArrays([path], paths)) : normalizeSlashes(path));
        }
        ts.resolvePath = resolvePath;
        /**
         * Parse a path into an array containing a root component (at index 0) and zero or more path
         * components (at indices > 0). The result is normalized.
         * If the path is relative, the root component is `""`.
         * If the path is absolute, the root component includes the first path separator (`/`).
         *
         * ```ts
         * getNormalizedPathComponents("to/dir/../file.ext", "/path/") === ["/", "path", "to", "file.ext"]
         */
        function getNormalizedPathComponents(path, currentDirectory) {
            return reducePathComponents(getPathComponents(path, currentDirectory));
        }
        ts.getNormalizedPathComponents = getNormalizedPathComponents;
        function getNormalizedAbsolutePath(fileName, currentDirectory) {
            return getPathFromPathComponents(getNormalizedPathComponents(fileName, currentDirectory));
        }
        ts.getNormalizedAbsolutePath = getNormalizedAbsolutePath;
        function normalizePath(path) {
            path = normalizeSlashes(path);
            var normalized = getPathFromPathComponents(reducePathComponents(getPathComponents(path)));
            return normalized && hasTrailingDirectorySeparator(path) ? ensureTrailingDirectorySeparator(normalized) : normalized;
        }
        ts.normalizePath = normalizePath;
        function getPathWithoutRoot(pathComponents) {
            if (pathComponents.length === 0)
                return "";
            return pathComponents.slice(1).join(ts.directorySeparator);
        }
        function getNormalizedAbsolutePathWithoutRoot(fileName, currentDirectory) {
            return getPathWithoutRoot(getNormalizedPathComponents(fileName, currentDirectory));
        }
        ts.getNormalizedAbsolutePathWithoutRoot = getNormalizedAbsolutePathWithoutRoot;
        function toPath(fileName, basePath, getCanonicalFileName) {
            var nonCanonicalizedPath = isRootedDiskPath(fileName)
                ? normalizePath(fileName)
                : getNormalizedAbsolutePath(fileName, basePath);
            return getCanonicalFileName(nonCanonicalizedPath);
        }
        ts.toPath = toPath;
        function normalizePathAndParts(path) {
            path = normalizeSlashes(path);
            var _a = reducePathComponents(getPathComponents(path)), root = _a[0], parts = _a.slice(1);
            if (parts.length) {
                var joinedParts = root + parts.join(ts.directorySeparator);
                return { path: hasTrailingDirectorySeparator(path) ? ensureTrailingDirectorySeparator(joinedParts) : joinedParts, parts: parts };
            }
            else {
                return { path: root, parts: parts };
            }
        }
        ts.normalizePathAndParts = normalizePathAndParts;
        function removeTrailingDirectorySeparator(path) {
            if (hasTrailingDirectorySeparator(path)) {
                return path.substr(0, path.length - 1);
            }
            return path;
        }
        ts.removeTrailingDirectorySeparator = removeTrailingDirectorySeparator;
        function ensureTrailingDirectorySeparator(path) {
            if (!hasTrailingDirectorySeparator(path)) {
                return path + ts.directorySeparator;
            }
            return path;
        }
        ts.ensureTrailingDirectorySeparator = ensureTrailingDirectorySeparator;
        /**
         * Ensures a path is either absolute (prefixed with `/` or `c:`) or dot-relative (prefixed
         * with `./` or `../`) so as not to be confused with an unprefixed module name.
         *
         * ```ts
         * ensurePathIsNonModuleName("/path/to/file.ext") === "/path/to/file.ext"
         * ensurePathIsNonModuleName("./path/to/file.ext") === "./path/to/file.ext"
         * ensurePathIsNonModuleName("../path/to/file.ext") === "../path/to/file.ext"
         * ensurePathIsNonModuleName("path/to/file.ext") === "./path/to/file.ext"
         * ```
         */
        function ensurePathIsNonModuleName(path) {
            return !pathIsAbsolute(path) && !pathIsRelative(path) ? "./" + path : path;
        }
        ts.ensurePathIsNonModuleName = ensurePathIsNonModuleName;
        function changeAnyExtension(path, ext, extensions, ignoreCase) {
            var pathext = extensions !== undefined && ignoreCase !== undefined ? getAnyExtensionFromPath(path, extensions, ignoreCase) : getAnyExtensionFromPath(path);
            return pathext ? path.slice(0, path.length - pathext.length) + (ts.startsWith(ext, ".") ? ext : "." + ext) : path;
        }
        ts.changeAnyExtension = changeAnyExtension;
        //// Path Comparisons
        // check path for these segments: '', '.'. '..'
        var relativePathSegmentRegExp = /(^|\/)\.{0,2}($|\/)/;
        function comparePathsWorker(a, b, componentComparer) {
            if (a === b)
                return 0 /* EqualTo */;
            if (a === undefined)
                return -1 /* LessThan */;
            if (b === undefined)
                return 1 /* GreaterThan */;
            // NOTE: Performance optimization - shortcut if the root segments differ as there would be no
            //       need to perform path reduction.
            var aRoot = a.substring(0, getRootLength(a));
            var bRoot = b.substring(0, getRootLength(b));
            var result = ts.compareStringsCaseInsensitive(aRoot, bRoot);
            if (result !== 0 /* EqualTo */) {
                return result;
            }
            // NOTE: Performance optimization - shortcut if there are no relative path segments in
            //       the non-root portion of the path
            var aRest = a.substring(aRoot.length);
            var bRest = b.substring(bRoot.length);
            if (!relativePathSegmentRegExp.test(aRest) && !relativePathSegmentRegExp.test(bRest)) {
                return componentComparer(aRest, bRest);
            }
            // The path contains a relative path segment. Normalize the paths and perform a slower component
            // by component comparison.
            var aComponents = reducePathComponents(getPathComponents(a));
            var bComponents = reducePathComponents(getPathComponents(b));
            var sharedLength = Math.min(aComponents.length, bComponents.length);
            for (var i = 1; i < sharedLength; i++) {
                var result_1 = componentComparer(aComponents[i], bComponents[i]);
                if (result_1 !== 0 /* EqualTo */) {
                    return result_1;
                }
            }
            return ts.compareValues(aComponents.length, bComponents.length);
        }
        /**
         * Performs a case-sensitive comparison of two paths. Path roots are always compared case-insensitively.
         */
        function comparePathsCaseSensitive(a, b) {
            return comparePathsWorker(a, b, ts.compareStringsCaseSensitive);
        }
        ts.comparePathsCaseSensitive = comparePathsCaseSensitive;
        /**
         * Performs a case-insensitive comparison of two paths.
         */
        function comparePathsCaseInsensitive(a, b) {
            return comparePathsWorker(a, b, ts.compareStringsCaseInsensitive);
        }
        ts.comparePathsCaseInsensitive = comparePathsCaseInsensitive;
        function comparePaths(a, b, currentDirectory, ignoreCase) {
            if (typeof currentDirectory === "string") {
                a = combinePaths(currentDirectory, a);
                b = combinePaths(currentDirectory, b);
            }
            else if (typeof currentDirectory === "boolean") {
                ignoreCase = currentDirectory;
            }
            return comparePathsWorker(a, b, ts.getStringComparer(ignoreCase));
        }
        ts.comparePaths = comparePaths;
        function containsPath(parent, child, currentDirectory, ignoreCase) {
            if (typeof currentDirectory === "string") {
                parent = combinePaths(currentDirectory, parent);
                child = combinePaths(currentDirectory, child);
            }
            else if (typeof currentDirectory === "boolean") {
                ignoreCase = currentDirectory;
            }
            if (parent === undefined || child === undefined)
                return false;
            if (parent === child)
                return true;
            var parentComponents = reducePathComponents(getPathComponents(parent));
            var childComponents = reducePathComponents(getPathComponents(child));
            if (childComponents.length < parentComponents.length) {
                return false;
            }
            var componentEqualityComparer = ignoreCase ? ts.equateStringsCaseInsensitive : ts.equateStringsCaseSensitive;
            for (var i = 0; i < parentComponents.length; i++) {
                var equalityComparer = i === 0 ? ts.equateStringsCaseInsensitive : componentEqualityComparer;
                if (!equalityComparer(parentComponents[i], childComponents[i])) {
                    return false;
                }
            }
            return true;
        }
        ts.containsPath = containsPath;
        /**
         * Determines whether `fileName` starts with the specified `directoryName` using the provided path canonicalization callback.
         * Comparison is case-sensitive between the canonical paths.
         *
         * @deprecated Use `containsPath` if possible.
         */
        function startsWithDirectory(fileName, directoryName, getCanonicalFileName) {
            var canonicalFileName = getCanonicalFileName(fileName);
            var canonicalDirectoryName = getCanonicalFileName(directoryName);
            return ts.startsWith(canonicalFileName, canonicalDirectoryName + "/") || ts.startsWith(canonicalFileName, canonicalDirectoryName + "\\");
        }
        ts.startsWithDirectory = startsWithDirectory;
        //// Relative Paths
        function getPathComponentsRelativeTo(from, to, stringEqualityComparer, getCanonicalFileName) {
            var fromComponents = reducePathComponents(getPathComponents(from));
            var toComponents = reducePathComponents(getPathComponents(to));
            var start;
            for (start = 0; start < fromComponents.length && start < toComponents.length; start++) {
                var fromComponent = getCanonicalFileName(fromComponents[start]);
                var toComponent = getCanonicalFileName(toComponents[start]);
                var comparer = start === 0 ? ts.equateStringsCaseInsensitive : stringEqualityComparer;
                if (!comparer(fromComponent, toComponent))
                    break;
            }
            if (start === 0) {
                return toComponents;
            }
            var components = toComponents.slice(start);
            var relative = [];
            for (; start < fromComponents.length; start++) {
                relative.push("..");
            }
            return __spreadArrays([""], relative, components);
        }
        ts.getPathComponentsRelativeTo = getPathComponentsRelativeTo;
        function getRelativePathFromDirectory(fromDirectory, to, getCanonicalFileNameOrIgnoreCase) {
            ts.Debug.assert((getRootLength(fromDirectory) > 0) === (getRootLength(to) > 0), "Paths must either both be absolute or both be relative");
            var getCanonicalFileName = typeof getCanonicalFileNameOrIgnoreCase === "function" ? getCanonicalFileNameOrIgnoreCase : ts.identity;
            var ignoreCase = typeof getCanonicalFileNameOrIgnoreCase === "boolean" ? getCanonicalFileNameOrIgnoreCase : false;
            var pathComponents = getPathComponentsRelativeTo(fromDirectory, to, ignoreCase ? ts.equateStringsCaseInsensitive : ts.equateStringsCaseSensitive, getCanonicalFileName);
            return getPathFromPathComponents(pathComponents);
        }
        ts.getRelativePathFromDirectory = getRelativePathFromDirectory;
        function convertToRelativePath(absoluteOrRelativePath, basePath, getCanonicalFileName) {
            return !isRootedDiskPath(absoluteOrRelativePath)
                ? absoluteOrRelativePath
                : getRelativePathToDirectoryOrUrl(basePath, absoluteOrRelativePath, basePath, getCanonicalFileName, /*isAbsolutePathAnUrl*/ false);
        }
        ts.convertToRelativePath = convertToRelativePath;
        function getRelativePathFromFile(from, to, getCanonicalFileName) {
            return ensurePathIsNonModuleName(getRelativePathFromDirectory(getDirectoryPath(from), to, getCanonicalFileName));
        }
        ts.getRelativePathFromFile = getRelativePathFromFile;
        function getRelativePathToDirectoryOrUrl(directoryPathOrUrl, relativeOrAbsolutePath, currentDirectory, getCanonicalFileName, isAbsolutePathAnUrl) {
            var pathComponents = getPathComponentsRelativeTo(resolvePath(currentDirectory, directoryPathOrUrl), resolvePath(currentDirectory, relativeOrAbsolutePath), ts.equateStringsCaseSensitive, getCanonicalFileName);
            var firstComponent = pathComponents[0];
            if (isAbsolutePathAnUrl && isRootedDiskPath(firstComponent)) {
                var prefix = firstComponent.charAt(0) === ts.directorySeparator ? "file://" : "file:///";
                pathComponents[0] = prefix + firstComponent;
            }
            return getPathFromPathComponents(pathComponents);
        }
        ts.getRelativePathToDirectoryOrUrl = getRelativePathToDirectoryOrUrl;
        function forEachAncestorDirectory(directory, callback) {
            while (true) {
                var result = callback(directory);
                if (result !== undefined) {
                    return result;
                }
                var parentPath = getDirectoryPath(directory);
                if (parentPath === directory) {
                    return undefined;
                }
                directory = parentPath;
            }
        }
        ts.forEachAncestorDirectory = forEachAncestorDirectory;
    })(ts || (ts = {}));
    // <auto-generated />
    // generated from './diagnosticInformationMap.generated.ts' by 'src/compiler'
    /* @internal */
    var ts;
    (function (ts) {
        function diag(code, category, key, message, reportsUnnecessary, elidedInCompatabilityPyramid) {
            return { code: code, category: category, key: key, message: message, reportsUnnecessary: reportsUnnecessary, elidedInCompatabilityPyramid: elidedInCompatabilityPyramid };
        }
        ts.Diagnostics = {
            Unterminated_string_literal: diag(1002, ts.DiagnosticCategory.Error, "Unterminated_string_literal_1002", "Unterminated string literal."),
            Identifier_expected: diag(1003, ts.DiagnosticCategory.Error, "Identifier_expected_1003", "Identifier expected."),
            _0_expected: diag(1005, ts.DiagnosticCategory.Error, "_0_expected_1005", "'{0}' expected."),
            A_file_cannot_have_a_reference_to_itself: diag(1006, ts.DiagnosticCategory.Error, "A_file_cannot_have_a_reference_to_itself_1006", "A file cannot have a reference to itself."),
            The_parser_expected_to_find_a_to_match_the_token_here: diag(1007, ts.DiagnosticCategory.Error, "The_parser_expected_to_find_a_to_match_the_token_here_1007", "The parser expected to find a '}' to match the '{' token here."),
            Trailing_comma_not_allowed: diag(1009, ts.DiagnosticCategory.Error, "Trailing_comma_not_allowed_1009", "Trailing comma not allowed."),
            Asterisk_Slash_expected: diag(1010, ts.DiagnosticCategory.Error, "Asterisk_Slash_expected_1010", "'*/' expected."),
            An_element_access_expression_should_take_an_argument: diag(1011, ts.DiagnosticCategory.Error, "An_element_access_expression_should_take_an_argument_1011", "An element access expression should take an argument."),
            Unexpected_token: diag(1012, ts.DiagnosticCategory.Error, "Unexpected_token_1012", "Unexpected token."),
            A_rest_parameter_or_binding_pattern_may_not_have_a_trailing_comma: diag(1013, ts.DiagnosticCategory.Error, "A_rest_parameter_or_binding_pattern_may_not_have_a_trailing_comma_1013", "A rest parameter or binding pattern may not have a trailing comma."),
            A_rest_parameter_must_be_last_in_a_parameter_list: diag(1014, ts.DiagnosticCategory.Error, "A_rest_parameter_must_be_last_in_a_parameter_list_1014", "A rest parameter must be last in a parameter list."),
            Parameter_cannot_have_question_mark_and_initializer: diag(1015, ts.DiagnosticCategory.Error, "Parameter_cannot_have_question_mark_and_initializer_1015", "Parameter cannot have question mark and initializer."),
            A_required_parameter_cannot_follow_an_optional_parameter: diag(1016, ts.DiagnosticCategory.Error, "A_required_parameter_cannot_follow_an_optional_parameter_1016", "A required parameter cannot follow an optional parameter."),
            An_index_signature_cannot_have_a_rest_parameter: diag(1017, ts.DiagnosticCategory.Error, "An_index_signature_cannot_have_a_rest_parameter_1017", "An index signature cannot have a rest parameter."),
            An_index_signature_parameter_cannot_have_an_accessibility_modifier: diag(1018, ts.DiagnosticCategory.Error, "An_index_signature_parameter_cannot_have_an_accessibility_modifier_1018", "An index signature parameter cannot have an accessibility modifier."),
            An_index_signature_parameter_cannot_have_a_question_mark: diag(1019, ts.DiagnosticCategory.Error, "An_index_signature_parameter_cannot_have_a_question_mark_1019", "An index signature parameter cannot have a question mark."),
            An_index_signature_parameter_cannot_have_an_initializer: diag(1020, ts.DiagnosticCategory.Error, "An_index_signature_parameter_cannot_have_an_initializer_1020", "An index signature parameter cannot have an initializer."),
            An_index_signature_must_have_a_type_annotation: diag(1021, ts.DiagnosticCategory.Error, "An_index_signature_must_have_a_type_annotation_1021", "An index signature must have a type annotation."),
            An_index_signature_parameter_must_have_a_type_annotation: diag(1022, ts.DiagnosticCategory.Error, "An_index_signature_parameter_must_have_a_type_annotation_1022", "An index signature parameter must have a type annotation."),
            An_index_signature_parameter_type_must_be_either_string_or_number: diag(1023, ts.DiagnosticCategory.Error, "An_index_signature_parameter_type_must_be_either_string_or_number_1023", "An index signature parameter type must be either 'string' or 'number'."),
            readonly_modifier_can_only_appear_on_a_property_declaration_or_index_signature: diag(1024, ts.DiagnosticCategory.Error, "readonly_modifier_can_only_appear_on_a_property_declaration_or_index_signature_1024", "'readonly' modifier can only appear on a property declaration or index signature."),
            Accessibility_modifier_already_seen: diag(1028, ts.DiagnosticCategory.Error, "Accessibility_modifier_already_seen_1028", "Accessibility modifier already seen."),
            _0_modifier_must_precede_1_modifier: diag(1029, ts.DiagnosticCategory.Error, "_0_modifier_must_precede_1_modifier_1029", "'{0}' modifier must precede '{1}' modifier."),
            _0_modifier_already_seen: diag(1030, ts.DiagnosticCategory.Error, "_0_modifier_already_seen_1030", "'{0}' modifier already seen."),
            _0_modifier_cannot_appear_on_a_class_element: diag(1031, ts.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_class_element_1031", "'{0}' modifier cannot appear on a class element."),
            super_must_be_followed_by_an_argument_list_or_member_access: diag(1034, ts.DiagnosticCategory.Error, "super_must_be_followed_by_an_argument_list_or_member_access_1034", "'super' must be followed by an argument list or member access."),
            Only_ambient_modules_can_use_quoted_names: diag(1035, ts.DiagnosticCategory.Error, "Only_ambient_modules_can_use_quoted_names_1035", "Only ambient modules can use quoted names."),
            Statements_are_not_allowed_in_ambient_contexts: diag(1036, ts.DiagnosticCategory.Error, "Statements_are_not_allowed_in_ambient_contexts_1036", "Statements are not allowed in ambient contexts."),
            A_declare_modifier_cannot_be_used_in_an_already_ambient_context: diag(1038, ts.DiagnosticCategory.Error, "A_declare_modifier_cannot_be_used_in_an_already_ambient_context_1038", "A 'declare' modifier cannot be used in an already ambient context."),
            Initializers_are_not_allowed_in_ambient_contexts: diag(1039, ts.DiagnosticCategory.Error, "Initializers_are_not_allowed_in_ambient_contexts_1039", "Initializers are not allowed in ambient contexts."),
            _0_modifier_cannot_be_used_in_an_ambient_context: diag(1040, ts.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_in_an_ambient_context_1040", "'{0}' modifier cannot be used in an ambient context."),
            _0_modifier_cannot_be_used_with_a_class_declaration: diag(1041, ts.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_with_a_class_declaration_1041", "'{0}' modifier cannot be used with a class declaration."),
            _0_modifier_cannot_be_used_here: diag(1042, ts.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_here_1042", "'{0}' modifier cannot be used here."),
            _0_modifier_cannot_appear_on_a_data_property: diag(1043, ts.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_data_property_1043", "'{0}' modifier cannot appear on a data property."),
            _0_modifier_cannot_appear_on_a_module_or_namespace_element: diag(1044, ts.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_module_or_namespace_element_1044", "'{0}' modifier cannot appear on a module or namespace element."),
            A_0_modifier_cannot_be_used_with_an_interface_declaration: diag(1045, ts.DiagnosticCategory.Error, "A_0_modifier_cannot_be_used_with_an_interface_declaration_1045", "A '{0}' modifier cannot be used with an interface declaration."),
            Top_level_declarations_in_d_ts_files_must_start_with_either_a_declare_or_export_modifier: diag(1046, ts.DiagnosticCategory.Error, "Top_level_declarations_in_d_ts_files_must_start_with_either_a_declare_or_export_modifier_1046", "Top-level declarations in .d.ts files must start with either a 'declare' or 'export' modifier."),
            A_rest_parameter_cannot_be_optional: diag(1047, ts.DiagnosticCategory.Error, "A_rest_parameter_cannot_be_optional_1047", "A rest parameter cannot be optional."),
            A_rest_parameter_cannot_have_an_initializer: diag(1048, ts.DiagnosticCategory.Error, "A_rest_parameter_cannot_have_an_initializer_1048", "A rest parameter cannot have an initializer."),
            A_set_accessor_must_have_exactly_one_parameter: diag(1049, ts.DiagnosticCategory.Error, "A_set_accessor_must_have_exactly_one_parameter_1049", "A 'set' accessor must have exactly one parameter."),
            A_set_accessor_cannot_have_an_optional_parameter: diag(1051, ts.DiagnosticCategory.Error, "A_set_accessor_cannot_have_an_optional_parameter_1051", "A 'set' accessor cannot have an optional parameter."),
            A_set_accessor_parameter_cannot_have_an_initializer: diag(1052, ts.DiagnosticCategory.Error, "A_set_accessor_parameter_cannot_have_an_initializer_1052", "A 'set' accessor parameter cannot have an initializer."),
            A_set_accessor_cannot_have_rest_parameter: diag(1053, ts.DiagnosticCategory.Error, "A_set_accessor_cannot_have_rest_parameter_1053", "A 'set' accessor cannot have rest parameter."),
            A_get_accessor_cannot_have_parameters: diag(1054, ts.DiagnosticCategory.Error, "A_get_accessor_cannot_have_parameters_1054", "A 'get' accessor cannot have parameters."),
            Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Promise_compatible_constructor_value: diag(1055, ts.DiagnosticCategory.Error, "Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Prom_1055", "Type '{0}' is not a valid async function return type in ES5/ES3 because it does not refer to a Promise-compatible constructor value."),
            Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher: diag(1056, ts.DiagnosticCategory.Error, "Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher_1056", "Accessors are only available when targeting ECMAScript 5 and higher."),
            An_async_function_or_method_must_have_a_valid_awaitable_return_type: diag(1057, ts.DiagnosticCategory.Error, "An_async_function_or_method_must_have_a_valid_awaitable_return_type_1057", "An async function or method must have a valid awaitable return type."),
            The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1058, ts.DiagnosticCategory.Error, "The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_t_1058", "The return type of an async function must either be a valid promise or must not contain a callable 'then' member."),
            A_promise_must_have_a_then_method: diag(1059, ts.DiagnosticCategory.Error, "A_promise_must_have_a_then_method_1059", "A promise must have a 'then' method."),
            The_first_parameter_of_the_then_method_of_a_promise_must_be_a_callback: diag(1060, ts.DiagnosticCategory.Error, "The_first_parameter_of_the_then_method_of_a_promise_must_be_a_callback_1060", "The first parameter of the 'then' method of a promise must be a callback."),
            Enum_member_must_have_initializer: diag(1061, ts.DiagnosticCategory.Error, "Enum_member_must_have_initializer_1061", "Enum member must have initializer."),
            Type_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method: diag(1062, ts.DiagnosticCategory.Error, "Type_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method_1062", "Type is referenced directly or indirectly in the fulfillment callback of its own 'then' method."),
            An_export_assignment_cannot_be_used_in_a_namespace: diag(1063, ts.DiagnosticCategory.Error, "An_export_assignment_cannot_be_used_in_a_namespace_1063", "An export assignment cannot be used in a namespace."),
            The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type: diag(1064, ts.DiagnosticCategory.Error, "The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type_1064", "The return type of an async function or method must be the global Promise<T> type."),
            In_ambient_enum_declarations_member_initializer_must_be_constant_expression: diag(1066, ts.DiagnosticCategory.Error, "In_ambient_enum_declarations_member_initializer_must_be_constant_expression_1066", "In ambient enum declarations member initializer must be constant expression."),
            Unexpected_token_A_constructor_method_accessor_or_property_was_expected: diag(1068, ts.DiagnosticCategory.Error, "Unexpected_token_A_constructor_method_accessor_or_property_was_expected_1068", "Unexpected token. A constructor, method, accessor, or property was expected."),
            Unexpected_token_A_type_parameter_name_was_expected_without_curly_braces: diag(1069, ts.DiagnosticCategory.Error, "Unexpected_token_A_type_parameter_name_was_expected_without_curly_braces_1069", "Unexpected token. A type parameter name was expected without curly braces."),
            _0_modifier_cannot_appear_on_a_type_member: diag(1070, ts.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_type_member_1070", "'{0}' modifier cannot appear on a type member."),
            _0_modifier_cannot_appear_on_an_index_signature: diag(1071, ts.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_an_index_signature_1071", "'{0}' modifier cannot appear on an index signature."),
            A_0_modifier_cannot_be_used_with_an_import_declaration: diag(1079, ts.DiagnosticCategory.Error, "A_0_modifier_cannot_be_used_with_an_import_declaration_1079", "A '{0}' modifier cannot be used with an import declaration."),
            Invalid_reference_directive_syntax: diag(1084, ts.DiagnosticCategory.Error, "Invalid_reference_directive_syntax_1084", "Invalid 'reference' directive syntax."),
            Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher_Use_the_syntax_0: diag(1085, ts.DiagnosticCategory.Error, "Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher_Use_the_syntax_0_1085", "Octal literals are not available when targeting ECMAScript 5 and higher. Use the syntax '{0}'."),
            _0_modifier_cannot_appear_on_a_constructor_declaration: diag(1089, ts.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_constructor_declaration_1089", "'{0}' modifier cannot appear on a constructor declaration."),
            _0_modifier_cannot_appear_on_a_parameter: diag(1090, ts.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_parameter_1090", "'{0}' modifier cannot appear on a parameter."),
            Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement: diag(1091, ts.DiagnosticCategory.Error, "Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement_1091", "Only a single variable declaration is allowed in a 'for...in' statement."),
            Type_parameters_cannot_appear_on_a_constructor_declaration: diag(1092, ts.DiagnosticCategory.Error, "Type_parameters_cannot_appear_on_a_constructor_declaration_1092", "Type parameters cannot appear on a constructor declaration."),
            Type_annotation_cannot_appear_on_a_constructor_declaration: diag(1093, ts.DiagnosticCategory.Error, "Type_annotation_cannot_appear_on_a_constructor_declaration_1093", "Type annotation cannot appear on a constructor declaration."),
            An_accessor_cannot_have_type_parameters: diag(1094, ts.DiagnosticCategory.Error, "An_accessor_cannot_have_type_parameters_1094", "An accessor cannot have type parameters."),
            A_set_accessor_cannot_have_a_return_type_annotation: diag(1095, ts.DiagnosticCategory.Error, "A_set_accessor_cannot_have_a_return_type_annotation_1095", "A 'set' accessor cannot have a return type annotation."),
            An_index_signature_must_have_exactly_one_parameter: diag(1096, ts.DiagnosticCategory.Error, "An_index_signature_must_have_exactly_one_parameter_1096", "An index signature must have exactly one parameter."),
            _0_list_cannot_be_empty: diag(1097, ts.DiagnosticCategory.Error, "_0_list_cannot_be_empty_1097", "'{0}' list cannot be empty."),
            Type_parameter_list_cannot_be_empty: diag(1098, ts.DiagnosticCategory.Error, "Type_parameter_list_cannot_be_empty_1098", "Type parameter list cannot be empty."),
            Type_argument_list_cannot_be_empty: diag(1099, ts.DiagnosticCategory.Error, "Type_argument_list_cannot_be_empty_1099", "Type argument list cannot be empty."),
            Invalid_use_of_0_in_strict_mode: diag(1100, ts.DiagnosticCategory.Error, "Invalid_use_of_0_in_strict_mode_1100", "Invalid use of '{0}' in strict mode."),
            with_statements_are_not_allowed_in_strict_mode: diag(1101, ts.DiagnosticCategory.Error, "with_statements_are_not_allowed_in_strict_mode_1101", "'with' statements are not allowed in strict mode."),
            delete_cannot_be_called_on_an_identifier_in_strict_mode: diag(1102, ts.DiagnosticCategory.Error, "delete_cannot_be_called_on_an_identifier_in_strict_mode_1102", "'delete' cannot be called on an identifier in strict mode."),
            A_for_await_of_statement_is_only_allowed_within_an_async_function_or_async_generator: diag(1103, ts.DiagnosticCategory.Error, "A_for_await_of_statement_is_only_allowed_within_an_async_function_or_async_generator_1103", "A 'for-await-of' statement is only allowed within an async function or async generator."),
            A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement: diag(1104, ts.DiagnosticCategory.Error, "A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement_1104", "A 'continue' statement can only be used within an enclosing iteration statement."),
            A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement: diag(1105, ts.DiagnosticCategory.Error, "A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement_1105", "A 'break' statement can only be used within an enclosing iteration or switch statement."),
            Jump_target_cannot_cross_function_boundary: diag(1107, ts.DiagnosticCategory.Error, "Jump_target_cannot_cross_function_boundary_1107", "Jump target cannot cross function boundary."),
            A_return_statement_can_only_be_used_within_a_function_body: diag(1108, ts.DiagnosticCategory.Error, "A_return_statement_can_only_be_used_within_a_function_body_1108", "A 'return' statement can only be used within a function body."),
            Expression_expected: diag(1109, ts.DiagnosticCategory.Error, "Expression_expected_1109", "Expression expected."),
            Type_expected: diag(1110, ts.DiagnosticCategory.Error, "Type_expected_1110", "Type expected."),
            A_default_clause_cannot_appear_more_than_once_in_a_switch_statement: diag(1113, ts.DiagnosticCategory.Error, "A_default_clause_cannot_appear_more_than_once_in_a_switch_statement_1113", "A 'default' clause cannot appear more than once in a 'switch' statement."),
            Duplicate_label_0: diag(1114, ts.DiagnosticCategory.Error, "Duplicate_label_0_1114", "Duplicate label '{0}'."),
            A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement: diag(1115, ts.DiagnosticCategory.Error, "A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement_1115", "A 'continue' statement can only jump to a label of an enclosing iteration statement."),
            A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement: diag(1116, ts.DiagnosticCategory.Error, "A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement_1116", "A 'break' statement can only jump to a label of an enclosing statement."),
            An_object_literal_cannot_have_multiple_properties_with_the_same_name_in_strict_mode: diag(1117, ts.DiagnosticCategory.Error, "An_object_literal_cannot_have_multiple_properties_with_the_same_name_in_strict_mode_1117", "An object literal cannot have multiple properties with the same name in strict mode."),
            An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name: diag(1118, ts.DiagnosticCategory.Error, "An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name_1118", "An object literal cannot have multiple get/set accessors with the same name."),
            An_object_literal_cannot_have_property_and_accessor_with_the_same_name: diag(1119, ts.DiagnosticCategory.Error, "An_object_literal_cannot_have_property_and_accessor_with_the_same_name_1119", "An object literal cannot have property and accessor with the same name."),
            An_export_assignment_cannot_have_modifiers: diag(1120, ts.DiagnosticCategory.Error, "An_export_assignment_cannot_have_modifiers_1120", "An export assignment cannot have modifiers."),
            Octal_literals_are_not_allowed_in_strict_mode: diag(1121, ts.DiagnosticCategory.Error, "Octal_literals_are_not_allowed_in_strict_mode_1121", "Octal literals are not allowed in strict mode."),
            Variable_declaration_list_cannot_be_empty: diag(1123, ts.DiagnosticCategory.Error, "Variable_declaration_list_cannot_be_empty_1123", "Variable declaration list cannot be empty."),
            Digit_expected: diag(1124, ts.DiagnosticCategory.Error, "Digit_expected_1124", "Digit expected."),
            Hexadecimal_digit_expected: diag(1125, ts.DiagnosticCategory.Error, "Hexadecimal_digit_expected_1125", "Hexadecimal digit expected."),
            Unexpected_end_of_text: diag(1126, ts.DiagnosticCategory.Error, "Unexpected_end_of_text_1126", "Unexpected end of text."),
            Invalid_character: diag(1127, ts.DiagnosticCategory.Error, "Invalid_character_1127", "Invalid character."),
            Declaration_or_statement_expected: diag(1128, ts.DiagnosticCategory.Error, "Declaration_or_statement_expected_1128", "Declaration or statement expected."),
            Statement_expected: diag(1129, ts.DiagnosticCategory.Error, "Statement_expected_1129", "Statement expected."),
            case_or_default_expected: diag(1130, ts.DiagnosticCategory.Error, "case_or_default_expected_1130", "'case' or 'default' expected."),
            Property_or_signature_expected: diag(1131, ts.DiagnosticCategory.Error, "Property_or_signature_expected_1131", "Property or signature expected."),
            Enum_member_expected: diag(1132, ts.DiagnosticCategory.Error, "Enum_member_expected_1132", "Enum member expected."),
            Variable_declaration_expected: diag(1134, ts.DiagnosticCategory.Error, "Variable_declaration_expected_1134", "Variable declaration expected."),
            Argument_expression_expected: diag(1135, ts.DiagnosticCategory.Error, "Argument_expression_expected_1135", "Argument expression expected."),
            Property_assignment_expected: diag(1136, ts.DiagnosticCategory.Error, "Property_assignment_expected_1136", "Property assignment expected."),
            Expression_or_comma_expected: diag(1137, ts.DiagnosticCategory.Error, "Expression_or_comma_expected_1137", "Expression or comma expected."),
            Parameter_declaration_expected: diag(1138, ts.DiagnosticCategory.Error, "Parameter_declaration_expected_1138", "Parameter declaration expected."),
            Type_parameter_declaration_expected: diag(1139, ts.DiagnosticCategory.Error, "Type_parameter_declaration_expected_1139", "Type parameter declaration expected."),
            Type_argument_expected: diag(1140, ts.DiagnosticCategory.Error, "Type_argument_expected_1140", "Type argument expected."),
            String_literal_expected: diag(1141, ts.DiagnosticCategory.Error, "String_literal_expected_1141", "String literal expected."),
            Line_break_not_permitted_here: diag(1142, ts.DiagnosticCategory.Error, "Line_break_not_permitted_here_1142", "Line break not permitted here."),
            or_expected: diag(1144, ts.DiagnosticCategory.Error, "or_expected_1144", "'{' or ';' expected."),
            Declaration_expected: diag(1146, ts.DiagnosticCategory.Error, "Declaration_expected_1146", "Declaration expected."),
            Import_declarations_in_a_namespace_cannot_reference_a_module: diag(1147, ts.DiagnosticCategory.Error, "Import_declarations_in_a_namespace_cannot_reference_a_module_1147", "Import declarations in a namespace cannot reference a module."),
            Cannot_use_imports_exports_or_module_augmentations_when_module_is_none: diag(1148, ts.DiagnosticCategory.Error, "Cannot_use_imports_exports_or_module_augmentations_when_module_is_none_1148", "Cannot use imports, exports, or module augmentations when '--module' is 'none'."),
            File_name_0_differs_from_already_included_file_name_1_only_in_casing: diag(1149, ts.DiagnosticCategory.Error, "File_name_0_differs_from_already_included_file_name_1_only_in_casing_1149", "File name '{0}' differs from already included file name '{1}' only in casing."),
            const_declarations_must_be_initialized: diag(1155, ts.DiagnosticCategory.Error, "const_declarations_must_be_initialized_1155", "'const' declarations must be initialized."),
            const_declarations_can_only_be_declared_inside_a_block: diag(1156, ts.DiagnosticCategory.Error, "const_declarations_can_only_be_declared_inside_a_block_1156", "'const' declarations can only be declared inside a block."),
            let_declarations_can_only_be_declared_inside_a_block: diag(1157, ts.DiagnosticCategory.Error, "let_declarations_can_only_be_declared_inside_a_block_1157", "'let' declarations can only be declared inside a block."),
            Unterminated_template_literal: diag(1160, ts.DiagnosticCategory.Error, "Unterminated_template_literal_1160", "Unterminated template literal."),
            Unterminated_regular_expression_literal: diag(1161, ts.DiagnosticCategory.Error, "Unterminated_regular_expression_literal_1161", "Unterminated regular expression literal."),
            An_object_member_cannot_be_declared_optional: diag(1162, ts.DiagnosticCategory.Error, "An_object_member_cannot_be_declared_optional_1162", "An object member cannot be declared optional."),
            A_yield_expression_is_only_allowed_in_a_generator_body: diag(1163, ts.DiagnosticCategory.Error, "A_yield_expression_is_only_allowed_in_a_generator_body_1163", "A 'yield' expression is only allowed in a generator body."),
            Computed_property_names_are_not_allowed_in_enums: diag(1164, ts.DiagnosticCategory.Error, "Computed_property_names_are_not_allowed_in_enums_1164", "Computed property names are not allowed in enums."),
            A_computed_property_name_in_an_ambient_context_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1165, ts.DiagnosticCategory.Error, "A_computed_property_name_in_an_ambient_context_must_refer_to_an_expression_whose_type_is_a_literal_t_1165", "A computed property name in an ambient context must refer to an expression whose type is a literal type or a 'unique symbol' type."),
            A_computed_property_name_in_a_class_property_declaration_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1166, ts.DiagnosticCategory.Error, "A_computed_property_name_in_a_class_property_declaration_must_refer_to_an_expression_whose_type_is_a_1166", "A computed property name in a class property declaration must refer to an expression whose type is a literal type or a 'unique symbol' type."),
            A_computed_property_name_in_a_method_overload_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1168, ts.DiagnosticCategory.Error, "A_computed_property_name_in_a_method_overload_must_refer_to_an_expression_whose_type_is_a_literal_ty_1168", "A computed property name in a method overload must refer to an expression whose type is a literal type or a 'unique symbol' type."),
            A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1169, ts.DiagnosticCategory.Error, "A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_1169", "A computed property name in an interface must refer to an expression whose type is a literal type or a 'unique symbol' type."),
            A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1170, ts.DiagnosticCategory.Error, "A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type__1170", "A computed property name in a type literal must refer to an expression whose type is a literal type or a 'unique symbol' type."),
            A_comma_expression_is_not_allowed_in_a_computed_property_name: diag(1171, ts.DiagnosticCategory.Error, "A_comma_expression_is_not_allowed_in_a_computed_property_name_1171", "A comma expression is not allowed in a computed property name."),
            extends_clause_already_seen: diag(1172, ts.DiagnosticCategory.Error, "extends_clause_already_seen_1172", "'extends' clause already seen."),
            extends_clause_must_precede_implements_clause: diag(1173, ts.DiagnosticCategory.Error, "extends_clause_must_precede_implements_clause_1173", "'extends' clause must precede 'implements' clause."),
            Classes_can_only_extend_a_single_class: diag(1174, ts.DiagnosticCategory.Error, "Classes_can_only_extend_a_single_class_1174", "Classes can only extend a single class."),
            implements_clause_already_seen: diag(1175, ts.DiagnosticCategory.Error, "implements_clause_already_seen_1175", "'implements' clause already seen."),
            Interface_declaration_cannot_have_implements_clause: diag(1176, ts.DiagnosticCategory.Error, "Interface_declaration_cannot_have_implements_clause_1176", "Interface declaration cannot have 'implements' clause."),
            Binary_digit_expected: diag(1177, ts.DiagnosticCategory.Error, "Binary_digit_expected_1177", "Binary digit expected."),
            Octal_digit_expected: diag(1178, ts.DiagnosticCategory.Error, "Octal_digit_expected_1178", "Octal digit expected."),
            Unexpected_token_expected: diag(1179, ts.DiagnosticCategory.Error, "Unexpected_token_expected_1179", "Unexpected token. '{' expected."),
            Property_destructuring_pattern_expected: diag(1180, ts.DiagnosticCategory.Error, "Property_destructuring_pattern_expected_1180", "Property destructuring pattern expected."),
            Array_element_destructuring_pattern_expected: diag(1181, ts.DiagnosticCategory.Error, "Array_element_destructuring_pattern_expected_1181", "Array element destructuring pattern expected."),
            A_destructuring_declaration_must_have_an_initializer: diag(1182, ts.DiagnosticCategory.Error, "A_destructuring_declaration_must_have_an_initializer_1182", "A destructuring declaration must have an initializer."),
            An_implementation_cannot_be_declared_in_ambient_contexts: diag(1183, ts.DiagnosticCategory.Error, "An_implementation_cannot_be_declared_in_ambient_contexts_1183", "An implementation cannot be declared in ambient contexts."),
            Modifiers_cannot_appear_here: diag(1184, ts.DiagnosticCategory.Error, "Modifiers_cannot_appear_here_1184", "Modifiers cannot appear here."),
            Merge_conflict_marker_encountered: diag(1185, ts.DiagnosticCategory.Error, "Merge_conflict_marker_encountered_1185", "Merge conflict marker encountered."),
            A_rest_element_cannot_have_an_initializer: diag(1186, ts.DiagnosticCategory.Error, "A_rest_element_cannot_have_an_initializer_1186", "A rest element cannot have an initializer."),
            A_parameter_property_may_not_be_declared_using_a_binding_pattern: diag(1187, ts.DiagnosticCategory.Error, "A_parameter_property_may_not_be_declared_using_a_binding_pattern_1187", "A parameter property may not be declared using a binding pattern."),
            Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement: diag(1188, ts.DiagnosticCategory.Error, "Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement_1188", "Only a single variable declaration is allowed in a 'for...of' statement."),
            The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer: diag(1189, ts.DiagnosticCategory.Error, "The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer_1189", "The variable declaration of a 'for...in' statement cannot have an initializer."),
            The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer: diag(1190, ts.DiagnosticCategory.Error, "The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer_1190", "The variable declaration of a 'for...of' statement cannot have an initializer."),
            An_import_declaration_cannot_have_modifiers: diag(1191, ts.DiagnosticCategory.Error, "An_import_declaration_cannot_have_modifiers_1191", "An import declaration cannot have modifiers."),
            Module_0_has_no_default_export: diag(1192, ts.DiagnosticCategory.Error, "Module_0_has_no_default_export_1192", "Module '{0}' has no default export."),
            An_export_declaration_cannot_have_modifiers: diag(1193, ts.DiagnosticCategory.Error, "An_export_declaration_cannot_have_modifiers_1193", "An export declaration cannot have modifiers."),
            Export_declarations_are_not_permitted_in_a_namespace: diag(1194, ts.DiagnosticCategory.Error, "Export_declarations_are_not_permitted_in_a_namespace_1194", "Export declarations are not permitted in a namespace."),
            Catch_clause_variable_cannot_have_a_type_annotation: diag(1196, ts.DiagnosticCategory.Error, "Catch_clause_variable_cannot_have_a_type_annotation_1196", "Catch clause variable cannot have a type annotation."),
            Catch_clause_variable_cannot_have_an_initializer: diag(1197, ts.DiagnosticCategory.Error, "Catch_clause_variable_cannot_have_an_initializer_1197", "Catch clause variable cannot have an initializer."),
            An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive: diag(1198, ts.DiagnosticCategory.Error, "An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive_1198", "An extended Unicode escape value must be between 0x0 and 0x10FFFF inclusive."),
            Unterminated_Unicode_escape_sequence: diag(1199, ts.DiagnosticCategory.Error, "Unterminated_Unicode_escape_sequence_1199", "Unterminated Unicode escape sequence."),
            Line_terminator_not_permitted_before_arrow: diag(1200, ts.DiagnosticCategory.Error, "Line_terminator_not_permitted_before_arrow_1200", "Line terminator not permitted before arrow."),
            Import_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_import_Asterisk_as_ns_from_mod_import_a_from_mod_import_d_from_mod_or_another_module_format_instead: diag(1202, ts.DiagnosticCategory.Error, "Import_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_import_Asterisk_as_1202", "Import assignment cannot be used when targeting ECMAScript modules. Consider using 'import * as ns from \"mod\"', 'import {a} from \"mod\"', 'import d from \"mod\"', or another module format instead."),
            Export_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_export_default_or_another_module_format_instead: diag(1203, ts.DiagnosticCategory.Error, "Export_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_export_default_or__1203", "Export assignment cannot be used when targeting ECMAScript modules. Consider using 'export default' or another module format instead."),
            Re_exporting_a_type_when_the_isolatedModules_flag_is_provided_requires_using_export_type: diag(1205, ts.DiagnosticCategory.Error, "Re_exporting_a_type_when_the_isolatedModules_flag_is_provided_requires_using_export_type_1205", "Re-exporting a type when the '--isolatedModules' flag is provided requires using 'export type'."),
            Decorators_are_not_valid_here: diag(1206, ts.DiagnosticCategory.Error, "Decorators_are_not_valid_here_1206", "Decorators are not valid here."),
            Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name: diag(1207, ts.DiagnosticCategory.Error, "Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name_1207", "Decorators cannot be applied to multiple get/set accessors of the same name."),
            All_files_must_be_modules_when_the_isolatedModules_flag_is_provided: diag(1208, ts.DiagnosticCategory.Error, "All_files_must_be_modules_when_the_isolatedModules_flag_is_provided_1208", "All files must be modules when the '--isolatedModules' flag is provided."),
            Invalid_use_of_0_Class_definitions_are_automatically_in_strict_mode: diag(1210, ts.DiagnosticCategory.Error, "Invalid_use_of_0_Class_definitions_are_automatically_in_strict_mode_1210", "Invalid use of '{0}'. Class definitions are automatically in strict mode."),
            A_class_declaration_without_the_default_modifier_must_have_a_name: diag(1211, ts.DiagnosticCategory.Error, "A_class_declaration_without_the_default_modifier_must_have_a_name_1211", "A class declaration without the 'default' modifier must have a name."),
            Identifier_expected_0_is_a_reserved_word_in_strict_mode: diag(1212, ts.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_1212", "Identifier expected. '{0}' is a reserved word in strict mode."),
            Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_strict_mode: diag(1213, ts.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_stric_1213", "Identifier expected. '{0}' is a reserved word in strict mode. Class definitions are automatically in strict mode."),
            Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode: diag(1214, ts.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode_1214", "Identifier expected. '{0}' is a reserved word in strict mode. Modules are automatically in strict mode."),
            Invalid_use_of_0_Modules_are_automatically_in_strict_mode: diag(1215, ts.DiagnosticCategory.Error, "Invalid_use_of_0_Modules_are_automatically_in_strict_mode_1215", "Invalid use of '{0}'. Modules are automatically in strict mode."),
            Identifier_expected_esModule_is_reserved_as_an_exported_marker_when_transforming_ECMAScript_modules: diag(1216, ts.DiagnosticCategory.Error, "Identifier_expected_esModule_is_reserved_as_an_exported_marker_when_transforming_ECMAScript_modules_1216", "Identifier expected. '__esModule' is reserved as an exported marker when transforming ECMAScript modules."),
            Export_assignment_is_not_supported_when_module_flag_is_system: diag(1218, ts.DiagnosticCategory.Error, "Export_assignment_is_not_supported_when_module_flag_is_system_1218", "Export assignment is not supported when '--module' flag is 'system'."),
            Experimental_support_for_decorators_is_a_feature_that_is_subject_to_change_in_a_future_release_Set_the_experimentalDecorators_option_in_your_tsconfig_or_jsconfig_to_remove_this_warning: diag(1219, ts.DiagnosticCategory.Error, "Experimental_support_for_decorators_is_a_feature_that_is_subject_to_change_in_a_future_release_Set_t_1219", "Experimental support for decorators is a feature that is subject to change in a future release. Set the 'experimentalDecorators' option in your 'tsconfig' or 'jsconfig' to remove this warning."),
            Generators_are_only_available_when_targeting_ECMAScript_2015_or_higher: diag(1220, ts.DiagnosticCategory.Error, "Generators_are_only_available_when_targeting_ECMAScript_2015_or_higher_1220", "Generators are only available when targeting ECMAScript 2015 or higher."),
            Generators_are_not_allowed_in_an_ambient_context: diag(1221, ts.DiagnosticCategory.Error, "Generators_are_not_allowed_in_an_ambient_context_1221", "Generators are not allowed in an ambient context."),
            An_overload_signature_cannot_be_declared_as_a_generator: diag(1222, ts.DiagnosticCategory.Error, "An_overload_signature_cannot_be_declared_as_a_generator_1222", "An overload signature cannot be declared as a generator."),
            _0_tag_already_specified: diag(1223, ts.DiagnosticCategory.Error, "_0_tag_already_specified_1223", "'{0}' tag already specified."),
            Signature_0_must_be_a_type_predicate: diag(1224, ts.DiagnosticCategory.Error, "Signature_0_must_be_a_type_predicate_1224", "Signature '{0}' must be a type predicate."),
            Cannot_find_parameter_0: diag(1225, ts.DiagnosticCategory.Error, "Cannot_find_parameter_0_1225", "Cannot find parameter '{0}'."),
            Type_predicate_0_is_not_assignable_to_1: diag(1226, ts.DiagnosticCategory.Error, "Type_predicate_0_is_not_assignable_to_1_1226", "Type predicate '{0}' is not assignable to '{1}'."),
            Parameter_0_is_not_in_the_same_position_as_parameter_1: diag(1227, ts.DiagnosticCategory.Error, "Parameter_0_is_not_in_the_same_position_as_parameter_1_1227", "Parameter '{0}' is not in the same position as parameter '{1}'."),
            A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods: diag(1228, ts.DiagnosticCategory.Error, "A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods_1228", "A type predicate is only allowed in return type position for functions and methods."),
            A_type_predicate_cannot_reference_a_rest_parameter: diag(1229, ts.DiagnosticCategory.Error, "A_type_predicate_cannot_reference_a_rest_parameter_1229", "A type predicate cannot reference a rest parameter."),
            A_type_predicate_cannot_reference_element_0_in_a_binding_pattern: diag(1230, ts.DiagnosticCategory.Error, "A_type_predicate_cannot_reference_element_0_in_a_binding_pattern_1230", "A type predicate cannot reference element '{0}' in a binding pattern."),
            An_export_assignment_can_only_be_used_in_a_module: diag(1231, ts.DiagnosticCategory.Error, "An_export_assignment_can_only_be_used_in_a_module_1231", "An export assignment can only be used in a module."),
            An_import_declaration_can_only_be_used_in_a_namespace_or_module: diag(1232, ts.DiagnosticCategory.Error, "An_import_declaration_can_only_be_used_in_a_namespace_or_module_1232", "An import declaration can only be used in a namespace or module."),
            An_export_declaration_can_only_be_used_in_a_module: diag(1233, ts.DiagnosticCategory.Error, "An_export_declaration_can_only_be_used_in_a_module_1233", "An export declaration can only be used in a module."),
            An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file: diag(1234, ts.DiagnosticCategory.Error, "An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file_1234", "An ambient module declaration is only allowed at the top level in a file."),
            A_namespace_declaration_is_only_allowed_in_a_namespace_or_module: diag(1235, ts.DiagnosticCategory.Error, "A_namespace_declaration_is_only_allowed_in_a_namespace_or_module_1235", "A namespace declaration is only allowed in a namespace or module."),
            The_return_type_of_a_property_decorator_function_must_be_either_void_or_any: diag(1236, ts.DiagnosticCategory.Error, "The_return_type_of_a_property_decorator_function_must_be_either_void_or_any_1236", "The return type of a property decorator function must be either 'void' or 'any'."),
            The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any: diag(1237, ts.DiagnosticCategory.Error, "The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any_1237", "The return type of a parameter decorator function must be either 'void' or 'any'."),
            Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression: diag(1238, ts.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression_1238", "Unable to resolve signature of class decorator when called as an expression."),
            Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression: diag(1239, ts.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression_1239", "Unable to resolve signature of parameter decorator when called as an expression."),
            Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression: diag(1240, ts.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression_1240", "Unable to resolve signature of property decorator when called as an expression."),
            Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression: diag(1241, ts.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression_1241", "Unable to resolve signature of method decorator when called as an expression."),
            abstract_modifier_can_only_appear_on_a_class_method_or_property_declaration: diag(1242, ts.DiagnosticCategory.Error, "abstract_modifier_can_only_appear_on_a_class_method_or_property_declaration_1242", "'abstract' modifier can only appear on a class, method, or property declaration."),
            _0_modifier_cannot_be_used_with_1_modifier: diag(1243, ts.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_with_1_modifier_1243", "'{0}' modifier cannot be used with '{1}' modifier."),
            Abstract_methods_can_only_appear_within_an_abstract_class: diag(1244, ts.DiagnosticCategory.Error, "Abstract_methods_can_only_appear_within_an_abstract_class_1244", "Abstract methods can only appear within an abstract class."),
            Method_0_cannot_have_an_implementation_because_it_is_marked_abstract: diag(1245, ts.DiagnosticCategory.Error, "Method_0_cannot_have_an_implementation_because_it_is_marked_abstract_1245", "Method '{0}' cannot have an implementation because it is marked abstract."),
            An_interface_property_cannot_have_an_initializer: diag(1246, ts.DiagnosticCategory.Error, "An_interface_property_cannot_have_an_initializer_1246", "An interface property cannot have an initializer."),
            A_type_literal_property_cannot_have_an_initializer: diag(1247, ts.DiagnosticCategory.Error, "A_type_literal_property_cannot_have_an_initializer_1247", "A type literal property cannot have an initializer."),
            A_class_member_cannot_have_the_0_keyword: diag(1248, ts.DiagnosticCategory.Error, "A_class_member_cannot_have_the_0_keyword_1248", "A class member cannot have the '{0}' keyword."),
            A_decorator_can_only_decorate_a_method_implementation_not_an_overload: diag(1249, ts.DiagnosticCategory.Error, "A_decorator_can_only_decorate_a_method_implementation_not_an_overload_1249", "A decorator can only decorate a method implementation, not an overload."),
            Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5: diag(1250, ts.DiagnosticCategory.Error, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_1250", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'."),
            Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Class_definitions_are_automatically_in_strict_mode: diag(1251, ts.DiagnosticCategory.Error, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Class_d_1251", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'. Class definitions are automatically in strict mode."),
            Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Modules_are_automatically_in_strict_mode: diag(1252, ts.DiagnosticCategory.Error, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Modules_1252", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'. Modules are automatically in strict mode."),
            _0_tag_cannot_be_used_independently_as_a_top_level_JSDoc_tag: diag(1253, ts.DiagnosticCategory.Error, "_0_tag_cannot_be_used_independently_as_a_top_level_JSDoc_tag_1253", "'{0}' tag cannot be used independently as a top level JSDoc tag."),
            A_const_initializer_in_an_ambient_context_must_be_a_string_or_numeric_literal_or_literal_enum_reference: diag(1254, ts.DiagnosticCategory.Error, "A_const_initializer_in_an_ambient_context_must_be_a_string_or_numeric_literal_or_literal_enum_refere_1254", "A 'const' initializer in an ambient context must be a string or numeric literal or literal enum reference."),
            A_definite_assignment_assertion_is_not_permitted_in_this_context: diag(1255, ts.DiagnosticCategory.Error, "A_definite_assignment_assertion_is_not_permitted_in_this_context_1255", "A definite assignment assertion '!' is not permitted in this context."),
            A_rest_element_must_be_last_in_a_tuple_type: diag(1256, ts.DiagnosticCategory.Error, "A_rest_element_must_be_last_in_a_tuple_type_1256", "A rest element must be last in a tuple type."),
            A_required_element_cannot_follow_an_optional_element: diag(1257, ts.DiagnosticCategory.Error, "A_required_element_cannot_follow_an_optional_element_1257", "A required element cannot follow an optional element."),
            Definite_assignment_assertions_can_only_be_used_along_with_a_type_annotation: diag(1258, ts.DiagnosticCategory.Error, "Definite_assignment_assertions_can_only_be_used_along_with_a_type_annotation_1258", "Definite assignment assertions can only be used along with a type annotation."),
            Module_0_can_only_be_default_imported_using_the_1_flag: diag(1259, ts.DiagnosticCategory.Error, "Module_0_can_only_be_default_imported_using_the_1_flag_1259", "Module '{0}' can only be default-imported using the '{1}' flag"),
            Keywords_cannot_contain_escape_characters: diag(1260, ts.DiagnosticCategory.Error, "Keywords_cannot_contain_escape_characters_1260", "Keywords cannot contain escape characters."),
            Already_included_file_name_0_differs_from_file_name_1_only_in_casing: diag(1261, ts.DiagnosticCategory.Error, "Already_included_file_name_0_differs_from_file_name_1_only_in_casing_1261", "Already included file name '{0}' differs from file name '{1}' only in casing."),
            with_statements_are_not_allowed_in_an_async_function_block: diag(1300, ts.DiagnosticCategory.Error, "with_statements_are_not_allowed_in_an_async_function_block_1300", "'with' statements are not allowed in an async function block."),
            await_expressions_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules: diag(1308, ts.DiagnosticCategory.Error, "await_expressions_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules_1308", "'await' expressions are only allowed within async functions and at the top levels of modules."),
            can_only_be_used_in_an_object_literal_property_inside_a_destructuring_assignment: diag(1312, ts.DiagnosticCategory.Error, "can_only_be_used_in_an_object_literal_property_inside_a_destructuring_assignment_1312", "'=' can only be used in an object literal property inside a destructuring assignment."),
            The_body_of_an_if_statement_cannot_be_the_empty_statement: diag(1313, ts.DiagnosticCategory.Error, "The_body_of_an_if_statement_cannot_be_the_empty_statement_1313", "The body of an 'if' statement cannot be the empty statement."),
            Global_module_exports_may_only_appear_in_module_files: diag(1314, ts.DiagnosticCategory.Error, "Global_module_exports_may_only_appear_in_module_files_1314", "Global module exports may only appear in module files."),
            Global_module_exports_may_only_appear_in_declaration_files: diag(1315, ts.DiagnosticCategory.Error, "Global_module_exports_may_only_appear_in_declaration_files_1315", "Global module exports may only appear in declaration files."),
            Global_module_exports_may_only_appear_at_top_level: diag(1316, ts.DiagnosticCategory.Error, "Global_module_exports_may_only_appear_at_top_level_1316", "Global module exports may only appear at top level."),
            A_parameter_property_cannot_be_declared_using_a_rest_parameter: diag(1317, ts.DiagnosticCategory.Error, "A_parameter_property_cannot_be_declared_using_a_rest_parameter_1317", "A parameter property cannot be declared using a rest parameter."),
            An_abstract_accessor_cannot_have_an_implementation: diag(1318, ts.DiagnosticCategory.Error, "An_abstract_accessor_cannot_have_an_implementation_1318", "An abstract accessor cannot have an implementation."),
            A_default_export_can_only_be_used_in_an_ECMAScript_style_module: diag(1319, ts.DiagnosticCategory.Error, "A_default_export_can_only_be_used_in_an_ECMAScript_style_module_1319", "A default export can only be used in an ECMAScript-style module."),
            Type_of_await_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1320, ts.DiagnosticCategory.Error, "Type_of_await_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member_1320", "Type of 'await' operand must either be a valid promise or must not contain a callable 'then' member."),
            Type_of_yield_operand_in_an_async_generator_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1321, ts.DiagnosticCategory.Error, "Type_of_yield_operand_in_an_async_generator_must_either_be_a_valid_promise_or_must_not_contain_a_cal_1321", "Type of 'yield' operand in an async generator must either be a valid promise or must not contain a callable 'then' member."),
            Type_of_iterated_elements_of_a_yield_Asterisk_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1322, ts.DiagnosticCategory.Error, "Type_of_iterated_elements_of_a_yield_Asterisk_operand_must_either_be_a_valid_promise_or_must_not_con_1322", "Type of iterated elements of a 'yield*' operand must either be a valid promise or must not contain a callable 'then' member."),
            Dynamic_imports_are_only_supported_when_the_module_flag_is_set_to_es2020_esnext_commonjs_amd_system_or_umd: diag(1323, ts.DiagnosticCategory.Error, "Dynamic_imports_are_only_supported_when_the_module_flag_is_set_to_es2020_esnext_commonjs_amd_system__1323", "Dynamic imports are only supported when the '--module' flag is set to 'es2020', 'esnext', 'commonjs', 'amd', 'system', or 'umd'."),
            Dynamic_import_must_have_one_specifier_as_an_argument: diag(1324, ts.DiagnosticCategory.Error, "Dynamic_import_must_have_one_specifier_as_an_argument_1324", "Dynamic import must have one specifier as an argument."),
            Specifier_of_dynamic_import_cannot_be_spread_element: diag(1325, ts.DiagnosticCategory.Error, "Specifier_of_dynamic_import_cannot_be_spread_element_1325", "Specifier of dynamic import cannot be spread element."),
            Dynamic_import_cannot_have_type_arguments: diag(1326, ts.DiagnosticCategory.Error, "Dynamic_import_cannot_have_type_arguments_1326", "Dynamic import cannot have type arguments"),
            String_literal_with_double_quotes_expected: diag(1327, ts.DiagnosticCategory.Error, "String_literal_with_double_quotes_expected_1327", "String literal with double quotes expected."),
            Property_value_can_only_be_string_literal_numeric_literal_true_false_null_object_literal_or_array_literal: diag(1328, ts.DiagnosticCategory.Error, "Property_value_can_only_be_string_literal_numeric_literal_true_false_null_object_literal_or_array_li_1328", "Property value can only be string literal, numeric literal, 'true', 'false', 'null', object literal or array literal."),
            _0_accepts_too_few_arguments_to_be_used_as_a_decorator_here_Did_you_mean_to_call_it_first_and_write_0: diag(1329, ts.DiagnosticCategory.Error, "_0_accepts_too_few_arguments_to_be_used_as_a_decorator_here_Did_you_mean_to_call_it_first_and_write__1329", "'{0}' accepts too few arguments to be used as a decorator here. Did you mean to call it first and write '@{0}()'?"),
            A_property_of_an_interface_or_type_literal_whose_type_is_a_unique_symbol_type_must_be_readonly: diag(1330, ts.DiagnosticCategory.Error, "A_property_of_an_interface_or_type_literal_whose_type_is_a_unique_symbol_type_must_be_readonly_1330", "A property of an interface or type literal whose type is a 'unique symbol' type must be 'readonly'."),
            A_property_of_a_class_whose_type_is_a_unique_symbol_type_must_be_both_static_and_readonly: diag(1331, ts.DiagnosticCategory.Error, "A_property_of_a_class_whose_type_is_a_unique_symbol_type_must_be_both_static_and_readonly_1331", "A property of a class whose type is a 'unique symbol' type must be both 'static' and 'readonly'."),
            A_variable_whose_type_is_a_unique_symbol_type_must_be_const: diag(1332, ts.DiagnosticCategory.Error, "A_variable_whose_type_is_a_unique_symbol_type_must_be_const_1332", "A variable whose type is a 'unique symbol' type must be 'const'."),
            unique_symbol_types_may_not_be_used_on_a_variable_declaration_with_a_binding_name: diag(1333, ts.DiagnosticCategory.Error, "unique_symbol_types_may_not_be_used_on_a_variable_declaration_with_a_binding_name_1333", "'unique symbol' types may not be used on a variable declaration with a binding name."),
            unique_symbol_types_are_only_allowed_on_variables_in_a_variable_statement: diag(1334, ts.DiagnosticCategory.Error, "unique_symbol_types_are_only_allowed_on_variables_in_a_variable_statement_1334", "'unique symbol' types are only allowed on variables in a variable statement."),
            unique_symbol_types_are_not_allowed_here: diag(1335, ts.DiagnosticCategory.Error, "unique_symbol_types_are_not_allowed_here_1335", "'unique symbol' types are not allowed here."),
            An_index_signature_parameter_type_cannot_be_a_type_alias_Consider_writing_0_Colon_1_Colon_2_instead: diag(1336, ts.DiagnosticCategory.Error, "An_index_signature_parameter_type_cannot_be_a_type_alias_Consider_writing_0_Colon_1_Colon_2_instead_1336", "An index signature parameter type cannot be a type alias. Consider writing '[{0}: {1}]: {2}' instead."),
            An_index_signature_parameter_type_cannot_be_a_union_type_Consider_using_a_mapped_object_type_instead: diag(1337, ts.DiagnosticCategory.Error, "An_index_signature_parameter_type_cannot_be_a_union_type_Consider_using_a_mapped_object_type_instead_1337", "An index signature parameter type cannot be a union type. Consider using a mapped object type instead."),
            infer_declarations_are_only_permitted_in_the_extends_clause_of_a_conditional_type: diag(1338, ts.DiagnosticCategory.Error, "infer_declarations_are_only_permitted_in_the_extends_clause_of_a_conditional_type_1338", "'infer' declarations are only permitted in the 'extends' clause of a conditional type."),
            Module_0_does_not_refer_to_a_value_but_is_used_as_a_value_here: diag(1339, ts.DiagnosticCategory.Error, "Module_0_does_not_refer_to_a_value_but_is_used_as_a_value_here_1339", "Module '{0}' does not refer to a value, but is used as a value here."),
            Module_0_does_not_refer_to_a_type_but_is_used_as_a_type_here_Did_you_mean_typeof_import_0: diag(1340, ts.DiagnosticCategory.Error, "Module_0_does_not_refer_to_a_type_but_is_used_as_a_type_here_Did_you_mean_typeof_import_0_1340", "Module '{0}' does not refer to a type, but is used as a type here. Did you mean 'typeof import('{0}')'?"),
            Type_arguments_cannot_be_used_here: diag(1342, ts.DiagnosticCategory.Error, "Type_arguments_cannot_be_used_here_1342", "Type arguments cannot be used here."),
            The_import_meta_meta_property_is_only_allowed_when_the_module_option_is_esnext_or_system: diag(1343, ts.DiagnosticCategory.Error, "The_import_meta_meta_property_is_only_allowed_when_the_module_option_is_esnext_or_system_1343", "The 'import.meta' meta-property is only allowed when the '--module' option is 'esnext' or 'system'."),
            A_label_is_not_allowed_here: diag(1344, ts.DiagnosticCategory.Error, "A_label_is_not_allowed_here_1344", "'A label is not allowed here."),
            An_expression_of_type_void_cannot_be_tested_for_truthiness: diag(1345, ts.DiagnosticCategory.Error, "An_expression_of_type_void_cannot_be_tested_for_truthiness_1345", "An expression of type 'void' cannot be tested for truthiness"),
            This_parameter_is_not_allowed_with_use_strict_directive: diag(1346, ts.DiagnosticCategory.Error, "This_parameter_is_not_allowed_with_use_strict_directive_1346", "This parameter is not allowed with 'use strict' directive."),
            use_strict_directive_cannot_be_used_with_non_simple_parameter_list: diag(1347, ts.DiagnosticCategory.Error, "use_strict_directive_cannot_be_used_with_non_simple_parameter_list_1347", "'use strict' directive cannot be used with non-simple parameter list."),
            Non_simple_parameter_declared_here: diag(1348, ts.DiagnosticCategory.Error, "Non_simple_parameter_declared_here_1348", "Non-simple parameter declared here."),
            use_strict_directive_used_here: diag(1349, ts.DiagnosticCategory.Error, "use_strict_directive_used_here_1349", "'use strict' directive used here."),
            Print_the_final_configuration_instead_of_building: diag(1350, ts.DiagnosticCategory.Message, "Print_the_final_configuration_instead_of_building_1350", "Print the final configuration instead of building."),
            An_identifier_or_keyword_cannot_immediately_follow_a_numeric_literal: diag(1351, ts.DiagnosticCategory.Error, "An_identifier_or_keyword_cannot_immediately_follow_a_numeric_literal_1351", "An identifier or keyword cannot immediately follow a numeric literal."),
            A_bigint_literal_cannot_use_exponential_notation: diag(1352, ts.DiagnosticCategory.Error, "A_bigint_literal_cannot_use_exponential_notation_1352", "A bigint literal cannot use exponential notation."),
            A_bigint_literal_must_be_an_integer: diag(1353, ts.DiagnosticCategory.Error, "A_bigint_literal_must_be_an_integer_1353", "A bigint literal must be an integer."),
            readonly_type_modifier_is_only_permitted_on_array_and_tuple_literal_types: diag(1354, ts.DiagnosticCategory.Error, "readonly_type_modifier_is_only_permitted_on_array_and_tuple_literal_types_1354", "'readonly' type modifier is only permitted on array and tuple literal types."),
            A_const_assertions_can_only_be_applied_to_references_to_enum_members_or_string_number_boolean_array_or_object_literals: diag(1355, ts.DiagnosticCategory.Error, "A_const_assertions_can_only_be_applied_to_references_to_enum_members_or_string_number_boolean_array__1355", "A 'const' assertions can only be applied to references to enum members, or string, number, boolean, array, or object literals."),
            Did_you_mean_to_mark_this_function_as_async: diag(1356, ts.DiagnosticCategory.Error, "Did_you_mean_to_mark_this_function_as_async_1356", "Did you mean to mark this function as 'async'?"),
            An_enum_member_name_must_be_followed_by_a_or: diag(1357, ts.DiagnosticCategory.Error, "An_enum_member_name_must_be_followed_by_a_or_1357", "An enum member name must be followed by a ',', '=', or '}'."),
            Tagged_template_expressions_are_not_permitted_in_an_optional_chain: diag(1358, ts.DiagnosticCategory.Error, "Tagged_template_expressions_are_not_permitted_in_an_optional_chain_1358", "Tagged template expressions are not permitted in an optional chain."),
            Identifier_expected_0_is_a_reserved_word_that_cannot_be_used_here: diag(1359, ts.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_that_cannot_be_used_here_1359", "Identifier expected. '{0}' is a reserved word that cannot be used here."),
            Did_you_mean_to_parenthesize_this_function_type: diag(1360, ts.DiagnosticCategory.Error, "Did_you_mean_to_parenthesize_this_function_type_1360", "Did you mean to parenthesize this function type?"),
            _0_cannot_be_used_as_a_value_because_it_was_imported_using_import_type: diag(1361, ts.DiagnosticCategory.Error, "_0_cannot_be_used_as_a_value_because_it_was_imported_using_import_type_1361", "'{0}' cannot be used as a value because it was imported using 'import type'."),
            _0_cannot_be_used_as_a_value_because_it_was_exported_using_export_type: diag(1362, ts.DiagnosticCategory.Error, "_0_cannot_be_used_as_a_value_because_it_was_exported_using_export_type_1362", "'{0}' cannot be used as a value because it was exported using 'export type'."),
            A_type_only_import_can_specify_a_default_import_or_named_bindings_but_not_both: diag(1363, ts.DiagnosticCategory.Error, "A_type_only_import_can_specify_a_default_import_or_named_bindings_but_not_both_1363", "A type-only import can specify a default import or named bindings, but not both."),
            Convert_to_type_only_export: diag(1364, ts.DiagnosticCategory.Message, "Convert_to_type_only_export_1364", "Convert to type-only export"),
            Convert_all_re_exported_types_to_type_only_exports: diag(1365, ts.DiagnosticCategory.Message, "Convert_all_re_exported_types_to_type_only_exports_1365", "Convert all re-exported types to type-only exports"),
            Split_into_two_separate_import_declarations: diag(1366, ts.DiagnosticCategory.Message, "Split_into_two_separate_import_declarations_1366", "Split into two separate import declarations"),
            Split_all_invalid_type_only_imports: diag(1367, ts.DiagnosticCategory.Message, "Split_all_invalid_type_only_imports_1367", "Split all invalid type-only imports"),
            Specify_emit_Slashchecking_behavior_for_imports_that_are_only_used_for_types: diag(1368, ts.DiagnosticCategory.Message, "Specify_emit_Slashchecking_behavior_for_imports_that_are_only_used_for_types_1368", "Specify emit/checking behavior for imports that are only used for types"),
            Did_you_mean_0: diag(1369, ts.DiagnosticCategory.Message, "Did_you_mean_0_1369", "Did you mean '{0}'?"),
            Only_ECMAScript_imports_may_use_import_type: diag(1370, ts.DiagnosticCategory.Error, "Only_ECMAScript_imports_may_use_import_type_1370", "Only ECMAScript imports may use 'import type'."),
            This_import_is_never_used_as_a_value_and_must_use_import_type_because_the_importsNotUsedAsValues_is_set_to_error: diag(1371, ts.DiagnosticCategory.Error, "This_import_is_never_used_as_a_value_and_must_use_import_type_because_the_importsNotUsedAsValues_is__1371", "This import is never used as a value and must use 'import type' because the 'importsNotUsedAsValues' is set to 'error'."),
            Convert_to_type_only_import: diag(1373, ts.DiagnosticCategory.Message, "Convert_to_type_only_import_1373", "Convert to type-only import"),
            Convert_all_imports_not_used_as_a_value_to_type_only_imports: diag(1374, ts.DiagnosticCategory.Message, "Convert_all_imports_not_used_as_a_value_to_type_only_imports_1374", "Convert all imports not used as a value to type-only imports"),
            await_expressions_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_has_no_imports_or_exports_Consider_adding_an_empty_export_to_make_this_file_a_module: diag(1375, ts.DiagnosticCategory.Error, "await_expressions_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_fi_1375", "'await' expressions are only allowed at the top level of a file when that file is a module, but this file has no imports or exports. Consider adding an empty 'export {}' to make this file a module."),
            _0_was_imported_here: diag(1376, ts.DiagnosticCategory.Message, "_0_was_imported_here_1376", "'{0}' was imported here."),
            _0_was_exported_here: diag(1377, ts.DiagnosticCategory.Message, "_0_was_exported_here_1377", "'{0}' was exported here."),
            Top_level_await_expressions_are_only_allowed_when_the_module_option_is_set_to_esnext_or_system_and_the_target_option_is_set_to_es2017_or_higher: diag(1378, ts.DiagnosticCategory.Error, "Top_level_await_expressions_are_only_allowed_when_the_module_option_is_set_to_esnext_or_system_and_t_1378", "Top-level 'await' expressions are only allowed when the 'module' option is set to 'esnext' or 'system', and the 'target' option is set to 'es2017' or higher."),
            An_import_alias_cannot_reference_a_declaration_that_was_exported_using_export_type: diag(1379, ts.DiagnosticCategory.Error, "An_import_alias_cannot_reference_a_declaration_that_was_exported_using_export_type_1379", "An import alias cannot reference a declaration that was exported using 'export type'."),
            An_import_alias_cannot_reference_a_declaration_that_was_imported_using_import_type: diag(1380, ts.DiagnosticCategory.Error, "An_import_alias_cannot_reference_a_declaration_that_was_imported_using_import_type_1380", "An import alias cannot reference a declaration that was imported using 'import type'."),
            Only_named_exports_may_use_export_type: diag(1383, ts.DiagnosticCategory.Error, "Only_named_exports_may_use_export_type_1383", "Only named exports may use 'export type'."),
            The_types_of_0_are_incompatible_between_these_types: diag(2200, ts.DiagnosticCategory.Error, "The_types_of_0_are_incompatible_between_these_types_2200", "The types of '{0}' are incompatible between these types."),
            The_types_returned_by_0_are_incompatible_between_these_types: diag(2201, ts.DiagnosticCategory.Error, "The_types_returned_by_0_are_incompatible_between_these_types_2201", "The types returned by '{0}' are incompatible between these types."),
            Call_signature_return_types_0_and_1_are_incompatible: diag(2202, ts.DiagnosticCategory.Error, "Call_signature_return_types_0_and_1_are_incompatible_2202", "Call signature return types '{0}' and '{1}' are incompatible.", /*reportsUnnecessary*/ undefined, /*elidedInCompatabilityPyramid*/ true),
            Construct_signature_return_types_0_and_1_are_incompatible: diag(2203, ts.DiagnosticCategory.Error, "Construct_signature_return_types_0_and_1_are_incompatible_2203", "Construct signature return types '{0}' and '{1}' are incompatible.", /*reportsUnnecessary*/ undefined, /*elidedInCompatabilityPyramid*/ true),
            Call_signatures_with_no_arguments_have_incompatible_return_types_0_and_1: diag(2204, ts.DiagnosticCategory.Error, "Call_signatures_with_no_arguments_have_incompatible_return_types_0_and_1_2204", "Call signatures with no arguments have incompatible return types '{0}' and '{1}'.", /*reportsUnnecessary*/ undefined, /*elidedInCompatabilityPyramid*/ true),
            Construct_signatures_with_no_arguments_have_incompatible_return_types_0_and_1: diag(2205, ts.DiagnosticCategory.Error, "Construct_signatures_with_no_arguments_have_incompatible_return_types_0_and_1_2205", "Construct signatures with no arguments have incompatible return types '{0}' and '{1}'.", /*reportsUnnecessary*/ undefined, /*elidedInCompatabilityPyramid*/ true),
            Duplicate_identifier_0: diag(2300, ts.DiagnosticCategory.Error, "Duplicate_identifier_0_2300", "Duplicate identifier '{0}'."),
            Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor: diag(2301, ts.DiagnosticCategory.Error, "Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor_2301", "Initializer of instance member variable '{0}' cannot reference identifier '{1}' declared in the constructor."),
            Static_members_cannot_reference_class_type_parameters: diag(2302, ts.DiagnosticCategory.Error, "Static_members_cannot_reference_class_type_parameters_2302", "Static members cannot reference class type parameters."),
            Circular_definition_of_import_alias_0: diag(2303, ts.DiagnosticCategory.Error, "Circular_definition_of_import_alias_0_2303", "Circular definition of import alias '{0}'."),
            Cannot_find_name_0: diag(2304, ts.DiagnosticCategory.Error, "Cannot_find_name_0_2304", "Cannot find name '{0}'."),
            Module_0_has_no_exported_member_1: diag(2305, ts.DiagnosticCategory.Error, "Module_0_has_no_exported_member_1_2305", "Module '{0}' has no exported member '{1}'."),
            File_0_is_not_a_module: diag(2306, ts.DiagnosticCategory.Error, "File_0_is_not_a_module_2306", "File '{0}' is not a module."),
            Cannot_find_module_0: diag(2307, ts.DiagnosticCategory.Error, "Cannot_find_module_0_2307", "Cannot find module '{0}'."),
            Module_0_has_already_exported_a_member_named_1_Consider_explicitly_re_exporting_to_resolve_the_ambiguity: diag(2308, ts.DiagnosticCategory.Error, "Module_0_has_already_exported_a_member_named_1_Consider_explicitly_re_exporting_to_resolve_the_ambig_2308", "Module {0} has already exported a member named '{1}'. Consider explicitly re-exporting to resolve the ambiguity."),
            An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements: diag(2309, ts.DiagnosticCategory.Error, "An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements_2309", "An export assignment cannot be used in a module with other exported elements."),
            Type_0_recursively_references_itself_as_a_base_type: diag(2310, ts.DiagnosticCategory.Error, "Type_0_recursively_references_itself_as_a_base_type_2310", "Type '{0}' recursively references itself as a base type."),
            A_class_may_only_extend_another_class: diag(2311, ts.DiagnosticCategory.Error, "A_class_may_only_extend_another_class_2311", "A class may only extend another class."),
            An_interface_can_only_extend_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2312, ts.DiagnosticCategory.Error, "An_interface_can_only_extend_an_object_type_or_intersection_of_object_types_with_statically_known_me_2312", "An interface can only extend an object type or intersection of object types with statically known members."),
            Type_parameter_0_has_a_circular_constraint: diag(2313, ts.DiagnosticCategory.Error, "Type_parameter_0_has_a_circular_constraint_2313", "Type parameter '{0}' has a circular constraint."),
            Generic_type_0_requires_1_type_argument_s: diag(2314, ts.DiagnosticCategory.Error, "Generic_type_0_requires_1_type_argument_s_2314", "Generic type '{0}' requires {1} type argument(s)."),
            Type_0_is_not_generic: diag(2315, ts.DiagnosticCategory.Error, "Type_0_is_not_generic_2315", "Type '{0}' is not generic."),
            Global_type_0_must_be_a_class_or_interface_type: diag(2316, ts.DiagnosticCategory.Error, "Global_type_0_must_be_a_class_or_interface_type_2316", "Global type '{0}' must be a class or interface type."),
            Global_type_0_must_have_1_type_parameter_s: diag(2317, ts.DiagnosticCategory.Error, "Global_type_0_must_have_1_type_parameter_s_2317", "Global type '{0}' must have {1} type parameter(s)."),
            Cannot_find_global_type_0: diag(2318, ts.DiagnosticCategory.Error, "Cannot_find_global_type_0_2318", "Cannot find global type '{0}'."),
            Named_property_0_of_types_1_and_2_are_not_identical: diag(2319, ts.DiagnosticCategory.Error, "Named_property_0_of_types_1_and_2_are_not_identical_2319", "Named property '{0}' of types '{1}' and '{2}' are not identical."),
            Interface_0_cannot_simultaneously_extend_types_1_and_2: diag(2320, ts.DiagnosticCategory.Error, "Interface_0_cannot_simultaneously_extend_types_1_and_2_2320", "Interface '{0}' cannot simultaneously extend types '{1}' and '{2}'."),
            Excessive_stack_depth_comparing_types_0_and_1: diag(2321, ts.DiagnosticCategory.Error, "Excessive_stack_depth_comparing_types_0_and_1_2321", "Excessive stack depth comparing types '{0}' and '{1}'."),
            Type_0_is_not_assignable_to_type_1: diag(2322, ts.DiagnosticCategory.Error, "Type_0_is_not_assignable_to_type_1_2322", "Type '{0}' is not assignable to type '{1}'."),
            Cannot_redeclare_exported_variable_0: diag(2323, ts.DiagnosticCategory.Error, "Cannot_redeclare_exported_variable_0_2323", "Cannot redeclare exported variable '{0}'."),
            Property_0_is_missing_in_type_1: diag(2324, ts.DiagnosticCategory.Error, "Property_0_is_missing_in_type_1_2324", "Property '{0}' is missing in type '{1}'."),
            Property_0_is_private_in_type_1_but_not_in_type_2: diag(2325, ts.DiagnosticCategory.Error, "Property_0_is_private_in_type_1_but_not_in_type_2_2325", "Property '{0}' is private in type '{1}' but not in type '{2}'."),
            Types_of_property_0_are_incompatible: diag(2326, ts.DiagnosticCategory.Error, "Types_of_property_0_are_incompatible_2326", "Types of property '{0}' are incompatible."),
            Property_0_is_optional_in_type_1_but_required_in_type_2: diag(2327, ts.DiagnosticCategory.Error, "Property_0_is_optional_in_type_1_but_required_in_type_2_2327", "Property '{0}' is optional in type '{1}' but required in type '{2}'."),
            Types_of_parameters_0_and_1_are_incompatible: diag(2328, ts.DiagnosticCategory.Error, "Types_of_parameters_0_and_1_are_incompatible_2328", "Types of parameters '{0}' and '{1}' are incompatible."),
            Index_signature_is_missing_in_type_0: diag(2329, ts.DiagnosticCategory.Error, "Index_signature_is_missing_in_type_0_2329", "Index signature is missing in type '{0}'."),
            Index_signatures_are_incompatible: diag(2330, ts.DiagnosticCategory.Error, "Index_signatures_are_incompatible_2330", "Index signatures are incompatible."),
            this_cannot_be_referenced_in_a_module_or_namespace_body: diag(2331, ts.DiagnosticCategory.Error, "this_cannot_be_referenced_in_a_module_or_namespace_body_2331", "'this' cannot be referenced in a module or namespace body."),
            this_cannot_be_referenced_in_current_location: diag(2332, ts.DiagnosticCategory.Error, "this_cannot_be_referenced_in_current_location_2332", "'this' cannot be referenced in current location."),
            this_cannot_be_referenced_in_constructor_arguments: diag(2333, ts.DiagnosticCategory.Error, "this_cannot_be_referenced_in_constructor_arguments_2333", "'this' cannot be referenced in constructor arguments."),
            this_cannot_be_referenced_in_a_static_property_initializer: diag(2334, ts.DiagnosticCategory.Error, "this_cannot_be_referenced_in_a_static_property_initializer_2334", "'this' cannot be referenced in a static property initializer."),
            super_can_only_be_referenced_in_a_derived_class: diag(2335, ts.DiagnosticCategory.Error, "super_can_only_be_referenced_in_a_derived_class_2335", "'super' can only be referenced in a derived class."),
            super_cannot_be_referenced_in_constructor_arguments: diag(2336, ts.DiagnosticCategory.Error, "super_cannot_be_referenced_in_constructor_arguments_2336", "'super' cannot be referenced in constructor arguments."),
            Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors: diag(2337, ts.DiagnosticCategory.Error, "Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors_2337", "Super calls are not permitted outside constructors or in nested functions inside constructors."),
            super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_derived_class: diag(2338, ts.DiagnosticCategory.Error, "super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_der_2338", "'super' property access is permitted only in a constructor, member function, or member accessor of a derived class."),
            Property_0_does_not_exist_on_type_1: diag(2339, ts.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_2339", "Property '{0}' does not exist on type '{1}'."),
            Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword: diag(2340, ts.DiagnosticCategory.Error, "Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword_2340", "Only public and protected methods of the base class are accessible via the 'super' keyword."),
            Property_0_is_private_and_only_accessible_within_class_1: diag(2341, ts.DiagnosticCategory.Error, "Property_0_is_private_and_only_accessible_within_class_1_2341", "Property '{0}' is private and only accessible within class '{1}'."),
            An_index_expression_argument_must_be_of_type_string_number_symbol_or_any: diag(2342, ts.DiagnosticCategory.Error, "An_index_expression_argument_must_be_of_type_string_number_symbol_or_any_2342", "An index expression argument must be of type 'string', 'number', 'symbol', or 'any'."),
            This_syntax_requires_an_imported_helper_named_1_which_does_not_exist_in_0_Consider_upgrading_your_version_of_0: diag(2343, ts.DiagnosticCategory.Error, "This_syntax_requires_an_imported_helper_named_1_which_does_not_exist_in_0_Consider_upgrading_your_ve_2343", "This syntax requires an imported helper named '{1}' which does not exist in '{0}'. Consider upgrading your version of '{0}'."),
            Type_0_does_not_satisfy_the_constraint_1: diag(2344, ts.DiagnosticCategory.Error, "Type_0_does_not_satisfy_the_constraint_1_2344", "Type '{0}' does not satisfy the constraint '{1}'."),
            Argument_of_type_0_is_not_assignable_to_parameter_of_type_1: diag(2345, ts.DiagnosticCategory.Error, "Argument_of_type_0_is_not_assignable_to_parameter_of_type_1_2345", "Argument of type '{0}' is not assignable to parameter of type '{1}'."),
            Call_target_does_not_contain_any_signatures: diag(2346, ts.DiagnosticCategory.Error, "Call_target_does_not_contain_any_signatures_2346", "Call target does not contain any signatures."),
            Untyped_function_calls_may_not_accept_type_arguments: diag(2347, ts.DiagnosticCategory.Error, "Untyped_function_calls_may_not_accept_type_arguments_2347", "Untyped function calls may not accept type arguments."),
            Value_of_type_0_is_not_callable_Did_you_mean_to_include_new: diag(2348, ts.DiagnosticCategory.Error, "Value_of_type_0_is_not_callable_Did_you_mean_to_include_new_2348", "Value of type '{0}' is not callable. Did you mean to include 'new'?"),
            This_expression_is_not_callable: diag(2349, ts.DiagnosticCategory.Error, "This_expression_is_not_callable_2349", "This expression is not callable."),
            Only_a_void_function_can_be_called_with_the_new_keyword: diag(2350, ts.DiagnosticCategory.Error, "Only_a_void_function_can_be_called_with_the_new_keyword_2350", "Only a void function can be called with the 'new' keyword."),
            This_expression_is_not_constructable: diag(2351, ts.DiagnosticCategory.Error, "This_expression_is_not_constructable_2351", "This expression is not constructable."),
            Conversion_of_type_0_to_type_1_may_be_a_mistake_because_neither_type_sufficiently_overlaps_with_the_other_If_this_was_intentional_convert_the_expression_to_unknown_first: diag(2352, ts.DiagnosticCategory.Error, "Conversion_of_type_0_to_type_1_may_be_a_mistake_because_neither_type_sufficiently_overlaps_with_the__2352", "Conversion of type '{0}' to type '{1}' may be a mistake because neither type sufficiently overlaps with the other. If this was intentional, convert the expression to 'unknown' first."),
            Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1: diag(2353, ts.DiagnosticCategory.Error, "Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1_2353", "Object literal may only specify known properties, and '{0}' does not exist in type '{1}'."),
            This_syntax_requires_an_imported_helper_but_module_0_cannot_be_found: diag(2354, ts.DiagnosticCategory.Error, "This_syntax_requires_an_imported_helper_but_module_0_cannot_be_found_2354", "This syntax requires an imported helper but module '{0}' cannot be found."),
            A_function_whose_declared_type_is_neither_void_nor_any_must_return_a_value: diag(2355, ts.DiagnosticCategory.Error, "A_function_whose_declared_type_is_neither_void_nor_any_must_return_a_value_2355", "A function whose declared type is neither 'void' nor 'any' must return a value."),
            An_arithmetic_operand_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2356, ts.DiagnosticCategory.Error, "An_arithmetic_operand_must_be_of_type_any_number_bigint_or_an_enum_type_2356", "An arithmetic operand must be of type 'any', 'number', 'bigint' or an enum type."),
            The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access: diag(2357, ts.DiagnosticCategory.Error, "The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access_2357", "The operand of an increment or decrement operator must be a variable or a property access."),
            The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_parameter: diag(2358, ts.DiagnosticCategory.Error, "The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_paramete_2358", "The left-hand side of an 'instanceof' expression must be of type 'any', an object type or a type parameter."),
            The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_Function_interface_type: diag(2359, ts.DiagnosticCategory.Error, "The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_F_2359", "The right-hand side of an 'instanceof' expression must be of type 'any' or of a type assignable to the 'Function' interface type."),
            The_left_hand_side_of_an_in_expression_must_be_of_type_any_string_number_or_symbol: diag(2360, ts.DiagnosticCategory.Error, "The_left_hand_side_of_an_in_expression_must_be_of_type_any_string_number_or_symbol_2360", "The left-hand side of an 'in' expression must be of type 'any', 'string', 'number', or 'symbol'."),
            The_right_hand_side_of_an_in_expression_must_be_of_type_any_an_object_type_or_a_type_parameter: diag(2361, ts.DiagnosticCategory.Error, "The_right_hand_side_of_an_in_expression_must_be_of_type_any_an_object_type_or_a_type_parameter_2361", "The right-hand side of an 'in' expression must be of type 'any', an object type or a type parameter."),
            The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2362, ts.DiagnosticCategory.Error, "The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type_2362", "The left-hand side of an arithmetic operation must be of type 'any', 'number', 'bigint' or an enum type."),
            The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2363, ts.DiagnosticCategory.Error, "The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type_2363", "The right-hand side of an arithmetic operation must be of type 'any', 'number', 'bigint' or an enum type."),
            The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access: diag(2364, ts.DiagnosticCategory.Error, "The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access_2364", "The left-hand side of an assignment expression must be a variable or a property access."),
            Operator_0_cannot_be_applied_to_types_1_and_2: diag(2365, ts.DiagnosticCategory.Error, "Operator_0_cannot_be_applied_to_types_1_and_2_2365", "Operator '{0}' cannot be applied to types '{1}' and '{2}'."),
            Function_lacks_ending_return_statement_and_return_type_does_not_include_undefined: diag(2366, ts.DiagnosticCategory.Error, "Function_lacks_ending_return_statement_and_return_type_does_not_include_undefined_2366", "Function lacks ending return statement and return type does not include 'undefined'."),
            This_condition_will_always_return_0_since_the_types_1_and_2_have_no_overlap: diag(2367, ts.DiagnosticCategory.Error, "This_condition_will_always_return_0_since_the_types_1_and_2_have_no_overlap_2367", "This condition will always return '{0}' since the types '{1}' and '{2}' have no overlap."),
            Type_parameter_name_cannot_be_0: diag(2368, ts.DiagnosticCategory.Error, "Type_parameter_name_cannot_be_0_2368", "Type parameter name cannot be '{0}'."),
            A_parameter_property_is_only_allowed_in_a_constructor_implementation: diag(2369, ts.DiagnosticCategory.Error, "A_parameter_property_is_only_allowed_in_a_constructor_implementation_2369", "A parameter property is only allowed in a constructor implementation."),
            A_rest_parameter_must_be_of_an_array_type: diag(2370, ts.DiagnosticCategory.Error, "A_rest_parameter_must_be_of_an_array_type_2370", "A rest parameter must be of an array type."),
            A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation: diag(2371, ts.DiagnosticCategory.Error, "A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation_2371", "A parameter initializer is only allowed in a function or constructor implementation."),
            Parameter_0_cannot_be_referenced_in_its_initializer: diag(2372, ts.DiagnosticCategory.Error, "Parameter_0_cannot_be_referenced_in_its_initializer_2372", "Parameter '{0}' cannot be referenced in its initializer."),
            Initializer_of_parameter_0_cannot_reference_identifier_1_declared_after_it: diag(2373, ts.DiagnosticCategory.Error, "Initializer_of_parameter_0_cannot_reference_identifier_1_declared_after_it_2373", "Initializer of parameter '{0}' cannot reference identifier '{1}' declared after it."),
            Duplicate_string_index_signature: diag(2374, ts.DiagnosticCategory.Error, "Duplicate_string_index_signature_2374", "Duplicate string index signature."),
            Duplicate_number_index_signature: diag(2375, ts.DiagnosticCategory.Error, "Duplicate_number_index_signature_2375", "Duplicate number index signature."),
            A_super_call_must_be_the_first_statement_in_the_constructor_when_a_class_contains_initialized_properties_parameter_properties_or_private_identifiers: diag(2376, ts.DiagnosticCategory.Error, "A_super_call_must_be_the_first_statement_in_the_constructor_when_a_class_contains_initialized_proper_2376", "A 'super' call must be the first statement in the constructor when a class contains initialized properties, parameter properties, or private identifiers."),
            Constructors_for_derived_classes_must_contain_a_super_call: diag(2377, ts.DiagnosticCategory.Error, "Constructors_for_derived_classes_must_contain_a_super_call_2377", "Constructors for derived classes must contain a 'super' call."),
            A_get_accessor_must_return_a_value: diag(2378, ts.DiagnosticCategory.Error, "A_get_accessor_must_return_a_value_2378", "A 'get' accessor must return a value."),
            Getter_and_setter_accessors_do_not_agree_in_visibility: diag(2379, ts.DiagnosticCategory.Error, "Getter_and_setter_accessors_do_not_agree_in_visibility_2379", "Getter and setter accessors do not agree in visibility."),
            get_and_set_accessor_must_have_the_same_type: diag(2380, ts.DiagnosticCategory.Error, "get_and_set_accessor_must_have_the_same_type_2380", "'get' and 'set' accessor must have the same type."),
            A_signature_with_an_implementation_cannot_use_a_string_literal_type: diag(2381, ts.DiagnosticCategory.Error, "A_signature_with_an_implementation_cannot_use_a_string_literal_type_2381", "A signature with an implementation cannot use a string literal type."),
            Specialized_overload_signature_is_not_assignable_to_any_non_specialized_signature: diag(2382, ts.DiagnosticCategory.Error, "Specialized_overload_signature_is_not_assignable_to_any_non_specialized_signature_2382", "Specialized overload signature is not assignable to any non-specialized signature."),
            Overload_signatures_must_all_be_exported_or_non_exported: diag(2383, ts.DiagnosticCategory.Error, "Overload_signatures_must_all_be_exported_or_non_exported_2383", "Overload signatures must all be exported or non-exported."),
            Overload_signatures_must_all_be_ambient_or_non_ambient: diag(2384, ts.DiagnosticCategory.Error, "Overload_signatures_must_all_be_ambient_or_non_ambient_2384", "Overload signatures must all be ambient or non-ambient."),
            Overload_signatures_must_all_be_public_private_or_protected: diag(2385, ts.DiagnosticCategory.Error, "Overload_signatures_must_all_be_public_private_or_protected_2385", "Overload signatures must all be public, private or protected."),
            Overload_signatures_must_all_be_optional_or_required: diag(2386, ts.DiagnosticCategory.Error, "Overload_signatures_must_all_be_optional_or_required_2386", "Overload signatures must all be optional or required."),
            Function_overload_must_be_static: diag(2387, ts.DiagnosticCategory.Error, "Function_overload_must_be_static_2387", "Function overload must be static."),
            Function_overload_must_not_be_static: diag(2388, ts.DiagnosticCategory.Error, "Function_overload_must_not_be_static_2388", "Function overload must not be static."),
            Function_implementation_name_must_be_0: diag(2389, ts.DiagnosticCategory.Error, "Function_implementation_name_must_be_0_2389", "Function implementation name must be '{0}'."),
            Constructor_implementation_is_missing: diag(2390, ts.DiagnosticCategory.Error, "Constructor_implementation_is_missing_2390", "Constructor implementation is missing."),
            Function_implementation_is_missing_or_not_immediately_following_the_declaration: diag(2391, ts.DiagnosticCategory.Error, "Function_implementation_is_missing_or_not_immediately_following_the_declaration_2391", "Function implementation is missing or not immediately following the declaration."),
            Multiple_constructor_implementations_are_not_allowed: diag(2392, ts.DiagnosticCategory.Error, "Multiple_constructor_implementations_are_not_allowed_2392", "Multiple constructor implementations are not allowed."),
            Duplicate_function_implementation: diag(2393, ts.DiagnosticCategory.Error, "Duplicate_function_implementation_2393", "Duplicate function implementation."),
            This_overload_signature_is_not_compatible_with_its_implementation_signature: diag(2394, ts.DiagnosticCategory.Error, "This_overload_signature_is_not_compatible_with_its_implementation_signature_2394", "This overload signature is not compatible with its implementation signature."),
            Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local: diag(2395, ts.DiagnosticCategory.Error, "Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local_2395", "Individual declarations in merged declaration '{0}' must be all exported or all local."),
            Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters: diag(2396, ts.DiagnosticCategory.Error, "Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters_2396", "Duplicate identifier 'arguments'. Compiler uses 'arguments' to initialize rest parameters."),
            Declaration_name_conflicts_with_built_in_global_identifier_0: diag(2397, ts.DiagnosticCategory.Error, "Declaration_name_conflicts_with_built_in_global_identifier_0_2397", "Declaration name conflicts with built-in global identifier '{0}'."),
            Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference: diag(2399, ts.DiagnosticCategory.Error, "Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference_2399", "Duplicate identifier '_this'. Compiler uses variable declaration '_this' to capture 'this' reference."),
            Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference: diag(2400, ts.DiagnosticCategory.Error, "Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference_2400", "Expression resolves to variable declaration '_this' that compiler uses to capture 'this' reference."),
            Duplicate_identifier_super_Compiler_uses_super_to_capture_base_class_reference: diag(2401, ts.DiagnosticCategory.Error, "Duplicate_identifier_super_Compiler_uses_super_to_capture_base_class_reference_2401", "Duplicate identifier '_super'. Compiler uses '_super' to capture base class reference."),
            Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference: diag(2402, ts.DiagnosticCategory.Error, "Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference_2402", "Expression resolves to '_super' that compiler uses to capture base class reference."),
            Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_type_2: diag(2403, ts.DiagnosticCategory.Error, "Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_t_2403", "Subsequent variable declarations must have the same type.  Variable '{0}' must be of type '{1}', but here has type '{2}'."),
            The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation: diag(2404, ts.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation_2404", "The left-hand side of a 'for...in' statement cannot use a type annotation."),
            The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any: diag(2405, ts.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any_2405", "The left-hand side of a 'for...in' statement must be of type 'string' or 'any'."),
            The_left_hand_side_of_a_for_in_statement_must_be_a_variable_or_a_property_access: diag(2406, ts.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_must_be_a_variable_or_a_property_access_2406", "The left-hand side of a 'for...in' statement must be a variable or a property access."),
            The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter_but_here_has_type_0: diag(2407, ts.DiagnosticCategory.Error, "The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter_but_2407", "The right-hand side of a 'for...in' statement must be of type 'any', an object type or a type parameter, but here has type '{0}'."),
            Setters_cannot_return_a_value: diag(2408, ts.DiagnosticCategory.Error, "Setters_cannot_return_a_value_2408", "Setters cannot return a value."),
            Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class: diag(2409, ts.DiagnosticCategory.Error, "Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class_2409", "Return type of constructor signature must be assignable to the instance type of the class."),
            The_with_statement_is_not_supported_All_symbols_in_a_with_block_will_have_type_any: diag(2410, ts.DiagnosticCategory.Error, "The_with_statement_is_not_supported_All_symbols_in_a_with_block_will_have_type_any_2410", "The 'with' statement is not supported. All symbols in a 'with' block will have type 'any'."),
            Property_0_of_type_1_is_not_assignable_to_string_index_type_2: diag(2411, ts.DiagnosticCategory.Error, "Property_0_of_type_1_is_not_assignable_to_string_index_type_2_2411", "Property '{0}' of type '{1}' is not assignable to string index type '{2}'."),
            Property_0_of_type_1_is_not_assignable_to_numeric_index_type_2: diag(2412, ts.DiagnosticCategory.Error, "Property_0_of_type_1_is_not_assignable_to_numeric_index_type_2_2412", "Property '{0}' of type '{1}' is not assignable to numeric index type '{2}'."),
            Numeric_index_type_0_is_not_assignable_to_string_index_type_1: diag(2413, ts.DiagnosticCategory.Error, "Numeric_index_type_0_is_not_assignable_to_string_index_type_1_2413", "Numeric index type '{0}' is not assignable to string index type '{1}'."),
            Class_name_cannot_be_0: diag(2414, ts.DiagnosticCategory.Error, "Class_name_cannot_be_0_2414", "Class name cannot be '{0}'."),
            Class_0_incorrectly_extends_base_class_1: diag(2415, ts.DiagnosticCategory.Error, "Class_0_incorrectly_extends_base_class_1_2415", "Class '{0}' incorrectly extends base class '{1}'."),
            Property_0_in_type_1_is_not_assignable_to_the_same_property_in_base_type_2: diag(2416, ts.DiagnosticCategory.Error, "Property_0_in_type_1_is_not_assignable_to_the_same_property_in_base_type_2_2416", "Property '{0}' in type '{1}' is not assignable to the same property in base type '{2}'."),
            Class_static_side_0_incorrectly_extends_base_class_static_side_1: diag(2417, ts.DiagnosticCategory.Error, "Class_static_side_0_incorrectly_extends_base_class_static_side_1_2417", "Class static side '{0}' incorrectly extends base class static side '{1}'."),
            Type_of_computed_property_s_value_is_0_which_is_not_assignable_to_type_1: diag(2418, ts.DiagnosticCategory.Error, "Type_of_computed_property_s_value_is_0_which_is_not_assignable_to_type_1_2418", "Type of computed property's value is '{0}', which is not assignable to type '{1}'."),
            Class_0_incorrectly_implements_interface_1: diag(2420, ts.DiagnosticCategory.Error, "Class_0_incorrectly_implements_interface_1_2420", "Class '{0}' incorrectly implements interface '{1}'."),
            A_class_can_only_implement_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2422, ts.DiagnosticCategory.Error, "A_class_can_only_implement_an_object_type_or_intersection_of_object_types_with_statically_known_memb_2422", "A class can only implement an object type or intersection of object types with statically known members."),
            Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_accessor: diag(2423, ts.DiagnosticCategory.Error, "Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_access_2423", "Class '{0}' defines instance member function '{1}', but extended class '{2}' defines it as instance member accessor."),
            Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_function: diag(2425, ts.DiagnosticCategory.Error, "Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_functi_2425", "Class '{0}' defines instance member property '{1}', but extended class '{2}' defines it as instance member function."),
            Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_function: diag(2426, ts.DiagnosticCategory.Error, "Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_functi_2426", "Class '{0}' defines instance member accessor '{1}', but extended class '{2}' defines it as instance member function."),
            Interface_name_cannot_be_0: diag(2427, ts.DiagnosticCategory.Error, "Interface_name_cannot_be_0_2427", "Interface name cannot be '{0}'."),
            All_declarations_of_0_must_have_identical_type_parameters: diag(2428, ts.DiagnosticCategory.Error, "All_declarations_of_0_must_have_identical_type_parameters_2428", "All declarations of '{0}' must have identical type parameters."),
            Interface_0_incorrectly_extends_interface_1: diag(2430, ts.DiagnosticCategory.Error, "Interface_0_incorrectly_extends_interface_1_2430", "Interface '{0}' incorrectly extends interface '{1}'."),
            Enum_name_cannot_be_0: diag(2431, ts.DiagnosticCategory.Error, "Enum_name_cannot_be_0_2431", "Enum name cannot be '{0}'."),
            In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enum_element: diag(2432, ts.DiagnosticCategory.Error, "In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enu_2432", "In an enum with multiple declarations, only one declaration can omit an initializer for its first enum element."),
            A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merged: diag(2433, ts.DiagnosticCategory.Error, "A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merg_2433", "A namespace declaration cannot be in a different file from a class or function with which it is merged."),
            A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged: diag(2434, ts.DiagnosticCategory.Error, "A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged_2434", "A namespace declaration cannot be located prior to a class or function with which it is merged."),
            Ambient_modules_cannot_be_nested_in_other_modules_or_namespaces: diag(2435, ts.DiagnosticCategory.Error, "Ambient_modules_cannot_be_nested_in_other_modules_or_namespaces_2435", "Ambient modules cannot be nested in other modules or namespaces."),
            Ambient_module_declaration_cannot_specify_relative_module_name: diag(2436, ts.DiagnosticCategory.Error, "Ambient_module_declaration_cannot_specify_relative_module_name_2436", "Ambient module declaration cannot specify relative module name."),
            Module_0_is_hidden_by_a_local_declaration_with_the_same_name: diag(2437, ts.DiagnosticCategory.Error, "Module_0_is_hidden_by_a_local_declaration_with_the_same_name_2437", "Module '{0}' is hidden by a local declaration with the same name."),
            Import_name_cannot_be_0: diag(2438, ts.DiagnosticCategory.Error, "Import_name_cannot_be_0_2438", "Import name cannot be '{0}'."),
            Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relative_module_name: diag(2439, ts.DiagnosticCategory.Error, "Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relati_2439", "Import or export declaration in an ambient module declaration cannot reference module through relative module name."),
            Import_declaration_conflicts_with_local_declaration_of_0: diag(2440, ts.DiagnosticCategory.Error, "Import_declaration_conflicts_with_local_declaration_of_0_2440", "Import declaration conflicts with local declaration of '{0}'."),
            Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module: diag(2441, ts.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_2441", "Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of a module."),
            Types_have_separate_declarations_of_a_private_property_0: diag(2442, ts.DiagnosticCategory.Error, "Types_have_separate_declarations_of_a_private_property_0_2442", "Types have separate declarations of a private property '{0}'."),
            Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2: diag(2443, ts.DiagnosticCategory.Error, "Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2_2443", "Property '{0}' is protected but type '{1}' is not a class derived from '{2}'."),
            Property_0_is_protected_in_type_1_but_public_in_type_2: diag(2444, ts.DiagnosticCategory.Error, "Property_0_is_protected_in_type_1_but_public_in_type_2_2444", "Property '{0}' is protected in type '{1}' but public in type '{2}'."),
            Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses: diag(2445, ts.DiagnosticCategory.Error, "Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses_2445", "Property '{0}' is protected and only accessible within class '{1}' and its subclasses."),
            Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1: diag(2446, ts.DiagnosticCategory.Error, "Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1_2446", "Property '{0}' is protected and only accessible through an instance of class '{1}'."),
            The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead: diag(2447, ts.DiagnosticCategory.Error, "The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead_2447", "The '{0}' operator is not allowed for boolean types. Consider using '{1}' instead."),
            Block_scoped_variable_0_used_before_its_declaration: diag(2448, ts.DiagnosticCategory.Error, "Block_scoped_variable_0_used_before_its_declaration_2448", "Block-scoped variable '{0}' used before its declaration."),
            Class_0_used_before_its_declaration: diag(2449, ts.DiagnosticCategory.Error, "Class_0_used_before_its_declaration_2449", "Class '{0}' used before its declaration."),
            Enum_0_used_before_its_declaration: diag(2450, ts.DiagnosticCategory.Error, "Enum_0_used_before_its_declaration_2450", "Enum '{0}' used before its declaration."),
            Cannot_redeclare_block_scoped_variable_0: diag(2451, ts.DiagnosticCategory.Error, "Cannot_redeclare_block_scoped_variable_0_2451", "Cannot redeclare block-scoped variable '{0}'."),
            An_enum_member_cannot_have_a_numeric_name: diag(2452, ts.DiagnosticCategory.Error, "An_enum_member_cannot_have_a_numeric_name_2452", "An enum member cannot have a numeric name."),
            The_type_argument_for_type_parameter_0_cannot_be_inferred_from_the_usage_Consider_specifying_the_type_arguments_explicitly: diag(2453, ts.DiagnosticCategory.Error, "The_type_argument_for_type_parameter_0_cannot_be_inferred_from_the_usage_Consider_specifying_the_typ_2453", "The type argument for type parameter '{0}' cannot be inferred from the usage. Consider specifying the type arguments explicitly."),
            Variable_0_is_used_before_being_assigned: diag(2454, ts.DiagnosticCategory.Error, "Variable_0_is_used_before_being_assigned_2454", "Variable '{0}' is used before being assigned."),
            Type_argument_candidate_1_is_not_a_valid_type_argument_because_it_is_not_a_supertype_of_candidate_0: diag(2455, ts.DiagnosticCategory.Error, "Type_argument_candidate_1_is_not_a_valid_type_argument_because_it_is_not_a_supertype_of_candidate_0_2455", "Type argument candidate '{1}' is not a valid type argument because it is not a supertype of candidate '{0}'."),
            Type_alias_0_circularly_references_itself: diag(2456, ts.DiagnosticCategory.Error, "Type_alias_0_circularly_references_itself_2456", "Type alias '{0}' circularly references itself."),
            Type_alias_name_cannot_be_0: diag(2457, ts.DiagnosticCategory.Error, "Type_alias_name_cannot_be_0_2457", "Type alias name cannot be '{0}'."),
            An_AMD_module_cannot_have_multiple_name_assignments: diag(2458, ts.DiagnosticCategory.Error, "An_AMD_module_cannot_have_multiple_name_assignments_2458", "An AMD module cannot have multiple name assignments."),
            Module_0_declares_1_locally_but_it_is_not_exported: diag(2459, ts.DiagnosticCategory.Error, "Module_0_declares_1_locally_but_it_is_not_exported_2459", "Module '{0}' declares '{1}' locally, but it is not exported."),
            Module_0_declares_1_locally_but_it_is_exported_as_2: diag(2460, ts.DiagnosticCategory.Error, "Module_0_declares_1_locally_but_it_is_exported_as_2_2460", "Module '{0}' declares '{1}' locally, but it is exported as '{2}'."),
            Type_0_is_not_an_array_type: diag(2461, ts.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_2461", "Type '{0}' is not an array type."),
            A_rest_element_must_be_last_in_a_destructuring_pattern: diag(2462, ts.DiagnosticCategory.Error, "A_rest_element_must_be_last_in_a_destructuring_pattern_2462", "A rest element must be last in a destructuring pattern."),
            A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature: diag(2463, ts.DiagnosticCategory.Error, "A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature_2463", "A binding pattern parameter cannot be optional in an implementation signature."),
            A_computed_property_name_must_be_of_type_string_number_symbol_or_any: diag(2464, ts.DiagnosticCategory.Error, "A_computed_property_name_must_be_of_type_string_number_symbol_or_any_2464", "A computed property name must be of type 'string', 'number', 'symbol', or 'any'."),
            this_cannot_be_referenced_in_a_computed_property_name: diag(2465, ts.DiagnosticCategory.Error, "this_cannot_be_referenced_in_a_computed_property_name_2465", "'this' cannot be referenced in a computed property name."),
            super_cannot_be_referenced_in_a_computed_property_name: diag(2466, ts.DiagnosticCategory.Error, "super_cannot_be_referenced_in_a_computed_property_name_2466", "'super' cannot be referenced in a computed property name."),
            A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type: diag(2467, ts.DiagnosticCategory.Error, "A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type_2467", "A computed property name cannot reference a type parameter from its containing type."),
            Cannot_find_global_value_0: diag(2468, ts.DiagnosticCategory.Error, "Cannot_find_global_value_0_2468", "Cannot find global value '{0}'."),
            The_0_operator_cannot_be_applied_to_type_symbol: diag(2469, ts.DiagnosticCategory.Error, "The_0_operator_cannot_be_applied_to_type_symbol_2469", "The '{0}' operator cannot be applied to type 'symbol'."),
            Symbol_reference_does_not_refer_to_the_global_Symbol_constructor_object: diag(2470, ts.DiagnosticCategory.Error, "Symbol_reference_does_not_refer_to_the_global_Symbol_constructor_object_2470", "'Symbol' reference does not refer to the global Symbol constructor object."),
            A_computed_property_name_of_the_form_0_must_be_of_type_symbol: diag(2471, ts.DiagnosticCategory.Error, "A_computed_property_name_of_the_form_0_must_be_of_type_symbol_2471", "A computed property name of the form '{0}' must be of type 'symbol'."),
            Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher: diag(2472, ts.DiagnosticCategory.Error, "Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher_2472", "Spread operator in 'new' expressions is only available when targeting ECMAScript 5 and higher."),
            Enum_declarations_must_all_be_const_or_non_const: diag(2473, ts.DiagnosticCategory.Error, "Enum_declarations_must_all_be_const_or_non_const_2473", "Enum declarations must all be const or non-const."),
            const_enum_member_initializers_can_only_contain_literal_values_and_other_computed_enum_values: diag(2474, ts.DiagnosticCategory.Error, "const_enum_member_initializers_can_only_contain_literal_values_and_other_computed_enum_values_2474", "const enum member initializers can only contain literal values and other computed enum values."),
            const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_import_declaration_or_export_assignment_or_type_query: diag(2475, ts.DiagnosticCategory.Error, "const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_im_2475", "'const' enums can only be used in property or index access expressions or the right hand side of an import declaration or export assignment or type query."),
            A_const_enum_member_can_only_be_accessed_using_a_string_literal: diag(2476, ts.DiagnosticCategory.Error, "A_const_enum_member_can_only_be_accessed_using_a_string_literal_2476", "A const enum member can only be accessed using a string literal."),
            const_enum_member_initializer_was_evaluated_to_a_non_finite_value: diag(2477, ts.DiagnosticCategory.Error, "const_enum_member_initializer_was_evaluated_to_a_non_finite_value_2477", "'const' enum member initializer was evaluated to a non-finite value."),
            const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN: diag(2478, ts.DiagnosticCategory.Error, "const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN_2478", "'const' enum member initializer was evaluated to disallowed value 'NaN'."),
            Property_0_does_not_exist_on_const_enum_1: diag(2479, ts.DiagnosticCategory.Error, "Property_0_does_not_exist_on_const_enum_1_2479", "Property '{0}' does not exist on 'const' enum '{1}'."),
            let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations: diag(2480, ts.DiagnosticCategory.Error, "let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations_2480", "'let' is not allowed to be used as a name in 'let' or 'const' declarations."),
            Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1: diag(2481, ts.DiagnosticCategory.Error, "Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1_2481", "Cannot initialize outer scoped variable '{0}' in the same scope as block scoped declaration '{1}'."),
            The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation: diag(2483, ts.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation_2483", "The left-hand side of a 'for...of' statement cannot use a type annotation."),
            Export_declaration_conflicts_with_exported_declaration_of_0: diag(2484, ts.DiagnosticCategory.Error, "Export_declaration_conflicts_with_exported_declaration_of_0_2484", "Export declaration conflicts with exported declaration of '{0}'."),
            The_left_hand_side_of_a_for_of_statement_must_be_a_variable_or_a_property_access: diag(2487, ts.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_must_be_a_variable_or_a_property_access_2487", "The left-hand side of a 'for...of' statement must be a variable or a property access."),
            Type_0_must_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2488, ts.DiagnosticCategory.Error, "Type_0_must_have_a_Symbol_iterator_method_that_returns_an_iterator_2488", "Type '{0}' must have a '[Symbol.iterator]()' method that returns an iterator."),
            An_iterator_must_have_a_next_method: diag(2489, ts.DiagnosticCategory.Error, "An_iterator_must_have_a_next_method_2489", "An iterator must have a 'next()' method."),
            The_type_returned_by_the_0_method_of_an_iterator_must_have_a_value_property: diag(2490, ts.DiagnosticCategory.Error, "The_type_returned_by_the_0_method_of_an_iterator_must_have_a_value_property_2490", "The type returned by the '{0}()' method of an iterator must have a 'value' property."),
            The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern: diag(2491, ts.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern_2491", "The left-hand side of a 'for...in' statement cannot be a destructuring pattern."),
            Cannot_redeclare_identifier_0_in_catch_clause: diag(2492, ts.DiagnosticCategory.Error, "Cannot_redeclare_identifier_0_in_catch_clause_2492", "Cannot redeclare identifier '{0}' in catch clause."),
            Tuple_type_0_of_length_1_has_no_element_at_index_2: diag(2493, ts.DiagnosticCategory.Error, "Tuple_type_0_of_length_1_has_no_element_at_index_2_2493", "Tuple type '{0}' of length '{1}' has no element at index '{2}'."),
            Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher: diag(2494, ts.DiagnosticCategory.Error, "Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher_2494", "Using a string in a 'for...of' statement is only supported in ECMAScript 5 and higher."),
            Type_0_is_not_an_array_type_or_a_string_type: diag(2495, ts.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_a_string_type_2495", "Type '{0}' is not an array type or a string type."),
            The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_standard_function_expression: diag(2496, ts.DiagnosticCategory.Error, "The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_stand_2496", "The 'arguments' object cannot be referenced in an arrow function in ES3 and ES5. Consider using a standard function expression."),
            This_module_can_only_be_referenced_with_ECMAScript_imports_Slashexports_by_turning_on_the_0_flag_and_referencing_its_default_export: diag(2497, ts.DiagnosticCategory.Error, "This_module_can_only_be_referenced_with_ECMAScript_imports_Slashexports_by_turning_on_the_0_flag_and_2497", "This module can only be referenced with ECMAScript imports/exports by turning on the '{0}' flag and referencing its default export."),
            Module_0_uses_export_and_cannot_be_used_with_export_Asterisk: diag(2498, ts.DiagnosticCategory.Error, "Module_0_uses_export_and_cannot_be_used_with_export_Asterisk_2498", "Module '{0}' uses 'export =' and cannot be used with 'export *'."),
            An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments: diag(2499, ts.DiagnosticCategory.Error, "An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments_2499", "An interface can only extend an identifier/qualified-name with optional type arguments."),
            A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments: diag(2500, ts.DiagnosticCategory.Error, "A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments_2500", "A class can only implement an identifier/qualified-name with optional type arguments."),
            A_rest_element_cannot_contain_a_binding_pattern: diag(2501, ts.DiagnosticCategory.Error, "A_rest_element_cannot_contain_a_binding_pattern_2501", "A rest element cannot contain a binding pattern."),
            _0_is_referenced_directly_or_indirectly_in_its_own_type_annotation: diag(2502, ts.DiagnosticCategory.Error, "_0_is_referenced_directly_or_indirectly_in_its_own_type_annotation_2502", "'{0}' is referenced directly or indirectly in its own type annotation."),
            Cannot_find_namespace_0: diag(2503, ts.DiagnosticCategory.Error, "Cannot_find_namespace_0_2503", "Cannot find namespace '{0}'."),
            Type_0_must_have_a_Symbol_asyncIterator_method_that_returns_an_async_iterator: diag(2504, ts.DiagnosticCategory.Error, "Type_0_must_have_a_Symbol_asyncIterator_method_that_returns_an_async_iterator_2504", "Type '{0}' must have a '[Symbol.asyncIterator]()' method that returns an async iterator."),
            A_generator_cannot_have_a_void_type_annotation: diag(2505, ts.DiagnosticCategory.Error, "A_generator_cannot_have_a_void_type_annotation_2505", "A generator cannot have a 'void' type annotation."),
            _0_is_referenced_directly_or_indirectly_in_its_own_base_expression: diag(2506, ts.DiagnosticCategory.Error, "_0_is_referenced_directly_or_indirectly_in_its_own_base_expression_2506", "'{0}' is referenced directly or indirectly in its own base expression."),
            Type_0_is_not_a_constructor_function_type: diag(2507, ts.DiagnosticCategory.Error, "Type_0_is_not_a_constructor_function_type_2507", "Type '{0}' is not a constructor function type."),
            No_base_constructor_has_the_specified_number_of_type_arguments: diag(2508, ts.DiagnosticCategory.Error, "No_base_constructor_has_the_specified_number_of_type_arguments_2508", "No base constructor has the specified number of type arguments."),
            Base_constructor_return_type_0_is_not_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2509, ts.DiagnosticCategory.Error, "Base_constructor_return_type_0_is_not_an_object_type_or_intersection_of_object_types_with_statically_2509", "Base constructor return type '{0}' is not an object type or intersection of object types with statically known members."),
            Base_constructors_must_all_have_the_same_return_type: diag(2510, ts.DiagnosticCategory.Error, "Base_constructors_must_all_have_the_same_return_type_2510", "Base constructors must all have the same return type."),
            Cannot_create_an_instance_of_an_abstract_class: diag(2511, ts.DiagnosticCategory.Error, "Cannot_create_an_instance_of_an_abstract_class_2511", "Cannot create an instance of an abstract class."),
            Overload_signatures_must_all_be_abstract_or_non_abstract: diag(2512, ts.DiagnosticCategory.Error, "Overload_signatures_must_all_be_abstract_or_non_abstract_2512", "Overload signatures must all be abstract or non-abstract."),
            Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression: diag(2513, ts.DiagnosticCategory.Error, "Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression_2513", "Abstract method '{0}' in class '{1}' cannot be accessed via super expression."),
            Classes_containing_abstract_methods_must_be_marked_abstract: diag(2514, ts.DiagnosticCategory.Error, "Classes_containing_abstract_methods_must_be_marked_abstract_2514", "Classes containing abstract methods must be marked abstract."),
            Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2: diag(2515, ts.DiagnosticCategory.Error, "Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2_2515", "Non-abstract class '{0}' does not implement inherited abstract member '{1}' from class '{2}'."),
            All_declarations_of_an_abstract_method_must_be_consecutive: diag(2516, ts.DiagnosticCategory.Error, "All_declarations_of_an_abstract_method_must_be_consecutive_2516", "All declarations of an abstract method must be consecutive."),
            Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type: diag(2517, ts.DiagnosticCategory.Error, "Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type_2517", "Cannot assign an abstract constructor type to a non-abstract constructor type."),
            A_this_based_type_guard_is_not_compatible_with_a_parameter_based_type_guard: diag(2518, ts.DiagnosticCategory.Error, "A_this_based_type_guard_is_not_compatible_with_a_parameter_based_type_guard_2518", "A 'this'-based type guard is not compatible with a parameter-based type guard."),
            An_async_iterator_must_have_a_next_method: diag(2519, ts.DiagnosticCategory.Error, "An_async_iterator_must_have_a_next_method_2519", "An async iterator must have a 'next()' method."),
            Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions: diag(2520, ts.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions_2520", "Duplicate identifier '{0}'. Compiler uses declaration '{1}' to support async functions."),
            Expression_resolves_to_variable_declaration_0_that_compiler_uses_to_support_async_functions: diag(2521, ts.DiagnosticCategory.Error, "Expression_resolves_to_variable_declaration_0_that_compiler_uses_to_support_async_functions_2521", "Expression resolves to variable declaration '{0}' that compiler uses to support async functions."),
            The_arguments_object_cannot_be_referenced_in_an_async_function_or_method_in_ES3_and_ES5_Consider_using_a_standard_function_or_method: diag(2522, ts.DiagnosticCategory.Error, "The_arguments_object_cannot_be_referenced_in_an_async_function_or_method_in_ES3_and_ES5_Consider_usi_2522", "The 'arguments' object cannot be referenced in an async function or method in ES3 and ES5. Consider using a standard function or method."),
            yield_expressions_cannot_be_used_in_a_parameter_initializer: diag(2523, ts.DiagnosticCategory.Error, "yield_expressions_cannot_be_used_in_a_parameter_initializer_2523", "'yield' expressions cannot be used in a parameter initializer."),
            await_expressions_cannot_be_used_in_a_parameter_initializer: diag(2524, ts.DiagnosticCategory.Error, "await_expressions_cannot_be_used_in_a_parameter_initializer_2524", "'await' expressions cannot be used in a parameter initializer."),
            Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value: diag(2525, ts.DiagnosticCategory.Error, "Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value_2525", "Initializer provides no value for this binding element and the binding element has no default value."),
            A_this_type_is_available_only_in_a_non_static_member_of_a_class_or_interface: diag(2526, ts.DiagnosticCategory.Error, "A_this_type_is_available_only_in_a_non_static_member_of_a_class_or_interface_2526", "A 'this' type is available only in a non-static member of a class or interface."),
            The_inferred_type_of_0_references_an_inaccessible_1_type_A_type_annotation_is_necessary: diag(2527, ts.DiagnosticCategory.Error, "The_inferred_type_of_0_references_an_inaccessible_1_type_A_type_annotation_is_necessary_2527", "The inferred type of '{0}' references an inaccessible '{1}' type. A type annotation is necessary."),
            A_module_cannot_have_multiple_default_exports: diag(2528, ts.DiagnosticCategory.Error, "A_module_cannot_have_multiple_default_exports_2528", "A module cannot have multiple default exports."),
            Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_containing_async_functions: diag(2529, ts.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_containing_async_func_2529", "Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of a module containing async functions."),
            Property_0_is_incompatible_with_index_signature: diag(2530, ts.DiagnosticCategory.Error, "Property_0_is_incompatible_with_index_signature_2530", "Property '{0}' is incompatible with index signature."),
            Object_is_possibly_null: diag(2531, ts.DiagnosticCategory.Error, "Object_is_possibly_null_2531", "Object is possibly 'null'."),
            Object_is_possibly_undefined: diag(2532, ts.DiagnosticCategory.Error, "Object_is_possibly_undefined_2532", "Object is possibly 'undefined'."),
            Object_is_possibly_null_or_undefined: diag(2533, ts.DiagnosticCategory.Error, "Object_is_possibly_null_or_undefined_2533", "Object is possibly 'null' or 'undefined'."),
            A_function_returning_never_cannot_have_a_reachable_end_point: diag(2534, ts.DiagnosticCategory.Error, "A_function_returning_never_cannot_have_a_reachable_end_point_2534", "A function returning 'never' cannot have a reachable end point."),
            Enum_type_0_has_members_with_initializers_that_are_not_literals: diag(2535, ts.DiagnosticCategory.Error, "Enum_type_0_has_members_with_initializers_that_are_not_literals_2535", "Enum type '{0}' has members with initializers that are not literals."),
            Type_0_cannot_be_used_to_index_type_1: diag(2536, ts.DiagnosticCategory.Error, "Type_0_cannot_be_used_to_index_type_1_2536", "Type '{0}' cannot be used to index type '{1}'."),
            Type_0_has_no_matching_index_signature_for_type_1: diag(2537, ts.DiagnosticCategory.Error, "Type_0_has_no_matching_index_signature_for_type_1_2537", "Type '{0}' has no matching index signature for type '{1}'."),
            Type_0_cannot_be_used_as_an_index_type: diag(2538, ts.DiagnosticCategory.Error, "Type_0_cannot_be_used_as_an_index_type_2538", "Type '{0}' cannot be used as an index type."),
            Cannot_assign_to_0_because_it_is_not_a_variable: diag(2539, ts.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_not_a_variable_2539", "Cannot assign to '{0}' because it is not a variable."),
            Cannot_assign_to_0_because_it_is_a_read_only_property: diag(2540, ts.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_read_only_property_2540", "Cannot assign to '{0}' because it is a read-only property."),
            The_target_of_an_assignment_must_be_a_variable_or_a_property_access: diag(2541, ts.DiagnosticCategory.Error, "The_target_of_an_assignment_must_be_a_variable_or_a_property_access_2541", "The target of an assignment must be a variable or a property access."),
            Index_signature_in_type_0_only_permits_reading: diag(2542, ts.DiagnosticCategory.Error, "Index_signature_in_type_0_only_permits_reading_2542", "Index signature in type '{0}' only permits reading."),
            Duplicate_identifier_newTarget_Compiler_uses_variable_declaration_newTarget_to_capture_new_target_meta_property_reference: diag(2543, ts.DiagnosticCategory.Error, "Duplicate_identifier_newTarget_Compiler_uses_variable_declaration_newTarget_to_capture_new_target_me_2543", "Duplicate identifier '_newTarget'. Compiler uses variable declaration '_newTarget' to capture 'new.target' meta-property reference."),
            Expression_resolves_to_variable_declaration_newTarget_that_compiler_uses_to_capture_new_target_meta_property_reference: diag(2544, ts.DiagnosticCategory.Error, "Expression_resolves_to_variable_declaration_newTarget_that_compiler_uses_to_capture_new_target_meta__2544", "Expression resolves to variable declaration '_newTarget' that compiler uses to capture 'new.target' meta-property reference."),
            A_mixin_class_must_have_a_constructor_with_a_single_rest_parameter_of_type_any: diag(2545, ts.DiagnosticCategory.Error, "A_mixin_class_must_have_a_constructor_with_a_single_rest_parameter_of_type_any_2545", "A mixin class must have a constructor with a single rest parameter of type 'any[]'."),
            Property_0_has_conflicting_declarations_and_is_inaccessible_in_type_1: diag(2546, ts.DiagnosticCategory.Error, "Property_0_has_conflicting_declarations_and_is_inaccessible_in_type_1_2546", "Property '{0}' has conflicting declarations and is inaccessible in type '{1}'."),
            The_type_returned_by_the_0_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value_property: diag(2547, ts.DiagnosticCategory.Error, "The_type_returned_by_the_0_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value_pro_2547", "The type returned by the '{0}()' method of an async iterator must be a promise for a type with a 'value' property."),
            Type_0_is_not_an_array_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2548, ts.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator_2548", "Type '{0}' is not an array type or does not have a '[Symbol.iterator]()' method that returns an iterator."),
            Type_0_is_not_an_array_type_or_a_string_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2549, ts.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_a_string_type_or_does_not_have_a_Symbol_iterator_method_that_returns__2549", "Type '{0}' is not an array type or a string type or does not have a '[Symbol.iterator]()' method that returns an iterator."),
            Property_0_does_not_exist_on_type_1_Did_you_mean_2: diag(2551, ts.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_Did_you_mean_2_2551", "Property '{0}' does not exist on type '{1}'. Did you mean '{2}'?"),
            Cannot_find_name_0_Did_you_mean_1: diag(2552, ts.DiagnosticCategory.Error, "Cannot_find_name_0_Did_you_mean_1_2552", "Cannot find name '{0}'. Did you mean '{1}'?"),
            Computed_values_are_not_permitted_in_an_enum_with_string_valued_members: diag(2553, ts.DiagnosticCategory.Error, "Computed_values_are_not_permitted_in_an_enum_with_string_valued_members_2553", "Computed values are not permitted in an enum with string valued members."),
            Expected_0_arguments_but_got_1: diag(2554, ts.DiagnosticCategory.Error, "Expected_0_arguments_but_got_1_2554", "Expected {0} arguments, but got {1}."),
            Expected_at_least_0_arguments_but_got_1: diag(2555, ts.DiagnosticCategory.Error, "Expected_at_least_0_arguments_but_got_1_2555", "Expected at least {0} arguments, but got {1}."),
            Expected_0_arguments_but_got_1_or_more: diag(2556, ts.DiagnosticCategory.Error, "Expected_0_arguments_but_got_1_or_more_2556", "Expected {0} arguments, but got {1} or more."),
            Expected_at_least_0_arguments_but_got_1_or_more: diag(2557, ts.DiagnosticCategory.Error, "Expected_at_least_0_arguments_but_got_1_or_more_2557", "Expected at least {0} arguments, but got {1} or more."),
            Expected_0_type_arguments_but_got_1: diag(2558, ts.DiagnosticCategory.Error, "Expected_0_type_arguments_but_got_1_2558", "Expected {0} type arguments, but got {1}."),
            Type_0_has_no_properties_in_common_with_type_1: diag(2559, ts.DiagnosticCategory.Error, "Type_0_has_no_properties_in_common_with_type_1_2559", "Type '{0}' has no properties in common with type '{1}'."),
            Value_of_type_0_has_no_properties_in_common_with_type_1_Did_you_mean_to_call_it: diag(2560, ts.DiagnosticCategory.Error, "Value_of_type_0_has_no_properties_in_common_with_type_1_Did_you_mean_to_call_it_2560", "Value of type '{0}' has no properties in common with type '{1}'. Did you mean to call it?"),
            Object_literal_may_only_specify_known_properties_but_0_does_not_exist_in_type_1_Did_you_mean_to_write_2: diag(2561, ts.DiagnosticCategory.Error, "Object_literal_may_only_specify_known_properties_but_0_does_not_exist_in_type_1_Did_you_mean_to_writ_2561", "Object literal may only specify known properties, but '{0}' does not exist in type '{1}'. Did you mean to write '{2}'?"),
            Base_class_expressions_cannot_reference_class_type_parameters: diag(2562, ts.DiagnosticCategory.Error, "Base_class_expressions_cannot_reference_class_type_parameters_2562", "Base class expressions cannot reference class type parameters."),
            The_containing_function_or_module_body_is_too_large_for_control_flow_analysis: diag(2563, ts.DiagnosticCategory.Error, "The_containing_function_or_module_body_is_too_large_for_control_flow_analysis_2563", "The containing function or module body is too large for control flow analysis."),
            Property_0_has_no_initializer_and_is_not_definitely_assigned_in_the_constructor: diag(2564, ts.DiagnosticCategory.Error, "Property_0_has_no_initializer_and_is_not_definitely_assigned_in_the_constructor_2564", "Property '{0}' has no initializer and is not definitely assigned in the constructor."),
            Property_0_is_used_before_being_assigned: diag(2565, ts.DiagnosticCategory.Error, "Property_0_is_used_before_being_assigned_2565", "Property '{0}' is used before being assigned."),
            A_rest_element_cannot_have_a_property_name: diag(2566, ts.DiagnosticCategory.Error, "A_rest_element_cannot_have_a_property_name_2566", "A rest element cannot have a property name."),
            Enum_declarations_can_only_merge_with_namespace_or_other_enum_declarations: diag(2567, ts.DiagnosticCategory.Error, "Enum_declarations_can_only_merge_with_namespace_or_other_enum_declarations_2567", "Enum declarations can only merge with namespace or other enum declarations."),
            Type_0_is_not_an_array_type_or_a_string_type_Use_compiler_option_downlevelIteration_to_allow_iterating_of_iterators: diag(2569, ts.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_a_string_type_Use_compiler_option_downlevelIteration_to_allow_iterati_2569", "Type '{0}' is not an array type or a string type. Use compiler option '--downlevelIteration' to allow iterating of iterators."),
            Object_is_of_type_unknown: diag(2571, ts.DiagnosticCategory.Error, "Object_is_of_type_unknown_2571", "Object is of type 'unknown'."),
            Rest_signatures_are_incompatible: diag(2572, ts.DiagnosticCategory.Error, "Rest_signatures_are_incompatible_2572", "Rest signatures are incompatible."),
            Property_0_is_incompatible_with_rest_element_type: diag(2573, ts.DiagnosticCategory.Error, "Property_0_is_incompatible_with_rest_element_type_2573", "Property '{0}' is incompatible with rest element type."),
            A_rest_element_type_must_be_an_array_type: diag(2574, ts.DiagnosticCategory.Error, "A_rest_element_type_must_be_an_array_type_2574", "A rest element type must be an array type."),
            No_overload_expects_0_arguments_but_overloads_do_exist_that_expect_either_1_or_2_arguments: diag(2575, ts.DiagnosticCategory.Error, "No_overload_expects_0_arguments_but_overloads_do_exist_that_expect_either_1_or_2_arguments_2575", "No overload expects {0} arguments, but overloads do exist that expect either {1} or {2} arguments."),
            Property_0_is_a_static_member_of_type_1: diag(2576, ts.DiagnosticCategory.Error, "Property_0_is_a_static_member_of_type_1_2576", "Property '{0}' is a static member of type '{1}'"),
            Return_type_annotation_circularly_references_itself: diag(2577, ts.DiagnosticCategory.Error, "Return_type_annotation_circularly_references_itself_2577", "Return type annotation circularly references itself."),
            Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_types_Slashnode: diag(2580, ts.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_types_Slashnode_2580", "Cannot find name '{0}'. Do you need to install type definitions for node? Try `npm i @types/node`."),
            Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_types_Slashjquery: diag(2581, ts.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_types_Slashjquery_2581", "Cannot find name '{0}'. Do you need to install type definitions for jQuery? Try `npm i @types/jquery`."),
            Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_types_Slashjest_or_npm_i_types_Slashmocha: diag(2582, ts.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_types_Slashje_2582", "Cannot find name '{0}'. Do you need to install type definitions for a test runner? Try `npm i @types/jest` or `npm i @types/mocha`."),
            Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_es2015_or_later: diag(2583, ts.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_2583", "Cannot find name '{0}'. Do you need to change your target library? Try changing the `lib` compiler option to es2015 or later."),
            Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_include_dom: diag(2584, ts.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_2584", "Cannot find name '{0}'. Do you need to change your target library? Try changing the `lib` compiler option to include 'dom'."),
            _0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_es2015_or_later: diag(2585, ts.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Do_you_need_to_change_your_target_library_2585", "'{0}' only refers to a type, but is being used as a value here. Do you need to change your target library? Try changing the `lib` compiler option to es2015 or later."),
            Enum_type_0_circularly_references_itself: diag(2586, ts.DiagnosticCategory.Error, "Enum_type_0_circularly_references_itself_2586", "Enum type '{0}' circularly references itself."),
            JSDoc_type_0_circularly_references_itself: diag(2587, ts.DiagnosticCategory.Error, "JSDoc_type_0_circularly_references_itself_2587", "JSDoc type '{0}' circularly references itself."),
            Cannot_assign_to_0_because_it_is_a_constant: diag(2588, ts.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_constant_2588", "Cannot assign to '{0}' because it is a constant."),
            Type_instantiation_is_excessively_deep_and_possibly_infinite: diag(2589, ts.DiagnosticCategory.Error, "Type_instantiation_is_excessively_deep_and_possibly_infinite_2589", "Type instantiation is excessively deep and possibly infinite."),
            Expression_produces_a_union_type_that_is_too_complex_to_represent: diag(2590, ts.DiagnosticCategory.Error, "Expression_produces_a_union_type_that_is_too_complex_to_represent_2590", "Expression produces a union type that is too complex to represent."),
            Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_types_Slashnode_and_then_add_node_to_the_types_field_in_your_tsconfig: diag(2591, ts.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_types_Slashnode_and_th_2591", "Cannot find name '{0}'. Do you need to install type definitions for node? Try `npm i @types/node` and then add `node` to the types field in your tsconfig."),
            Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_types_Slashjquery_and_then_add_jquery_to_the_types_field_in_your_tsconfig: diag(2592, ts.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_types_Slashjquery_an_2592", "Cannot find name '{0}'. Do you need to install type definitions for jQuery? Try `npm i @types/jquery` and then add `jquery` to the types field in your tsconfig."),
            Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_types_Slashjest_or_npm_i_types_Slashmocha_and_then_add_jest_or_mocha_to_the_types_field_in_your_tsconfig: diag(2593, ts.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_types_Slashje_2593", "Cannot find name '{0}'. Do you need to install type definitions for a test runner? Try `npm i @types/jest` or `npm i @types/mocha` and then add `jest` or `mocha` to the types field in your tsconfig."),
            This_module_is_declared_with_using_export_and_can_only_be_used_with_a_default_import_when_using_the_0_flag: diag(2594, ts.DiagnosticCategory.Error, "This_module_is_declared_with_using_export_and_can_only_be_used_with_a_default_import_when_using_the__2594", "This module is declared with using 'export =', and can only be used with a default import when using the '{0}' flag."),
            JSX_element_attributes_type_0_may_not_be_a_union_type: diag(2600, ts.DiagnosticCategory.Error, "JSX_element_attributes_type_0_may_not_be_a_union_type_2600", "JSX element attributes type '{0}' may not be a union type."),
            The_return_type_of_a_JSX_element_constructor_must_return_an_object_type: diag(2601, ts.DiagnosticCategory.Error, "The_return_type_of_a_JSX_element_constructor_must_return_an_object_type_2601", "The return type of a JSX element constructor must return an object type."),
            JSX_element_implicitly_has_type_any_because_the_global_type_JSX_Element_does_not_exist: diag(2602, ts.DiagnosticCategory.Error, "JSX_element_implicitly_has_type_any_because_the_global_type_JSX_Element_does_not_exist_2602", "JSX element implicitly has type 'any' because the global type 'JSX.Element' does not exist."),
            Property_0_in_type_1_is_not_assignable_to_type_2: diag(2603, ts.DiagnosticCategory.Error, "Property_0_in_type_1_is_not_assignable_to_type_2_2603", "Property '{0}' in type '{1}' is not assignable to type '{2}'."),
            JSX_element_type_0_does_not_have_any_construct_or_call_signatures: diag(2604, ts.DiagnosticCategory.Error, "JSX_element_type_0_does_not_have_any_construct_or_call_signatures_2604", "JSX element type '{0}' does not have any construct or call signatures."),
            JSX_element_type_0_is_not_a_constructor_function_for_JSX_elements: diag(2605, ts.DiagnosticCategory.Error, "JSX_element_type_0_is_not_a_constructor_function_for_JSX_elements_2605", "JSX element type '{0}' is not a constructor function for JSX elements."),
            Property_0_of_JSX_spread_attribute_is_not_assignable_to_target_property: diag(2606, ts.DiagnosticCategory.Error, "Property_0_of_JSX_spread_attribute_is_not_assignable_to_target_property_2606", "Property '{0}' of JSX spread attribute is not assignable to target property."),
            JSX_element_class_does_not_support_attributes_because_it_does_not_have_a_0_property: diag(2607, ts.DiagnosticCategory.Error, "JSX_element_class_does_not_support_attributes_because_it_does_not_have_a_0_property_2607", "JSX element class does not support attributes because it does not have a '{0}' property."),
            The_global_type_JSX_0_may_not_have_more_than_one_property: diag(2608, ts.DiagnosticCategory.Error, "The_global_type_JSX_0_may_not_have_more_than_one_property_2608", "The global type 'JSX.{0}' may not have more than one property."),
            JSX_spread_child_must_be_an_array_type: diag(2609, ts.DiagnosticCategory.Error, "JSX_spread_child_must_be_an_array_type_2609", "JSX spread child must be an array type."),
            _0_is_defined_as_an_accessor_in_class_1_but_is_overridden_here_in_2_as_an_instance_property: diag(2610, ts.DiagnosticCategory.Error, "_0_is_defined_as_an_accessor_in_class_1_but_is_overridden_here_in_2_as_an_instance_property_2610", "'{0}' is defined as an accessor in class '{1}', but is overridden here in '{2}' as an instance property."),
            _0_is_defined_as_a_property_in_class_1_but_is_overridden_here_in_2_as_an_accessor: diag(2611, ts.DiagnosticCategory.Error, "_0_is_defined_as_a_property_in_class_1_but_is_overridden_here_in_2_as_an_accessor_2611", "'{0}' is defined as a property in class '{1}', but is overridden here in '{2}' as an accessor."),
            Property_0_will_overwrite_the_base_property_in_1_If_this_is_intentional_add_an_initializer_Otherwise_add_a_declare_modifier_or_remove_the_redundant_declaration: diag(2612, ts.DiagnosticCategory.Error, "Property_0_will_overwrite_the_base_property_in_1_If_this_is_intentional_add_an_initializer_Otherwise_2612", "Property '{0}' will overwrite the base property in '{1}'. If this is intentional, add an initializer. Otherwise, add a 'declare' modifier or remove the redundant declaration."),
            Module_0_has_no_default_export_Did_you_mean_to_use_import_1_from_0_instead: diag(2613, ts.DiagnosticCategory.Error, "Module_0_has_no_default_export_Did_you_mean_to_use_import_1_from_0_instead_2613", "Module '{0}' has no default export. Did you mean to use 'import { {1} } from {0}' instead?"),
            Module_0_has_no_exported_member_1_Did_you_mean_to_use_import_1_from_0_instead: diag(2614, ts.DiagnosticCategory.Error, "Module_0_has_no_exported_member_1_Did_you_mean_to_use_import_1_from_0_instead_2614", "Module '{0}' has no exported member '{1}'. Did you mean to use 'import {1} from {0}' instead?"),
            Cannot_augment_module_0_with_value_exports_because_it_resolves_to_a_non_module_entity: diag(2649, ts.DiagnosticCategory.Error, "Cannot_augment_module_0_with_value_exports_because_it_resolves_to_a_non_module_entity_2649", "Cannot augment module '{0}' with value exports because it resolves to a non-module entity."),
            A_member_initializer_in_a_enum_declaration_cannot_reference_members_declared_after_it_including_members_defined_in_other_enums: diag(2651, ts.DiagnosticCategory.Error, "A_member_initializer_in_a_enum_declaration_cannot_reference_members_declared_after_it_including_memb_2651", "A member initializer in a enum declaration cannot reference members declared after it, including members defined in other enums."),
            Merged_declaration_0_cannot_include_a_default_export_declaration_Consider_adding_a_separate_export_default_0_declaration_instead: diag(2652, ts.DiagnosticCategory.Error, "Merged_declaration_0_cannot_include_a_default_export_declaration_Consider_adding_a_separate_export_d_2652", "Merged declaration '{0}' cannot include a default export declaration. Consider adding a separate 'export default {0}' declaration instead."),
            Non_abstract_class_expression_does_not_implement_inherited_abstract_member_0_from_class_1: diag(2653, ts.DiagnosticCategory.Error, "Non_abstract_class_expression_does_not_implement_inherited_abstract_member_0_from_class_1_2653", "Non-abstract class expression does not implement inherited abstract member '{0}' from class '{1}'."),
            Exported_external_package_typings_file_cannot_contain_tripleslash_references_Please_contact_the_package_author_to_update_the_package_definition: diag(2654, ts.DiagnosticCategory.Error, "Exported_external_package_typings_file_cannot_contain_tripleslash_references_Please_contact_the_pack_2654", "Exported external package typings file cannot contain tripleslash references. Please contact the package author to update the package definition."),
            Exported_external_package_typings_file_0_is_not_a_module_Please_contact_the_package_author_to_update_the_package_definition: diag(2656, ts.DiagnosticCategory.Error, "Exported_external_package_typings_file_0_is_not_a_module_Please_contact_the_package_author_to_update_2656", "Exported external package typings file '{0}' is not a module. Please contact the package author to update the package definition."),
            JSX_expressions_must_have_one_parent_element: diag(2657, ts.DiagnosticCategory.Error, "JSX_expressions_must_have_one_parent_element_2657", "JSX expressions must have one parent element."),
            Type_0_provides_no_match_for_the_signature_1: diag(2658, ts.DiagnosticCategory.Error, "Type_0_provides_no_match_for_the_signature_1_2658", "Type '{0}' provides no match for the signature '{1}'."),
            super_is_only_allowed_in_members_of_object_literal_expressions_when_option_target_is_ES2015_or_higher: diag(2659, ts.DiagnosticCategory.Error, "super_is_only_allowed_in_members_of_object_literal_expressions_when_option_target_is_ES2015_or_highe_2659", "'super' is only allowed in members of object literal expressions when option 'target' is 'ES2015' or higher."),
            super_can_only_be_referenced_in_members_of_derived_classes_or_object_literal_expressions: diag(2660, ts.DiagnosticCategory.Error, "super_can_only_be_referenced_in_members_of_derived_classes_or_object_literal_expressions_2660", "'super' can only be referenced in members of derived classes or object literal expressions."),
            Cannot_export_0_Only_local_declarations_can_be_exported_from_a_module: diag(2661, ts.DiagnosticCategory.Error, "Cannot_export_0_Only_local_declarations_can_be_exported_from_a_module_2661", "Cannot export '{0}'. Only local declarations can be exported from a module."),
            Cannot_find_name_0_Did_you_mean_the_static_member_1_0: diag(2662, ts.DiagnosticCategory.Error, "Cannot_find_name_0_Did_you_mean_the_static_member_1_0_2662", "Cannot find name '{0}'. Did you mean the static member '{1}.{0}'?"),
            Cannot_find_name_0_Did_you_mean_the_instance_member_this_0: diag(2663, ts.DiagnosticCategory.Error, "Cannot_find_name_0_Did_you_mean_the_instance_member_this_0_2663", "Cannot find name '{0}'. Did you mean the instance member 'this.{0}'?"),
            Invalid_module_name_in_augmentation_module_0_cannot_be_found: diag(2664, ts.DiagnosticCategory.Error, "Invalid_module_name_in_augmentation_module_0_cannot_be_found_2664", "Invalid module name in augmentation, module '{0}' cannot be found."),
            Invalid_module_name_in_augmentation_Module_0_resolves_to_an_untyped_module_at_1_which_cannot_be_augmented: diag(2665, ts.DiagnosticCategory.Error, "Invalid_module_name_in_augmentation_Module_0_resolves_to_an_untyped_module_at_1_which_cannot_be_augm_2665", "Invalid module name in augmentation. Module '{0}' resolves to an untyped module at '{1}', which cannot be augmented."),
            Exports_and_export_assignments_are_not_permitted_in_module_augmentations: diag(2666, ts.DiagnosticCategory.Error, "Exports_and_export_assignments_are_not_permitted_in_module_augmentations_2666", "Exports and export assignments are not permitted in module augmentations."),
            Imports_are_not_permitted_in_module_augmentations_Consider_moving_them_to_the_enclosing_external_module: diag(2667, ts.DiagnosticCategory.Error, "Imports_are_not_permitted_in_module_augmentations_Consider_moving_them_to_the_enclosing_external_mod_2667", "Imports are not permitted in module augmentations. Consider moving them to the enclosing external module."),
            export_modifier_cannot_be_applied_to_ambient_modules_and_module_augmentations_since_they_are_always_visible: diag(2668, ts.DiagnosticCategory.Error, "export_modifier_cannot_be_applied_to_ambient_modules_and_module_augmentations_since_they_are_always__2668", "'export' modifier cannot be applied to ambient modules and module augmentations since they are always visible."),
            Augmentations_for_the_global_scope_can_only_be_directly_nested_in_external_modules_or_ambient_module_declarations: diag(2669, ts.DiagnosticCategory.Error, "Augmentations_for_the_global_scope_can_only_be_directly_nested_in_external_modules_or_ambient_module_2669", "Augmentations for the global scope can only be directly nested in external modules or ambient module declarations."),
            Augmentations_for_the_global_scope_should_have_declare_modifier_unless_they_appear_in_already_ambient_context: diag(2670, ts.DiagnosticCategory.Error, "Augmentations_for_the_global_scope_should_have_declare_modifier_unless_they_appear_in_already_ambien_2670", "Augmentations for the global scope should have 'declare' modifier unless they appear in already ambient context."),
            Cannot_augment_module_0_because_it_resolves_to_a_non_module_entity: diag(2671, ts.DiagnosticCategory.Error, "Cannot_augment_module_0_because_it_resolves_to_a_non_module_entity_2671", "Cannot augment module '{0}' because it resolves to a non-module entity."),
            Cannot_assign_a_0_constructor_type_to_a_1_constructor_type: diag(2672, ts.DiagnosticCategory.Error, "Cannot_assign_a_0_constructor_type_to_a_1_constructor_type_2672", "Cannot assign a '{0}' constructor type to a '{1}' constructor type."),
            Constructor_of_class_0_is_private_and_only_accessible_within_the_class_declaration: diag(2673, ts.DiagnosticCategory.Error, "Constructor_of_class_0_is_private_and_only_accessible_within_the_class_declaration_2673", "Constructor of class '{0}' is private and only accessible within the class declaration."),
            Constructor_of_class_0_is_protected_and_only_accessible_within_the_class_declaration: diag(2674, ts.DiagnosticCategory.Error, "Constructor_of_class_0_is_protected_and_only_accessible_within_the_class_declaration_2674", "Constructor of class '{0}' is protected and only accessible within the class declaration."),
            Cannot_extend_a_class_0_Class_constructor_is_marked_as_private: diag(2675, ts.DiagnosticCategory.Error, "Cannot_extend_a_class_0_Class_constructor_is_marked_as_private_2675", "Cannot extend a class '{0}'. Class constructor is marked as private."),
            Accessors_must_both_be_abstract_or_non_abstract: diag(2676, ts.DiagnosticCategory.Error, "Accessors_must_both_be_abstract_or_non_abstract_2676", "Accessors must both be abstract or non-abstract."),
            A_type_predicate_s_type_must_be_assignable_to_its_parameter_s_type: diag(2677, ts.DiagnosticCategory.Error, "A_type_predicate_s_type_must_be_assignable_to_its_parameter_s_type_2677", "A type predicate's type must be assignable to its parameter's type."),
            Type_0_is_not_comparable_to_type_1: diag(2678, ts.DiagnosticCategory.Error, "Type_0_is_not_comparable_to_type_1_2678", "Type '{0}' is not comparable to type '{1}'."),
            A_function_that_is_called_with_the_new_keyword_cannot_have_a_this_type_that_is_void: diag(2679, ts.DiagnosticCategory.Error, "A_function_that_is_called_with_the_new_keyword_cannot_have_a_this_type_that_is_void_2679", "A function that is called with the 'new' keyword cannot have a 'this' type that is 'void'."),
            A_0_parameter_must_be_the_first_parameter: diag(2680, ts.DiagnosticCategory.Error, "A_0_parameter_must_be_the_first_parameter_2680", "A '{0}' parameter must be the first parameter."),
            A_constructor_cannot_have_a_this_parameter: diag(2681, ts.DiagnosticCategory.Error, "A_constructor_cannot_have_a_this_parameter_2681", "A constructor cannot have a 'this' parameter."),
            get_and_set_accessor_must_have_the_same_this_type: diag(2682, ts.DiagnosticCategory.Error, "get_and_set_accessor_must_have_the_same_this_type_2682", "'get' and 'set' accessor must have the same 'this' type."),
            this_implicitly_has_type_any_because_it_does_not_have_a_type_annotation: diag(2683, ts.DiagnosticCategory.Error, "this_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_2683", "'this' implicitly has type 'any' because it does not have a type annotation."),
            The_this_context_of_type_0_is_not_assignable_to_method_s_this_of_type_1: diag(2684, ts.DiagnosticCategory.Error, "The_this_context_of_type_0_is_not_assignable_to_method_s_this_of_type_1_2684", "The 'this' context of type '{0}' is not assignable to method's 'this' of type '{1}'."),
            The_this_types_of_each_signature_are_incompatible: diag(2685, ts.DiagnosticCategory.Error, "The_this_types_of_each_signature_are_incompatible_2685", "The 'this' types of each signature are incompatible."),
            _0_refers_to_a_UMD_global_but_the_current_file_is_a_module_Consider_adding_an_import_instead: diag(2686, ts.DiagnosticCategory.Error, "_0_refers_to_a_UMD_global_but_the_current_file_is_a_module_Consider_adding_an_import_instead_2686", "'{0}' refers to a UMD global, but the current file is a module. Consider adding an import instead."),
            All_declarations_of_0_must_have_identical_modifiers: diag(2687, ts.DiagnosticCategory.Error, "All_declarations_of_0_must_have_identical_modifiers_2687", "All declarations of '{0}' must have identical modifiers."),
            Cannot_find_type_definition_file_for_0: diag(2688, ts.DiagnosticCategory.Error, "Cannot_find_type_definition_file_for_0_2688", "Cannot find type definition file for '{0}'."),
            Cannot_extend_an_interface_0_Did_you_mean_implements: diag(2689, ts.DiagnosticCategory.Error, "Cannot_extend_an_interface_0_Did_you_mean_implements_2689", "Cannot extend an interface '{0}'. Did you mean 'implements'?"),
            An_import_path_cannot_end_with_a_0_extension_Consider_importing_1_instead: diag(2691, ts.DiagnosticCategory.Error, "An_import_path_cannot_end_with_a_0_extension_Consider_importing_1_instead_2691", "An import path cannot end with a '{0}' extension. Consider importing '{1}' instead."),
            _0_is_a_primitive_but_1_is_a_wrapper_object_Prefer_using_0_when_possible: diag(2692, ts.DiagnosticCategory.Error, "_0_is_a_primitive_but_1_is_a_wrapper_object_Prefer_using_0_when_possible_2692", "'{0}' is a primitive, but '{1}' is a wrapper object. Prefer using '{0}' when possible."),
            _0_only_refers_to_a_type_but_is_being_used_as_a_value_here: diag(2693, ts.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_value_here_2693", "'{0}' only refers to a type, but is being used as a value here."),
            Namespace_0_has_no_exported_member_1: diag(2694, ts.DiagnosticCategory.Error, "Namespace_0_has_no_exported_member_1_2694", "Namespace '{0}' has no exported member '{1}'."),
            Left_side_of_comma_operator_is_unused_and_has_no_side_effects: diag(2695, ts.DiagnosticCategory.Error, "Left_side_of_comma_operator_is_unused_and_has_no_side_effects_2695", "Left side of comma operator is unused and has no side effects.", /*reportsUnnecessary*/ true),
            The_Object_type_is_assignable_to_very_few_other_types_Did_you_mean_to_use_the_any_type_instead: diag(2696, ts.DiagnosticCategory.Error, "The_Object_type_is_assignable_to_very_few_other_types_Did_you_mean_to_use_the_any_type_instead_2696", "The 'Object' type is assignable to very few other types. Did you mean to use the 'any' type instead?"),
            An_async_function_or_method_must_return_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES2015_in_your_lib_option: diag(2697, ts.DiagnosticCategory.Error, "An_async_function_or_method_must_return_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_in_2697", "An async function or method must return a 'Promise'. Make sure you have a declaration for 'Promise' or include 'ES2015' in your `--lib` option."),
            Spread_types_may_only_be_created_from_object_types: diag(2698, ts.DiagnosticCategory.Error, "Spread_types_may_only_be_created_from_object_types_2698", "Spread types may only be created from object types."),
            Static_property_0_conflicts_with_built_in_property_Function_0_of_constructor_function_1: diag(2699, ts.DiagnosticCategory.Error, "Static_property_0_conflicts_with_built_in_property_Function_0_of_constructor_function_1_2699", "Static property '{0}' conflicts with built-in property 'Function.{0}' of constructor function '{1}'."),
            Rest_types_may_only_be_created_from_object_types: diag(2700, ts.DiagnosticCategory.Error, "Rest_types_may_only_be_created_from_object_types_2700", "Rest types may only be created from object types."),
            The_target_of_an_object_rest_assignment_must_be_a_variable_or_a_property_access: diag(2701, ts.DiagnosticCategory.Error, "The_target_of_an_object_rest_assignment_must_be_a_variable_or_a_property_access_2701", "The target of an object rest assignment must be a variable or a property access."),
            _0_only_refers_to_a_type_but_is_being_used_as_a_namespace_here: diag(2702, ts.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_namespace_here_2702", "'{0}' only refers to a type, but is being used as a namespace here."),
            The_operand_of_a_delete_operator_must_be_a_property_reference: diag(2703, ts.DiagnosticCategory.Error, "The_operand_of_a_delete_operator_must_be_a_property_reference_2703", "The operand of a 'delete' operator must be a property reference."),
            The_operand_of_a_delete_operator_cannot_be_a_read_only_property: diag(2704, ts.DiagnosticCategory.Error, "The_operand_of_a_delete_operator_cannot_be_a_read_only_property_2704", "The operand of a 'delete' operator cannot be a read-only property."),
            An_async_function_or_method_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declaration_for_the_Promise_constructor_or_include_ES2015_in_your_lib_option: diag(2705, ts.DiagnosticCategory.Error, "An_async_function_or_method_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_de_2705", "An async function or method in ES5/ES3 requires the 'Promise' constructor.  Make sure you have a declaration for the 'Promise' constructor or include 'ES2015' in your `--lib` option."),
            Required_type_parameters_may_not_follow_optional_type_parameters: diag(2706, ts.DiagnosticCategory.Error, "Required_type_parameters_may_not_follow_optional_type_parameters_2706", "Required type parameters may not follow optional type parameters."),
            Generic_type_0_requires_between_1_and_2_type_arguments: diag(2707, ts.DiagnosticCategory.Error, "Generic_type_0_requires_between_1_and_2_type_arguments_2707", "Generic type '{0}' requires between {1} and {2} type arguments."),
            Cannot_use_namespace_0_as_a_value: diag(2708, ts.DiagnosticCategory.Error, "Cannot_use_namespace_0_as_a_value_2708", "Cannot use namespace '{0}' as a value."),
            Cannot_use_namespace_0_as_a_type: diag(2709, ts.DiagnosticCategory.Error, "Cannot_use_namespace_0_as_a_type_2709", "Cannot use namespace '{0}' as a type."),
            _0_are_specified_twice_The_attribute_named_0_will_be_overwritten: diag(2710, ts.DiagnosticCategory.Error, "_0_are_specified_twice_The_attribute_named_0_will_be_overwritten_2710", "'{0}' are specified twice. The attribute named '{0}' will be overwritten."),
            A_dynamic_import_call_returns_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES2015_in_your_lib_option: diag(2711, ts.DiagnosticCategory.Error, "A_dynamic_import_call_returns_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES20_2711", "A dynamic import call returns a 'Promise'. Make sure you have a declaration for 'Promise' or include 'ES2015' in your `--lib` option."),
            A_dynamic_import_call_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declaration_for_the_Promise_constructor_or_include_ES2015_in_your_lib_option: diag(2712, ts.DiagnosticCategory.Error, "A_dynamic_import_call_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declarat_2712", "A dynamic import call in ES5/ES3 requires the 'Promise' constructor.  Make sure you have a declaration for the 'Promise' constructor or include 'ES2015' in your `--lib` option."),
            Cannot_access_0_1_because_0_is_a_type_but_not_a_namespace_Did_you_mean_to_retrieve_the_type_of_the_property_1_in_0_with_0_1: diag(2713, ts.DiagnosticCategory.Error, "Cannot_access_0_1_because_0_is_a_type_but_not_a_namespace_Did_you_mean_to_retrieve_the_type_of_the_p_2713", "Cannot access '{0}.{1}' because '{0}' is a type, but not a namespace. Did you mean to retrieve the type of the property '{1}' in '{0}' with '{0}[\"{1}\"]'?"),
            The_expression_of_an_export_assignment_must_be_an_identifier_or_qualified_name_in_an_ambient_context: diag(2714, ts.DiagnosticCategory.Error, "The_expression_of_an_export_assignment_must_be_an_identifier_or_qualified_name_in_an_ambient_context_2714", "The expression of an export assignment must be an identifier or qualified name in an ambient context."),
            Abstract_property_0_in_class_1_cannot_be_accessed_in_the_constructor: diag(2715, ts.DiagnosticCategory.Error, "Abstract_property_0_in_class_1_cannot_be_accessed_in_the_constructor_2715", "Abstract property '{0}' in class '{1}' cannot be accessed in the constructor."),
            Type_parameter_0_has_a_circular_default: diag(2716, ts.DiagnosticCategory.Error, "Type_parameter_0_has_a_circular_default_2716", "Type parameter '{0}' has a circular default."),
            Subsequent_property_declarations_must_have_the_same_type_Property_0_must_be_of_type_1_but_here_has_type_2: diag(2717, ts.DiagnosticCategory.Error, "Subsequent_property_declarations_must_have_the_same_type_Property_0_must_be_of_type_1_but_here_has_t_2717", "Subsequent property declarations must have the same type.  Property '{0}' must be of type '{1}', but here has type '{2}'."),
            Duplicate_property_0: diag(2718, ts.DiagnosticCategory.Error, "Duplicate_property_0_2718", "Duplicate property '{0}'."),
            Type_0_is_not_assignable_to_type_1_Two_different_types_with_this_name_exist_but_they_are_unrelated: diag(2719, ts.DiagnosticCategory.Error, "Type_0_is_not_assignable_to_type_1_Two_different_types_with_this_name_exist_but_they_are_unrelated_2719", "Type '{0}' is not assignable to type '{1}'. Two different types with this name exist, but they are unrelated."),
            Class_0_incorrectly_implements_class_1_Did_you_mean_to_extend_1_and_inherit_its_members_as_a_subclass: diag(2720, ts.DiagnosticCategory.Error, "Class_0_incorrectly_implements_class_1_Did_you_mean_to_extend_1_and_inherit_its_members_as_a_subclas_2720", "Class '{0}' incorrectly implements class '{1}'. Did you mean to extend '{1}' and inherit its members as a subclass?"),
            Cannot_invoke_an_object_which_is_possibly_null: diag(2721, ts.DiagnosticCategory.Error, "Cannot_invoke_an_object_which_is_possibly_null_2721", "Cannot invoke an object which is possibly 'null'."),
            Cannot_invoke_an_object_which_is_possibly_undefined: diag(2722, ts.DiagnosticCategory.Error, "Cannot_invoke_an_object_which_is_possibly_undefined_2722", "Cannot invoke an object which is possibly 'undefined'."),
            Cannot_invoke_an_object_which_is_possibly_null_or_undefined: diag(2723, ts.DiagnosticCategory.Error, "Cannot_invoke_an_object_which_is_possibly_null_or_undefined_2723", "Cannot invoke an object which is possibly 'null' or 'undefined'."),
            Module_0_has_no_exported_member_1_Did_you_mean_2: diag(2724, ts.DiagnosticCategory.Error, "Module_0_has_no_exported_member_1_Did_you_mean_2_2724", "Module '{0}' has no exported member '{1}'. Did you mean '{2}'?"),
            Class_name_cannot_be_Object_when_targeting_ES5_with_module_0: diag(2725, ts.DiagnosticCategory.Error, "Class_name_cannot_be_Object_when_targeting_ES5_with_module_0_2725", "Class name cannot be 'Object' when targeting ES5 with module {0}."),
            Cannot_find_lib_definition_for_0: diag(2726, ts.DiagnosticCategory.Error, "Cannot_find_lib_definition_for_0_2726", "Cannot find lib definition for '{0}'."),
            Cannot_find_lib_definition_for_0_Did_you_mean_1: diag(2727, ts.DiagnosticCategory.Error, "Cannot_find_lib_definition_for_0_Did_you_mean_1_2727", "Cannot find lib definition for '{0}'. Did you mean '{1}'?"),
            _0_is_declared_here: diag(2728, ts.DiagnosticCategory.Message, "_0_is_declared_here_2728", "'{0}' is declared here."),
            Property_0_is_used_before_its_initialization: diag(2729, ts.DiagnosticCategory.Error, "Property_0_is_used_before_its_initialization_2729", "Property '{0}' is used before its initialization."),
            An_arrow_function_cannot_have_a_this_parameter: diag(2730, ts.DiagnosticCategory.Error, "An_arrow_function_cannot_have_a_this_parameter_2730", "An arrow function cannot have a 'this' parameter."),
            Implicit_conversion_of_a_symbol_to_a_string_will_fail_at_runtime_Consider_wrapping_this_expression_in_String: diag(2731, ts.DiagnosticCategory.Error, "Implicit_conversion_of_a_symbol_to_a_string_will_fail_at_runtime_Consider_wrapping_this_expression_i_2731", "Implicit conversion of a 'symbol' to a 'string' will fail at runtime. Consider wrapping this expression in 'String(...)'."),
            Cannot_find_module_0_Consider_using_resolveJsonModule_to_import_module_with_json_extension: diag(2732, ts.DiagnosticCategory.Error, "Cannot_find_module_0_Consider_using_resolveJsonModule_to_import_module_with_json_extension_2732", "Cannot find module '{0}'. Consider using '--resolveJsonModule' to import module with '.json' extension"),
            Property_0_was_also_declared_here: diag(2733, ts.DiagnosticCategory.Error, "Property_0_was_also_declared_here_2733", "Property '{0}' was also declared here."),
            It_is_highly_likely_that_you_are_missing_a_semicolon: diag(2734, ts.DiagnosticCategory.Error, "It_is_highly_likely_that_you_are_missing_a_semicolon_2734", "It is highly likely that you are missing a semicolon."),
            Did_you_mean_for_0_to_be_constrained_to_type_new_args_Colon_any_1: diag(2735, ts.DiagnosticCategory.Error, "Did_you_mean_for_0_to_be_constrained_to_type_new_args_Colon_any_1_2735", "Did you mean for '{0}' to be constrained to type 'new (...args: any[]) => {1}'?"),
            Operator_0_cannot_be_applied_to_type_1: diag(2736, ts.DiagnosticCategory.Error, "Operator_0_cannot_be_applied_to_type_1_2736", "Operator '{0}' cannot be applied to type '{1}'."),
            BigInt_literals_are_not_available_when_targeting_lower_than_ES2020: diag(2737, ts.DiagnosticCategory.Error, "BigInt_literals_are_not_available_when_targeting_lower_than_ES2020_2737", "BigInt literals are not available when targeting lower than ES2020."),
            An_outer_value_of_this_is_shadowed_by_this_container: diag(2738, ts.DiagnosticCategory.Message, "An_outer_value_of_this_is_shadowed_by_this_container_2738", "An outer value of 'this' is shadowed by this container."),
            Type_0_is_missing_the_following_properties_from_type_1_Colon_2: diag(2739, ts.DiagnosticCategory.Error, "Type_0_is_missing_the_following_properties_from_type_1_Colon_2_2739", "Type '{0}' is missing the following properties from type '{1}': {2}"),
            Type_0_is_missing_the_following_properties_from_type_1_Colon_2_and_3_more: diag(2740, ts.DiagnosticCategory.Error, "Type_0_is_missing_the_following_properties_from_type_1_Colon_2_and_3_more_2740", "Type '{0}' is missing the following properties from type '{1}': {2}, and {3} more."),
            Property_0_is_missing_in_type_1_but_required_in_type_2: diag(2741, ts.DiagnosticCategory.Error, "Property_0_is_missing_in_type_1_but_required_in_type_2_2741", "Property '{0}' is missing in type '{1}' but required in type '{2}'."),
            The_inferred_type_of_0_cannot_be_named_without_a_reference_to_1_This_is_likely_not_portable_A_type_annotation_is_necessary: diag(2742, ts.DiagnosticCategory.Error, "The_inferred_type_of_0_cannot_be_named_without_a_reference_to_1_This_is_likely_not_portable_A_type_a_2742", "The inferred type of '{0}' cannot be named without a reference to '{1}'. This is likely not portable. A type annotation is necessary."),
            No_overload_expects_0_type_arguments_but_overloads_do_exist_that_expect_either_1_or_2_type_arguments: diag(2743, ts.DiagnosticCategory.Error, "No_overload_expects_0_type_arguments_but_overloads_do_exist_that_expect_either_1_or_2_type_arguments_2743", "No overload expects {0} type arguments, but overloads do exist that expect either {1} or {2} type arguments."),
            Type_parameter_defaults_can_only_reference_previously_declared_type_parameters: diag(2744, ts.DiagnosticCategory.Error, "Type_parameter_defaults_can_only_reference_previously_declared_type_parameters_2744", "Type parameter defaults can only reference previously declared type parameters."),
            This_JSX_tag_s_0_prop_expects_type_1_which_requires_multiple_children_but_only_a_single_child_was_provided: diag(2745, ts.DiagnosticCategory.Error, "This_JSX_tag_s_0_prop_expects_type_1_which_requires_multiple_children_but_only_a_single_child_was_pr_2745", "This JSX tag's '{0}' prop expects type '{1}' which requires multiple children, but only a single child was provided."),
            This_JSX_tag_s_0_prop_expects_a_single_child_of_type_1_but_multiple_children_were_provided: diag(2746, ts.DiagnosticCategory.Error, "This_JSX_tag_s_0_prop_expects_a_single_child_of_type_1_but_multiple_children_were_provided_2746", "This JSX tag's '{0}' prop expects a single child of type '{1}', but multiple children were provided."),
            _0_components_don_t_accept_text_as_child_elements_Text_in_JSX_has_the_type_string_but_the_expected_type_of_1_is_2: diag(2747, ts.DiagnosticCategory.Error, "_0_components_don_t_accept_text_as_child_elements_Text_in_JSX_has_the_type_string_but_the_expected_t_2747", "'{0}' components don't accept text as child elements. Text in JSX has the type 'string', but the expected type of '{1}' is '{2}'."),
            Cannot_access_ambient_const_enums_when_the_isolatedModules_flag_is_provided: diag(2748, ts.DiagnosticCategory.Error, "Cannot_access_ambient_const_enums_when_the_isolatedModules_flag_is_provided_2748", "Cannot access ambient const enums when the '--isolatedModules' flag is provided."),
            _0_refers_to_a_value_but_is_being_used_as_a_type_here: diag(2749, ts.DiagnosticCategory.Error, "_0_refers_to_a_value_but_is_being_used_as_a_type_here_2749", "'{0}' refers to a value, but is being used as a type here."),
            The_implementation_signature_is_declared_here: diag(2750, ts.DiagnosticCategory.Error, "The_implementation_signature_is_declared_here_2750", "The implementation signature is declared here."),
            Circularity_originates_in_type_at_this_location: diag(2751, ts.DiagnosticCategory.Error, "Circularity_originates_in_type_at_this_location_2751", "Circularity originates in type at this location."),
            The_first_export_default_is_here: diag(2752, ts.DiagnosticCategory.Error, "The_first_export_default_is_here_2752", "The first export default is here."),
            Another_export_default_is_here: diag(2753, ts.DiagnosticCategory.Error, "Another_export_default_is_here_2753", "Another export default is here."),
            super_may_not_use_type_arguments: diag(2754, ts.DiagnosticCategory.Error, "super_may_not_use_type_arguments_2754", "'super' may not use type arguments."),
            No_constituent_of_type_0_is_callable: diag(2755, ts.DiagnosticCategory.Error, "No_constituent_of_type_0_is_callable_2755", "No constituent of type '{0}' is callable."),
            Not_all_constituents_of_type_0_are_callable: diag(2756, ts.DiagnosticCategory.Error, "Not_all_constituents_of_type_0_are_callable_2756", "Not all constituents of type '{0}' are callable."),
            Type_0_has_no_call_signatures: diag(2757, ts.DiagnosticCategory.Error, "Type_0_has_no_call_signatures_2757", "Type '{0}' has no call signatures."),
            Each_member_of_the_union_type_0_has_signatures_but_none_of_those_signatures_are_compatible_with_each_other: diag(2758, ts.DiagnosticCategory.Error, "Each_member_of_the_union_type_0_has_signatures_but_none_of_those_signatures_are_compatible_with_each_2758", "Each member of the union type '{0}' has signatures, but none of those signatures are compatible with each other."),
            No_constituent_of_type_0_is_constructable: diag(2759, ts.DiagnosticCategory.Error, "No_constituent_of_type_0_is_constructable_2759", "No constituent of type '{0}' is constructable."),
            Not_all_constituents_of_type_0_are_constructable: diag(2760, ts.DiagnosticCategory.Error, "Not_all_constituents_of_type_0_are_constructable_2760", "Not all constituents of type '{0}' are constructable."),
            Type_0_has_no_construct_signatures: diag(2761, ts.DiagnosticCategory.Error, "Type_0_has_no_construct_signatures_2761", "Type '{0}' has no construct signatures."),
            Each_member_of_the_union_type_0_has_construct_signatures_but_none_of_those_signatures_are_compatible_with_each_other: diag(2762, ts.DiagnosticCategory.Error, "Each_member_of_the_union_type_0_has_construct_signatures_but_none_of_those_signatures_are_compatible_2762", "Each member of the union type '{0}' has construct signatures, but none of those signatures are compatible with each other."),
            Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_for_of_will_always_send_0: diag(2763, ts.DiagnosticCategory.Error, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_for_of_will_always_s_2763", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but for-of will always send '{0}'."),
            Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_spread_will_always_send_0: diag(2764, ts.DiagnosticCategory.Error, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_spread_will_al_2764", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but array spread will always send '{0}'."),
            Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_destructuring_will_always_send_0: diag(2765, ts.DiagnosticCategory.Error, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_destructuring__2765", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but array destructuring will always send '{0}'."),
            Cannot_delegate_iteration_to_value_because_the_next_method_of_its_iterator_expects_type_1_but_the_containing_generator_will_always_send_0: diag(2766, ts.DiagnosticCategory.Error, "Cannot_delegate_iteration_to_value_because_the_next_method_of_its_iterator_expects_type_1_but_the_co_2766", "Cannot delegate iteration to value because the 'next' method of its iterator expects type '{1}', but the containing generator will always send '{0}'."),
            The_0_property_of_an_iterator_must_be_a_method: diag(2767, ts.DiagnosticCategory.Error, "The_0_property_of_an_iterator_must_be_a_method_2767", "The '{0}' property of an iterator must be a method."),
            The_0_property_of_an_async_iterator_must_be_a_method: diag(2768, ts.DiagnosticCategory.Error, "The_0_property_of_an_async_iterator_must_be_a_method_2768", "The '{0}' property of an async iterator must be a method."),
            No_overload_matches_this_call: diag(2769, ts.DiagnosticCategory.Error, "No_overload_matches_this_call_2769", "No overload matches this call."),
            The_last_overload_gave_the_following_error: diag(2770, ts.DiagnosticCategory.Error, "The_last_overload_gave_the_following_error_2770", "The last overload gave the following error."),
            The_last_overload_is_declared_here: diag(2771, ts.DiagnosticCategory.Error, "The_last_overload_is_declared_here_2771", "The last overload is declared here."),
            Overload_0_of_1_2_gave_the_following_error: diag(2772, ts.DiagnosticCategory.Error, "Overload_0_of_1_2_gave_the_following_error_2772", "Overload {0} of {1}, '{2}', gave the following error."),
            Did_you_forget_to_use_await: diag(2773, ts.DiagnosticCategory.Error, "Did_you_forget_to_use_await_2773", "Did you forget to use 'await'?"),
            This_condition_will_always_return_true_since_the_function_is_always_defined_Did_you_mean_to_call_it_instead: diag(2774, ts.DiagnosticCategory.Error, "This_condition_will_always_return_true_since_the_function_is_always_defined_Did_you_mean_to_call_it__2774", "This condition will always return true since the function is always defined. Did you mean to call it instead?"),
            Assertions_require_every_name_in_the_call_target_to_be_declared_with_an_explicit_type_annotation: diag(2775, ts.DiagnosticCategory.Error, "Assertions_require_every_name_in_the_call_target_to_be_declared_with_an_explicit_type_annotation_2775", "Assertions require every name in the call target to be declared with an explicit type annotation."),
            Assertions_require_the_call_target_to_be_an_identifier_or_qualified_name: diag(2776, ts.DiagnosticCategory.Error, "Assertions_require_the_call_target_to_be_an_identifier_or_qualified_name_2776", "Assertions require the call target to be an identifier or qualified name."),
            The_operand_of_an_increment_or_decrement_operator_may_not_be_an_optional_property_access: diag(2777, ts.DiagnosticCategory.Error, "The_operand_of_an_increment_or_decrement_operator_may_not_be_an_optional_property_access_2777", "The operand of an increment or decrement operator may not be an optional property access."),
            The_target_of_an_object_rest_assignment_may_not_be_an_optional_property_access: diag(2778, ts.DiagnosticCategory.Error, "The_target_of_an_object_rest_assignment_may_not_be_an_optional_property_access_2778", "The target of an object rest assignment may not be an optional property access."),
            The_left_hand_side_of_an_assignment_expression_may_not_be_an_optional_property_access: diag(2779, ts.DiagnosticCategory.Error, "The_left_hand_side_of_an_assignment_expression_may_not_be_an_optional_property_access_2779", "The left-hand side of an assignment expression may not be an optional property access."),
            The_left_hand_side_of_a_for_in_statement_may_not_be_an_optional_property_access: diag(2780, ts.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_may_not_be_an_optional_property_access_2780", "The left-hand side of a 'for...in' statement may not be an optional property access."),
            The_left_hand_side_of_a_for_of_statement_may_not_be_an_optional_property_access: diag(2781, ts.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_may_not_be_an_optional_property_access_2781", "The left-hand side of a 'for...of' statement may not be an optional property access."),
            _0_needs_an_explicit_type_annotation: diag(2782, ts.DiagnosticCategory.Message, "_0_needs_an_explicit_type_annotation_2782", "'{0}' needs an explicit type annotation."),
            Import_declaration_0_is_using_private_name_1: diag(4000, ts.DiagnosticCategory.Error, "Import_declaration_0_is_using_private_name_1_4000", "Import declaration '{0}' is using private name '{1}'."),
            Type_parameter_0_of_exported_class_has_or_is_using_private_name_1: diag(4002, ts.DiagnosticCategory.Error, "Type_parameter_0_of_exported_class_has_or_is_using_private_name_1_4002", "Type parameter '{0}' of exported class has or is using private name '{1}'."),
            Type_parameter_0_of_exported_interface_has_or_is_using_private_name_1: diag(4004, ts.DiagnosticCategory.Error, "Type_parameter_0_of_exported_interface_has_or_is_using_private_name_1_4004", "Type parameter '{0}' of exported interface has or is using private name '{1}'."),
            Type_parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4006, ts.DiagnosticCategory.Error, "Type_parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1_4006", "Type parameter '{0}' of constructor signature from exported interface has or is using private name '{1}'."),
            Type_parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4008, ts.DiagnosticCategory.Error, "Type_parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1_4008", "Type parameter '{0}' of call signature from exported interface has or is using private name '{1}'."),
            Type_parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1: diag(4010, ts.DiagnosticCategory.Error, "Type_parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1_4010", "Type parameter '{0}' of public static method from exported class has or is using private name '{1}'."),
            Type_parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1: diag(4012, ts.DiagnosticCategory.Error, "Type_parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1_4012", "Type parameter '{0}' of public method from exported class has or is using private name '{1}'."),
            Type_parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1: diag(4014, ts.DiagnosticCategory.Error, "Type_parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1_4014", "Type parameter '{0}' of method from exported interface has or is using private name '{1}'."),
            Type_parameter_0_of_exported_function_has_or_is_using_private_name_1: diag(4016, ts.DiagnosticCategory.Error, "Type_parameter_0_of_exported_function_has_or_is_using_private_name_1_4016", "Type parameter '{0}' of exported function has or is using private name '{1}'."),
            Implements_clause_of_exported_class_0_has_or_is_using_private_name_1: diag(4019, ts.DiagnosticCategory.Error, "Implements_clause_of_exported_class_0_has_or_is_using_private_name_1_4019", "Implements clause of exported class '{0}' has or is using private name '{1}'."),
            extends_clause_of_exported_class_0_has_or_is_using_private_name_1: diag(4020, ts.DiagnosticCategory.Error, "extends_clause_of_exported_class_0_has_or_is_using_private_name_1_4020", "'extends' clause of exported class '{0}' has or is using private name '{1}'."),
            extends_clause_of_exported_interface_0_has_or_is_using_private_name_1: diag(4022, ts.DiagnosticCategory.Error, "extends_clause_of_exported_interface_0_has_or_is_using_private_name_1_4022", "'extends' clause of exported interface '{0}' has or is using private name '{1}'."),
            Exported_variable_0_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4023, ts.DiagnosticCategory.Error, "Exported_variable_0_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4023", "Exported variable '{0}' has or is using name '{1}' from external module {2} but cannot be named."),
            Exported_variable_0_has_or_is_using_name_1_from_private_module_2: diag(4024, ts.DiagnosticCategory.Error, "Exported_variable_0_has_or_is_using_name_1_from_private_module_2_4024", "Exported variable '{0}' has or is using name '{1}' from private module '{2}'."),
            Exported_variable_0_has_or_is_using_private_name_1: diag(4025, ts.DiagnosticCategory.Error, "Exported_variable_0_has_or_is_using_private_name_1_4025", "Exported variable '{0}' has or is using private name '{1}'."),
            Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4026, ts.DiagnosticCategory.Error, "Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot__4026", "Public static property '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4027, ts.DiagnosticCategory.Error, "Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4027", "Public static property '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
            Public_static_property_0_of_exported_class_has_or_is_using_private_name_1: diag(4028, ts.DiagnosticCategory.Error, "Public_static_property_0_of_exported_class_has_or_is_using_private_name_1_4028", "Public static property '{0}' of exported class has or is using private name '{1}'."),
            Public_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4029, ts.DiagnosticCategory.Error, "Public_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_name_4029", "Public property '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Public_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4030, ts.DiagnosticCategory.Error, "Public_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4030", "Public property '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
            Public_property_0_of_exported_class_has_or_is_using_private_name_1: diag(4031, ts.DiagnosticCategory.Error, "Public_property_0_of_exported_class_has_or_is_using_private_name_1_4031", "Public property '{0}' of exported class has or is using private name '{1}'."),
            Property_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4032, ts.DiagnosticCategory.Error, "Property_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2_4032", "Property '{0}' of exported interface has or is using name '{1}' from private module '{2}'."),
            Property_0_of_exported_interface_has_or_is_using_private_name_1: diag(4033, ts.DiagnosticCategory.Error, "Property_0_of_exported_interface_has_or_is_using_private_name_1_4033", "Property '{0}' of exported interface has or is using private name '{1}'."),
            Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4034, ts.DiagnosticCategory.Error, "Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_name_1_from_private_mod_4034", "Parameter type of public static setter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
            Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_private_name_1: diag(4035, ts.DiagnosticCategory.Error, "Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_private_name_1_4035", "Parameter type of public static setter '{0}' from exported class has or is using private name '{1}'."),
            Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4036, ts.DiagnosticCategory.Error, "Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2_4036", "Parameter type of public setter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
            Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_private_name_1: diag(4037, ts.DiagnosticCategory.Error, "Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_private_name_1_4037", "Parameter type of public setter '{0}' from exported class has or is using private name '{1}'."),
            Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4038, ts.DiagnosticCategory.Error, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_external_modul_4038", "Return type of public static getter '{0}' from exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4039, ts.DiagnosticCategory.Error, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_4039", "Return type of public static getter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
            Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_private_name_1: diag(4040, ts.DiagnosticCategory.Error, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_private_name_1_4040", "Return type of public static getter '{0}' from exported class has or is using private name '{1}'."),
            Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4041, ts.DiagnosticCategory.Error, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_4041", "Return type of public getter '{0}' from exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4042, ts.DiagnosticCategory.Error, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2_4042", "Return type of public getter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
            Return_type_of_public_getter_0_from_exported_class_has_or_is_using_private_name_1: diag(4043, ts.DiagnosticCategory.Error, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_private_name_1_4043", "Return type of public getter '{0}' from exported class has or is using private name '{1}'."),
            Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4044, ts.DiagnosticCategory.Error, "Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_name_0_from_private_mod_4044", "Return type of constructor signature from exported interface has or is using name '{0}' from private module '{1}'."),
            Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4045, ts.DiagnosticCategory.Error, "Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_0_4045", "Return type of constructor signature from exported interface has or is using private name '{0}'."),
            Return_type_of_call_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4046, ts.DiagnosticCategory.Error, "Return_type_of_call_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4046", "Return type of call signature from exported interface has or is using name '{0}' from private module '{1}'."),
            Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4047, ts.DiagnosticCategory.Error, "Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_name_0_4047", "Return type of call signature from exported interface has or is using private name '{0}'."),
            Return_type_of_index_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4048, ts.DiagnosticCategory.Error, "Return_type_of_index_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4048", "Return type of index signature from exported interface has or is using name '{0}' from private module '{1}'."),
            Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4049, ts.DiagnosticCategory.Error, "Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_name_0_4049", "Return type of index signature from exported interface has or is using private name '{0}'."),
            Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4050, ts.DiagnosticCategory.Error, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_external_module__4050", "Return type of public static method from exported class has or is using name '{0}' from external module {1} but cannot be named."),
            Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_private_module_1: diag(4051, ts.DiagnosticCategory.Error, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_private_module_1_4051", "Return type of public static method from exported class has or is using name '{0}' from private module '{1}'."),
            Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_name_0: diag(4052, ts.DiagnosticCategory.Error, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_name_0_4052", "Return type of public static method from exported class has or is using private name '{0}'."),
            Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4053, ts.DiagnosticCategory.Error, "Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_c_4053", "Return type of public method from exported class has or is using name '{0}' from external module {1} but cannot be named."),
            Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_private_module_1: diag(4054, ts.DiagnosticCategory.Error, "Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_private_module_1_4054", "Return type of public method from exported class has or is using name '{0}' from private module '{1}'."),
            Return_type_of_public_method_from_exported_class_has_or_is_using_private_name_0: diag(4055, ts.DiagnosticCategory.Error, "Return_type_of_public_method_from_exported_class_has_or_is_using_private_name_0_4055", "Return type of public method from exported class has or is using private name '{0}'."),
            Return_type_of_method_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4056, ts.DiagnosticCategory.Error, "Return_type_of_method_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4056", "Return type of method from exported interface has or is using name '{0}' from private module '{1}'."),
            Return_type_of_method_from_exported_interface_has_or_is_using_private_name_0: diag(4057, ts.DiagnosticCategory.Error, "Return_type_of_method_from_exported_interface_has_or_is_using_private_name_0_4057", "Return type of method from exported interface has or is using private name '{0}'."),
            Return_type_of_exported_function_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4058, ts.DiagnosticCategory.Error, "Return_type_of_exported_function_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named_4058", "Return type of exported function has or is using name '{0}' from external module {1} but cannot be named."),
            Return_type_of_exported_function_has_or_is_using_name_0_from_private_module_1: diag(4059, ts.DiagnosticCategory.Error, "Return_type_of_exported_function_has_or_is_using_name_0_from_private_module_1_4059", "Return type of exported function has or is using name '{0}' from private module '{1}'."),
            Return_type_of_exported_function_has_or_is_using_private_name_0: diag(4060, ts.DiagnosticCategory.Error, "Return_type_of_exported_function_has_or_is_using_private_name_0_4060", "Return type of exported function has or is using private name '{0}'."),
            Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4061, ts.DiagnosticCategory.Error, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_can_4061", "Parameter '{0}' of constructor from exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4062, ts.DiagnosticCategory.Error, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_private_module_2_4062", "Parameter '{0}' of constructor from exported class has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_constructor_from_exported_class_has_or_is_using_private_name_1: diag(4063, ts.DiagnosticCategory.Error, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_private_name_1_4063", "Parameter '{0}' of constructor from exported class has or is using private name '{1}'."),
            Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4064, ts.DiagnosticCategory.Error, "Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_name_1_from_private_mod_4064", "Parameter '{0}' of constructor signature from exported interface has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4065, ts.DiagnosticCategory.Error, "Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1_4065", "Parameter '{0}' of constructor signature from exported interface has or is using private name '{1}'."),
            Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4066, ts.DiagnosticCategory.Error, "Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4066", "Parameter '{0}' of call signature from exported interface has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4067, ts.DiagnosticCategory.Error, "Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1_4067", "Parameter '{0}' of call signature from exported interface has or is using private name '{1}'."),
            Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4068, ts.DiagnosticCategory.Error, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_external_module__4068", "Parameter '{0}' of public static method from exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4069, ts.DiagnosticCategory.Error, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_private_module_2_4069", "Parameter '{0}' of public static method from exported class has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1: diag(4070, ts.DiagnosticCategory.Error, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1_4070", "Parameter '{0}' of public static method from exported class has or is using private name '{1}'."),
            Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4071, ts.DiagnosticCategory.Error, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_c_4071", "Parameter '{0}' of public method from exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4072, ts.DiagnosticCategory.Error, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_private_module_2_4072", "Parameter '{0}' of public method from exported class has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1: diag(4073, ts.DiagnosticCategory.Error, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1_4073", "Parameter '{0}' of public method from exported class has or is using private name '{1}'."),
            Parameter_0_of_method_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4074, ts.DiagnosticCategory.Error, "Parameter_0_of_method_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4074", "Parameter '{0}' of method from exported interface has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1: diag(4075, ts.DiagnosticCategory.Error, "Parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1_4075", "Parameter '{0}' of method from exported interface has or is using private name '{1}'."),
            Parameter_0_of_exported_function_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4076, ts.DiagnosticCategory.Error, "Parameter_0_of_exported_function_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4076", "Parameter '{0}' of exported function has or is using name '{1}' from external module {2} but cannot be named."),
            Parameter_0_of_exported_function_has_or_is_using_name_1_from_private_module_2: diag(4077, ts.DiagnosticCategory.Error, "Parameter_0_of_exported_function_has_or_is_using_name_1_from_private_module_2_4077", "Parameter '{0}' of exported function has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_exported_function_has_or_is_using_private_name_1: diag(4078, ts.DiagnosticCategory.Error, "Parameter_0_of_exported_function_has_or_is_using_private_name_1_4078", "Parameter '{0}' of exported function has or is using private name '{1}'."),
            Exported_type_alias_0_has_or_is_using_private_name_1: diag(4081, ts.DiagnosticCategory.Error, "Exported_type_alias_0_has_or_is_using_private_name_1_4081", "Exported type alias '{0}' has or is using private name '{1}'."),
            Default_export_of_the_module_has_or_is_using_private_name_0: diag(4082, ts.DiagnosticCategory.Error, "Default_export_of_the_module_has_or_is_using_private_name_0_4082", "Default export of the module has or is using private name '{0}'."),
            Type_parameter_0_of_exported_type_alias_has_or_is_using_private_name_1: diag(4083, ts.DiagnosticCategory.Error, "Type_parameter_0_of_exported_type_alias_has_or_is_using_private_name_1_4083", "Type parameter '{0}' of exported type alias has or is using private name '{1}'."),
            Conflicting_definitions_for_0_found_at_1_and_2_Consider_installing_a_specific_version_of_this_library_to_resolve_the_conflict: diag(4090, ts.DiagnosticCategory.Error, "Conflicting_definitions_for_0_found_at_1_and_2_Consider_installing_a_specific_version_of_this_librar_4090", "Conflicting definitions for '{0}' found at '{1}' and '{2}'. Consider installing a specific version of this library to resolve the conflict."),
            Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4091, ts.DiagnosticCategory.Error, "Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4091", "Parameter '{0}' of index signature from exported interface has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4092, ts.DiagnosticCategory.Error, "Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_private_name_1_4092", "Parameter '{0}' of index signature from exported interface has or is using private name '{1}'."),
            Property_0_of_exported_class_expression_may_not_be_private_or_protected: diag(4094, ts.DiagnosticCategory.Error, "Property_0_of_exported_class_expression_may_not_be_private_or_protected_4094", "Property '{0}' of exported class expression may not be private or protected."),
            Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4095, ts.DiagnosticCategory.Error, "Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_4095", "Public static method '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4096, ts.DiagnosticCategory.Error, "Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4096", "Public static method '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
            Public_static_method_0_of_exported_class_has_or_is_using_private_name_1: diag(4097, ts.DiagnosticCategory.Error, "Public_static_method_0_of_exported_class_has_or_is_using_private_name_1_4097", "Public static method '{0}' of exported class has or is using private name '{1}'."),
            Public_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4098, ts.DiagnosticCategory.Error, "Public_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4098", "Public method '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Public_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4099, ts.DiagnosticCategory.Error, "Public_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4099", "Public method '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
            Public_method_0_of_exported_class_has_or_is_using_private_name_1: diag(4100, ts.DiagnosticCategory.Error, "Public_method_0_of_exported_class_has_or_is_using_private_name_1_4100", "Public method '{0}' of exported class has or is using private name '{1}'."),
            Method_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4101, ts.DiagnosticCategory.Error, "Method_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2_4101", "Method '{0}' of exported interface has or is using name '{1}' from private module '{2}'."),
            Method_0_of_exported_interface_has_or_is_using_private_name_1: diag(4102, ts.DiagnosticCategory.Error, "Method_0_of_exported_interface_has_or_is_using_private_name_1_4102", "Method '{0}' of exported interface has or is using private name '{1}'."),
            Type_parameter_0_of_exported_mapped_object_type_is_using_private_name_1: diag(4103, ts.DiagnosticCategory.Error, "Type_parameter_0_of_exported_mapped_object_type_is_using_private_name_1_4103", "Type parameter '{0}' of exported mapped object type is using private name '{1}'."),
            The_type_0_is_readonly_and_cannot_be_assigned_to_the_mutable_type_1: diag(4104, ts.DiagnosticCategory.Error, "The_type_0_is_readonly_and_cannot_be_assigned_to_the_mutable_type_1_4104", "The type '{0}' is 'readonly' and cannot be assigned to the mutable type '{1}'."),
            Private_or_protected_member_0_cannot_be_accessed_on_a_type_parameter: diag(4105, ts.DiagnosticCategory.Error, "Private_or_protected_member_0_cannot_be_accessed_on_a_type_parameter_4105", "Private or protected member '{0}' cannot be accessed on a type parameter."),
            Parameter_0_of_accessor_has_or_is_using_private_name_1: diag(4106, ts.DiagnosticCategory.Error, "Parameter_0_of_accessor_has_or_is_using_private_name_1_4106", "Parameter '{0}' of accessor has or is using private name '{1}'."),
            Parameter_0_of_accessor_has_or_is_using_name_1_from_private_module_2: diag(4107, ts.DiagnosticCategory.Error, "Parameter_0_of_accessor_has_or_is_using_name_1_from_private_module_2_4107", "Parameter '{0}' of accessor has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_accessor_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4108, ts.DiagnosticCategory.Error, "Parameter_0_of_accessor_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4108", "Parameter '{0}' of accessor has or is using name '{1}' from external module '{2}' but cannot be named."),
            Type_arguments_for_0_circularly_reference_themselves: diag(4109, ts.DiagnosticCategory.Error, "Type_arguments_for_0_circularly_reference_themselves_4109", "Type arguments for '{0}' circularly reference themselves."),
            Tuple_type_arguments_circularly_reference_themselves: diag(4110, ts.DiagnosticCategory.Error, "Tuple_type_arguments_circularly_reference_themselves_4110", "Tuple type arguments circularly reference themselves."),
            The_current_host_does_not_support_the_0_option: diag(5001, ts.DiagnosticCategory.Error, "The_current_host_does_not_support_the_0_option_5001", "The current host does not support the '{0}' option."),
            Cannot_find_the_common_subdirectory_path_for_the_input_files: diag(5009, ts.DiagnosticCategory.Error, "Cannot_find_the_common_subdirectory_path_for_the_input_files_5009", "Cannot find the common subdirectory path for the input files."),
            File_specification_cannot_end_in_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0: diag(5010, ts.DiagnosticCategory.Error, "File_specification_cannot_end_in_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0_5010", "File specification cannot end in a recursive directory wildcard ('**'): '{0}'."),
            Cannot_read_file_0_Colon_1: diag(5012, ts.DiagnosticCategory.Error, "Cannot_read_file_0_Colon_1_5012", "Cannot read file '{0}': {1}."),
            Failed_to_parse_file_0_Colon_1: diag(5014, ts.DiagnosticCategory.Error, "Failed_to_parse_file_0_Colon_1_5014", "Failed to parse file '{0}': {1}."),
            Unknown_compiler_option_0: diag(5023, ts.DiagnosticCategory.Error, "Unknown_compiler_option_0_5023", "Unknown compiler option '{0}'."),
            Compiler_option_0_requires_a_value_of_type_1: diag(5024, ts.DiagnosticCategory.Error, "Compiler_option_0_requires_a_value_of_type_1_5024", "Compiler option '{0}' requires a value of type {1}."),
            Unknown_compiler_option_0_Did_you_mean_1: diag(5025, ts.DiagnosticCategory.Error, "Unknown_compiler_option_0_Did_you_mean_1_5025", "Unknown compiler option '{0}'. Did you mean '{1}'?"),
            Could_not_write_file_0_Colon_1: diag(5033, ts.DiagnosticCategory.Error, "Could_not_write_file_0_Colon_1_5033", "Could not write file '{0}': {1}."),
            Option_project_cannot_be_mixed_with_source_files_on_a_command_line: diag(5042, ts.DiagnosticCategory.Error, "Option_project_cannot_be_mixed_with_source_files_on_a_command_line_5042", "Option 'project' cannot be mixed with source files on a command line."),
            Option_isolatedModules_can_only_be_used_when_either_option_module_is_provided_or_option_target_is_ES2015_or_higher: diag(5047, ts.DiagnosticCategory.Error, "Option_isolatedModules_can_only_be_used_when_either_option_module_is_provided_or_option_target_is_ES_5047", "Option 'isolatedModules' can only be used when either option '--module' is provided or option 'target' is 'ES2015' or higher."),
            Option_0_cannot_be_specified_when_option_target_is_ES3: diag(5048, ts.DiagnosticCategory.Error, "Option_0_cannot_be_specified_when_option_target_is_ES3_5048", "Option '{0}' cannot be specified when option 'target' is 'ES3'."),
            Option_0_can_only_be_used_when_either_option_inlineSourceMap_or_option_sourceMap_is_provided: diag(5051, ts.DiagnosticCategory.Error, "Option_0_can_only_be_used_when_either_option_inlineSourceMap_or_option_sourceMap_is_provided_5051", "Option '{0} can only be used when either option '--inlineSourceMap' or option '--sourceMap' is provided."),
            Option_0_cannot_be_specified_without_specifying_option_1: diag(5052, ts.DiagnosticCategory.Error, "Option_0_cannot_be_specified_without_specifying_option_1_5052", "Option '{0}' cannot be specified without specifying option '{1}'."),
            Option_0_cannot_be_specified_with_option_1: diag(5053, ts.DiagnosticCategory.Error, "Option_0_cannot_be_specified_with_option_1_5053", "Option '{0}' cannot be specified with option '{1}'."),
            A_tsconfig_json_file_is_already_defined_at_Colon_0: diag(5054, ts.DiagnosticCategory.Error, "A_tsconfig_json_file_is_already_defined_at_Colon_0_5054", "A 'tsconfig.json' file is already defined at: '{0}'."),
            Cannot_write_file_0_because_it_would_overwrite_input_file: diag(5055, ts.DiagnosticCategory.Error, "Cannot_write_file_0_because_it_would_overwrite_input_file_5055", "Cannot write file '{0}' because it would overwrite input file."),
            Cannot_write_file_0_because_it_would_be_overwritten_by_multiple_input_files: diag(5056, ts.DiagnosticCategory.Error, "Cannot_write_file_0_because_it_would_be_overwritten_by_multiple_input_files_5056", "Cannot write file '{0}' because it would be overwritten by multiple input files."),
            Cannot_find_a_tsconfig_json_file_at_the_specified_directory_Colon_0: diag(5057, ts.DiagnosticCategory.Error, "Cannot_find_a_tsconfig_json_file_at_the_specified_directory_Colon_0_5057", "Cannot find a tsconfig.json file at the specified directory: '{0}'."),
            The_specified_path_does_not_exist_Colon_0: diag(5058, ts.DiagnosticCategory.Error, "The_specified_path_does_not_exist_Colon_0_5058", "The specified path does not exist: '{0}'."),
            Invalid_value_for_reactNamespace_0_is_not_a_valid_identifier: diag(5059, ts.DiagnosticCategory.Error, "Invalid_value_for_reactNamespace_0_is_not_a_valid_identifier_5059", "Invalid value for '--reactNamespace'. '{0}' is not a valid identifier."),
            Option_paths_cannot_be_used_without_specifying_baseUrl_option: diag(5060, ts.DiagnosticCategory.Error, "Option_paths_cannot_be_used_without_specifying_baseUrl_option_5060", "Option 'paths' cannot be used without specifying '--baseUrl' option."),
            Pattern_0_can_have_at_most_one_Asterisk_character: diag(5061, ts.DiagnosticCategory.Error, "Pattern_0_can_have_at_most_one_Asterisk_character_5061", "Pattern '{0}' can have at most one '*' character."),
            Substitution_0_in_pattern_1_can_have_at_most_one_Asterisk_character: diag(5062, ts.DiagnosticCategory.Error, "Substitution_0_in_pattern_1_can_have_at_most_one_Asterisk_character_5062", "Substitution '{0}' in pattern '{1}' can have at most one '*' character."),
            Substitutions_for_pattern_0_should_be_an_array: diag(5063, ts.DiagnosticCategory.Error, "Substitutions_for_pattern_0_should_be_an_array_5063", "Substitutions for pattern '{0}' should be an array."),
            Substitution_0_for_pattern_1_has_incorrect_type_expected_string_got_2: diag(5064, ts.DiagnosticCategory.Error, "Substitution_0_for_pattern_1_has_incorrect_type_expected_string_got_2_5064", "Substitution '{0}' for pattern '{1}' has incorrect type, expected 'string', got '{2}'."),
            File_specification_cannot_contain_a_parent_directory_that_appears_after_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0: diag(5065, ts.DiagnosticCategory.Error, "File_specification_cannot_contain_a_parent_directory_that_appears_after_a_recursive_directory_wildca_5065", "File specification cannot contain a parent directory ('..') that appears after a recursive directory wildcard ('**'): '{0}'."),
            Substitutions_for_pattern_0_shouldn_t_be_an_empty_array: diag(5066, ts.DiagnosticCategory.Error, "Substitutions_for_pattern_0_shouldn_t_be_an_empty_array_5066", "Substitutions for pattern '{0}' shouldn't be an empty array."),
            Invalid_value_for_jsxFactory_0_is_not_a_valid_identifier_or_qualified_name: diag(5067, ts.DiagnosticCategory.Error, "Invalid_value_for_jsxFactory_0_is_not_a_valid_identifier_or_qualified_name_5067", "Invalid value for 'jsxFactory'. '{0}' is not a valid identifier or qualified-name."),
            Adding_a_tsconfig_json_file_will_help_organize_projects_that_contain_both_TypeScript_and_JavaScript_files_Learn_more_at_https_Colon_Slash_Slashaka_ms_Slashtsconfig: diag(5068, ts.DiagnosticCategory.Error, "Adding_a_tsconfig_json_file_will_help_organize_projects_that_contain_both_TypeScript_and_JavaScript__5068", "Adding a tsconfig.json file will help organize projects that contain both TypeScript and JavaScript files. Learn more at https://aka.ms/tsconfig."),
            Option_0_cannot_be_specified_without_specifying_option_1_or_option_2: diag(5069, ts.DiagnosticCategory.Error, "Option_0_cannot_be_specified_without_specifying_option_1_or_option_2_5069", "Option '{0}' cannot be specified without specifying option '{1}' or option '{2}'."),
            Option_resolveJsonModule_cannot_be_specified_without_node_module_resolution_strategy: diag(5070, ts.DiagnosticCategory.Error, "Option_resolveJsonModule_cannot_be_specified_without_node_module_resolution_strategy_5070", "Option '--resolveJsonModule' cannot be specified without 'node' module resolution strategy."),
            Option_resolveJsonModule_can_only_be_specified_when_module_code_generation_is_commonjs_amd_es2015_or_esNext: diag(5071, ts.DiagnosticCategory.Error, "Option_resolveJsonModule_can_only_be_specified_when_module_code_generation_is_commonjs_amd_es2015_or_5071", "Option '--resolveJsonModule' can only be specified when module code generation is 'commonjs', 'amd', 'es2015' or 'esNext'."),
            Unknown_build_option_0: diag(5072, ts.DiagnosticCategory.Error, "Unknown_build_option_0_5072", "Unknown build option '{0}'."),
            Build_option_0_requires_a_value_of_type_1: diag(5073, ts.DiagnosticCategory.Error, "Build_option_0_requires_a_value_of_type_1_5073", "Build option '{0}' requires a value of type {1}."),
            Option_incremental_can_only_be_specified_using_tsconfig_emitting_to_single_file_or_when_option_tsBuildInfoFile_is_specified: diag(5074, ts.DiagnosticCategory.Error, "Option_incremental_can_only_be_specified_using_tsconfig_emitting_to_single_file_or_when_option_tsBui_5074", "Option '--incremental' can only be specified using tsconfig, emitting to single file or when option `--tsBuildInfoFile` is specified."),
            _0_is_assignable_to_the_constraint_of_type_1_but_1_could_be_instantiated_with_a_different_subtype_of_constraint_2: diag(5075, ts.DiagnosticCategory.Error, "_0_is_assignable_to_the_constraint_of_type_1_but_1_could_be_instantiated_with_a_different_subtype_of_5075", "'{0}' is assignable to the constraint of type '{1}', but '{1}' could be instantiated with a different subtype of constraint '{2}'."),
            _0_and_1_operations_cannot_be_mixed_without_parentheses: diag(5076, ts.DiagnosticCategory.Error, "_0_and_1_operations_cannot_be_mixed_without_parentheses_5076", "'{0}' and '{1}' operations cannot be mixed without parentheses."),
            Unknown_build_option_0_Did_you_mean_1: diag(5077, ts.DiagnosticCategory.Error, "Unknown_build_option_0_Did_you_mean_1_5077", "Unknown build option '{0}'. Did you mean '{1}'?"),
            Unknown_watch_option_0: diag(5078, ts.DiagnosticCategory.Error, "Unknown_watch_option_0_5078", "Unknown watch option '{0}'."),
            Unknown_watch_option_0_Did_you_mean_1: diag(5079, ts.DiagnosticCategory.Error, "Unknown_watch_option_0_Did_you_mean_1_5079", "Unknown watch option '{0}'. Did you mean '{1}'?"),
            Watch_option_0_requires_a_value_of_type_1: diag(5080, ts.DiagnosticCategory.Error, "Watch_option_0_requires_a_value_of_type_1_5080", "Watch option '{0}' requires a value of type {1}."),
            Cannot_find_a_tsconfig_json_file_at_the_current_directory_Colon_0: diag(5081, ts.DiagnosticCategory.Error, "Cannot_find_a_tsconfig_json_file_at_the_current_directory_Colon_0_5081", "Cannot find a tsconfig.json file at the current directory: {0}."),
            Generates_a_sourcemap_for_each_corresponding_d_ts_file: diag(6000, ts.DiagnosticCategory.Message, "Generates_a_sourcemap_for_each_corresponding_d_ts_file_6000", "Generates a sourcemap for each corresponding '.d.ts' file."),
            Concatenate_and_emit_output_to_single_file: diag(6001, ts.DiagnosticCategory.Message, "Concatenate_and_emit_output_to_single_file_6001", "Concatenate and emit output to single file."),
            Generates_corresponding_d_ts_file: diag(6002, ts.DiagnosticCategory.Message, "Generates_corresponding_d_ts_file_6002", "Generates corresponding '.d.ts' file."),
            Specify_the_location_where_debugger_should_locate_map_files_instead_of_generated_locations: diag(6003, ts.DiagnosticCategory.Message, "Specify_the_location_where_debugger_should_locate_map_files_instead_of_generated_locations_6003", "Specify the location where debugger should locate map files instead of generated locations."),
            Specify_the_location_where_debugger_should_locate_TypeScript_files_instead_of_source_locations: diag(6004, ts.DiagnosticCategory.Message, "Specify_the_location_where_debugger_should_locate_TypeScript_files_instead_of_source_locations_6004", "Specify the location where debugger should locate TypeScript files instead of source locations."),
            Watch_input_files: diag(6005, ts.DiagnosticCategory.Message, "Watch_input_files_6005", "Watch input files."),
            Redirect_output_structure_to_the_directory: diag(6006, ts.DiagnosticCategory.Message, "Redirect_output_structure_to_the_directory_6006", "Redirect output structure to the directory."),
            Do_not_erase_const_enum_declarations_in_generated_code: diag(6007, ts.DiagnosticCategory.Message, "Do_not_erase_const_enum_declarations_in_generated_code_6007", "Do not erase const enum declarations in generated code."),
            Do_not_emit_outputs_if_any_errors_were_reported: diag(6008, ts.DiagnosticCategory.Message, "Do_not_emit_outputs_if_any_errors_were_reported_6008", "Do not emit outputs if any errors were reported."),
            Do_not_emit_comments_to_output: diag(6009, ts.DiagnosticCategory.Message, "Do_not_emit_comments_to_output_6009", "Do not emit comments to output."),
            Do_not_emit_outputs: diag(6010, ts.DiagnosticCategory.Message, "Do_not_emit_outputs_6010", "Do not emit outputs."),
            Allow_default_imports_from_modules_with_no_default_export_This_does_not_affect_code_emit_just_typechecking: diag(6011, ts.DiagnosticCategory.Message, "Allow_default_imports_from_modules_with_no_default_export_This_does_not_affect_code_emit_just_typech_6011", "Allow default imports from modules with no default export. This does not affect code emit, just typechecking."),
            Skip_type_checking_of_declaration_files: diag(6012, ts.DiagnosticCategory.Message, "Skip_type_checking_of_declaration_files_6012", "Skip type checking of declaration files."),
            Do_not_resolve_the_real_path_of_symlinks: diag(6013, ts.DiagnosticCategory.Message, "Do_not_resolve_the_real_path_of_symlinks_6013", "Do not resolve the real path of symlinks."),
            Only_emit_d_ts_declaration_files: diag(6014, ts.DiagnosticCategory.Message, "Only_emit_d_ts_declaration_files_6014", "Only emit '.d.ts' declaration files."),
            Specify_ECMAScript_target_version_Colon_ES3_default_ES5_ES2015_ES2016_ES2017_ES2018_ES2019_ES2020_or_ESNEXT: diag(6015, ts.DiagnosticCategory.Message, "Specify_ECMAScript_target_version_Colon_ES3_default_ES5_ES2015_ES2016_ES2017_ES2018_ES2019_ES2020_or_6015", "Specify ECMAScript target version: 'ES3' (default), 'ES5', 'ES2015', 'ES2016', 'ES2017', 'ES2018', 'ES2019', 'ES2020', or 'ESNEXT'."),
            Specify_module_code_generation_Colon_none_commonjs_amd_system_umd_es2015_es2020_or_ESNext: diag(6016, ts.DiagnosticCategory.Message, "Specify_module_code_generation_Colon_none_commonjs_amd_system_umd_es2015_es2020_or_ESNext_6016", "Specify module code generation: 'none', 'commonjs', 'amd', 'system', 'umd', 'es2015', 'es2020', or 'ESNext'."),
            Print_this_message: diag(6017, ts.DiagnosticCategory.Message, "Print_this_message_6017", "Print this message."),
            Print_the_compiler_s_version: diag(6019, ts.DiagnosticCategory.Message, "Print_the_compiler_s_version_6019", "Print the compiler's version."),
            Compile_the_project_given_the_path_to_its_configuration_file_or_to_a_folder_with_a_tsconfig_json: diag(6020, ts.DiagnosticCategory.Message, "Compile_the_project_given_the_path_to_its_configuration_file_or_to_a_folder_with_a_tsconfig_json_6020", "Compile the project given the path to its configuration file, or to a folder with a 'tsconfig.json'."),
            Syntax_Colon_0: diag(6023, ts.DiagnosticCategory.Message, "Syntax_Colon_0_6023", "Syntax: {0}"),
            options: diag(6024, ts.DiagnosticCategory.Message, "options_6024", "options"),
            file: diag(6025, ts.DiagnosticCategory.Message, "file_6025", "file"),
            Examples_Colon_0: diag(6026, ts.DiagnosticCategory.Message, "Examples_Colon_0_6026", "Examples: {0}"),
            Options_Colon: diag(6027, ts.DiagnosticCategory.Message, "Options_Colon_6027", "Options:"),
            Version_0: diag(6029, ts.DiagnosticCategory.Message, "Version_0_6029", "Version {0}"),
            Insert_command_line_options_and_files_from_a_file: diag(6030, ts.DiagnosticCategory.Message, "Insert_command_line_options_and_files_from_a_file_6030", "Insert command line options and files from a file."),
            Starting_compilation_in_watch_mode: diag(6031, ts.DiagnosticCategory.Message, "Starting_compilation_in_watch_mode_6031", "Starting compilation in watch mode..."),
            File_change_detected_Starting_incremental_compilation: diag(6032, ts.DiagnosticCategory.Message, "File_change_detected_Starting_incremental_compilation_6032", "File change detected. Starting incremental compilation..."),
            KIND: diag(6034, ts.DiagnosticCategory.Message, "KIND_6034", "KIND"),
            FILE: diag(6035, ts.DiagnosticCategory.Message, "FILE_6035", "FILE"),
            VERSION: diag(6036, ts.DiagnosticCategory.Message, "VERSION_6036", "VERSION"),
            LOCATION: diag(6037, ts.DiagnosticCategory.Message, "LOCATION_6037", "LOCATION"),
            DIRECTORY: diag(6038, ts.DiagnosticCategory.Message, "DIRECTORY_6038", "DIRECTORY"),
            STRATEGY: diag(6039, ts.DiagnosticCategory.Message, "STRATEGY_6039", "STRATEGY"),
            FILE_OR_DIRECTORY: diag(6040, ts.DiagnosticCategory.Message, "FILE_OR_DIRECTORY_6040", "FILE OR DIRECTORY"),
            Generates_corresponding_map_file: diag(6043, ts.DiagnosticCategory.Message, "Generates_corresponding_map_file_6043", "Generates corresponding '.map' file."),
            Compiler_option_0_expects_an_argument: diag(6044, ts.DiagnosticCategory.Error, "Compiler_option_0_expects_an_argument_6044", "Compiler option '{0}' expects an argument."),
            Unterminated_quoted_string_in_response_file_0: diag(6045, ts.DiagnosticCategory.Error, "Unterminated_quoted_string_in_response_file_0_6045", "Unterminated quoted string in response file '{0}'."),
            Argument_for_0_option_must_be_Colon_1: diag(6046, ts.DiagnosticCategory.Error, "Argument_for_0_option_must_be_Colon_1_6046", "Argument for '{0}' option must be: {1}."),
            Locale_must_be_of_the_form_language_or_language_territory_For_example_0_or_1: diag(6048, ts.DiagnosticCategory.Error, "Locale_must_be_of_the_form_language_or_language_territory_For_example_0_or_1_6048", "Locale must be of the form <language> or <language>-<territory>. For example '{0}' or '{1}'."),
            Unsupported_locale_0: diag(6049, ts.DiagnosticCategory.Error, "Unsupported_locale_0_6049", "Unsupported locale '{0}'."),
            Unable_to_open_file_0: diag(6050, ts.DiagnosticCategory.Error, "Unable_to_open_file_0_6050", "Unable to open file '{0}'."),
            Corrupted_locale_file_0: diag(6051, ts.DiagnosticCategory.Error, "Corrupted_locale_file_0_6051", "Corrupted locale file {0}."),
            Raise_error_on_expressions_and_declarations_with_an_implied_any_type: diag(6052, ts.DiagnosticCategory.Message, "Raise_error_on_expressions_and_declarations_with_an_implied_any_type_6052", "Raise error on expressions and declarations with an implied 'any' type."),
            File_0_not_found: diag(6053, ts.DiagnosticCategory.Error, "File_0_not_found_6053", "File '{0}' not found."),
            File_0_has_an_unsupported_extension_The_only_supported_extensions_are_1: diag(6054, ts.DiagnosticCategory.Error, "File_0_has_an_unsupported_extension_The_only_supported_extensions_are_1_6054", "File '{0}' has an unsupported extension. The only supported extensions are {1}."),
            Suppress_noImplicitAny_errors_for_indexing_objects_lacking_index_signatures: diag(6055, ts.DiagnosticCategory.Message, "Suppress_noImplicitAny_errors_for_indexing_objects_lacking_index_signatures_6055", "Suppress noImplicitAny errors for indexing objects lacking index signatures."),
            Do_not_emit_declarations_for_code_that_has_an_internal_annotation: diag(6056, ts.DiagnosticCategory.Message, "Do_not_emit_declarations_for_code_that_has_an_internal_annotation_6056", "Do not emit declarations for code that has an '@internal' annotation."),
            Specify_the_root_directory_of_input_files_Use_to_control_the_output_directory_structure_with_outDir: diag(6058, ts.DiagnosticCategory.Message, "Specify_the_root_directory_of_input_files_Use_to_control_the_output_directory_structure_with_outDir_6058", "Specify the root directory of input files. Use to control the output directory structure with --outDir."),
            File_0_is_not_under_rootDir_1_rootDir_is_expected_to_contain_all_source_files: diag(6059, ts.DiagnosticCategory.Error, "File_0_is_not_under_rootDir_1_rootDir_is_expected_to_contain_all_source_files_6059", "File '{0}' is not under 'rootDir' '{1}'. 'rootDir' is expected to contain all source files."),
            Specify_the_end_of_line_sequence_to_be_used_when_emitting_files_Colon_CRLF_dos_or_LF_unix: diag(6060, ts.DiagnosticCategory.Message, "Specify_the_end_of_line_sequence_to_be_used_when_emitting_files_Colon_CRLF_dos_or_LF_unix_6060", "Specify the end of line sequence to be used when emitting files: 'CRLF' (dos) or 'LF' (unix)."),
            NEWLINE: diag(6061, ts.DiagnosticCategory.Message, "NEWLINE_6061", "NEWLINE"),
            Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_null_on_command_line: diag(6064, ts.DiagnosticCategory.Error, "Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_null_on_command_line_6064", "Option '{0}' can only be specified in 'tsconfig.json' file or set to 'null' on command line."),
            Enables_experimental_support_for_ES7_decorators: diag(6065, ts.DiagnosticCategory.Message, "Enables_experimental_support_for_ES7_decorators_6065", "Enables experimental support for ES7 decorators."),
            Enables_experimental_support_for_emitting_type_metadata_for_decorators: diag(6066, ts.DiagnosticCategory.Message, "Enables_experimental_support_for_emitting_type_metadata_for_decorators_6066", "Enables experimental support for emitting type metadata for decorators."),
            Enables_experimental_support_for_ES7_async_functions: diag(6068, ts.DiagnosticCategory.Message, "Enables_experimental_support_for_ES7_async_functions_6068", "Enables experimental support for ES7 async functions."),
            Specify_module_resolution_strategy_Colon_node_Node_js_or_classic_TypeScript_pre_1_6: diag(6069, ts.DiagnosticCategory.Message, "Specify_module_resolution_strategy_Colon_node_Node_js_or_classic_TypeScript_pre_1_6_6069", "Specify module resolution strategy: 'node' (Node.js) or 'classic' (TypeScript pre-1.6)."),
            Initializes_a_TypeScript_project_and_creates_a_tsconfig_json_file: diag(6070, ts.DiagnosticCategory.Message, "Initializes_a_TypeScript_project_and_creates_a_tsconfig_json_file_6070", "Initializes a TypeScript project and creates a tsconfig.json file."),
            Successfully_created_a_tsconfig_json_file: diag(6071, ts.DiagnosticCategory.Message, "Successfully_created_a_tsconfig_json_file_6071", "Successfully created a tsconfig.json file."),
            Suppress_excess_property_checks_for_object_literals: diag(6072, ts.DiagnosticCategory.Message, "Suppress_excess_property_checks_for_object_literals_6072", "Suppress excess property checks for object literals."),
            Stylize_errors_and_messages_using_color_and_context_experimental: diag(6073, ts.DiagnosticCategory.Message, "Stylize_errors_and_messages_using_color_and_context_experimental_6073", "Stylize errors and messages using color and context (experimental)."),
            Do_not_report_errors_on_unused_labels: diag(6074, ts.DiagnosticCategory.Message, "Do_not_report_errors_on_unused_labels_6074", "Do not report errors on unused labels."),
            Report_error_when_not_all_code_paths_in_function_return_a_value: diag(6075, ts.DiagnosticCategory.Message, "Report_error_when_not_all_code_paths_in_function_return_a_value_6075", "Report error when not all code paths in function return a value."),
            Report_errors_for_fallthrough_cases_in_switch_statement: diag(6076, ts.DiagnosticCategory.Message, "Report_errors_for_fallthrough_cases_in_switch_statement_6076", "Report errors for fallthrough cases in switch statement."),
            Do_not_report_errors_on_unreachable_code: diag(6077, ts.DiagnosticCategory.Message, "Do_not_report_errors_on_unreachable_code_6077", "Do not report errors on unreachable code."),
            Disallow_inconsistently_cased_references_to_the_same_file: diag(6078, ts.DiagnosticCategory.Message, "Disallow_inconsistently_cased_references_to_the_same_file_6078", "Disallow inconsistently-cased references to the same file."),
            Specify_library_files_to_be_included_in_the_compilation: diag(6079, ts.DiagnosticCategory.Message, "Specify_library_files_to_be_included_in_the_compilation_6079", "Specify library files to be included in the compilation."),
            Specify_JSX_code_generation_Colon_preserve_react_native_or_react: diag(6080, ts.DiagnosticCategory.Message, "Specify_JSX_code_generation_Colon_preserve_react_native_or_react_6080", "Specify JSX code generation: 'preserve', 'react-native', or 'react'."),
            File_0_has_an_unsupported_extension_so_skipping_it: diag(6081, ts.DiagnosticCategory.Message, "File_0_has_an_unsupported_extension_so_skipping_it_6081", "File '{0}' has an unsupported extension, so skipping it."),
            Only_amd_and_system_modules_are_supported_alongside_0: diag(6082, ts.DiagnosticCategory.Error, "Only_amd_and_system_modules_are_supported_alongside_0_6082", "Only 'amd' and 'system' modules are supported alongside --{0}."),
            Base_directory_to_resolve_non_absolute_module_names: diag(6083, ts.DiagnosticCategory.Message, "Base_directory_to_resolve_non_absolute_module_names_6083", "Base directory to resolve non-absolute module names."),
            Deprecated_Use_jsxFactory_instead_Specify_the_object_invoked_for_createElement_when_targeting_react_JSX_emit: diag(6084, ts.DiagnosticCategory.Message, "Deprecated_Use_jsxFactory_instead_Specify_the_object_invoked_for_createElement_when_targeting_react__6084", "[Deprecated] Use '--jsxFactory' instead. Specify the object invoked for createElement when targeting 'react' JSX emit"),
            Enable_tracing_of_the_name_resolution_process: diag(6085, ts.DiagnosticCategory.Message, "Enable_tracing_of_the_name_resolution_process_6085", "Enable tracing of the name resolution process."),
            Resolving_module_0_from_1: diag(6086, ts.DiagnosticCategory.Message, "Resolving_module_0_from_1_6086", "======== Resolving module '{0}' from '{1}'. ========"),
            Explicitly_specified_module_resolution_kind_Colon_0: diag(6087, ts.DiagnosticCategory.Message, "Explicitly_specified_module_resolution_kind_Colon_0_6087", "Explicitly specified module resolution kind: '{0}'."),
            Module_resolution_kind_is_not_specified_using_0: diag(6088, ts.DiagnosticCategory.Message, "Module_resolution_kind_is_not_specified_using_0_6088", "Module resolution kind is not specified, using '{0}'."),
            Module_name_0_was_successfully_resolved_to_1: diag(6089, ts.DiagnosticCategory.Message, "Module_name_0_was_successfully_resolved_to_1_6089", "======== Module name '{0}' was successfully resolved to '{1}'. ========"),
            Module_name_0_was_not_resolved: diag(6090, ts.DiagnosticCategory.Message, "Module_name_0_was_not_resolved_6090", "======== Module name '{0}' was not resolved. ========"),
            paths_option_is_specified_looking_for_a_pattern_to_match_module_name_0: diag(6091, ts.DiagnosticCategory.Message, "paths_option_is_specified_looking_for_a_pattern_to_match_module_name_0_6091", "'paths' option is specified, looking for a pattern to match module name '{0}'."),
            Module_name_0_matched_pattern_1: diag(6092, ts.DiagnosticCategory.Message, "Module_name_0_matched_pattern_1_6092", "Module name '{0}', matched pattern '{1}'."),
            Trying_substitution_0_candidate_module_location_Colon_1: diag(6093, ts.DiagnosticCategory.Message, "Trying_substitution_0_candidate_module_location_Colon_1_6093", "Trying substitution '{0}', candidate module location: '{1}'."),
            Resolving_module_name_0_relative_to_base_url_1_2: diag(6094, ts.DiagnosticCategory.Message, "Resolving_module_name_0_relative_to_base_url_1_2_6094", "Resolving module name '{0}' relative to base url '{1}' - '{2}'."),
            Loading_module_as_file_Slash_folder_candidate_module_location_0_target_file_type_1: diag(6095, ts.DiagnosticCategory.Message, "Loading_module_as_file_Slash_folder_candidate_module_location_0_target_file_type_1_6095", "Loading module as file / folder, candidate module location '{0}', target file type '{1}'."),
            File_0_does_not_exist: diag(6096, ts.DiagnosticCategory.Message, "File_0_does_not_exist_6096", "File '{0}' does not exist."),
            File_0_exist_use_it_as_a_name_resolution_result: diag(6097, ts.DiagnosticCategory.Message, "File_0_exist_use_it_as_a_name_resolution_result_6097", "File '{0}' exist - use it as a name resolution result."),
            Loading_module_0_from_node_modules_folder_target_file_type_1: diag(6098, ts.DiagnosticCategory.Message, "Loading_module_0_from_node_modules_folder_target_file_type_1_6098", "Loading module '{0}' from 'node_modules' folder, target file type '{1}'."),
            Found_package_json_at_0: diag(6099, ts.DiagnosticCategory.Message, "Found_package_json_at_0_6099", "Found 'package.json' at '{0}'."),
            package_json_does_not_have_a_0_field: diag(6100, ts.DiagnosticCategory.Message, "package_json_does_not_have_a_0_field_6100", "'package.json' does not have a '{0}' field."),
            package_json_has_0_field_1_that_references_2: diag(6101, ts.DiagnosticCategory.Message, "package_json_has_0_field_1_that_references_2_6101", "'package.json' has '{0}' field '{1}' that references '{2}'."),
            Allow_javascript_files_to_be_compiled: diag(6102, ts.DiagnosticCategory.Message, "Allow_javascript_files_to_be_compiled_6102", "Allow javascript files to be compiled."),
            Option_0_should_have_array_of_strings_as_a_value: diag(6103, ts.DiagnosticCategory.Error, "Option_0_should_have_array_of_strings_as_a_value_6103", "Option '{0}' should have array of strings as a value."),
            Checking_if_0_is_the_longest_matching_prefix_for_1_2: diag(6104, ts.DiagnosticCategory.Message, "Checking_if_0_is_the_longest_matching_prefix_for_1_2_6104", "Checking if '{0}' is the longest matching prefix for '{1}' - '{2}'."),
            Expected_type_of_0_field_in_package_json_to_be_1_got_2: diag(6105, ts.DiagnosticCategory.Message, "Expected_type_of_0_field_in_package_json_to_be_1_got_2_6105", "Expected type of '{0}' field in 'package.json' to be '{1}', got '{2}'."),
            baseUrl_option_is_set_to_0_using_this_value_to_resolve_non_relative_module_name_1: diag(6106, ts.DiagnosticCategory.Message, "baseUrl_option_is_set_to_0_using_this_value_to_resolve_non_relative_module_name_1_6106", "'baseUrl' option is set to '{0}', using this value to resolve non-relative module name '{1}'."),
            rootDirs_option_is_set_using_it_to_resolve_relative_module_name_0: diag(6107, ts.DiagnosticCategory.Message, "rootDirs_option_is_set_using_it_to_resolve_relative_module_name_0_6107", "'rootDirs' option is set, using it to resolve relative module name '{0}'."),
            Longest_matching_prefix_for_0_is_1: diag(6108, ts.DiagnosticCategory.Message, "Longest_matching_prefix_for_0_is_1_6108", "Longest matching prefix for '{0}' is '{1}'."),
            Loading_0_from_the_root_dir_1_candidate_location_2: diag(6109, ts.DiagnosticCategory.Message, "Loading_0_from_the_root_dir_1_candidate_location_2_6109", "Loading '{0}' from the root dir '{1}', candidate location '{2}'."),
            Trying_other_entries_in_rootDirs: diag(6110, ts.DiagnosticCategory.Message, "Trying_other_entries_in_rootDirs_6110", "Trying other entries in 'rootDirs'."),
            Module_resolution_using_rootDirs_has_failed: diag(6111, ts.DiagnosticCategory.Message, "Module_resolution_using_rootDirs_has_failed_6111", "Module resolution using 'rootDirs' has failed."),
            Do_not_emit_use_strict_directives_in_module_output: diag(6112, ts.DiagnosticCategory.Message, "Do_not_emit_use_strict_directives_in_module_output_6112", "Do not emit 'use strict' directives in module output."),
            Enable_strict_null_checks: diag(6113, ts.DiagnosticCategory.Message, "Enable_strict_null_checks_6113", "Enable strict null checks."),
            Unknown_option_excludes_Did_you_mean_exclude: diag(6114, ts.DiagnosticCategory.Error, "Unknown_option_excludes_Did_you_mean_exclude_6114", "Unknown option 'excludes'. Did you mean 'exclude'?"),
            Raise_error_on_this_expressions_with_an_implied_any_type: diag(6115, ts.DiagnosticCategory.Message, "Raise_error_on_this_expressions_with_an_implied_any_type_6115", "Raise error on 'this' expressions with an implied 'any' type."),
            Resolving_type_reference_directive_0_containing_file_1_root_directory_2: diag(6116, ts.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_1_root_directory_2_6116", "======== Resolving type reference directive '{0}', containing file '{1}', root directory '{2}'. ========"),
            Resolving_using_primary_search_paths: diag(6117, ts.DiagnosticCategory.Message, "Resolving_using_primary_search_paths_6117", "Resolving using primary search paths..."),
            Resolving_from_node_modules_folder: diag(6118, ts.DiagnosticCategory.Message, "Resolving_from_node_modules_folder_6118", "Resolving from node_modules folder..."),
            Type_reference_directive_0_was_successfully_resolved_to_1_primary_Colon_2: diag(6119, ts.DiagnosticCategory.Message, "Type_reference_directive_0_was_successfully_resolved_to_1_primary_Colon_2_6119", "======== Type reference directive '{0}' was successfully resolved to '{1}', primary: {2}. ========"),
            Type_reference_directive_0_was_not_resolved: diag(6120, ts.DiagnosticCategory.Message, "Type_reference_directive_0_was_not_resolved_6120", "======== Type reference directive '{0}' was not resolved. ========"),
            Resolving_with_primary_search_path_0: diag(6121, ts.DiagnosticCategory.Message, "Resolving_with_primary_search_path_0_6121", "Resolving with primary search path '{0}'."),
            Root_directory_cannot_be_determined_skipping_primary_search_paths: diag(6122, ts.DiagnosticCategory.Message, "Root_directory_cannot_be_determined_skipping_primary_search_paths_6122", "Root directory cannot be determined, skipping primary search paths."),
            Resolving_type_reference_directive_0_containing_file_1_root_directory_not_set: diag(6123, ts.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_1_root_directory_not_set_6123", "======== Resolving type reference directive '{0}', containing file '{1}', root directory not set. ========"),
            Type_declaration_files_to_be_included_in_compilation: diag(6124, ts.DiagnosticCategory.Message, "Type_declaration_files_to_be_included_in_compilation_6124", "Type declaration files to be included in compilation."),
            Looking_up_in_node_modules_folder_initial_location_0: diag(6125, ts.DiagnosticCategory.Message, "Looking_up_in_node_modules_folder_initial_location_0_6125", "Looking up in 'node_modules' folder, initial location '{0}'."),
            Containing_file_is_not_specified_and_root_directory_cannot_be_determined_skipping_lookup_in_node_modules_folder: diag(6126, ts.DiagnosticCategory.Message, "Containing_file_is_not_specified_and_root_directory_cannot_be_determined_skipping_lookup_in_node_mod_6126", "Containing file is not specified and root directory cannot be determined, skipping lookup in 'node_modules' folder."),
            Resolving_type_reference_directive_0_containing_file_not_set_root_directory_1: diag(6127, ts.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_not_set_root_directory_1_6127", "======== Resolving type reference directive '{0}', containing file not set, root directory '{1}'. ========"),
            Resolving_type_reference_directive_0_containing_file_not_set_root_directory_not_set: diag(6128, ts.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_not_set_root_directory_not_set_6128", "======== Resolving type reference directive '{0}', containing file not set, root directory not set. ========"),
            Resolving_real_path_for_0_result_1: diag(6130, ts.DiagnosticCategory.Message, "Resolving_real_path_for_0_result_1_6130", "Resolving real path for '{0}', result '{1}'."),
            Cannot_compile_modules_using_option_0_unless_the_module_flag_is_amd_or_system: diag(6131, ts.DiagnosticCategory.Error, "Cannot_compile_modules_using_option_0_unless_the_module_flag_is_amd_or_system_6131", "Cannot compile modules using option '{0}' unless the '--module' flag is 'amd' or 'system'."),
            File_name_0_has_a_1_extension_stripping_it: diag(6132, ts.DiagnosticCategory.Message, "File_name_0_has_a_1_extension_stripping_it_6132", "File name '{0}' has a '{1}' extension - stripping it."),
            _0_is_declared_but_its_value_is_never_read: diag(6133, ts.DiagnosticCategory.Error, "_0_is_declared_but_its_value_is_never_read_6133", "'{0}' is declared but its value is never read.", /*reportsUnnecessary*/ true),
            Report_errors_on_unused_locals: diag(6134, ts.DiagnosticCategory.Message, "Report_errors_on_unused_locals_6134", "Report errors on unused locals."),
            Report_errors_on_unused_parameters: diag(6135, ts.DiagnosticCategory.Message, "Report_errors_on_unused_parameters_6135", "Report errors on unused parameters."),
            The_maximum_dependency_depth_to_search_under_node_modules_and_load_JavaScript_files: diag(6136, ts.DiagnosticCategory.Message, "The_maximum_dependency_depth_to_search_under_node_modules_and_load_JavaScript_files_6136", "The maximum dependency depth to search under node_modules and load JavaScript files."),
            Cannot_import_type_declaration_files_Consider_importing_0_instead_of_1: diag(6137, ts.DiagnosticCategory.Error, "Cannot_import_type_declaration_files_Consider_importing_0_instead_of_1_6137", "Cannot import type declaration files. Consider importing '{0}' instead of '{1}'."),
            Property_0_is_declared_but_its_value_is_never_read: diag(6138, ts.DiagnosticCategory.Error, "Property_0_is_declared_but_its_value_is_never_read_6138", "Property '{0}' is declared but its value is never read.", /*reportsUnnecessary*/ true),
            Import_emit_helpers_from_tslib: diag(6139, ts.DiagnosticCategory.Message, "Import_emit_helpers_from_tslib_6139", "Import emit helpers from 'tslib'."),
            Auto_discovery_for_typings_is_enabled_in_project_0_Running_extra_resolution_pass_for_module_1_using_cache_location_2: diag(6140, ts.DiagnosticCategory.Error, "Auto_discovery_for_typings_is_enabled_in_project_0_Running_extra_resolution_pass_for_module_1_using__6140", "Auto discovery for typings is enabled in project '{0}'. Running extra resolution pass for module '{1}' using cache location '{2}'."),
            Parse_in_strict_mode_and_emit_use_strict_for_each_source_file: diag(6141, ts.DiagnosticCategory.Message, "Parse_in_strict_mode_and_emit_use_strict_for_each_source_file_6141", "Parse in strict mode and emit \"use strict\" for each source file."),
            Module_0_was_resolved_to_1_but_jsx_is_not_set: diag(6142, ts.DiagnosticCategory.Error, "Module_0_was_resolved_to_1_but_jsx_is_not_set_6142", "Module '{0}' was resolved to '{1}', but '--jsx' is not set."),
            Module_0_was_resolved_as_locally_declared_ambient_module_in_file_1: diag(6144, ts.DiagnosticCategory.Message, "Module_0_was_resolved_as_locally_declared_ambient_module_in_file_1_6144", "Module '{0}' was resolved as locally declared ambient module in file '{1}'."),
            Module_0_was_resolved_as_ambient_module_declared_in_1_since_this_file_was_not_modified: diag(6145, ts.DiagnosticCategory.Message, "Module_0_was_resolved_as_ambient_module_declared_in_1_since_this_file_was_not_modified_6145", "Module '{0}' was resolved as ambient module declared in '{1}' since this file was not modified."),
            Specify_the_JSX_factory_function_to_use_when_targeting_react_JSX_emit_e_g_React_createElement_or_h: diag(6146, ts.DiagnosticCategory.Message, "Specify_the_JSX_factory_function_to_use_when_targeting_react_JSX_emit_e_g_React_createElement_or_h_6146", "Specify the JSX factory function to use when targeting 'react' JSX emit, e.g. 'React.createElement' or 'h'."),
            Resolution_for_module_0_was_found_in_cache_from_location_1: diag(6147, ts.DiagnosticCategory.Message, "Resolution_for_module_0_was_found_in_cache_from_location_1_6147", "Resolution for module '{0}' was found in cache from location '{1}'."),
            Directory_0_does_not_exist_skipping_all_lookups_in_it: diag(6148, ts.DiagnosticCategory.Message, "Directory_0_does_not_exist_skipping_all_lookups_in_it_6148", "Directory '{0}' does not exist, skipping all lookups in it."),
            Show_diagnostic_information: diag(6149, ts.DiagnosticCategory.Message, "Show_diagnostic_information_6149", "Show diagnostic information."),
            Show_verbose_diagnostic_information: diag(6150, ts.DiagnosticCategory.Message, "Show_verbose_diagnostic_information_6150", "Show verbose diagnostic information."),
            Emit_a_single_file_with_source_maps_instead_of_having_a_separate_file: diag(6151, ts.DiagnosticCategory.Message, "Emit_a_single_file_with_source_maps_instead_of_having_a_separate_file_6151", "Emit a single file with source maps instead of having a separate file."),
            Emit_the_source_alongside_the_sourcemaps_within_a_single_file_requires_inlineSourceMap_or_sourceMap_to_be_set: diag(6152, ts.DiagnosticCategory.Message, "Emit_the_source_alongside_the_sourcemaps_within_a_single_file_requires_inlineSourceMap_or_sourceMap__6152", "Emit the source alongside the sourcemaps within a single file; requires '--inlineSourceMap' or '--sourceMap' to be set."),
            Transpile_each_file_as_a_separate_module_similar_to_ts_transpileModule: diag(6153, ts.DiagnosticCategory.Message, "Transpile_each_file_as_a_separate_module_similar_to_ts_transpileModule_6153", "Transpile each file as a separate module (similar to 'ts.transpileModule')."),
            Print_names_of_generated_files_part_of_the_compilation: diag(6154, ts.DiagnosticCategory.Message, "Print_names_of_generated_files_part_of_the_compilation_6154", "Print names of generated files part of the compilation."),
            Print_names_of_files_part_of_the_compilation: diag(6155, ts.DiagnosticCategory.Message, "Print_names_of_files_part_of_the_compilation_6155", "Print names of files part of the compilation."),
            The_locale_used_when_displaying_messages_to_the_user_e_g_en_us: diag(6156, ts.DiagnosticCategory.Message, "The_locale_used_when_displaying_messages_to_the_user_e_g_en_us_6156", "The locale used when displaying messages to the user (e.g. 'en-us')"),
            Do_not_generate_custom_helper_functions_like_extends_in_compiled_output: diag(6157, ts.DiagnosticCategory.Message, "Do_not_generate_custom_helper_functions_like_extends_in_compiled_output_6157", "Do not generate custom helper functions like '__extends' in compiled output."),
            Do_not_include_the_default_library_file_lib_d_ts: diag(6158, ts.DiagnosticCategory.Message, "Do_not_include_the_default_library_file_lib_d_ts_6158", "Do not include the default library file (lib.d.ts)."),
            Do_not_add_triple_slash_references_or_imported_modules_to_the_list_of_compiled_files: diag(6159, ts.DiagnosticCategory.Message, "Do_not_add_triple_slash_references_or_imported_modules_to_the_list_of_compiled_files_6159", "Do not add triple-slash references or imported modules to the list of compiled files."),
            Deprecated_Use_skipLibCheck_instead_Skip_type_checking_of_default_library_declaration_files: diag(6160, ts.DiagnosticCategory.Message, "Deprecated_Use_skipLibCheck_instead_Skip_type_checking_of_default_library_declaration_files_6160", "[Deprecated] Use '--skipLibCheck' instead. Skip type checking of default library declaration files."),
            List_of_folders_to_include_type_definitions_from: diag(6161, ts.DiagnosticCategory.Message, "List_of_folders_to_include_type_definitions_from_6161", "List of folders to include type definitions from."),
            Disable_size_limitations_on_JavaScript_projects: diag(6162, ts.DiagnosticCategory.Message, "Disable_size_limitations_on_JavaScript_projects_6162", "Disable size limitations on JavaScript projects."),
            The_character_set_of_the_input_files: diag(6163, ts.DiagnosticCategory.Message, "The_character_set_of_the_input_files_6163", "The character set of the input files."),
            Emit_a_UTF_8_Byte_Order_Mark_BOM_in_the_beginning_of_output_files: diag(6164, ts.DiagnosticCategory.Message, "Emit_a_UTF_8_Byte_Order_Mark_BOM_in_the_beginning_of_output_files_6164", "Emit a UTF-8 Byte Order Mark (BOM) in the beginning of output files."),
            Do_not_truncate_error_messages: diag(6165, ts.DiagnosticCategory.Message, "Do_not_truncate_error_messages_6165", "Do not truncate error messages."),
            Output_directory_for_generated_declaration_files: diag(6166, ts.DiagnosticCategory.Message, "Output_directory_for_generated_declaration_files_6166", "Output directory for generated declaration files."),
            A_series_of_entries_which_re_map_imports_to_lookup_locations_relative_to_the_baseUrl: diag(6167, ts.DiagnosticCategory.Message, "A_series_of_entries_which_re_map_imports_to_lookup_locations_relative_to_the_baseUrl_6167", "A series of entries which re-map imports to lookup locations relative to the 'baseUrl'."),
            List_of_root_folders_whose_combined_content_represents_the_structure_of_the_project_at_runtime: diag(6168, ts.DiagnosticCategory.Message, "List_of_root_folders_whose_combined_content_represents_the_structure_of_the_project_at_runtime_6168", "List of root folders whose combined content represents the structure of the project at runtime."),
            Show_all_compiler_options: diag(6169, ts.DiagnosticCategory.Message, "Show_all_compiler_options_6169", "Show all compiler options."),
            Deprecated_Use_outFile_instead_Concatenate_and_emit_output_to_single_file: diag(6170, ts.DiagnosticCategory.Message, "Deprecated_Use_outFile_instead_Concatenate_and_emit_output_to_single_file_6170", "[Deprecated] Use '--outFile' instead. Concatenate and emit output to single file"),
            Command_line_Options: diag(6171, ts.DiagnosticCategory.Message, "Command_line_Options_6171", "Command-line Options"),
            Basic_Options: diag(6172, ts.DiagnosticCategory.Message, "Basic_Options_6172", "Basic Options"),
            Strict_Type_Checking_Options: diag(6173, ts.DiagnosticCategory.Message, "Strict_Type_Checking_Options_6173", "Strict Type-Checking Options"),
            Module_Resolution_Options: diag(6174, ts.DiagnosticCategory.Message, "Module_Resolution_Options_6174", "Module Resolution Options"),
            Source_Map_Options: diag(6175, ts.DiagnosticCategory.Message, "Source_Map_Options_6175", "Source Map Options"),
            Additional_Checks: diag(6176, ts.DiagnosticCategory.Message, "Additional_Checks_6176", "Additional Checks"),
            Experimental_Options: diag(6177, ts.DiagnosticCategory.Message, "Experimental_Options_6177", "Experimental Options"),
            Advanced_Options: diag(6178, ts.DiagnosticCategory.Message, "Advanced_Options_6178", "Advanced Options"),
            Provide_full_support_for_iterables_in_for_of_spread_and_destructuring_when_targeting_ES5_or_ES3: diag(6179, ts.DiagnosticCategory.Message, "Provide_full_support_for_iterables_in_for_of_spread_and_destructuring_when_targeting_ES5_or_ES3_6179", "Provide full support for iterables in 'for-of', spread, and destructuring when targeting 'ES5' or 'ES3'."),
            Enable_all_strict_type_checking_options: diag(6180, ts.DiagnosticCategory.Message, "Enable_all_strict_type_checking_options_6180", "Enable all strict type-checking options."),
            List_of_language_service_plugins: diag(6181, ts.DiagnosticCategory.Message, "List_of_language_service_plugins_6181", "List of language service plugins."),
            Scoped_package_detected_looking_in_0: diag(6182, ts.DiagnosticCategory.Message, "Scoped_package_detected_looking_in_0_6182", "Scoped package detected, looking in '{0}'"),
            Reusing_resolution_of_module_0_to_file_1_from_old_program: diag(6183, ts.DiagnosticCategory.Message, "Reusing_resolution_of_module_0_to_file_1_from_old_program_6183", "Reusing resolution of module '{0}' to file '{1}' from old program."),
            Reusing_module_resolutions_originating_in_0_since_resolutions_are_unchanged_from_old_program: diag(6184, ts.DiagnosticCategory.Message, "Reusing_module_resolutions_originating_in_0_since_resolutions_are_unchanged_from_old_program_6184", "Reusing module resolutions originating in '{0}' since resolutions are unchanged from old program."),
            Disable_strict_checking_of_generic_signatures_in_function_types: diag(6185, ts.DiagnosticCategory.Message, "Disable_strict_checking_of_generic_signatures_in_function_types_6185", "Disable strict checking of generic signatures in function types."),
            Enable_strict_checking_of_function_types: diag(6186, ts.DiagnosticCategory.Message, "Enable_strict_checking_of_function_types_6186", "Enable strict checking of function types."),
            Enable_strict_checking_of_property_initialization_in_classes: diag(6187, ts.DiagnosticCategory.Message, "Enable_strict_checking_of_property_initialization_in_classes_6187", "Enable strict checking of property initialization in classes."),
            Numeric_separators_are_not_allowed_here: diag(6188, ts.DiagnosticCategory.Error, "Numeric_separators_are_not_allowed_here_6188", "Numeric separators are not allowed here."),
            Multiple_consecutive_numeric_separators_are_not_permitted: diag(6189, ts.DiagnosticCategory.Error, "Multiple_consecutive_numeric_separators_are_not_permitted_6189", "Multiple consecutive numeric separators are not permitted."),
            Whether_to_keep_outdated_console_output_in_watch_mode_instead_of_clearing_the_screen: diag(6191, ts.DiagnosticCategory.Message, "Whether_to_keep_outdated_console_output_in_watch_mode_instead_of_clearing_the_screen_6191", "Whether to keep outdated console output in watch mode instead of clearing the screen."),
            All_imports_in_import_declaration_are_unused: diag(6192, ts.DiagnosticCategory.Error, "All_imports_in_import_declaration_are_unused_6192", "All imports in import declaration are unused.", /*reportsUnnecessary*/ true),
            Found_1_error_Watching_for_file_changes: diag(6193, ts.DiagnosticCategory.Message, "Found_1_error_Watching_for_file_changes_6193", "Found 1 error. Watching for file changes."),
            Found_0_errors_Watching_for_file_changes: diag(6194, ts.DiagnosticCategory.Message, "Found_0_errors_Watching_for_file_changes_6194", "Found {0} errors. Watching for file changes."),
            Resolve_keyof_to_string_valued_property_names_only_no_numbers_or_symbols: diag(6195, ts.DiagnosticCategory.Message, "Resolve_keyof_to_string_valued_property_names_only_no_numbers_or_symbols_6195", "Resolve 'keyof' to string valued property names only (no numbers or symbols)."),
            _0_is_declared_but_never_used: diag(6196, ts.DiagnosticCategory.Error, "_0_is_declared_but_never_used_6196", "'{0}' is declared but never used.", /*reportsUnnecessary*/ true),
            Include_modules_imported_with_json_extension: diag(6197, ts.DiagnosticCategory.Message, "Include_modules_imported_with_json_extension_6197", "Include modules imported with '.json' extension"),
            All_destructured_elements_are_unused: diag(6198, ts.DiagnosticCategory.Error, "All_destructured_elements_are_unused_6198", "All destructured elements are unused.", /*reportsUnnecessary*/ true),
            All_variables_are_unused: diag(6199, ts.DiagnosticCategory.Error, "All_variables_are_unused_6199", "All variables are unused.", /*reportsUnnecessary*/ true),
            Definitions_of_the_following_identifiers_conflict_with_those_in_another_file_Colon_0: diag(6200, ts.DiagnosticCategory.Error, "Definitions_of_the_following_identifiers_conflict_with_those_in_another_file_Colon_0_6200", "Definitions of the following identifiers conflict with those in another file: {0}"),
            Conflicts_are_in_this_file: diag(6201, ts.DiagnosticCategory.Message, "Conflicts_are_in_this_file_6201", "Conflicts are in this file."),
            Project_references_may_not_form_a_circular_graph_Cycle_detected_Colon_0: diag(6202, ts.DiagnosticCategory.Error, "Project_references_may_not_form_a_circular_graph_Cycle_detected_Colon_0_6202", "Project references may not form a circular graph. Cycle detected: {0}"),
            _0_was_also_declared_here: diag(6203, ts.DiagnosticCategory.Message, "_0_was_also_declared_here_6203", "'{0}' was also declared here."),
            and_here: diag(6204, ts.DiagnosticCategory.Message, "and_here_6204", "and here."),
            All_type_parameters_are_unused: diag(6205, ts.DiagnosticCategory.Error, "All_type_parameters_are_unused_6205", "All type parameters are unused"),
            package_json_has_a_typesVersions_field_with_version_specific_path_mappings: diag(6206, ts.DiagnosticCategory.Message, "package_json_has_a_typesVersions_field_with_version_specific_path_mappings_6206", "'package.json' has a 'typesVersions' field with version-specific path mappings."),
            package_json_does_not_have_a_typesVersions_entry_that_matches_version_0: diag(6207, ts.DiagnosticCategory.Message, "package_json_does_not_have_a_typesVersions_entry_that_matches_version_0_6207", "'package.json' does not have a 'typesVersions' entry that matches version '{0}'."),
            package_json_has_a_typesVersions_entry_0_that_matches_compiler_version_1_looking_for_a_pattern_to_match_module_name_2: diag(6208, ts.DiagnosticCategory.Message, "package_json_has_a_typesVersions_entry_0_that_matches_compiler_version_1_looking_for_a_pattern_to_ma_6208", "'package.json' has a 'typesVersions' entry '{0}' that matches compiler version '{1}', looking for a pattern to match module name '{2}'."),
            package_json_has_a_typesVersions_entry_0_that_is_not_a_valid_semver_range: diag(6209, ts.DiagnosticCategory.Message, "package_json_has_a_typesVersions_entry_0_that_is_not_a_valid_semver_range_6209", "'package.json' has a 'typesVersions' entry '{0}' that is not a valid semver range."),
            An_argument_for_0_was_not_provided: diag(6210, ts.DiagnosticCategory.Message, "An_argument_for_0_was_not_provided_6210", "An argument for '{0}' was not provided."),
            An_argument_matching_this_binding_pattern_was_not_provided: diag(6211, ts.DiagnosticCategory.Message, "An_argument_matching_this_binding_pattern_was_not_provided_6211", "An argument matching this binding pattern was not provided."),
            Did_you_mean_to_call_this_expression: diag(6212, ts.DiagnosticCategory.Message, "Did_you_mean_to_call_this_expression_6212", "Did you mean to call this expression?"),
            Did_you_mean_to_use_new_with_this_expression: diag(6213, ts.DiagnosticCategory.Message, "Did_you_mean_to_use_new_with_this_expression_6213", "Did you mean to use 'new' with this expression?"),
            Enable_strict_bind_call_and_apply_methods_on_functions: diag(6214, ts.DiagnosticCategory.Message, "Enable_strict_bind_call_and_apply_methods_on_functions_6214", "Enable strict 'bind', 'call', and 'apply' methods on functions."),
            Using_compiler_options_of_project_reference_redirect_0: diag(6215, ts.DiagnosticCategory.Message, "Using_compiler_options_of_project_reference_redirect_0_6215", "Using compiler options of project reference redirect '{0}'."),
            Found_1_error: diag(6216, ts.DiagnosticCategory.Message, "Found_1_error_6216", "Found 1 error."),
            Found_0_errors: diag(6217, ts.DiagnosticCategory.Message, "Found_0_errors_6217", "Found {0} errors."),
            Module_name_0_was_successfully_resolved_to_1_with_Package_ID_2: diag(6218, ts.DiagnosticCategory.Message, "Module_name_0_was_successfully_resolved_to_1_with_Package_ID_2_6218", "======== Module name '{0}' was successfully resolved to '{1}' with Package ID '{2}'. ========"),
            Type_reference_directive_0_was_successfully_resolved_to_1_with_Package_ID_2_primary_Colon_3: diag(6219, ts.DiagnosticCategory.Message, "Type_reference_directive_0_was_successfully_resolved_to_1_with_Package_ID_2_primary_Colon_3_6219", "======== Type reference directive '{0}' was successfully resolved to '{1}' with Package ID '{2}', primary: {3}. ========"),
            package_json_had_a_falsy_0_field: diag(6220, ts.DiagnosticCategory.Message, "package_json_had_a_falsy_0_field_6220", "'package.json' had a falsy '{0}' field."),
            Disable_use_of_source_files_instead_of_declaration_files_from_referenced_projects: diag(6221, ts.DiagnosticCategory.Message, "Disable_use_of_source_files_instead_of_declaration_files_from_referenced_projects_6221", "Disable use of source files instead of declaration files from referenced projects."),
            Emit_class_fields_with_Define_instead_of_Set: diag(6222, ts.DiagnosticCategory.Message, "Emit_class_fields_with_Define_instead_of_Set_6222", "Emit class fields with Define instead of Set."),
            Generates_a_CPU_profile: diag(6223, ts.DiagnosticCategory.Message, "Generates_a_CPU_profile_6223", "Generates a CPU profile."),
            Disable_solution_searching_for_this_project: diag(6224, ts.DiagnosticCategory.Message, "Disable_solution_searching_for_this_project_6224", "Disable solution searching for this project."),
            Specify_strategy_for_watching_file_Colon_FixedPollingInterval_default_PriorityPollingInterval_DynamicPriorityPolling_UseFsEvents_UseFsEventsOnParentDirectory: diag(6225, ts.DiagnosticCategory.Message, "Specify_strategy_for_watching_file_Colon_FixedPollingInterval_default_PriorityPollingInterval_Dynami_6225", "Specify strategy for watching file: 'FixedPollingInterval' (default), 'PriorityPollingInterval', 'DynamicPriorityPolling', 'UseFsEvents', 'UseFsEventsOnParentDirectory'."),
            Specify_strategy_for_watching_directory_on_platforms_that_don_t_support_recursive_watching_natively_Colon_UseFsEvents_default_FixedPollingInterval_DynamicPriorityPolling: diag(6226, ts.DiagnosticCategory.Message, "Specify_strategy_for_watching_directory_on_platforms_that_don_t_support_recursive_watching_natively__6226", "Specify strategy for watching directory on platforms that don't support recursive watching natively: 'UseFsEvents' (default), 'FixedPollingInterval', 'DynamicPriorityPolling'."),
            Specify_strategy_for_creating_a_polling_watch_when_it_fails_to_create_using_file_system_events_Colon_FixedInterval_default_PriorityInterval_DynamicPriority: diag(6227, ts.DiagnosticCategory.Message, "Specify_strategy_for_creating_a_polling_watch_when_it_fails_to_create_using_file_system_events_Colon_6227", "Specify strategy for creating a polling watch when it fails to create using file system events: 'FixedInterval' (default), 'PriorityInterval', 'DynamicPriority'."),
            Synchronously_call_callbacks_and_update_the_state_of_directory_watchers_on_platforms_that_don_t_support_recursive_watching_natively: diag(6228, ts.DiagnosticCategory.Message, "Synchronously_call_callbacks_and_update_the_state_of_directory_watchers_on_platforms_that_don_t_supp_6228", "Synchronously call callbacks and update the state of directory watchers on platforms that don't support recursive watching natively."),
            Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_false_or_null_on_command_line: diag(6230, ts.DiagnosticCategory.Error, "Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_false_or_null_on_command_line_6230", "Option '{0}' can only be specified in 'tsconfig.json' file or set to 'false' or 'null' on command line."),
            Projects_to_reference: diag(6300, ts.DiagnosticCategory.Message, "Projects_to_reference_6300", "Projects to reference"),
            Enable_project_compilation: diag(6302, ts.DiagnosticCategory.Message, "Enable_project_compilation_6302", "Enable project compilation"),
            Composite_projects_may_not_disable_declaration_emit: diag(6304, ts.DiagnosticCategory.Error, "Composite_projects_may_not_disable_declaration_emit_6304", "Composite projects may not disable declaration emit."),
            Output_file_0_has_not_been_built_from_source_file_1: diag(6305, ts.DiagnosticCategory.Error, "Output_file_0_has_not_been_built_from_source_file_1_6305", "Output file '{0}' has not been built from source file '{1}'."),
            Referenced_project_0_must_have_setting_composite_Colon_true: diag(6306, ts.DiagnosticCategory.Error, "Referenced_project_0_must_have_setting_composite_Colon_true_6306", "Referenced project '{0}' must have setting \"composite\": true."),
            File_0_is_not_listed_within_the_file_list_of_project_1_Projects_must_list_all_files_or_use_an_include_pattern: diag(6307, ts.DiagnosticCategory.Error, "File_0_is_not_listed_within_the_file_list_of_project_1_Projects_must_list_all_files_or_use_an_includ_6307", "File '{0}' is not listed within the file list of project '{1}'. Projects must list all files or use an 'include' pattern."),
            Cannot_prepend_project_0_because_it_does_not_have_outFile_set: diag(6308, ts.DiagnosticCategory.Error, "Cannot_prepend_project_0_because_it_does_not_have_outFile_set_6308", "Cannot prepend project '{0}' because it does not have 'outFile' set"),
            Output_file_0_from_project_1_does_not_exist: diag(6309, ts.DiagnosticCategory.Error, "Output_file_0_from_project_1_does_not_exist_6309", "Output file '{0}' from project '{1}' does not exist"),
            Project_0_is_out_of_date_because_oldest_output_1_is_older_than_newest_input_2: diag(6350, ts.DiagnosticCategory.Message, "Project_0_is_out_of_date_because_oldest_output_1_is_older_than_newest_input_2_6350", "Project '{0}' is out of date because oldest output '{1}' is older than newest input '{2}'"),
            Project_0_is_up_to_date_because_newest_input_1_is_older_than_oldest_output_2: diag(6351, ts.DiagnosticCategory.Message, "Project_0_is_up_to_date_because_newest_input_1_is_older_than_oldest_output_2_6351", "Project '{0}' is up to date because newest input '{1}' is older than oldest output '{2}'"),
            Project_0_is_out_of_date_because_output_file_1_does_not_exist: diag(6352, ts.DiagnosticCategory.Message, "Project_0_is_out_of_date_because_output_file_1_does_not_exist_6352", "Project '{0}' is out of date because output file '{1}' does not exist"),
            Project_0_is_out_of_date_because_its_dependency_1_is_out_of_date: diag(6353, ts.DiagnosticCategory.Message, "Project_0_is_out_of_date_because_its_dependency_1_is_out_of_date_6353", "Project '{0}' is out of date because its dependency '{1}' is out of date"),
            Project_0_is_up_to_date_with_d_ts_files_from_its_dependencies: diag(6354, ts.DiagnosticCategory.Message, "Project_0_is_up_to_date_with_d_ts_files_from_its_dependencies_6354", "Project '{0}' is up to date with .d.ts files from its dependencies"),
            Projects_in_this_build_Colon_0: diag(6355, ts.DiagnosticCategory.Message, "Projects_in_this_build_Colon_0_6355", "Projects in this build: {0}"),
            A_non_dry_build_would_delete_the_following_files_Colon_0: diag(6356, ts.DiagnosticCategory.Message, "A_non_dry_build_would_delete_the_following_files_Colon_0_6356", "A non-dry build would delete the following files: {0}"),
            A_non_dry_build_would_build_project_0: diag(6357, ts.DiagnosticCategory.Message, "A_non_dry_build_would_build_project_0_6357", "A non-dry build would build project '{0}'"),
            Building_project_0: diag(6358, ts.DiagnosticCategory.Message, "Building_project_0_6358", "Building project '{0}'..."),
            Updating_output_timestamps_of_project_0: diag(6359, ts.DiagnosticCategory.Message, "Updating_output_timestamps_of_project_0_6359", "Updating output timestamps of project '{0}'..."),
            delete_this_Project_0_is_up_to_date_because_it_was_previously_built: diag(6360, ts.DiagnosticCategory.Message, "delete_this_Project_0_is_up_to_date_because_it_was_previously_built_6360", "delete this - Project '{0}' is up to date because it was previously built"),
            Project_0_is_up_to_date: diag(6361, ts.DiagnosticCategory.Message, "Project_0_is_up_to_date_6361", "Project '{0}' is up to date"),
            Skipping_build_of_project_0_because_its_dependency_1_has_errors: diag(6362, ts.DiagnosticCategory.Message, "Skipping_build_of_project_0_because_its_dependency_1_has_errors_6362", "Skipping build of project '{0}' because its dependency '{1}' has errors"),
            Project_0_can_t_be_built_because_its_dependency_1_has_errors: diag(6363, ts.DiagnosticCategory.Message, "Project_0_can_t_be_built_because_its_dependency_1_has_errors_6363", "Project '{0}' can't be built because its dependency '{1}' has errors"),
            Build_one_or_more_projects_and_their_dependencies_if_out_of_date: diag(6364, ts.DiagnosticCategory.Message, "Build_one_or_more_projects_and_their_dependencies_if_out_of_date_6364", "Build one or more projects and their dependencies, if out of date"),
            Delete_the_outputs_of_all_projects: diag(6365, ts.DiagnosticCategory.Message, "Delete_the_outputs_of_all_projects_6365", "Delete the outputs of all projects"),
            Enable_verbose_logging: diag(6366, ts.DiagnosticCategory.Message, "Enable_verbose_logging_6366", "Enable verbose logging"),
            Show_what_would_be_built_or_deleted_if_specified_with_clean: diag(6367, ts.DiagnosticCategory.Message, "Show_what_would_be_built_or_deleted_if_specified_with_clean_6367", "Show what would be built (or deleted, if specified with '--clean')"),
            Build_all_projects_including_those_that_appear_to_be_up_to_date: diag(6368, ts.DiagnosticCategory.Message, "Build_all_projects_including_those_that_appear_to_be_up_to_date_6368", "Build all projects, including those that appear to be up to date"),
            Option_build_must_be_the_first_command_line_argument: diag(6369, ts.DiagnosticCategory.Error, "Option_build_must_be_the_first_command_line_argument_6369", "Option '--build' must be the first command line argument."),
            Options_0_and_1_cannot_be_combined: diag(6370, ts.DiagnosticCategory.Error, "Options_0_and_1_cannot_be_combined_6370", "Options '{0}' and '{1}' cannot be combined."),
            Updating_unchanged_output_timestamps_of_project_0: diag(6371, ts.DiagnosticCategory.Message, "Updating_unchanged_output_timestamps_of_project_0_6371", "Updating unchanged output timestamps of project '{0}'..."),
            Project_0_is_out_of_date_because_output_of_its_dependency_1_has_changed: diag(6372, ts.DiagnosticCategory.Message, "Project_0_is_out_of_date_because_output_of_its_dependency_1_has_changed_6372", "Project '{0}' is out of date because output of its dependency '{1}' has changed"),
            Updating_output_of_project_0: diag(6373, ts.DiagnosticCategory.Message, "Updating_output_of_project_0_6373", "Updating output of project '{0}'..."),
            A_non_dry_build_would_update_timestamps_for_output_of_project_0: diag(6374, ts.DiagnosticCategory.Message, "A_non_dry_build_would_update_timestamps_for_output_of_project_0_6374", "A non-dry build would update timestamps for output of project '{0}'"),
            A_non_dry_build_would_update_output_of_project_0: diag(6375, ts.DiagnosticCategory.Message, "A_non_dry_build_would_update_output_of_project_0_6375", "A non-dry build would update output of project '{0}'"),
            Cannot_update_output_of_project_0_because_there_was_error_reading_file_1: diag(6376, ts.DiagnosticCategory.Message, "Cannot_update_output_of_project_0_because_there_was_error_reading_file_1_6376", "Cannot update output of project '{0}' because there was error reading file '{1}'"),
            Cannot_write_file_0_because_it_will_overwrite_tsbuildinfo_file_generated_by_referenced_project_1: diag(6377, ts.DiagnosticCategory.Error, "Cannot_write_file_0_because_it_will_overwrite_tsbuildinfo_file_generated_by_referenced_project_1_6377", "Cannot write file '{0}' because it will overwrite '.tsbuildinfo' file generated by referenced project '{1}'"),
            Enable_incremental_compilation: diag(6378, ts.DiagnosticCategory.Message, "Enable_incremental_compilation_6378", "Enable incremental compilation"),
            Composite_projects_may_not_disable_incremental_compilation: diag(6379, ts.DiagnosticCategory.Error, "Composite_projects_may_not_disable_incremental_compilation_6379", "Composite projects may not disable incremental compilation."),
            Specify_file_to_store_incremental_compilation_information: diag(6380, ts.DiagnosticCategory.Message, "Specify_file_to_store_incremental_compilation_information_6380", "Specify file to store incremental compilation information"),
            Project_0_is_out_of_date_because_output_for_it_was_generated_with_version_1_that_differs_with_current_version_2: diag(6381, ts.DiagnosticCategory.Message, "Project_0_is_out_of_date_because_output_for_it_was_generated_with_version_1_that_differs_with_curren_6381", "Project '{0}' is out of date because output for it was generated with version '{1}' that differs with current version '{2}'"),
            Skipping_build_of_project_0_because_its_dependency_1_was_not_built: diag(6382, ts.DiagnosticCategory.Message, "Skipping_build_of_project_0_because_its_dependency_1_was_not_built_6382", "Skipping build of project '{0}' because its dependency '{1}' was not built"),
            Project_0_can_t_be_built_because_its_dependency_1_was_not_built: diag(6383, ts.DiagnosticCategory.Message, "Project_0_can_t_be_built_because_its_dependency_1_was_not_built_6383", "Project '{0}' can't be built because its dependency '{1}' was not built"),
            Have_recompiles_in_incremental_and_watch_assume_that_changes_within_a_file_will_only_affect_files_directly_depending_on_it: diag(6384, ts.DiagnosticCategory.Message, "Have_recompiles_in_incremental_and_watch_assume_that_changes_within_a_file_will_only_affect_files_di_6384", "Have recompiles in '--incremental' and '--watch' assume that changes within a file will only affect files directly depending on it."),
            The_expected_type_comes_from_property_0_which_is_declared_here_on_type_1: diag(6500, ts.DiagnosticCategory.Message, "The_expected_type_comes_from_property_0_which_is_declared_here_on_type_1_6500", "The expected type comes from property '{0}' which is declared here on type '{1}'"),
            The_expected_type_comes_from_this_index_signature: diag(6501, ts.DiagnosticCategory.Message, "The_expected_type_comes_from_this_index_signature_6501", "The expected type comes from this index signature."),
            The_expected_type_comes_from_the_return_type_of_this_signature: diag(6502, ts.DiagnosticCategory.Message, "The_expected_type_comes_from_the_return_type_of_this_signature_6502", "The expected type comes from the return type of this signature."),
            Print_names_of_files_that_are_part_of_the_compilation_and_then_stop_processing: diag(6503, ts.DiagnosticCategory.Message, "Print_names_of_files_that_are_part_of_the_compilation_and_then_stop_processing_6503", "Print names of files that are part of the compilation and then stop processing."),
            File_0_is_a_JavaScript_file_Did_you_mean_to_enable_the_allowJs_option: diag(6504, ts.DiagnosticCategory.Error, "File_0_is_a_JavaScript_file_Did_you_mean_to_enable_the_allowJs_option_6504", "File '{0}' is a JavaScript file. Did you mean to enable the 'allowJs' option?"),
            Variable_0_implicitly_has_an_1_type: diag(7005, ts.DiagnosticCategory.Error, "Variable_0_implicitly_has_an_1_type_7005", "Variable '{0}' implicitly has an '{1}' type."),
            Parameter_0_implicitly_has_an_1_type: diag(7006, ts.DiagnosticCategory.Error, "Parameter_0_implicitly_has_an_1_type_7006", "Parameter '{0}' implicitly has an '{1}' type."),
            Member_0_implicitly_has_an_1_type: diag(7008, ts.DiagnosticCategory.Error, "Member_0_implicitly_has_an_1_type_7008", "Member '{0}' implicitly has an '{1}' type."),
            new_expression_whose_target_lacks_a_construct_signature_implicitly_has_an_any_type: diag(7009, ts.DiagnosticCategory.Error, "new_expression_whose_target_lacks_a_construct_signature_implicitly_has_an_any_type_7009", "'new' expression, whose target lacks a construct signature, implicitly has an 'any' type."),
            _0_which_lacks_return_type_annotation_implicitly_has_an_1_return_type: diag(7010, ts.DiagnosticCategory.Error, "_0_which_lacks_return_type_annotation_implicitly_has_an_1_return_type_7010", "'{0}', which lacks return-type annotation, implicitly has an '{1}' return type."),
            Function_expression_which_lacks_return_type_annotation_implicitly_has_an_0_return_type: diag(7011, ts.DiagnosticCategory.Error, "Function_expression_which_lacks_return_type_annotation_implicitly_has_an_0_return_type_7011", "Function expression, which lacks return-type annotation, implicitly has an '{0}' return type."),
            Construct_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type: diag(7013, ts.DiagnosticCategory.Error, "Construct_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type_7013", "Construct signature, which lacks return-type annotation, implicitly has an 'any' return type."),
            Function_type_which_lacks_return_type_annotation_implicitly_has_an_0_return_type: diag(7014, ts.DiagnosticCategory.Error, "Function_type_which_lacks_return_type_annotation_implicitly_has_an_0_return_type_7014", "Function type, which lacks return-type annotation, implicitly has an '{0}' return type."),
            Element_implicitly_has_an_any_type_because_index_expression_is_not_of_type_number: diag(7015, ts.DiagnosticCategory.Error, "Element_implicitly_has_an_any_type_because_index_expression_is_not_of_type_number_7015", "Element implicitly has an 'any' type because index expression is not of type 'number'."),
            Could_not_find_a_declaration_file_for_module_0_1_implicitly_has_an_any_type: diag(7016, ts.DiagnosticCategory.Error, "Could_not_find_a_declaration_file_for_module_0_1_implicitly_has_an_any_type_7016", "Could not find a declaration file for module '{0}'. '{1}' implicitly has an 'any' type."),
            Element_implicitly_has_an_any_type_because_type_0_has_no_index_signature: diag(7017, ts.DiagnosticCategory.Error, "Element_implicitly_has_an_any_type_because_type_0_has_no_index_signature_7017", "Element implicitly has an 'any' type because type '{0}' has no index signature."),
            Object_literal_s_property_0_implicitly_has_an_1_type: diag(7018, ts.DiagnosticCategory.Error, "Object_literal_s_property_0_implicitly_has_an_1_type_7018", "Object literal's property '{0}' implicitly has an '{1}' type."),
            Rest_parameter_0_implicitly_has_an_any_type: diag(7019, ts.DiagnosticCategory.Error, "Rest_parameter_0_implicitly_has_an_any_type_7019", "Rest parameter '{0}' implicitly has an 'any[]' type."),
            Call_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type: diag(7020, ts.DiagnosticCategory.Error, "Call_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type_7020", "Call signature, which lacks return-type annotation, implicitly has an 'any' return type."),
            _0_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_and_is_referenced_directly_or_indirectly_in_its_own_initializer: diag(7022, ts.DiagnosticCategory.Error, "_0_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_and_is_referenced_directly_or__7022", "'{0}' implicitly has type 'any' because it does not have a type annotation and is referenced directly or indirectly in its own initializer."),
            _0_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_referenced_directly_or_indirectly_in_one_of_its_return_expressions: diag(7023, ts.DiagnosticCategory.Error, "_0_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_reference_7023", "'{0}' implicitly has return type 'any' because it does not have a return type annotation and is referenced directly or indirectly in one of its return expressions."),
            Function_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_referenced_directly_or_indirectly_in_one_of_its_return_expressions: diag(7024, ts.DiagnosticCategory.Error, "Function_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_ref_7024", "Function implicitly has return type 'any' because it does not have a return type annotation and is referenced directly or indirectly in one of its return expressions."),
            Generator_implicitly_has_yield_type_0_because_it_does_not_yield_any_values_Consider_supplying_a_return_type_annotation: diag(7025, ts.DiagnosticCategory.Error, "Generator_implicitly_has_yield_type_0_because_it_does_not_yield_any_values_Consider_supplying_a_retu_7025", "Generator implicitly has yield type '{0}' because it does not yield any values. Consider supplying a return type annotation."),
            JSX_element_implicitly_has_type_any_because_no_interface_JSX_0_exists: diag(7026, ts.DiagnosticCategory.Error, "JSX_element_implicitly_has_type_any_because_no_interface_JSX_0_exists_7026", "JSX element implicitly has type 'any' because no interface 'JSX.{0}' exists."),
            Unreachable_code_detected: diag(7027, ts.DiagnosticCategory.Error, "Unreachable_code_detected_7027", "Unreachable code detected.", /*reportsUnnecessary*/ true),
            Unused_label: diag(7028, ts.DiagnosticCategory.Error, "Unused_label_7028", "Unused label.", /*reportsUnnecessary*/ true),
            Fallthrough_case_in_switch: diag(7029, ts.DiagnosticCategory.Error, "Fallthrough_case_in_switch_7029", "Fallthrough case in switch."),
            Not_all_code_paths_return_a_value: diag(7030, ts.DiagnosticCategory.Error, "Not_all_code_paths_return_a_value_7030", "Not all code paths return a value."),
            Binding_element_0_implicitly_has_an_1_type: diag(7031, ts.DiagnosticCategory.Error, "Binding_element_0_implicitly_has_an_1_type_7031", "Binding element '{0}' implicitly has an '{1}' type."),
            Property_0_implicitly_has_type_any_because_its_set_accessor_lacks_a_parameter_type_annotation: diag(7032, ts.DiagnosticCategory.Error, "Property_0_implicitly_has_type_any_because_its_set_accessor_lacks_a_parameter_type_annotation_7032", "Property '{0}' implicitly has type 'any', because its set accessor lacks a parameter type annotation."),
            Property_0_implicitly_has_type_any_because_its_get_accessor_lacks_a_return_type_annotation: diag(7033, ts.DiagnosticCategory.Error, "Property_0_implicitly_has_type_any_because_its_get_accessor_lacks_a_return_type_annotation_7033", "Property '{0}' implicitly has type 'any', because its get accessor lacks a return type annotation."),
            Variable_0_implicitly_has_type_1_in_some_locations_where_its_type_cannot_be_determined: diag(7034, ts.DiagnosticCategory.Error, "Variable_0_implicitly_has_type_1_in_some_locations_where_its_type_cannot_be_determined_7034", "Variable '{0}' implicitly has type '{1}' in some locations where its type cannot be determined."),
            Try_npm_install_types_Slash_1_if_it_exists_or_add_a_new_declaration_d_ts_file_containing_declare_module_0: diag(7035, ts.DiagnosticCategory.Error, "Try_npm_install_types_Slash_1_if_it_exists_or_add_a_new_declaration_d_ts_file_containing_declare_mod_7035", "Try `npm install @types/{1}` if it exists or add a new declaration (.d.ts) file containing `declare module '{0}';`"),
            Dynamic_import_s_specifier_must_be_of_type_string_but_here_has_type_0: diag(7036, ts.DiagnosticCategory.Error, "Dynamic_import_s_specifier_must_be_of_type_string_but_here_has_type_0_7036", "Dynamic import's specifier must be of type 'string', but here has type '{0}'."),
            Enables_emit_interoperability_between_CommonJS_and_ES_Modules_via_creation_of_namespace_objects_for_all_imports_Implies_allowSyntheticDefaultImports: diag(7037, ts.DiagnosticCategory.Message, "Enables_emit_interoperability_between_CommonJS_and_ES_Modules_via_creation_of_namespace_objects_for__7037", "Enables emit interoperability between CommonJS and ES Modules via creation of namespace objects for all imports. Implies 'allowSyntheticDefaultImports'."),
            Type_originates_at_this_import_A_namespace_style_import_cannot_be_called_or_constructed_and_will_cause_a_failure_at_runtime_Consider_using_a_default_import_or_import_require_here_instead: diag(7038, ts.DiagnosticCategory.Message, "Type_originates_at_this_import_A_namespace_style_import_cannot_be_called_or_constructed_and_will_cau_7038", "Type originates at this import. A namespace-style import cannot be called or constructed, and will cause a failure at runtime. Consider using a default import or import require here instead."),
            Mapped_object_type_implicitly_has_an_any_template_type: diag(7039, ts.DiagnosticCategory.Error, "Mapped_object_type_implicitly_has_an_any_template_type_7039", "Mapped object type implicitly has an 'any' template type."),
            If_the_0_package_actually_exposes_this_module_consider_sending_a_pull_request_to_amend_https_Colon_Slash_Slashgithub_com_SlashDefinitelyTyped_SlashDefinitelyTyped_Slashtree_Slashmaster_Slashtypes_Slash_1: diag(7040, ts.DiagnosticCategory.Error, "If_the_0_package_actually_exposes_this_module_consider_sending_a_pull_request_to_amend_https_Colon_S_7040", "If the '{0}' package actually exposes this module, consider sending a pull request to amend 'https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/{1}`"),
            The_containing_arrow_function_captures_the_global_value_of_this: diag(7041, ts.DiagnosticCategory.Error, "The_containing_arrow_function_captures_the_global_value_of_this_7041", "The containing arrow function captures the global value of 'this'."),
            Module_0_was_resolved_to_1_but_resolveJsonModule_is_not_used: diag(7042, ts.DiagnosticCategory.Error, "Module_0_was_resolved_to_1_but_resolveJsonModule_is_not_used_7042", "Module '{0}' was resolved to '{1}', but '--resolveJsonModule' is not used."),
            Variable_0_implicitly_has_an_1_type_but_a_better_type_may_be_inferred_from_usage: diag(7043, ts.DiagnosticCategory.Suggestion, "Variable_0_implicitly_has_an_1_type_but_a_better_type_may_be_inferred_from_usage_7043", "Variable '{0}' implicitly has an '{1}' type, but a better type may be inferred from usage."),
            Parameter_0_implicitly_has_an_1_type_but_a_better_type_may_be_inferred_from_usage: diag(7044, ts.DiagnosticCategory.Suggestion, "Parameter_0_implicitly_has_an_1_type_but_a_better_type_may_be_inferred_from_usage_7044", "Parameter '{0}' implicitly has an '{1}' type, but a better type may be inferred from usage."),
            Member_0_implicitly_has_an_1_type_but_a_better_type_may_be_inferred_from_usage: diag(7045, ts.DiagnosticCategory.Suggestion, "Member_0_implicitly_has_an_1_type_but_a_better_type_may_be_inferred_from_usage_7045", "Member '{0}' implicitly has an '{1}' type, but a better type may be inferred from usage."),
            Variable_0_implicitly_has_type_1_in_some_locations_but_a_better_type_may_be_inferred_from_usage: diag(7046, ts.DiagnosticCategory.Suggestion, "Variable_0_implicitly_has_type_1_in_some_locations_but_a_better_type_may_be_inferred_from_usage_7046", "Variable '{0}' implicitly has type '{1}' in some locations, but a better type may be inferred from usage."),
            Rest_parameter_0_implicitly_has_an_any_type_but_a_better_type_may_be_inferred_from_usage: diag(7047, ts.DiagnosticCategory.Suggestion, "Rest_parameter_0_implicitly_has_an_any_type_but_a_better_type_may_be_inferred_from_usage_7047", "Rest parameter '{0}' implicitly has an 'any[]' type, but a better type may be inferred from usage."),
            Property_0_implicitly_has_type_any_but_a_better_type_for_its_get_accessor_may_be_inferred_from_usage: diag(7048, ts.DiagnosticCategory.Suggestion, "Property_0_implicitly_has_type_any_but_a_better_type_for_its_get_accessor_may_be_inferred_from_usage_7048", "Property '{0}' implicitly has type 'any', but a better type for its get accessor may be inferred from usage."),
            Property_0_implicitly_has_type_any_but_a_better_type_for_its_set_accessor_may_be_inferred_from_usage: diag(7049, ts.DiagnosticCategory.Suggestion, "Property_0_implicitly_has_type_any_but_a_better_type_for_its_set_accessor_may_be_inferred_from_usage_7049", "Property '{0}' implicitly has type 'any', but a better type for its set accessor may be inferred from usage."),
            _0_implicitly_has_an_1_return_type_but_a_better_type_may_be_inferred_from_usage: diag(7050, ts.DiagnosticCategory.Suggestion, "_0_implicitly_has_an_1_return_type_but_a_better_type_may_be_inferred_from_usage_7050", "'{0}' implicitly has an '{1}' return type, but a better type may be inferred from usage."),
            Parameter_has_a_name_but_no_type_Did_you_mean_0_Colon_1: diag(7051, ts.DiagnosticCategory.Error, "Parameter_has_a_name_but_no_type_Did_you_mean_0_Colon_1_7051", "Parameter has a name but no type. Did you mean '{0}: {1}'?"),
            Element_implicitly_has_an_any_type_because_type_0_has_no_index_signature_Did_you_mean_to_call_1: diag(7052, ts.DiagnosticCategory.Error, "Element_implicitly_has_an_any_type_because_type_0_has_no_index_signature_Did_you_mean_to_call_1_7052", "Element implicitly has an 'any' type because type '{0}' has no index signature. Did you mean to call '{1}'?"),
            Element_implicitly_has_an_any_type_because_expression_of_type_0_can_t_be_used_to_index_type_1: diag(7053, ts.DiagnosticCategory.Error, "Element_implicitly_has_an_any_type_because_expression_of_type_0_can_t_be_used_to_index_type_1_7053", "Element implicitly has an 'any' type because expression of type '{0}' can't be used to index type '{1}'."),
            No_index_signature_with_a_parameter_of_type_0_was_found_on_type_1: diag(7054, ts.DiagnosticCategory.Error, "No_index_signature_with_a_parameter_of_type_0_was_found_on_type_1_7054", "No index signature with a parameter of type '{0}' was found on type '{1}'."),
            _0_which_lacks_return_type_annotation_implicitly_has_an_1_yield_type: diag(7055, ts.DiagnosticCategory.Error, "_0_which_lacks_return_type_annotation_implicitly_has_an_1_yield_type_7055", "'{0}', which lacks return-type annotation, implicitly has an '{1}' yield type."),
            You_cannot_rename_this_element: diag(8000, ts.DiagnosticCategory.Error, "You_cannot_rename_this_element_8000", "You cannot rename this element."),
            You_cannot_rename_elements_that_are_defined_in_the_standard_TypeScript_library: diag(8001, ts.DiagnosticCategory.Error, "You_cannot_rename_elements_that_are_defined_in_the_standard_TypeScript_library_8001", "You cannot rename elements that are defined in the standard TypeScript library."),
            import_can_only_be_used_in_TypeScript_files: diag(8002, ts.DiagnosticCategory.Error, "import_can_only_be_used_in_TypeScript_files_8002", "'import ... =' can only be used in TypeScript files."),
            export_can_only_be_used_in_TypeScript_files: diag(8003, ts.DiagnosticCategory.Error, "export_can_only_be_used_in_TypeScript_files_8003", "'export =' can only be used in TypeScript files."),
            Type_parameter_declarations_can_only_be_used_in_TypeScript_files: diag(8004, ts.DiagnosticCategory.Error, "Type_parameter_declarations_can_only_be_used_in_TypeScript_files_8004", "Type parameter declarations can only be used in TypeScript files."),
            implements_clauses_can_only_be_used_in_TypeScript_files: diag(8005, ts.DiagnosticCategory.Error, "implements_clauses_can_only_be_used_in_TypeScript_files_8005", "'implements' clauses can only be used in TypeScript files."),
            _0_declarations_can_only_be_used_in_TypeScript_files: diag(8006, ts.DiagnosticCategory.Error, "_0_declarations_can_only_be_used_in_TypeScript_files_8006", "'{0}' declarations can only be used in TypeScript files."),
            Type_aliases_can_only_be_used_in_TypeScript_files: diag(8008, ts.DiagnosticCategory.Error, "Type_aliases_can_only_be_used_in_TypeScript_files_8008", "Type aliases can only be used in TypeScript files."),
            The_0_modifier_can_only_be_used_in_TypeScript_files: diag(8009, ts.DiagnosticCategory.Error, "The_0_modifier_can_only_be_used_in_TypeScript_files_8009", "The '{0}' modifier can only be used in TypeScript files."),
            Type_annotations_can_only_be_used_in_TypeScript_files: diag(8010, ts.DiagnosticCategory.Error, "Type_annotations_can_only_be_used_in_TypeScript_files_8010", "Type annotations can only be used in TypeScript files."),
            Type_arguments_can_only_be_used_in_TypeScript_files: diag(8011, ts.DiagnosticCategory.Error, "Type_arguments_can_only_be_used_in_TypeScript_files_8011", "Type arguments can only be used in TypeScript files."),
            Parameter_modifiers_can_only_be_used_in_TypeScript_files: diag(8012, ts.DiagnosticCategory.Error, "Parameter_modifiers_can_only_be_used_in_TypeScript_files_8012", "Parameter modifiers can only be used in TypeScript files."),
            Non_null_assertions_can_only_be_used_in_TypeScript_files: diag(8013, ts.DiagnosticCategory.Error, "Non_null_assertions_can_only_be_used_in_TypeScript_files_8013", "Non-null assertions can only be used in TypeScript files."),
            Type_assertion_expressions_can_only_be_used_in_TypeScript_files: diag(8016, ts.DiagnosticCategory.Error, "Type_assertion_expressions_can_only_be_used_in_TypeScript_files_8016", "Type assertion expressions can only be used in TypeScript files."),
            Octal_literal_types_must_use_ES2015_syntax_Use_the_syntax_0: diag(8017, ts.DiagnosticCategory.Error, "Octal_literal_types_must_use_ES2015_syntax_Use_the_syntax_0_8017", "Octal literal types must use ES2015 syntax. Use the syntax '{0}'."),
            Octal_literals_are_not_allowed_in_enums_members_initializer_Use_the_syntax_0: diag(8018, ts.DiagnosticCategory.Error, "Octal_literals_are_not_allowed_in_enums_members_initializer_Use_the_syntax_0_8018", "Octal literals are not allowed in enums members initializer. Use the syntax '{0}'."),
            Report_errors_in_js_files: diag(8019, ts.DiagnosticCategory.Message, "Report_errors_in_js_files_8019", "Report errors in .js files."),
            JSDoc_types_can_only_be_used_inside_documentation_comments: diag(8020, ts.DiagnosticCategory.Error, "JSDoc_types_can_only_be_used_inside_documentation_comments_8020", "JSDoc types can only be used inside documentation comments."),
            JSDoc_typedef_tag_should_either_have_a_type_annotation_or_be_followed_by_property_or_member_tags: diag(8021, ts.DiagnosticCategory.Error, "JSDoc_typedef_tag_should_either_have_a_type_annotation_or_be_followed_by_property_or_member_tags_8021", "JSDoc '@typedef' tag should either have a type annotation or be followed by '@property' or '@member' tags."),
            JSDoc_0_is_not_attached_to_a_class: diag(8022, ts.DiagnosticCategory.Error, "JSDoc_0_is_not_attached_to_a_class_8022", "JSDoc '@{0}' is not attached to a class."),
            JSDoc_0_1_does_not_match_the_extends_2_clause: diag(8023, ts.DiagnosticCategory.Error, "JSDoc_0_1_does_not_match_the_extends_2_clause_8023", "JSDoc '@{0} {1}' does not match the 'extends {2}' clause."),
            JSDoc_param_tag_has_name_0_but_there_is_no_parameter_with_that_name: diag(8024, ts.DiagnosticCategory.Error, "JSDoc_param_tag_has_name_0_but_there_is_no_parameter_with_that_name_8024", "JSDoc '@param' tag has name '{0}', but there is no parameter with that name."),
            Class_declarations_cannot_have_more_than_one_augments_or_extends_tag: diag(8025, ts.DiagnosticCategory.Error, "Class_declarations_cannot_have_more_than_one_augments_or_extends_tag_8025", "Class declarations cannot have more than one `@augments` or `@extends` tag."),
            Expected_0_type_arguments_provide_these_with_an_extends_tag: diag(8026, ts.DiagnosticCategory.Error, "Expected_0_type_arguments_provide_these_with_an_extends_tag_8026", "Expected {0} type arguments; provide these with an '@extends' tag."),
            Expected_0_1_type_arguments_provide_these_with_an_extends_tag: diag(8027, ts.DiagnosticCategory.Error, "Expected_0_1_type_arguments_provide_these_with_an_extends_tag_8027", "Expected {0}-{1} type arguments; provide these with an '@extends' tag."),
            JSDoc_may_only_appear_in_the_last_parameter_of_a_signature: diag(8028, ts.DiagnosticCategory.Error, "JSDoc_may_only_appear_in_the_last_parameter_of_a_signature_8028", "JSDoc '...' may only appear in the last parameter of a signature."),
            JSDoc_param_tag_has_name_0_but_there_is_no_parameter_with_that_name_It_would_match_arguments_if_it_had_an_array_type: diag(8029, ts.DiagnosticCategory.Error, "JSDoc_param_tag_has_name_0_but_there_is_no_parameter_with_that_name_It_would_match_arguments_if_it_h_8029", "JSDoc '@param' tag has name '{0}', but there is no parameter with that name. It would match 'arguments' if it had an array type."),
            The_type_of_a_function_declaration_must_match_the_function_s_signature: diag(8030, ts.DiagnosticCategory.Error, "The_type_of_a_function_declaration_must_match_the_function_s_signature_8030", "The type of a function declaration must match the function's signature."),
            You_cannot_rename_a_module_via_a_global_import: diag(8031, ts.DiagnosticCategory.Error, "You_cannot_rename_a_module_via_a_global_import_8031", "You cannot rename a module via a global import."),
            Qualified_name_0_is_not_allowed_without_a_leading_param_object_1: diag(8032, ts.DiagnosticCategory.Error, "Qualified_name_0_is_not_allowed_without_a_leading_param_object_1_8032", "Qualified name '{0}' is not allowed without a leading '@param {object} {1}'."),
            Only_identifiers_Slashqualified_names_with_optional_type_arguments_are_currently_supported_in_a_class_extends_clause: diag(9002, ts.DiagnosticCategory.Error, "Only_identifiers_Slashqualified_names_with_optional_type_arguments_are_currently_supported_in_a_clas_9002", "Only identifiers/qualified-names with optional type arguments are currently supported in a class 'extends' clause."),
            class_expressions_are_not_currently_supported: diag(9003, ts.DiagnosticCategory.Error, "class_expressions_are_not_currently_supported_9003", "'class' expressions are not currently supported."),
            Language_service_is_disabled: diag(9004, ts.DiagnosticCategory.Error, "Language_service_is_disabled_9004", "Language service is disabled."),
            Declaration_emit_for_this_file_requires_using_private_name_0_An_explicit_type_annotation_may_unblock_declaration_emit: diag(9005, ts.DiagnosticCategory.Error, "Declaration_emit_for_this_file_requires_using_private_name_0_An_explicit_type_annotation_may_unblock_9005", "Declaration emit for this file requires using private name '{0}'. An explicit type annotation may unblock declaration emit."),
            Declaration_emit_for_this_file_requires_using_private_name_0_from_module_1_An_explicit_type_annotation_may_unblock_declaration_emit: diag(9006, ts.DiagnosticCategory.Error, "Declaration_emit_for_this_file_requires_using_private_name_0_from_module_1_An_explicit_type_annotati_9006", "Declaration emit for this file requires using private name '{0}' from module '{1}'. An explicit type annotation may unblock declaration emit."),
            JSX_attributes_must_only_be_assigned_a_non_empty_expression: diag(17000, ts.DiagnosticCategory.Error, "JSX_attributes_must_only_be_assigned_a_non_empty_expression_17000", "JSX attributes must only be assigned a non-empty 'expression'."),
            JSX_elements_cannot_have_multiple_attributes_with_the_same_name: diag(17001, ts.DiagnosticCategory.Error, "JSX_elements_cannot_have_multiple_attributes_with_the_same_name_17001", "JSX elements cannot have multiple attributes with the same name."),
            Expected_corresponding_JSX_closing_tag_for_0: diag(17002, ts.DiagnosticCategory.Error, "Expected_corresponding_JSX_closing_tag_for_0_17002", "Expected corresponding JSX closing tag for '{0}'."),
            JSX_attribute_expected: diag(17003, ts.DiagnosticCategory.Error, "JSX_attribute_expected_17003", "JSX attribute expected."),
            Cannot_use_JSX_unless_the_jsx_flag_is_provided: diag(17004, ts.DiagnosticCategory.Error, "Cannot_use_JSX_unless_the_jsx_flag_is_provided_17004", "Cannot use JSX unless the '--jsx' flag is provided."),
            A_constructor_cannot_contain_a_super_call_when_its_class_extends_null: diag(17005, ts.DiagnosticCategory.Error, "A_constructor_cannot_contain_a_super_call_when_its_class_extends_null_17005", "A constructor cannot contain a 'super' call when its class extends 'null'."),
            An_unary_expression_with_the_0_operator_is_not_allowed_in_the_left_hand_side_of_an_exponentiation_expression_Consider_enclosing_the_expression_in_parentheses: diag(17006, ts.DiagnosticCategory.Error, "An_unary_expression_with_the_0_operator_is_not_allowed_in_the_left_hand_side_of_an_exponentiation_ex_17006", "An unary expression with the '{0}' operator is not allowed in the left-hand side of an exponentiation expression. Consider enclosing the expression in parentheses."),
            A_type_assertion_expression_is_not_allowed_in_the_left_hand_side_of_an_exponentiation_expression_Consider_enclosing_the_expression_in_parentheses: diag(17007, ts.DiagnosticCategory.Error, "A_type_assertion_expression_is_not_allowed_in_the_left_hand_side_of_an_exponentiation_expression_Con_17007", "A type assertion expression is not allowed in the left-hand side of an exponentiation expression. Consider enclosing the expression in parentheses."),
            JSX_element_0_has_no_corresponding_closing_tag: diag(17008, ts.DiagnosticCategory.Error, "JSX_element_0_has_no_corresponding_closing_tag_17008", "JSX element '{0}' has no corresponding closing tag."),
            super_must_be_called_before_accessing_this_in_the_constructor_of_a_derived_class: diag(17009, ts.DiagnosticCategory.Error, "super_must_be_called_before_accessing_this_in_the_constructor_of_a_derived_class_17009", "'super' must be called before accessing 'this' in the constructor of a derived class."),
            Unknown_type_acquisition_option_0: diag(17010, ts.DiagnosticCategory.Error, "Unknown_type_acquisition_option_0_17010", "Unknown type acquisition option '{0}'."),
            super_must_be_called_before_accessing_a_property_of_super_in_the_constructor_of_a_derived_class: diag(17011, ts.DiagnosticCategory.Error, "super_must_be_called_before_accessing_a_property_of_super_in_the_constructor_of_a_derived_class_17011", "'super' must be called before accessing a property of 'super' in the constructor of a derived class."),
            _0_is_not_a_valid_meta_property_for_keyword_1_Did_you_mean_2: diag(17012, ts.DiagnosticCategory.Error, "_0_is_not_a_valid_meta_property_for_keyword_1_Did_you_mean_2_17012", "'{0}' is not a valid meta-property for keyword '{1}'. Did you mean '{2}'?"),
            Meta_property_0_is_only_allowed_in_the_body_of_a_function_declaration_function_expression_or_constructor: diag(17013, ts.DiagnosticCategory.Error, "Meta_property_0_is_only_allowed_in_the_body_of_a_function_declaration_function_expression_or_constru_17013", "Meta-property '{0}' is only allowed in the body of a function declaration, function expression, or constructor."),
            JSX_fragment_has_no_corresponding_closing_tag: diag(17014, ts.DiagnosticCategory.Error, "JSX_fragment_has_no_corresponding_closing_tag_17014", "JSX fragment has no corresponding closing tag."),
            Expected_corresponding_closing_tag_for_JSX_fragment: diag(17015, ts.DiagnosticCategory.Error, "Expected_corresponding_closing_tag_for_JSX_fragment_17015", "Expected corresponding closing tag for JSX fragment."),
            JSX_fragment_is_not_supported_when_using_jsxFactory: diag(17016, ts.DiagnosticCategory.Error, "JSX_fragment_is_not_supported_when_using_jsxFactory_17016", "JSX fragment is not supported when using --jsxFactory"),
            JSX_fragment_is_not_supported_when_using_an_inline_JSX_factory_pragma: diag(17017, ts.DiagnosticCategory.Error, "JSX_fragment_is_not_supported_when_using_an_inline_JSX_factory_pragma_17017", "JSX fragment is not supported when using an inline JSX factory pragma"),
            Unknown_type_acquisition_option_0_Did_you_mean_1: diag(17018, ts.DiagnosticCategory.Error, "Unknown_type_acquisition_option_0_Did_you_mean_1_17018", "Unknown type acquisition option '{0}'. Did you mean '{1}'?"),
            Circularity_detected_while_resolving_configuration_Colon_0: diag(18000, ts.DiagnosticCategory.Error, "Circularity_detected_while_resolving_configuration_Colon_0_18000", "Circularity detected while resolving configuration: {0}"),
            A_path_in_an_extends_option_must_be_relative_or_rooted_but_0_is_not: diag(18001, ts.DiagnosticCategory.Error, "A_path_in_an_extends_option_must_be_relative_or_rooted_but_0_is_not_18001", "A path in an 'extends' option must be relative or rooted, but '{0}' is not."),
            The_files_list_in_config_file_0_is_empty: diag(18002, ts.DiagnosticCategory.Error, "The_files_list_in_config_file_0_is_empty_18002", "The 'files' list in config file '{0}' is empty."),
            No_inputs_were_found_in_config_file_0_Specified_include_paths_were_1_and_exclude_paths_were_2: diag(18003, ts.DiagnosticCategory.Error, "No_inputs_were_found_in_config_file_0_Specified_include_paths_were_1_and_exclude_paths_were_2_18003", "No inputs were found in config file '{0}'. Specified 'include' paths were '{1}' and 'exclude' paths were '{2}'."),
            File_is_a_CommonJS_module_it_may_be_converted_to_an_ES6_module: diag(80001, ts.DiagnosticCategory.Suggestion, "File_is_a_CommonJS_module_it_may_be_converted_to_an_ES6_module_80001", "File is a CommonJS module; it may be converted to an ES6 module."),
            This_constructor_function_may_be_converted_to_a_class_declaration: diag(80002, ts.DiagnosticCategory.Suggestion, "This_constructor_function_may_be_converted_to_a_class_declaration_80002", "This constructor function may be converted to a class declaration."),
            Import_may_be_converted_to_a_default_import: diag(80003, ts.DiagnosticCategory.Suggestion, "Import_may_be_converted_to_a_default_import_80003", "Import may be converted to a default import."),
            JSDoc_types_may_be_moved_to_TypeScript_types: diag(80004, ts.DiagnosticCategory.Suggestion, "JSDoc_types_may_be_moved_to_TypeScript_types_80004", "JSDoc types may be moved to TypeScript types."),
            require_call_may_be_converted_to_an_import: diag(80005, ts.DiagnosticCategory.Suggestion, "require_call_may_be_converted_to_an_import_80005", "'require' call may be converted to an import."),
            This_may_be_converted_to_an_async_function: diag(80006, ts.DiagnosticCategory.Suggestion, "This_may_be_converted_to_an_async_function_80006", "This may be converted to an async function."),
            await_has_no_effect_on_the_type_of_this_expression: diag(80007, ts.DiagnosticCategory.Suggestion, "await_has_no_effect_on_the_type_of_this_expression_80007", "'await' has no effect on the type of this expression."),
            Numeric_literals_with_absolute_values_equal_to_2_53_or_greater_are_too_large_to_be_represented_accurately_as_integers: diag(80008, ts.DiagnosticCategory.Suggestion, "Numeric_literals_with_absolute_values_equal_to_2_53_or_greater_are_too_large_to_be_represented_accur_80008", "Numeric literals with absolute values equal to 2^53 or greater are too large to be represented accurately as integers."),
            Add_missing_super_call: diag(90001, ts.DiagnosticCategory.Message, "Add_missing_super_call_90001", "Add missing 'super()' call"),
            Make_super_call_the_first_statement_in_the_constructor: diag(90002, ts.DiagnosticCategory.Message, "Make_super_call_the_first_statement_in_the_constructor_90002", "Make 'super()' call the first statement in the constructor"),
            Change_extends_to_implements: diag(90003, ts.DiagnosticCategory.Message, "Change_extends_to_implements_90003", "Change 'extends' to 'implements'"),
            Remove_unused_declaration_for_Colon_0: diag(90004, ts.DiagnosticCategory.Message, "Remove_unused_declaration_for_Colon_0_90004", "Remove unused declaration for: '{0}'"),
            Remove_import_from_0: diag(90005, ts.DiagnosticCategory.Message, "Remove_import_from_0_90005", "Remove import from '{0}'"),
            Implement_interface_0: diag(90006, ts.DiagnosticCategory.Message, "Implement_interface_0_90006", "Implement interface '{0}'"),
            Implement_inherited_abstract_class: diag(90007, ts.DiagnosticCategory.Message, "Implement_inherited_abstract_class_90007", "Implement inherited abstract class"),
            Add_0_to_unresolved_variable: diag(90008, ts.DiagnosticCategory.Message, "Add_0_to_unresolved_variable_90008", "Add '{0}.' to unresolved variable"),
            Remove_destructuring: diag(90009, ts.DiagnosticCategory.Message, "Remove_destructuring_90009", "Remove destructuring"),
            Remove_variable_statement: diag(90010, ts.DiagnosticCategory.Message, "Remove_variable_statement_90010", "Remove variable statement"),
            Remove_template_tag: diag(90011, ts.DiagnosticCategory.Message, "Remove_template_tag_90011", "Remove template tag"),
            Remove_type_parameters: diag(90012, ts.DiagnosticCategory.Message, "Remove_type_parameters_90012", "Remove type parameters"),
            Import_0_from_module_1: diag(90013, ts.DiagnosticCategory.Message, "Import_0_from_module_1_90013", "Import '{0}' from module \"{1}\""),
            Change_0_to_1: diag(90014, ts.DiagnosticCategory.Message, "Change_0_to_1_90014", "Change '{0}' to '{1}'"),
            Add_0_to_existing_import_declaration_from_1: diag(90015, ts.DiagnosticCategory.Message, "Add_0_to_existing_import_declaration_from_1_90015", "Add '{0}' to existing import declaration from \"{1}\""),
            Declare_property_0: diag(90016, ts.DiagnosticCategory.Message, "Declare_property_0_90016", "Declare property '{0}'"),
            Add_index_signature_for_property_0: diag(90017, ts.DiagnosticCategory.Message, "Add_index_signature_for_property_0_90017", "Add index signature for property '{0}'"),
            Disable_checking_for_this_file: diag(90018, ts.DiagnosticCategory.Message, "Disable_checking_for_this_file_90018", "Disable checking for this file"),
            Ignore_this_error_message: diag(90019, ts.DiagnosticCategory.Message, "Ignore_this_error_message_90019", "Ignore this error message"),
            Initialize_property_0_in_the_constructor: diag(90020, ts.DiagnosticCategory.Message, "Initialize_property_0_in_the_constructor_90020", "Initialize property '{0}' in the constructor"),
            Initialize_static_property_0: diag(90021, ts.DiagnosticCategory.Message, "Initialize_static_property_0_90021", "Initialize static property '{0}'"),
            Change_spelling_to_0: diag(90022, ts.DiagnosticCategory.Message, "Change_spelling_to_0_90022", "Change spelling to '{0}'"),
            Declare_method_0: diag(90023, ts.DiagnosticCategory.Message, "Declare_method_0_90023", "Declare method '{0}'"),
            Declare_static_method_0: diag(90024, ts.DiagnosticCategory.Message, "Declare_static_method_0_90024", "Declare static method '{0}'"),
            Prefix_0_with_an_underscore: diag(90025, ts.DiagnosticCategory.Message, "Prefix_0_with_an_underscore_90025", "Prefix '{0}' with an underscore"),
            Rewrite_as_the_indexed_access_type_0: diag(90026, ts.DiagnosticCategory.Message, "Rewrite_as_the_indexed_access_type_0_90026", "Rewrite as the indexed access type '{0}'"),
            Declare_static_property_0: diag(90027, ts.DiagnosticCategory.Message, "Declare_static_property_0_90027", "Declare static property '{0}'"),
            Call_decorator_expression: diag(90028, ts.DiagnosticCategory.Message, "Call_decorator_expression_90028", "Call decorator expression"),
            Add_async_modifier_to_containing_function: diag(90029, ts.DiagnosticCategory.Message, "Add_async_modifier_to_containing_function_90029", "Add async modifier to containing function"),
            Replace_infer_0_with_unknown: diag(90030, ts.DiagnosticCategory.Message, "Replace_infer_0_with_unknown_90030", "Replace 'infer {0}' with 'unknown'"),
            Replace_all_unused_infer_with_unknown: diag(90031, ts.DiagnosticCategory.Message, "Replace_all_unused_infer_with_unknown_90031", "Replace all unused 'infer' with 'unknown'"),
            Import_default_0_from_module_1: diag(90032, ts.DiagnosticCategory.Message, "Import_default_0_from_module_1_90032", "Import default '{0}' from module \"{1}\""),
            Add_default_import_0_to_existing_import_declaration_from_1: diag(90033, ts.DiagnosticCategory.Message, "Add_default_import_0_to_existing_import_declaration_from_1_90033", "Add default import '{0}' to existing import declaration from \"{1}\""),
            Add_parameter_name: diag(90034, ts.DiagnosticCategory.Message, "Add_parameter_name_90034", "Add parameter name"),
            Declare_a_private_field_named_0: diag(90053, ts.DiagnosticCategory.Message, "Declare_a_private_field_named_0_90053", "Declare a private field named '{0}'."),
            Convert_function_to_an_ES2015_class: diag(95001, ts.DiagnosticCategory.Message, "Convert_function_to_an_ES2015_class_95001", "Convert function to an ES2015 class"),
            Convert_function_0_to_class: diag(95002, ts.DiagnosticCategory.Message, "Convert_function_0_to_class_95002", "Convert function '{0}' to class"),
            Extract_to_0_in_1: diag(95004, ts.DiagnosticCategory.Message, "Extract_to_0_in_1_95004", "Extract to {0} in {1}"),
            Extract_function: diag(95005, ts.DiagnosticCategory.Message, "Extract_function_95005", "Extract function"),
            Extract_constant: diag(95006, ts.DiagnosticCategory.Message, "Extract_constant_95006", "Extract constant"),
            Extract_to_0_in_enclosing_scope: diag(95007, ts.DiagnosticCategory.Message, "Extract_to_0_in_enclosing_scope_95007", "Extract to {0} in enclosing scope"),
            Extract_to_0_in_1_scope: diag(95008, ts.DiagnosticCategory.Message, "Extract_to_0_in_1_scope_95008", "Extract to {0} in {1} scope"),
            Annotate_with_type_from_JSDoc: diag(95009, ts.DiagnosticCategory.Message, "Annotate_with_type_from_JSDoc_95009", "Annotate with type from JSDoc"),
            Annotate_with_types_from_JSDoc: diag(95010, ts.DiagnosticCategory.Message, "Annotate_with_types_from_JSDoc_95010", "Annotate with types from JSDoc"),
            Infer_type_of_0_from_usage: diag(95011, ts.DiagnosticCategory.Message, "Infer_type_of_0_from_usage_95011", "Infer type of '{0}' from usage"),
            Infer_parameter_types_from_usage: diag(95012, ts.DiagnosticCategory.Message, "Infer_parameter_types_from_usage_95012", "Infer parameter types from usage"),
            Convert_to_default_import: diag(95013, ts.DiagnosticCategory.Message, "Convert_to_default_import_95013", "Convert to default import"),
            Install_0: diag(95014, ts.DiagnosticCategory.Message, "Install_0_95014", "Install '{0}'"),
            Replace_import_with_0: diag(95015, ts.DiagnosticCategory.Message, "Replace_import_with_0_95015", "Replace import with '{0}'."),
            Use_synthetic_default_member: diag(95016, ts.DiagnosticCategory.Message, "Use_synthetic_default_member_95016", "Use synthetic 'default' member."),
            Convert_to_ES6_module: diag(95017, ts.DiagnosticCategory.Message, "Convert_to_ES6_module_95017", "Convert to ES6 module"),
            Add_undefined_type_to_property_0: diag(95018, ts.DiagnosticCategory.Message, "Add_undefined_type_to_property_0_95018", "Add 'undefined' type to property '{0}'"),
            Add_initializer_to_property_0: diag(95019, ts.DiagnosticCategory.Message, "Add_initializer_to_property_0_95019", "Add initializer to property '{0}'"),
            Add_definite_assignment_assertion_to_property_0: diag(95020, ts.DiagnosticCategory.Message, "Add_definite_assignment_assertion_to_property_0_95020", "Add definite assignment assertion to property '{0}'"),
            Add_all_missing_members: diag(95022, ts.DiagnosticCategory.Message, "Add_all_missing_members_95022", "Add all missing members"),
            Infer_all_types_from_usage: diag(95023, ts.DiagnosticCategory.Message, "Infer_all_types_from_usage_95023", "Infer all types from usage"),
            Delete_all_unused_declarations: diag(95024, ts.DiagnosticCategory.Message, "Delete_all_unused_declarations_95024", "Delete all unused declarations"),
            Prefix_all_unused_declarations_with_where_possible: diag(95025, ts.DiagnosticCategory.Message, "Prefix_all_unused_declarations_with_where_possible_95025", "Prefix all unused declarations with '_' where possible"),
            Fix_all_detected_spelling_errors: diag(95026, ts.DiagnosticCategory.Message, "Fix_all_detected_spelling_errors_95026", "Fix all detected spelling errors"),
            Add_initializers_to_all_uninitialized_properties: diag(95027, ts.DiagnosticCategory.Message, "Add_initializers_to_all_uninitialized_properties_95027", "Add initializers to all uninitialized properties"),
            Add_definite_assignment_assertions_to_all_uninitialized_properties: diag(95028, ts.DiagnosticCategory.Message, "Add_definite_assignment_assertions_to_all_uninitialized_properties_95028", "Add definite assignment assertions to all uninitialized properties"),
            Add_undefined_type_to_all_uninitialized_properties: diag(95029, ts.DiagnosticCategory.Message, "Add_undefined_type_to_all_uninitialized_properties_95029", "Add undefined type to all uninitialized properties"),
            Change_all_jsdoc_style_types_to_TypeScript: diag(95030, ts.DiagnosticCategory.Message, "Change_all_jsdoc_style_types_to_TypeScript_95030", "Change all jsdoc-style types to TypeScript"),
            Change_all_jsdoc_style_types_to_TypeScript_and_add_undefined_to_nullable_types: diag(95031, ts.DiagnosticCategory.Message, "Change_all_jsdoc_style_types_to_TypeScript_and_add_undefined_to_nullable_types_95031", "Change all jsdoc-style types to TypeScript (and add '| undefined' to nullable types)"),
            Implement_all_unimplemented_interfaces: diag(95032, ts.DiagnosticCategory.Message, "Implement_all_unimplemented_interfaces_95032", "Implement all unimplemented interfaces"),
            Install_all_missing_types_packages: diag(95033, ts.DiagnosticCategory.Message, "Install_all_missing_types_packages_95033", "Install all missing types packages"),
            Rewrite_all_as_indexed_access_types: diag(95034, ts.DiagnosticCategory.Message, "Rewrite_all_as_indexed_access_types_95034", "Rewrite all as indexed access types"),
            Convert_all_to_default_imports: diag(95035, ts.DiagnosticCategory.Message, "Convert_all_to_default_imports_95035", "Convert all to default imports"),
            Make_all_super_calls_the_first_statement_in_their_constructor: diag(95036, ts.DiagnosticCategory.Message, "Make_all_super_calls_the_first_statement_in_their_constructor_95036", "Make all 'super()' calls the first statement in their constructor"),
            Add_qualifier_to_all_unresolved_variables_matching_a_member_name: diag(95037, ts.DiagnosticCategory.Message, "Add_qualifier_to_all_unresolved_variables_matching_a_member_name_95037", "Add qualifier to all unresolved variables matching a member name"),
            Change_all_extended_interfaces_to_implements: diag(95038, ts.DiagnosticCategory.Message, "Change_all_extended_interfaces_to_implements_95038", "Change all extended interfaces to 'implements'"),
            Add_all_missing_super_calls: diag(95039, ts.DiagnosticCategory.Message, "Add_all_missing_super_calls_95039", "Add all missing super calls"),
            Implement_all_inherited_abstract_classes: diag(95040, ts.DiagnosticCategory.Message, "Implement_all_inherited_abstract_classes_95040", "Implement all inherited abstract classes"),
            Add_all_missing_async_modifiers: diag(95041, ts.DiagnosticCategory.Message, "Add_all_missing_async_modifiers_95041", "Add all missing 'async' modifiers"),
            Add_ts_ignore_to_all_error_messages: diag(95042, ts.DiagnosticCategory.Message, "Add_ts_ignore_to_all_error_messages_95042", "Add '@ts-ignore' to all error messages"),
            Annotate_everything_with_types_from_JSDoc: diag(95043, ts.DiagnosticCategory.Message, "Annotate_everything_with_types_from_JSDoc_95043", "Annotate everything with types from JSDoc"),
            Add_to_all_uncalled_decorators: diag(95044, ts.DiagnosticCategory.Message, "Add_to_all_uncalled_decorators_95044", "Add '()' to all uncalled decorators"),
            Convert_all_constructor_functions_to_classes: diag(95045, ts.DiagnosticCategory.Message, "Convert_all_constructor_functions_to_classes_95045", "Convert all constructor functions to classes"),
            Generate_get_and_set_accessors: diag(95046, ts.DiagnosticCategory.Message, "Generate_get_and_set_accessors_95046", "Generate 'get' and 'set' accessors"),
            Convert_require_to_import: diag(95047, ts.DiagnosticCategory.Message, "Convert_require_to_import_95047", "Convert 'require' to 'import'"),
            Convert_all_require_to_import: diag(95048, ts.DiagnosticCategory.Message, "Convert_all_require_to_import_95048", "Convert all 'require' to 'import'"),
            Move_to_a_new_file: diag(95049, ts.DiagnosticCategory.Message, "Move_to_a_new_file_95049", "Move to a new file"),
            Remove_unreachable_code: diag(95050, ts.DiagnosticCategory.Message, "Remove_unreachable_code_95050", "Remove unreachable code"),
            Remove_all_unreachable_code: diag(95051, ts.DiagnosticCategory.Message, "Remove_all_unreachable_code_95051", "Remove all unreachable code"),
            Add_missing_typeof: diag(95052, ts.DiagnosticCategory.Message, "Add_missing_typeof_95052", "Add missing 'typeof'"),
            Remove_unused_label: diag(95053, ts.DiagnosticCategory.Message, "Remove_unused_label_95053", "Remove unused label"),
            Remove_all_unused_labels: diag(95054, ts.DiagnosticCategory.Message, "Remove_all_unused_labels_95054", "Remove all unused labels"),
            Convert_0_to_mapped_object_type: diag(95055, ts.DiagnosticCategory.Message, "Convert_0_to_mapped_object_type_95055", "Convert '{0}' to mapped object type"),
            Convert_namespace_import_to_named_imports: diag(95056, ts.DiagnosticCategory.Message, "Convert_namespace_import_to_named_imports_95056", "Convert namespace import to named imports"),
            Convert_named_imports_to_namespace_import: diag(95057, ts.DiagnosticCategory.Message, "Convert_named_imports_to_namespace_import_95057", "Convert named imports to namespace import"),
            Add_or_remove_braces_in_an_arrow_function: diag(95058, ts.DiagnosticCategory.Message, "Add_or_remove_braces_in_an_arrow_function_95058", "Add or remove braces in an arrow function"),
            Add_braces_to_arrow_function: diag(95059, ts.DiagnosticCategory.Message, "Add_braces_to_arrow_function_95059", "Add braces to arrow function"),
            Remove_braces_from_arrow_function: diag(95060, ts.DiagnosticCategory.Message, "Remove_braces_from_arrow_function_95060", "Remove braces from arrow function"),
            Convert_default_export_to_named_export: diag(95061, ts.DiagnosticCategory.Message, "Convert_default_export_to_named_export_95061", "Convert default export to named export"),
            Convert_named_export_to_default_export: diag(95062, ts.DiagnosticCategory.Message, "Convert_named_export_to_default_export_95062", "Convert named export to default export"),
            Add_missing_enum_member_0: diag(95063, ts.DiagnosticCategory.Message, "Add_missing_enum_member_0_95063", "Add missing enum member '{0}'"),
            Add_all_missing_imports: diag(95064, ts.DiagnosticCategory.Message, "Add_all_missing_imports_95064", "Add all missing imports"),
            Convert_to_async_function: diag(95065, ts.DiagnosticCategory.Message, "Convert_to_async_function_95065", "Convert to async function"),
            Convert_all_to_async_functions: diag(95066, ts.DiagnosticCategory.Message, "Convert_all_to_async_functions_95066", "Convert all to async functions"),
            Add_unknown_conversion_for_non_overlapping_types: diag(95069, ts.DiagnosticCategory.Message, "Add_unknown_conversion_for_non_overlapping_types_95069", "Add 'unknown' conversion for non-overlapping types"),
            Add_unknown_to_all_conversions_of_non_overlapping_types: diag(95070, ts.DiagnosticCategory.Message, "Add_unknown_to_all_conversions_of_non_overlapping_types_95070", "Add 'unknown' to all conversions of non-overlapping types"),
            Add_missing_new_operator_to_call: diag(95071, ts.DiagnosticCategory.Message, "Add_missing_new_operator_to_call_95071", "Add missing 'new' operator to call"),
            Add_missing_new_operator_to_all_calls: diag(95072, ts.DiagnosticCategory.Message, "Add_missing_new_operator_to_all_calls_95072", "Add missing 'new' operator to all calls"),
            Add_names_to_all_parameters_without_names: diag(95073, ts.DiagnosticCategory.Message, "Add_names_to_all_parameters_without_names_95073", "Add names to all parameters without names"),
            Enable_the_experimentalDecorators_option_in_your_configuration_file: diag(95074, ts.DiagnosticCategory.Message, "Enable_the_experimentalDecorators_option_in_your_configuration_file_95074", "Enable the 'experimentalDecorators' option in your configuration file"),
            Convert_parameters_to_destructured_object: diag(95075, ts.DiagnosticCategory.Message, "Convert_parameters_to_destructured_object_95075", "Convert parameters to destructured object"),
            Allow_accessing_UMD_globals_from_modules: diag(95076, ts.DiagnosticCategory.Message, "Allow_accessing_UMD_globals_from_modules_95076", "Allow accessing UMD globals from modules."),
            Extract_type: diag(95077, ts.DiagnosticCategory.Message, "Extract_type_95077", "Extract type"),
            Extract_to_type_alias: diag(95078, ts.DiagnosticCategory.Message, "Extract_to_type_alias_95078", "Extract to type alias"),
            Extract_to_typedef: diag(95079, ts.DiagnosticCategory.Message, "Extract_to_typedef_95079", "Extract to typedef"),
            Infer_this_type_of_0_from_usage: diag(95080, ts.DiagnosticCategory.Message, "Infer_this_type_of_0_from_usage_95080", "Infer 'this' type of '{0}' from usage"),
            Add_const_to_unresolved_variable: diag(95081, ts.DiagnosticCategory.Message, "Add_const_to_unresolved_variable_95081", "Add 'const' to unresolved variable"),
            Add_const_to_all_unresolved_variables: diag(95082, ts.DiagnosticCategory.Message, "Add_const_to_all_unresolved_variables_95082", "Add 'const' to all unresolved variables"),
            Add_await: diag(95083, ts.DiagnosticCategory.Message, "Add_await_95083", "Add 'await'"),
            Add_await_to_initializer_for_0: diag(95084, ts.DiagnosticCategory.Message, "Add_await_to_initializer_for_0_95084", "Add 'await' to initializer for '{0}'"),
            Fix_all_expressions_possibly_missing_await: diag(95085, ts.DiagnosticCategory.Message, "Fix_all_expressions_possibly_missing_await_95085", "Fix all expressions possibly missing 'await'"),
            Remove_unnecessary_await: diag(95086, ts.DiagnosticCategory.Message, "Remove_unnecessary_await_95086", "Remove unnecessary 'await'"),
            Remove_all_unnecessary_uses_of_await: diag(95087, ts.DiagnosticCategory.Message, "Remove_all_unnecessary_uses_of_await_95087", "Remove all unnecessary uses of 'await'"),
            Enable_the_jsx_flag_in_your_configuration_file: diag(95088, ts.DiagnosticCategory.Message, "Enable_the_jsx_flag_in_your_configuration_file_95088", "Enable the '--jsx' flag in your configuration file"),
            Add_await_to_initializers: diag(95089, ts.DiagnosticCategory.Message, "Add_await_to_initializers_95089", "Add 'await' to initializers"),
            Extract_to_interface: diag(95090, ts.DiagnosticCategory.Message, "Extract_to_interface_95090", "Extract to interface"),
            Convert_to_a_bigint_numeric_literal: diag(95091, ts.DiagnosticCategory.Message, "Convert_to_a_bigint_numeric_literal_95091", "Convert to a bigint numeric literal"),
            Convert_all_to_bigint_numeric_literals: diag(95092, ts.DiagnosticCategory.Message, "Convert_all_to_bigint_numeric_literals_95092", "Convert all to bigint numeric literals"),
            Convert_const_to_let: diag(95093, ts.DiagnosticCategory.Message, "Convert_const_to_let_95093", "Convert 'const' to 'let'"),
            Prefix_with_declare: diag(95094, ts.DiagnosticCategory.Message, "Prefix_with_declare_95094", "Prefix with 'declare'"),
            Prefix_all_incorrect_property_declarations_with_declare: diag(95095, ts.DiagnosticCategory.Message, "Prefix_all_incorrect_property_declarations_with_declare_95095", "Prefix all incorrect property declarations with 'declare'"),
            Convert_to_template_string: diag(95096, ts.DiagnosticCategory.Message, "Convert_to_template_string_95096", "Convert to template string"),
            Add_export_to_make_this_file_into_a_module: diag(95097, ts.DiagnosticCategory.Message, "Add_export_to_make_this_file_into_a_module_95097", "Add 'export {}' to make this file into a module"),
            Set_the_target_option_in_your_configuration_file_to_0: diag(95098, ts.DiagnosticCategory.Message, "Set_the_target_option_in_your_configuration_file_to_0_95098", "Set the 'target' option in your configuration file to '{0}'"),
            Set_the_module_option_in_your_configuration_file_to_0: diag(95099, ts.DiagnosticCategory.Message, "Set_the_module_option_in_your_configuration_file_to_0_95099", "Set the 'module' option in your configuration file to '{0}'"),
            No_value_exists_in_scope_for_the_shorthand_property_0_Either_declare_one_or_provide_an_initializer: diag(18004, ts.DiagnosticCategory.Error, "No_value_exists_in_scope_for_the_shorthand_property_0_Either_declare_one_or_provide_an_initializer_18004", "No value exists in scope for the shorthand property '{0}'. Either declare one or provide an initializer."),
            Classes_may_not_have_a_field_named_constructor: diag(18006, ts.DiagnosticCategory.Error, "Classes_may_not_have_a_field_named_constructor_18006", "Classes may not have a field named 'constructor'."),
            JSX_expressions_may_not_use_the_comma_operator_Did_you_mean_to_write_an_array: diag(18007, ts.DiagnosticCategory.Error, "JSX_expressions_may_not_use_the_comma_operator_Did_you_mean_to_write_an_array_18007", "JSX expressions may not use the comma operator. Did you mean to write an array?"),
            Private_identifiers_cannot_be_used_as_parameters: diag(18009, ts.DiagnosticCategory.Error, "Private_identifiers_cannot_be_used_as_parameters_18009", "Private identifiers cannot be used as parameters"),
            An_accessibility_modifier_cannot_be_used_with_a_private_identifier: diag(18010, ts.DiagnosticCategory.Error, "An_accessibility_modifier_cannot_be_used_with_a_private_identifier_18010", "An accessibility modifier cannot be used with a private identifier."),
            The_operand_of_a_delete_operator_cannot_be_a_private_identifier: diag(18011, ts.DiagnosticCategory.Error, "The_operand_of_a_delete_operator_cannot_be_a_private_identifier_18011", "The operand of a 'delete' operator cannot be a private identifier."),
            constructor_is_a_reserved_word: diag(18012, ts.DiagnosticCategory.Error, "constructor_is_a_reserved_word_18012", "'#constructor' is a reserved word."),
            Property_0_is_not_accessible_outside_class_1_because_it_has_a_private_identifier: diag(18013, ts.DiagnosticCategory.Error, "Property_0_is_not_accessible_outside_class_1_because_it_has_a_private_identifier_18013", "Property '{0}' is not accessible outside class '{1}' because it has a private identifier."),
            The_property_0_cannot_be_accessed_on_type_1_within_this_class_because_it_is_shadowed_by_another_private_identifier_with_the_same_spelling: diag(18014, ts.DiagnosticCategory.Error, "The_property_0_cannot_be_accessed_on_type_1_within_this_class_because_it_is_shadowed_by_another_priv_18014", "The property '{0}' cannot be accessed on type '{1}' within this class because it is shadowed by another private identifier with the same spelling."),
            Property_0_in_type_1_refers_to_a_different_member_that_cannot_be_accessed_from_within_type_2: diag(18015, ts.DiagnosticCategory.Error, "Property_0_in_type_1_refers_to_a_different_member_that_cannot_be_accessed_from_within_type_2_18015", "Property '{0}' in type '{1}' refers to a different member that cannot be accessed from within type '{2}'."),
            Private_identifiers_are_not_allowed_outside_class_bodies: diag(18016, ts.DiagnosticCategory.Error, "Private_identifiers_are_not_allowed_outside_class_bodies_18016", "Private identifiers are not allowed outside class bodies."),
            The_shadowing_declaration_of_0_is_defined_here: diag(18017, ts.DiagnosticCategory.Error, "The_shadowing_declaration_of_0_is_defined_here_18017", "The shadowing declaration of '{0}' is defined here"),
            The_declaration_of_0_that_you_probably_intended_to_use_is_defined_here: diag(18018, ts.DiagnosticCategory.Error, "The_declaration_of_0_that_you_probably_intended_to_use_is_defined_here_18018", "The declaration of '{0}' that you probably intended to use is defined here"),
            _0_modifier_cannot_be_used_with_a_private_identifier: diag(18019, ts.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_with_a_private_identifier_18019", "'{0}' modifier cannot be used with a private identifier"),
            A_method_cannot_be_named_with_a_private_identifier: diag(18022, ts.DiagnosticCategory.Error, "A_method_cannot_be_named_with_a_private_identifier_18022", "A method cannot be named with a private identifier."),
            An_accessor_cannot_be_named_with_a_private_identifier: diag(18023, ts.DiagnosticCategory.Error, "An_accessor_cannot_be_named_with_a_private_identifier_18023", "An accessor cannot be named with a private identifier."),
            An_enum_member_cannot_be_named_with_a_private_identifier: diag(18024, ts.DiagnosticCategory.Error, "An_enum_member_cannot_be_named_with_a_private_identifier_18024", "An enum member cannot be named with a private identifier."),
            can_only_be_used_at_the_start_of_a_file: diag(18026, ts.DiagnosticCategory.Error, "can_only_be_used_at_the_start_of_a_file_18026", "'#!' can only be used at the start of a file."),
            Compiler_reserves_name_0_when_emitting_private_identifier_downlevel: diag(18027, ts.DiagnosticCategory.Error, "Compiler_reserves_name_0_when_emitting_private_identifier_downlevel_18027", "Compiler reserves name '{0}' when emitting private identifier downlevel."),
            Private_identifiers_are_only_available_when_targeting_ECMAScript_2015_and_higher: diag(18028, ts.DiagnosticCategory.Error, "Private_identifiers_are_only_available_when_targeting_ECMAScript_2015_and_higher_18028", "Private identifiers are only available when targeting ECMAScript 2015 and higher."),
            Private_identifiers_are_not_allowed_in_variable_declarations: diag(18029, ts.DiagnosticCategory.Error, "Private_identifiers_are_not_allowed_in_variable_declarations_18029", "Private identifiers are not allowed in variable declarations."),
            An_optional_chain_cannot_contain_private_identifiers: diag(18030, ts.DiagnosticCategory.Error, "An_optional_chain_cannot_contain_private_identifiers_18030", "An optional chain cannot contain private identifiers."),
        };
    })(ts || (ts = {}));
    var ts;
    (function (ts) {
        var _a;
        /* @internal */
        function tokenIsIdentifierOrKeyword(token) {
            return token >= 75 /* Identifier */;
        }
        ts.tokenIsIdentifierOrKeyword = tokenIsIdentifierOrKeyword;
        /* @internal */
        function tokenIsIdentifierOrKeywordOrGreaterThan(token) {
            return token === 31 /* GreaterThanToken */ || tokenIsIdentifierOrKeyword(token);
        }
        ts.tokenIsIdentifierOrKeywordOrGreaterThan = tokenIsIdentifierOrKeywordOrGreaterThan;
        var textToKeywordObj = (_a = {
            abstract: 122 /* AbstractKeyword */,
            any: 125 /* AnyKeyword */,
            as: 123 /* AsKeyword */,
            asserts: 124 /* AssertsKeyword */,
            bigint: 151 /* BigIntKeyword */,
            boolean: 128 /* BooleanKeyword */,
            break: 77 /* BreakKeyword */,
            case: 78 /* CaseKeyword */,
            catch: 79 /* CatchKeyword */,
            class: 80 /* ClassKeyword */,
            continue: 82 /* ContinueKeyword */,
            const: 81 /* ConstKeyword */
        },
            _a["" + "constructor"] = 129 /* ConstructorKeyword */,
            _a.debugger = 83 /* DebuggerKeyword */,
            _a.declare = 130 /* DeclareKeyword */,
            _a.default = 84 /* DefaultKeyword */,
            _a.delete = 85 /* DeleteKeyword */,
            _a.do = 86 /* DoKeyword */,
            _a.else = 87 /* ElseKeyword */,
            _a.enum = 88 /* EnumKeyword */,
            _a.export = 89 /* ExportKeyword */,
            _a.extends = 90 /* ExtendsKeyword */,
            _a.false = 91 /* FalseKeyword */,
            _a.finally = 92 /* FinallyKeyword */,
            _a.for = 93 /* ForKeyword */,
            _a.from = 149 /* FromKeyword */,
            _a.function = 94 /* FunctionKeyword */,
            _a.get = 131 /* GetKeyword */,
            _a.if = 95 /* IfKeyword */,
            _a.implements = 113 /* ImplementsKeyword */,
            _a.import = 96 /* ImportKeyword */,
            _a.in = 97 /* InKeyword */,
            _a.infer = 132 /* InferKeyword */,
            _a.instanceof = 98 /* InstanceOfKeyword */,
            _a.interface = 114 /* InterfaceKeyword */,
            _a.is = 133 /* IsKeyword */,
            _a.keyof = 134 /* KeyOfKeyword */,
            _a.let = 115 /* LetKeyword */,
            _a.module = 135 /* ModuleKeyword */,
            _a.namespace = 136 /* NamespaceKeyword */,
            _a.never = 137 /* NeverKeyword */,
            _a.new = 99 /* NewKeyword */,
            _a.null = 100 /* NullKeyword */,
            _a.number = 140 /* NumberKeyword */,
            _a.object = 141 /* ObjectKeyword */,
            _a.package = 116 /* PackageKeyword */,
            _a.private = 117 /* PrivateKeyword */,
            _a.protected = 118 /* ProtectedKeyword */,
            _a.public = 119 /* PublicKeyword */,
            _a.readonly = 138 /* ReadonlyKeyword */,
            _a.require = 139 /* RequireKeyword */,
            _a.global = 150 /* GlobalKeyword */,
            _a.return = 101 /* ReturnKeyword */,
            _a.set = 142 /* SetKeyword */,
            _a.static = 120 /* StaticKeyword */,
            _a.string = 143 /* StringKeyword */,
            _a.super = 102 /* SuperKeyword */,
            _a.switch = 103 /* SwitchKeyword */,
            _a.symbol = 144 /* SymbolKeyword */,
            _a.this = 104 /* ThisKeyword */,
            _a.throw = 105 /* ThrowKeyword */,
            _a.true = 106 /* TrueKeyword */,
            _a.try = 107 /* TryKeyword */,
            _a.type = 145 /* TypeKeyword */,
            _a.typeof = 108 /* TypeOfKeyword */,
            _a.undefined = 146 /* UndefinedKeyword */,
            _a.unique = 147 /* UniqueKeyword */,
            _a.unknown = 148 /* UnknownKeyword */,
            _a.var = 109 /* VarKeyword */,
            _a.void = 110 /* VoidKeyword */,
            _a.while = 111 /* WhileKeyword */,
            _a.with = 112 /* WithKeyword */,
            _a.yield = 121 /* YieldKeyword */,
            _a.async = 126 /* AsyncKeyword */,
            _a.await = 127 /* AwaitKeyword */,
            _a.of = 152 /* OfKeyword */,
            _a);
        var textToKeyword = ts.createMapFromTemplate(textToKeywordObj);
        var textToToken = ts.createMapFromTemplate(__assign(__assign({}, textToKeywordObj), { "{": 18 /* OpenBraceToken */, "}": 19 /* CloseBraceToken */, "(": 20 /* OpenParenToken */, ")": 21 /* CloseParenToken */, "[": 22 /* OpenBracketToken */, "]": 23 /* CloseBracketToken */, ".": 24 /* DotToken */, "...": 25 /* DotDotDotToken */, ";": 26 /* SemicolonToken */, ",": 27 /* CommaToken */, "<": 29 /* LessThanToken */, ">": 31 /* GreaterThanToken */, "<=": 32 /* LessThanEqualsToken */, ">=": 33 /* GreaterThanEqualsToken */, "==": 34 /* EqualsEqualsToken */, "!=": 35 /* ExclamationEqualsToken */, "===": 36 /* EqualsEqualsEqualsToken */, "!==": 37 /* ExclamationEqualsEqualsToken */, "=>": 38 /* EqualsGreaterThanToken */, "+": 39 /* PlusToken */, "-": 40 /* MinusToken */, "**": 42 /* AsteriskAsteriskToken */, "*": 41 /* AsteriskToken */, "/": 43 /* SlashToken */, "%": 44 /* PercentToken */, "++": 45 /* PlusPlusToken */, "--": 46 /* MinusMinusToken */, "<<": 47 /* LessThanLessThanToken */, "</": 30 /* LessThanSlashToken */, ">>": 48 /* GreaterThanGreaterThanToken */, ">>>": 49 /* GreaterThanGreaterThanGreaterThanToken */, "&": 50 /* AmpersandToken */, "|": 51 /* BarToken */, "^": 52 /* CaretToken */, "!": 53 /* ExclamationToken */, "~": 54 /* TildeToken */, "&&": 55 /* AmpersandAmpersandToken */, "||": 56 /* BarBarToken */, "?": 57 /* QuestionToken */, "??": 60 /* QuestionQuestionToken */, "?.": 28 /* QuestionDotToken */, ":": 58 /* ColonToken */, "=": 62 /* EqualsToken */, "+=": 63 /* PlusEqualsToken */, "-=": 64 /* MinusEqualsToken */, "*=": 65 /* AsteriskEqualsToken */, "**=": 66 /* AsteriskAsteriskEqualsToken */, "/=": 67 /* SlashEqualsToken */, "%=": 68 /* PercentEqualsToken */, "<<=": 69 /* LessThanLessThanEqualsToken */, ">>=": 70 /* GreaterThanGreaterThanEqualsToken */, ">>>=": 71 /* GreaterThanGreaterThanGreaterThanEqualsToken */, "&=": 72 /* AmpersandEqualsToken */, "|=": 73 /* BarEqualsToken */, "^=": 74 /* CaretEqualsToken */, "@": 59 /* AtToken */, "`": 61 /* BacktickToken */ }));
        /*
            As per ECMAScript Language Specification 3th Edition, Section 7.6: Identifiers
            IdentifierStart ::
                Can contain Unicode 3.0.0 categories:
                Uppercase letter (Lu),
                Lowercase letter (Ll),
                Titlecase letter (Lt),
                Modifier letter (Lm),
                Other letter (Lo), or
                Letter number (Nl).
            IdentifierPart :: =
                Can contain IdentifierStart + Unicode 3.0.0 categories:
                Non-spacing mark (Mn),
                Combining spacing mark (Mc),
                Decimal number (Nd), or
                Connector punctuation (Pc).
    
            Codepoint ranges for ES3 Identifiers are extracted from the Unicode 3.0.0 specification at:
            http://www.unicode.org/Public/3.0-Update/UnicodeData-3.0.0.txt
        */
        var unicodeES3IdentifierStart = [170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 543, 546, 563, 592, 685, 688, 696, 699, 705, 720, 721, 736, 740, 750, 750, 890, 890, 902, 902, 904, 906, 908, 908, 910, 929, 931, 974, 976, 983, 986, 1011, 1024, 1153, 1164, 1220, 1223, 1224, 1227, 1228, 1232, 1269, 1272, 1273, 1329, 1366, 1369, 1369, 1377, 1415, 1488, 1514, 1520, 1522, 1569, 1594, 1600, 1610, 1649, 1747, 1749, 1749, 1765, 1766, 1786, 1788, 1808, 1808, 1810, 1836, 1920, 1957, 2309, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2524, 2525, 2527, 2529, 2544, 2545, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2699, 2701, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2784, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2870, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 2997, 2999, 3001, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3123, 3125, 3129, 3168, 3169, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3294, 3294, 3296, 3297, 3333, 3340, 3342, 3344, 3346, 3368, 3370, 3385, 3424, 3425, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3648, 3654, 3713, 3714, 3716, 3716, 3719, 3720, 3722, 3722, 3725, 3725, 3732, 3735, 3737, 3743, 3745, 3747, 3749, 3749, 3751, 3751, 3754, 3755, 3757, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3805, 3840, 3840, 3904, 3911, 3913, 3946, 3976, 3979, 4096, 4129, 4131, 4135, 4137, 4138, 4176, 4181, 4256, 4293, 4304, 4342, 4352, 4441, 4447, 4514, 4520, 4601, 4608, 4614, 4616, 4678, 4680, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4742, 4744, 4744, 4746, 4749, 4752, 4782, 4784, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4814, 4816, 4822, 4824, 4846, 4848, 4878, 4880, 4880, 4882, 4885, 4888, 4894, 4896, 4934, 4936, 4954, 5024, 5108, 5121, 5740, 5743, 5750, 5761, 5786, 5792, 5866, 6016, 6067, 6176, 6263, 6272, 6312, 7680, 7835, 7840, 7929, 7936, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8319, 8319, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8497, 8499, 8505, 8544, 8579, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12346, 12353, 12436, 12445, 12446, 12449, 12538, 12540, 12542, 12549, 12588, 12593, 12686, 12704, 12727, 13312, 19893, 19968, 40869, 40960, 42124, 44032, 55203, 63744, 64045, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65136, 65138, 65140, 65140, 65142, 65276, 65313, 65338, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500,];
        var unicodeES3IdentifierPart = [170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 543, 546, 563, 592, 685, 688, 696, 699, 705, 720, 721, 736, 740, 750, 750, 768, 846, 864, 866, 890, 890, 902, 902, 904, 906, 908, 908, 910, 929, 931, 974, 976, 983, 986, 1011, 1024, 1153, 1155, 1158, 1164, 1220, 1223, 1224, 1227, 1228, 1232, 1269, 1272, 1273, 1329, 1366, 1369, 1369, 1377, 1415, 1425, 1441, 1443, 1465, 1467, 1469, 1471, 1471, 1473, 1474, 1476, 1476, 1488, 1514, 1520, 1522, 1569, 1594, 1600, 1621, 1632, 1641, 1648, 1747, 1749, 1756, 1759, 1768, 1770, 1773, 1776, 1788, 1808, 1836, 1840, 1866, 1920, 1968, 2305, 2307, 2309, 2361, 2364, 2381, 2384, 2388, 2392, 2403, 2406, 2415, 2433, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2492, 2494, 2500, 2503, 2504, 2507, 2509, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2545, 2562, 2562, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2649, 2652, 2654, 2654, 2662, 2676, 2689, 2691, 2693, 2699, 2701, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2784, 2790, 2799, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2870, 2873, 2876, 2883, 2887, 2888, 2891, 2893, 2902, 2903, 2908, 2909, 2911, 2913, 2918, 2927, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 2997, 2999, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3031, 3031, 3047, 3055, 3073, 3075, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3123, 3125, 3129, 3134, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3168, 3169, 3174, 3183, 3202, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3262, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3294, 3294, 3296, 3297, 3302, 3311, 3330, 3331, 3333, 3340, 3342, 3344, 3346, 3368, 3370, 3385, 3390, 3395, 3398, 3400, 3402, 3405, 3415, 3415, 3424, 3425, 3430, 3439, 3458, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3570, 3571, 3585, 3642, 3648, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3719, 3720, 3722, 3722, 3725, 3725, 3732, 3735, 3737, 3743, 3745, 3747, 3749, 3749, 3751, 3751, 3754, 3755, 3757, 3769, 3771, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3805, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3946, 3953, 3972, 3974, 3979, 3984, 3991, 3993, 4028, 4038, 4038, 4096, 4129, 4131, 4135, 4137, 4138, 4140, 4146, 4150, 4153, 4160, 4169, 4176, 4185, 4256, 4293, 4304, 4342, 4352, 4441, 4447, 4514, 4520, 4601, 4608, 4614, 4616, 4678, 4680, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4742, 4744, 4744, 4746, 4749, 4752, 4782, 4784, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4814, 4816, 4822, 4824, 4846, 4848, 4878, 4880, 4880, 4882, 4885, 4888, 4894, 4896, 4934, 4936, 4954, 4969, 4977, 5024, 5108, 5121, 5740, 5743, 5750, 5761, 5786, 5792, 5866, 6016, 6099, 6112, 6121, 6160, 6169, 6176, 6263, 6272, 6313, 7680, 7835, 7840, 7929, 7936, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8255, 8256, 8319, 8319, 8400, 8412, 8417, 8417, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8497, 8499, 8505, 8544, 8579, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12346, 12353, 12436, 12441, 12442, 12445, 12446, 12449, 12542, 12549, 12588, 12593, 12686, 12704, 12727, 13312, 19893, 19968, 40869, 40960, 42124, 44032, 55203, 63744, 64045, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65056, 65059, 65075, 65076, 65101, 65103, 65136, 65138, 65140, 65140, 65142, 65276, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65381, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500,];
        /*
            As per ECMAScript Language Specification 5th Edition, Section 7.6: ISyntaxToken Names and Identifiers
            IdentifierStart ::
                Can contain Unicode 6.2 categories:
                Uppercase letter (Lu),
                Lowercase letter (Ll),
                Titlecase letter (Lt),
                Modifier letter (Lm),
                Other letter (Lo), or
                Letter number (Nl).
            IdentifierPart ::
                Can contain IdentifierStart + Unicode 6.2 categories:
                Non-spacing mark (Mn),
                Combining spacing mark (Mc),
                Decimal number (Nd),
                Connector punctuation (Pc),
                <ZWNJ>, or
                <ZWJ>.
    
            Codepoint ranges for ES5 Identifiers are extracted from the Unicode 6.2 specification at:
            http://www.unicode.org/Public/6.2.0/ucd/UnicodeData.txt
        */
        var unicodeES5IdentifierStart = [170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 884, 886, 887, 890, 893, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1319, 1329, 1366, 1369, 1369, 1377, 1415, 1488, 1514, 1520, 1522, 1568, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2048, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2208, 2208, 2210, 2220, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2423, 2425, 2431, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2545, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3123, 3125, 3129, 3133, 3133, 3160, 3161, 3168, 3169, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3294, 3294, 3296, 3297, 3313, 3314, 3333, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3424, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3648, 3654, 3713, 3714, 3716, 3716, 3719, 3720, 3722, 3722, 3725, 3725, 3732, 3735, 3737, 3743, 3745, 3747, 3749, 3749, 3751, 3751, 3754, 3755, 3757, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5108, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5872, 5888, 5900, 5902, 5905, 5920, 5937, 5952, 5969, 5984, 5996, 5998, 6000, 6016, 6067, 6103, 6103, 6108, 6108, 6176, 6263, 6272, 6312, 6314, 6314, 6320, 6389, 6400, 6428, 6480, 6509, 6512, 6516, 6528, 6571, 6593, 6599, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6987, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7293, 7401, 7404, 7406, 7409, 7413, 7414, 7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8305, 8305, 8319, 8319, 8336, 8348, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11310, 11312, 11358, 11360, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11823, 11823, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12589, 12593, 12686, 12704, 12730, 12784, 12799, 13312, 19893, 19968, 40908, 40960, 42124, 42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539, 42560, 42606, 42623, 42647, 42656, 42735, 42775, 42783, 42786, 42888, 42891, 42894, 42896, 42899, 42912, 42922, 43000, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43638, 43642, 43642, 43648, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43741, 43744, 43754, 43762, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43968, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65136, 65140, 65142, 65276, 65313, 65338, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500,];
        var unicodeES5IdentifierPart = [170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 768, 884, 886, 887, 890, 893, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1155, 1159, 1162, 1319, 1329, 1366, 1369, 1369, 1377, 1415, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1488, 1514, 1520, 1522, 1552, 1562, 1568, 1641, 1646, 1747, 1749, 1756, 1759, 1768, 1770, 1788, 1791, 1791, 1808, 1866, 1869, 1969, 1984, 2037, 2042, 2042, 2048, 2093, 2112, 2139, 2208, 2208, 2210, 2220, 2276, 2302, 2304, 2403, 2406, 2415, 2417, 2423, 2425, 2431, 2433, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2500, 2503, 2504, 2507, 2510, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2545, 2561, 2563, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2649, 2652, 2654, 2654, 2662, 2677, 2689, 2691, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2787, 2790, 2799, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2876, 2884, 2887, 2888, 2891, 2893, 2902, 2903, 2908, 2909, 2911, 2915, 2918, 2927, 2929, 2929, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3024, 3024, 3031, 3031, 3046, 3055, 3073, 3075, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3123, 3125, 3129, 3133, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3160, 3161, 3168, 3171, 3174, 3183, 3202, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3260, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3294, 3294, 3296, 3299, 3302, 3311, 3313, 3314, 3330, 3331, 3333, 3340, 3342, 3344, 3346, 3386, 3389, 3396, 3398, 3400, 3402, 3406, 3415, 3415, 3424, 3427, 3430, 3439, 3450, 3455, 3458, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3570, 3571, 3585, 3642, 3648, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3719, 3720, 3722, 3722, 3725, 3725, 3732, 3735, 3737, 3743, 3745, 3747, 3749, 3749, 3751, 3751, 3754, 3755, 3757, 3769, 3771, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3807, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3948, 3953, 3972, 3974, 3991, 3993, 4028, 4038, 4038, 4096, 4169, 4176, 4253, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4957, 4959, 4992, 5007, 5024, 5108, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5872, 5888, 5900, 5902, 5908, 5920, 5940, 5952, 5971, 5984, 5996, 5998, 6000, 6002, 6003, 6016, 6099, 6103, 6103, 6108, 6109, 6112, 6121, 6155, 6157, 6160, 6169, 6176, 6263, 6272, 6314, 6320, 6389, 6400, 6428, 6432, 6443, 6448, 6459, 6470, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6608, 6617, 6656, 6683, 6688, 6750, 6752, 6780, 6783, 6793, 6800, 6809, 6823, 6823, 6912, 6987, 6992, 7001, 7019, 7027, 7040, 7155, 7168, 7223, 7232, 7241, 7245, 7293, 7376, 7378, 7380, 7414, 7424, 7654, 7676, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8204, 8205, 8255, 8256, 8276, 8276, 8305, 8305, 8319, 8319, 8336, 8348, 8400, 8412, 8417, 8417, 8421, 8432, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8