/*!
 * Copyright (c) 2012 - 2018, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
!function(t,e){var n;n=t.Bokeh,function(t,e,i){if(null!=n)return n.register_plugin(t,{"models/widgets/abstract_button":431,"models/widgets/abstract_icon":432,"models/widgets/abstract_slider":433,"models/widgets/autocomplete_input":434,"models/widgets/button":435,"models/widgets/button_group":436,"models/widgets/checkbox_button_group":437,"models/widgets/checkbox_group":438,"models/widgets/color_picker":439,"models/widgets/control":440,"models/widgets/date_picker":441,"models/widgets/date_range_slider":442,"models/widgets/date_slider":443,"models/widgets/div":444,"models/widgets/dropdown":445,"models/widgets/file_input":446,"models/widgets/index":447,"models/widgets/input_group":448,"models/widgets/input_widget":449,"models/widgets/main":450,"models/widgets/markup":451,"models/widgets/multiselect":452,"models/widgets/paragraph":453,"models/widgets/password_input":454,"models/widgets/pretext":455,"models/widgets/radio_button_group":456,"models/widgets/radio_group":457,"models/widgets/range_slider":458,"models/widgets/selectbox":459,"models/widgets/slider":460,"models/widgets/spinner":461,"models/widgets/text_input":462,"models/widgets/textarea_input":463,"models/widgets/toggle":464,"models/widgets/widget":482,"styles/clearfix":466,"styles/widgets/inputs":467,"styles/widgets/nouislider":468,"styles/widgets/pikaday":469,"styles/widgets/sliders":470},450);throw new Error("Cannot find Bokeh. You have to load it prior to loading plugins.")}({431:function(t,e,n){var i=t(421),o=t(18),r=t(5),a=t(4),s=t(440),l=t(304),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.icon_views={}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.render()})},e.prototype.remove=function(){a.remove_views(this.icon_views),t.prototype.remove.call(this)},e.prototype._render_button=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];return r.button.apply(void 0,[{type:"button",disabled:this.model.disabled,class:[l.bk_btn,l.bk_btn_type(this.model.button_type)]}].concat(t))},e.prototype.render=function(){var e=this;t.prototype.render.call(this),this.button_el=this._render_button(this.model.label),this.button_el.addEventListener("click",function(){return e.click()});var n=this.model.icon;if(null!=n){a.build_views(this.icon_views,[n],{parent:this});var i=this.icon_views[n.id];i.render(),r.prepend(this.button_el,i.el,r.nbsp())}this.group_el=r.div({class:l.bk_btn_group},this.button_el),this.el.appendChild(this.group_el)},e.prototype.click=function(){null!=this.model.callback&&this.model.callback.execute(this.model)},e.__name__="AbstractButtonView",e}(s.ControlView);n.AbstractButtonView=u;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({label:[o.String,"Button"],icon:[o.Instance],button_type:[o.ButtonType,"default"],callback:[o.Any]})},e.__name__="AbstractButton",e}(s.Control);n.AbstractButton=c,c.initClass()},432:function(t,e,n){var i=t(421),o=t(62),r=t(6),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="AbstractIconView",e}(r.DOMView);n.AbstractIconView=a;var s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.__name__="AbstractIcon",e}(o.Model);n.AbstractIcon=s},433:function(t,e,n){var i=t(421),o=t(471),r=t(18),a=t(5),s=t(24),l=t(28),u=t(440),c=t(470),d="bk-noUi-",p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"noUiSlider",{get:function(){return this.slider_el.noUiSlider},enumerable:!0,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._init_callback()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var n=this.model.properties,i=n.callback,o=n.callback_policy,r=n.callback_throttle;this.on_change([i,o,r],function(){return e._init_callback()});var a=this.model.properties,s=a.start,l=a.end,u=a.value,c=a.step,d=a.title;this.on_change([s,l,u,c],function(){var t=e._calc_to(),n=t.start,i=t.end,o=t.value,r=t.step;e.noUiSlider.updateOptions({range:{min:n,max:i},start:o,step:r})});var p=this.model.properties.bar_color;this.on_change(p,function(){e._set_bar_color()}),this.on_change([u,d],function(){return e._update_title()})},e.prototype._init_callback=function(){var t=this,e=this.model.callback,n=function(){null!=e&&e.execute(t.model),t.model.value_throttled=t.model.value};switch(this.model.callback_policy){case"continuous":this.callback_wrapper=n;break;case"throttle":this.callback_wrapper=l.throttle(n,this.model.callback_throttle);break;default:this.callback_wrapper=void 0}},e.prototype._update_title=function(){var t=this;a.empty(this.title_el);var e=null==this.model.title||0==this.model.title.length&&!this.model.show_value;if(this.title_el.style.display=e?"none":"",!e&&(0!=this.model.title.length&&(this.title_el.textContent=this.model.title+": "),this.model.show_value)){var n=this._calc_to().value,i=n.map(function(e){return t.model.pretty(e)}).join(" .. ");this.title_el.appendChild(a.span({class:c.bk_slider_value},i))}},e.prototype._set_bar_color=function(){this.model.disabled||(this.slider_el.querySelector(".bk-noUi-connect").style.backgroundColor=this.model.bar_color)},e.prototype._keypress_handle=function(t,e){void 0===e&&(e=0);var n=this._calc_to(),i=n.start,o=n.value,r=n.end,a=n.step,s=2==o.length,l=i,u=r;switch(s&&0==e?u=o[1]:s&&1==e&&(l=o[0]),t.which){case 37:o[e]=Math.max(o[e]-a,l);break;case 39:o[e]=Math.min(o[e]+a,u);break;default:return}s?(this.model.value=o,this.model.properties.value.change.emit()):this.model.value=o[0],this.noUiSlider.set(o),null!=this.callback_wrapper&&this.callback_wrapper()},e.prototype.render=function(){var e=this;t.prototype.render.call(this);var n,i=this._calc_to(),r=i.start,l=i.end,u=i.value,p=i.step;if(this.model.tooltips){var h={to:function(t){return e.model.pretty(t)}};n=s.repeat(h,u.length)}else n=!1;if(null==this.slider_el){this.slider_el=a.div(),o.create(this.slider_el,{cssPrefix:d,range:{min:r,max:l},start:u,step:p,behaviour:this.model.behaviour,connect:this.model.connected,tooltips:n,orientation:this.model.orientation,direction:this.model.direction}),this.noUiSlider.on("slide",function(t,n,i){return e._slide(i)}),this.noUiSlider.on("change",function(t,n,i){return e._change(i)}),this._set_keypress_handles();var f=function(t,i){if(n){var o=e.slider_el.querySelectorAll(".bk-noUi-handle")[t],r=o.querySelector(".bk-noUi-tooltip");r.style.display=i?"block":""}};this.noUiSlider.on("start",function(t,e){return f(e,!0)}),this.noUiSlider.on("end",function(t,e){return f(e,!1)})}else this.noUiSlider.updateOptions({range:{min:r,max:l},start:u,step:p});this._set_bar_color(),this.model.disabled?this.slider_el.setAttribute("disabled","true"):this.slider_el.removeAttribute("disabled"),this.title_el=a.div({class:c.bk_slider_title}),this._update_title(),this.group_el=a.div({class:c.bk_input_group},this.title_el,this.slider_el),this.el.appendChild(this.group_el)},e.prototype._slide=function(t){this.model.value=this._calc_from(t),null!=this.callback_wrapper&&this.callback_wrapper()},e.prototype._change=function(t){switch(this.model.value=this._calc_from(t),this.model.value_throttled=this.model.value,this.model.callback_policy){case"mouseup":case"throttle":null!=this.model.callback&&this.model.callback.execute(this.model)}},e.__name__="AbstractBaseSliderView",e}(u.ControlView),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._calc_to=function(){return{start:this.model.start,end:this.model.end,value:[this.model.value],step:this.model.step}},e.prototype._calc_from=function(t){var e=t[0];return Number.isInteger(this.model.start)&&Number.isInteger(this.model.end)&&Number.isInteger(this.model.step)?Math.round(e):e},e.prototype._set_keypress_handles=function(){var t=this,e=this.slider_el.querySelector(".bk-noUi-handle");e.setAttribute("tabindex","0"),e.addEventListener("keydown",function(e){return t._keypress_handle(e)})},e.__name__="AbstractSliderView",e}(p);n.AbstractSliderView=h;var f=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._calc_to=function(){return{start:this.model.start,end:this.model.end,value:this.model.value,step:this.model.step}},e.prototype._calc_from=function(t){return t},e.prototype._set_keypress_handles=function(){var t=this,e=this.slider_el.querySelector(".bk-noUi-handle-lower"),n=this.slider_el.querySelector(".bk-noUi-handle-upper");e.setAttribute("tabindex","0"),e.addEventListener("keydown",function(e){return t._keypress_handle(e,0)}),n.setAttribute("tabindex","1"),n.addEventListener("keydown",function(e){return t._keypress_handle(e,1)})},e.__name__="AbstractRangeSliderView",e}(p);n.AbstractRangeSliderView=f;var _=function(t){function e(e){var n=t.call(this,e)||this;return n.connected=!1,n}return i.__extends(e,t),e.initClass=function(){this.define({title:[r.String,""],show_value:[r.Boolean,!0],start:[r.Any],end:[r.Any],value:[r.Any],value_throttled:[r.Any],step:[r.Number,1],format:[r.String],direction:[r.Any,"ltr"],tooltips:[r.Boolean,!0],callback:[r.Any],callback_throttle:[r.Number,200],callback_policy:[r.SliderCallbackPolicy,"throttle"],bar_color:[r.Color,"#e6e6e6"]})},e.prototype._formatter=function(t,e){return""+t},e.prototype.pretty=function(t){return this._formatter(t,this.format)},e.__name__="AbstractSlider",e}(u.Control);n.AbstractSlider=_,_.initClass()},434:function(t,e,n){var i=t(421),o=t(462),r=t(5),a=t(18),s=t(34),l=t(309),u=t(308),c=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e._open=!1,e._last_value="",e._hover_index=0,e}return i.__extends(e,t),e.prototype.render=function(){var e=this;t.prototype.render.call(this),this.input_el.addEventListener("keydown",function(t){return e._keydown(t)}),this.input_el.addEventListener("keyup",function(t){return e._keyup(t)}),this.menu=r.div({class:[u.bk_menu,l.bk_below]}),this.menu.addEventListener("click",function(t){return e._menu_click(t)}),this.menu.addEventListener("mouseover",function(t){return e._menu_hover(t)}),this.el.appendChild(this.menu),r.undisplay(this.menu)},e.prototype.change_input=function(){this._open&&this.menu.children.length>0&&(this.model.value=this.menu.children[this._hover_index].textContent,this.input_el.focus(),this._hide_menu())},e.prototype._update_completions=function(t){r.empty(this.menu);for(var e=0,n=t;e<n.length;e++){var i=n[e],o=r.div({},i);this.menu.appendChild(o)}t.length>0&&this.menu.children[0].classList.add(l.bk_active)},e.prototype._show_menu=function(){var t=this;if(!this._open){this._open=!0,this._hover_index=0,this._last_value=this.model.value,r.display(this.menu);var e=function(n){var i=n.target;i instanceof HTMLElement&&!t.el.contains(i)&&(document.removeEventListener("click",e),t._hide_menu())};document.addEventListener("click",e)}},e.prototype._hide_menu=function(){this._open&&(this._open=!1,r.undisplay(this.menu))},e.prototype._menu_click=function(t){t.target!=t.currentTarget&&t.target instanceof Element&&(this.model.value=t.target.textContent,this.input_el.focus(),this._hide_menu())},e.prototype._menu_hover=function(t){if(t.target!=t.currentTarget&&t.target instanceof Element){var e=0;for(e=0;e<this.menu.children.length&&this.menu.children[e].textContent!=t.target.textContent;e++);this._bump_hover(e)}},e.prototype._bump_hover=function(t){var e=this.menu.children.length;this._open&&e>0&&(this.menu.children[this._hover_index].classList.remove(l.bk_active),this._hover_index=s.clamp(t,0,e-1),this.menu.children[this._hover_index].classList.add(l.bk_active))},e.prototype._keydown=function(t){},e.prototype._keyup=function(t){switch(t.keyCode){case r.Keys.Enter:this.change_input();break;case r.Keys.Esc:this._hide_menu();break;case r.Keys.Up:this._bump_hover(this._hover_index-1);break;case r.Keys.Down:this._bump_hover(this._hover_index+1);break;default:var e=this.input_el.value;if(e.length<=1)return void this._hide_menu();for(var n=[],i=0,o=this.model.completions;i<o.length;i++){var a=o[i];-1!=a.indexOf(e)&&n.push(a)}this._update_completions(n),0==n.length?this._hide_menu():this._show_menu()}},e.__name__="AutocompleteInputView",e}(o.TextInputView);n.AutocompleteInputView=c;var d=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c,this.define({completions:[a.Array,[]]})},e.__name__="AutocompleteInput",e}(o.TextInput);n.AutocompleteInput=d,d.initClass()},435:function(t,e,n){var i=t(421),o=t(431),r=t(3),a=t(18),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.click=function(){this.model.clicks=this.model.clicks+1,this.model.trigger_event(new r.ButtonClick),t.prototype.click.call(this)},e.__name__="ButtonView",e}(o.AbstractButtonView);n.ButtonView=s;var l=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=s,this.define({clicks:[a.Number,0]}),this.override({label:"Button"})},e.__name__="Button",e}(o.AbstractButton);n.Button=l,l.initClass()},436:function(t,e,n){var i=t(421),o=t(440),r=t(5),a=t(18),s=t(304),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var n=this.model.properties;this.on_change(n.button_type,function(){return e.render()}),this.on_change(n.labels,function(){return e.render()}),this.on_change(n.active,function(){return e._update_active()})},e.prototype.render=function(){var e=this;t.prototype.render.call(this),this._buttons=this.model.labels.map(function(t,n){var i=r.div({class:[s.bk_btn,s.bk_btn_type(e.model.button_type)],disabled:e.model.disabled},t);return i.addEventListener("click",function(){return e.change_active(n)}),i}),this._update_active();var n=r.div({class:s.bk_btn_group},this._buttons);this.el.appendChild(n)},e.__name__="ButtonGroupView",e}(o.ControlView);n.ButtonGroupView=l;var u=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({labels:[a.Array,[]],button_type:[a.ButtonType,"default"],callback:[a.Any]})},e.__name__="ButtonGroup",e}(o.Control);n.ButtonGroup=u,u.initClass()},437:function(t,e,n){var i=t(421),o=t(436),r=t(5),a=t(32),s=t(18),l=t(309),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),Object.defineProperty(e.prototype,"active",{get:function(){return new a.Set(this.model.active)},enumerable:!0,configurable:!0}),e.prototype.change_active=function(t){var e=this.active;e.toggle(t),this.model.active=e.values,null!=this.model.callback&&this.model.callback.execute(this.model)},e.prototype._update_active=function(){var t=this.active;this._buttons.forEach(function(e,n){r.classes(e).toggle(l.bk_active,t.has(n))})},e.__name__="CheckboxButtonGroupView",e}(o.ButtonGroupView);n.CheckboxButtonGroupView=u;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=u,this.define({active:[s.Array,[]]})},e.__name__="CheckboxButtonGroup",e}(o.ButtonGroup);n.CheckboxButtonGroup=c,c.initClass()},438:function(t,e,n){var i=t(421),o=t(448),r=t(5),a=t(24),s=t(32),l=t(18),u=t(309),c=t(467),d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.render=function(){var e=this;t.prototype.render.call(this);var n=r.div({class:[c.bk_input_group,this.model.inline?u.bk_inline:null]});this.el.appendChild(n);for(var i=this.model,o=i.active,s=i.labels,l=function(t){var i=r.input({type:"checkbox",value:""+t});i.addEventListener("change",function(){return e.change_active(t)}),d.model.disabled&&(i.disabled=!0),a.includes(o,t)&&(i.checked=!0);var l=r.label({},i,r.span({},s[t]));n.appendChild(l)},d=this,p=0;p<s.length;p++)l(p)},e.prototype.change_active=function(t){var e=new s.Set(this.model.active);e.toggle(t),this.model.active=e.values,null!=this.model.callback&&this.model.callback.execute(this.model)},e.__name__="CheckboxGroupView",e}(o.InputGroupView);n.CheckboxGroupView=d;var p=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=d,this.define({active:[l.Array,[]],labels:[l.Array,[]],inline:[l.Boolean,!1],callback:[l.Any]})},e.__name__="CheckboxGroup",e}(o.InputGroup);n.CheckboxGroup=p,p.initClass()},439:function(t,e,n){var i=t(421),o=t(449),r=t(5),a=t(18),s=t(467),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.name.change,function(){return e.input_el.name=e.model.name||""}),this.connect(this.model.properties.color.change,function(){return e.input_el.value=e.model.color}),this.connect(this.model.properties.disabled.change,function(){return e.input_el.disabled=e.model.disabled})},e.prototype.render=function(){var e=this;t.prototype.render.call(this),this.input_el=r.input({type:"color",class:s.bk_input,name:this.model.name,value:this.model.color,disabled:this.model.disabled}),this.input_el.addEventListener("change",function(){return e.change_input()}),this.group_el.appendChild(this.input_el)},e.prototype.change_input=function(){this.model.color=this.input_el.value,t.prototype.change_input.call(this)},e.__name__="ColorPickerView",e}(o.InputWidgetView);n.ColorPickerView=l;var u=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.define({color:[a.Color,"#000000"]})},e.__name__="ColorPicker",e}(o.InputWidget);n.ColorPicker=u,u.initClass()},440:function(t,e,n){var i=t(421),o=t(482),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var n=this.model.properties;this.on_change(n.disabled,function(){return e.render()})},e.__name__="ControlView",e}(o.WidgetView);n.ControlView=r;var a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.__name__="Control",e}(o.Widget);n.Control=a},441:function(t,e,n){var i=t(421),o=t(449),r=t(5),a=t(18),s=t(472),l=t(467);t(469),s.prototype.adjustPosition=function(){if(!this._o.container){this.el.style.position="absolute";var t=this._o.trigger,e=this.el.offsetWidth,n=this.el.offsetHeight,i=window.innerWidth||document.documentElement.clientWidth,o=window.innerHeight||document.documentElement.clientHeight,r=window.pageYOffset||document.body.scrollTop||document.documentElement.scrollTop,a=t.getBoundingClientRect(),s=a.left+window.pageXOffset,l=a.bottom+window.pageYOffset;s-=this.el.parentElement.offsetLeft,l-=this.el.parentElement.offsetTop,(this._o.reposition&&s+e>i||this._o.position.indexOf("right")>-1&&s-e+t.offsetWidth>0)&&(s=s-e+t.offsetWidth),(this._o.reposition&&l+n>o+r||this._o.position.indexOf("top")>-1&&l-n-t.offsetHeight>0)&&(l=l-n-t.offsetHeight),this.el.style.left=s+"px",this.el.style.top=l+"px"}};var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.render()})},e.prototype.render=function(){var e=this;null!=this._picker&&this._picker.destroy(),t.prototype.render.call(this),this.input_el=r.input({type:"text",class:l.bk_input,disabled:this.model.disabled}),this.group_el.appendChild(this.input_el),this._picker=new s({field:this.input_el,defaultDate:this._unlocal_date(new Date(this.model.value)),setDefaultDate:!0,minDate:null!=this.model.min_date?this._unlocal_date(new Date(this.model.min_date)):void 0,maxDate:null!=this.model.max_date?this._unlocal_date(new Date(this.model.max_date)):void 0,onSelect:function(t){return e._on_select(t)}}),this._root_element.appendChild(this._picker.el)},e.prototype._unlocal_date=function(t){var e=t.toISOString().substr(0,10),n=e.split("-");return new Date(Number(n[0]),Number(n[1])-1,Number(n[2]))},e.prototype._on_select=function(t){this.model.value=t.toDateString(),this.change_input()},e.__name__="DatePickerView",e}(o.InputWidgetView);n.DatePickerView=u;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=u,this.define({value:[a.Any,(new Date).toDateString()],min_date:[a.Any],max_date:[a.Any]})},e.__name__="DatePicker",e}(o.InputWidget);n.DatePicker=c,c.initClass()},442:function(t,e,n){var i=t(421),o=t(420),r=t(433),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="DateRangeSliderView",e}(r.AbstractRangeSliderView);n.DateRangeSliderView=a;var s=function(t){function e(e){var n=t.call(this,e)||this;return n.behaviour="drag",n.connected=[!1,!0,!1],n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.override({format:"%d %b %Y"})},e.prototype._formatter=function(t,e){return o(t,e)},e.__name__="DateRangeSlider",e}(r.AbstractSlider);n.DateRangeSlider=s,s.initClass()},443:function(t,e,n){var i=t(421),o=t(420),r=t(433),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="DateSliderView",e}(r.AbstractSliderView);n.DateSliderView=a;var s=function(t){function e(e){var n=t.call(this,e)||this;return n.behaviour="tap",n.connected=[!0,!1],n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.override({format:"%d %b %Y"})},e.prototype._formatter=function(t,e){return o(t,e)},e.__name__="DateSlider",e}(r.AbstractSlider);n.DateSlider=s,s.initClass()},444:function(t,e,n){var i=t(421),o=t(451),r=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.render=function(){t.prototype.render.call(this),this.model.render_as_text?this.markup_el.textContent=this.model.text:this.markup_el.innerHTML=this.model.text},e.__name__="DivView",e}(o.MarkupView);n.DivView=a;var s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.define({render_as_text:[r.Boolean,!1]})},e.__name__="Div",e}(o.Markup);n.Div=s,s.initClass()},445:function(t,e,n){var i=t(421),o=t(431),r=t(3),a=t(5),s=t(18),l=t(46),u=t(309),c=t(304),d=t(308),p=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e._open=!1,e}return i.__extends(e,t),e.prototype.render=function(){var e=this;t.prototype.render.call(this);var n=a.div({class:[d.bk_caret,u.bk_down]});if(this.model.is_split){var i=this._render_button(n);i.classList.add(c.bk_dropdown_toggle),i.addEventListener("click",function(){return e._toggle_menu()}),this.group_el.appendChild(i)}else this.button_el.appendChild(n);var o=this.model.menu.map(function(t,n){if(null==t)return a.div({class:d.bk_divider});var i=l.isString(t)?t:t[0],o=a.div({},i);return o.addEventListener("click",function(){return e._item_click(n)}),o});this.menu=a.div({class:[d.bk_menu,u.bk_below]},o),this.el.appendChild(this.menu),a.undisplay(this.menu)},e.prototype._show_menu=function(){var t=this;if(!this._open){this._open=!0,a.display(this.menu);var e=function(n){var i=n.target;i instanceof HTMLElement&&!t.el.contains(i)&&(document.removeEventListener("click",e),t._hide_menu())};document.addEventListener("click",e)}},e.prototype._hide_menu=function(){this._open&&(this._open=!1,a.undisplay(this.menu))},e.prototype._toggle_menu=function(){this._open?this._hide_menu():this._show_menu()},e.prototype.click=function(){this.model.is_split?(this._hide_menu(),this.model.trigger_event(new r.ButtonClick),this.model.value=this.model.default_value,null!=this.model.callback&&this.model.callback.execute(this.model),t.prototype.click.call(this)):this._toggle_menu()},e.prototype._item_click=function(t){this._hide_menu();var e=this.model.menu[t];if(null!=e){var n=l.isString(e)?e:e[1];l.isString(n)?(this.model.trigger_event(new r.MenuItemClick(n)),this.model.value=n,null!=this.model.callback&&this.model.callback.execute(this.model)):(n.execute(this.model,{index:t}),null!=this.model.callback&&this.model.callback.execute(this.model))}},e.__name__="DropdownView",e}(o.AbstractButtonView);n.DropdownView=p;var h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=p,this.define({split:[s.Boolean,!1],menu:[s.Array,[]],value:[s.String],default_value:[s.String]}),this.override({label:"Dropdown"})},Object.defineProperty(e.prototype,"is_split",{get:function(){return this.split||null!=this.default_value},enumerable:!0,configurable:!0}),e.__name__="Dropdown",e}(o.AbstractButton);n.Dropdown=h,h.initClass()},446:function(t,e,n){var i=t(421),o=t(18),r=t(482),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.render()}),this.connect(this.model.properties.width.change,function(){return e.render()})},e.prototype.render=function(){var t=this;this.dialogEl||(this.dialogEl=document.createElement("input"),this.dialogEl.type="file",this.dialogEl.multiple=!1,null!=this.model.accept&&""!=this.model.accept&&(this.dialogEl.accept=this.model.accept),this.dialogEl.style.width="{this.model.width}px",this.dialogEl.onchange=function(e){return t.load_file(e)},this.el.appendChild(this.dialogEl))},e.prototype.load_file=function(t){var e=this,n=new FileReader;this.model.filename=t.target.files[0].name,n.onload=function(t){return e.file(t)},n.readAsDataURL(t.target.files[0])},e.prototype.file=function(t){var e=t.target.result,n=e.split(","),i=n[1],o=n[0].split(":")[1].split(";")[0];this.model.value=i,this.model.mime_type=o},e.__name__="FileInputView",e}(r.WidgetView);n.FileInputView=a;var s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.type="FileInput",this.prototype.default_view=a,this.define({value:[o.String,""],mime_type:[o.String,""],filename:[o.String,""],accept:[o.String,""]})},e.__name__="FileInput",e}(r.Widget);n.FileInput=s,s.initClass()},447:function(t,e,n){var i=t(431);n.AbstractButton=i.AbstractButton;var o=t(432);n.AbstractIcon=o.AbstractIcon;var r=t(434);n.AutocompleteInput=r.AutocompleteInput;var a=t(435);n.Button=a.Button;var s=t(437);n.CheckboxButtonGroup=s.CheckboxButtonGroup;var l=t(438);n.CheckboxGroup=l.CheckboxGroup;var u=t(439);n.ColorPicker=u.ColorPicker;var c=t(441);n.DatePicker=c.DatePicker;var d=t(442);n.DateRangeSlider=d.DateRangeSlider;var p=t(443);n.DateSlider=p.DateSlider;var h=t(444);n.Div=h.Div;var f=t(445);n.Dropdown=f.Dropdown;var _=t(446);n.FileInput=_.FileInput;var m=t(449);n.InputWidget=m.InputWidget;var b=t(451);n.Markup=b.Markup;var g=t(452);n.MultiSelect=g.MultiSelect;var v=t(453);n.Paragraph=v.Paragraph;var k=t(454);n.PasswordInput=k.PasswordInput;var y=t(455);n.PreText=y.PreText;var w=t(456);n.RadioButtonGroup=w.RadioButtonGroup;var x=t(457);n.RadioGroup=x.RadioGroup;var S=t(458);n.RangeSlider=S.RangeSlider;var C=t(459);n.Select=C.Select;var D=t(460);n.Slider=D.Slider;var A=t(461);n.Spinner=A.Spinner;var E=t(462);n.TextInput=E.TextInput;var U=t(463);n.TextAreaInput=U.TextAreaInput;var V=t(464);n.Toggle=V.Toggle;var M=t(482);n.Widget=M.Widget},448:function(t,e,n){var i=t(421),o=t(440),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.render()})},e.__name__="InputGroupView",e}(o.ControlView);n.InputGroupView=r;var a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.__name__="InputGroup",e}(o.Control);n.InputGroup=a},449:function(t,e,n){var i=t(421),o=t(440),r=t(5),a=t(18),s=t(467),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.title.change,function(){e.label_el.textContent=e.model.title})},e.prototype.render=function(){t.prototype.render.call(this);var e=this.model.title;this.label_el=r.label({style:{display:0==e.length?"none":""}},e),this.group_el=r.div({class:s.bk_input_group},this.label_el),this.el.appendChild(this.group_el)},e.prototype.change_input=function(){null!=this.model.callback&&this.model.callback.execute(this.model)},e.__name__="InputWidgetView",e}(o.ControlView);n.InputWidgetView=l;var u=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({title:[a.String,""],callback:[a.Any]})},e.__name__="InputWidget",e}(o.Control);n.InputWidget=u,u.initClass()},450:function(t,e,n){var i=t(447);n.Widgets=i;var o=t(0);o.register_models(i)},451:function(t,e,n){var i=t(421),o=t(13),r=t(5),a=t(18),s=t(482),l=t(466),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){e.render(),e.root.compute_layout()})},e.prototype._update_layout=function(){this.layout=new o.VariadicBox(this.el),this.layout.set_sizing(this.box_sizing())},e.prototype.render=function(){t.prototype.render.call(this);var e=i.__assign({},this.model.style,{display:"inline-block"});this.markup_el=r.div({class:l.bk_clearfix,style:e}),this.el.appendChild(this.markup_el)},e.__name__="MarkupView",e}(s.WidgetView);n.MarkupView=u;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({text:[a.String,""],style:[a.Any,{}]})},e.__name__="Markup",e}(s.Widget);n.Markup=c,c.initClass()},452:function(t,e,n){var i=t(421),o=t(5),r=t(46),a=t(32),s=t(18),l=t(449),u=t(467),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.value.change,function(){return e.render_selection()}),this.connect(this.model.properties.options.change,function(){return e.render()}),this.connect(this.model.properties.name.change,function(){return e.render()}),this.connect(this.model.properties.title.change,function(){return e.render()}),this.connect(this.model.properties.size.change,function(){return e.render()}),this.connect(this.model.properties.disabled.change,function(){return e.render()})},e.prototype.render=function(){var e=this;t.prototype.render.call(this);var n=this.model.options.map(function(t){var e,n;return r.isString(t)?e=n=t:(e=t[0],n=t[1]),o.option({value:e},n)});this.select_el=o.select({multiple:!0,class:u.bk_input,name:this.model.name,disabled:this.model.disabled},n),this.select_el.addEventListener("change",function(){return e.change_input()}),this.group_el.appendChild(this.select_el),this.render_selection()},e.prototype.render_selection=function(){for(var t=new a.Set(this.model.value),e=0,n=Array.from(this.el.querySelectorAll("option"));e<n.length;e++){var i=n[e];i.selected=t.has(i.value)}this.select_el.size=this.model.size},e.prototype.change_input=function(){for(var e=null!=this.el.querySelector("select:focus"),n=[],i=0,o=Array.from(this.el.querySelectorAll("option"));i<o.length;i++){var r=o[i];r.selected&&n.push(r.value)}this.model.value=n,t.prototype.change_input.call(this),e&&this.select_el.focus()},e.__name__="MultiSelectView",e}(l.InputWidgetView);n.MultiSelectView=c;var d=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c,this.define({value:[s.Array,[]],options:[s.Array,[]],size:[s.Number,4]})},e.__name__="MultiSelect",e}(l.InputWidget);n.MultiSelect=d,d.initClass()},453:function(t,e,n){var i=t(421),o=t(451),r=t(5),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.render=function(){t.prototype.render.call(this);var e=r.p({style:{margin:0}},this.model.text);this.markup_el.appendChild(e)},e.__name__="ParagraphView",e}(o.MarkupView);n.ParagraphView=a;var s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a},e.__name__="Paragraph",e}(o.Markup);n.Paragraph=s,s.initClass()},454:function(t,e,n){var i=t(421),o=t(462),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.render=function(){t.prototype.render.call(this),this.input_el.type="password"},e.__name__="PasswordInputView",e}(o.TextInputView);n.PasswordInputView=r;var a=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=r},e.__name__="PasswordInput",e}(o.TextInput);n.PasswordInput=a,a.initClass()},455:function(t,e,n){var i=t(421),o=t(451),r=t(5),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.render=function(){t.prototype.render.call(this);var e=r.pre({style:{overflow:"auto"}},this.model.text);this.markup_el.appendChild(e)},e.__name__="PreTextView",e}(o.MarkupView);n.PreTextView=a;var s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a},e.__name__="PreText",e}(o.Markup);n.PreText=s,s.initClass()},456:function(t,e,n){var i=t(421),o=t(436),r=t(5),a=t(18),s=t(309),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.change_active=function(t){this.model.active!==t&&(this.model.active=t,null!=this.model.callback&&this.model.callback.execute(this.model))},e.prototype._update_active=function(){var t=this.model.active;this._buttons.forEach(function(e,n){r.classes(e).toggle(s.bk_active,t===n)})},e.__name__="RadioButtonGroupView",e}(o.ButtonGroupView);n.RadioButtonGroupView=l;var u=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.define({active:[a.Any,null]})},e.__name__="RadioButtonGroup",e}(o.ButtonGroup);n.RadioButtonGroup=u,u.initClass()},457:function(t,e,n){var i=t(421),o=t(5),r=t(40),a=t(18),s=t(448),l=t(309),u=t(467),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.render=function(){var e=this;t.prototype.render.call(this);var n=o.div({class:[u.bk_input_group,this.model.inline?l.bk_inline:null]});this.el.appendChild(n);for(var i=r.uniqueId(),a=this.model,s=a.active,c=a.labels,d=function(t){var r=o.input({type:"radio",name:i,value:""+t});r.addEventListener("change",function(){return e.change_active(t)}),p.model.disabled&&(r.disabled=!0),t==s&&(r.checked=!0);var a=o.label({},r,o.span({},c[t]));n.appendChild(a)},p=this,h=0;h<c.length;h++)d(h)},e.prototype.change_active=function(t){this.model.active=t,null!=this.model.callback&&this.model.callback.execute(this.model)},e.__name__="RadioGroupView",e}(s.InputGroupView);n.RadioGroupView=c;var d=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c,this.define({active:[a.Number],labels:[a.Array,[]],inline:[a.Boolean,!1],callback:[a.Any]})},e.__name__="RadioGroup",e}(s.InputGroup);n.RadioGroup=d,d.initClass()},458:function(t,e,n){var i=t(421),o=t(391),r=t(433),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="RangeSliderView",e}(r.AbstractRangeSliderView);n.RangeSliderView=a;var s=function(t){function e(e){var n=t.call(this,e)||this;return n.behaviour="drag",n.connected=[!1,!0,!1],n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.override({format:"0[.]00"})},e.prototype._formatter=function(t,e){return o.format(t,e)},e.__name__="RangeSlider",e}(r.AbstractSlider);n.RangeSlider=s,s.initClass()},459:function(t,e,n){var i=t(421),o=t(5),r=t(46),a=t(17),s=t(18),l=t(449),u=t(467),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.render()})},e.prototype.build_options=function(t){var e=this;return t.map(function(t){var n,i;r.isString(t)?n=i=t:(n=t[0],i=t[1]);var a=e.model.value==n;return o.option({selected:a,value:n},i)})},e.prototype.render=function(){var e,n=this;if(t.prototype.render.call(this),r.isArray(this.model.options))e=this.build_options(this.model.options);else{e=[];var i=this.model.options;for(var a in i){var s=i[a];e.push(o.optgroup({label:a},this.build_options(s)))}}this.select_el=o.select({class:u.bk_input,id:this.model.id,name:this.model.name,disabled:this.model.disabled},e),this.select_el.addEventListener("change",function(){return n.change_input()}),this.group_el.appendChild(this.select_el)},e.prototype.change_input=function(){var e=this.select_el.value;a.logger.debug("selectbox: value = "+e),this.model.value=e,t.prototype.change_input.call(this)},e.__name__="SelectView",e}(l.InputWidgetView);n.SelectView=c;var d=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=c,this.define({value:[s.String,""],options:[s.Any,[]]})},e.__name__="Select",e}(l.InputWidget);n.Select=d,d.initClass()},460:function(t,e,n){var i=t(421),o=t(391),r=t(433),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.__name__="SliderView",e}(r.AbstractSliderView);n.SliderView=a;var s=function(t){function e(e){var n=t.call(this,e)||this;return n.behaviour="tap",n.connected=[!0,!1],n}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=a,this.override({format:"0[.]00"})},e.prototype._formatter=function(t,e){return o.format(t,e)},e.__name__="Slider",e}(r.AbstractSlider);n.Slider=s,s.initClass()},461:function(t,e,n){var i=t(421),o=t(449),r=t(5),a=t(18),s=t(467),l=Math.abs,u=Math.floor,c=Math.log10;function d(t){var e=l(Number(String(t).replace(".","")));if(0==e)return 0;for(;0!=e&&e%10==0;)e/=10;return u(c(e))+1}var p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.low.change,function(){var t=e.model.low;null!=t&&(e.input_el.min=t.toFixed(16))}),this.connect(this.model.properties.high.change,function(){var t=e.model.high;null!=t&&(e.input_el.max=t.toFixed(16))}),this.connect(this.model.properties.step.change,function(){var t=e.model.step;e.input_el.step=t.toFixed(16)}),this.connect(this.model.properties.value.change,function(){var t=e.model,n=t.value,i=t.step;e.input_el.value=n.toFixed(d(i))}),this.connect(this.model.properties.disabled.change,function(){e.input_el.disabled=e.model.disabled})},e.prototype.render=function(){var e=this;t.prototype.render.call(this),this.input_el=r.input({type:"number",class:s.bk_input,name:this.model.name,min:this.model.low,max:this.model.high,value:this.model.value,step:this.model.step,disabled:this.model.disabled}),this.input_el.addEventListener("change",function(){return e.change_input()}),this.group_el.appendChild(this.input_el)},e.prototype.change_input=function(){var e=this.model.step,n=Number(this.input_el.value);this.model.value=Number(n.toFixed(d(e))),this.model.value!=n&&this.model.change.emit(),t.prototype.change_input.call(this)},e.__name__="SpinnerView",e}(o.InputWidgetView);n.SpinnerView=p;var h=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=p,this.define({value:[a.Number,0],low:[a.Number,null],high:[a.Number,null],step:[a.Number,1]})},e.__name__="Spinner",e}(o.InputWidget);n.Spinner=h,h.initClass()},462:function(t,e,n){var i=t(421),o=t(449),r=t(5),a=t(18),s=t(467),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.name.change,function(){return e.input_el.name=e.model.name||""}),this.connect(this.model.properties.value.change,function(){return e.input_el.value=e.model.value}),this.connect(this.model.properties.value_input.change,function(){return e.input_el.value=e.model.value_input}),this.connect(this.model.properties.disabled.change,function(){return e.input_el.disabled=e.model.disabled}),this.connect(this.model.properties.placeholder.change,function(){return e.input_el.placeholder=e.model.placeholder})},e.prototype.render=function(){var e=this;t.prototype.render.call(this),this.input_el=r.input({type:"text",class:s.bk_input,name:this.model.name,value:this.model.value,disabled:this.model.disabled,placeholder:this.model.placeholder}),this.input_el.addEventListener("change",function(){return e.change_input()}),this.input_el.addEventListener("input",function(){return e.change_input_oninput()}),this.group_el.appendChild(this.input_el)},e.prototype.change_input=function(){this.model.value=this.input_el.value,t.prototype.change_input.call(this)},e.prototype.change_input_oninput=function(){this.model.value_input=this.input_el.value,t.prototype.change_input.call(this)},e.__name__="TextInputView",e}(o.InputWidgetView);n.TextInputView=l;var u=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.define({value:[a.String,""],value_input:[a.String,""],placeholder:[a.String,""]})},e.__name__="TextInput",e}(o.InputWidget);n.TextInput=u,u.initClass()},463:function(t,e,n){var i=t(421),o=t(462),r=t(449),a=t(5),s=t(18),l=t(467),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.name.change,function(){return e.input_el.name=e.model.name||""}),this.connect(this.model.properties.value.change,function(){return e.input_el.value=e.model.value}),this.connect(this.model.properties.disabled.change,function(){return e.input_el.disabled=e.model.disabled}),this.connect(this.model.properties.placeholder.change,function(){return e.input_el.placeholder=e.model.placeholder}),this.connect(this.model.properties.rows.change,function(){return e.input_el.rows=e.model.rows}),this.connect(this.model.properties.cols.change,function(){return e.input_el.cols=e.model.cols}),this.connect(this.model.properties.max_length.change,function(){return e.input_el.maxLength=e.model.max_length})},e.prototype.render=function(){var e=this;t.prototype.render.call(this),this.input_el=a.textarea({class:l.bk_input,name:this.model.name,disabled:this.model.disabled,placeholder:this.model.placeholder,cols:this.model.cols,rows:this.model.rows,maxLength:this.model.max_length}),this.input_el.textContent=this.model.value,this.input_el.addEventListener("change",function(){return e.change_input()}),this.group_el.appendChild(this.input_el)},e.prototype.change_input=function(){this.model.value=this.input_el.value,t.prototype.change_input.call(this)},e.__name__="TextAreaInputView",e}(r.InputWidgetView);n.TextAreaInputView=u;var c=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=u,this.define({cols:[s.Number,20],rows:[s.Number,2],max_length:[s.Number,500]})},e.__name__="TextAreaInput",e}(o.TextInput);n.TextAreaInput=c,c.initClass()},464:function(t,e,n){var i=t(421),o=t(431),r=t(5),a=t(18),s=t(309),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,function(){return e._update_active()})},e.prototype.render=function(){t.prototype.render.call(this),this._update_active()},e.prototype.click=function(){this.model.active=!this.model.active,t.prototype.click.call(this)},e.prototype._update_active=function(){r.classes(this.button_el).toggle(s.bk_active,this.model.active)},e.__name__="ToggleView",e}(o.AbstractButtonView);n.ToggleView=l;var u=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.prototype.default_view=l,this.define({active:[a.Boolean,!1]}),this.override({label:"Toggle"})},e.__name__="Toggle",e}(o.AbstractButton);n.Toggle=u,u.initClass()},482:function(t,e,n){var i=t(421),o=t(164),r=t(18),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype._width_policy=function(){return"horizontal"==this.model.orientation?t.prototype._width_policy.call(this):"fixed"},e.prototype._height_policy=function(){return"horizontal"==this.model.orientation?"fixed":t.prototype._height_policy.call(this)},e.prototype.box_sizing=function(){var e=t.prototype.box_sizing.call(this);return"horizontal"==this.model.orientation?null==e.width&&(e.width=this.model.default_size):null==e.height&&(e.height=this.model.default_size),e},e.__name__="WidgetView",e}(o.HTMLBoxView);n.WidgetView=a;var s=function(t){function e(e){return t.call(this,e)||this}return i.__extends(e,t),e.initClass=function(){this.define({orientation:[r.Orientation,"horizontal"],default_size:[r.Number,300]}),this.override({margin:[5,5,5,5]})},e.__name__="Widget",e}(o.HTMLBox);n.Widget=s,s.initClass()},466:function(t,e,n){t(311);var i=t(5);i.styles.append('.bk-root .bk-clearfix:before,\n.bk-root .bk-clearfix:after {\n  content: "";\n  display: table;\n}\n.bk-root .bk-clearfix:after {\n  clear: both;\n}\n'),n.bk_clearfix="bk-clearfix"},467:function(t,e,n){t(311);var i=t(5);i.styles.append('.bk-root .bk-input {\n  display: inline-block;\n  width: 100%;\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n  min-height: 31px;\n  padding: 0 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n}\n.bk-root .bk-input:focus {\n  border-color: #66afe9;\n  outline: 0;\n  box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075), 0 0 8px rgba(102, 175, 233, 0.6);\n}\n.bk-root .bk-input::placeholder,\n.bk-root .bk-input:-ms-input-placeholder,\n.bk-root .bk-input::-moz-placeholder,\n.bk-root .bk-input::-webkit-input-placeholder {\n  color: #999;\n  opacity: 1;\n}\n.bk-root .bk-input[disabled],\n.bk-root .bk-input[readonly] {\n  cursor: not-allowed;\n  background-color: #eee;\n  opacity: 1;\n}\n.bk-root select[multiple].bk-input,\n.bk-root select[size].bk-input,\n.bk-root textarea.bk-input {\n  height: auto;\n}\n.bk-root .bk-input-group {\n  width: 100%;\n  height: 100%;\n  display: inline-flex;\n  display: -webkit-inline-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: start;\n  -webkit-align-items: start;\n  flex-direction: column;\n  -webkit-flex-direction: column;\n  white-space: nowrap;\n}\n.bk-root .bk-input-group.bk-inline {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-input-group.bk-inline > *:not(:first-child) {\n  margin-left: 5px;\n}\n.bk-root .bk-input-group input[type="checkbox"] + span,\n.bk-root .bk-input-group input[type="radio"] + span {\n  position: relative;\n  top: -2px;\n  margin-left: 3px;\n}\n'),n.bk_input="bk-input",n.bk_input_group="bk-input-group"},468:function(t,e,n){t(311);var i=t(5);i.styles.append('.bk-root {\n  /* Functional styling;\n * These styles are required for noUiSlider to function.\n * You don\'t need to change these rules to apply your design.\n */\n  /* Painting and performance;\n * Browsers can paint handles in their own layer.\n */\n  /* Slider size and handle placement;\n */\n  /* Styling;\n */\n  /* Handles and cursors;\n */\n  /* Handle stripes;\n */\n  /* Disabled state;\n */\n  /* Base;\n *\n */\n  /* Values;\n *\n */\n  /* Markings;\n *\n */\n  /* Horizontal layout;\n *\n */\n  /* Vertical layout;\n *\n */\n}\n.bk-root .bk-noUi-target,\n.bk-root .bk-noUi-target * {\n  -webkit-touch-callout: none;\n  -webkit-tap-highlight-color: rgba(0, 0, 0, 0);\n  -webkit-user-select: none;\n  -ms-touch-action: none;\n  touch-action: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  user-select: none;\n  -moz-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.bk-root .bk-noUi-target {\n  position: relative;\n  direction: ltr;\n}\n.bk-root .bk-noUi-base {\n  width: 100%;\n  height: 100%;\n  position: relative;\n  z-index: 1;\n  /* Fix 401 */\n}\n.bk-root .bk-noUi-connect {\n  position: absolute;\n  right: 0;\n  top: 0;\n  left: 0;\n  bottom: 0;\n}\n.bk-root .bk-noUi-origin {\n  position: absolute;\n  height: 0;\n  width: 0;\n}\n.bk-root .bk-noUi-handle {\n  position: relative;\n  z-index: 1;\n}\n.bk-root .bk-noUi-state-tap .bk-noUi-connect,\n.bk-root .bk-noUi-state-tap .bk-noUi-origin {\n  -webkit-transition: top 0.3s, right 0.3s, bottom 0.3s, left 0.3s;\n  transition: top 0.3s, right 0.3s, bottom 0.3s, left 0.3s;\n}\n.bk-root .bk-noUi-state-drag * {\n  cursor: inherit !important;\n}\n.bk-root .bk-noUi-base,\n.bk-root .bk-noUi-handle {\n  -webkit-transform: translate3d(0, 0, 0);\n  transform: translate3d(0, 0, 0);\n}\n.bk-root .bk-noUi-horizontal {\n  height: 18px;\n}\n.bk-root .bk-noUi-horizontal .bk-noUi-handle {\n  width: 34px;\n  height: 28px;\n  left: -17px;\n  top: -6px;\n}\n.bk-root .bk-noUi-vertical {\n  width: 18px;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-handle {\n  width: 28px;\n  height: 34px;\n  left: -6px;\n  top: -17px;\n}\n.bk-root .bk-noUi-target {\n  background: #FAFAFA;\n  border-radius: 4px;\n  border: 1px solid #D3D3D3;\n  box-shadow: inset 0 1px 1px #F0F0F0, 0 3px 6px -5px #BBB;\n}\n.bk-root .bk-noUi-connect {\n  background: #3FB8AF;\n  border-radius: 4px;\n  box-shadow: inset 0 0 3px rgba(51, 51, 51, 0.45);\n  -webkit-transition: background 450ms;\n  transition: background 450ms;\n}\n.bk-root .bk-noUi-draggable {\n  cursor: ew-resize;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-draggable {\n  cursor: ns-resize;\n}\n.bk-root .bk-noUi-handle {\n  border: 1px solid #D9D9D9;\n  border-radius: 3px;\n  background: #FFF;\n  cursor: default;\n  box-shadow: inset 0 0 1px #FFF, inset 0 1px 7px #EBEBEB, 0 3px 6px -3px #BBB;\n}\n.bk-root .bk-noUi-active {\n  box-shadow: inset 0 0 1px #FFF, inset 0 1px 7px #DDD, 0 3px 6px -3px #BBB;\n}\n.bk-root .bk-noUi-handle:before,\n.bk-root .bk-noUi-handle:after {\n  content: "";\n  display: block;\n  position: absolute;\n  height: 14px;\n  width: 1px;\n  background: #E8E7E6;\n  left: 14px;\n  top: 6px;\n}\n.bk-root .bk-noUi-handle:after {\n  left: 17px;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-handle:before,\n.bk-root .bk-noUi-vertical .bk-noUi-handle:after {\n  width: 14px;\n  height: 1px;\n  left: 6px;\n  top: 14px;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-handle:after {\n  top: 17px;\n}\n.bk-root [disabled] .bk-noUi-connect {\n  background: #B8B8B8;\n}\n.bk-root [disabled].bk-noUi-target,\n.bk-root [disabled].bk-noUi-handle,\n.bk-root [disabled] .bk-noUi-handle {\n  cursor: not-allowed;\n}\n.bk-root .bk-noUi-pips,\n.bk-root .bk-noUi-pips * {\n  -moz-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.bk-root .bk-noUi-pips {\n  position: absolute;\n  color: #999;\n}\n.bk-root .bk-noUi-value {\n  position: absolute;\n  white-space: nowrap;\n  text-align: center;\n}\n.bk-root .bk-noUi-value-sub {\n  color: #ccc;\n  font-size: 10px;\n}\n.bk-root .bk-noUi-marker {\n  position: absolute;\n  background: #CCC;\n}\n.bk-root .bk-noUi-marker-sub {\n  background: #AAA;\n}\n.bk-root .bk-noUi-marker-large {\n  background: #AAA;\n}\n.bk-root .bk-noUi-pips-horizontal {\n  padding: 10px 0;\n  height: 80px;\n  top: 100%;\n  left: 0;\n  width: 100%;\n}\n.bk-root .bk-noUi-value-horizontal {\n  -webkit-transform: translate3d(-50%, 50%, 0);\n  transform: translate3d(-50%, 50%, 0);\n}\n.bk-root .bk-noUi-marker-horizontal.bk-noUi-marker {\n  margin-left: -1px;\n  width: 2px;\n  height: 5px;\n}\n.bk-root .bk-noUi-marker-horizontal.bk-noUi-marker-sub {\n  height: 10px;\n}\n.bk-root .bk-noUi-marker-horizontal.bk-noUi-marker-large {\n  height: 15px;\n}\n.bk-root .bk-noUi-pips-vertical {\n  padding: 0 10px;\n  height: 100%;\n  top: 0;\n  left: 100%;\n}\n.bk-root .bk-noUi-value-vertical {\n  -webkit-transform: translate3d(0, 50%, 0);\n  transform: translate3d(0, 50%, 0);\n  padding-left: 25px;\n}\n.bk-root .bk-noUi-marker-vertical.bk-noUi-marker {\n  width: 5px;\n  height: 2px;\n  margin-top: -1px;\n}\n.bk-root .bk-noUi-marker-vertical.bk-noUi-marker-sub {\n  width: 10px;\n}\n.bk-root .bk-noUi-marker-vertical.bk-noUi-marker-large {\n  width: 15px;\n}\n.bk-root .bk-noUi-tooltip {\n  display: block;\n  position: absolute;\n  border: 1px solid #D9D9D9;\n  border-radius: 3px;\n  background: #fff;\n  color: #000;\n  padding: 5px;\n  text-align: center;\n  white-space: nowrap;\n}\n.bk-root .bk-noUi-horizontal .bk-noUi-tooltip {\n  -webkit-transform: translate(-50%, 0);\n  transform: translate(-50%, 0);\n  left: 50%;\n  bottom: 120%;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-tooltip {\n  -webkit-transform: translate(0, -50%);\n  transform: translate(0, -50%);\n  top: 50%;\n  right: 120%;\n}\n.bk-root .bk-noUi-handle {\n  cursor: grab;\n  cursor: -webkit-grab;\n}\n.bk-root .bk-noUi-handle.bk-noUi-active {\n  cursor: grabbing;\n  cursor: -webkit-grabbing;\n}\n.bk-root .bk-noUi-tooltip {\n  display: none;\n  white-space: nowrap;\n}\n.bk-root .bk-noUi-handle:hover .bk-noUi-tooltip {\n  display: block;\n}\n.bk-root .bk-noUi-horizontal {\n  width: 100%;\n  height: 10px;\n}\n.bk-root .bk-noUi-horizontal.bk-noUi-target {\n  margin: 5px 0px;\n}\n.bk-root .bk-noUi-horizontal .bk-noUi-handle {\n  width: 14px;\n  height: 18px;\n  left: -7px;\n  top: -5px;\n}\n.bk-root .bk-noUi-vertical {\n  width: 10px;\n  height: 100%;\n}\n.bk-root .bk-noUi-vertical.bk-noUi-target {\n  margin: 0px 5px;\n}\n.bk-root .bk-noUi-vertical .bk-noUi-handle {\n  width: 18px;\n  height: 14px;\n  left: -5px;\n  top: -7px;\n}\n.bk-root .bk-noUi-handle:after,\n.bk-root .bk-noUi-handle:before {\n  display: none;\n}\n.bk-root .bk-noUi-connect {\n  box-shadow: none;\n}\n')},469:function(t,e,n){t(311);var i=t(5);i.styles.append('.bk-root {\n  @charset "UTF-8";\n  /*!\n * Pikaday\n * Copyright © 2014 David Bushell | BSD & MIT license | https://dbushell.com/\n */\n  /*\nclear child float (pika-lendar), using the famous micro clearfix hack\nhttp://nicolasgallagher.com/micro-clearfix-hack/\n*/\n  /* styling for abbr */\n}\n.bk-root .pika-single {\n  z-index: 9999;\n  display: block;\n  position: relative;\n  color: #333;\n  background: #fff;\n  border: 1px solid #ccc;\n  border-bottom-color: #bbb;\n  font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;\n}\n.bk-root .pika-single:before,\n.bk-root .pika-single:after {\n  content: " ";\n  display: table;\n}\n.bk-root .pika-single:after {\n  clear: both;\n}\n.bk-root .pika-single.is-hidden {\n  display: none;\n}\n.bk-root .pika-single.is-bound {\n  position: absolute;\n  box-shadow: 0 5px 15px -5px rgba(0, 0, 0, 0.5);\n}\n.bk-root .pika-lendar {\n  float: left;\n  width: 240px;\n  margin: 8px;\n}\n.bk-root .pika-title {\n  position: relative;\n  text-align: center;\n}\n.bk-root .pika-label {\n  display: inline-block;\n  position: relative;\n  z-index: 9999;\n  overflow: hidden;\n  margin: 0;\n  padding: 5px 3px;\n  font-size: 14px;\n  line-height: 20px;\n  font-weight: bold;\n  background-color: #fff;\n}\n.bk-root .pika-title select {\n  cursor: pointer;\n  position: absolute;\n  z-index: 9998;\n  margin: 0;\n  left: 0;\n  top: 5px;\n  opacity: 0;\n}\n.bk-root .pika-prev,\n.bk-root .pika-next {\n  display: block;\n  cursor: pointer;\n  position: relative;\n  outline: none;\n  border: 0;\n  padding: 0;\n  width: 20px;\n  height: 30px;\n  /* hide text using text-indent trick, using width value (it\'s enough) */\n  text-indent: 20px;\n  white-space: nowrap;\n  overflow: hidden;\n  background-color: transparent;\n  background-position: center center;\n  background-repeat: no-repeat;\n  background-size: 75% 75%;\n  opacity: 0.5;\n}\n.bk-root .pika-prev:hover,\n.bk-root .pika-next:hover {\n  opacity: 1;\n}\n.bk-root .pika-prev,\n.bk-root .is-rtl .pika-next {\n  float: left;\n  background-image: url(\'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAeCAYAAAAsEj5rAAAAUklEQVR42u3VMQoAIBADQf8Pgj+OD9hG2CtONJB2ymQkKe0HbwAP0xucDiQWARITIDEBEnMgMQ8S8+AqBIl6kKgHiXqQqAeJepBo/z38J/U0uAHlaBkBl9I4GwAAAABJRU5ErkJggg==\');\n}\n.bk-root .pika-next,\n.bk-root .is-rtl .pika-prev {\n  float: right;\n  background-image: url(\'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAeCAYAAAAsEj5rAAAAU0lEQVR42u3VOwoAMAgE0dwfAnNjU26bYkBCFGwfiL9VVWoO+BJ4Gf3gtsEKKoFBNTCoCAYVwaAiGNQGMUHMkjGbgjk2mIONuXo0nC8XnCf1JXgArVIZAQh5TKYAAAAASUVORK5CYII=\');\n}\n.bk-root .pika-prev.is-disabled,\n.bk-root .pika-next.is-disabled {\n  cursor: default;\n  opacity: 0.2;\n}\n.bk-root .pika-select {\n  display: inline-block;\n}\n.bk-root .pika-table {\n  width: 100%;\n  border-collapse: collapse;\n  border-spacing: 0;\n  border: 0;\n}\n.bk-root .pika-table th,\n.bk-root .pika-table td {\n  width: 14.28571429%;\n  padding: 0;\n}\n.bk-root .pika-table th {\n  color: #999;\n  font-size: 12px;\n  line-height: 25px;\n  font-weight: bold;\n  text-align: center;\n}\n.bk-root .pika-button {\n  cursor: pointer;\n  display: block;\n  box-sizing: border-box;\n  -moz-box-sizing: border-box;\n  outline: none;\n  border: 0;\n  margin: 0;\n  width: 100%;\n  padding: 5px;\n  color: #666;\n  font-size: 12px;\n  line-height: 15px;\n  text-align: right;\n  background: #f5f5f5;\n}\n.bk-root .pika-week {\n  font-size: 11px;\n  color: #999;\n}\n.bk-root .is-today .pika-button {\n  color: #33aaff;\n  font-weight: bold;\n}\n.bk-root .is-selected .pika-button,\n.bk-root .has-event .pika-button {\n  color: #fff;\n  font-weight: bold;\n  background: #33aaff;\n  box-shadow: inset 0 1px 3px #178fe5;\n  border-radius: 3px;\n}\n.bk-root .has-event .pika-button {\n  background: #005da9;\n  box-shadow: inset 0 1px 3px #0076c9;\n}\n.bk-root .is-disabled .pika-button,\n.bk-root .is-inrange .pika-button {\n  background: #D5E9F7;\n}\n.bk-root .is-startrange .pika-button {\n  color: #fff;\n  background: #6CB31D;\n  box-shadow: none;\n  border-radius: 3px;\n}\n.bk-root .is-endrange .pika-button {\n  color: #fff;\n  background: #33aaff;\n  box-shadow: none;\n  border-radius: 3px;\n}\n.bk-root .is-disabled .pika-button {\n  pointer-events: none;\n  cursor: default;\n  color: #999;\n  opacity: 0.3;\n}\n.bk-root .is-outside-current-month .pika-button {\n  color: #999;\n  opacity: 0.3;\n}\n.bk-root .is-selection-disabled {\n  pointer-events: none;\n  cursor: default;\n}\n.bk-root .pika-button:hover,\n.bk-root .pika-row.pick-whole-week:hover .pika-button {\n  color: #fff;\n  background: #ff8000;\n  box-shadow: none;\n  border-radius: 3px;\n}\n.bk-root .pika-table abbr {\n  border-bottom: none;\n  cursor: help;\n}\n')},470:function(t,e,n){t(311),t(468);var i=t(5);i.styles.append(".bk-root .bk-slider-title {\n  white-space: nowrap;\n}\n.bk-root .bk-slider-value {\n  font-weight: 600;\n}\n"),n.bk_slider_value="bk-slider-value",n.bk_slider_title="bk-slider-title",n.bk_input_group="bk-input-group"},471:function(t,e,n){
/*! nouislider - 10.1.0 - 2017-07-28 17:11:18 */var i;i=function(){"use strict";var t="10.1.0";function e(t){t.preventDefault()}function n(t){return"number"==typeof t&&!isNaN(t)&&isFinite(t)}function i(t,e,n){n>0&&(a(t,e),setTimeout(function(){s(t,e)},n))}function o(t){return Array.isArray(t)?t:[t]}function r(t){var e=(t=String(t)).split(".");return e.length>1?e[1].length:0}function a(t,e){t.classList?t.classList.add(e):t.className+=" "+e}function s(t,e){t.classList?t.classList.remove(e):t.className=t.className.replace(new RegExp("(^|\\b)"+e.split(" ").join("|")+"(\\b|$)","gi")," ")}function l(t){var e=void 0!==window.pageXOffset,n="CSS1Compat"===(t.compatMode||""),i=e?window.pageXOffset:n?t.documentElement.scrollLeft:t.body.scrollLeft,o=e?window.pageYOffset:n?t.documentElement.scrollTop:t.body.scrollTop;return{x:i,y:o}}function u(t,e){return 100/(e-t)}function c(t,e){return 100*e/(t[1]-t[0])}function d(t,e){for(var n=1;t>=e[n];)n+=1;return n}function p(t,e,n){if(n>=t.slice(-1)[0])return 100;var i,o,r,a,s=d(n,t);return i=t[s-1],o=t[s],r=e[s-1],a=e[s],r+function(t,e){return c(t,t[0]<0?e+Math.abs(t[0]):e-t[0])}([i,o],n)/u(r,a)}function h(t,e,n,i){if(100===i)return i;var o,r,a=d(i,t);return n?(o=t[a-1],r=t[a],i-o>(r-o)/2?r:o):e[a-1]?t[a-1]+function(t,e){return Math.round(t/e)*e}(i-t[a-1],e[a-1]):i}function f(e,i,o){var r;if("number"==typeof i&&(i=[i]),"[object Array]"!==Object.prototype.toString.call(i))throw new Error("noUiSlider ("+t+"): 'range' contains invalid value.");if(!n(r="min"===e?0:"max"===e?100:parseFloat(e))||!n(i[0]))throw new Error("noUiSlider ("+t+"): 'range' value isn't numeric.");o.xPct.push(r),o.xVal.push(i[0]),r?o.xSteps.push(!isNaN(i[1])&&i[1]):isNaN(i[1])||(o.xSteps[0]=i[1]),o.xHighestCompleteStep.push(0)}function _(t,e,n){if(!e)return!0;n.xSteps[t]=c([n.xVal[t],n.xVal[t+1]],e)/u(n.xPct[t],n.xPct[t+1]);var i=(n.xVal[t+1]-n.xVal[t])/n.xNumSteps[t],o=Math.ceil(Number(i.toFixed(3))-1),r=n.xVal[t]+n.xNumSteps[t]*o;n.xHighestCompleteStep[t]=r}function m(t,e,n){this.xPct=[],this.xVal=[],this.xSteps=[n||!1],this.xNumSteps=[!1],this.xHighestCompleteStep=[],this.snap=e;var i,o=[];for(i in t)t.hasOwnProperty(i)&&o.push([t[i],i]);for(o.length&&"object"==typeof o[0][0]?o.sort(function(t,e){return t[0][0]-e[0][0]}):o.sort(function(t,e){return t[0]-e[0]}),i=0;i<o.length;i++)f(o[i][1],o[i][0],this);for(this.xNumSteps=this.xSteps.slice(0),i=0;i<this.xNumSteps.length;i++)_(i,this.xNumSteps[i],this)}m.prototype.getMargin=function(e){var n=this.xNumSteps[0];if(n&&e/n%1!=0)throw new Error("noUiSlider ("+t+"): 'limit', 'margin' and 'padding' must be divisible by step.");return 2===this.xPct.length&&c(this.xVal,e)},m.prototype.toStepping=function(t){return t=p(this.xVal,this.xPct,t)},m.prototype.fromStepping=function(t){return function(t,e,n){if(n>=100)return t.slice(-1)[0];var i,o,r,a,s=d(n,e);return i=t[s-1],o=t[s],r=e[s-1],a=e[s],function(t,e){return e*(t[1]-t[0])/100+t[0]}([i,o],(n-r)*u(r,a))}(this.xVal,this.xPct,t)},m.prototype.getStep=function(t){return t=h(this.xPct,this.xSteps,this.snap,t)},m.prototype.getNearbySteps=function(t){var e=d(t,this.xPct);return{stepBefore:{startValue:this.xVal[e-2],step:this.xNumSteps[e-2],highestStep:this.xHighestCompleteStep[e-2]},thisStep:{startValue:this.xVal[e-1],step:this.xNumSteps[e-1],highestStep:this.xHighestCompleteStep[e-1]},stepAfter:{startValue:this.xVal[e-0],step:this.xNumSteps[e-0],highestStep:this.xHighestCompleteStep[e-0]}}},m.prototype.countStepDecimals=function(){var t=this.xNumSteps.map(r);return Math.max.apply(null,t)},m.prototype.convert=function(t){return this.getStep(this.toStepping(t))};var b={to:function(t){return void 0!==t&&t.toFixed(2)},from:Number};function g(e){if(function(t){return"object"==typeof t&&"function"==typeof t.to&&"function"==typeof t.from}(e))return!0;throw new Error("noUiSlider ("+t+"): 'format' requires 'to' and 'from' methods.")}function v(e,i){if(!n(i))throw new Error("noUiSlider ("+t+"): 'step' is not numeric.");e.singleStep=i}function k(e,n){if("object"!=typeof n||Array.isArray(n))throw new Error("noUiSlider ("+t+"): 'range' is not an object.");if(void 0===n.min||void 0===n.max)throw new Error("noUiSlider ("+t+"): Missing 'min' or 'max' in 'range'.");if(n.min===n.max)throw new Error("noUiSlider ("+t+"): 'range' 'min' and 'max' cannot be equal.");e.spectrum=new m(n,e.snap,e.singleStep)}function y(e,n){if(n=o(n),!Array.isArray(n)||!n.length)throw new Error("noUiSlider ("+t+"): 'start' option is incorrect.");e.handles=n.length,e.start=n}function w(e,n){if(e.snap=n,"boolean"!=typeof n)throw new Error("noUiSlider ("+t+"): 'snap' option must be a boolean.")}function x(e,n){if(e.animate=n,"boolean"!=typeof n)throw new Error("noUiSlider ("+t+"): 'animate' option must be a boolean.")}function S(e,n){if(e.animationDuration=n,"number"!=typeof n)throw new Error("noUiSlider ("+t+"): 'animationDuration' option must be a number.")}function C(e,n){var i,o=[!1];if("lower"===n?n=[!0,!1]:"upper"===n&&(n=[!1,!0]),!0===n||!1===n){for(i=1;i<e.handles;i++)o.push(n);o.push(!1)}else{if(!Array.isArray(n)||!n.length||n.length!==e.handles+1)throw new Error("noUiSlider ("+t+"): 'connect' option doesn't match handle count.");o=n}e.connect=o}function D(e,n){switch(n){case"horizontal":e.ort=0;break;case"vertical":e.ort=1;break;default:throw new Error("noUiSlider ("+t+"): 'orientation' option is invalid.")}}function A(e,i){if(!n(i))throw new Error("noUiSlider ("+t+"): 'margin' option must be numeric.");if(0!==i&&(e.margin=e.spectrum.getMargin(i),!e.margin))throw new Error("noUiSlider ("+t+"): 'margin' option is only supported on linear sliders.")}function E(e,i){if(!n(i))throw new Error("noUiSlider ("+t+"): 'limit' option must be numeric.");if(e.limit=e.spectrum.getMargin(i),!e.limit||e.handles<2)throw new Error("noUiSlider ("+t+"): 'limit' option is only supported on linear sliders with 2 or more handles.")}function U(e,i){if(!n(i))throw new Error("noUiSlider ("+t+"): 'padding' option must be numeric.");if(0!==i){if(e.padding=e.spectrum.getMargin(i),!e.padding)throw new Error("noUiSlider ("+t+"): 'padding' option is only supported on linear sliders.");if(e.padding<0)throw new Error("noUiSlider ("+t+"): 'padding' option must be a positive number.");if(e.padding>=50)throw new Error("noUiSlider ("+t+"): 'padding' option must be less than half the range.")}}function V(e,n){switch(n){case"ltr":e.dir=0;break;case"rtl":e.dir=1;break;default:throw new Error("noUiSlider ("+t+"): 'direction' option was not recognized.")}}function M(e,n){if("string"!=typeof n)throw new Error("noUiSlider ("+t+"): 'behaviour' must be a string containing options.");var i=n.indexOf("tap")>=0,o=n.indexOf("drag")>=0,r=n.indexOf("fixed")>=0,a=n.indexOf("snap")>=0,s=n.indexOf("hover")>=0;if(r){if(2!==e.handles)throw new Error("noUiSlider ("+t+"): 'fixed' behaviour must be used with 2 handles");A(e,e.start[1]-e.start[0])}e.events={tap:i||a,drag:o,fixed:r,snap:a,hover:s}}function N(e,n){if(e.multitouch=n,"boolean"!=typeof n)throw new Error("noUiSlider ("+t+"): 'multitouch' option must be a boolean.")}function I(e,n){if(!1!==n)if(!0===n){e.tooltips=[];for(var i=0;i<e.handles;i++)e.tooltips.push(!0)}else{if(e.tooltips=o(n),e.tooltips.length!==e.handles)throw new Error("noUiSlider ("+t+"): must pass a formatter for all handles.");e.tooltips.forEach(function(e){if("boolean"!=typeof e&&("object"!=typeof e||"function"!=typeof e.to))throw new Error("noUiSlider ("+t+"): 'tooltips' must be passed a formatter or 'false'.")})}}function B(t,e){t.ariaFormat=e,g(e)}function R(t,e){t.format=e,g(e)}function T(e,n){if(void 0!==n&&"string"!=typeof n&&!1!==n)throw new Error("noUiSlider ("+t+"): 'cssPrefix' must be a string or `false`.");e.cssPrefix=n}function P(e,n){if(void 0!==n&&"object"!=typeof n)throw new Error("noUiSlider ("+t+"): 'cssClasses' must be an object.");if("string"==typeof e.cssPrefix)for(var i in e.cssClasses={},n)n.hasOwnProperty(i)&&(e.cssClasses[i]=e.cssPrefix+n[i]);else e.cssClasses=n}function F(e,n){if(!0!==n&&!1!==n)throw new Error("noUiSlider ("+t+"): 'useRequestAnimationFrame' option should be true (default) or false.");e.useRequestAnimationFrame=n}function z(e){var n={margin:0,limit:0,padding:0,animate:!0,animationDuration:300,ariaFormat:b,format:b},i={step:{r:!1,t:v},start:{r:!0,t:y},connect:{r:!0,t:C},direction:{r:!0,t:V},snap:{r:!1,t:w},animate:{r:!1,t:x},animationDuration:{r:!1,t:S},range:{r:!0,t:k},orientation:{r:!1,t:D},margin:{r:!1,t:A},limit:{r:!1,t:E},padding:{r:!1,t:U},behaviour:{r:!0,t:M},multitouch:{r:!0,t:N},ariaFormat:{r:!1,t:B},format:{r:!1,t:R},tooltips:{r:!1,t:I},cssPrefix:{r:!1,t:T},cssClasses:{r:!1,t:P},useRequestAnimationFrame:{r:!1,t:F}},o={connect:!1,direction:"ltr",behaviour:"tap",multitouch:!1,orientation:"horizontal",cssPrefix:"noUi-",cssClasses:{target:"target",base:"base",origin:"origin",handle:"handle",handleLower:"handle-lower",handleUpper:"handle-upper",horizontal:"horizontal",vertical:"vertical",background:"background",connect:"connect",ltr:"ltr",rtl:"rtl",draggable:"draggable",drag:"state-drag",tap:"state-tap",active:"active",tooltip:"tooltip",pips:"pips",pipsHorizontal:"pips-horizontal",pipsVertical:"pips-vertical",marker:"marker",markerHorizontal:"marker-horizontal",markerVertical:"marker-vertical",markerNormal:"marker-normal",markerLarge:"marker-large",markerSub:"marker-sub",value:"value",valueHorizontal:"value-horizontal",valueVertical:"value-vertical",valueNormal:"value-normal",valueLarge:"value-large",valueSub:"value-sub"},useRequestAnimationFrame:!0};e.format&&!e.ariaFormat&&(e.ariaFormat=e.format),Object.keys(i).forEach(function(r){if(void 0===e[r]&&void 0===o[r]){if(i[r].r)throw new Error("noUiSlider ("+t+"): '"+r+"' is required.");return!0}i[r].t(n,void 0===e[r]?o[r]:e[r])}),n.pips=e.pips;var r=[["left","top"],["right","bottom"]];return n.style=r[n.dir][n.ort],n.styleOposite=r[n.dir?0:1][n.ort],n}function O(n,r,u){var c,d,p,h,f,_,m,b=window.navigator.pointerEnabled?{start:"pointerdown",move:"pointermove",end:"pointerup"}:window.navigator.msPointerEnabled?{start:"MSPointerDown",move:"MSPointerMove",end:"MSPointerUp"}:{start:"mousedown touchstart",move:"mousemove touchmove",end:"mouseup touchend"},g=window.CSS&&CSS.supports&&CSS.supports("touch-action","none"),v=g&&function(){var t=!1;try{var e=Object.defineProperty({},"passive",{get:function(){t=!0}});window.addEventListener("test",null,e)}catch(t){}return t}(),k=n,y=[],w=[],x=0,S=r.spectrum,C=[],D={},A=n.ownerDocument,E=A.documentElement,U=A.body;function V(t,e){var n=A.createElement("div");return e&&a(n,e),t.appendChild(n),n}function M(t,e){var n=V(t,r.cssClasses.origin),i=V(n,r.cssClasses.handle);return i.setAttribute("data-handle",e),i.setAttribute("tabindex","0"),i.setAttribute("role","slider"),i.setAttribute("aria-orientation",r.ort?"vertical":"horizontal"),0===e?a(i,r.cssClasses.handleLower):e===r.handles-1&&a(i,r.cssClasses.handleUpper),n}function N(t,e){return!!e&&V(t,r.cssClasses.connect)}function I(t,e){return!!r.tooltips[e]&&V(t.firstChild,r.cssClasses.tooltip)}function B(t,e,n){var i=A.createElement("div"),o=[r.cssClasses.valueNormal,r.cssClasses.valueLarge,r.cssClasses.valueSub],s=[r.cssClasses.markerNormal,r.cssClasses.markerLarge,r.cssClasses.markerSub],l=[r.cssClasses.valueHorizontal,r.cssClasses.valueVertical],u=[r.cssClasses.markerHorizontal,r.cssClasses.markerVertical];function c(t,e){var n=e===r.cssClasses.value,i=n?l:u,a=n?o:s;return e+" "+i[r.ort]+" "+a[t]}return a(i,r.cssClasses.pips),a(i,0===r.ort?r.cssClasses.pipsHorizontal:r.cssClasses.pipsVertical),Object.keys(t).forEach(function(o){!function(t,o){o[1]=o[1]&&e?e(o[0],o[1]):o[1];var a=V(i,!1);a.className=c(o[1],r.cssClasses.marker),a.style[r.style]=t+"%",o[1]&&((a=V(i,!1)).className=c(o[1],r.cssClasses.value),a.style[r.style]=t+"%",a.innerText=n.to(o[0]))}(o,t[o])}),i}function R(){var t;f&&((t=f).parentElement.removeChild(t),f=null)}function T(e){R();var n=e.mode,i=e.density||1,o=e.filter||!1,r=e.values||!1,a=e.stepped||!1,s=function(e,n,i){if("range"===e||"steps"===e)return S.xVal;if("count"===e){if(!n)throw new Error("noUiSlider ("+t+"): 'values' required for mode 'count'.");var o,r=100/(n-1),a=0;for(n=[];(o=a++*r)<=100;)n.push(o);e="positions"}return"positions"===e?n.map(function(t){return S.fromStepping(i?S.getStep(t):t)}):"values"===e?i?n.map(function(t){return S.fromStepping(S.getStep(S.toStepping(t)))}):n:void 0}(n,r,a),l=function(t,e,n){var i,o={},r=S.xVal[0],a=S.xVal[S.xVal.length-1],s=!1,l=!1,u=0;return(i=n.slice().sort(function(t,e){return t-e}),n=i.filter(function(t){return!this[t]&&(this[t]=!0)},{}))[0]!==r&&(n.unshift(r),s=!0),n[n.length-1]!==a&&(n.push(a),l=!0),n.forEach(function(i,r){var a,c,d,p,h,f,_,m,b,g=i,v=n[r+1];if("steps"===e&&(a=S.xNumSteps[r]),a||(a=v-g),!1!==g&&void 0!==v)for(a=Math.max(a,1e-7),c=g;c<=v;c=(c+a).toFixed(7)/1){for(_=(h=(p=S.toStepping(c))-u)/t,b=h/(m=Math.round(_)),d=1;d<=m;d+=1)o[(u+d*b).toFixed(5)]=["x",0];f=n.indexOf(c)>-1?1:"steps"===e?2:0,!r&&s&&(f=0),c===v&&l||(o[p.toFixed(5)]=[c,f]),u=p}}),o}(i,n,s),u=e.format||{to:Math.round};return f=k.appendChild(B(l,o,u))}function P(){var t=c.getBoundingClientRect(),e="offset"+["Width","Height"][r.ort];return 0===r.ort?t.width||c[e]:t.height||c[e]}function F(t,e,n,i){var o=function(o){return!k.hasAttribute("disabled")&&(a=k,s=r.cssClasses.tap,(a.classList?!a.classList.contains(s):!new RegExp("\\b"+s+"\\b").test(a.className))&&!!(o=function(t,e,n){var i,o,a=0===t.type.indexOf("touch"),s=0===t.type.indexOf("mouse"),u=0===t.type.indexOf("pointer");if(0===t.type.indexOf("MSPointer")&&(u=!0),a&&r.multitouch){var c=function(t){return t.target===n||n.contains(t.target)};if("touchstart"===t.type){var d=Array.prototype.filter.call(t.touches,c);if(d.length>1)return!1;i=d[0].pageX,o=d[0].pageY}else{var p=Array.prototype.find.call(t.changedTouches,c);if(!p)return!1;i=p.pageX,o=p.pageY}}else if(a){if(t.touches.length>1)return!1;i=t.changedTouches[0].pageX,o=t.changedTouches[0].pageY}return e=e||l(A),(s||u)&&(i=t.clientX+e.x,o=t.clientY+e.y),t.pageOffset=e,t.points=[i,o],t.cursor=s||u,t}(o,i.pageOffset,i.target||e))&&!(t===b.start&&void 0!==o.buttons&&o.buttons>1)&&(!i.hover||!o.buttons)&&(v||o.preventDefault(),o.calcPoint=o.points[r.ort],void n(o,i)));var a,s},a=[];return t.split(" ").forEach(function(t){e.addEventListener(t,o,!!v&&{passive:!0}),a.push([t,o])}),a}function O(t){var e,n,i,o,a,s,u=t-(e=c,n=r.ort,i=e.getBoundingClientRect(),o=e.ownerDocument,a=o.documentElement,s=l(o),/webkit.*Chrome.*Mobile/i.test(navigator.userAgent)&&(s.x=0),n?i.top+s.y-a.clientTop:i.left+s.x-a.clientLeft),d=100*u/P();return r.dir?100-d:d}function L(t,e,n,i){var o=n.slice(),r=[!t,t],a=[t,!t];i=i.slice(),t&&i.reverse(),i.length>1?i.forEach(function(t,n){var i=Q(o,t,o[t]+e,r[n],a[n],!1);!1===i?e=0:(e=i-o[t],o[t]=i)}):r=a=[!0];var s=!1;i.forEach(function(t,i){s=$(t,n[t]+e,r[i],a[i])||s}),s&&i.forEach(function(t){W("update",t),W("slide",t)})}function W(t,e,n){Object.keys(D).forEach(function(i){var o=i.split(".")[0];t===o&&D[i].forEach(function(t){t.call(h,C.map(r.format.to),e,C.slice(),n||!1,y.slice())})})}function j(t,e){"mouseout"===t.type&&"HTML"===t.target.nodeName&&null===t.relatedTarget&&Y(t,e)}function G(t,e){if(-1===navigator.appVersion.indexOf("MSIE 9")&&0===t.buttons&&0!==e.buttonsProperty)return Y(t,e);var n=(r.dir?-1:1)*(t.calcPoint-e.startCalcPoint),i=100*n/e.baseSize;L(n>0,i,e.locations,e.handleNumbers)}function Y(t,n){n.handle&&(s(n.handle,r.cssClasses.active),x-=1),n.listeners.forEach(function(t){E.removeEventListener(t[0],t[1])}),0===x&&(s(k,r.cssClasses.drag),J(),t.cursor&&(U.style.cursor="",U.removeEventListener("selectstart",e))),n.handleNumbers.forEach(function(t){W("change",t),W("set",t),W("end",t)})}function H(t,n){var i;if(1===n.handleNumbers.length){var o=d[n.handleNumbers[0]];if(o.hasAttribute("disabled"))return!1;i=o.children[0],x+=1,a(i,r.cssClasses.active)}t.stopPropagation();var s=[],l=F(b.move,E,G,{target:t.target,handle:i,listeners:s,startCalcPoint:t.calcPoint,baseSize:P(),pageOffset:t.pageOffset,handleNumbers:n.handleNumbers,buttonsProperty:t.buttons,locations:y.slice()}),u=F(b.end,E,Y,{target:t.target,handle:i,listeners:s,handleNumbers:n.handleNumbers}),c=F("mouseout",E,j,{target:t.target,handle:i,listeners:s,handleNumbers:n.handleNumbers});s.push.apply(s,l.concat(u,c)),t.cursor&&(U.style.cursor=getComputedStyle(t.target).cursor,d.length>1&&a(k,r.cssClasses.drag),U.addEventListener("selectstart",e,!1)),n.handleNumbers.forEach(function(t){W("start",t)})}function q(t){t.stopPropagation();var e=O(t.calcPoint),n=function(t){var e=100,n=!1;return d.forEach(function(i,o){if(!i.hasAttribute("disabled")){var r=Math.abs(y[o]-t);r<e&&(n=o,e=r)}}),n}(e);if(!1===n)return!1;r.events.snap||i(k,r.cssClasses.tap,r.animationDuration),$(n,e,!0,!0),J(),W("slide",n,!0),W("update",n,!0),W("change",n,!0),W("set",n,!0),r.events.snap&&H(t,{handleNumbers:[n]})}function K(t){var e=O(t.calcPoint),n=S.getStep(e),i=S.fromStepping(n);Object.keys(D).forEach(function(t){"hover"===t.split(".")[0]&&D[t].forEach(function(t){t.call(h,i)})})}function Q(t,e,n,i,o,a){var s;return d.length>1&&(i&&e>0&&(n=Math.max(n,t[e-1]+r.margin)),o&&e<d.length-1&&(n=Math.min(n,t[e+1]-r.margin))),d.length>1&&r.limit&&(i&&e>0&&(n=Math.min(n,t[e-1]+r.limit)),o&&e<d.length-1&&(n=Math.max(n,t[e+1]-r.limit))),r.padding&&(0===e&&(n=Math.max(n,r.padding)),e===d.length-1&&(n=Math.min(n,100-r.padding))),n=S.getStep(n),s=n,!((n=Math.max(Math.min(s,100),0))===t[e]&&!a)&&n}function X(t){return t+"%"}function J(){w.forEach(function(t){var e=y[t]>50?-1:1,n=3+(d.length+e*t);d[t].childNodes[0].style.zIndex=n})}function $(t,e,n,i){return!1!==(e=Q(y,t,e,n,i,!1))&&(function(t,e){y[t]=e,C[t]=S.fromStepping(e);var n=function(){d[t].style[r.style]=X(e),Z(t),Z(t+1)};window.requestAnimationFrame&&r.useRequestAnimationFrame?window.requestAnimationFrame(n):n()}(t,e),!0)}function Z(t){if(p[t]){var e=0,n=100;0!==t&&(e=y[t-1]),t!==p.length-1&&(n=y[t]),p[t].style[r.style]=X(e),p[t].style[r.styleOposite]=X(100-n)}}function tt(t,e){null!==t&&!1!==t&&("number"==typeof t&&(t=String(t)),!1===(t=r.format.from(t))||isNaN(t)||$(e,S.toStepping(t),!1,!1))}function et(t,e){var n=o(t),a=void 0===y[0];e=void 0===e||!!e,n.forEach(tt),r.animate&&!a&&i(k,r.cssClasses.tap,r.animationDuration),w.forEach(function(t){$(t,y[t],!0,!1)}),J(),w.forEach(function(t){W("update",t),null!==n[t]&&e&&W("set",t)})}function nt(){var t=C.map(r.format.to);return 1===t.length?t[0]:t}function it(t,e){D[t]=D[t]||[],D[t].push(e),"update"===t.split(".")[0]&&d.forEach(function(t,e){W("update",e)})}if(k.noUiSlider)throw new Error("noUiSlider ("+t+"): Slider was already initialized.");return function(t){a(t,r.cssClasses.target),0===r.dir?a(t,r.cssClasses.ltr):a(t,r.cssClasses.rtl),0===r.ort?a(t,r.cssClasses.horizontal):a(t,r.cssClasses.vertical),c=V(t,r.cssClasses.base)}(k),function(t,e){d=[],(p=[]).push(N(e,t[0]));for(var n=0;n<r.handles;n++)d.push(M(e,n)),w[n]=n,p.push(N(e,t[n+1]))}(r.connect,c),h={destroy:function(){for(var t in r.cssClasses)r.cssClasses.hasOwnProperty(t)&&s(k,r.cssClasses[t]);for(;k.firstChild;)k.removeChild(k.firstChild);delete k.noUiSlider},steps:function(){return y.map(function(t,e){var n=S.getNearbySteps(t),i=C[e],o=n.thisStep.step,r=null;!1!==o&&i+o>n.stepAfter.startValue&&(o=n.stepAfter.startValue-i),r=i>n.thisStep.startValue?n.thisStep.step:!1!==n.stepBefore.step&&i-n.stepBefore.highestStep,100===t?o=null:0===t&&(r=null);var a=S.countStepDecimals();return null!==o&&!1!==o&&(o=Number(o.toFixed(a))),null!==r&&!1!==r&&(r=Number(r.toFixed(a))),[r,o]})},on:it,off:function(t){var e=t&&t.split(".")[0],n=e&&t.substring(e.length);Object.keys(D).forEach(function(t){var i=t.split(".")[0],o=t.substring(i.length);e&&e!==i||n&&n!==o||delete D[t]})},get:nt,set:et,reset:function(t){et(r.start,t)},__moveHandles:function(t,e,n){L(t,e,y,n)},options:u,updateOptions:function(t,e){var n=nt(),i=["margin","limit","padding","range","animate","snap","step","format"];i.forEach(function(e){void 0!==t[e]&&(u[e]=t[e])});var o=z(u);i.forEach(function(e){void 0!==t[e]&&(r[e]=o[e])}),S=o.spectrum,r.margin=o.margin,r.limit=o.limit,r.padding=o.padding,r.pips&&T(r.pips),y=[],et(t.start||n,e)},target:k,removePips:R,pips:T},(m=r.events).fixed||d.forEach(function(t,e){F(b.start,t.children[0],H,{handleNumbers:[e]})}),m.tap&&F(b.start,c,q,{}),m.hover&&F(b.move,c,K,{hover:!0}),m.drag&&p.forEach(function(t,e){if(!1!==t&&0!==e&&e!==p.length-1){var n=d[e-1],i=d[e],o=[t];a(t,r.cssClasses.draggable),m.fixed&&(o.push(n.children[0]),o.push(i.children[0])),o.forEach(function(t){F(b.start,t,H,{handles:[n,i],handleNumbers:[e-1,e]})})}}),et(r.start),r.pips&&T(r.pips),r.tooltips&&(_=d.map(I),it("update",function(t,e,n){if(_[e]){var i=t[e];!0!==r.tooltips[e]&&(i=r.tooltips[e].to(n[e])),_[e].innerHTML=i}})),it("update",function(t,e,n,i,o){w.forEach(function(t){var e=d[t],i=Q(y,t,0,!0,!0,!0),a=Q(y,t,100,!0,!0,!0),s=o[t],l=r.ariaFormat.to(n[t]);e.children[0].setAttribute("aria-valuemin",i.toFixed(1)),e.children[0].setAttribute("aria-valuemax",a.toFixed(1)),e.children[0].setAttribute("aria-valuenow",s.toFixed(1)),e.children[0].setAttribute("aria-valuetext",l)})}),h}return{version:t,create:function(e,n){if(!e||!e.nodeName)throw new Error("noUiSlider ("+t+"): create requires a single element, got: "+e);var i=z(n),o=O(e,i,n);return e.noUiSlider=o,o}}},"object"==typeof n?e.exports=i():window.noUiSlider=i()},472:function(t,e,n){var i=function(t,e,n,i){t.addEventListener(e,n,!!i)},o=function(t,e,n,i){t.removeEventListener(e,n,!!i)},r=function(t,e){return-1!==(" "+t.className+" ").indexOf(" "+e+" ")},a=function(t,e){r(t,e)||(t.className=""===t.className?e:t.className+" "+e)},s=function(t,e){var n;t.className=(n=(" "+t.className+" ").replace(" "+e+" "," ")).trim?n.trim():n.replace(/^\s+|\s+$/g,"")},l=function(t){return/Array/.test(Object.prototype.toString.call(t))},u=function(t){return/Date/.test(Object.prototype.toString.call(t))&&!isNaN(t.getTime())},c=function(t){var e=t.getDay();return 0===e||6===e},d=function(t){
// solution lifted from date.js (MIT license): https://github.com/datejs/Datejs
return t%4==0&&t%100!=0||t%400==0},p=function(t,e){return[31,d(t)?29:28,31,30,31,30,31,31,30,31,30,31][e]},h=function(t){u(t)&&t.setHours(0,0,0,0)},f=function(t,e){return t.getTime()===e.getTime()},_=function(t,e,n){var i,o;for(i in e)(o=void 0!==t[i])&&"object"==typeof e[i]&&null!==e[i]&&void 0===e[i].nodeName?u(e[i])?n&&(t[i]=new Date(e[i].getTime())):l(e[i])?n&&(t[i]=e[i].slice(0)):t[i]=_({},e[i],n):!n&&o||(t[i]=e[i]);return t},m=function(t,e,n){var i;document.createEvent?((i=document.createEvent("HTMLEvents")).initEvent(e,!0,!1),i=_(i,n),t.dispatchEvent(i)):document.createEventObject&&(i=document.createEventObject(),i=_(i,n),t.fireEvent("on"+e,i))},b=function(t){return t.month<0&&(t.year-=Math.ceil(Math.abs(t.month)/12),t.month+=12),t.month>11&&(t.year+=Math.floor(Math.abs(t.month)/12),t.month-=12),t},g={field:null,bound:void 0,ariaLabel:"Use the arrow keys to pick a date",position:"bottom left",reposition:!0,format:"YYYY-MM-DD",toString:null,parse:null,defaultDate:null,setDefaultDate:!1,firstDay:0,formatStrict:!1,minDate:null,maxDate:null,yearRange:10,showWeekNumber:!1,pickWholeWeek:!1,minYear:0,maxYear:9999,minMonth:void 0,maxMonth:void 0,startRange:null,endRange:null,isRTL:!1,yearSuffix:"",showMonthAfterYear:!1,showDaysInNextAndPreviousMonths:!1,enableSelectionDaysInNextAndPreviousMonths:!1,numberOfMonths:1,mainCalendar:"left",container:void 0,blurFieldOnSelect:!0,i18n:{previousMonth:"Previous Month",nextMonth:"Next Month",months:["January","February","March","April","May","June","July","August","September","October","November","December"],weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],weekdaysShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"]},theme:null,events:[],onSelect:null,onOpen:null,onClose:null,onDraw:null,keyboardInput:!0},v=function(t,e,n){for(e+=t.firstDay;e>=7;)e-=7;return n?t.i18n.weekdaysShort[e]:t.i18n.weekdays[e]},k=function(t){var e=[],n="false";if(t.isEmpty){if(!t.showDaysInNextAndPreviousMonths)return'<td class="is-empty"></td>';e.push("is-outside-current-month"),t.enableSelectionDaysInNextAndPreviousMonths||e.push("is-selection-disabled")}return t.isDisabled&&e.push("is-disabled"),t.isToday&&e.push("is-today"),t.isSelected&&(e.push("is-selected"),n="true"),t.hasEvent&&e.push("has-event"),t.isInRange&&e.push("is-inrange"),t.isStartRange&&e.push("is-startrange"),t.isEndRange&&e.push("is-endrange"),'<td data-day="'+t.day+'" class="'+e.join(" ")+'" aria-selected="'+n+'"><button class="pika-button pika-day" type="button" data-pika-year="'+t.year+'" data-pika-month="'+t.month+'" data-pika-day="'+t.day+'">'+t.day+"</button></td>"},y=function(t,e,n){var i=new Date(n,e,t),o=function(t){t.setHours(0,0,0,0);var e=t.getDate(),n=t.getDay(),i=function(t){return(t+7-1)%7};t.setDate(e+3-i(n));var o=new Date(t.getFullYear(),0,4),r=(t.getTime()-o.getTime())/864e5;return 1+Math.round((r-3+i(o.getDay()))/7)}(i);return'<td class="pika-week">'+o+"</td>"},w=function(t,e,n,i){return'<tr class="pika-row'+(n?" pick-whole-week":"")+(i?" is-selected":"")+'">'+(e?t.reverse():t).join("")+"</tr>"},x=function(t,e,n,i,o,r){var a,s,u,c,d,p=t._o,h=n===p.minYear,f=n===p.maxYear,_='<div id="'+r+'" class="pika-title" role="heading" aria-live="assertive">',m=!0,b=!0;for(u=[],a=0;a<12;a++)u.push('<option value="'+(n===o?a-e:12+a-e)+'"'+(a===i?' selected="selected"':"")+(h&&a<p.minMonth||f&&a>p.maxMonth?' disabled="disabled"':"")+">"+p.i18n.months[a]+"</option>");for(c='<div class="pika-label">'+p.i18n.months[i]+'<select class="pika-select pika-select-month" tabindex="-1">'+u.join("")+"</select></div>",l(p.yearRange)?(a=p.yearRange[0],s=p.yearRange[1]+1):(a=n-p.yearRange,s=1+n+p.yearRange),u=[];a<s&&a<=p.maxYear;a++)a>=p.minYear&&u.push('<option value="'+a+'"'+(a===n?' selected="selected"':"")+">"+a+"</option>");return d='<div class="pika-label">'+n+p.yearSuffix+'<select class="pika-select pika-select-year" tabindex="-1">'+u.join("")+"</select></div>",p.showMonthAfterYear?_+=d+c:_+=c+d,h&&(0===i||p.minMonth>=i)&&(m=!1),f&&(11===i||p.maxMonth<=i)&&(b=!1),0===e&&(_+='<button class="pika-prev'+(m?"":" is-disabled")+'" type="button">'+p.i18n.previousMonth+"</button>"),e===t._o.numberOfMonths-1&&(_+='<button class="pika-next'+(b?"":" is-disabled")+'" type="button">'+p.i18n.nextMonth+"</button>"),_+="</div>"},S=function(t,e,n){return'<table cellpadding="0" cellspacing="0" class="pika-table" role="grid" aria-labelledby="'+n+'">'+function(t){var e,n=[];for(t.showWeekNumber&&n.push("<th></th>"),e=0;e<7;e++)n.push('<th scope="col"><abbr title="'+v(t,e)+'">'+v(t,e,!0)+"</abbr></th>");return"<thead><tr>"+(t.isRTL?n.reverse():n).join("")+"</tr></thead>"}(t)+"<tbody>"+e.join("")+"</tbody></table>"},C=function(t){var e=this,n=e.config(t);e._onMouseDown=function(t){if(e._v){var i=(t=t||window.event).target||t.srcElement;if(i)if(r(i,"is-disabled")||(!r(i,"pika-button")||r(i,"is-empty")||r(i.parentNode,"is-disabled")?r(i,"pika-prev")?e.prevMonth():r(i,"pika-next")&&e.nextMonth():(e.setDate(new Date(i.getAttribute("data-pika-year"),i.getAttribute("data-pika-month"),i.getAttribute("data-pika-day"))),n.bound&&setTimeout(function(){e.hide(),n.blurFieldOnSelect&&n.field&&n.field.blur()},100))),r(i,"pika-select"))e._c=!0;else{if(!t.preventDefault)return t.returnValue=!1,!1;t.preventDefault()}}},e._onChange=function(t){var n=(t=t||window.event).target||t.srcElement;n&&(r(n,"pika-select-month")?e.gotoMonth(n.value):r(n,"pika-select-year")&&e.gotoYear(n.value))},e._onKeyChange=function(t){if(t=t||window.event,e.isVisible())switch(t.keyCode){case 13:case 27:n.field&&n.field.blur();break;case 37:e.adjustDate("subtract",1);break;case 38:e.adjustDate("subtract",7);break;case 39:e.adjustDate("add",1);break;case 40:e.adjustDate("add",7);break;case 8:case 46:e.setDate(null)}},e._parseFieldValue=function(){return n.parse?n.parse(n.field.value,n.format):new Date(Date.parse(n.field.value))},e._onInputChange=function(t){var n;t.firedBy!==e&&(n=e._parseFieldValue(),u(n)&&e.setDate(n),e._v||e.show())},e._onInputFocus=function(){e.show()},e._onInputClick=function(){e.show()},e._onInputBlur=function(){var t=document.activeElement;do{if(r(t,"pika-single"))return}while(t=t.parentNode);e._c||(e._b=setTimeout(function(){e.hide()},50)),e._c=!1},e._onClick=function(t){var i=(t=t||window.event).target||t.srcElement,o=i;if(i){do{if(r(o,"pika-single")||o===n.trigger)return}while(o=o.parentNode);e._v&&i!==n.trigger&&o!==n.trigger&&e.hide()}},e.el=document.createElement("div"),e.el.className="pika-single"+(n.isRTL?" is-rtl":"")+(n.theme?" "+n.theme:""),i(e.el,"mousedown",e._onMouseDown,!0),i(e.el,"touchend",e._onMouseDown,!0),i(e.el,"change",e._onChange),n.keyboardInput&&i(document,"keydown",e._onKeyChange),n.field&&(n.container?n.container.appendChild(e.el):n.bound?document.body.appendChild(e.el):n.field.parentNode.insertBefore(e.el,n.field.nextSibling),i(n.field,"change",e._onInputChange),n.defaultDate||(n.defaultDate=e._parseFieldValue(),n.setDefaultDate=!0));var o=n.defaultDate;u(o)?n.setDefaultDate?e.setDate(o,!0):e.gotoDate(o):e.gotoDate(new Date),n.bound?(this.hide(),e.el.className+=" is-bound",i(n.trigger,"click",e._onInputClick),i(n.trigger,"focus",e._onInputFocus),i(n.trigger,"blur",e._onInputBlur)):this.show()};C.prototype={config:function(t){this._o||(this._o=_({},g,!0));var e=_(this._o,t,!0);e.isRTL=!!e.isRTL,e.field=e.field&&e.field.nodeName?e.field:null,e.theme="string"==typeof e.theme&&e.theme?e.theme:null,e.bound=!!(void 0!==e.bound?e.field&&e.bound:e.field),e.trigger=e.trigger&&e.trigger.nodeName?e.trigger:e.field,e.disableWeekends=!!e.disableWeekends,e.disableDayFn="function"==typeof e.disableDayFn?e.disableDayFn:null;var n=parseInt(e.numberOfMonths,10)||1;if(e.numberOfMonths=n>4?4:n,u(e.minDate)||(e.minDate=!1),u(e.maxDate)||(e.maxDate=!1),e.minDate&&e.maxDate&&e.maxDate<e.minDate&&(e.maxDate=e.minDate=!1),e.minDate&&this.setMinDate(e.minDate),e.maxDate&&this.setMaxDate(e.maxDate),l(e.yearRange)){var i=(new Date).getFullYear()-10;e.yearRange[0]=parseInt(e.yearRange[0],10)||i,e.yearRange[1]=parseInt(e.yearRange[1],10)||i}else e.yearRange=Math.abs(parseInt(e.yearRange,10))||g.yearRange,e.yearRange>100&&(e.yearRange=100);return e},toString:function(t){return t=t||this._o.format,u(this._d)?this._o.toString?this._o.toString(this._d,t):this._d.toDateString():""},getDate:function(){return u(this._d)?new Date(this._d.getTime()):null},setDate:function(t,e){if(!t)return this._d=null,this._o.field&&(this._o.field.value="",m(this._o.field,"change",{firedBy:this})),this.draw();if("string"==typeof t&&(t=new Date(Date.parse(t))),u(t)){var n=this._o.minDate,i=this._o.maxDate;u(n)&&t<n?t=n:u(i)&&t>i&&(t=i),this._d=new Date(t.getTime()),h(this._d),this.gotoDate(this._d),this._o.field&&(this._o.field.value=this.toString(),m(this._o.field,"change",{firedBy:this})),e||"function"!=typeof this._o.onSelect||this._o.onSelect.call(this,this.getDate())}},clear:function(){this.setDate(null)},gotoDate:function(t){var e=!0;if(u(t)){if(this.calendars){var n=new Date(this.calendars[0].year,this.calendars[0].month,1),i=new Date(this.calendars[this.calendars.length-1].year,this.calendars[this.calendars.length-1].month,1),o=t.getTime();i.setMonth(i.getMonth()+1),i.setDate(i.getDate()-1),e=o<n.getTime()||i.getTime()<o}e&&(this.calendars=[{month:t.getMonth(),year:t.getFullYear()}],"right"===this._o.mainCalendar&&(this.calendars[0].month+=1-this._o.numberOfMonths)),this.adjustCalendars()}},adjustDate:function(t,e){var n,i=this.getDate()||new Date,o=24*parseInt(e)*60*60*1e3;"add"===t?n=new Date(i.valueOf()+o):"subtract"===t&&(n=new Date(i.valueOf()-o)),this.setDate(n)},adjustCalendars:function(){this.calendars[0]=b(this.calendars[0]);for(var t=1;t<this._o.numberOfMonths;t++)this.calendars[t]=b({month:this.calendars[0].month+t,year:this.calendars[0].year});this.draw()},gotoToday:function(){this.gotoDate(new Date)},gotoMonth:function(t){isNaN(t)||(this.calendars[0].month=parseInt(t,10),this.adjustCalendars())},nextMonth:function(){this.calendars[0].month++,this.adjustCalendars()},prevMonth:function(){this.calendars[0].month--,this.adjustCalendars()},gotoYear:function(t){isNaN(t)||(this.calendars[0].year=parseInt(t,10),this.adjustCalendars())},setMinDate:function(t){t instanceof Date?(h(t),this._o.minDate=t,this._o.minYear=t.getFullYear(),this._o.minMonth=t.getMonth()):(this._o.minDate=g.minDate,this._o.minYear=g.minYear,this._o.minMonth=g.minMonth,this._o.startRange=g.startRange),this.draw()},setMaxDate:function(t){t instanceof Date?(h(t),this._o.maxDate=t,this._o.maxYear=t.getFullYear(),this._o.maxMonth=t.getMonth()):(this._o.maxDate=g.maxDate,this._o.maxYear=g.maxYear,this._o.maxMonth=g.maxMonth,this._o.endRange=g.endRange),this.draw()},setStartRange:function(t){this._o.startRange=t},setEndRange:function(t){this._o.endRange=t},draw:function(t){if(this._v||t){var e,n=this._o,i=n.minYear,o=n.maxYear,r=n.minMonth,a=n.maxMonth,s="";this._y<=i&&(this._y=i,!isNaN(r)&&this._m<r&&(this._m=r)),this._y>=o&&(this._y=o,!isNaN(a)&&this._m>a&&(this._m=a));for(var l=0;l<n.numberOfMonths;l++)e="pika-title-"+Math.random().toString(36).replace(/[^a-z]+/g,"").substr(0,2),s+='<div class="pika-lendar">'+x(this,l,this.calendars[l].year,this.calendars[l].month,this.calendars[0].year,e)+this.render(this.calendars[l].year,this.calendars[l].month,e)+"</div>";this.el.innerHTML=s,n.bound&&"hidden"!==n.field.type&&setTimeout(function(){n.trigger.focus()},1),"function"==typeof this._o.onDraw&&this._o.onDraw(this),n.bound&&n.field.setAttribute("aria-label",n.ariaLabel)}},adjustPosition:function(){var t,e,n,i,o,r,l,u,c,d,p,h;if(!this._o.container){if(this.el.style.position="absolute",t=this._o.trigger,e=t,n=this.el.offsetWidth,i=this.el.offsetHeight,o=window.innerWidth||document.documentElement.clientWidth,r=window.innerHeight||document.documentElement.clientHeight,l=window.pageYOffset||document.body.scrollTop||document.documentElement.scrollTop,p=!0,h=!0,"function"==typeof t.getBoundingClientRect)d=t.getBoundingClientRect(),u=d.left+window.pageXOffset,c=d.bottom+window.pageYOffset;else for(u=e.offsetLeft,c=e.offsetTop+e.offsetHeight;e=e.offsetParent;)u+=e.offsetLeft,c+=e.offsetTop;(this._o.reposition&&u+n>o||this._o.position.indexOf("right")>-1&&u-n+t.offsetWidth>0)&&(u=u-n+t.offsetWidth,p=!1),(this._o.reposition&&c+i>r+l||this._o.position.indexOf("top")>-1&&c-i-t.offsetHeight>0)&&(c=c-i-t.offsetHeight,h=!1),this.el.style.left=u+"px",this.el.style.top=c+"px",a(this.el,p?"left-aligned":"right-aligned"),a(this.el,h?"bottom-aligned":"top-aligned"),s(this.el,p?"right-aligned":"left-aligned"),s(this.el,h?"top-aligned":"bottom-aligned")}},render:function(t,e,n){var i=this._o,o=new Date,r=p(t,e),a=new Date(t,e,1).getDay(),s=[],l=[];h(o),i.firstDay>0&&(a-=i.firstDay)<0&&(a+=7);for(var d=0===e?11:e-1,_=11===e?0:e+1,m=0===e?t-1:t,b=11===e?t+1:t,g=p(m,d),v=r+a,x=v;x>7;)x-=7;v+=7-x;for(var C=!1,D=0,A=0;D<v;D++){var E=new Date(t,e,D-a+1),U=!!u(this._d)&&f(E,this._d),V=f(E,o),M=-1!==i.events.indexOf(E.toDateString()),N=D<a||D>=r+a,I=D-a+1,B=e,R=t,T=i.startRange&&f(i.startRange,E),P=i.endRange&&f(i.endRange,E),F=i.startRange&&i.endRange&&i.startRange<E&&E<i.endRange,z=i.minDate&&E<i.minDate||i.maxDate&&E>i.maxDate||i.disableWeekends&&c(E)||i.disableDayFn&&i.disableDayFn(E);N&&(D<a?(I=g+I,B=d,R=m):(I-=r,B=_,R=b));var O={day:I,month:B,year:R,hasEvent:M,isSelected:U,isToday:V,isDisabled:z,isEmpty:N,isStartRange:T,isEndRange:P,isInRange:F,showDaysInNextAndPreviousMonths:i.showDaysInNextAndPreviousMonths,enableSelectionDaysInNextAndPreviousMonths:i.enableSelectionDaysInNextAndPreviousMonths};i.pickWholeWeek&&U&&(C=!0),l.push(k(O)),7==++A&&(i.showWeekNumber&&l.unshift(y(D-a,e,t)),s.push(w(l,i.isRTL,i.pickWholeWeek,C)),l=[],A=0,C=!1)}return S(i,s,n)},isVisible:function(){return this._v},show:function(){this.isVisible()||(this._v=!0,this.draw(),s(this.el,"is-hidden"),this._o.bound&&(i(document,"click",this._onClick),this.adjustPosition()),"function"==typeof this._o.onOpen&&this._o.onOpen.call(this))},hide:function(){var t=this._v;!1!==t&&(this._o.bound&&o(document,"click",this._onClick),this.el.style.position="static",this.el.style.left="auto",this.el.style.top="auto",a(this.el,"is-hidden"),this._v=!1,void 0!==t&&"function"==typeof this._o.onClose&&this._o.onClose.call(this))},destroy:function(){var t=this._o;this.hide(),o(this.el,"mousedown",this._onMouseDown,!0),o(this.el,"touchend",this._onMouseDown,!0),o(this.el,"change",this._onChange),t.keyboardInput&&o(document,"keydown",this._onKeyChange),t.field&&(o(t.field,"change",this._onInputChange),t.bound&&(o(t.trigger,"click",this._onInputClick),o(t.trigger,"focus",this._onInputFocus),o(t.trigger,"blur",this._onInputBlur))),this.el.parentNode&&this.el.parentNode.removeChild(this.el)}},e.exports=C}})}(this);
//# sourceMappingURL=bokeh-widgets.min.js.map