/*!
 * Copyright (c) 2012 - 2018, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
!function(t,e){var o,s,r,a,l;t.Bokeh=(o=[function(t,e,i){var n=t(153),r=t(32);i.overrides={};var o=r.clone(n);i.Models=function(t){var e=i.overrides[t]||o[t];if(null==e)throw new Error("Model '"+t+"' does not exist. This could be due to a widget\n                     or a custom model not being registered before first usage.");return e},i.Models.register=function(t,e){i.overrides[t]=e},i.Models.unregister=function(t){delete i.overrides[t]},i.Models.register_models=function(t,e,i){if(void 0===e&&(e=!1),null!=t)for(var n in t){var r=t[n];e||!o.hasOwnProperty(n)?o[n]=r:null!=i?i(n):console.warn("Model '"+n+"' was already registered")}},i.register_models=i.Models.register_models,i.Models.registered_names=function(){return Object.keys(o)},i.index={}},function(t,e,o){var s=t(336),a=t(14),l=t(52),h=t(282),u=t(283),c=t(2);o.DEFAULT_SERVER_WEBSOCKET_URL="ws://localhost:5006/ws",o.DEFAULT_SESSION_ID="default";var _=0,p=function(){function t(t,e,i,n,r){void 0===t&&(t=o.DEFAULT_SERVER_WEBSOCKET_URL),void 0===e&&(e=o.DEFAULT_SESSION_ID),void 0===i&&(i=null),void 0===n&&(n=null),void 0===r&&(r=null),this.url=t,this.id=e,this.args_string=i,this._on_have_session_hook=n,this._on_closed_permanently_hook=r,this._number=_++,this.socket=null,this.session=null,this.closed_permanently=!1,this._current_handler=null,this._pending_ack=null,this._pending_replies={},this._receiver=new u.Receiver,a.logger.debug("Creating websocket "+this._number+" to '"+this.url+"' session '"+this.id+"'")}return t.prototype.connect=function(){var i=this;if(this.closed_permanently)return s.Promise.reject(new Error("Cannot connect() a closed ClientConnection"));if(null!=this.socket)return s.Promise.reject(new Error("Already connected"));this._pending_replies={},this._current_handler=null;try{var t=this.url+"?bokeh-protocol-version=1.0&bokeh-session-id="+this.id;return null!=this.args_string&&0<this.args_string.length&&(t+="&"+this.args_string),this.socket=new WebSocket(t),new s.Promise(function(t,e){i.socket.binaryType="arraybuffer",i.socket.onopen=function(){return i._on_open(t,e)},i.socket.onmessage=function(t){return i._on_message(t)},i.socket.onclose=function(t){return i._on_close(t)},i.socket.onerror=function(){return i._on_error(e)}})}catch(t){return a.logger.error("websocket creation failed to url: "+this.url),a.logger.error(" - "+t),s.Promise.reject(t)}},t.prototype.close=function(){this.closed_permanently||(a.logger.debug("Permanently closing websocket connection "+this._number),this.closed_permanently=!0,null!=this.socket&&this.socket.close(1e3,"close method called on ClientConnection "+this._number),this.session._connection_closed(),null!=this._on_closed_permanently_hook&&(this._on_closed_permanently_hook(),this._on_closed_permanently_hook=null))},t.prototype._schedule_reconnect=function(t){var e=this;setTimeout(function(){e.closed_permanently||a.logger.info("Websocket connection "+e._number+" disconnected, will not attempt to reconnect")},t)},t.prototype.send=function(t){if(null==this.socket)throw new Error("not connected so cannot send "+t);t.send(this.socket)},t.prototype.send_with_reply=function(i){var n=this,t=new s.Promise(function(t,e){n._pending_replies[i.msgid()]=[t,e],n.send(i)});return t.then(function(t){if("ERROR"===t.msgtype())throw new Error("Error reply "+t.content.text);return t},function(t){throw t})},t.prototype._pull_doc_json=function(){var t=h.Message.create("PULL-DOC-REQ",{}),e=this.send_with_reply(t);return e.then(function(t){if(!("doc"in t.content))throw new Error("No 'doc' field in PULL-DOC-REPLY");return t.content.doc},function(t){throw t})},t.prototype._repull_session_doc=function(){var r=this;null==this.session?a.logger.debug("Pulling session for first time"):a.logger.debug("Repulling session"),this._pull_doc_json().then(function(t){if(null==r.session)if(r.closed_permanently)a.logger.debug("Got new document after connection was already closed");else{var e=l.Document.from_json(t),i=l.Document._compute_patch_since_json(t,e);if(0<i.events.length){a.logger.debug("Sending "+i.events.length+" changes from model construction back to server");var n=h.Message.create("PATCH-DOC",{},i);r.send(n)}r.session=new c.ClientSession(r,e,r.id),a.logger.debug("Created a new session from new pulled doc"),null!=r._on_have_session_hook&&(r._on_have_session_hook(r.session),r._on_have_session_hook=null)}else r.session.document.replace_with_json(t),a.logger.debug("Updated existing session with new pulled doc")},function(t){throw t}).catch(function(t){null!=console.trace&&console.trace(t),a.logger.error("Failed to repull session "+t)})},t.prototype._on_open=function(t,e){var i=this;a.logger.info("Websocket connection "+this._number+" is now open"),this._pending_ack=[t,e],this._current_handler=function(t){i._awaiting_ack_handler(t)}},t.prototype._on_message=function(t){null==this._current_handler&&a.logger.error("Got a message with no current handler set");try{this._receiver.consume(t.data)}catch(t){this._close_bad_protocol(t.toString())}if(null!=this._receiver.message){var e=this._receiver.message,i=e.problem();null!=i&&this._close_bad_protocol(i),this._current_handler(e)}},t.prototype._on_close=function(t){var i=this;a.logger.info("Lost websocket "+this._number+" connection, "+t.code+" ("+t.reason+")"),(this.socket=null)!=this._pending_ack&&(this._pending_ack[1](new Error("Lost websocket connection, "+t.code+" ("+t.reason+")")),this._pending_ack=null);for(var e=function(){for(var t in i._pending_replies){var e=i._pending_replies[t];return delete i._pending_replies[t],e}return null},n=e();null!=n;)n[1]("Disconnected"),n=e();this.closed_permanently||this._schedule_reconnect(2e3)},t.prototype._on_error=function(t){a.logger.debug("Websocket error on socket "+this._number),t(new Error("Could not open websocket"))},t.prototype._close_bad_protocol=function(t){a.logger.error("Closing connection: "+t),null!=this.socket&&this.socket.close(1002,t)},t.prototype._awaiting_ack_handler=function(t){var e=this;"ACK"===t.msgtype()?(this._current_handler=function(t){return e._steady_state_handler(t)},this._repull_session_doc(),null!=this._pending_ack&&(this._pending_ack[0](this),this._pending_ack=null)):this._close_bad_protocol("First message was not an ACK")},t.prototype._steady_state_handler=function(t){if(t.reqid()in this._pending_replies){var e=this._pending_replies[t.reqid()];delete this._pending_replies[t.reqid()],e[0](t)}else this.session.handle(t)},t}();o.ClientConnection=p,o.pull_session=function(i,n,r){return new s.Promise(function(t,e){return new p(i,n,r,function(e){try{t(e)}catch(t){throw a.logger.error("Promise handler threw an error, closing session "+t),e.close(),t}},function(){e(new Error("Connection was closed before we successfully pulled a session"))}).connect().then(function(t){},function(t){throw a.logger.error("Failed to connect to Bokeh server "+t),t})})}},function(t,e,i){var n=t(14),r=t(52),o=t(282),s=function(){function t(t,e,i){var n=this;this._connection=t,this.document=e,this.id=i,this._document_listener=function(t){return n._document_changed(t)},this.document.on_change(this._document_listener),this.event_manager=this.document.event_manager,this.event_manager.session=this}return t.prototype.handle=function(t){var e=t.msgtype();"PATCH-DOC"===e?this._handle_patch(t):"OK"===e?this._handle_ok(t):"ERROR"===e?this._handle_error(t):n.logger.debug("Doing nothing with message "+t.msgtype())},t.prototype.close=function(){this._connection.close()},t.prototype.send_event=function(t){var e=o.Message.create("EVENT",{},JSON.stringify(t));this._connection.send(e)},t.prototype._connection_closed=function(){this.document.remove_on_change(this._document_listener)},t.prototype.request_server_info=function(){var t=o.Message.create("SERVER-INFO-REQ",{}),e=this._connection.send_with_reply(t);return e.then(function(t){return t.content})},t.prototype.force_roundtrip=function(){return this.request_server_info().then(function(t){})},t.prototype._document_changed=function(t){if(t.setter_id!==this.id&&(!(t instanceof r.ModelChangedEvent)||t.attr in t.model.serializable_attributes())){var e=o.Message.create("PATCH-DOC",{},this.document.create_json_patch([t]));this._connection.send(e)}},t.prototype._handle_patch=function(t){this.document.apply_json_patch(t.content,t.buffers,this.id)},t.prototype._handle_ok=function(t){n.logger.trace("Unhandled OK reply to "+t.reqid())},t.prototype._handle_error=function(t){n.logger.error("Unhandled ERROR reply to "+t.reqid()+": "+t.content.text)},t}();i.ClientSession=s},function(t,e,i){var n=t(391),r=t(14),o=t(32),s={};function a(e){return function(t){t.prototype.event_name=e,s[e]=t}}i.register_event_class=a,i.register_with_event=function(t){for(var e=[],i=1;i<arguments.length;i++)e[i-1]=arguments[i];var n=t.prototype.applicable_models.concat(e);t.prototype.applicable_models=n};var l=function(){function t(t){void 0===t&&(t={}),this.model_id=null,(this._options=t).model_id&&(this.model_id=t.model_id)}return t.prototype.set_model_id=function(t){return this._options.model_id=t,this.model_id=t,this},t.prototype.is_applicable_to=function(e){return this.applicable_models.some(function(t){return e instanceof t})},t.event_class=function(t){if(t.type)return s[t.type];r.logger.warn("BokehEvent.event_class required events with a string type attribute")},t.prototype.toJSON=function(){return{event_name:this.event_name,event_values:o.clone(this._options)}},t.prototype._customize_event=function(t){return this},t}();(i.BokehEvent=l).prototype.applicable_models=[];var h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([a("button_click")],e)}(l);i.ButtonClick=h;var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(l),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([a("lodstart")],e)}(i.UIEvent=u);i.LODStart=c;var _=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([a("lodend")],e)}(u);i.LODEnd=_;var p=function(i){function t(t){var e=i.call(this,t)||this;return e.geometry=t.geometry,e.final=t.final,e}return n.__extends(t,i),t=n.__decorate([a("selectiongeometry")],t)}(u);i.SelectionGeometry=p;var d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([a("reset")],e)}(u);i.Reset=d;var f=function(i){function t(t){var e=i.call(this,t)||this;return e.sx=t.sx,e.sy=t.sy,e.x=null,e.y=null,e}return n.__extends(t,i),t.from_event=function(t,e){return void 0===e&&(e=null),new this({sx:t.sx,sy:t.sy,model_id:e})},t.prototype._customize_event=function(t){var e=t.plot_canvas.frame.xscales.default,i=t.plot_canvas.frame.yscales.default;return this.x=e.invert(this.sx),this.y=i.invert(this.sy),this._options.x=this.x,this._options.y=this.y,this},t}(u),v=function(i){function t(t){void 0===t&&(t={});var e=i.call(this,t)||this;return e.delta_x=t.delta_x,e.delta_y=t.delta_y,e}return n.__extends(t,i),t.from_event=function(t,e){return void 0===e&&(e=null),new this({sx:t.sx,sy:t.sy,delta_x:t.deltaX,delta_y:t.deltaY,direction:t.direction,model_id:e})},t=n.__decorate([a("pan")],t)}(i.PointEvent=f);i.Pan=v;var m=function(i){function t(t){void 0===t&&(t={});var e=i.call(this,t)||this;return e.scale=t.scale,e}return n.__extends(t,i),t.from_event=function(t,e){return void 0===e&&(e=null),new this({sx:t.sx,sy:t.sy,scale:t.scale,model_id:e})},t=n.__decorate([a("pinch")],t)}(f);i.Pinch=m;var g=function(i){function t(t){void 0===t&&(t={});var e=i.call(this,t)||this;return e.delta=t.delta,e}return n.__extends(t,i),t.from_event=function(t,e){return void 0===e&&(e=null),new this({sx:t.sx,sy:t.sy,delta:t.delta,model_id:e})},t=n.__decorate([a("wheel")],t)}(f);i.MouseWheel=g;var y=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([a("mousemove")],e)}(f);i.MouseMove=y;var b=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([a("mouseenter")],e)}(f);i.MouseEnter=b;var x=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([a("mouseleave")],e)}(f);i.MouseLeave=x;var w=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([a("tap")],e)}(f);i.Tap=w;var k=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([a("doubletap")],e)}(f);i.DoubleTap=k;var S=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([a("press")],e)}(f);i.Press=S;var C=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([a("panstart")],e)}(f);i.PanStart=C;var T=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([a("panend")],e)}(f);i.PanEnd=T;var A=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([a("pinchstart")],e)}(f);i.PinchStart=A;var E=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e=n.__decorate([a("pinchend")],e)}(f);i.PinchEnd=E},function(t,e,i){var g=t(391),y=t(21);i.build_views=function(e,t,i,n){void 0===n&&(n=function(t){return t.default_view});for(var r=y.difference(Object.keys(e),t.map(function(t){return t.id})),o=0,s=r;o<s.length;o++){var a=s[o];e[a].remove(),delete e[a]}for(var l=[],h=t.filter(function(t){return null==e[t.id]}),u=0,c=h;u<c.length;u++){var _=c[u],p=n(_),d=g.__assign({},i,{model:_,connect_signals:!1}),f=new p(d);e[_.id]=f,l.push(f)}for(var v=0,m=l;v<m.length;v++){var f=m[v];f.connect_signals()}return l},i.remove_views=function(t){for(var e in t)t[e].remove(),delete t[e]}},function(t,e,i){var n,y=t(44),r=function(g){return function(t){void 0===t&&(t={});for(var e=[],i=1;i<arguments.length;i++)e[i-1]=arguments[i];var n=document.createElement(g);for(var r in t){var o=t[r];if(null!=o&&(!y.isBoolean(o)||o))if("class"===r&&y.isArray(o))for(var s=0,a=o;s<a.length;s++){var l=a[s];null!=l&&n.classList.add(l)}else if("style"===r&&y.isPlainObject(o))for(var h in o)n.style[h]=o[h];else if("data"===r&&y.isPlainObject(o))for(var u in o)n.dataset[u]=o[u];else n.setAttribute(r,o)}function c(t){if(t instanceof HTMLElement)n.appendChild(t);else if(y.isString(t))n.appendChild(document.createTextNode(t));else if(null!=t&&!1!==t)throw new Error("expected an HTMLElement, string, false or null, got "+JSON.stringify(t))}for(var _=0,p=e;_<p.length;_++){var d=p[_];if(y.isArray(d))for(var f=0,v=d;f<v.length;f++){var m=v[f];c(m)}else c(d)}return n}};function o(t,e){var i=Element.prototype,n=i.matches||i.webkitMatchesSelector||i.mozMatchesSelector||i.msMatchesSelector;return n.call(t,e)}i.createElement=function(t,e){for(var i=[],n=2;n<arguments.length;n++)i[n-2]=arguments[n];return r(t).apply(void 0,[e].concat(i))},i.div=r("div"),i.span=r("span"),i.link=r("link"),i.style=r("style"),i.a=r("a"),i.p=r("p"),i.i=r("i"),i.pre=r("pre"),i.button=r("button"),i.label=r("label"),i.input=r("input"),i.select=r("select"),i.option=r("option"),i.optgroup=r("optgroup"),i.textarea=r("textarea"),i.canvas=r("canvas"),i.ul=r("ul"),i.ol=r("ol"),i.li=r("li"),i.nbsp=document.createTextNode(" "),i.removeElement=function(t){var e=t.parentNode;null!=e&&e.removeChild(t)},i.replaceWith=function(t,e){var i=t.parentNode;null!=i&&i.replaceChild(e,t)},i.prepend=function(t){for(var e=[],i=1;i<arguments.length;i++)e[i-1]=arguments[i];for(var n=t.firstChild,r=0,o=e;r<o.length;r++){var s=o[r];t.insertBefore(s,n)}},i.empty=function(t){for(var e;e=t.firstChild;)t.removeChild(e)},i.show=function(t){t.style.display=""},i.hide=function(t){t.style.display="none"},i.position=function(t){return{top:t.offsetTop,left:t.offsetLeft}},i.offset=function(t){var e=t.getBoundingClientRect();return{top:e.top+window.pageYOffset-document.documentElement.clientTop,left:e.left+window.pageXOffset-document.documentElement.clientLeft}},i.matches=o,i.parent=function(t,e){for(var i=t;i=i.parentElement;)if(o(i,e))return i;return null},i.margin=function(t){var e=getComputedStyle(t);return{top:parseFloat(e.marginTop)||0,bottom:parseFloat(e.marginBottom)||0,left:parseFloat(e.marginLeft)||0,right:parseFloat(e.marginRight)||0}},i.padding=function(t){var e=getComputedStyle(t);return{top:parseFloat(e.paddingTop)||0,bottom:parseFloat(e.paddingBottom)||0,left:parseFloat(e.paddingLeft)||0,right:parseFloat(e.paddingRight)||0}},(n=i.Keys||(i.Keys={}))[n.Backspace=8]="Backspace",n[n.Tab=9]="Tab",n[n.Enter=13]="Enter",n[n.Esc=27]="Esc",n[n.PageUp=33]="PageUp",n[n.PageDown=34]="PageDown",n[n.Left=37]="Left",n[n.Up=38]="Up",n[n.Right=39]="Right",n[n.Down=40]="Down",n[n.Delete=46]="Delete"},function(t,e,i){var n=t(391),r=t(48),o=t(5),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),this._has_finished=!1,this.el=this._createElement()},t.prototype.remove=function(){o.removeElement(this.el),e.prototype.remove.call(this)},t.prototype.css_classes=function(){return[]},t.prototype.cursor=function(t,e){return null},t.prototype.layout=function(){},t.prototype.render=function(){},t.prototype.renderTo=function(t){t.appendChild(this.el),this.layout()},t.prototype.has_finished=function(){return this._has_finished},Object.defineProperty(t.prototype,"_root_element",{get:function(){return o.parent(this.el,".bk-root")||document.body},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"solver",{get:function(){return this.is_root?this._solver:this.parent.solver},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"is_idle",{get:function(){return this.has_finished()},enumerable:!0,configurable:!0}),t.prototype._createElement=function(){return o.createElement(this.tagName,{id:this.id,class:this.css_classes()})},t}(r.View);(i.DOMView=s).prototype.tagName="div"},function(t,e,i){i.AngleUnits=["deg","rad"],i.Dimension=["width","height"],i.Dimensions=["width","height","both"],i.Direction=["clock","anticlock"],i.FontStyle=["normal","italic","bold","bold italic"],i.LatLon=["lat","lon"],i.LineCap=["butt","round","square"],i.LineJoin=["miter","round","bevel"],i.Location=["above","below","left","right"],i.LegendClickPolicy=["none","hide","mute"],i.LegendLocation=["top_left","top_center","top_right","center_left","center","center_right","bottom_left","bottom_center","bottom_right"],i.Anchor=i.LegendLocation,i.Orientation=["vertical","horizontal"],i.OutputBackend=["canvas","svg","webgl"],i.RenderLevel=["image","underlay","glyph","annotation","overlay"],i.RenderMode=["canvas","css"],i.Side=["above","below","left","right"],i.Place=["above","below","left","right","center"],i.SpatialUnits=["screen","data"],i.StartEnd=["start","end"],i.VerticalAlign=["top","middle","bottom"],i.TextAlign=["left","right","center"],i.TextBaseline=["top","middle","bottom","alphabetic","hanging","ideographic"],i.TickLabelOrientation=["vertical","horizontal","parallel","normal"],i.TooltipAttachment=["horizontal","vertical","left","right","above","below"],i.Distribution=["uniform","normal"],i.StepMode=["after","before","center"],i.SizingMode=["stretch_both","scale_width","scale_height","scale_both","fixed"],i.PaddingUnits=["percent","absolute"],i.SliderCallbackPolicy=["continuous","throttle","mouseup"],i.RoundingFunction=["round","nearest","floor","rounddown","ceil","roundup"],i.UpdateMode=["replace","append"],i.HTTPMethod=["POST","GET"],i.Logo=["normal","grey"]},function(t,e,i){var o=t(391),l=t(19),n=t(16),h=t(34),r=t(15),u=t(38),s=t(21),_=t(32),p=t(44),d=t(30),a=function(a){function c(t){void 0===t&&(t={});var e=a.call(this)||this;for(var i in e._subtype=void 0,e.document=null,e.destroyed=new l.Signal0(e,"destroyed"),e.change=new l.Signal0(e,"change"),e.transformchange=new l.Signal0(e,"transformchange"),e.attributes={},e.properties={},e._set_after_defaults={},e._pending=!1,e._changing=!1,e.props){var n=e.props[i],r=n.type,o=n.default_value;if(null==r)throw new Error("undefined property type for "+e.type+"."+i);e.properties[i]=new r(e,i,o)}null==t.id&&e.setv({id:u.uniqueId()},{silent:!0});var s=t.__deferred__||!1;return s&&delete(t=_.clone(t)).__deferred__,e.setv(t,{silent:!0}),s||e.finalize(),e}return o.__extends(c,a),c.initClass=function(){this.prototype.type="HasProps",this.prototype.props={},this.prototype.mixins=[],this.define({id:[r.Any]})},c._fix_default=function(t,e){return void 0===t?void 0:p.isFunction(t)?t:p.isObject(t)?p.isArray(t)?function(){return s.copy(t)}:function(){return _.clone(t)}:function(){return t}},c.define=function(a){var t=function(i){var t=a[i];if(null!=l.prototype.props[i])throw new Error("attempted to redefine property '"+l.prototype.type+"."+i+"'");if(null!=l.prototype[i])throw new Error("attempted to redefine attribute '"+l.prototype.type+"."+i+"'");Object.defineProperty(l.prototype,i,{get:function(){var t=this.getv(i);return t},set:function(t){var e;return this.setv(((e={})[i]=t,e)),this},configurable:!1,enumerable:!0});var e=t[0],n=t[1],r=t[2],o={type:e,default_value:l._fix_default(n,i),internal:r||!1},s=_.clone(l.prototype.props);s[i]=o,l.prototype.props=s},l=this;for(var e in a)t(e)},c.internal=function(t){var e={};for(var i in t){var n=t[i],r=n[0],o=n[1];e[i]=[r,o,!0]}this.define(e)},c.mixin=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];this.define(n.create(t));var i=this.prototype.mixins.concat(t);this.prototype.mixins=i},c.mixins=function(t){this.mixin.apply(this,t)},c.override=function(t){for(var e in t){var i=this._fix_default(t[e],e),n=this.prototype.props[e];if(null==n)throw new Error("attempted to override nonexistent '"+this.prototype.type+"."+e+"'");var r=_.clone(this.prototype.props);r[e]=o.__assign({},n,{default_value:i}),this.prototype.props=r}},c.prototype.toString=function(){return this.type+"("+this.id+")"},c.prototype.finalize=function(){var t=this;for(var e in this.properties){var i=this.properties[e];i.update(),null!=i.spec.transform&&this.connect(i.spec.transform.change,function(){return t.transformchange.emit()})}this.initialize(),this.connect_signals()},c.prototype.initialize=function(){},c.prototype.connect_signals=function(){},c.prototype.disconnect_signals=function(){l.Signal.disconnectReceiver(this)},c.prototype.destroy=function(){this.disconnect_signals(),this.destroyed.emit()},c.prototype.clone=function(){return new this.constructor(this.attributes)},c.prototype._setv=function(t,e){var i=e.check_eq,n=e.silent,r=[],o=this._changing;this._changing=!0;var s=this.attributes;for(var a in t){var l=t[a];!1!==i&&d.isEqual(s[a],l)||r.push(a),s[a]=l}if(!n){0<r.length&&(this._pending=!0);for(var h=0;h<r.length;h++)this.properties[r[h]].change.emit()}if(!o){if(!n&&!e.no_change)for(;this._pending;)this._pending=!1,this.change.emit();this._pending=!1,this._changing=!1}},c.prototype.setv=function(t,e){for(var i in void 0===e&&(e={}),t)if(t.hasOwnProperty(i)){var n=i;if(null==this.props[n])throw new Error("property "+this.type+"."+n+" wasn't declared");null!=e&&e.defaults||(this._set_after_defaults[i]=!0)}if(!_.isEmpty(t)){var r={};for(var i in t)r[i]=this.getv(i);this._setv(t,e);var o=e.silent;if(null==o||!o)for(var i in t)this._tell_document_about_change(i,r[i],this.getv(i),e)}},c.prototype.getv=function(t){if(null==this.props[t])throw new Error("property "+this.type+"."+t+" wasn't declared");return this.attributes[t]},c.prototype.ref=function(){return h.create_ref(this)},c.prototype.set_subtype=function(t){this._subtype=t},c.prototype.attribute_is_serializable=function(t){var e=this.props[t];if(null==e)throw new Error(this.type+".attribute_is_serializable('"+t+"'): "+t+" wasn't declared");return!e.internal},c.prototype.serializable_attributes=function(){var t={};for(var e in this.attributes){var i=this.attributes[e];this.attribute_is_serializable(e)&&(t[e]=i)}return t},c._value_to_json=function(t,e,i){if(e instanceof c)return e.ref();if(p.isArray(e)){for(var n=[],r=0;r<e.length;r++){var o=e[r];n.push(c._value_to_json(r.toString(),o,e))}return n}if(p.isPlainObject(e)){var s={};for(var a in e)e.hasOwnProperty(a)&&(s[a]=c._value_to_json(a,e[a],e));return s}return e},c.prototype.attributes_as_json=function(t,e){void 0===t&&(t=!0),void 0===e&&(e=c._value_to_json);var i=this.serializable_attributes(),n={};for(var r in i)if(i.hasOwnProperty(r)){var o=i[r];t?n[r]=o:r in this._set_after_defaults&&(n[r]=o)}return e("attributes",n,this)},c._json_record_references=function(t,e,i,n){if(null==e);else if(h.is_ref(e)){if(!(e.id in i)){var r=t.get_model_by_id(e.id);c._value_record_references(r,i,n)}}else if(p.isArray(e))for(var o=0,s=e;o<s.length;o++){var a=s[o];c._json_record_references(t,a,i,n)}else if(p.isPlainObject(e))for(var l in e)if(e.hasOwnProperty(l)){var a=e[l];c._json_record_references(t,a,i,n)}},c._value_record_references=function(t,e,i){if(null==t);else if(t instanceof c){if(!(t.id in e)&&(e[t.id]=t,i))for(var n=t._immediate_references(),r=0,o=n;r<o.length;r++){var s=o[r];c._value_record_references(s,e,!0)}}else if(t.buffer instanceof ArrayBuffer);else if(p.isArray(t))for(var a=0,l=t;a<l.length;a++){var h=l[a];c._value_record_references(h,e,i)}else if(p.isPlainObject(t))for(var u in t)if(t.hasOwnProperty(u)){var h=t[u];c._value_record_references(h,e,i)}},c.prototype._immediate_references=function(){var t={},e=this.serializable_attributes();for(var i in e){var n=e[i];c._value_record_references(n,t,!1)}return _.values(t)},c.prototype.references=function(){var t={};return c._value_record_references(this,t,!0),_.values(t)},c.prototype._doc_attached=function(){},c.prototype.attach_document=function(t){if(null!=this.document&&this.document!=t)throw new Error("models must be owned by only a single document");this.document=t,this._doc_attached()},c.prototype.detach_document=function(){this.document=null},c.prototype._tell_document_about_change=function(t,e,i,n){if(this.attribute_is_serializable(t)&&null!=this.document){var r={};c._value_record_references(i,r,!1);var o={};c._value_record_references(e,o,!1);var s=!1;for(var a in r)if(!(a in o)){s=!0;break}if(!s)for(var l in o)if(!(l in r)){s=!0;break}s&&this.document._invalidate_all_models(),this.document._notify_change(this,t,e,i,n)}},c.prototype.materialize_dataspecs=function(t){var e={};for(var i in this.properties){var n=this.properties[i];n.dataspec&&(!n.optional||null!=n.spec.value||i in this._set_after_defaults)&&(e["_"+i]=n.array(t),null!=n.spec.field&&n.spec.field in t._shapes&&(e["_"+i+"_shape"]=t._shapes[n.spec.field]),n instanceof r.DistanceSpec&&(e["max_"+i]=s.max(e["_"+i])))}return e},c}(l.Signalable());(i.HasProps=a).initClass()},function(t,e,i){var n=t(21),r=t(197);function o(t){return t*t}function s(t,e){return o(t.x-e.x)+o(t.y-e.y)}function a(t,e,i){var n=s(e,i);if(0==n)return s(t,e);var r=((t.x-e.x)*(i.x-e.x)+(t.y-e.y)*(i.y-e.y))/n;if(r<0)return s(t,e);if(1<r)return s(t,i);var o={x:e.x+r*(i.x-e.x),y:e.y+r*(i.y-e.y)};return s(t,o)}i.point_in_poly=function(t,e,i,n){for(var r=!1,o=i[i.length-1],s=n[n.length-1],a=0;a<i.length;a++){var l=i[a],h=n[a];s<e!=h<e&&o+(e-s)/(h-s)*(l-o)<t&&(r=!r),o=l,s=h}return r},i.point_in_ellipse=function(t,e,i,n,r,o,s){var a=Math.pow(Math.cos(i)/r,2)+Math.pow(Math.sin(i)/n,2),l=2*Math.cos(i)*Math.sin(i)*(Math.pow(1/r,2)-Math.pow(1/n,2)),h=Math.pow(Math.cos(i)/n,2)+Math.pow(Math.sin(i)/r,2);return a*Math.pow(t-o,2)+l*(t-o)*(e-s)+h*Math.pow(e-s,2)<=1},i.create_empty_hit_test_result=function(){return new r.Selection},i.create_hit_test_result_from_hits=function(t){var e=new r.Selection;return e.indices=n.sortBy(t,function(t){return t[0],t[1]}).map(function(t){var e=t[0];return t[1],e}),e},i.validate_bbox_coords=function(t,e){var i,n,r=t[0],o=t[1],s=e[0],a=e[1];return o<r&&(r=(i=[o,r])[0],o=i[1]),a<s&&(s=(n=[a,s])[0],a=n[1]),{minX:r,minY:s,maxX:o,maxY:a}},i.dist_2_pts=s,i.dist_to_segment_squared=a,i.dist_to_segment=function(t,e,i){return Math.sqrt(a(t,e,i))},i.check_2_segments_intersect=function(t,e,i,n,r,o,s,a){var l=(a-o)*(i-t)-(s-r)*(n-e);if(0==l)return{hit:!1,x:null,y:null};var h=e-o,u=t-r,c=(s-r)*h-(a-o)*u,_=(i-t)*h-(n-e)*u;u=_/l;var p=t+(h=c/l)*(i-t),d=e+h*(n-e);return{hit:0<h&&h<1&&0<u&&u<1,x:p,y:d}}},function(t,e,i){var s=t(13),a=t(21);i.vstack=function(t,e){var i=[];if(0<e.length){i.push(s.EQ(a.head(e)._bottom,[-1,t._bottom])),i.push(s.EQ(a.tail(e)._top,[-1,t._top])),i.push.apply(i,a.pairwise(e,function(t,e){return s.EQ(t._top,[-1,e._bottom])}));for(var n=0,r=e;n<r.length;n++){var o=r[n];i.push(s.EQ(o._left,[-1,t._left])),i.push(s.EQ(o._right,[-1,t._right]))}}return i},i.hstack=function(t,e){var i=[];if(0<e.length){i.push(s.EQ(a.head(e)._right,[-1,t._right])),i.push(s.EQ(a.tail(e)._left,[-1,t._left])),i.push.apply(i,a.pairwise(e,function(t,e){return s.EQ(t._left,[-1,e._right])}));for(var n=0,r=e;n<r.length;n++){var o=r[n];i.push(s.EQ(o._top,[-1,t._top])),i.push(s.EQ(o._bottom,[-1,t._bottom]))}}return i}},function(t,e,i){var n=t(391),r=t(13),o=t(8),s=t(24),a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="LayoutCanvas"},t.prototype.initialize=function(){e.prototype.initialize.call(this),this._top=new r.Variable(this.toString()+".top"),this._left=new r.Variable(this.toString()+".left"),this._width=new r.Variable(this.toString()+".width"),this._height=new r.Variable(this.toString()+".height"),this._right=new r.Variable(this.toString()+".right"),this._bottom=new r.Variable(this.toString()+".bottom");var t=this;this._hcenter={get value(){return(t._left.value+t._right.value)/2}},this._vcenter={get value(){return(t._top.value+t._bottom.value)/2}}},t.prototype.get_editables=function(){return[]},t.prototype.get_constraints=function(){return[r.GE(this._top),r.GE(this._bottom),r.GE(this._left),r.GE(this._right),r.GE(this._width),r.GE(this._height),r.EQ(this._left,this._width,[-1,this._right]),r.EQ(this._top,this._height,[-1,this._bottom])]},t.prototype.get_layoutable_children=function(){return[]},Object.defineProperty(t.prototype,"bbox",{get:function(){return new s.BBox({x0:this._left.value,y0:this._top.value,x1:this._right.value,y1:this._bottom.value})},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"layout_bbox",{get:function(){return{top:this._top.value,left:this._left.value,width:this._width.value,height:this._height.value,right:this._right.value,bottom:this._bottom.value}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"xview",{get:function(){var r=this;return{compute:function(t){return r._left.value+t},v_compute:function(t){for(var e=new Float64Array(t.length),i=r._left.value,n=0;n<t.length;n++)e[n]=i+t[n];return e}}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"yview",{get:function(){var r=this;return{compute:function(t){return r._bottom.value-t},v_compute:function(t){for(var e=new Float64Array(t.length),i=r._bottom.value,n=0;n<t.length;n++)e[n]=i-t[n];return e}}},enumerable:!0,configurable:!0}),t}(o.HasProps);(i.LayoutCanvas=a).initClass()},function(t,e,r){var i=t(391),o=t(13),n=t(11),s=t(15),a=t(14),l=t(44),h=Math.PI/2,u="alphabetic",c="middle",_="hanging",p="left",d="right",f="center",v={above:{parallel:0,normal:-h,horizontal:0,vertical:-h},below:{parallel:0,normal:h,horizontal:0,vertical:h},left:{parallel:-h,normal:0,horizontal:0,vertical:-h},right:{parallel:h,normal:0,horizontal:0,vertical:h}},m={above:{justified:"top",parallel:u,normal:c,horizontal:u,vertical:c},below:{justified:"bottom",parallel:_,normal:c,horizontal:_,vertical:c},left:{justified:"top",parallel:u,normal:c,horizontal:c,vertical:u},right:{justified:"top",parallel:u,normal:c,horizontal:c,vertical:u}},g={above:{justified:f,parallel:f,normal:p,horizontal:f,vertical:p},below:{justified:f,parallel:f,normal:p,horizontal:f,vertical:p},left:{justified:f,parallel:f,normal:d,horizontal:d,vertical:f},right:{justified:f,parallel:f,normal:p,horizontal:p,vertical:f}},y={above:d,below:p,left:d,right:p},b={above:p,below:d,left:d,right:p};function x(t){return"panel"in t}r.isSizeable=x,r.isSizeableView=function(t){return x(t.model)&&"get_size"in t},r._view_sizes=new WeakMap,r._view_constraints=new WeakMap,r.update_panel_constraints=function(t){var e=t.solver,i=t.get_size(),n=r._view_constraints.get(t);if(null!=n&&e.has_constraint(n)){if(r._view_sizes.get(t)===i)return;e.remove_constraint(n)}n=o.GE(t.model.panel._size,-i),e.add_constraint(n),r._view_sizes.set(t,i),r._view_constraints.set(t,n)};var w=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="SidePanel",this.internal({side:[s.String]})},t.prototype.toString=function(){return this.type+"("+this.id+", "+this.side+")"},t.prototype.initialize=function(){switch(e.prototype.initialize.call(this),this.side){case"above":this._dim=0,this._normals=[0,-1],this._size=this._height;break;case"below":this._dim=0,this._normals=[0,1],this._size=this._height;break;case"left":this._dim=1,this._normals=[-1,0],this._size=this._width;break;case"right":this._dim=1,this._normals=[1,0],this._size=this._width;break;default:a.logger.error("unrecognized side: '"+this.side+"'")}},Object.defineProperty(t.prototype,"dimension",{get:function(){return this._dim},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"normals",{get:function(){return this._normals},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"is_horizontal",{get:function(){return"above"==this.side||"below"==this.side},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"is_vertical",{get:function(){return"left"==this.side||"right"==this.side},enumerable:!0,configurable:!0}),t.prototype.apply_label_text_heuristics=function(t,e){var i,n,r=this.side;l.isString(e)?(i=m[r][e],n=g[r][e]):0===e?n=i="whatever":e<0?(i="middle",n=y[r]):(i="middle",n=b[r]),t.textBaseline=i,t.textAlign=n},t.prototype.get_label_angle_heuristic=function(t){return v[this.side][t]},t}(n.LayoutCanvas);(r.SidePanel=w).initClass()},function(t,e,i){var n=t(350);function r(i){return function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];return new n.Constraint(new(n.Expression.bind.apply(n.Expression,[void 0].concat(t))),i)}}function o(i){return function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];return new n.Constraint(new(n.Expression.bind.apply(n.Expression,[void 0].concat(t))),i,n.Strength.weak)}}i.Variable=n.Variable,i.Expression=n.Expression,i.Constraint=n.Constraint,i.Operator=n.Operator,i.Strength=n.Strength,i.EQ=r(n.Operator.Eq),i.LE=r(n.Operator.Le),i.GE=r(n.Operator.Ge),i.WEAK_EQ=o(n.Operator.Eq),i.WEAK_LE=o(n.Operator.Le),i.WEAK_GE=o(n.Operator.Ge);var s=function(){function t(){this.solver=new n.Solver}return t.prototype.clear=function(){this.solver=new n.Solver},t.prototype.toString=function(){return"Solver(num_constraints="+this.num_constraints+", num_editables="+this.num_editables+")"},Object.defineProperty(t.prototype,"num_constraints",{get:function(){return this.solver.numConstraints},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"num_editables",{get:function(){return this.solver.numEditVariables},enumerable:!0,configurable:!0}),t.prototype.get_constraints=function(){return this.solver.getConstraints()},t.prototype.update_variables=function(){this.solver.updateVariables()},t.prototype.has_constraint=function(t){return this.solver.hasConstraint(t)},t.prototype.add_constraint=function(e){try{this.solver.addConstraint(e)}catch(t){throw new Error(t.message+": "+e.toString())}},t.prototype.remove_constraint=function(t){this.solver.removeConstraint(t)},t.prototype.add_edit_variable=function(t,e){this.solver.addEditVariable(t,e)},t.prototype.remove_edit_variable=function(t){this.solver.removeEditVariable(t)},t.prototype.suggest_value=function(t,e){this.solver.suggestValue(t,e)},t}();i.Solver=s},function(t,e,i){var o=t(44),n={},s=function(t,e){this.name=t,this.level=e};i.LogLevel=s;var r=function(){function r(t,e){void 0===e&&(e=r.INFO),this._name=t,this.set_level(e)}return Object.defineProperty(r,"levels",{get:function(){return Object.keys(r.log_levels)},enumerable:!0,configurable:!0}),r.get=function(t,e){if(void 0===e&&(e=r.INFO),0<t.length){var i=n[t];return null==i&&(n[t]=i=new r(t,e)),i}throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level")},Object.defineProperty(r.prototype,"level",{get:function(){return this.get_level()},enumerable:!0,configurable:!0}),r.prototype.get_level=function(){return this._log_level},r.prototype.set_level=function(t){if(t instanceof s)this._log_level=t;else{if(!o.isString(t)||null==r.log_levels[t])throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");this._log_level=r.log_levels[t]}var e="["+this._name+"]";for(var i in r.log_levels){var n=r.log_levels[i];n.level<this._log_level.level||this._log_level.level===r.OFF.level?this[i]=function(){}:this[i]=a(i,e)}},r.prototype.trace=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e]},r.prototype.debug=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e]},r.prototype.info=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e]},r.prototype.warn=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e]},r.prototype.error=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e]},r.TRACE=new s("trace",0),r.DEBUG=new s("debug",1),r.INFO=new s("info",2),r.WARN=new s("warn",6),r.ERROR=new s("error",7),r.FATAL=new s("fatal",8),r.OFF=new s("off",9),r.log_levels={trace:r.TRACE,debug:r.DEBUG,info:r.INFO,warn:r.WARN,error:r.ERROR,fatal:r.FATAL,off:r.OFF},r}();function a(t,e){return null!=console[t]?console[t].bind(console,e):null!=console.log?console.log.bind(console,e):function(){}}i.Logger=r,i.logger=r.get("bokeh"),i.set_log_level=function(t){null==r.log_levels[t]?(console.log("[bokeh] unrecognized logging level '"+t+"' passed to Bokeh.set_log_level(), ignoring"),console.log("[bokeh] valid log levels are: "+r.levels.join(", "))):(console.log("[bokeh] setting log level to: '"+t+"'"),i.logger.set_level(t))}},function(t,e,i){var o=t(391),s=t(19),n=t(7),r=t(39),a=t(27),l=t(21),h=t(22),u=t(44);function c(e){try{return JSON.stringify(e)}catch(t){return e.toString()}}function _(t){return u.isPlainObject(t)&&(void 0===t.value?0:1)+(void 0===t.field?0:1)+(void 0===t.expr?0:1)==1}s.Signal,i.isSpec=_;var p=function(r){function t(t,e,i){var n=r.call(this)||this;return n.obj=t,n.attr=e,n.default_value=i,n.optional=!1,n.obj=t,n.attr=e,n.default_value=i,n.change=new s.Signal0(n.obj,"change"),n._init(),n.connect(n.change,function(){return n._init()}),n}return o.__extends(t,r),t.prototype.update=function(){this._init()},t.prototype.init=function(){},t.prototype.transform=function(t){return t},t.prototype.validate=function(t){},t.prototype.value=function(t){if(void 0===t&&(t=!0),void 0===this.spec.value)throw new Error("attempted to retrieve property value for property without value specification");var e=this.transform([this.spec.value])[0];return null!=this.spec.transform&&t&&(e=this.spec.transform.compute(e)),e},t.prototype.array=function(t){if(!this.dataspec)throw new Error("attempted to retrieve property array for non-dataspec property");var e;if(null!=this.spec.field){if(null==(e=this.transform(t.get_column(this.spec.field))))throw new Error("attempted to retrieve property array for nonexistent field '"+this.spec.field+"'")}else if(null!=this.spec.expr)e=this.transform(this.spec.expr.v_compute(t));else{var i=t.get_length();null==i&&(i=1);var n=this.value(!1);e=l.repeat(n,i)}return null!=this.spec.transform&&(e=this.spec.transform.v_compute(e)),e},t.prototype._init=function(){var t,e=this.obj,i=this.attr,n=e.getv(i);if(void 0===n){var r=this.default_value;n=void 0!==r?r(e):null,e.setv(((t={})[i]=n,t),{silent:!0,defaults:!0})}if(u.isArray(n)?this.spec={value:n}:_(n)?this.spec=n:this.spec={value:n},this.dataspec&&null!=this.spec.field&&!u.isString(this.spec.field))throw new Error("field value for property '"+i+"' is not a string");null!=this.spec.value&&this.validate(this.spec.value),this.init()},t.prototype.toString=function(){return"Prop("+this.obj+"."+this.attr+", spec: "+c(this.spec)+")"},t}(s.Signalable());function d(i,n){return function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.prototype.validate=function(t){if(!n(t))throw new Error(i+" property '"+this.attr+"' given invalid value: "+c(t))},e}(p)}(i.Property=p).prototype.dataspec=!1;var f=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}((i.simple_prop=d)("Any",function(t){return!0}));i.Any=f;var v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(d("Array",function(t){return u.isArray(t)||t instanceof Float64Array}));i.Array=v;var m=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(d("Bool",u.isBoolean));i.Bool=m,i.Boolean=m;var g=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(d("Color",function(t){return u.isString(t)&&(r.is_svg_color(t.toLowerCase())||"#"==t.substring(0,1)||a.valid_rgb(t))}));i.Color=g;var y=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(d("Instance",function(t){return null!=t.properties}));i.Instance=y;var b=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(d("Number",function(t){return u.isNumber(t)||u.isBoolean(t)}));i.Number=b;var x=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(i.Int=b);i.Angle=x;var w=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(d("Number",function(t){return(u.isNumber(t)||u.isBoolean(t))&&0<=t&&t<=1}));i.Percent=w;var k=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(d("String",u.isString));i.String=k;var S=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(i.FontSize=k);function C(t,e){return function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(d(t,function(t){return l.includes(e,t)}))}i.Font=S;var T=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}((i.enum_prop=C)("Anchor",n.LegendLocation));i.Anchor=T;var A=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("AngleUnits",n.AngleUnits));i.AngleUnits=A;var E=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.prototype.transform=function(t){for(var e=new Uint8Array(t.length),i=0;i<t.length;i++)switch(t[i]){case"clock":e[i]=0;break;case"anticlock":e[i]=1}return e},e}(C("Direction",n.Direction));i.Direction=E;var M=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("Dimension",n.Dimension));i.Dimension=M;var O=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("Dimensions",n.Dimensions));i.Dimensions=O;var z=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("FontStyle",n.FontStyle));i.FontStyle=z;var P=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("LatLon",n.LatLon));i.LatLon=P;var j=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("LineCap",n.LineCap));i.LineCap=j;var N=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("LineJoin",n.LineJoin));i.LineJoin=N;var F=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("LegendLocation",n.LegendLocation));i.LegendLocation=F;var D=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("Location",n.Location));i.Location=D;var I=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("OutputBackend",n.OutputBackend));i.OutputBackend=I;var R=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("Orientation",n.Orientation));i.Orientation=R;var B=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("VerticalAlign",n.VerticalAlign));i.VerticalAlign=B;var L=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("TextAlign",n.TextAlign));i.TextAlign=L;var V=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("TextBaseline",n.TextBaseline));i.TextBaseline=V;var G=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("RenderLevel",n.RenderLevel));i.RenderLevel=G;var U=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("RenderMode",n.RenderMode));i.RenderMode=U;var q=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("SizingMode",n.SizingMode));i.SizingMode=q;var Y=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("SpatialUnits",n.SpatialUnits));i.SpatialUnits=Y;var X=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("Distribution",n.Distribution));i.Distribution=X;var H=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("StepMode",n.StepMode));i.StepMode=H;var W=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("PaddingUnits",n.PaddingUnits));i.PaddingUnits=W;var J=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(C("StartEnd",n.StartEnd));function Q(i,n,r){return function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.prototype.init=function(){null==this.spec.units&&(this.spec.units=r);var t=this.spec.units;if(!l.includes(n,t))throw new Error(i+" units must be one of "+n+", given invalid value: "+t)},Object.defineProperty(e.prototype,"units",{get:function(){return this.spec.units},set:function(t){this.spec.units=t},enumerable:!0,configurable:!0}),e}(b)}i.StartEnd=J;var $=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype.transform=function(t){return"deg"==this.spec.units&&(t=h.map(t,function(t){return t*Math.PI/180})),t=h.map(t,function(t){return-t}),e.prototype.transform.call(this,t)},t}((i.units_prop=Q)("AngleSpec",n.AngleUnits,"rad"));(i.AngleSpec=$).prototype.dataspec=!0;var K=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(g);(i.ColorSpec=K).prototype.dataspec=!0;var Z=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(Q("DistanceSpec",n.SpatialUnits,"data"));(i.DistanceSpec=Z).prototype.dataspec=!0;var tt=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(k);(i.FontSizeSpec=tt).prototype.dataspec=!0;var et=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(k);(i.MarkerSpec=et).prototype.dataspec=!0;var it=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(b);(i.NumberSpec=it).prototype.dataspec=!0;var nt=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e}(k);(i.StringSpec=nt).prototype.dataspec=!0},function(t,e,h){var i=t(15),u=t(32);function n(t,e){var i={};for(var n in t){var r=t[n];i[e+n]=r}return i}var r={line_color:[i.ColorSpec,"black"],line_width:[i.NumberSpec,1],line_alpha:[i.NumberSpec,1],line_join:[i.LineJoin,"bevel"],line_cap:[i.LineCap,"butt"],line_dash:[i.Array,[]],line_dash_offset:[i.Number,0]};h.line=function(t){return void 0===t&&(t=""),n(r,t)};var o={fill_color:[i.ColorSpec,"gray"],fill_alpha:[i.NumberSpec,1]};h.fill=function(t){return void 0===t&&(t=""),n(o,t)};var s={text_font:[i.Font,"helvetica"],text_font_size:[i.FontSizeSpec,"12pt"],text_font_style:[i.FontStyle,"normal"],text_color:[i.ColorSpec,"#444444"],text_alpha:[i.NumberSpec,1],text_align:[i.TextAlign,"left"],text_baseline:[i.TextBaseline,"bottom"],text_line_height:[i.Number,1.2]};h.text=function(t){return void 0===t&&(t=""),n(s,t)},h.create=function(t){for(var e={},i=0,n=t;i<n.length;i++){var r=n[i],o=r.split(":"),s=o[0],a=o[1],l=void 0;switch(s){case"line":l=h.line;break;case"fill":l=h.fill;break;case"text":l=h.text;break;default:throw new Error("Unknown property mixin kind '"+s+"'")}u.extend(e,l(a))}return e}},function(t,e,i){var n=t(391),r=t(8),o=t(197),p=t(185),d=t(186),s=t(15),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.initClass=function(){this.prototype.type="SelectionManager",this.internal({source:[s.Any]})},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.inspectors={}},e.prototype.select=function(t,e,i,n){void 0===n&&(n=!1);for(var r=[],o=[],s=0,a=t;s<a.length;s++){var l=a[s];l instanceof p.GlyphRendererView?r.push(l):l instanceof d.GraphRendererView&&o.push(l)}for(var h=!1,u=0,c=o;u<c.length;u++){var l=c[u],_=l.model.selection_policy.hit_test(e,l);h=h||l.model.selection_policy.do_selection(_,l.model,i,n)}if(0<r.length){var _=this.source.selection_policy.hit_test(e,r);h=h||this.source.selection_policy.do_selection(_,this.source,i,n)}return h},e.prototype.inspect=function(t,e){var i=!1;if(t instanceof p.GlyphRendererView){var n=t.hit_test(e);if(null!=n){i=!n.is_empty();var r=this.get_or_create_inspector(t.model);r.update(n,!0,!1),this.source.setv({inspected:r},{silent:!0}),this.source.inspect.emit([t,{geometry:e}])}}else if(t instanceof d.GraphRendererView){var n=t.model.inspection_policy.hit_test(e,t);i=i||t.model.inspection_policy.do_inspection(n,e,t,!1,!1)}return i},e.prototype.clear=function(t){this.source.selected.clear(),null!=t&&this.get_or_create_inspector(t.model).clear()},e.prototype.get_or_create_inspector=function(t){return null==this.inspectors[t.id]&&(this.inspectors[t.id]=new o.Selection),this.inspectors[t.id]},e}(r.HasProps);(i.SelectionManager=a).initClass()},function(t,e,i){var n=function(){function t(){this._dev=!1}return Object.defineProperty(t.prototype,"dev",{get:function(){return this._dev},set:function(t){this._dev=t},enumerable:!0,configurable:!0}),t}();i.Settings=n,i.settings=new n},function(t,e,i){var n,r=t(391),o=t(29),s=t(25),a=t(21),l=function(){function t(t,e){this.sender=t,this.name=e}return t.prototype.connect=function(t,e){void 0===e&&(e=null),u.has(this.sender)||u.set(this.sender,[]);var i=u.get(this.sender);if(null!=_(i,this,t,e))return!1;var n=e||t;c.has(n)||c.set(n,[]);var r=c.get(n),o={signal:this,slot:t,context:e};return i.push(o),r.push(o),!0},t.prototype.disconnect=function(t,e){void 0===e&&(e=null);var i=u.get(this.sender);if(null==i||0===i.length)return!1;var n=_(i,this,t,e);if(null==n)return!1;var r=e||t,o=c.get(r);return n.signal=null,d(i),d(o),!0},t.prototype.emit=function(t){for(var e=u.get(this.sender)||[],i=0,n=e;i<n.length;i++){var r=n[i],o=r.signal,s=r.slot,a=r.context;o===this&&s.call(a,t,this.sender)}},t}(),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype.emit=function(){t.prototype.emit.call(this,void 0)},e}(i.Signal=l);i.Signal0=h,(n=l=i.Signal||(i.Signal={})).disconnectBetween=function(t,e){var i=u.get(t);if(null!=i&&0!==i.length){var n=c.get(e);if(null!=n&&0!==n.length){for(var r=0,o=n;r<o.length;r++){var s=o[r];if(null==s.signal)return;s.signal.sender===t&&(s.signal=null)}d(i),d(n)}}},n.disconnectSender=function(t){var e=u.get(t);if(null!=e&&0!==e.length){for(var i=0,n=e;i<n.length;i++){var r=n[i];if(null==r.signal)return;var o=r.context||r.slot;r.signal=null,d(c.get(o))}d(e)}},n.disconnectReceiver=function(t){var e=c.get(t);if(null!=e&&0!==e.length){for(var i=0,n=e;i<n.length;i++){var r=n[i];if(null==r.signal)return;var o=r.signal.sender;r.signal=null,d(u.get(o))}d(e)}},n.disconnectAll=function(t){var e=u.get(t);if(null!=e&&0!==e.length){for(var i=0,n=e;i<n.length;i++){var r=n[i];r.signal=null}d(e)}var o=c.get(t);if(null!=o&&0!==o.length){for(var s=0,a=o;s<a.length;s++){var r=a[s];r.signal=null}d(o)}},i.Signal=l,i.Signalable=function(t){return null!=t?function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype.connect=function(t,e){return t.connect(e,this)},e}(t):function(){function t(){}return t.prototype.connect=function(t,e){return t.connect(e,this)},t}()},(i._Signalable||(i._Signalable={})).connect=function(t,e){return t.connect(e,this)};var u=new WeakMap,c=new WeakMap;function _(t,e,i,n){return a.find(t,function(t){return t.signal===e&&t.slot===i&&t.context===n})}var p=new o.Set;function d(t){0===p.size&&s.defer(f),p.add(t)}function f(){p.forEach(function(t){a.removeBy(t,function(t){return null==t.signal})}),p.clear()}},function(t,e,d){var i=t(391),o=t(347),s=t(19),a=t(14),l=t(5),n=t(45),h=t(21),f=t(32),r=t(44),u=t(3);d.is_mobile="ontouchstart"in window||0<navigator.maxTouchPoints;var c=function(){function t(t,e,i,n){var r=this;this.plot_view=t,this.toolbar=e,this.hit_area=i,this.plot=n,this.pan_start=new s.Signal(this,"pan:start"),this.pan=new s.Signal(this,"pan"),this.pan_end=new s.Signal(this,"pan:end"),this.pinch_start=new s.Signal(this,"pinch:start"),this.pinch=new s.Signal(this,"pinch"),this.pinch_end=new s.Signal(this,"pinch:end"),this.rotate_start=new s.Signal(this,"rotate:start"),this.rotate=new s.Signal(this,"rotate"),this.rotate_end=new s.Signal(this,"rotate:end"),this.tap=new s.Signal(this,"tap"),this.doubletap=new s.Signal(this,"doubletap"),this.press=new s.Signal(this,"press"),this.move_enter=new s.Signal(this,"move:enter"),this.move=new s.Signal(this,"move"),this.move_exit=new s.Signal(this,"move:exit"),this.scroll=new s.Signal(this,"scroll"),this.keydown=new s.Signal(this,"keydown"),this.keyup=new s.Signal(this,"keyup"),this.hammer=new o(this.hit_area),this._configure_hammerjs(),this.hit_area.addEventListener("mousemove",function(t){return r._mouse_move(t)}),this.hit_area.addEventListener("mouseenter",function(t){return r._mouse_enter(t)}),this.hit_area.addEventListener("mouseleave",function(t){return r._mouse_exit(t)}),this.hit_area.addEventListener("wheel",function(t){return r._mouse_wheel(t)}),document.addEventListener("keydown",this),document.addEventListener("keyup",this)}return t.prototype.destroy=function(){this.hammer.destroy(),document.removeEventListener("keydown",this),document.removeEventListener("keyup",this)},t.prototype.handleEvent=function(t){"keydown"==t.type?this._key_down(t):"keyup"==t.type&&this._key_up(t)},t.prototype._configure_hammerjs=function(){var e=this;this.hammer.get("doubletap").recognizeWith("tap"),this.hammer.get("tap").requireFailure("doubletap"),this.hammer.get("doubletap").dropRequireFailure("tap"),this.hammer.on("doubletap",function(t){return e._doubletap(t)}),this.hammer.on("tap",function(t){return e._tap(t)}),this.hammer.on("press",function(t){return e._press(t)}),this.hammer.get("pan").set({direction:o.DIRECTION_ALL}),this.hammer.on("panstart",function(t){return e._pan_start(t)}),this.hammer.on("pan",function(t){return e._pan(t)}),this.hammer.on("panend",function(t){return e._pan_end(t)}),this.hammer.get("pinch").set({enable:!0}),this.hammer.on("pinchstart",function(t){return e._pinch_start(t)}),this.hammer.on("pinch",function(t){return e._pinch(t)}),this.hammer.on("pinchend",function(t){return e._pinch_end(t)}),this.hammer.get("rotate").set({enable:!0}),this.hammer.on("rotatestart",function(t){return e._rotate_start(t)}),this.hammer.on("rotate",function(t){return e._rotate(t)}),this.hammer.on("rotateend",function(t){return e._rotate_end(t)})},t.prototype.register_tool=function(i){var n=this,t=i.model.event_type;null!=t&&(r.isString(t)?this._register_tool(i,t):t.forEach(function(t,e){return n._register_tool(i,t,e<1)}))},t.prototype._register_tool=function(t,e,i){void 0===i&&(i=!0);var n=t,r=n.model.id,o=function(e){return function(t){t.id==r&&e(t.e)}},s=function(e){return function(t){e(t.e)}};switch(e){case"pan":null!=n._pan_start&&n.connect(this.pan_start,o(n._pan_start.bind(n))),null!=n._pan&&n.connect(this.pan,o(n._pan.bind(n))),null!=n._pan_end&&n.connect(this.pan_end,o(n._pan_end.bind(n)));break;case"pinch":null!=n._pinch_start&&n.connect(this.pinch_start,o(n._pinch_start.bind(n))),null!=n._pinch&&n.connect(this.pinch,o(n._pinch.bind(n))),null!=n._pinch_end&&n.connect(this.pinch_end,o(n._pinch_end.bind(n)));break;case"rotate":null!=n._rotate_start&&n.connect(this.rotate_start,o(n._rotate_start.bind(n))),null!=n._rotate&&n.connect(this.rotate,o(n._rotate.bind(n))),null!=n._rotate_end&&n.connect(this.rotate_end,o(n._rotate_end.bind(n)));break;case"move":null!=n._move_enter&&n.connect(this.move_enter,o(n._move_enter.bind(n))),null!=n._move&&n.connect(this.move,o(n._move.bind(n))),null!=n._move_exit&&n.connect(this.move_exit,o(n._move_exit.bind(n)));break;case"tap":null!=n._tap&&n.connect(this.tap,o(n._tap.bind(n)));break;case"press":null!=n._press&&n.connect(this.press,o(n._press.bind(n)));break;case"scroll":null!=n._scroll&&n.connect(this.scroll,o(n._scroll.bind(n)));break;default:throw new Error("unsupported event_type: "+e)}i&&(null!=n._doubletap&&n.connect(this.doubletap,s(n._doubletap.bind(n))),null!=n._keydown&&n.connect(this.keydown,s(n._keydown.bind(n))),null!=n._keyup&&n.connect(this.keyup,s(n._keyup.bind(n))),d.is_mobile&&null!=n._scroll&&"pinch"==e&&(a.logger.debug("Registering scroll on touch screen"),n.connect(this.scroll,o(n._scroll.bind(n)))))},t.prototype._hit_test_renderers=function(t,e){for(var i=this.plot_view.get_renderer_views(),n=0,r=h.reversed(i);n<r.length;n++){var o=r[n],s=o.model.level;if(("annotation"==s||"overlay"==s)&&null!=o.interactive_hit&&o.interactive_hit(t,e))return o}return null},t.prototype._hit_test_frame=function(t,e){return this.plot_view.frame.bbox.contains(t,e)},t.prototype._hit_test_canvas=function(t,e){return this.plot_view.canvas.bbox.contains(t,e)},t.prototype._trigger=function(e,i,t){var n=this,r=this.toolbar.gestures,o=e.name,s=o.split(":")[0],a=this._hit_test_renderers(i.sx,i.sy),l=this._hit_test_canvas(i.sx,i.sy);switch(s){case"move":var h=r[s].active;null!=h&&this.trigger(e,i,h.id);var u=this.toolbar.inspectors.filter(function(t){return t.active}),c="default";null!=a?(c=a.cursor(i.sx,i.sy)||c,f.isEmpty(u)||(e=this.move_exit,o=e.name)):this._hit_test_frame(i.sx,i.sy)&&(f.isEmpty(u)||(c="crosshair")),this.plot_view.set_cursor(c),this.plot_view.set_toolbar_visibility(l),u.map(function(t){return n.trigger(e,i,t.id)});break;case"tap":var _=t.target;if(null!=_&&_!=this.hit_area)return;null!=a&&null!=a.on_hit&&a.on_hit(i.sx,i.sy);var h=r[s].active;null!=h&&this.trigger(e,i,h.id);break;case"scroll":var p=d.is_mobile?"pinch":"scroll",h=r[p].active;null!=h&&(t.preventDefault(),t.stopPropagation(),this.trigger(e,i,h.id));break;default:var h=r[s].active;null!=h&&this.trigger(e,i,h.id)}this._trigger_bokeh_event(i)},t.prototype.trigger=function(t,e,i){void 0===i&&(i=null),t.emit({id:i,e:e})},t.prototype._trigger_bokeh_event=function(t){var e=u.BokehEvent.event_class(t);null!=e?this.plot.trigger_event(e.from_event(t)):a.logger.debug("Unhandled event of type "+t.type)},t.prototype._get_sxy=function(t){var e,i=(e=t,"undefined"!=typeof TouchEvent&&e instanceof TouchEvent?(0!=t.touches.length?t.touches:t.changedTouches)[0]:t),n=i.pageX,r=i.pageY,o=l.offset(this.hit_area),s=o.left,a=o.top;return{sx:n-s,sy:r-a}},t.prototype._gesture_event=function(t){return i.__assign({type:t.type},this._get_sxy(t.srcEvent),{deltaX:t.deltaX,deltaY:t.deltaY,scale:t.scale,shiftKey:t.srcEvent.shiftKey})},t.prototype._tap_event=function(t){return i.__assign({type:t.type},this._get_sxy(t.srcEvent),{shiftKey:t.srcEvent.shiftKey})},t.prototype._move_event=function(t){return i.__assign({type:t.type},this._get_sxy(t))},t.prototype._scroll_event=function(t){return i.__assign({type:t.type},this._get_sxy(t),{delta:n.getDeltaY(t)})},t.prototype._key_event=function(t){return{type:t.type,keyCode:t.keyCode}},t.prototype._pan_start=function(t){var e=this._gesture_event(t);e.sx-=t.deltaX,e.sy-=t.deltaY,this._trigger(this.pan_start,e,t.srcEvent)},t.prototype._pan=function(t){this._trigger(this.pan,this._gesture_event(t),t.srcEvent)},t.prototype._pan_end=function(t){this._trigger(this.pan_end,this._gesture_event(t),t.srcEvent)},t.prototype._pinch_start=function(t){this._trigger(this.pinch_start,this._gesture_event(t),t.srcEvent)},t.prototype._pinch=function(t){this._trigger(this.pinch,this._gesture_event(t),t.srcEvent)},t.prototype._pinch_end=function(t){this._trigger(this.pinch_end,this._gesture_event(t),t.srcEvent)},t.prototype._rotate_start=function(t){this._trigger(this.rotate_start,this._gesture_event(t),t.srcEvent)},t.prototype._rotate=function(t){this._trigger(this.rotate,this._gesture_event(t),t.srcEvent)},t.prototype._rotate_end=function(t){this._trigger(this.rotate_end,this._gesture_event(t),t.srcEvent)},t.prototype._tap=function(t){this._trigger(this.tap,this._tap_event(t),t.srcEvent)},t.prototype._doubletap=function(t){var e=this._tap_event(t);this._trigger_bokeh_event(e),this.trigger(this.doubletap,e)},t.prototype._press=function(t){this._trigger(this.press,this._tap_event(t),t.srcEvent)},t.prototype._mouse_enter=function(t){this._trigger(this.move_enter,this._move_event(t),t)},t.prototype._mouse_move=function(t){this._trigger(this.move,this._move_event(t),t)},t.prototype._mouse_exit=function(t){this._trigger(this.move_exit,this._move_event(t),t)},t.prototype._mouse_wheel=function(t){this._trigger(this.scroll,this._scroll_event(t),t)},t.prototype._key_down=function(t){this.trigger(this.keydown,this._key_event(t))},t.prototype._key_up=function(t){this.trigger(this.keyup,this._key_event(t))},t}();d.UIEvents=c},function(t,e,n){var o=t(31),u=t(23),i=t(22);n.min=i.min,n.minBy=i.minBy,n.max=i.max,n.maxBy=i.maxBy,n.sum=i.sum;var r=Array.prototype.slice;function s(t){var e;return(e=[]).concat.apply(e,t)}function c(t,e){return-1!==t.indexOf(e)}function a(t,e,i){void 0===i&&(i=1),u.assert(0<i,"'step' must be a positive number"),null==e&&(e=t,t=0);for(var n=Math.max,r=Math.ceil,o=Math.abs,s=t<=e?i:-i,a=n(r(o(e-t)/i),0),l=Array(a),h=0;h<a;h++,t+=s)l[h]=t;return l}function l(r){return function(t,e){for(var i=t.length,n=0<r?0:i-1;0<=n&&n<i;n+=r)if(e(t[n]))return n;return-1}}function h(t){for(var e=[],i=0,n=t;i<n.length;i++){var r=n[i];c(e,r)||e.push(r)}return e}n.head=function(t){return t[0]},n.tail=function(t){return t[t.length-1]},n.last=function(t){return t[t.length-1]},n.copy=function(t){return r.call(t)},n.concat=s,n.includes=c,n.contains=c,n.nth=function(t,e){return t[0<=e?e:t.length+e]},n.zip=function(t,e){for(var i=Math.min(t.length,e.length),n=new Array(i),r=0;r<i;r++)n[r]=[t[r],e[r]];return n},n.unzip=function(t){for(var e,i=t.length,n=new Array(i),r=new Array(i),o=0;o<i;o++)e=t[o],n[o]=e[0],r[o]=e[1];return[n,r]},n.range=a,n.linspace=function(t,e,i){void 0===i&&(i=100);for(var n=(e-t)/(i-1),r=new Array(i),o=0;o<i;o++)r[o]=t+n*o;return r},n.transpose=function(t){for(var e=t.length,i=t[0].length,n=[],r=0;r<i;r++){n[r]=[];for(var o=0;o<e;o++)n[r][o]=t[o][r]}return n},n.cumsum=function(t){var n=[];return t.reduce(function(t,e,i){return n[i]=t+e},0),n},n.argmin=function(e){return i.minBy(a(e.length),function(t){return e[t]})},n.argmax=function(e){return i.maxBy(a(e.length),function(t){return e[t]})},n.all=function(t,e){for(var i=0,n=t;i<n.length;i++){var r=n[i];if(!e(r))return!1}return!0},n.any=function(t,e){for(var i=0,n=t;i<n.length;i++){var r=n[i];if(e(r))return!0}return!1},n.findIndex=l(1),n.findLastIndex=l(-1),n.find=function(t,e){var i=n.findIndex(t,e);return-1==i?void 0:t[i]},n.findLast=function(t,e){var i=n.findLastIndex(t,e);return-1==i?void 0:t[i]},n.sortedIndex=function(t,e){for(var i=0,n=t.length;i<n;){var r=Math.floor((i+n)/2);t[r]<e?i=r+1:n=r}return i},n.sortBy=function(t,i){var e=t.map(function(t,e){return{value:t,index:e,key:i(t)}});return e.sort(function(t,e){var i=t.key,n=e.key;if(i!==n){if(n<i||void 0===i)return 1;if(i<n||void 0===n)return-1}return t.index-e.index}),e.map(function(t){return t.value})},n.uniq=h,n.uniqBy=function(t,e){for(var i=[],n=[],r=0,o=t;r<o.length;r++){var s=o[r],a=e(s);c(n,a)||(n.push(a),i.push(s))}return i},n.union=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];return h(s(t))},n.intersection=function(t){for(var e=[],i=1;i<arguments.length;i++)e[i-1]=arguments[i];var n=[];t:for(var r=0,o=t;r<o.length;r++){var s=o[r];if(!c(n,s)){for(var a=0,l=e;a<l.length;a++){var h=l[a];if(!c(h,s))continue t}n.push(s)}}return n},n.difference=function(t){for(var e=[],i=1;i<arguments.length;i++)e[i-1]=arguments[i];var n=s(e);return t.filter(function(t){return!c(n,t)})},n.removeBy=function(t,e){for(var i=0;i<t.length;)e(t[i])?t.splice(i,1):i++},n.shuffle=function(t){for(var e=t.length,i=new Array(e),n=0;n<e;n++){var r=o.randomIn(0,n);r!==n&&(i[n]=i[r]),i[r]=t[n]}return i},n.pairwise=function(t,e){for(var i=t.length,n=new Array(i-1),r=0;r<i-1;r++)n[r]=e(t[r],t[r+1]);return n},n.reversed=function(t){for(var e=t.length,i=new Array(e),n=0;n<e;n++)i[e-n-1]=t[n];return i},n.repeat=function(t,e){for(var i=new Array(e),n=0;n<e;n++)i[n]=t;return i}},function(t,e,i){function n(t,e,i){for(var n=[],r=3;r<arguments.length;r++)n[r-3]=arguments[r];var o=t.length;e<0&&(e+=o),e<0?e=0:o<e&&(e=o),null==i||o-e<i?i=o-e:i<0&&(i=0);for(var s=o-i+n.length,a=new t.constructor(s),l=0;l<e;l++)a[l]=t[l];for(var h=0,u=n;h<u.length;h++){var c=u[h];a[l++]=c}for(var _=e+i;_<o;_++)a[l++]=t[_];return a}i.splice=n,i.insert=function(t,e,i){return n(t,i,0,e)},i.append=function(t,e){return n(t,t.length,0,e)},i.prepend=function(t,e){return n(t,0,0,e)},i.indexOf=function(t,e){for(var i=0,n=t.length;i<n;i++)if(t[i]===e)return i;return-1},i.map=function(t,e){for(var i=t.length,n=new t.constructor(i),r=0;r<i;r++)n[r]=e(t[r],r,t);return n},i.min=function(t){for(var e,i=1/0,n=0,r=t.length;n<r;n++)(e=t[n])<i&&(i=e);return i},i.minBy=function(t,e){if(0==t.length)throw new Error("minBy() called with an empty array");for(var i=t[0],n=e(i),r=1,o=t.length;r<o;r++){var s=t[r],a=e(s);a<n&&(i=s,n=a)}return i},i.max=function(t){for(var e,i=-1/0,n=0,r=t.length;n<r;n++)e=t[n],i<e&&(i=e);return i},i.maxBy=function(t,e){if(0==t.length)throw new Error("maxBy() called with an empty array");for(var i=t[0],n=e(i),r=1,o=t.length;r<o;r++){var s=t[r],a=e(s);n<a&&(i=s,n=a)}return i},i.sum=function(t){for(var e=0,i=0,n=t.length;i<n;i++)e+=t[i];return e}},function(t,e,i){var n=t(391),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(Error);i.AssertionError=r,i.assert=function(t,e){if(!(!0===t||!1!==t&&t()))throw new r(e||"Assertion failed")}},function(t,e,i){var n=Math.min,r=Math.max;i.empty=function(){return{minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0}},i.positive_x=function(){return{minX:Number.MIN_VALUE,minY:-1/0,maxX:1/0,maxY:1/0}},i.positive_y=function(){return{minX:-1/0,minY:Number.MIN_VALUE,maxX:1/0,maxY:1/0}},i.union=function(t,e){return{minX:n(t.minX,e.minX),maxX:r(t.maxX,e.maxX),minY:n(t.minY,e.minY),maxY:r(t.maxY,e.maxY)}};var o=function(){function e(t){if("x0"in t&&"y0"in t&&"x1"in t&&"y1"in t){var e=t,i=e.x0,n=e.y0,r=e.x1,o=e.y1;if(!(i<=r&&n<=o))throw new Error("invalid bbox {x0: "+i+", y0: "+n+", x1: "+r+", y1: "+o+"}");this.x0=i,this.y0=n,this.x1=r,this.y1=o}else{var s=t,a=s.x,l=s.y,h=s.width,u=s.height;if(!(0<=h&&0<=u))throw new Error("invalid bbox {x: "+a+", y: "+l+", width: "+h+", height: "+u+"}");this.x0=a,this.y0=l,this.x1=a+h,this.y1=l+u}}return Object.defineProperty(e.prototype,"minX",{get:function(){return this.x0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"minY",{get:function(){return this.y0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"maxX",{get:function(){return this.x1},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"maxY",{get:function(){return this.y1},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"left",{get:function(){return this.x0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"top",{get:function(){return this.y0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"right",{get:function(){return this.x1},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"bottom",{get:function(){return this.y1},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"p0",{get:function(){return[this.x0,this.y0]},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"p1",{get:function(){return[this.x1,this.y1]},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"x",{get:function(){return this.x0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"y",{get:function(){return this.y0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"width",{get:function(){return this.x1-this.x0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"height",{get:function(){return this.y1-this.y0},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"rect",{get:function(){return{x:this.x,y:this.y,width:this.width,height:this.height}},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"h_range",{get:function(){return{start:this.x0,end:this.x1}},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"v_range",{get:function(){return{start:this.y0,end:this.y1}},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"ranges",{get:function(){return[this.h_range,this.v_range]},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"aspect",{get:function(){return this.width/this.height},enumerable:!0,configurable:!0}),e.prototype.contains=function(t,e){return t>=this.x0&&t<=this.x1&&e>=this.y0&&e<=this.y1},e.prototype.clip=function(t,e){return t<this.x0?t=this.x0:t>this.x1&&(t=this.x1),e<this.y0?e=this.y0:e>this.y1&&(e=this.y1),[t,e]},e.prototype.union=function(t){return new e({x0:n(this.x0,t.x0),y0:n(this.y0,t.y0),x1:r(this.x1,t.x1),y1:r(this.y1,t.y1)})},e}();i.BBox=o},function(t,e,i){i.delay=function(t,e){return setTimeout(t,e)};var n="function"==typeof requestAnimationFrame?requestAnimationFrame:setImmediate;i.defer=function(t){return n(t)},i.throttle=function(i,n,r){void 0===r&&(r={});var o,s,a,l=null,h=0,u=function(){h=!1===r.leading?0:Date.now(),l=null,a=i.apply(o,s),l||(o=s=null)};return function(){var t=Date.now();h||!1!==r.leading||(h=t);var e=n-(t-h);return o=this,s=arguments,e<=0||n<e?(l&&(clearTimeout(l),l=null),h=t,a=i.apply(o,s),l||(o=s=null)):l||!1===r.trailing||(l=setTimeout(u,e)),a}},i.once=function(t){var e,i=!1;return function(){return i||(i=!0,e=t()),e}}},function(t,e,i){var n=t(287);i.SVGRenderingContext2D=n,i.fixup_ctx=function(t){var e,c,i,n,r;(e=t).setLineDash||(e.setLineDash=function(t){e.mozDash=t,e.webkitLineDash=t}),e.getLineDash||(e.getLineDash=function(){return e.mozDash}),(r=t).setLineDashOffset=function(t){r.lineDashOffset=t,r.mozDashOffset=t,r.webkitLineDashOffset=t},r.getLineDashOffset=function(){return r.mozDashOffset},(n=t).setImageSmoothingEnabled=function(t){n.imageSmoothingEnabled=t,n.mozImageSmoothingEnabled=t,n.oImageSmoothingEnabled=t,n.webkitImageSmoothingEnabled=t,n.msImageSmoothingEnabled=t},n.getImageSmoothingEnabled=function(){var t=n.imageSmoothingEnabled;return null==t||t},(i=t).measureText&&null==i.html5MeasureText&&(i.html5MeasureText=i.measureText,i.measureText=function(t){var e=i.html5MeasureText(t);return e.ascent=1.6*i.html5MeasureText("m").width,e}),(c=t).ellipse||(c.ellipse=function(t,e,i,n,r,o,s,a){void 0===a&&(a=!1);var l=.551784;c.translate(t,e),c.rotate(r);var h=i,u=n;a&&(h=-i,u=-n),c.moveTo(-h,0),c.bezierCurveTo(-h,u*l,-h*l,u,0,u),c.bezierCurveTo(h*l,u,h,u*l,h,0),c.bezierCurveTo(h,-u*l,h*l,-u,0,-u),c.bezierCurveTo(-h*l,-u,-h,-u*l,-h,0),c.rotate(-r),c.translate(-t,-e)})},i.get_scale_ratio=function(t,e,i){if("svg"==i)return 1;if(e){var n=window.devicePixelRatio||1,r=t.webkitBackingStorePixelRatio||t.mozBackingStorePixelRatio||t.msBackingStorePixelRatio||t.oBackingStorePixelRatio||t.backingStorePixelRatio||1;return n/r}return 1}},function(t,e,i){var n=t(39),r=t(21);function o(t){var e=Number(t).toString(16);return 1==e.length?"0"+e:e}function s(t){if(0==(t+="").indexOf("#"))return t;if(n.is_svg_color(t))return n.svg_colors[t];if(0==t.indexOf("rgb")){var e=t.replace(/^rgba?\(|\s+|\)$/g,"").split(","),i=e.slice(0,3).map(o).join("");return 4==e.length&&(i+=o(Math.floor(255*parseFloat(e[3])))),"#"+i.slice(0,8)}return t}i.color2hex=s,i.color2rgba=function(t,e){if(void 0===e&&(e=1),!t)return[0,0,0,0];var i=s(t);(i=i.replace(/ |#/g,"")).length<=4&&(i=i.replace(/(.)/g,"$1$1"));for(var n=i.match(/../g).map(function(t){return parseInt(t,16)/255});n.length<3;)n.push(0);return n.length<4&&n.push(e),n.slice(0,4)},i.valid_rgb=function(t){var e;switch(t.substring(0,4)){case"rgba":e={start:"rgba(",len:4,alpha:!0};break;case"rgb(":e={start:"rgb(",len:3,alpha:!1};break;default:return!1}if(new RegExp(".*?(\\.).*(,)").test(t))throw new Error("color expects integers for rgb in rgb/rgba tuple, received "+t);var i=t.replace(e.start,"").replace(")","").split(",").map(parseFloat);if(i.length!=e.len)throw new Error("color expects rgba "+e.len+"-tuple, received "+t);if(e.alpha&&!(0<=i[3]&&i[3]<=1))throw new Error("color expects rgba 4-tuple to have alpha value between 0 and 1");if(r.includes(i.slice(0,3).map(function(t){return 0<=t&&t<=255}),!1))throw new Error("color expects rgb to have value between 0 and 255");return!0}},function(t,e,i){i.is_ie=0<=navigator.userAgent.indexOf("MSIE")||0<navigator.userAgent.indexOf("Trident")||0<navigator.userAgent.indexOf("Edge"),i.is_little_endian=function(){var t=new ArrayBuffer(4),e=new Uint8Array(t),i=new Uint32Array(t);i[1]=168496141;var n=!0;return 10==e[4]&&11==e[5]&&12==e[6]&&13==e[7]&&(n=!1),n}()},function(t,e,i){var r=t(21),o=t(30),s=t(44),n=function(){function t(){this._dict={}}return t.prototype._existing=function(t){return t in this._dict?this._dict[t]:null},t.prototype.add_value=function(t,e){var i=this._existing(t);null==i?this._dict[t]=e:s.isArray(i)?i.push(e):this._dict[t]=[i,e]},t.prototype.remove_value=function(t,e){var i=this._existing(t);if(s.isArray(i)){var n=r.difference(i,[e]);0<n.length?this._dict[t]=n:delete this._dict[t]}else o.isEqual(i,e)&&delete this._dict[t]},t.prototype.get_one=function(t,e){var i=this._existing(t);if(s.isArray(i)){if(1===i.length)return i[0];throw new Error(e)}return i},t}();i.MultiDict=n;var a=function(){function o(t){if(null==t)this._values=[];else if(t instanceof o)this._values=r.copy(t._values);else{this._values=[];for(var e=0,i=t;e<i.length;e++){var n=i[e];this.add(n)}}}return Object.defineProperty(o.prototype,"values",{get:function(){return r.copy(this._values).sort()},enumerable:!0,configurable:!0}),o.prototype.toString=function(){return"Set(["+this.values.join(",")+"])"},Object.defineProperty(o.prototype,"size",{get:function(){return this._values.length},enumerable:!0,configurable:!0}),o.prototype.has=function(t){return-1!==this._values.indexOf(t)},o.prototype.add=function(t){this.has(t)||this._values.push(t)},o.prototype.remove=function(t){var e=this._values.indexOf(t);-1!==e&&this._values.splice(e,1)},o.prototype.toggle=function(t){var e=this._values.indexOf(t);-1===e?this._values.push(t):this._values.splice(e,1)},o.prototype.clear=function(){this._values=[]},o.prototype.union=function(t){return t=new o(t),new o(this._values.concat(t._values))},o.prototype.intersect=function(t){t=new o(t);for(var e=new o,i=0,n=t._values;i<n.length;i++){var r=n[i];this.has(r)&&t.has(r)&&e.add(r)}return e},o.prototype.diff=function(t){t=new o(t);for(var e=new o,i=0,n=this._values;i<n.length;i++){var r=n[i];t.has(r)||e.add(r)}return e},o.prototype.forEach=function(t,e){for(var i=0,n=this._values;i<n.length;i++){var r=n[i];t.call(e||this,r,r,this)}},o}();i.Set=a},function(t,e,i){var _=t(44),p=Object.prototype.toString;i.isEqual=function(t,e){return function t(e,i,n,r){if(e===i)return 0!==e||1/e==1/i;if(null==e||null==i)return e===i;var o=p.call(e);if(o!==p.call(i))return!1;switch(o){case"[object RegExp]":case"[object String]":return""+e==""+i;case"[object Number]":return+e!=+e?+i!=+i:0==+e?1/+e==1/i:+e==+i;case"[object Date]":case"[object Boolean]":return+e==+i}var s="[object Array]"===o;if(!s){if("object"!=typeof e||"object"!=typeof i)return!1;var a=e.constructor,l=i.constructor;if(a!==l&&!(_.isFunction(a)&&a instanceof a&&_.isFunction(l)&&l instanceof l)&&"constructor"in e&&"constructor"in i)return!1}r=r||[];for(var h=(n=n||[]).length;h--;)if(n[h]===e)return r[h]===i;if(n.push(e),r.push(i),s){if((h=e.length)!==i.length)return!1;for(;h--;)if(!t(e[h],i[h],n,r))return!1}else{var u=Object.keys(e),c=void 0;if(h=u.length,Object.keys(i).length!==h)return!1;for(;h--;)if(c=u[h],!i.hasOwnProperty(c)||!t(e[c],i[c],n,r))return!1}return n.pop(),r.pop(),!0}(t,e)}},function(t,e,i){function a(t){for(;t<0;)t+=2*Math.PI;for(;t>2*Math.PI;)t-=2*Math.PI;return t}function l(t,e){return Math.abs(a(t-e))}function o(){return Math.random()}i.angle_norm=a,i.angle_dist=l,i.angle_between=function(t,e,i,n){var r=a(t),o=l(e,i),s=l(e,r)<=o&&l(r,i)<=o;return 1==n?!s:s},i.random=o,i.randomIn=function(t,e){return null==e&&(e=t,t=0),t+Math.floor(Math.random()*(e-t+1))},i.atan2=function(t,e){return Math.atan2(e[1]-t[1],e[0]-t[0])},i.rnorm=function(t,e){for(var i,n;i=o(),n=(2*(n=o())-1)*Math.sqrt(1/Math.E*2),!(-4*i*i*Math.log(i)>=n*n););var r=n/i;return r=t+e*r},i.clamp=function(t,e,i){return i<t?i:t<e?e:t}},function(t,e,i){var n=t(391),h=t(21);function r(t,e){return n.__assign(t,e)}function o(t){return Object.keys(t).length}i.keys=Object.keys,i.values=function(t){for(var e=Object.keys(t),i=e.length,n=new Array(i),r=0;r<i;r++)n[r]=t[e[r]];return n},i.extend=r,i.clone=function(t){return r({},t)},i.merge=function(t,e){for(var i=Object.create(Object.prototype),n=h.concat([Object.keys(t),Object.keys(e)]),r=0,o=n;r<o.length;r++){var s=o[r],a=t.hasOwnProperty(s)?t[s]:[],l=e.hasOwnProperty(s)?e[s]:[];i[s]=h.union(a,l)}return i},i.size=o,i.isEmpty=function(t){return 0===o(t)}},function(t,e,h){var i=t(374),n=t(362),r=new n("GOOGLE"),o=new n("WGS84");h.wgs84_mercator=i(o,r);var s={lon:[-20026376.39,20026376.39],lat:[-20048966.1,20048966.1]},a={lon:[-180,180],lat:[-85.06,85.06]};function u(t,e){for(var i=Math.min(t.length,e.length),n=new Array(i),r=new Array(i),o=0;o<i;o++){var s=h.wgs84_mercator.forward([t[o],e[o]]),a=s[0],l=s[1];n[o]=a,r[o]=l}return[n,r]}h.clip_mercator=function(t,e,i){var n=s[i],r=n[0],o=n[1];return[Math.max(t,r),Math.min(e,o)]},h.in_bounds=function(t,e){return t>a[e][0]&&t<a[e][1]},h.project_xy=u,h.project_xsys=function(t,e){for(var i=Math.min(t.length,e.length),n=new Array(i),r=new Array(i),o=0;o<i;o++){var s=u(t[o],e[o]),a=s[0],l=s[1];n[o]=a,r[o]=l}return[n,r]}},function(t,e,i){var n=t(44);i.create_ref=function(t){var e={type:t.type,id:t.id};return null!=t._subtype&&(e.subtype=t._subtype),e},i.is_ref=function(t){if(n.isObject(t)){var e=Object.keys(t).sort();if(2==e.length)return"id"==e[0]&&"type"==e[1];if(3==e.length)return"id"==e[0]&&"subtype"==e[1]&&"type"==e[2]}return!1}},function(t,e,i){i.get_indices=function(t){var e=t.selected;return e["0d"].glyph?e["0d"].indices:0<e["1d"].indices.length?e["1d"].indices:0<e["2d"].indices.length?e["2d"].indices:[]}},function(t,e,u){var _=t(44),i=t(28);function c(t){for(var e=new Uint8Array(t.buffer,t.byteOffset,2*t.length),i=0,n=e.length;i<n;i+=2){var r=e[i];e[i]=e[i+1],e[i+1]=r}}function p(t){for(var e=new Uint8Array(t.buffer,t.byteOffset,4*t.length),i=0,n=e.length;i<n;i+=4){var r=e[i];e[i]=e[i+3],e[i+3]=r,r=e[i+1],e[i+1]=e[i+2],e[i+2]=r}}function d(t){for(var e=new Uint8Array(t.buffer,t.byteOffset,8*t.length),i=0,n=e.length;i<n;i+=8){var r=e[i];e[i]=e[i+7],e[i+7]=r,r=e[i+1],e[i+1]=e[i+6],e[i+6]=r,r=e[i+2],e[i+2]=e[i+5],e[i+5]=r,r=e[i+3],e[i+3]=e[i+4],e[i+4]=r}}function n(t,e){for(var i=t.order!==u.BYTE_ORDER,n=t.shape,r=null,o=0,s=e;o<s.length;o++){var a=s[o],l=JSON.parse(a[0]);if(l.id===t.__buffer__){r=a[1];break}}var h=new u.ARRAY_TYPES[t.dtype](r);return i&&(2===h.BYTES_PER_ELEMENT?c(h):4===h.BYTES_PER_ELEMENT?p(h):8===h.BYTES_PER_ELEMENT&&d(h)),[h,n]}function f(t,e){return _.isObject(t)&&"__ndarray__"in t?o(t):_.isObject(t)&&"__buffer__"in t?n(t,e):_.isArray(t)||_.isTypedArray(t)?[t,[]]:void 0}function s(t){var e=new Uint8Array(t),i=Array.from(e).map(function(t){return String.fromCharCode(t)});return btoa(i.join(""))}function r(t){for(var e=atob(t),i=e.length,n=new Uint8Array(i),r=0,o=i;r<o;r++)n[r]=e.charCodeAt(r);return n.buffer}function o(t){var e=r(t.__ndarray__),i=t.dtype,n=t.shape;if(!(i in u.ARRAY_TYPES))throw new Error("unknown dtype: "+i);return[new u.ARRAY_TYPES[i](e),n]}function a(t,e){var i,n=s(t.buffer),r=function(t){if("name"in t.constructor)return t.constructor.name;switch(!0){case t instanceof Uint8Array:return"Uint8Array";case t instanceof Int8Array:return"Int8Array";case t instanceof Uint16Array:return"Uint16Array";case t instanceof Int16Array:return"Int16Array";case t instanceof Uint32Array:return"Uint32Array";case t instanceof Int32Array:return"Int32Array";case t instanceof Float32Array:return"Float32Array";case t instanceof Float64Array:return"Float64Array";default:throw new Error("unsupported typed array")}}(t);if(!(r in u.DTYPES))throw new Error("unknown array type: "+r);i=u.DTYPES[r];var o={__ndarray__:n,shape:e,dtype:i};return o}function v(t,e){if(0==t.length||!_.isObject(t[0])&&!_.isArray(t[0]))return[t,[]];for(var i=[],n=[],r=0,o=t;r<o.length;r++){var s=o[r],a=_.isArray(s)?v(s,e):f(s,e),l=a[0],h=a[1];i.push(l),n.push(h)}var u=n.map(function(t){return t.filter(function(t){return 0!=t.length})});return[i,u]}function l(t,e){for(var i=[],n=0,r=t.length;n<r;n++){var o=t[n];if(_.isTypedArray(o)){var s=e[n]?e[n]:void 0;i.push(a(o,s))}else _.isArray(o)?i.push(l(o,e?e[n]:[])):i.push(o)}return i}u.ARRAY_TYPES={uint8:Uint8Array,int8:Int8Array,uint16:Uint16Array,int16:Int16Array,uint32:Uint32Array,int32:Int32Array,float32:Float32Array,float64:Float64Array},u.DTYPES={Uint8Array:"uint8",Int8Array:"int8",Uint16Array:"uint16",Int16Array:"int16",Uint32Array:"uint32",Int32Array:"int32",Float32Array:"float32",Float64Array:"float64"},u.BYTE_ORDER=i.is_little_endian?"little":"big",u.swap16=c,u.swap32=p,u.swap64=d,u.process_buffer=n,u.process_array=f,u.arrayBufferToBase64=s,u.base64ToArrayBuffer=r,u.decode_base64=o,u.encode_base64=a,u.decode_column_data=function(t,e){void 0===e&&(e=[]);var i={},n={};for(var r in t){var o=t[r];if(_.isArray(o)){if(0==o.length||!_.isObject(o[0])&&!_.isArray(o[0])){i[r]=o;continue}var s=v(o,e),a=s[0],l=s[1];i[r]=a,n[r]=l}else{var h=f(o,e),u=h[0],c=h[1];i[r]=u,n[r]=c}}return[i,n]},u.encode_column_data=function(t,e){var i={};for(var n in t){var r=t[n],o=null!=e?e[n]:void 0,s=void 0;s=_.isTypedArray(r)?a(r,o):_.isArray(r)?l(r,o||[]):r,i[n]=s}return i}},function(t,e,i){var l=t(346),o=t(24),n=function(){function t(t){if(this.points=t,this.index=null,0<t.length){this.index=new l(t.length);for(var e=0,i=t;e<i.length;e++){var n=i[e],r=n.minX,o=n.minY,s=n.maxX,a=n.maxY;this.index.add(r,o,s,a)}this.index.finish()}}return Object.defineProperty(t.prototype,"bbox",{get:function(){if(null==this.index)return o.empty();var t=this.index,e=t.minX,i=t.minY,n=t.maxX,r=t.maxY;return{minX:e,minY:i,maxX:n,maxY:r}},enumerable:!0,configurable:!0}),t.prototype.search=function(t){var e=this;if(null==this.index)return[];var i=t.minX,n=t.minY,r=t.maxX,o=t.maxY,s=this.index.search(i,n,r,o);return s.map(function(t){return e.points[t]})},t.prototype.indices=function(t){return this.search(t).map(function(t){var e=t.i;return e})},t}();i.SpatialIndex=n},function(t,e,i){var n=t(18);function r(){for(var t=new Array(32),e="0123456789ABCDEF",i=0;i<32;i++)t[i]=e.substr(Math.floor(16*Math.random()),1);return t[12]="4",t[16]=e.substr(3&t[16].charCodeAt(0)|8,1),t.join("")}i.startsWith=function(t,e,i){return void 0===i&&(i=0),t.substr(i,e.length)==e},i.uuid4=r;var o=1e3;i.uniqueId=function(t){var e=n.settings.dev?"j"+o++:r();return null!=t?t+"-"+e:e},i.escape=function(t){return t.replace(/(?:[&<>"'`])/g,function(t){switch(t){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&#x27;";case"`":return"&#x60;";default:return t}})},i.unescape=function(t){return t.replace(/&(amp|lt|gt|quot|#x27|#x60);/g,function(t,e){switch(e){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';case"#x27":return"'";case"#x60":return"`";default:return e}})},i.use_strict=function(t){return"'use strict';\n"+t}},function(t,e,i){i.svg_colors={indianred:"#CD5C5C",lightcoral:"#F08080",salmon:"#FA8072",darksalmon:"#E9967A",lightsalmon:"#FFA07A",crimson:"#DC143C",red:"#FF0000",firebrick:"#B22222",darkred:"#8B0000",pink:"#FFC0CB",lightpink:"#FFB6C1",hotpink:"#FF69B4",deeppink:"#FF1493",mediumvioletred:"#C71585",palevioletred:"#DB7093",coral:"#FF7F50",tomato:"#FF6347",orangered:"#FF4500",darkorange:"#FF8C00",orange:"#FFA500",gold:"#FFD700",yellow:"#FFFF00",lightyellow:"#FFFFE0",lemonchiffon:"#FFFACD",lightgoldenrodyellow:"#FAFAD2",papayawhip:"#FFEFD5",moccasin:"#FFE4B5",peachpuff:"#FFDAB9",palegoldenrod:"#EEE8AA",khaki:"#F0E68C",darkkhaki:"#BDB76B",lavender:"#E6E6FA",thistle:"#D8BFD8",plum:"#DDA0DD",violet:"#EE82EE",orchid:"#DA70D6",fuchsia:"#FF00FF",magenta:"#FF00FF",mediumorchid:"#BA55D3",mediumpurple:"#9370DB",blueviolet:"#8A2BE2",darkviolet:"#9400D3",darkorchid:"#9932CC",darkmagenta:"#8B008B",purple:"#800080",indigo:"#4B0082",slateblue:"#6A5ACD",darkslateblue:"#483D8B",mediumslateblue:"#7B68EE",greenyellow:"#ADFF2F",chartreuse:"#7FFF00",lawngreen:"#7CFC00",lime:"#00FF00",limegreen:"#32CD32",palegreen:"#98FB98",lightgreen:"#90EE90",mediumspringgreen:"#00FA9A",springgreen:"#00FF7F",mediumseagreen:"#3CB371",seagreen:"#2E8B57",forestgreen:"#228B22",green:"#008000",darkgreen:"#006400",yellowgreen:"#9ACD32",olivedrab:"#6B8E23",olive:"#808000",darkolivegreen:"#556B2F",mediumaquamarine:"#66CDAA",darkseagreen:"#8FBC8F",lightseagreen:"#20B2AA",darkcyan:"#008B8B",teal:"#008080",aqua:"#00FFFF",cyan:"#00FFFF",lightcyan:"#E0FFFF",paleturquoise:"#AFEEEE",aquamarine:"#7FFFD4",turquoise:"#40E0D0",mediumturquoise:"#48D1CC",darkturquoise:"#00CED1",cadetblue:"#5F9EA0",steelblue:"#4682B4",lightsteelblue:"#B0C4DE",powderblue:"#B0E0E6",lightblue:"#ADD8E6",skyblue:"#87CEEB",lightskyblue:"#87CEFA",deepskyblue:"#00BFFF",dodgerblue:"#1E90FF",cornflowerblue:"#6495ED",royalblue:"#4169E1",blue:"#0000FF",mediumblue:"#0000CD",darkblue:"#00008B",navy:"#000080",midnightblue:"#191970",cornsilk:"#FFF8DC",blanchedalmond:"#FFEBCD",bisque:"#FFE4C4",navajowhite:"#FFDEAD",wheat:"#F5DEB3",burlywood:"#DEB887",tan:"#D2B48C",rosybrown:"#BC8F8F",sandybrown:"#F4A460",goldenrod:"#DAA520",darkgoldenrod:"#B8860B",peru:"#CD853F",chocolate:"#D2691E",saddlebrown:"#8B4513",sienna:"#A0522D",brown:"#A52A2A",maroon:"#800000",white:"#FFFFFF",snow:"#FFFAFA",honeydew:"#F0FFF0",mintcream:"#F5FFFA",azure:"#F0FFFF",aliceblue:"#F0F8FF",ghostwhite:"#F8F8FF",whitesmoke:"#F5F5F5",seashell:"#FFF5EE",beige:"#F5F5DC",oldlace:"#FDF5E6",floralwhite:"#FFFAF0",ivory:"#FFFFF0",antiquewhite:"#FAEBD7",linen:"#FAF0E6",lavenderblush:"#FFF0F5",mistyrose:"#FFE4E1",gainsboro:"#DCDCDC",lightgray:"#D3D3D3",lightgrey:"#D3D3D3",silver:"#C0C0C0",darkgray:"#A9A9A9",darkgrey:"#A9A9A9",gray:"#808080",grey:"#808080",dimgray:"#696969",dimgrey:"#696969",lightslategray:"#778899",lightslategrey:"#778899",slategray:"#708090",slategrey:"#708090",darkslategray:"#2F4F4F",darkslategrey:"#2F4F4F",black:"#000000"},i.is_svg_color=function(t){return t in i.svg_colors}},function(t,e,s){var r=t(389),n=t(361),o=t(390),_=t(38),a=t(44);function l(t,e,i){if(a.isNumber(t)){var n=function(){switch(!1){case Math.floor(t)!=t:return"%d";case!(.1<Math.abs(t)&&Math.abs(t)<1e3):return"%0.3f";default:return"%0.3e"}}();return r.sprintf(n,t)}return""+t}function p(t,e,i,n){if(null==i)return l;if(null!=n&&(t in n||e in n)){var r=e in n?e:t,o=n[r];if(a.isString(o)){if(o in s.DEFAULT_FORMATTERS)return s.DEFAULT_FORMATTERS[o];throw new Error("Unknown tooltip field formatter type '"+o+"'")}return function(t,e,i){return o.format(t,e,i)}}return s.DEFAULT_FORMATTERS.numeral}function d(t,e,i,n){if("$"==t[0]){if(t.substring(1)in n)return n[t.substring(1)];throw new Error("Unknown special variable '"+t+"'")}var r=e.get_column(t);if(null==r)return null;if(a.isNumber(i))return r[i];var o=r[i.index];if(a.isTypedArray(o)||a.isArray(o)){if(a.isArray(o[0])){var s=o[i.dim2];return s[i.dim1]}return o[i.flat_index]}return o}s.DEFAULT_FORMATTERS={numeral:function(t,e,i){return n.format(t,e)},datetime:function(t,e,i){return o(t,e)},printf:function(t,e,i){return r.sprintf(e,t)}},s.basic_formatter=l,s.get_formatter=p,s.get_value=d,s.replace_placeholders=function(t,a,l,h,u){void 0===u&&(u={});var c=t.replace(/(?:^|[^@])([@|\$](?:\w+|{[^{}]+}))(?:{[^{}]+})?/g,function(t,e,i){return""+e});return t=(t=(t=t.replace(/@\$name/g,function(t){return"@{"+u.name+"}"})).replace(/(^|[^\$])\$(\w+)/g,function(t,e,i){return e+"@$"+i})).replace(/(^|[^@])@(?:(\$?\w+)|{([^{}]+)})(?:{([^{}]+)})?/g,function(t,e,i,n,r){var o=d(i=null!=n?n:i,a,l,u);if(null==o)return""+e+_.escape("???");if("safe"==r)return""+e+o;var s=p(i,c,r,h);return""+e+_.escape(s(o,r,u))})}},function(t,e,i){var a=t(5),l={};i.get_text_height=function(t){if(null!=l[t])return l[t];var e=a.span({style:{font:t}},"Hg"),i=a.div({style:{display:"inline-block",width:"1px",height:"0px"}}),n=a.div({},e,i);document.body.appendChild(n);try{i.style.verticalAlign="baseline";var r=a.offset(i).top-a.offset(e).top;i.style.verticalAlign="bottom";var o=a.offset(i).top-a.offset(e).top,s={height:o,ascent:r,descent:o-r};return l[t]=s}finally{document.body.removeChild(n)}}},function(t,e,i){var a=("undefined"!=typeof window?window.requestAnimationFrame:void 0)||("undefined"!=typeof window?window.webkitRequestAnimationFrame:void 0)||("undefined"!=typeof window?window.mozRequestAnimationFrame:void 0)||("undefined"!=typeof window?window.msRequestAnimationFrame:void 0)||function(t){return t(Date.now()),-1};i.throttle=function(t,i){var n=null,r=0,o=!1,s=function(){r=Date.now(),n=null,o=!1,t()};return function(){var t=Date.now(),e=i-(t-r);e<=0&&!o?(null!=n&&clearTimeout(n),o=!0,a(s)):n||o||(n=setTimeout(function(){return a(s)},e))}}},function(t,e,i){i.concat=function(t){for(var e=[],i=1;i<arguments.length;i++)e[i-1]=arguments[i];for(var n=t.length,r=0,o=e;r<o.length;r++){var s=o[r];n+=s.length}var a=new t.constructor(n);a.set(t,0);for(var l=t.length,h=0,u=e;h<u.length;h++){var s=u[h];a.set(s,l),l+=s.length}return a}},function(t,e,i){var n=t(21),r=Object.prototype.toString;function o(t){return"[object Number]"===r.call(t)}function s(t){var e=typeof t;return"function"===e||"object"===e&&!!t}i.isBoolean=function(t){return!0===t||!1===t||"[object Boolean]"===r.call(t)},i.isNumber=o,i.isInteger=function(t){return o(t)&&isFinite(t)&&Math.floor(t)===t},i.isString=function(t){return"[object String]"===r.call(t)},i.isStrictNaN=function(t){return o(t)&&t!==+t},i.isFunction=function(t){return"[object Function]"===r.call(t)},i.isArray=function(t){return Array.isArray(t)},i.isArrayOf=function(t,e){return n.all(t,e)},i.isArrayableOf=function(t,e){for(var i=0,n=t.length;i<n;i++)if(!e(t[i]))return!1;return!0},i.isTypedArray=function(t){return null!=t&&null!=t.buffer&&t.buffer instanceof ArrayBuffer},i.isObject=s,i.isPlainObject=function(t){return s(t)&&(null==t.constructor||t.constructor===Object)}},function(t,e,i){function n(t){var e=getComputedStyle(t).fontSize;return null!=e?parseInt(e,10):null}i.getDeltaY=function(t){var e,i=-t.deltaY;if(t.target instanceof HTMLElement)switch(t.deltaMode){case t.DOM_DELTA_LINE:i*=n((e=t.target).offsetParent||document.body)||n(e)||16;break;case t.DOM_DELTA_PAGE:i*=t.target.clientHeight}return i}},function(t,e,i){var f=t(31);function v(t,e,i){var n=[t.start,t.end],r=n[0],o=n[1],s=null!=i?i:(o+r)/2,a=r-(r-s)*e,l=o-(o-s)*e;return[a,l]}function m(t,e){var i=e[0],n=e[1],r={};for(var o in t){var s=t[o],a=s.r_invert(i,n),l=a[0],h=a[1];r[o]={start:l,end:h}}return r}i.scale_highlow=v,i.get_info=m,i.scale_range=function(t,e,i,n,r){void 0===i&&(i=!0),void 0===n&&(n=!0),e=f.clamp(e,-.9,.9);var o=i?e:0,s=v(t.bbox.h_range,o,null!=r?r.x:void 0),a=s[0],l=s[1],h=m(t.xscales,[a,l]),u=n?e:0,c=v(t.bbox.v_range,u,null!=r?r.y:void 0),_=c[0],p=c[1],d=m(t.yscales,[_,p]);return{xrs:h,yrs:d,factor:e}}},function(t,e,i){var n=t(44);i.isValue=function(t){return n.isObject(t)&&"value"in t},i.isField=function(t){return n.isObject(t)&&"field"in t}},function(t,e,i){var n=t(391),r=t(19),o=t(38),s=function(i){function t(t){var e=i.call(this)||this;if(e.removed=new r.Signal0(e,"removed"),null==t.model)throw new Error("model of a view wasn't configured");return e.model=t.model,e._parent=t.parent,e.id=t.id||o.uniqueId(),e.initialize(t),!1!==t.connect_signals&&e.connect_signals(),e}return n.__extends(t,i),t.prototype.initialize=function(t){},t.prototype.remove=function(){this._parent=void 0,this.disconnect_signals(),this.removed.emit()},t.prototype.toString=function(){return this.model.type+"View("+this.id+")"},Object.defineProperty(t.prototype,"parent",{get:function(){if(void 0!==this._parent)return this._parent;throw new Error("parent of a view wasn't configured")},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"is_root",{get:function(){return null===this.parent},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"root",{get:function(){return this.is_root?this:this.parent.root},enumerable:!0,configurable:!0}),t.prototype.connect_signals=function(){},t.prototype.disconnect_signals=function(){r.Signal.disconnectReceiver(this)},t.prototype.notify_finished=function(){this.root.notify_finished()},t}(r.Signalable());i.View=s},function(t,e,i){var n=t(391),r=t(16),o=t(27),s=function(){function t(t,e){void 0===e&&(e=""),this.obj=t,this.prefix=e,this.cache={};var i=t.properties[e+this.do_attr].spec;this.doit=null!==i.value;for(var n=0,r=this.attrs;n<r.length;n++){var o=r[n];this[o]=t.properties[e+o]}}return t.prototype.warm_cache=function(t){for(var e=0,i=this.attrs;e<i.length;e++){var n=i[e],r=this.obj.properties[this.prefix+n];if(void 0!==r.spec.value)this.cache[n]=r.spec.value;else{if(null==t)throw new Error("source is required with a vectorized visual property");this.cache[n+"_array"]=r.array(t)}}},t.prototype.cache_select=function(t,e){var i,n=this.obj.properties[this.prefix+t];return void 0!==n.spec.value?this.cache[t]=i=n.spec.value:this.cache[t]=i=this.cache[t+"_array"][e],i},t.prototype.set_vectorize=function(t,e){null!=this.all_indices?this._set_vectorize(t,this.all_indices[e]):this._set_vectorize(t,e)},t}(),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.set_value=function(t){t.strokeStyle=this.line_color.value(),t.globalAlpha=this.line_alpha.value(),t.lineWidth=this.line_width.value(),t.lineJoin=this.line_join.value(),t.lineCap=this.line_cap.value(),t.setLineDash(this.line_dash.value()),t.setLineDashOffset(this.line_dash_offset.value())},e.prototype._set_vectorize=function(t,e){this.cache_select("line_color",e),t.strokeStyle!==this.cache.line_color&&(t.strokeStyle=this.cache.line_color),this.cache_select("line_alpha",e),t.globalAlpha!==this.cache.line_alpha&&(t.globalAlpha=this.cache.line_alpha),this.cache_select("line_width",e),t.lineWidth!==this.cache.line_width&&(t.lineWidth=this.cache.line_width),this.cache_select("line_join",e),t.lineJoin!==this.cache.line_join&&(t.lineJoin=this.cache.line_join),this.cache_select("line_cap",e),t.lineCap!==this.cache.line_cap&&(t.lineCap=this.cache.line_cap),this.cache_select("line_dash",e),t.getLineDash()!==this.cache.line_dash&&t.setLineDash(this.cache.line_dash),this.cache_select("line_dash_offset",e),t.getLineDashOffset()!==this.cache.line_dash_offset&&t.setLineDashOffset(this.cache.line_dash_offset)},e.prototype.color_value=function(){var t=o.color2rgba(this.line_color.value(),this.line_alpha.value()),e=t[0],i=t[1],n=t[2],r=t[3];return"rgba("+255*e+","+255*i+","+255*n+","+r+")"},e}(i.ContextProperties=s);(i.Line=h).prototype.attrs=Object.keys(r.line()),h.prototype.do_attr="line_color";var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.set_value=function(t){t.fillStyle=this.fill_color.value(),t.globalAlpha=this.fill_alpha.value()},e.prototype._set_vectorize=function(t,e){this.cache_select("fill_color",e),t.fillStyle!==this.cache.fill_color&&(t.fillStyle=this.cache.fill_color),this.cache_select("fill_alpha",e),t.globalAlpha!==this.cache.fill_alpha&&(t.globalAlpha=this.cache.fill_alpha)},e.prototype.color_value=function(){var t=o.color2rgba(this.fill_color.value(),this.fill_alpha.value()),e=t[0],i=t[1],n=t[2],r=t[3];return"rgba("+255*e+","+255*i+","+255*n+","+r+")"},e}(s);(i.Fill=u).prototype.attrs=Object.keys(r.fill()),u.prototype.do_attr="fill_color";var c=function(a){function t(){return null!==a&&a.apply(this,arguments)||this}return n.__extends(t,a),t.prototype.cache_select=function(t,e){var i;if("font"==t){a.prototype.cache_select.call(this,"text_font_style",e),a.prototype.cache_select.call(this,"text_font_size",e),a.prototype.cache_select.call(this,"text_font",e);var n=this.cache,r=n.text_font_style,o=n.text_font_size,s=n.text_font;this.cache.font=i=r+" "+o+" "+s}else i=a.prototype.cache_select.call(this,t,e);return i},t.prototype.font_value=function(){var t=this.text_font.value(),e=this.text_font_size.value(),i=this.text_font_style.value();return i+" "+e+" "+t},t.prototype.color_value=function(){var t=o.color2rgba(this.text_color.value(),this.text_alpha.value()),e=t[0],i=t[1],n=t[2],r=t[3];return"rgba("+255*e+","+255*i+","+255*n+","+r+")"},t.prototype.set_value=function(t){t.font=this.font_value(),t.fillStyle=this.text_color.value(),t.globalAlpha=this.text_alpha.value(),t.textAlign=this.text_align.value(),t.textBaseline=this.text_baseline.value()},t.prototype._set_vectorize=function(t,e){this.cache_select("font",e),t.font!==this.cache.font&&(t.font=this.cache.font),this.cache_select("text_color",e),t.fillStyle!==this.cache.text_color&&(t.fillStyle=this.cache.text_color),this.cache_select("text_alpha",e),t.globalAlpha!==this.cache.text_alpha&&(t.globalAlpha=this.cache.text_alpha),this.cache_select("text_align",e),t.textAlign!==this.cache.text_align&&(t.textAlign=this.cache.text_align),this.cache_select("text_baseline",e),t.textBaseline!==this.cache.text_baseline&&(t.textBaseline=this.cache.text_baseline)},t}(s);(i.Text=c).prototype.attrs=Object.keys(r.text()),c.prototype.do_attr="text_color";var a=function(){function t(t){for(var e=0,i=t.mixins;e<i.length;e++){var n=i[e],r=n.split(":"),o=r[0],s=r[1],a=void 0===s?"":s,l=void 0;switch(o){case"line":l=h;break;case"fill":l=u;break;case"text":l=c;break;default:throw new Error("unknown visual: "+o)}this[a+o]=new l(t,a)}}return t.prototype.warm_cache=function(t){for(var e in this)if(this.hasOwnProperty(e)){var i=this[e];i instanceof s&&i.warm_cache(t)}},t.prototype.set_all_indices=function(t){for(var e in this)if(this.hasOwnProperty(e)){var i=this[e];i instanceof s&&(i.all_indices=t)}},t}();i.Visuals=a},function(t,e,i){var o=t(391),s=t(0),_=t(286),j=t(14),n=t(3),p=t(8),r=t(19),a=t(34),N=t(36),m=t(29),y=t(21),b=t(32),x=t(30),d=t(44),l=t(157),F=t(200),g=t(59),h=t(51),u=function(){function t(t){this.document=t,this.session=null,this.subscribed_models=new m.Set}return t.prototype.send_event=function(t){null!=this.session&&this.session.send_event(t)},t.prototype.trigger=function(t){for(var e=0,i=this.subscribed_models.values;e<i.length;e++){var n=i[e];if(null==t.model_id||t.model_id===n){var r=this.document._all_models[n];null!=r&&r._process_event(t)}}},t}();i.EventManager=u,i.documents=[],i.DEFAULT_TITLE="Bokeh Application";var c=function(){function P(){i.documents.push(this),this._init_timestamp=Date.now(),this._title=i.DEFAULT_TITLE,this._roots=[],this._all_models={},this._all_models_by_name=new m.MultiDict,this._all_models_freeze_count=0,this._callbacks=[],this.event_manager=new u(this),this.idle=new r.Signal0(this,"idle"),this._idle_roots=new WeakMap,this._interactive_timestamp=null,this._interactive_plot=null}return Object.defineProperty(P.prototype,"layoutables",{get:function(){return this._roots.filter(function(t){return t instanceof l.LayoutDOM})},enumerable:!0,configurable:!0}),Object.defineProperty(P.prototype,"is_idle",{get:function(){for(var t=0,e=this.layoutables;t<e.length;t++){var i=e[t];if(!this._idle_roots.has(i))return!1}return!0},enumerable:!0,configurable:!0}),P.prototype.notify_idle=function(t){this._idle_roots.set(t,!0),this.is_idle&&(j.logger.info("document idle at "+(Date.now()-this._init_timestamp)+" ms"),this.idle.emit())},P.prototype.clear=function(){this._push_all_models_freeze();try{for(;0<this._roots.length;)this.remove_root(this._roots[0])}finally{this._pop_all_models_freeze()}},P.prototype.interactive_start=function(t){null==this._interactive_plot&&(this._interactive_plot=t,this._interactive_plot.trigger_event(new n.LODStart({}))),this._interactive_timestamp=Date.now()},P.prototype.interactive_stop=function(t){null!=this._interactive_plot&&this._interactive_plot.id===t.id&&this._interactive_plot.trigger_event(new n.LODEnd({})),this._interactive_plot=null,this._interactive_timestamp=null},P.prototype.interactive_duration=function(){return null==this._interactive_timestamp?-1:Date.now()-this._interactive_timestamp},P.prototype.destructively_move=function(t){if(t===this)throw new Error("Attempted to overwrite a document with itself");t.clear();var e=y.copy(this._roots);this.clear();for(var i=0,n=e;i<n.length;i++){var r=n[i];if(null!=r.document)throw new Error("Somehow we didn't detach "+r)}if(0!==Object.keys(this._all_models).length)throw new Error("this._all_models still had stuff in it: "+this._all_models);for(var o=0,s=e;o<s.length;o++){var r=s[o];t.add_root(r)}t.set_title(this._title)},P.prototype._push_all_models_freeze=function(){this._all_models_freeze_count+=1},P.prototype._pop_all_models_freeze=function(){this._all_models_freeze_count-=1,0===this._all_models_freeze_count&&this._recompute_all_models()},P.prototype._invalidate_all_models=function(){j.logger.debug("invalidating document models"),0===this._all_models_freeze_count&&this._recompute_all_models()},P.prototype._recompute_all_models=function(){for(var t=new m.Set,e=0,i=this._roots;e<i.length;e++){var n=i[e];t=t.union(n.references())}for(var r=new m.Set(b.values(this._all_models)),o=r.diff(t),s=t.diff(r),a={},l=0,h=t.values;l<h.length;l++){var u=h[l];a[u.id]=u}for(var c=0,_=o.values;c<_.length;c++){var p=_[c];p.detach_document(),p instanceof g.Model&&null!=p.name&&this._all_models_by_name.remove_value(p.name,p)}for(var d=0,f=s.values;d<f.length;d++){var v=f[d];v.attach_document(this),v instanceof g.Model&&null!=v.name&&this._all_models_by_name.add_value(v.name,v)}this._all_models=a},P.prototype.roots=function(){return this._roots},P.prototype.add_root=function(t,e){if(j.logger.debug("Adding root: "+t),!y.includes(this._roots,t)){this._push_all_models_freeze();try{this._roots.push(t)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new h.RootAddedEvent(this,t,e))}},P.prototype.remove_root=function(t,e){var i=this._roots.indexOf(t);if(!(i<0)){this._push_all_models_freeze();try{this._roots.splice(i,1)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new h.RootRemovedEvent(this,t,e))}},P.prototype.title=function(){return this._title},P.prototype.set_title=function(t,e){t!==this._title&&(this._title=t,this._trigger_on_change(new h.TitleChangedEvent(this,t,e)))},P.prototype.get_model_by_id=function(t){return t in this._all_models?this._all_models[t]:null},P.prototype.get_model_by_name=function(t){return this._all_models_by_name.get_one(t,"Multiple models are named '"+t+"'")},P.prototype.on_change=function(t){y.includes(this._callbacks,t)||this._callbacks.push(t)},P.prototype.remove_on_change=function(t){var e=this._callbacks.indexOf(t);0<=e&&this._callbacks.splice(e,1)},P.prototype._trigger_on_change=function(t){for(var e=0,i=this._callbacks;e<i.length;e++){var n=i[e];n(t)}},P.prototype._notify_change=function(t,e,i,n,r){"name"===e&&(this._all_models_by_name.remove_value(i,t),null!=n&&this._all_models_by_name.add_value(n,t));var o=null!=r?r.setter_id:void 0,s=null!=r?r.hint:void 0;this._trigger_on_change(new h.ModelChangedEvent(this,t,e,i,n,o,s))},P._references_json=function(t,e){void 0===e&&(e=!0);for(var i=[],n=0,r=t;n<r.length;n++){var o=r[n],s=o.ref();s.attributes=o.attributes_as_json(e),delete s.attributes.id,i.push(s)}return i},P._instantiate_object=function(t,e,i){var n=o.__assign({},i,{id:t,__deferred__:!0}),r=s.Models(e);return new r(n)},P._instantiate_references_json=function(t,e){for(var i={},n=0,r=t;n<r.length;n++){var o=r[n],s=o.id,a=o.type,l=o.attributes||{},h=void 0;s in e?h=e[s]:(h=P._instantiate_object(s,a,l),null!=o.subtype&&h.set_subtype(o.subtype)),i[h.id]=h}return i},P._resolve_refs=function(t,e,i){function o(t){if(a.is_ref(t)){if(t.id in e)return e[t.id];if(t.id in i)return i[t.id];throw new Error("reference "+JSON.stringify(t)+" isn't known (not in Document?)")}return d.isArray(t)?function(t){for(var e=[],i=0,n=t;i<n.length;i++){var r=n[i];e.push(o(r))}return e}(t):d.isPlainObject(t)?function(t){var e={};for(var i in t){var n=t[i];e[i]=o(n)}return e}(t):t}return o(t)},P._initialize_references_json=function(t,e,i){for(var n={},r=0,o=t;r<o.length;r++){var s=o[r],a=s.id,l=s.attributes,h=!(a in e),u=h?i[a]:e[a],c=P._resolve_refs(l,e,i);n[u.id]=[u,c,h]}function _(h,u){var c={};function _(t){if(t instanceof p.HasProps){if(!(t.id in c)&&t.id in h){c[t.id]=!0;var e=h[t.id],i=e[1],n=e[2];for(var r in i){var o=i[r];_(o)}u(t,i,n)}}else if(d.isArray(t))for(var s=0,a=t;s<a.length;s++){var o=a[s];_(o)}else if(d.isPlainObject(t))for(var l in t){var o=t[l];_(o)}}for(var t in h){var e=h[t],i=e[0];_(i)}}_(n,function(t,e,i){i&&t.setv(e,{silent:!0})}),_(n,function(t,e,i){i&&t.finalize()})},P._event_for_attribute_change=function(t,e,i,n,r){var o=n.get_model_by_id(t.id);if(o.attribute_is_serializable(e)){var s={kind:"ModelChanged",model:{id:t.id,type:t.type},attr:e,new:i};return p.HasProps._json_record_references(n,i,r,!0),s}return null},P._events_to_sync_objects=function(t,e,i,n){for(var r=Object.keys(t.attributes),o=Object.keys(e.attributes),s=y.difference(r,o),a=y.difference(o,r),l=y.intersection(r,o),h=[],u=0,c=s;u<c.length;u++){var _=c[u];j.logger.warn("Server sent key "+_+" but we don't seem to have it in our JSON")}for(var p=0,d=a;p<d.length;p++){var _=d[p],f=e.attributes[_];h.push(P._event_for_attribute_change(t,_,f,i,n))}for(var v=0,m=l;v<m.length;v++){var _=m[v],g=t.attributes[_],f=e.attributes[_];null==g&&null==f||(null==g||null==f?h.push(P._event_for_attribute_change(t,_,f,i,n)):x.isEqual(g,f)||h.push(P._event_for_attribute_change(t,_,f,i,n)))}return h.filter(function(t){return null!=t})},P._compute_patch_since_json=function(t,e){var i=e.to_json(!1);function n(t){for(var e={},i=0,n=t.roots.references;i<n.length;i++){var r=n[i];e[r.id]=r}return e}for(var r=n(t),o={},s=[],a=0,l=t.roots.root_ids;a<l.length;a++){var h=l[a];o[h]=r[h],s.push(h)}for(var u=n(i),c={},_=[],p=0,d=i.roots.root_ids;p<d.length;p++){var h=d[p];c[h]=u[h],_.push(h)}if(s.sort(),_.sort(),0<y.difference(s,_).length||0<y.difference(_,s).length)throw new Error("Not implemented: computing add/remove of document roots");var f={},v=[];for(var m in e._all_models)if(m in r){var g=P._events_to_sync_objects(r[m],u[m],e,f);v=v.concat(g)}return{references:P._references_json(b.values(f),!1),events:v}},P.prototype.to_json_string=function(t){return void 0===t&&(t=!0),JSON.stringify(this.to_json(t))},P.prototype.to_json=function(t){void 0===t&&(t=!0);var e=this._roots.map(function(t){return t.id}),i=b.values(this._all_models);return{version:_.version,title:this._title,roots:{root_ids:e,references:P._references_json(i,t)}}},P.from_json_string=function(t){var e=JSON.parse(t);return P.from_json(e)},P.from_json=function(t){j.logger.debug("Creating Document from JSON");var e=t.version,i=-1!==e.indexOf("+")||-1!==e.indexOf("-"),n="Library versions: JS ("+_.version+") / Python ("+e+")";i||_.version===e?j.logger.debug(n):(j.logger.warn("JS/Python version mismatch"),j.logger.warn(n));var r=t.roots,o=r.root_ids,s=r.references,a=P._instantiate_references_json(s,{});P._initialize_references_json(s,{},a);for(var l=new P,h=0,u=o;h<u.length;h++){var c=u[h];l.add_root(a[c])}return l.set_title(t.title),l},P.prototype.replace_with_json=function(t){var e=P.from_json(t);e.destructively_move(this)},P.prototype.create_json_patch_string=function(t){return JSON.stringify(this.create_json_patch(t))},P.prototype.create_json_patch=function(t){for(var e={},i=[],n=0,r=t;n<r.length;n++){var o=r[n];if(o.document!==this)throw j.logger.warn("Cannot create a patch using events from a different document, event had ",o.document," we are ",this),new Error("Cannot create a patch using events from a different document");i.push(o.json(e))}return{events:i,references:P._references_json(b.values(e))}},P.prototype.apply_json_patch=function(t,e,i){for(var n,r=t.references,o=t.events,s=P._instantiate_references_json(r,this._all_models),a=0,l=o;a<l.length;a++){var h=l[a];switch(h.kind){case"RootAdded":case"RootRemoved":case"ModelChanged":var u=h.model.id;if(u in this._all_models)s[u]=this._all_models[u];else if(!(u in s))throw j.logger.warn("Got an event for unknown model ",h.model),new Error("event model wasn't known")}}var c={},_={};for(var p in s){var d=s[p];p in this._all_models?c[p]=d:_[p]=d}P._initialize_references_json(r,c,_);for(var f=0,v=o;f<v.length;f++){var h=v[f];switch(h.kind){case"ModelChanged":var m=h.model.id;if(!(m in this._all_models))throw new Error("Cannot apply patch to "+m+" which is not in the document");var g=this._all_models[m],y=h.attr,b=h.model.type;if("data"===y&&"ColumnDataSource"===b){var x=N.decode_column_data(h.new,e),w=x[0],k=x[1];g.setv({_shapes:k,data:w},{setter_id:i})}else{var d=P._resolve_refs(h.new,c,_);g.setv(((n={})[y]=d,n),{setter_id:i})}break;case"ColumnDataChanged":var S=h.column_source.id;if(!(S in this._all_models))throw new Error("Cannot stream to "+S+" which is not in the document");var C=this._all_models[S],T=N.decode_column_data(h.new,e),w=T[0],k=T[1];if(null!=h.cols){for(var A in C.data)A in w||(w[A]=C.data[A]);for(var A in C._shapes)A in k||(k[A]=C._shapes[A])}C.setv({_shapes:k,data:w},{setter_id:i,check_eq:!1});break;case"ColumnsStreamed":var S=h.column_source.id;if(!(S in this._all_models))throw new Error("Cannot stream to "+S+" which is not in the document");var C=this._all_models[S];if(!(C instanceof F.ColumnDataSource))throw new Error("Cannot stream to non-ColumnDataSource");var w=h.data,E=h.rollover;C.stream(w,E,i);break;case"ColumnsPatched":var S=h.column_source.id;if(!(S in this._all_models))throw new Error("Cannot patch "+S+" which is not in the document");var C=this._all_models[S];if(!(C instanceof F.ColumnDataSource))throw new Error("Cannot patch non-ColumnDataSource");var M=h.patches;C.patch(M,i);break;case"RootAdded":var O=h.model.id,z=s[O];this.add_root(z,i);break;case"RootRemoved":var O=h.model.id,z=s[O];this.remove_root(z,i);break;case"TitleChanged":this.set_title(h.title,i);break;default:throw new Error("Unknown patch event "+JSON.stringify(h))}}},P}();i.Document=c},function(t,e,i){var n=t(391),o=t(8),r=function(t){this.document=t},s=function(l){function t(t,e,i,n,r,o,s){var a=l.call(this,t)||this;return a.model=e,a.attr=i,a.old=n,a.new_=r,a.setter_id=o,a.hint=s,a}return n.__extends(t,l),t.prototype.json=function(t){if("id"===this.attr)throw new Error("'id' field should never change, whatever code just set it is wrong");if(null!=this.hint)return this.hint.json(t);var e=this.new_,i=o.HasProps._value_to_json(this.attr,e,this.model),n={};for(var r in o.HasProps._value_record_references(e,n,!0),this.model.id in n&&this.model!==e&&delete n[this.model.id],n)t[r]=n[r];return{kind:"ModelChanged",model:this.model.ref(),attr:this.attr,new:i}},t}(i.DocumentChangedEvent=r);i.ModelChangedEvent=s;var a=function(r){function t(t,e,i){var n=r.call(this,t)||this;return n.column_source=e,n.patches=i,n}return n.__extends(t,r),t.prototype.json=function(t){return{kind:"ColumnsPatched",column_source:this.column_source,patches:this.patches}},t}(r);i.ColumnsPatchedEvent=a;var l=function(o){function t(t,e,i,n){var r=o.call(this,t)||this;return r.column_source=e,r.data=i,r.rollover=n,r}return n.__extends(t,o),t.prototype.json=function(t){return{kind:"ColumnsStreamed",column_source:this.column_source,data:this.data,rollover:this.rollover}},t}(r);i.ColumnsStreamedEvent=l;var h=function(r){function t(t,e,i){var n=r.call(this,t)||this;return n.title=e,n.setter_id=i,n}return n.__extends(t,r),t.prototype.json=function(t){return{kind:"TitleChanged",title:this.title}},t}(r);i.TitleChangedEvent=h;var u=function(r){function t(t,e,i){var n=r.call(this,t)||this;return n.model=e,n.setter_id=i,n}return n.__extends(t,r),t.prototype.json=function(t){return o.HasProps._value_record_references(this.model,t,!0),{kind:"RootAdded",model:this.model.ref()}},t}(r);i.RootAddedEvent=u;var c=function(r){function t(t,e,i){var n=r.call(this,t)||this;return n.model=e,n.setter_id=i,n}return n.__extends(t,r),t.prototype.json=function(t){return{kind:"RootRemoved",model:this.model.ref()}},t}(r);i.RootRemovedEvent=c},function(t,e,i){var n=t(391);n.__exportStar(t(50),i),n.__exportStar(t(51),i)},function(t,e,n){var r=t(5);function o(t){var e=document.getElementById(t);if(null==e)throw new Error("Error rendering Bokeh model: could not find #"+t+" HTML tag");if(!document.body.contains(e))throw new Error("Error rendering Bokeh model: element #"+t+" must be under <body>");if("SCRIPT"==e.tagName){var i=r.div({class:n.BOKEH_ROOT});r.replaceWith(e,i),e=i}return e}n.BOKEH_ROOT="bk-root",n.inject_css=function(t){var e=r.link({href:t,rel:"stylesheet",type:"text/css"});document.body.appendChild(e)},n.inject_raw_css=function(t){var e=r.style({},t);document.body.appendChild(e)},n._resolve_element=function(t){var e=t.elementid;return null!=e?o(e):document.body},n._resolve_root_elements=function(t){var e={};if(null!=t.roots)for(var i in t.roots)e[i]=o(t.roots[i]);return e}},function(t,e,i){var d=t(52),f=t(14),s=t(25),v=t(38),m=t(44),g=t(57),y=t(56),b=t(53),n=t(57);i.add_document_standalone=n.add_document_standalone;var r=t(56);i.add_document_from_session=r.add_document_from_session;var o=t(55);i.embed_items_notebook=o.embed_items_notebook,i.kernels=o.kernels;var a=t(53);function l(t,e,i,n){m.isString(t)&&(t=JSON.parse(v.unescape(t)));var r={};for(var o in t){var s=t[o];r[o]=d.Document.from_json(s)}for(var a=0,l=e;a<l.length;a++){var h=l[a],u=b._resolve_element(h),c=b._resolve_root_elements(h);if(null!=h.docid)g.add_document_standalone(r[h.docid],u,c,h.use_for_title);else{if(null==h.sessionid)throw new Error("Error rendering Bokeh items: either 'docid' or 'sessionid' was expected.");var _=y._get_ws_url(i,n);f.logger.debug("embed: computed ws url: "+_);var p=y.add_document_from_session(_,h.sessionid,u,c,h.use_for_title);p.then(function(){console.log("Bokeh items were rendered successfully")},function(t){console.log("Error rendering Bokeh items:",t)})}}}i.BOKEH_ROOT=a.BOKEH_ROOT,i.inject_css=a.inject_css,i.inject_raw_css=a.inject_raw_css,i.embed_item=function(t,e){var i,n={},r=v.uuid4();n[r]=t.doc,null==e&&(e=t.target_id);var o={roots:((i={})[t.root_id]=e,i),docid:r};s.defer(function(){return l(n,[o])})},i.embed_items=function(t,e,i,n){s.defer(function(){return l(t,e,i,n)})}},function(t,e,r){var l=t(52),o=t(283),s=t(14),h=t(32),u=t(57),c=t(53);function a(t,e){0<e.buffers.length?t.consume(e.buffers[0].buffer):t.consume(e.content.data);var i=t.message;null!=i&&this.apply_json_patch(i.content,i.buffers)}function _(i,n){if("undefined"!=typeof Jupyter&&null!=Jupyter.notebook.kernel){s.logger.info("Registering Jupyter comms for target "+i);var t=Jupyter.notebook.kernel.comm_manager;try{t.register_target(i,function(t){s.logger.info("Registering Jupyter comms for target "+i);var e=new o.Receiver;t.on_msg(a.bind(n,e))})}catch(t){s.logger.warn("Jupyter comms failed to register. push_notebook() will not function. (exception reported: "+t+")")}}else if(n.roots()[0].id in r.kernels){s.logger.info("Registering JupyterLab comms for target "+i);var e=r.kernels[n.roots()[0].id];try{e.registerCommTarget(i,function(t){s.logger.info("Registering JupyterLab comms for target "+i);var e=new o.Receiver;t.onMsg=a.bind(n,e)})}catch(t){s.logger.warn("Jupyter comms failed to register. push_notebook() will not function. (exception reported: "+t+")")}}else console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest jupyterlab_bokeh extension is installed. In an exported notebook this warning is expected.")}r.kernels={},r.embed_items_notebook=function(t,e){if(1!=h.size(t))throw new Error("embed_items_notebook expects exactly one document in docs_json");for(var i=l.Document.from_json(h.values(t)[0]),n=0,r=e;n<r.length;n++){var o=r[n];null!=o.notebook_comms_target&&_(o.notebook_comms_target,i);var s=c._resolve_element(o),a=c._resolve_root_elements(o);u.add_document_standalone(i,s,a)}}},function(t,e,i){var s=t(1),a=t(14),l=t(57);i._get_ws_url=function(t,e){var i,n="ws:";return"https:"==window.location.protocol&&(n="wss:"),null!=e?(i=document.createElement("a")).href=e:i=window.location,null!=t?"/"==t&&(t=""):t=i.pathname.replace(/\/+$/,""),n+"//"+i.host+t+"/ws"};var h={};i.add_document_from_session=function(t,e,i,n,r){void 0===n&&(n={}),void 0===r&&(r=!1);var o=window.location.search.substr(1);return function(t,e,i){t in h||(h[t]={});var n=h[t];return e in n||(n[e]=s.pull_session(t,e,i)),n[e]}(t,e,o).then(function(t){return l.add_document_standalone(t.document,i,n,r)},function(t){throw a.logger.error("Failed to load Bokeh session "+e+": "+t),t})}},function(t,e,i){var h=t(52),u=t(5),c=t(0),_=t(53);i.add_document_standalone=function(t,o,s,e){void 0===s&&(s={}),void 0===e&&(e=!1);var a={};function i(t){var e;t.id in s?e=s[t.id]:o.classList.contains(_.BOKEH_ROOT)?e=o:(e=u.div({class:_.BOKEH_ROOT}),o.appendChild(e));var i,n,r=(n=new(i=t).default_view({model:i,parent:null}),c.index[i.id]=n);r.renderTo(e),a[t.id]=r}for(var n=0,r=t.roots();n<r.length;n++){var l=r[n];i(l)}return e&&(window.document.title=t.title()),t.on_change(function(t){t instanceof h.RootAddedEvent?i(t.model):t instanceof h.RootRemovedEvent?function(t){var e=t.id;if(e in a){var i=a[e];i.remove(),delete a[e],delete c.index[e]}}(t.model):e&&t instanceof h.TitleChangedEvent&&(window.document.title=t.title)}),a}},function(t,e,i){t(280);var n=t(286);i.version=n.version;var r=t(54);i.embed=r;var o=t(281);i.protocol=o;var s=t(285);i._testing=s;var a=t(14);i.logger=a.logger,i.set_log_level=a.set_log_level;var l=t(18);i.settings=l.settings;var h=t(0);i.Models=h.Models,i.index=h.index;var u=t(52);i.documents=u.documents;var c=t(284);i.safely=c.safely},function(t,e,i){var n=t(391),r=t(8),o=t(15),s=t(44),a=t(32),l=t(14),h=function(_){function i(t){return _.call(this,t)||this}return n.__extends(i,_),i.initClass=function(){this.prototype.type="Model",this.define({tags:[o.Array,[]],name:[o.String],js_property_callbacks:[o.Any,{}],js_event_callbacks:[o.Any,{}],subscribed_events:[o.Array,[]]})},i.prototype.connect_signals=function(){var i=this;for(var t in _.prototype.connect_signals.call(this),this.js_property_callbacks)for(var e=this.js_property_callbacks[t],n=t.split(":"),r=n[0],o=n[1],s=void 0===o?null:o,a=function(t){var e=null!=s?l.properties[s][r]:l[r];l.connect(e,function(){return t.execute(i,{})})},l=this,h=0,u=e;h<u.length;h++){var c=u[h];a(c)}this.connect(this.properties.js_event_callbacks.change,function(){return i._update_event_callbacks}),this.connect(this.properties.subscribed_events.change,function(){return i._update_event_callbacks})},i.prototype._process_event=function(e){if(e.is_applicable_to(this)){e=e._customize_event(this);for(var t=0,i=this.js_event_callbacks[e.event_name]||[];t<i.length;t++){var n=i[t];n.execute(e,{})}null!=this.document&&this.subscribed_events.some(function(t){return t==e.event_name})&&this.document.event_manager.send_event(e)}},i.prototype.trigger_event=function(t){null!=this.document&&this.document.event_manager.trigger(t.set_model_id(this.id))},i.prototype._update_event_callbacks=function(){null!=this.document?this.document.event_manager.subscribed_models.add(this.id):l.logger.warn("WARNING: Document not defined for updating event callbacks")},i.prototype._doc_attached=function(){a.isEmpty(this.js_event_callbacks)&&a.isEmpty(this.subscribed_events)||this._update_event_callbacks()},i.prototype.select=function(e){if(s.isString(e))return this.references().filter(function(t){return t instanceof i&&t.name===e});if(e.prototype instanceof r.HasProps)return this.references().filter(function(t){return t instanceof e});throw new Error("invalid selector")},i.prototype.select_one=function(t){var e=this.select(t);switch(e.length){case 0:return null;case 1:return e[0];default:throw new Error("found more than one object matching given selector")}},i}(r.HasProps);(i.Model=h).initClass()},function(t,e,i){var n=t(391),r=t(12),o=t(15),s=t(33),a=t(32),l=t(189),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._get_size=function(){throw new Error("not implemented")},e.prototype.get_size=function(){return this.model.visible?Math.round(this._get_size()):0},e.prototype.set_data=function(t){var e,i,n=this.model.materialize_dataspecs(t);if(a.extend(this,n),this.plot_model.use_map){var r=this;null!=r._x&&(e=s.project_xy(r._x,r._y),r._x=e[0],r._y=e[1]),null!=r._xs&&(i=s.project_xsys(r._xs,r._ys),r._xs=i[0],r._ys=i[1])}},e}(l.RendererView);i.AnnotationView=h;var u=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Annotation",this.define({plot:[o.Instance]}),this.override({level:"annotation"})},t.prototype.add_panel=function(t){if(null==this.panel||t!==this.panel.side){var e=new r.SidePanel({side:t});e.attach_document(this.document),this.set_panel(e)}},t.prototype.set_panel=function(t){this.panel=t,this.level="overlay"},t}(l.Renderer);(i.Annotation=u).initClass()},function(t,e,i){var n=t(391),r=t(60),o=t(62),s=t(200),a=t(15),l=t(31),h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),null==this.model.source&&(this.model.source=new s.ColumnDataSource),this.set_data(this.model.source)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.plot_view.request_render()}),this.connect(this.model.source.streaming,function(){return t.set_data(t.model.source)}),this.connect(this.model.source.patching,function(){return t.set_data(t.model.source)}),this.connect(this.model.source.change,function(){return t.set_data(t.model.source)})},t.prototype.set_data=function(t){e.prototype.set_data.call(this,t),this.visuals.warm_cache(t),this.plot_view.request_render()},t.prototype._map_data=function(){var t,e,i,n,r=this.plot_view.frame;return"data"==this.model.start_units?(t=r.xscales[this.model.x_range_name].v_compute(this._x_start),e=r.yscales[this.model.y_range_name].v_compute(this._y_start)):(t=r.xview.v_compute(this._x_start),e=r.yview.v_compute(this._y_start)),"data"==this.model.end_units?(i=r.xscales[this.model.x_range_name].v_compute(this._x_end),n=r.yscales[this.model.y_range_name].v_compute(this._y_end)):(i=r.xview.v_compute(this._x_end),n=r.yview.v_compute(this._y_end)),[[t,e],[i,n]]},t.prototype.render=function(){if(this.model.visible){var t=this.plot_view.canvas_view.ctx;t.save();var e=this._map_data(),i=e[0],n=e[1];null!=this.model.end&&this._arrow_head(t,"render",this.model.end,i,n),null!=this.model.start&&this._arrow_head(t,"render",this.model.start,n,i),t.beginPath();var r=this.plot_model.canvas.bbox.rect,o=r.x,s=r.y,a=r.width,l=r.height;t.rect(o,s,a,l),null!=this.model.end&&this._arrow_head(t,"clip",this.model.end,i,n),null!=this.model.start&&this._arrow_head(t,"clip",this.model.start,n,i),t.closePath(),t.clip(),this._arrow_body(t,i,n),t.restore()}},t.prototype._arrow_head=function(t,e,i,n,r){for(var o=0,s=this._x_start.length;o<s;o++){var a=Math.PI/2+l.atan2([n[0][o],n[1][o]],[r[0][o],r[1][o]]);t.save(),t.translate(r[0][o],r[1][o]),t.rotate(a),"render"==e?i.render(t,o):"clip"==e&&i.clip(t,o),t.restore()}},t.prototype._arrow_body=function(t,e,i){if(this.visuals.line.doit)for(var n=0,r=this._x_start.length;n<r;n++)this.visuals.line.set_vectorize(t,n),t.beginPath(),t.moveTo(e[0][n],e[1][n]),t.lineTo(i[0][n],i[1][n]),t.stroke()},t}(r.AnnotationView);i.ArrowView=h;var u=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Arrow",this.prototype.default_view=h,this.mixins(["line"]),this.define({x_start:[a.NumberSpec],y_start:[a.NumberSpec],start_units:[a.String,"data"],start:[a.Instance,null],x_end:[a.NumberSpec],y_end:[a.NumberSpec],end_units:[a.String,"data"],end:[a.Instance,function(){return new o.OpenHead({})}],source:[a.Instance],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"]})},t}(r.Annotation);(i.Arrow=u).initClass()},function(t,e,i){var n=t(391),r=t(60),o=t(49),s=t(15),a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="ArrowHead",this.define({size:[s.Number,25]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this.visuals=new o.Visuals(this)},t}(r.Annotation);(i.ArrowHead=a).initClass();var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="OpenHead",this.mixins(["line"])},t.prototype.clip=function(t,e){this.visuals.line.set_vectorize(t,e),t.moveTo(.5*this.size,this.size),t.lineTo(.5*this.size,-2),t.lineTo(-.5*this.size,-2),t.lineTo(-.5*this.size,this.size),t.lineTo(0,0),t.lineTo(.5*this.size,this.size)},t.prototype.render=function(t,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,e),t.beginPath(),t.moveTo(.5*this.size,this.size),t.lineTo(0,0),t.lineTo(-.5*this.size,this.size),t.stroke())},t}(a);(i.OpenHead=l).initClass();var h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="NormalHead",this.mixins(["line","fill"]),this.override({fill_color:"black"})},t.prototype.clip=function(t,e){this.visuals.line.set_vectorize(t,e),t.moveTo(.5*this.size,this.size),t.lineTo(.5*this.size,-2),t.lineTo(-.5*this.size,-2),t.lineTo(-.5*this.size,this.size),t.lineTo(.5*this.size,this.size)},t.prototype.render=function(t,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,e),this._normal(t,e),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,e),this._normal(t,e),t.stroke())},t.prototype._normal=function(t,e){t.beginPath(),t.moveTo(.5*this.size,this.size),t.lineTo(0,0),t.lineTo(-.5*this.size,this.size),t.closePath()},t}(a);(i.NormalHead=h).initClass();var u=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="VeeHead",this.mixins(["line","fill"]),this.override({fill_color:"black"})},t.prototype.clip=function(t,e){this.visuals.line.set_vectorize(t,e),t.moveTo(.5*this.size,this.size),t.lineTo(.5*this.size,-2),t.lineTo(-.5*this.size,-2),t.lineTo(-.5*this.size,this.size),t.lineTo(0,.5*this.size),t.lineTo(.5*this.size,this.size)},t.prototype.render=function(t,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,e),this._vee(t,e),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,e),this._vee(t,e),t.stroke())},t.prototype._vee=function(t,e){t.beginPath(),t.moveTo(.5*this.size,this.size),t.lineTo(0,0),t.lineTo(-.5*this.size,this.size),t.lineTo(0,.5*this.size),t.closePath()},t}(a);(i.VeeHead=u).initClass();var c=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="TeeHead",this.mixins(["line"])},t.prototype.render=function(t,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,e),t.beginPath(),t.moveTo(.5*this.size,0),t.lineTo(-.5*this.size,0),t.stroke())},t.prototype.clip=function(t,e){},t}(a);(i.TeeHead=c).initClass()},function(t,e,i){var n=t(391),r=t(60),o=t(200),s=t(15),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),this.set_data(this.model.source)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.source.streaming,function(){return t.set_data(t.model.source)}),this.connect(this.model.source.patching,function(){return t.set_data(t.model.source)}),this.connect(this.model.source.change,function(){return t.set_data(t.model.source)})},t.prototype.set_data=function(t){e.prototype.set_data.call(this,t),this.visuals.warm_cache(t),this.plot_view.request_render()},t.prototype._map_data=function(){var t,e,i,n=this.plot_view.frame,r=this.model.dimension,o=n.xscales[this.model.x_range_name],s=n.yscales[this.model.y_range_name],a="height"==r?s:o,l="height"==r?o:s,h="height"==r?n.yview:n.xview,u="height"==r?n.xview:n.yview;t="data"==this.model.lower.units?a.v_compute(this._lower):h.v_compute(this._lower),e="data"==this.model.upper.units?a.v_compute(this._upper):h.v_compute(this._upper),i="data"==this.model.base.units?l.v_compute(this._base):u.v_compute(this._base);var c="height"==r?[1,0]:[0,1],_=c[0],p=c[1],d=[t,i],f=[e,i];this._lower_sx=d[_],this._lower_sy=d[p],this._upper_sx=f[_],this._upper_sy=f[p]},t.prototype.render=function(){if(this.model.visible){this._map_data();var t=this.plot_view.canvas_view.ctx;t.beginPath(),t.moveTo(this._lower_sx[0],this._lower_sy[0]);for(var e=0,i=this._lower_sx.length;e<i;e++)t.lineTo(this._lower_sx[e],this._lower_sy[e]);for(var n=this._upper_sx.length-1,e=n;0<=e;e--)t.lineTo(this._upper_sx[e],this._upper_sy[e]);t.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_value(t),t.fill()),t.beginPath(),t.moveTo(this._lower_sx[0],this._lower_sy[0]);for(var e=0,i=this._lower_sx.length;e<i;e++)t.lineTo(this._lower_sx[e],this._lower_sy[e]);this.visuals.line.doit&&(this.visuals.line.set_value(t),t.stroke()),t.beginPath(),t.moveTo(this._upper_sx[0],this._upper_sy[0]);for(var e=0,i=this._upper_sx.length;e<i;e++)t.lineTo(this._upper_sx[e],this._upper_sy[e]);this.visuals.line.doit&&(this.visuals.line.set_value(t),t.stroke())}},t}(r.AnnotationView);i.BandView=a;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Band",this.prototype.default_view=a,this.mixins(["line","fill"]),this.define({lower:[s.DistanceSpec],upper:[s.DistanceSpec],base:[s.DistanceSpec],dimension:[s.Dimension,"height"],source:[s.Instance,function(){return new o.ColumnDataSource}],x_range_name:[s.String,"default"],y_range_name:[s.String,"default"]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},t}(r.Annotation);(i.Band=l).initClass()},function(t,e,i){var n=t(391),r=t(60),o=t(19),l=t(5),s=t(15),a=t(24);i.EDGE_TOLERANCE=2.5;var h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),this.plot_view.canvas_overlays.appendChild(this.el),this.el.classList.add("bk-shading"),l.hide(this.el)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),"css"==this.model.render_mode?(this.connect(this.model.change,function(){return t.render()}),this.connect(this.model.data_update,function(){return t.render()})):(this.connect(this.model.change,function(){return t.plot_view.request_render()}),this.connect(this.model.data_update,function(){return t.plot_view.request_render()}))},t.prototype.render=function(){var o=this;if(this.model.visible||"css"!=this.model.render_mode||l.hide(this.el),this.model.visible)if(null!=this.model.left||null!=this.model.right||null!=this.model.top||null!=this.model.bottom){var t=this.plot_model.frame,e=t.xscales[this.model.x_range_name],i=t.yscales[this.model.y_range_name],n=function(t,e,i,n,r){return null!=t?o.model.screen?t:"data"==e?i.compute(t):n.compute(t):r};this.sleft=n(this.model.left,this.model.left_units,e,t.xview,t._left.value),this.sright=n(this.model.right,this.model.right_units,e,t.xview,t._right.value),this.stop=n(this.model.top,this.model.top_units,i,t.yview,t._top.value),this.sbottom=n(this.model.bottom,this.model.bottom_units,i,t.yview,t._bottom.value);var r="css"==this.model.render_mode?this._css_box.bind(this):this._canvas_box.bind(this);r(this.sleft,this.sright,this.sbottom,this.stop)}else l.hide(this.el)},t.prototype._css_box=function(t,e,i,n){var r=this.model.properties.line_width.value(),o=Math.floor(e-t)-r,s=Math.floor(i-n)-r;this.el.style.left=t+"px",this.el.style.width=o+"px",this.el.style.top=n+"px",this.el.style.height=s+"px",this.el.style.borderWidth=r+"px",this.el.style.borderColor=this.model.properties.line_color.value(),this.el.style.backgroundColor=this.model.properties.fill_color.value(),this.el.style.opacity=this.model.properties.fill_alpha.value();var a=this.model.properties.line_dash.value().length<2?"solid":"dashed";this.el.style.borderStyle=a,l.show(this.el)},t.prototype._canvas_box=function(t,e,i,n){var r=this.plot_view.canvas_view.ctx;r.save(),r.beginPath(),r.rect(t,n,e-t,i-n),this.visuals.fill.set_value(r),r.fill(),this.visuals.line.set_value(r),r.stroke(),r.restore()},t.prototype.interactive_bbox=function(){var t=this.model.properties.line_width.value()+i.EDGE_TOLERANCE;return new a.BBox({x0:this.sleft-t,y0:this.stop-t,x1:this.sright+t,y1:this.sbottom+t})},t.prototype.interactive_hit=function(t,e){if(null==this.model.in_cursor)return!1;var i=this.interactive_bbox();return i.contains(t,e)},t.prototype.cursor=function(t,e){return Math.abs(t-this.sleft)<3||Math.abs(t-this.sright)<3?this.model.ew_cursor:Math.abs(e-this.sbottom)<3||Math.abs(e-this.stop)<3?this.model.ns_cursor:t>this.sleft&&t<this.sright&&e>this.stop&&e<this.sbottom?this.model.in_cursor:null},t}(r.AnnotationView);i.BoxAnnotationView=h;var u=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="BoxAnnotation",this.prototype.default_view=h,this.mixins(["line","fill"]),this.define({render_mode:[s.RenderMode,"canvas"],x_range_name:[s.String,"default"],y_range_name:[s.String,"default"],top:[s.Number,null],top_units:[s.SpatialUnits,"data"],bottom:[s.Number,null],bottom_units:[s.SpatialUnits,"data"],left:[s.Number,null],left_units:[s.SpatialUnits,"data"],right:[s.Number,null],right_units:[s.SpatialUnits,"data"]}),this.internal({screen:[s.Boolean,!1],ew_cursor:[s.String,null],ns_cursor:[s.String,null],in_cursor:[s.String,null]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this.data_update=new o.Signal0(this,"data_update")},t.prototype.update=function(t){var e=t.left,i=t.right,n=t.top,r=t.bottom;this.setv({left:e,right:i,top:n,bottom:r,screen:!0},{silent:!0}),this.data_update.emit()},t}(r.Annotation);(i.BoxAnnotation=u).initClass()},function(t,e,i){var n=t(391),r=t(60),o=t(207),s=t(104),u=t(167),a=t(192),l=t(193),h=t(184),c=t(15),_=t(41),p=t(21),g=t(22),d=t(32),f=t(44),v=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),this._set_canvas_image()},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.visible.change,function(){return t.plot_view.request_render()}),this.connect(this.model.ticker.change,function(){return t.plot_view.request_render()}),this.connect(this.model.formatter.change,function(){return t.plot_view.request_render()}),null!=this.model.color_mapper&&this.connect(this.model.color_mapper.change,function(){t._set_canvas_image(),t.plot_view.request_render()})},t.prototype._get_size=function(){if(null==this.model.color_mapper)return 0;var t=this.compute_legend_dimensions(),e=this.model.panel.side;switch(e){case"above":case"below":return t.height;case"left":case"right":return t.width;default:throw new Error("unreachable code")}},t.prototype._set_canvas_image=function(){var t,e;if(null!=this.model.color_mapper){var i,n,r=this.model.color_mapper.palette;switch("vertical"==this.model.orientation&&(r=p.reversed(r)),this.model.orientation){case"vertical":t=[1,r.length],i=t[0],n=t[1];break;case"horizontal":e=[r.length,1],i=e[0],n=e[1];break;default:throw new Error("unreachable code")}var o=document.createElement("canvas");o.width=i,o.height=n;var s=o.getContext("2d"),a=s.getImageData(0,0,i,n),l=new u.LinearColorMapper({palette:r}).rgba_mapper,h=l.v_compute(p.range(0,r.length));a.data.set(h),s.putImageData(a,0,0),this.image=o}},t.prototype.compute_legend_dimensions=function(){var t,e,i=this.model._computed_image_dimensions(),n=[i.height,i.width],r=n[0],o=n[1],s=this._get_label_extent(),a=this.model._title_extent(),l=this.model._tick_extent(),h=this.model.padding;switch(this.model.orientation){case"vertical":t=r+a+2*h,e=o+l+s+2*h;break;case"horizontal":t=r+a+l+s+2*h,e=o+2*h;break;default:throw new Error("unreachable code")}return{width:e,height:t}},t.prototype.compute_legend_location=function(){var t,e,i=this.compute_legend_dimensions(),n=[i.height,i.width],r=n[0],o=n[1],s=this.model.margin,a=null!=this.model.panel?this.model.panel:this.plot_view.frame,l=a.bbox.ranges,h=l[0],u=l[1],c=this.model.location;if(f.isString(c))switch(c){case"top_left":t=h.start+s,e=u.start+s;break;case"top_center":t=(h.end+h.start)/2-o/2,e=u.start+s;break;case"top_right":t=h.end-s-o,e=u.start+s;break;case"bottom_right":t=h.end-s-o,e=u.end-s-r;break;case"bottom_center":t=(h.end+h.start)/2-o/2,e=u.end-s-r;break;case"bottom_left":t=h.start+s,e=u.end-s-r;break;case"center_left":t=h.start+s,e=(u.end+u.start)/2-r/2;break;case"center":t=(h.end+h.start)/2-o/2,e=(u.end+u.start)/2-r/2;break;case"center_right":t=h.end-s-o,e=(u.end+u.start)/2-r/2;break;default:throw new Error("unreachable code")}else{if(!f.isArray(c)||2!=c.length)throw new Error("unreachable code");var _=c[0],p=c[1];t=a.xview.compute(_),e=a.yview.compute(p)-r}return{sx:t,sy:e}},t.prototype.render=function(){if(this.model.visible&&null!=this.model.color_mapper){var t=this.plot_view.canvas_view.ctx;t.save();var e=this.compute_legend_location(),i=e.sx,n=e.sy;t.translate(i,n),this._draw_bbox(t);var r=this._get_image_offset();if(t.translate(r.x,r.y),this._draw_image(t),null!=this.model.color_mapper.low&&null!=this.model.color_mapper.high){var o=this.model.tick_info();this._draw_major_ticks(t,o),this._draw_minor_ticks(t,o),this._draw_major_labels(t,o)}this.model.title&&this._draw_title(t),t.restore()}},t.prototype._draw_bbox=function(t){var e=this.compute_legend_dimensions();t.save(),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(0,0,e.width,e.height)),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()},t.prototype._draw_image=function(t){var e=this.model._computed_image_dimensions();t.save(),t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.scale_alpha,t.drawImage(this.image,0,0,e.width,e.height),this.visuals.bar_line.doit&&(this.visuals.bar_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()},t.prototype._draw_major_ticks=function(t,e){if(this.visuals.major_tick_line.doit){var i=this.model._normals(),n=i[0],r=i[1],o=this.model._computed_image_dimensions(),s=[o.width*n,o.height*r],a=s[0],l=s[1],h=e.coords.major,u=h[0],c=h[1],_=this.model.major_tick_in,p=this.model.major_tick_out;t.save(),t.translate(a,l),this.visuals.major_tick_line.set_value(t);for(var d=0,f=u.length;d<f;d++)t.beginPath(),t.moveTo(Math.round(u[d]+n*p),Math.round(c[d]+r*p)),t.lineTo(Math.round(u[d]-n*_),Math.round(c[d]-r*_)),t.stroke();t.restore()}},t.prototype._draw_minor_ticks=function(t,e){if(this.visuals.minor_tick_line.doit){var i=this.model._normals(),n=i[0],r=i[1],o=this.model._computed_image_dimensions(),s=[o.width*n,o.height*r],a=s[0],l=s[1],h=e.coords.minor,u=h[0],c=h[1],_=this.model.minor_tick_in,p=this.model.minor_tick_out;t.save(),t.translate(a,l),this.visuals.minor_tick_line.set_value(t);for(var d=0,f=u.length;d<f;d++)t.beginPath(),t.moveTo(Math.round(u[d]+n*p),Math.round(c[d]+r*p)),t.lineTo(Math.round(u[d]-n*_),Math.round(c[d]-r*_)),t.stroke();t.restore()}},t.prototype._draw_major_labels=function(t,e){if(this.visuals.major_label_text.doit){var i=this.model._normals(),n=i[0],r=i[1],o=this.model._computed_image_dimensions(),s=[o.width*n,o.height*r],a=s[0],l=s[1],h=this.model.label_standoff+this.model._tick_extent(),u=[h*n,h*r],c=u[0],_=u[1],p=e.coords.major,d=p[0],f=p[1],v=e.labels.major;this.visuals.major_label_text.set_value(t),t.save(),t.translate(a+c,l+_);for(var m=0,g=d.length;m<g;m++)t.fillText(v[m],Math.round(d[m]+n*this.model.label_standoff),Math.round(f[m]+r*this.model.label_standoff));t.restore()}},t.prototype._draw_title=function(t){this.visuals.title_text.doit&&(t.save(),this.visuals.title_text.set_value(t),t.fillText(this.model.title,0,-this.model.title_standoff),t.restore())},t.prototype._get_label_extent=function(){var t,e=this.model.tick_info().labels.major;if(null==this.model.color_mapper.low||null==this.model.color_mapper.high||d.isEmpty(e))t=0;else{var i=this.plot_view.canvas_view.ctx;switch(i.save(),this.visuals.major_label_text.set_value(i),this.model.orientation){case"vertical":t=p.max(e.map(function(t){return i.measureText(t.toString()).width}));break;case"horizontal":t=_.get_text_height(this.visuals.major_label_text.font_value()).height;break;default:throw new Error("unreachable code")}t+=this.model.label_standoff,i.restore()}return t},t.prototype._get_image_offset=function(){var t=this.model.padding,e=this.model.padding+this.model._title_extent();return{x:t,y:e}},t}(r.AnnotationView);i.ColorBarView=v;var m=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="ColorBar",this.prototype.default_view=v,this.mixins(["text:major_label_","text:title_","line:major_tick_","line:minor_tick_","line:border_","line:bar_","fill:background_"]),this.define({location:[c.Any,"top_right"],orientation:[c.Orientation,"vertical"],title:[c.String],title_standoff:[c.Number,2],width:[c.Any,"auto"],height:[c.Any,"auto"],scale_alpha:[c.Number,1],ticker:[c.Instance,function(){return new o.BasicTicker}],formatter:[c.Instance,function(){return new s.BasicTickFormatter}],major_label_overrides:[c.Any,{}],color_mapper:[c.Instance],label_standoff:[c.Number,5],margin:[c.Number,30],padding:[c.Number,10],major_tick_in:[c.Number,5],major_tick_out:[c.Number,0],minor_tick_in:[c.Number,0],minor_tick_out:[c.Number,0]}),this.override({background_fill_color:"#ffffff",background_fill_alpha:.95,bar_line_color:null,border_line_color:null,major_label_text_align:"center",major_label_text_baseline:"middle",major_label_text_font_size:"8pt",major_tick_line_color:"#ffffff",minor_tick_line_color:null,title_text_font_size:"10pt",title_text_font_style:"italic"})},t.prototype._normals=function(){return"vertical"==this.orientation?[1,0]:[0,1]},t.prototype._title_extent=function(){var t=this.title_text_font+" "+this.title_text_font_size+" "+this.title_text_font_style,e=this.title?_.get_text_height(t).height+this.title_standoff:0;return e},t.prototype._tick_extent=function(){return null!=this.color_mapper.low&&null!=this.color_mapper.high?p.max([this.major_tick_out,this.minor_tick_out]):0},t.prototype._computed_image_dimensions=function(){var t,e,i=this.plot.plot_canvas.frame._height.value,n=this.plot.plot_canvas.frame._width.value,r=this._title_extent();switch(this.orientation){case"vertical":"auto"==this.height?null!=this.panel?t=i-2*this.padding-r:(t=p.max([25*this.color_mapper.palette.length,.3*i]),t=p.min([t,.8*i-2*this.padding-r])):t=this.height,e="auto"==this.width?25:this.width;break;case"horizontal":t="auto"==this.height?25:this.height,"auto"==this.width?null!=this.panel?e=n-2*this.padding:(e=p.max([25*this.color_mapper.palette.length,.3*n]),e=p.min([e,.8*n-2*this.padding])):e=this.width;break;default:throw new Error("unreachable code")}return{width:e,height:t}},t.prototype._tick_coordinate_scale=function(t){var e={source_range:new h.Range1d({start:this.color_mapper.low,end:this.color_mapper.high}),target_range:new h.Range1d({start:0,end:t})};switch(this.color_mapper.type){case"LinearColorMapper":return new a.LinearScale(e);case"LogColorMapper":return new l.LogScale(e);default:throw new Error("unreachable code")}},t.prototype._format_major_labels=function(t,e){for(var i=this.formatter.doFormat(t,null),n=0,r=e.length;n<r;n++)e[n]in this.major_label_overrides&&(i[n]=this.major_label_overrides[e[n]]);return i},t.prototype.tick_info=function(){var e,t=this._computed_image_dimensions();switch(this.orientation){case"vertical":e=t.height;break;case"horizontal":e=t.width;break;default:throw new Error("unreachable code")}for(var i=this._tick_coordinate_scale(e),n=this._normals(),r=n[0],o=n[1],s=[this.color_mapper.low,this.color_mapper.high],a=s[0],l=s[1],h=this.ticker.get_ticks(a,l,null,null,this.ticker.desired_num_ticks),u=h.major,c=h.minor,_=[[],[]],p=[[],[]],d=0,f=u.length;d<f;d++)u[d]<a||u[d]>l||(_[r].push(u[d]),_[o].push(0));for(var d=0,f=c.length;d<f;d++)c[d]<a||c[d]>l||(p[r].push(c[d]),p[o].push(0));var v={major:this._format_major_labels(_[r],u)},m={major:[[],[]],minor:[[],[]]};return m.major[r]=i.v_compute(_[r]),m.minor[r]=i.v_compute(p[r]),m.major[o]=_[o],m.minor[o]=p[o],"vertical"==this.orientation&&(m.major[r]=g.map(m.major[r],function(t){return e-t}),m.minor[r]=g.map(m.minor[r],function(t){return e-t})),{coords:m,labels:v}},t}(r.Annotation);(i.ColorBar=m).initClass()},function(t,e,i){var n=t(60);i.Annotation=n.Annotation;var r=t(61);i.Arrow=r.Arrow;var o=t(62);i.ArrowHead=o.ArrowHead;var s=t(62);i.OpenHead=s.OpenHead;var a=t(62);i.NormalHead=a.NormalHead;var l=t(62);i.TeeHead=l.TeeHead;var h=t(62);i.VeeHead=h.VeeHead;var u=t(63);i.Band=u.Band;var c=t(64);i.BoxAnnotation=c.BoxAnnotation;var _=t(65);i.ColorBar=_.ColorBar;var p=t(67);i.Label=p.Label;var d=t(68);i.LabelSet=d.LabelSet;var f=t(69);i.Legend=f.Legend;var v=t(70);i.LegendItem=v.LegendItem;var m=t(71);i.PolyAnnotation=m.PolyAnnotation;var g=t(72);i.Slope=g.Slope;var y=t(73);i.Span=y.Span;var b=t(74);i.TextAnnotation=b.TextAnnotation;var x=t(75);i.Title=x.Title;var w=t(76);i.ToolbarPanel=w.ToolbarPanel;var k=t(77);i.Tooltip=k.Tooltip;var S=t(78);i.Whisker=S.Whisker},function(t,e,i){var n=t(391),r=t(74),a=t(5),o=t(15),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),this.visuals.warm_cache()},t.prototype._get_size=function(){var t=this.plot_view.canvas_view.ctx;if(this.visuals.text.set_value(t),this.model.panel.is_horizontal){var e=t.measureText(this.model.text).ascent;return e}var i=t.measureText(this.model.text).width;return i},t.prototype.render=function(){if(this.model.visible||"css"!=this.model.render_mode||a.hide(this.el),this.model.visible){var t;switch(this.model.angle_units){case"rad":t=-this.model.angle;break;case"deg":t=-this.model.angle*Math.PI/180;break;default:throw new Error("unreachable code")}var e=null!=this.model.panel?this.model.panel:this.plot_view.frame,i=this.plot_view.frame.xscales[this.model.x_range_name],n=this.plot_view.frame.yscales[this.model.y_range_name],r="data"==this.model.x_units?i.compute(this.model.x):e.xview.compute(this.model.x),o="data"==this.model.y_units?n.compute(this.model.y):e.yview.compute(this.model.y);r+=this.model.x_offset,o-=this.model.y_offset;var s="canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this);s(this.plot_view.canvas_view.ctx,this.model.text,r,o,t)}},t}(r.TextAnnotationView);i.LabelView=s;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Label",this.prototype.default_view=s,this.mixins(["text","line:border_","fill:background_"]),this.define({x:[o.Number],x_units:[o.SpatialUnits,"data"],y:[o.Number],y_units:[o.SpatialUnits,"data"],text:[o.String],angle:[o.Angle,0],angle_units:[o.AngleUnits,"rad"],x_offset:[o.Number,0],y_offset:[o.Number,0],x_range_name:[o.String,"default"],y_range_name:[o.String,"default"]}),this.override({background_fill_color:null,border_line_color:null})},t}(r.TextAnnotation);(i.Label=l).initClass()},function(t,e,i){var n=t(391),r=t(74),o=t(200),u=t(5),s=t(15),a=function(r){function t(){return null!==r&&r.apply(this,arguments)||this}return n.__extends(t,r),t.prototype.initialize=function(t){if(r.prototype.initialize.call(this,t),this.set_data(this.model.source),"css"==this.model.render_mode)for(var e=0,i=this._text.length;e<i;e++){var n=u.div({class:"bk-annotation-child",style:{display:"none"}});this.el.appendChild(n)}},t.prototype.connect_signals=function(){var t=this;r.prototype.connect_signals.call(this),"css"==this.model.render_mode?(this.connect(this.model.change,function(){t.set_data(t.model.source),t.render()}),this.connect(this.model.source.streaming,function(){t.set_data(t.model.source),t.render()}),this.connect(this.model.source.patching,function(){t.set_data(t.model.source),t.render()}),this.connect(this.model.source.change,function(){t.set_data(t.model.source),t.render()})):(this.connect(this.model.change,function(){t.set_data(t.model.source),t.plot_view.request_render()}),this.connect(this.model.source.streaming,function(){t.set_data(t.model.source),t.plot_view.request_render()}),this.connect(this.model.source.patching,function(){t.set_data(t.model.source),t.plot_view.request_render()}),this.connect(this.model.source.change,function(){t.set_data(t.model.source),t.plot_view.request_render()}))},t.prototype.set_data=function(t){r.prototype.set_data.call(this,t),this.visuals.warm_cache(t)},t.prototype._map_data=function(){var t=this.plot_view.frame.xscales[this.model.x_range_name],e=this.plot_view.frame.yscales[this.model.y_range_name],i=null!=this.model.panel?this.model.panel:this.plot_view.frame,n="data"==this.model.x_units?t.v_compute(this._x):i.xview.v_compute(this._x),r="data"==this.model.y_units?e.v_compute(this._y):i.yview.v_compute(this._y);return[n,r]},t.prototype.render=function(){if(this.model.visible||"css"!=this.model.render_mode||u.hide(this.el),this.model.visible)for(var t="canvas"==this.model.render_mode?this._v_canvas_text.bind(this):this._v_css_text.bind(this),e=this.plot_view.canvas_view.ctx,i=this._map_data(),n=i[0],r=i[1],o=0,s=this._text.length;o<s;o++)t(e,o,this._text[o],n[o]+this._x_offset[o],r[o]-this._y_offset[o],this._angle[o])},t.prototype._get_size=function(){var t=this.plot_view.canvas_view.ctx;switch(this.visuals.text.set_value(t),this.model.panel.side){case"above":case"below":var e=t.measureText(this._text[0]).ascent;return e;case"left":case"right":var i=t.measureText(this._text[0]).width;return i;default:throw new Error("unreachable code")}},t.prototype._v_canvas_text=function(t,e,i,n,r,o){this.visuals.text.set_vectorize(t,e);var s=this._calculate_bounding_box_dimensions(t,i);t.save(),t.beginPath(),t.translate(n,r),t.rotate(o),t.rect(s[0],s[1],s[2],s[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),t.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),t.stroke()),this.visuals.text.doit&&(this.visuals.text.set_vectorize(t,e),t.fillText(i,0,0)),t.restore()},t.prototype._v_css_text=function(t,e,i,n,r,o){var s=this.el.children[e];s.textContent=i,this.visuals.text.set_vectorize(t,e);var a=this._calculate_bounding_box_dimensions(t,i),l=this.visuals.border_line.line_dash.value(),h=l.length<2?"solid":"dashed";this.visuals.border_line.set_vectorize(t,e),this.visuals.background_fill.set_vectorize(t,e),s.style.position="absolute",s.style.left=n+a[0]+"px",s.style.top=r+a[1]+"px",s.style.color=""+this.visuals.text.text_color.value(),s.style.opacity=""+this.visuals.text.text_alpha.value(),s.style.font=""+this.visuals.text.font_value(),s.style.lineHeight="normal",o&&(s.style.transform="rotate("+o+"rad)"),this.visuals.background_fill.doit&&(s.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(s.style.borderStyle=""+h,s.style.borderWidth=this.visuals.border_line.line_width.value()+"px",s.style.borderColor=""+this.visuals.border_line.color_value()),u.show(s)},t}(r.TextAnnotationView);i.LabelSetView=a;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="LabelSet",this.prototype.default_view=a,this.mixins(["text","line:border_","fill:background_"]),this.define({x:[s.NumberSpec],y:[s.NumberSpec],x_units:[s.SpatialUnits,"data"],y_units:[s.SpatialUnits,"data"],text:[s.StringSpec,{field:"text"}],angle:[s.AngleSpec,0],x_offset:[s.NumberSpec,{value:0}],y_offset:[s.NumberSpec,{value:0}],source:[s.Instance,function(){return new o.ColumnDataSource}],x_range_name:[s.String,"default"],y_range_name:[s.String,"default"]}),this.override({background_fill_color:null,border_line_color:null})},t}(r.TextAnnotation);(i.LabelSet=l).initClass()},function(t,e,i){var n=t(391),r=t(60),o=t(15),s=t(19),M=t(41),O=t(24),z=t(21),P=t(32),j=t(44),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.cursor=function(t,e){return"none"==this.model.click_policy?null:"pointer"},Object.defineProperty(t.prototype,"legend_padding",{get:function(){return null!=this.visuals.border_line.line_color.value()?this.model.padding:0},enumerable:!0,configurable:!0}),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.plot_view.request_render()}),this.connect(this.model.item_change,function(){return t.plot_view.request_render()})},t.prototype.compute_legend_bbox=function(){var t=this.model.get_legend_names(),e=this.model,i=e.glyph_height,n=e.glyph_width,r=this.model,o=r.label_height,s=r.label_width;this.max_label_height=z.max([M.get_text_height(this.visuals.label_text.font_value()).height,o,i]);var a=this.plot_view.canvas_view.ctx;a.save(),this.visuals.label_text.set_value(a),this.text_widths={};for(var l=0,h=t;l<h.length;l++){var u=h[l];this.text_widths[u]=z.max([a.measureText(u).width,s])}a.restore();var c,_,p=Math.max(z.max(P.values(this.text_widths)),0),d=this.model.margin,f=this.legend_padding,v=this.model.spacing,m=this.model.label_standoff;if("vertical"==this.model.orientation)c=t.length*this.max_label_height+Math.max(t.length-1,0)*v+2*f,_=p+n+m+2*f;else{for(var g in _=2*f+Math.max(t.length-1,0)*v,this.text_widths){var y=this.text_widths[g];_+=z.max([y,s])+n+m}c=this.max_label_height+2*f}var b,x,w=null!=this.model.panel?this.model.panel:this.plot_view.frame,k=w.bbox.ranges,S=k[0],C=k[1],T=this.model.location;if(j.isString(T))switch(T){case"top_left":b=S.start+d,x=C.start+d;break;case"top_center":b=(S.end+S.start)/2-_/2,x=C.start+d;break;case"top_right":b=S.end-d-_,x=C.start+d;break;case"bottom_right":b=S.end-d-_,x=C.end-d-c;break;case"bottom_center":b=(S.end+S.start)/2-_/2,x=C.end-d-c;break;case"bottom_left":b=S.start+d,x=C.end-d-c;break;case"center_left":b=S.start+d,x=(C.end+C.start)/2-c/2;break;case"center":b=(S.end+S.start)/2-_/2,x=(C.end+C.start)/2-c/2;break;case"center_right":b=S.end-d-_,x=(C.end+C.start)/2-c/2;break;default:throw new Error("unreachable code")}else{if(!j.isArray(T)||2!=T.length)throw new Error("unreachable code");var A=T[0],E=T[1];b=w.xview.compute(A),x=w.yview.compute(E)-c}return{x:b,y:x,width:_,height:c}},t.prototype.interactive_bbox=function(){var t=this.compute_legend_bbox(),e=t.x,i=t.y,n=t.width,r=t.height;return new O.BBox({x:e,y:i,width:n,height:r})},t.prototype.interactive_hit=function(t,e){var i=this.interactive_bbox();return i.contains(t,e)},t.prototype.on_hit=function(t,e){for(var i,n,r,o=this.model.glyph_width,s=this.legend_padding,a=this.model.spacing,l=this.model.label_standoff,h=r=s,u=this.compute_legend_bbox(),c="vertical"==this.model.orientation,_=0,p=this.model.items;_<p.length;_++)for(var d=p[_],f=d.get_labels_list_from_label_prop(),v=0,m=f;v<m.length;v++){var g=m[v],y=u.x+h,b=u.y+r,x=void 0,w=void 0;c?(i=[u.width-2*s,this.max_label_height],x=i[0],w=i[1]):(n=[this.text_widths[g]+o+l,this.max_label_height],x=n[0],w=n[1]);var k=new O.BBox({x:y,y:b,width:x,height:w});if(k.contains(t,e)){switch(this.model.click_policy){case"hide":for(var S=0,C=d.renderers;S<C.length;S++){var T=C[S];T.visible=!T.visible}break;case"mute":for(var A=0,E=d.renderers;A<E.length;A++){var T=E[A];T.muted=!T.muted}}return!0}c?r+=this.max_label_height+a:h+=this.text_widths[g]+o+l+a}return!1},t.prototype.render=function(){if(this.model.visible&&0!=this.model.items.length){for(var t=0,e=this.model.items;t<e.length;t++){var i=e[t];i.legend=this.model}var n=this.plot_view.canvas_view.ctx,r=this.compute_legend_bbox();n.save(),this._draw_legend_box(n,r),this._draw_legend_items(n,r),n.restore()}},t.prototype._draw_legend_box=function(t,e){t.beginPath(),t.rect(e.x,e.y,e.width,e.height),this.visuals.background_fill.set_value(t),t.fill(),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.stroke())},t.prototype._draw_legend_items=function(y,b){for(var x=this,t=this.model,w=t.glyph_width,k=t.glyph_height,S=this.legend_padding,C=this.model.spacing,T=this.model.label_standoff,A=S,E=S,M="vertical"==this.model.orientation,e=function(t){var e,i,n=t.get_labels_list_from_label_prop(),r=t.get_field_from_label_prop();if(0==n.length)return"continue";for(var o=function(){switch(x.model.click_policy){case"none":return!0;case"hide":return z.all(t.renderers,function(t){return t.visible});case"mute":return z.all(t.renderers,function(t){return!t.muted})}}(),s=0,a=n;s<a.length;s++){var l=a[s],h=b.x+A,u=b.y+E,c=h+w,_=u+k;M?E+=O.max_label_height+C:A+=O.text_widths[l]+w+T+C,O.visuals.label_text.set_value(y),y.fillText(l,c+T,u+O.max_label_height/2);for(var p=0,d=t.renderers;p<d.length;p++){var f=d[p],v=O.plot_view.renderer_views[f.id];v.draw_legend(y,h,c,u,_,r,l,t.index)}if(!o){var m=void 0,g=void 0;M?(e=[b.width-2*S,O.max_label_height],m=e[0],g=e[1]):(i=[O.text_widths[l]+w+T,O.max_label_height],m=i[0],g=i[1]),y.beginPath(),y.rect(h,u,m,g),O.visuals.inactive_fill.set_value(y),y.fill()}}},O=this,i=0,n=this.model.items;i<n.length;i++){var r=n[i];e(r)}},t.prototype._get_size=function(){var t=this.compute_legend_bbox();switch(this.model.panel.side){case"above":case"below":return t.height+2*this.model.margin;case"left":case"right":return t.width+2*this.model.margin}},t}(r.AnnotationView);i.LegendView=a;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.item_change=new s.Signal0(this,"item_change")},t.initClass=function(){this.prototype.type="Legend",this.prototype.default_view=a,this.mixins(["text:label_","fill:inactive_","line:border_","fill:background_"]),this.define({orientation:[o.Orientation,"vertical"],location:[o.Any,"top_right"],label_standoff:[o.Number,5],glyph_height:[o.Number,20],glyph_width:[o.Number,20],label_height:[o.Number,20],label_width:[o.Number,20],margin:[o.Number,10],padding:[o.Number,10],spacing:[o.Number,3],items:[o.Array,[]],click_policy:[o.Any,"none"]}),this.override({border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,inactive_fill_color:"white",inactive_fill_alpha:.7,label_text_font_size:"10pt",label_text_baseline:"middle"})},t.prototype.get_legend_names=function(){for(var t=[],e=0,i=this.items;e<i.length;e++){var n=i[e],r=n.get_labels_list_from_label_prop();t.push.apply(t,r)}return t},t}(r.Annotation);(i.Legend=l).initClass()},function(t,e,i){var r=t(391),n=t(59),o=t(201),s=t(47),a=t(15),l=t(14),h=t(21),u=function(n){function t(t){return n.call(this,t)||this}return r.__extends(t,n),t.initClass=function(){this.prototype.type="LegendItem",this.define({label:[a.StringSpec,null],renderers:[a.Array,[]],index:[a.Number,null]})},t.prototype._check_data_sources_on_renderers=function(){var t=this.get_field_from_label_prop();if(null!=t){if(this.renderers.length<1)return!1;var e=this.renderers[0].data_source;if(null!=e)for(var i=0,n=this.renderers;i<n.length;i++){var r=n[i];if(r.data_source!=e)return!1}}return!0},t.prototype._check_field_label_on_data_source=function(){var t=this.get_field_from_label_prop();if(null!=t){if(this.renderers.length<1)return!1;var e=this.renderers[0].data_source;if(null!=e&&!h.includes(e.columns(),t))return!1}return!0},t.prototype.initialize=function(){var t=this;n.prototype.initialize.call(this),this.legend=null,this.connect(this.change,function(){null!=t.legend&&t.legend.item_change.emit()});var e=this._check_data_sources_on_renderers();e||l.logger.error("Non matching data sources on legend item renderers");var i=this._check_field_label_on_data_source();i||l.logger.error("Bad column name on label: "+this.label)},t.prototype.get_field_from_label_prop=function(){var t=this.label;return s.isField(t)?t.field:null},t.prototype.get_labels_list_from_label_prop=function(){if(s.isValue(this.label))return[this.label.value];var t=this.get_field_from_label_prop();if(null!=t){var e=void 0;if(!this.renderers[0]||null==this.renderers[0].data_source)return["No source found"];if((e=this.renderers[0].data_source)instanceof o.ColumnarDataSource){var i=e.get_column(t);return null!=i?h.uniq(Array.from(i)):["Invalid field"]}}return[]},t}(n.Model);(i.LegendItem=u).initClass()},function(t,e,i){var n=t(391),r=t(60),o=t(19),s=t(15),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.plot_view.request_render()}),this.connect(this.model.data_update,function(){return t.plot_view.request_render()})},t.prototype.render=function(){if(this.model.visible){var t=this.model,e=t.xs,i=t.ys;if(e.length==i.length&&!(e.length<3||i.length<3)){for(var n=this.plot_view.frame,r=this.plot_view.canvas_view.ctx,o=0,s=e.length;o<s;o++){var a=void 0;if("screen"!=this.model.xs_units)throw new Error("not implemented");a=this.model.screen?e[o]:n.xview.compute(e[o]);var l=void 0;if("screen"!=this.model.ys_units)throw new Error("not implemented");l=this.model.screen?i[o]:n.yview.compute(i[o]),0==o?(r.beginPath(),r.moveTo(a,l)):r.lineTo(a,l)}r.closePath(),this.visuals.line.doit&&(this.visuals.line.set_value(r),r.stroke()),this.visuals.fill.doit&&(this.visuals.fill.set_value(r),r.fill())}}},t}(r.AnnotationView);i.PolyAnnotationView=a;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="PolyAnnotation",this.prototype.default_view=a,this.mixins(["line","fill"]),this.define({xs:[s.Array,[]],xs_units:[s.SpatialUnits,"data"],ys:[s.Array,[]],ys_units:[s.SpatialUnits,"data"],x_range_name:[s.String,"default"],y_range_name:[s.String,"default"]}),this.internal({screen:[s.Boolean,!1]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this.data_update=new o.Signal0(this,"data_update")},t.prototype.update=function(t){var e=t.xs,i=t.ys;this.setv({xs:e,ys:i,screen:!0},{silent:!0}),this.data_update.emit()},t}(r.Annotation);(i.PolyAnnotation=l).initClass()},function(t,e,i){var n=t(391),r=t(60),o=t(15),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.plot_view.request_render()})},t.prototype.render=function(){this.model.visible&&this._draw_slope()},t.prototype._draw_slope=function(){var t=this.model.gradient,e=this.model.y_intercept;if(null!=t&&null!=e){var i=this.plot_view.frame,n=i.xscales[this.model.x_range_name],r=i.yscales[this.model.y_range_name],o=i._top.value,s=o+i._height.value,a=r.invert(o),l=r.invert(s),h=(a-e)/t,u=(l-e)/t,c=n.compute(h),_=n.compute(u),p=this.plot_view.canvas_view.ctx;p.save(),p.beginPath(),this.visuals.line.set_value(p),p.moveTo(c,o),p.lineTo(_,s),p.stroke(),p.restore()}},t}(r.AnnotationView);i.SlopeView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Slope",this.prototype.default_view=s,this.mixins(["line"]),this.define({gradient:[o.Number,null],y_intercept:[o.Number,null],x_range_name:[o.String,"default"],y_range_name:[o.String,"default"]}),this.override({line_color:"black"})},t}(r.Annotation);(i.Slope=a).initClass()},function(t,e,i){var n=t(391),r=t(60),c=t(5),o=t(15),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),this.plot_view.canvas_overlays.appendChild(this.el),this.el.style.position="absolute",c.hide(this.el)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.model.for_hover?this.connect(this.model.properties.computed_location.change,function(){return t._draw_span()}):"canvas"==this.model.render_mode?(this.connect(this.model.change,function(){return t.plot_view.request_render()}),this.connect(this.model.properties.location.change,function(){return t.plot_view.request_render()})):(this.connect(this.model.change,function(){return t.render()}),this.connect(this.model.properties.location.change,function(){return t._draw_span()}))},t.prototype.render=function(){this.model.visible||"css"!=this.model.render_mode||c.hide(this.el),this.model.visible&&this._draw_span()},t.prototype._draw_span=function(){var i=this,n=this.model.for_hover?this.model.computed_location:this.model.location;if(null!=n){var t,e,r,o,s=this.plot_view.frame,a=s.xscales[this.model.x_range_name],l=s.yscales[this.model.y_range_name],h=function(t,e){return i.model.for_hover?i.model.computed_location:"data"==i.model.location_units?t.compute(n):e.compute(n)};if("width"==this.model.dimension?(r=h(l,s.yview),e=s._left.value,o=s._width.value,t=this.model.properties.line_width.value()):(r=s._top.value,e=h(a,s.xview),o=this.model.properties.line_width.value(),t=s._height.value),"css"==this.model.render_mode)this.el.style.top=r+"px",this.el.style.left=e+"px",this.el.style.width=o+"px",this.el.style.height=t+"px",this.el.style.backgroundColor=this.model.properties.line_color.value(),this.el.style.opacity=this.model.properties.line_alpha.value(),c.show(this.el);else if("canvas"==this.model.render_mode){var u=this.plot_view.canvas_view.ctx;u.save(),u.beginPath(),this.visuals.line.set_value(u),u.moveTo(e,r),"width"==this.model.dimension?u.lineTo(e+o,r):u.lineTo(e,r+t),u.stroke(),u.restore()}}else c.hide(this.el)},t}(r.AnnotationView);i.SpanView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Span",this.prototype.default_view=s,this.mixins(["line"]),this.define({render_mode:[o.RenderMode,"canvas"],x_range_name:[o.String,"default"],y_range_name:[o.String,"default"],location:[o.Number,null],location_units:[o.SpatialUnits,"data"],dimension:[o.Dimension,"width"]}),this.override({line_color:"black"}),this.internal({for_hover:[o.Boolean,!1],computed_location:[o.Number,null]})},t}(r.Annotation);(i.Span=a).initClass()},function(t,e,i){var n=t(391),r=t(60),l=t(5),o=t(15),s=t(41),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),"css"==this.model.render_mode&&(this.el.classList.add("bk-annotation"),this.plot_view.canvas_overlays.appendChild(this.el))},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),"css"==this.model.render_mode?this.connect(this.model.change,function(){return t.render()}):this.connect(this.model.change,function(){return t.plot_view.request_render()})},t.prototype._calculate_text_dimensions=function(t,e){var i=t.measureText(e).width,n=s.get_text_height(this.visuals.text.font_value()).height;return[i,n]},t.prototype._calculate_bounding_box_dimensions=function(t,e){var i,n,r=this._calculate_text_dimensions(t,e),o=r[0],s=r[1];switch(t.textAlign){case"left":i=0;break;case"center":i=-o/2;break;case"right":i=-o;break;default:throw new Error("unreachable code")}switch(t.textBaseline){case"top":n=0;break;case"middle":n=-.5*s;break;case"bottom":n=-1*s;break;case"alphabetic":n=-.8*s;break;case"hanging":n=-.17*s;break;case"ideographic":n=-.83*s;break;default:throw new Error("unreachable code")}return[i,n,o,s]},t.prototype._canvas_text=function(t,e,i,n,r){this.visuals.text.set_value(t);var o=this._calculate_bounding_box_dimensions(t,e);t.save(),t.beginPath(),t.translate(i,n),r&&t.rotate(r),t.rect(o[0],o[1],o[2],o[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.stroke()),this.visuals.text.doit&&(this.visuals.text.set_value(t),t.fillText(e,0,0)),t.restore()},t.prototype._css_text=function(t,e,i,n,r){l.hide(this.el),this.visuals.text.set_value(t);var o=this._calculate_bounding_box_dimensions(t,e),s=this.visuals.border_line.line_dash.value(),a=s.length<2?"solid":"dashed";this.visuals.border_line.set_value(t),this.visuals.background_fill.set_value(t),this.el.style.position="absolute",this.el.style.left=i+o[0]+"px",this.el.style.top=n+o[1]+"px",this.el.style.color=""+this.visuals.text.text_color.value(),this.el.style.opacity=""+this.visuals.text.text_alpha.value(),this.el.style.font=""+this.visuals.text.font_value(),this.el.style.lineHeight="normal",r&&(this.el.style.transform="rotate("+r+"rad)"),this.visuals.background_fill.doit&&(this.el.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(this.el.style.borderStyle=""+a,this.el.style.borderWidth=this.visuals.border_line.line_width.value()+"px",this.el.style.borderColor=""+this.visuals.border_line.color_value()),this.el.textContent=e,l.show(this.el)},t}(r.AnnotationView);i.TextAnnotationView=a;var h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="TextAnnotation",this.define({render_mode:[o.RenderMode,"canvas"]})},t}(r.Annotation);(i.TextAnnotation=h).initClass()},function(t,e,i){var n=t(391),r=t(74),s=t(5),o=t(15),a=t(49),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),this.visuals.text=new a.Text(this.model)},t.prototype._get_location=function(){var t,e,i=this.model.panel,n=this.model.offset;switch(i.side){case"above":case"below":switch(this.model.vertical_align){case"top":e=i._top.value+5;break;case"middle":e=i._vcenter.value;break;case"bottom":e=i._bottom.value-5;break;default:throw new Error("unreachable code")}switch(this.model.align){case"left":t=i._left.value+n;break;case"center":t=i._hcenter.value;break;case"right":t=i._right.value-n;break;default:throw new Error("unreachable code")}break;case"left":switch(this.model.vertical_align){case"top":t=i._left.value-5;break;case"middle":t=i._hcenter.value;break;case"bottom":t=i._right.value+5;break;default:throw new Error("unreachable code")}switch(this.model.align){case"left":e=i._bottom.value-n;break;case"center":e=i._vcenter.value;break;case"right":e=i._top.value+n;break;default:throw new Error("unreachable code")}break;case"right":switch(this.model.vertical_align){case"top":t=i._right.value-5;break;case"middle":t=i._hcenter.value;break;case"bottom":t=i._left.value+5;break;default:throw new Error("unreachable code")}switch(this.model.align){case"left":e=i._top.value+n;break;case"center":e=i._vcenter.value;break;case"right":e=i._bottom.value-n;break;default:throw new Error("unreachable code")}break;default:throw new Error("unreachable code")}return[t,e]},t.prototype.render=function(){if(this.model.visible){var t=this.model.text;if(null!=t&&0!=t.length){this.model.text_baseline=this.model.vertical_align,this.model.text_align=this.model.align;var e=this._get_location(),i=e[0],n=e[1],r=this.model.panel.get_label_angle_heuristic("parallel"),o="canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this);o(this.plot_view.canvas_view.ctx,t,i,n,r)}}else"css"==this.model.render_mode&&s.hide(this.el)},t.prototype._get_size=function(){var t=this.model.text;if(null==t||0==t.length)return 0;var e=this.plot_view.canvas_view.ctx;return this.visuals.text.set_value(e),e.measureText(t).ascent+10},t}(r.TextAnnotationView);i.TitleView=l;var h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Title",this.prototype.default_view=l,this.mixins(["line:border_","fill:background_"]),this.define({text:[o.String],text_font:[o.Font,"helvetica"],text_font_size:[o.FontSizeSpec,"10pt"],text_font_style:[o.FontStyle,"bold"],text_color:[o.ColorSpec,"#444444"],text_alpha:[o.NumberSpec,1],vertical_align:[o.VerticalAlign,"bottom"],align:[o.TextAlign,"left"],offset:[o.Number,0]}),this.override({background_fill_color:null,border_line_color:null}),this.internal({text_align:[o.TextAlign,"left"],text_baseline:[o.TextBaseline,"bottom"]})},t}(r.TextAnnotation);(i.Title=h).initClass()},function(t,e,i){var n=t(391),r=t(60),o=t(4),s=t(5),a=t(15),l=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return n.__extends(t,i),t.prototype.initialize=function(t){i.prototype.initialize.call(this,t),this.plot_view.canvas_events.appendChild(this.el),this._toolbar_views={},o.build_views(this._toolbar_views,[this.model.toolbar],{parent:this});var e=this._toolbar_views[this.model.toolbar.id];this.plot_view.visibility_callbacks.push(function(t){return e.set_visibility(t)})},t.prototype.remove=function(){o.remove_views(this._toolbar_views),i.prototype.remove.call(this)},t.prototype.render=function(){if(i.prototype.render.call(this),this.model.visible){var t=this.model.panel;this.el.style.position="absolute",this.el.style.left=t._left.value+"px",this.el.style.top=t._top.value+"px",this.el.style.width=t._width.value+"px",this.el.style.height=t._height.value+"px",this.el.style.overflow="hidden";var e=this._toolbar_views[this.model.toolbar.id];e.render(),s.empty(this.el),this.el.appendChild(e.el),s.show(this.el)}else s.hide(this.el)},t.prototype._get_size=function(){return 30},t}(r.AnnotationView);i.ToolbarPanelView=l;var h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="ToolbarPanel",this.prototype.default_view=l,this.define({toolbar:[a.Instance]})},t}(r.Annotation);(i.ToolbarPanel=h).initClass()},function(t,e,i){var n=t(391),r=t(60),f=t(5),o=t(15);function v(t,e,i,n,r){var o;switch(t){case"horizontal":o=e<n?"right":"left";break;case"vertical":o=i<r?"below":"above";break;default:o=t}return o}i.compute_side=v;var s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),this.plot_view.canvas_overlays.appendChild(this.el),f.hide(this.el)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.data.change,function(){return t._draw_tips()})},t.prototype.css_classes=function(){return e.prototype.css_classes.call(this).concat("bk-tooltip")},t.prototype.render=function(){this.model.visible&&this._draw_tips()},t.prototype._draw_tips=function(){var t=this.model.data;if(f.empty(this.el),f.hide(this.el),this.model.custom?this.el.classList.add("bk-tooltip-custom"):this.el.classList.remove("bk-tooltip-custom"),0!=t.length){for(var e=this.plot_view.frame,i=0,n=t;i<n.length;i++){var r=n[i],o=r[0],s=r[1],a=r[2];if(!this.model.inner_only||e.bbox.contains(o,s)){var l=f.div({},a);this.el.appendChild(l)}}var h,u,c=t[t.length-1],_=c[0],p=c[1],d=v(this.model.attachment,_,p,e._hcenter.value,e._vcenter.value);switch(this.el.classList.remove("bk-right"),this.el.classList.remove("bk-left"),this.el.classList.remove("bk-above"),this.el.classList.remove("bk-below"),f.show(this.el),d){case"right":this.el.classList.add("bk-left"),h=_+(this.el.offsetWidth-this.el.clientWidth)+10,u=p-this.el.offsetHeight/2;break;case"left":this.el.classList.add("bk-right"),h=_-this.el.offsetWidth-10,u=p-this.el.offsetHeight/2;break;case"below":this.el.classList.add("bk-above"),u=p+(this.el.offsetHeight-this.el.clientHeight)+10,h=Math.round(_-this.el.offsetWidth/2);break;case"above":this.el.classList.add("bk-below"),u=p-this.el.offsetHeight-10,h=Math.round(_-this.el.offsetWidth/2);break;default:throw new Error("unreachable code")}this.model.show_arrow&&this.el.classList.add("bk-tooltip-arrow"),0<this.el.childNodes.length?(this.el.style.top=u+"px",this.el.style.left=h+"px"):f.hide(this.el)}},t}(r.AnnotationView);i.TooltipView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Tooltip",this.prototype.default_view=s,this.define({attachment:[o.String,"horizontal"],inner_only:[o.Bool,!0],show_arrow:[o.Bool,!0]}),this.override({level:"overlay"}),this.internal({data:[o.Any,[]],custom:[o.Any]})},t.prototype.clear=function(){this.data=[]},t.prototype.add=function(t,e,i){this.data=this.data.concat([[t,e,i]])},t}(r.Annotation);(i.Tooltip=a).initClass()},function(t,e,i){var n=t(391),r=t(60),o=t(200),s=t(62),a=t(15),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),this.set_data(this.model.source)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.source.streaming,function(){return t.set_data(t.model.source)}),this.connect(this.model.source.patching,function(){return t.set_data(t.model.source)}),this.connect(this.model.source.change,function(){return t.set_data(t.model.source)})},t.prototype.set_data=function(t){e.prototype.set_data.call(this,t),this.visuals.warm_cache(t),this.plot_view.request_render()},t.prototype._map_data=function(){var t,e,i,n=this.plot_model.frame,r=this.model.dimension,o=n.xscales[this.model.x_range_name],s=n.yscales[this.model.y_range_name],a="height"==r?s:o,l="height"==r?o:s,h="height"==r?n.yview:n.xview,u="height"==r?n.xview:n.yview;t="data"==this.model.lower.units?a.v_compute(this._lower):h.v_compute(this._lower),e="data"==this.model.upper.units?a.v_compute(this._upper):h.v_compute(this._upper),i="data"==this.model.base.units?l.v_compute(this._base):u.v_compute(this._base);var c="height"==r?[1,0]:[0,1],_=c[0],p=c[1],d=[t,i],f=[e,i];this._lower_sx=d[_],this._lower_sy=d[p],this._upper_sx=f[_],this._upper_sy=f[p]},t.prototype.render=function(){if(this.model.visible){this._map_data();var t=this.plot_view.canvas_view.ctx;if(this.visuals.line.doit)for(var e=0,i=this._lower_sx.length;e<i;e++)this.visuals.line.set_vectorize(t,e),t.beginPath(),t.moveTo(this._lower_sx[e],this._lower_sy[e]),t.lineTo(this._upper_sx[e],this._upper_sy[e]),t.stroke();var n="height"==this.model.dimension?0:Math.PI/2;if(null!=this.model.lower_head)for(var e=0,i=this._lower_sx.length;e<i;e++)t.save(),t.translate(this._lower_sx[e],this._lower_sy[e]),t.rotate(n+Math.PI),this.model.lower_head.render(t,e),t.restore();if(null!=this.model.upper_head)for(var e=0,i=this._upper_sx.length;e<i;e++)t.save(),t.translate(this._upper_sx[e],this._upper_sy[e]),t.rotate(n),this.model.upper_head.render(t,e),t.restore()}},t}(r.AnnotationView);i.WhiskerView=l;var h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Whisker",this.prototype.default_view=l,this.mixins(["line"]),this.define({lower:[a.DistanceSpec],lower_head:[a.Instance,function(){return new s.TeeHead({level:"underlay",size:10})}],upper:[a.DistanceSpec],upper_head:[a.Instance,function(){return new s.TeeHead({level:"underlay",size:10})}],base:[a.DistanceSpec],dimension:[a.Dimension,"height"],source:[a.Instance,function(){return new o.ColumnDataSource}],x_range_name:[a.String,"default"],y_range_name:[a.String,"default"]}),this.override({level:"underlay"})},t}(r.Annotation);(i.Whisker=h).initClass()},function(t,e,i){var n=t(391),r=t(187),o=t(15),s=t(12),l=t(21),T=t(44),a=t(181),h=Math.abs,u=Math.min,c=Math.max,_=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.render=function(){if(this.model.visible){var t={tick:this._tick_extent(),tick_label:this._tick_label_extents(),axis_label:this._axis_label_extent()},e=this.model.tick_coords,i=this.plot_view.canvas_view.ctx;i.save(),this._draw_rule(i,t),this._draw_major_ticks(i,t,e),this._draw_minor_ticks(i,t,e),this._draw_major_labels(i,t,e),this._draw_axis_label(i,t,e),null!=this._render&&this._render(i,t,e),i.restore()}},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.plot_view.request_render()})},t.prototype.get_size=function(){return this.model.visible?Math.round(this._get_size()):0},t.prototype._get_size=function(){return null!=this.model.fixed_location?0:this._tick_extent()+this._tick_label_extent()+this._axis_label_extent()},Object.defineProperty(t.prototype,"needs_clip",{get:function(){return null!=this.model.fixed_location},enumerable:!0,configurable:!0}),t.prototype._draw_rule=function(t,e){if(this.visuals.axis_line.doit){var i=this.model.rule_coords,n=i[0],r=i[1],o=this.plot_view.map_to_screen(n,r,this.model.x_range_name,this.model.y_range_name),s=o[0],a=o[1],l=this.model.normals,h=l[0],u=l[1],c=this.model.offsets,_=c[0],p=c[1];this.visuals.axis_line.set_value(t),t.beginPath(),t.moveTo(Math.round(s[0]+h*_),Math.round(a[0]+u*p));for(var d=1;d<s.length;d++){var f=Math.round(s[d]+h*_),v=Math.round(a[d]+u*p);t.lineTo(f,v)}t.stroke()}},t.prototype._draw_major_ticks=function(t,e,i){var n=this.model.major_tick_in,r=this.model.major_tick_out,o=this.visuals.major_tick_line;this._draw_ticks(t,i.major,n,r,o)},t.prototype._draw_minor_ticks=function(t,e,i){var n=this.model.minor_tick_in,r=this.model.minor_tick_out,o=this.visuals.minor_tick_line;this._draw_ticks(t,i.minor,n,r,o)},t.prototype._draw_major_labels=function(t,e,i){var n=i.major,r=this.model.compute_labels(n[this.model.dimension]),o=this.model.major_label_orientation,s=e.tick+this.model.major_label_standoff,a=this.visuals.major_label_text;this._draw_oriented_labels(t,r,n,o,this.model.panel.side,s,a)},t.prototype._draw_axis_label=function(t,e,i){if(null!=this.model.axis_label&&0!=this.model.axis_label.length&&null==this.model.fixed_location){var n,r;switch(this.model.panel.side){case"above":n=this.model.panel._hcenter.value,r=this.model.panel._bottom.value;break;case"below":n=this.model.panel._hcenter.value,r=this.model.panel._top.value;break;case"left":n=this.model.panel._right.value,r=this.model.panel._vcenter.value;break;case"right":n=this.model.panel._left.value,r=this.model.panel._vcenter.value;break;default:throw new Error("unknown side: "+this.model.panel.side)}var o=[[n],[r]],s=e.tick+l.sum(e.tick_label)+this.model.axis_label_standoff,a=this.visuals.axis_label_text;this._draw_oriented_labels(t,[this.model.axis_label],o,"parallel",this.model.panel.side,s,a,"screen")}},t.prototype._draw_ticks=function(t,e,i,n,r){if(r.doit){var o=e[0],s=e[1],a=this.plot_view.map_to_screen(o,s,this.model.x_range_name,this.model.y_range_name),l=a[0],h=a[1],u=this.model.normals,c=u[0],_=u[1],p=this.model.offsets,d=p[0],f=p[1],v=[c*(d-i),_*(f-i)],m=v[0],g=v[1],y=[c*(d+n),_*(f+n)],b=y[0],x=y[1];r.set_value(t);for(var w=0;w<l.length;w++){var k=Math.round(l[w]+b),S=Math.round(h[w]+x),C=Math.round(l[w]+m),T=Math.round(h[w]+g);t.beginPath(),t.moveTo(k,S),t.lineTo(C,T),t.stroke()}}},t.prototype._draw_oriented_labels=function(t,e,i,n,r,o,s,a){var l,h,u;if(void 0===a&&(a="data"),s.doit&&0!=e.length){var c,_,p,d;if("screen"==a)c=i[0],_=i[1],p=(l=[0,0])[0],d=l[1];else{var f=i[0],v=i[1];h=this.plot_view.map_to_screen(f,v,this.model.x_range_name,this.model.y_range_name),c=h[0],_=h[1],u=this.model.offsets,p=u[0],d=u[1]}var m,g=this.model.normals,y=g[0],b=g[1],x=y*(p+o),w=b*(d+o);s.set_value(t),this.model.panel.apply_label_text_heuristics(t,n),m=T.isString(n)?this.model.panel.get_label_angle_heuristic(n):-n;for(var k=0;k<c.length;k++){var S=Math.round(c[k]+x),C=Math.round(_[k]+w);t.translate(S,C),t.rotate(m),t.fillText(e[k],0,0),t.rotate(-m),t.translate(-S,-C)}}},t.prototype._axis_label_extent=function(){if(null==this.model.axis_label||""==this.model.axis_label)return 0;var t=this.model.axis_label_standoff,e=this.visuals.axis_label_text;return this._oriented_labels_extent([this.model.axis_label],"parallel",this.model.panel.side,t,e)},t.prototype._tick_extent=function(){return this.model.major_tick_out},t.prototype._tick_label_extent=function(){return l.sum(this._tick_label_extents())},t.prototype._tick_label_extents=function(){var t=this.model.tick_coords.major,e=this.model.compute_labels(t[this.model.dimension]),i=this.model.major_label_orientation,n=this.model.major_label_standoff,r=this.visuals.major_label_text;return[this._oriented_labels_extent(e,i,this.model.panel.side,n,r)]},t.prototype._oriented_labels_extent=function(t,e,i,n,r){if(0==t.length)return 0;var o,s,a=this.plot_view.canvas_view.ctx;r.set_value(a),T.isString(e)?(o=1,s=this.model.panel.get_label_angle_heuristic(e)):(o=2,s=-e),s=Math.abs(s);for(var l=Math.cos(s),h=Math.sin(s),u=0,c=0;c<t.length;c++){var _=1.1*a.measureText(t[c]).width,p=.9*a.measureText(t[c]).ascent,d=void 0;u<(d="above"==i||"below"==i?_*h+p/o*l:_*l+p/o*h)&&(u=d)}return 0<u&&(u+=n),u},t}(r.GuideRendererView);i.AxisView=_;var p=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Axis",this.prototype.default_view=_,this.mixins(["line:axis_","line:major_tick_","line:minor_tick_","text:major_label_","text:axis_label_"]),this.define({bounds:[o.Any,"auto"],ticker:[o.Instance,null],formatter:[o.Instance,null],x_range_name:[o.String,"default"],y_range_name:[o.String,"default"],axis_label:[o.String,""],axis_label_standoff:[o.Int,5],major_label_standoff:[o.Int,5],major_label_orientation:[o.Any,"horizontal"],major_label_overrides:[o.Any,{}],major_tick_in:[o.Number,2],major_tick_out:[o.Number,6],minor_tick_in:[o.Number,0],minor_tick_out:[o.Number,4],fixed_location:[o.Any,null]}),this.override({axis_line_color:"black",major_tick_line_color:"black",minor_tick_line_color:"black",major_label_text_font_size:"8pt",major_label_text_align:"center",major_label_text_baseline:"alphabetic",axis_label_text_font_size:"10pt",axis_label_text_font_style:"italic"})},t.prototype.add_panel=function(t){this.panel=new s.SidePanel({side:t}),this.panel.attach_document(this.document)},Object.defineProperty(t.prototype,"normals",{get:function(){return this.panel.normals},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"dimension",{get:function(){return this.panel.dimension},enumerable:!0,configurable:!0}),t.prototype.compute_labels=function(t){for(var e=this.formatter.doFormat(t,this),i=0;i<t.length;i++)t[i]in this.major_label_overrides&&(e[i]=this.major_label_overrides[t[i]]);return e},Object.defineProperty(t.prototype,"offsets",{get:function(){var t=this.plot.plot_canvas.frame,e=[0,0],i=e[0],n=e[1];switch(this.panel.side){case"below":n=h(this.panel._top.value-t._bottom.value);break;case"above":n=h(this.panel._bottom.value-t._top.value);break;case"right":i=h(this.panel._left.value-t._right.value);break;case"left":i=h(this.panel._right.value-t._left.value)}return[i,n]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"ranges",{get:function(){var t=this.dimension,e=(t+1)%2,i=this.plot.plot_canvas.frame,n=[i.x_ranges[this.x_range_name],i.y_ranges[this.y_range_name]];return[n[t],n[e]]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"computed_bounds",{get:function(){var t=this.ranges[0],e=this.bounds,i=[t.min,t.max];if("auto"==e)return[t.min,t.max];if(T.isArray(e)){var n=void 0,r=void 0,o=e[0],s=e[1],a=i[0],l=i[1];return h(o-s)>h(a-l)?(n=c(u(o,s),a),r=u(c(o,s),l)):(n=u(o,s),r=c(o,s)),[n,r]}throw new Error("user bounds '"+e+"' not understood")},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"rule_coords",{get:function(){var t=this.dimension,e=(t+1)%2,i=this.ranges[0],n=this.computed_bounds,r=n[0],o=n[1],s=new Array(2),a=new Array(2),l=[s,a];return l[t][0]=Math.max(r,i.min),l[t][1]=Math.min(o,i.max),l[t][0]>l[t][1]&&(l[t][0]=l[t][1]=NaN),l[e][0]=this.loc,l[e][1]=this.loc,l},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"tick_coords",{get:function(){for(var t=this.dimension,e=(t+1)%2,i=this.ranges[0],n=this.computed_bounds,r=n[0],o=n[1],s=this.ticker.get_ticks(r,o,i,this.loc,{}),a=s.major,l=s.minor,h=[[],[]],u=[[],[]],c=[i.min,i.max],_=c[0],p=c[1],d=0;d<a.length;d++)a[d]<_||a[d]>p||(h[t].push(a[d]),h[e].push(this.loc));for(var d=0;d<l.length;d++)l[d]<_||l[d]>p||(u[t].push(l[d]),u[e].push(this.loc));return{major:h,minor:u}},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"loc",{get:function(){if(null!=this.fixed_location){if(T.isNumber(this.fixed_location))return this.fixed_location;var t=this.ranges,e=t[1];if(e instanceof a.FactorRange)return e.synthetic(this.fixed_location);throw new Error("unexpected")}var i=this.ranges,n=i[1];switch(this.panel.side){case"left":case"below":return n.start;case"right":case"above":return n.end}},enumerable:!0,configurable:!0}),t}(r.GuideRenderer);(i.Axis=p).initClass()},function(t,e,i){var n=t(391),r=t(79),o=t(208),s=t(105),a=t(15),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._render=function(t,e,i){this._draw_group_separators(t,e,i)},e.prototype._draw_group_separators=function(t,e,i){var n,r=this.model.ranges[0],o=this.model.computed_bounds,s=o[0],a=o[1];if(r.tops&&!(r.tops.length<2)&&this.visuals.separator_line.doit){for(var l=this.model.dimension,h=(l+1)%2,u=[[],[]],c=0,_=0;_<r.tops.length-1;_++){for(var p=void 0,d=void 0,f=c;f<r.factors.length;f++)if(r.factors[f][0]==r.tops[_+1]){n=[r.factors[f-1],r.factors[f]],p=n[0],d=n[1],c=f;break}var v=(r.synthetic(p)+r.synthetic(d))/2;s<v&&v<a&&(u[l].push(v),u[h].push(this.model.loc))}var m=this._tick_label_extent();this._draw_ticks(t,u,-3,m-6,this.visuals.separator_line)}},e.prototype._draw_major_labels=function(t,e,i){for(var n=this._get_factor_info(),r=e.tick+this.model.major_label_standoff,o=0;o<n.length;o++){var s=n[o],a=s[0],l=s[1],h=s[2],u=s[3];this._draw_oriented_labels(t,a,l,h,this.model.panel.side,r,u),r+=e.tick_label[o]}},e.prototype._tick_label_extents=function(){for(var t=this._get_factor_info(),e=[],i=0,n=t;i<n.length;i++){var r=n[i],o=r[0],s=r[2],a=r[3],l=this._oriented_labels_extent(o,s,this.model.panel.side,this.model.major_label_standoff,a);e.push(l)}return e},e.prototype._get_factor_info=function(){var t=this.model.ranges[0],e=this.model.computed_bounds,i=e[0],n=e[1],r=this.model.loc,o=this.model.ticker.get_ticks(i,n,t,r,{}),s=this.model.tick_coords,a=[];if(1==t.levels){var l=this.model.formatter.doFormat(o.major,this.model);a.push([l,s.major,this.model.major_label_orientation,this.visuals.major_label_text])}else if(2==t.levels){var l=this.model.formatter.doFormat(o.major.map(function(t){return t[1]}),this.model);a.push([l,s.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([o.tops,s.tops,this.model.group_label_orientation,this.visuals.group_text])}else if(3==t.levels){var l=this.model.formatter.doFormat(o.major.map(function(t){return t[2]}),this.model),h=o.mids.map(function(t){return t[1]});a.push([l,s.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([h,s.mids,this.model.subgroup_label_orientation,this.visuals.subgroup_text]),a.push([o.tops,s.tops,this.model.group_label_orientation,this.visuals.group_text])}return a},e}(r.AxisView);i.CategoricalAxisView=l;var h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="CategoricalAxis",this.prototype.default_view=l,this.mixins(["line:separator_","text:group_","text:subgroup_"]),this.define({group_label_orientation:[a.Any,"parallel"],subgroup_label_orientation:[a.Any,"parallel"]}),this.override({ticker:function(){return new o.CategoricalTicker},formatter:function(){return new s.CategoricalTickFormatter},separator_line_color:"lightgrey",separator_line_width:2,group_text_font_style:"bold",group_text_font_size:"8pt",group_text_color:"grey",subgroup_text_font_style:"bold",subgroup_text_font_size:"8pt"})},Object.defineProperty(t.prototype,"tick_coords",{get:function(){var e=this,t=this.dimension,i=(t+1)%2,n=this.ranges[0],r=this.computed_bounds,o=r[0],s=r[1],a=this.ticker.get_ticks(o,s,n,this.loc,{}),l={major:[[],[]],mids:[[],[]],tops:[[],[]],minor:[[],[]]};return l.major[t]=a.major,l.major[i]=a.major.map(function(t){return e.loc}),3==n.levels&&(l.mids[t]=a.mids),l.mids[i]=a.mids.map(function(t){return e.loc}),1<n.levels&&(l.tops[t]=a.tops),l.tops[i]=a.tops.map(function(t){return e.loc}),l},enumerable:!0,configurable:!0}),t}(r.Axis);(i.CategoricalAxis=h).initClass()},function(t,e,i){var n=t(391),r=t(79),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="ContinuousAxis"},t}(r.Axis);(i.ContinuousAxis=o).initClass()},function(t,e,i){var n=t(391),r=t(84),o=t(106),s=t(211),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.LinearAxisView);i.DatetimeAxisView=a;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="DatetimeAxis",this.prototype.default_view=a,this.override({ticker:function(){return new s.DatetimeTicker},formatter:function(){return new o.DatetimeTickFormatter}})},t}(r.LinearAxis);(i.DatetimeAxis=l).initClass()},function(t,e,i){var n=t(79);i.Axis=n.Axis;var r=t(80);i.CategoricalAxis=r.CategoricalAxis;var o=t(81);i.ContinuousAxis=o.ContinuousAxis;var s=t(82);i.DatetimeAxis=s.DatetimeAxis;var a=t(84);i.LinearAxis=a.LinearAxis;var l=t(85);i.LogAxis=l.LogAxis;var h=t(86);i.MercatorAxis=h.MercatorAxis},function(t,e,i){var n=t(391),r=t(79),o=t(81),s=t(104),a=t(207),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.AxisView);i.LinearAxisView=l;var h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="LinearAxis",this.prototype.default_view=l,this.override({ticker:function(){return new a.BasicTicker},formatter:function(){return new s.BasicTickFormatter}})},t}(o.ContinuousAxis);(i.LinearAxis=h).initClass()},function(t,e,i){var n=t(391),r=t(79),o=t(81),s=t(109),a=t(215),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.AxisView);i.LogAxisView=l;var h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="LogAxis",this.prototype.default_view=l,this.override({ticker:function(){return new a.LogTicker},formatter:function(){return new s.LogTickFormatter}})},t}(o.ContinuousAxis);(i.LogAxis=h).initClass()},function(t,e,i){var n=t(391),r=t(79),o=t(84),s=t(110),a=t(216),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.AxisView);i.MercatorAxisView=l;var h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="MercatorAxis",this.prototype.default_view=l,this.override({ticker:function(){return new a.MercatorTicker({dimension:"lat"})},formatter:function(){return new s.MercatorTickFormatter({dimension:"lat"})}})},t}(o.LinearAxis);(i.MercatorAxis=h).initClass()},function(t,e,i){var n=t(391),r=t(59),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Callback"},t}(r.Model);(i.Callback=o).initClass()},function(i,t,e){var n=i(391),r=i(87),o=i(15),s=i(32),a=i(38),l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="CustomJS",this.define({args:[o.Any,{}],code:[o.String,""],use_strict:[o.Boolean,!1]})},Object.defineProperty(t.prototype,"names",{get:function(){return s.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"func",{get:function(){var t=this.use_strict?a.use_strict(this.code):this.code;return new(Function.bind.apply(Function,[void 0].concat(this.names,["cb_obj","cb_data","require","exports",t])))},enumerable:!0,configurable:!0}),t.prototype.execute=function(t,e){return this.func.apply(t,this.values.concat(t,e,i,{}))},t}(r.Callback);(e.CustomJS=l).initClass()},function(t,e,i){var n=t(88);i.CustomJS=n.CustomJS;var r=t(90);i.OpenURL=r.OpenURL},function(t,e,i){var n=t(391),r=t(87),o=t(15),s=t(35),a=t(40),l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="OpenURL",this.define({url:[o.String,"http://"]})},t.prototype.execute=function(t,e){for(var i=0,n=s.get_indices(e.source);i<n.length;i++){var r=n[i],o=a.replace_placeholders(this.url,e.source,r);window.open(o)}return null},t}(r.Callback);(i.OpenURL=l).initClass()},function(t,e,i){var n=t(391),r=t(11),o=t(6),s=t(13),a=t(14),l=t(15),h=t(5),u=t(26);null!=window.CanvasPixelArray&&(window.CanvasPixelArray.prototype.set=function(t){for(var e=0;e<this.length;e++)this[e]=t[e]});var c=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return n.__extends(t,i),Object.defineProperty(t.prototype,"ctx",{get:function(){return this._ctx},enumerable:!0,configurable:!0}),t.prototype.initialize=function(t){switch(i.prototype.initialize.call(this,t),this.map_el=this.model.map?this.el.appendChild(h.div({class:"bk-canvas-map"})):null,this.model.output_backend){case"canvas":case"webgl":this.canvas_el=this.el.appendChild(h.canvas({class:"bk-canvas"}));var e=this.canvas_el.getContext("2d");if(null==e)throw new Error("unable to obtain 2D rendering context");this._ctx=e;break;case"svg":var e=new u.SVGRenderingContext2D;this._ctx=e,this.canvas_el=this.el.appendChild(e.getSvg())}this.overlays_el=this.el.appendChild(h.div({class:"bk-canvas-overlays"})),this.events_el=this.el.appendChild(h.div({class:"bk-canvas-events"})),u.fixup_ctx(this._ctx),a.logger.debug("CanvasView initialized")},t.prototype.css_classes=function(){return i.prototype.css_classes.call(this).concat("bk-canvas-wrapper")},t.prototype.get_canvas_element=function(){return this.canvas_el},t.prototype.prepare_canvas=function(){var t=this.model._width.value,e=this.model._height.value;this.el.style.width=t+"px",this.el.style.height=e+"px";var i=u.get_scale_ratio(this.ctx,this.model.use_hidpi,this.model.output_backend);this.model.pixel_ratio=i,this.canvas_el.style.width=t+"px",this.canvas_el.style.height=e+"px",this.canvas_el.setAttribute("width",""+t*i),this.canvas_el.setAttribute("height",""+e*i),a.logger.debug("Rendering CanvasView with width: "+t+", height: "+e+", pixel ratio: "+i)},t.prototype.set_dims=function(t){var e=t[0],i=t[1];e<=0||i<=0||(e!=this.model._width.value&&(null!=this._width_constraint&&this.solver.has_constraint(this._width_constraint)&&this.solver.remove_constraint(this._width_constraint),this._width_constraint=s.EQ(this.model._width,-e),this.solver.add_constraint(this._width_constraint)),i!=this.model._height.value&&(null!=this._height_constraint&&this.solver.has_constraint(this._height_constraint)&&this.solver.remove_constraint(this._height_constraint),this._height_constraint=s.EQ(this.model._height,-i),this.solver.add_constraint(this._height_constraint)),this.solver.update_variables())},t}(o.DOMView);i.CanvasView=c;var _=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Canvas",this.prototype.default_view=c,this.internal({map:[l.Boolean,!1],use_hidpi:[l.Boolean,!0],pixel_ratio:[l.Number,1],output_backend:[l.OutputBackend,"canvas"]})},Object.defineProperty(t.prototype,"panel",{get:function(){return this},enumerable:!0,configurable:!0}),t}(r.LayoutCanvas);(i.Canvas=_).initClass()},function(t,e,i){var n=t(391),a=t(190),l=t(192),h=t(193),u=t(184),c=t(180),_=t(181),r=t(11),o=t(15),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="CartesianFrame",this.internal({extra_x_ranges:[o.Any,{}],extra_y_ranges:[o.Any,{}],x_range:[o.Instance],y_range:[o.Instance],x_scale:[o.Instance],y_scale:[o.Instance]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this._configure_scales()},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.change,function(){return t._configure_scales()})},Object.defineProperty(t.prototype,"panel",{get:function(){return this},enumerable:!0,configurable:!0}),t.prototype.get_editables=function(){return e.prototype.get_editables.call(this).concat([this._width,this._height])},t.prototype.map_to_screen=function(t,e,i,n){void 0===i&&(i="default"),void 0===n&&(n="default");var r=this.xscales[i].v_compute(t),o=this.yscales[n].v_compute(e);return[r,o]},t.prototype._get_ranges=function(t,e){var i={};if(i.default=t,null!=e)for(var n in e)i[n]=e[n];return i},t.prototype._get_scales=function(t,e,i){var n={};for(var r in e){var o=e[r];if(o instanceof c.DataRange1d||o instanceof u.Range1d){if(!(t instanceof h.LogScale||t instanceof l.LinearScale))throw new Error("Range "+o.type+" is incompatible is Scale "+t.type);if(t instanceof a.CategoricalScale)throw new Error("Range "+o.type+" is incompatible is Scale "+t.type)}if(o instanceof _.FactorRange&&!(t instanceof a.CategoricalScale))throw new Error("Range "+o.type+" is incompatible is Scale "+t.type);t instanceof h.LogScale&&o instanceof c.DataRange1d&&(o.scale_hint="log");var s=t.clone();s.setv({source_range:o,target_range:i}),n[r]=s}return n},t.prototype._configure_frame_ranges=function(){this._h_target=new u.Range1d({start:this._left.value,end:this._right.value}),this._v_target=new u.Range1d({start:this._bottom.value,end:this._top.value})},t.prototype._configure_scales=function(){this._configure_frame_ranges(),this._x_ranges=this._get_ranges(this.x_range,this.extra_x_ranges),this._y_ranges=this._get_ranges(this.y_range,this.extra_y_ranges),this._xscales=this._get_scales(this.x_scale,this._x_ranges,this._h_target),this._yscales=this._get_scales(this.y_scale,this._y_ranges,this._v_target)},t.prototype.update_scales=function(){for(var t in this._configure_frame_ranges(),this._xscales){var e=this._xscales[t];e.target_range=this._h_target}for(var i in this._yscales){var e=this._yscales[i];e.target_range=this._v_target}},Object.defineProperty(t.prototype,"x_ranges",{get:function(){return this._x_ranges},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"y_ranges",{get:function(){return this._y_ranges},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"xscales",{get:function(){return this._xscales},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"yscales",{get:function(){return this._yscales},enumerable:!0,configurable:!0}),t}(r.LayoutCanvas);(i.CartesianFrame=s).initClass()},function(t,e,i){var n=t(91);i.Canvas=n.Canvas;var r=t(92);i.CartesianFrame=r.CartesianFrame},function(t,e,i){var n=t(391),r=t(95),o=t(15),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="CumSum",this.define({field:[o.String],include_zero:[o.Boolean,!1]})},t.prototype._v_compute=function(t){var e=new Float64Array(t.get_length()||0),i=t.data[this.field],n=this.include_zero?1:0;e[0]=this.include_zero?0:i[0];for(var r=1;r<e.length;r++)e[r]=e[r-1]+i[r-n];return e},t}(r.Expression);(i.CumSum=s).initClass()},function(t,e,i){var n=t(391),r=t(59),o=function(i){function t(t){var e=i.call(this,t)||this;return e._connected={},e._result={},e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="Expression"},t.prototype.initialize=function(){i.prototype.initialize.call(this),this._connected={},this._result={}},t.prototype.v_compute=function(t){var e=this;null==this._connected[t.id]&&(this.connect(t.change,function(){return delete e._result[t.id]}),this.connect(t.patching,function(){return delete e._result[t.id]}),this.connect(t.streaming,function(){return delete e._result[t.id]}),this._connected[t.id]=!0);var i=this._result[t.id];return null==i&&(this._result[t.id]=i=this._v_compute(t)),i},t}(r.Model);(i.Expression=o).initClass()},function(t,e,i){var n=t(95);i.Expression=n.Expression;var r=t(97);i.Stack=r.Stack;var o=t(94);i.CumSum=o.CumSum},function(t,e,i){var n=t(391),r=t(95),o=t(15),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Stack",this.define({fields:[o.Array,[]]})},t.prototype._v_compute=function(t){for(var e=new Float64Array(t.get_length()||0),i=0,n=this.fields;i<n.length;i++)for(var r=n[i],o=0;o<t.data[r].length;o++){var s=t.data[r][o];e[o]+=s}return e},t}(r.Expression);(i.Stack=s).initClass()},function(t,e,i){var n=t(391),r=t(100),o=t(15),s=t(14),a=t(21),l=t(44),h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="BooleanFilter",this.define({booleans:[o.Array,null]})},t.prototype.compute_indices=function(t){var e=this.booleans;return null!=e&&0<e.length?a.all(e,l.isBoolean)?(e.length!==t.get_length()&&s.logger.warn("BooleanFilter "+this.id+": length of booleans doesn't match data source"),a.range(0,e.length).filter(function(t){return!0===e[t]})):(s.logger.warn("BooleanFilter "+this.id+": booleans should be array of booleans, defaulting to no filtering"),null):(null!=e&&0==e.length?s.logger.warn("BooleanFilter "+this.id+": booleans is empty, defaulting to no filtering"):s.logger.warn("BooleanFilter "+this.id+": booleans was not set, defaulting to no filtering"),null)},t}(r.Filter);(i.BooleanFilter=h).initClass()},function(i,t,e){var n=i(391),r=i(100),o=i(15),s=i(32),a=i(38),l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="CustomJSFilter",this.define({args:[o.Any,{}],code:[o.String,""],use_strict:[o.Boolean,!1]})},Object.defineProperty(t.prototype,"names",{get:function(){return s.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"func",{get:function(){var t=this.use_strict?a.use_strict(this.code):this.code;return new(Function.bind.apply(Function,[void 0].concat(this.names,["source","require","exports",t])))},enumerable:!0,configurable:!0}),t.prototype.compute_indices=function(t){return this.filter=this.func.apply(this,this.values.concat([t,i,{}])),e.prototype.compute_indices.call(this,t)},t}(r.Filter);(e.CustomJSFilter=l).initClass()},function(t,e,i){var n=t(391),r=t(59),o=t(15),s=t(44),a=t(21),l=t(14),h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Filter",this.define({filter:[o.Array,null]})},t.prototype.compute_indices=function(t){var e=this.filter;return null!=e&&0<=e.length?s.isArrayOf(e,s.isBoolean)?a.range(0,e.length).filter(function(t){return!0===e[t]}):s.isArrayOf(e,s.isInteger)?e:(l.logger.warn("Filter "+this.id+": filter should either be array of only booleans or only integers, defaulting to no filtering"),null):(l.logger.warn("Filter "+this.id+": filter was not set to be an array, defaulting to no filtering"),null)},t}(r.Model);(i.Filter=h).initClass()},function(t,e,i){var n=t(391),r=t(100),o=t(15),s=t(14),a=t(21),l=function(i){function t(t){var e=i.call(this,t)||this;return e.indices=null,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="GroupFilter",this.define({column_name:[o.String],group:[o.String]})},t.prototype.compute_indices=function(t){var e=this,i=t.get_column(this.column_name);return null==i?(s.logger.warn("group filter: groupby column not found in data source"),null):(this.indices=a.range(0,t.get_length()||0).filter(function(t){return i[t]===e.group}),0===this.indices.length&&s.logger.warn("group filter: group '"+this.group+"' did not match any values in column '"+this.column_name+"'"),this.indices)},t}(r.Filter);(i.GroupFilter=l).initClass()},function(t,e,i){var n=t(98);i.BooleanFilter=n.BooleanFilter;var r=t(99);i.CustomJSFilter=r.CustomJSFilter;var o=t(100);i.Filter=o.Filter;var s=t(101);i.GroupFilter=s.GroupFilter;var a=t(103);i.IndexFilter=a.IndexFilter},function(t,e,i){var n=t(391),r=t(100),o=t(15),s=t(14),a=t(44),l=t(21),h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="IndexFilter",this.define({indices:[o.Array,null]})},t.prototype.compute_indices=function(t){return null!=this.indices&&0<=this.indices.length?l.all(this.indices,a.isInteger)?this.indices:(s.logger.warn("IndexFilter "+this.id+": indices should be array of integers, defaulting to no filtering"),null):(s.logger.warn("IndexFilter "+this.id+": indices was not set, defaulting to no filtering"),null)},t}(r.Filter);(i.IndexFilter=h).initClass()},function(t,e,i){var n=t(391),r=t(113),o=t(15),f=t(44),s=function(i){function t(t){var e=i.call(this,t)||this;return e.last_precision=3,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="BasicTickFormatter",this.define({precision:[o.Any,"auto"],use_scientific:[o.Bool,!0],power_limit_high:[o.Number,5],power_limit_low:[o.Number,-3]})},Object.defineProperty(t.prototype,"scientific_limit_low",{get:function(){return Math.pow(10,this.power_limit_low)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"scientific_limit_high",{get:function(){return Math.pow(10,this.power_limit_high)},enumerable:!0,configurable:!0}),t.prototype.doFormat=function(t,e){if(0==t.length)return[];var i=0;2<=t.length&&(i=Math.abs(t[1]-t[0])/1e4);var n=!1;if(this.use_scientific)for(var r=0,o=t;r<o.length;r++){var s=o[r],a=Math.abs(s);if(i<a&&(a>=this.scientific_limit_high||a<=this.scientific_limit_low)){n=!0;break}}var l=new Array(t.length),h=this.precision;if(null==h||f.isNumber(h))if(n)for(var u=0,c=t.length;u<c;u++)l[u]=t[u].toExponential(h||void 0);else for(var u=0,c=t.length;u<c;u++)l[u]=t[u].toFixed(h||void 0).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"");else for(var _=this.last_precision,p=this.last_precision<=15;p?_<=15:15<=_;p?_++:_--){var d=!0;if(n){for(var u=0,c=t.length;u<c;u++)if(l[u]=t[u].toExponential(_),0<u&&l[u]===l[u-1]){d=!1;break}if(d)break}else{for(var u=0,c=t.length;u<c;u++)if(l[u]=t[u].toFixed(_).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,""),0<u&&l[u]==l[u-1]){d=!1;break}if(d)break}if(d){this.last_precision=_;break}}return l},t}(r.TickFormatter);(i.BasicTickFormatter=s).initClass()},function(t,e,i){var n=t(391),r=t(113),o=t(21),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="CategoricalTickFormatter"},t.prototype.doFormat=function(t,e){return o.copy(t)},t}(r.TickFormatter);(i.CategoricalTickFormatter=s).initClass()},function(t,e,i){var n=t(391),r=t(389),w=t(390),o=t(113),k=t(14),s=t(15),a=t(21),l=t(44);function S(t,e){if(l.isFunction(e))return e(t);var i,n=r.sprintf("$1%06d",(i=t,Math.round(i/1e3%1*1e6)));return-1==(e=e.replace(/((^|[^%])(%%)*)%f/,n)).indexOf("%")?e:w(t,e)}var C=["microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"],h=function(i){function t(t){var e=i.call(this,t)||this;return e.strip_leading_zeros=!0,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="DatetimeTickFormatter",this.define({microseconds:[s.Array,["%fus"]],milliseconds:[s.Array,["%3Nms","%S.%3Ns"]],seconds:[s.Array,["%Ss"]],minsec:[s.Array,[":%M:%S"]],minutes:[s.Array,[":%M","%Mm"]],hourmin:[s.Array,["%H:%M"]],hours:[s.Array,["%Hh","%H:%M"]],days:[s.Array,["%m/%d","%a%d"]],months:[s.Array,["%m/%Y","%b %Y"]],years:[s.Array,["%Y"]]})},t.prototype.initialize=function(){i.prototype.initialize.call(this),this._update_width_formats()},t.prototype._update_width_formats=function(){var n=+w(new Date),t=function(t){var e=t.map(function(t){return S(n,t).length}),i=a.sortBy(a.zip(e,t),function(t){var e=t[0];return e});return a.unzip(i)};this._width_formats={microseconds:t(this.microseconds),milliseconds:t(this.milliseconds),seconds:t(this.seconds),minsec:t(this.minsec),minutes:t(this.minutes),hourmin:t(this.hourmin),hours:t(this.hours),days:t(this.days),months:t(this.months),years:t(this.years)}},t.prototype._get_resolution_str=function(t,e){var i=1.1*t;switch(!1){case!(i<.001):return"microseconds";case!(i<1):return"milliseconds";case!(i<60):return 60<=e?"minsec":"seconds";case!(i<3600):return 3600<=e?"hourmin":"minutes";case!(i<86400):return"hours";case!(i<2678400):return"days";case!(i<31536e3):return"months";default:return"years"}},t.prototype.doFormat=function(t,e){if(0==t.length)return[];for(var i=Math.abs(t[t.length-1]-t[0])/1e3,n=i/(t.length-1),r=this._get_resolution_str(n,i),o=this._width_formats[r],s=o[1][0],a=[],l=C.indexOf(r),h={},u=0,c=C;u<c.length;u++){var _=c[u];h[_]=0}h.seconds=5,h.minsec=4,h.minutes=4,h.hourmin=3,h.hours=3;for(var p=0,d=t;p<d.length;p++){var f=d[p],v=void 0,m=void 0;try{m=w(f,"%Y %m %d %H %M %S").split(/\s+/).map(function(t){return parseInt(t,10)}),v=S(f,s)}catch(t){k.logger.warn("unable to format tick for timestamp value "+f),k.logger.warn(" - "+t),a.push("ERR");continue}for(var g=!1,y=l;0==m[h[C[y]]];){var b=void 0;if((y+=1)==C.length)break;if(("minsec"==r||"hourmin"==r)&&!g){if("minsec"==r&&0==m[4]&&0!=m[5]||"hourmin"==r&&0==m[3]&&0!=m[4]){b=this._width_formats[C[l-1]][1][0],v=S(f,b);break}g=!0}b=this._width_formats[C[y]][1][0],v=S(f,b)}if(this.strip_leading_zeros){var x=v.replace(/^0+/g,"");x!=v&&isNaN(parseInt(x))&&(x="0"+x),a.push(x)}else a.push(v)}return a},t}(o.TickFormatter);(i.DatetimeTickFormatter=h).initClass()},function(o,t,e){var i=o(391),n=o(113),r=o(15),s=o(32),a=o(38),l=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="FuncTickFormatter",this.define({args:[r.Any,{}],code:[r.String,""],use_strict:[r.Boolean,!1]})},Object.defineProperty(t.prototype,"names",{get:function(){return s.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!0,configurable:!0}),t.prototype._make_func=function(){var t=this.use_strict?a.use_strict(this.code):this.code;return new(Function.bind.apply(Function,[void 0,"tick","index","ticks"].concat(this.names,["require","exports",t])))},t.prototype.doFormat=function(t,e){var n=this,r=this._make_func().bind({});return t.map(function(t,e,i){return r.apply(void 0,[t,e,i].concat(n.values,[o,{}]))})},t}(n.TickFormatter);(e.FuncTickFormatter=l).initClass()},function(t,e,i){var n=t(104);i.BasicTickFormatter=n.BasicTickFormatter;var r=t(105);i.CategoricalTickFormatter=r.CategoricalTickFormatter;var o=t(106);i.DatetimeTickFormatter=o.DatetimeTickFormatter;var s=t(107);i.FuncTickFormatter=s.FuncTickFormatter;var a=t(109);i.LogTickFormatter=a.LogTickFormatter;var l=t(110);i.MercatorTickFormatter=l.MercatorTickFormatter;var h=t(111);i.NumeralTickFormatter=h.NumeralTickFormatter;var u=t(112);i.PrintfTickFormatter=u.PrintfTickFormatter;var c=t(113);i.TickFormatter=c.TickFormatter},function(t,e,i){var n=t(391),r=t(113),o=t(104),s=t(14),a=t(15),l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="LogTickFormatter",this.define({ticker:[a.Instance,null]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this.basic_formatter=new o.BasicTickFormatter,null==this.ticker&&s.logger.warn("LogTickFormatter not configured with a ticker, using default base of 10 (labels will be incorrect if ticker base is not 10)")},t.prototype.doFormat=function(t,e){if(0==t.length)return[];for(var i=null!=this.ticker?this.ticker.base:10,n=!1,r=new Array(t.length),o=0,s=t.length;o<s;o++)if(r[o]=i+"^"+Math.round(Math.log(t[o])/Math.log(i)),0<o&&r[o]==r[o-1]){n=!0;break}return n?this.basic_formatter.doFormat(t,e):r},t}(r.TickFormatter);(i.LogTickFormatter=l).initClass()},function(t,e,i){var n=t(391),r=t(104),o=t(15),h=t(33),s=function(l){function t(t){return l.call(this,t)||this}return n.__extends(t,l),t.initClass=function(){this.prototype.type="MercatorTickFormatter",this.define({dimension:[o.LatLon]})},t.prototype.doFormat=function(t,e){if(null==this.dimension)throw new Error("MercatorTickFormatter.dimension not configured");if(0==t.length)return[];var i=t.length,n=new Array(i);if("lon"==this.dimension)for(var r=0;r<i;r++){var o=h.wgs84_mercator.inverse([t[r],e.loc])[0];n[r]=o}else for(var r=0;r<i;r++){var s=h.wgs84_mercator.inverse([e.loc,t[r]]),a=s[1];n[r]=a}return l.prototype.doFormat.call(this,n,e)},t}(r.BasicTickFormatter);(i.MercatorTickFormatter=s).initClass()},function(t,e,i){var n=t(391),o=t(361),r=t(113),s=t(15),a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="NumeralTickFormatter",this.define({format:[s.String,"0,0"],language:[s.String,"en"],rounding:[s.String,"round"]})},Object.defineProperty(t.prototype,"_rounding_fn",{get:function(){switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}},enumerable:!0,configurable:!0}),t.prototype.doFormat=function(t,e){var i=this.format,n=this.language,r=this._rounding_fn;return t.map(function(t){return o.format(t,i,n,r)})},t}(r.TickFormatter);(i.NumeralTickFormatter=a).initClass()},function(t,e,i){var n=t(391),r=t(389),o=t(113),s=t(15),a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="PrintfTickFormatter",this.define({format:[s.String,"%s"]})},t.prototype.doFormat=function(t,e){var i=this;return t.map(function(t){return r.sprintf(i.format,t)})},t}(o.TickFormatter);(i.PrintfTickFormatter=a).initClass()},function(t,e,i){var n=t(391),r=t(59),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="TickFormatter"},t}(r.Model);(i.TickFormatter=o).initClass()},function(t,e,i){var n=t(391),r=t(146),o=t(143),z=t(9),s=t(15),P=t(31),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius,this._angle=new Float32Array(this._start_angle.length);for(var t=0,e=this._start_angle.length;t<e;t++)this._angle[t]=this._end_angle[t]-this._start_angle[t]},e.prototype._render=function(t,e,i){for(var n=i.sx,r=i.sy,o=i._start_angle,s=i._angle,a=i.sinner_radius,l=i.souter_radius,h=this.model.properties.direction.value(),u=0,c=e;u<c.length;u++){var _=c[u];isNaN(n[_]+r[_]+a[_]+l[_]+o[_]+s[_])||(t.translate(n[_],r[_]),t.rotate(o[_]),t.moveTo(l[_],0),t.beginPath(),t.arc(0,0,l[_],0,s[_],h),t.rotate(s[_]),t.lineTo(a[_],0),t.arc(0,0,a[_],0,-s[_],!h),t.closePath(),t.rotate(-s[_]-o[_]),t.translate(-n[_],-r[_]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,_),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,_),t.stroke()))}},e.prototype._hit_point=function(t){var e,i,n,r,o,s,a=t.sx,l=t.sy,h=this.renderer.xscale.invert(a),u=this.renderer.yscale.invert(l);if("data"==this.model.properties.outer_radius.units)n=h-this.max_outer_radius,o=h+this.max_outer_radius,r=u-this.max_outer_radius,s=u+this.max_outer_radius;else{var c=a-this.max_outer_radius,_=a+this.max_outer_radius;e=this.renderer.xscale.r_invert(c,_),n=e[0],o=e[1];var p=l-this.max_outer_radius,d=l+this.max_outer_radius;i=this.renderer.yscale.r_invert(p,d),r=i[0],s=i[1]}for(var f=[],v=z.validate_bbox_coords([n,o],[r,s]),m=0,g=this.index.indices(v);m<g.length;m++){var y=g[m],b=Math.pow(this.souter_radius[y],2),x=Math.pow(this.sinner_radius[y],2),w=this.renderer.xscale.r_compute(h,this._x[y]),c=w[0],_=w[1],k=this.renderer.yscale.r_compute(u,this._y[y]),p=k[0],d=k[1],S=Math.pow(c-_,2)+Math.pow(p-d,2);S<=b&&x<=S&&f.push([y,S])}for(var C=this.model.properties.direction.value(),T=[],A=0,E=f;A<E.length;A++){var M=E[A],y=M[0],S=M[1],O=Math.atan2(l-this.sy[y],a-this.sx[y]);P.angle_between(-O,-this._start_angle[y],-this._end_angle[y],C)&&T.push([y,S])}return z.create_hit_test_result_from_hits(T)},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_area_legend(this.visuals,t,e,i)},e.prototype._scenterxy=function(t){var e=(this.sinner_radius[t]+this.souter_radius[t])/2,i=(this._start_angle[t]+this._end_angle[t])/2;return{x:this.sx[t]+e*Math.cos(i),y:this.sy[t]+e*Math.sin(i)}},e.prototype.scenterx=function(t){return this._scenterxy(t).x},e.prototype.scentery=function(t){return this._scenterxy(t).y},e}(r.XYGlyphView);i.AnnularWedgeView=a;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="AnnularWedge",this.prototype.default_view=a,this.mixins(["line","fill"]),this.define({direction:[s.Direction,"anticlock"],inner_radius:[s.DistanceSpec],outer_radius:[s.DistanceSpec],start_angle:[s.AngleSpec],end_angle:[s.AngleSpec]})},t}(r.XYGlyph);(i.AnnularWedge=l).initClass()},function(t,e,i){var n=t(391),r=t(146),C=t(9),o=t(15),p=t(28),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius},e.prototype._render=function(t,e,i){for(var n=i.sx,r=i.sy,o=i.sinner_radius,s=i.souter_radius,a=0,l=e;a<l.length;a++){var h=l[a];if(!isNaN(n[h]+r[h]+o[h]+s[h])){if(this.visuals.fill.doit){if(this.visuals.fill.set_vectorize(t,h),t.beginPath(),p.is_ie)for(var u=0,c=[!1,!0];u<c.length;u++){var _=c[u];t.arc(n[h],r[h],o[h],0,Math.PI,_),t.arc(n[h],r[h],s[h],Math.PI,0,!_)}else t.arc(n[h],r[h],o[h],0,2*Math.PI,!0),t.arc(n[h],r[h],s[h],2*Math.PI,0,!1);t.fill()}this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,h),t.beginPath(),t.arc(n[h],r[h],o[h],0,2*Math.PI),t.moveTo(n[h]+s[h],r[h]),t.arc(n[h],r[h],s[h],0,2*Math.PI),t.stroke())}}},e.prototype._hit_point=function(t){var e,i,n,r,o,s,a=t.sx,l=t.sy,h=this.renderer.xscale.invert(a),u=this.renderer.yscale.invert(l);if("data"==this.model.properties.outer_radius.units)n=h-this.max_outer_radius,o=h+this.max_outer_radius,r=u-this.max_outer_radius,s=u+this.max_outer_radius;else{var c=a-this.max_outer_radius,_=a+this.max_outer_radius;e=this.renderer.xscale.r_invert(c,_),n=e[0],o=e[1];var p=l-this.max_outer_radius,d=l+this.max_outer_radius;i=this.renderer.yscale.r_invert(p,d),r=i[0],s=i[1]}for(var f=[],v=C.validate_bbox_coords([n,o],[r,s]),m=0,g=this.index.indices(v);m<g.length;m++){var y=g[m],b=Math.pow(this.souter_radius[y],2),x=Math.pow(this.sinner_radius[y],2),w=this.renderer.xscale.r_compute(h,this._x[y]),c=w[0],_=w[1],k=this.renderer.yscale.r_compute(u,this._y[y]),p=k[0],d=k[1],S=Math.pow(c-_,2)+Math.pow(p-d,2);S<=b&&x<=S&&f.push([y,S])}return C.create_hit_test_result_from_hits(f)},e.prototype.draw_legend_for_index=function(t,e,i){var n=e.x0,r=e.y0,o=e.x1,s=e.y1,a=i+1,l=new Array(a);l[i]=(n+o)/2;var h=new Array(a);h[i]=(r+s)/2;var u=.5*Math.min(Math.abs(o-n),Math.abs(s-r)),c=new Array(a);c[i]=.4*u;var _=new Array(a);_[i]=.8*u,this._render(t,[i],{sx:l,sy:h,sinner_radius:c,souter_radius:_})},e}(r.XYGlyphView);i.AnnulusView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Annulus",this.prototype.default_view=s,this.mixins(["line","fill"]),this.define({inner_radius:[o.DistanceSpec],outer_radius:[o.DistanceSpec]})},t}(r.XYGlyph);(i.Annulus=a).initClass()},function(t,e,i){var n=t(391),r=t(146),o=t(143),s=t(15),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius},e.prototype._render=function(t,e,i){var n=i.sx,r=i.sy,o=i.sradius,s=i._start_angle,a=i._end_angle;if(this.visuals.line.doit)for(var l=this.model.properties.direction.value(),h=0,u=e;h<u.length;h++){var c=u[h];isNaN(n[c]+r[c]+o[c]+s[c]+a[c])||(t.beginPath(),t.arc(n[c],r[c],o[c],s[c],a[c],l),this.visuals.line.set_vectorize(t,c),t.stroke())}},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_line_legend(this.visuals,t,e,i)},e}(r.XYGlyphView);i.ArcView=a;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Arc",this.prototype.default_view=a,this.mixins(["line"]),this.define({direction:[s.Direction,"anticlock"],radius:[s.DistanceSpec],start_angle:[s.AngleSpec],end_angle:[s.AngleSpec]})},t}(r.XYGlyph);(i.Arc=l).initClass()},function(t,e,i){var n=t(391),l=t(37),r=t(123),o=t(143);function h(t,e,i,n,r,o,s,a){for(var l=[],h=[[],[]],u=0;u<=2;u++){var c=void 0,_=void 0,p=void 0;if(0===u?(_=6*t-12*i+6*r,c=-3*t+9*i-9*r+3*s,p=3*i-3*t):(_=6*e-12*n+6*o,c=-3*e+9*n-9*o+3*a,p=3*n-3*e),Math.abs(c)<1e-12){if(Math.abs(_)<1e-12)continue;var d=-p/_;0<d&&d<1&&l.push(d)}else{var f=_*_-4*p*c,v=Math.sqrt(f);if(!(f<0)){var m=(-_+v)/(2*c);0<m&&m<1&&l.push(m);var g=(-_-v)/(2*c);0<g&&g<1&&l.push(g)}}}for(var y=l.length,b=y;y--;){var d=l[y],x=1-d,w=x*x*x*t+3*x*x*d*i+3*x*d*d*r+d*d*d*s;h[0][y]=w;var k=x*x*x*e+3*x*x*d*n+3*x*d*d*o+d*d*d*a;h[1][y]=k}return h[0][b]=t,h[1][b]=e,h[0][b+1]=s,h[1][b+1]=a,[Math.min.apply(Math,h[0]),Math.max.apply(Math,h[1]),Math.max.apply(Math,h[0]),Math.min.apply(Math,h[1])]}var s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._x0.length;e<i;e++)if(!isNaN(this._x0[e]+this._x1[e]+this._y0[e]+this._y1[e]+this._cx0[e]+this._cy0[e]+this._cx1[e]+this._cy1[e])){var n=h(this._x0[e],this._y0[e],this._x1[e],this._y1[e],this._cx0[e],this._cy0[e],this._cx1[e],this._cy1[e]),r=n[0],o=n[1],s=n[2],a=n[3];t.push({minX:r,minY:o,maxX:s,maxY:a,i:e})}return new l.SpatialIndex(t)},e.prototype._render=function(t,e,i){var n=i.sx0,r=i.sy0,o=i.sx1,s=i.sy1,a=i.scx0,l=i.scy0,h=i.scx1,u=i.scy1;if(this.visuals.line.doit)for(var c=0,_=e;c<_.length;c++){var p=_[c];isNaN(n[p]+r[p]+o[p]+s[p]+a[p]+l[p]+h[p]+u[p])||(t.beginPath(),t.moveTo(n[p],r[p]),t.bezierCurveTo(a[p],l[p],h[p],u[p],o[p],s[p]),this.visuals.line.set_vectorize(t,p),t.stroke())}},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_line_legend(this.visuals,t,e,i)},e.prototype.scenterx=function(){throw new Error("not implemented")},e.prototype.scentery=function(){throw new Error("not implemented")},e}(r.GlyphView);i.BezierView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Bezier",this.prototype.default_view=s,this.coords([["x0","y0"],["x1","y1"],["cx0","cy0"],["cx1","cy1"]]),this.mixins(["line"])},t}(r.Glyph);(i.Bezier=a).initClass()},function(t,e,i){var n=t(391),l=t(37),r=t(123),o=t(143),f=t(9),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_box=function(t){for(var e=[],i=0;i<t;i++){var n=this._lrtb(i),r=n[0],o=n[1],s=n[2],a=n[3];!isNaN(r+o+s+a)&&isFinite(r+o+s+a)&&e.push({minX:Math.min(r,o),minY:Math.min(s,a),maxX:Math.max(o,r),maxY:Math.max(s,a),i:i})}return new l.SpatialIndex(e)},e.prototype._render=function(t,e,i){for(var n=i.sleft,r=i.sright,o=i.stop,s=i.sbottom,a=0,l=e;a<l.length;a++){var h=l[a];isNaN(n[h]+o[h]+r[h]+s[h])||(this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,h),t.fillRect(n[h],o[h],r[h]-n[h],s[h]-o[h])),this.visuals.line.doit&&(t.beginPath(),t.rect(n[h],o[h],r[h]-n[h],s[h]-o[h]),this.visuals.line.set_vectorize(t,h),t.stroke()))}},e.prototype._clamp_viewport=function(){for(var t=this.renderer.plot_view.frame.bbox.h_range,e=this.renderer.plot_view.frame.bbox.v_range,i=this.stop.length,n=0;n<i;n++)this.stop[n]=Math.max(this.stop[n],e.start),this.sbottom[n]=Math.min(this.sbottom[n],e.end),this.sleft[n]=Math.max(this.sleft[n],t.start),this.sright[n]=Math.min(this.sright[n],t.end)},e.prototype._hit_rect=function(t){return this._hit_rect_against_index(t)},e.prototype._hit_point=function(t){var e=t.sx,i=t.sy,n=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(i),o=this.index.indices({minX:n,minY:r,maxX:n,maxY:r}),s=f.create_empty_hit_test_result();return s.indices=o,s},e.prototype._hit_span=function(t){var e,i=t.sx,n=t.sy;if("v"==t.direction){var r=this.renderer.yscale.invert(n),o=this.renderer.plot_view.frame.bbox.h_range,s=this.renderer.xscale.r_invert(o.start,o.end),a=s[0],l=s[1];e=this.index.indices({minX:a,minY:r,maxX:l,maxY:r})}else{var h=this.renderer.xscale.invert(i),u=this.renderer.plot_view.frame.bbox.v_range,c=this.renderer.yscale.r_invert(u.start,u.end),_=c[0],p=c[1];e=this.index.indices({minX:h,minY:_,maxX:h,maxY:p})}var d=f.create_empty_hit_test_result();return d.indices=e,d},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_area_legend(this.visuals,t,e,i)},e}(r.GlyphView);i.BoxView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Box",this.mixins(["line","fill"])},t}(r.Glyph);(i.Box=a).initClass()},function(t,e,i){var n=t(391),r=t(146),o=t(15),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.XYGlyphView);i.CenterRotatableView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="CenterRotatable",this.mixins(["line","fill"]),this.define({angle:[o.AngleSpec,0],width:[o.DistanceSpec],height:[o.DistanceSpec]})},t}(r.XYGlyph);(i.CenterRotatable=a).initClass()},function(t,e,i){var n=t(391),r=t(146),M=t(9),o=t(15),h=t(21),s=t(22),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._map_data=function(){if(null!=this._radius)if("data"==this.model.properties.radius.spec.units){var t=this.model.properties.radius_dimension.spec.value;switch(t){case"x":this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius);break;case"y":this.sradius=this.sdist(this.renderer.yscale,this._y,this._radius)}}else this.sradius=this._radius,this.max_size=2*this.max_radius;else this.sradius=s.map(this._size,function(t){return t/2})},e.prototype._mask_data=function(){var t,e,i,n,r,o,s,a,l=this.renderer.plot_view.frame.bbox.ranges,h=l[0],u=l[1];if(null!=this._radius&&"data"==this.model.properties.radius.units){var c=h.start,_=h.end;t=this.renderer.xscale.r_invert(c,_),r=t[0],s=t[1],r-=this.max_radius,s+=this.max_radius;var p=u.start,d=u.end;e=this.renderer.yscale.r_invert(p,d),o=e[0],a=e[1],o-=this.max_radius,a+=this.max_radius}else{var c=h.start-this.max_size,_=h.end+this.max_size;i=this.renderer.xscale.r_invert(c,_),r=i[0],s=i[1];var p=u.start-this.max_size,d=u.end+this.max_size;n=this.renderer.yscale.r_invert(p,d),o=n[0],a=n[1]}var f=M.validate_bbox_coords([r,s],[o,a]);return this.index.indices(f)},e.prototype._render=function(t,e,i){for(var n=i.sx,r=i.sy,o=i.sradius,s=0,a=e;s<a.length;s++){var l=a[s];isNaN(n[l]+r[l]+o[l])||(t.beginPath(),t.arc(n[l],r[l],o[l],0,2*Math.PI,!1),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,l),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,l),t.stroke()))}},e.prototype._hit_point=function(t){var e,i,n,r,o,s,a,l,h,u,c,_,p,d,f,v,m=t.sx,g=t.sy,y=this.renderer.xscale.invert(m),b=this.renderer.yscale.invert(g);null!=this._radius&&"data"==this.model.properties.radius.units?(p=y-this.max_radius,d=y+this.max_radius,f=b-this.max_radius,v=b+this.max_radius):(h=m-this.max_size,u=m+this.max_size,e=this.renderer.xscale.r_invert(h,u),p=e[0],d=e[1],i=[Math.min(p,d),Math.max(p,d)],p=i[0],d=i[1],c=g-this.max_size,_=g+this.max_size,n=this.renderer.yscale.r_invert(c,_),f=n[0],v=n[1],r=[Math.min(f,v),Math.max(f,v)],f=r[0],v=r[1]);var x=M.validate_bbox_coords([p,d],[f,v]),w=this.index.indices(x),k=[];if(null!=this._radius&&"data"==this.model.properties.radius.units)for(var S=0,C=w;S<C.length;S++){var T=C[S];l=Math.pow(this.sradius[T],2),o=this.renderer.xscale.r_compute(y,this._x[T]),h=o[0],u=o[1],s=this.renderer.yscale.r_compute(b,this._y[T]),c=s[0],_=s[1],(a=Math.pow(h-u,2)+Math.pow(c-_,2))<=l&&k.push([T,a])}else for(var A=0,E=w;A<E.length;A++){var T=E[A];l=Math.pow(this.sradius[T],2),(a=Math.pow(this.sx[T]-m,2)+Math.pow(this.sy[T]-g,2))<=l&&k.push([T,a])}return M.create_hit_test_result_from_hits(k)},e.prototype._hit_span=function(t){var e,i,n,r,o,s,a,l,h,u=t.sx,c=t.sy,_=this.bounds(),p=_.minX,d=_.minY,f=_.maxX,v=_.maxY,m=M.create_empty_hit_test_result();if("h"==t.direction){var g=void 0,y=void 0;l=d,h=v,null!=this._radius&&"data"==this.model.properties.radius.units?(g=u-this.max_radius,y=u+this.max_radius,e=this.renderer.xscale.r_invert(g,y),s=e[0],a=e[1]):(o=this.max_size/2,g=u-o,y=u+o,i=this.renderer.xscale.r_invert(g,y),s=i[0],a=i[1])}else{var b=void 0,x=void 0;s=p,a=f,null!=this._radius&&"data"==this.model.properties.radius.units?(b=c-this.max_radius,x=c+this.max_radius,n=this.renderer.yscale.r_invert(b,x),l=n[0],h=n[1]):(o=this.max_size/2,b=c-o,x=c+o,r=this.renderer.yscale.r_invert(b,x),l=r[0],h=r[1])}var w=M.validate_bbox_coords([s,a],[l,h]),k=this.index.indices(w);return m.indices=k,m},e.prototype._hit_rect=function(t){var e=t.sx0,i=t.sx1,n=t.sy0,r=t.sy1,o=this.renderer.xscale.r_invert(e,i),s=o[0],a=o[1],l=this.renderer.yscale.r_invert(n,r),h=l[0],u=l[1],c=M.validate_bbox_coords([s,a],[h,u]),_=M.create_empty_hit_test_result();return _.indices=this.index.indices(c),_},e.prototype._hit_poly=function(t){for(var e=t.sx,i=t.sy,n=h.range(0,this.sx.length),r=[],o=0,s=n.length;o<s;o++){var a=n[o];M.point_in_poly(this.sx[o],this.sy[o],e,i)&&r.push(a)}var l=M.create_empty_hit_test_result();return l.indices=r,l},e.prototype.draw_legend_for_index=function(t,e,i){var n=e.x0,r=e.y0,o=e.x1,s=e.y1,a=i+1,l=new Array(a);l[i]=(n+o)/2;var h=new Array(a);h[i]=(r+s)/2;var u=new Array(a);u[i]=.2*Math.min(Math.abs(o-n),Math.abs(s-r)),this._render(t,[i],{sx:l,sy:h,sradius:u})},e}(r.XYGlyphView);i.CircleView=a;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Circle",this.prototype.default_view=a,this.mixins(["line","fill"]),this.define({angle:[o.AngleSpec,0],size:[o.DistanceSpec,{units:"screen",value:4}],radius:[o.DistanceSpec,null],radius_dimension:[o.String,"x"]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this.properties.radius.optional=!0},t}(r.XYGlyph);(i.Circle=l).initClass()},function(t,e,i){var n=t(391),r=t(122),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.EllipseOvalView);i.EllipseView=o;var s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Ellipse",this.prototype.default_view=o},t}(r.EllipseOval);(i.Ellipse=s).initClass()},function(t,e,i){var n=t(391),r=t(119),S=t(9),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._set_data=function(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)},e.prototype._map_data=function(){"data"==this.model.properties.width.units?this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"):this.sw=this._width,"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"):this.sh=this._height},e.prototype._render=function(t,e,i){for(var n=i.sx,r=i.sy,o=i.sw,s=i.sh,a=i._angle,l=0,h=e;l<h.length;l++){var u=h[l];isNaN(n[u]+r[u]+o[u]+s[u]+a[u])||(t.beginPath(),t.ellipse(n[u],r[u],o[u]/2,s[u]/2,a[u],0,2*Math.PI),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,u),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,u),t.stroke()))}},e.prototype._hit_point=function(t){var e,i,n,r,o,s,a,l,h,u,c,_,p,d=t.sx,f=t.sy,v=this.renderer.xscale.invert(d),m=this.renderer.yscale.invert(f);"data"==this.model.properties.width.units?(o=v-this.max_width,s=v+this.max_width):(u=d-this.max_width,c=d+this.max_width,e=this.renderer.xscale.r_invert(u,c),o=e[0],s=e[1]),"data"==this.model.properties.height.units?(a=m-this.max_height,l=m+this.max_height):(_=f-this.max_height,p=f+this.max_height,i=this.renderer.yscale.r_invert(_,p),a=i[0],l=i[1]);for(var g=S.validate_bbox_coords([o,s],[a,l]),y=this.index.indices(g),b=[],x=0,w=y;x<w.length;x++){var k=w[x];S.point_in_ellipse(d,f,this._angle[k],this.sh[k]/2,this.sw[k]/2,this.sx[k],this.sy[k])&&(n=this.renderer.xscale.r_compute(v,this._x[k]),u=n[0],c=n[1],r=this.renderer.yscale.r_compute(m,this._y[k]),_=r[0],p=r[1],h=Math.pow(u-c,2)+Math.pow(_-p,2),b.push([k,h]))}return S.create_hit_test_result_from_hits(b)},e.prototype.draw_legend_for_index=function(t,e,i){var n=e.x0,r=e.y0,o=e.x1,s=e.y1,a=i+1,l=new Array(a);l[i]=(n+o)/2;var h=new Array(a);h[i]=(r+s)/2;var u=this.sw[i]/this.sh[i],c=.8*Math.min(Math.abs(o-n),Math.abs(s-r)),_=new Array(a),p=new Array(a);1<u?(_[i]=c,p[i]=c/u):(_[i]=c*u,p[i]=c),this._render(t,[i],{sx:l,sy:h,sw:_,sh:p,_angle:[0]})},e.prototype._bounds=function(t){var e=t.minX,i=t.maxX,n=t.minY,r=t.maxY;return{minX:e-this.max_w2,maxX:i+this.max_w2,minY:n-this.max_h2,maxY:r+this.max_h2}},e}(r.CenterRotatableView);i.EllipseOvalView=o;var s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="EllipseOval"},t}(r.CenterRotatable);(i.EllipseOval=s).initClass()},function(o,t,e){var i=o(391),p=o(9),l=o(15),h=o(24),y=o(33),s=o(49),n=o(48),r=o(59),a=o(14),b=o(22),x=o(32),d=o(44),w=o(130),k=o(181),u=function(r){function t(){var t=null!==r&&r.apply(this,arguments)||this;return t._nohit_warned={},t}return i.__extends(t,r),t.prototype.initialize=function(t){r.prototype.initialize.call(this,t),this._nohit_warned={},this.renderer=t.renderer,this.visuals=new s.Visuals(this.model);var e=this.renderer.plot_view.gl;if(null!=e){var i=null;try{i=o(452)}catch(t){if("MODULE_NOT_FOUND"!==t.code)throw t;a.logger.warn("WebGL was requested and is supported, but bokeh-gl(.min).js is not available, falling back to 2D rendering.")}if(null!=i){var n=i[this.model.type+"GLGlyph"];null!=n&&(this.glglyph=new n(e.ctx,this))}}},t.prototype.set_visuals=function(t){this.visuals.warm_cache(t),null!=this.glglyph&&this.glglyph.set_visuals_changed()},t.prototype.render=function(t,e,i){t.beginPath(),null!=this.glglyph&&this.glglyph.render(t,e,i)||this._render(t,e,i)},t.prototype.has_finished=function(){return!0},t.prototype.notify_finished=function(){this.renderer.notify_finished()},t.prototype._bounds=function(t){return t},t.prototype.bounds=function(){return this._bounds(this.index.bbox)},t.prototype.log_bounds=function(){for(var t=h.empty(),e=this.index.search(h.positive_x()),i=0,n=e;i<n.length;i++){var r=n[i];r.minX<t.minX&&(t.minX=r.minX),r.maxX>t.maxX&&(t.maxX=r.maxX)}for(var o=this.index.search(h.positive_y()),s=0,a=o;s<a.length;s++){var l=a[s];l.minY<t.minY&&(t.minY=l.minY),l.maxY>t.maxY&&(t.maxY=l.maxY)}return this._bounds(t)},t.prototype.get_anchor_point=function(t,e,i){var n=i[0],r=i[1];switch(t){case"center":return{x:this.scenterx(e,n,r),y:this.scentery(e,n,r)};default:return null}},t.prototype.sdist=function(t,e,i,n,r){var o,s;void 0===n&&(n="edge"),void 0===r&&(r=!1);var a=e.length;if("center"==n){var l=b.map(i,function(t){return t/2});o=new Float64Array(a);for(var h=0;h<a;h++)o[h]=e[h]-l[h];s=new Float64Array(a);for(var h=0;h<a;h++)s[h]=e[h]+l[h]}else{o=e,s=new Float64Array(a);for(var h=0;h<a;h++)s[h]=o[h]+i[h]}var u=t.v_compute(o),c=t.v_compute(s);return r?b.map(u,function(t,e){return Math.ceil(Math.abs(c[e]-u[e]))}):b.map(u,function(t,e){return Math.abs(c[e]-u[e])})},t.prototype.draw_legend_for_index=function(t,e,i){},t.prototype.hit_test=function(t){var e=null,i="_hit_"+t.type;return null!=this[i]?e=this[i](t):null==this._nohit_warned[t.type]&&(a.logger.debug("'"+t.type+"' selection not available for "+this.model.type),this._nohit_warned[t.type]=!0),e},t.prototype._hit_rect_against_index=function(t){var e=t.sx0,i=t.sx1,n=t.sy0,r=t.sy1,o=this.renderer.xscale.r_invert(e,i),s=o[0],a=o[1],l=this.renderer.yscale.r_invert(n,r),h=l[0],u=l[1],c=p.validate_bbox_coords([s,a],[h,u]),_=p.create_empty_hit_test_result();return _.indices=this.index.indices(c),_},t.prototype.set_data=function(t,i,e){var n,r,o,s,a=this.model.materialize_dataspecs(t);if(this.visuals.set_all_indices(i),i&&!(this instanceof w.LineView)){var l={},h=function(t){var e=a[t];"_"===t.charAt(0)?l[t]=i.map(function(t){return e[t]}):l[t]=e};for(var u in a)h(u);a=l}var c=this;if(x.extend(c,a),this.renderer.plot_view.model.use_map&&(null!=c._x&&(n=y.project_xy(c._x,c._y),c._x=n[0],c._y=n[1]),null!=c._xs&&(r=y.project_xsys(c._xs,c._ys),c._xs=r[0],c._ys=r[1]),null!=c._x0&&(o=y.project_xy(c._x0,c._y0),c._x0=o[0],c._y0=o[1]),null!=c._x1&&(s=y.project_xy(c._x1,c._y1),c._x1=s[0],c._y1=s[1])),null!=this.renderer.plot_view.frame.x_ranges)for(var _=this.renderer.plot_view.frame.x_ranges[this.model.x_range_name],p=this.renderer.plot_view.frame.y_ranges[this.model.y_range_name],d=0,f=this.model._coords;d<f.length;d++){var v=f[d],m=v[0],g=v[1];m="_"+m,g="_"+g,null!=c._xs?(_ instanceof k.FactorRange&&(c[m]=b.map(c[m],function(t){return _.v_synthetic(t)})),p instanceof k.FactorRange&&(c[g]=b.map(c[g],function(t){return p.v_synthetic(t)}))):(_ instanceof k.FactorRange&&(c[m]=_.v_synthetic(c[m])),p instanceof k.FactorRange&&(c[g]=p.v_synthetic(c[g])))}null!=this.glglyph&&this.glglyph.set_data_changed(c._x.length),this._set_data(e),this.index_data()},t.prototype._set_data=function(t){},t.prototype.index_data=function(){this.index=this._index_data()},t.prototype.mask_data=function(t){return null!=this.glglyph||null==this._mask_data?t:this._mask_data()},t.prototype.map_data=function(){for(var t,e=this,i=0,n=this.model._coords;i<n.length;i++){var r=n[i],o=r[0],s=r[1],a="s"+o,l="s"+s;if(s="_"+s,null!=e[o="_"+o]&&(d.isArray(e[o][0])||d.isTypedArray(e[o][0]))){var h=e[o].length;e[a]=new Array(h),e[l]=new Array(h);for(var u=0;u<h;u++){var c=this.map_to_screen(e[o][u],e[s][u]),_=c[0],p=c[1];e[a][u]=_,e[l][u]=p}}else t=this.map_to_screen(e[o],e[s]),e[a]=t[0],e[l]=t[1]}this._map_data()},t.prototype._map_data=function(){},t.prototype.map_to_screen=function(t,e){return this.renderer.plot_view.map_to_screen(t,e,this.model.x_range_name,this.model.y_range_name)},t}(n.View);e.GlyphView=u;var c=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="Glyph",this.prototype._coords=[],this.internal({x_range_name:[l.String,"default"],y_range_name:[l.String,"default"]})},t.coords=function(t){var e=this.prototype._coords.concat(t);this.prototype._coords=e;for(var i={},n=0,r=t;n<r.length;n++){var o=r[n],s=o[0],a=o[1];i[s]=[l.NumberSpec],i[a]=[l.NumberSpec]}this.define(i)},t}(r.Model);(e.Glyph=c).initClass()},function(t,e,i){var n=t(391),r=t(118),o=t(15),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.scenterx=function(t){return(this.sleft[t]+this.sright[t])/2},e.prototype.scentery=function(t){return this.sy[t]},e.prototype._index_data=function(){return this._index_box(this._y.length)},e.prototype._lrtb=function(t){var e=Math.min(this._left[t],this._right[t]),i=Math.max(this._left[t],this._right[t]),n=this._y[t]+.5*this._height[t],r=this._y[t]-.5*this._height[t];return[e,i,n,r]},e.prototype._map_data=function(){this.sy=this.renderer.yscale.v_compute(this._y),this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"),this.sleft=this.renderer.xscale.v_compute(this._left),this.sright=this.renderer.xscale.v_compute(this._right);var t=this.sy.length;this.stop=new Float64Array(t),this.sbottom=new Float64Array(t);for(var e=0;e<t;e++)this.stop[e]=this.sy[e]-this.sh[e]/2,this.sbottom[e]=this.sy[e]+this.sh[e]/2;this._clamp_viewport()},e}(r.BoxView);i.HBarView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="HBar",this.prototype.default_view=s,this.coords([["left","y"]]),this.define({height:[o.DistanceSpec],right:[o.NumberSpec]}),this.override({left:0})},t}(r.Box);(i.HBar=a).initClass()},function(t,e,i){var n=t(391),r=t(123),f=t(9),o=t(15),a=t(37),s=t(143),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.scenterx=function(t){return this.sx[t]},e.prototype.scentery=function(t){return this.sy[t]},e.prototype._set_data=function(){var t=this._q.length,e=this.model.size,i=this.model.aspect_scale;if(this._x=new Float64Array(t),this._y=new Float64Array(t),"pointytop"==this.model.orientation)for(var n=0;n<t;n++)this._x[n]=e*Math.sqrt(3)*(this._q[n]+this._r[n]/2)/i,this._y[n]=3*-e/2*this._r[n];else for(var n=0;n<t;n++)this._x[n]=3*e/2*this._q[n],this._y[n]=-e*Math.sqrt(3)*(this._r[n]+this._q[n]/2)*i},e.prototype._index_data=function(){var t,e=this.model.size,i=Math.sqrt(3)*e/2;"flattop"==this.model.orientation?(i=(t=[e,i])[0],e=t[1],e*=this.model.aspect_scale):i/=this.model.aspect_scale;for(var n=[],r=0;r<this._x.length;r++){var o=this._x[r],s=this._y[r];!isNaN(o+s)&&isFinite(o+s)&&n.push({minX:o-i,minY:s-e,maxX:o+i,maxY:s+e,i:r})}return new a.SpatialIndex(n)},e.prototype.map_data=function(){var t,e;t=this.map_to_screen(this._x,this._y),this.sx=t[0],this.sy=t[1],e=this._get_unscaled_vertices(),this.svx=e[0],this.svy=e[1]},e.prototype._get_unscaled_vertices=function(){var t=this.model.size,e=this.model.aspect_scale;if("pointytop"==this.model.orientation){var i=this.renderer.yscale,n=this.renderer.xscale,r=Math.abs(i.compute(0)-i.compute(t)),o=Math.sqrt(3)/2*Math.abs(n.compute(0)-n.compute(t))/e,s=r/2,a=[0,-o,-o,0,o,o],l=[r,s,-s,-r,-s,s];return[a,l]}var i=this.renderer.xscale,n=this.renderer.yscale,r=Math.abs(i.compute(0)-i.compute(t)),o=Math.sqrt(3)/2*Math.abs(n.compute(0)-n.compute(t))*e,s=r/2,a=[r,s,-s,-r,-s,s],l=[0,-o,-o,0,o,o];return[a,l]},e.prototype._render=function(t,e,i){for(var n=i.sx,r=i.sy,o=i.svx,s=i.svy,a=i._scale,l=0,h=e;l<h.length;l++){var u=h[l];if(!isNaN(n[u]+r[u]+a[u])){t.translate(n[u],r[u]),t.beginPath();for(var c=0;c<6;c++)t.lineTo(o[c]*a[u],s[c]*a[u]);t.closePath(),t.translate(-n[u],-r[u]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,u),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,u),t.stroke())}}},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,n=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(i),o=this.index.indices({minX:n,minY:r,maxX:n,maxY:r}),s=[],a=0,l=o;a<l.length;a++){var h=l[a];f.point_in_poly(e-this.sx[h],i-this.sy[h],this.svx,this.svy)&&s.push(h)}var u=f.create_empty_hit_test_result();return u.indices=s,u},e.prototype._hit_span=function(t){var e,i=t.sx,n=t.sy;if("v"==t.direction){var r=this.renderer.yscale.invert(n),o=this.renderer.plot_view.frame.bbox.h_range,s=this.renderer.xscale.r_invert(o.start,o.end),a=s[0],l=s[1];e=this.index.indices({minX:a,minY:r,maxX:l,maxY:r})}else{var h=this.renderer.xscale.invert(i),u=this.renderer.plot_view.frame.bbox.v_range,c=this.renderer.yscale.r_invert(u.start,u.end),_=c[0],p=c[1];e=this.index.indices({minX:h,minY:_,maxX:h,maxY:p})}var d=f.create_empty_hit_test_result();return d.indices=e,d},e.prototype._hit_rect=function(t){var e=t.sx0,i=t.sx1,n=t.sy0,r=t.sy1,o=this.renderer.xscale.r_invert(e,i),s=o[0],a=o[1],l=this.renderer.yscale.r_invert(n,r),h=l[0],u=l[1],c=f.validate_bbox_coords([s,a],[h,u]),_=f.create_empty_hit_test_result();return _.indices=this.index.indices(c),_},e.prototype.draw_legend_for_index=function(t,e,i){s.generic_area_legend(this.visuals,t,e,i)},e}(r.GlyphView);i.HexTileView=l;var h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="HexTile",this.prototype.default_view=l,this.coords([["r","q"]]),this.mixins(["line","fill"]),this.define({size:[o.Number,1],aspect_scale:[o.Number,1],scale:[o.NumberSpec,1],orientation:[o.String,"pointytop"]}),this.override({line_color:null})},t}(r.Glyph);(i.HexTile=h).initClass()},function(t,e,i){var n=t(391),r=t(146),o=t(167),s=t(15),c=t(21),l=t(37),_=t(9),a=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return n.__extends(t,i),t.prototype.initialize=function(t){var e=this;i.prototype.initialize.call(this,t),this.connect(this.model.color_mapper.change,function(){return e._update_image()}),this.connect(this.model.properties.global_alpha.change,function(){return e.renderer.request_render()})},t.prototype._update_image=function(){null!=this.image_data&&(this._set_data(),this.renderer.plot_view.request_render())},t.prototype._index_data=function(){for(var t=[],e=0,i=this._x.length;e<i;e++){var n=this._lrtb(e),r=n[0],o=n[1],s=n[2],a=n[3];!isNaN(r+o+s+a)&&isFinite(r+o+s+a)&&t.push({minX:r,minY:a,maxX:o,maxY:s,i:e})}return new l.SpatialIndex(t)},t.prototype._lrtb=function(t){var e=this.renderer.xscale.source_range,i=this._x[t],n=e.is_reversed?i-this._dw[t]:i+this._dw[t],r=this.renderer.yscale.source_range,o=this._y[t],s=r.is_reversed?o-this._dh[t]:o+this._dh[t],a=i<n?[i,n]:[n,i],l=a[0],h=a[1],u=o<s?[o,s]:[s,o],c=u[0],_=u[1];return[l,h,_,c]},t.prototype._image_index=function(t,e,i){var n=this._lrtb(t),r=n[0],o=n[1],s=n[2],a=n[3],l=this._width[t],h=this._height[t],u=(o-r)/l,c=(s-a)/h,_=Math.floor((e-r)/u),p=Math.floor((i-a)/c);return{index:t,dim1:_,dim2:p,flat_index:p*l+_}},t.prototype._hit_point=function(t){var e=t.sx,i=t.sy,n=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(i),o=_.validate_bbox_coords([n,n],[r,r]),s=this.index.indices(o),a=_.create_empty_hit_test_result();a.image_indices=[];for(var l=0,h=s;l<h.length;l++){var u=h[l];e!=1/0&&i!=1/0&&a.image_indices.push(this._image_index(u,n,r))}return a},t.prototype._set_data=function(){null!=this.image_data&&this.image_data.length==this._image.length||(this.image_data=new Array(this._image.length)),null!=this._width&&this._width.length==this._image.length||(this._width=new Array(this._image.length)),null!=this._height&&this._height.length==this._image.length||(this._height=new Array(this._image.length));for(var t=this.model.color_mapper.rgba_mapper,e=0,i=this._image.length;e<i;e++){var n=void 0;if(null!=this._image_shape&&0<this._image_shape[e].length){n=this._image[e];var r=this._image_shape[e];this._height[e]=r[0],this._width[e]=r[1]}else{var o=this._image[e];n=c.concat(o),this._height[e]=o.length,this._width[e]=o[0].length}var s=this.image_data[e],a=void 0;null!=s&&s.width==this._width[e]&&s.height==this._height[e]?a=s:((a=document.createElement("canvas")).width=this._width[e],a.height=this._height[e]);var l=a.getContext("2d"),h=l.getImageData(0,0,this._width[e],this._height[e]),u=t.v_compute(n);h.data.set(u),l.putImageData(h,0,0),this.image_data[e]=a,this.max_dw=0,"data"==this.model.properties.dw.units&&(this.max_dw=c.max(this._dw)),this.max_dh=0,"data"==this.model.properties.dh.units&&(this.max_dh=c.max(this._dh))}},t.prototype._map_data=function(){switch(this.model.properties.dw.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,this._dw,"edge",this.model.dilate);break;case"screen":this.sw=this._dw}switch(this.model.properties.dh.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,this._dh,"edge",this.model.dilate);break;case"screen":this.sh=this._dh}},t.prototype._render=function(t,e,i){var n=i.image_data,r=i.sx,o=i.sy,s=i.sw,a=i.sh,l=t.getImageSmoothingEnabled();t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.global_alpha;for(var h=0,u=e;h<u.length;h++){var c=u[h];if(null!=n[c]&&!isNaN(r[c]+o[c]+s[c]+a[c])){var _=o[c];t.translate(0,_),t.scale(1,-1),t.translate(0,-_),t.drawImage(n[c],0|r[c],0|o[c],s[c],a[c]),t.translate(0,_),t.scale(1,-1),t.translate(0,-_)}}t.setImageSmoothingEnabled(l)},t.prototype.bounds=function(){var t=this.index.bbox;return t.maxX+=this.max_dw,t.maxY+=this.max_dh,t},t}(r.XYGlyphView);i.ImageView=a;var h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Image",this.prototype.default_view=a,this.define({image:[s.NumberSpec],dw:[s.DistanceSpec],dh:[s.DistanceSpec],dilate:[s.Bool,!1],global_alpha:[s.Number,1],color_mapper:[s.Instance,function(){return new o.LinearColorMapper({palette:["#000000","#252525","#525252","#737373","#969696","#bdbdbd","#d9d9d9","#f0f0f0","#ffffff"]})}]})},t}(r.XYGlyph);(i.Image=h).initClass()},function(t,e,i){var n=t(391),r=t(146),o=t(15),f=t(21),s=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return n.__extends(t,i),t.prototype.initialize=function(t){var e=this;i.prototype.initialize.call(this,t),this.connect(this.model.properties.global_alpha.change,function(){return e.renderer.request_render()})},t.prototype._set_data=function(t){null!=this.image_data&&this.image_data.length==this._image.length||(this.image_data=new Array(this._image.length)),null!=this._width&&this._width.length==this._image.length||(this._width=new Array(this._image.length)),null!=this._height&&this._height.length==this._image.length||(this._height=new Array(this._image.length));for(var e=0,i=this._image.length;e<i;e++)if(!(null!=t&&t.indexOf(e)<0)){var n=void 0;if(null!=this._image_shape&&0<this._image_shape[e].length){n=this._image[e].buffer;var r=this._image_shape[e];this._height[e]=r[0],this._width[e]=r[1]}else{var o=this._image[e],s=f.concat(o);n=new ArrayBuffer(4*s.length);for(var a=new Uint32Array(n),l=0,h=s.length;l<h;l++)a[l]=s[l];this._height[e]=o.length,this._width[e]=o[0].length}var u=this.image_data[e],c=void 0;null!=u&&u.width==this._width[e]&&u.height==this._height[e]?c=u:((c=document.createElement("canvas")).width=this._width[e],c.height=this._height[e]);var _=c.getContext("2d"),p=_.getImageData(0,0,this._width[e],this._height[e]),d=new Uint8Array(n);p.data.set(d),_.putImageData(p,0,0),this.image_data[e]=c,this.max_dw=0,"data"==this.model.properties.dw.units&&(this.max_dw=f.max(this._dw)),this.max_dh=0,"data"==this.model.properties.dh.units&&(this.max_dh=f.max(this._dh))}},t.prototype._map_data=function(){switch(this.model.properties.dw.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,this._dw,"edge",this.model.dilate);break;case"screen":this.sw=this._dw}switch(this.model.properties.dh.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,this._dh,"edge",this.model.dilate);break;case"screen":this.sh=this._dh}},t.prototype._render=function(t,e,i){var n=i.image_data,r=i.sx,o=i.sy,s=i.sw,a=i.sh,l=t.getImageSmoothingEnabled();t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.global_alpha;for(var h=0,u=e;h<u.length;h++){var c=u[h];if(!isNaN(r[c]+o[c]+s[c]+a[c])){var _=o[c];t.translate(0,_),t.scale(1,-1),t.translate(0,-_),t.drawImage(n[c],0|r[c],0|o[c],s[c],a[c]),t.translate(0,_),t.scale(1,-1),t.translate(0,-_)}}t.setImageSmoothingEnabled(l)},t.prototype.bounds=function(){var t=this.index.bbox;return t.maxX+=this.max_dw,t.maxY+=this.max_dh,t},t}(r.XYGlyphView);i.ImageRGBAView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="ImageRGBA",this.prototype.default_view=s,this.define({image:[o.NumberSpec],dw:[o.DistanceSpec],dh:[o.DistanceSpec],global_alpha:[o.Number,1],dilate:[o.Bool,!1]})},t}(r.XYGlyph);(i.ImageRGBA=a).initClass()},function(t,e,m){var n=t(391),i=t(146),g=t(14),r=t(15),y=t(22),o=t(37);m.CanvasImage=Image;var s=function(i){function t(){var t=null!==i&&i.apply(this,arguments)||this;return t._images_rendered=!1,t}return n.__extends(t,i),t.prototype.initialize=function(t){var e=this;i.prototype.initialize.call(this,t),this.connect(this.model.properties.global_alpha.change,function(){return e.renderer.request_render()})},t.prototype._index_data=function(){return new o.SpatialIndex([])},t.prototype._set_data=function(){var n=this;null!=this.image&&this.image.length==this._url.length||(this.image=y.map(this._url,function(){return null}));var t=this.model,r=t.retry_attempts,o=t.retry_timeout;this.retries=y.map(this._url,function(){return r});for(var e=function(t,e){if(null==s._url[t])return"continue";var i=new m.CanvasImage;i.onerror=function(){0<n.retries[t]?(g.logger.trace("ImageURL failed to load "+n._url[t]+" image, retrying in "+o+" ms"),setTimeout(function(){return i.src=n._url[t]},o)):g.logger.warn("ImageURL unable to load "+n._url[t]+" image after "+r+" retries"),n.retries[t]-=1},i.onload=function(){n.image[t]=i,n.renderer.request_render()},i.src=s._url[t]},s=this,i=0,a=this._url.length;i<a;i++)e(i,a);for(var l="data"==this.model.properties.w.units,h="data"==this.model.properties.h.units,u=this._x.length,c=new Array(l?2*u:u),_=new Array(h?2*u:u),i=0;i<u;i++)c[i]=this._x[i],_[i]=this._y[i];if(l)for(var i=0;i<u;i++)c[u+i]=this._x[i]+this._w[i];if(h)for(var i=0;i<u;i++)_[u+i]=this._y[i]+this._h[i];var p=y.min(c),d=y.max(c),f=y.min(_),v=y.max(_);this._bounds_rect={minX:p,maxX:d,minY:f,maxY:v}},t.prototype.has_finished=function(){return i.prototype.has_finished.call(this)&&1==this._images_rendered},t.prototype._map_data=function(){var t=null!=this.model.w?this._w:y.map(this._x,function(){return NaN}),e=null!=this.model.h?this._h:y.map(this._x,function(){return NaN});switch(this.model.properties.w.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,t,"edge",this.model.dilate);break;case"screen":this.sw=t}switch(this.model.properties.h.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,e,"edge",this.model.dilate);break;case"screen":this.sh=e}},t.prototype._render=function(t,e,i){var n=i.image,r=i.sx,o=i.sy,s=i.sw,a=i.sh,l=i._angle,h=this.renderer.plot_view.frame;t.rect(h._left.value+1,h._top.value+1,h._width.value-2,h._height.value-2),t.clip();for(var u=!0,c=0,_=e;c<_.length;c++){var p=_[c];if(!isNaN(r[p]+o[p]+l[p])&&-1!=this.retries[p]){var d=n[p];null!=d?this._render_image(t,p,d,r,o,s,a,l):u=!1}}u&&!this._images_rendered&&(this._images_rendered=!0,this.notify_finished())},t.prototype._final_sx_sy=function(t,e,i,n,r){switch(t){case"top_left":return[e,i];case"top_center":return[e-n/2,i];case"top_right":return[e-n,i];case"center_right":return[e-n,i-r/2];case"bottom_right":return[e-n,i-r];case"bottom_center":return[e-n/2,i-r];case"bottom_left":return[e,i-r];case"center_left":return[e,i-r/2];case"center":return[e-n/2,i-r/2]}},t.prototype._render_image=function(t,e,i,n,r,o,s,a){isNaN(o[e])&&(o[e]=i.width),isNaN(s[e])&&(s[e]=i.height);var l=this.model.anchor,h=this._final_sx_sy(l,n[e],r[e],o[e],s[e]),u=h[0],c=h[1];t.save(),t.globalAlpha=this.model.global_alpha,a[e]?(t.translate(u,c),t.rotate(a[e]),t.drawImage(i,0,0,o[e],s[e]),t.rotate(-a[e]),t.translate(-u,-c)):t.drawImage(i,u,c,o[e],s[e]),t.restore()},t.prototype.bounds=function(){return this._bounds_rect},t}(i.XYGlyphView);m.ImageURLView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="ImageURL",this.prototype.default_view=s,this.define({url:[r.StringSpec],anchor:[r.Anchor,"top_left"],global_alpha:[r.Number,1],angle:[r.AngleSpec,0],w:[r.DistanceSpec],h:[r.DistanceSpec],dilate:[r.Bool,!1],retry_attempts:[r.Number,0],retry_timeout:[r.Number,0]})},t}(i.XYGlyph);(m.ImageURL=a).initClass()},function(t,e,i){var n=t(114);i.AnnularWedge=n.AnnularWedge;var r=t(115);i.Annulus=r.Annulus;var o=t(116);i.Arc=o.Arc;var s=t(117);i.Bezier=s.Bezier;var a=t(120);i.Circle=a.Circle;var l=t(119);i.CenterRotatable=l.CenterRotatable;var h=t(121);i.Ellipse=h.Ellipse;var u=t(122);i.EllipseOval=u.EllipseOval;var c=t(123);i.Glyph=c.Glyph;var _=t(124);i.HBar=_.HBar;var p=t(125);i.HexTile=p.HexTile;var d=t(126);i.Image=d.Image;var f=t(127);i.ImageRGBA=f.ImageRGBA;var v=t(128);i.ImageURL=v.ImageURL;var m=t(130);i.Line=m.Line;var g=t(131);i.MultiLine=g.MultiLine;var y=t(132);i.MultiPolygons=y.MultiPolygons;var b=t(133);i.Oval=b.Oval;var x=t(134);i.Patch=x.Patch;var w=t(135);i.Patches=w.Patches;var k=t(136);i.Quad=k.Quad;var S=t(137);i.Quadratic=S.Quadratic;var C=t(138);i.Ray=C.Ray;var T=t(139);i.Rect=T.Rect;var A=t(140);i.Segment=A.Segment;var E=t(141);i.Step=E.Step;var M=t(142);i.Text=M.Text;var O=t(144);i.VBar=O.VBar;var z=t(145);i.Wedge=z.Wedge;var P=t(146);i.XYGlyph=P.XYGlyph},function(t,e,i){var n=t(391),r=t(146),a=t(143),c=t(9),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._render=function(t,e,i){var n=i.sx,r=i.sy,o=!1,s=null;this.visuals.line.set_value(t);for(var a=0,l=e;a<l.length;a++){var h=l[a];if(o){if(!isFinite(n[h]+r[h])){t.stroke(),t.beginPath(),o=!1,s=h;continue}null!=s&&1<h-s&&(t.stroke(),o=!1)}o?t.lineTo(n[h],r[h]):(t.beginPath(),t.moveTo(n[h],r[h]),o=!0),s=h}o&&t.stroke()},e.prototype._hit_point=function(t){for(var e=this,i=c.create_empty_hit_test_result(),n={x:t.sx,y:t.sy},r=9999,o=Math.max(2,this.visuals.line.line_width.value()/2),s=0,a=this.sx.length-1;s<a;s++){var l={x:this.sx[s],y:this.sy[s]},h={x:this.sx[s+1],y:this.sy[s+1]},u=c.dist_to_segment(n,l,h);u<o&&u<r&&(r=u,i.add_to_selected_glyphs(this.model),i.get_view=function(){return e},i.line_indices=[s])}return i},e.prototype._hit_span=function(t){var e,i,n=this,r=t.sx,o=t.sy,s=c.create_empty_hit_test_result();"v"==t.direction?(e=this.renderer.yscale.invert(o),i=this._y):(e=this.renderer.xscale.invert(r),i=this._x);for(var a=0,l=i.length-1;a<l;a++)(i[a]<=e&&e<=i[a+1]||i[a+1]<=e&&e<=i[a])&&(s.add_to_selected_glyphs(this.model),s.get_view=function(){return n},s.line_indices.push(a));return s},e.prototype.get_interpolation_hit=function(t,e){var i=[this._x[t],this._y[t],this._x[t+1],this._y[t+1]],n=i[0],r=i[1],o=i[2],s=i[3];return a.line_interpolation(this.renderer,e,n,r,o,s)},e.prototype.draw_legend_for_index=function(t,e,i){a.generic_line_legend(this.visuals,t,e,i)},e}(r.XYGlyphView);i.LineView=o;var s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Line",this.prototype.default_view=o,this.mixins(["line"])},t}(r.XYGlyph);(i.Line=s).initClass()},function(t,e,i){var n=t(391),m=t(37),d=t(9),f=t(32),g=t(21),y=t(44),r=t(123),l=t(143),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._xs.length;e<i;e++)if(null!=this._xs[e]&&0!==this._xs[e].length){for(var n=this._xs[e],r=[],o=0,s=n.length;o<s;o++){var a=n[o];y.isStrictNaN(a)||r.push(a)}for(var l=this._ys[e],h=[],o=0,s=l.length;o<s;o++){var u=l[o];y.isStrictNaN(u)||h.push(u)}var c=[g.min(r),g.max(r)],_=c[0],p=c[1],d=[g.min(h),g.max(h)],f=d[0],v=d[1];t.push({minX:_,minY:f,maxX:p,maxY:v,i:e})}return new m.SpatialIndex(t)},e.prototype._render=function(t,e,i){for(var n=i.sxs,r=i.sys,o=0,s=e;o<s.length;o++){var a=s[o],l=[n[a],r[a]],h=l[0],u=l[1];this.visuals.line.set_vectorize(t,a);for(var c=0,_=h.length;c<_;c++)0!=c?isNaN(h[c])||isNaN(u[c])?(t.stroke(),t.beginPath()):t.lineTo(h[c],u[c]):(t.beginPath(),t.moveTo(h[c],u[c]));t.stroke()}},e.prototype._hit_point=function(t){for(var e=d.create_empty_hit_test_result(),i={x:t.sx,y:t.sy},n=9999,r={},o=0,s=this.sxs.length;o<s;o++){for(var a=Math.max(2,this.visuals.line.cache_select("line_width",o)/2),l=null,h=0,u=this.sxs[o].length-1;h<u;h++){var c={x:this.sxs[o][h],y:this.sys[o][h]},_={x:this.sxs[o][h+1],y:this.sys[o][h+1]},p=d.dist_to_segment(i,c,_);p<a&&p<n&&(n=p,l=[h])}l&&(r[o]=l)}return e.indices=f.keys(r).map(function(t){return parseInt(t,10)}),e.multiline_indices=r,e},e.prototype._hit_span=function(t){var e,i,n=t.sx,r=t.sy,o=d.create_empty_hit_test_result();"v"===t.direction?(e=this.renderer.yscale.invert(r),i=this._ys):(e=this.renderer.xscale.invert(n),i=this._xs);for(var s={},a=0,l=i.length;a<l;a++){for(var h=[],u=0,c=i[a].length-1;u<c;u++)i[a][u]<=e&&e<=i[a][u+1]&&h.push(u);0<h.length&&(s[a]=h)}return o.indices=f.keys(s).map(function(t){return parseInt(t,10)}),o.multiline_indices=s,o},e.prototype.get_interpolation_hit=function(t,e,i){var n=[this._xs[t][e],this._ys[t][e],this._xs[t][e+1],this._ys[t][e+1]],r=n[0],o=n[1],s=n[2],a=n[3];return l.line_interpolation(this.renderer,i,r,o,s,a)},e.prototype.draw_legend_for_index=function(t,e,i){l.generic_line_legend(this.visuals,t,e,i)},e.prototype.scenterx=function(){throw new Error("not implemented")},e.prototype.scentery=function(){throw new Error("not implemented")},e}(r.GlyphView);i.MultiLineView=o;var s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="MultiLine",this.prototype.default_view=o,this.coords([["xs","ys"]]),this.mixins(["line"])},t}(r.Glyph);(i.MultiLine=s).initClass()},function(t,e,i){var n=t(391),h=t(37),r=t(123),o=t(143),u=t(21),s=t(22),x=t(9),m=t(44),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._xs.length;e<i;e++)for(var n=0,r=this._xs[e].length;n<r;n++){var o=this._xs[e][n][0],s=this._ys[e][n][0];0!=o.length&&t.push({minX:u.min(o),minY:u.min(s),maxX:u.max(o),maxY:u.max(s),i:e})}return this.hole_index=this._index_hole_data(),new h.SpatialIndex(t)},e.prototype._index_hole_data=function(){for(var t=[],e=0,i=this._xs.length;e<i;e++)for(var n=0,r=this._xs[e].length;n<r;n++)if(1<this._xs[e][n].length)for(var o=1,s=this._xs[e][n].length;o<s;o++){var a=this._xs[e][n][o],l=this._ys[e][n][o];0!=a.length&&t.push({minX:u.min(a),minY:u.min(l),maxX:u.max(a),maxY:u.max(l),i:e})}return new h.SpatialIndex(t)},e.prototype._mask_data=function(){var t=this.renderer.plot_view.frame.x_ranges.default,e=[t.min,t.max],i=e[0],n=e[1],r=this.renderer.plot_view.frame.y_ranges.default,o=[r.min,r.max],s=o[0],a=o[1],l=x.validate_bbox_coords([i,n],[s,a]),h=this.index.indices(l);return h.sort(function(t,e){return t-e}).filter(function(t,e,i){return 0===e||t!==i[e-1]})},e.prototype._render=function(t,e,i){var n=i.sxs,r=i.sys;if(this.visuals.fill.doit||this.visuals.line.doit)for(var o=0,s=e;o<s.length;o++){var a=s[o];t.beginPath();for(var l=0,h=n[a].length;l<h;l++)for(var u=0,c=n[a][l].length;u<c;u++){for(var _=n[a][l][u],p=r[a][l][u],d=0,f=_.length;d<f;d++)0!=d?t.lineTo(_[d],p[d]):t.moveTo(_[d],p[d]);t.closePath()}this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,a),t.fill("evenodd")),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,a),t.stroke())}},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,n=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(i),o=this.index.indices({minX:n,minY:r,maxX:n,maxY:r}),s=this.hole_index.indices({minX:n,minY:r,maxX:n,maxY:r}),a=[],l=0,h=o.length;l<h;l++)for(var u=o[l],c=this.sxs[u],_=this.sys[u],p=0,d=c.length;p<d;p++){var f=c[p].length;if(x.point_in_poly(e,i,c[p][0],_[p][0]))if(1==f)a.push(u);else if(-1==s.indexOf(u))a.push(u);else if(1<f){for(var v=!1,m=1;m<f;m++){var g=c[p][m],y=_[p][m];if(x.point_in_poly(e,i,g,y)){v=!0;break}}v||a.push(u)}}var b=x.create_empty_hit_test_result();return b.indices=a,b},e.prototype._get_snap_coord=function(t){return s.sum(t)/t.length},e.prototype.scenterx=function(t,e,i){if(1==this.sxs[t].length)return this._get_snap_coord(this.sxs[t][0][0]);for(var n=this.sxs[t],r=this.sys[t],o=0,s=n.length;o<s;o++)if(x.point_in_poly(e,i,n[o][0],r[o][0]))return this._get_snap_coord(n[o][0]);throw new Error("unreachable code")},e.prototype.scentery=function(t,e,i){if(1==this.sys[t].length)return this._get_snap_coord(this.sys[t][0][0]);for(var n=this.sxs[t],r=this.sys[t],o=0,s=n.length;o<s;o++)if(x.point_in_poly(e,i,n[o][0],r[o][0]))return this._get_snap_coord(r[o][0]);throw new Error("unreachable code")},e.prototype.map_data=function(){for(var t=this,e=0,i=this.model._coords;e<i.length;e++){var n=i[e],r=n[0],o=n[1],s="s"+r,a="s"+o;if(o="_"+o,null!=t[r="_"+r]&&(m.isArray(t[r][0])||m.isTypedArray(t[r][0]))){var l=t[r].length;t[s]=new Array(l),t[a]=new Array(l);for(var h=0;h<l;h++){var u=t[r][h].length;t[s][h]=new Array(u),t[a][h]=new Array(u);for(var c=0;c<u;c++){var _=t[r][h][c].length;t[s][h][c]=new Array(_),t[a][h][c]=new Array(_);for(var p=0;p<_;p++){var d=this.map_to_screen(t[r][h][c][p],t[o][h][c][p]),f=d[0],v=d[1];t[s][h][c][p]=f,t[a][h][c][p]=v}}}}}},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_area_legend(this.visuals,t,e,i)},e}(r.GlyphView);i.MultiPolygonsView=a;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="MultiPolygons",this.prototype.default_view=a,this.coords([["xs","ys"]]),this.mixins(["line","fill"])},t}(r.Glyph);(i.MultiPolygons=l).initClass()},function(t,e,i){var n=t(391),r=t(122),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._map_data=function(){var t,e=this._x.length;this.sw=new Float64Array(e),t="data"==this.model.properties.width.units?this.sdist(this.renderer.xscale,this._x,this._width,"center"):this._width;for(var i=0;i<e;i++)this.sw[i]=.75*t[i];"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"):this.sh=this._height},e}(r.EllipseOvalView);i.OvalView=o;var s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Oval",this.prototype.default_view=o},t}(r.EllipseOval);(i.Oval=s).initClass()},function(t,e,i){var n=t(391),r=t(146),o=t(143),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._render=function(t,e,i){var n=i.sx,r=i.sy;if(this.visuals.fill.doit){this.visuals.fill.set_value(t);for(var o=0,s=e;o<s.length;o++){var a=s[o];0!=a?isNaN(n[a]+r[a])?(t.closePath(),t.fill(),t.beginPath()):t.lineTo(n[a],r[a]):(t.beginPath(),t.moveTo(n[a],r[a]))}t.closePath(),t.fill()}if(this.visuals.line.doit){this.visuals.line.set_value(t);for(var l=0,h=e;l<h.length;l++){var a=h[l];0!=a?isNaN(n[a]+r[a])?(t.closePath(),t.stroke(),t.beginPath()):t.lineTo(n[a],r[a]):(t.beginPath(),t.moveTo(n[a],r[a]))}return t.closePath(),t.stroke()}},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_area_legend(this.visuals,t,e,i)},e}(r.XYGlyphView);i.PatchView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Patch",this.prototype.default_view=s,this.mixins(["line","fill"])},t}(r.XYGlyph);(i.Patch=a).initClass()},function(t,e,i){var n=t(391),h=t(37),r=t(123),o=t(143),u=t(21),s=t(22),l=t(44),f=t(9),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._build_discontinuous_object=function(t){for(var e=[],i=0,n=t.length;i<n;i++){e[i]=[];for(var r=u.copy(t[i]);0<r.length;){var o=u.findLastIndex(r,function(t){return l.isStrictNaN(t)}),s=void 0;0<=o?s=r.splice(o):(s=r,r=[]);var a=s.filter(function(t){return!l.isStrictNaN(t)});e[i].push(a)}}return e},e.prototype._index_data=function(){for(var t=this._build_discontinuous_object(this._xs),e=this._build_discontinuous_object(this._ys),i=[],n=0,r=this._xs.length;n<r;n++)for(var o=0,s=t[n].length;o<s;o++){var a=t[n][o],l=e[n][o];0!=a.length&&i.push({minX:u.min(a),minY:u.min(l),maxX:u.max(a),maxY:u.max(l),i:n})}return new h.SpatialIndex(i)},e.prototype._mask_data=function(){var t=this.renderer.plot_view.frame.x_ranges.default,e=[t.min,t.max],i=e[0],n=e[1],r=this.renderer.plot_view.frame.y_ranges.default,o=[r.min,r.max],s=o[0],a=o[1],l=f.validate_bbox_coords([i,n],[s,a]),h=this.index.indices(l);return h.sort(function(t,e){return t-e})},e.prototype._render=function(t,e,i){var n=i.sxs,r=i.sys;this.sxss=this._build_discontinuous_object(n),this.syss=this._build_discontinuous_object(r);for(var o=0,s=e;o<s.length;o++){var a=s[o],l=[n[a],r[a]],h=l[0],u=l[1];if(this.visuals.fill.doit){this.visuals.fill.set_vectorize(t,a);for(var c=0,_=h.length;c<_;c++)0!=c?isNaN(h[c]+u[c])?(t.closePath(),t.fill(),t.beginPath()):t.lineTo(h[c],u[c]):(t.beginPath(),t.moveTo(h[c],u[c]));t.closePath(),t.fill()}if(this.visuals.line.doit){this.visuals.line.set_vectorize(t,a);for(var c=0,_=h.length;c<_;c++)0!=c?isNaN(h[c]+u[c])?(t.closePath(),t.stroke(),t.beginPath()):t.lineTo(h[c],u[c]):(t.beginPath(),t.moveTo(h[c],u[c]));t.closePath(),t.stroke()}}},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,n=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(i),o=this.index.indices({minX:n,minY:r,maxX:n,maxY:r}),s=[],a=0,l=o.length;a<l;a++)for(var h=o[a],u=this.sxss[h],c=this.syss[h],_=0,p=u.length;_<p;_++)f.point_in_poly(e,i,u[_],c[_])&&s.push(h);var d=f.create_empty_hit_test_result();return d.indices=s,d},e.prototype._get_snap_coord=function(t){return s.sum(t)/t.length},e.prototype.scenterx=function(t,e,i){if(1==this.sxss[t].length)return this._get_snap_coord(this.sxs[t]);for(var n=this.sxss[t],r=this.syss[t],o=0,s=n.length;o<s;o++)if(f.point_in_poly(e,i,n[o],r[o]))return this._get_snap_coord(n[o]);throw new Error("unreachable code")},e.prototype.scentery=function(t,e,i){if(1==this.syss[t].length)return this._get_snap_coord(this.sys[t]);for(var n=this.sxss[t],r=this.syss[t],o=0,s=n.length;o<s;o++)if(f.point_in_poly(e,i,n[o],r[o]))return this._get_snap_coord(r[o]);throw new Error("unreachable code")},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_area_legend(this.visuals,t,e,i)},e}(r.GlyphView);i.PatchesView=a;var c=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Patches",this.prototype.default_view=a,this.coords([["xs","ys"]]),this.mixins(["line","fill"])},t}(r.Glyph);(i.Patches=c).initClass()},function(t,e,i){var n=t(391),r=t(118),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.get_anchor_point=function(t,e,i){var n=Math.min(this.sleft[e],this.sright[e]),r=Math.max(this.sright[e],this.sleft[e]),o=Math.min(this.stop[e],this.sbottom[e]),s=Math.max(this.sbottom[e],this.stop[e]);switch(t){case"top_left":return{x:n,y:o};case"top_center":return{x:(n+r)/2,y:o};case"top_right":return{x:r,y:o};case"center_right":return{x:r,y:(o+s)/2};case"bottom_right":return{x:r,y:s};case"bottom_center":return{x:(n+r)/2,y:s};case"bottom_left":return{x:n,y:s};case"center_left":return{x:n,y:(o+s)/2};case"center":return{x:(n+r)/2,y:(o+s)/2};default:return null}},e.prototype.scenterx=function(t){return(this.sleft[t]+this.sright[t])/2},e.prototype.scentery=function(t){return(this.stop[t]+this.sbottom[t])/2},e.prototype._index_data=function(){return this._index_box(this._right.length)},e.prototype._lrtb=function(t){var e=this._left[t],i=this._right[t],n=this._top[t],r=this._bottom[t];return[e,i,n,r]},e}(r.BoxView);i.QuadView=o;var s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Quad",this.prototype.default_view=o,this.coords([["right","bottom"],["left","top"]])},t}(r.Box);(i.Quad=s).initClass()},function(t,e,i){var n=t(391),h=t(37),r=t(123),o=t(143);function u(t,e,i){if(e==(t+i)/2)return[t,i];var n=(t-e)/(t-2*e+i),r=t*Math.pow(1-n,2)+2*e*(1-n)*n+i*Math.pow(n,2);return[Math.min(t,i,r),Math.max(t,i,r)]}var s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._x0.length;e<i;e++)if(!isNaN(this._x0[e]+this._x1[e]+this._y0[e]+this._y1[e]+this._cx[e]+this._cy[e])){var n=u(this._x0[e],this._cx[e],this._x1[e]),r=n[0],o=n[1],s=u(this._y0[e],this._cy[e],this._y1[e]),a=s[0],l=s[1];t.push({minX:r,minY:a,maxX:o,maxY:l,i:e})}return new h.SpatialIndex(t)},e.prototype._render=function(t,e,i){var n=i.sx0,r=i.sy0,o=i.sx1,s=i.sy1,a=i.scx,l=i.scy;if(this.visuals.line.doit)for(var h=0,u=e;h<u.length;h++){var c=u[h];isNaN(n[c]+r[c]+o[c]+s[c]+a[c]+l[c])||(t.beginPath(),t.moveTo(n[c],r[c]),t.quadraticCurveTo(a[c],l[c],o[c],s[c]),this.visuals.line.set_vectorize(t,c),t.stroke())}},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_line_legend(this.visuals,t,e,i)},e.prototype.scenterx=function(){throw new Error("not implemented")},e.prototype.scentery=function(){throw new Error("not implemented")},e}(r.GlyphView);i.QuadraticView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Quadratic",this.prototype.default_view=s,this.coords([["x0","y0"],["x1","y1"],["cx","cy"]]),this.mixins(["line"])},t}(r.Glyph);(i.Quadratic=a).initClass()},function(t,e,i){var n=t(391),r=t(146),o=t(143),s=t(15),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.length.units?this.slength=this.sdist(this.renderer.xscale,this._x,this._length):this.slength=this._length},e.prototype._render=function(t,e,i){var n=i.sx,r=i.sy,o=i.slength,s=i._angle;if(this.visuals.line.doit){for(var a=this.renderer.plot_view.frame._width.value,l=this.renderer.plot_view.frame._height.value,h=2*(a+l),u=0,c=o.length;u<c;u++)0==o[u]&&(o[u]=h);for(var _=0,p=e;_<p.length;_++){var u=p[_];isNaN(n[u]+r[u]+s[u]+o[u])||(t.translate(n[u],r[u]),t.rotate(s[u]),t.beginPath(),t.moveTo(0,0),t.lineTo(o[u],0),this.visuals.line.set_vectorize(t,u),t.stroke(),t.rotate(-s[u]),t.translate(-n[u],-r[u]))}}},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_line_legend(this.visuals,t,e,i)},e}(r.XYGlyphView);i.RayView=a;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Ray",this.prototype.default_view=a,this.mixins(["line"]),this.define({length:[s.DistanceSpec],angle:[s.AngleSpec]})},t}(r.XYGlyph);(i.Ray=l).initClass()},function(t,e,i){var n=t(391),r=t(119),o=t(143),T=t(9),s=t(15),A=t(22),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._set_data=function(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)},e.prototype._map_data=function(){var t,e;if("data"==this.model.properties.width.units)t=this._map_dist_corner_for_data_side_length(this._x,this._width,this.renderer.xscale),this.sw=t[0],this.sx0=t[1];else{this.sw=this._width;var i=this.sx.length;this.sx0=new Float64Array(i);for(var n=0;n<i;n++)this.sx0[n]=this.sx[n]-this.sw[n]/2}if("data"==this.model.properties.height.units)e=this._map_dist_corner_for_data_side_length(this._y,this._height,this.renderer.yscale),this.sh=e[0],this.sy1=e[1];else{this.sh=this._height;var r=this.sy.length;this.sy1=new Float64Array(r);for(var n=0;n<r;n++)this.sy1[n]=this.sy[n]-this.sh[n]/2}var o=this.sw.length;this.ssemi_diag=new Float64Array(o);for(var n=0;n<o;n++)this.ssemi_diag[n]=Math.sqrt(this.sw[n]/2*this.sw[n]/2+this.sh[n]/2*this.sh[n]/2)},e.prototype._render=function(t,e,i){var n=i.sx,r=i.sy,o=i.sx0,s=i.sy1,a=i.sw,l=i.sh,h=i._angle;if(this.visuals.fill.doit)for(var u=0,c=e;u<c.length;u++){var _=c[u];isNaN(n[_]+r[_]+o[_]+s[_]+a[_]+l[_]+h[_])||(this.visuals.fill.set_vectorize(t,_),h[_]?(t.translate(n[_],r[_]),t.rotate(h[_]),t.fillRect(-a[_]/2,-l[_]/2,a[_],l[_]),t.rotate(-h[_]),t.translate(-n[_],-r[_])):t.fillRect(o[_],s[_],a[_],l[_]))}if(this.visuals.line.doit){t.beginPath();for(var p=0,d=e;p<d.length;p++){var _=d[p];isNaN(n[_]+r[_]+o[_]+s[_]+a[_]+l[_]+h[_])||0!=a[_]&&0!=l[_]&&(h[_]?(t.translate(n[_],r[_]),t.rotate(h[_]),t.rect(-a[_]/2,-l[_]/2,a[_],l[_]),t.rotate(-h[_]),t.translate(-n[_],-r[_])):t.rect(o[_],s[_],a[_],l[_]),this.visuals.line.set_vectorize(t,_),t.stroke(),t.beginPath())}t.stroke()}},e.prototype._hit_rect=function(t){return this._hit_rect_against_index(t)},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,n=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(i),o=[],s=0,a=this.sx0.length;s<a;s++)o.push(this.sx0[s]+this.sw[s]/2);for(var l=[],s=0,a=this.sy1.length;s<a;s++)l.push(this.sy1[s]+this.sh[s]/2);for(var h=A.max(this._ddist(0,o,this.ssemi_diag)),u=A.max(this._ddist(1,l,this.ssemi_diag)),c=n-h,_=n+h,p=r-u,d=r+u,f=[],v=T.validate_bbox_coords([c,_],[p,d]),m=0,g=this.index.indices(v);m<g.length;m++){var s=g[m],y=void 0,b=void 0;if(this._angle[s]){var x=Math.sin(-this._angle[s]),w=Math.cos(-this._angle[s]),k=w*(e-this.sx[s])-x*(i-this.sy[s])+this.sx[s],S=x*(e-this.sx[s])+w*(i-this.sy[s])+this.sy[s];e=k,i=S,b=Math.abs(this.sx[s]-e)<=this.sw[s]/2,y=Math.abs(this.sy[s]-i)<=this.sh[s]/2}else b=e-this.sx0[s]<=this.sw[s]&&0<=e-this.sx0[s],y=i-this.sy1[s]<=this.sh[s]&&0<=i-this.sy1[s];y&&b&&f.push(s)}var C=T.create_empty_hit_test_result();return C.indices=f,C},e.prototype._map_dist_corner_for_data_side_length=function(t,e,i){for(var n=t.length,r=new Float64Array(n),o=new Float64Array(n),s=0;s<n;s++)r[s]=Number(t[s])-e[s]/2,o[s]=Number(t[s])+e[s]/2;for(var a=i.v_compute(r),l=i.v_compute(o),h=this.sdist(i,r,e,"edge",this.model.dilate),u=a,s=0,c=a.length;s<c;s++)if(a[s]!=l[s]){u=a[s]<l[s]?a:l;break}return[h,u]},e.prototype._ddist=function(t,e,i){for(var n=0==t?this.renderer.xscale:this.renderer.yscale,r=e,o=r.length,s=new Float64Array(o),a=0;a<o;a++)s[a]=r[a]+i[a];for(var l=n.v_invert(r),h=n.v_invert(s),u=l.length,c=new Float64Array(u),a=0;a<u;a++)c[a]=Math.abs(h[a]-l[a]);return c},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_area_legend(this.visuals,t,e,i)},e.prototype._bounds=function(t){var e=t.minX,i=t.maxX,n=t.minY,r=t.maxY;return{minX:e-this.max_w2,maxX:i+this.max_w2,minY:n-this.max_h2,maxY:r+this.max_h2}},e}(r.CenterRotatableView);i.RectView=a;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Rect",this.prototype.default_view=a,this.define({dilate:[s.Bool,!1]})},t}(r.CenterRotatable);(i.Rect=l).initClass()},function(t,e,i){var n=t(391),k=t(9),a=t(37),r=t(123),o=t(143),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._x0.length;e<i;e++){var n=this._x0[e],r=this._x1[e],o=this._y0[e],s=this._y1[e];isNaN(n+r+o+s)||t.push({minX:Math.min(n,r),minY:Math.min(o,s),maxX:Math.max(n,r),maxY:Math.max(o,s),i:e})}return new a.SpatialIndex(t)},e.prototype._render=function(t,e,i){var n=i.sx0,r=i.sy0,o=i.sx1,s=i.sy1;if(this.visuals.line.doit)for(var a=0,l=e;a<l.length;a++){var h=l[a];isNaN(n[h]+r[h]+o[h]+s[h])||(t.beginPath(),t.moveTo(n[h],r[h]),t.lineTo(o[h],s[h]),this.visuals.line.set_vectorize(t,h),t.stroke())}},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,n={x:e,y:i},r=[],o=this.renderer.xscale.r_invert(e-2,e+2),s=o[0],a=o[1],l=this.renderer.yscale.r_invert(i-2,i+2),h=l[0],u=l[1],c=this.index.indices({minX:s,minY:h,maxX:a,maxY:u}),_=0,p=c;_<p.length;_++){var d=p[_],f=Math.pow(Math.max(2,this.visuals.line.cache_select("line_width",d)/2),2),v={x:this.sx0[d],y:this.sy0[d]},m={x:this.sx1[d],y:this.sy1[d]},g=k.dist_to_segment_squared(n,v,m);g<f&&r.push(d)}var y=k.create_empty_hit_test_result();return y.indices=r,y},e.prototype._hit_span=function(t){var e,i,n,r,o,s=this.renderer.plot_view.frame.bbox.ranges,a=s[0],l=s[1],h=t.sx,u=t.sy;"v"==t.direction?(o=this.renderer.yscale.invert(u),e=[this._y0,this._y1],n=e[0],r=e[1]):(o=this.renderer.xscale.invert(h),i=[this._x0,this._x1],n=i[0],r=i[1]);for(var c=[],_=this.renderer.xscale.r_invert(a.start,a.end),p=_[0],d=_[1],f=this.renderer.yscale.r_invert(l.start,l.end),v=f[0],m=f[1],g=this.index.indices({minX:p,minY:v,maxX:d,maxY:m}),y=0,b=g;y<b.length;y++){var x=b[y];(n[x]<=o&&o<=r[x]||r[x]<=o&&o<=n[x])&&c.push(x)}var w=k.create_empty_hit_test_result();return w.indices=c,w},e.prototype.scenterx=function(t){return(this.sx0[t]+this.sx1[t])/2},e.prototype.scentery=function(t){return(this.sy0[t]+this.sy1[t])/2},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_line_legend(this.visuals,t,e,i)},e}(r.GlyphView);i.SegmentView=s;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Segment",this.prototype.default_view=s,this.coords([["x0","y0"],["x1","y1"]]),this.mixins(["line"])},t}(r.Glyph);(i.Segment=l).initClass()},function(t,e,i){var n=t(391),r=t(146),o=t(143),s=t(15),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._render=function(t,e,i){var n,r,o,s,a,l,h=i.sx,u=i.sy,c=!1,_=null;this.visuals.line.set_value(t);var p=e.length;if(!(p<2)){t.beginPath(),t.moveTo(h[0],u[0]);for(var d=0,f=e;d<f.length;d++){var v=f[d],m=void 0,g=void 0,y=void 0,b=void 0;switch(this.model.mode){case"before":n=[h[v-1],u[v]],m=n[0],y=n[1],r=[h[v],u[v]],g=r[0],b=r[1];break;case"after":o=[h[v],u[v-1]],m=o[0],y=o[1],s=[h[v],u[v]],g=s[0],b=s[1];break;case"center":var x=(h[v-1]+h[v])/2;a=[x,u[v-1]],m=a[0],y=a[1],l=[x,u[v]],g=l[0],b=l[1];break;default:throw new Error("unexpected")}if(c){if(!isFinite(h[v]+u[v])){t.stroke(),t.beginPath(),c=!1,_=v;continue}null!=_&&1<v-_&&(t.stroke(),c=!1)}c?(t.lineTo(m,y),t.lineTo(g,b)):(t.beginPath(),t.moveTo(h[v],u[v]),c=!0),_=v}t.lineTo(h[p-1],u[p-1]),t.stroke()}},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_line_legend(this.visuals,t,e,i)},e}(r.XYGlyphView);i.StepView=a;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Step",this.prototype.default_view=a,this.mixins(["line"]),this.define({mode:[s.StepMode,"before"]})},t}(r.XYGlyph);(i.Step=l).initClass()},function(t,e,i){var n=t(391),r=t(146),d=t(9),o=t(15),O=t(41),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._rotate_point=function(t,e,i,n,r){var o=(t-i)*Math.cos(r)-(e-n)*Math.sin(r)+i,s=(t-i)*Math.sin(r)+(e-n)*Math.cos(r)+n;return[o,s]},e.prototype._text_bounds=function(t,e,i,n){var r=[t,t+i,t+i,t,t],o=[e,e,e-n,e-n,e];return[r,o]},e.prototype._render=function(t,e,i){var n=i.sx,r=i.sy,o=i._x_offset,s=i._y_offset,a=i._angle,l=i._text;this._sys=[],this._sxs=[];for(var h=0,u=e;h<u.length;h++){var c=u[h];if(!isNaN(n[c]+r[c]+o[c]+s[c]+a[c])&&null!=l[c]&&(this._sxs[c]=[],this._sys[c]=[],this.visuals.text.doit)){var _=""+l[c];t.save(),t.translate(n[c]+o[c],r[c]+s[c]),t.rotate(a[c]),this.visuals.text.set_vectorize(t,c);var p=this.visuals.text.cache_select("font",c),d=O.get_text_height(p).height,f=this.visuals.text.text_line_height.value()*d;if(-1==_.indexOf("\n")){t.fillText(_,0,0);var v=n[c]+o[c],m=r[c]+s[c],g=t.measureText(_).width,y=this._text_bounds(v,m,g,f),b=y[0],x=y[1];this._sxs[c].push(b),this._sys[c].push(x)}else{var w=_.split("\n"),k=f*w.length,S=this.visuals.text.cache_select("text_baseline",c),C=void 0;switch(S){case"top":C=0;break;case"middle":C=-k/2+f/2;break;case"bottom":C=-k+f;break;default:C=0,console.warn("'"+S+"' baseline not supported with multi line text")}for(var T=0,A=w;T<A.length;T++){var E=A[T];t.fillText(E,0,C);var v=n[c]+o[c],m=C+r[c]+s[c],g=t.measureText(E).width,M=this._text_bounds(v,m,g,f),b=M[0],x=M[1];this._sxs[c].push(b),this._sys[c].push(x),C+=f}}t.restore()}}},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,n=[],r=0;r<this._sxs.length;r++)for(var o=this._sxs[r],s=this._sys[r],a=o.length,l=0,h=a;l<h;l++){var u=this._rotate_point(e,i,o[a-1][0],s[a-1][0],-this._angle[r]),c=u[0],_=u[1];d.point_in_poly(c,_,o[l],s[l])&&n.push(r)}var p=d.create_empty_hit_test_result();return p.indices=n,p},e.prototype._scenterxy=function(t){var e=this._sxs[t][0][0],i=this._sys[t][0][0],n=(this._sxs[t][0][2]+e)/2,r=(this._sys[t][0][2]+i)/2,o=this._rotate_point(n,r,e,i,this._angle[t]),s=o[0],a=o[1];return{x:s,y:a}},e.prototype.scenterx=function(t){return this._scenterxy(t).x},e.prototype.scentery=function(t){return this._scenterxy(t).y},e}(r.XYGlyphView);i.TextView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Text",this.prototype.default_view=s,this.mixins(["text"]),this.define({text:[o.StringSpec,{field:"text"}],angle:[o.AngleSpec,0],x_offset:[o.NumberSpec,0],y_offset:[o.NumberSpec,0]})},t}(r.XYGlyph);(i.Text=a).initClass()},function(t,e,i){var x=t(9);i.generic_line_legend=function(t,e,i,n){var r=i.x0,o=i.x1,s=i.y0,a=i.y1;e.save(),e.beginPath(),e.moveTo(r,(s+a)/2),e.lineTo(o,(s+a)/2),t.line.doit&&(t.line.set_vectorize(e,n),e.stroke()),e.restore()},i.generic_area_legend=function(t,e,i,n){var r=i.x0,o=i.x1,s=i.y0,a=i.y1,l=.1*Math.abs(o-r),h=.1*Math.abs(a-s),u=r+l,c=o-l,_=s+h,p=a-h;t.fill.doit&&(t.fill.set_vectorize(e,n),e.fillRect(u,_,c-u,p-_)),t.line.doit&&(e.beginPath(),e.rect(u,_,c-u,p-_),t.line.set_vectorize(e,n),e.stroke())},i.line_interpolation=function(t,e,i,n,r,o){var s,a,l,h,u,c,_,p,d,f,v=e.sx,m=e.sy;"point"==e.type?(s=t.yscale.r_invert(m-1,m+1),d=s[0],f=s[1],a=t.xscale.r_invert(v-1,v+1),_=a[0],p=a[1]):"v"==e.direction?(l=t.yscale.r_invert(m,m),d=l[0],f=l[1],h=[Math.min(i-1,r-1),Math.max(i+1,r+1)],_=h[0],p=h[1]):(u=t.xscale.r_invert(v,v),_=u[0],p=u[1],c=[Math.min(n-1,o-1),Math.max(n+1,o+1)],d=c[0],f=c[1]);var g=x.check_2_segments_intersect(_,d,p,f,i,n,r,o),y=g.x,b=g.y;return[y,b]}},function(t,e,i){var n=t(391),r=t(118),o=t(15),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.scenterx=function(t){return this.sx[t]},e.prototype.scentery=function(t){return(this.stop[t]+this.sbottom[t])/2},e.prototype._index_data=function(){return this._index_box(this._x.length)},e.prototype._lrtb=function(t){var e=this._x[t]-this._width[t]/2,i=this._x[t]+this._width[t]/2,n=Math.max(this._top[t],this._bottom[t]),r=Math.min(this._top[t],this._bottom[t]);return[e,i,n,r]},e.prototype._map_data=function(){this.sx=this.renderer.xscale.v_compute(this._x),this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"),this.stop=this.renderer.yscale.v_compute(this._top),this.sbottom=this.renderer.yscale.v_compute(this._bottom);var t=this.sx.length;this.sleft=new Float64Array(t),this.sright=new Float64Array(t);for(var e=0;e<t;e++)this.sleft[e]=this.sx[e]-this.sw[e]/2,this.sright[e]=this.sx[e]+this.sw[e]/2;this._clamp_viewport()},e}(r.BoxView);i.VBarView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="VBar",this.prototype.default_view=s,this.coords([["x","bottom"]]),this.define({width:[o.DistanceSpec],top:[o.NumberSpec]}),this.override({bottom:0})},t}(r.Box);(i.VBar=a).initClass()},function(t,e,i){var n=t(391),r=t(146),o=t(143),P=t(9),s=t(15),j=t(31),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._map_data=function(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius},e.prototype._render=function(t,e,i){for(var n=i.sx,r=i.sy,o=i.sradius,s=i._start_angle,a=i._end_angle,l=this.model.properties.direction.value(),h=0,u=e;h<u.length;h++){var c=u[h];isNaN(n[c]+r[c]+o[c]+s[c]+a[c])||(t.beginPath(),t.arc(n[c],r[c],o[c],s[c],a[c],l),t.lineTo(n[c],r[c]),t.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,c),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,c),t.stroke()))}},e.prototype._hit_point=function(t){var e,i,n,r,o,s,a,l,h,u,c,_,p,d=t.sx,f=t.sy,v=this.renderer.xscale.invert(d),m=this.renderer.yscale.invert(f),g=2*this.max_radius;"data"===this.model.properties.radius.units?(u=v-g,c=v+g,_=m-g,p=m+g):(s=d-g,a=d+g,e=this.renderer.xscale.r_invert(s,a),u=e[0],c=e[1],l=f-g,h=f+g,i=this.renderer.yscale.r_invert(l,h),_=i[0],p=i[1]);for(var y=[],b=P.validate_bbox_coords([u,c],[_,p]),x=0,w=this.index.indices(b);x<w.length;x++){var k=w[x],S=Math.pow(this.sradius[k],2);n=this.renderer.xscale.r_compute(v,this._x[k]),s=n[0],a=n[1],r=this.renderer.yscale.r_compute(m,this._y[k]),l=r[0],h=r[1],(o=Math.pow(s-a,2)+Math.pow(l-h,2))<=S&&y.push([k,o])}for(var C=this.model.properties.direction.value(),T=[],A=0,E=y;A<E.length;A++){var M=E[A],k=M[0],O=M[1],z=Math.atan2(f-this.sy[k],d-this.sx[k]);j.angle_between(-z,-this._start_angle[k],-this._end_angle[k],C)&&T.push([k,O])}return P.create_hit_test_result_from_hits(T)},e.prototype.draw_legend_for_index=function(t,e,i){o.generic_area_legend(this.visuals,t,e,i)},e.prototype._scenterxy=function(t){var e=this.sradius[t]/2,i=(this._start_angle[t]+this._end_angle[t])/2;return{x:this.sx[t]+e*Math.cos(i),y:this.sy[t]+e*Math.sin(i)}},e.prototype.scenterx=function(t){return this._scenterxy(t).x},e.prototype.scentery=function(t){return this._scenterxy(t).y},e}(r.XYGlyphView);i.WedgeView=a;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Wedge",this.prototype.default_view=a,this.mixins(["line","fill"]),this.define({direction:[s.Direction,"anticlock"],radius:[s.DistanceSpec],start_angle:[s.AngleSpec],end_angle:[s.AngleSpec]})},t}(r.XYGlyph);(i.Wedge=l).initClass()},function(t,e,i){var n=t(391),o=t(37),r=t(123),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._index_data=function(){for(var t=[],e=0,i=this._x.length;e<i;e++){var n=this._x[e],r=this._y[e];!isNaN(n+r)&&isFinite(n+r)&&t.push({minX:n,minY:r,maxX:n,maxY:r,i:e})}return new o.SpatialIndex(t)},e.prototype.scenterx=function(t){return this.sx[t]},e.prototype.scentery=function(t){return this.sy[t]},e}(r.GlyphView);i.XYGlyphView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="XYGlyph",this.coords([["x","y"]])},t}(r.Glyph);(i.XYGlyph=a).initClass()},function(t,e,i){var n=t(391),r=t(59),u=t(22),c=t(21),_=t(9),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="GraphHitTestPolicy"},t.prototype._hit_test_nodes=function(t,e){if(!e.model.visible)return null;var i=e.node_view.glyph.hit_test(t);return null==i?null:e.node_view.model.view.convert_selection_from_subset(i)},t.prototype._hit_test_edges=function(t,e){if(!e.model.visible)return null;var i=e.edge_view.glyph.hit_test(t);return null==i?null:e.edge_view.model.view.convert_selection_from_subset(i)},t}(r.Model),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="NodesOnly"},t.prototype.hit_test=function(t,e){return this._hit_test_nodes(t,e)},t.prototype.do_selection=function(t,e,i,n){if(null==t)return!1;var r=e.node_renderer.data_source.selected;return r.update(t,i,n),e.node_renderer.data_source._select.emit(),!r.is_empty()},t.prototype.do_inspection=function(t,e,i,n,r){if(null==t)return!1;var o=i.model.get_selection_manager().get_or_create_inspector(i.node_view.model);return o.update(t,n,r),i.node_view.model.data_source.setv({inspected:o},{silent:!0}),i.node_view.model.data_source.inspect.emit([i.node_view,{geometry:e}]),!o.is_empty()},t}(i.GraphHitTestPolicy=o);(i.NodesOnly=s).initClass();var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="NodesAndLinkedEdges"},t.prototype.hit_test=function(t,e){return this._hit_test_nodes(t,e)},t.prototype.get_linked_edges=function(e,t,i){var n=[];"selection"==i?n=e.selected.indices.map(function(t){return e.data.index[t]}):"inspection"==i&&(n=e.inspected.indices.map(function(t){return e.data.index[t]}));for(var r=[],o=0;o<t.data.start.length;o++)(c.contains(n,t.data.start[o])||c.contains(n,t.data.end[o]))&&r.push(o);for(var s=_.create_empty_hit_test_result(),a=0,l=r;a<l.length;a++){var o=l[a];s.multiline_indices[o]=[0]}return s.indices=r,s},t.prototype.do_selection=function(t,e,i,n){if(null==t)return!1;var r=e.node_renderer.data_source.selected;r.update(t,i,n);var o=e.edge_renderer.data_source.selected,s=this.get_linked_edges(e.node_renderer.data_source,e.edge_renderer.data_source,"selection");return o.update(s,i,n),e.node_renderer.data_source._select.emit(),!r.is_empty()},t.prototype.do_inspection=function(t,e,i,n,r){if(null==t)return!1;var o=i.node_view.model.data_source.selection_manager.get_or_create_inspector(i.node_view.model);o.update(t,n,r),i.node_view.model.data_source.setv({inspected:o},{silent:!0});var s=i.edge_view.model.data_source.selection_manager.get_or_create_inspector(i.edge_view.model),a=this.get_linked_edges(i.node_view.model.data_source,i.edge_view.model.data_source,"inspection");return s.update(a,n,r),i.edge_view.model.data_source.setv({inspected:s},{silent:!0}),i.node_view.model.data_source.inspect.emit([i.node_view,{geometry:e}]),!o.is_empty()},t}(o);(i.NodesAndLinkedEdges=a).initClass();var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="EdgesAndLinkedNodes"},t.prototype.hit_test=function(t,e){return this._hit_test_edges(t,e)},t.prototype.get_linked_nodes=function(e,t,i){var n=[];"selection"==i?n=t.selected.indices:"inspection"==i&&(n=t.inspected.indices);for(var r=[],o=0,s=n;o<s.length;o++){var a=s[o];r.push(t.data.start[a]),r.push(t.data.end[a])}var l=c.uniq(r).map(function(t){return u.indexOf(e.data.index,t)}),h=_.create_empty_hit_test_result();return h.indices=l,h},t.prototype.do_selection=function(t,e,i,n){if(null==t)return!1;var r=e.edge_renderer.data_source.selected;r.update(t,i,n);var o=e.node_renderer.data_source.selected,s=this.get_linked_nodes(e.node_renderer.data_source,e.edge_renderer.data_source,"selection");return o.update(s,i,n),e.edge_renderer.data_source._select.emit(),!r.is_empty()},t.prototype.do_inspection=function(t,e,i,n,r){if(null==t)return!1;var o=i.edge_view.model.data_source.selection_manager.get_or_create_inspector(i.edge_view.model);o.update(t,n,r),i.edge_view.model.data_source.setv({inspected:o},{silent:!0});var s=i.node_view.model.data_source.selection_manager.get_or_create_inspector(i.node_view.model),a=this.get_linked_nodes(i.node_view.model.data_source,i.edge_view.model.data_source,"inspection");return s.update(a,n,r),i.node_view.model.data_source.setv({inspected:s},{silent:!0}),i.edge_view.model.data_source.inspect.emit([i.edge_view,{geometry:e}]),!o.is_empty()},t}(o);(i.EdgesAndLinkedNodes=l).initClass()},function(t,e,i){var n=t(391);n.__exportStar(t(147),i),n.__exportStar(t(149),i),n.__exportStar(t(150),i)},function(t,e,i){var n=t(391),r=t(59),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="LayoutProvider"},t}(r.Model);(i.LayoutProvider=o).initClass()},function(t,e,i){var n=t(391),r=t(149),o=t(15),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="StaticLayoutProvider",this.define({graph_layout:[o.Any,{}]})},t.prototype.get_node_coordinates=function(t){for(var e=[],i=[],n=t.data.index,r=0,o=n.length;r<o;r++){var s=this.graph_layout[n[r]],a=null!=s?s:[NaN,NaN],l=a[0],h=a[1];e.push(l),i.push(h)}return[e,i]},t.prototype.get_edge_coordinates=function(t){for(var e,i,n=[],r=[],o=t.data.start,s=t.data.end,a=null!=t.data.xs&&null!=t.data.ys,l=0,h=o.length;l<h;l++){var u=null!=this.graph_layout[o[l]]&&null!=this.graph_layout[s[l]];if(a&&u)n.push(t.data.xs[l]),r.push(t.data.ys[l]);else{var c=void 0,_=void 0;u?(e=[this.graph_layout[o[l]],this.graph_layout[s[l]]],_=e[0],c=e[1]):(_=(i=[[NaN,NaN],[NaN,NaN]])[0],c=i[1]),n.push([_[0],c[0]]),r.push([_[1],c[1]])}}return[n,r]},t}(r.LayoutProvider);(i.StaticLayoutProvider=s).initClass()},function(t,e,i){var n=t(391),h=t(79),r=t(187),o=t(15),u=t(44),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),Object.defineProperty(t.prototype,"_x_range_name",{get:function(){return this.model.x_range_name},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"_y_range_name",{get:function(){return this.model.y_range_name},enumerable:!0,configurable:!0}),t.prototype.render=function(){if(this.model.visible){var t=this.plot_view.canvas_view.ctx;t.save(),this._draw_regions(t),this._draw_minor_grids(t),this._draw_grids(t),t.restore()}},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.request_render()})},t.prototype._draw_regions=function(t){if(this.visuals.band_fill.doit){var e=this.model.grid_coords("major",!1),i=e[0],n=e[1];this.visuals.band_fill.set_value(t);for(var r=0;r<i.length-1;r++)if(r%2==1){var o=this.plot_view.map_to_screen(i[r],n[r],this._x_range_name,this._y_range_name),s=o[0],a=o[1],l=this.plot_view.map_to_screen(i[r+1],n[r+1],this._x_range_name,this._y_range_name),h=l[0],u=l[1];t.fillRect(s[0],a[0],h[1]-s[0],u[1]-a[0]),t.fill()}}},t.prototype._draw_grids=function(t){if(this.visuals.grid_line.doit){var e=this.model.grid_coords("major"),i=e[0],n=e[1];this._draw_grid_helper(t,this.visuals.grid_line,i,n)}},t.prototype._draw_minor_grids=function(t){if(this.visuals.minor_grid_line.doit){var e=this.model.grid_coords("minor"),i=e[0],n=e[1];this._draw_grid_helper(t,this.visuals.minor_grid_line,i,n)}},t.prototype._draw_grid_helper=function(t,e,i,n){e.set_value(t);for(var r=0;r<i.length;r++){var o=this.plot_view.map_to_screen(i[r],n[r],this._x_range_name,this._y_range_name),s=o[0],a=o[1];t.beginPath(),t.moveTo(Math.round(s[0]),Math.round(a[0]));for(var l=1;l<s.length;l++)t.lineTo(Math.round(s[l]),Math.round(a[l]));t.stroke()}},t}(r.GuideRendererView);i.GridView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Grid",this.prototype.default_view=s,this.mixins(["line:grid_","line:minor_grid_","fill:band_"]),this.define({bounds:[o.Any,"auto"],dimension:[o.Number,0],ticker:[o.Instance],x_range_name:[o.String,"default"],y_range_name:[o.String,"default"]}),this.override({level:"underlay",band_fill_color:null,band_fill_alpha:0,grid_line_color:"#e5e5e5",minor_grid_line_color:null})},t.prototype.ranges=function(){var t=this.dimension,e=(t+1)%2,i=this.plot.plot_canvas.frame,n=[i.x_ranges[this.x_range_name],i.y_ranges[this.y_range_name]];return[n[t],n[e]]},t.prototype.computed_bounds=function(){var t,e,i,n=this.ranges()[0],r=this.bounds,o=[n.min,n.max];if(u.isArray(r))e=Math.min(r[0],r[1]),i=Math.max(r[0],r[1]),e<o[0]&&(e=o[0]),o[1]<i&&(i=o[1]);else{e=o[0],i=o[1];for(var s=0,a=this.plot.select(h.Axis);s<a.length;s++){var l=a[s];l.dimension==this.dimension&&l.x_range_name==this.x_range_name&&l.y_range_name==this.y_range_name&&(t=l.computed_bounds,e=t[0],i=t[1])}}return[e,i]},t.prototype.grid_coords=function(t,e){var i;void 0===e&&(e=!0);var n=this.dimension,r=(n+1)%2,o=this.ranges(),s=o[0],a=o[1],l=this.computed_bounds(),h=l[0],u=l[1];i=[Math.min(h,u),Math.max(h,u)],h=i[0],u=i[1];var c=this.ticker.get_ticks(h,u,s,a.min,{})[t],_=s.min,p=s.max,d=a.min,f=a.max,v=[[],[]];e||(c[0]!=_&&c.splice(0,0,_),c[c.length-1]!=p&&c.push(p));for(var m=0;m<c.length;m++)if(c[m]!=_&&c[m]!=p||!e){for(var g=[],y=[],b=0;b<2;b++){var x=d+(f-d)/1*b;g.push(c[m]),y.push(x)}v[n].push(g),v[r].push(y)}return v},t}(r.GuideRenderer);(i.Grid=a).initClass()},function(t,e,i){var n=t(151);i.Grid=n.Grid},function(t,e,i){var n=t(391);n.__exportStar(t(66),i),n.__exportStar(t(83),i),n.__exportStar(t(89),i),n.__exportStar(t(93),i),n.__exportStar(t(96),i),n.__exportStar(t(102),i),n.__exportStar(t(108),i),n.__exportStar(t(129),i),n.__exportStar(t(148),i),n.__exportStar(t(152),i),n.__exportStar(t(156),i),n.__exportStar(t(166),i),n.__exportStar(t(274),i),n.__exportStar(t(171),i),n.__exportStar(t(176),i),n.__exportStar(t(182),i),n.__exportStar(t(188),i),n.__exportStar(t(191),i),n.__exportStar(t(195),i),n.__exportStar(t(204),i),n.__exportStar(t(214),i),n.__exportStar(t(224),i),n.__exportStar(t(260),i)},function(t,e,i){var n=t(391),p=t(13),r=t(15),s=t(21),o=t(157),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.children.change,function(){return t.rebuild_child_views()})},t.prototype.css_classes=function(){return e.prototype.css_classes.call(this).concat("bk-grid")},t.prototype.get_height=function(){var t=this.model.get_layoutable_children(),e=t.map(function(t){return t._height.value});return this.model._horizontal?s.max(e):s.sum(e)},t.prototype.get_width=function(){var t=this.model.get_layoutable_children(),e=t.map(function(t){return t._width.value});return this.model._horizontal?s.sum(e):s.max(e)},t}(o.LayoutDOMView);i.BoxView=a;var l=function(_){function w(t){return _.call(this,t)||this}return n.__extends(w,_),w.initClass=function(){this.prototype.type="Box",this.prototype.default_view=a,this.define({children:[r.Array,[]]}),this.internal({spacing:[r.Number,6]})},w.prototype.initialize=function(){_.prototype.initialize.call(this),this._child_equal_size_width=new p.Variable(this.toString()+".child_equal_size_width"),this._child_equal_size_height=new p.Variable(this.toString()+".child_equal_size_height"),this._box_equal_size_top=new p.Variable(this.toString()+".box_equal_size_top"),this._box_equal_size_bottom=new p.Variable(this.toString()+".box_equal_size_bottom"),this._box_equal_size_left=new p.Variable(this.toString()+".box_equal_size_left"),this._box_equal_size_right=new p.Variable(this.toString()+".box_equal_size_right"),this._box_cell_align_top=new p.Variable(this.toString()+".box_cell_align_top"),this._box_cell_align_bottom=new p.Variable(this.toString()+".box_cell_align_bottom"),this._box_cell_align_left=new p.Variable(this.toString()+".box_cell_align_left"),this._box_cell_align_right=new p.Variable(this.toString()+".box_cell_align_right")},w.prototype.get_layoutable_children=function(){return this.children},w.prototype.get_constrained_variables=function(){return n.__assign({},_.prototype.get_constrained_variables.call(this),{box_equal_size_top:this._box_equal_size_top,box_equal_size_bottom:this._box_equal_size_bottom,box_equal_size_left:this._box_equal_size_left,box_equal_size_right:this._box_equal_size_right,box_cell_align_top:this._box_cell_align_top,box_cell_align_bottom:this._box_cell_align_bottom,box_cell_align_left:this._box_cell_align_left,box_cell_align_right:this._box_cell_align_right})},w.prototype.get_constraints=function(){var i=_.prototype.get_constraints.call(this),t=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];i.push.apply(i,t)},e=this.get_layoutable_children();if(0==e.length)return i;for(var n=0,r=e;n<r.length;n++){var o=r[n],s=o.get_constrained_variables(),a=this._child_rect(s);this._horizontal?null!=s.height&&t(p.EQ(a.height,[-1,this._height])):null!=s.width&&t(p.EQ(a.width,[-1,this._width])),this._horizontal?null!=s.box_equal_size_left&&null!=s.box_equal_size_right&&null!=s.width&&t(p.EQ([-1,s.box_equal_size_left],[-1,s.box_equal_size_right],s.width,this._child_equal_size_width)):null!=s.box_equal_size_top&&null!=s.box_equal_size_bottom&&null!=s.height&&t(p.EQ([-1,s.box_equal_size_top],[-1,s.box_equal_size_bottom],s.height,this._child_equal_size_height))}var l=this._info(e[0].get_constrained_variables());t(p.EQ(l.span.start,0));for(var h=1;h<e.length;h++){var u=this._info(e[h].get_constrained_variables());l.span.size&&t(p.EQ(l.span.start,l.span.size,[-1,u.span.start])),t(p.WEAK_EQ(l.whitespace.after,u.whitespace.before,0-this.spacing)),t(p.GE(l.whitespace.after,u.whitespace.before,0-this.spacing)),l=u}var c=e[e.length-1].get_constrained_variables();return this._horizontal?null!=c.width&&t(p.EQ(l.span.start,l.span.size,[-1,this._width])):null!=c.height&&t(p.EQ(l.span.start,l.span.size,[-1,this._height])),i=i.concat(this._align_outer_edges_constraints(!0),this._align_outer_edges_constraints(!1),this._align_inner_cell_edges_constraints(),this._box_equal_size_bounds(!0),this._box_equal_size_bounds(!1),this._box_cell_align_bounds(!0),this._box_cell_align_bounds(!1),this._box_whitespace(!0),this._box_whitespace(!1))},w.prototype._child_rect=function(t){return{x:t.origin_x,y:t.origin_y,width:t.width,height:t.height}},w.prototype._span=function(t){return this._horizontal?{start:t.x,size:t.width}:{start:t.y,size:t.height}},w.prototype._info=function(t){var e;e=this._horizontal?{before:t.whitespace_left,after:t.whitespace_right}:{before:t.whitespace_top,after:t.whitespace_bottom};var i=this._span(this._child_rect(t));return{span:i,whitespace:e}},w.prototype._flatten_cell_edge_variables=function(t){var e;e=t?w._top_bottom_inner_cell_edge_variables:w._left_right_inner_cell_edge_variables;for(var i=t!=this._horizontal,n=this.get_layoutable_children(),r=n.length,o={},s=0,a=0,l=n;a<l.length;a++){var h=l[a],u=void 0;u=h instanceof w?h._flatten_cell_edge_variables(t):{};for(var c=h.get_constrained_variables(),_=0,p=e;_<p.length;_++){var d=p[_];d in c&&(u[d]=[c[d]])}for(var f in u){var v=u[f],m=void 0;if(i){var g=f.split(" "),y=g[0],b=1<g.length?g[1]:"",x=this._horizontal?"row":"col";m=y+" "+x+"-"+r+"-"+s+"-"+b}else m=f;o[m]=m in o?o[m].concat(v):v}s++}return o},w.prototype._align_inner_cell_edges_constraints=function(){var t=[];if(null!=this.document&&s.includes(this.document.roots(),this)){var e=this._flatten_cell_edge_variables(this._horizontal);for(var i in e){var n=e[i];if(1<n.length)for(var r=n[0],o=1;o<n.length;o++)t.push(p.EQ(n[o],[-1,r]))}}return t},w.prototype._find_edge_leaves=function(t){var e=this.get_layoutable_children(),i=[[],[]];if(0<e.length)if(this._horizontal==t){var n=e[0],r=e[e.length-1];n instanceof w?i[0]=i[0].concat(n._find_edge_leaves(t)[0]):i[0].push(n),r instanceof w?i[1]=i[1].concat(r._find_edge_leaves(t)[1]):i[1].push(r)}else for(var o=0,s=e;o<s.length;o++){var a=s[o];if(a instanceof w){var l=a._find_edge_leaves(t);i[0]=i[0].concat(l[0]),i[1]=i[1].concat(l[1])}else i[0].push(a),i[1].push(a)}return i},w.prototype._align_outer_edges_constraints=function(t){var e,i,n=this._find_edge_leaves(t),r=n[0],o=n[1];t?(e="on_edge_align_left",i="on_edge_align_right"):(e="on_edge_align_top",i="on_edge_align_bottom");var s=function(t,e){for(var i=[],n=0,r=t;n<r.length;n++){var o=r[n],s=o.get_constrained_variables();e in s&&i.push(s[e])}return i},a=s(r,e),l=s(o,i),h=[],u=function(t){if(1<t.length)for(var e=t[0],i=1;i<t.length;i++){var n=t[i];h.push(p.EQ([-1,e],n))}};return u(a),u(l),h},w.prototype._box_insets_from_child_insets=function(t,e,i,a){var n,r,o,s,l=this._find_edge_leaves(t),h=l[0],u=l[1];t?(n=e+"_left",r=e+"_right",o=this[i+"_left"],s=this[i+"_right"]):(n=e+"_top",r=e+"_bottom",o=this[i+"_top"],s=this[i+"_bottom"]);var c=[],_=function(t,e,i){for(var n=0,r=e;n<r.length;n++){var o=r[n],s=o.get_constrained_variables();i in s&&(a?c.push(p.GE([-1,t],s[i])):c.push(p.EQ([-1,t],s[i])))}};return _(o,h,n),_(s,u,r),c},w.prototype._box_equal_size_bounds=function(t){return this._box_insets_from_child_insets(t,"box_equal_size","_box_equal_size",!1)},w.prototype._box_cell_align_bounds=function(t){return this._box_insets_from_child_insets(t,"box_cell_align","_box_cell_align",!1)},w.prototype._box_whitespace=function(t){return this._box_insets_from_child_insets(t,"whitespace","_whitespace",!0)},w._left_right_inner_cell_edge_variables=["box_cell_align_left","box_cell_align_right"],w._top_bottom_inner_cell_edge_variables=["box_cell_align_top","box_cell_align_bottom"],w}(o.LayoutDOM);(i.Box=l).initClass()},function(t,e,i){var n=t(391),r=t(154),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat("bk-grid-column")},e}(r.BoxView);i.ColumnView=o;var s=function(i){function t(t){var e=i.call(this,t)||this;return e._horizontal=!1,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="Column",this.prototype.default_view=o},t}(r.Box);(i.Column=s).initClass()},function(t,e,i){var n=t(154);i.Box=n.Box;var r=t(155);i.Column=r.Column;var o=t(157);i.LayoutDOM=o.LayoutDOM;var s=t(158);i.Row=s.Row;var a=t(159);i.Spacer=a.Spacer;var l=t(160);i.WidgetBox=l.WidgetBox},function(t,e,i){var n=t(391),r=t(59),g=t(5),o=t(15),s=t(11),h=t(13),a=t(4),l=t(6),u=function(i){function t(){var t=null!==i&&i.apply(this,arguments)||this;return t._solver_inited=!1,t._idle_notified=!1,t}return n.__extends(t,i),t.prototype.initialize=function(t){i.prototype.initialize.call(this,t),this.is_root&&(this._solver=new h.Solver),this.child_views={},this.build_child_views()},t.prototype.remove=function(){for(var t in this.child_views){var e=this.child_views[t];e.remove()}this.child_views={},i.prototype.remove.call(this)},t.prototype.has_finished=function(){if(!i.prototype.has_finished.call(this))return!1;for(var t in this.child_views){var e=this.child_views[t];if(!e.has_finished())return!1}return!0},t.prototype.notify_finished=function(){this.is_root?!this._idle_notified&&this.has_finished()&&null!=this.model.document&&(this._idle_notified=!0,this.model.document.notify_idle(this.model)):i.prototype.notify_finished.call(this)},t.prototype._calc_width_height=function(){for(var t=this.el;t=t.parentElement;)if(!t.classList.contains("bk-root")){if(t==document.body){var e=g.margin(document.body),i=e.left,n=e.right,r=e.top,o=e.bottom,s=document.documentElement.clientWidth-i-n,a=document.documentElement.clientHeight-r-o;return[s,a]}var l=g.padding(t),h=l.left,u=l.right,c=l.top,_=l.bottom,p=t.getBoundingClientRect(),d=p.width,f=p.height,v=d-h-u,m=f-c-_;switch(this.model.sizing_mode){case"scale_width":if(0<v)return[v,0<m?m:null];break;case"scale_height":if(0<m)return[0<v?v:null,m];break;case"scale_both":case"stretch_both":if(0<v||0<m)return[0<v?v:null,0<m?m:null];break;default:throw new Error("unreachable")}}return[null,null]},t.prototype._init_solver=function(){this._root_width=new h.Variable(this.toString()+".root_width"),this._root_height=new h.Variable(this.toString()+".root_height"),this._solver.add_edit_variable(this._root_width,NaN),this._solver.add_edit_variable(this._root_height,NaN);for(var t=this.model.get_all_editables(),e=0,i=t;e<i.length;e++){var n=i[e];this._solver.add_edit_variable(n,h.Strength.strong)}for(var r=this.model.get_all_constraints(),o=0,s=r;o<s.length;o++){var a=s[o];this._solver.add_constraint(a)}var l=this.model.get_constrained_variables();null!=l.width&&this._solver.add_constraint(h.EQ(l.width,this._root_width)),null!=l.height&&this._solver.add_constraint(h.EQ(l.height,this._root_height)),this._solver.update_variables(),this._solver_inited=!0},t.prototype._suggest_dims=function(t,e){var i,n=this.model.get_constrained_variables();null==n.width&&null==n.height||(null!=t&&null!=e||(i=this._calc_width_height(),t=i[0],e=i[1]),null!=n.width&&null!=t&&this._solver.suggest_value(this._root_width,t),null!=n.height&&null!=e&&this._solver.suggest_value(this._root_height,e),this._solver.update_variables())},t.prototype.resize=function(t,e){void 0===t&&(t=null),void 0===e&&(e=null),this.is_root?this._do_layout(!1,t,e):this.root.resize(t,e)},t.prototype.partial_layout=function(){this.is_root?this._do_layout(!1):this.root.partial_layout()},t.prototype.layout=function(){this.is_root?this._do_layout(!0):this.root.layout()},t.prototype._do_layout=function(t,e,i){void 0===e&&(e=null),void 0===i&&(i=null),this._solver_inited&&!t||(this._solver.clear(),this._init_solver()),this._suggest_dims(e,i),this._layout(),this._layout(),this._layout(!0),this.notify_finished()},t.prototype._layout=function(t){void 0===t&&(t=!1);for(var e=0,i=this.model.get_layoutable_children();e<i.length;e++){var n=i[e],r=this.child_views[n.id];null!=r._layout&&r._layout(t)}this.render(),t&&(this._has_finished=!0)},t.prototype.rebuild_child_views=function(){this.solver.clear(),this.build_child_views(),this.layout()},t.prototype.build_child_views=function(){var t=this.model.get_layoutable_children();a.build_views(this.child_views,t,{parent:this}),g.empty(this.el);for(var e=0,i=t;e<i.length;e++){var n=i[e],r=this.child_views[n.id];this.el.appendChild(r.el)}},t.prototype.connect_signals=function(){var t=this;i.prototype.connect_signals.call(this),this.is_root&&window.addEventListener("resize",this),this.connect(this.model.properties.sizing_mode.change,function(){return t.layout()})},t.prototype.handleEvent=function(){this.resize()},t.prototype.disconnect_signals=function(){window.removeEventListener("resize",this),i.prototype.disconnect_signals.call(this)},t.prototype._render_classes=function(){this.el.className="";for(var t=0,e=this.css_classes();t<e.length;t++){var i=e[t];this.el.classList.add(i)}this.el.classList.add("bk-layout-"+this.model.sizing_mode);for(var n=0,r=this.model.css_classes;n<r.length;n++){var o=r[n];this.el.classList.add(o)}},t.prototype.render=function(){switch(this._render_classes(),this.model.sizing_mode){case"fixed":var t=void 0;t=null!=this.model.width?this.model.width:this.get_width(),this.model.setv({width:t},{silent:!0});var e=void 0;e=null!=this.model.height?this.model.height:this.get_height(),this.model.setv({height:e},{silent:!0}),this.solver.suggest_value(this.model._width,t),this.solver.suggest_value(this.model._height,e);break;case"scale_width":var e=this.get_height();this.solver.suggest_value(this.model._height,e);break;case"scale_height":var t=this.get_width();this.solver.suggest_value(this.model._width,t);break;case"scale_both":var i=this.get_width_height(),t=i[0],e=i[1];this.solver.suggest_value(this.model._width,t),this.solver.suggest_value(this.model._height,e)}this.solver.update_variables(),this.position()},t.prototype.position=function(){switch(this.model.sizing_mode){case"fixed":case"scale_width":case"scale_height":this.el.style.position="relative",this.el.style.left="",this.el.style.top="";break;case"scale_both":case"stretch_both":this.el.style.position="absolute",this.el.style.left=this.model._dom_left.value+"px",this.el.style.top=this.model._dom_top.value+"px"}this.el.style.width=this.model._width.value+"px",this.el.style.height=this.model._height.value+"px"},t.prototype.get_width_height=function(){var t=this._calc_width_height(),e=t[0],i=t[1];if(null==e&&null==i)throw new Error("detached element");var n=this.model.get_aspect_ratio();if(null!=e&&null==i)return[e,e/n];if(null==e&&null!=i)return[i*n,i];var r,o,s=e,a=e/n,l=i*n,h=i;return s<l?(r=s,o=a):(r=l,o=h),[r,o]},t}(l.DOMView);i.LayoutDOMView=u;var c=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="LayoutDOM",this.define({height:[o.Number],width:[o.Number],disabled:[o.Bool,!1],sizing_mode:[o.SizingMode,"fixed"],css_classes:[o.Array,[]]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this._width=new h.Variable(this.toString()+".width"),this._height=new h.Variable(this.toString()+".height"),this._left=new h.Variable(this.toString()+".left"),this._right=new h.Variable(this.toString()+".right"),this._top=new h.Variable(this.toString()+".top"),this._bottom=new h.Variable(this.toString()+".bottom"),this._dom_top=new h.Variable(this.toString()+".dom_top"),this._dom_left=new h.Variable(this.toString()+".dom_left"),this._width_minus_right=new h.Variable(this.toString()+".width_minus_right"),this._height_minus_bottom=new h.Variable(this.toString()+".height_minus_bottom"),this._whitespace_top=new h.Variable(this.toString()+".whitespace_top"),this._whitespace_bottom=new h.Variable(this.toString()+".whitespace_bottom"),this._whitespace_left=new h.Variable(this.toString()+".whitespace_left"),this._whitespace_right=new h.Variable(this.toString()+".whitespace_right")},Object.defineProperty(t.prototype,"layout_bbox",{get:function(){return{top:this._top.value,left:this._left.value,width:this._width.value,height:this._height.value,right:this._right.value,bottom:this._bottom.value,dom_top:this._dom_top.value,dom_left:this._dom_left.value}},enumerable:!0,configurable:!0}),t.prototype.dump_layout=function(){for(var t,e={},i=[this];t=i.shift();)i.push.apply(i,t.get_layoutable_children()),e[t.toString()]=t.layout_bbox;console.table(e)},t.prototype.get_all_constraints=function(){for(var t=this.get_constraints(),e=0,i=this.get_layoutable_children();e<i.length;e++){var n=i[e];t=n instanceof s.LayoutCanvas?t.concat(n.get_constraints()):t.concat(n.get_all_constraints())}return t},t.prototype.get_all_editables=function(){for(var t=this.get_editables(),e=0,i=this.get_layoutable_children();e<i.length;e++){var n=i[e];t=n instanceof s.LayoutCanvas?t.concat(n.get_editables()):t.concat(n.get_all_editables())}return t},t.prototype.get_constraints=function(){return[h.GE(this._dom_left),h.GE(this._dom_top),h.GE(this._left),h.GE(this._width,[-1,this._right]),h.GE(this._top),h.GE(this._height,[-1,this._bottom]),h.EQ(this._width_minus_right,[-1,this._width],this._right),h.EQ(this._height_minus_bottom,[-1,this._height],this._bottom)]},t.prototype.get_layoutable_children=function(){return[]},t.prototype.get_editables=function(){switch(this.sizing_mode){case"fixed":return[this._height,this._width];case"scale_width":return[this._height];case"scale_height":return[this._width];case"scale_both":return[this._width,this._height];default:return[]}},t.prototype.get_constrained_variables=function(){var t={origin_x:this._dom_left,origin_y:this._dom_top,whitespace_top:this._whitespace_top,whitespace_bottom:this._whitespace_bottom,whitespace_left:this._whitespace_left,whitespace_right:this._whitespace_right};switch(this.sizing_mode){case"stretch_both":t.width=this._width,t.height=this._height;break;case"scale_width":t.width=this._width;break;case"scale_height":t.height=this._height}return t},t.prototype.get_aspect_ratio=function(){return this.width/this.height},t}(r.Model);(i.LayoutDOM=c).initClass()},function(t,e,i){var n=t(391),r=t(154),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat("bk-grid-row")},e}(r.BoxView);i.RowView=o;var s=function(i){function t(t){var e=i.call(this,t)||this;return e._horizontal=!0,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="Row",this.prototype.default_view=o},t}(r.Box);(i.Row=s).initClass()},function(t,e,i){var n=t(391),r=t(157),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.render=function(){t.prototype.render.call(this),"fixed"==this.model.sizing_mode&&(this.el.style.width=this.model.width+"px",this.el.style.height=this.model.height+"px")},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat("bk-spacer-box")},e.prototype.get_width=function(){return 1},e.prototype.get_height=function(){return 1},e}(r.LayoutDOMView);i.SpacerView=o;var s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Spacer",this.prototype.default_view=o},t.prototype.get_constrained_variables=function(){return n.__assign({},e.prototype.get_constrained_variables.call(this),{on_edge_align_top:this._top,on_edge_align_bottom:this._height_minus_bottom,on_edge_align_left:this._left,on_edge_align_right:this._width_minus_right,box_cell_align_top:this._top,box_cell_align_bottom:this._height_minus_bottom,box_cell_align_left:this._left,box_cell_align_right:this._width_minus_right,box_equal_size_top:this._top,box_equal_size_bottom:this._height_minus_bottom,box_equal_size_left:this._left,box_equal_size_right:this._width_minus_right})},t}(r.LayoutDOM);(i.Spacer=s).initClass()},function(t,e,i){var n=t(391),r=t(14),o=t(15),s=t(157),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.children.change,function(){return t.rebuild_child_views()})},t.prototype.css_classes=function(){return e.prototype.css_classes.call(this).concat("bk-widget-box")},t.prototype.render=function(){if(this._render_classes(),"fixed"==this.model.sizing_mode||"scale_height"==this.model.sizing_mode){var t=this.get_width();this.model._width.value!=t&&this.solver.suggest_value(this.model._width,t)}if("fixed"==this.model.sizing_mode||"scale_width"==this.model.sizing_mode){var e=this.get_height();this.model._height.value!=e&&this.solver.suggest_value(this.model._height,e)}if(this.solver.update_variables(),"stretch_both"==this.model.sizing_mode)this.el.style.position="absolute",this.el.style.left=this.model._dom_left.value+"px",this.el.style.top=this.model._dom_top.value+"px",this.el.style.width=this.model._width.value+"px",this.el.style.height=this.model._height.value+"px";else{var i=void 0;i=0<this.model._width.value-20?this.model._width.value-20+"px":"100%",this.el.style.width=i}},t.prototype.get_height=function(){var t=0;for(var e in this.child_views){var i=this.child_views[e],n=i.el,r=getComputedStyle(n),o=parseInt(r.marginTop)||0,s=parseInt(r.marginBottom)||0;t+=n.offsetHeight+o+s}return t+20},t.prototype.get_width=function(){if(null!=this.model.width)return this.model.width;var t=this.el.scrollWidth+20;for(var e in this.child_views){var i=this.child_views[e],n=i.el.scrollWidth;t<n&&(t=n)}return t},t}(s.LayoutDOMView);i.WidgetBoxView=a;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="WidgetBox",this.prototype.default_view=a,this.define({children:[o.Array,[]]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),"fixed"==this.sizing_mode&&null==this.width&&(this.width=300,r.logger.info("WidgetBox mode is fixed, but no width specified. Using default of 300."))},t.prototype.get_constrained_variables=function(){var t=n.__assign({},e.prototype.get_constrained_variables.call(this),{on_edge_align_top:this._top,on_edge_align_bottom:this._height_minus_bottom,on_edge_align_left:this._left,on_edge_align_right:this._width_minus_right,box_cell_align_top:this._top,box_cell_align_bottom:this._height_minus_bottom,box_cell_align_left:this._left,box_cell_align_right:this._width_minus_right,box_equal_size_top:this._top,box_equal_size_bottom:this._height_minus_bottom});return"fixed"!=this.sizing_mode&&(t.box_equal_size_left=this._left,t.box_equal_size_right=this._width_minus_right),t},t.prototype.get_layoutable_children=function(){return this.children},t}(s.LayoutDOM);(i.WidgetBox=l).initClass()},function(t,e,i){var n=t(391),o=t(162),r=t(164),s=t(15),a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="CategoricalColorMapper",this.define({factors:[s.Array],start:[s.Number,0],end:[s.Number]})},t.prototype._v_compute=function(t,e,i,n){var r=n.nan_color;o.cat_v_compute(t,this.factors,i,e,this.start,this.end,r)},t}(r.ColorMapper);(i.CategoricalColorMapper=a).initClass()},function(t,e,i){var _=t(21),p=t(44);function d(t,e){if(t.length!=e.length)return!1;for(var i=0,n=t.length;i<n;i++)if(t[i]!==e[i])return!1;return!0}i._cat_equals=d,i.cat_v_compute=function(o,s,a,l,h,u,c){for(var t=function(t,e){var i=o[t],n=void 0;p.isString(i)?n=s.indexOf(i):(null!=h?i=null!=u?i.slice(h,u):i.slice(h):null!=u&&(i=i.slice(0,u)),n=1==i.length?s.indexOf(i[0]):_.findIndex(s,function(t){return d(t,i)}));var r=void 0;r=n<0||n>=a.length?c:a[n],l[t]=r},e=0,i=o.length;e<i;e++)t(e,i)}},function(t,e,i){var n=t(391),r=t(162),o=t(169),s=t(15),a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="CategoricalMarkerMapper",this.define({factors:[s.Array],markers:[s.Array],start:[s.Number,0],end:[s.Number],default_value:[s.String,"circle"]})},t.prototype.v_compute=function(t){var e=new Array(t.length);return r.cat_v_compute(t,this.factors,this.markers,e,this.start,this.end,this.default_value),e},t}(o.Mapper);(i.CategoricalMarkerMapper=a).initClass()},function(t,e,i){var n=t(391),r=t(169),o=t(15),s=t(27),a=t(28);function l(t){return"#"!=t[0]&&(t=s.color2hex(t)),9!=t.length&&(t+="ff"),parseInt(t.slice(1),16)}function h(t){for(var e=new Uint32Array(t.length),i=0,n=t.length;i<n;i++)e[i]=l(t[i]);return e}function u(t){if(a.is_little_endian)for(var e=new DataView(t.buffer),i=0,n=t.length;i<n;i++)e.setUint32(4*i,t[i]);return new Uint8Array(t.buffer)}i._convert_color=l,i._convert_palette=h,i._uint32_to_rgba=u;var c=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="ColorMapper",this.define({palette:[o.Any],nan_color:[o.Color,"gray"]})},t.prototype.v_compute=function(t){var e=new Array(t.length);return this._v_compute(t,e,this.palette,this._colors(function(t){return t})),e},Object.defineProperty(t.prototype,"rgba_mapper",{get:function(){var i=this,n=h(this.palette),r=this._colors(l);return{v_compute:function(t){var e=new Uint32Array(t.length);return i._v_compute(t,e,n,r),u(e)}}},enumerable:!0,configurable:!0}),t.prototype._colors=function(t){return{nan_color:t(this.nan_color)}},t}(r.Mapper);(i.ColorMapper=c).initClass()},function(t,e,i){var n=t(391),r=t(164),o=t(15),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="ContinuousColorMapper",this.define({high:[o.Number],low:[o.Number],high_color:[o.Color],low_color:[o.Color]})},t.prototype._colors=function(t){return n.__assign({},e.prototype._colors.call(this,t),{low_color:null!=this.low_color?t(this.low_color):void 0,high_color:null!=this.high_color?t(this.high_color):void 0})},t}(r.ColorMapper);(i.ContinuousColorMapper=s).initClass()},function(t,e,i){var n=t(161);i.CategoricalColorMapper=n.CategoricalColorMapper;var r=t(163);i.CategoricalMarkerMapper=r.CategoricalMarkerMapper;var o=t(165);i.ContinuousColorMapper=o.ContinuousColorMapper;var s=t(164);i.ColorMapper=s.ColorMapper;var a=t(167);i.LinearColorMapper=a.LinearColorMapper;var l=t(168);i.LogColorMapper=l.LogColorMapper},function(t,e,i){var n=t(391),r=t(165),m=t(22),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="LinearColorMapper"},t.prototype._v_compute=function(t,e,i,n){for(var r=n.nan_color,o=n.low_color,s=n.high_color,a=null!=this.low?this.low:m.min(t),l=null!=this.high?this.high:m.max(t),h=i.length-1,u=1/(l-a),c=1/i.length,_=0,p=t.length;_<p;_++){var d=t[_];if(isNaN(d))e[_]=r;else if(d!=l){var f=(d-a)*u,v=Math.floor(f/c);e[_]=v<0?null!=o?o:i[0]:h<v?null!=s?s:i[h]:i[v]}else e[_]=i[h]}},t}(r.ContinuousColorMapper);(i.LinearColorMapper=o).initClass()},function(t,e,i){var n=t(391),r=t(165),m=t(22),g=null!=Math.log1p?Math.log1p:function(t){return Math.log(1+t)},o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="LogColorMapper"},t.prototype._v_compute=function(t,e,i,n){for(var r=n.nan_color,o=n.low_color,s=n.high_color,a=i.length,l=null!=this.low?this.low:m.min(t),h=null!=this.high?this.high:m.max(t),u=a/(g(h)-g(l)),c=i.length-1,_=0,p=t.length;_<p;_++){var d=t[_];if(isNaN(d))e[_]=r;else if(h<d)e[_]=null!=s?s:i[c];else if(d!=h)if(d<l)e[_]=null!=o?o:i[0];else{var f=g(d)-g(l),v=Math.floor(f*u);c<v&&(v=c),e[_]=i[v]}else e[_]=i[c]}},t}(r.ContinuousColorMapper);(i.LogColorMapper=o).initClass()},function(t,e,i){var n=t(391),r=t(279),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Mapper"},t.prototype.compute=function(t){throw new Error("mapping single values is not supported")},t}(r.Transform);(i.Mapper=o).initClass()},function(t,e,i){var o=t(391),s=t(172),h=Math.sqrt(3);function a(t,e){t.moveTo(-e,e),t.lineTo(e,-e),t.moveTo(-e,-e),t.lineTo(e,e)}function l(t,e){t.moveTo(0,e),t.lineTo(0,-e),t.moveTo(-e,0),t.lineTo(e,0)}function u(t,e){t.moveTo(0,e),t.lineTo(e/1.5,0),t.lineTo(0,-e),t.lineTo(-e/1.5,0),t.closePath()}function c(t,e){var i=e*h,n=i/3;t.moveTo(-e,n),t.lineTo(e,n),t.lineTo(0,n-i),t.closePath()}function n(t,e,i,n,r){var o=.65*i;l(t,i),a(t,o),n.doit&&(n.set_vectorize(t,e),t.stroke())}function r(t,e,i,n,r){t.arc(0,0,i,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),l(t,i),t.stroke())}function _(t,e,i,n,r){t.arc(0,0,i,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),a(t,i),t.stroke())}function p(t,e,i,n,r){l(t,i),n.doit&&(n.set_vectorize(t,e),t.stroke())}function d(t,e,i,n,r){u(t,i),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),t.stroke())}function f(t,e,i,n,r){u(t,i),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),l(t,i),t.stroke())}function v(t,e,i,n,r){var o,s,a,l;l=h*(a=(s=i)/2),(o=t).moveTo(s,0),o.lineTo(a,-l),o.lineTo(-a,-l),o.lineTo(-s,0),o.lineTo(-a,l),o.lineTo(a,l),o.closePath(),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),t.stroke())}function m(t,e,i,n,r){t.rotate(Math.PI),c(t,i),t.rotate(-Math.PI),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),t.stroke())}function g(t,e,i,n,r){var o=2*i;t.rect(-i,-i,o,o),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),t.stroke())}function y(t,e,i,n,r){var o=2*i;t.rect(-i,-i,o,o),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),l(t,i),t.stroke())}function b(t,e,i,n,r){var o=2*i;t.rect(-i,-i,o,o),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),a(t,i),t.stroke())}function x(t,e,i,n,r){c(t,i),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),t.stroke())}function w(t,e,i,n,r){var o,s;s=i,(o=t).moveTo(-s,0),o.lineTo(s,0),n.doit&&(n.set_vectorize(t,e),t.stroke())}function k(t,e,i,n,r){a(t,i),n.doit&&(n.set_vectorize(t,e),t.stroke())}function S(i,n){var r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.initClass=function(){this.prototype._render_one=n},e}(s.MarkerView);r.initClass();var t=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.initClass=function(){this.prototype.default_view=r,this.prototype.type=i},e}(s.Marker);return t.initClass(),t}i.Asterisk=S("Asterisk",n),i.CircleCross=S("CircleCross",r),i.CircleX=S("CircleX",_),i.Cross=S("Cross",p),i.Diamond=S("Diamond",d),i.DiamondCross=S("DiamondCross",f),i.Hex=S("Hex",v),i.InvertedTriangle=S("InvertedTriangle",m),i.Square=S("Square",g),i.SquareCross=S("SquareCross",y),i.SquareX=S("SquareX",b),i.Triangle=S("Triangle",x),i.Dash=S("Dash",w),i.X=S("X",k),i.marker_funcs={asterisk:n,circle:function(t,e,i,n,r){t.arc(0,0,i,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(t,e),t.fill()),n.doit&&(n.set_vectorize(t,e),t.stroke())},circle_cross:r,circle_x:_,cross:p,diamond:d,diamond_cross:f,hex:v,inverted_triangle:m,square:g,square_cross:y,square_x:b,triangle:x,dash:w,x:k}},function(t,e,i){var n=t(391);n.__exportStar(t(170),i);var r=t(173);i.Scatter=r.Scatter},function(t,e,i){var n=t(391),r=t(146),w=t(9),o=t(15),h=t(21),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._render=function(t,e,i){for(var n=i.sx,r=i.sy,o=i._size,s=i._angle,a=0,l=e;a<l.length;a++){var h=l[a];if(!isNaN(n[h]+r[h]+o[h]+s[h])){var u=o[h]/2;t.beginPath(),t.translate(n[h],r[h]),s[h]&&t.rotate(s[h]),this._render_one(t,h,u,this.visuals.line,this.visuals.fill),s[h]&&t.rotate(-s[h]),t.translate(-n[h],-r[h])}}},e.prototype._mask_data=function(){var t=this.renderer.plot_view.frame.bbox.h_range,e=t.start-this.max_size,i=t.end+this.max_size,n=this.renderer.xscale.r_invert(e,i),r=n[0],o=n[1],s=this.renderer.plot_view.frame.bbox.v_range,a=s.start-this.max_size,l=s.end+this.max_size,h=this.renderer.yscale.r_invert(a,l),u=h[0],c=h[1],_=w.validate_bbox_coords([r,o],[u,c]);return this.index.indices(_)},e.prototype._hit_point=function(t){for(var e=t.sx,i=t.sy,n=e-this.max_size,r=e+this.max_size,o=this.renderer.xscale.r_invert(n,r),s=o[0],a=o[1],l=i-this.max_size,h=i+this.max_size,u=this.renderer.yscale.r_invert(l,h),c=u[0],_=u[1],p=w.validate_bbox_coords([s,a],[c,_]),d=this.index.indices(p),f=[],v=0,m=d;v<m.length;v++){var g=m[v],y=this._size[g]/2,b=Math.abs(this.sx[g]-e)+Math.abs(this.sy[g]-i);Math.abs(this.sx[g]-e)<=y&&Math.abs(this.sy[g]-i)<=y&&f.push([g,b])}return w.create_hit_test_result_from_hits(f)},e.prototype._hit_span=function(t){var e,i,n,r,o,s,a=t.sx,l=t.sy,h=this.bounds(),u=h.minX,c=h.minY,_=h.maxX,p=h.maxY,d=w.create_empty_hit_test_result();if("h"==t.direction){o=c,s=p;var f=this.max_size/2,v=a-f,m=a+f;e=this.renderer.xscale.r_invert(v,m),n=e[0],r=e[1]}else{n=u,r=_;var f=this.max_size/2,g=l-f,y=l+f;i=this.renderer.yscale.r_invert(g,y),o=i[0],s=i[1]}var b=w.validate_bbox_coords([n,r],[o,s]),x=this.index.indices(b);return d.indices=x,d},e.prototype._hit_rect=function(t){var e=t.sx0,i=t.sx1,n=t.sy0,r=t.sy1,o=this.renderer.xscale.r_invert(e,i),s=o[0],a=o[1],l=this.renderer.yscale.r_invert(n,r),h=l[0],u=l[1],c=w.validate_bbox_coords([s,a],[h,u]),_=w.create_empty_hit_test_result();return _.indices=this.index.indices(c),_},e.prototype._hit_poly=function(t){for(var e=t.sx,i=t.sy,n=h.range(0,this.sx.length),r=[],o=0,s=n.length;o<s;o++){var a=n[o];w.point_in_poly(this.sx[o],this.sy[o],e,i)&&r.push(a)}var l=w.create_empty_hit_test_result();return l.indices=r,l},e.prototype.draw_legend_for_index=function(t,e,i){var n=e.x0,r=e.x1,o=e.y0,s=e.y1,a=i+1,l=new Array(a);l[i]=(n+r)/2;var h=new Array(a);h[i]=(o+s)/2;var u=new Array(a);u[i]=.4*Math.min(Math.abs(r-n),Math.abs(s-o));var c=new Array(a);c[i]=0,this._render(t,[i],{sx:l,sy:h,_size:u,_angle:c})},e}(r.XYGlyphView);i.MarkerView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.mixins(["line","fill"]),this.define({size:[o.DistanceSpec,{units:"screen",value:4}],angle:[o.AngleSpec,0]})},t}(r.XYGlyph);(i.Marker=a).initClass()},function(t,e,i){var n=t(391),r=t(172),_=t(170),o=t(15),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._render=function(t,e,i){for(var n=i.sx,r=i.sy,o=i._size,s=i._angle,a=i._marker,l=0,h=e;l<h.length;l++){var u=h[l];if(!isNaN(n[u]+r[u]+o[u]+s[u])){var c=o[u]/2;t.beginPath(),t.translate(n[u],r[u]),s[u]&&t.rotate(s[u]),_.marker_funcs[a[u]](t,u,c,this.visuals.line,this.visuals.fill),s[u]&&t.rotate(-s[u]),t.translate(-n[u],-r[u])}}},e.prototype.draw_legend_for_index=function(t,e,i){var n=e.x0,r=e.x1,o=e.y0,s=e.y1,a=i+1,l=new Array(a);l[i]=(n+r)/2;var h=new Array(a);h[i]=(o+s)/2;var u=new Array(a);u[i]=.4*Math.min(Math.abs(r-n),Math.abs(s-o));var c=new Array(a);c[i]=0;var _=new Array(a);_[i]=this._marker[i],this._render(t,[i],{sx:l,sy:h,_size:u,_angle:c,_marker:_})},e}(r.MarkerView);i.ScatterView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Scatter",this.prototype.default_view=s,this.define({marker:[o.MarkerSpec,{value:"circle"}]})},t}(r.Marker);(i.Scatter=a).initClass()},function(t,e,i){var n=t(391),r=t(14),o=t(175),s=t(177),a=t(15),l=t(59),h=t(184),u=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="MapOptions",this.define({lat:[a.Number],lng:[a.Number],zoom:[a.Number,12]})},t}(l.Model);(i.MapOptions=u).initClass();var c=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="GMapOptions",this.define({map_type:[a.String,"roadmap"],scale_control:[a.Bool,!1],styles:[a.String],tilt:[a.Int,45]})},t}(u);(i.GMapOptions=c).initClass();var _=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(s.PlotView);i.GMapPlotView=_;var p=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="GMapPlot",this.prototype.default_view=_,this.define({map_options:[a.Instance],api_key:[a.String]}),this.override({x_range:function(){return new h.Range1d},y_range:function(){return new h.Range1d}})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this.api_key||r.logger.error("api_key is required. See https://developers.google.com/maps/documentation/javascript/get-api-key for more information on how to obtain your own.")},t.prototype._init_plot_canvas=function(){return new o.GMapPlotCanvas({plot:this})},t}(s.Plot);(i.GMapPlot=p).initClass()},function(t,e,i){var n=t(391),r=t(19),c=t(33),o=t(178),s=new r.Signal0({},"gmaps_ready"),a=function(a){function t(){return null!==a&&a.apply(this,arguments)||this}return n.__extends(t,a),t.prototype.initialize=function(t){var e=this;this.pause(),a.prototype.initialize.call(this,t),this._tiles_loaded=!1,this.zoom_count=0;var i=this.model.plot.map_options,n=i.zoom,r=i.lat,o=i.lng;this.initial_zoom=n,this.initial_lat=r,this.initial_lng=o,this.canvas_view.map_el.style.position="absolute","undefined"!=typeof google&&null!=google.maps||("undefined"==typeof _bokeh_gmaps_callback&&function(t){_bokeh_gmaps_callback=function(){return s.emit()};var e=document.createElement("script");e.type="text/javascript",e.src="https://maps.googleapis.com/maps/api/js?key="+t+"&callback=_bokeh_gmaps_callback",document.body.appendChild(e)}(this.model.plot.api_key),s.connect(function(){return e.request_render()})),this.unpause()},t.prototype.update_range=function(t){if(null==t)this.map.setCenter({lat:this.initial_lat,lng:this.initial_lng}),this.map.setOptions({zoom:this.initial_zoom}),a.prototype.update_range.call(this,null);else if(null!=t.sdx||null!=t.sdy)this.map.panBy(t.sdx||0,t.sdy||0),a.prototype.update_range.call(this,t);else if(null!=t.factor){var e=void 0;if(10!==this.zoom_count)return void(this.zoom_count+=1);this.zoom_count=0,this.pause(),a.prototype.update_range.call(this,t),e=t.factor<0?-1:1;var i=this.map.getZoom(),n=i+e;if(2<=n){this.map.setZoom(n);var r=this._get_projected_bounds(),o=r[0],s=r[1];s-o<0&&this.map.setZoom(i)}this.unpause()}this._set_bokeh_ranges()},t.prototype._build_map=function(){var t=this,e=google.maps;this.map_types={satellite:e.MapTypeId.SATELLITE,terrain:e.MapTypeId.TERRAIN,roadmap:e.MapTypeId.ROADMAP,hybrid:e.MapTypeId.HYBRID};var i=this.model.plot.map_options,n={center:new e.LatLng(i.lat,i.lng),zoom:i.zoom,disableDefaultUI:!0,mapTypeId:this.map_types[i.map_type],scaleControl:i.scale_control,tilt:i.tilt};null!=i.styles&&(n.styles=JSON.parse(i.styles)),this.map=new e.Map(this.canvas_view.map_el,n),e.event.addListener(this.map,"idle",function(){return t._set_bokeh_ranges()}),e.event.addListener(this.map,"bounds_changed",function(){return t._set_bokeh_ranges()}),e.event.addListenerOnce(this.map,"tilesloaded",function(){return t._render_finished()}),this.connect(this.model.plot.properties.map_options.change,function(){return t._update_options()}),this.connect(this.model.plot.map_options.properties.styles.change,function(){return t._update_styles()}),this.connect(this.model.plot.map_options.properties.lat.change,function(){return t._update_center("lat")}),this.connect(this.model.plot.map_options.properties.lng.change,function(){return t._update_center("lng")}),this.connect(this.model.plot.map_options.properties.zoom.change,function(){return t._update_zoom()}),this.connect(this.model.plot.map_options.properties.map_type.change,function(){return t._update_map_type()}),this.connect(this.model.plot.map_options.properties.scale_control.change,function(){return t._update_scale_control()}),this.connect(this.model.plot.map_options.properties.tilt.change,function(){return t._update_tilt()})},t.prototype._render_finished=function(){this._tiles_loaded=!0,this.notify_finished()},t.prototype.has_finished=function(){return a.prototype.has_finished.call(this)&&!0===this._tiles_loaded},t.prototype._get_latlon_bounds=function(){var t=this.map.getBounds(),e=t.getNorthEast(),i=t.getSouthWest(),n=i.lng(),r=e.lng(),o=i.lat(),s=e.lat();return[n,r,o,s]},t.prototype._get_projected_bounds=function(){var t=this._get_latlon_bounds(),e=t[0],i=t[1],n=t[2],r=t[3],o=c.wgs84_mercator.forward([e,n]),s=o[0],a=o[1],l=c.wgs84_mercator.forward([i,r]),h=l[0],u=l[1];return[s,h,a,u]},t.prototype._set_bokeh_ranges=function(){var t=this._get_projected_bounds(),e=t[0],i=t[1],n=t[2],r=t[3];this.frame.x_range.setv({start:e,end:i}),this.frame.y_range.setv({start:n,end:r})},t.prototype._update_center=function(t){var e=this.map.getCenter().toJSON();e[t]=this.model.plot.map_options[t],this.map.setCenter(e),this._set_bokeh_ranges()},t.prototype._update_map_type=function(){this.map.setOptions({mapTypeId:this.map_types[this.model.plot.map_options.map_type]})},t.prototype._update_scale_control=function(){this.map.setOptions({scaleControl:this.model.plot.map_options.scale_control})},t.prototype._update_tilt=function(){this.map.setOptions({tilt:this.model.plot.map_options.tilt})},t.prototype._update_options=function(){this._update_styles(),this._update_center("lat"),this._update_center("lng"),this._update_zoom(),this._update_map_type()},t.prototype._update_styles=function(){this.map.setOptions({styles:JSON.parse(this.model.plot.map_options.styles)})},t.prototype._update_zoom=function(){this.map.setOptions({zoom:this.model.plot.map_options.zoom}),this._set_bokeh_ranges()},t.prototype._map_hook=function(t,e){var i=e[0],n=e[1],r=e[2],o=e[3];this.canvas_view.map_el.style.top=n+"px",this.canvas_view.map_el.style.left=i+"px",this.canvas_view.map_el.style.width=r+"px",this.canvas_view.map_el.style.height=o+"px",null==this.map&&"undefined"!=typeof google&&null!=google.maps&&this._build_map()},t.prototype._paint_empty=function(t,e){var i=this.canvas._width.value,n=this.canvas._height.value,r=e[0],o=e[1],s=e[2],a=e[3];t.clearRect(0,0,i,n),t.beginPath(),t.moveTo(0,0),t.lineTo(0,n),t.lineTo(i,n),t.lineTo(i,0),t.lineTo(0,0),t.moveTo(r,o),t.lineTo(r+s,o),t.lineTo(r+s,o+a),t.lineTo(r,o+a),t.lineTo(r,o),t.closePath(),t.fillStyle=this.model.plot.border_fill_color,t.fill()},t}(o.PlotCanvasView);i.GMapPlotCanvasView=a;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="GMapPlotCanvas",this.prototype.default_view=a},t.prototype.initialize=function(){this.use_map=!0,e.prototype.initialize.call(this)},t}(o.PlotCanvas);(i.GMapPlotCanvas=l).initClass()},function(t,e,i){var n=t(174);i.MapOptions=n.MapOptions;var r=t(174);i.GMapOptions=r.GMapOptions;var o=t(174);i.GMapPlot=o.GMapPlot;var s=t(175);i.GMapPlotCanvas=s.GMapPlotCanvas;var a=t(177);i.Plot=a.Plot;var l=t(178);i.PlotCanvas=l.PlotCanvas},function(t,e,i){var o=t(391),n=t(13),r=t(14),s=t(15),f=t(19),a=t(21),v=t(32),m=t(44),l=t(157),h=t(75),u=t(192),c=t(268),_=t(76),p=t(178),g=t(200),y=t(185),b=t(3),x=t(180),w=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.prototype.connect_signals=function(){t.prototype.connect_signals.call(this),this.connect(this.model.properties.title.change,function(){return r.logger.warn("Title object cannot be replaced. Try changing properties on title to update it after initialization.")})},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat("bk-plot-layout")},e.prototype.get_height=function(){return this.model._width.value/this.model.get_aspect_ratio()},e.prototype.get_width=function(){return this.model._height.value*this.model.get_aspect_ratio()},e.prototype.save=function(t){this.plot_canvas_view.save(t)},Object.defineProperty(e.prototype,"plot_canvas_view",{get:function(){return this.child_views[this.model.plot_canvas.id]},enumerable:!0,configurable:!0}),e}(l.LayoutDOMView);i.PlotView=w;var d=function(d){function t(t){return d.call(this,t)||this}return o.__extends(t,d),t.initClass=function(){this.prototype.type="Plot",this.prototype.default_view=w,this.mixins(["line:outline_","fill:background_","fill:border_"]),this.define({toolbar:[s.Instance,function(){return new c.Toolbar}],toolbar_location:[s.Location,"right"],toolbar_sticky:[s.Boolean,!0],plot_width:[s.Number,600],plot_height:[s.Number,600],title:[s.Any,function(){return new h.Title({text:""})}],title_location:[s.Location,"above"],h_symmetry:[s.Bool,!0],v_symmetry:[s.Bool,!1],above:[s.Array,[]],below:[s.Array,[]],left:[s.Array,[]],right:[s.Array,[]],renderers:[s.Array,[]],x_range:[s.Instance,function(){return new x.DataRange1d}],extra_x_ranges:[s.Any,{}],y_range:[s.Instance,function(){return new x.DataRange1d}],extra_y_ranges:[s.Any,{}],x_scale:[s.Instance,function(){return new u.LinearScale}],y_scale:[s.Instance,function(){return new u.LinearScale}],lod_factor:[s.Number,10],lod_interval:[s.Number,300],lod_threshold:[s.Number,2e3],lod_timeout:[s.Number,500],hidpi:[s.Bool,!0],output_backend:[s.OutputBackend,"canvas"],min_border:[s.Number,5],min_border_top:[s.Number,null],min_border_left:[s.Number,null],min_border_bottom:[s.Number,null],min_border_right:[s.Number,null],inner_width:[s.Number],inner_height:[s.Number],layout_width:[s.Number],layout_height:[s.Number],match_aspect:[s.Bool,!1],aspect_scale:[s.Number,1]}),this.override({outline_line_color:"#e5e5e5",border_fill_color:"#ffffff",background_fill_color:"#ffffff"}),b.register_with_event(b.UIEvent,this)},t.prototype.initialize=function(){d.prototype.initialize.call(this),this.reset=new f.Signal0(this,"reset");for(var t=0,e=v.values(this.extra_x_ranges).concat(this.x_range);t<e.length;t++){var i=e[t],n=i.plots;m.isArray(n)&&(n=n.concat(this),i.setv({plots:n},{silent:!0}))}for(var r=0,o=v.values(this.extra_y_ranges).concat(this.y_range);r<o.length;r++){var s=o[r],n=s.plots;m.isArray(n)&&(n=n.concat(this),s.setv({plots:n},{silent:!0}))}null!=this.min_border&&(null==this.min_border_top&&(this.min_border_top=this.min_border),null==this.min_border_bottom&&(this.min_border_bottom=this.min_border),null==this.min_border_left&&(this.min_border_left=this.min_border),null==this.min_border_right&&(this.min_border_right=this.min_border));for(var a=0,l=["above","below","left","right"];a<l.length;a++)for(var h=l[a],u=this.getv(h),c=0,_=u;c<_.length;c++){var p=_[c];p.add_panel(h)}this._init_title_panel(),this._init_toolbar_panel(),this._plot_canvas=this._init_plot_canvas(),this.plot_canvas.toolbar=this.toolbar,null==this.width&&(this.width=this.plot_width),null==this.height&&(this.height=this.plot_height)},t.prototype._init_plot_canvas=function(){return new p.PlotCanvas({plot:this})},t.prototype._init_title_panel=function(){if(null!=this.title){var t=m.isString(this.title)?new h.Title({text:this.title}):this.title;this.add_layout(t,this.title_location)}},t.prototype._init_toolbar_panel=function(){var e=this,t=a.find(this.renderers,function(t){return t instanceof _.ToolbarPanel&&a.includes(t.tags,e.id)});switch(null!=t&&this.remove_layout(t),this.toolbar_location){case"left":case"right":case"above":case"below":if(t=new _.ToolbarPanel({toolbar:this.toolbar,tags:[this.id]}),this.toolbar.toolbar_location=this.toolbar_location,this.toolbar_sticky){var i=this.getv(this.toolbar_location),n=a.find(i,function(t){return t instanceof h.Title});if(null!=n)return t.set_panel(n.panel),void this.add_renderers(t)}this.add_layout(t,this.toolbar_location)}},t.prototype.connect_signals=function(){var t=this;d.prototype.connect_signals.call(this),this.connect(this.properties.toolbar_location.change,function(){return t._init_toolbar_panel()})},Object.defineProperty(t.prototype,"plot_canvas",{get:function(){return this._plot_canvas},enumerable:!0,configurable:!0}),t.prototype._doc_attached=function(){this.plot_canvas.attach_document(this.document),d.prototype._doc_attached.call(this)},t.prototype.add_renderers=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];var i=this.renderers;i=i.concat(t),this.renderers=i},t.prototype.add_layout=function(t,e){if(void 0===e&&(e="center"),null!=t.props.plot&&(t.plot=this),"center"!=e){var i=this.getv(e);i.push(t),t.add_panel(e)}this.add_renderers(t)},t.prototype.remove_layout=function(e){var t=function(t){a.removeBy(t,function(t){return t==e})};t(this.left),t(this.right),t(this.above),t(this.below),t(this.renderers)},t.prototype.add_glyph=function(t,e,i){void 0===e&&(e=new g.ColumnDataSource),void 0===i&&(i={});var n=o.__assign({},i,{data_source:e,glyph:t}),r=new y.GlyphRenderer(n);return this.add_renderers(r),r},t.prototype.add_tools=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];for(var i=0,n=t;i<n.length;i++){var r=n[i];null!=r.overlay&&this.add_renderers(r.overlay)}this.toolbar.tools=this.toolbar.tools.concat(t)},t.prototype.get_layoutable_children=function(){return[this.plot_canvas]},t.prototype.get_constraints=function(){var t=d.prototype.get_constraints.call(this);return t.push(n.EQ(this._width,[-1,this.plot_canvas._width])),t.push(n.EQ(this._height,[-1,this.plot_canvas._height])),t},t.prototype.get_constrained_variables=function(){var t=o.__assign({},d.prototype.get_constrained_variables.call(this),{on_edge_align_top:this.plot_canvas._top,on_edge_align_bottom:this.plot_canvas._height_minus_bottom,on_edge_align_left:this.plot_canvas._left,on_edge_align_right:this.plot_canvas._width_minus_right,box_cell_align_top:this.plot_canvas._top,box_cell_align_bottom:this.plot_canvas._height_minus_bottom,box_cell_align_left:this.plot_canvas._left,box_cell_align_right:this.plot_canvas._width_minus_right,box_equal_size_top:this.plot_canvas._top,box_equal_size_bottom:this.plot_canvas._height_minus_bottom});return"fixed"!=this.sizing_mode&&(t.box_equal_size_left=this.plot_canvas._left,t.box_equal_size_right=this.plot_canvas._width_minus_right),t},Object.defineProperty(t.prototype,"all_renderers",{get:function(){for(var t=this.renderers,e=0,i=this.toolbar.tools;e<i.length;e++){var n=i[e];t=t.concat(n.synthetic_renderers)}return t},enumerable:!0,configurable:!0}),t}(l.LayoutDOM);(i.Plot=d).initClass()},function(t,e,i){var l=t(391),n=t(91),r=t(92),C=t(180),T=t(185),o=t(157),s=t(3),h=t(19),c=t(4),u=t(20),_=t(49),a=t(6),p=t(11),d=t(10),f=t(13),A=t(14),v=t(7),m=t(15),g=t(42),y=t(44),b=t(21),E=t(32),x=t(12),w=null,k=function(a){function t(){return null!==a&&a.apply(this,arguments)||this}return l.__extends(t,a),Object.defineProperty(t.prototype,"frame",{get:function(){return this.model.frame},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"canvas",{get:function(){return this.model.canvas},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"canvas_overlays",{get:function(){return this.canvas_view.overlays_el},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"canvas_events",{get:function(){return this.canvas_view.events_el},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"is_paused",{get:function(){return null!=this._is_paused&&0!==this._is_paused},enumerable:!0,configurable:!0}),t.prototype.view_options=function(){return{plot_view:this,parent:this}},t.prototype.pause=function(){null==this._is_paused?this._is_paused=1:this._is_paused+=1},t.prototype.unpause=function(t){if(void 0===t&&(t=!1),null==this._is_paused)throw new Error("wasn't paused");this._is_paused-=1,0!=this._is_paused||t||this.request_render()},t.prototype.request_render=function(){this.request_paint()},t.prototype.request_paint=function(){this.is_paused||this.throttled_paint()},t.prototype.reset=function(){this.clear_state(),this.reset_range(),this.reset_selection(),this.model.plot.trigger_event(new s.Reset)},t.prototype.remove=function(){this.ui_event_bus.destroy(),c.remove_views(this.renderer_views),c.remove_views(this.tool_views),this.canvas_view.remove(),a.prototype.remove.call(this)},t.prototype.css_classes=function(){return a.prototype.css_classes.call(this).concat("bk-plot-wrapper")},t.prototype.initialize=function(t){var e=this;this.pause(),a.prototype.initialize.call(this,t),this.force_paint=new h.Signal0(this,"force_paint"),this.state_changed=new h.Signal0(this,"state_changed"),this.lod_started=!1,this.visuals=new _.Visuals(this.model.plot),this._initial_state_info={selection:{},dimensions:{width:this.model.canvas._width.value,height:this.model.canvas._height.value}},this.visibility_callbacks=[],this.state={history:[],index:-1},this.canvas_view=new this.canvas.default_view({model:this.canvas,parent:this}),this.el.appendChild(this.canvas_view.el),this.canvas_view.render(),"webgl"==this.model.plot.output_backend&&this.init_webgl(),this.throttled_paint=g.throttle(function(){return e.force_paint.emit()},15),this.ui_event_bus=new u.UIEvents(this,this.model.toolbar,this.canvas_view.events_el,this.model.plot),this.levels={};for(var i=0,n=v.RenderLevel;i<n.length;i++){var r=n[i];this.levels[r]={}}this.renderer_views={},this.tool_views={},this.build_levels(),this.build_tools(),this.update_dataranges(),this.unpause(!0),A.logger.debug("PlotView initialized")},t.prototype.set_cursor=function(t){void 0===t&&(t="default"),this.canvas_view.el.style.cursor=t},t.prototype.set_toolbar_visibility=function(e){void 0===e&&(e=!0),this.visibility_callbacks.forEach(function(t){return t(e)})},t.prototype.init_webgl=function(){if(null==w){var t=document.createElement("canvas"),e={premultipliedAlpha:!0},i=t.getContext("webgl",e)||t.getContext("experimental-webgl",e);null!=i&&(w={canvas:t,ctx:i})}null!=w?this.gl=w:A.logger.warn("WebGL is not supported, falling back to 2D canvas.")},t.prototype.prepare_webgl=function(t,e){if(null!=this.gl){var i=this.canvas_view.get_canvas_element();this.gl.canvas.width=i.width,this.gl.canvas.height=i.height;var n=this.gl.ctx;n.viewport(0,0,this.gl.canvas.width,this.gl.canvas.height),n.clearColor(0,0,0,0),n.clear(n.COLOR_BUFFER_BIT||n.DEPTH_BUFFER_BIT),n.enable(n.SCISSOR_TEST);var r=e[0],o=e[1],s=e[2],a=e[3],l=this.model.canvas,h=l.xview,u=l.yview,c=h.compute(r),_=u.compute(o+a);n.scissor(t*c,t*_,t*s,t*a),n.enable(n.BLEND),n.blendFuncSeparate(n.SRC_ALPHA,n.ONE_MINUS_SRC_ALPHA,n.ONE_MINUS_DST_ALPHA,n.ONE)}},t.prototype.blit_webgl=function(t){var e=this.canvas_view.ctx;null!=this.gl&&(A.logger.debug("drawing with WebGL"),e.restore(),e.drawImage(this.gl.canvas,0,0),e.save(),e.scale(t,t),e.translate(.5,.5))},t.prototype.update_dataranges=function(){for(var t=this.model.frame,e={},i={},n=!1,r=0,o=E.values(t.x_ranges).concat(E.values(t.y_ranges));r<o.length;r++){var s=o[r];s instanceof C.DataRange1d&&"log"==s.scale_hint&&(n=!0)}for(var a in this.renderer_views){var l=this.renderer_views[a];if(l instanceof T.GlyphRendererView){var h=l.glyph.bounds();if(null!=h&&(e[a]=h),n){var u=l.glyph.log_bounds();null!=u&&(i[a]=u)}}}var c,_=!1,p=!1;!1!==this.model.plot.match_aspect&&0!=this.frame._width.value&&0!=this.frame._height.value&&(c=1/this.model.plot.aspect_scale*(this.frame._width.value/this.frame._height.value));for(var d=0,f=E.values(t.x_ranges);d<f.length;d++){var v=f[d];if(v instanceof C.DataRange1d){var m="log"==v.scale_hint?i:e;v.update(m,0,this.model.id,c),v.follow&&(_=!0)}null!=v.bounds&&(p=!0)}for(var g=0,y=E.values(t.y_ranges);g<y.length;g++){var b=y[g];if(b instanceof C.DataRange1d){var m="log"==b.scale_hint?i:e;b.update(m,1,this.model.id,c),b.follow&&(_=!0)}null!=b.bounds&&(p=!0)}if(_&&p){A.logger.warn("Follow enabled so bounds are unset.");for(var x=0,w=E.values(t.x_ranges);x<w.length;x++){var v=w[x];v.bounds=null}for(var k=0,S=E.values(t.y_ranges);k<S.length;k++){var b=S[k];b.bounds=null}}this.range_update_timestamp=Date.now()},t.prototype.map_to_screen=function(t,e,i,n){return void 0===i&&(i="default"),void 0===n&&(n="default"),this.frame.map_to_screen(t,e,i,n)},t.prototype.push_state=function(t,e){var i=this.state,n=i.history,r=i.index,o=null!=n[r]?n[r].info:{},s=l.__assign({},this._initial_state_info,o,e);this.state.history=this.state.history.slice(0,this.state.index+1),this.state.history.push({type:t,info:s}),this.state.index=this.state.history.length-1,this.state_changed.emit()},t.prototype.clear_state=function(){this.state={history:[],index:-1},this.state_changed.emit()},t.prototype.can_undo=function(){this.state.index},t.prototype.can_redo=function(){this.state.index,this.state.history.length},t.prototype.undo=function(){this.can_undo()&&(this.state.index-=1,this._do_state_change(this.state.index),this.state_changed.emit())},t.prototype.redo=function(){this.can_redo()&&(this.state.index+=1,this._do_state_change(this.state.index),this.state_changed.emit())},t.prototype._do_state_change=function(t){var e=null!=this.state.history[t]?this.state.history[t].info:this._initial_state_info;null!=e.range&&this.update_range(e.range),null!=e.selection&&this.update_selection(e.selection)},t.prototype.get_selection=function(){for(var t={},e=0,i=this.model.plot.renderers;e<i.length;e++){var n=i[e];if(n instanceof T.GlyphRenderer){var r=n.data_source.selected;t[n.id]=r}}return t},t.prototype.update_selection=function(t){for(var e=0,i=this.model.plot.renderers;e<i.length;e++){var n=i[e];if(n instanceof T.GlyphRenderer){var r=n.data_source;null!=t?null!=t[n.id]&&r.selected.update(t[n.id],!0,!1):r.selection_manager.clear()}}},t.prototype.reset_selection=function(){this.update_selection(null)},t.prototype._update_ranges_together=function(t){for(var e=1,i=0,n=t;i<n.length;i++){var r=n[i],o=r[0],s=r[1];e=Math.min(e,this._get_weight_to_constrain_interval(o,s))}if(e<1)for(var a=0,l=t;a<l.length;a++){var h=l[a],o=h[0],s=h[1];s.start=e*s.start+(1-e)*o.start,s.end=e*s.end+(1-e)*o.end}},t.prototype._update_ranges_individually=function(t,e,i,n){for(var r=!1,o=0,s=t;o<s.length;o++){var a=s[o],l=a[0],h=a[1];if(!i){var u=this._get_weight_to_constrain_interval(l,h);u<1&&(h.start=u*h.start+(1-u)*l.start,h.end=u*h.end+(1-u)*l.end)}if(null!=l.bounds&&"auto"!=l.bounds){var c=l.bounds,_=c[0],p=c[1],d=Math.abs(h.end-h.start);l.is_reversed?(null!=_&&_>=h.end&&(r=!0,h.end=_,(e||i)&&(h.start=_+d)),null!=p&&p<=h.start&&(r=!0,h.start=p,(e||i)&&(h.end=p-d))):(null!=_&&_>=h.start&&(r=!0,h.start=_,(e||i)&&(h.end=_+d)),null!=p&&p<=h.end&&(r=!0,h.end=p,(e||i)&&(h.start=p-d)))}}if(!(i&&r&&n))for(var f=0,v=t;f<v.length;f++){var m=v[f],l=m[0],h=m[1];l.have_updated_interactively=!0,l.start==h.start&&l.end==h.end||l.setv(h)}},t.prototype._get_weight_to_constrain_interval=function(t,e){var i=t.min_interval,n=t.max_interval;if(null!=t.bounds&&"auto"!=t.bounds){var r=t.bounds,o=r[0],s=r[1];if(null!=o&&null!=s){var a=Math.abs(s-o);n=null!=n?Math.min(n,a):a}}var l=1;if(null!=i||null!=n){var h=Math.abs(t.end-t.start),u=Math.abs(e.end-e.start);0<i&&u<i&&(l=(h-i)/(h-u)),0<n&&n<u&&(l=(n-h)/(u-h)),l=Math.max(0,Math.min(1,l))}return l},t.prototype.update_range=function(t,e,i,n){void 0===e&&(e=!1),void 0===i&&(i=!1),void 0===n&&(n=!0),this.pause();var r=this.frame,o=r.x_ranges,s=r.y_ranges;if(null==t){for(var a in o){var l=o[a];l.reset()}for(var h in s){var l=s[h];l.reset()}this.update_dataranges()}else{var u=[];for(var c in o){var l=o[c];u.push([l,t.xrs[c]])}for(var _ in s){var l=s[_];u.push([l,t.yrs[_]])}i&&this._update_ranges_together(u),this._update_ranges_individually(u,e,i,n)}this.unpause()},t.prototype.reset_range=function(){this.update_range(null)},t.prototype.build_levels=function(){var t=this.model.plot.all_renderers,e=E.keys(this.renderer_views),i=c.build_views(this.renderer_views,t,this.view_options()),n=b.difference(e,t.map(function(t){return t.id}));for(var r in this.levels)for(var o=0,s=n;o<s.length;o++){var a=s[o];delete this.levels[r][a]}for(var l=0,h=i;l<h.length;l++){var u=h[l];this.levels[u.model.level][u.model.id]=u}},t.prototype.get_renderer_views=function(){var e=this;return this.model.plot.renderers.map(function(t){return e.levels[t.level][t.id]})},t.prototype.build_tools=function(){var e=this,t=this.model.plot.toolbar.tools,i=c.build_views(this.tool_views,t,this.view_options());i.map(function(t){return e.ui_event_bus.register_tool(t)})},t.prototype.connect_signals=function(){var t=this;a.prototype.connect_signals.call(this),this.connect(this.force_paint,function(){return t.repaint()});var e=this.model.frame,i=e.x_ranges,n=e.y_ranges;for(var r in i){var o=i[r];this.connect(o.change,function(){return t.request_render()})}for(var s in n){var o=n[s];this.connect(o.change,function(){return t.request_render()})}this.connect(this.model.plot.properties.renderers.change,function(){return t.build_levels()}),this.connect(this.model.plot.toolbar.properties.tools.change,function(){t.build_levels(),t.build_tools()}),this.connect(this.model.plot.change,function(){return t.request_render()}),this.connect(this.model.plot.reset,function(){return t.reset()})},t.prototype.set_initial_range=function(){var t=!0,e=this.frame,i=e.x_ranges,n=e.y_ranges,r={},o={};for(var s in i){var a=i[s],l=a.start,h=a.end;if(null==l||null==h||y.isStrictNaN(l+h)){t=!1;break}r[s]={start:l,end:h}}if(t)for(var u in n){var c=n[u],l=c.start,h=c.end;if(null==l||null==h||y.isStrictNaN(l+h)){t=!1;break}o[u]={start:l,end:h}}t?(this._initial_state_info.range={xrs:r,yrs:o},A.logger.debug("initial ranges set")):A.logger.warn("could not set initial ranges")},t.prototype.update_constraints=function(){for(var t in this.solver.suggest_value(this.frame._width,this.canvas._width.value),this.solver.suggest_value(this.frame._height,this.canvas._height.value),this.renderer_views){var e=this.renderer_views[t];x.isSizeableView(e)&&null!=e.model.panel&&x.update_panel_constraints(e)}this.solver.update_variables()},t.prototype._layout=function(t){void 0===t&&(t=!1),this.render(),t&&(this.model.plot.setv({inner_width:Math.round(this.frame._width.value),inner_height:Math.round(this.frame._height.value),layout_width:Math.round(this.canvas._width.value),layout_height:Math.round(this.canvas._height.value)},{no_change:!0}),this.paint())},t.prototype.has_finished=function(){if(!a.prototype.has_finished.call(this))return!1;for(var t in this.levels){var e=this.levels[t];for(var i in e){var n=e[i];if(!n.has_finished())return!1}}return!0},t.prototype.render=function(){var t=this.model._width.value,e=this.model._height.value;this.canvas_view.set_dims([t,e]),this.update_constraints(),!1!==this.model.plot.match_aspect&&0!=this.frame._width.value&&0!=this.frame._height.value&&this.update_dataranges(),this.el.style.position="absolute",this.el.style.left=this.model._dom_left.value+"px",this.el.style.top=this.model._dom_top.value+"px",this.el.style.width=this.model._width.value+"px",this.el.style.height=this.model._height.value+"px"},t.prototype._needs_layout=function(){for(var t in this.renderer_views){var e=this.renderer_views[t];if(x.isSizeableView(e)&&null!=e.model.panel&&x._view_sizes.get(e)!=e.get_size())return!0}return!1},t.prototype.repaint=function(){this._needs_layout()?this.parent.partial_layout():this.paint()},t.prototype.paint=function(){var t=this;if(!this.is_paused){A.logger.trace("PlotCanvas.render() for "+this.model.id),this.canvas_view.prepare_canvas();var e=this.model.document;if(null!=e){var i=e.interactive_duration(),n=this.model.plot;0<=i&&i<n.lod_interval?setTimeout(function(){e.interactive_duration()>n.lod_timeout&&e.interactive_stop(n),t.request_render()},n.lod_timeout):e.interactive_stop(n)}for(var r in this.renderer_views){var o=this.renderer_views[r];if(null==this.range_update_timestamp||o instanceof T.GlyphRendererView&&o.set_data_timestamp>this.range_update_timestamp){this.update_dataranges();break}}this.model.frame.update_scales();var s=this.canvas_view.ctx,a=this.canvas.pixel_ratio;s.save(),s.scale(a,a),s.translate(.5,.5);var l=[this.frame._left.value,this.frame._top.value,this.frame._width.value,this.frame._height.value];if(this._map_hook(s,l),this._paint_empty(s,l),this.prepare_webgl(a,l),s.save(),this.visuals.outline_line.doit){this.visuals.outline_line.set_value(s);var h=l[0],u=l[1],c=l[2],_=l[3];h+c==this.canvas._width.value&&(c-=1),u+_==this.canvas._height.value&&(_-=1),s.strokeRect(h,u,c,_)}s.restore(),this._paint_levels(s,["image","underlay","glyph"],l,!0),this.blit_webgl(a),this._paint_levels(s,["annotation"],l,!0),this._paint_levels(s,["overlay"],l,!1),null==this._initial_state_info.range&&this.set_initial_range(),s.restore(),this._has_finished||(this._has_finished=!0,this.notify_finished())}},t.prototype._paint_levels=function(t,e,i,n){t.save(),n&&(t.beginPath(),t.rect.apply(t,i),t.clip());for(var r={},o=0;o<this.model.plot.renderers.length;o++){var s=this.model.plot.renderers[o];r[s.id]=o}for(var a=function(t){return r[t.model.id]},l=0,h=e;l<h.length;l++)for(var u=h[l],c=b.sortBy(E.values(this.levels[u]),a),_=0,p=c;_<p.length;_++){var d=p[_];!n&&d.needs_clip&&(t.save(),t.beginPath(),t.rect.apply(t,i),t.clip()),d.render(),!n&&d.needs_clip&&t.restore()}t.restore()},t.prototype._map_hook=function(t,e){},t.prototype._paint_empty=function(t,e){var i=[0,0,this.canvas_view.model._width.value,this.canvas_view.model._height.value],n=i[0],r=i[1],o=i[2],s=i[3],a=e[0],l=e[1],h=e[2],u=e[3];t.clearRect(n,r,o,s),this.visuals.border_fill.doit&&(this.visuals.border_fill.set_value(t),t.fillRect(n,r,o,s),t.clearRect(a,l,h,u)),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(a,l,h,u))},t.prototype.save=function(t){switch(this.model.plot.output_backend){case"canvas":case"webgl":var e=this.canvas_view.get_canvas_element();if(null!=e.msToBlob){var i=e.msToBlob();window.navigator.msSaveBlob(i,t)}else{var n=document.createElement("a");n.href=e.toDataURL("image/png"),n.download=t+".png",n.target="_blank",n.dispatchEvent(new MouseEvent("click"))}break;case"svg":var r=this.canvas_view._ctx,o=r.getSerializedSvg(!0),s=new Blob([o],{type:"text/plain"}),a=document.createElement("a");a.download=t+".svg",a.innerHTML="Download svg",a.href=window.URL.createObjectURL(s),a.onclick=function(t){return document.body.removeChild(t.target)},a.style.display="none",document.body.appendChild(a),a.click()}},t}(a.DOMView);i.PlotCanvasView=k;var S=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return l.__extends(e,t),e.initClass=function(){this.prototype.type="AbovePanel"},e}(p.LayoutCanvas);(i.AbovePanel=S).initClass();var M=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return l.__extends(e,t),e.initClass=function(){this.prototype.type="BelowPanel"},e}(p.LayoutCanvas);(i.BelowPanel=M).initClass();var O=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return l.__extends(e,t),e.initClass=function(){this.prototype.type="LeftPanel"},e}(p.LayoutCanvas);(i.LeftPanel=O).initClass();var z=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return l.__extends(e,t),e.initClass=function(){this.prototype.type="RightPanel"},e}(p.LayoutCanvas);(i.RightPanel=z).initClass();var P=function(e){function t(t){return e.call(this,t)||this}return l.__extends(t,e),t.initClass=function(){this.prototype.type="PlotCanvas",this.prototype.default_view=k,this.internal({plot:[m.Instance],toolbar:[m.Instance],canvas:[m.Instance],frame:[m.Instance]}),this.override({sizing_mode:"stretch_both"})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this.canvas=new n.Canvas({map:null!=this.use_map&&this.use_map,use_hidpi:this.plot.hidpi,output_backend:this.plot.output_backend}),this.frame=new r.CartesianFrame({x_range:this.plot.x_range,extra_x_ranges:this.plot.extra_x_ranges,x_scale:this.plot.x_scale,y_range:this.plot.y_range,extra_y_ranges:this.plot.extra_y_ranges,y_scale:this.plot.y_scale}),this.above_panel=new S,this.below_panel=new M,this.left_panel=new O,this.right_panel=new z,A.logger.debug("PlotCanvas initialized")},t.prototype._doc_attached=function(){this.canvas.attach_document(this.document),this.frame.attach_document(this.document),this.above_panel.attach_document(this.document),this.below_panel.attach_document(this.document),this.left_panel.attach_document(this.document),this.right_panel.attach_document(this.document),e.prototype._doc_attached.call(this),A.logger.debug("PlotCanvas attached to document")},t.prototype.get_layoutable_children=function(){var r=[this.above_panel,this.below_panel,this.left_panel,this.right_panel,this.canvas,this.frame],t=function(t){for(var e=0,i=t;e<i.length;e++){var n=i[e];x.isSizeable(n)&&null!=n.panel&&r.push(n.panel)}};return t(this.plot.above),t(this.plot.below),t(this.plot.left),t(this.plot.right),r},t.prototype.get_constraints=function(){return e.prototype.get_constraints.call(this).concat(this._get_constant_constraints(),this._get_side_constraints())},t.prototype._get_constant_constraints=function(){return[f.EQ(this.canvas._left,0),f.EQ(this.canvas._top,0),f.GE(this.above_panel._top,[-1,this.canvas._top]),f.EQ(this.above_panel._bottom,[-1,this.frame._top]),f.EQ(this.above_panel._left,[-1,this.left_panel._right]),f.EQ(this.above_panel._right,[-1,this.right_panel._left]),f.EQ(this.below_panel._top,[-1,this.frame._bottom]),f.LE(this.below_panel._bottom,[-1,this.canvas._bottom]),f.EQ(this.below_panel._left,[-1,this.left_panel._right]),f.EQ(this.below_panel._right,[-1,this.right_panel._left]),f.EQ(this.left_panel._top,[-1,this.above_panel._bottom]),f.EQ(this.left_panel._bottom,[-1,this.below_panel._top]),f.GE(this.left_panel._left,[-1,this.canvas._left]),f.EQ(this.left_panel._right,[-1,this.frame._left]),f.EQ(this.right_panel._top,[-1,this.above_panel._bottom]),f.EQ(this.right_panel._bottom,[-1,this.below_panel._top]),f.EQ(this.right_panel._left,[-1,this.frame._right]),f.LE(this.right_panel._right,[-1,this.canvas._right]),f.EQ(this._top,[-1,this.above_panel._bottom]),f.EQ(this._left,[-1,this.left_panel._right]),f.EQ(this._height,[-1,this._bottom],[-1,this.canvas._bottom],this.below_panel._top),f.EQ(this._width,[-1,this._right],[-1,this.canvas._right],this.right_panel._left),f.GE(this._top,-this.plot.min_border_top),f.GE(this._left,-this.plot.min_border_left),f.GE(this._height,[-1,this._bottom],-this.plot.min_border_bottom),f.GE(this._width,[-1,this._right],-this.plot.min_border_right)]},t.prototype._get_side_constraints=function(){var t=function(t){return t.map(function(t){return t.panel})},e=d.vstack(this.above_panel,t(this.plot.above)),i=d.vstack(this.below_panel,b.reversed(t(this.plot.below))),n=d.hstack(this.left_panel,t(this.plot.left)),r=d.hstack(this.right_panel,b.reversed(t(this.plot.right)));return b.concat([e,i,n,r])},t}(o.LayoutDOM);(i.PlotCanvas=P).initClass()},function(t,e,i){var n=t(391),r=t(183),o=t(15),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="DataRange",this.define({names:[o.Array,[]],renderers:[o.Array,[]]})},t}(r.Range);(i.DataRange=s).initClass()},function(t,e,i){var n=t(391),r=t(179),h=t(185),_=t(14),o=t(15),u=t(24),c=t(21),s=function(i){function t(t){var e=i.call(this,t)||this;return e._plot_bounds={},e.have_updated_interactively=!1,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="DataRange1d",this.define({start:[o.Number],end:[o.Number],range_padding:[o.Number,.1],range_padding_units:[o.PaddingUnits,"percent"],flipped:[o.Bool,!1],follow:[o.StartEnd],follow_interval:[o.Number],default_span:[o.Number,2]}),this.internal({scale_hint:[o.String,"auto"]})},t.prototype.initialize=function(){i.prototype.initialize.call(this),this._initial_start=this.start,this._initial_end=this.end,this._initial_range_padding=this.range_padding,this._initial_range_padding_units=this.range_padding_units,this._initial_follow=this.follow,this._initial_follow_interval=this.follow_interval,this._initial_default_span=this.default_span},Object.defineProperty(t.prototype,"min",{get:function(){return Math.min(this.start,this.end)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"max",{get:function(){return Math.max(this.start,this.end)},enumerable:!0,configurable:!0}),t.prototype.computed_renderers=function(){var e=this.names,t=this.renderers;if(0==t.length)for(var i=0,n=this.plots;i<n.length;i++){var r=n[i],o=r.renderers.filter(function(t){return t instanceof h.GlyphRenderer});t=t.concat(o)}0<e.length&&(t=t.filter(function(t){return c.includes(e,t.name)})),_.logger.debug("computed "+t.length+" renderers for DataRange1d "+this.id);for(var s=0,a=t;s<a.length;s++){var l=a[s];_.logger.trace(" - "+l.type+" "+l.id)}return t},t.prototype._compute_plot_bounds=function(t,e){for(var i=u.empty(),n=0,r=t;n<r.length;n++){var o=r[n];null!=e[o.id]&&(i=u.union(i,e[o.id]))}return i},t.prototype.adjust_bounds_for_aspect=function(t,e){var i=u.empty(),n=t.maxX-t.minX;n<=0&&(n=1);var r=t.maxY-t.minY;r<=0&&(r=1);var o=.5*(t.maxX+t.minX),s=.5*(t.maxY+t.minY);return n<e*r?n=e*r:r=n/e,i.maxX=o+.5*n,i.minX=o-.5*n,i.maxY=s+.5*r,i.minY=s-.5*r,i},t.prototype._compute_min_max=function(t,e){var i,n,r,o,s=u.empty();for(var a in t){var l=t[a];s=u.union(s,l)}return 0==e?(i=[s.minX,s.maxX],r=i[0],o=i[1]):(n=[s.minY,s.maxY],r=n[0],o=n[1]),[r,o]},t.prototype._compute_range=function(t,e){var i,n,r,o=this.range_padding;if("log"==this.scale_hint){(isNaN(t)||!isFinite(t)||t<=0)&&(t=isNaN(e)||!isFinite(e)||e<=0?.1:e/100,_.logger.warn("could not determine minimum data value for log axis, DataRange1d using value "+t)),(isNaN(e)||!isFinite(e)||e<=0)&&(e=isNaN(t)||!isFinite(t)||t<=0?10:100*t,_.logger.warn("could not determine maximum data value for log axis, DataRange1d using value "+e));var s=void 0,a=void 0;if(e==t)a=this.default_span+.001,s=Math.log(t)/Math.log(10);else{var l=void 0,h=void 0;"percent"==this.range_padding_units?(l=Math.log(t)/Math.log(10),h=Math.log(e)/Math.log(10),a=(h-l)*(1+o)):(l=Math.log(t-o)/Math.log(10),h=Math.log(e+o)/Math.log(10),a=h-l),s=(l+h)/2}n=Math.pow(10,s-a/2),r=Math.pow(10,s+a/2)}else{var a=void 0;a=e==t?this.default_span:"percent"==this.range_padding_units?(e-t)*(1+o):e-t+2*o;var s=(e+t)/2;n=s-a/2,r=s+a/2}var u=1;this.flipped&&(n=(i=[r,n])[0],r=i[1],u=-1);var c=this.follow_interval;return null!=c&&Math.abs(n-r)>c&&("start"==this.follow?r=n+u*c:"end"==this.follow&&(n=r-u*c)),[n,r]},t.prototype.update=function(t,e,i,n){if(!this.have_updated_interactively){var r=this.computed_renderers(),o=this._compute_plot_bounds(r,t);null!=n&&(o=this.adjust_bounds_for_aspect(o,n)),this._plot_bounds[i]=o;var s=this._compute_min_max(this._plot_bounds,e),a=s[0],l=s[1],h=this._compute_range(a,l),u=h[0],c=h[1];null!=this._initial_start&&("log"==this.scale_hint?0<this._initial_start&&(u=this._initial_start):u=this._initial_start),null!=this._initial_end&&("log"==this.scale_hint?0<this._initial_end&&(c=this._initial_end):c=this._initial_end);var _=[this.start,this.end],p=_[0],d=_[1];if(u!=p||c!=d){var f={};u!=p&&(f.start=u),c!=d&&(f.end=c),this.setv(f)}"auto"==this.bounds&&this.setv({bounds:[u,c]},{silent:!0}),this.change.emit()}},t.prototype.reset=function(){this.have_updated_interactively=!1,this.setv({range_padding:this._initial_range_padding,range_padding_units:this._initial_range_padding_units,follow:this._initial_follow,follow_interval:this._initial_follow_interval,default_span:this._initial_default_span},{silent:!0}),this.change.emit()},t}(r.DataRange);(i.DataRange1d=s).initClass()},function(t,e,i){var n=t(391),r=t(183),o=t(15),s=t(22),b=t(21),h=t(44);function m(t,e,i){void 0===i&&(i=0);for(var n={},r=0;r<t.length;r++){var o=t[r];if(o in n)throw new Error("duplicate factor or subfactor: "+o);n[o]={value:.5+r*(1+e)+i}}return[n,(t.length-1)*e]}function x(t,s,a,e){void 0===e&&(e=0);for(var l={},h={},i=[],n=0,r=t;n<r.length;n++){var o=r[n],u=o[0],c=o[1];u in h||(h[u]=[],i.push(u)),h[u].push(c)}for(var _=e,p=0,d=function(t){var e=h[t].length,i=m(h[t],a,_),n=i[0],r=i[1];p+=r;var o=b.sum(h[t].map(function(t){return n[t].value}));l[t]={value:o/e,mapping:n},_+=e+s+r},f=0,v=i;f<v.length;f++){var u=v[f];d(u)}return[l,i,(i.length-1)*s+p]}function u(t,u,c,_,e){void 0===e&&(e=0);for(var p={},d={},i=[],n=0,r=t;n<r.length;n++){var o=r[n],s=o[0],a=o[1],l=o[2];s in d||(d[s]=[],i.push(s)),d[s].push([a,l])}for(var f=[],v=e,m=0,h=function(t){for(var e=d[t].length,i=x(d[t],c,_,v),n=i[0],r=i[1],o=i[2],s=0,a=r;s<a.length;s++){var l=a[s];f.push([t,l])}m+=o;var h=b.sum(d[t].map(function(t){var e=t[0];return n[e].value}));p[t]={value:h/e,mapping:n},v+=e+u+o},g=0,y=i;g<y.length;g++){var s=y[g];h(s)}return[p,i,f,(i.length-1)*u+m]}i.map_one_level=m,i.map_two_levels=x,i.map_three_levels=u;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="FactorRange",this.define({factors:[o.Array,[]],factor_padding:[o.Number,0],subgroup_padding:[o.Number,.8],group_padding:[o.Number,1.4],range_padding:[o.Number,0],range_padding_units:[o.PaddingUnits,"percent"],start:[o.Number],end:[o.Number]}),this.internal({levels:[o.Number],mids:[o.Array],tops:[o.Array],tops_groups:[o.Array]})},Object.defineProperty(t.prototype,"min",{get:function(){return this.start},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"max",{get:function(){return this.end},enumerable:!0,configurable:!0}),t.prototype.initialize=function(){e.prototype.initialize.call(this),this._init(!0)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.properties.factors.change,function(){return t.reset()}),this.connect(this.properties.factor_padding.change,function(){return t.reset()}),this.connect(this.properties.group_padding.change,function(){return t.reset()}),this.connect(this.properties.subgroup_padding.change,function(){return t.reset()}),this.connect(this.properties.range_padding.change,function(){return t.reset()}),this.connect(this.properties.range_padding_units.change,function(){return t.reset()})},t.prototype.reset=function(){this._init(!1),this.change.emit()},t.prototype._lookup=function(t){if(1==t.length){var e=this._mapping;return e.hasOwnProperty(t[0])?e[t[0]].value:NaN}if(2==t.length){var e=this._mapping;return e.hasOwnProperty(t[0])&&e[t[0]].mapping.hasOwnProperty(t[1])?e[t[0]].mapping[t[1]].value:NaN}if(3==t.length){var e=this._mapping;return e.hasOwnProperty(t[0])&&e[t[0]].mapping.hasOwnProperty(t[1])&&e[t[0]].mapping[t[1]].mapping.hasOwnProperty(t[2])?e[t[0]].mapping[t[1]].mapping[t[2]].value:NaN}throw new Error("unreachable code")},t.prototype.synthetic=function(t){if(h.isNumber(t))return t;if(h.isString(t))return this._lookup([t]);var e=0,i=t[t.length-1];return h.isNumber(i)&&(e=i,t=t.slice(0,-1)),this._lookup(t)+e},t.prototype.v_synthetic=function(t){var e=this;return s.map(t,function(t){return e.synthetic(t)})},t.prototype._init=function(t){var e,i,n,r,o;if(b.all(this.factors,h.isString))r=1,e=m(this.factors,this.factor_padding),this._mapping=e[0],o=e[1];else if(b.all(this.factors,function(t){return h.isArray(t)&&2==t.length&&h.isString(t[0])&&h.isString(t[1])}))r=2,i=x(this.factors,this.group_padding,this.factor_padding),this._mapping=i[0],this.tops=i[1],o=i[2];else{if(!b.all(this.factors,function(t){return h.isArray(t)&&3==t.length&&h.isString(t[0])&&h.isString(t[1])&&h.isString(t[2])}))throw new Error("???");r=3,n=u(this.factors,this.group_padding,this.subgroup_padding,this.factor_padding),this._mapping=n[0],this.tops=n[1],this.mids=n[2],o=n[3]}var s=0,a=this.factors.length+o;if("percent"==this.range_padding_units){var l=(a-s)*this.range_padding/2;s-=l,a+=l}else s-=this.range_padding,a+=this.range_padding;this.setv({start:s,end:a,levels:r},{silent:t}),"auto"==this.bounds&&this.setv({bounds:[s,a]},{silent:!0})},t}(r.Range);(i.FactorRange=a).initClass()},function(t,e,i){var n=t(179);i.DataRange=n.DataRange;var r=t(180);i.DataRange1d=r.DataRange1d;var o=t(181);i.FactorRange=o.FactorRange;var s=t(183);i.Range=s.Range;var a=t(184);i.Range1d=a.Range1d},function(t,e,i){var n=t(391),r=t(59),o=t(15),s=t(44),a=function(i){function t(t){var e=i.call(this,t)||this;return e.have_updated_interactively=!1,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="Range",this.define({callback:[o.Any],bounds:[o.Any],min_interval:[o.Any],max_interval:[o.Any]}),this.internal({plots:[o.Array,[]]})},t.prototype.connect_signals=function(){var t=this;i.prototype.connect_signals.call(this),this.connect(this.change,function(){return t._emit_callback()})},t.prototype.reset=function(){this.change.emit()},t.prototype._emit_callback=function(){null!=this.callback&&(s.isFunction(this.callback)?this.callback(this):this.callback.execute(this,{}))},Object.defineProperty(t.prototype,"is_reversed",{get:function(){return this.start>this.end},enumerable:!0,configurable:!0}),t}(r.Model);(i.Range=a).initClass()},function(t,e,i){var n=t(391),r=t(183),o=t(15),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Range1d",this.define({start:[o.Number,0],end:[o.Number,1],reset_start:[o.Number],reset_end:[o.Number]})},t.prototype._set_auto_bounds=function(){if("auto"==this.bounds){var t=Math.min(this.reset_start,this.reset_end),e=Math.max(this.reset_start,this.reset_end);this.setv({bounds:[t,e]},{silent:!0})}},t.prototype.initialize=function(){e.prototype.initialize.call(this),null==this.reset_start&&(this.reset_start=this.start),null==this.reset_end&&(this.reset_end=this.end),this._set_auto_bounds()},Object.defineProperty(t.prototype,"min",{get:function(){return Math.min(this.start,this.end)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"max",{get:function(){return Math.max(this.start,this.end)},enumerable:!0,configurable:!0}),t.prototype.reset=function(){this._set_auto_bounds(),this.start!=this.reset_start||this.end!=this.reset_end?this.setv({start:this.reset_start,end:this.reset_end}):this.change.emit()},t}(r.Range);(i.Range1d=s).initClass()},function(t,e,i){var n=t(391),r=t(189),P=t(130),o=t(199),j=t(14),s=t(15),a=t(22),N=t(21),_=t(32),l=t(181),p={fill:{},line:{}},d={fill:{fill_alpha:.3,fill_color:"grey"},line:{line_alpha:.3,line_color:"grey"}},f={fill:{fill_alpha:.2},line:{}},h=function(c){function t(){return null!==c&&c.apply(this,arguments)||this}return n.__extends(t,c),t.prototype.initialize=function(t){c.prototype.initialize.call(this,t);var i=this.model.glyph,n=N.includes(i.mixins,"fill"),r=N.includes(i.mixins,"line"),o=_.clone(i.attributes);function e(t){var e=_.clone(o);return n&&_.extend(e,t.fill),r&&_.extend(e,t.line),new i.constructor(e)}delete o.id,this.glyph=this.build_glyph_view(i);var s=this.model.selection_glyph;null==s?s=e({fill:{},line:{}}):"auto"===s&&(s=e(p)),this.selection_glyph=this.build_glyph_view(s);var a=this.model.nonselection_glyph;null==a?a=e({fill:{},line:{}}):"auto"===a&&(a=e(f)),this.nonselection_glyph=this.build_glyph_view(a);var l=this.model.hover_glyph;null!=l&&(this.hover_glyph=this.build_glyph_view(l));var h=this.model.muted_glyph;null!=h&&(this.muted_glyph=this.build_glyph_view(h));var u=e(d);this.decimated_glyph=this.build_glyph_view(u),this.xscale=this.plot_view.frame.xscales[this.model.x_range_name],this.yscale=this.plot_view.frame.yscales[this.model.y_range_name],this.set_data(!1)},t.prototype.build_glyph_view=function(t){return new t.default_view({model:t,renderer:this,plot_view:this.plot_view,parent:this})},t.prototype.connect_signals=function(){var e=this;c.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.request_render()}),this.connect(this.model.glyph.change,function(){return e.set_data()}),this.connect(this.model.data_source.change,function(){return e.set_data()}),this.connect(this.model.data_source.streaming,function(){return e.set_data()}),this.connect(this.model.data_source.patching,function(t){return e.set_data(!0,t)}),this.connect(this.model.data_source.selected.change,function(){return e.request_render()}),this.connect(this.model.data_source._select,function(){return e.request_render()}),null!=this.hover_glyph&&this.connect(this.model.data_source.inspect,function(){return e.request_render()}),this.connect(this.model.properties.view.change,function(){return e.set_data()}),this.connect(this.model.view.change,function(){return e.set_data()});var t=this.plot_model.frame,i=t.x_ranges,n=t.y_ranges;for(var r in i){var o=i[r];o instanceof l.FactorRange&&this.connect(o.change,function(){return e.set_data()})}for(var s in n){var o=n[s];o instanceof l.FactorRange&&this.connect(o.change,function(){return e.set_data()})}this.connect(this.model.glyph.transformchange,function(){return e.set_data()})},t.prototype.have_selection_glyphs=function(){return null!=this.selection_glyph&&null!=this.nonselection_glyph},t.prototype.set_data=function(t,e){void 0===t&&(t=!0),void 0===e&&(e=null);var i=Date.now(),n=this.model.data_source;this.all_indices=this.model.view.indices,this.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0}),this.glyph.set_data(n,this.all_indices,e),this.glyph.set_visuals(n),this.decimated_glyph.set_visuals(n),this.have_selection_glyphs()&&(this.selection_glyph.set_visuals(n),this.nonselection_glyph.set_visuals(n)),null!=this.hover_glyph&&this.hover_glyph.set_visuals(n),null!=this.muted_glyph&&this.muted_glyph.set_visuals(n);var r=this.plot_model.plot.lod_factor;this.decimated=[];for(var o=0,s=Math.floor(this.all_indices.length/r);o<s;o++)this.decimated.push(o*r);var a=Date.now()-i;j.logger.debug(this.glyph.model.type+" GlyphRenderer ("+this.model.id+"): set_data finished in "+a+"ms"),this.set_data_timestamp=Date.now(),t&&this.request_render()},t.prototype.render=function(){var r=this;if(this.model.visible){var t=Date.now(),e=this.glyph.glglyph;this.glyph.map_data();var i=Date.now()-t,n=Date.now(),o=this.glyph.mask_data(this.all_indices);o.length===this.all_indices.length&&(o=N.range(0,this.all_indices.length));var s=Date.now()-n,a=this.plot_view.canvas_view.ctx;a.save();var l,h=this.model.data_source.selected;l=!h||h.is_empty()?[]:this.glyph instanceof P.LineView&&h.selected_glyph===this.glyph.model?this.model.view.convert_indices_from_subset(o):h.indices;var u,c=this.model.data_source.inspected;u=c&&0!==c.length?c["0d"].glyph?this.model.view.convert_indices_from_subset(o):0<c["1d"].indices.length?c["1d"].indices:function(){for(var t=[],e=0,i=Object.keys(c["2d"].indices);e<i.length;e++){var n=i[e];t.push(parseInt(n))}return t}():[];var _,p,d,f=function(){for(var t=[],e=0,i=o;e<i.length;e++){var n=i[e];N.includes(u,r.all_indices[n])&&t.push(n)}return t}(),v=this.plot_model.plot.lod_threshold;null!=this.model.document&&0<this.model.document.interactive_duration()&&!e&&null!=v&&this.all_indices.length>v?(o=this.decimated,_=this.decimated_glyph,p=this.decimated_glyph):(_=this.model.muted&&null!=this.muted_glyph?this.muted_glyph:this.glyph,p=this.nonselection_glyph),d=this.selection_glyph,null!=this.hover_glyph&&f.length&&(o=N.difference(o,f));var m,g=null;if(l.length&&this.have_selection_glyphs()){for(var y=Date.now(),b={},x=0,w=l;x<w.length;x++){var k=w[x];b[k]=!0}var S=new Array,C=new Array;if(this.glyph instanceof P.LineView)for(var T=0,A=this.all_indices;T<A.length;T++){var k=A[T];null!=b[k]?S.push(k):C.push(k)}else for(var E=0,M=o;E<M.length;E++){var k=M[E];null!=b[this.all_indices[k]]?S.push(k):C.push(k)}g=Date.now()-y,m=Date.now(),p.render(a,C,this.glyph),d.render(a,S,this.glyph),null!=this.hover_glyph&&(this.glyph instanceof P.LineView?this.hover_glyph.render(a,this.model.view.convert_indices_from_subset(f),this.glyph):this.hover_glyph.render(a,f,this.glyph))}else m=Date.now(),this.glyph instanceof P.LineView?this.hover_glyph&&f.length?this.hover_glyph.render(a,this.model.view.convert_indices_from_subset(f),this.glyph):_.render(a,this.all_indices,this.glyph):(_.render(a,o,this.glyph),this.hover_glyph&&f.length&&this.hover_glyph.render(a,f,this.glyph));var O=Date.now()-m;this.last_dtrender=O;var z=Date.now()-t;return j.logger.debug(this.glyph.model.type+" GlyphRenderer ("+this.model.id+"): render finished in "+z+"ms"),j.logger.trace(" - map_data finished in       : "+i+"ms"),j.logger.trace(" - mask_data finished in      : "+s+"ms"),null!=g&&j.logger.trace(" - selection mask finished in : "+g+"ms"),j.logger.trace(" - glyph renders finished in  : "+O+"ms"),a.restore()}},t.prototype.draw_legend=function(t,e,i,n,r,o,s,a){null==a&&(a=this.model.get_reference_point(o,s)),this.glyph.draw_legend_for_index(t,{x0:e,x1:i,y0:n,y1:r},a)},t.prototype.hit_test=function(t){if(!this.model.visible)return null;var e=this.glyph.hit_test(t);return null==e?null:this.model.view.convert_selection_from_subset(e)},t}(r.RendererView);i.GlyphRendererView=h;var u=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="GlyphRenderer",this.prototype.default_view=h,this.define({x_range_name:[s.String,"default"],y_range_name:[s.String,"default"],data_source:[s.Instance],view:[s.Instance,function(){return new o.CDSView}],glyph:[s.Instance],hover_glyph:[s.Instance],nonselection_glyph:[s.Any,"auto"],selection_glyph:[s.Any,"auto"],muted_glyph:[s.Instance],muted:[s.Bool,!1]}),this.override({level:"glyph"})},t.prototype.initialize=function(){e.prototype.initialize.call(this),null==this.view.source&&(this.view.source=this.data_source,this.view.compute_indices())},t.prototype.get_reference_point=function(t,e){var i=0;if(null!=t){var n=this.data_source.get_column(t);if(null!=n){var r=a.indexOf(n,e);-1!=r&&(i=r)}}return i},t.prototype.get_selection_manager=function(){return this.data_source.selection_manager},t}(r.Renderer);(i.GlyphRenderer=u).initClass()},function(t,e,i){var n=t(391),r=t(189),o=t(147),s=t(15),l=t(4),a=function(a){function t(){return null!==a&&a.apply(this,arguments)||this}return n.__extends(t,a),t.prototype.initialize=function(t){var e;a.prototype.initialize.call(this,t),this.xscale=this.plot_view.frame.xscales.default,this.yscale=this.plot_view.frame.yscales.default,this._renderer_views={},e=l.build_views(this._renderer_views,[this.model.node_renderer,this.model.edge_renderer],this.plot_view.view_options()),this.node_view=e[0],this.edge_view=e[1],this.set_data()},t.prototype.connect_signals=function(){var t=this;a.prototype.connect_signals.call(this),this.connect(this.model.layout_provider.change,function(){return t.set_data()}),this.connect(this.model.node_renderer.data_source._select,function(){return t.set_data()}),this.connect(this.model.node_renderer.data_source.inspect,function(){return t.set_data()}),this.connect(this.model.node_renderer.data_source.change,function(){return t.set_data()}),this.connect(this.model.edge_renderer.data_source._select,function(){return t.set_data()}),this.connect(this.model.edge_renderer.data_source.inspect,function(){return t.set_data()}),this.connect(this.model.edge_renderer.data_source.change,function(){return t.set_data()});var e=this.plot_model.frame,i=e.x_ranges,n=e.y_ranges;for(var r in i){var o=i[r];this.connect(o.change,function(){return t.set_data()})}for(var s in n){var o=n[s];this.connect(o.change,function(){return t.set_data()})}},t.prototype.set_data=function(t){var e,i;void 0===t&&(t=!0),this.node_view.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0}),this.edge_view.glyph.model.setv({x_range_name:this.model.x_range_name,y_range_name:this.model.y_range_name},{silent:!0});var n=this.node_view.glyph;e=this.model.layout_provider.get_node_coordinates(this.model.node_renderer.data_source),n._x=e[0],n._y=e[1];var r=this.edge_view.glyph;i=this.model.layout_provider.get_edge_coordinates(this.model.edge_renderer.data_source),r._xs=i[0],r._ys=i[1],n.index_data(),r.index_data(),t&&this.request_render()},t.prototype.render=function(){this.edge_view.render(),this.node_view.render()},t}(r.RendererView);i.GraphRendererView=a;var h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="GraphRenderer",this.prototype.default_view=a,this.define({x_range_name:[s.String,"default"],y_range_name:[s.String,"default"],layout_provider:[s.Instance],node_renderer:[s.Instance],edge_renderer:[s.Instance],selection_policy:[s.Instance,function(){return new o.NodesOnly}],inspection_policy:[s.Instance,function(){return new o.NodesOnly}]}),this.override({level:"glyph"})},t.prototype.get_selection_manager=function(){return this.node_renderer.data_source.selection_manager},t}(r.Renderer);(i.GraphRenderer=h).initClass()},function(t,e,i){var n=t(391),r=t(189),o=t(15),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.RendererView);i.GuideRendererView=s;var a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="GuideRenderer",this.define({plot:[o.Instance]}),this.override({level:"overlay"})},t}(r.Renderer);(i.GuideRenderer=a).initClass()},function(t,e,i){var n=t(185);i.GlyphRenderer=n.GlyphRenderer;var r=t(186);i.GraphRenderer=r.GraphRenderer;var o=t(187);i.GuideRenderer=o.GuideRenderer;var s=t(189);i.Renderer=s.Renderer},function(t,e,i){var n=t(391),r=t(6),o=t(49),s=t(15),a=t(59),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),this.plot_view=t.plot_view,this.visuals=new o.Visuals(this.model),this._has_finished=!0},Object.defineProperty(t.prototype,"plot_model",{get:function(){return this.plot_view.model},enumerable:!0,configurable:!0}),t.prototype.request_render=function(){this.plot_view.request_render()},t.prototype.map_to_screen=function(t,e){return this.plot_view.map_to_screen(t,e,this.model.x_range_name,this.model.y_range_name)},Object.defineProperty(t.prototype,"needs_clip",{get:function(){return!1},enumerable:!0,configurable:!0}),t}(r.DOMView);i.RendererView=l;var h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Renderer",this.define({level:[s.RenderLevel],visible:[s.Bool,!0]})},t}(a.Model);(i.Renderer=h).initClass()},function(t,e,i){var n=t(391),r=t(192),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="CategoricalScale"},t.prototype.compute=function(t){return e.prototype.compute.call(this,this.source_range.synthetic(t))},t.prototype.v_compute=function(t){return e.prototype.v_compute.call(this,this.source_range.v_synthetic(t))},t}(r.LinearScale);(i.CategoricalScale=o).initClass()},function(t,e,i){var n=t(190);i.CategoricalScale=n.CategoricalScale;var r=t(192);i.LinearScale=r.LinearScale;var o=t(193);i.LogScale=o.LogScale;var s=t(194);i.Scale=s.Scale},function(t,e,i){var n=t(391),r=t(194),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="LinearScale"},t.prototype.compute=function(t){var e=this._compute_state(),i=e[0],n=e[1];return i*t+n},t.prototype.v_compute=function(t){for(var e=this._compute_state(),i=e[0],n=e[1],r=new Float64Array(t.length),o=0;o<t.length;o++)r[o]=i*t[o]+n;return r},t.prototype.invert=function(t){var e=this._compute_state(),i=e[0],n=e[1];return(t-n)/i},t.prototype.v_invert=function(t){for(var e=this._compute_state(),i=e[0],n=e[1],r=new Float64Array(t.length),o=0;o<t.length;o++)r[o]=(t[o]-n)/i;return r},t.prototype._compute_state=function(){var t=this.source_range.start,e=this.source_range.end,i=this.target_range.start,n=this.target_range.end,r=(n-i)/(e-t),o=-r*t+i;return[r,o]},t}(r.Scale);(i.LinearScale=o).initClass()},function(t,e,i){var n=t(391),r=t(194),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="LogScale"},t.prototype.compute=function(t){var e,i=this._compute_state(),n=i[0],r=i[1],o=i[2],s=i[3];if(0==o)e=0;else{var a=(Math.log(t)-s)/o;e=isFinite(a)?a*n+r:NaN}return e},t.prototype.v_compute=function(t){var e=this._compute_state(),i=e[0],n=e[1],r=e[2],o=e[3],s=new Float64Array(t.length);if(0==r)for(var a=0;a<t.length;a++)s[a]=0;else for(var a=0;a<t.length;a++){var l=(Math.log(t[a])-o)/r,h=void 0;h=isFinite(l)?l*i+n:NaN,s[a]=h}return s},t.prototype.invert=function(t){var e=this._compute_state(),i=e[0],n=e[1],r=e[2],o=e[3],s=(t-n)/i;return Math.exp(r*s+o)},t.prototype.v_invert=function(t){for(var e=this._compute_state(),i=e[0],n=e[1],r=e[2],o=e[3],s=new Float64Array(t.length),a=0;a<t.length;a++){var l=(t[a]-n)/i;s[a]=Math.exp(r*l+o)}return s},t.prototype._get_safe_factor=function(t,e){var i,n=t<0?0:t,r=e<0?0:e;if(n==r)if(0==n)n=(i=[1,10])[0],r=i[1];else{var o=Math.log(n)/Math.log(10);n=Math.pow(10,Math.floor(o)),r=Math.ceil(o)!=Math.floor(o)?Math.pow(10,Math.ceil(o)):Math.pow(10,Math.ceil(o)+1)}return[n,r]},t.prototype._compute_state=function(){var t,e,i=this.source_range.start,n=this.source_range.end,r=this.target_range.start,o=this.target_range.end,s=o-r,a=this._get_safe_factor(i,n),l=a[0],h=a[1];0==l?(t=Math.log(h),e=0):(t=Math.log(h)-Math.log(l),e=Math.log(l));var u=s,c=r;return[u,c,t,e]},t}(r.Scale);(i.LogScale=o).initClass()},function(t,e,i){var n=t(391),r=t(274),o=t(15),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Scale",this.internal({source_range:[o.Any],target_range:[o.Any]})},t.prototype.r_compute=function(t,e){return this.target_range.is_reversed?[this.compute(e),this.compute(t)]:[this.compute(t),this.compute(e)]},t.prototype.r_invert=function(t,e){return this.target_range.is_reversed?[this.invert(e),this.invert(t)]:[this.invert(t),this.invert(e)]},t}(r.Transform);(i.Scale=s).initClass()},function(t,e,i){var n=t(391);n.__exportStar(t(196),i);var r=t(197);i.Selection=r.Selection},function(t,e,i){var n=t(391),r=t(59),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.do_selection=function(t,e,i,n){return null!==t&&(e.selected.update(t,i,n),e._select.emit(),!e.selected.is_empty())},e}(r.Model);(i.SelectionPolicy=o).prototype.type="SelectionPolicy";var s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.hit_test=function(t,e){for(var i=[],n=0,r=e;n<r.length;n++){var o=r[n],s=o.hit_test(t);null!==s&&i.push(s)}if(0<i.length){for(var a=i[0],l=0,h=i;l<h.length;l++){var u=h[l];a.update_through_intersection(u)}return a}return null},e}(o);(i.IntersectRenderers=s).prototype.type="IntersectRenderers";var a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.hit_test=function(t,e){for(var i=[],n=0,r=e;n<r.length;n++){var o=r[n],s=o.hit_test(t);null!==s&&i.push(s)}if(0<i.length){for(var a=i[0],l=0,h=i;l<h.length;l++){var u=h[l];a.update_through_union(u)}return a}return null},e}(o);(i.UnionRenderers=a).prototype.type="UnionRenderers"},function(t,e,i){var n=t(391),r=t(59),o=t(15),s=t(21),a=t(32),l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Selection",this.define({indices:[o.Array,[]],line_indices:[o.Array,[]],multiline_indices:[o.Any,{}]}),this.internal({final:[o.Boolean],selected_glyphs:[o.Array,[]],get_view:[o.Any],image_indices:[o.Array,[]]})},t.prototype.initialize=function(){var t=this;e.prototype.initialize.call(this),this["0d"]={glyph:null,indices:[],flag:!1,get_view:function(){return null}},this["2d"]={indices:{}},this["1d"]={indices:this.indices},this.get_view=function(){return null},this.connect(this.properties.indices.change,function(){return t["1d"].indices=t.indices}),this.connect(this.properties.line_indices.change,function(){t["0d"].indices=t.line_indices,0==t.line_indices.length?t["0d"].flag=!1:t["0d"].flag=!0}),this.connect(this.properties.selected_glyphs.change,function(){return t["0d"].glyph=t.selected_glyph}),this.connect(this.properties.get_view.change,function(){return t["0d"].get_view=t.get_view}),this.connect(this.properties.multiline_indices.change,function(){return t["2d"].indices=t.multiline_indices})},Object.defineProperty(t.prototype,"selected_glyph",{get:function(){return 0<this.selected_glyphs.length?this.selected_glyphs[0]:null},enumerable:!0,configurable:!0}),t.prototype.add_to_selected_glyphs=function(t){this.selected_glyphs.push(t)},t.prototype.update=function(t,e,i){this.final=e,i?this.update_through_union(t):(this.indices=t.indices,this.line_indices=t.line_indices,this.selected_glyphs=t.selected_glyphs,this.get_view=t.get_view,this.multiline_indices=t.multiline_indices,this.image_indices=t.image_indices)},t.prototype.clear=function(){this.final=!0,this.indices=[],this.line_indices=[],this.multiline_indices={},this.get_view=function(){return null},this.selected_glyphs=[]},t.prototype.is_empty=function(){return 0==this.indices.length&&0==this.line_indices.length&&0==this.image_indices.length},t.prototype.update_through_union=function(t){this.indices=s.union(t.indices,this.indices),this.selected_glyphs=s.union(t.selected_glyphs,this.selected_glyphs),this.line_indices=s.union(t.line_indices,this.line_indices),this.get_view()||(this.get_view=t.get_view),this.multiline_indices=a.merge(t.multiline_indices,this.multiline_indices)},t.prototype.update_through_intersection=function(t){this.indices=s.intersection(t.indices,this.indices),this.selected_glyphs=s.union(t.selected_glyphs,this.selected_glyphs),this.line_indices=s.union(t.line_indices,this.line_indices),this.get_view()||(this.get_view=t.get_view),this.multiline_indices=a.merge(t.multiline_indices,this.multiline_indices)},t}(r.Model);(i.Selection=l).initClass()},function(t,e,i){var n=t(391),r=t(205),o=t(14),_=t(44),s=t(15),a=function(i){function t(t){var e=i.call(this,t)||this;return e.initialized=!1,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="AjaxDataSource",this.define({mode:[s.String,"replace"],content_type:[s.String,"application/json"],adapter:[s.Any],http_headers:[s.Any,{}],max_size:[s.Number],method:[s.String,"POST"],if_modified:[s.Bool,!1]})},t.prototype.destroy=function(){null!=this.interval&&clearInterval(this.interval),i.prototype.destroy.call(this)},t.prototype.setup=function(){var t=this;!this.initialized&&(this.initialized=!0,this.get_data(this.mode),this.polling_interval)&&(this.interval=setInterval(function(){return t.get_data(t.mode,t.max_size,t.if_modified)},this.polling_interval))},t.prototype.get_data=function(t,e,i){var n=this;void 0===e&&(e=0),void 0===i&&(i=!1);var r=this.prepare_request();r.addEventListener("load",function(){return n.do_load(r,t,e)}),r.addEventListener("error",function(){return n.do_error(r)}),r.send()},t.prototype.prepare_request=function(){var t=new XMLHttpRequest;t.open(this.method,this.data_url,!0),t.withCredentials=!1,t.setRequestHeader("Content-Type",this.content_type);var e=this.http_headers;for(var i in e){var n=e[i];t.setRequestHeader(i,n)}return t},t.prototype.do_load=function(t,e,i){if(200===t.status){var n=JSON.parse(t.responseText),r=this.adapter,o={};switch(o=null!=r?_.isFunction(r)?r(this,{response:n}):r.execute(this,{response:n}):n,e){case"replace":this.data=o;break;case"append":for(var s=this.data,a=0,l=this.columns();a<l.length;a++){var h=l[a],u=Array.from(s[h]),c=Array.from(o[h]);o[h]=u.concat(c).slice(-i)}this.data=o}}},t.prototype.do_error=function(t){o.logger.error("Failed to fetch JSON from "+this.data_url+" with code "+t.status)},t}(r.RemoteDataSource);(i.AjaxDataSource=a).initClass()},function(t,e,i){var n=t(391),r=t(59),o=t(15),s=t(197),a=t(21),l=t(201),h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="CDSView",this.define({filters:[o.Array,[]],source:[o.Instance]}),this.internal({indices:[o.Array,[]],indices_map:[o.Any,{}]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this.compute_indices()},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.properties.filters.change,function(){t.compute_indices(),t.change.emit()}),null!=this.source&&(null!=this.source.change&&this.connect(this.source.change,function(){return t.compute_indices()}),null!=this.source.streaming&&this.connect(this.source.streaming,function(){return t.compute_indices()}),null!=this.source.patching&&this.connect(this.source.patching,function(){return t.compute_indices()}))},t.prototype.compute_indices=function(){var e=this,r=this.filters.map(function(t){return t.compute_indices(e.source)});0<(r=function(){for(var t=[],e=0,i=r;e<i.length;e++){var n=i[e];null!=n&&t.push(n)}return t}()).length?this.indices=a.intersection.apply(this,r):this.source instanceof l.ColumnarDataSource&&(this.indices=this.source.get_indices()),this.indices_map_to_subset()},t.prototype.indices_map_to_subset=function(){this.indices_map={};for(var t=0;t<this.indices.length;t++)this.indices_map[this.indices[t]]=t},t.prototype.convert_selection_from_subset=function(t){var e=this,i=new s.Selection;i.update_through_union(t);var n=t.indices.map(function(t){return e.indices[t]});return i.indices=n,i.image_indices=t.image_indices,i},t.prototype.convert_selection_to_subset=function(t){var e=this,i=new s.Selection;i.update_through_union(t);var n=t.indices.map(function(t){return e.indices_map[t]});return i.indices=n,i.image_indices=t.image_indices,i},t.prototype.convert_indices_from_subset=function(t){var e=this;return t.map(function(t){return e.indices[t]})},t}(r.Model);(i.CDSView=h).initClass()},function(t,e,i){var n=t(391),r=t(201),o=t(8),s=t(15),k=t(29),h=t(36),S=t(44),u=t(43),c=t(32),a=t(51);function _(t,e,i){if(S.isArray(t)){var n=t.concat(e);return null!=i&&n.length>i?n.slice(-i):n}if(S.isTypedArray(t)){var r=t.length+e.length;if(null!=i&&i<r){var o=r-i,s=t.length,n=void 0;t.length<i?(n=new t.constructor(i)).set(t,0):n=t;for(var a=o,l=s;a<l;a++)n[a-o]=n[a];for(var a=0,l=e.length;a<l;a++)n[a+(s-o)]=e[a];return n}var h=new t.constructor(e);return u.concat(t,h)}throw new Error("unsupported array types")}function C(t,e){var i,n,r;return S.isNumber(t)?(r=(i=t)+1,n=1):(i=null!=t.start?t.start:0,r=null!=t.stop?t.stop:e,n=null!=t.step?t.step:1),[i,r,n]}function p(t,e,i){for(var n=new k.Set,r=!1,o=0,s=e;o<s.length;o++){var a=s[o],l=a[0],h=a[1],u=void 0,c=void 0;if(S.isArray(l)){var _=l[0];n.add(_),c=i[_],u=t[_]}else S.isNumber(l)?(h=[h],n.add(l)):r=!0,l=[0,0,l],c=[1,t.length],u=t;2===l.length&&(c=[1,c[0]],l=[l[0],0,l[1]]);for(var p=0,d=C(l[1],c[0]),f=d[0],v=d[1],m=d[2],g=C(l[2],c[1]),y=g[0],b=g[1],x=g[2],_=f;_<v;_+=m)for(var w=y;w<b;w+=x)r&&n.add(w),u[_*c[1]+w]=h[p],p++}return n}i.stream_to_column=_,i.slice=C,i.patch_to_column=p;var l=function(e){function l(t){return e.call(this,t)||this}return n.__extends(l,e),l.initClass=function(){this.prototype.type="ColumnDataSource",this.define({data:[s.Any,{}]})},l.prototype.initialize=function(){var t;e.prototype.initialize.call(this),t=h.decode_column_data(this.data),this.data=t[0],this._shapes=t[1]},l.prototype.attributes_as_json=function(t,e){void 0===t&&(t=!0),void 0===e&&(e=l._value_to_json);for(var i={},n=this.serializable_attributes(),r=0,o=c.keys(n);r<o.length;r++){var s=o[r],a=n[s];"data"===s&&(a=h.encode_column_data(a,this._shapes)),t?i[s]=a:s in this._set_after_defaults&&(i[s]=a)}return e("attributes",i,this)},l._value_to_json=function(t,e,i){return S.isPlainObject(e)&&"data"===t?h.encode_column_data(e,i._shapes):o.HasProps._value_to_json(t,e,i)},l.prototype.stream=function(t,e,i){var n=this.data;for(var r in t)n[r]=_(n[r],t[r],e);if(this.setv({data:n},{silent:!0}),this.streaming.emit(),null!=this.document){var o=new a.ColumnsStreamedEvent(this.document,this.ref(),t,e);this.document._notify_change(this,"data",null,null,{setter_id:i,hint:o})}},l.prototype.patch=function(t,e){var i=this.data,n=new k.Set;for(var r in t){var o=t[r];n=n.union(p(i[r],o,this._shapes[r]))}if(this.setv({data:i},{silent:!0}),this.patching.emit(n.values),null!=this.document){var s=new a.ColumnsPatchedEvent(this.document,this.ref(),t);this.document._notify_change(this,"data",null,null,{setter_id:e,hint:s})}},l}(r.ColumnarDataSource);(i.ColumnDataSource=l).initClass()},function(t,e,i){var n=t(391),r=t(202),o=t(19),s=t(14),a=t(17),l=t(15),h=t(44),u=t(21),c=t(32),_=t(197),p=t(196),d=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.prototype.get_array=function(t){var e=this.data[t];return null==e?this.data[t]=e=[]:h.isArray(e)||(this.data[t]=e=Array.from(e)),e},t.initClass=function(){this.prototype.type="ColumnarDataSource",this.define({selection_policy:[l.Instance,function(){return new p.UnionRenderers}]}),this.internal({selection_manager:[l.Instance,function(t){return new a.SelectionManager({source:t})}],inspected:[l.Instance,function(){return new _.Selection}],_shapes:[l.Any,{}]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this._select=new o.Signal0(this,"select"),this.inspect=new o.Signal(this,"inspect"),this.streaming=new o.Signal0(this,"streaming"),this.patching=new o.Signal(this,"patching")},t.prototype.get_column=function(t){var e=this.data[t];return null!=e?e:null},t.prototype.columns=function(){return c.keys(this.data)},t.prototype.get_length=function(t){void 0===t&&(t=!0);var e=u.uniq(c.values(this.data).map(function(t){return t.length}));switch(e.length){case 0:return null;case 1:return e[0];default:var i="data source has columns of inconsistent lengths";if(t)return s.logger.warn(i),e.sort()[0];throw new Error(i)}},t.prototype.get_indices=function(){var t=this.get_length();return u.range(0,null!=t?t:1)},t.prototype.clear=function(){for(var t={},e=0,i=this.columns();e<i.length;e++){var n=i[e];t[n]=new this.data[n].constructor}this.data=t},t}(r.DataSource);(i.ColumnarDataSource=d).initClass()},function(t,e,i){var n=t(391),r=t(59),o=t(15),s=t(44),a=t(197),l=function(i){function t(t){return i.call(this,t)||this}return n.__extends(t,i),t.initClass=function(){this.prototype.type="DataSource",this.define({selected:[o.Instance,function(){return new a.Selection}],callback:[o.Any]})},t.prototype.connect_signals=function(){var e=this;i.prototype.connect_signals.call(this),this.connect(this.properties.selected.change,function(){var t=e.callback;null!=t&&(s.isFunction(t)?t(e):t.execute(e))})},t}(r.Model);(i.DataSource=l).initClass()},function(t,e,i){var n=t(391),r=t(201),b=t(14),o=t(15),s=t(21),a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="GeoJSONDataSource",this.define({geojson:[o.Any]}),this.internal({data:[o.Any,{}]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this._update_data()},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.properties.geojson.change,function(){return t._update_data()})},t.prototype._update_data=function(){this.data=this.geojson_to_column_data()},t.prototype._get_new_list_array=function(t){return s.range(0,t).map(function(t){return[]})},t.prototype._get_new_nan_array=function(t){return s.range(0,t).map(function(t){return NaN})},t.prototype._add_properties=function(t,e,i,n){var r=t.properties||{};for(var o in r)e.hasOwnProperty(o)||(e[o]=this._get_new_nan_array(n)),e[o][i]=r[o]},t.prototype._add_geometry=function(t,e,i){function n(t){return null!=t?t:NaN}function r(t,e){return t.concat([[NaN,NaN,NaN]]).concat(e)}switch(t.type){case"Point":var o=t.coordinates,s=o[0],a=o[1],l=o[2];e.x[i]=s,e.y[i]=a,e.z[i]=n(l);break;case"LineString":for(var h=t.coordinates,u=0;u<h.length;u++){var c=h[u],s=c[0],a=c[1],l=c[2];e.xs[i][u]=s,e.ys[i][u]=a,e.zs[i][u]=n(l)}break;case"Polygon":1<t.coordinates.length&&b.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used.");for(var _=t.coordinates[0],u=0;u<_.length;u++){var p=_[u],s=p[0],a=p[1],l=p[2];e.xs[i][u]=s,e.ys[i][u]=a,e.zs[i][u]=n(l)}break;case"MultiPoint":b.logger.warn("MultiPoint not supported in Bokeh");break;case"MultiLineString":for(var h=t.coordinates.reduce(r),u=0;u<h.length;u++){var d=h[u],s=d[0],a=d[1],l=d[2];e.xs[i][u]=s,e.ys[i][u]=a,e.zs[i][u]=n(l)}break;case"MultiPolygon":for(var f=[],v=0,m=t.coordinates;v<m.length;v++){var g=m[v];1<g.length&&b.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used."),f.push(g[0])}for(var h=f.reduce(r),u=0;u<h.length;u++){var y=h[u],s=y[0],a=y[1],l=y[2];e.xs[i][u]=s,e.ys[i][u]=a,e.zs[i][u]=n(l)}break;default:throw new Error("Invalid GeoJSON geometry type: "+t.type)}},t.prototype.geojson_to_column_data=function(){var t,e=JSON.parse(this.geojson);switch(e.type){case"GeometryCollection":if(null==e.geometries)throw new Error("No geometries found in GeometryCollection");if(0===e.geometries.length)throw new Error("geojson.geometries must have one or more items");t=e.geometries;break;case"FeatureCollection":if(null==e.features)throw new Error("No features found in FeaturesCollection");if(0==e.features.length)throw new Error("geojson.features must have one or more items");t=e.features;break;default:throw new Error("Bokeh only supports type GeometryCollection and FeatureCollection at top level")}for(var i=0,n=0,r=t;n<r.length;n++){var o=r[n],s="Feature"===o.type?o.geometry:o;"GeometryCollection"==s.type?i+=s.geometries.length:i+=1}for(var a={x:this._get_new_nan_array(i),y:this._get_new_nan_array(i),z:this._get_new_nan_array(i),xs:this._get_new_list_array(i),ys:this._get_new_list_array(i),zs:this._get_new_list_array(i)},l=0,h=0,u=t;h<u.length;h++){var o=u[h],s="Feature"==o.type?o.geometry:o;if("GeometryCollection"==s.type)for(var c=0,_=s.geometries;c<_.length;c++){var p=_[c];this._add_geometry(p,a,l),"Feature"===o.type&&this._add_properties(o,a,l,i),l+=1}else this._add_geometry(s,a,l),"Feature"===o.type&&this._add_properties(o,a,l,i),l+=1}return a},t}(r.ColumnarDataSource);(i.GeoJSONDataSource=a).initClass()},function(t,e,i){var n=t(198);i.AjaxDataSource=n.AjaxDataSource;var r=t(200);i.ColumnDataSource=r.ColumnDataSource;var o=t(201);i.ColumnarDataSource=o.ColumnarDataSource;var s=t(199);i.CDSView=s.CDSView;var a=t(202);i.DataSource=a.DataSource;var l=t(203);i.GeoJSONDataSource=l.GeoJSONDataSource;var h=t(205);i.RemoteDataSource=h.RemoteDataSource},function(t,e,i){var n=t(391),r=t(200),o=t(15),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.prototype.get_column=function(t){var e=this.data[t];return null!=e?e:[]},t.prototype.initialize=function(){e.prototype.initialize.call(this),this.setup()},t.initClass=function(){this.prototype.type="RemoteDataSource",this.define({data_url:[o.String],polling_interval:[o.Number]})},t}(r.ColumnDataSource);(i.RemoteDataSource=s).initClass()},function(t,e,i){var n=t(391),r=t(210),o=t(15),v=t(21),s=function(i){function t(t){return i.call(this,t)||this}return n.__extends(t,i),t.initClass=function(){this.prototype.type="AdaptiveTicker",this.define({base:[o.Number,10],mantissas:[o.Array,[1,2,5]],min_interval:[o.Number,0],max_interval:[o.Number]})},t.prototype.initialize=function(){i.prototype.initialize.call(this);var t=v.nth(this.mantissas,-1)/this.base,e=v.nth(this.mantissas,0)*this.base;this.extended_mantissas=[t].concat(this.mantissas,[e]),this.base_factor=0===this.get_min_interval()?1:this.get_min_interval()},t.prototype.get_interval=function(t,e,i){var n,r,o,s,a,l=e-t,h=this.get_ideal_interval(t,e,i),u=Math.floor((s=h/this.base_factor,void 0===(a=this.base)&&(a=Math.E),Math.log(s)/Math.log(a))),c=Math.pow(this.base,u)*this.base_factor,_=this.extended_mantissas,p=_.map(function(t){return Math.abs(i-l/(t*c))}),d=_[v.argmin(p)],f=d*c;return n=f,r=this.get_min_interval(),o=this.get_max_interval(),Math.max(r,Math.min(o,n))},t}(r.ContinuousTicker);(i.AdaptiveTicker=s).initClass()},function(t,e,i){var n=t(391),r=t(206),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="BasicTicker"},t}(r.AdaptiveTicker);(i.BasicTicker=o).initClass()},function(t,e,i){var n=t(391),r=t(219),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="CategoricalTicker"},t.prototype.get_ticks=function(t,e,i,n,r){var o=this._collect(i.factors,i,t,e),s=this._collect(i.tops||[],i,t,e),a=this._collect(i.mids||[],i,t,e);return{major:o,minor:[],tops:s,mids:a}},t.prototype._collect=function(t,e,i,n){for(var r=[],o=0,s=t;o<s.length;o++){var a=s[o],l=e.synthetic(a);i<l&&l<n&&r.push(a)}return r},t}(r.Ticker);(i.CategoricalTicker=o).initClass()},function(t,e,i){var n=t(391),r=t(210),o=t(15),c=t(21),_=t(32),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="CompositeTicker",this.define({tickers:[o.Array,[]]})},Object.defineProperty(t.prototype,"min_intervals",{get:function(){return this.tickers.map(function(t){return t.get_min_interval()})},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"max_intervals",{get:function(){return this.tickers.map(function(t){return t.get_max_interval()})},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"min_interval",{get:function(){return this.min_intervals[0]},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"max_interval",{get:function(){return this.max_intervals[0]},enumerable:!0,configurable:!0}),t.prototype.get_best_ticker=function(t,e,i){var n,r=e-t,o=this.get_ideal_interval(t,e,i),s=[c.sortedIndex(this.min_intervals,o)-1,c.sortedIndex(this.max_intervals,o)],a=[this.min_intervals[s[0]],this.max_intervals[s[1]]],l=a.map(function(t){return Math.abs(i-r/t)});if(_.isEmpty(l.filter(function(t){return!isNaN(t)})))n=this.tickers[0];else{var h=c.argmin(l),u=s[h];n=this.tickers[u]}return n},t.prototype.get_interval=function(t,e,i){var n=this.get_best_ticker(t,e,i);return n.get_interval(t,e,i)},t.prototype.get_ticks_no_defaults=function(t,e,i,n){var r=this.get_best_ticker(t,e,n);return r.get_ticks_no_defaults(t,e,i,n)},t}(r.ContinuousTicker);(i.CompositeTicker=s).initClass()},function(t,e,i){var n=t(391),r=t(219),o=t(15),x=t(21),w=t(44),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="ContinuousTicker",this.define({num_minor_ticks:[o.Number,5],desired_num_ticks:[o.Number,6]})},t.prototype.get_ticks=function(t,e,i,n,r){return this.get_ticks_no_defaults(t,e,n,this.desired_num_ticks)},t.prototype.get_ticks_no_defaults=function(e,i,t,n){var r=this.get_interval(e,i,n),o=Math.floor(e/r),s=Math.ceil(i/r),a=(w.isStrictNaN(o)||w.isStrictNaN(s)?[]:x.range(o,s+1)).map(function(t){return t*r}).filter(function(t){return e<=t&&t<=i}),l=this.num_minor_ticks,h=[];if(0<l&&0<a.length){for(var u=r/l,c=x.range(0,l).map(function(t){return t*u}),_=0,p=c.slice(1);_<p.length;_++){var d=p[_],f=a[0]-d;e<=f&&f<=i&&h.push(f)}for(var v=0,m=a;v<m.length;v++)for(var g=m[v],y=0,b=c;y<b.length;y++){var d=b[y],f=g+d;e<=f&&f<=i&&h.push(f)}}return{major:a,minor:h}},t.prototype.get_min_interval=function(){return this.min_interval},t.prototype.get_max_interval=function(){return null!=this.max_interval?this.max_interval:1/0},t.prototype.get_ideal_interval=function(t,e,i){var n=e-t;return n/i},t}(r.Ticker);(i.ContinuousTicker=s).initClass()},function(t,e,i){var n=t(391),r=t(21),o=t(206),s=t(209),a=t(212),l=t(217),h=t(221),u=t(220),c=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="DatetimeTicker",this.override({num_minor_ticks:0,tickers:function(){return[new o.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*u.ONE_MILLI,num_minor_ticks:0}),new o.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:u.ONE_SECOND,max_interval:30*u.ONE_MINUTE,num_minor_ticks:0}),new o.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:u.ONE_HOUR,max_interval:12*u.ONE_HOUR,num_minor_ticks:0}),new a.DaysTicker({days:r.range(1,32)}),new a.DaysTicker({days:r.range(1,31,3)}),new a.DaysTicker({days:[1,8,15,22]}),new a.DaysTicker({days:[1,15]}),new l.MonthsTicker({months:r.range(0,12,1)}),new l.MonthsTicker({months:r.range(0,12,2)}),new l.MonthsTicker({months:r.range(0,12,4)}),new l.MonthsTicker({months:r.range(0,12,6)}),new h.YearsTicker({})]}})},t}(s.CompositeTicker);(i.DatetimeTicker=c).initClass()},function(t,e,i){var n=t(391),r=t(218),u=t(220),o=t(15),c=t(21),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="DaysTicker",this.define({days:[o.Array,[]]}),this.override({num_minor_ticks:0})},t.prototype.initialize=function(){e.prototype.initialize.call(this);var t=this.days;1<t.length?this.interval=(t[1]-t[0])*u.ONE_DAY:this.interval=31*u.ONE_DAY},t.prototype.get_ticks_no_defaults=function(e,i,t,n){var r=function(t,e){var i=u.last_month_no_later_than(new Date(t)),n=u.last_month_no_later_than(new Date(e));n.setUTCMonth(n.getUTCMonth()+1);for(var r=[],o=i;r.push(u.copy_date(o)),o.setUTCMonth(o.getUTCMonth()+1),!(n<o););return r}(e,i),h=this.days,o=this.interval,s=c.concat(r.map(function(t){return function(t,e){for(var i=t.getUTCMonth(),n=[],r=0,o=h;r<o.length;r++){var s=o[r],a=u.copy_date(t);a.setUTCDate(s);var l=new Date(a.getTime()+e/2);l.getUTCMonth()==i&&n.push(a)}return n}(t,o)})),a=s.map(function(t){return t.getTime()}),l=a.filter(function(t){return e<=t&&t<=i});return{major:l,minor:[]}},t}(r.SingleIntervalTicker);(i.DaysTicker=s).initClass()},function(t,e,i){var n=t(391),r=t(210),o=t(15),s=function(i){function t(t){var e=i.call(this,t)||this;return e.min_interval=0,e.max_interval=0,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="FixedTicker",this.define({ticks:[o.Array,[]],minor_ticks:[o.Array,[]]})},t.prototype.get_ticks_no_defaults=function(t,e,i,n){return{major:this.ticks,minor:this.minor_ticks}},t.prototype.get_interval=function(t,e,i){return 0},t}(r.ContinuousTicker);(i.FixedTicker=s).initClass()},function(t,e,i){var n=t(206);i.AdaptiveTicker=n.AdaptiveTicker;var r=t(207);i.BasicTicker=r.BasicTicker;var o=t(208);i.CategoricalTicker=o.CategoricalTicker;var s=t(209);i.CompositeTicker=s.CompositeTicker;var a=t(210);i.ContinuousTicker=a.ContinuousTicker;var l=t(211);i.DatetimeTicker=l.DatetimeTicker;var h=t(212);i.DaysTicker=h.DaysTicker;var u=t(213);i.FixedTicker=u.FixedTicker;var c=t(215);i.LogTicker=c.LogTicker;var _=t(216);i.MercatorTicker=_.MercatorTicker;var p=t(217);i.MonthsTicker=p.MonthsTicker;var d=t(218);i.SingleIntervalTicker=d.SingleIntervalTicker;var f=t(219);i.Ticker=f.Ticker;var v=t(221);i.YearsTicker=v.YearsTicker},function(t,e,i){var n=t(391),r=t(206),N=t(21),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="LogTicker",this.override({mantissas:[1,5]})},t.prototype.get_ticks_no_defaults=function(e,i,t,n){var r,o=this.num_minor_ticks,s=[],a=this.base,l=Math.log(e)/Math.log(a),h=Math.log(i)/Math.log(a),u=h-l;if(isFinite(u))if(u<2){var c=this.get_interval(e,i,n),_=Math.floor(e/c),p=Math.ceil(i/c);if(r=N.range(_,p+1).filter(function(t){return 0!=t}).map(function(t){return t*c}).filter(function(t){return e<=t&&t<=i}),0<o&&0<r.length){for(var d=c/o,f=N.range(0,o).map(function(t){return t*d}),v=0,m=f.slice(1);v<m.length;v++){var g=m[v];s.push(r[0]-g)}for(var y=0,b=r;y<b.length;y++)for(var x=b[y],w=0,k=f;w<k.length;w++){var g=k[w];s.push(x+g)}}}else{var S=Math.ceil(.999999*l),C=Math.floor(1.000001*h),T=Math.ceil((C-S)/9);if(r=N.range(S-1,C+1,T).map(function(t){return Math.pow(a,t)}),0<o&&0<r.length){for(var A=Math.pow(a,T)/o,f=N.range(1,o+1).map(function(t){return t*A}),E=0,M=f;E<M.length;E++){var g=M[E];s.push(r[0]/g)}s.push(r[0]);for(var O=0,z=r;O<z.length;O++)for(var x=z[O],P=0,j=f;P<j.length;P++){var g=j[P];s.push(x*g)}}}else r=[];return{major:r.filter(function(t){return e<=t&&t<=i}),minor:s.filter(function(t){return e<=t&&t<=i})}},t}(r.AdaptiveTicker);(i.LogTicker=o).initClass()},function(t,e,i){var n=t(391),r=t(207),o=t(15),M=t(33),s=function(E){function t(t){return E.call(this,t)||this}return n.__extends(t,E),t.initClass=function(){this.prototype.type="MercatorTicker",this.define({dimension:[o.LatLon]})},t.prototype.get_ticks_no_defaults=function(t,e,i,n){var r,o,s,a,l,h,u,c;if(null==this.dimension)throw new Error("MercatorTicker.dimension not configured");r=M.clip_mercator(t,e,this.dimension),t=r[0],e=r[1],"lon"===this.dimension?(o=M.wgs84_mercator.inverse([t,i]),h=o[0],c=o[1],s=M.wgs84_mercator.inverse([e,i]),u=s[0],c=s[1]):(a=M.wgs84_mercator.inverse([i,t]),c=a[0],h=a[1],l=M.wgs84_mercator.inverse([i,e]),c=l[0],u=l[1]);var _=E.prototype.get_ticks_no_defaults.call(this,h,u,i,n),p=[],d=[];if("lon"===this.dimension){for(var f=0,v=_.major;f<v.length;f++){var m=v[f];if(M.in_bounds(m,"lon")){var g=M.wgs84_mercator.forward([m,c])[0];p.push(g)}}for(var y=0,b=_.minor;y<b.length;y++){var m=b[y];if(M.in_bounds(m,"lon")){var g=M.wgs84_mercator.forward([m,c])[0];d.push(g)}}}else{for(var x=0,w=_.major;x<w.length;x++){var m=w[x];if(M.in_bounds(m,"lat")){var k=M.wgs84_mercator.forward([c,m]),S=k[1];p.push(S)}}for(var C=0,T=_.minor;C<T.length;C++){var m=T[C];if(M.in_bounds(m,"lat")){var A=M.wgs84_mercator.forward([c,m]),S=A[1];d.push(S)}}}return{major:p,minor:d}},t}(r.BasicTicker);(i.MercatorTicker=s).initClass()},function(t,e,i){var n=t(391),r=t(218),h=t(220),o=t(15),u=t(21),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="MonthsTicker",this.define({months:[o.Array,[]]})},t.prototype.initialize=function(){e.prototype.initialize.call(this);var t=this.months;1<t.length?this.interval=(t[1]-t[0])*h.ONE_MONTH:this.interval=12*h.ONE_MONTH},t.prototype.get_ticks_no_defaults=function(e,i,t,n){var r=function(t,e){var i=h.last_year_no_later_than(new Date(t)),n=h.last_year_no_later_than(new Date(e));n.setUTCFullYear(n.getUTCFullYear()+1);for(var r=[],o=i;r.push(h.copy_date(o)),o.setUTCFullYear(o.getUTCFullYear()+1),!(n<o););return r}(e,i),o=this.months,s=u.concat(r.map(function(i){return o.map(function(t){var e=h.copy_date(i);return e.setUTCMonth(t),e})})),a=s.map(function(t){return t.getTime()}),l=a.filter(function(t){return e<=t&&t<=i});return{major:l,minor:[]}},t}(r.SingleIntervalTicker);(i.MonthsTicker=s).initClass()},function(t,e,i){var n=t(391),r=t(210),o=t(15),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="SingleIntervalTicker",this.define({interval:[o.Number]})},t.prototype.get_interval=function(t,e,i){return this.interval},Object.defineProperty(t.prototype,"min_interval",{get:function(){return this.interval},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"max_interval",{get:function(){return this.interval},enumerable:!0,configurable:!0}),t}(r.ContinuousTicker);(i.SingleIntervalTicker=s).initClass()},function(t,e,i){var n=t(391),r=t(59),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Ticker"},t}(r.Model);(i.Ticker=o).initClass()},function(t,e,i){function n(t){return new Date(t.getTime())}function r(t){var e=n(t);return e.setUTCDate(1),e.setUTCHours(0),e.setUTCMinutes(0),e.setUTCSeconds(0),e.setUTCMilliseconds(0),e}i.ONE_MILLI=1,i.ONE_SECOND=1e3,i.ONE_MINUTE=60*i.ONE_SECOND,i.ONE_HOUR=60*i.ONE_MINUTE,i.ONE_DAY=24*i.ONE_HOUR,i.ONE_MONTH=30*i.ONE_DAY,i.ONE_YEAR=365*i.ONE_DAY,i.copy_date=n,i.last_month_no_later_than=r,i.last_year_no_later_than=function(t){var e=r(t);return e.setUTCMonth(0),e}},function(t,e,i){var n=t(391),r=t(207),o=t(218),h=t(220),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="YearsTicker"},t.prototype.initialize=function(){e.prototype.initialize.call(this),this.interval=h.ONE_YEAR,this.basic_ticker=new r.BasicTicker({num_minor_ticks:0})},t.prototype.get_ticks_no_defaults=function(e,i,t,n){var r=h.last_year_no_later_than(new Date(e)).getUTCFullYear(),o=h.last_year_no_later_than(new Date(i)).getUTCFullYear(),s=this.basic_ticker.get_ticks_no_defaults(r,o,t,n).major,a=s.map(function(t){return Date.UTC(t,0,1)}),l=a.filter(function(t){return e<=t&&t<=i});return{major:l,minor:[]}},t}(o.SingleIntervalTicker);(i.YearsTicker=s).initClass()},function(t,e,i){var n=t(391),r=t(225),o=t(15),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="BBoxTileSource",this.define({use_latlon:[o.Bool,!1]})},t.prototype.get_image_url=function(t,e,i){var n,r,o,s,a,l,h=this.string_lookup_replace(this.url,this.extra_url_vars);return this.use_latlon?(n=this.get_tile_geographic_bounds(t,e,i),s=n[0],l=n[1],o=n[2],a=n[3]):(r=this.get_tile_meter_bounds(t,e,i),s=r[0],l=r[1],o=r[2],a=r[3]),h.replace("{XMIN}",s.toString()).replace("{YMIN}",l.toString()).replace("{XMAX}",o.toString()).replace("{YMAX}",a.toString())},t}(r.MercatorTileSource);(i.BBoxTileSource=s).initClass()},function(t,e,i){var n=t(44),r=function(){function t(){this.images=[]}return t.prototype.pop=function(){var t=this.images.pop();return null!=t?t:new Image},t.prototype.push=function(t){var e;50<this.images.length||(n.isArray(t)?(e=this.images).push.apply(e,t):this.images.push(t))},t}();i.ImagePool=r},function(t,e,i){var n=t(222);i.BBoxTileSource=n.BBoxTileSource;var r=t(225);i.MercatorTileSource=r.MercatorTileSource;var o=t(226);i.QUADKEYTileSource=o.QUADKEYTileSource;var s=t(227);i.TileRenderer=s.TileRenderer;var a=t(228);i.TileSource=a.TileSource;var l=t(230);i.TMSTileSource=l.TMSTileSource;var h=t(231);i.WMTSTileSource=h.WMTSTileSource},function(t,e,i){var n=t(391),r=t(228),o=t(15),s=t(21),h=t(229),a=function(i){function t(t){return i.call(this,t)||this}return n.__extends(t,i),t.initClass=function(){this.prototype.type="MercatorTileSource",this.define({snap_to_zoom:[o.Bool,!1],wrap_around:[o.Bool,!0]}),this.override({x_origin_offset:20037508.34,y_origin_offset:20037508.34,initial_resolution:156543.03392804097})},t.prototype.initialize=function(){var e=this;i.prototype.initialize.call(this),this._resolutions=s.range(this.min_zoom,this.max_zoom+1).map(function(t){return e.get_resolution(t)})},t.prototype._computed_initial_resolution=function(){return null!=this.initial_resolution?this.initial_resolution:2*Math.PI*6378137/this.tile_size},t.prototype.is_valid_tile=function(t,e,i){return!(!this.wrap_around&&(t<0||t>=Math.pow(2,i))||e<0||e>=Math.pow(2,i))},t.prototype.parent_by_tile_xyz=function(t,e,i){var n=this.tile_xyz_to_quadkey(t,e,i),r=n.substring(0,n.length-1);return this.quadkey_to_tile_xyz(r)},t.prototype.get_resolution=function(t){return this._computed_initial_resolution()/Math.pow(2,t)},t.prototype.get_resolution_by_extent=function(t,e,i){var n=(t[2]-t[0])/i,r=(t[3]-t[1])/e;return[n,r]},t.prototype.get_level_by_extent=function(t,e,i){for(var n=(t[2]-t[0])/i,r=(t[3]-t[1])/e,o=Math.max(n,r),s=0,a=0,l=this._resolutions;a<l.length;a++){var h=l[a];if(h<o){if(0==s)return 0;if(0<s)return s-1}s+=1}return s-1},t.prototype.get_closest_level_by_extent=function(t,e,i){var n=(t[2]-t[0])/i,r=(t[3]-t[1])/e,o=Math.max(n,r),s=this._resolutions.reduce(function(t,e){return Math.abs(e-o)<Math.abs(t-o)?e:t});return this._resolutions.indexOf(s)},t.prototype.snap_to_zoom_level=function(t,e,i,n){var r=t[0],o=t[1],s=t[2],a=t[3],l=this._resolutions[n],h=i*l,u=e*l;if(!this.snap_to_zoom){var c=(s-r)/h,_=(a-o)/u;_<c?(h=s-r,u*=c):(h*=_,u=a-o)}var p=(h-(s-r))/2,d=(u-(a-o))/2;return[r-p,o-d,s+p,a+d]},t.prototype.tms_to_wmts=function(t,e,i){"Note this works both ways";return[t,Math.pow(2,i)-1-e,i]},t.prototype.wmts_to_tms=function(t,e,i){"Note this works both ways";return[t,Math.pow(2,i)-1-e,i]},t.prototype.pixels_to_meters=function(t,e,i){var n=this.get_resolution(i),r=t*n-this.x_origin_offset,o=e*n-this.y_origin_offset;return[r,o]},t.prototype.meters_to_pixels=function(t,e,i){var n=this.get_resolution(i),r=(t+this.x_origin_offset)/n,o=(e+this.y_origin_offset)/n;return[r,o]},t.prototype.pixels_to_tile=function(t,e){var i=Math.ceil(t/this.tile_size);i=0===i?i:i-1;var n=Math.max(Math.ceil(e/this.tile_size)-1,0);return[i,n]},t.prototype.pixels_to_raster=function(t,e,i){var n=this.tile_size<<i;return[t,n-e]},t.prototype.meters_to_tile=function(t,e,i){var n=this.meters_to_pixels(t,e,i),r=n[0],o=n[1];return this.pixels_to_tile(r,o)},t.prototype.get_tile_meter_bounds=function(t,e,i){var n=this.pixels_to_meters(t*this.tile_size,e*this.tile_size,i),r=n[0],o=n[1],s=this.pixels_to_meters((t+1)*this.tile_size,(e+1)*this.tile_size,i),a=s[0],l=s[1];return[r,o,a,l]},t.prototype.get_tile_geographic_bounds=function(t,e,i){var n=this.get_tile_meter_bounds(t,e,i),r=h.meters_extent_to_geographic(n),o=r[0],s=r[1],a=r[2],l=r[3];return[o,s,a,l]},t.prototype.get_tiles_by_extent=function(t,e,i){void 0===i&&(i=1);var n=t[0],r=t[1],o=t[2],s=t[3],a=this.meters_to_tile(n,r,e),l=a[0],h=a[1],u=this.meters_to_tile(o,s,e),c=u[0],_=u[1];l-=i,h-=i,c+=i;for(var p=[],d=_+=i;h<=d;d--)for(var f=l;f<=c;f++)this.is_valid_tile(f,d,e)&&p.push([f,d,e,this.get_tile_meter_bounds(f,d,e)]);return this.sort_tiles_from_center(p,[l,h,c,_]),p},t.prototype.quadkey_to_tile_xyz=function(t){for(var e=0,i=0,n=t.length,r=n;0<r;r--){var o=t.charAt(n-r),s=1<<r-1;switch(o){case"0":continue;case"1":e|=s;break;case"2":i|=s;break;case"3":e|=s,i|=s;break;default:throw new TypeError("Invalid Quadkey: "+t)}}return[e,i,n]},t.prototype.tile_xyz_to_quadkey=function(t,e,i){for(var n="",r=i;0<r;r--){var o=1<<r-1,s=0;0!=(t&o)&&(s+=1),0!=(e&o)&&(s+=2),n+=s.toString()}return n},t.prototype.children_by_tile_xyz=function(t,e,i){for(var n=this.tile_xyz_to_quadkey(t,e,i),r=[],o=0;o<=3;o++){var s=this.quadkey_to_tile_xyz(n+o.toString()),a=s[0],l=s[1],h=s[2],u=this.get_tile_meter_bounds(a,l,h);r.push([a,l,h,u])}return r},t.prototype.get_closest_parent_by_tile_xyz=function(t,e,i){var n,r,o,s=this.calculate_world_x_by_tile_xyz(t,e,i);n=this.normalize_xyz(t,e,i),t=n[0],e=n[1],i=n[2];for(var a=this.tile_xyz_to_quadkey(t,e,i);0<a.length;)if(a=a.substring(0,a.length-1),r=this.quadkey_to_tile_xyz(a),t=r[0],e=r[1],i=r[2],o=this.denormalize_xyz(t,e,i,s),t=o[0],e=o[1],i=o[2],this.tile_xyz_to_key(t,e,i)in this.tiles)return[t,e,i];return[0,0,0]},t.prototype.normalize_xyz=function(t,e,i){if(this.wrap_around){var n=Math.pow(2,i);return[(t%n+n)%n,e,i]}return[t,e,i]},t.prototype.denormalize_xyz=function(t,e,i,n){return[t+n*Math.pow(2,i),e,i]},t.prototype.denormalize_meters=function(t,e,i,n){return[t+2*n*Math.PI*6378137,e]},t.prototype.calculate_world_x_by_tile_xyz=function(t,e,i){return Math.floor(t/Math.pow(2,i))},t}(r.TileSource);(i.MercatorTileSource=a).initClass()},function(t,e,i){var n=t(391),r=t(225),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="QUADKEYTileSource"},t.prototype.get_image_url=function(t,e,i){var n=this.string_lookup_replace(this.url,this.extra_url_vars),r=this.tms_to_wmts(t,e,i),o=r[0],s=r[1],a=r[2],l=this.tile_xyz_to_quadkey(o,s,a);return n.replace("{Q}",l)},t}(r.MercatorTileSource);(i.QUADKEYTileSource=o).initClass()},function(t,e,i){var r=t(391),o=t(223),n=t(231),s=t(189),a=t(184),l=t(5),h=t(15),I=t(21),u=t(44),c=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(t,n),t.prototype.initialize=function(t){this.attributionEl=null,this._tiles=[],n.prototype.initialize.call(this,t)},t.prototype.connect_signals=function(){var t=this;n.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.request_render()})},t.prototype.get_extent=function(){return[this.x_range.start,this.y_range.start,this.x_range.end,this.y_range.end]},Object.defineProperty(t.prototype,"map_plot",{get:function(){return this.plot_model.plot},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"map_canvas",{get:function(){return this.plot_view.canvas_view.ctx},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"map_frame",{get:function(){return this.plot_model.frame},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"x_range",{get:function(){return this.map_plot.x_range},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"y_range",{get:function(){return this.map_plot.y_range},enumerable:!0,configurable:!0}),t.prototype._set_data=function(){this.pool=new o.ImagePool,this.extent=this.get_extent(),this._last_height=void 0,this._last_width=void 0},t.prototype._add_attribution=function(){var t=this.model.tile_source.attribution;if(u.isString(t)&&0<t.length){if(null==this.attributionEl){var e=this.plot_model.canvas._right.value-this.plot_model.frame._right.value,i=this.plot_model.canvas._bottom.value-this.plot_model.frame._bottom.value,n=this.map_frame._width.value;this.attributionEl=l.div({class:"bk-tile-attribution",style:{position:"absolute",bottom:i+"px",right:e+"px","max-width":n-4+"px",padding:"2px","background-color":"rgba(255,255,255,0.5)","font-size":"7pt","font-family":"sans-serif","line-height":"1.05","white-space":"nowrap",overflow:"hidden","text-overflow":"ellipsis"}});var r=this.plot_view.canvas_view.events_el;r.appendChild(this.attributionEl)}this.attributionEl.innerHTML=t,this.attributionEl.title=this.attributionEl.textContent.replace(/\s*\n\s*/g," ")}},t.prototype._map_data=function(){this.initial_extent=this.get_extent();var t=this.model.tile_source.get_level_by_extent(this.initial_extent,this.map_frame._height.value,this.map_frame._width.value),e=this.model.tile_source.snap_to_zoom_level(this.initial_extent,this.map_frame._height.value,this.map_frame._width.value,t);this.x_range.start=e[0],this.y_range.start=e[1],this.x_range.end=e[2],this.y_range.end=e[3],this.x_range instanceof a.Range1d&&(this.x_range.reset_start=e[0],this.x_range.reset_end=e[2]),this.y_range instanceof a.Range1d&&(this.y_range.reset_start=e[1],this.y_range.reset_end=e[3]),this._add_attribution()},t.prototype._on_tile_load=function(t,e){t.img=e.target,t.loaded=!0,this.request_render()},t.prototype._on_tile_cache_load=function(t,e){t.img=e.target,t.loaded=!0,t.finished=!0,this.notify_finished()},t.prototype._on_tile_error=function(t){t.finished=!0},t.prototype._create_tile=function(t,e,i,n,r){void 0===r&&(r=!1);var o=this.model.tile_source.normalize_xyz(t,e,i),s=o[0],a=o[1],l=o[2],h=this.pool.pop(),u={img:h,tile_coords:[t,e,i],normalized_coords:[s,a,l],quadkey:this.model.tile_source.tile_xyz_to_quadkey(t,e,i),cache_key:this.model.tile_source.tile_xyz_to_key(t,e,i),bounds:n,loaded:!1,finished:!1,x_coord:n[0],y_coord:n[3]};h.onload=r?this._on_tile_cache_load.bind(this,u):this._on_tile_load.bind(this,u),h.onerror=this._on_tile_error.bind(this,u),h.alt="",h.src=this.model.tile_source.get_image_url(s,a,l),this.model.tile_source.tiles[u.cache_key]=u,this._tiles.push(u)},t.prototype._enforce_aspect_ratio=function(){if(this._last_height!==this.map_frame._height.value||this._last_width!==this.map_frame._width.value){var t=this.get_extent(),e=this.model.tile_source.get_level_by_extent(t,this.map_frame._height.value,this.map_frame._width.value),i=this.model.tile_source.snap_to_zoom_level(t,this.map_frame._height.value,this.map_frame._width.value,e);this.x_range.setv({start:i[0],end:i[2]}),this.y_range.setv({start:i[1],end:i[3]}),this.extent=i,this._last_height=this.map_frame._height.value,this._last_width=this.map_frame._width.value}},t.prototype.has_finished=function(){if(!n.prototype.has_finished.call(this))return!1;if(0===this._tiles.length)return!1;for(var t=0,e=this._tiles;t<e.length;t++){var i=e[t];if(!i.finished)return!1}return!0},t.prototype.render=function(){null==this.map_initialized&&(this._set_data(),this._map_data(),this.map_initialized=!0),this._enforce_aspect_ratio(),this._update(),null!=this.prefetch_timer&&clearTimeout(this.prefetch_timer),this.prefetch_timer=setTimeout(this._prefetch_tiles.bind(this),500),this.has_finished()&&this.notify_finished()},t.prototype._draw_tile=function(t){var e=this.model.tile_source.tiles[t];if(null!=e){var i=this.plot_view.map_to_screen([e.bounds[0]],[e.bounds[3]]),n=i[0][0],r=i[1][0],o=this.plot_view.map_to_screen([e.bounds[2]],[e.bounds[1]]),s=o[0][0],a=o[1][0],l=s-n,h=a-r,u=n,c=r,_=this.map_canvas.getImageSmoothingEnabled();this.map_canvas.setImageSmoothingEnabled(this.model.smoothing),this.map_canvas.drawImage(e.img,u,c,l,h),this.map_canvas.setImageSmoothingEnabled(_),e.finished=!0}},t.prototype._set_rect=function(){var t=this.plot_model.plot.properties.outline_line_width.value(),e=this.map_frame._left.value+t/2,i=this.map_frame._top.value+t/2,n=this.map_frame._width.value-t,r=this.map_frame._height.value-t;this.map_canvas.rect(e,i,n,r),this.map_canvas.clip()},t.prototype._render_tiles=function(t){this.map_canvas.save(),this._set_rect(),this.map_canvas.globalAlpha=this.model.alpha;for(var e=0,i=t;e<i.length;e++){var n=i[e];this._draw_tile(n)}this.map_canvas.restore()},t.prototype._prefetch_tiles=function(){for(var t=this.model.tile_source,e=this.get_extent(),i=this.map_frame._height.value,n=this.map_frame._width.value,r=this.model.tile_source.get_level_by_extent(e,i,n),o=this.model.tile_source.get_tiles_by_extent(e,r),s=0,a=Math.min(10,o.length);s<a;s++)for(var l=o[s],h=l[0],u=l[1],c=l[2],_=this.model.tile_source.children_by_tile_xyz(h,u,c),p=0,d=_;p<d.length;p++){var f=d[p],v=f[0],m=f[1],g=f[2],y=f[3];t.tile_xyz_to_key(v,m,g)in t.tiles||this._create_tile(v,m,g,y,!0)}},t.prototype._fetch_tiles=function(t){for(var e=0,i=t;e<i.length;e++){var n=i[e],r=n[0],o=n[1],s=n[2],a=n[3];this._create_tile(r,o,s,a)}},t.prototype._update=function(){var t=this,e=this.model.tile_source,i=e.min_zoom,n=e.max_zoom,r=this.get_extent(),o=this.extent[2]-this.extent[0]<r[2]-r[0],s=this.map_frame._height.value,a=this.map_frame._width.value,l=e.get_level_by_extent(r,s,a),h=!1;l<i?(r=this.extent,l=i,h=!0):n<l&&(r=this.extent,l=n,h=!0),h&&(this.x_range.setv({x_range:{start:r[0],end:r[2]}}),this.y_range.setv({start:r[1],end:r[3]}),this.extent=r),this.extent=r;for(var u=e.get_tiles_by_extent(r,l),c=[],_=[],p=[],d=[],f=0,v=u;f<v.length;f++){var m=v[f],g=m[0],y=m[1],b=m[2],x=e.tile_xyz_to_key(g,y,b),w=e.tiles[x];if(null!=w&&w.loaded)_.push(x);else if(this.model.render_parents){var k=e.get_closest_parent_by_tile_xyz(g,y,b),S=k[0],C=k[1],T=k[2],A=e.tile_xyz_to_key(S,C,T),E=e.tiles[A];if(null!=E&&E.loaded&&!I.includes(p,A)&&p.push(A),o)for(var M=e.children_by_tile_xyz(g,y,b),O=0,z=M;O<z.length;O++){var P=z[O],j=P[0],N=P[1],F=P[2],D=e.tile_xyz_to_key(j,N,F);D in e.tiles&&d.push(D)}}null==w&&c.push(m)}this._render_tiles(p),this._render_tiles(d),this._render_tiles(_),null!=this.render_timer&&clearTimeout(this.render_timer),this.render_timer=setTimeout(function(){return t._fetch_tiles(c)},65)},t}(s.RendererView);i.TileRendererView=c;var _=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.initClass=function(){this.prototype.type="TileRenderer",this.prototype.default_view=c,this.define({alpha:[h.Number,1],x_range_name:[h.String,"default"],y_range_name:[h.String,"default"],smoothing:[h.Bool,!0],tile_source:[h.Instance,function(){return new n.WMTSTileSource}],render_parents:[h.Bool,!0]}),this.override({level:"underlay"})},t}(s.Renderer);(i.TileRenderer=_).initClass()},function(t,e,i){var n=t(391),r=t(59),o=t(223),s=t(15),a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="TileSource",this.define({url:[s.String,""],tile_size:[s.Number,256],max_zoom:[s.Number,30],min_zoom:[s.Number,0],extra_url_vars:[s.Any,{}],attribution:[s.String,""],x_origin_offset:[s.Number],y_origin_offset:[s.Number],initial_resolution:[s.Number]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this.tiles={},this.pool=new o.ImagePool,this._normalize_case()},t.prototype.string_lookup_replace=function(t,e){var i=t;for(var n in e){var r=e[n];i=i.replace("{"+n+"}",r)}return i},t.prototype._normalize_case=function(){var t=this.url.replace("{x}","{X}").replace("{y}","{Y}").replace("{z}","{Z}").replace("{q}","{Q}").replace("{xmin}","{XMIN}").replace("{ymin}","{YMIN}").replace("{xmax}","{XMAX}").replace("{ymax}","{YMAX}");this.url=t},t.prototype.tile_xyz_to_key=function(t,e,i){return t+":"+e+":"+i},t.prototype.key_to_tile_xyz=function(t){var e=t.split(":").map(function(t){return parseInt(t)}),i=e[0],n=e[1],r=e[2];return[i,n,r]},t.prototype.sort_tiles_from_center=function(t,e){var i=e[0],n=e[1],r=e[2],o=e[3],s=(r-i)/2+i,a=(o-n)/2+n;t.sort(function(t,e){var i=Math.sqrt(Math.pow(s-t[0],2)+Math.pow(a-t[1],2)),n=Math.sqrt(Math.pow(s-e[0],2)+Math.pow(a-e[1],2));return i-n})},t.prototype.get_image_url=function(t,e,i){var n=this.string_lookup_replace(this.url,this.extra_url_vars);return n.replace("{X}",t.toString()).replace("{Y}",e.toString()).replace("{Z}",i.toString())},t}(r.Model);(i.TileSource=a).initClass()},function(t,e,i){var n=t(33);function c(t,e){return n.wgs84_mercator.forward([t,e])}function _(t,e){return n.wgs84_mercator.inverse([t,e])}i.geographic_to_meters=c,i.meters_to_geographic=_,i.geographic_extent_to_meters=function(t){var e=t[0],i=t[1],n=t[2],r=t[3],o=c(e,i),s=o[0],a=o[1],l=c(n,r),h=l[0],u=l[1];return[s,a,h,u]},i.meters_extent_to_geographic=function(t){var e=t[0],i=t[1],n=t[2],r=t[3],o=_(e,i),s=o[0],a=o[1],l=_(n,r),h=l[0],u=l[1];return[s,a,h,u]}},function(t,e,i){var n=t(391),r=t(225),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="TMSTileSource"},t.prototype.get_image_url=function(t,e,i){var n=this.string_lookup_replace(this.url,this.extra_url_vars);return n.replace("{X}",t.toString()).replace("{Y}",e.toString()).replace("{Z}",i.toString())},t}(r.MercatorTileSource);(i.TMSTileSource=o).initClass()},function(t,e,i){var n=t(391),r=t(225),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="WMTSTileSource"},t.prototype.get_image_url=function(t,e,i){var n=this.string_lookup_replace(this.url,this.extra_url_vars),r=this.tms_to_wmts(t,e,i),o=r[0],s=r[1],a=r[2];return n.replace("{X}",o.toString()).replace("{Y}",s.toString()).replace("{Z}",a.toString())},t}(r.MercatorTileSource);(i.WMTSTileSource=o).initClass()},function(t,e,i){var n=t(391),r=t(241),o=t(19),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._clicked=function(){this.model.do.emit()},e}(r.ButtonToolButtonView);i.ActionToolButtonView=s;var a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.do,function(){return t.doit()})},t}(r.ButtonToolView);i.ActionToolView=a;var l=function(i){function t(t){var e=i.call(this,t)||this;return e.button_view=s,e.do=new o.Signal0(e,"do"),e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="ActionTool"},t}(r.ButtonTool);(i.ActionTool=l).initClass()},function(t,e,i){var n=t(391),r=t(232),o=t(15),s=t(44),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat("bk-toolbar-button-custom-action")},e}(r.ActionToolButtonView);i.CustomActionButtonView=a;var l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.doit=function(){var t=this.model.callback;s.isFunction(t)?t(this,{}):t.execute(this,{})},e}(r.ActionToolView);i.CustomActionView=l;var h=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Custom Action",e.button_view=a,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="CustomAction",this.prototype.default_view=l,this.define({action_tooltip:[o.String,"Perform a Custom Action"],callback:[o.Any],icon:[o.String]})},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this.action_tooltip},enumerable:!0,configurable:!0}),t}(r.ActionTool);(i.CustomAction=h).initClass()},function(t,e,i){var n=t(391),r=t(232),o=t(15),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.doit=function(){window.open(this.model.redirect)},e}(r.ActionToolView);i.HelpToolView=s;var a=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Help",e.icon="bk-tool-icon-help",e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="HelpTool",this.prototype.default_view=s,this.define({help_tooltip:[o.String,"Click the question mark to learn more about Bokeh plot tools."],redirect:[o.String,"https://bokeh.pydata.org/en/latest/docs/user_guide/tools.html#built-in-tools"]})},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this.help_tooltip},enumerable:!0,configurable:!0}),t}(r.ActionTool);(i.HelpTool=a).initClass()},function(t,e,i){var n=t(391),r=t(232),o=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.plot_view.state_changed,function(){return t.model.disabled=!t.plot_view.can_redo()})},t.prototype.doit=function(){this.plot_view.redo()},t}(r.ActionToolView);i.RedoToolView=o;var s=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Redo",e.icon="bk-tool-icon-redo",e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="RedoTool",this.prototype.default_view=o,this.override({disabled:!0})},t}(r.ActionTool);(i.RedoTool=s).initClass()},function(t,e,i){var n=t(391),r=t(232),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.doit=function(){this.plot_view.reset()},e}(r.ActionToolView);i.ResetToolView=o;var s=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Reset",e.icon="bk-tool-icon-reset",e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="ResetTool",this.prototype.default_view=o},t}(r.ActionTool);(i.ResetTool=s).initClass()},function(t,e,i){var n=t(391),r=t(232),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.doit=function(){this.plot_view.save("bokeh_plot")},e}(r.ActionToolView);i.SaveToolView=o;var s=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Save",e.icon="bk-tool-icon-save",e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="SaveTool",this.prototype.default_view=o},t}(r.ActionTool);(i.SaveTool=s).initClass()},function(t,e,i){var n=t(391),r=t(232),o=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.plot_view.state_changed,function(){return t.model.disabled=!t.plot_view.can_undo()})},t.prototype.doit=function(){this.plot_view.undo()},t}(r.ActionToolView);i.UndoToolView=o;var s=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Undo",e.icon="bk-tool-icon-undo",e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="UndoTool",this.prototype.default_view=o,this.override({disabled:!0})},t}(r.ActionTool);(i.UndoTool=s).initClass()},function(t,e,i){var n=t(391),r=t(232),o=t(46),s=t(15),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.doit=function(){var t=this.plot_model.frame,e=this.model.dimensions,i="width"==e||"both"==e,n="height"==e||"both"==e,r=o.scale_range(t,this.model.factor,i,n);this.plot_view.push_state("zoom_out",{range:r}),this.plot_view.update_range(r,!1,!0),this.model.document&&this.model.document.interactive_start(this.plot_model.plot)},e}(r.ActionToolView);i.ZoomInToolView=a;var l=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Zoom In",e.icon="bk-tool-icon-zoom-in",e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="ZoomInTool",this.prototype.default_view=a,this.define({factor:[s.Percent,.1],dimensions:[s.Dimensions,"both"]})},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),t}(r.ActionTool);(i.ZoomInTool=l).initClass()},function(t,e,i){var n=t(391),r=t(232),o=t(46),s=t(15),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.doit=function(){var t=this.plot_model.frame,e=this.model.dimensions,i="width"==e||"both"==e,n="height"==e||"both"==e,r=o.scale_range(t,-this.model.factor,i,n);this.plot_view.push_state("zoom_out",{range:r}),this.plot_view.update_range(r,!1,!0),this.model.document&&this.model.document.interactive_start(this.plot_model.plot)},e}(r.ActionToolView);i.ZoomOutToolView=a;var l=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Zoom Out",e.icon="bk-tool-icon-zoom-out",e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="ZoomOutTool",this.prototype.default_view=a,this.define({factor:[s.Percent,.1],dimensions:[s.Dimensions,"both"]})},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),t}(r.ActionTool);(i.ZoomOutTool=l).initClass()},function(t,e,i){var n=t(391),r=t(6),o=t(266),s=t(5),a=t(15),l=t(38),h=t(44),u=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return n.__extends(t,i),t.prototype.initialize=function(t){var e=this;i.prototype.initialize.call(this,t),this.connect(this.model.change,function(){return e.render()}),this.el.addEventListener("click",function(){return e._clicked()}),this.render()},t.prototype.css_classes=function(){return i.prototype.css_classes.call(this).concat("bk-toolbar-button")},t.prototype.render=function(){s.empty(this.el);var t=this.model.computed_icon;h.isString(t)&&(l.startsWith(t,"data:image")?this.el.style.backgroundImage="url('"+t+"')":this.el.classList.add(t)),this.el.title=this.model.tooltip},t}(r.DOMView);i.ButtonToolButtonView=u;var c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(o.ToolView);i.ButtonToolView=c;var _=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="ButtonTool",this.internal({disabled:[a.Boolean,!1]})},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this.tool_name},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"computed_icon",{get:function(){return this.icon},enumerable:!0,configurable:!0}),t}(o.Tool);(i.ButtonTool=_).initClass()},function(t,e,i){var n=t(391),o=t(5),r=t(15),s=t(243),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._tap=function(t){if(null==this._draw_basepoint&&null==this._basepoint){var e=t.shiftKey;this._select_event(t,e,this.model.renderers)}},e.prototype._keyup=function(t){if(this.model.active&&this._mouse_in_frame)for(var e=0,i=this.model.renderers;e<i.length;e++){var n=i[e];if(t.keyCode===o.Keys.Backspace)this._delete_selected(n);else if(t.keyCode==o.Keys.Esc){var r=n.data_source;r.selection_manager.clear()}}},e.prototype._set_extent=function(t,e,i,n){var r=t[0],o=t[1],s=e[0],a=e[1];void 0===n&&(n=!1);var l=this.model.renderers[0],h=this.plot_model.frame,u=l.glyph,c=l.data_source,_=h.xscales[l.x_range_name],p=h.yscales[l.y_range_name],d=_.r_invert(r,o),f=d[0],v=d[1],m=p.r_invert(s,a),g=m[0],y=m[1],b=[(f+v)/2,(g+y)/2],x=b[0],w=b[1],k=[v-f,y-g],S=k[0],C=k[1],T=[u.x.field,u.y.field],A=T[0],E=T[1],M=[u.width.field,u.height.field],O=M[0],z=M[1];if(i)this._pop_glyphs(c,this.model.num_objects),A&&c.get_array(A).push(x),E&&c.get_array(E).push(w),O&&c.get_array(O).push(S),z&&c.get_array(z).push(C),this._pad_empty_columns(c,[A,E,O,z]);else{var P=c.data[A].length-1;A&&(c.data[A][P]=x),E&&(c.data[E][P]=w),O&&(c.data[O][P]=S),z&&(c.data[z][P]=C)}this._emit_cds_changes(c,!0,!1,n)},e.prototype._update_box=function(t,e,i){if(void 0===e&&(e=!1),void 0===i&&(i=!1),null!=this._draw_basepoint){var n=[t.sx,t.sy],r=this.plot_model.frame,o=this.model.dimensions,s=this.model._get_dim_limits(this._draw_basepoint,n,r,o);if(null!=s){var a=s[0],l=s[1];this._set_extent(a,l,e,i)}}},e.prototype._doubletap=function(t){this.model.active&&(null!=this._draw_basepoint?(this._update_box(t,!1,!0),this._draw_basepoint=null):(this._draw_basepoint=[t.sx,t.sy],this._select_event(t,!0,this.model.renderers),this._update_box(t,!0,!1)))},e.prototype._move=function(t){this._update_box(t,!1,!1)},e.prototype._pan_start=function(t){if(t.shiftKey){if(null!=this._draw_basepoint)return;this._draw_basepoint=[t.sx,t.sy],this._update_box(t,!0,!1)}else{if(null!=this._basepoint)return;this._select_event(t,!0,this.model.renderers),this._basepoint=[t.sx,t.sy]}},e.prototype._pan=function(t,e,i){if(void 0===e&&(e=!1),void 0===i&&(i=!1),t.shiftKey){if(null==this._draw_basepoint)return;this._update_box(t,e,i)}else{if(null==this._basepoint)return;this._drag_points(t,this.model.renderers)}},e.prototype._pan_end=function(t){if(this._pan(t,!1,!0),t.shiftKey)this._draw_basepoint=null;else{this._basepoint=null;for(var e=0,i=this.model.renderers;e<i.length;e++){var n=i[e];this._emit_cds_changes(n.data_source,!1,!0,!0)}}},e}(s.EditToolView);i.BoxEditToolView=a;var l=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Box Edit Tool",e.icon="bk-tool-icon-box-edit",e.event_type=["tap","pan","move"],e.default_order=1,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="BoxEditTool",this.prototype.default_view=a,this.define({dimensions:[r.Dimensions,"both"],num_objects:[r.Int,0]})},t}(s.EditTool);(i.BoxEditTool=l).initClass()},function(t,e,i){var n=t(391),r=t(15),o=t(21),l=t(44),s=t(251),a=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t._mouse_in_frame=!0,t}return n.__extends(t,e),t.prototype._move_enter=function(t){this._mouse_in_frame=!0},t.prototype._move_exit=function(t){this._mouse_in_frame=!1},t.prototype._map_drag=function(t,e,i){var n=this.plot_model.frame;if(!n.bbox.contains(t,e))return null;var r=n.xscales[i.x_range_name].invert(t),o=n.yscales[i.y_range_name].invert(e);return[r,o]},t.prototype._delete_selected=function(t){var e=t.data_source,i=e.selected.indices;i.sort();for(var n=0,r=e.columns();n<r.length;n++)for(var o=r[n],s=e.get_array(o),a=0;a<i.length;a++){var l=i[a];s.splice(l-a,1)}this._emit_cds_changes(e)},t.prototype._pop_glyphs=function(t,e){var i=t.columns();if(e&&i.length)for(var n=0,r=i;n<r.length;n++){var o=r[n],s=t.get_array(o),a=s.length-e+1;a<1||(l.isArray(s)||(s=Array.from(s),t.data[o]=s),s.splice(0,a))}},t.prototype._emit_cds_changes=function(t,e,i,n){void 0===e&&(e=!0),void 0===i&&(i=!0),void 0===n&&(n=!0),i&&t.selection_manager.clear(),e&&t.change.emit(),n&&(t.data=t.data,t.properties.data.change.emit())},t.prototype._drag_points=function(t,e){if(null!=this._basepoint){for(var i=this._basepoint,n=i[0],r=i[1],o=0,s=e;o<s.length;o++){var a=s[o],l=this._map_drag(n,r,a),h=this._map_drag(t.sx,t.sy,a);if(null!=h&&null!=l){for(var u=h[0],c=h[1],_=l[0],p=l[1],d=[u-_,c-p],f=d[0],v=d[1],m=a.glyph,g=a.data_source,y=[m.x.field,m.y.field],b=y[0],x=y[1],w=0,k=g.selected.indices;w<k.length;w++){var S=k[w];b&&(g.data[b][S]+=f),x&&(g.data[x][S]+=v)}g.change.emit()}}this._basepoint=[t.sx,t.sy]}},t.prototype._pad_empty_columns=function(t,e){for(var i=0,n=t.columns();i<n.length;i++){var r=n[i];o.includes(e,r)||t.get_array(r).push(this.model.empty_value)}},t.prototype._select_event=function(t,e,i){var n=this.plot_model.frame,r=t.sx,o=t.sy;if(!n.bbox.contains(r,o))return[];for(var s={type:"point",sx:r,sy:o},a=[],l=0,h=i;l<h.length;l++){var u=h[l],c=u.get_selection_manager(),_=u.data_source,p=[this.plot_view.renderer_views[u.id]],d=c.select(p,s,!0,e);d&&a.push(u),_.properties.selected.change.emit()}return a},t}(s.GestureToolView);i.EditToolView=a;var h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="EditTool",this.define({custom_icon:[r.String],custom_tooltip:[r.String],empty_value:[r.Any],renderers:[r.Array,[]]})},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this.custom_tooltip||this.tool_name},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"computed_icon",{get:function(){return this.custom_icon||this.icon},enumerable:!0,configurable:!0}),t}(s.GestureTool);(i.EditTool=h).initClass()},function(t,e,i){var n=t(391),r=t(5),o=t(15),v=t(44),s=t(243),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._draw=function(t,e,i){if(void 0===i&&(i=!1),this.model.active){var n=this.model.renderers[0],r=this._map_drag(t.sx,t.sy,n);if(null!=r){var o=r[0],s=r[1],a=n.data_source,l=n.glyph,h=[l.xs.field,l.ys.field],u=h[0],c=h[1];if("new"==e)this._pop_glyphs(a,this.model.num_objects),u&&a.get_array(u).push([o]),c&&a.get_array(c).push([s]),this._pad_empty_columns(a,[u,c]);else if("add"==e){if(u){var _=a.data[u].length-1,p=a.get_array(u)[_];v.isArray(p)||(p=Array.from(p),a.data[u][_]=p),p.push(o)}if(c){var d=a.data[c].length-1,f=a.get_array(c)[d];v.isArray(f)||(f=Array.from(f),a.data[c][d]=f),f.push(s)}}this._emit_cds_changes(a,!0,!0,i)}}},e.prototype._pan_start=function(t){this._draw(t,"new")},e.prototype._pan=function(t){this._draw(t,"add")},e.prototype._pan_end=function(t){this._draw(t,"add",!0)},e.prototype._tap=function(t){this._select_event(t,t.shiftKey,this.model.renderers)},e.prototype._keyup=function(t){if(this.model.active&&this._mouse_in_frame)for(var e=0,i=this.model.renderers;e<i.length;e++){var n=i[e];t.keyCode===r.Keys.Esc?n.data_source.selection_manager.clear():t.keyCode===r.Keys.Backspace&&this._delete_selected(n)}},e}(s.EditToolView);i.FreehandDrawToolView=a;var l=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Freehand Draw Tool",e.icon="bk-tool-icon-freehand-draw",e.event_type=["pan","tap"],e.default_order=3,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="FreehandDrawTool",this.prototype.default_view=a,this.define({num_objects:[o.Int,0]})},t}(s.EditTool);(i.FreehandDrawTool=l).initClass()},function(t,e,i){var n=t(391),r=t(5),o=t(15),s=t(243),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._tap=function(t){var e=t.shiftKey,i=this._select_event(t,e,this.model.renderers);if(!i.length&&this.model.add){var n=this.model.renderers[0],r=this._map_drag(t.sx,t.sy,n);if(null!=r){var o=n.glyph,s=n.data_source,a=[o.x.field,o.y.field],l=a[0],h=a[1],u=r[0],c=r[1];this._pop_glyphs(s,this.model.num_objects),l&&s.get_array(l).push(u),h&&s.get_array(h).push(c),this._pad_empty_columns(s,[l,h]),s.change.emit(),s.data=s.data,s.properties.data.change.emit()}}},e.prototype._keyup=function(t){if(this.model.active&&this._mouse_in_frame)for(var e=0,i=this.model.renderers;e<i.length;e++){var n=i[e];t.keyCode===r.Keys.Backspace?this._delete_selected(n):t.keyCode==r.Keys.Esc&&n.data_source.selection_manager.clear()}},e.prototype._pan_start=function(t){this.model.drag&&(this._select_event(t,!0,this.model.renderers),this._basepoint=[t.sx,t.sy])},e.prototype._pan=function(t){this.model.drag&&null!=this._basepoint&&this._drag_points(t,this.model.renderers)},e.prototype._pan_end=function(t){if(this.model.drag){this._pan(t);for(var e=0,i=this.model.renderers;e<i.length;e++){var n=i[e];this._emit_cds_changes(n.data_source,!1,!0,!0)}this._basepoint=null}},e}(s.EditToolView);i.PointDrawToolView=a;var l=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Point Draw Tool",e.icon="bk-tool-icon-point-draw",e.event_type=["tap","pan","move"],e.default_order=2,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="PointDrawTool",this.prototype.default_view=a,this.define({add:[o.Bool,!0],drag:[o.Bool,!0],num_objects:[o.Int,0]})},t}(s.EditTool);(i.PointDrawTool=l).initClass()},function(t,e,i){var n=t(391),r=t(5),o=t(15),y=t(44),s=t(248),a=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t._drawing=!1,t._initialized=!1,t}return n.__extends(t,e),t.prototype._tap=function(t){this._drawing?this._draw(t,"add",!0):this._select_event(t,t.shiftKey,this.model.renderers)},t.prototype._draw=function(t,e,i){var n;void 0===i&&(i=!1);var r=this.model.renderers[0],o=this._map_drag(t.sx,t.sy,r);if(this._initialized||this.activate(),null!=o){var s=o[0],a=o[1];n=this._snap_to_vertex(t,s,a),s=n[0],a=n[1];var l=r.data_source,h=r.glyph,u=[h.xs.field,h.ys.field],c=u[0],_=u[1];if("new"==e)this._pop_glyphs(l,this.model.num_objects),c&&l.get_array(c).push([s,s]),_&&l.get_array(_).push([a,a]),this._pad_empty_columns(l,[c,_]);else if("edit"==e){if(c){var p=l.data[c][l.data[c].length-1];p[p.length-1]=s}if(_){var d=l.data[_][l.data[_].length-1];d[d.length-1]=a}}else if("add"==e){if(c){var f=l.data[c].length-1,p=l.get_array(c)[f],v=p[p.length-1];p[p.length-1]=s,y.isArray(p)||(p=Array.from(p),l.data[c][f]=p),p.push(v)}if(_){var m=l.data[_].length-1,d=l.get_array(_)[m],g=d[d.length-1];d[d.length-1]=a,y.isArray(d)||(d=Array.from(d),l.data[_][m]=d),d.push(g)}}this._emit_cds_changes(l,!0,!1,i)}},t.prototype._show_vertices=function(){for(var t=[],e=[],i=0;i<this.model.renderers.length;i++){var n=this.model.renderers[i],r=n.data_source,o=n.glyph,s=[o.xs.field,o.ys.field],a=s[0],l=s[1];if(a)for(var h=0,u=r.get_array(a);h<u.length;h++){var c=u[h];Array.prototype.push.apply(t,c)}if(l)for(var _=0,p=r.get_array(l);_<p.length;_++){var c=p[_];Array.prototype.push.apply(e,c)}this._drawing&&i==this.model.renderers.length-1&&(t.splice(t.length-1,1),e.splice(e.length-1,1))}this._set_vertices(t,e)},t.prototype._doubletap=function(t){this.model.active&&(this._drawing?(this._drawing=!1,this._draw(t,"edit",!0)):(this._drawing=!0,this._draw(t,"new",!0)))},t.prototype._move=function(t){this._drawing&&this._draw(t,"edit")},t.prototype._remove=function(){var t=this.model.renderers[0],e=t.data_source,i=t.glyph,n=[i.xs.field,i.ys.field],r=n[0],o=n[1];if(r){var s=e.data[r].length-1,a=e.get_array(r)[s];a.splice(a.length-1,1)}if(o){var l=e.data[o].length-1,h=e.get_array(o)[l];h.splice(h.length-1,1)}this._emit_cds_changes(e)},t.prototype._keyup=function(t){if(this.model.active&&this._mouse_in_frame)for(var e=0,i=this.model.renderers;e<i.length;e++){var n=i[e];t.keyCode===r.Keys.Backspace?this._delete_selected(n):t.keyCode==r.Keys.Esc&&(this._drawing&&(this._remove(),this._drawing=!1),n.data_source.selection_manager.clear())}},t.prototype._pan_start=function(t){this.model.drag&&(this._select_event(t,!0,this.model.renderers),this._basepoint=[t.sx,t.sy])},t.prototype._pan=function(t){if(null!=this._basepoint&&this.model.drag){for(var e=this._basepoint,i=e[0],n=e[1],r=0,o=this.model.renderers;r<o.length;r++){var s=o[r],a=this._map_drag(i,n,s),l=this._map_drag(t.sx,t.sy,s);if(null!=l&&null!=a){var h=s.data_source,u=s.glyph,c=[u.xs.field,u.ys.field],_=c[0],p=c[1];if(_||p){for(var d=l[0],f=l[1],v=a[0],m=a[1],g=[d-v,f-m],y=g[0],b=g[1],x=0,w=h.selected.indices;x<w.length;x++){var k=w[x],S=void 0,C=void 0,T=void 0;_&&(C=h.data[_][k]),p?(T=h.data[p][k],S=T.length):S=C.length;for(var A=0;A<S;A++)C&&(C[A]+=y),T&&(T[A]+=b)}h.change.emit()}}}this._basepoint=[t.sx,t.sy]}},t.prototype._pan_end=function(t){if(this.model.drag){this._pan(t);for(var e=0,i=this.model.renderers;e<i.length;e++){var n=i[e];this._emit_cds_changes(n.data_source)}this._basepoint=null}},t.prototype.activate=function(){var t=this;if(this.model.vertex_renderer&&this.model.active){if(this._show_vertices(),!this._initialized)for(var e=0,i=this.model.renderers;e<i.length;e++){var n=i[e],r=n.data_source;r.connect(r.properties.data.change,function(){return t._show_vertices()})}this._initialized=!0}},t.prototype.deactivate=function(){this._drawing&&(this._remove(),this._drawing=!1),this.model.vertex_renderer&&this._hide_vertices()},t}(s.PolyToolView);i.PolyDrawToolView=a;var l=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Polygon Draw Tool",e.icon="bk-tool-icon-poly-draw",e.event_type=["pan","tap","move"],e.default_order=3,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="PolyDrawTool",this.prototype.default_view=a,this.define({drag:[o.Bool,!0],num_objects:[o.Int,0]})},t}(s.PolyTool);(i.PolyDrawTool=l).initClass()},function(t,e,i){var n=t(391),o=t(5),c=t(44),r=t(248),s=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t._drawing=!1,t}return n.__extends(t,e),t.prototype._doubletap=function(t){if(this.model.active){var e=this._map_drag(t.sx,t.sy,this.model.vertex_renderer);if(null!=e){var i=e[0],n=e[1],r=this._select_event(t,!1,[this.model.vertex_renderer]),o=this.model.vertex_renderer.data_source,s=this.model.vertex_renderer.glyph,a=[s.x.field,s.y.field],l=a[0],h=a[1];if(r.length&&null!=this._selected_renderer){var u=o.selected.indices[0];this._drawing?(this._drawing=!1,o.selection_manager.clear()):(o.selected.indices=[u+1],l&&o.get_array(l).splice(u+1,0,i),h&&o.get_array(h).splice(u+1,0,n),this._drawing=!0),o.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}else this._show_vertices(t)}}},t.prototype._show_vertices=function(t){if(this.model.active){var e=this._select_event(t,!1,this.model.renderers);if(!e.length)return this._set_vertices([],[]),this._selected_renderer=null,void(this._drawing=!1);var i,n,r=e[0],o=r.glyph,s=r.data_source,a=s.selected.indices[0],l=[o.xs.field,o.ys.field],h=l[0],u=l[1];h?(i=s.data[h][a],c.isArray(i)||(s.data[h][a]=i=Array.from(i))):i=o.xs.value,u?(n=s.data[u][a],c.isArray(n)||(s.data[u][a]=n=Array.from(n))):n=o.ys.value,this._selected_renderer=r,this._set_vertices(i,n)}},t.prototype._move=function(t){var e;if(this._drawing&&null!=this._selected_renderer){var i=this.model.vertex_renderer,n=i.data_source,r=i.glyph,o=this._map_drag(t.sx,t.sy,i);if(null==o)return;var s=o[0],a=o[1],l=n.selected.indices;e=this._snap_to_vertex(t,s,a),s=e[0],a=e[1],n.selected.indices=l;var h=[r.x.field,r.y.field],u=h[0],c=h[1],_=l[0];u&&(n.data[u][_]=s),c&&(n.data[c][_]=a),n.change.emit(),this._selected_renderer.data_source.change.emit()}},t.prototype._tap=function(t){var e,i=this.model.vertex_renderer,n=this._map_drag(t.sx,t.sy,i);if(null!=n){if(this._drawing&&this._selected_renderer){var r=n[0],o=n[1],s=i.data_source,a=i.glyph,l=[a.x.field,a.y.field],h=l[0],u=l[1],c=s.selected.indices;e=this._snap_to_vertex(t,r,o),r=e[0],o=e[1];var _=c[0];if(s.selected.indices=[_+1],h){var p=s.get_array(h),d=p[_];p[_]=r,p.splice(_+1,0,d)}if(u){var f=s.get_array(u),v=f[_];f[_]=o,f.splice(_+1,0,v)}return s.change.emit(),void this._emit_cds_changes(this._selected_renderer.data_source,!0,!1,!0)}var m=t.shiftKey;this._select_event(t,m,[i]),this._select_event(t,m,this.model.renderers)}},t.prototype._remove_vertex=function(){if(this._drawing&&this._selected_renderer){var t=this.model.vertex_renderer,e=t.data_source,i=t.glyph,n=e.selected.indices[0],r=[i.x.field,i.y.field],o=r[0],s=r[1];o&&e.get_array(o).splice(n,1),s&&e.get_array(s).splice(n,1),e.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}},t.prototype._pan_start=function(t){this._select_event(t,!0,[this.model.vertex_renderer]),this._basepoint=[t.sx,t.sy]},t.prototype._pan=function(t){null!=this._basepoint&&(this._drag_points(t,[this.model.vertex_renderer]),this._selected_renderer&&this._selected_renderer.data_source.change.emit())},t.prototype._pan_end=function(t){null!=this._basepoint&&(this._drag_points(t,[this.model.vertex_renderer]),this._emit_cds_changes(this.model.vertex_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)},t.prototype._keyup=function(t){if(this.model.active&&this._mouse_in_frame){var e;e=this._selected_renderer?[this.model.vertex_renderer]:this.model.renderers;for(var i=0,n=e;i<n.length;i++){var r=n[i];t.keyCode===o.Keys.Backspace?(this._delete_selected(r),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source)):t.keyCode==o.Keys.Esc&&(this._drawing?(this._remove_vertex(),this._drawing=!1):this._selected_renderer&&this._hide_vertices(),r.data_source.selection_manager.clear())}}},t.prototype.deactivate=function(){this._selected_renderer&&(this._drawing&&(this._remove_vertex(),this._drawing=!1),this._hide_vertices())},t}(r.PolyToolView);i.PolyEditToolView=s;var a=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Poly Edit Tool",e.icon="bk-tool-icon-poly-edit",e.event_type=["tap","pan","move"],e.default_order=4,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="PolyEditTool",this.prototype.default_view=s},t}(r.PolyTool);(i.PolyEditTool=a).initClass()},function(t,e,i){var n=t(391),r=t(15),a=t(44),o=t(243),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._set_vertices=function(t,e){var i=this.model.vertex_renderer.glyph,n=this.model.vertex_renderer.data_source,r=[i.x.field,i.y.field],o=r[0],s=r[1];o&&(a.isArray(t)?n.data[o]=t:i.x={value:t}),s&&(a.isArray(e)?n.data[s]=e:i.y={value:e}),this._emit_cds_changes(n,!0,!0,!1)},e.prototype._hide_vertices=function(){this._set_vertices([],[])},e.prototype._snap_to_vertex=function(t,e,i){if(this.model.vertex_renderer){var n=this._select_event(t,!1,[this.model.vertex_renderer]),r=this.model.vertex_renderer.data_source,o=this.model.vertex_renderer.glyph,s=[o.x.field,o.y.field],a=s[0],l=s[1];if(n.length){var h=r.selected.indices[0];a&&(e=r.data[a][h]),l&&(i=r.data[l][h]),r.selection_manager.clear()}}return[e,i]},e}(o.EditToolView);i.PolyToolView=s;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="PolyTool",this.prototype.default_view=s,this.define({vertex_renderer:[r.Instance]})},t}(o.EditTool);(i.PolyTool=l).initClass()},function(t,e,i){var v=t(391),n=t(256),r=t(64),o=t(15),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return v.__extends(e,t),e.prototype._compute_limits=function(t){var e=this.plot_model.frame,i=this.model.dimensions,n=this._base_point;if("center"==this.model.origin){var r=n[0],o=n[1],s=t[0],a=t[1];n=[r-(s-r),o-(a-o)]}return this.model._get_dim_limits(n,t,e,i)},e.prototype._pan_start=function(t){var e=t.sx,i=t.sy;this._base_point=[e,i]},e.prototype._pan=function(t){var e=t.sx,i=t.sy,n=[e,i],r=this._compute_limits(n),o=r[0],s=r[1];if(this.model.overlay.update({left:o[0],right:o[1],top:s[0],bottom:s[1]}),this.model.select_every_mousemove){var a=t.shiftKey;this._do_select(o,s,!1,a)}},e.prototype._pan_end=function(t){var e=t.sx,i=t.sy,n=[e,i],r=this._compute_limits(n),o=r[0],s=r[1],a=t.shiftKey;this._do_select(o,s,!0,a),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null,this.plot_view.push_state("box_select",{selection:this.plot_view.get_selection()})},e.prototype._do_select=function(t,e,i,n){var r=t[0],o=t[1],s=e[0],a=e[1];void 0===n&&(n=!1);var l={type:"rect",sx0:r,sx1:o,sy0:s,sy1:a};this._select(l,i,n)},e.prototype._emit_callback=function(t){var e=this.computed_renderers[0],i=this.plot_model.frame,n=i.xscales[e.x_range_name],r=i.yscales[e.y_range_name],o=t.sx0,s=t.sx1,a=t.sy0,l=t.sy1,h=n.r_invert(o,s),u=h[0],c=h[1],_=r.r_invert(a,l),p=_[0],d=_[1],f=v.__assign({x0:u,y0:p,x1:c,y1:d},t);this.model.callback.execute(this.model,{geometry:f})},e}(n.SelectToolView);i.BoxSelectToolView=s;var a=function(){return new r.BoxAnnotation({level:"overlay",render_mode:"css",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}})},l=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Box Select",e.icon="bk-tool-icon-box-select",e.event_type="pan",e.default_order=30,e}return v.__extends(t,i),t.initClass=function(){this.prototype.type="BoxSelectTool",this.prototype.default_view=s,this.define({dimensions:[o.Dimensions,"both"],select_every_mousemove:[o.Bool,!1],callback:[o.Instance],overlay:[o.Instance,a],origin:[o.String,"corner"]})},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),t}(n.SelectTool);(i.BoxSelectTool=l).initClass()},function(t,e,i){var n=t(391),r=t(251),o=t(64),s=t(15),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._match_aspect=function(t,e,i){var n,r,o,s,a=i.bbox.aspect,l=i.bbox.h_range.end,h=i.bbox.h_range.start,u=i.bbox.v_range.end,c=i.bbox.v_range.start,_=Math.abs(t[0]-e[0]),p=Math.abs(t[1]-e[1]),d=0==p?0:_/p,f=(a<=d?[1,d/a]:[a/d,1])[0];return t[0]<=e[0]?(n=t[0],r=t[0]+_*f,l<r&&(r=l)):(r=t[0],(n=t[0]-_*f)<h&&(n=h)),_=Math.abs(r-n),t[1]<=e[1]?(s=t[1],o=t[1]+_/a,u<o&&(o=u)):(o=t[1],(s=t[1]-_/a)<c&&(s=c)),p=Math.abs(o-s),t[0]<=e[0]?r=t[0]+a*p:n=t[0]-a*p,[[n,r],[s,o]]},e.prototype._compute_limits=function(t){var e,i,n,r,o=this.plot_model.frame,s=this.model.dimensions,a=this._base_point;if("center"==this.model.origin){var l=a[0],h=a[1],u=t[0],c=t[1];a=[l-(u-l),h-(c-h)]}return this.model.match_aspect&&"both"==s?(e=this._match_aspect(a,t,o),n=e[0],r=e[1]):(i=this.model._get_dim_limits(a,t,o,s),n=i[0],r=i[1]),[n,r]},e.prototype._pan_start=function(t){this._base_point=[t.sx,t.sy]},e.prototype._pan=function(t){var e=[t.sx,t.sy],i=this._compute_limits(e),n=i[0],r=i[1];this.model.overlay.update({left:n[0],right:n[1],top:r[0],bottom:r[1]})},e.prototype._pan_end=function(t){var e=[t.sx,t.sy],i=this._compute_limits(e),n=i[0],r=i[1];this._update(n,r),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null},e.prototype._update=function(t,e){var i=t[0],n=t[1],r=e[0],o=e[1];if(!(Math.abs(n-i)<=5||Math.abs(o-r)<=5)){var s=this.plot_model.frame,a=s.xscales,l=s.yscales,h={};for(var u in a){var c=a[u],_=c.r_invert(i,n),p=_[0],d=_[1];h[u]={start:p,end:d}}var f={};for(var v in l){var c=l[v],m=c.r_invert(r,o),p=m[0],d=m[1];f[v]={start:p,end:d}}var g={xrs:h,yrs:f};this.plot_view.push_state("box_zoom",{range:g}),this.plot_view.update_range(g)}},e}(r.GestureToolView);i.BoxZoomToolView=a;var l=function(){return new o.BoxAnnotation({level:"overlay",render_mode:"css",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}})},h=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Box Zoom",e.icon="bk-tool-icon-box-zoom",e.event_type="pan",e.default_order=20,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="BoxZoomTool",this.prototype.default_view=a,this.define({dimensions:[s.Dimensions,"both"],overlay:[s.Instance,l],match_aspect:[s.Bool,!1],origin:[s.String,"corner"]})},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),t}(r.GestureTool);(i.BoxZoomTool=h).initClass()},function(t,e,i){var n=t(391),r=t(241),o=t(265),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.ButtonToolView);i.GestureToolView=s;var a=function(i){function t(t){var e=i.call(this,t)||this;return e.button_view=o.OnOffButtonView,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="GestureTool"},t}(r.ButtonTool);(i.GestureTool=a).initClass()},function(t,e,i){var l=t(391),n=t(256),r=t(71),o=t(5),s=t(15),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return l.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),this.data=null},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,function(){return t._active_change()})},t.prototype._active_change=function(){this.model.active||this._clear_overlay()},t.prototype._keyup=function(t){t.keyCode==o.Keys.Enter&&this._clear_overlay()},t.prototype._pan_start=function(t){var e=t.sx,i=t.sy;this.data={sx:[e],sy:[i]}},t.prototype._pan=function(t){var e=t.sx,i=t.sy,n=this.plot_model.frame.bbox.clip(e,i),r=n[0],o=n[1];this.data.sx.push(r),this.data.sy.push(o);var s=this.model.overlay;if(s.update({xs:this.data.sx,ys:this.data.sy}),this.model.select_every_mousemove){var a=t.shiftKey;this._do_select(this.data.sx,this.data.sy,!1,a)}},t.prototype._pan_end=function(t){this._clear_overlay();var e=t.shiftKey;this._do_select(this.data.sx,this.data.sy,!0,e),this.plot_view.push_state("lasso_select",{selection:this.plot_view.get_selection()})},t.prototype._clear_overlay=function(){this.model.overlay.update({xs:[],ys:[]})},t.prototype._do_select=function(t,e,i,n){var r={type:"poly",sx:t,sy:e};this._select(r,i,n)},t.prototype._emit_callback=function(t){var e=this.computed_renderers[0],i=this.plot_model.frame,n=i.xscales[e.x_range_name],r=i.yscales[e.y_range_name],o=n.v_invert(t.sx),s=r.v_invert(t.sy),a=l.__assign({x:o,y:s},t);this.model.callback.execute(this.model,{geometry:a})},t}(n.SelectToolView);i.LassoSelectToolView=a;var h=function(){return new r.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}})},u=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Lasso Select",e.icon="bk-tool-icon-lasso-select",e.event_type="pan",e.default_order=12,e}return l.__extends(t,i),t.initClass=function(){this.prototype.type="LassoSelectTool",this.prototype.default_view=a,this.define({select_every_mousemove:[s.Bool,!0],callback:[s.Instance],overlay:[s.Instance,h]})},t}(n.SelectTool);(i.LassoSelectTool=u).initClass()},function(t,e,i){var n=t(391),r=t(251),o=t(15),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._pan_start=function(t){this.last_dx=0,this.last_dy=0;var e=t.sx,i=t.sy,n=this.plot_model.frame.bbox;if(!n.contains(e,i)){var r=n.h_range,o=n.v_range;(e<r.start||e>r.end)&&(this.v_axis_only=!0),(i<o.start||i>o.end)&&(this.h_axis_only=!0)}null!=this.model.document&&this.model.document.interactive_start(this.plot_model.plot)},e.prototype._pan=function(t){this._update(t.deltaX,t.deltaY),null!=this.model.document&&this.model.document.interactive_start(this.plot_model.plot)},e.prototype._pan_end=function(t){this.h_axis_only=!1,this.v_axis_only=!1,null!=this.pan_info&&this.plot_view.push_state("pan",{range:this.pan_info})},e.prototype._update=function(t,e){var i,n,r,o,s,a,l=this.plot_model.frame,h=t-this.last_dx,u=e-this.last_dy,c=l.bbox.h_range,_=c.start-h,p=c.end-h,d=l.bbox.v_range,f=d.start-u,v=d.end-u,m=this.model.dimensions;"width"!=m&&"both"!=m||this.v_axis_only?(i=c.start,n=c.end,r=0):(i=_,n=p,r=-h),"height"!=m&&"both"!=m||this.h_axis_only?(o=d.start,s=d.end,a=0):(o=f,s=v,a=-u),this.last_dx=t,this.last_dy=e;var g=l.xscales,y=l.yscales,b={};for(var x in g){var w=g[x],k=w.r_invert(i,n),S=k[0],C=k[1];b[x]={start:S,end:C}}var T={};for(var A in y){var w=y[A],E=w.r_invert(o,s),S=E[0],C=E[1];T[A]={start:S,end:C}}this.pan_info={xrs:b,yrs:T,sdx:r,sdy:a},this.plot_view.update_range(this.pan_info,!0)},e}(r.GestureToolView);i.PanToolView=s;var a=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Pan",e.event_type="pan",e.default_order=10,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="PanTool",this.prototype.default_view=s,this.define({dimensions:[o.Dimensions,"both"]})},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip("Pan",this.dimensions)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"icon",{get:function(){switch(this.dimensions){case"both":return"bk-tool-icon-pan";case"width":return"bk-tool-icon-xpan";case"height":return"bk-tool-icon-ypan"}},enumerable:!0,configurable:!0}),t}(r.GestureTool);(i.PanTool=a).initClass()},function(t,e,i){var l=t(391),n=t(256),r=t(71),o=t(5),s=t(15),a=t(21),h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return l.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),this.data={sx:[],sy:[]}},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,function(){return t._active_change()})},t.prototype._active_change=function(){this.model.active||this._clear_data()},t.prototype._keyup=function(t){t.keyCode==o.Keys.Enter&&this._clear_data()},t.prototype._doubletap=function(t){var e=t.shiftKey;this._do_select(this.data.sx,this.data.sy,!0,e),this.plot_view.push_state("poly_select",{selection:this.plot_view.get_selection()}),this._clear_data()},t.prototype._clear_data=function(){this.data={sx:[],sy:[]},this.model.overlay.update({xs:[],ys:[]})},t.prototype._tap=function(t){var e=t.sx,i=t.sy,n=this.plot_model.frame;n.bbox.contains(e,i)&&(this.data.sx.push(e),this.data.sy.push(i),this.model.overlay.update({xs:a.copy(this.data.sx),ys:a.copy(this.data.sy)}))},t.prototype._do_select=function(t,e,i,n){var r={type:"poly",sx:t,sy:e};this._select(r,i,n)},t.prototype._emit_callback=function(t){var e=this.computed_renderers[0],i=this.plot_model.frame,n=i.xscales[e.x_range_name],r=i.yscales[e.y_range_name],o=n.v_invert(t.sx),s=r.v_invert(t.sy),a=l.__assign({x:o,y:s},t);this.model.callback.execute(this.model,{geometry:a})},t}(n.SelectToolView);i.PolySelectToolView=h;var u=function(){return new r.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:{value:"lightgrey"},fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:2},line_dash:{value:[4,4]}})},c=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Poly Select",e.icon="bk-tool-icon-polygon-select",e.event_type="tap",e.default_order=11,e}return l.__extends(t,i),t.initClass=function(){this.prototype.type="PolySelectTool",this.prototype.default_view=h,this.define({callback:[s.Instance],overlay:[s.Instance,u]})},t}(n.SelectTool);(i.PolySelectTool=c).initClass()},function(t,e,i){var n=t(391),_=t(64),r=t(14),o=t(15),s=t(251);function p(t,e,i,n){if(null==e)return!1;var r=i.compute(e);return Math.abs(t-r)<n}function d(t,e,i,n,r){var o=!0;if(null!=r.left&&null!=r.right){var s=i.invert(t);(s<r.left||s>r.right)&&(o=!1)}if(null!=r.bottom&&null!=r.top){var a=n.invert(e);(a<r.bottom||a>r.top)&&(o=!1)}return o}function l(t,e,i,n){var r=e.compute(t),o=e.invert(r+i);return o>=n.start&&o<=n.end?o:t}function h(t,e,i,n){var r=e.r_compute(t.start,t.end),o=r[0],s=r[1],a=e.r_invert(o+i,s+i),l=a[0],h=a[1];l>=n.start&&l<=n.end&&h>=n.start&&h<=n.end&&(t.start=l,t.end=h)}i.is_near=p,i.is_inside=d,i.compute_value=l,i.update_range=h;var a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),this.side=0,this.model.update_overlay_from_ranges()},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),null!=this.model.x_range&&this.connect(this.model.x_range.change,function(){return t.model.update_overlay_from_ranges()}),null!=this.model.y_range&&this.connect(this.model.y_range.change,function(){return t.model.update_overlay_from_ranges()})},t.prototype._pan_start=function(t){this.last_dx=0,this.last_dy=0;var e=this.model.x_range,i=this.model.y_range,n=this.plot_model.frame,r=n.xscales.default,o=n.yscales.default,s=this.model.overlay,a=s.left,l=s.right,h=s.top,u=s.bottom,c=this.model.overlay.properties.line_width.value()+_.EDGE_TOLERANCE;null!=e&&this.model.x_interaction&&(p(t.sx,a,r,c)?this.side=1:p(t.sx,l,r,c)?this.side=2:d(t.sx,t.sy,r,o,s)&&(this.side=3)),null!=i&&this.model.y_interaction&&(0==this.side&&p(t.sy,u,o,c)&&(this.side=4),0==this.side&&p(t.sy,h,o,c)?this.side=5:d(t.sx,t.sy,r,o,this.model.overlay)&&(3==this.side?this.side=7:this.side=6))},t.prototype._pan=function(t){var e=this.plot_model.frame,i=t.deltaX-this.last_dx,n=t.deltaY-this.last_dy,r=this.model.x_range,o=this.model.y_range,s=e.xscales.default,a=e.yscales.default;null!=r&&(3==this.side||7==this.side?h(r,s,i,e.x_range):1==this.side?r.start=l(r.start,s,i,e.x_range):2==this.side&&(r.end=l(r.end,s,i,e.x_range))),null!=o&&(6==this.side||7==this.side?h(o,a,n,e.y_range):4==this.side?o.start=l(o.start,a,n,e.y_range):5==this.side&&(o.end=l(o.end,a,n,e.y_range))),this.last_dx=t.deltaX,this.last_dy=t.deltaY},t.prototype._pan_end=function(t){this.side=0},t}(s.GestureToolView);i.RangeToolView=a;var u=function(){return new _.BoxAnnotation({level:"overlay",render_mode:"css",fill_color:"lightgrey",fill_alpha:{value:.5},line_color:{value:"black"},line_alpha:{value:1},line_width:{value:.5},line_dash:[2,2]})},c=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Range Tool",e.icon="bk-tool-icon-range",e.event_type="pan",e.default_order=1,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="RangeTool",this.prototype.default_view=a,this.define({x_range:[o.Instance,null],x_interaction:[o.Bool,!0],y_range:[o.Instance,null],y_interaction:[o.Bool,!0],overlay:[o.Instance,u]})},t.prototype.initialize=function(){i.prototype.initialize.call(this),this.overlay.in_cursor="grab",this.overlay.ew_cursor=null!=this.x_range&&this.x_interaction?"ew-resize":null,this.overlay.ns_cursor=null!=this.y_range&&this.y_interaction?"ns-resize":null},t.prototype.update_overlay_from_ranges=function(){null==this.x_range&&null==this.y_range&&(this.overlay.left=null,this.overlay.right=null,this.overlay.bottom=null,this.overlay.top=null,r.logger.warn("RangeTool not configured with any Ranges.")),null==this.x_range?(this.overlay.left=null,this.overlay.right=null):(this.overlay.left=this.x_range.start,this.overlay.right=this.x_range.end),null==this.y_range?(this.overlay.bottom=null,this.overlay.top=null):(this.overlay.bottom=this.y_range.start,this.overlay.top=this.y_range.end)},t}(s.GestureTool);(i.RangeTool=c).initClass()},function(t,e,i){var y=t(391),n=t(251),o=t(186),r=t(271),s=t(15),a=t(5),b=t(3),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return y.__extends(e,t),Object.defineProperty(e.prototype,"computed_renderers",{get:function(){var t=this.model.renderers,e=this.plot_model.plot.renderers,i=this.model.names;return r.compute_renderers(t,e,i)},enumerable:!0,configurable:!0}),e.prototype._computed_renderers_by_data_source=function(){for(var t={},e=0,i=this.computed_renderers;e<i.length;e++){var n=i[e],r=void 0;(r=n instanceof o.GraphRenderer?n.node_renderer.data_source.id:n.data_source.id)in t||(t[r]=[]),t[r].push(n)}return t},e.prototype._keyup=function(t){if(t.keyCode==a.Keys.Esc){for(var e=0,i=this.computed_renderers;e<i.length;e++){var n=i[e],r=n.data_source,o=r.selection_manager;o.clear()}this.plot_view.request_render()}},e.prototype._select=function(t,e,i){var n=this._computed_renderers_by_data_source();for(var r in n){for(var o=n[r],s=o[0].get_selection_manager(),a=[],l=0,h=o;l<h.length;l++){var u=h[l];u.id in this.plot_view.renderer_views&&a.push(this.plot_view.renderer_views[u.id])}s.select(a,t,e,i)}null!=this.model.callback&&this._emit_callback(t),this._emit_selection_event(t,e)},e.prototype._emit_selection_event=function(t,e){void 0===e&&(e=!0);var i,n=this.plot_model.frame.xscales.default,r=this.plot_model.frame.yscales.default;switch(t.type){case"point":var o=t.sx,s=t.sy,a=n.invert(o),l=r.invert(s);i=y.__assign({},t,{x:a,y:l});break;case"rect":var h=t.sx0,u=t.sx1,c=t.sy0,_=t.sy1,p=n.r_invert(h,u),d=p[0],f=p[1],v=r.r_invert(c,_),m=v[0],g=v[1];i=y.__assign({},t,{x0:d,y0:m,x1:f,y1:g});break;case"poly":var o=t.sx,s=t.sy,a=n.v_invert(o),l=r.v_invert(s);i=y.__assign({},t,{x:a,y:l});break;default:throw new Error("Unrecognized selection geometry type: '"+t.type+"'")}this.plot_model.plot.trigger_event(new b.SelectionGeometry({geometry:i,final:e}))},e}(n.GestureToolView);i.SelectToolView=l;var h=function(e){function t(t){return e.call(this,t)||this}return y.__extends(t,e),t.initClass=function(){this.prototype.type="SelectTool",this.define({renderers:[s.Any,"auto"],names:[s.Array,[]]})},t}(n.GestureTool);(i.SelectTool=h).initClass()},function(t,e,i){var x=t(391),n=t(256),r=t(15),w=t(44),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return x.__extends(e,t),e.prototype._tap=function(t){var e=t.sx,i=t.sy,n={type:"point",sx:e,sy:i},r=t.shiftKey;this._select(n,!0,r)},e.prototype._select=function(t,e,i){var n=this,r=this.model.callback;if("select"==this.model.behavior){var o=this._computed_renderers_by_data_source();for(var s in o){var a=o[s],l=a[0].get_selection_manager(),h=a.map(function(t){return n.plot_view.renderer_views[t.id]}),u=l.select(h,t,e,i);if(u&&null!=r){var c=this.plot_model.frame,_=c.xscales[a[0].x_range_name],p=c.yscales[a[0].y_range_name],d=_.invert(t.sx),f=p.invert(t.sy),v=x.__assign({},t,{x:d,y:f}),m={geometries:v,source:l.source};w.isFunction(r)?r(this,m):r.execute(this,m)}}this._emit_selection_event(t),this.plot_view.push_state("tap",{selection:this.plot_view.get_selection()})}else for(var g=0,y=this.computed_renderers;g<y.length;g++){var b=y[g],l=b.get_selection_manager(),u=l.inspect(this.plot_view.renderer_views[b.id],t);if(u&&null!=r){var c=this.plot_model.frame,_=c.xscales[b.x_range_name],p=c.yscales[b.y_range_name],d=_.invert(t.sx),f=p.invert(t.sy),v=x.__assign({},t,{x:d,y:f}),m={geometries:v,source:l.source};w.isFunction(r)?r(this,m):r.execute(this,m)}}},e}(n.SelectToolView);i.TapToolView=o;var s=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Tap",e.icon="bk-tool-icon-tap-select",e.event_type="tap",e.default_order=10,e}return x.__extends(t,i),t.initClass=function(){this.prototype.type="TapTool",this.prototype.default_view=o,this.define({behavior:[r.String,"select"],callback:[r.Any]})},t}(n.SelectTool);(i.TapTool=s).initClass()},function(t,e,i){var n=t(391),r=t(251),o=t(15),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._scroll=function(t){var e=this.model.speed*t.delta;.9<e?e=.9:e<-.9&&(e=-.9),this._update_ranges(e)},e.prototype._update_ranges=function(t){var e,i,n,r,o=this.plot_model.frame,s=o.bbox.h_range,a=o.bbox.v_range,l=[s.start,s.end],h=l[0],u=l[1],c=[a.start,a.end],_=c[0],p=c[1];switch(this.model.dimension){case"height":var d=Math.abs(p-_);e=h,i=u,n=_-d*t,r=p-d*t;break;case"width":var f=Math.abs(u-h);e=h-f*t,i=u-f*t,n=_,r=p;break;default:throw new Error("this shouldn't have happened")}var v=o.xscales,m=o.yscales,g={};for(var y in v){var b=v[y],x=b.r_invert(e,i),w=x[0],k=x[1];g[y]={start:w,end:k}}var S={};for(var C in m){var b=m[C],T=b.r_invert(n,r),w=T[0],k=T[1];S[C]={start:w,end:k}}var A={xrs:g,yrs:S,factor:t};this.plot_view.push_state("wheel_pan",{range:A}),this.plot_view.update_range(A,!1,!0),null!=this.model.document&&this.model.document.interactive_start(this.plot_model.plot)},e}(r.GestureToolView);i.WheelPanToolView=s;var a=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Wheel Pan",e.icon="bk-tool-icon-wheel-pan",e.event_type="scroll",e.default_order=12,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="WheelPanTool",this.prototype.default_view=s,this.define({dimension:[o.Dimension,"width"]}),this.internal({speed:[o.Number,.001]})},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimension)},enumerable:!0,configurable:!0}),t}(r.GestureTool);(i.WheelPanTool=a).initClass()},function(t,e,i){var n=t(391),r=t(251),c=t(46),o=t(15),s=t(20),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._pinch=function(t){var e,i=t.sx,n=t.sy,r=t.scale;e=1<=r?20*(r-1):-20/r,this._scroll({type:"mousewheel",sx:i,sy:n,delta:e})},e.prototype._scroll=function(t){var e=this.plot_model.frame,i=e.bbox.h_range,n=e.bbox.v_range,r=t.sx,o=t.sy,s=this.model.dimensions,a=("width"==s||"both"==s)&&i.start<r&&r<i.end,l=("height"==s||"both"==s)&&n.start<o&&o<n.end;if(a&&l||this.model.zoom_on_axis){var h=this.model.speed*t.delta,u=c.scale_range(e,h,a,l,{x:r,y:o});this.plot_view.push_state("wheel_zoom",{range:u}),this.plot_view.update_range(u,!1,!0,this.model.maintain_focus),null!=this.model.document&&this.model.document.interactive_start(this.plot_model.plot)}},e}(r.GestureToolView);i.WheelZoomToolView=a;var l=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Wheel Zoom",e.icon="bk-tool-icon-wheel-zoom",e.event_type=s.is_mobile?"pinch":"scroll",e.default_order=10,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="WheelZoomTool",this.prototype.default_view=a,this.define({dimensions:[o.Dimensions,"both"],maintain_focus:[o.Boolean,!0],zoom_on_axis:[o.Boolean,!0],speed:[o.Number,1/600]})},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.tool_name,this.dimensions)},enumerable:!0,configurable:!0}),t}(r.GestureTool);(i.WheelZoomTool=l).initClass()},function(t,e,i){var n=t(232);i.ActionTool=n.ActionTool;var r=t(233);i.CustomAction=r.CustomAction;var o=t(234);i.HelpTool=o.HelpTool;var s=t(235);i.RedoTool=s.RedoTool;var a=t(236);i.ResetTool=a.ResetTool;var l=t(237);i.SaveTool=l.SaveTool;var h=t(238);i.UndoTool=h.UndoTool;var u=t(239);i.ZoomInTool=u.ZoomInTool;var c=t(240);i.ZoomOutTool=c.ZoomOutTool;var _=t(241);i.ButtonTool=_.ButtonTool;var p=t(243);i.EditTool=p.EditTool;var d=t(242);i.BoxEditTool=d.BoxEditTool;var f=t(244);i.FreehandDrawTool=f.FreehandDrawTool;var v=t(245);i.PointDrawTool=v.PointDrawTool;var m=t(246);i.PolyDrawTool=m.PolyDrawTool;var g=t(248);i.PolyTool=g.PolyTool;var y=t(247);i.PolyEditTool=y.PolyEditTool;var b=t(249);i.BoxSelectTool=b.BoxSelectTool;var x=t(250);i.BoxZoomTool=x.BoxZoomTool;var w=t(251);i.GestureTool=w.GestureTool;var k=t(252);i.LassoSelectTool=k.LassoSelectTool;var S=t(253);i.PanTool=S.PanTool;var C=t(254);i.PolySelectTool=C.PolySelectTool;var T=t(255);i.RangeTool=T.RangeTool;var A=t(256);i.SelectTool=A.SelectTool;var E=t(257);i.TapTool=E.TapTool;var M=t(258);i.WheelPanTool=M.WheelPanTool;var O=t(259);i.WheelZoomTool=O.WheelZoomTool;var z=t(261);i.CrosshairTool=z.CrosshairTool;var P=t(262);i.CustomJSHover=P.CustomJSHover;var j=t(263);i.HoverTool=j.HoverTool;var N=t(264);i.InspectTool=N.InspectTool;var F=t(266);i.Tool=F.Tool;var D=t(267);i.ToolProxy=D.ToolProxy;var I=t(268);i.Toolbar=I.Toolbar;var R=t(269);i.ToolbarBase=R.ToolbarBase;var B=t(270);i.ProxyToolbar=B.ProxyToolbar;var L=t(270);i.ToolbarBox=L.ToolbarBox},function(t,e,i){var n=t(391),r=t(264),o=t(73),s=t(15),a=t(32),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._move=function(t){if(this.model.active){var e=t.sx,i=t.sy;this.plot_model.frame.bbox.contains(e,i)?this._update_spans(e,i):this._update_spans(null,null)}},e.prototype._move_exit=function(t){this._update_spans(null,null)},e.prototype._update_spans=function(t,e){var i=this.model.dimensions;"width"!=i&&"both"!=i||(this.model.spans.width.computed_location=e),"height"!=i&&"both"!=i||(this.model.spans.height.computed_location=t)},e}(r.InspectToolView);i.CrosshairToolView=l;var h=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Crosshair",e.icon="bk-tool-icon-crosshair",e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="CrosshairTool",this.prototype.default_view=l,this.define({dimensions:[s.Dimensions,"both"],line_color:[s.Color,"black"],line_width:[s.Number,1],line_alpha:[s.Number,1]}),this.internal({location_units:[s.SpatialUnits,"screen"],render_mode:[s.RenderMode,"css"],spans:[s.Any]})},Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip("Crosshair",this.dimensions)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"synthetic_renderers",{get:function(){return a.values(this.spans)},enumerable:!0,configurable:!0}),t.prototype.initialize=function(){i.prototype.initialize.call(this),this.spans={width:new o.Span({for_hover:!0,dimension:"width",render_mode:this.render_mode,location_units:this.location_units,line_color:this.line_color,line_width:this.line_width,line_alpha:this.line_alpha}),height:new o.Span({for_hover:!0,dimension:"height",render_mode:this.render_mode,location_units:this.location_units,line_color:this.line_color,line_width:this.line_width,line_alpha:this.line_alpha})}},t}(r.InspectTool);(i.CrosshairTool=h).initClass()},function(r,t,o){var i=r(391),e=r(59),n=r(15),s=r(32),a=r(38),l=function(e){function t(t){return e.call(this,t)||this}return i.__extends(t,e),t.initClass=function(){this.prototype.type="CustomJSHover",this.define({args:[n.Any,{}],code:[n.String,""]})},Object.defineProperty(t.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!0,configurable:!0}),t.prototype._make_code=function(t,e,i,n){return new(Function.bind.apply(Function,[void 0].concat(s.keys(this.args),[t,e,i,"require","exports",a.use_strict(n)])))},t.prototype.format=function(t,e,i){var n=this._make_code("value","format","special_vars",this.code);return n.apply(void 0,this.values.concat([t,e,i,r,o]))},t}(e.Model);(o.CustomJSHover=l).initClass()},function(t,e,i){var f=t(391),n=t(264),s=t(77),Z=t(185),tt=t(186),o=t(271),c=t(9),k=t(40),S=t(5),r=t(15),C=t(27),et=t(32),T=t(44),a=t(4);function it(t,e,i,n,r,o){var s,a,l={x:r[t],y:o[t]},h={x:r[t+1],y:o[t+1]};if("span"==e.type)"h"==e.direction?(s=Math.abs(l.x-i),a=Math.abs(h.x-i)):(s=Math.abs(l.y-n),a=Math.abs(h.y-n));else{var u={x:i,y:n};s=c.dist_2_pts(l,u),a=c.dist_2_pts(h,u)}return s<a?[[l.x,l.y],t]:[[h.x,h.y],t+1]}function nt(t,e,i){return[[t[i],e[i]],i]}i._nearest_line_hit=it,i._line_hit=nt;var l=function(r){function t(){return null!==r&&r.apply(this,arguments)||this}return f.__extends(t,r),t.prototype.initialize=function(t){r.prototype.initialize.call(this,t),this.ttviews={}},t.prototype.remove=function(){a.remove_views(this.ttviews),r.prototype.remove.call(this)},t.prototype.connect_signals=function(){var t=this;r.prototype.connect_signals.call(this);for(var e=0,i=this.computed_renderers;e<i.length;e++){var n=i[e];n instanceof Z.GlyphRenderer?this.connect(n.data_source.inspect,this._update):(this.connect(n.node_renderer.data_source.inspect,this._update),this.connect(n.edge_renderer.data_source.inspect,this._update))}this.connect(this.model.properties.renderers.change,function(){return t._computed_renderers=t._ttmodels=null}),this.connect(this.model.properties.names.change,function(){return t._computed_renderers=t._ttmodels=null}),this.connect(this.model.properties.tooltips.change,function(){return t._ttmodels=null})},t.prototype._compute_ttmodels=function(){var t={},e=this.model.tooltips;if(null!=e)for(var i=0,n=this.computed_renderers;i<n.length;i++){var r=n[i];if(r instanceof Z.GlyphRenderer){var o=new s.Tooltip({custom:T.isString(e)||T.isFunction(e),attachment:this.model.attachment,show_arrow:this.model.show_arrow});t[r.id]=o}else{var o=new s.Tooltip({custom:T.isString(e)||T.isFunction(e),attachment:this.model.attachment,show_arrow:this.model.show_arrow});t[r.node_renderer.id]=o,t[r.edge_renderer.id]=o}}return a.build_views(this.ttviews,et.values(t),{parent:this,plot_view:this.plot_view}),t},Object.defineProperty(t.prototype,"computed_renderers",{get:function(){if(null==this._computed_renderers){var t=this.model.renderers,e=this.plot_model.plot.renderers,i=this.model.names;this._computed_renderers=o.compute_renderers(t,e,i)}return this._computed_renderers},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"ttmodels",{get:function(){return null==this._ttmodels&&(this._ttmodels=this._compute_ttmodels()),this._ttmodels},enumerable:!0,configurable:!0}),t.prototype._clear=function(){for(var t in this._inspect(1/0,1/0),this.ttmodels){var e=this.ttmodels[t];e.clear()}},t.prototype._move=function(t){if(this.model.active){var e=t.sx,i=t.sy;this.plot_model.frame.bbox.contains(e,i)?this._inspect(e,i):this._clear()}},t.prototype._move_exit=function(){this._clear()},t.prototype._inspect=function(t,e){var i;if("mouse"==this.model.mode)i={type:"point",sx:t,sy:e};else{var n="vline"==this.model.mode?"h":"v";i={type:"span",direction:n,sx:t,sy:e}}for(var r=0,o=this.computed_renderers;r<o.length;r++){var s=o[r],a=s.get_selection_manager();a.inspect(this.plot_view.renderer_views[s.id],i)}null!=this.model.callback&&this._emit_callback(i)},t.prototype._update=function(t){var e,i,n,r,o,s,a,l,h,u,c,_,p,d,f,v,m=t[0],g=t[1].geometry;if(this.model.active&&(m instanceof Z.GlyphRendererView||m instanceof tt.GraphRendererView)){var y=m.model,b=this.ttmodels[y.id];if(null!=b){b.clear();var x=y.get_selection_manager(),w=x.inspectors[y.id];if(y instanceof Z.GlyphRenderer&&(w=y.view.convert_selection_to_subset(w)),!w.is_empty()){for(var k=x.source,S=this.plot_model.frame,C=g.sx,T=g.sy,A=S.xscales[y.x_range_name],E=S.yscales[y.y_range_name],M=A.invert(C),O=E.invert(T),z=m.glyph,P=0,j=w.line_indices;P<j.length;P++){var N=j[P],F=z._x[N+1],D=z._y[N+1],I=N,R=void 0,B=void 0;switch(this.model.line_policy){case"interp":e=z.get_interpolation_hit(N,g),F=e[0],D=e[1],R=A.compute(F),B=E.compute(D);break;case"prev":i=nt(z.sx,z.sy,N),n=i[0],R=n[0],B=n[1],I=i[1];break;case"next":r=nt(z.sx,z.sy,N+1),o=r[0],R=o[0],B=o[1],I=r[1];break;case"nearest":s=it(N,g,C,T,z.sx,z.sy),a=s[0],R=a[0],B=a[1],I=s[1],F=z._x[I],D=z._y[I];break;default:R=(l=[C,T])[0],B=l[1]}var L={index:I,x:M,y:O,sx:C,sy:T,data_x:F,data_y:D,rx:R,ry:B,indices:w.line_indices,name:m.model.name};b.add(R,B,this._render_tooltips(k,I,L))}for(var V=0,G=w.image_indices;V<G.length;V++){var U=G[V],L={index:U.index,x:M,y:O,sx:C,sy:T},q=this._render_tooltips(k,U,L);b.add(C,T,q)}for(var Y=0,X=w.indices;Y<X.length;Y++){var N=X[Y];if(et.isEmpty(w.multiline_indices)){var F=null!=z._x?z._x[N]:void 0,D=null!=z._y?z._y[N]:void 0,R=void 0,B=void 0;if("snap_to_data"==this.model.point_policy){var H=z.get_anchor_point(this.model.anchor,N,[C,T]);null==H&&(H=z.get_anchor_point("center",N,[C,T])),R=H.x,B=H.y}else R=(v=[C,T])[0],B=v[1];var W=void 0,L={index:W=y instanceof Z.GlyphRenderer?y.view.convert_indices_from_subset([N])[0]:N,x:M,y:O,sx:C,sy:T,data_x:F,data_y:D,indices:w.indices,name:m.model.name};b.add(R,B,this._render_tooltips(k,W,L))}else for(var J=0,Q=w.multiline_indices[N.toString()];J<Q.length;J++){var $=Q[J],F=z._xs[N][$],D=z._ys[N][$],K=$,R=void 0,B=void 0;switch(this.model.line_policy){case"interp":h=z.get_interpolation_hit(N,$,g),F=h[0],D=h[1],R=A.compute(F),B=E.compute(D);break;case"prev":u=nt(z.sxs[N],z.sys[N],$),c=u[0],R=c[0],B=c[1],K=u[1];break;case"next":_=nt(z.sxs[N],z.sys[N],$+1),p=_[0],R=p[0],B=p[1],K=_[1];break;case"nearest":d=it($,g,C,T,z.sxs[N],z.sys[N]),f=d[0],R=f[0],B=f[1],K=d[1],F=z._xs[N][K],D=z._ys[N][K];break;default:throw new Error("should't have happened")}var W=void 0,L={index:W=y instanceof Z.GlyphRenderer?y.view.convert_indices_from_subset([N])[0]:N,segment_index:K,x:M,y:O,sx:C,sy:T,data_x:F,data_y:D,indices:w.multiline_indices,name:m.model.name};b.add(R,B,this._render_tooltips(k,W,L))}}}}}},t.prototype._emit_callback=function(t){for(var e=0,i=this.computed_renderers;e<i.length;e++){var n=i[e],r=n.data_source.inspected,o=this.plot_model.frame,s=o.xscales[n.x_range_name],a=o.yscales[n.y_range_name],l=s.invert(t.sx),h=a.invert(t.sy),u=f.__assign({x:l,y:h},t),c=this.model.callback,_=[c,{index:r,geometry:u,renderer:n}],p=_[0],d=_[1];T.isFunction(c)?c(p,d):c.execute(p,d)}},t.prototype._render_tooltips=function(t,e,i){var n=this.model.tooltips;if(T.isString(n)){var r=S.div();return r.innerHTML=k.replace_placeholders(n,t,e,this.model.formatters,i),r}if(T.isFunction(n))return n(t,i);for(var o=S.div({style:{display:"table",borderSpacing:"2px"}}),s=0,a=n;s<a.length;s++){var l=a[s],h=l[0],u=l[1],c=S.div({style:{display:"table-row"}});o.appendChild(c);var _=void 0;if(_=S.div({style:{display:"table-cell"},class:"bk-tooltip-row-label"},h+": "),c.appendChild(_),_=S.div({style:{display:"table-cell"},class:"bk-tooltip-row-value"}),c.appendChild(_),0<=u.indexOf("$color")){var p=u.match(/\$color(\[.*\])?:(\w*)/),d=p[1],f=void 0===d?"":d,v=p[2],m=t.get_column(v);if(null==m){var g=S.span({},v+" unknown");_.appendChild(g);continue}var y=0<=f.indexOf("hex"),b=0<=f.indexOf("swatch"),x=T.isNumber(e)?m[e]:null;if(null==x){var w=S.span({},"(null)");_.appendChild(w);continue}y&&(x=C.color2hex(x));var r=S.span({},x);_.appendChild(r),b&&(r=S.span({class:"bk-tooltip-color-block",style:{backgroundColor:x}}," "),_.appendChild(r))}else{var r=S.span();r.innerHTML=k.replace_placeholders(u.replace("$~","$data_"),t,e,this.model.formatters,i),_.appendChild(r)}}return o},t}(n.InspectToolView);i.HoverToolView=l;var h=function(i){function t(t){var e=i.call(this,t)||this;return e.tool_name="Hover",e.icon="bk-tool-icon-hover",e}return f.__extends(t,i),t.initClass=function(){this.prototype.type="HoverTool",this.prototype.default_view=l,this.define({tooltips:[r.Any,[["index","$index"],["data (x, y)","($x, $y)"],["screen (x, y)","($sx, $sy)"]]],formatters:[r.Any,{}],renderers:[r.Any,"auto"],names:[r.Array,[]],mode:[r.String,"mouse"],point_policy:[r.String,"snap_to_data"],line_policy:[r.String,"nearest"],show_arrow:[r.Boolean,!0],anchor:[r.String,"center"],attachment:[r.String,"horizontal"],callback:[r.Any]})},t}(n.InspectTool);(i.HoverTool=h).initClass()},function(t,e,i){var n=t(391),r=t(241),o=t(265),s=t(15),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(r.ButtonToolView);i.InspectToolView=a;var l=function(i){function t(t){var e=i.call(this,t)||this;return e.event_type="move",e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="InspectTool",this.prototype.button_view=o.OnOffButtonView,this.define({toggleable:[s.Bool,!0]}),this.override({active:!0})},t}(r.ButtonTool);(i.InspectTool=l).initClass()},function(t,e,i){var n=t(391),r=t(241),o=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.render=function(){t.prototype.render.call(this),this.model.active?this.el.classList.add("bk-active"):this.el.classList.remove("bk-active")},e.prototype._clicked=function(){var t=this.model.active;this.model.active=!t},e}(r.ButtonToolButtonView);i.OnOffButtonView=o},function(t,e,i){var n=t(391),r=t(15),o=t(48),_=t(21),s=t(59),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),this.plot_view=t.plot_view},Object.defineProperty(t.prototype,"plot_model",{get:function(){return this.plot_view.model},enumerable:!0,configurable:!0}),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,function(){t.model.active?t.activate():t.deactivate()})},t.prototype.activate=function(){},t.prototype.deactivate=function(){},t}(o.View);i.ToolView=a;var l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Tool",this.internal({active:[r.Boolean,!1]})},Object.defineProperty(t.prototype,"synthetic_renderers",{get:function(){return[]},enumerable:!0,configurable:!0}),t.prototype._get_dim_tooltip=function(t,e){switch(e){case"width":return t+" (x-axis)";case"height":return t+" (y-axis)";case"both":return t}},t.prototype._get_dim_limits=function(t,e,i,n){var r,o=t[0],s=t[1],a=e[0],l=e[1],h=i.bbox.h_range;"width"==n||"both"==n?(r=[_.min([o,a]),_.max([o,a])],r=[_.max([r[0],h.start]),_.min([r[1],h.end])]):r=[h.start,h.end];var u,c=i.bbox.v_range;return"height"==n||"both"==n?(u=[_.min([s,l]),_.max([s,l])],u=[_.max([u[0],c.start]),_.min([u[1],c.end])]):u=[c.start,c.end],[r,u]},t}(s.Model);(i.Tool=l).initClass()},function(t,e,i){var n=t(391),r=t(15),o=t(19),s=t(59),a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="ToolProxy",this.define({tools:[r.Array,[]],active:[r.Bool,!1],disabled:[r.Bool,!1]})},Object.defineProperty(t.prototype,"button_view",{get:function(){return this.tools[0].button_view},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"event_type",{get:function(){return this.tools[0].event_type},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"tooltip",{get:function(){return this.tools[0].tooltip},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"tool_name",{get:function(){return this.tools[0].tool_name},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"icon",{get:function(){return this.tools[0].computed_icon},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"computed_icon",{get:function(){return this.icon},enumerable:!0,configurable:!0}),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.do=new o.Signal0(this,"do")},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.do,function(){return t.doit()}),this.connect(this.properties.active.change,function(){return t.set_active()})},t.prototype.doit=function(){for(var t=0,e=this.tools;t<e.length;t++){var i=e[t];i.do.emit()}},t.prototype.set_active=function(){for(var t=0,e=this.tools;t<e.length;t++){var i=e[t];i.active=this.active}},t}(s.Model);(i.ToolProxy=a).initClass()},function(t,e,i){var n=t(391),r=t(15),v=t(14),m=t(44),g=t(21),y=t(232),b=t(234),x=t(251),w=t(264),o=t(269),s=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Toolbar",this.prototype.default_view=o.ToolbarBaseView,this.define({active_drag:[r.Any,"auto"],active_inspect:[r.Any,"auto"],active_scroll:[r.Any,"auto"],active_tap:[r.Any,"auto"],active_multi:[r.Any,null]})},t.prototype.initialize=function(){e.prototype.initialize.call(this),this._init_tools()},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.properties.tools.change,function(){return t._init_tools()})},t.prototype._init_tools=function(){for(var e=this,t=function(e){if(e instanceof w.InspectTool)g.any(s.inspectors,function(t){return t.id==e.id})||(s.inspectors=s.inspectors.concat([e]));else if(e instanceof b.HelpTool)g.any(s.help,function(t){return t.id==e.id})||(s.help=s.help.concat([e]));else if(e instanceof y.ActionTool)g.any(s.actions,function(t){return t.id==e.id})||(s.actions=s.actions.concat([e]));else if(e instanceof x.GestureTool){var t=void 0,i=void 0;m.isString(e.event_type)?(t=[e.event_type],i=!1):(t=e.event_type||[],i=!0);for(var n=0,r=t;n<r.length;n++){var o=r[n];o in s.gestures?(i&&(o="multi"),g.any(s.gestures[o].tools,function(t){return t.id==e.id})||(s.gestures[o].tools=s.gestures[o].tools.concat([e])),s.connect(e.properties.active.change,s._active_change.bind(s,e))):v.logger.warn("Toolbar: unknown event type '"+o+"' for tool: "+e.type+" ("+e.id+")")}}},s=this,i=0,n=this.tools;i<n.length;i++){var r=n[i];t(r)}if("auto"==this.active_inspect);else if(this.active_inspect instanceof w.InspectTool)for(var o=0,a=this.inspectors;o<a.length;o++){var l=a[o];l!=this.active_inspect&&(l.active=!1)}else if(m.isArray(this.active_inspect))for(var h=0,u=this.inspectors;h<u.length;h++){var l=u[h];g.includes(this.active_inspect,l)||(l.active=!1)}else if(null==this.active_inspect)for(var c=0,_=this.inspectors;c<_.length;c++){var l=_[c];l.active=!1}var p=function(t){t.active?e._active_change(t):t.active=!0};for(var d in this.gestures){var f=this.gestures[d];if(0!=f.tools.length){if(f.tools=g.sortBy(f.tools,function(t){return t.default_order}),"tap"==d){if(null==this.active_tap)continue;"auto"==this.active_tap?p(f.tools[0]):p(this.active_tap)}if("pan"==d){if(null==this.active_drag)continue;"auto"==this.active_drag?p(f.tools[0]):p(this.active_drag)}if("pinch"==d||"scroll"==d){if(null==this.active_scroll||"auto"==this.active_scroll)continue;p(this.active_scroll)}null!=this.active_multi&&p(this.active_multi)}}},t}(o.ToolbarBase);(i.Toolbar=s).initClass()},function(t,e,i){var n=t(391),a=t(14),c=t(5),r=t(4),o=t(15),s=t(6),l=t(44),h=t(59),u=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="ToolbarBase",this.define({_visible:[o.Bool,null],autohide:[o.Bool,!1]})},Object.defineProperty(t.prototype,"visible",{get:function(){return!this.autohide||null!=this._visible&&this._visible},enumerable:!0,configurable:!0}),t}(h.Model);(i.ToolbarViewModel=u).initClass();var _=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),this._tool_button_views={},this._build_tool_button_views(),this._toolbar_view_model=new u({autohide:this.model.autohide})},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.tools.change,function(){return t._build_tool_button_views()}),this.connect(this.model.properties.autohide.change,function(){t._toolbar_view_model.autohide=t.model.autohide,t._on_visible_change()}),this.connect(this._toolbar_view_model.properties._visible.change,function(){return t._on_visible_change()})},t.prototype.remove=function(){r.remove_views(this._tool_button_views),e.prototype.remove.call(this)},t.prototype._build_tool_button_views=function(){var t=null!=this.model._proxied_tools?this.model._proxied_tools:this.model.tools;r.build_views(this._tool_button_views,t,{parent:this},function(t){return t.button_view})},t.prototype.set_visibility=function(t){t!=this._toolbar_view_model._visible&&(this._toolbar_view_model._visible=t)},t.prototype._on_visible_change=function(){var t=this._toolbar_view_model.visible,e="bk-toolbar-hidden";this.el.classList.contains(e)&&t?this.el.classList.remove(e):t||this.el.classList.add(e)},t.prototype.render=function(){var e=this;if(c.empty(this.el),this.el.classList.add("bk-toolbar"),this.el.classList.add("bk-toolbar-"+this.model.toolbar_location),this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change(),null!=this.model.logo){var t="grey"===this.model.logo?"bk-grey":null,i=c.a({href:"https://bokeh.pydata.org/",target:"_blank",class:["bk-logo","bk-logo-small",t]});this.el.appendChild(i)}var n=[],r=function(t){return e._tool_button_views[t.id].el},o=this.model.gestures;for(var s in o)n.push(o[s].tools.map(r));n.push(this.model.actions.map(r)),n.push(this.model.inspectors.filter(function(t){return t.toggleable}).map(r)),n.push(this.model.help.map(r));for(var a=0,l=n;a<l.length;a++){var h=l[a];if(0!==h.length){var u=c.div({class:"bk-button-bar"},h);this.el.appendChild(u)}}},t}(s.DOMView);i.ToolbarBaseView=_;var p=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="ToolbarBase",this.prototype.default_view=_,this.define({tools:[o.Array,[]],logo:[o.String,"normal"],autohide:[o.Bool,!1]}),this.internal({gestures:[o.Any,function(){return{pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}}}],actions:[o.Array,[]],inspectors:[o.Array,[]],help:[o.Array,[]],toolbar_location:[o.Location,"right"]})},Object.defineProperty(t.prototype,"horizontal",{get:function(){return"above"===this.toolbar_location||"below"===this.toolbar_location},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"vertical",{get:function(){return"left"===this.toolbar_location||"right"===this.toolbar_location},enumerable:!0,configurable:!0}),t.prototype._active_change=function(t){var e=t.event_type;if(null!=e)for(var i=l.isString(e)?[e]:e,n=0,r=i;n<r.length;n++){var o=r[n];if(t.active){var s=this.gestures[o].active;null!=s&&t!=s&&(a.logger.debug("Toolbar: deactivating tool: "+s.type+" ("+s.id+") for event type '"+o+"'"),s.active=!1),this.gestures[o].active=t,a.logger.debug("Toolbar: activating tool: "+t.type+" ("+t.id+") for event type '"+o+"'")}else this.gestures[o].active=null}},t}(h.Model);(i.ToolbarBase=p).initClass()},function(t,e,i){var n=t(391),r=t(15),o=t(5),a=t(14),l=t(44),E=t(21),h=t(232),u=t(234),c=t(251),_=t(264),s=t(269),M=t(267),p=t(157),d=t(4),f=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="ProxyToolbar"},t.prototype.initialize=function(){e.prototype.initialize.call(this),this._init_tools(),this._merge_tools()},t.prototype._init_tools=function(){for(var t=function(e){if(e instanceof _.InspectTool)E.any(s.inspectors,function(t){return t.id==e.id})||(s.inspectors=s.inspectors.concat([e]));else if(e instanceof u.HelpTool)E.any(s.help,function(t){return t.id==e.id})||(s.help=s.help.concat([e]));else if(e instanceof h.ActionTool)E.any(s.actions,function(t){return t.id==e.id})||(s.actions=s.actions.concat([e]));else if(e instanceof c.GestureTool){var t=void 0,i=void 0;l.isString(e.event_type)?(t=[e.event_type],i=!1):(t=e.event_type||[],i=!0);for(var n=0,r=t;n<r.length;n++){var o=r[n];o in s.gestures?(i&&(o="multi"),E.any(s.gestures[o].tools,function(t){return t.id==e.id})||(s.gestures[o].tools=s.gestures[o].tools.concat([e]))):a.logger.warn("Toolbar: unknown event type '"+o+"' for tool: "+e.type+" ("+e.id+")")}}},s=this,e=0,i=this.tools;e<i.length;e++){var n=i[e];t(n)}},t.prototype._merge_tools=function(){var t,n=this;this._proxied_tools=[];for(var e={},i={},r={},o=[],s=[],a=0,l=this.help;a<l.length;a++){var h=l[a];E.includes(s,h.redirect)||(o.push(h),s.push(h.redirect))}for(var u in(t=this._proxied_tools).push.apply(t,o),this.help=o,this.gestures){var c=this.gestures[u];u in r||(r[u]={});for(var _=0,p=c.tools;_<p.length;_++){var d=p[_];d.type in r[u]||(r[u][d.type]=[]),r[u][d.type].push(d)}}for(var f=0,v=this.inspectors;f<v.length;f++){var d=v[f];d.type in e||(e[d.type]=[]),e[d.type].push(d)}for(var m=0,g=this.actions;m<g.length;m++){var d=g[m];d.type in i||(i[d.type]=[]),i[d.type].push(d)}var y=function(t,e){void 0===e&&(e=!1);var i=new M.ToolProxy({tools:t,active:e});return n._proxied_tools.push(i),i};for(var u in r){var c=this.gestures[u];for(var b in c.tools=[],r[u]){var x=r[u][b];if(0<x.length)if("multi"==u)for(var w=0,k=x;w<k.length;w++){var d=k[w],S=y([d]);c.tools.push(S),this.connect(S.properties.active.change,this._active_change.bind(this,S))}else{var S=y(x);c.tools.push(S),this.connect(S.properties.active.change,this._active_change.bind(this,S))}}}for(var b in this.actions=[],i){var x=i[b];if("CustomAction"==b)for(var C=0,T=x;C<T.length;C++){var d=T[C];this.actions.push(y([d]))}else 0<x.length&&this.actions.push(y(x))}for(var b in this.inspectors=[],e){var x=e[b];0<x.length&&this.inspectors.push(y(x,!0))}for(var A in this.gestures){var c=this.gestures[A];0!=c.tools.length&&(c.tools=E.sortBy(c.tools,function(t){return t.default_order}),"pinch"!=A&&"scroll"!=A&&"multi"!=A&&(c.tools[0].active=!0))}},t}(s.ToolbarBase);(i.ProxyToolbar=f).initClass();var v=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n.__extends(t,e),t.prototype.initialize=function(t){e.prototype.initialize.call(this,t),this.model.toolbar.toolbar_location=this.model.toolbar_location,this._toolbar_views={},d.build_views(this._toolbar_views,[this.model.toolbar],{parent:this})},t.prototype.remove=function(){d.remove_views(this._toolbar_views),e.prototype.remove.call(this)},t.prototype.css_classes=function(){return e.prototype.css_classes.call(this).concat("bk-toolbar-box")},t.prototype.render=function(){e.prototype.render.call(this);var t=this._toolbar_views[this.model.toolbar.id];t.render(),o.empty(this.el),this.el.appendChild(t.el)},t.prototype.get_width=function(){return this.model.toolbar.vertical?30:null},t.prototype.get_height=function(){return this.model.toolbar.horizontal?30:null},t}(p.LayoutDOMView);i.ToolbarBoxView=v;var m=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="ToolbarBox",this.prototype.default_view=v,this.define({toolbar:[r.Instance],toolbar_location:[r.Location,"right"]})},Object.defineProperty(t.prototype,"sizing_mode",{get:function(){switch(this.toolbar_location){case"above":case"below":return"scale_width";case"left":case"right":return"scale_height"}},enumerable:!0,configurable:!0}),t}(p.LayoutDOM);(i.ToolbarBox=m).initClass()},function(t,e,i){var r=t(21),o=t(185),s=t(186);i.compute_renderers=function(t,e,i){return null==t?[]:(n="auto"==t?e.filter(function(t){return t instanceof o.GlyphRenderer||t instanceof s.GraphRenderer}):t,0<i.length&&(n=n.filter(function(t){return r.includes(i,t.name)})),n);var n}},function(i,t,e){var n=i(391),r=i(279),o=i(15),s=i(32),a=i(38),l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="CustomJSTransform",this.define({args:[o.Any,{}],func:[o.String,""],v_func:[o.String,""],use_strict:[o.Boolean,!1]})},Object.defineProperty(t.prototype,"names",{get:function(){return s.keys(this.args)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"values",{get:function(){return s.values(this.args)},enumerable:!0,configurable:!0}),t.prototype._make_transform=function(t,e){var i=this.use_strict?a.use_strict(e):e;return new(Function.bind.apply(Function,[void 0].concat(this.names,[t,"require","exports",i])))},Object.defineProperty(t.prototype,"scalar_transform",{get:function(){return this._make_transform("x",this.func)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"vector_transform",{get:function(){return this._make_transform("xs",this.v_func)},enumerable:!0,configurable:!0}),t.prototype.compute=function(t){return this.scalar_transform.apply(this,this.values.concat([t,i,{}]))},t.prototype.v_compute=function(t){return this.vector_transform.apply(this,this.values.concat([t,i,{}]))},t}(r.Transform);(e.CustomJSTransform=l).initClass()},function(t,e,i){var n=t(391),r=t(279),o=t(181),s=t(15),a=t(44),l=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Dodge",this.define({value:[s.Number,0],range:[s.Instance]})},t.prototype.v_compute=function(t){var e;if(this.range instanceof o.FactorRange)e=this.range.v_synthetic(t);else{if(!a.isArrayableOf(t,a.isNumber))throw new Error("unexpected");e=t}for(var i=new Float64Array(e.length),n=0;n<e.length;n++){var r=e[n];i[n]=this._compute(r)}return i},t.prototype.compute=function(t){if(this.range instanceof o.FactorRange)return this._compute(this.range.synthetic(t));if(a.isNumber(t))return this._compute(t);throw new Error("unexpected")},t.prototype._compute=function(t){return t+this.value},t}(r.Transform);(i.Dodge=l).initClass()},function(t,e,i){var n=t(272);i.CustomJSTransform=n.CustomJSTransform;var r=t(273);i.Dodge=r.Dodge;var o=t(275);i.Interpolator=o.Interpolator;var s=t(276);i.Jitter=s.Jitter;var a=t(277);i.LinearInterpolator=a.LinearInterpolator;var l=t(278);i.StepInterpolator=l.StepInterpolator;var h=t(279);i.Transform=h.Transform},function(t,e,i){var n=t(391),r=t(279),o=t(15),c=t(21),_=t(44),s=function(i){function t(t){var e=i.call(this,t)||this;return e._sorted_dirty=!0,e}return n.__extends(t,i),t.initClass=function(){this.prototype.type="Interpolator",this.define({x:[o.Any],y:[o.Any],data:[o.Any],clip:[o.Bool,!0]})},t.prototype.connect_signals=function(){var t=this;i.prototype.connect_signals.call(this),this.connect(this.change,function(){return t._sorted_dirty=!0})},t.prototype.v_compute=function(t){for(var e=new Float64Array(t.length),i=0;i<t.length;i++){var n=t[i];e[i]=this.compute(n)}return e},t.prototype.sort=function(t){if(void 0===t&&(t=!1),this._sorted_dirty){var e,i;if(_.isString(this.x)&&_.isString(this.y)&&null!=this.data){var n=this.data.columns();if(!c.includes(n,this.x))throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");if(!c.includes(n,this.y))throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");e=this.data.get_column(this.x),i=this.data.get_column(this.y)}else{if(!_.isArray(this.x)||!_.isArray(this.y))throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");e=this.x,i=this.y}if(e.length!==i.length)throw new Error("The length for x and y do not match");if(e.length<2)throw new Error("x and y must have at least two elements to support interpolation");var r=[];for(var o in e)r.push({x:e[o],y:i[o]});t?r.sort(function(t,e){return t.x>e.x?-1:t.x==e.x?0:1}):r.sort(function(t,e){return t.x<e.x?-1:t.x==e.x?0:1}),this._x_sorted=[],this._y_sorted=[];for(var s=0,a=r;s<a.length;s++){var l=a[s],h=l.x,u=l.y;this._x_sorted.push(h),this._y_sorted.push(u)}this._sorted_dirty=!1}},t}(r.Transform);(i.Interpolator=s).initClass()},function(t,e,i){var n=t(391),r=t(279),o=t(181),s=t(44),a=t(15),l=t(31),h=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Jitter",this.define({mean:[a.Number,0],width:[a.Number,1],distribution:[a.Distribution,"uniform"],range:[a.Instance]}),this.internal({previous_values:[a.Array]})},t.prototype.v_compute=function(t){if(null!=this.previous_values&&this.previous_values.length==t.length)return this.previous_values;var e;if(this.range instanceof o.FactorRange)e=this.range.v_synthetic(t);else{if(!s.isArrayableOf(t,s.isNumber))throw new Error("unexpected");e=t}for(var i=new Float64Array(e.length),n=0;n<e.length;n++){var r=e[n];i[n]=this._compute(r)}return this.previous_values=i},t.prototype.compute=function(t){if(this.range instanceof o.FactorRange)return this._compute(this.range.synthetic(t));if(s.isNumber(t))return this._compute(t);throw new Error("unexpected")},t.prototype._compute=function(t){switch(this.distribution){case"uniform":return t+this.mean+(l.random()-.5)*this.width;case"normal":return t+l.rnorm(this.mean,this.width)}},t}(r.Transform);(i.Jitter=h).initClass()},function(t,e,i){var n=t(391),s=t(21),r=t(275),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="LinearInterpolator"},t.prototype.compute=function(e){if(this.sort(!1),this.clip){if(e<this._x_sorted[0]||e>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(e<this._x_sorted[0])return this._y_sorted[0];if(e>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}if(e==this._x_sorted[0])return this._y_sorted[0];var t=s.findLastIndex(this._x_sorted,function(t){return t<e}),i=this._x_sorted[t],n=this._x_sorted[t+1],r=this._y_sorted[t],o=this._y_sorted[t+1];return r+(e-i)/(n-i)*(o-r)},t}(r.Interpolator);(i.LinearInterpolator=o).initClass()},function(t,e,i){var n=t(391),r=t(275),o=t(15),s=t(21),a=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="StepInterpolator",this.define({mode:[o.StepMode,"after"]})},t.prototype.compute=function(e){if(this.sort(!1),this.clip){if(e<this._x_sorted[0]||e>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(e<this._x_sorted[0])return this._y_sorted[0];if(e>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}var t;switch(this.mode){case"after":t=s.findLastIndex(this._x_sorted,function(t){return t<=e});break;case"before":t=s.findIndex(this._x_sorted,function(t){return e<=t});break;case"center":var i=this._x_sorted.map(function(t){return Math.abs(t-e)}),n=s.min(i);t=s.findIndex(i,function(t){return n===t});break;default:throw new Error("unknown mode: "+this.mode)}return-1!=t?this._y_sorted[t]:NaN},t}(r.Interpolator);(i.StepInterpolator=a).initClass()},function(t,e,i){var n=t(391),r=t(59),o=function(e){function t(t){return e.call(this,t)||this}return n.__extends(t,e),t.initClass=function(){this.prototype.type="Transform"},t}(r.Model);(i.Transform=o).initClass()},function(t,e,i){"function"!=typeof WeakMap&&t(342),Number.isInteger||(Number.isInteger=function(t){return"number"==typeof t&&isFinite(t)&&Math.floor(t)===t});var n,l,r,h,o=String.prototype;o.repeat||(o.repeat=function(t){if(null==this)throw new TypeError("can't convert "+this+" to object");var e=""+this;if((t=+t)!=t&&(t=0),t<0)throw new RangeError("repeat count must be non-negative");if(t==1/0)throw new RangeError("repeat count must be less than infinity");if(t=Math.floor(t),0==e.length||0==t)return"";if(e.length*t>=1<<28)throw new RangeError("repeat count must not overflow maximum string size");for(var i="";1==(1&t)&&(i+=e),0!=(t>>>=1);)e+=e;return i}),Array.from||(Array.from=(n=Object.prototype.toString,l=function(t){return"function"==typeof t||"[object Function]"===n.call(t)},r=Math.pow(2,53)-1,h=function(t){var e,i=(e=Number(t),isNaN(e)?0:0!==e&&isFinite(e)?(0<e?1:-1)*Math.floor(Math.abs(e)):e);return Math.min(Math.max(i,0),r)},function(t){var e=Object(t);if(null==t)throw new TypeError("Array.from requires an array-like object - not null or undefined");var i,n=1<arguments.length?arguments[1]:void 0;if(void 0!==n){if(!l(n))throw new TypeError("Array.from: when provided, the second argument must be a function");2<arguments.length&&(i=arguments[2])}for(var r=h(e.length),o=l(this)?Object(new this(r)):new Array(r),s=0
// 13. If IsConstructor(C) is true, then
;s<r;){var a=e[s];o[s]=n?void 0===i?n(a,s):n.call(i,a,s):a,s+=1}return o.length=r,o}))},function(t,e,i){var n=t(391);n.__exportStar(t(282),i),n.__exportStar(t(283),i)},function(t,e,i){var n=t(38),r=function(){function s(t,e,i){this.header=t,this.metadata=e,this.content=i,this.buffers=[]}return s.assemble=function(t,e,i){var n=JSON.parse(t),r=JSON.parse(e),o=JSON.parse(i);return new s(n,r,o)},s.prototype.assemble_buffer=function(t,e){var i=null!=this.header.num_buffers?this.header.num_buffers:0;if(i<=this.buffers.length)throw new Error("too many buffers received, expecting #{nb}");this.buffers.push([t,e])},s.create=function(t,e,i){void 0===i&&(i={});var n=s.create_header(t);return new s(n,e,i)},s.create_header=function(t){return{msgid:n.uniqueId(),msgtype:t}},s.prototype.complete=function(){return!(null==this.header||null==this.metadata||null==this.content||"num_buffers"in this.header&&this.buffers.length!==this.header.num_buffers)},s.prototype.send=function(t){var e=null!=this.header.num_buffers?this.header.num_buffers:0;if(0<e)throw new Error("BokehJS only supports receiving buffers, not sending");var i=JSON.stringify(this.header),n=JSON.stringify(this.metadata),r=JSON.stringify(this.content);t.send(i),t.send(n),t.send(r)},s.prototype.msgid=function(){return this.header.msgid},s.prototype.msgtype=function(){return this.header.msgtype},s.prototype.reqid=function(){return this.header.reqid},s.prototype.problem=function(){return"msgid"in this.header?"msgtype"in this.header?null:"No msgtype in header":"No msgid in header"},s}();i.Message=r},function(t,e,i){var o=t(282),n=function(){function t(){this.message=null,this._partial=null,this._fragments=[],this._buf_header=null,this._current_consumer=this._HEADER}return t.prototype.consume=function(t){this._current_consumer(t)},t.prototype._HEADER=function(t){this._assume_text(t),this.message=null,this._partial=null,this._fragments=[t],this._buf_header=null,this._current_consumer=this._METADATA},t.prototype._METADATA=function(t){this._assume_text(t),this._fragments.push(t),this._current_consumer=this._CONTENT},t.prototype._CONTENT=function(t){this._assume_text(t),this._fragments.push(t);var e=this._fragments.slice(0,3),i=e[0],n=e[1],r=e[2];this._partial=o.Message.assemble(i,n,r),this._check_complete()},t.prototype._BUFFER_HEADER=function(t){this._assume_text(t),this._buf_header=t,this._current_consumer=this._BUFFER_PAYLOAD},t.prototype._BUFFER_PAYLOAD=function(t){this._assume_binary(t),this._partial.assemble_buffer(this._buf_header,t),this._check_complete()},t.prototype._assume_text=function(t){if(t instanceof ArrayBuffer)throw new Error("Expected text fragment but received binary fragment")},t.prototype._assume_binary=function(t){if(!(t instanceof ArrayBuffer))throw new Error("Expected binary fragment but received text fragment")},t.prototype._check_complete=function(){this._partial.complete()?(this.message=this._partial,this._current_consumer=this._HEADER):this._current_consumer=this._BUFFER_HEADER},t}();i.Receiver=n},function(t,e,i){i.safely=function(t,e){void 0===e&&(e=!1);try{return t()}catch(t){if(function(t){var e=document.createElement("div");e.style.backgroundColor="#f2dede",e.style.border="1px solid #a94442",e.style.borderRadius="4px",e.style.display="inline-block",e.style.fontFamily="sans-serif",e.style.marginTop="5px",e.style.minWidth="200px",e.style.padding="5px 5px 5px 10px",e.classList.add("bokeh-error-box-into-flames");var i=document.createElement("span");i.style.backgroundColor="#a94442",i.style.borderRadius="0px 4px 0px 0px",i.style.color="white",i.style.cursor="pointer",i.style.cssFloat="right",i.style.fontSize="0.8em",i.style.margin="-6px -6px 0px 0px",i.style.padding="2px 5px 4px 5px",i.title="close",i.setAttribute("aria-label","close"),i.appendChild(document.createTextNode("x")),i.addEventListener("click",function(){return s.removeChild(e)});var n=document.createElement("h3");n.style.color="#a94442",n.style.margin="8px 0px 0px 0px",n.style.padding="0px",n.appendChild(document.createTextNode("Bokeh Error"));var r=document.createElement("pre");r.style.whiteSpace="unset",r.style.overflowX="auto";var o=t instanceof Error?t.message:t;r.appendChild(document.createTextNode(o)),e.appendChild(i),e.appendChild(n),e.appendChild(r);var s=document.getElementsByTagName("body")[0];s.insertBefore(e,s.firstChild)}(t),e)return;throw t}}},function(t,e,n){function r(){var t=document.getElementsByTagName("body")[0],e=document.getElementsByClassName("bokeh-test-div");1==e.length&&t.removeChild(e[0]),delete e[0];var i=document.createElement("div");i.classList.add("bokeh-test-div"),i.style.display="none",t.insertBefore(i,t.firstChild)}n.results={},n.init=function(){r()},n.record=function(t,e){n.results[t]=e,r()},n.count=function(t){null==n.results[t]&&(n.results[t]=0),n.results[t]+=1,r()},n.clear=function(){for(var t=0,e=Object.keys(n.results);t<e.length;t++){var i=e[t];delete n.results[i]}r()}},function(t,e,i){i.version="1.0.1"},function(t,e,i){!function(){"use strict";var _,x,p,d,a;function f(t,e){var i,n=Object.keys(e);for(i=0;i<n.length;i++)t=t.replace(new RegExp("\\{"+n[i]+"\\}","gi"),e[n[i]]);return t}function l(t){var e,i,n;if(!t)throw new Error("cannot create a random attribute name for an undefined object");e="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz",i="";do{for(i="",n=0;n<12;n++)i+=e[Math.floor(Math.random()*e.length)]}while(t[i]);return i}a=function(t,e){var i,n,r,o={};for(t=t.split(","),e=e||10,i=0;i<t.length;i+=2)n="&"+t[i+1]+";",r=parseInt(t[i],e),o[n]="&#"+r+";";return o["\\xa0"]="&#160;",o}("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),_={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}},(p=function(t,e){this.__root=t,this.__ctx=e}).prototype.addColorStop=function(t,e){var i,n=this.__ctx.__createElement("stop");n.setAttribute("offset",t),-1!==e.indexOf("rgba")?(i=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(e),n.setAttribute("stop-color",f("rgb({r},{g},{b})",{r:i[1],g:i[2],b:i[3]})),n.setAttribute("stop-opacity",i[4])):n.setAttribute("stop-color",e),this.__root.appendChild(n)},d=function(t,e){this.__root=t,this.__ctx=e},(x=function(t){var e,i={width:500,height:500,enableMirroring:!1};if(1<arguments.length?((e=i).width=t,e.height=arguments[1]):e=t||i,!(this instanceof x))return new x(e);this.width=e.width||i.width,this.height=e.height||i.height,this.enableMirroring=void 0!==e.enableMirroring?e.enableMirroring:i.enableMirroring,(this.canvas=this).__document=e.document||document,e.ctx?this.__ctx=e.ctx:(this.__canvas=this.__document.createElement("canvas"),this.__ctx=this.__canvas.getContext("2d")),this.__setDefaultStyles(),this.__stack=[this.__getStyleState()],this.__groupStack=[],this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg"),this.__root.setAttribute("version",1.1),this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink"),this.__root.setAttribute("width",this.width),this.__root.setAttribute("height",this.height),this.__ids={},this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs"),this.__root.appendChild(this.__defs),this.__currentElement=this.__document.createElementNS("http://www.w3.org/2000/svg","g"),this.__root.appendChild(this.__currentElement)}).prototype.__createElement=function(t,e,i){void 0===e&&(e={});var n,r,o=this.__document.createElementNS("http://www.w3.org/2000/svg",t),s=Object.keys(e);for(i&&(o.setAttribute("fill","none"),o.setAttribute("stroke","none")),n=0;n<s.length;n++)r=s[n],o.setAttribute(r,e[r]);return o},x.prototype.__setDefaultStyles=function(){var t,e,i=Object.keys(_);for(t=0;t<i.length;t++)this[e=i[t]]=_[e].canvas},x.prototype.__applyStyleState=function(t){var e,i,n=Object.keys(t);for(e=0;e<n.length;e++)this[i=n[e]]=t[i]},x.prototype.__getStyleState=function(){var t,e,i={},n=Object.keys(_);for(t=0;t<n.length;t++)e=n[t],i[e]=this[e];return i},x.prototype.__applyStyleToCurrentElement=function(e){var t=this.__currentElement,i=this.__currentElementsToStyle;i&&(t.setAttribute(e,""),t=i.element,i.children.forEach(function(t){t.setAttribute(e,"")}));var n,r,o,s,a,l=Object.keys(_);for(n=0;n<l.length;n++)if(r=_[l[n]],o=this[l[n]],r.apply)if(o instanceof d){if(o.__ctx)for(;o.__ctx.__defs.childNodes.length;)s=o.__ctx.__defs.childNodes[0].getAttribute("id"),this.__ids[s]=s,this.__defs.appendChild(o.__ctx.__defs.childNodes[0]);t.setAttribute(r.apply,f("url(#{id})",{id:o.__root.getAttribute("id")}))}else if(o instanceof p)t.setAttribute(r.apply,f("url(#{id})",{id:o.__root.getAttribute("id")}));else if(-1!==r.apply.indexOf(e)&&r.svg!==o)if("stroke"!==r.svgAttr&&"fill"!==r.svgAttr||-1===o.indexOf("rgba")){var h=r.svgAttr;if("globalAlpha"===l[n]&&(h=e+"-"+r.svgAttr,t.getAttribute(h)))continue;t.setAttribute(h,o)}else{a=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(o),t.setAttribute(r.svgAttr,f("rgb({r},{g},{b})",{r:a[1],g:a[2],b:a[3]}));var u=a[4],c=this.globalAlpha;null!=c&&(u*=c),t.setAttribute(r.svgAttr+"-opacity",u)}},x.prototype.__closestGroupOrSvg=function(t){return"g"===(t=t||this.__currentElement).nodeName||"svg"===t.nodeName?t:this.__closestGroupOrSvg(t.parentNode)},x.prototype.getSerializedSvg=function(t){var e,i,n,r,o,s=(new XMLSerializer).serializeToString(this.__root);if(/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi.test(s)&&(s=s.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')),t)for(e=Object.keys(a),i=0;i<e.length;i++)n=e[i],r=a[n],(o=new RegExp(n,"gi")).test(s)&&(s=s.replace(o,r));return s},x.prototype.getSvg=function(){return this.__root},x.prototype.save=function(){var t=this.__createElement("g"),e=this.__closestGroupOrSvg();this.__groupStack.push(e),e.appendChild(t),this.__currentElement=t,this.__stack.push(this.__getStyleState())},x.prototype.restore=function(){this.__currentElement=this.__groupStack.pop(),this.__currentElementsToStyle=null,this.__currentElement||(this.__currentElement=this.__root.childNodes[1]);var t=this.__stack.pop();this.__applyStyleState(t)},x.prototype.__addTransform=function(t){var e=this.__closestGroupOrSvg();if(0<e.childNodes.length){"path"===this.__currentElement.nodeName&&(this.__currentElementsToStyle||(this.__currentElementsToStyle={element:e,children:[]}),this.__currentElementsToStyle.children.push(this.__currentElement),this.__applyCurrentDefaultPath());var i=this.__createElement("g");e.appendChild(i),this.__currentElement=i}var n=this.__currentElement.getAttribute("transform");n?n+=" ":n="",n+=t,this.__currentElement.setAttribute("transform",n)},x.prototype.scale=function(t,e){void 0===e&&(e=t),this.__addTransform(f("scale({x},{y})",{x:t,y:e}))},x.prototype.rotate=function(t){var e=180*t/Math.PI;this.__addTransform(f("rotate({angle},{cx},{cy})",{angle:e,cx:0,cy:0}))},x.prototype.translate=function(t,e){this.__addTransform(f("translate({x},{y})",{x:t,y:e}))},x.prototype.transform=function(t,e,i,n,r,o){this.__addTransform(f("matrix({a},{b},{c},{d},{e},{f})",{a:t,b:e,c:i,d:n,e:r,f:o}))},x.prototype.beginPath=function(){var t;this.__currentDefaultPath="",this.__currentPosition={},t=this.__createElement("path",{},!0),this.__closestGroupOrSvg().appendChild(t),this.__currentElement=t},x.prototype.__applyCurrentDefaultPath=function(){var t=this.__currentElement;"path"===t.nodeName?t.setAttribute("d",this.__currentDefaultPath):console.error("Attempted to apply path command to node",t.nodeName)},x.prototype.__addPathCommand=function(t){this.__currentDefaultPath+=" ",this.__currentDefaultPath+=t},x.prototype.moveTo=function(t,e){"path"!==this.__currentElement.nodeName&&this.beginPath(),this.__currentPosition={x:t,y:e},this.__addPathCommand(f("M {x} {y}",{x:t,y:e}))},x.prototype.closePath=function(){this.__currentDefaultPath&&this.__addPathCommand("Z")},x.prototype.lineTo=function(t,e){this.__currentPosition={x:t,y:e},-1<this.__currentDefaultPath.indexOf("M")?this.__addPathCommand(f("L {x} {y}",{x:t,y:e})):this.__addPathCommand(f("M {x} {y}",{x:t,y:e}))},x.prototype.bezierCurveTo=function(t,e,i,n,r,o){this.__currentPosition={x:r,y:o},this.__addPathCommand(f("C {cp1x} {cp1y} {cp2x} {cp2y} {x} {y}",{cp1x:t,cp1y:e,cp2x:i,cp2y:n,x:r,y:o}))},x.prototype.quadraticCurveTo=function(t,e,i,n){this.__currentPosition={x:i,y:n},this.__addPathCommand(f("Q {cpx} {cpy} {x} {y}",{cpx:t,cpy:e,x:i,y:n}))};var b=function(t){var e=Math.sqrt(t[0]*t[0]+t[1]*t[1]);return[t[0]/e,t[1]/e]};x.prototype.arcTo=function(t,e,i,n,r){var o=this.__currentPosition&&this.__currentPosition.x,s=this.__currentPosition&&this.__currentPosition.y;if(void 0!==o&&void 0!==s){if(r<0)throw new Error("IndexSizeError: The radius provided ("+r+") is negative.");if(o===t&&s===e||t===i&&e===n||0===r)this.lineTo(t,e);else{var a=b([o-t,s-e]),l=b([i-t,n-e]);if(a[0]*l[1]!=a[1]*l[0]){var h=a[0]*l[0]+a[1]*l[1],u=Math.acos(Math.abs(h)),c=b([a[0]+l[0],a[1]+l[1]]),_=r/Math.sin(u/2),p=t+_*c[0],d=e+_*c[1],f=[-a[1],a[0]],v=[l[1],-l[0]],m=function(t){var e=t[0],i=t[1];return 0<=i?Math.acos(e):-Math.acos(e)},g=m(f),y=m(v);this.lineTo(p+f[0]*r,d+f[1]*r),this.arc(p,d,r,g,y)}else this.lineTo(t,e)}}},x.prototype.stroke=function(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","fill stroke markers"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("stroke")},x.prototype.fill=function(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","stroke fill markers"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("fill")},x.prototype.rect=function(t,e,i,n){"path"!==this.__currentElement.nodeName&&this.beginPath(),this.moveTo(t,e),this.lineTo(t+i,e),this.lineTo(t+i,e+n),this.lineTo(t,e+n),this.lineTo(t,e),this.closePath()},x.prototype.fillRect=function(t,e,i,n){var r;r=this.__createElement("rect",{x:t,y:e,width:i,height:n},!0),this.__closestGroupOrSvg().appendChild(r),this.__currentElement=r,this.__applyStyleToCurrentElement("fill")},x.prototype.strokeRect=function(t,e,i,n){var r;r=this.__createElement("rect",{x:t,y:e,width:i,height:n},!0),this.__closestGroupOrSvg().appendChild(r),this.__currentElement=r,this.__applyStyleToCurrentElement("stroke")},x.prototype.__clearCanvas=function(){for(var t=this.__closestGroupOrSvg(),e=t.getAttribute("transform"),i=this.__root.childNodes[1],n=i.childNodes,r=n.length-1;0<=r;r--)n[r]&&i.removeChild(n[r]);this.__currentElement=i,this.__groupStack=[],e&&this.__addTransform(e)},x.prototype.clearRect=function(t,e,i,n){if(0!==t||0!==e||i!==this.width||n!==this.height){var r,o=this.__closestGroupOrSvg();r=this.__createElement("rect",{x:t,y:e,width:i,height:n,fill:"#FFFFFF"},!0),o.appendChild(r)}else this.__clearCanvas()},x.prototype.createLinearGradient=function(t,e,i,n){var r=this.__createElement("linearGradient",{id:l(this.__ids),x1:t+"px",x2:i+"px",y1:e+"px",y2:n+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(r),new p(r,this)},x.prototype.createRadialGradient=function(t,e,i,n,r,o){var s=this.__createElement("radialGradient",{id:l(this.__ids),cx:n+"px",cy:r+"px",r:o+"px",fx:t+"px",fy:e+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(s),new p(s,this)},x.prototype.__parseFont=function(){var t=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font),e={style:t[1]||"normal",size:t[4]||"10px",family:t[6]||"sans-serif",weight:t[3]||"normal",decoration:t[2]||"normal",href:null};return"underline"===this.__fontUnderline&&(e.decoration="underline"),this.__fontHref&&(e.href=this.__fontHref),e},x.prototype.__wrapTextLink=function(t,e){if(t.href){var i=this.__createElement("a");return i.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",t.href),i.appendChild(e),i}return e},x.prototype.__applyText=function(t,e,i,n){var r,o,s,a,l=this.__parseFont(),h=this.__closestGroupOrSvg(),u=this.__createElement("text",{"font-family":l.family,"font-size":l.size,"font-style":l.style,"font-weight":l.weight,"text-decoration":l.decoration,x:e,y:i,"text-anchor":(s=this.textAlign,a={left:"start",right:"end",center:"middle",start:"start",end:"end"},a[s]||a.start),"dominant-baseline":(r=this.textBaseline,o={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"},o[r]||o.alphabetic)},!0);u.appendChild(this.__document.createTextNode(t)),this.__currentElement=u,this.__applyStyleToCurrentElement(n),h.appendChild(this.__wrapTextLink(l,u))},x.prototype.fillText=function(t,e,i){this.__applyText(t,e,i,"fill")},x.prototype.strokeText=function(t,e,i){this.__applyText(t,e,i,"stroke")},x.prototype.measureText=function(t){return this.__ctx.font=this.font,this.__ctx.measureText(t)},x.prototype.arc=function(t,e,i,n,r,o){if(n!==r){n%=2*Math.PI,r%=2*Math.PI,n===r&&(r=(r+2*Math.PI-.001*(o?-1:1))%(2*Math.PI));var s=t+i*Math.cos(r),a=e+i*Math.sin(r),l=t+i*Math.cos(n),h=e+i*Math.sin(n),u=o?0:1,c=0,_=r-n;_<0&&(_+=2*Math.PI),c=o?_>Math.PI?0:1:_>Math.PI?1:0,this.lineTo(l,h),this.__addPathCommand(f("A {rx} {ry} {xAxisRotation} {largeArcFlag} {sweepFlag} {endX} {endY}",{rx:i,ry:i,xAxisRotation:0,largeArcFlag:c,sweepFlag:u,endX:s,endY:a})),this.__currentPosition={x:s,y:a}}},x.prototype.clip=function(){var t=this.__closestGroupOrSvg(),e=this.__createElement("clipPath"),i=l(this.__ids),n=this.__createElement("g");this.__applyCurrentDefaultPath(),t.removeChild(this.__currentElement),e.setAttribute("id",i),e.appendChild(this.__currentElement),this.__defs.appendChild(e),t.setAttribute("clip-path",f("url(#{id})",{id:i})),t.appendChild(n),this.__currentElement=n},x.prototype.drawImage=function(){var t,e,i,n,r,o,s,a,l,h,u,c,_,p,d=Array.prototype.slice.call(arguments),f=d[0],v=0,m=0;if(3===d.length)t=d[1],e=d[2],r=f.width,o=f.height,i=r,n=o;else if(5===d.length)t=d[1],e=d[2],i=d[3],n=d[4],r=f.width,o=f.height;else{if(9!==d.length)throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length);v=d[1],m=d[2],r=d[3],o=d[4],t=d[5],e=d[6],i=d[7],n=d[8]}s=this.__closestGroupOrSvg(),this.__currentElement;var g="translate("+t+", "+e+")";if(f instanceof x){if((a=f.getSvg().cloneNode(!0)).childNodes&&1<a.childNodes.length){for(l=a.childNodes[0];l.childNodes.length;)p=l.childNodes[0].getAttribute("id"),this.__ids[p]=p,this.__defs.appendChild(l.childNodes[0]);if(h=a.childNodes[1]){var y,b=h.getAttribute("transform");y=b?b+" "+g:g,h.setAttribute("transform",y),s.appendChild(h)}}}else"IMG"===f.nodeName?((u=this.__createElement("image")).setAttribute("width",i),u.setAttribute("height",n),u.setAttribute("preserveAspectRatio","none"),(v||m||r!==f.width||o!==f.height)&&((c=this.__document.createElement("canvas")).width=i,c.height=n,(_=c.getContext("2d")).drawImage(f,v,m,r,o,0,0,i,n),f=c),u.setAttribute("transform",g),u.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","CANVAS"===f.nodeName?f.toDataURL():f.getAttribute("src")),s.appendChild(u)):"CANVAS"===f.nodeName&&((u=this.__createElement("image")).setAttribute("width",i),u.setAttribute("height",n),u.setAttribute("preserveAspectRatio","none"),(c=this.__document.createElement("canvas")).width=i,c.height=n,(_=c.getContext("2d")).imageSmoothingEnabled=!1,_.mozImageSmoothingEnabled=!1,_.oImageSmoothingEnabled=!1,_.webkitImageSmoothingEnabled=!1,_.drawImage(f,v,m,r,o,0,0,i,n),f=c,u.setAttribute("transform",g),u.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",f.toDataURL()),s.appendChild(u))},x.prototype.createPattern=function(t,e){var i,n=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),r=l(this.__ids);return n.setAttribute("id",r),n.setAttribute("width",t.width),n.setAttribute("height",t.height),"CANVAS"===t.nodeName||"IMG"===t.nodeName?((i=this.__document.createElementNS("http://www.w3.org/2000/svg","image")).setAttribute("width",t.width),i.setAttribute("height",t.height),i.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","CANVAS"===t.nodeName?t.toDataURL():t.getAttribute("src")),n.appendChild(i),this.__defs.appendChild(n)):t instanceof x&&(n.appendChild(t.__root.childNodes[1]),this.__defs.appendChild(n)),new d(n,this)},x.prototype.setLineDash=function(t){t&&0<t.length?this.lineDash=t.join(","):this.lineDash=null},x.prototype.drawFocusRing=function(){},x.prototype.createImageData=function(){},x.prototype.getImageData=function(){},x.prototype.putImageData=function(){},x.prototype.globalCompositeOperation=function(){},x.prototype.setTransform=function(){},"object"==typeof window&&(window.C2S=x),"object"==typeof e&&"object"==typeof e.exports&&(e.exports=x)}()},function(t,e,i){var n,o=t(307),r=t(317),s=t(321),a=t(316),l=t(321),h=t(323),u=Function.prototype.bind,c=Object.defineProperty,_=Object.prototype.hasOwnProperty;n=function(t,e,i){var n,r=h(e)&&l(e.value);return delete(n=o(e)).writable,delete n.value,n.get=function(){return!i.overwriteDefinition&&_.call(this,t)?r:(e.value=u.call(r,i.resolveContext?i.resolveContext(this):this),c(this,t,e),this[t])},n},e.exports=function(t){var i=r(arguments[1]);return null!=i.resolveContext&&s(i.resolveContext),a(t,function(t,e){return n(e,t,i)})}},function(t,e,i){var a=t(304),l=t(317),h=t(310),u=t(324);(e.exports=function(t,e){var i,n,r,o,s;return arguments.length<2||"string"!=typeof t?(o=e,e=t,t=null):o=arguments[2],null==t?(i=r=!0,n=!1):(i=u.call(t,"c"),n=u.call(t,"e"),r=u.call(t,"w")),s={value:e,configurable:i,enumerable:n,writable:r},o?a(l(o),s):s}).gs=function(t,e,i){var n,r,o,s;return"string"!=typeof t?(o=i,i=e,e=t,t=null):o=arguments[3],null==e?e=void 0:h(e)?null==i?i=void 0:h(i)||(o=i,i=void 0):(o=e,e=i=void 0),null==t?r=!(n=!0):(n=u.call(t,"c"),r=u.call(t,"e")),s={get:e,set:i,configurable:n,enumerable:r},o?a(l(o),s):s}},function(t,e,i){var n=t(323);e.exports=function(){return n(this).length=0,this}},function(t,e,i){e.exports=t(292)()?Array.from:t(293)},function(t,e,i){e.exports=function(){var t,e,i=Array.from;return"function"==typeof i&&(e=i(t=["raz","dwa"]),Boolean(e&&e!==t&&"dwa"===e[1]))}},function(t,e,i){var p=t(337).iterator,d=t(294),f=t(295),v=t(302),m=t(321),g=t(323),y=t(312),b=t(327),x=Array.isArray,w=Function.prototype.call,k={configurable:!0,enumerable:!0,writable:!0,value:null},S=Object.defineProperty;e.exports=function(t){var e,i,n,r,o,s,a,l,h,u,c=arguments[1],_=arguments[2];if(t=Object(g(t)),y(c)&&m(c),this&&this!==Array&&f(this))e=this;else{if(!c){if(d(t))return 1!==(o=t.length)?Array.apply(null,t):((r=new Array(1))[0]=t[0],r);if(x(t)){for(r=new Array(o=t.length),i=0;i<o;++i)r[i]=t[i];return r}}r=[]}if(!x(t))if(void 0!==(h=t[p])){for(a=m(h).call(t),e&&(r=new e),l=a.next(),i=0;!l.done;)u=c?w.call(c,_,l.value,i):l.value,e?(k.value=u,S(r,i,k)):r[i]=u,l=a.next(),++i;o=i}else if(b(t)){for(o=t.length,e&&(r=new e),n=i=0;i<o;++i)u=t[i],i+1<o&&55296<=(s=u.charCodeAt(0))&&s<=56319&&(u+=t[++i]),u=c?w.call(c,_,u,n):u,e?(k.value=u,S(r,n,k)):r[n]=u,++n;o=n}if(void 0===o)for(o=v(t.length),e&&(r=new e(o)),i=0;i<o;++i)u=c?w.call(c,_,t[i],i):t[i],e?(k.value=u,S(r,i,k)):r[i]=u;return e&&(k.value=null,r.length=o),r}},function(t,e,i){var n=Object.prototype.toString,r=n.call(function(){return arguments}());e.exports=function(t){return n.call(t)===r}},function(t,e,i){var n=Object.prototype.toString,r=n.call(t(296));e.exports=function(t){return"function"==typeof t&&n.call(t)===r}},function(t,e,i){e.exports=function(){}},function(t,e,i){e.exports=function(){return this}()},function(t,e,i){e.exports=t(299)()?Math.sign:t(300)},function(t,e,i){e.exports=function(){var t=Math.sign;return"function"==typeof t&&1===t(10)&&-1===t(-20)}},function(t,e,i){e.exports=function(t){return t=Number(t),isNaN(t)||0===t?t:0<t?1:-1}},function(t,e,i){var n=t(298),r=Math.abs,o=Math.floor;e.exports=function(t){return isNaN(t)?0:0!==(t=Number(t))&&isFinite(t)?n(t)*o(r(t)):t}},function(t,e,i){var n=t(301),r=Math.max;e.exports=function(t){return r(0,n(t))}},function(t,e,i){var a=t(321),l=t(323),h=Function.prototype.bind,u=Function.prototype.call,c=Object.keys,_=Object.prototype.propertyIsEnumerable;e.exports=function(o,s){return function(i,n){var t,r=arguments[2],e=arguments[3];return i=Object(l(i)),a(n),t=c(i),e&&t.sort("function"==typeof e?h.call(e,i):void 0),"function"!=typeof o&&(o=t[o]),u.call(o,t,function(t,e){return _.call(i,t)?u.call(n,r,i[t],t,i,e):s})}}},function(t,e,i){e.exports=t(305)()?Object.assign:t(306)},function(t,e,i){e.exports=function(){var t,e=Object.assign;return"function"==typeof e&&(e(t={foo:"raz"},{bar:"dwa"},{trzy:"trzy"}),t.foo+t.bar+t.trzy==="razdwatrzy")}},function(t,e,i){var s=t(313),a=t(323),l=Math.max;e.exports=function(e,i){var n,t,r,o=l(arguments.length,2);for(e=Object(a(e)),r=function(t){try{e[t]=i[t]}catch(t){n||(n=t)}},t=1;t<o;++t)i=arguments[t],s(i).forEach(r);if(void 0!==n)throw n;return e}},function(t,e,i){var o=t(291),s=t(304),a=t(323);e.exports=function(e){var t=Object(a(e)),i=arguments[1],n=Object(arguments[2]);if(t!==e&&!i)return t;var r={};return i?o(i,function(t){(n.ensure||t in e)&&(r[t]=e[t])}):s(r,e),r}},function(t,e,i){var n,r,o,s,a=Object.create;t(319)()||(n=t(320)),e.exports=n?1!==n.level?a:(s={configurable:(o={},!1),enumerable:(r={},!1),writable:!0,value:void 0},Object.getOwnPropertyNames(Object.prototype).forEach(function(t){o[t]="__proto__"!==t?s:{configurable:!0,enumerable:!1,writable:!0,value:void 0}}),Object.defineProperties(r,o),Object.defineProperty(n,"nullPolyfill",{configurable:!1,enumerable:!1,writable:!1,value:r}),function(t,e){return a(null===t?r:t,e)}):a},function(t,e,i){e.exports=t(303)("forEach")},function(t,e,i){e.exports=function(t){return"function"==typeof t}},function(t,e,i){var n=t(312),r={function:!0,object:!0};e.exports=function(t){return n(t)&&r[typeof t]||!1}},function(t,e,i){var n=t(296)();e.exports=function(t){return t!==n&&null!==t}},function(t,e,i){e.exports=t(314)()?Object.keys:t(315)},function(t,e,i){e.exports=function(){try{return Object.keys("primitive"),!0}catch(t){return!1}}},function(t,e,i){var n=t(312),r=Object.keys;e.exports=function(t){return r(n(t)?Object(t):t)}},function(t,e,i){var n=t(321),a=t(309),l=Function.prototype.call;e.exports=function(t,r){var o={},s=arguments[2];return n(r),a(t,function(t,e,i,n){o[e]=l.call(r,s,t,e,i,n)}),o}},function(t,e,i){var n=t(312),r=Array.prototype.forEach,o=Object.create;e.exports=function(t){var e=o(null);return r.call(arguments,function(t){n(t)&&function(t,e){var i;for(i in t)e[i]=t[i]}(Object(t),e)}),e}},function(t,e,i){e.exports=t(319)()?Object.setPrototypeOf:t(320)},function(t,e,i){var n=Object.create,r=Object.getPrototypeOf,o={};e.exports=function(){var t=Object.setPrototypeOf,e=arguments[0]||n;return"function"==typeof t&&r(t(e(null),o))===o}},function(t,e,i){var r,n,o,s,a=t(311),l=t(323),h=Object.prototype.isPrototypeOf,u=Object.defineProperty,c={configurable:!0,enumerable:!1,writable:!0,value:void 0};r=function(t,e){if(l(t),null===e||a(e))return t;throw new TypeError("Prototype must be null or an object")},e.exports=(n=function(){var t,e=Object.create(null),i={},n=Object.getOwnPropertyDescriptor(Object.prototype,"__proto__");if(n){try{(t=n.set).call(e,i)}catch(t){}if(Object.getPrototypeOf(e)===i)return{set:t,level:2}}return e.__proto__=i,Object.getPrototypeOf(e)===i?{level:2}:((e={}).__proto__=i,Object.getPrototypeOf(e)===i&&{level:1})}())?(2===n.level?n.set?(s=n.set,o=function(t,e){return s.call(r(t,e),e),t}):o=function(t,e){return r(t,e).__proto__=e,t}:o=function t(e,i){var n;return r(e,i),(n=h.call(t.nullPolyfill,e))&&delete t.nullPolyfill.__proto__,null===i&&(i=t.nullPolyfill),e.__proto__=i,n&&u(t.nullPolyfill,"__proto__",c),e},Object.defineProperty(o,"level",{configurable:!1,enumerable:!1,writable:!1,value:n.level})):null,t(308)},function(t,e,i){e.exports=function(t){if("function"!=typeof t)throw new TypeError(t+" is not a function");return t}},function(t,e,i){var n=t(311);e.exports=function(t){if(!n(t))throw new TypeError(t+" is not an Object");return t}},function(t,e,i){var n=t(312);e.exports=function(t){if(!n(t))throw new TypeError("Cannot use null or undefined");return t}},function(t,e,i){e.exports=t(325)()?String.prototype.contains:t(326)},function(t,e,i){var n="razdwatrzy";e.exports=function(){return"function"==typeof n.contains&&!0===n.contains("dwa")&&!1===n.contains("foo")}},function(t,e,i){var n=String.prototype.indexOf;e.exports=function(t){return-1<n.call(this,t,arguments[1])}},function(t,e,i){var n=Object.prototype.toString,r=n.call("");e.exports=function(t){return"string"==typeof t||t&&"object"==typeof t&&(t instanceof String||n.call(t)===r)||!1}},function(t,e,i){var n=Object.create(null),r=Math.random;e.exports=function(){for(var t;t=r().toString(36).slice(2),n[t];);return t}},function(t,e,i){var n,r=t(318),o=t(324),s=t(289),a=t(337),l=t(332),h=Object.defineProperty;n=e.exports=function(t,e){if(!(this instanceof n))throw new TypeError("Constructor requires 'new'");l.call(this,t),e=e?o.call(e,"key+value")?"key+value":o.call(e,"key")?"key":"value":"value",h(this,"__kind__",s("",e))},r&&r(n,l),delete n.prototype.constructor,n.prototype=Object.create(l.prototype,{_resolve:s(function(t){return"value"===this.__kind__?this.__list__[t]:"key+value"===this.__kind__?[t,this.__list__[t]]:t})}),h(n.prototype,a.toStringTag,s("c","Array Iterator"))},function(t,e,i){var c=t(294),_=t(321),p=t(327),d=t(331),f=Array.isArray,v=Function.prototype.call,m=Array.prototype.some;e.exports=function(t,e){var i,n,r,o,s,a,l,h,u=arguments[2];if(f(t)||c(t)?i="array":p(t)?i="string":t=d(t),_(e),r=function(){o=!0},"array"!==i)if("string"!==i)for(n=t.next();!n.done;){if(v.call(e,u,n.value,r),o)return;n=t.next()}else for(a=t.length,s=0;s<a&&(l=t[s],s+1<a&&55296<=(h=l.charCodeAt(0))&&h<=56319&&(l+=t[++s]),v.call(e,u,l,r),!o);++s);else m.call(t,function(t){return v.call(e,u,t,r),o})}},function(t,e,i){var n=t(294),r=t(327),o=t(329),s=t(334),a=t(335),l=t(337).iterator;e.exports=function(t){return"function"==typeof a(t)[l]?t[l]():n(t)?new o(t):r(t)?new s(t):new o(t)}},function(t,e,i){var n,r=t(290),o=t(304),s=t(321),a=t(323),l=t(289),h=t(288),u=t(337),c=Object.defineProperty,_=Object.defineProperties;e.exports=n=function(t,e){if(!(this instanceof n))throw new TypeError("Constructor requires 'new'");_(this,{__list__:l("w",a(t)),__context__:l("w",e),__nextIndex__:l("w",0)}),e&&(s(e.on),e.on("_add",this._onAdd),e.on("_delete",this._onDelete),e.on("_clear",this._onClear))},delete n.prototype.constructor,_(n.prototype,o({_next:l(function(){var t;if(this.__list__)return this.__redo__&&void 0!==(t=this.__redo__.shift())?t:this.__nextIndex__<this.__list__.length?this.__nextIndex__++:void this._unBind()}),next:l(function(){return this._createResult(this._next())}),_createResult:l(function(t){return void 0===t?{done:!0,value:void 0}:{done:!1,value:this._resolve(t)}}),_resolve:l(function(t){return this.__list__[t]}),_unBind:l(function(){this.__list__=null,delete this.__redo__,this.__context__&&(this.__context__.off("_add",this._onAdd),this.__context__.off("_delete",this._onDelete),this.__context__.off("_clear",this._onClear),this.__context__=null)}),toString:l(function(){return"[object "+(this[u.toStringTag]||"Object")+"]"})},h({_onAdd:l(function(i){i>=this.__nextIndex__||(++this.__nextIndex__,this.__redo__?(this.__redo__.forEach(function(t,e){i<=t&&(this.__redo__[e]=++t)},this),this.__redo__.push(i)):c(this,"__redo__",l("c",[i])))}),_onDelete:l(function(i){var t;i>=this.__nextIndex__||(--this.__nextIndex__,this.__redo__&&(-1!==(t=this.__redo__.indexOf(i))&&this.__redo__.splice(t,1),this.__redo__.forEach(function(t,e){i<t&&(this.__redo__[e]=--t)},this)))}),_onClear:l(function(){this.__redo__&&r.call(this.__redo__),this.__nextIndex__=0})}))),c(n.prototype,u.iterator,l(function(){return this}))},function(t,e,i){var n=t(294),r=t(312),o=t(327),s=t(337).iterator,a=Array.isArray;e.exports=function(t){return!(!r(t)||!a(t)&&!o(t)&&!n(t)&&"function"!=typeof t[s])}},function(t,e,i){var n,r=t(318),o=t(289),s=t(337),a=t(332),l=Object.defineProperty;n=e.exports=function(t){if(!(this instanceof n))throw new TypeError("Constructor requires 'new'");t=String(t),a.call(this,t),l(this,"__length__",o("",t.length))},r&&r(n,a),delete n.prototype.constructor,n.prototype=Object.create(a.prototype,{_next:o(function(){if(this.__list__)return this.__nextIndex__<this.__length__?this.__nextIndex__++:void this._unBind()}),_resolve:o(function(t){var e,i=this.__list__[t];return this.__nextIndex__===this.__length__?i:55296<=(e=i.charCodeAt(0))&&e<=56319?i+this.__list__[this.__nextIndex__++]:i})}),l(n.prototype,s.toStringTag,o("c","String Iterator"))},function(t,e,i){var n=t(333);e.exports=function(t){if(!n(t))throw new TypeError(t+" is not iterable");return t}},function(L,t,e){
/*!
     * @overview es6-promise - a tiny implementation of Promises/A+.
     * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
     * @license   Licensed under MIT license
     *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
     * @version   v4.2.4+314e4831
     */var i,n;i=this,n=function(){"use strict";function h(t){return"function"==typeof t}var i=Array.isArray?Array.isArray:function(t){return"[object Array]"===Object.prototype.toString.call(t)},n=0,e=void 0,r=void 0,a=function(t,e){_[n]=t,_[n+1]=e,2===(n+=2)&&(r?r(p):g())},t="undefined"!=typeof window?window:void 0,o=t||{},s=o.MutationObserver||o.WebKitMutationObserver,l="undefined"==typeof self&&"undefined"!=typeof process&&"[object process]"==={}.toString.call(process),u="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;function c(){var t=setTimeout;return function(){return t(p,1)}}var _=new Array(1e3);function p(){for(var t=0;t<n;t+=2){var e=_[t],i=_[t+1];e(i),_[t]=void 0,_[t+1]=void 0}n=0}var d,f,v,m,g=void 0;function y(t,e){var i=this,n=new this.constructor(w);void 0===n[x]&&I(n);var r=i._state;if(r){var o=arguments[r-1];a(function(){return F(r,n,o,i._result)})}else j(i,n,t,e);return n}function b(t){if(t&&"object"==typeof t&&t.constructor===this)return t;var e=new this(w);return M(e,t),e}l?g=function(){return process.nextTick(p)}:s?(f=0,v=new s(p),m=document.createTextNode(""),v.observe(m,{characterData:!0}),g=function(){m.data=f=++f%2}):u?((d=new MessageChannel).port1.onmessage=p,g=function(){return d.port2.postMessage(0)}):g=void 0===t&&"function"==typeof L?function(){try{var t=Function("return this")().require("vertx");return void 0!==(e=t.runOnLoop||t.runOnContext)?function(){e(p)}:c()}catch(t){return c()}}():c();var x=Math.random().toString(36).substring(2);function w(){}var k=void 0,S=1,C=2,T={error:null};function A(t){try{return t.then}catch(t){return T.error=t,T}}function E(t,e,i){var n,r,o,s;e.constructor===t.constructor&&i===y&&e.constructor.resolve===b?(o=t,(s=e)._state===S?z(o,s._result):s._state===C?P(o,s._result):j(s,void 0,function(t){return M(o,t)},function(t){return P(o,t)})):i===T?(P(t,T.error),T.error=null):void 0===i?z(t,e):h(i)?(n=e,r=i,a(function(e){var i=!1,t=function(t,e,i,n){try{t.call(e,i,n)}catch(t){return t}}(r,n,function(t){i||(i=!0,n!==t?M(e,t):z(e,t))},function(t){i||(i=!0,P(e,t))},e._label);!i&&t&&(i=!0,P(e,t))},t)):z(t,e)}function M(t,e){var i,n;t===e?P(t,new TypeError("You cannot resolve a promise with itself")):(n=typeof(i=e),null===i||"object"!==n&&"function"!==n?z(t,e):E(t,e,A(e)))}function O(t){t._onerror&&t._onerror(t._result),N(t)}function z(t,e){t._state===k&&(t._result=e,t._state=S,0!==t._subscribers.length&&a(N,t))}function P(t,e){t._state===k&&(t._state=C,t._result=e,a(O,t))}function j(t,e,i,n){var r=t._subscribers,o=r.length;t._onerror=null,r[o]=e,r[o+S]=i,r[o+C]=n,0===o&&t._state&&a(N,t)}function N(t){var e=t._subscribers,i=t._state;if(0!==e.length){for(var n=void 0,r=void 0,o=t._result,s=0;s<e.length;s+=3)n=e[s],r=e[s+i],n?F(i,n,r,o):r(o);t._subscribers.length=0}}function F(t,e,i,n){var r=h(i),o=void 0,s=void 0,a=void 0,l=void 0;if(r){if((o=function(t,e){try{return t(e)}catch(t){return T.error=t,T}}(i,n))===T?(l=!0,s=o.error,o.error=null):a=!0,e===o)return void P(e,new TypeError("A promises callback cannot return that same promise."))}else o=n,a=!0;e._state!==k||(r&&a?M(e,o):l?P(e,s):t===S?z(e,o):t===C&&P(e,o))}var D=0;function I(t){t[x]=D++,t._state=void 0,t._result=void 0,t._subscribers=[]}var R=function(){function t(t,e){this._instanceConstructor=t,this.promise=new t(w),this.promise[x]||I(this.promise),i(e)?(this.length=e.length,this._remaining=e.length,this._result=new Array(this.length),0===this.length?z(this.promise,this._result):(this.length=this.length||0,this._enumerate(e),0===this._remaining&&z(this.promise,this._result))):P(this.promise,new Error("Array Methods must be provided an Array"))}return t.prototype._enumerate=function(t){for(var e=0;this._state===k&&e<t.length;e++)this._eachEntry(t[e],e)},t.prototype._eachEntry=function(e,t){var i=this._instanceConstructor,n=i.resolve;if(n===b){var r=A(e);if(r===y&&e._state!==k)this._settledAt(e._state,t,e._result);else if("function"!=typeof r)this._remaining--,this._result[t]=e;else if(i===B){var o=new i(w);E(o,e,r),this._willSettleAt(o,t)}else this._willSettleAt(new i(function(t){return t(e)}),t)}else this._willSettleAt(n(e),t)},t.prototype._settledAt=function(t,e,i){var n=this.promise;n._state===k&&(this._remaining--,t===C?P(n,i):this._result[e]=i),0===this._remaining&&z(n,this._result)},t.prototype._willSettleAt=function(t,e){var i=this;j(t,void 0,function(t){return i._settledAt(S,e,t)},function(t){return i._settledAt(C,e,t)})},t}(),B=function(){function e(t){this[x]=D++,this._result=this._state=void 0,this._subscribers=[],w!==t&&("function"!=typeof t&&function(){throw new TypeError("You must pass a resolver function as the first argument to the promise constructor")}(),this instanceof e?function(e,t){try{t(function(t){M(e,t)},function(t){P(e,t)})}catch(t){P(e,t)}}(this,t):function(){throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.")}())}return e.prototype.catch=function(t){return this.then(null,t)},e.prototype.finally=function(e){var i=this.constructor;return this.then(function(t){return i.resolve(e()).then(function(){return t})},function(t){return i.resolve(e()).then(function(){throw t})})},e}();return B.prototype.then=y,B.all=function(t){return new R(this,t).promise},B.race=function(r){var o=this;return i(r)?new o(function(t,e){for(var i=r.length,n=0;n<i;n++)o.resolve(r[n]).then(t,e)}):new o(function(t,e){return e(new TypeError("You must pass an array to race."))})},B.resolve=b,B.reject=function(t){var e=new this(w);return P(e,t),e},B._setScheduler=function(t){r=t},B._setAsap=function(t){a=t},B._asap=a,B.polyfill=function(){var t=void 0;if("undefined"!=typeof global)t=global;else if("undefined"!=typeof self)t=self;else try{t=Function("return this")()}catch(t){throw new Error("polyfill failed because global object is unavailable in this environment")}var e=t.Promise;if(e){var i=null;try{i=Object.prototype.toString.call(e.resolve())}catch(t){}if("[object Promise]"===i&&!e.cast)return}t.Promise=B},B.Promise=B},"object"==typeof e&&void 0!==t?t.exports=n():i.ES6Promise=n()},function(t,e,i){e.exports=t(338)()?Symbol:t(340)},function(t,e,i){var n={object:!0,symbol:!0};e.exports=function(){var t;if("function"!=typeof Symbol)return!1;t=Symbol("test symbol");try{String(t)}catch(t){return!1}return!!n[typeof Symbol.iterator]&&!!n[typeof Symbol.toPrimitive]&&!!n[typeof Symbol.toStringTag]}},function(t,e,i){e.exports=function(t){return!!t&&("symbol"==typeof t||!!t.constructor&&"Symbol"===t.constructor.name&&"Symbol"===t[t.constructor.toStringTag])}},function(t,e,i){var n,r,o,s,a=t(289),l=t(341),h=Object.create,u=Object.defineProperties,c=Object.defineProperty,_=Object.prototype,p=h(null);if("function"==typeof Symbol){n=Symbol;try{String(n()),s=!0}catch(t){}}var d,f=(d=h(null),function(t){for(var e,i,n=0;d[t+(n||"")];)++n;return d[t+=n||""]=!0,c(_,e="@@"+t,a.gs(null,function(t){i||(i=!0,c(this,e,a(t)),i=!1)})),e});o=function(t){if(this instanceof o)throw new TypeError("Symbol is not a constructor");return r(t)},e.exports=r=function t(e){var i;if(this instanceof t)throw new TypeError("Symbol is not a constructor");return s?n(e):(i=h(o.prototype),e=void 0===e?"":String(e),u(i,{__description__:a("",e),__name__:a("",f(e))}))},u(r,{for:a(function(t){return p[t]?p[t]:p[t]=r(String(t))}),keyFor:a(function(t){var e;for(e in l(t),p)if(p[e]===t)return e}),hasInstance:a("",n&&n.hasInstance||r("hasInstance")),isConcatSpreadable:a("",n&&n.isConcatSpreadable||r("isConcatSpreadable")),iterator:a("",n&&n.iterator||r("iterator")),match:a("",n&&n.match||r("match")),replace:a("",n&&n.replace||r("replace")),search:a("",n&&n.search||r("search")),species:a("",n&&n.species||r("species")),split:a("",n&&n.split||r("split")),toPrimitive:a("",n&&n.toPrimitive||r("toPrimitive")),toStringTag:a("",n&&n.toStringTag||r("toStringTag")),unscopables:a("",n&&n.unscopables||r("unscopables"))}),u(o.prototype,{constructor:a(r),toString:a("",function(){return this.__name__})}),u(r.prototype,{toString:a(function(){return"Symbol ("+l(this).__description__+")"}),valueOf:a(function(){return l(this)})}),c(r.prototype,r.toPrimitive,a("",function(){var t=l(this);return"symbol"==typeof t?t:t.toString()})),c(r.prototype,r.toStringTag,a("c","Symbol")),c(o.prototype,r.toStringTag,a("c",r.prototype[r.toStringTag])),c(o.prototype,r.toPrimitive,a("c",r.prototype[r.toPrimitive]))},function(t,e,i){var n=t(339);e.exports=function(t){if(!n(t))throw new TypeError(t+" is not a symbol");return t}},function(t,e,i){t(343)()||Object.defineProperty(t(297),"WeakMap",{value:t(345),configurable:!0,enumerable:!1,writable:!0})},function(t,e,i){e.exports=function(){var t,e;if("function"!=typeof WeakMap)return!1;try{t=new WeakMap([[e={},"one"],[{},"two"],[{},"three"]])}catch(t){return!1}return"[object WeakMap]"===String(t)&&"function"==typeof t.set&&t.set({},1)===t&&"function"==typeof t.delete&&"function"==typeof t.has&&"one"===t.get(e)}},function(t,e,i){e.exports="function"==typeof WeakMap&&"[object WeakMap]"===Object.prototype.toString.call(new WeakMap)},function(t,e,i){var n,r=t(318),o=t(322),s=t(323),a=t(328),l=t(289),h=t(331),u=t(330),c=t(337).toStringTag,_=t(344),p=Array.isArray,d=Object.defineProperty,f=Object.prototype.hasOwnProperty,v=Object.getPrototypeOf;e.exports=n=function(){var e,t=arguments[0];if(!(this instanceof n))throw new TypeError("Constructor requires 'new'");return e=_&&r&&WeakMap!==n?r(new WeakMap,v(this)):this,null!=t&&(p(t)||(t=h(t))),d(e,"__weakMapData__",l("c","$weakMap$"+a())),t&&u(t,function(t){s(t),e.set(t[0],t[1])}),e},_&&(r&&r(n,WeakMap),n.prototype=Object.create(WeakMap.prototype,{constructor:l(n)})),Object.defineProperties(n.prototype,{delete:l(function(t){return!!f.call(o(t),this.__weakMapData__)&&(delete t[this.__weakMapData__],!0)}),get:l(function(t){if(f.call(o(t),this.__weakMapData__))return t[this.__weakMapData__]}),has:l(function(t){return f.call(o(t),this.__weakMapData__)}),set:l(function(t,e){return d(o(t),this.__weakMapData__,l("c",e)),this}),toString:l(function(){return"[object WeakMap]"})}),d(n.prototype,c,l("c","WeakMap"))},function(t,e,i){var n,r;n=this,r=function(){"use strict";var l=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array],h=function(t,e,i,n){if(void 0===t)throw new Error("Missing required argument: numItems.");if(isNaN(t)||t<=0)throw new Error("Unpexpected numItems value: "+t+".");this.numItems=+t,this.nodeSize=Math.min(Math.max(+e||16,2),65535);var r=t,o=r;for(this._levelBounds=[4*r];r=Math.ceil(r/this.nodeSize),o+=r,this._levelBounds.push(4*o),1!==r;);this.ArrayType=i||Float64Array,this.IndexArrayType=o<16384?Uint16Array:Uint32Array;var s=l.indexOf(this.ArrayType),a=4*o*this.ArrayType.BYTES_PER_ELEMENT;if(s<0)throw new Error("Unexpected typed array class: "+i+".");n&&n instanceof ArrayBuffer?(this.data=n,this._boxes=new this.ArrayType(this.data,8,4*o),this._indices=new this.IndexArrayType(this.data,8+a,o),this._pos=4*o,this.minX=this._boxes[this._pos-4],this.minY=this._boxes[this._pos-3],this.maxX=this._boxes[this._pos-2],this.maxY=this._boxes[this._pos-1]):(this.data=new ArrayBuffer(8+a+o*this.IndexArrayType.BYTES_PER_ELEMENT),this._boxes=new this.ArrayType(this.data,8,4*o),this._indices=new this.IndexArrayType(this.data,8+a,o),this._pos=0,this.minX=1/0,this.minY=1/0,this.maxX=-1/0,this.maxY=-1/0,new Uint8Array(this.data,0,2).set([251,48+s]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t)};function C(t,e,i,n,r){var o=t[n];t[n]=t[r],t[r]=o;var s=4*n,a=4*r,l=e[s],h=e[s+1],u=e[s+2],c=e[s+3];e[s]=e[a],e[s+1]=e[a+1],e[s+2]=e[a+2],e[s+3]=e[a+3],e[a]=l,e[a+1]=h,e[a+2]=u,e[a+3]=c;var _=i[n];i[n]=i[r],i[r]=_}function T(t,e){var i=t^e,n=65535^i,r=65535^(t|e),o=t&(65535^e),s=i|n>>1,a=i>>1^i,l=r>>1^n&o>>1^r,h=i&r>>1^o>>1^o;a=(i=s)&(n=a)>>2^n&(i^n)>>2,l^=i&(r=l)>>2^n&(o=h)>>2,h^=n&r>>2^(i^n)&o>>2,a=(i=s=i&i>>2^n&n>>2)&(n=a)>>4^n&(i^n)>>4,l^=i&(r=l)>>4^n&(o=h)>>4,h^=n&r>>4^(i^n)&o>>4,l^=(i=s=i&i>>4^n&n>>4)&(r=l)>>8^(n=a)&(o=h)>>8;var u=t^e,c=(n=(h^=n&r>>8^(i^n)&o>>8)^h>>1)|65535^(u|(i=l^l>>1));return((c=1431655765&((c=858993459&((c=252645135&((c=16711935&(c|c<<8))|c<<4))|c<<2))|c<<1))<<1|(u=1431655765&((u=858993459&((u=252645135&((u=16711935&(u|u<<8))|u<<4))|u<<2))|u<<1)))>>>0}return h.from=function(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");var e=new Uint8Array(t,0,2),i=e[0],n=e[1];if(251!==i)throw new Error("Data does not appear to be in a Flatbush format.");if(n>>4!=3)throw new Error("Got v"+(n>>4)+" data when expected v3.");var r=new Uint16Array(t,2,1),o=r[0],s=new Uint32Array(t,4,1),a=s[0];return new h(a,o,l[15&n],t)},h.prototype.add=function(t,e,i,n){var r=this._pos>>2;this._indices[r]=r,this._boxes[this._pos++]=t,this._boxes[this._pos++]=e,this._boxes[this._pos++]=i,this._boxes[this._pos++]=n,t<this.minX&&(this.minX=t),e<this.minY&&(this.minY=e),i>this.maxX&&(this.maxX=i),n>this.maxY&&(this.maxY=n)},h.prototype.finish=function(){var t=this;if(this._pos>>2!==this.numItems)throw new Error("Added "+(this._pos>>2)+" items when expected "+this.numItems+".");for(var e=this.maxX-this.minX,i=this.maxY-this.minY,n=new Uint32Array(this.numItems),r=0;r<this.numItems;r++){var o=4*r,s=t._boxes[o++],a=t._boxes[o++],l=t._boxes[o++],h=t._boxes[o++],u=Math.floor(65535*((s+l)/2-t.minX)/e),c=Math.floor(65535*((a+h)/2-t.minY)/i);n[r]=T(u,c)}!function t(e,i,n,r,o){if(!(o<=r)){for(var s=e[r+o>>1],a=r-1,l=o+1;;){for(;e[++a]<s;);for(;e[--l]>s;);if(l<=a)break;C(e,i,n,a,l)}t(e,i,n,r,l),t(e,i,n,l+1,o)}}(n,this._boxes,this._indices,0,this.numItems-1);for(var _=0,p=0;_<this._levelBounds.length-1;_++)for(var d=t._levelBounds[_];p<d;){for(var f=1/0,v=1/0,m=-1/0,g=-1/0,y=p,b=0;b<this.nodeSize&&p<d;b++){var x=t._boxes[p++],w=t._boxes[p++],k=t._boxes[p++],S=t._boxes[p++];x<f&&(f=x),w<v&&(v=w),m<k&&(m=k),g<S&&(g=S)}t._indices[t._pos>>2]=y,t._boxes[t._pos++]=f,t._boxes[t._pos++]=v,t._boxes[t._pos++]=m,t._boxes[t._pos++]=g}},h.prototype.search=function(t,e,i,n,r){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var o=this._boxes.length-4,s=this._levelBounds.length-1,a=[],l=[];void 0!==o;){for(var h=Math.min(o+4*this.nodeSize,this._levelBounds[s]),u=o;u<h;u+=4){var c=this._indices[u>>2];i<this._boxes[u]||n<this._boxes[u+1]||t>this._boxes[u+2]||e>this._boxes[u+3]||(o<4*this.numItems?(void 0===r||r(c))&&l.push(c):(a.push(c),a.push(s-1)))}s=a.pop(),o=a.pop()}return l},h},"object"==typeof i&&void 0!==e?e.exports=r():n.Flatbush=r()},function(t,Yt,e){
/*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
!function(o,a,t,x){"use strict";var s,l=["","webkit","Moz","MS","ms","o"],e=a.createElement("div"),i="function",h=Math.round,w=Math.abs,k=Date.now;function u(t,e,i){return setTimeout(f(t,i),e)}function n(t,e,i){return!!Array.isArray(t)&&(c(t,i[e],i),!0)}function c(t,e,i){var n;if(t)if(t.forEach)t.forEach(e,i);else if(t.length!==x)for(n=0;n<t.length;)e.call(i,t[n],n,t),n++;else for(n in t)t.hasOwnProperty(n)&&e.call(i,t[n],n,t)}function r(n,t,e){var r="DEPRECATED METHOD: "+t+"\n"+e+" AT \n";return function(){var t=new Error("get-stack-trace"),e=t&&t.stack?t.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",i=o.console&&(o.console.warn||o.console.log);return i&&i.call(o.console,r,e),n.apply(this,arguments)}}s="function"!=typeof Object.assign?function(t){if(t===x||null===t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),i=1;i<arguments.length;i++){var n=arguments[i];if(n!==x&&null!==n)for(var r in n)n.hasOwnProperty(r)&&(e[r]=n[r])}return e}:Object.assign;var _=r(function(t,e,i){for(var n=Object.keys(e),r=0;r<n.length;)(!i||i&&t[n[r]]===x)&&(t[n[r]]=e[n[r]]),r++;return t},"extend","Use `assign`."),p=r(function(t,e){return _(t,e,!0)},"merge","Use `assign`.");function d(t,e,i){var n,r=e.prototype;(n=t.prototype=Object.create(r)).constructor=t,n._super=r,i&&s(n,i)}function f(t,e){return function(){return t.apply(e,arguments)}}function v(t,e){return typeof t==i?t.apply(e&&e[0]||x,e):t}function m(t,e){return t===x?e:t}function g(e,t,i){c(C(t),function(t){e.addEventListener(t,i,!1)})}function y(e,t,i){c(C(t),function(t){e.removeEventListener(t,i,!1)})}function S(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function b(t,e){return-1<t.indexOf(e)}function C(t){return t.trim().split(/\s+/g)}function T(t,e,i){if(t.indexOf&&!i)return t.indexOf(e);for(var n=0;n<t.length;){if(i&&t[n][i]==e||!i&&t[n]===e)return n;n++}return-1}function A(t){return Array.prototype.slice.call(t,0)}function E(t,i,e){for(var n=[],r=[],o=0;o<t.length;){var s=i?t[o][i]:t[o];T(r,s)<0&&n.push(t[o]),r[o]=s,o++}return e&&(n=i?n.sort(function(t,e){return t[i]>e[i]}):n.sort()),n}function M(t,e){for(var i,n,r=e[0].toUpperCase()+e.slice(1),o=0;o<l.length;){if(i=l[o],(n=i?i+r:e)in t)return n;o++}return x}var O=1;function z(t){var e=t.ownerDocument||t;return e.defaultView||e.parentWindow||o}var P="ontouchstart"in o,j=M(o,"PointerEvent")!==x,N=P&&/mobile|tablet|ip(ad|hone|od)|android/i.test(navigator.userAgent),F="touch",D=25,I=1,R=4,B=8,L=1,V=2,G=4,U=8,q=16,Y=V|G,X=U|q,H=Y|X,W=["x","y"],J=["clientX","clientY"];function Q(e,t){var i=this;this.manager=e,this.callback=t,this.element=e.element,this.target=e.options.inputTarget,this.domHandler=function(t){v(e.options.enable,[e])&&i.handler(t)},this.init()}function $(t,e,i){var n=i.pointers.length,r=i.changedPointers.length,o=e&I&&n-r==0,s=e&(R|B)&&n-r==0;i.isFirst=!!o,i.isFinal=!!s,o&&(t.session={}),i.eventType=e,function(t,e){var i=t.session,n=e.pointers,r=n.length;i.firstInput||(i.firstInput=K(e)),1<r&&!i.firstMultiple?i.firstMultiple=K(e):1===r&&(i.firstMultiple=!1);var o,s,a,l,h,u,c=i.firstInput,_=i.firstMultiple,p=_?_.center:c.center,d=e.center=Z(n);e.timeStamp=k(),e.deltaTime=e.timeStamp-c.timeStamp,e.angle=nt(p,d),e.distance=it(p,d),o=i,a=(s=e).center,l=o.offsetDelta||{},h=o.prevDelta||{},u=o.prevInput||{},s.eventType!==I&&u.eventType!==R||(h=o.prevDelta={x:u.deltaX||0,y:u.deltaY||0},l=o.offsetDelta={x:a.x,y:a.y}),s.deltaX=h.x+(a.x-l.x),s.deltaY=h.y+(a.y-l.y),e.offsetDirection=et(e.deltaX,e.deltaY);var f,v,m,g,y=tt(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=y.x,e.overallVelocityY=y.y,e.overallVelocity=w(y.x)>w(y.y)?y.x:y.y,e.scale=_?(m=_.pointers,it((g=n)[0],g[1],J)/it(m[0],m[1],J)):1,e.rotation=_?(f=_.pointers,nt((v=n)[1],v[0],J)+nt(f[1],f[0],J)):0,e.maxPointers=i.prevInput?e.pointers.length>i.prevInput.maxPointers?e.pointers.length:i.prevInput.maxPointers:e.pointers.length,function(t,e){var i,n,r,o,s=t.lastInterval||e,a=e.timeStamp-s.timeStamp;if(e.eventType!=B&&(D<a||s.velocity===x)){var l=e.deltaX-s.deltaX,h=e.deltaY-s.deltaY,u=tt(a,l,h);n=u.x,r=u.y,i=w(u.x)>w(u.y)?u.x:u.y,o=et(l,h),t.lastInterval=e}else i=s.velocity,n=s.velocityX,r=s.velocityY,o=s.direction;e.velocity=i,e.velocityX=n,e.velocityY=r,e.direction=o}(i,e);var b=t.element;S(e.srcEvent.target,b)&&(b=e.srcEvent.target),e.target=b}(t,i),t.emit("hammer.input",i),t.recognize(i),t.session.prevInput=i}function K(t){for(var e=[],i=0;i<t.pointers.length;)e[i]={clientX:h(t.pointers[i].clientX),clientY:h(t.pointers[i].clientY)},i++;return{timeStamp:k(),pointers:e,center:Z(e),deltaX:t.deltaX,deltaY:t.deltaY}}function Z(t){var e=t.length;if(1===e)return{x:h(t[0].clientX),y:h(t[0].clientY)};for(var i=0,n=0,r=0;r<e;)i+=t[r].clientX,n+=t[r].clientY,r++;return{x:h(i/e),y:h(n/e)}}function tt(t,e,i){return{x:e/t||0,y:i/t||0}}function et(t,e){return t===e?L:w(t)>=w(e)?t<0?V:G:e<0?U:q}function it(t,e,i){i||(i=W);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return Math.sqrt(n*n+r*r)}function nt(t,e,i){i||(i=W);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return 180*Math.atan2(r,n)/Math.PI}Q.prototype={handler:function(){},init:function(){this.evEl&&g(this.element,this.evEl,this.domHandler),this.evTarget&&g(this.target,this.evTarget,this.domHandler),this.evWin&&g(z(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&y(this.element,this.evEl,this.domHandler),this.evTarget&&y(this.target,this.evTarget,this.domHandler),this.evWin&&y(z(this.element),this.evWin,this.domHandler)}};var rt={mousedown:I,mousemove:2,mouseup:R},ot="mousedown",st="mousemove mouseup";function at(){this.evEl=ot,this.evWin=st,this.pressed=!1,Q.apply(this,arguments)}d(at,Q,{handler:function(t){var e=rt[t.type];e&I&&0===t.button&&(this.pressed=!0),2&e&&1!==t.which&&(e=R),this.pressed&&(e&R&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:"mouse",srcEvent:t}))}});var lt={pointerdown:I,pointermove:2,pointerup:R,pointercancel:B,pointerout:B},ht={2:F,3:"pen",4:"mouse",5:"kinect"},ut="pointerdown",ct="pointermove pointerup pointercancel";function _t(){this.evEl=ut,this.evWin=ct,Q.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}o.MSPointerEvent&&!o.PointerEvent&&(ut="MSPointerDown",ct="MSPointerMove MSPointerUp MSPointerCancel"),d(_t,Q,{handler:function(t){var e=this.store,i=!1,n=t.type.toLowerCase().replace("ms",""),r=lt[n],o=ht[t.pointerType]||t.pointerType,s=o==F,a=T(e,t.pointerId,"pointerId");r&I&&(0===t.button||s)?a<0&&(e.push(t),a=e.length-1):r&(R|B)&&(i=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:o,srcEvent:t}),i&&e.splice(a,1))}});var pt={touchstart:I,touchmove:2,touchend:R,touchcancel:B};function dt(){this.evTarget="touchstart",this.evWin="touchstart touchmove touchend touchcancel",this.started=!1,Q.apply(this,arguments)}d(dt,Q,{handler:function(t){var e=pt[t.type];if(e===I&&(this.started=!0),this.started){var i=function(t,e){var i=A(t.touches),n=A(t.changedTouches);return e&(R|B)&&(i=E(i.concat(n),"identifier",!0)),[i,n]}.call(this,t,e);e&(R|B)&&i[0].length-i[1].length==0&&(this.started=!1),this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:F,srcEvent:t})}}});var ft={touchstart:I,touchmove:2,touchend:R,touchcancel:B},vt="touchstart touchmove touchend touchcancel";function mt(){this.evTarget=vt,this.targetIds={},Q.apply(this,arguments)}d(mt,Q,{handler:function(t){var e=ft[t.type],i=function(t,e){var i=A(t.touches),n=this.targetIds;if(e&(2|I)&&1===i.length)return n[i[0].identifier]=!0,[i,i];var r,o,s=A(t.changedTouches),a=[],l=this.target;if(o=i.filter(function(t){return S(t.target,l)}),e===I)for(r=0;r<o.length;)n[o[r].identifier]=!0,r++;for(r=0;r<s.length;)n[s[r].identifier]&&a.push(s[r]),e&(R|B)&&delete n[s[r].identifier],r++;return a.length?[E(o.concat(a),"identifier",!0),a]:void 0}.call(this,t,e);i&&this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:F,srcEvent:t})}});var gt=2500;function yt(){Q.apply(this,arguments);var t=f(this.handler,this);this.touch=new mt(this.manager,t),this.mouse=new at(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function bt(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var i={x:e.clientX,y:e.clientY};this.lastTouches.push(i);var n=this.lastTouches;setTimeout(function(){var t=n.indexOf(i);-1<t&&n.splice(t,1)},gt)}}d(yt,Q,{handler:function(t,e,i){var n=i.pointerType==F,r="mouse"==i.pointerType;if(!(r&&i.sourceCapabilities&&i.sourceCapabilities.firesTouchEvents)){if(n)(function(t,e){t&I?(this.primaryTouch=e.changedPointers[0].identifier,bt.call(this,e)):t&(R|B)&&bt.call(this,e)}).call(this,e,i);else if(r&&function(t){for(var e=t.srcEvent.clientX,i=t.srcEvent.clientY,n=0;n<this.lastTouches.length;n++){var r=this.lastTouches[n],o=Math.abs(e-r.x),s=Math.abs(i-r.y);if(o<=25&&s<=25)return!0}return!1}.call(this,i))return;this.callback(t,e,i)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var xt=M(e.style,"touchAction"),wt=xt!==x,kt="manipulation",St="none",Ct="pan-x",Tt="pan-y",At=function(){if(!wt)return!1;var e={},i=o.CSS&&o.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach(function(t){e[t]=!i||o.CSS.supports("touch-action",t)}),e}();function Et(t,e){this.manager=t,this.set(e)}Et.prototype={set:function(t){"compute"==t&&(t=this.compute()),wt&&this.manager.element.style&&At[t]&&(this.manager.element.style[xt]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var e=[];return c(this.manager.recognizers,function(t){v(t.options.enable,[t])&&(e=e.concat(t.getTouchAction()))}),function(t){if(b(t,St))return St;var e=b(t,Ct),i=b(t,Tt);return e&&i?St:e||i?e?Ct:Tt:b(t,kt)?kt:"auto"}(e.join(" "))},preventDefaults:function(t){var e=t.srcEvent,i=t.offsetDirection;if(this.manager.session.prevented)e.preventDefault();else{var n=this.actions,r=b(n,St)&&!At.none,o=b(n,Tt)&&!At[Tt],s=b(n,Ct)&&!At[Ct];if(r){var a=1===t.pointers.length,l=t.distance<2,h=t.deltaTime<250;if(a&&l&&h)return}if(!s||!o)return r||o&&i&Y||s&&i&X?this.preventSrc(e):void 0}},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};var Mt=1;function Ot(t){this.options=s({},this.defaults,t||{}),this.id=O++,this.manager=null,this.options.enable=m(this.options.enable,!0),this.state=Mt,this.simultaneous={},this.requireFail=[]}function zt(t){return 16&t?"cancel":8&t?"end":4&t?"move":2&t?"start":""}function Pt(t){return t==q?"down":t==U?"up":t==V?"left":t==G?"right":""}function jt(t,e){var i=e.manager;return i?i.get(t):t}function Nt(){Ot.apply(this,arguments)}function Ft(){Nt.apply(this,arguments),this.pX=null,this.pY=null}function Dt(){Nt.apply(this,arguments)}function It(){Ot.apply(this,arguments),this._timer=null,this._input=null}function Rt(){Nt.apply(this,arguments)}function Bt(){Nt.apply(this,arguments)}function Lt(){Ot.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function Vt(t,e){return(e=e||{}).recognizers=m(e.recognizers,Vt.defaults.preset),new Gt(t,e)}function Gt(t,e){var i;this.options=s({},Vt.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=new((i=this).options.inputClass||(j?_t:N?mt:P?yt:at))(i,$),this.touchAction=new Et(this,this.options.touchAction),Ut(this,!0),c(this.options.recognizers,function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])},this)}function Ut(i,n){var r,o=i.element;o.style&&(c(i.options.cssProps,function(t,e){r=M(o.style,e),n?(i.oldCssProps[r]=o.style[r],o.style[r]=t):o.style[r]=i.oldCssProps[r]||""}),n||(i.oldCssProps={}))}Ot.prototype={defaults:{},set:function(t){return s(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(n(t,"recognizeWith",this))return this;var e=this.simultaneous;return t=jt(t,this),e[t.id]||(e[t.id]=t).recognizeWith(this),this},dropRecognizeWith:function(t){return n(t,"dropRecognizeWith",this)||(t=jt(t,this),delete this.simultaneous[t.id]),this},requireFailure:function(t){if(n(t,"requireFailure",this))return this;var e=this.requireFail;return t=jt(t,this),-1===T(e,t)&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(n(t,"dropRequireFailure",this))return this;t=jt(t,this);var e=T(this.requireFail,t);return-1<e&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return 0<this.requireFail.length},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(e){var i=this,t=this.state;function n(t){i.manager.emit(t,e)}t<8&&n(i.options.event+zt(t)),n(i.options.event),e.additionalEvent&&n(e.additionalEvent),8<=t&&n(i.options.event+zt(t))},tryEmit:function(t){if(this.canEmit())return this.emit(t);this.state=32},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(this.requireFail[t].state&(32|Mt)))return!1;t++}return!0},recognize:function(t){var e=s({},t);if(!v(this.options.enable,[this,e]))return this.reset(),void(this.state=32);56&this.state&&(this.state=Mt),this.state=this.process(e),30&this.state&&this.tryEmit(e)},process:function(t){},getTouchAction:function(){},reset:function(){}},d(Nt,Ot,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,i=t.eventType,n=6&e,r=this.attrTest(t);return n&&(i&B||!r)?16|e:n||r?i&R?8|e:2&e?4|e:2:32}}),d(Ft,Nt,{defaults:{event:"pan",threshold:10,pointers:1,direction:H},getTouchAction:function(){var t=this.options.direction,e=[];return t&Y&&e.push(Tt),t&X&&e.push(Ct),e},directionTest:function(t){var e=this.options,i=!0,n=t.distance,r=t.direction,o=t.deltaX,s=t.deltaY;return r&e.direction||(e.direction&Y?(r=0===o?L:o<0?V:G,i=o!=this.pX,n=Math.abs(t.deltaX)):(r=0===s?L:s<0?U:q,i=s!=this.pY,n=Math.abs(t.deltaY))),t.direction=r,i&&n>e.threshold&&r&e.direction},attrTest:function(t){return Nt.prototype.attrTest.call(this,t)&&(2&this.state||!(2&this.state)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=Pt(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),d(Dt,Nt,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return[St]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||2&this.state)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),d(It,Ot,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return["auto"]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!n||!i||t.eventType&(R|B)&&!r)this.reset();else if(t.eventType&I)this.reset(),this._timer=u(function(){this.state=8,this.tryEmit()},e.time,this);else if(t.eventType&R)return 8;return 32},reset:function(){clearTimeout(this._timer)},emit:function(t){8===this.state&&(t&&t.eventType&R?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=k(),this.manager.emit(this.options.event,this._input)))}}),d(Rt,Nt,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return[St]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||2&this.state)}}),d(Bt,Nt,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:Y|X,pointers:1},getTouchAction:function(){return Ft.prototype.getTouchAction.call(this)},attrTest:function(t){var e,i=this.options.direction;return i&(Y|X)?e=t.overallVelocity:i&Y?e=t.overallVelocityX:i&X&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&i&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&w(e)>this.options.velocity&&t.eventType&R},emit:function(t){var e=Pt(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),d(Lt,Ot,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return[kt]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),t.eventType&I&&0===this.count)return this.failTimeout();if(n&&r&&i){if(t.eventType!=R)return this.failTimeout();var o=!this.pTime||t.timeStamp-this.pTime<e.interval,s=!this.pCenter||it(this.pCenter,t.center)<e.posThreshold;this.pTime=t.timeStamp,this.pCenter=t.center,s&&o?this.count+=1:this.count=1,this._input=t;var a=this.count%e.taps;if(0===a)return this.hasRequireFailures()?(this._timer=u(function(){this.state=8,this.tryEmit()},e.interval,this),2):8}return 32},failTimeout:function(){return this._timer=u(function(){this.state=32},this.options.interval,this),32},reset:function(){clearTimeout(this._timer)},emit:function(){8==this.state&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),Vt.VERSION="2.0.7",Vt.defaults={domEvents:!1,touchAction:"compute",enable:!0,inputTarget:null,inputClass:null,preset:[[Rt,{enable:!1}],[Dt,{enable:!1},["rotate"]],[Bt,{direction:Y}],[Ft,{direction:Y},["swipe"]],[Lt],[Lt,{event:"doubletap",taps:2},["tap"]],[It]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}},Gt.prototype={set:function(t){return s(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?2:1},recognize:function(t){var e=this.session;if(!e.stopped){var i;this.touchAction.preventDefaults(t);var n=this.recognizers,r=e.curRecognizer;(!r||r&&8&r.state)&&(r=e.curRecognizer=null);for(var o=0;o<n.length;)i=n[o],2===e.stopped||r&&i!=r&&!i.canRecognizeWith(r)?i.reset():i.recognize(t),!r&&14&i.state&&(r=e.curRecognizer=i),o++}},get:function(t){if(t instanceof Ot)return t;for(var e=this.recognizers,i=0;i<e.length;i++)if(e[i].options.event==t)return e[i];return null},add:function(t){if(n(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),(t.manager=this).touchAction.update(),t},remove:function(t){if(n(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,i=T(e,t);-1!==i&&(e.splice(i,1),this.touchAction.update())}return this},on:function(t,e){if(t!==x&&e!==x){var i=this.handlers;return c(C(t),function(t){i[t]=i[t]||[],i[t].push(e)}),this}},off:function(t,e){if(t!==x){var i=this.handlers;return c(C(t),function(t){e?i[t]&&i[t].splice(T(i[t],e),1):delete i[t]}),this}},emit:function(t,e){var i,n,r;this.options.domEvents&&(i=t,n=e,(r=a.createEvent("Event")).initEvent(i,!0,!0),(r.gesture=n).target.dispatchEvent(r));var o=this.handlers[t]&&this.handlers[t].slice();if(o&&o.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var s=0;s<o.length;)o[s](e),s++}},destroy:function(){this.element&&Ut(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},s(Vt,{INPUT_START:I,INPUT_MOVE:2,INPUT_END:R,INPUT_CANCEL:B,STATE_POSSIBLE:Mt,STATE_BEGAN:2,STATE_CHANGED:4,STATE_ENDED:8,STATE_RECOGNIZED:8,STATE_CANCELLED:16,STATE_FAILED:32,DIRECTION_NONE:L,DIRECTION_LEFT:V,DIRECTION_RIGHT:G,DIRECTION_UP:U,DIRECTION_DOWN:q,DIRECTION_HORIZONTAL:Y,DIRECTION_VERTICAL:X,DIRECTION_ALL:H,Manager:Gt,Input:Q,TouchAction:Et,TouchInput:mt,MouseInput:at,PointerEventInput:_t,TouchMouseInput:yt,SingleTouchInput:dt,Recognizer:Ot,AttrRecognizer:Nt,Tap:Lt,Pan:Ft,Swipe:Bt,Pinch:Dt,Rotate:Rt,Press:It,on:g,off:y,each:c,merge:p,extend:_,assign:s,inherit:d,bindFn:f,prefixed:M});var qt=void 0!==o?o:"undefined"!=typeof self?self:{};qt.Hammer=Vt,void 0!==Yt&&Yt.exports?Yt.exports=Vt:o.Hammer=Vt}(window,document)},function(t,e,i){var n,r,o=t(353);(r=n=i.Operator||(i.Operator={}))[r.Le=0]="Le",r[r.Ge=1]="Ge",r[r.Eq=2]="Eq";var s=function(){function t(t,e,i){void 0===i&&(i=o.Strength.required),this._id=a++,this._operator=e,this._expression=t,this._strength=o.Strength.clip(i)}return t.Compare=function(t,e){return t.id-e.id},t.prototype.toString=function(){var t=this;return this._expression+" "+function(){switch(t._operator){case n.Le:return"<=";case n.Ge:return">=";case n.Eq:return"=="}}()+" 0"},Object.defineProperty(t.prototype,"id",{get:function(){return this._id},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"expression",{get:function(){return this._expression},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"op",{get:function(){return this._operator},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"strength",{get:function(){return this._strength},enumerable:!0,configurable:!0}),t}();i.Constraint=s;var a=0},function(t,e,i){var h=t(357),u=t(360),c=t(351),n=function(){function t(){var t=function(t){for(var e=0,i=function(){return 0},n=c.createMap(u.Variable.Compare),r=0,o=t.length;r<o;++r){var s=t[r];if("number"==typeof s)e+=s;else if(s instanceof u.Variable)n.setDefault(s,i).second+=1;else{if(!(s instanceof Array))throw new Error("invalid Expression argument: "+JSON.stringify(s));if(2!==s.length)throw new Error("array must have length 2");var a=s[0],l=s[1];if("number"!=typeof a)throw new Error("array item 0 must be a number");if(!(l instanceof u.Variable))throw new Error("array item 1 must be a variable");n.setDefault(l,i).second+=a}}return{terms:n,constant:e}}(arguments);this._terms=t.terms,this._constant=t.constant}return t.prototype.toString=function(){var e=[];h.forEach(this._terms,function(t){e.push([t.first,t.second])});for(var t=!0,i="",n=0,r=e;n<r.length;n++){var o=r[n],s=o[0],a=o[1];t?(t=!1,i+=1==a?""+s:-1==a?"-"+s:a+"*"+s):i+=1==a?" + "+s:-1==a?" - "+s:0<=a?" + "+a+s:" - "+-a+s}var l=this.constant;return l<0?i+=" - "+-l:0<l&&(i+=" + "+l),i},Object.defineProperty(t.prototype,"terms",{get:function(){return this._terms},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"constant",{get:function(){return this._constant},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"value",{get:function(){var e=this._constant;return h.forEach(this._terms,function(t){e+=t.first.value*t.second}),e},enumerable:!0,configurable:!0}),t}();i.Expression=n},function(t,e,i){
/*-----------------------------------------------------------------------------
    | Copyright (c) 2014, Nucleic Development Team.
    |
    | Distributed under the terms of the Modified BSD License.
    |
    | The full license is in the file COPYING.txt, distributed with this software.
    |----------------------------------------------------------------------------*/
function n(t){for(var e in t)i.hasOwnProperty(e)||(i[e]=t[e])}n(t(360)),n(t(349)),n(t(348)),n(t(353)),n(t(352))},function(t,e,i){var n=t(357);i.createMap=function(t){return new n.AssociativeArray(t)}},function(t,e,i){var g,n,r=t(360),a=t(349),y=t(348),b=t(353),o=t(351),s=t(357),l=function(){function t(){this._cnMap=o.createMap(y.Constraint.Compare),this._rowMap=o.createMap(h.Compare),this._varMap=o.createMap(r.Variable.Compare),this._editMap=o.createMap(r.Variable.Compare),this._infeasibleRows=[],this._objective=new k,this._artificial=null,this._idTick=0}return t.prototype.addConstraint=function(t){var e=this._cnMap.find(t);if(void 0!==e)throw new Error("duplicate constraint");var i=this._createRow(t),n=i.row,r=i.tag,o=this._chooseSubject(n,r);if(o.type()===g.Invalid&&n.allDummies()){if(!x(n.constant())){for(var s=[],a=0,l=t.expression.terms._array;a<l.length;a++){var h=l[a];s.push(h.first.name)}var u=["LE","GE","EQ"][t.op];throw new Error("unsatisfiable constraint ["+s.join(",")+"] operator: "+u)}o=r.marker}if(o.type()===g.Invalid){if(!this._addWithArtificialVariable(n))throw new Error("unsatisfiable constraint")}else n.solveFor(o),this._substitute(o,n),this._rowMap.insert(o,n);this._cnMap.insert(t,r),this._optimize(this._objective)},t.prototype.removeConstraint=function(t,e){void 0===e&&(e=!1);var i=this._cnMap.erase(t);if(void 0===i){if(e)return;throw new Error("unknown constraint")}this._removeConstraintEffects(t,i.second);var n=i.second.marker,r=this._rowMap.erase(n);if(void 0===r){var o=this._getMarkerLeavingSymbol(n);if(o.type()===g.Invalid)throw new Error("failed to find leaving row");(r=this._rowMap.erase(o)).second.solveForEx(o,n),this._substitute(n,r.second)}this._optimize(this._objective)},t.prototype.hasConstraint=function(t){return this._cnMap.contains(t)},t.prototype.addEditVariable=function(t,e){var i=this._editMap.find(t);if(void 0!==i)throw new Error("duplicate edit variable: "+t.name);if((e=b.Strength.clip(e))===b.Strength.required)throw new Error("bad required strength");var n=new a.Expression(t),r=new y.Constraint(n,y.Operator.Eq,e);this.addConstraint(r);var o=this._cnMap.find(r).second,s={tag:o,constraint:r,constant:0};this._editMap.insert(t,s)},t.prototype.removeEditVariable=function(t,e){void 0===e&&(e=!1);var i=this._editMap.erase(t);if(void 0===i){if(e)return;throw new Error("unknown edit variable: "+t.name)}this.removeConstraint(i.second.constraint,e)},t.prototype.hasEditVariable=function(t){return this._editMap.contains(t)},t.prototype.suggestValue=function(t,e){var i=this._editMap.find(t);if(void 0===i)throw new Error("unknown edit variable: "+t.name);var n=this._rowMap,r=i.second,o=e-r.constant;r.constant=e;var s=r.tag.marker,a=n.find(s);if(void 0!==a)return a.second.add(-o)<0&&this._infeasibleRows.push(s),void this._dualOptimize();var l=r.tag.other;if(void 0!==(a=n.find(l)))return a.second.add(o)<0&&this._infeasibleRows.push(l),void this._dualOptimize();for(var h=0,u=n.size();h<u;++h){var c=n.itemAt(h),_=c.second,p=_.coefficientFor(s);0!==p&&_.add(o*p)<0&&c.first.type()!==g.External&&this._infeasibleRows.push(c.first)}this._dualOptimize()},t.prototype.updateVariables=function(){for(var t=this._varMap,e=this._rowMap,i=0,n=t.size();i<n;++i){var r=t.itemAt(i),o=e.find(r.second),s=0;void 0!==o&&-0===(s=o.second.constant())&&(s=0),r.first.setValue(s)}},t.prototype.getConstraints=function(){var e=[];return s.forEach(this._cnMap,function(t){e.push(t.first)}),e},Object.defineProperty(t.prototype,"numConstraints",{get:function(){return this._cnMap.size()},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"numEditVariables",{get:function(){return this._editMap.size()},enumerable:!0,configurable:!0}),t.prototype._getVarSymbol=function(t){var e=this;return this._varMap.setDefault(t,function(){return e._makeSymbol(g.External)}).second},t.prototype._createRow=function(t){for(var e=t.expression,i=new k(e.constant),n=e.terms,r=0,o=n.size();r<o;++r){var s=n.itemAt(r);if(!x(s.second)){var a=this._getVarSymbol(s.first),l=this._rowMap.find(a);void 0!==l?i.insertRow(l.second,s.second):i.insertSymbol(a,s.second)}}var h=this._objective,u=t.strength,c={marker:w,other:w};switch(t.op){case y.Operator.Le:case y.Operator.Ge:var _=t.op===y.Operator.Le?1:-1,p=this._makeSymbol(g.Slack);if(c.marker=p,i.insertSymbol(p,_),u<b.Strength.required){var d=this._makeSymbol(g.Error);c.other=d,i.insertSymbol(d,-_),h.insertSymbol(d,u)}break;case y.Operator.Eq:if(u<b.Strength.required){var f=this._makeSymbol(g.Error),v=this._makeSymbol(g.Error);c.marker=f,c.other=v,i.insertSymbol(f,-1),i.insertSymbol(v,1),h.insertSymbol(f,u),h.insertSymbol(v,u)}else{var m=this._makeSymbol(g.Dummy);c.marker=m,i.insertSymbol(m)}}return i.constant()<0&&i.reverseSign(),{row:i,tag:c}},t.prototype._chooseSubject=function(t,e){for(var i=t.cells(),n=0,r=i.size();n<r;++n){var o=i.itemAt(n);if(o.first.type()===g.External)return o.first}var s=e.marker.type();return(s===g.Slack||s===g.Error)&&t.coefficientFor(e.marker)<0?e.marker:((s=e.other.type())===g.Slack||s===g.Error)&&t.coefficientFor(e.other)<0?e.other:w},t.prototype._addWithArtificialVariable=function(t){var e=this._makeSymbol(g.Slack);this._rowMap.insert(e,t.copy()),this._artificial=t.copy(),this._optimize(this._artificial);var i=x(this._artificial.constant());this._artificial=null;var n=this._rowMap.erase(e);if(void 0!==n){var r=n.second;if(r.isConstant())return i;var o=this._anyPivotableSymbol(r);if(o.type()===g.Invalid)return!1;r.solveForEx(e,o),this._substitute(o,r),this._rowMap.insert(o,r)}for(var s=this._rowMap,a=0,l=s.size();a<l;++a)s.itemAt(a).second.removeSymbol(e);return this._objective.removeSymbol(e),i},t.prototype._substitute=function(t,e){for(var i=this._rowMap,n=0,r=i.size();n<r;++n){var o=i.itemAt(n);o.second.substitute(t,e),o.second.constant()<0&&o.first.type()!==g.External&&this._infeasibleRows.push(o.first)}this._objective.substitute(t,e),this._artificial&&this._artificial.substitute(t,e)},t.prototype._optimize=function(t){for(;;){var e=this._getEnteringSymbol(t);if(e.type()===g.Invalid)return;var i=this._getLeavingSymbol(e);if(i.type()===g.Invalid)throw new Error("the objective is unbounded");var n=this._rowMap.erase(i).second;n.solveForEx(i,e),this._substitute(e,n),this._rowMap.insert(e,n)}},t.prototype._dualOptimize=function(){for(var t=this._rowMap,e=this._infeasibleRows;0!==e.length;){var i=e.pop(),n=t.find(i);if(void 0!==n&&n.second.constant()<0){var r=this._getDualEnteringSymbol(n.second);if(r.type()===g.Invalid)throw new Error("dual optimize failed");var o=n.second;t.erase(i),o.solveForEx(i,r),this._substitute(r,o),t.insert(r,o)}}},t.prototype._getEnteringSymbol=function(t){for(var e=t.cells(),i=0,n=e.size();i<n;++i){var r=e.itemAt(i),o=r.first;if(r.second<0&&o.type()!==g.Dummy)return o}return w},t.prototype._getDualEnteringSymbol=function(t){for(var e=Number.MAX_VALUE,i=w,n=t.cells(),r=0,o=n.size();r<o;++r){var s=n.itemAt(r),a=s.first,l=s.second;if(0<l&&a.type()!==g.Dummy){var h=this._objective.coefficientFor(a),u=h/l;u<e&&(e=u,i=a)}}return i},t.prototype._getLeavingSymbol=function(t){for(var e=Number.MAX_VALUE,i=w,n=this._rowMap,r=0,o=n.size();r<o;++r){var s=n.itemAt(r),a=s.first;if(a.type()!==g.External){var l=s.second,h=l.coefficientFor(t);if(h<0){var u=-l.constant()/h;u<e&&(e=u,i=a)}}}return i},t.prototype._getMarkerLeavingSymbol=function(t){for(var e=Number.MAX_VALUE,i=e,n=e,r=w,o=r,s=r,a=r,l=this._rowMap,h=0,u=l.size();h<u;++h){var c=l.itemAt(h),_=c.second,p=_.coefficientFor(t);if(0!==p){var d=c.first;if(d.type()===g.External)a=d;else if(p<0){var f=-_.constant()/p;f<i&&(i=f,o=d)}else{var f=_.constant()/p;f<n&&(n=f,s=d)}}}return o!==r?o:s!==r?s:a},t.prototype._removeConstraintEffects=function(t,e){e.marker.type()===g.Error&&this._removeMarkerEffects(e.marker,t.strength),e.other.type()===g.Error&&this._removeMarkerEffects(e.other,t.strength)},t.prototype._removeMarkerEffects=function(t,e){var i=this._rowMap.find(t);void 0!==i?this._objective.insertRow(i.second,-e):this._objective.insertSymbol(t,-e)},t.prototype._anyPivotableSymbol=function(t){for(var e=t.cells(),i=0,n=e.size();i<n;++i){var r=e.itemAt(i),o=r.first.type();if(o===g.Slack||o===g.Error)return r.first}return w},t.prototype._makeSymbol=function(t){return new h(t,this._idTick++)},t}();function x(t){return t<0?-t<1e-8:t<1e-8}i.Solver=l,(n=g||(g={}))[n.Invalid=0]="Invalid",n[n.External=1]="External",n[n.Slack=2]="Slack",n[n.Error=3]="Error",n[n.Dummy=4]="Dummy";var h=function(){function t(t,e){this._id=e,this._type=t}return t.Compare=function(t,e){return t.id()-e.id()},t.prototype.id=function(){return this._id},t.prototype.type=function(){return this._type},t}(),w=new h(g.Invalid,-1),k=function(){function e(t){void 0===t&&(t=0),this._cellMap=o.createMap(h.Compare),this._constant=t}return e.prototype.cells=function(){return this._cellMap},e.prototype.constant=function(){return this._constant},e.prototype.isConstant=function(){return this._cellMap.empty()},e.prototype.allDummies=function(){for(var t=this._cellMap,e=0,i=t.size();e<i;++e){var n=t.itemAt(e);if(n.first.type()!==g.Dummy)return!1}return!0},e.prototype.copy=function(){var t=new e(this._constant);return t._cellMap=this._cellMap.copy(),t},e.prototype.add=function(t){return this._constant+=t},e.prototype.insertSymbol=function(t,e){void 0===e&&(e=1);var i=this._cellMap.setDefault(t,function(){return 0});x(i.second+=e)&&this._cellMap.erase(t)},e.prototype.insertRow=function(t,e){void 0===e&&(e=1),this._constant+=t._constant*e;for(var i=t._cellMap,n=0,r=i.size();n<r;++n){var o=i.itemAt(n);this.insertSymbol(o.first,o.second*e)}},e.prototype.removeSymbol=function(t){this._cellMap.erase(t)},e.prototype.reverseSign=function(){this._constant=-this._constant;for(var t=this._cellMap,e=0,i=t.size();e<i;++e){var n=t.itemAt(e);n.second=-n.second}},e.prototype.solveFor=function(t){var e=this._cellMap,i=e.erase(t),n=-1/i.second;this._constant*=n;for(var r=0,o=e.size();r<o;++r)e.itemAt(r).second*=n},e.prototype.solveForEx=function(t,e){this.insertSymbol(t,-1),this.solveFor(e)},e.prototype.coefficientFor=function(t){var e=this._cellMap.find(t);return void 0!==e?e.second:0},e.prototype.substitute=function(t,e){var i=this._cellMap.erase(t);void 0!==i&&this.insertRow(e,i.second)},e}()},function(t,e,i){!function(e){function t(t,e,i,n){void 0===n&&(n=1);var r=0;return r+=1e6*Math.max(0,Math.min(1e3,t*n)),r+=1e3*Math.max(0,Math.min(1e3,e*n)),r+=Math.max(0,Math.min(1e3,i*n))}e.create=t,e.required=t(1e3,1e3,1e3),e.strong=t(1,0,0),e.medium=t(0,1,0),e.weak=t(0,0,1),e.clip=function(t){return Math.max(0,Math.min(e.required,t))}}(i.Strength||(i.Strength={}))},function(t,e,i){var l=t(358);function o(t,e,i){for(var n,r,o=0,s=t.length;0<s;)i(t[r=o+(n=s>>1)],e)<0?(o=r+1,s-=n+1):s=n;return o}i.lowerBound=o,i.binarySearch=function(t,e,i){var n=o(t,e,i);if(n===t.length)return-1;var r=t[n];return 0!==i(r,e)?-1:n},i.binaryFind=function(t,e,i){var n=o(t,e,i);if(n!==t.length){var r=t[n];if(0===i(r,e))return r}},i.asSet=function(t,e){var i=l.asArray(t),n=i.length;if(n<=1)return i;i.sort(e);for(var r=[i[0]],o=1,s=0;o<n;++o){var a=i[o];0!==e(r[s],a)&&(r.push(a),++s)}return r},i.setIsDisjoint=function(t,e,i){for(var n=0,r=0,o=t.length,s=e.length;n<o&&r<s;){var a=i(t[n],e[r]);if(a<0)++n;else{if(!(0<a))return!1;++r}}return!0},i.setIsSubset=function(t,e,i){var n=t.length,r=e.length;if(r<n)return!1;for(var o=0,s=0;o<n&&s<r;){var a=i(t[o],e[s]);if(a<0)return!1;0<a||++o,++s}return!(o<n)},i.setUnion=function(t,e,i){for(var n=0,r=0,o=t.length,s=e.length,a=[];n<o&&r<s;){var l=t[n],h=e[r],u=i(l,h);u<0?(a.push(l),++n):(0<u?a.push(h):(a.push(l),++n),++r)}for(;n<o;)a.push(t[n]),++n;for(;r<s;)a.push(e[r]),++r;return a},i.setIntersection=function(t,e,i){for(var n=0,r=0,o=t.length,s=e.length,a=[];n<o&&r<s;){var l=t[n],h=e[r],u=i(l,h);u<0?++n:(0<u||(a.push(l),++n),++r)}return a},i.setDifference=function(t,e,i){for(var n=0,r=0,o=t.length,s=e.length,a=[];n<o&&r<s;){var l=t[n],h=e[r],u=i(l,h);u<0?(a.push(l),++n):(0<u||++n,++r)}for(;n<o;)a.push(t[n]),++n;return a},i.setSymmetricDifference=function(t,e,i){for(var n=0,r=0,o=t.length,s=e.length,a=[];n<o&&r<s;){var l=t[n],h=e[r],u=i(l,h);u<0?(a.push(l),++n):(0<u?a.push(h):++n,++r)}for(;n<o;)a.push(t[n]),++n;for(;r<s;)a.push(e[r]),++r;return a}},function(t,e,i){var n=t(358),r=function(){function t(){this._array=[]}return t.prototype.size=function(){return this._array.length},t.prototype.empty=function(){return 0===this._array.length},t.prototype.itemAt=function(t){return this._array[t]},t.prototype.takeAt=function(t){return this._array.splice(t,1)[0]},t.prototype.clear=function(){this._array=[]},t.prototype.swap=function(t){var e=this._array;this._array=t._array,t._array=e},t.prototype.__iter__=function(){return n.iter(this._array)},t.prototype.__reversed__=function(){return n.reversed(this._array)},t}();i.ArrayBase=r},function(t,e,i){
/*-----------------------------------------------------------------------------
    | Copyright (c) 2014, Nucleic Development Team.
    |
    | Distributed under the terms of the Modified BSD License.
    |
    | The full license is in the file COPYING.txt, distributed with this software.
    |----------------------------------------------------------------------------*/
var n,r=this&&this.__extends||(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)e.hasOwnProperty(i)&&(t[i]=e[i])},function(t,e){function i(){this.constructor=t}n(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),s=t(359),o=t(355),a=t(354),l=t(358),h=function(n){function o(t){var i,e=n.call(this)||this;return e._compare=t,e._wrapped=(i=t,function(t,e){return i(t.first,e)}),e}return r(o,n),o.prototype.comparitor=function(){return this._compare},o.prototype.indexOf=function(t){return a.binarySearch(this._array,t,this._wrapped)},o.prototype.contains=function(t){return 0<=a.binarySearch(this._array,t,this._wrapped)},o.prototype.find=function(t){return a.binaryFind(this._array,t,this._wrapped)},o.prototype.setDefault=function(t,e){var i=this._array,n=a.lowerBound(i,t,this._wrapped);if(n===i.length){var r=new s.Pair(t,e());return i.push(r),r}var o=i[n];if(0!==this._compare(o.first,t)){var r=new s.Pair(t,e());return i.splice(n,0,r),r}return o},o.prototype.insert=function(t,e){var i=this._array,n=a.lowerBound(i,t,this._wrapped);if(n===i.length){var r=new s.Pair(t,e);return i.push(r),r}var o=i[n];if(0!==this._compare(o.first,t)){var r=new s.Pair(t,e);return i.splice(n,0,r),r}return o.second=e,o},o.prototype.update=function(t){var e=this;t instanceof o?this._array=function(t,e,i){for(var n=0,r=0,o=t.length,s=e.length,a=[];n<o&&r<s;){var l=t[n],h=e[r],u=i(l.first,h.first);u<0?(a.push(l.copy()),++n):(0<u?a.push(h.copy()):(a.push(h.copy()),++n),++r)}for(;n<o;)a.push(t[n].copy()),++n;for(;r<s;)a.push(e[r].copy()),++r;return a}(this._array,t._array,this._compare):l.forEach(t,function(t){e.insert(t.first,t.second)})},o.prototype.erase=function(t){var e=this._array,i=a.binarySearch(e,t,this._wrapped);if(!(i<0))return e.splice(i,1)[0]},o.prototype.copy=function(){for(var t=new o(this._compare),e=t._array,i=this._array,n=0,r=i.length;n<r;++n)e.push(i[n].copy());return t},o}(o.ArrayBase);i.AssociativeArray=h},function(t,e,i){function n(t){for(var e in t)i.hasOwnProperty(e)||(i[e]=t[e])}n(t(354)),n(t(355)),n(t(356)),n(t(358)),n(t(359))},function(t,e,i){var n=function(){function t(t,e){void 0===e&&(e=0),this._array=t,this._index=Math.max(0,Math.min(e,t.length))}return t.prototype.__next__=function(){return this._array[this._index++]},t.prototype.__iter__=function(){return this},t}();i.ArrayIterator=n;var r=function(){function t(t,e){void 0===e&&(e=t.length),this._array=t,this._index=Math.max(0,Math.min(e,t.length))}return t.prototype.__next__=function(){return this._array[--this._index]},t.prototype.__iter__=function(){return this},t}();i.ReverseArrayIterator=r,i.iter=function(t){return t instanceof Array?new n(t):t.__iter__()},i.reversed=function(t){return t instanceof Array?new r(t):t.__reversed__()},i.next=function(t){return t.__next__()},i.asArray=function(t){if(t instanceof Array)return t.slice();for(var e,i=[],n=t.__iter__();void 0!==(e=n.__next__());)i.push(e);return i},i.forEach=function(t,e){if(t instanceof Array){for(var i=0,n=t.length;i<n;++i)if(!1===e(t[i]))return}else for(var r,o=t.__iter__();void 0!==(r=o.__next__());)if(!1===e(r))return},i.map=function(t,e){var i=[];if(t instanceof Array)for(var n=0,r=t.length;n<r;++n)i.push(e(t[n]));else for(var o,s=t.__iter__();void 0!==(o=s.__next__());)i.push(e(o));return i},i.filter=function(t,e){var i,n=[];if(t instanceof Array)for(var r=0,o=t.length;r<o;++r)i=t[r],e(i)&&n.push(i);else for(var s=t.__iter__();void 0!==(i=s.__next__());)e(i)&&n.push(i);return n}},function(t,e,i){var n=function(){function t(t,e){this.first=t,this.second=e}return t.prototype.copy=function(){return new t(this.first,this.second)},t}();i.Pair=n},function(t,e,i){var n=function(){function t(t){void 0===t&&(t=""),this._value=0,this._context=null,this._id=r++,this._name=t}return t.Compare=function(t,e){return t.id-e.id},t.prototype.toString=function(){return this._name},Object.defineProperty(t.prototype,"id",{get:function(){return this._id},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"name",{get:function(){return this._name},enumerable:!0,configurable:!0}),t.prototype.setName=function(t){this._name=t},Object.defineProperty(t.prototype,"context",{get:function(){return this._context},enumerable:!0,configurable:!0}),t.prototype.setContext=function(t){this._context=t},Object.defineProperty(t.prototype,"value",{get:function(){return this._value},enumerable:!0,configurable:!0}),t.prototype.setValue=function(t){this._value=t},t}();i.Variable=n;var r=0},function(t,e,i){
/*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
var u,U={},o=U,q="en-US",Y=null,r="0,0";function n(t){this._value=t}function p(t){var e,i="";for(e=0;e<t;e++)i+="0";return i}function X(t,e,i,n){var r,o,s,a,l,h,u,c,_=Math.pow(10,e);return o=-1<t.toFixed(0).search("e")?(s=e,c=t.toString(),a=c.split("e")[0],u=c.split("e")[1],l=a.split(".")[0],h=a.split(".")[1]||"",c=l+h+p(u-h.length),0<s&&(c+="."+p(s)),c):(i(t*_)/_).toFixed(e),n&&(r=new RegExp("0{1,"+n+"}$"),o=o.replace(r,"")),o}function s(t,e,i){var n,r,o,s,a,l,h,u,c,_;return-1<e.indexOf("$")?n=function(t,e,i){var n,r,o=e,s=o.indexOf("$"),a=o.indexOf("("),l=o.indexOf("+"),h=o.indexOf("-"),u="",c="";if(-1===o.indexOf("$")?"infix"===U[q].currency.position?(c=U[q].currency.symbol,U[q].currency.spaceSeparated&&(c=" "+c+" ")):U[q].currency.spaceSeparated&&(u=" "):-1<o.indexOf(" $")?(u=" ",o=o.replace(" $","")):-1<o.indexOf("$ ")?(u=" ",o=o.replace("$ ","")):o=o.replace("$",""),r=d(t,o,i,c),-1===e.indexOf("$"))switch(U[q].currency.position){case"postfix":-1<r.indexOf(")")?((r=r.split("")).splice(-1,0,u+U[q].currency.symbol),r=r.join("")):r=r+u+U[q].currency.symbol;break;case"infix":break;case"prefix":-1<r.indexOf("(")||-1<r.indexOf("-")?(r=r.split(""),n=Math.max(a,h)+1,r.splice(n,0,U[q].currency.symbol+u),r=r.join("")):r=U[q].currency.symbol+u+r;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else s<=1?-1<r.indexOf("(")||-1<r.indexOf("+")||-1<r.indexOf("-")?(r=r.split(""),n=1,(s<a||s<l||s<h)&&(n=0),r.splice(n,0,U[q].currency.symbol+u),r=r.join("")):r=U[q].currency.symbol+u+r:-1<r.indexOf(")")?((r=r.split("")).splice(-1,0,u+U[q].currency.symbol),r=r.join("")):r=r+u+U[q].currency.symbol;return r}(t,e,i):-1<e.indexOf("%")?(l=t,u=i,_="",l*=100,-1<(h=e).indexOf(" %")?(_=" ",h=h.replace(" %","")):h=h.replace("%",""),-1<(c=d(l,h,u)).indexOf(")")?((c=c.split("")).splice(-1,0,_+"%"),c=c.join("")):c=c+_+"%",n=c):-1<e.indexOf(":")?(r=t,o=Math.floor(r/60/60),s=Math.floor((r-60*o*60)/60),a=Math.round(r-60*o*60-60*s),n=o+":"+(s<10?"0"+s:s)+":"+(a<10?"0"+a:a)):n=d(t,e,i),n}function d(t,e,i,n){var r,o,s,a,l,h,u,c,_,p,d,f,v,m,g,y,b,x,w,k=!1,S=!1,C=!1,T="",A=!1,E=!1,M=!1,O=!1,z=!1,P="",j="",N=Math.abs(t),F=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],D=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],I="",R=!1,B=!1;if(0===t&&null!==Y)return Y;if(!isFinite(t))return""+t;if(0===e.indexOf("{")){var L=e.indexOf("}");if(-1===L)throw Error('Format should also contain a "}"');f=e.slice(1,L),e=e.slice(L+1)}else f="";if(e.indexOf("}")===e.length-1){var V=e.indexOf("{");if(-1===V)throw Error('Format should also contain a "{"');v=e.slice(V+1,-1),e=e.slice(0,V+1)}else v="";if(w=-1===e.indexOf(".")?e.match(/([0-9]+).*/):e.match(/([0-9]+)\..*/),x=null===w?-1:w[1].length,-1!==e.indexOf("-")&&(R=!0),-1<e.indexOf("(")?(k=!0,e=e.slice(1,-1)):-1<e.indexOf("+")&&(S=!0,e=e.replace(/\+/g,"")),-1<e.indexOf("a")){if(p=e.split(".")[0].match(/[0-9]+/g)||["0"],p=parseInt(p[0],10),A=0<=e.indexOf("aK"),E=0<=e.indexOf("aM"),M=0<=e.indexOf("aB"),O=0<=e.indexOf("aT"),z=A||E||M||O,-1<e.indexOf(" a")?(T=" ",e=e.replace(" a","")):e=e.replace("a",""),l=Math.floor(Math.log(N)/Math.LN10)+1,u=0==(u=l%3)?3:u,p&&0!==N&&(h=Math.floor(Math.log(N)/Math.LN10)+1-p,c=3*~~((Math.min(p,l)-u)/3),N/=Math.pow(10,c),-1===e.indexOf(".")&&3<p))for(e+="[.]",y=(y=0===h?0:3*~~(h/3)-h)<0?y+3:y,r=0;r<y;r++)e+="0";Math.floor(Math.log(Math.abs(t))/Math.LN10)+1!==p&&(N>=Math.pow(10,12)&&!z||O?(T+=U[q].abbreviations.trillion,t/=Math.pow(10,12)):N<Math.pow(10,12)&&N>=Math.pow(10,9)&&!z||M?(T+=U[q].abbreviations.billion,t/=Math.pow(10,9)):N<Math.pow(10,9)&&N>=Math.pow(10,6)&&!z||E?(T+=U[q].abbreviations.million,t/=Math.pow(10,6)):(N<Math.pow(10,6)&&N>=Math.pow(10,3)&&!z||A)&&(T+=U[q].abbreviations.thousand,t/=Math.pow(10,3)))}if(-1<e.indexOf("b"))for(-1<e.indexOf(" b")?(P=" ",e=e.replace(" b","")):e=e.replace("b",""),a=0;a<=F.length;a++)if(o=Math.pow(1024,a),s=Math.pow(1024,a+1),o<=t&&t<s){P+=F[a],0<o&&(t/=o);break}if(-1<e.indexOf("d"))for(-1<e.indexOf(" d")?(P=" ",e=e.replace(" d","")):e=e.replace("d",""),a=0;a<=D.length;a++)if(o=Math.pow(1e3,a),s=Math.pow(1e3,a+1),o<=t&&t<s){P+=D[a],0<o&&(t/=o);break}if(-1<e.indexOf("o")&&(-1<e.indexOf(" o")?(j=" ",e=e.replace(" o","")):e=e.replace("o",""),U[q].ordinal&&(j+=U[q].ordinal(t))),-1<e.indexOf("[.]")&&(C=!0,e=e.replace("[.]",".")),_=t.toString().split(".")[0],d=e.split(".")[1],m=e.indexOf(","),d){if(-1!==d.indexOf("*")?I=X(t,t.toString().split(".")[1].length,i):-1<d.indexOf("[")?(d=(d=d.replace("]","")).split("["),I=X(t,d[0].length+d[1].length,i,d[1].length)):I=X(t,d.length,i),_=I.split(".")[0],I.split(".")[1].length){var G=n?T+n:U[q].delimiters.decimal;I=G+I.split(".")[1]}else I="";C&&0===Number(I.slice(1))&&(I="")}else _=X(t,null,i);return-1<_.indexOf("-")&&(_=_.slice(1),B=!0),_.length<x&&(_=new Array(x-_.length+1).join("0")+_),-1<m&&(_=_.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+U[q].delimiters.thousands)),0===e.indexOf(".")&&(_=""),g=e.indexOf("("),b=e.indexOf("-"),f+(g<b?(k&&B?"(":"")+(R&&B||!k&&B?"-":""):(R&&B||!k&&B?"-":"")+(k&&B?"(":""))+(!B&&S&&0!==t?"+":"")+_+I+(j||"")+(T&&!n?T:"")+(P||"")+(k&&B?")":"")+v}function a(t,e){U[t]=e}function l(t){var e=U[q=t].defaults;e&&e.format&&u.defaultFormat(e.format),e&&e.currencyFormat&&u.defaultCurrencyFormat(e.currencyFormat)}void 0!==e&&e.exports,(u=function(t){return u.isNumbro(t)?t=t.value():0===t||void 0===t?t=0:Number(t)||(t=u.fn.unformat(t)),new n(Number(t))}).version="1.6.2",u.isNumbro=function(t){return t instanceof n},u.setLanguage=function(t,e){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var i=t,n=t.split("-")[0],r=null;o[i]||(Object.keys(o).forEach(function(t){r||t.split("-")[0]!==n||(r=t)}),i=r||e||"en-US"),l(i)},u.setCulture=function(t,e){var i=t,n=t.split("-")[1],r=null;U[i]||(n&&Object.keys(U).forEach(function(t){r||t.split("-")[1]!==n||(r=t)}),i=r||e||"en-US"),l(i)},u.language=function(t,e){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!t)return q;if(t&&!e){if(!o[t])throw new Error("Unknown language : "+t);l(t)}return!e&&o[t]||a(t,e),u},u.culture=function(t,e){if(!t)return q;if(t&&!e){if(!U[t])throw new Error("Unknown culture : "+t);l(t)}return!e&&U[t]||a(t,e),u},u.languageData=function(t){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!t)return o[q];if(!o[t])throw new Error("Unknown language : "+t);return o[t]},u.cultureData=function(t){if(!t)return U[q];if(!U[t])throw new Error("Unknown culture : "+t);return U[t]},u.culture("en-US",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(t){var e=t%10;return 1==~~(t%100/10)?"th":1===e?"st":2===e?"nd":3===e?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}}),u.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),o},u.cultures=function(){return U},u.zeroFormat=function(t){Y="string"==typeof t?t:null},u.defaultFormat=function(t){r="string"==typeof t?t:"0.0"},u.defaultCurrencyFormat=function(t){},u.validate=function(t,e){var i,n,r,o,s,a,l,h;if("string"!=typeof t&&(t+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",t)),(t=t.trim()).match(/^\d+$/))return!0;if(""===t)return!1;try{l=u.cultureData(e)}catch(t){l=u.cultureData(u.culture())}return r=l.currency.symbol,s=l.abbreviations,i=l.delimiters.decimal,n="."===l.delimiters.thousands?"\\.":l.delimiters.thousands,!(null!==(h=t.match(/^[^\d]+/))&&(t=t.substr(1),h[0]!==r)||null!==(h=t.match(/[^\d]+$/))&&(t=t.slice(0,-1),h[0]!==s.thousand&&h[0]!==s.million&&h[0]!==s.billion&&h[0]!==s.trillion)||(a=new RegExp(n+"{2}"),t.match(/[^\d.,]/g)||2<(o=t.split(i)).length||(o.length<2?!o[0].match(/^\d+.*\d$/)||o[0].match(a):1===o[0].length?!o[0].match(/^\d+$/)||o[0].match(a)||!o[1].match(/^\d+$/):!o[0].match(/^\d+.*\d$/)||o[0].match(a)||!o[1].match(/^\d+$/))))},e.exports={format:function(t,e,i,n){return null!=i&&i!==u.culture()&&u.setCulture(i),s(Number(t),null!=e?e:r,null==n?Math.round:n)}}},function(t,e,i){var l=t(382),h=t(380),n=t(384),u=t(379),c=t(370),_=t(375);function p(t,e){if(!(this instanceof p))return new p(t);e=e||function(t){if(t)throw t};var i=l(t);if("object"==typeof i){var n=p.projections.get(i.projName);if(n){if(i.datumCode&&"none"!==i.datumCode){var r=c[i.datumCode];r&&(i.datum_params=r.towgs84?r.towgs84.split(","):null,i.ellps=r.ellipse,i.datumName=r.datumName?r.datumName:i.datumCode)}i.k0=i.k0||1,i.axis=i.axis||"enu";var o=u.sphere(i.a,i.b,i.rf,i.ellps,i.sphere),s=u.eccentricity(o.a,o.b,o.rf,i.R_A),a=i.datum||_(i.datumCode,i.datum_params,o.a,o.b,s.es,s.ep2);h(this,i),h(this,n),this.a=o.a,this.b=o.b,this.rf=o.rf,this.sphere=o.sphere,this.es=s.es,this.e=s.e,this.ep2=s.ep2,this.datum=a,this.init(),e(null,this)}else e(t)}else e(t)}(p.projections=n).start(),e.exports=p},function(t,e,i){e.exports=function(t,e,i){var n,r,o,s=i.x,a=i.y,l=i.z||0,h={};for(o=0;o<3;o++)if(!e||2!==o||void 0!==i.z)switch(0===o?(n=s,r="x"):1===o?(n=a,r="y"):(n=l,r="z"),t.axis[o]){case"e":h[r]=n;break;case"w":h[r]=-n;break;case"n":h[r]=n;break;case"s":h[r]=-n;break;case"u":void 0!==i[r]&&(h.z=n);break;case"d":void 0!==i[r]&&(h.z=-n);break;default:return null}return h}},function(t,e,i){var n=2*Math.PI,r=t(367);e.exports=function(t){return Math.abs(t)<=3.14159265359?t:t-r(t)*n}},function(t,e,i){e.exports=function(t,e,i){var n=t*e;return i/Math.sqrt(1-n*n)}},function(t,e,i){var a=Math.PI/2;e.exports=function(t,e){for(var i,n,r=.5*t,o=a-2*Math.atan(e),s=0;s<=15;s++)if(i=t*Math.sin(o),n=a-2*Math.atan(e*Math.pow((1-i)/(1+i),r))-o,o+=n,Math.abs(n)<=1e-10)return o;return-9999}},function(t,e,i){e.exports=function(t){return t<0?-1:1}},function(t,e,i){e.exports=function(t){var e={x:t[0],y:t[1]};return 2<t.length&&(e.z=t[2]),3<t.length&&(e.m=t[3]),e}},function(t,e,i){var o=Math.PI/2;e.exports=function(t,e,i){var n=t*i,r=.5*t;return n=Math.pow((1-n)/(1+n),r),Math.tan(.5*(o-e))/n}},function(t,e,i){i.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},i.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},i.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},i.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},i.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},i.potsdam={towgs84:"606.0,23.0,413.0",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},i.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},i.hermannskogel={towgs84:"653.0,-212.0,449.0",ellipse:"bessel",datumName:"Hermannskogel"},i.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},i.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},i.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},i.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},i.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},i.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},i.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},i.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},function(t,e,i){i.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},i.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},i.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},i.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},i.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},i.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},i.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},i.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},i.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},i.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},i.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},i.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},i.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},i.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},i.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},i.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},i.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},i.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},i.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},i.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},i.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},i.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},i.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},i.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},i.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},i.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},i.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},i.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},i.hough={a:6378270,rf:297,ellipseName:"Hough"},i.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},i.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},i.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},i.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},i.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},i.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},i.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},i.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},i.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},i.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},i.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},i.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"},i.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"},i.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}},function(t,e,i){i.greenwich=0,i.lisbon=-9.131906111111,i.paris=2.337229166667,i.bogota=-74.080916666667,i.madrid=-3.687938888889,i.rome=12.452333333333,i.bern=7.439583333333,i.jakarta=106.807719444444,i.ferro=-17.666666666667,i.brussels=4.367975,i.stockholm=18.058277777778,i.athens=23.7163375,i.oslo=10.722916666667},function(t,e,i){i.ft={to_meter:.3048},i["us-ft"]={to_meter:1200/3937}},function(t,e,i){var n=t(362),r=t(387),o=n("WGS84");function s(t,e,i){var n;return Array.isArray(i)?(n=r(t,e,i),3===i.length?[n.x,n.y,n.z]:[n.x,n.y]):r(t,e,i)}function a(t){return t instanceof n?t:t.oProj?t.oProj:n(t)}e.exports=function(e,i,t){e=a(e);var n,r=!1;return void 0===i?(i=e,e=o,r=!0):(void 0!==i.x||Array.isArray(i))&&(t=i,i=e,e=o,r=!0),i=a(i),t?s(e,i,t):(n={forward:function(t){return s(e,i,t)},inverse:function(t){return s(i,e,t)}},r&&(n.oProj=i),n)}},function(t,e,i){var a=484813681109536e-20;e.exports=function(t,e,i,n,r,o){var s={datum_type:4};return t&&"none"===t&&(s.datum_type=5),e&&(s.datum_params=e.map(parseFloat),0===s.datum_params[0]&&0===s.datum_params[1]&&0===s.datum_params[2]||(s.datum_type=1),3<s.datum_params.length&&(0===s.datum_params[3]&&0===s.datum_params[4]&&0===s.datum_params[5]&&0===s.datum_params[6]||(s.datum_type=2,s.datum_params[3]*=a,s.datum_params[4]*=a,s.datum_params[5]*=a,s.datum_params[6]=s.datum_params[6]/1e6+1))),s.a=i,s.b=n,s.es=r,s.ep2=o,s}},function(t,e,i){var k=Math.PI/2;i.compareDatums=function(t,e){return t.datum_type===e.datum_type&&!(t.a!==e.a||5e-11<Math.abs(this.es-e.es))&&(1===t.datum_type?this.datum_params[0]===e.datum_params[0]&&t.datum_params[1]===e.datum_params[1]&&t.datum_params[2]===e.datum_params[2]:2!==t.datum_type||t.datum_params[0]===e.datum_params[0]&&t.datum_params[1]===e.datum_params[1]&&t.datum_params[2]===e.datum_params[2]&&t.datum_params[3]===e.datum_params[3]&&t.datum_params[4]===e.datum_params[4]&&t.datum_params[5]===e.datum_params[5]&&t.datum_params[6]===e.datum_params[6])},i.geodeticToGeocentric=function(t,e,i){var n,r,o,s,a=t.x,l=t.y,h=t.z?t.z:0;if(l<-k&&-1.001*k<l)l=-k;else if(k<l&&l<1.001*k)l=k;else if(l<-k||k<l)return null;return a>Math.PI&&(a-=2*Math.PI),r=Math.sin(l),s=Math.cos(l),o=r*r,{x:((n=i/Math.sqrt(1-e*o))+h)*s*Math.cos(a),y:(n+h)*s*Math.sin(a),z:(n*(1-e)+h)*r}},i.geocentricToGeodetic=function(t,e,i,n){var r,o,s,a,l,h,u,c,_,p,d,f,v,m,g,y,b=t.x,x=t.y,w=t.z?t.z:0;if(r=Math.sqrt(b*b+x*x),o=Math.sqrt(b*b+x*x+w*w),r/i<1e-12){if(m=0,o/i<1e-12)return g=k,y=-n,{x:t.x,y:t.y,z:t.z}}else m=Math.atan2(x,b);for(s=w/o,a=r/o,l=1/Math.sqrt(1-e*(2-e)*a*a),c=a*(1-e)*l,_=s*l,v=0;v++,u=i/Math.sqrt(1-e*_*_),h=e*u/(u+(y=r*c+w*_-u*(1-e*_*_))),l=1/Math.sqrt(1-h*(2-h)*a*a),f=(d=s*l)*c-(p=a*(1-h)*l)*_,c=p,_=d,1e-24<f*f&&v<30;);return g=Math.atan(d/Math.abs(p)),{x:m,y:g,z:y}},i.geocentricToWgs84=function(t,e,i){if(1===e)return{x:t.x+i[0],y:t.y+i[1],z:t.z+i[2]};if(2===e){var n=i[0],r=i[1],o=i[2],s=i[3],a=i[4],l=i[5],h=i[6];return{x:h*(t.x-l*t.y+a*t.z)+n,y:h*(l*t.x+t.y-s*t.z)+r,z:h*(-a*t.x+s*t.y+t.z)+o}}},i.geocentricFromWgs84=function(t,e,i){if(1===e)return{x:t.x-i[0],y:t.y-i[1],z:t.z-i[2]};if(2===e){var n=i[0],r=i[1],o=i[2],s=i[3],a=i[4],l=i[5],h=i[6],u=(t.x-n)/h,c=(t.y-r)/h,_=(t.z-o)/h;return{x:u+l*c-a*_,y:-l*u+c+s*_,z:a*u-s*c+_}}}},function(t,e,i){var n=t(376);function r(t){return 1===t||2===t}e.exports=function(t,e,i){return n.compareDatums(t,e)?i:5===t.datum_type||5===e.datum_type?i:t.es!==e.es||t.a!==e.a||r(t.datum_type)||r(e.datum_type)?(i=n.geodeticToGeocentric(i,t.es,t.a),r(t.datum_type)&&(i=n.geocentricToWgs84(i,t.datum_type,t.datum_params)),r(e.datum_type)&&(i=n.geocentricFromWgs84(i,e.datum_type,e.datum_params)),n.geocentricToGeodetic(i,e.es,e.a,e.b)):i}},function(t,e,i){var n=t(381),r=t(383),o=t(388);function s(t){var e=this;if(2===arguments.length){var i=arguments[1];s[t]="string"==typeof i?"+"===i.charAt(0)?r(arguments[1]):o(arguments[1]):i}else if(1===arguments.length){if(Array.isArray(t))return t.map(function(t){Array.isArray(t)?s.apply(e,t):s(t)});if("string"==typeof t){if(t in s)return s[t]}else"EPSG"in t?s["EPSG:"+t.EPSG]=t:"ESRI"in t?s["ESRI:"+t.ESRI]=t:"IAU2000"in t?s["IAU2000:"+t.IAU2000]=t:console.log(t);return}}n(s),e.exports=s},function(t,e,i){var s=t(371);i.eccentricity=function(t,e,i,n){var r=t*t,o=e*e,s=(r-o)/r,a=0;n?(r=(t*=1-s*(.16666666666666666+s*(.04722222222222222+.022156084656084655*s)))*t,s=0):a=Math.sqrt(s);var l=(r-o)/o;return{es:s,e:a,ep2:l}},i.sphere=function(t,e,i,n,r){if(!t){var o=s[n];o||(o=s.WGS84),t=o.a,e=o.b,i=o.rf}return i&&!e&&(e=(1-1/i)*t),(0===i||Math.abs(t-e)<1e-10)&&(r=!0,e=t),{a:t,b:e,rf:i,sphere:r}}},function(t,e,i){e.exports=function(t,e){var i,n;if(t=t||{},!e)return t;for(n in e)void 0!==(i=e[n])&&(t[n]=i);return t}},function(t,e,i){e.exports=function(t){t("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),t("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),t("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),t.WGS84=t["EPSG:4326"],t["EPSG:3785"]=t["EPSG:3857"],t.GOOGLE=t["EPSG:3857"],t["EPSG:900913"]=t["EPSG:3857"],t["EPSG:102113"]=t["EPSG:3857"]}},function(t,e,i){var n=t(378),r=t(388),o=t(383),s=["GEOGCS","GEOCCS","PROJCS","LOCAL_CS"];e.exports=function(t){return"string"!=typeof t?t:t in n?n[t]:(e=t,s.some(function(t){return-1<e.indexOf(t)})?r(t):"+"===t[0]?o(t):void 0);var e}},function(t,e,i){var a=.017453292519943295,l=t(372),h=t(373);e.exports=function(t){var e,i,n,r={},o=t.split("+").map(function(t){return t.trim()}).filter(function(t){return t}).reduce(function(t,e){var i=e.split("=");return i.push(!0),t[i[0].toLowerCase()]=i[1],t},{}),s={proj:"projName",datum:"datumCode",rf:function(t){r.rf=parseFloat(t)},lat_0:function(t){r.lat0=t*a},lat_1:function(t){r.lat1=t*a},lat_2:function(t){r.lat2=t*a},lat_ts:function(t){r.lat_ts=t*a},lon_0:function(t){r.long0=t*a},lon_1:function(t){r.long1=t*a},lon_2:function(t){r.long2=t*a},alpha:function(t){r.alpha=parseFloat(t)*a},lonc:function(t){r.longc=t*a},x_0:function(t){r.x0=parseFloat(t)},y_0:function(t){r.y0=parseFloat(t)},k_0:function(t){r.k0=parseFloat(t)},k:function(t){r.k0=parseFloat(t)},a:function(t){r.a=parseFloat(t)},b:function(t){r.b=parseFloat(t)},r_a:function(){r.R_A=!0},zone:function(t){r.zone=parseInt(t,10)},south:function(){r.utmSouth=!0},towgs84:function(t){r.datum_params=t.split(",").map(function(t){return parseFloat(t)})},to_meter:function(t){r.to_meter=parseFloat(t)},units:function(t){r.units=t,h[t]&&(r.to_meter=h[t].to_meter)},from_greenwich:function(t){r.from_greenwich=t*a},pm:function(t){r.from_greenwich=(l[t]?l[t]:parseFloat(t))*a},nadgrids:function(t){"@null"===t?r.datumCode="none":r.nadgrids=t},axis:function(t){var e="ewnsud";3===t.length&&-1!==e.indexOf(t.substr(0,1))&&-1!==e.indexOf(t.substr(1,1))&&-1!==e.indexOf(t.substr(2,1))&&(r.axis=t)}};for(e in o)i=o[e],e in s?"function"==typeof(n=s[e])?n(i):r[n]=i:r[e]=i;return"string"==typeof r.datumCode&&"WGS84"!==r.datumCode&&(r.datumCode=r.datumCode.toLowerCase()),r}},function(t,e,i){var n=[t(386),t(385)],r={},o=[];function s(t,e){var i=o.length;return t.names?((o[i]=t).names.forEach(function(t){r[t.toLowerCase()]=i}),this):(console.log(e),!0)}i.add=s,i.get=function(t){if(!t)return!1;var e=t.toLowerCase();return void 0!==r[e]&&o[r[e]]?o[r[e]]:void 0},i.start=function(){n.forEach(s)}},function(t,e,i){function n(t){return t}i.init=function(){},i.forward=n,i.inverse=n,i.names=["longlat","identity"]},function(t,e,i){var n=t(365),a=Math.PI/2,l=57.29577951308232,h=t(364),u=Math.PI/4,c=t(369),s=t(366);i.init=function(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=n(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)},i.forward=function(t){var e,i,n=t.x,r=t.y;if(90<r*l&&r*l<-90&&180<n*l&&n*l<-180)return null;if(Math.abs(Math.abs(r)-a)<=1e-10)return null;if(this.sphere)e=this.x0+this.a*this.k0*h(n-this.long0),i=this.y0+this.a*this.k0*Math.log(Math.tan(u+.5*r));else{var o=Math.sin(r),s=c(this.e,r,o);e=this.x0+this.a*this.k0*h(n-this.long0),i=this.y0-this.a*this.k0*Math.log(s)}return t.x=e,t.y=i,t},i.inverse=function(t){var e,i,n=t.x-this.x0,r=t.y-this.y0;if(this.sphere)i=a-2*Math.atan(Math.exp(-r/(this.a*this.k0)));else{var o=Math.exp(-r/(this.a*this.k0));if(-9999===(i=s(this.e,o)))return null}return e=h(this.long0+n/(this.a*this.k0)),t.x=e,t.y=i,t},i.names=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"]},function(t,e,i){var a=.017453292519943295,l=57.29577951308232,h=t(377),u=t(363),c=t(362),_=t(368);e.exports=function t(e,i,n){var r,o,s;return Array.isArray(n)&&(n=_(n)),e.datum&&i.datum&&(s=i,(1===(o=e).datum.datum_type||2===o.datum.datum_type)&&"WGS84"!==s.datumCode||(1===s.datum.datum_type||2===s.datum.datum_type)&&"WGS84"!==o.datumCode)&&(r=new c("WGS84"),n=t(e,r,n),e=r),"enu"!==e.axis&&(n=u(e,!1,n)),"longlat"===e.projName?n={x:n.x*a,y:n.y*a}:(e.to_meter&&(n={x:n.x*e.to_meter,y:n.y*e.to_meter}),n=e.inverse(n)),e.from_greenwich&&(n.x+=e.from_greenwich),n=h(e.datum,i.datum,n),i.from_greenwich&&(n={x:n.x-i.grom_greenwich,y:n.y}),"longlat"===i.projName?n={x:n.x*l,y:n.y*l}:(n=i.forward(n),i.to_meter&&(n={x:n.x/i.to_meter,y:n.y/i.to_meter})),"enu"!==i.axis?u(i,!0,n):n}},function(t,e,i){var n=.017453292519943295,s=t(380);function r(t,e,i){t[e]=i.map(function(t){var e={};return a(t,e),e}).reduce(function(t,e){return s(t,e)},{})}function a(t,e){var i;Array.isArray(t)?("PARAMETER"===(i=t.shift())&&(i=t.shift()),1===t.length?Array.isArray(t[0])?(e[i]={},a(t[0],e[i])):e[i]=t[0]:t.length?"TOWGS84"===i?e[i]=t:(e[i]={},-1<["UNIT","PRIMEM","VERT_DATUM"].indexOf(i)?(e[i]={name:t[0].toLowerCase(),convert:t[1]},3===t.length&&(e[i].auth=t[2])):"SPHEROID"===i?(e[i]={name:t[0],a:t[1],rf:t[2]},4===t.length&&(e[i].auth=t[3])):-1<["GEOGCS","GEOCCS","DATUM","VERT_CS","COMPD_CS","LOCAL_CS","FITTED_CS","LOCAL_DATUM"].indexOf(i)?(t[0]=["name",t[0]],r(e,i,t)):t.every(function(t){return Array.isArray(t)})?r(e,i,t):a(t,e[i])):e[i]=!0):e[t]=!0}function l(t){return t*n}e.exports=function(t,e){var i=JSON.parse((","+t).replace(/\s*\,\s*([A-Z_0-9]+?)(\[)/g,',["$1",').slice(1).replace(/\s*\,\s*([A-Z_0-9]+?)\]/g,',"$1"]').replace(/,\["VERTCS".+/,"")),n=i.shift(),r=i.shift();i.unshift(["name",r]),i.unshift(["type",n]),i.unshift("output");var o={};return a(i,o),function(o){function t(t){var e=o.to_meter||1;return parseFloat(t,10)*e}"GEOGCS"===o.type?o.projName="longlat":"LOCAL_CS"===o.type?(o.projName="identity",o.local=!0):"object"==typeof o.PROJECTION?o.projName=Object.keys(o.PROJECTION)[0]:o.projName=o.PROJECTION,o.UNIT&&(o.units=o.UNIT.name.toLowerCase(),"metre"===o.units&&(o.units="meter"),o.UNIT.convert&&("GEOGCS"===o.type?o.DATUM&&o.DATUM.SPHEROID&&(o.to_meter=parseFloat(o.UNIT.convert,10)*o.DATUM.SPHEROID.a):o.to_meter=parseFloat(o.UNIT.convert,10))),o.GEOGCS&&(o.GEOGCS.DATUM?o.datumCode=o.GEOGCS.DATUM.name.toLowerCase():o.datumCode=o.GEOGCS.name.toLowerCase(),"d_"===o.datumCode.slice(0,2)&&(o.datumCode=o.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==o.datumCode&&"new_zealand_1949"!==o.datumCode||(o.datumCode="nzgd49"),"wgs_1984"===o.datumCode&&("Mercator_Auxiliary_Sphere"===o.PROJECTION&&(o.sphere=!0),o.datumCode="wgs84"),"_ferro"===o.datumCode.slice(-6)&&(o.datumCode=o.datumCode.slice(0,-6)),"_jakarta"===o.datumCode.slice(-8)&&(o.datumCode=o.datumCode.slice(0,-8)),~o.datumCode.indexOf("belge")&&(o.datumCode="rnb72"),o.GEOGCS.DATUM&&o.GEOGCS.DATUM.SPHEROID&&(o.ellps=o.GEOGCS.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===o.ellps.toLowerCase().slice(0,13)&&(o.ellps="intl"),o.a=o.GEOGCS.DATUM.SPHEROID.a,o.rf=parseFloat(o.GEOGCS.DATUM.SPHEROID.rf,10)),~o.datumCode.indexOf("osgb_1936")&&(o.datumCode="osgb36")),o.b&&!isFinite(o.b)&&(o.b=o.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_2","Standard_Parallel_2"],["false_easting","False_Easting"],["false_northing","False_Northing"],["central_meridian","Central_Meridian"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",l],["longitude_of_center","Longitude_Of_Center"],["longc","longitude_of_center",l],["x0","false_easting",t],["y0","false_northing",t],["long0","central_meridian",l],["lat0","latitude_of_origin",l],["lat0","standard_parallel_1",l],["lat1","standard_parallel_1",l],["lat2","standard_parallel_2",l],["alpha","azimuth",l],["srsCode","name"]].forEach(function(t){return e=o,n=(i=t)[0],r=i[1],void(!(n in e)&&r in e&&(e[n]=e[r],3===i.length&&(e[n]=i[2](e[n]))));var e,i,n,r}),o.long0||!o.longc||"Albers_Conic_Equal_Area"!==o.projName&&"Lambert_Azimuthal_Equal_Area"!==o.projName||(o.long0=o.longc),o.lat_ts||!o.lat1||"Stereographic_South_Pole"!==o.projName&&"Polar Stereographic (variant B)"!==o.projName||(o.lat0=l(0<o.lat1?90:-90),o.lat_ts=o.lat1)}(o.output),s(e,o.output)}},function(t,e,i){!function(){"use strict";var d={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^\)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[\+\-]/};function f(t){return function(t,e){var i,n,r,o,s,a,l,h,u,c=1,_=t.length,p="";for(n=0;n<_;n++)if("string"==typeof t[n])p+=t[n];else if(Array.isArray(t[n])){if((o=t[n])[2])for(i=e[c],r=0;r<o[2].length;r++){if(!i.hasOwnProperty(o[2][r]))throw new Error(f('[sprintf] property "%s" does not exist',o[2][r]));i=i[o[2][r]]}else i=o[1]?e[o[1]]:e[c++];if(d.not_type.test(o[8])&&d.not_primitive.test(o[8])&&i instanceof Function&&(i=i()),d.numeric_arg.test(o[8])&&"number"!=typeof i&&isNaN(i))throw new TypeError(f("[sprintf] expecting number but found %T",i));switch(d.number.test(o[8])&&(h=0<=i),o[8]){case"b":i=parseInt(i,10).toString(2);break;case"c":i=String.fromCharCode(parseInt(i,10));break;case"d":case"i":i=parseInt(i,10);break;case"j":i=JSON.stringify(i,null,o[6]?parseInt(o[6]):0);break;case"e":i=o[7]?parseFloat(i).toExponential(o[7]):parseFloat(i).toExponential();break;case"f":i=o[7]?parseFloat(i).toFixed(o[7]):parseFloat(i);break;case"g":i=o[7]?String(Number(i.toPrecision(o[7]))):parseFloat(i);break;case"o":i=(parseInt(i,10)>>>0).toString(8);break;case"s":i=String(i),i=o[7]?i.substring(0,o[7]):i;break;case"t":i=String(!!i),i=o[7]?i.substring(0,o[7]):i;break;case"T":i=Object.prototype.toString.call(i).slice(8,-1).toLowerCase(),i=o[7]?i.substring(0,o[7]):i;break;case"u":i=parseInt(i,10)>>>0;break;case"v":i=i.valueOf(),i=o[7]?i.substring(0,o[7]):i;break;case"x":i=(parseInt(i,10)>>>0).toString(16);break;case"X":i=(parseInt(i,10)>>>0).toString(16).toUpperCase()}d.json.test(o[8])?p+=i:(!d.number.test(o[8])||h&&!o[3]?u="":(u=h?"+":"-",i=i.toString().replace(d.sign,"")),a=o[4]?"0"===o[4]?"0":o[4].charAt(1):" ",l=o[6]-(u+i).length,s=o[6]&&0<l?a.repeat(l):"",p+=o[5]?u+i+s:"0"===a?u+s+i:s+u+i)}return p}(function(t){if(l[t])return l[t];for(var e,i=t,n=[],r=0;i;){if(null!==(e=d.text.exec(i)))n.push(e[0]);else if(null!==(e=d.modulo.exec(i)))n.push("%");else{if(null===(e=d.placeholder.exec(i)))throw new SyntaxError("[sprintf] unexpected placeholder");if(e[2]){r|=1;var o=[],s=e[2],a=[];if(null===(a=d.key.exec(s)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o.push(a[1]);""!==(s=s.substring(a[0].length));)if(null!==(a=d.key_access.exec(s)))o.push(a[1]);else{if(null===(a=d.index_access.exec(s)))throw new SyntaxError("[sprintf] failed to parse named argument key");o.push(a[1])}e[2]=o}else r|=2;if(3===r)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");n.push(e)}i=i.substring(e[0].length)}return l[t]=n}(t),arguments)}function t(t,e){return f.apply(null,[t].concat(e||[]))}var l=Object.create(null);void 0!==i&&(i.sprintf=f,i.vsprintf=t),"undefined"!=typeof window&&(window.sprintf=f,window.vsprintf=t)}()},function(t,e,i){!function(t){"object"==typeof e&&e.exports?e.exports=t():this.tz=t()}(function(){function d(t,e,i){for(var n,r=e.day[1];n=new Date(Date.UTC(i,e.month,Math.abs(r++))),e.day[0]<7&&n.getUTCDay()!=e.day[0];);return(n={clock:e.clock,sort:n.getTime(),rule:e,save:6e4*e.save,offset:t.offset})[n.clock]=n.sort+6e4*e.time,n.posix?n.wallclock=n[n.clock]+(t.offset+e.saved):n.posix=n[n.clock]-(t.offset+e.saved),n}function r(t,e,i){var n,r,o,s,a,l,h,u=t[t.zone],c=[],_=new Date(i).getUTCFullYear(),p=1;for(n=1,r=u.length;n<r&&!(u[n][e]<=i);n++);if((o=u[n]).rules){for(l=t[o.rules],h=_+1;_-p<=h;--h)for(n=0,r=l.length;n<r;n++)l[n].from<=h&&h<=l[n].to?c.push(d(o,l[n],h)):l[n].to<h&&1==p&&(p=h-l[n].to);for(c.sort(function(t,e){return t.sort-e.sort}),n=0,r=c.length;n<r;n++)i>=c[n][e]&&c[n][c[n].clock]>o[c[n].clock]&&(s=c[n])}return s&&((a=/^(.*)\/(.*)$/.exec(o.format))?s.abbrev=a[s.save?2:1]:s.abbrev=o.format.replace(/%s/,s.rule.letter)),s||o}function a(t,e){return"UTC"==t.zone?e:(t.entry=r(t,"posix",e),e+t.entry.offset+t.entry.save)}function c(t,e){return"UTC"==t.zone?e:(t.entry=i=r(t,"wallclock",e),0<(n=e-i.wallclock)&&n<i.save?null:e-i.offset-i.save);var i,n}function o(t,e,i){var n,r=+(i[1]+1),o=i[2]*r,s=l.indexOf(i[3].toLowerCase());if(9<s)e+=o*h[s-10];else{if(n=new Date(a(t,e)),s<7)for(;o;)n.setUTCDate(n.getUTCDate()+r),n.getUTCDay()==s&&(o-=r);else 7==s?n.setUTCFullYear(n.getUTCFullYear()+o):8==s?n.setUTCMonth(n.getUTCMonth()+o):n.setUTCDate(n.getUTCDate()+o);null==(e=c(t,n.getTime()))&&(e=c(t,n.getTime()+864e5*r)-864e5*r)}return e}var e={clock:function(){return+new Date},zone:"UTC",entry:{abbrev:"UTC",offset:0,save:0},UTC:1,z:function(t,e,i,n){var r,o,s=this.entry.offset+this.entry.save,a=Math.abs(s/1e3),l=[],h=3600;for(r=0;r<3;r++)l.push(("0"+Math.floor(a/h)).slice(-2)),a%=h,h/=60;return"^"!=i||s?("^"==i&&(n=3),3==n?(o=(o=l.join(":")).replace(/:00$/,""),"^"!=i&&(o=o.replace(/:00$/,""))):n?(o=l.slice(0,n+1).join(":"),"^"==i&&(o=o.replace(/:00$/,""))):o=l.slice(0,2).join(""),o=(o=(s<0?"-":"+")+o).replace(/([-+])(0)/,{_:" $1","-":"$1"}[i]||"$1$2")):"Z"},"%":function(t){return"%"},n:function(t){return"\n"},t:function(t){return"\t"},U:function(t){return u(t,0)},W:function(t){return u(t,1)},V:function(t){return i(t)[0]},G:function(t){return i(t)[1]},g:function(t){return i(t)[1]%100},j:function(t){return Math.floor((t.getTime()-Date.UTC(t.getUTCFullYear(),0))/864e5)+1},s:function(t){return Math.floor(t.getTime()/1e3)},C:function(t){return Math.floor(t.getUTCFullYear()/100)},N:function(t){return t.getTime()%1e3*1e6},m:function(t){return t.getUTCMonth()+1},Y:function(t){return t.getUTCFullYear()},y:function(t){return t.getUTCFullYear()%100},H:function(t){return t.getUTCHours()},M:function(t){return t.getUTCMinutes()},S:function(t){return t.getUTCSeconds()},e:function(t){return t.getUTCDate()},d:function(t){return t.getUTCDate()},u:function(t){return t.getUTCDay()||7},w:function(t){return t.getUTCDay()},l:function(t){return t.getUTCHours()%12||12},I:function(t){return t.getUTCHours()%12||12},k:function(t){return t.getUTCHours()},Z:function(t){return this.entry.abbrev},a:function(t){return this[this.locale].day.abbrev[t.getUTCDay()]},A:function(t){return this[this.locale].day.full[t.getUTCDay()]},h:function(t){return this[this.locale].month.abbrev[t.getUTCMonth()]},b:function(t){return this[this.locale].month.abbrev[t.getUTCMonth()]},B:function(t){return this[this.locale].month.full[t.getUTCMonth()]},P:function(t){return this[this.locale].meridiem[Math.floor(t.getUTCHours()/12)].toLowerCase()},p:function(t){return this[this.locale].meridiem[Math.floor(t.getUTCHours()/12)]},R:function(t,e){return this.convert([e,"%H:%M"])},T:function(t,e){return this.convert([e,"%H:%M:%S"])},D:function(t,e){return this.convert([e,"%m/%d/%y"])},F:function(t,e){return this.convert([e,"%Y-%m-%d"])},x:function(t,e){return this.convert([e,this[this.locale].date])},r:function(t,e){return this.convert([e,this[this.locale].time12||"%I:%M:%S"])},X:function(t,e){return this.convert([e,this[this.locale].time24])},c:function(t,e){return this.convert([e,this[this.locale].dateTime])},convert:function(t){if(!t.length)return"1.0.13";var e,i,l,n,h,u=Object.create(this),r=[];for(e=0;e<t.length;e++)if(n=t[e],Array.isArray(n))e||isNaN(n[1])?n.splice.apply(t,[e--,1].concat(n)):h=n;else if(isNaN(n)){if("string"==(l=typeof n))~n.indexOf("%")?u.format=n:e||"*"!=n?!e&&(l=/^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(n))?((h=[]).push.apply(h,l.slice(1,8)),l[9]?(h.push(l[10]+1),h.push.apply(h,l[11].split(/:/))):l[8]&&h.push(1)):/^\w{2,3}_\w{2}$/.test(n)?u.locale=n:(l=s.exec(n))?r.push(l):u.zone=n:h=n;else if("function"==l){if(l=n.call(u))return l}else if(/^\w{2,3}_\w{2}$/.test(n.name))u[n.name]=n;else if(n.zones){for(l in n.zones)u[l]=n.zones[l];for(l in n.rules)u[l]=n.rules[l]}}else e||(h=n);if(u[u.locale]||delete u.locale,u[u.zone]||delete u.zone,null!=h){if("*"==h)h=u.clock();else if(Array.isArray(h)){for(l=[],i=!h[7],e=0;e<11;e++)l[e]=+(h[e]||0);--l[1],h=Date.UTC.apply(Date.UTC,l)+-l[7]*(36e5*l[8]+6e4*l[9]+1e3*l[10])}else h=Math.floor(h);if(!isNaN(h)){if(i&&(h=c(u,h)),null==h)return h;for(e=0,i=r.length;e<i;e++)h=o(u,h,r[e]);return u.format?(l=new Date(a(u,h)),u.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,function(t,e,i,n,r){var o,s,a="0";if(o=u[r]){for(t=String(o.call(u,l,h,e,i.length)),"_"==(e||o.style)&&(a=" "),s="-"==e?0:o.pad||0;t.length<s;)t=a+t;for(s="-"==e?0:n||o.pad;t.length<s;)t=a+t;"N"==r&&s<t.length&&(t=t.slice(0,s)),"^"==e&&(t=t.toUpperCase())}return t})):h}}return function(){return u.convert(arguments)}},locale:"en_US",en_US:{date:"%m/%d/%Y",time24:"%I:%M:%S %p",time12:"%I:%M:%S %p",dateTime:"%a %d %b %Y %I:%M:%S %p %Z",meridiem:["AM","PM"],month:{abbrev:"Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),full:"January|February|March|April|May|June|July|August|September|October|November|December".split("|")},day:{abbrev:"Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),full:"Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")}}},l="Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond",s=new RegExp("^\\s*([+-])(\\d+)\\s+("+l+")s?\\s*$","i"),h=[36e5,6e4,1e3,1];function u(t,e){var i,n,r;return n=new Date(Date.UTC(t.getUTCFullYear(),0)),i=Math.floor((t.getTime()-n.getTime())/864e5),n.getUTCDay()==e?r=0:8==(r=7-n.getUTCDay()+e)&&(r=1),r<=i?Math.floor((i-r)/7)+1:0}function i(t){var e,i,n;return i=t.getUTCFullYear(),e=new Date(Date.UTC(i,0)).getUTCDay(),(n=u(t,1)+(1<e&&e<=4?1:0))?53!=n||4==e||3==e&&29==new Date(i,1,29).getDate()?[n,t.getUTCFullYear()]:[1,t.getUTCFullYear()+1]:(i=t.getUTCFullYear()-1,e=new Date(Date.UTC(i,0)).getUTCDay(),[n=4==e||3==e&&29==new Date(i,1,29).getDate()?53:52,t.getUTCFullYear()-1])}return l=l.toLowerCase().split("|"),"delmHMSUWVgCIky".replace(/./g,function(t){e[t].pad=2}),e.N.pad=9,e.j.pad=3,e.k.style="_",e.l.style="_",e.e.style="_",function(){return e.convert(arguments)}})},function(t,n,e){
/*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0
    
    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.
    
    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
var i,r,o,s,a,l,h,u,c,_,p,d,f,v,m,g,y,b,x;!function(t){var e="object"==typeof global?global:"object"==typeof self?self:"object"==typeof this?this:{};function i(i,n){return i!==e&&("function"==typeof Object.create?Object.defineProperty(i,"__esModule",{value:!0}):i.__esModule=!0),function(t,e){return i[t]=n?n(t,e):e}}"object"==typeof n&&"object"==typeof n.exports?t(i(e,i(n.exports))):t(i(e))}(function(t){var n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)e.hasOwnProperty(i)&&(t[i]=e[i])};i=function(t,e){function i(){this.constructor=t}n(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)},r=Object.assign||function(t){for(var e,i=1,n=arguments.length;i<n;i++)for(var r in e=arguments[i])Object.prototype.hasOwnProperty.call(e,r)&&(t[r]=e[r]);return t},o=function(t,e){var i={};for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&e.indexOf(n)<0&&(i[n]=t[n]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols)for(var r=0,n=Object.getOwnPropertySymbols(t);r<n.length;r++)e.indexOf(n[r])<0&&(i[n[r]]=t[n[r]]);return i},s=function(t,e,i,n){var r,o=arguments.length,s=o<3?e:null===n?n=Object.getOwnPropertyDescriptor(e,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(t,e,i,n);else for(var a=t.length-1;0<=a;a--)(r=t[a])&&(s=(o<3?r(s):3<o?r(e,i,s):r(e,i))||s);return 3<o&&s&&Object.defineProperty(e,i,s),s},a=function(i,n){return function(t,e){n(t,e,i)}},l=function(t,e){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(t,e)},h=function(o,s,a,l){return new(a||(a=Promise))(function(t,e){function i(t){try{r(l.next(t))}catch(t){e(t)}}function n(t){try{r(l.throw(t))}catch(t){e(t)}}function r(e){e.done?t(e.value):new a(function(t){t(e.value)}).then(i,n)}r((l=l.apply(o,s||[])).next())})},u=function(i,n){var r,o,s,t,a={label:0,sent:function(){if(1&s[0])throw s[1];return s[1]},trys:[],ops:[]};return t={next:e(0),throw:e(1),return:e(2)},"function"==typeof Symbol&&(t[Symbol.iterator]=function(){return this}),t;function e(e){return function(t){return function(e){if(r)throw new TypeError("Generator is already executing.");for(;a;)try{if(r=1,o&&(s=2&e[0]?o.return:e[0]?o.throw||((s=o.return)&&s.call(o),0):o.next)&&!(s=s.call(o,e[1])).done)return s;switch(o=0,s&&(e=[2&e[0],s.value]),e[0]){case 0:case 1:s=e;break;case 4:return a.label++,{value:e[1],done:!1};case 5:a.label++,o=e[1],e=[0];continue;case 7:e=a.ops.pop(),a.trys.pop();continue;default:if(!(s=0<(s=a.trys).length&&s[s.length-1])&&(6===e[0]||2===e[0])){a=0;continue}if(3===e[0]&&(!s||e[1]>s[0]&&e[1]<s[3])){a.label=e[1];break}if(6===e[0]&&a.label<s[1]){a.label=s[1],s=e;break}if(s&&a.label<s[2]){a.label=s[2],a.ops.push(e);break}s[2]&&a.ops.pop(),a.trys.pop();continue}e=n.call(i,a)}catch(t){e=[6,t],o=0}finally{r=s=0}if(5&e[0])throw e[1];return{value:e[0]?e[1]:void 0,done:!0}}([e,t])}}},c=function(t,e){for(var i in t)e.hasOwnProperty(i)||(e[i]=t[i])},_=function(t){var e="function"==typeof Symbol&&t[Symbol.iterator],i=0;return e?e.call(t):{next:function(){return t&&i>=t.length&&(t=void 0),{value:t&&t[i++],done:!t}}}},p=function(t,e){var i="function"==typeof Symbol&&t[Symbol.iterator];if(!i)return t;var n,r,o=i.call(t),s=[];try{for(;(void 0===e||0<e--)&&!(n=o.next()).done;)s.push(n.value)}catch(t){r={error:t}}finally{try{n&&!n.done&&(i=o.return)&&i.call(o)}finally{if(r)throw r.error}}return s},d=function(){for(var t=[],e=0;e<arguments.length;e++)t=t.concat(p(arguments[e]));return t},f=function(t){return this instanceof f?(this.v=t,this):new f(t)},v=function(t,e,i){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var r,o=i.apply(t,e||[]),s=[];return r={},n("next"),n("throw"),n("return"),r[Symbol.asyncIterator]=function(){return this},r;function n(n){o[n]&&(r[n]=function(i){return new Promise(function(t,e){1<s.push([n,i,t,e])||a(n,i)})})}function a(t,e){try{(i=o[t](e)).value instanceof f?Promise.resolve(i.value.v).then(l,h):u(s[0][2],i)}catch(t){u(s[0][3],t)}var i}function l(t){a("next",t)}function h(t){a("throw",t)}function u(t,e){t(e),s.shift(),s.length&&a(s[0][0],s[0][1])}},m=function(n){var t,r;return t={},e("next"),e("throw",function(t){throw t}),e("return"),t[Symbol.iterator]=function(){return this},t;function e(e,i){t[e]=n[e]?function(t){return(r=!r)?{value:f(n[e](t)),done:"return"===e}:i?i(t):t}:i}},g=function(l){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var t,e=l[Symbol.asyncIterator];return e?e.call(l):(l=_(l),t={},i("next"),i("throw"),i("return"),t[Symbol.asyncIterator]=function(){return this},t);function i(a){t[a]=l[a]&&function(s){return new Promise(function(t,e){var i,n,r,o;s=l[a](s),i=t,n=e,r=s.done,o=s.value,Promise.resolve(o).then(function(t){i({value:t,done:r})},n)})}}},y=function(t,e){return Object.defineProperty?Object.defineProperty(t,"raw",{value:e}):t.raw=e,t},b=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var i in t)Object.hasOwnProperty.call(t,i)&&(e[i]=t[i]);return e.default=t,e},x=function(t){return t&&t.__esModule?t:{default:t}},t("__extends",i),t("__assign",r),t("__rest",o),t("__decorate",s),t("__param",a),t("__metadata",l),t("__awaiter",h),t("__generator",u),t("__exportStar",c),t("__values",_),t("__read",p),t("__spread",d),t("__await",f),t("__asyncGenerator",v),t("__asyncDelegator",m),t("__asyncValues",g),t("__makeTemplateObject",y),t("__importStar",b),t("__importDefault",x)})}],s={base:0,"client/connection":1,"client/session":2,"core/bokeh_events":3,"core/build_views":4,"core/dom":5,"core/dom_view":6,"core/enums":7,"core/has_props":8,"core/hittest":9,"core/layout/alignments":10,"core/layout/layout_canvas":11,"core/layout/side_panel":12,"core/layout/solver":13,"core/logging":14,"core/properties":15,"core/property_mixins":16,"core/selection_manager":17,"core/settings":18,"core/signaling":19,"core/ui_events":20,"core/util/array":21,"core/util/arrayable":22,"core/util/assert":23,"core/util/bbox":24,"core/util/callback":25,"core/util/canvas":26,"core/util/color":27,"core/util/compat":28,"core/util/data_structures":29,"core/util/eq":30,"core/util/math":31,"core/util/object":32,"core/util/projections":33,"core/util/refs":34,"core/util/selection":35,"core/util/serialization":36,"core/util/spatial":37,"core/util/string":38,"core/util/svg_colors":39,"core/util/templating":40,"core/util/text":41,"core/util/throttle":42,"core/util/typed_array":43,"core/util/types":44,"core/util/wheel":45,"core/util/zoom":46,"core/vectorization":47,"core/view":48,"core/visuals":49,"document/document":50,"document/events":51,"document/index":52,"embed/dom":53,"embed/index":54,"embed/notebook":55,"embed/server":56,"embed/standalone":57,main:58,model:59,"models/annotations/annotation":60,"models/annotations/arrow":61,"models/annotations/arrow_head":62,"models/annotations/band":63,"models/annotations/box_annotation":64,"models/annotations/color_bar":65,"models/annotations/index":66,"models/annotations/label":67,"models/annotations/label_set":68,"models/annotations/legend":69,"models/annotations/legend_item":70,"models/annotations/poly_annotation":71,"models/annotations/slope":72,"models/annotations/span":73,"models/annotations/text_annotation":74,"models/annotations/title":75,"models/annotations/toolbar_panel":76,"models/annotations/tooltip":77,"models/annotations/whisker":78,"models/axes/axis":79,"models/axes/categorical_axis":80,"models/axes/continuous_axis":81,"models/axes/datetime_axis":82,"models/axes/index":83,"models/axes/linear_axis":84,"models/axes/log_axis":85,"models/axes/mercator_axis":86,"models/callbacks/callback":87,"models/callbacks/customjs":88,"models/callbacks/index":89,"models/callbacks/open_url":90,"models/canvas/canvas":91,"models/canvas/cartesian_frame":92,"models/canvas/index":93,"models/expressions/cumsum":94,"models/expressions/expression":95,"models/expressions/index":96,"models/expressions/stack":97,"models/filters/boolean_filter":98,"models/filters/customjs_filter":99,"models/filters/filter":100,"models/filters/group_filter":101,"models/filters/index":102,"models/filters/index_filter":103,"models/formatters/basic_tick_formatter":104,"models/formatters/categorical_tick_formatter":105,"models/formatters/datetime_tick_formatter":106,"models/formatters/func_tick_formatter":107,"models/formatters/index":108,"models/formatters/log_tick_formatter":109,"models/formatters/mercator_tick_formatter":110,"models/formatters/numeral_tick_formatter":111,"models/formatters/printf_tick_formatter":112,"models/formatters/tick_formatter":113,"models/glyphs/annular_wedge":114,"models/glyphs/annulus":115,"models/glyphs/arc":116,"models/glyphs/bezier":117,"models/glyphs/box":118,"models/glyphs/center_rotatable":119,"models/glyphs/circle":120,"models/glyphs/ellipse":121,"models/glyphs/ellipse_oval":122,"models/glyphs/glyph":123,"models/glyphs/hbar":124,"models/glyphs/hex_tile":125,"models/glyphs/image":126,"models/glyphs/image_rgba":127,"models/glyphs/image_url":128,"models/glyphs/index":129,"models/glyphs/line":130,"models/glyphs/multi_line":131,"models/glyphs/multi_polygons":132,"models/glyphs/oval":133,"models/glyphs/patch":134,"models/glyphs/patches":135,"models/glyphs/quad":136,"models/glyphs/quadratic":137,"models/glyphs/ray":138,"models/glyphs/rect":139,"models/glyphs/segment":140,"models/glyphs/step":141,"models/glyphs/text":142,"models/glyphs/utils":143,"models/glyphs/vbar":144,"models/glyphs/wedge":145,"models/glyphs/xy_glyph":146,"models/graphs/graph_hit_test_policy":147,"models/graphs/index":148,"models/graphs/layout_provider":149,"models/graphs/static_layout_provider":150,"models/grids/grid":151,"models/grids/index":152,"models/index":153,"models/layouts/box":154,"models/layouts/column":155,"models/layouts/index":156,"models/layouts/layout_dom":157,"models/layouts/row":158,"models/layouts/spacer":159,"models/layouts/widget_box":160,"models/mappers/categorical_color_mapper":161,"models/mappers/categorical_mapper":162,"models/mappers/categorical_marker_mapper":163,"models/mappers/color_mapper":164,"models/mappers/continuous_color_mapper":165,"models/mappers/index":166,"models/mappers/linear_color_mapper":167,"models/mappers/log_color_mapper":168,"models/mappers/mapper":169,"models/markers/defs":170,"models/markers/index":171,"models/markers/marker":172,"models/markers/scatter":173,"models/plots/gmap_plot":174,"models/plots/gmap_plot_canvas":175,"models/plots/index":176,"models/plots/plot":177,"models/plots/plot_canvas":178,"models/ranges/data_range":179,"models/ranges/data_range1d":180,"models/ranges/factor_range":181,"models/ranges/index":182,"models/ranges/range":183,"models/ranges/range1d":184,"models/renderers/glyph_renderer":185,"models/renderers/graph_renderer":186,"models/renderers/guide_renderer":187,"models/renderers/index":188,"models/renderers/renderer":189,"models/scales/categorical_scale":190,"models/scales/index":191,"models/scales/linear_scale":192,"models/scales/log_scale":193,"models/scales/scale":194,"models/selections/index":195,"models/selections/interaction_policy":196,"models/selections/selection":197,"models/sources/ajax_data_source":198,"models/sources/cds_view":199,"models/sources/column_data_source":200,"models/sources/columnar_data_source":201,"models/sources/data_source":202,"models/sources/geojson_data_source":203,"models/sources/index":204,"models/sources/remote_data_source":205,"models/tickers/adaptive_ticker":206,"models/tickers/basic_ticker":207,"models/tickers/categorical_ticker":208,"models/tickers/composite_ticker":209,"models/tickers/continuous_ticker":210,"models/tickers/datetime_ticker":211,"models/tickers/days_ticker":212,"models/tickers/fixed_ticker":213,"models/tickers/index":214,"models/tickers/log_ticker":215,"models/tickers/mercator_ticker":216,"models/tickers/months_ticker":217,"models/tickers/single_interval_ticker":218,"models/tickers/ticker":219,"models/tickers/util":220,"models/tickers/years_ticker":221,"models/tiles/bbox_tile_source":222,"models/tiles/image_pool":223,"models/tiles/index":224,"models/tiles/mercator_tile_source":225,"models/tiles/quadkey_tile_source":226,"models/tiles/tile_renderer":227,"models/tiles/tile_source":228,"models/tiles/tile_utils":229,"models/tiles/tms_tile_source":230,"models/tiles/wmts_tile_source":231,"models/tools/actions/action_tool":232,"models/tools/actions/custom_action":233,"models/tools/actions/help_tool":234,"models/tools/actions/redo_tool":235,"models/tools/actions/reset_tool":236,"models/tools/actions/save_tool":237,"models/tools/actions/undo_tool":238,"models/tools/actions/zoom_in_tool":239,"models/tools/actions/zoom_out_tool":240,"models/tools/button_tool":241,"models/tools/edit/box_edit_tool":242,"models/tools/edit/edit_tool":243,"models/tools/edit/freehand_draw_tool":244,"models/tools/edit/point_draw_tool":245,"models/tools/edit/poly_draw_tool":246,"models/tools/edit/poly_edit_tool":247,"models/tools/edit/poly_tool":248,"models/tools/gestures/box_select_tool":249,"models/tools/gestures/box_zoom_tool":250,"models/tools/gestures/gesture_tool":251,"models/tools/gestures/lasso_select_tool":252,"models/tools/gestures/pan_tool":253,"models/tools/gestures/poly_select_tool":254,"models/tools/gestures/range_tool":255,"models/tools/gestures/select_tool":256,"models/tools/gestures/tap_tool":257,"models/tools/gestures/wheel_pan_tool":258,"models/tools/gestures/wheel_zoom_tool":259,"models/tools/index":260,"models/tools/inspectors/crosshair_tool":261,"models/tools/inspectors/customjs_hover":262,"models/tools/inspectors/hover_tool":263,"models/tools/inspectors/inspect_tool":264,"models/tools/on_off_button":265,"models/tools/tool":266,"models/tools/tool_proxy":267,"models/tools/toolbar":268,"models/tools/toolbar_base":269,"models/tools/toolbar_box":270,"models/tools/util":271,"models/transforms/customjs_transform":272,"models/transforms/dodge":273,"models/transforms/index":274,"models/transforms/interpolator":275,"models/transforms/jitter":276,"models/transforms/linear_interpolator":277,"models/transforms/step_interpolator":278,"models/transforms/transform":279,polyfill:280,"protocol/index":281,"protocol/message":282,"protocol/receiver":283,safely:284,testing:285,version:286},r={},(l=(a=function(t){var e=null!=s[t]?s[t]:t;if(!r[e]){if(!o[e]){var i=new Error("Cannot find module '"+t+"'");throw i.code="MODULE_NOT_FOUND",i}var n=r[e]={exports:{}};o[e].call(n.exports,a,n,n.exports)}return r[e].exports})(58)).require=a,l.register_plugin=function(t,e,i){for(var n in t)o[n]=t[n];for(var n in e)s[n]=e[n];var r=a(i);for(var n in r)l[n]=r[n];return r},l)}(this);
//# sourceMappingURL=bokeh.min.js.map