
define [
  "underscore",
  "common/collection",
  "common/has_properties",
  "common/logging",
  "ticking/basic_tick_formatter"
], (_, Collection, HasProperties, Logging, BasicTickFormatter) ->

  logger = Logging.logger

  class LogTickFormatter extends HasProperties
    type: 'LogTickFormatter'

    initialize: (attrs, options) ->
      super(attrs, options)
      @basic_formatter = new BasicTickFormatter.Model()
      if not @get('ticker')?
        logger.warn("LogTickFormatter not configured with a ticker, using default base of 10 (labels will be incorrect if ticker base is not 10)")

    format: (ticks) ->
      if ticks.length == 0
        return []

      if @get('ticker')?
        base = @get('ticker').get('base')
      else
        base = 10

      small_interval = false
      labels = new Array(ticks.length)
      for i in [0...ticks.length]
        labels[i] = "#{base}^#{ Math.round(Math.log(ticks[i]) / Math.log(base)) }"
        if (i > 0) and (labels[i] == labels[i-1])
          small_interval = true
          break

      if small_interval
        labels = @basic_formatter.format(ticks)

      return labels

  class LogTickFormatters extends Collection
    model: LogTickFormatter

  return {
    "Model": LogTickFormatter,
    "Collection": new LogTickFormatters()
  }
