// TODO disable reordering for this suite!


var begin = 0,
	moduleStart = 0,
	moduleDone = 0,
	testStart = 0,
	testDone = 0,
	log = 0,
	moduleContext,
	moduleDoneContext,
	testContext,
	testDoneContext,
	logContext;

QUnit.begin(function() {
	begin++;
});
QUnit.done(function() {
});
QUnit.moduleStart(function(context) {
	moduleStart++;
	moduleContext = context;
});
QUnit.moduleDone(function(context) {
	moduleDone++;
	moduleDoneContext = context;
});
QUnit.testStart(function(context) {
	testStart++;
	testContext = context;
});
QUnit.testDone(function(context) {
	testDone++;
	testDoneContext = context;
});
QUnit.log(function(context) {
	log++;
	logContext = context;
});

var logs = ["begin", "testStart", "testDone", "log", "moduleStart", "moduleDone", "done"];
for (var i = 0; i < logs.length; i++) {
	(function() {
		var log = logs[i];
		QUnit[log](function() {
			console.log(log, arguments);
		});
	})();
}

module("logs1");

test("test1", 15, function() {
	equal(begin, 1);
	equal(moduleStart, 1);
	equal(testStart, 1);
	equal(testDone, 0);
	equal(moduleDone, 0);

	deepEqual(logContext, {
		name: "test1",
		module: "logs1",
		result: true,
		message: undefined,
		actual: 0,
		expected: 0
	});
	equal("foo", "foo", "msg");
	deepEqual(logContext, {
		name: "test1",
		module: "logs1",
		result: true,
		message: "msg",
		actual: "foo",
		expected: "foo"
	});
	strictEqual(testDoneContext, undefined);
	deepEqual(testContext, {
		module: "logs1",
		name: "test1"
	});
	strictEqual(moduleDoneContext, undefined);
	deepEqual(moduleContext, {
		name: "logs1"
	});
	ok(true, "msg");
	deepEqual(logContext, {
		module: "logs1",
		name: "test1",
		result: true,
		message: "msg"
	});

	equal(log, 14);
});
test("test2", 10, function() {
	equal(begin, 1);
	equal(moduleStart, 1);
	equal(testStart, 2);
	equal(testDone, 1);
	equal(moduleDone, 0);

	deepEqual(testDoneContext, {
		module: "logs1",
		name: "test1",
		failed: 0,
		passed: 15,
		total: 15
	});
	deepEqual(testContext, {
		module: "logs1",
		name: "test2"
	});
	strictEqual(moduleDoneContext, undefined);
	deepEqual(moduleContext, {
		name: "logs1"
	});

	equal(log, 24);
});

module("logs2");

test("test1", 9, function() {
	equal(begin, 1);
	equal(moduleStart, 2);
	equal(testStart, 3);
	equal(testDone, 2);
	equal(moduleDone, 1);

	deepEqual(testContext, {
		module: "logs2",
		name: "test1"
	});
	deepEqual(moduleDoneContext, {
		name: "logs1",
		failed: 0,
		passed: 25,
		total: 25
	});
	deepEqual(moduleContext, {
		name: "logs2"
	});

	equal(log, 33);
});
test("test2", 8, function() {
	equal(begin, 1);
	equal(moduleStart, 2);
	equal(testStart, 4);
	equal(testDone, 3);
	equal(moduleDone, 1);

	deepEqual(testContext, {
		module: "logs2",
		name: "test2"
	});
	deepEqual(moduleContext, {
		name: "logs2"
	});

	equal(log, 41);
});

var testAutorun = true;

QUnit.done(function() {

	if (!testAutorun) {
		return;
	}

	testAutorun = false;

	module("autorun");

	test("reset", 0, function() {});

	moduleStart = moduleDone = 0;

	test("first", function(){
		equal(moduleStart, 1, "test started");
		equal(moduleDone, 0, "test in progress");
	});

	test("second", function(){
		equal(moduleStart, 2, "test started");
		equal(moduleDone, 1, "test in progress");
	});
});
