# aws-lc-sys

[![crates.io](https://img.shields.io/crates/v/aws-lc-sys.svg)](https://crates.io/crates/aws-lc-sys)

**Autogenerated** Low-level AWS-LC bindings for the Rust programming language. We do not recommend directly relying on these bindings.

[Documentation](https://github.com/aws/aws-lc).

## Release Support

This crate pulls in the source code of AWS-LC to build with it. Bindings for platforms we officially support are pre-generated. To generate bindings for any platforms where pre-generated bindings aren't available, you can use the `generate_bindings` feature to do so.

### Pregenerated Bindings Availability

CPU|OS
-------------|-------------
x86|Linux
x86-64|Linux
arm-64|Linux
x86-64|MacOS

## Build Prerequisites

Since this crate builds AWS-LC as a native library, most build tools needed to build AWS-LC are applicable to `aws-lc-sys` as well. Go and Perl aren't absolutely necessary for `aws-lc-sys`, as AWS-LC provides generated build files.

[Building AWS-LC](https://github.com/aws/aws-lc/blob/main/BUILDING.md)

AWS-LC is tested on a variety of C/C++ compiler, OS, and CPU combinations. For a complete list of tested combinations see [tests/ci/Readme.md](https://github.com/aws/aws-lc/tree/main/tests/ci#unit-tests). If you use a different build combination and would like us to support it, please open an issue to us at [AWS-LC](https://github.com/aws/aws-lc/issues/new?assignees=&labels=&template=build-issue.md&title=).

## Building with a FIPS-validated module

This crate does not offer the AWS-LC FIPS build. To use AWS-LC FIPS, please use the FIPS version of this crate, available at [aws-lc-fips-sys](https://crates.io/crates/aws-lc-fips-sys).

## Contribution

See contributing file at [AWS-LC](https://github.com/aws/aws-lc/blob/main/CONTRIBUTING.md)

## Licensing

See license at [AWS-LC](https://github.com/aws/aws-lc/blob/main/LICENSE)
