/*
 * Decompiled with CFR 0.152.
 */
package org.pyant.tasks;

import java.io.File;
import java.util.ArrayList;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.pyant.tasks.PythonInteractiveBaseTask;

public class PythonTestTask
extends PythonInteractiveBaseTask {
    protected ArrayList filesets = new ArrayList();
    protected File dir = null;
    protected String testrunner = "";
    private static final String FAIL_MSG = "Test execution failed.  See output for details.";
    protected boolean packagedtests = true;

    public void execute() {
        Project project = this.getProject();
        project.log("PythonTestTask.execute()", 4);
        Commandline commandline = new Commandline();
        commandline.setExecutable("python");
        this.makeScript();
        if (this.script != null) {
            super.executeScript(project, this.dir, FAIL_MSG);
        }
    }

    private void makeScript() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getModulesArg(this.getProject());
        stringBuffer.append("import unittest\n");
        if (string != null) {
            this.getProject().log("Non-null modules arg. creating script");
            if (!this.testrunner.equals("")) {
                int n = this.testrunner.lastIndexOf(46);
                String string2 = n >= 0 ? this.testrunner.substring(0, this.testrunner.lastIndexOf(46)) : "";
                stringBuffer.append("import " + string2 + "\n");
            }
            stringBuffer.append("unittest.main(module=None, defaultTest=None, argv=[" + string + "]");
            if (!this.testrunner.equals("")) {
                stringBuffer.append(", testRunner=" + this.testrunner + "()");
            }
            stringBuffer.append(")\n");
            this.script = stringBuffer.toString();
        } else {
            this.getProject().log("Modules arg is null. not creating script");
            this.script = null;
        }
    }

    protected String getModulesArg(Project project) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string2 : this.filesets) {
            DirectoryScanner directoryScanner = string2.getDirectoryScanner(project);
            String[] stringArray = directoryScanner.getIncludedFiles();
            for (int i = 0; i < stringArray.length; ++i) {
                project.log(stringArray[i]);
                if (!stringArray[i].endsWith(".py")) continue;
                String string3 = stringArray[i].substring(0, stringArray[i].length() - 3);
                if (!this.packagedtests) {
                    string3 = string3.substring(string3.lastIndexOf(File.separatorChar) + 1);
                }
                if (bl) {
                    stringBuffer.append("'" + string3 + "'");
                    bl = false;
                }
                stringBuffer.append(",'" + string3 + "'");
            }
        }
        string2 = stringBuffer.toString();
        if ("".equals(string2.trim())) {
            return null;
        }
        string2 = string2.replace('\\', '.');
        string2 = string2.replace('/', '.');
        project.log("Modules: " + string2);
        return string2;
    }

    public void setPackagedtests(boolean bl) {
        this.packagedtests = bl;
    }

    public void addFileSet(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setTestRunner(String string) {
        this.testrunner = string;
    }
}

