"""unit tests for the apycot.utils module"""

import unittest
from logilab.common.testlib import TestCase


from apycot import SUCCESS, PARTIAL, FAILURE, SKIPPED, ERROR, MISSING, merge_status, TestStatus


class StatusTC(TestCase):
    """Default tests for data file utilities functions"""
    
    def test_order(self):
        self.assertTrue(SUCCESS > PARTIAL)
        self.assertTrue(PARTIAL > FAILURE)
        self.assertTrue(FAILURE > ERROR)
        self.assertTrue(ERROR > SKIPPED)
        
        self.assertFalse(SUCCESS < PARTIAL)
        self.assertFalse(PARTIAL < FAILURE)
        self.assertFalse(FAILURE < ERROR)
        self.assertFalse(ERROR < SKIPPED)

        self.assertTrue(PARTIAL > ERROR)
        self.assertFalse(FAILURE > SUCCESS)
        
        self.assertTrue(ERROR == ERROR)
        self.assertFalse(SKIPPED == SUCCESS)

    def test_bool(self):
        self.assertTrue(SUCCESS)
        self.assertTrue(PARTIAL)
        self.assertFalse(FAILURE)
        self.assertFalse(SKIPPED)
        self.assertFalse(SKIPPED)

    def test_string(self):
        self.assertTextEquals("%s"%SUCCESS,"success")
        self.assertTextEquals("%s"%PARTIAL,"partial")
        self.assertTextEquals("%s"%FAILURE,"failure")
        self.assertTextEquals("%s"%SKIPPED,"skipped")
        self.assertTextEquals("%s"%ERROR,"error")

    def test_merge(self):
        self.assertIs(merge_status(SUCCESS,FAILURE),FAILURE)
        self.assertIs(merge_status(PARTIAL,ERROR),ERROR)

    def test_get(self):
        self.assertIs(TestStatus.get("failure"),FAILURE)
        self.assertIs(TestStatus.get("jkdshqmhdgslmflk"),None)

    def test_int(self):
        self.assertEquals(FAILURE, 0)

if __name__ == '__main__':
    unittest.main()
