# Copyright (c) 2003-2004 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
"""
unit tests for the runtests module
"""


from logilab.common.testlib import TestCase, unittest_main
from threading import Thread, Event


from apycot.runtests import active_test_thread_names, get_tests
from utils import MockConfigParser


class MiscTC(TestCase):
    
    def test_thread_names(self):
        event = Event()
        names = ("titi","tutu","tata","toto")
        threads = [ Thread(target=event.wait, name=name) for name in names ]
        for thread in threads:
            thread.start()
        self.assertTextEquals("tata, titi, toto, tutu", active_test_thread_names())
        event.set()
        for thread in threads:
            thread.join()

    def test_get_test_simple(self):
        config = MockConfigParser({'alice':{'is_test':'1','eyes':'blue'},
                                    'bob':{'is_test':'1','hat':'black'},
                                    'caroline':{'meal':'cake'},})
        tests = get_tests(config)
        self.assertEquals(tests, set(('alice',"bob")))

    def test_get_test_negativ(self):
        config = MockConfigParser({'alice':{'is_test':'0','eyes':'blue'},
                                    'bob':{'is_test':'1','hat':'black'},
                                    'caroline':{'cake':'a lie', 'is_test':'1'},})
        tests = get_tests(config)
        self.assertEquals(tests, set(('caroline',"bob")))


if __name__ == '__main__':
    unittest_main()
