"""unit tests for apycot.reporters"""

from logilab.common.testlib import TestCase, unittest_main

from utils import MockTransport, MockConfigParser

from apycot import get_registered, list_registered
from apycot.datamanagers import XMLDataManager
from apycot.formatters import TextFormatter, HTMLFormatter
from apycot.reporters.simple import *
from apycot.reporters.evolution import *

config = MockConfigParser({'DATA': {'location':'inputs'}})
datamanager = XMLDataManager(config)

try:
    from reportlab.graphics import renderPM
except ImportError:
    HAS_RL = False
else:
    HAS_RL = True


class ReportsTC(TestCase):
    def test(self):
        keys = list_registered('reporter')
        keys.sort()
        if HAS_RL:
            self.assertEquals(keys, ['activity_evolution_graph',
                                     'contest_report', 'detailed_report',
                                     'minimal_report', 'multi_files_detailed_report',
                                     'status_evolution_graph', 'status_evolution_report',
                                     'synthetized_report', 'test_activity_report'])
        else:
            self.assertEquals(keys, ['contest_report', 'detailed_report',
                                     'minimal_report', 'multi_files_detailed_report',
                                     'status_evolution_report',
                                     'synthetized_report', 'test_activity_report'])
            
def make_reporter(reporter_id, url_support, formatter=None):
    transport = transport = MockTransport(url_support=url_support)
    transport.open(datamanager.date)
    allreporters = []
    reporter_fact = get_registered('reporter', reporter_id)
    reporter= reporter_fact('Myreport', transport=transport,
                            formatter=formatter, all_reporters=allreporters)
    return reporter, transport

class BaseReportTC:
        
    def test_html_w_link_support(self):
        reporter, transport = make_reporter(self.reporter_id, 1, HTMLFormatter())
        reporter.make_reports(datamanager)
        self.assert_(transport.transported)

    def test_html_wo_link_support(self):
        reporter, transport = make_reporter(self.reporter_id, 0, HTMLFormatter())
        reporter.make_reports(datamanager)
        self.assert_(transport.transported)

    def test_text_w_link_support(self):
        reporter, transport = make_reporter(self.reporter_id, 1, TextFormatter())
        reporter.make_reports(datamanager)
        self.assert_(transport.transported)

    def test_text_wo_link_support(self):
        reporter, transport = make_reporter(self.reporter_id, 0, TextFormatter())
        reporter.make_reports(datamanager)
        self.assert_(transport.transported)


class MinimalReportTC(BaseReportTC, TestCase):
    reporter_id = 'minimal_report'
class SynthetizedReportTC(BaseReportTC, TestCase):
    reporter_id = 'synthetized_report'
class DetailedReportTC(BaseReportTC, TestCase):
    reporter_id = 'detailed_report'
class MultiFilesDetailedReportTC(BaseReportTC, TestCase):
    reporter_id = 'multi_files_detailed_report'
class ContestReportTC(BaseReportTC, TestCase):
    reporter_id = 'contest_report'

class StatusEvolutionReportTC(BaseReportTC, TestCase):
    reporter_id = 'status_evolution_report'
class TestActivityReportTC(BaseReportTC, TestCase):
    reporter_id = 'test_activity_report'
    
if HAS_RL:
    class BaseGraphReportTC:
        def test(self):
            reporter, transport = make_reporter(self.reporter_id, 1)
            reporter.make_reports(datamanager)
            self.assert_(transport.transported)
            
    class StatusEvolutionGraphReportTC(BaseGraphReportTC, TestCase):
        reporter_id = 'status_evolution_graph'
    class ActivityEvolutionGraphReportTC(BaseGraphReportTC, TestCase):
        reporter_id = 'activity_evolution_graph'
    

## class MakeIdsDictFunctionTest(TestCase):
##     def test_known_values(self):
##         self.assertEqual(make_ids_dict(('a_b', 'c_d')),
##                          {'a_b': 'ab', 'c_d': 'cd'})
##         self.assertEqual(make_ids_dict(('a_b', 'a_b2', 'c_d')),
##                          {'a_b2': 'a2', 'a_b': 'ab', 'c_d': 'cd'})
##         self.assertEqual(make_ids_dict(('a_b', 'ab_b2', 'c_d')),
##                          {'a_b': 'ab', 'c_d': 'cd', 'ab_b2': 'bb'})
##         self.assertEqual(make_ids_dict(('a_b', 'a', 'ab_b2', 'c_d')),
##                          {'a': 'a0', 'a_b': 'ab', 'c_d': 'cd', 'ab_b2': 'bb'})

        
if __name__ == '__main__':
    unittest_main()
