"""unittest for apycot's decorators"""

import unittest
from os.path import join
from lxml.etree import parse

from logilab.common.testlib import mock_object, TestCase, unittest_main

from utils import MockRepository

from apycot import get_registered, list_registered, register
from apycot.utils import DAY

from apycot.decorators import *

MockRepository.__name__ = 'mock'
register('repository', MockRepository)


class DecoratorsTC(TestCase):
    def test(self):
        keys = list_registered('decorator')
        keys.sort()
        self.assertEquals(keys, ['activity', 'contest'])


    def test_decorator_pattern(self):
        def _raise(*args):
            raise Exception()
        d = AbstractDecorator()
        d.do_decorate = _raise
        d2 = AbstractDecorator(d)
        d2.do_decorate = lambda *args: args
        self.assertRaises(Exception, d2.decorate, None, None)
        self.assertRaises(NotImplementedError , AbstractDecorator().decorate, None, None)
        
class BaseDecoratorTC(TestCase):
    options = {}
    def setUp(self):
        self.tree = parse(join('inputs', self.file))
        self.data = self.tree.getroot()
        self.decorator = get_registered('decorator', self.decorator)()
        self.decorator.set_options(self.options)
        

class ContestDecoratorTC(BaseDecoratorTC):
    file = 'mock_data.xml'
    decorator = 'contest'
    options = {'fields': 'pylint_evaluation, test_coverage',
               'expression': 'test_coverage / 5 + pylint_evaluation'}
    decorated_data = ('check', {'name': 'contest', 'fake': '1', 'status':'27.00'}, [
        ('raw', {'class': 'fields'},[], 'pylint_evaluation, test_coverage'),
        ('raw', {'class': 'expression'},[], 'test_coverage / 5 + pylint_evaluation'),
        ('raw', {'class': 'test_coverage'},[],'90.0'),
        ('raw', {'class': 'pylint_evaluation'},[], '9.0')])
        
    def test(self):
        self.decorator.decorate(self.data, None)
        self.assertEquals(len(self.data[0]), 2)
        contest = self.data[0][-1]
        self.assertXMLEqualsTuple(contest, self.decorated_data)
        note = float(self.data[1][-1].get('status'))
        self.assertEquals(note, 27.0)
        note = float(self.data[2][-1].get('status'))
        self.assertEquals(note, -1.0)


class ActivityDecoratorTC(BaseDecoratorTC):
    file = 'mock_data.xml'
    decorator = 'activity'

    def test(self):
        self.decorator.decorate(self.data, mock_object(date_offset=DAY))
        self.assertEquals(len(self.data[0]), 2)
        activity = self.data[0][-1]
        self.assertXMLEqualsTuple(activity,
                              ['check', {'status': 'active', 'name': 'activity', 'fake': '1'},
                               [('log', {'path': 'xxx/file', 'severity': 'INFO'},[], 'author: log message'),
                                ('raw', {'class': 'date'},[], 'from 2004/02/28 to 2004/02/29'),
                                ('raw', {'class': 'added_lines'},[], '6'),
                                ('raw', {'class': 'deleted_lines'},[], '3')]])

if __name__ == '__main__':
    unittest_main()
