# Copyright (c) 2003-2004 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
"""
unit tests for the writer module
"""

from logilab.common.testlib import TestCase, unittest_main
import shutil
import sys
import os
from os.path import join
from cStringIO import StringIO
from lxml.etree import parse

from utils import input_path

                         

class AcceptanceTest(TestCase):
    def setUp(self):
        # update inputs/apycot.ini if you change this
        self.tempdir = "/tmp/tester_tests"
        if not os.path.isdir(self.tempdir):
            os.mkdir(self.tempdir)
        self.config = input_path('tester.ini')

    def tearDown(self):
        shutil.rmtree(self.tempdir)

    def test_goodWrittenFile(self):
        from apycot import runtests
        from apycot.utils import get_latest
        sys.stdout = sys.stderr = StringIO()
        try:
            runtests.run_from_config_file(self.config)
        finally:
            sys.stdout = sys.__stdout__
            sys.stderr = sys.__stderr__
        filename = join(get_latest(self.tempdir),'tester_data.xml')
        tree = parse(join(get_latest(self.tempdir),
                                              'tester_data.xml'))
        self.failUnlessEqual(tree.getroot().tag, u'testsdata')

if __name__ == '__main__':
    unittest_main()
