# Copyright (c) 2004-2007 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
"""installation preprocessor for Zope products
"""


import os
from os.path import join, abspath, basename

from apycot.preprocessors import BasePreProcessor
from apycot import IPreProcessor, register
from apycot.utils import EnvironmentTrackerMixin
    
class ZopeInstanceProcessor(EnvironmentTrackerMixin, BasePreProcessor):
    """install a product in a zope test environment (INSTANCE_HOME)
    """
    __implements__ = IPreProcessor
    __name__ = 'zope_install'

    def __init__(self, writer, options):
        EnvironmentTrackerMixin.__init__(self)
        BasePreProcessor.__init__(self, writer, options)
        self._installed = {}
           
    # PreProcessor interface ##################################################

    def check_setup(self, test, checker):
        """setup the test environment"""
        self._install(test.repo.path)
        test.install_base = self._installed[test.repo.path]
            
    def check_clean(self, test, checker):
        """clean the test environment"""
        self._uninstall(test.repo.path)
            
    def dependancy_setup(self, test, path):
        """setup the test environment

        may raise a SetupException
        """
        self._install(path)

    def dependancy_clean(self, test, path):
        """clean the test environment
        """
        self._uninstall(path)

    # private #################################################################
    
    def _install(self, path):
        """run the distutils setup.py install method on a path if
        the path is not yet installed
        """
        self.writer.msg(1, 'Run preprocessor %s on %s' % (self.__name__, path))
        products_dir = join(os.environ.get('INSTANCE_HOME',
                                           '/var/lib/zope/instance/test'),
                            'Products')
        self._installed[path] =  join(products_dir, basename(path))
        try:
            os.symlink(abspath(path), self._installed[path])
        except OSError, ex:
            ex.args += (abspath(path), self._installed[path])
            raise
        self.writer.msg(2, 'Preprocessor %s succeed on %s' % (self.__name__,
                                                              path))

    def _uninstall(self, path):
        """run the distutils setup.py install method on a path if
        the path is not yet installed
        """
        self.writer.msg(2, 'Run preprocessor %s cleaning on dependancy %s' % (
            self.__name__, path))
        os.remove(self._installed[path])
        del self._installed[path]

register('preprocessor', ZopeInstanceProcessor)
