# Copyright (c) 2003-2007 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
"""debian packages builder preprocessor

Requires logilab's devtools package
"""

from os.path import abspath
from tempfile import mkdtemp


#from logilab.common import shellutils
from logilab.devtools.buildpackage import build_debian

from apycot.preprocessors import BasePreProcessor, clean_modules
from apycot import register, IPreProcessor

#COMMAND = "fakeroot make -f debian/rules binary 1>/dev/null 2>/dev/null"

class DebianProcessor(BasePreProcessor):
    """preprocessor building debian package using fakeroot
    """

    __implements__ = IPreProcessor
    __name__ = 'build_debian'

    # PreProcessor interface ##################################################
    
    def check_setup(self, test, checker):
        """setup the test environment
        """
        if hasattr(test, 'deb_packages_dir'):
            # already processed
            return
        path = test.repo.env_path()
        self.writer.msg(1, 'Run preprocessor %s on %s' % (self.__name__, path))
        clean_modules('__pkginfo__')
        # create a temp directory to put the generated files (deb, dsc...)
        destdir = abspath(mkdtemp(dir='.'))
        test.deb_packages_dir = destdir
        self.execute(None, build_debian, abspath(path), destdir, quiet=True)
        
    def check_clean(self, test, checker):
        """clean the test environment

        don't actually remove the directory so we don't have to build debian
        package for each check requiring this preprocessor in the same test
        """
        path = test.repo.env_path()
        self.writer.msg(2, 'Run preprocessor %s cleaning on %s' % (
            self.__name__, path))
                    
    def dependancy_setup(self, test, path):
        """setup the test environment for a dependancy
        """
        raise Exception('This preprocessor is not able to handle dependancies')

    def dependancy_clean(self, test, path):
        """clean the test environment for a dependancy
        """
        pass

register('preprocessor', DebianProcessor)
        
        
