# pylint: disable-msg=W0622
# Copyright (c) 2004-2008 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
"""tester packaging information"""

distname = 'apycot'
modname = 'apycot'

numversion = (0, 12, 3)
version = '.'.join([str(num) for num in numversion])

license = 'GPL'
copyright = '''Copyright (c) 2004-2008 LOGILAB S.A. (Paris, FRANCE).
http://www.logilab.fr/ -- mailto:contact@logilab.fr'''

author = "Sylvain Thenault"
author_email = "sylvain.thenault@logilab.fr"

short_desc = "batch testing framework"
long_desc = """This package is designed to run tests on a code repository on a
daily basis. It comes with a set of predefined tests, essentially for python 
packages, and a set of predefined reports to display execution results. 
However, it has been designed to be higly extensible, so you could write your 
own test or report using the Python language (i.e. this framework is NOT 
limited to test Python code !)."""

web = "http://www.logilab.org/projects/%s" % distname.lower()
ftp = "ftp://ftp.logilab.org/pub/%s" % distname.lower()
mailinglist = "mailto://qa-projects@logilab.org"

from os.path import join

doc_files = [join('doc', '*.txt')]
html_doc_files = [join('doc', '*.html'),
                  join('doc', '*.png'),
                  join('doc', 'samples')]

scripts = [join('bin', 'apycot-runtests'), join('bin', 'apycot-runtest'), 
           join('bin', 'apycot-runcheck'), join('bin', 'apycot-runreports'), 
           join('bin', 'apycot-changes')]

include_dirs = [join('tests', 'inputs')]

pyversions = ['2.4']

debian_name = "apycot"
