#!/bin/sh

VERSION="3.0.0"
MAJOR_MINOR="3.0"

pip install --user --upgrade antsibull
git clone git@github.com:ansible-community/ansible-build-data
mkdir built
BUILD_DATA_DIR="ansible-build-data/${MAJOR_MINOR}"
if test -e "${BUILD_DATA_DIR}/ansible-${MAJOR_MINOR}.build" ; then
  BUILDFILE="ansible-${MAJOR_MINOR}.build"
  DEPSFILE="ansible-${VERSION}.deps"
else
  BUILDFILE="acd-${MAJOR_MINOR}.build"
  DEPSFILE="acd-${VERSION}.deps"
fi
antsibull-build rebuild-single "${VERSION}" --data-dir "${BUILD_DATA_DIR}" --build-file "${BUILDFILE}" --deps-file "${DEPSFILE}" --sdist-dir built --debian

#pip install twine
#twine upload "built/ansible-${VERSION}.tar.gz"