# Contributing

Hello and welcome! Thank you for being interested in contributing to this project.

First of all get confident with the [Ansible Collections Overview](https://github.com/ansible-collections/overview).

We accept pull requests for bugfixes, new features, and other improvements, assuming they pass our review. If you are planning a larger feature or refactoring, please create an issue first to discuss it with us.

## :bug: Reporting an issue

Please [search in the issue list](https://github.com/ansible-collections/community.sops/issues) and if has not been already reported, [open a new issue](https://github.com/ansible-collections/community.sops/issues/new/choose)

## 🏗 To contribute

A more extensive walk-through can be found in [Ansible's Contributing to collections](https://docs.ansible.com/ansible/latest/dev_guide/developing_collections.html#hacking-collections).

1. Fork this repo (when checking it out, see [here](https://docs.ansible.com/ansible/latest/dev_guide/developing_collections.html#contributing-to-collections) for how to place the checkout correctly)
1. Create a feature branch
1. Commit and push your code. To make the process faster, please ensure:

    - the tests are green. Tests runs using [GitHub Actions](https://help.github.com/en/actions)
    - you added a [changelog fragment](https://docs.ansible.com/ansible/latest/community/development_process.html#changelogs-how-to)

Please note that all PRs that are not strictly documentation, testing, or add a new plugin or module, require a changelog fragment. See [Creating a changelog fragment](https://docs.ansible.com/ansible/latest/community/development_process.html#changelogs-how-to) for information on that.

Further resources:

- [Ansible Developer guide: developing collections](https://docs.ansible.com/ansible/latest/dev_guide/developing_collections.html)
- [Ansible Developer guide](https://docs.ansible.com/ansible/latest/dev_guide/index.html)

This repository adheres to the [Ansible Community code of conduct](https://docs.ansible.com/ansible/latest/community/code_of_conduct.html)
