from .. import Provider as DateTimeProvider


class Provider(DateTimeProvider):
    DAY_NAMES = {
        '0': 'السبت',
        '1': 'الأحد',
        '2': 'الإثنين',
        '3': 'الثلاثاء',
        '4': 'الأربعاء',
        '5': 'الخميس',
        '6': 'الجمعة',
    }

    MONTH_NAMES = {
        '01': 'كانون الثّاني',
        '02': 'شباط',
        '03': 'آذار',
        '04': 'نيسان',
        '05': 'أيّار',
        '06': 'حزيران',
        '07': 'تمّوز',
        '08': 'آب',
        '09': 'أيلول',
        '10': 'تشرين الأول',
        '11': 'تشرين الثاني',
        '12': 'كانون الأول',
    }

    centuries = [
        'الأول', 'الثاني', 'الثالث', 'الرابع', 'الخامس', 'السادس',
        'السابع', 'الثامن', 'التاسع', 'العاشر', 'الحادي عشر',
        'الثاني عشر', 'الثالث عشر', 'الرابع عشر', 'الخامس عشر',
        'السادس عشر', 'الثامن عشر', 'التاسع عشر', 'العشرين',
        'الحادي والعشرين', 'الثاني والعشرين',
    ]

    countries = [{'timezones': ['أوروب/أندورا'],
                  'alpha-2-code': 'AD',
                  'continent': 'أوروبا',
                  'name': 'أندورا',
                  'capital': 'أندورا لا فيلا'},
                 {'timezones': ['آسيا/كابل'],
                  'alpha-2-code': 'AF',
                  'continent': 'آسيا',
                  'name': 'أفغانستان',
                  'capital': 'كابل'},
                 {'timezones': ['أمريكا/أنتيغوا'],
                  'alpha-2-code': 'AG',
                  'continent': 'أمريكا الشمالية',
                  'name': 'أنتيغوا وباربودا',
                  'capital': "سانت جونز"},
                 {'timezones': ['أوروبا/تيرانا'],
                  'alpha-2-code': 'AL',
                  'continent': 'أوروبا',
                  'name': 'ألبانيا',
                  'capital': 'تيرانا'},
                 {'timezones': ['آسيا/يريفان'],
                  'alpha-2-code': 'AM',
                  'continent': 'آسيا',
                  'name': 'أرمينيا',
                  'capital': 'يريفان'},
                 {'timezones': ['إفريقيا/لواندا'],
                  'alpha-2-code': 'AO',
                  'continent': 'إفريقيا',
                  'name': 'أنغولا',
                  'capital': 'لواندا'},
                 {'timezones': ['أمريكا/الأرجنتين/بوينس_آيرس',
                                'أمريكا/الأرجنتين/Cordoba',
                                'أمريكا/الأرجنتين/خوخوي',
                                'أمريكا/الأرجنتين/توكومان',
                                'أمريكا/الأرجنتين/كاتاماركا',
                                'أمريكا/الأرجنتين/لا_ريوخا',
                                'أمريكا/الأرجنتين/سان_خوان',
                                'أمريكا/الأرجنتين/مندوزا',
                                'أمريكا/الأرجنتين/ريو_غاليغوس',
                                'أمريكا/الأرجنتين/أوشوايا'],
                  'alpha-2-code': 'AR',
                  'continent': 'أمريكا الجنوبية',
                  'name': 'الأرجنتين',
                  'capital': 'بوينس آيرس'},
                 {'timezones': ['أوروبا/النمسا'],
                  'alpha-2-code': 'AT',
                  'continent': 'أوروبا',
                  'name': 'النمسا',
                  'capital': 'فيينا'},
                 {'timezones': ['أستراليا/لورد_هاو',
                                'أستراليا/هوبارت',
                                'أستراليا/كري',
                                'أستراليا/ملبورن',
                                'أستراليا/سدني',
                                'أستراليا/بروكن_هل',
                                'أستراليا/بريزبن',
                                'أستراليا/ليندمان',
                                'أستراليا/أديلايد',
                                'أستراليا/داروين',
                                'أستراليا/برث'],
                  'alpha-2-code': 'AU',
                  'continent': 'أوقيانوسيا',
                  'name': 'أستراليا',
                  'capital': 'كانبرا'},
                 {'timezones': ['آسيا/باكو'],
                  'alpha-2-code': 'AZ',
                  'continent': 'آسيا',
                  'name': 'أذربيجان',
                  'capital': 'باكو'},
                 {'timezones': ['أمريكا/باربادوس'],
                  'alpha-2-code': 'BB',
                  'continent': 'أمريكا الشمالية',
                  'name': 'باربادوس',
                  'capital': 'بريدج تاون'},
                 {'timezones': ['آسيا/دكا'],
                  'alpha-2-code': 'BD',
                  'continent': 'آسيا',
                  'name': 'بنغلادش',
                  'capital': 'دكا'},
                 {'timezones': ['أوروبا/بروكسل'],
                  'alpha-2-code': 'BE',
                  'continent': 'أوروبا',
                  'name': 'بلجيكا',
                  'capital': 'بروكسل'},
                 {'timezones': ['إفريقيا/واغادوغو'],
                  'alpha-2-code': 'BF',
                  'continent': 'إفريقيا',
                  'name': 'بوركينا فاسو',
                  'capital': 'واغادوغو'},
                 {'timezones': ['أوروبا/صوفيا'],
                  'alpha-2-code': 'BG',
                  'continent': 'أوروبا',
                  'name': 'بلغاريا',
                  'capital': 'صوفيا'},
                 {'timezones': ['آسيا/البحرين'],
                  'alpha-2-code': 'BH',
                  'continent': 'آسيا',
                  'name': 'البحرين',
                  'capital': 'المنامة'},
                 {'timezones': ['إفريقيا/بوجمبورا'],
                  'alpha-2-code': 'BI',
                  'continent': 'إفريقيا',
                  'name': 'بوروندي',
                  'capital': 'بوجمبورا'},
                 {'timezones': ['إفريقيا/بورتو نوفو'],
                  'alpha-2-code': 'BJ',
                  'continent': 'إفريقيا',
                  'name': 'بنين',
                  'capital': 'بورتو نوفو'},
                 {'timezones': ['آسيا/بروناي'],
                  'alpha-2-code': 'BN',
                  'continent': 'آسيا',
                  'name': 'اتحاد بروناي (دار السلام)',
                  'capital': 'بندر سري بكاوان'},
                 {'timezones': ['أمريكا/لاباز'],
                  'alpha-2-code': 'BO',
                  'continent': 'أمريكا الجنوبية',
                  'name': 'بوليفيا',
                  'capital': 'سوكري'},
                 {'timezones': ['أمريكا/نورونها',
                                'أمريكا/بليم',
                                'أمريكا/فورتاليزا',
                                'أمريكا/ريسيفي',
                                'أمريكا/أراغوينا',
                                'أمريكا/ماسايو',
                                'أمريكا/باهيا',
                                'أمريكا/ساو_باولو',
                                'أمريكا/كامبو_غراندي',
                                'أمريكا/كويابا',
                                'أمريكا/بورتو_فاليو',
                                'أمريكا/بوا_فيستا',
                                'أمريكا/ماناوس',
                                'أمريكا/إيرونيبي',
                                'أمريكا/ريو_برانكو'],
                  'alpha-2-code': 'BR',
                  'continent': 'أمريكا الجنوبية',
                  'name': 'البرازيل',
                  'capital': 'برازيليا'},
                 {'timezones': ['أمريكا/ناساو'],
                  'alpha-2-code': 'BS',
                  'continent': 'أمريكا الشمالية',
                  'name': 'باهاماس',
                  'capital': 'ناساو'},
                 {'timezones': ['آسيا/تيمفو'],
                  'alpha-2-code': 'BT',
                  'continent': 'آسيا',
                  'name': 'بوتان',
                  'capital': 'تيمفو'},
                 {'timezones': ['إفريقيا/غابورون'],
                  'alpha-2-code': 'BW',
                  'continent': 'إفريقيا',
                  'name': 'بوتسوانا',
                  'capital': 'غابورون'},
                 {'timezones': ['أوروبا/مينسك'],
                  'alpha-2-code': 'BY',
                  'continent': 'أوروبا',
                  'name': 'روسيا البيضاء',
                  'capital': 'مينسك'},
                 {'timezones': ['أمريكا/بليز'],
                  'alpha-2-code': 'BZ',
                  'continent': 'أمريكا الشمالية',
                  'name': 'بليز',
                  'capital': 'بلموبان'},
                 {'timezones': ['أمريكا/سينت_جونز',
                                'أمريكا/هاليفاكس',
                                'أمريكا/جليس_باي',
                                'أمريكا/مونكتون',
                                'أمريكا/جووس_باي',
                                'أمريكا/بلانك_سابلون',
                                'أمريكا/مونتريال',
                                'أمريكا/تورونتو',
                                'أمريكا/نيبيغون',
                                'أمريكا/ثاندر_باي',
                                'أمريكا/بانغيرتانغ',
                                'أمريكا/إيكواليوت',
                                'أمريكا/أتيكوكان',
                                'أمريكا/رانكن_إنلت',
                                'أمريكا/وينيبيغ',
                                'أمريكا/رايني_ريفر',
                                'أمريكا/كامبريدج_باي',
                                'أمريكا/ريجينا',
                                'أمريكا/سويفت_كارنت',
                                'أمريكا/إدمونتون',
                                'أمريكا/يلو_نايف',
                                'أمريكا/إنوفك',
                                'أمريكا/دوسن_كريك',
                                'أمريكا/فانكوفر',
                                'أمريكا/وايت_هورس',
                                'أمريكا/داوسون'],
                  'alpha-2-code': 'CA',
                  'continent': 'أمريكا الشمالية',
                  'name': 'كندا',
                  'capital': 'أوتاوا'},
                 {'timezones': ['إفريقيا/كينشاسا',
                                'إفريقيا/لوبومباشي'],
                  'alpha-2-code': 'CD',
                  'continent': 'إفريقيا',
                  'name': 'جمهورية الكونغو الديمقراطية',
                  'capital': 'كينشاسا'},
                 {'timezones': ['إفريقيا/برازافيل'],
                  'alpha-2-code': 'CG',
                  'continent': 'إفريقيا',
                  'name': 'جمهورية الكونغو',
                  'capital': 'برازافيل'},
                 {'timezones': ['إفريقيا/أبيدجان'],
                  'alpha-2-code': 'CI',
                  'continent': 'إفريقيا',
                  'name': "ساحل العاج",
                  'capital': 'ياموسوكرو'},
                 {'timezones': ['أمريكا/سانتياغو',
                                'المحيط_الهاديء/جزيرة_القيامة'],
                  'alpha-2-code': 'CL',
                  'continent': 'أمريكا الجنوبية',
                  'name': 'تشيلي',
                  'capital': 'سانتياغو'},
                 {'timezones': ['إفريقيا/دوالا'],
                  'alpha-2-code': 'CM',
                  'continent': 'إفريقيا',
                  'name': 'الكاميرون',
                  'capital': 'ياوندي'},
                 {'timezones': ['آسيا/شانغهاي',
                                'آسيا/هاربن',
                                'آسيا/تشونغتشينغ',
                                'آسيا/أورومتشي',
                                'آسيا/كاشغر'],
                  'alpha-2-code': 'CN',
                  'continent': 'آسيا',
                  'name': "جمهورية الصين الشعبية",
                  'capital': 'بكين'},
                 {'timezones': ['أمريكا/بوغوتا'],
                  'alpha-2-code': 'CO',
                  'continent': 'أمريكا الجنوبية',
                  'name': 'كولومبيا',
                  'capital': 'بوغوتا'},
                 {'timezones': ['أمريكا/كوستاريكا'],
                  'alpha-2-code': 'CR',
                  'continent': 'أمريكا الشمالية',
                  'name': 'كوستاريكا',
                  'capital': 'سان خوسيه'},
                 {'timezones': ['أمريكا/هافانا'],
                  'alpha-2-code': 'CU',
                  'continent': 'أمريكا الشمالية',
                  'name': 'كوبا',
                  'capital': 'هافانا'},
                 {'timezones': ['الأطلنطي/الرأس_الأخضر'],
                  'alpha-2-code': 'CV',
                  'continent': 'إفريقيا',
                  'name': 'جمهورية الرأس الأخضر',
                  'capital': 'برايا'},
                 {'timezones': ['آسيا/نيقوسيا'],
                  'alpha-2-code': 'CY',
                  'continent': 'آسيا',
                  'name': 'قبرص',
                  'capital': 'نيقوسيا'},
                 {'timezones': ['أوروبا/براغ'],
                  'alpha-2-code': 'CZ',
                  'continent': 'أوروبا',
                  'name': 'جمهورية التشيك',
                  'capital': 'براغ'},
                 {'timezones': ['أوروبا/برلين'],
                  'alpha-2-code': 'DE',
                  'continent': 'أوروبا',
                  'name': 'ألمانيا',
                  'capital': 'برلين'},
                 {'timezones': ['إفريقيا/جيبوتي'],
                  'alpha-2-code': 'DJ',
                  'continent': 'إفريقيا',
                  'name': 'جيبوتي',
                  'capital': 'جيبوتي'},
                 {'timezones': ['أوروبا/كوبنهاغن'],
                  'alpha-2-code': 'DK',
                  'continent': 'أوروبا',
                  'name': 'الدنمارك',
                  'capital': 'كوبنهاغن'},
                 {'timezones': ['أمريكا/دومينيكا'],
                  'alpha-2-code': 'DM',
                  'continent': 'أمريكا الشمالية',
                  'name': 'دومينيكا',
                  'capital': 'روسياو'},
                 {'timezones': ['أمريكا/سانتو_دومينغو'],
                  'alpha-2-code': 'DO',
                  'continent': 'أمريكا الشمالية',
                  'name': 'جمهورية الدومينيكان',
                  'capital': 'سانتو دومينغو'},
                 {'timezones': ['أمريكا/غواياكيل',
                                'المحيط_الهاديء/أرخبيل_غالاباغوس'],
                  'alpha-2-code': 'EC',
                  'continent': 'أمريكا الجنوبية',
                  'name': 'الإكوادور',
                  'capital': 'كيتو'},
                 {'timezones': ['أوروبا/تالين'],
                  'alpha-2-code': 'EE',
                  'continent': 'أوروبا',
                  'name': 'إستونيا',
                  'capital': 'تالين'},
                 {'timezones': ['إفريقيا/القاهرة'],
                  'alpha-2-code': 'EG',
                  'continent': 'إفريقيا',
                  'name': 'مصر',
                  'capital': 'القاهرة'},
                 {'timezones': ['إفريقيا/أسمرة'],
                  'alpha-2-code': 'ER',
                  'continent': 'إفريقيا',
                  'name': 'إرتيريا',
                  'capital': 'أسمرة'},
                 {'timezones': ['إفريقيا/أديس أبابا'],
                  'alpha-2-code': 'ET',
                  'continent': 'إفريقيا',
                  'name': 'إثيوبيا',
                  'capital': 'أديس أبابا'},
                 {'timezones': ['أوروبا/هلسنكي'],
                  'alpha-2-code': 'FI',
                  'continent': 'أوروبا',
                  'name': 'فنلندا',
                  'capital': 'هلسنكي'},
                 {'timezones': ['المحيط_الهاديء/فيجي'],
                  'alpha-2-code': 'FJ',
                  'continent': 'أوقيانوسيا',
                  'name': 'فيجي',
                  'capital': 'سوفا'},
                 {'timezones': ['أوروبا/باريس'],
                  'alpha-2-code': 'FR',
                  'continent': 'أوروبا',
                  'name': 'فرنسا',
                  'capital': 'باريس'},
                 {'timezones': ['إفريقيا/ليبرفيل'],
                  'alpha-2-code': 'GA',
                  'continent': 'إفريقيا',
                  'name': 'الغابون',
                  'capital': 'ليبرفيل'},
                 {'timezones': ['آسيا/تبليسي'],
                  'alpha-2-code': 'GE',
                  'continent': 'آسيا',
                  'name': 'جورجيا',
                  'capital': 'تبليسي'},
                 {'timezones': ['إفريقيا/أكرا'],
                  'alpha-2-code': 'GH',
                  'continent': 'إفريقيا',
                  'name': 'غانا',
                  'capital': 'أكرا'},
                 {'timezones': ['إفريقيا/بانجول'],
                  'alpha-2-code': 'GM',
                  'continent': 'إفريقيا',
                  'name': 'غامبيا',
                  'capital': 'بانجول'},
                 {'timezones': ['إفريقيا/كوناكري'],
                  'alpha-2-code': 'GN',
                  'continent': 'إفريقيا',
                  'name': 'غينيا',
                  'capital': 'كوناكري'},
                 {'timezones': ['أوروبا/أثينا'],
                  'alpha-2-code': 'GR',
                  'continent': 'أوروبا',
                  'name': 'اليونان',
                  'capital': 'أثينا'},
                 {'timezones': ['أمريكا/غواتيمالا'],
                  'alpha-2-code': 'GT',
                  'continent': 'أمريكا الشمالية',
                  'name': 'غواتيمالا',
                  'capital': 'غواتيمالا سيتي'},
                 {'timezones': ['أمريكا/غواتيمالا'],
                  'alpha-2-code': 'GT',
                  'continent': 'أمريكا الشمالية',
                  'name': 'هايتي',
                  'capital': 'بورت أو برانس'},
                 {'timezones': ['إفريقيا/بيساو'],
                  'alpha-2-code': 'GW',
                  'continent': 'إفريقيا',
                  'name': 'غينيا بيساو',
                  'capital': 'بيساو'},
                 {'timezones': ['أمريكا/غيانا'],
                  'alpha-2-code': 'GY',
                  'continent': 'أمريكا الجنوبية',
                  'name': 'غيانا',
                  'capital': 'جورج تاون'},
                 {'timezones': ['أمريكا/تيجوسيجالبا'],
                  'alpha-2-code': 'HN',
                  'continent': 'أمريكا الشمالية',
                  'name': 'هندوراس',
                  'capital': 'تيجوسيجالبا'},
                 {'timezones': ['أوروبا/بودابست'],
                  'alpha-2-code': 'HU',
                  'continent': 'أوروبا',
                  'name': 'هنغاريا',
                  'capital': 'بودابست'},
                 {'timezones': ['آسيا/جاكرتا',
                                'آسيا/بونتياناك',
                                'آسيا/ماكاسار',
                                'آسيا/جايابورا'],
                  'alpha-2-code': 'ID',
                  'continent': 'آسيا',
                  'name': 'إندونسيا',
                  'capital': 'جاكرتا'},
                 {'timezones': ['أوروبا/دبلن'],
                  'alpha-2-code': 'IE',
                  'continent': 'أوروبا',
                  'name': 'إيرلندا',
                  'capital': 'دبلن'},
                 {'timezones': ['آسيا/القدس'],
                  'alpha-2-code': 'IL',
                  'continent': 'آسيا',
                  'name': 'فلسطين',
                  'capital': 'القدس'},
                 {'timezones': ['آسيا/كالكتا'],
                  'alpha-2-code': 'IN',
                  'continent': 'آسيا',
                  'name': 'الهند',
                  'capital': 'نيو دلهي'},
                 {'timezones': ['آسيا/بغداد'],
                  'alpha-2-code': 'IQ',
                  'continent': 'آسيا',
                  'name': 'العراق',
                  'capital': 'بغداد'},
                 {'timezones': ['آسيا/طهران'],
                  'alpha-2-code': 'IR',
                  'continent': 'آسيا',
                  'name': 'إيران',
                  'capital': 'طهران'},
                 {'timezones': ['الأطلنطي/ريكيافيك'],
                  'alpha-2-code': 'IS',
                  'continent': 'أوروبا',
                  'name': 'آيسلندا',
                  'capital': 'ريكيافيك'},
                 {'timezones': ['أوروبا/روما'],
                  'alpha-2-code': 'IT',
                  'continent': 'أوروبا',
                  'name': 'إيطاليا',
                  'capital': 'روما'},
                 {'timezones': ['أمريكا/جامايكا'],
                  'alpha-2-code': 'JM',
                  'continent': 'أمريكا الشمالية',
                  'name': 'جامايكا',
                  'capital': 'كينغستون'},
                 {'timezones': ['آسيا/عمّان'],
                  'alpha-2-code': 'JO',
                  'continent': 'آسيا',
                  'name': 'الأردن',
                  'capital': 'عمّان'},
                 {'timezones': ['آسيا/طوكيو'],
                  'alpha-2-code': 'JP',
                  'continent': 'آسيا',
                  'name': 'اليابان',
                  'capital': 'طوكيو'},
                 {'timezones': ['إفريقيا/نيروبي'],
                  'alpha-2-code': 'KE',
                  'continent': 'إفريقيا',
                  'name': 'كينيا',
                  'capital': 'نيروبي'},
                 {'timezones': ['آسيا/بشكيك'],
                  'alpha-2-code': 'KG',
                  'continent': 'آسيا',
                  'name': 'قيرغيزستان',
                  'capital': 'بشكيك'},
                 {'timezones': ['المحيط_الهاديء/تاراوا',
                                'المحيط_الهاديء/إيديربيري',
                                'المحيط_الهاديء/كريتيماتي'],
                  'alpha-2-code': 'KI',
                  'continent': 'أوقيانوسيا',
                  'name': 'كيريباتي',
                  'capital': 'جنوب تاراوا'},
                 {'timezones': ['آسيا/بيونغ_يانغ'],
                  'alpha-2-code': 'KP',
                  'continent': 'آسيا',
                  'name': 'كوريا الشمالية',
                  'capital': 'بيونغ يانغ'},
                 {'timezones': ['آسيا/سيؤول'],
                  'alpha-2-code': 'KR',
                  'continent': 'آسيا',
                  'name': '؛كوريا الجنوبية',
                  'capital': 'سيؤول'},
                 {'timezones': ['آسيا/الكويت'],
                  'alpha-2-code': 'KW',
                  'continent': 'آسيا',
                  'name': 'الكويت',
                  'capital': 'الكويت'},
                 {'timezones': ['آسيا/بيروت'],
                  'alpha-2-code': 'LB',
                  'continent': 'آسيا',
                  'name': 'لبنان',
                  'capital': 'بيروت'},
                 {'timezones': ['أوروبا/فادوز'],
                  'alpha-2-code': 'LI',
                  'continent': 'أوروبا',
                  'name': 'ليختنشتاين',
                  'capital': 'فادوز'},
                 {'timezones': ['إفريقيا/مونروفيا'],
                  'alpha-2-code': 'LR',
                  'continent': 'إفريقيا',
                  'name': 'ليبيريا',
                  'capital': 'مونروفيا'},
                 {'timezones': ['إفريقيا/ماسيرو'],
                  'alpha-2-code': 'LS',
                  'continent': 'إفريقيا',
                  'name': 'ليسوتو',
                  'capital': 'ماسيرو'},
                 {'timezones': ['أوروبا/فيلنيوس'],
                  'alpha-2-code': 'LT',
                  'continent': 'أوروبا',
                  'name': 'ليتوانيا',
                  'capital': 'فيلنيوس'},
                 {'timezones': ['أوروبا/لوكسمبرغ'],
                  'alpha-2-code': 'LU',
                  'continent': 'أوروبا',
                  'name': 'لوكسمبرغ',
                  'capital': 'لوكسمبرغ سيتي'},
                 {'timezones': ['أوروبا/ربيغ'],
                  'alpha-2-code': 'LV',
                  'continent': 'أوروبا',
                  'name': 'لاتفيا',
                  'capital': 'ربيغ'},
                 {'timezones': ['إفريقيا/طرابلس'],
                  'alpha-2-code': 'LY',
                  'continent': 'إفريقيا',
                  'name': 'ليبيا',
                  'capital': 'طرابلس'},
                 {'timezones': ['الهندي/أنتاناناريفو'],
                  'alpha-2-code': 'MG',
                  'continent': 'إفريقيا',
                  'name': 'مدغشقر',
                  'capital': 'أنتاناناريفو'},
                 {'timezones': ['المحيط_الهاديء/ماجورو',
                                'المحيط_الهاديء/كواجلين_أتول'],
                  'alpha-2-code': 'MH',
                  'continent': 'أوقيانوسيا',
                  'name': 'جزر مارشال',
                  'capital': 'ماجورو'},
                 {'timezones': ['أوروبا/سكوبيه'],
                  'alpha-2-code': 'MK',
                  'continent': 'أوروبا',
                  'name': 'جمهورية مقدونيا',
                  'capital': 'سكوبيه'},
                 {'timezones': ['إفريقيا/باماكو'],
                  'alpha-2-code': 'ML',
                  'continent': 'إفريقيا',
                  'name': 'مالي',
                  'capital': 'باماكو'},
                 {'timezones': ['آسيا/رانغون'],
                  'alpha-2-code': 'MM',
                  'continent': 'آسيا',
                  'name': 'ميانمار',
                  'capital': 'نايبيداو'},
                 {'timezones': ['آسيا/أولان_باتور',
                                'آسيا/Hovd',
                                'آسيا/تشويبالسان'],
                  'alpha-2-code': 'MN',
                  'continent': 'آسيا',
                  'name': 'مانغوليا',
                  'capital': 'أولان باتور'},
                 {'timezones': ['إفريقيا/نواكشط'],
                  'alpha-2-code': 'MR',
                  'continent': 'إفريقيا',
                  'name': 'موريتانيا',
                  'capital': 'نواكشط'},
                 {'timezones': ['أوروبا/مالطا'],
                  'alpha-2-code': 'MT',
                  'continent': 'أوروبا',
                  'name': 'مالطا',
                  'capital': 'فاليتا'},
                 {'timezones': ['الهندي/موريشيوس'],
                  'alpha-2-code': 'MU',
                  'continent': 'إفريقيا',
                  'name': 'موريشيوس',
                  'capital': 'بور لويس'},
                 {'timezones': ['الهندي/جزر_المالديف'],
                  'alpha-2-code': 'MV',
                  'continent': 'آسيا',
                  'name': 'جمهورية المالديف',
                  'capital': 'ماليه'},
                 {'timezones': ['إفريقيا/بلانتاير'],
                  'alpha-2-code': 'MW',
                  'continent': 'إفريقيا',
                  'name': 'ملاوي',
                  'capital': 'ليلونغوي'},
                 {'timezones': ['أمريكا/ميكسيكو_سيتي',
                                'أمريكا/كانكون',
                                'أمريكا/ميرديا',
                                'أمريكا/مونتيري',
                                'أمريكا/مازاتلان',
                                'أمريكا/شيواوا',
                                'أمريكا/ارموسييو_سونورا',
                                'أمريكا/تيخوانا'],
                  'alpha-2-code': 'MX',
                  'continent': 'أمريكا الشمالية',
                  'name': 'المكسيك',
                  'capital': 'ميكسيكو سيتي§'},
                 {'timezones': ['آسيا/كوالا_لامبور',
                                'آسيا/Kuching'],
                  'alpha-2-code': 'MY',
                  'continent': 'آسيا',
                  'name': 'ماليزيا',
                  'capital': 'كوالا لامبور'},
                 {'timezones': ['إفريقيا/مابوتو'],
                  'alpha-2-code': 'MZ',
                  'continent': 'إفريقيا',
                  'name': 'موزمبيق',
                  'capital': 'مابوتو'},
                 {'timezones': ['إفريقيا/ويندهوك'],
                  'alpha-2-code': 'NA',
                  'continent': 'إفريقيا',
                  'name': 'ناميبيا',
                  'capital': 'ويندهوك'},
                 {'timezones': ['إفريقيا/نيامي'],
                  'alpha-2-code': 'NE',
                  'continent': 'إفريقيا',
                  'name': 'النيجر',
                  'capital': 'نيامي'},
                 {'timezones': ['إفريقيا/لاغوس'],
                  'alpha-2-code': 'NG',
                  'continent': 'إفريقيا',
                  'name': 'نيجيريا',
                  'capital': 'أبوجا'},
                 {'timezones': ['أمريكا/ماناغوا'],
                  'alpha-2-code': 'NI',
                  'continent': 'أمريكا الشمالية',
                  'name': 'نيكاراغوا',
                  'capital': 'ماناغوا'},
                 {'timezones': ['أوروبا/أمستردام'],
                  'alpha-2-code': 'NL',
                  'continent': 'أوروبا',
                  'name': 'هولندا',
                  'capital': 'أمستردام'},
                 {'timezones': ['أوروبا/أوسلو'],
                  'alpha-2-code': 'NO',
                  'continent': 'أوروبا',
                  'name': 'النرويج',
                  'capital': 'أوسلو'},
                 {'timezones': ['آسيا/كاتماندو'],
                  'alpha-2-code': 'NP',
                  'continent': 'آسيا',
                  'name': 'النيبال',
                  'capital': 'كاتماندو'},
                 {'timezones': ['المحيط_الهاديء/ناورو'],
                  'alpha-2-code': 'NR',
                  'continent': 'أوقيانوسيا',
                  'name': 'ناورو',
                  'capital': 'يارين'},
                 {'timezones': ['المحيط_الهاديء/أوكلاند',
                                'المحيط_الهاديء/تشاتهام'],
                  'alpha-2-code': 'NZ',
                  'continent': 'أوقيانوسيا',
                  'name': 'نيوزيلاندا',
                  'capital': 'ويلينغتون'},
                 {'timezones': ['آسيا/مسقط'],
                  'alpha-2-code': 'OM',
                  'continent': 'آسيا',
                  'name': 'عمان',
                  'capital': 'مسقط'},
                 {'timezones': ['أمريكا/بنما'],
                  'alpha-2-code': 'PA',
                  'continent': 'أمريكا الشمالية',
                  'name': 'بنما',
                  'capital': 'بنما'},
                 {'timezones': ['أمريكا/ليما'],
                  'alpha-2-code': 'PE',
                  'continent': 'أمريكا الجنوبية',
                  'name': 'البيرو',
                  'capital': 'ليما'},
                 {'timezones': ['المحيط_الهاديء/بورت_مورسبي'],
                  'alpha-2-code': 'PG',
                  'continent': 'أوقيانوسيا',
                  'name': 'بابوا غينيا الجديدة',
                  'capital': 'بورت مورسبي'},
                 {'timezones': ['آسيا/مانيلا'],
                  'alpha-2-code': 'PH',
                  'continent': 'آسيا',
                  'name': 'الفيليبين',
                  'capital': 'مانيلا'},
                 {'timezones': ['آسيا/كاراتشي'],
                  'alpha-2-code': 'PK',
                  'continent': 'آسيا',
                  'name': 'باكستان',
                  'capital': 'إسلام أباد'},
                 {'timezones': ['أوروبا/وارسو'],
                  'alpha-2-code': 'PL',
                  'continent': 'أوروبا',
                  'name': 'بولندا',
                  'capital': 'وارسو'},
                 {'timezones': ['أوروبا/لشبونة',
                                'الأطلنطي/ماديرا',
                                'الأطلنطي/الأزور'],
                  'alpha-2-code': 'PT',
                  'continent': 'أوروبا',
                  'name': 'البرتغال',
                  'capital': 'لشبونة'},
                 {'timezones': ['المحيط_الهاديء/بالاو'],
                  'alpha-2-code': 'PW',
                  'continent': 'أوقيانوسيا',
                  'name': 'بالاو',
                  'capital': 'نجيرولمد'},
                 {'timezones': ['أمريكا/أسونسيون'],
                  'alpha-2-code': 'PY',
                  'continent': 'أمريكا الجنوبية',
                  'name': 'بابرغوي',
                  'capital': 'أسونسيون'},
                 {'timezones': ['آسيا/قطر'],
                  'alpha-2-code': 'QA',
                  'continent': 'آسيا',
                  'name': 'قطر',
                  'capital': 'الدوحة'},
                 {'timezones': ['أوروبا/بوخارست'],
                  'alpha-2-code': 'RO',
                  'continent': 'أوروبا',
                  'name': 'رومانيا',
                  'capital': 'بوخارست'},
                 {'timezones': ['أوروبا/كالينينغراد',
                                'أوروبا/موسكو',
                                'أوروبا/Volgograd',
                                'أوروبا/سمارة',
                                'آسيا/يكاترينبورغ',
                                'آسيا/أومسك',
                                'آسيا/نوفوسيبيرسك',
                                'آسيا/كراسنوياسك',
                                'آسيا/إروتسك',
                                'آسيا/ياكوتسك',
                                'آسيا/فالديفوستوك',
                                'آسيا/ساخالن',
                                'آسيا/ماغادان',
                                'آسيا/كامشتكا',
                                'آسيا/أنادير'],
                  'alpha-2-code': 'RU',
                  'continent': 'أوروبا',
                  'name': 'روسيا',
                  'capital': 'موسكو'},
                 {'timezones': ['إفريقيا/كيغالي'],
                  'alpha-2-code': 'RW',
                  'continent': 'إفريقيا',
                  'name': 'رواندا',
                  'capital': 'كيغالي'},
                 {'timezones': ['آسيا/الرياض'],
                  'alpha-2-code': 'SA',
                  'continent': 'آسيا',
                  'name': 'المملكة العربية السعودية',
                  'capital': 'الرياض'},
                 {'timezones': ['المحيط_الهاديء/غوادالكانال'],
                  'alpha-2-code': 'SB',
                  'continent': 'أوقيانوسيا',
                  'name': 'جزر سولمون',
                  'capital': 'هونيارا'},
                 {'timezones': ['الهندي/ماهي'],
                  'alpha-2-code': 'SC',
                  'continent': 'إفريقيا',
                  'name': 'سيشل',
                  'capital': 'فيكتوريا'},
                 {'timezones': ['إفريقيا/الخرطوم'],
                  'alpha-2-code': 'SD',
                  'continent': 'إفريقيا',
                  'name': 'السودان',
                  'capital': 'الخرطوم'},
                 {'timezones': ['أوروبا/ستوكهولم'],
                  'alpha-2-code': 'SE',
                  'continent':'أوروبا',
                  'name': 'السويد',
                  'capital': 'ستوكهولم'},
                 {'timezones': ['آسيا/سنغافورة'],
                  'alpha-2-code': 'SG',
                  'continent': 'آسيا',
                  'name': 'سنغافورة',
                  'capital': 'سنغافورة'},
                 {'timezones': ['أوروبا/ليوبليانا'],
                  'alpha-2-code': 'SI',
                  'continent': 'أوروبا',
                  'name': 'سلوفانيا',
                  'capital': 'ليوبليانا'},
                 {'timezones': ['أوروبا/براتيسلافا'],
                  'alpha-2-code': 'SK',
                  'continent': 'أوروبا',
                  'name': 'سلوفاكيا',
                  'capital': 'براتيسلافا'},
                 {'timezones': ['إفريقيا/فريتاون'],
                  'alpha-2-code': 'SL',
                  'continent': 'إفريقيا',
                  'name': 'سيراليون',
                  'capital': 'فريتاون'},
                 {'timezones': ['أوروبا/سان_مارينو'],
                  'alpha-2-code': 'SM',
                  'continent': 'أوروبا',
                  'name': 'جمهورية سان مارينو',
                  'capital': 'سان مارينو'},
                 {'timezones': ['إفريقيا/داكار'],
                  'alpha-2-code': 'SN',
                  'continent': 'إفريقيا',
                  'name': 'السنغال',
                  'capital': 'داكار'},
                 {'timezones': ['إفريقيا/مقديشو'],
                  'alpha-2-code': 'SO',
                  'continent': 'إفريقيا',
                  'name': 'الصومال',
                  'capital': 'مقديشو'},
                 {'timezones': ['أمريكا/باراماريبو'],
                  'alpha-2-code': 'SR',
                  'continent': 'أمريكا الجنوبية',
                  'name': 'Suriname',
                  'capital': 'باراماريبو'},
                 {'timezones': ['إفريقيا/ساو_تومي'],
                  'alpha-2-code': 'ST',
                  'continent': 'إفريقيا',
                  'name': ' ساو تومي وبرينسيب',
                  'capital': 'ساو تومي'},
                 {'timezones': ['آسيا/دممشق'],
                  'alpha-2-code': 'SY',
                  'continent': 'آسيا',
                  'name': 'سوريا',
                  'capital': 'دمشق'},
                 {'timezones': ['إفريقيا/لومي'],
                  'alpha-2-code': 'TG',
                  'continent': 'إفريقيا',
                  'name': 'توغو',
                  'capital': 'لومي'},
                 {'timezones': ['آسيا/بانغوك'],
                  'alpha-2-code': 'TH',
                  'continent': 'آسيا',
                  'name': 'تايلند',
                  'capital': 'بناغوك'},
                 {'timezones': ['آسيا/دوشنبه'],
                  'alpha-2-code': 'TJ',
                  'continent': 'آسيا',
                  'name': 'طاجكيستان',
                  'capital': 'دوشنبه'},
                 {'timezones': ['آسيا/عشق_آباد'],
                  'alpha-2-code': 'TM',
                  'continent': 'آسيا',
                  'name': 'تركمانستان',
                  'capital': 'عشق آباد'},
                 {'timezones': ['إفريقيا/تونس'],
                  'alpha-2-code': 'TN',
                  'continent': 'إفريقيا',
                  'name': 'تونس',
                  'capital': 'تونس'},
                 {'timezones': ['المحيط_الهاديء/تونغاتابو'],
                  'alpha-2-code': 'TO',
                  'continent': 'أوقيانوسيا',
                  'name': 'تونغا',
                  'capital': 'نوكو ألوفا'},
                 {'timezones': ['أوروبا/إسطنبول'],
                  'alpha-2-code': 'TR',
                  'continent': 'آسيا',
                  'name': 'تركيا',
                  'capital': 'أنقرة'},
                 {'timezones': ['أمريكا/بورت_أوف_سبين'],
                  'alpha-2-code': 'TT',
                  'continent': 'أمريكا الشمالية',
                  'name': 'ترينيداد وتوباغو',
                  'capital': 'بورت أوف سبين'},
                 {'timezones': ['المحيط_الهاديء/فونافوتي'],
                  'alpha-2-code': 'TV',
                  'continent': 'أوقيانوسيا',
                  'name': 'توفالو',
                  'capital': 'فونافوتي'},
                 {'timezones': ['إفريقيا/دار_السلام'],
                  'alpha-2-code': 'TZ',
                  'continent': 'إفريقيا',
                  'name': 'تانزانيا',
                  'capital': 'دودوما'},
                 {'timezones': ['أوروبا/كييف',
                                'أوروبا/أوجهورود',
                                'أوروبا/زاباروجيا',
                                'أوروبا/سيمفروبول'],
                  'alpha-2-code': 'UA',
                  'continent': 'أوروبا',
                  'name': 'أوكرانيا',
                  'capital': 'كييف'},
                 {'timezones': ['إفريقيا/كامبالا'],
                  'alpha-2-code': 'UG',
                  'continent': 'إفريقيا',
                  'name': 'أوغندا',
                  'capital': 'كامبالا'},
                 {'timezones': ['أمريكا/نيويورك',
                                'أمريكا/ديترويت',
                                'أمريكا/كنتاكي/لويسفيل',
                                'أمريكا/كنتاكي/مونتيسللو',
                                'أمريكا/إنديانا/إنديانابولس',
                                'أمريكا/إنديانا/مارنغو',
                                'أمريكا/إنديانا/نوكس',
                                'أمريكا/إنديانا/فيفاي',
                                'أمريكا/شيكاغو',
                                'أمريكا/إنديانا/فانسان',
                                'أمريكا/إنديانا/بيترزبيرغ',
                                'أمريكا/مينومني',
                                'أمريكا/نورث_داكوتا/سينتر',
                                'أمريكا/نورث_داكوتا/نيو_سالم',
                                'أمريكا/دنفر',
                                'أمريكا/بويسي',
                                'أمريكا/شيبروك',
                                'أمريكا/فينيكس',
                                'أمريكا/لوس_أنجيلوس',
                                'أمريكا/أنكوريج',
                                'أمريكا/جونو',
                                'أمريكا/ياكوتات',
                                'أمريكا/نوم',
                                'أمريكا/أداك',
                                'المحيط_الهاديء/هونولولو'],
                  'alpha-2-code': 'US',
                  'continent': 'أمريكا الشمالية',
                  'name': 'الولايات المتحدة الأمريكية',
                  'capital': 'واشنطن'},
                 {'timezones': ['أمريكا/مونتفيدو'],
                  'alpha-2-code': 'UY',
                  'continent': 'أمريكا الجنوبية',
                  'name': 'أوروغواي',
                  'capital': 'مونتفيدو'},
                 {'timezones': ['آسيا/سمرقند',
                                'آسيا/طشقند'],
                  'alpha-2-code': 'UZ',
                  'continent': 'آسيا',
                  'name': 'أوزبكستان',
                  'capital': 'طشقند'},
                 {'timezones': ['أوروبا/الفاتيكان'],
                  'alpha-2-code': 'VA',
                  'continent': 'أوروبا',
                  'name': 'الفاتيكان',
                  'capital': 'الفاتيكان'},
                 {'timezones': ['أمريكا/كاركاس'],
                  'alpha-2-code': 'VE',
                  'continent': 'أمريكا الجنوبية',
                  'name': 'فنزويلا',
                  'capital': 'كاركاس'},
                 {'timezones': ['آسيا/سايغون'],
                  'alpha-2-code': 'VN',
                  'continent': 'آسيا',
                  'name': 'فيتنام',
                  'capital': 'هانوي'},
                 {'timezones': ['المحيط_الهاديء/أيفاتي'],
                  'alpha-2-code': 'VU',
                  'continent': 'أوقيانوسيا',
                  'name': 'فانواتو',
                  'capital': 'بورت فيلا'},
                 {'timezones': ['آسيا/عدن'],
                  'alpha-2-code': 'YE',
                  'continent': 'آسيا',
                  'name': 'اليمن',
                  'capital': "صنعاء"},
                 {'timezones': ['إفريقيا/لوساكا'],
                  'alpha-2-code': 'ZM',
                  'continent': 'إفريقيا',
                  'name': 'زامبيا',
                  'capital': 'لوساكا'},
                 {'timezones': ['إفريقيا/هراري'],
                  'alpha-2-code': 'ZW',
                  'continent': 'إفريقيا',
                  'name': 'زيمبابوي',
                  'capital': 'هراري'},
                 {'timezones': ['إفريقيا/الجزائر'],
                  'alpha-2-code': 'DZ',
                  'continent': 'إفريقيا',
                  'name': 'الجزائر',
                  'capital': 'الجزائر'},
                 {'timezones': ['أوروبا/سراييفو'],
                  'alpha-2-code': 'BA',
                  'continent': 'أوروبا',
                  'name': 'البوسنة والهرسك',
                  'capital': 'سراييفو'},
                 {'timezones': ['آسيا/بنوم_بنه'],
                  'alpha-2-code': 'KH',
                  'continent': 'آسيا',
                  'name': 'كمبوديا',
                  'capital': 'بنوم بنه'},
                 {'timezones': ['إفريقيا/بانغي'],
                  'alpha-2-code': 'CF',
                  'continent': 'إفريقيا',
                  'name': 'جمهورية أفريقيا الوسطى',
                  'capital': 'بانغي'},
                 {'timezones': ['إفريقيا/نجامينا'],
                  'alpha-2-code': 'TD',
                  'continent': 'إفريقيا',
                  'name': 'تشاد',
                  'capital': "نجامينا"},
                 {'timezones': ['الهندي/كومورو'],
                  'alpha-2-code': 'KM',
                  'continent': 'إفريقيا',
                  'name': 'جزر القمر',
                  'capital': 'موروني'},
                 {'timezones': ['أوروبا/زغرب'],
                  'alpha-2-code': 'HR',
                  'continent': 'أوروبا',
                  'name': 'كرواتيا',
                  'capital': 'زغرب'},
                 {'timezones': ['آسيا/ديلي'],
                  'alpha-2-code': 'TL',
                  'continent': 'آسيا',
                  'name': 'تيمور الشرقية',
                  'capital': 'ديلي'},
                 {'timezones': ['أمريكا/السلفادور'],
                  'alpha-2-code': 'SV',
                  'continent': 'أمريكا الشمالية',
                  'name': 'السلفادور',
                  'capital': 'سان سلفادور'},
                 {'timezones': ['إفريقيا/مالابو'],
                  'alpha-2-code': 'GQ',
                  'continent': 'إفريقيا',
                  'name': 'غينيا الاستوائية',
                  'capital': 'مالابو'},
                 {'timezones': ['أمريكا/غرينادا'],
                  'alpha-2-code': 'GD',
                  'continent': 'أمريكا الشمالية',
                  'name': 'غرينادا',
                  'capital': "سانت جورجز"},
                 {'timezones': ['آسيا/ألماتي',
                                'آسيا/كيزيلوردا',
                                'آسيا/أقتوبي',
                                'آسيا/أقتاو',
                                'آسيا/أورال'],
                  'alpha-2-code': 'KZ',
                  'continent': 'آسيا',
                  'name': 'كازاخستان',
                  'capital': 'أستانة'},
                 {'timezones': ['آسيا/فيينتيان'],
                  'alpha-2-code': 'LA',
                  'continent': 'آسيا',
                  'name': 'لاوس',
                  'capital': 'فيينتيان'},
                 {'timezones': ['المحيط_الهاديء/تشوك',
                                'المحيط_الهاديء/بونابي',
                                'المحيط_الهاديء/كورساي'],
                  'alpha-2-code': 'FM',
                  'continent': 'أوقيانوسيا',
                  'name': 'ولايات ميكرونيسيا المتحدة',
                  'capital': 'باليكير'},
                 {'timezones': ['أوروبا/كيشيناو'],
                  'alpha-2-code': 'MD',
                  'continent': 'أوروبا',
                  'name': 'مولدافيا',
                  'capital': 'كيشيناو'},
                 {'timezones': ['أوروبا/موناكو'],
                  'alpha-2-code': 'MC',
                  'continent': 'أوروبا',
                  'name': 'موناكو',
                  'capital': 'موناكو'},
                 {'timezones': ['أوروبا/بودغوريتسا'],
                  'alpha-2-code': 'ME',
                  'continent': 'أوروبا',
                  'name': 'الجبل الأسود',
                  'capital': 'بودغوريتسا'},
                 {'timezones': ['إفريقيا/الدار_البيضاء'],
                  'alpha-2-code': 'MA',
                  'continent': 'إفريقيا',
                  'name': 'المغرب',
                  'capital': 'الرباط'},
                 {'timezones': ['أمريكا/سانت_كيتس'],
                  'alpha-2-code': 'KN',
                  'continent': 'أمريكا الشمالية',
                  'name': 'سانت كيتس ونيفيس',
                  'capital': 'باستير'},
                 {'timezones': ['أمريكا/سانت_لوسيا'],
                  'alpha-2-code': 'LC',
                  'continent': 'أمريكا الشمالية',
                  'name': 'سانت لوسيا',
                  'capital': 'كاستريس'},
                 {'timezones': ['أمريكا/سينت_فينسينت'],
                  'alpha-2-code': 'VC',
                  'continent': 'أمريكا الشمالية',
                  'name': 'سانت فينسنت والغرينادين',
                  'capital': 'كينغستاون'},
                 {'timezones': ['المحيط_الهاديء/أبيا'],
                  'alpha-2-code': 'WS',
                  'continent': 'أوقيانوسيا',
                  'name': 'ساموا',
                  'capital': 'أبيا'},
                 {'timezones': ['أوروبا/بلغراد'],
                  'alpha-2-code': 'RS',
                  'continent': 'أوروبا',
                  'name': 'صربيا',
                  'capital': 'بلغراد'},
                 {'timezones': ['إفريقيا/جوهانسبرغ'],
                  'alpha-2-code': 'ZA',
                  'continent': 'إفريقيا',
                  'name': 'جنوب إفريقيا',
                  'capital': 'بريتوريا'},
                 {'timezones': ['أوروبا/مدريد',
                                'إفريقيا/سبتة',
                                'الأطلنطي/الكناري'],
                  'alpha-2-code': 'ES',
                  'continent': 'أوروبا',
                  'name': 'إسبانيا',
                  'capital': 'مدريد'},
                 {'timezones': ['آسيا/كولمبو'],
                  'alpha-2-code': 'LK',
                  'continent': 'آسيا',
                  'name': 'سريلانكا',
                  'capital': 'سري جاياواردنابورا كوتي'},
                 {'timezones': ['إفريقيا/مبابان'],
                  'alpha-2-code': 'SZ',
                  'continent': 'إفريقيا',
                  'name': 'سوازيلاند',
                  'capital': 'مبابان'},
                 {'timezones': ['أوروبا/زيورخ'],
                  'alpha-2-code': 'CH',
                  'continent': 'أوروبا',
                  'name': 'سويسرا',
                  'capital': 'برن'},
                 {'timezones': ['آسيا/دبي'],
                  'alpha-2-code': 'AE',
                  'continent': 'آسيا',
                  'name': 'الإمارات العربية المتحدة',
                  'capital': 'أبو ظبي'},
                 {'timezones': ['أوروبا/لندن'],
                  'alpha-2-code': 'GB',
                  'continent': 'أوروبا',
                  'name': 'المملكة المتحدة',
                  'capital': 'لندن'},
                 ]

    AM_PM = {
        'AM': 'ص',
        'PM': 'م',
    }

    def month_name(self) -> str:
        month = self.date('%m')
        return self.MONTH_NAMES[month]

    def am_pm(self) -> str:
        date = self.date('%p')
        return self.AM_PM[date]

    def day_of_week(self) -> str:
        day = self.date('%w')
        return self.DAY_NAMES[day]
