<TeXmacs|1.99.5>

<style|<tuple|tmdoc|framed-session|american>>

<\body>
  <doc-data|<doc-title|The Pure <TeXmacs>
  Plugin>|<doc-author|<author-data|<author-name|Albert
  Grf>|<author-email|dr.graef@t-online.de>|<author-homepage|http://pure-lang.googlecode.com/>>>|<doc-date|<date>>>

  <\table-of-contents|toc>
    <vspace*|1fn><with|font-series|bold|math-font-series|bold|1.<space|2spc>About
    Pure> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
    <no-break><pageref|auto-1><vspace|0.5fn>

    <vspace*|1fn><with|font-series|bold|math-font-series|bold|2.<space|2spc>Pure
    Sessions> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
    <no-break><pageref|auto-2><vspace|0.5fn>

    <vspace*|1fn><with|font-series|bold|math-font-series|bold|3.<space|2spc>Completion
    and Help> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
    <no-break><pageref|auto-3><vspace|0.5fn>

    <vspace*|1fn><with|font-series|bold|math-font-series|bold|4.<space|2spc>Pure
    and Reduce> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
    <no-break><pageref|auto-4><vspace|0.5fn>

    <vspace*|1fn><with|font-series|bold|math-font-series|bold|5.<space|2spc>Mathematical
    Input and Output> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
    <no-break><pageref|auto-5><vspace|0.5fn>

    <with|par-left|1.5fn|5.1.<space|2spc>Basic expressions
    <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
    <no-break><pageref|auto-6>>

    <with|par-left|1.5fn|5.2.<space|2spc>Trees
    <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
    <no-break><pageref|auto-7>>

    <with|par-left|1.5fn|5.3.<space|2spc>Lists
    <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
    <no-break><pageref|auto-8>>

    <with|par-left|1.5fn|5.4.<space|2spc>Big operators (integrals, limits,
    sums, etc.) <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
    <no-break><pageref|auto-9>>

    <with|par-left|1.5fn|5.5.<space|2spc>Differentials and integrals
    <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
    <no-break><pageref|auto-10>>

    <with|par-left|1.5fn|5.6.<space|2spc>Programming
    <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
    <no-break><pageref|auto-11>>

    <with|par-left|1.5fn|5.7.<space|2spc>Caveats
    <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
    <no-break><pageref|auto-12>>

    <vspace*|1fn><with|font-series|bold|math-font-series|bold|6.<space|2spc>Pure
    and Octave> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
    <no-break><pageref|auto-13><vspace|0.5fn>

    <vspace*|1fn><with|font-series|bold|math-font-series|bold|7.<space|2spc>PostScript
    Output> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
    <no-break><pageref|auto-14><vspace|0.5fn>

    <vspace*|1fn><with|font-series|bold|math-font-series|bold|8.<space|2spc>Pure
    Scripting> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
    <no-break><pageref|auto-15><vspace|0.5fn>
  </table-of-contents>

  <include|pure-abstract.en.tm>

  <section|Pure Sessions>

  You can insert a Pure session as usual with <samp|Insert \| Session \|
  Pure>.

  <\session|pure|default>
    <\output>
      \;

      \ __ \\ \ \| \ \ \| \ __\| _ \\ \ \ \ Pure 0.56
      (x86_64-unknown-linux-gnu)

      \ \| \ \ \| \| \ \ \| \| \ \ \ __/ \ \ \ Copyright (c) 2008-2012 by
      Albert Graef

      \ .__/ \\__,_\|_\| \ \\___\| \ \ \ (Type 'help' for help, 'help
      copying'

      _\| \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ for license
      information.)

      \;

      Loaded prelude from /usr/lib/pure/prelude.pure.

      \;
    </output>

    <\input>
      \<gtr\>\ 
    <|input>
      fact n = if n\<gtr\>0 then n*fact (n-1) else 1;
    </input>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      map fact (0..10);
    <|unfolded-io>
      [1,1,2,6,24,120,720,5040,40320,362880,3628800]
    </unfolded-io>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      show fact
    <|unfolded-io>
      fact n = if n\<gtr\>0 then n*fact (n-1) else 1;
    </unfolded-io>
  </session>

  As with other <TeXmacs> session inserts, these snippets aren't just
  verbatim Pure code, they are <em|real interactions> with the Pure
  interpreter, so you can rerun the calculations or enter your own code. By
  these means you can use <TeXmacs> as a frontend for the Pure interpreter;
  please check the <TeXmacs> documentation, section \P<TeXmacs> \ as an
  interface\Q, for details. To make this work, you'll have to install the
  plugin first so that <TeXmacs> knows about it; instructions for that can be
  found in the <hlink|Pure installation instructions|http://docs.pure-lang.googlecode.com/hg/install.html#texmacs-mode>.
  The distributed configuration actually defines various different types of
  Pure sessions, each with their own options for the Pure interpreter, and
  it's easy to add your own if needed.

  Sessions can be formatted in different ways. Here we use the <TeXmacs>
  <samp|varsession> style package for a somewhat fancier formatting. It's
  also possible to globally override formatting options such as the color of
  prompts, input and output fields, by defining the <verbatim|pure-input> and
  <verbatim|pure-output> macros accordingly; see the <TeXmacs> manual,
  section \PWriting <TeXmacs> style files\Q, for details. An example can be
  found in the accompanying <verbatim|pure-session-styles.ts> file; install
  this in your <verbatim|~/.TeXmacs/packages> directory if you want to give
  it a try.

  Here's another session showing plain text formatting and subsessions.

  <\session|pure|subsession-example>
    <\output>
      \;

      \ __ \\ \ \| \ \ \| \ __\| _ \\ \ \ \ Pure 0.56
      (x86_64-unknown-linux-gnu)

      \ \| \ \ \| \| \ \ \| \| \ \ \ __/ \ \ \ Copyright (c) 2008-2012 by
      Albert Graef

      \ .__/ \\__,_\|_\| \ \\___\| \ \ \ (Type 'help' for help, 'help
      copying'

      _\| \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ for license
      information.)

      \;

      Loaded prelude from /usr/lib/pure/prelude.pure.

      \;
    </output>

    <\input>
      \<gtr\>\ 
    <|input>
      fact n = if n\<gtr\>0 then n*fact (n-1) else 1;
    </input>

    <\unfolded-subsession>
      This is a subsession.
    <|unfolded-subsession>
      <\unfolded-io>
        \<gtr\>\ 
      <|unfolded-io>
        map fact (1..10); // <text|This is a <em|plain text> comment with
        math: <math|n! = 1\<times\>\<cdots\>\<times\><around*|(|n-1|)>\<times\>n>.>
      <|unfolded-io>
        [1,2,6,24,120,720,5040,40320,362880,3628800]
      </unfolded-io>

      <\unfolded-io>
        \<gtr\>\ 
      <|unfolded-io>
        show fact
      <|unfolded-io>
        fact n = if n\<gtr\>0 then n*fact (n-1) else 1;
      </unfolded-io>

      <\input>
        \<gtr\>\ 
      <|input>
        \;
      </input>
    </unfolded-subsession>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      fact fact;
    <|unfolded-io>
      <\errput>
        \<less\>stdin\<gtr\>, line 4: unhandled exception 'failed_cond' while
        evaluating 'fact fact'
      </errput>
    </unfolded-io>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      fact 30L;
    <|unfolded-io>
      265252859812191058636308480000000L
    </unfolded-io>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      quit
    <|unfolded-io>
      <script-dead>
    </unfolded-io>
  </session>

  Another session type (<verbatim|pure-debug>, this runs the interpreter in
  debugging mode):

  <\session|pure-debug|default>
    <\output>
      \;

      \ __ \\ \ \| \ \ \| \ __\| _ \\ \ \ \ Pure 0.56
      (x86_64-unknown-linux-gnu)

      \ \| \ \ \| \| \ \ \| \| \ \ \ __/ \ \ \ Copyright (c) 2008-2012 by
      Albert Graef

      \ .__/ \\__,_\|_\| \ \\___\| \ \ \ (Type 'help' for help, 'help
      copying'

      _\| \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ for license
      information.)

      \;

      Loaded prelude from /usr/lib/pure/prelude.pure.

      \;
    </output>

    <\input>
      \<gtr\>\ 
    <|input>
      fact n = if n\<gtr\>0 then n*fact (n-1) else 1;
    </input>

    <\input>
      \<gtr\>\ 
    <|input>
      break fact
    </input>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      fact 5;
    <|unfolded-io>
      ** [1] fact: fact n = if n\<gtr\>0 then n*fact (n-1) else 1;

      \ \ \ \ \ n = 5

      (Type 'h' for help.)
    </unfolded-io>

    <\unfolded-io>
      :\ 
    <|unfolded-io>
      h
    <|unfolded-io>
      Debugger commands:

      a \ \ \ \ \ \ auto: step through the entire program, run unattended

      c [f] \ \ continue until next breakpoint, or given function f

      h \ \ \ \ \ \ help: print this list

      n \ \ \ \ \ \ next step: step over reduction

      p [n] \ \ print rule stack (n = number of frames)

      r \ \ \ \ \ \ run: finish evaluation without debugger

      s \ \ \ \ \ \ single step: step into reduction

      t, b \ \ \ move to the top or bottom of the rule stack

      u, d \ \ \ move up or down one level in the rule stack

      x \ \ \ \ \ \ exit the interpreter (after confirmation)

      . \ \ \ \ \ \ reprint current rule

      ! cmd \ \ execute interpreter command

      ? expr \ evaluate expression

      \<less\>cr\<gtr\> \ \ \ single step (same as 's')

      \<less\>eof\<gtr\> \ \ step through program, run unattended (same as
      'a')
    </unfolded-io>

    <\unfolded-io>
      :\ 
    <|unfolded-io>
      s
    <|unfolded-io>
      ** [2] (\<gtr\>): x::int\<gtr\>y::int = x\<gtr\>y;

      \ \ \ \ \ x = 5; y = 0
    </unfolded-io>

    <\unfolded-io>
      :\ 
    <|unfolded-io>
      s
    <|unfolded-io>
      ++ [2] (\<gtr\>): x::int\<gtr\>y::int = x\<gtr\>y;

      \ \ \ \ \ x = 5; y = 0

      \ \ \ \ \ --\<gtr\> 1

      ** [2] (-): x::int-y::int = x-y;

      \ \ \ \ \ x = 5; y = 1
    </unfolded-io>

    <\unfolded-io>
      :\ 
    <|unfolded-io>
      s
    <|unfolded-io>
      ++ [2] (-): x::int-y::int = x-y;

      \ \ \ \ \ x = 5; y = 1

      \ \ \ \ \ --\<gtr\> 4

      ** [2] fact: fact n = if n\<gtr\>0 then n*fact (n-1) else 1;

      \ \ \ \ \ n = 4
    </unfolded-io>

    <\unfolded-io>
      :\ 
    <|unfolded-io>
      r
    <|unfolded-io>
      120
    </unfolded-io>
  </session>

  Note that <TeXmacs> always runs plugins in the current working directory in
  which it was started, which is also the directory from which the Pure
  interpreter will read its startup files. If you start <TeXmacs> from the
  GUI, this will most likely be your home directory. It often makes more
  sense to run the interpreter in the directory of the <TeXmacs> document
  hosting the Pure sessions, so that you can keep scripts and other files
  needed by your sessions in the same directory. Unfortunately, <TeXmacs>
  offers no help with this; there's simply no way to specify a working
  directory when running a session. Thus you'll either have to run <TeXmacs>
  in the right directory (by invoking it from the command line), or change
  the working directory manually inside the Pure session. To help with the
  latter, the <TeXmacs>-hosted interpreter offers a special <verbatim|cdd>
  (\Pcurrent document directory\Q) command:

  <\session|pure|default>
    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      pwd
    <|unfolded-io>
      /home/ag
    </unfolded-io>

    <\input>
      \<gtr\>\ 
    <|input>
      cdd
    </input>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      pwd
    <|unfolded-io>
      /home/ag/.TeXmacs/plugins/pure/doc
    </unfolded-io>
  </session>

  <section|Completion and Help>

  Completion of Pure keywords and functions is fully supported in <TeXmacs>.
  Just type <key|Tab> as usual and <TeXmacs> displays a list of possible
  completions in its status line. Pressing <key|Tab> again you can cycle
  through the completions and pick the one that you want. For instance, you
  can try this yourself on the following input line by placing the cursor
  behind the <verbatim|f> and hitting the <key|Tab> key repeatedly:

  <\session|pure|default>
    <\input>
      \<gtr\>\ 
    <|input>
      f
    </input>
  </session>

  The Pure <verbatim|help> command also works in <TeXmacs>. This pops up a
  new <TeXmacs> window with the help file in it. Search terms also work as
  usual; you might want to try the following to find out how the Pure help
  system works (this may take a while to load, so be patient):

  <\session|pure|default>
    <\input>
      \<gtr\>\ 
    <|input>
      help online-help
    </input>
  </session>

  Note that Pure's online help is in html format by default. While <TeXmacs>
  can load html files, it has to convert them to its own format first, which
  at least in the current version of <TeXmacs> is quite slow and the
  rendering isn't perfect. As a remedy, there's <TeXmacs>-formatted online
  documentation available on the Pure website, see the Pure installation
  instructions for details. If these files are installed then the Pure help
  can also be accessed using the corresponding options in the <samp|Pure>
  plugin menu which automatically appears when the cursor is inside a Pure
  session. If you still prefer the html documentation, then it's also
  possible to use an external graphical html browser instead. Just set the
  <verbatim|PURE_HELP> shell environment variable accordingly, the
  interpreter will then use that command to display the online
  help.<\footnote>
    Note that the <verbatim|PURE_HELP> environment variable also works
    outside of <TeXmacs>, i.e., when the interpreter is run from Emacs or the
    shell. The <verbatim|BROWSER> environment variable, however, does
    <em|not> change the way that the <verbatim|help> command works in
    <TeXmacs>, so you can use this variable instead to specify a browser
    program for use outside of <TeXmacs> only.
  </footnote>

  <section|Pure and Reduce>

  The following example shows how to run the Reduce computer algebra system
  in Pure (to make this work, you also need to have the
  <verbatim|pure-reduce> module installed; this is available as an addon from
  the <hlink|Pure website|http://pure-lang.googlecode.com>).

  <\session|pure|reduce>
    <\output>
      \;

      \ __ \\ \ \| \ \ \| \ __\| _ \\ \ \ \ Pure 0.56
      (x86_64-unknown-linux-gnu)

      \ \| \ \ \| \| \ \ \| \| \ \ \ __/ \ \ \ Copyright (c) 2008-2012 by
      Albert Graef

      \ .__/ \\__,_\|_\| \ \\___\| \ \ \ (Type 'help' for help, 'help
      copying'

      _\| \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ for license
      information.)

      \;

      Loaded prelude from /usr/lib/pure/prelude.pure.

      \;
    </output>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      using reduce;
    <|unfolded-io>
      Reduce (Free CSL version), 03-Nov-12 ...
    </unfolded-io>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      simplify (df (sin (x^2)) x);
    <|unfolded-io>
      2*cos (x^2)*x
    </unfolded-io>
  </session>

  Up to now we've only been running Pure in verbatim
  a.k.a.<space|1spc>program mode. But the Pure plugin also fully supports
  math input and output. These are enabled as follows:

  <\itemize>
    <item>To use math <em|input>, you can toggle the input line between math
    and program (verbatim) mode using the <key|Ctrl+Shift+M> key combination.
    This isn't a standard <TeXmacs> keybinding, but is defined at the
    beginning of the <verbatim|pure-init.scm> script for your convenience;
    you can edit the script to change this according to your preferences. Of
    course, you can also use the corresponding <samp|Focus \| Input options
    \| Mathematical input> menu option or the equivalent toolbar item; these
    become visible when the cursor is located at the input line. Or you can
    make math input the default by putting the following Scheme command into
    your <verbatim|my-init-texmacs.scm> file:

    <\scm-code>
      (if (not (session-math-input?)) (toggle-session-math-input))
    </scm-code>

    <item>To enable math <em|output>, you'll have to invoke the
    <verbatim|math> function from the Pure <verbatim|texmacs> module. This
    module is always loaded when running Pure inside <TeXmacs>. The
    <verbatim|math> function uses the Reduce <verbatim|tmprint> package, so
    the <verbatim|pure-reduce> module <em|must> be installed to make this
    work.

    The <verbatim|verbatim> function switches back to verbatim Pure output.
    Verbatim output is also used as a fallback in math mode for all Pure
    expressions which cannot be printed through the Reduce interface
    (typically because they aren't valid Reduce expressions).

    To make math output the default, you can also run a <verbatim|pure-math>
    session (<samp|Insert \| Session \| Pure-math>) which works like a
    regular Pure session but enables math output and loads the
    <verbatim|reduce> module at startup.
  </itemize>

  At present this is still a bit experimental and work in progress, but it
  seems to work pretty well already, as shown below. (If you notice any bugs
  or missing features in math input and output, please submit a bug report on
  the <hlink|Pure website|http://code.google.com/p/pure-lang/issues/list>.)

  <\session|pure|reduce>
    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      math;
    <|unfolded-io>
      ()
    </unfolded-io>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      simplify <around*|(|df <around*|(|sin<around*|(|x<rsup|2>|)>|)> x|)>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|2*cos
      <around*|(|x<rsup|2>|)>*x>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      simplify <around*|(|intg <around*|(|cos <around*|(|x+y|)><rsup|2>|)>
      x|)>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<frac|cos
      <around*|(|x+y|)>*sin <around*|(|x+y|)>+x|2>>
    </unfolded-io-math>
  </session>

  A more detailed account on math input and output can be found in the
  following section.

  <section|Mathematical Input and Output>

  For the purposes of this section, let's start up a regular Pure session and
  load the <verbatim|math> and <verbatim|reduce> modules.

  <\session|pure|math>
    <\output>
      \;

      \ __ \\ \ \| \ \ \| \ __\| _ \\ \ \ \ Pure 0.56
      (x86_64-unknown-linux-gnu)

      \ \| \ \ \| \| \ \ \| \| \ \ \ __/ \ \ \ Copyright (c) 2008-2012 by
      Albert Graef

      \ .__/ \\__,_\|_\| \ \\___\| \ \ \ (Type 'help' for help, 'help
      copying'

      _\| \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ for license
      information.)

      \;

      Loaded prelude from /usr/lib/pure/prelude.pure.

      \;
    </output>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      using math, reduce;
    <|unfolded-io>
      Reduce (Free CSL version), 03-Nov-12 ...
    </unfolded-io>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      simplify (df (sin (x^2)) x);
    <|unfolded-io>
      2*cos (x^2)*x
    </unfolded-io>
  </session>

  To enter an expression like the one above as a mathematical formula, we
  must first switch the input line to <em|math input mode>. To do that, you
  can go search the toolbar for <samp|Input Options \| Mathematical Input>
  and check it, or type the key combination <key|Ctrl+Shift+M> defined by the
  Pure plugin. Another useful convenience is the <verbatim|?> prefix operator
  (defined in <verbatim|texmacs.pure>) which simplifies its expression
  argument, which is quoted automagically. Here's how the expression
  <verbatim|? df (sin (x^2)) x)> looks like when typed in math input mode:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      ?df <around*|(|sin <around*|(|x<rsup|2>|)>|)> x;
    <|unfolded-io-math>
      2*cos (x^2)*x
    </unfolded-io-math>
  </session>

  This is pretty much the same as:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      simplify <around*|(|<rprime|'>df <around*|(|sin
      <around*|(|x<rsup|2>|)>|)> x|)>;
    <|unfolded-io-math>
      2*cos (x^2)*x
    </unfolded-io-math>
  </session>

  But it's a lot easier to type, and the <verbatim|?> operator uses
  <verbatim|simplifyd> rather than just <verbatim|simplify>, which also
  supports some customary notation for limits, integrals and differentials
  commonly used in <TeXmacs>. The <verbatim|?:> operator does the same, but
  evaluates its argument; you want to use that if the expression includes
  some Pure functions which should be evaluated before submitting the result
  to Reduce. Note the difference:

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      foo x = x+1;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      ?intg<around*|(|foo x|)> x;
    <|unfolded-io-math>
      \;

      *** foo declared operator\ 

      intg (foo x) x
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      ?:intg<around*|(|foo x|)> x;
    <|unfolded-io-math>
      (x^2+2*x)/2
    </unfolded-io-math>
  </session>

  Note that both <verbatim|?> and <verbatim|?:> are at the lowest possible
  precedence level in Pure so that their arguments don't have to be
  parenthesized (but this also means that you'll have to parenthesize the
  entire <verbatim|?> or <verbatim|?:> expression if you want to use it in
  the context of a larger expression).

  Once we change to <em|math output mode>, simplifications of expressions are
  done automatically by the pretty-printer, so we can often do without
  explicitly using the <verbatim|simplify>, <verbatim|?> and <verbatim|?:>
  operations. We'll do the rest of this session in this mode, so let's switch
  to it now. As explained in the previous section, this is done by invoking
  the <verbatim|math> function from the <verbatim|texmacs> module.<\footnote>
    Note the <verbatim|let> keyword before the call to <verbatim|math>. In
    Pure this normally indicates a global variable definition, but if the
    left-hand side is omitted, the interpreter executes the right-hand side
    expression as usual and skips the printing of the result, similar to what
    the <verbatim|$> terminator does in Reduce. We'll use this trick a lot in
    the following, to suppress uninteresting evaluation results.
  </footnote>

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      let math;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      df <around*|(|sin <around*|(|x<rsup|2>|)>|)> x;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|2*cos
      <around*|(|x<rsup|2>|)>*x>
    </unfolded-io-math>
  </session>

  Note that the <verbatim|df> term got simplified, but that's only in the
  display:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      verb ans;
    <|unfolded-io-math>
      df (sin (x^2)) x
    </unfolded-io-math>
  </session>

  To actually obtain a simplified result which can be processed further in
  Pure land (passed to Pure functions or assigned to Pure variables), you
  still need to use <verbatim|?>, <verbatim|?:> etc.:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      ?df <around*|(|sin <around*|(|x<rsup|2>|)>|)> x;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|2*cos
      <around*|(|x<rsup|2>|)>*x>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      verb ans;
    <|unfolded-io-math>
      2*cos (x^2)*x
    </unfolded-io-math>
  </session>

  Note that the function <verbatim|verb> from the <verbatim|texmacs> module
  lets us peek at how the verbatim result looks like, without actually
  switching to verbatim mode. Similarly, the <verbatim|mth> function
  temporarily switches the output mode to math mode when in verbatim mode.

  There are some Pure expressions (such as strings, lambdas and pointers)
  which are always printed verbatim. However, the pretty-printer will try to
  print as much of the result in math mode as it can. For instance:

  <\session|pure|math>
    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      (\\x-\<gtr\>x^2),"abc",df (sin (x^2)) x*y;
    <|unfolded-io>
      #\<less\>closure 0x7f1db00e3580\<gtr\>,"abc",<with|color|black|mode|math|math-display|true|2*cos
      <around*|(|x<rsup|2>|)>*x*y>
    </unfolded-io>
  </session>

  There are in fact two different variations of math output mode. Just
  calling <verbatim|math> is the same as <verbatim|algebraic> which
  corresponds to Reduce's <em|algebraic mode> and causes printed expressions
  to be simplified before they are printed. In contrast, <verbatim|symbolic>
  employs Reduce's <em|symbolic mode> to pretty-print the raw expressions
  <em|without> simplifying them.<\footnote>
    Note that these commands don't actually change Reduce's internal mode of
    operation, they only affect the display mode in <TeXmacs>.
  </footnote> Likewise, there are functions <verbatim|alg> (which is a
  synonym for <verbatim|mth>) and <verbatim|symb> to temporarily switch to
  the algebraic and symbolic math output modes, respectively. For instance:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      df <around*|(|sin <around*|(|x<rsup|2>|)>|)> x;<text|<verbatim| //
      still in algebraic math mode>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|2*cos
      <around*|(|x<rsup|2>|)>*x>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      symb ans;<text|<verbatim| // the same in symbolic math mode>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<frac|\<partial\>*sin
      <around*|(|x<rsup|2>|)>|\<partial\>*x>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      verb ans;<text|<verbatim| // the same as a verbatim Pure expression>>
    <|unfolded-io-math>
      df (sin (x^2)) x
    </unfolded-io-math>
  </session>

  Note that there are some kinds of symbolic expressions (specifically, the
  logical expressions other than equality) which aren't by default valid in
  Reduce's algebraic mode, but work in symbolic mode:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      x\<geqslant\>y\<wedge\>y\<gtr\>0;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|x>\<gtr\>=<with|color|black|mode|math|math-display|true|y>&&<with|color|black|mode|math|math-display|true|y>\<gtr\><with|color|black|mode|math|math-display|true|0>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      symb ans;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|x\<geq\>y\<wedge\>y\<gtr\>0>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      ?x\<gtr\>0;
    <|unfolded-io-math>
      \;

      ***** \<gtr\> invalid as algebraic operator\ 

      \;

      ***** \<gtr\> invalid as algebraic operator\ 

      <with|color|black|mode|math|math-display|true|x>\<gtr\><with|color|black|mode|math|math-display|true|0>
    </unfolded-io-math>
  </session>

  As a remedy, you can just declare the logical operations as Reduce
  operators; this won't actually convince Reduce to simplify them, but at
  least it gets rid of those annoying error messages and also makes the
  pretty-printer do a nicer job in algebraic mode:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      declare operator <around*|[|<around*|(|\<neq\>|)>,<around*|(|\<less\>|)>,<around*|(|\<gtr\>|)>,<around*|(|\<leqslant\>|)>,<around*|(|\<geqslant\>|)>,<around*|(|\<neg\>|)>,<around*|(|\<wedge\>|)>,<around*|(|\<vee\>|)>|]>;
    <|unfolded-io-math>
      ()
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      x\<geqslant\>y\<wedge\>y\<gtr\>0;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|x\<geq\>y\<wedge\>y\<gtr\>0>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      ?x\<geqslant\>y\<wedge\>y\<gtr\>0;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|x\<geq\>y\<wedge\>y\<gtr\>0>
    </unfolded-io-math>
  </session>

  <subsection|Basic expressions>

  Most mathematical expressions are mapped to corresponding Pure expressions
  in a sensible way. We start out by declaring a few additional operators to
  be used below, so that they are known to Reduce. (This isn't strictly
  necessary, but silences the \P<verbatim|declared operator>\Q messages from
  Reduce.)

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      let declare<space|1spc>operator <around*|[|above,below,binom|]>;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <around*|(|\<backslash\>x\<rightarrow\>2*x+\<alpha\>|)>
      5;<with|mode|prog| // lambdas>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|\<alpha\>+<with|math-font-family|rm|10>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      x<rsub|k>,x<rsup|k>,<lsub|k>x,<lsup|k>x,<below|x|k>,<above|x|k>;<text|<verbatim|
      // sub- and superscripts>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|x>!<with|color|black|mode|math|math-display|true|k>,<with|color|black|mode|math|math-display|true|x<rsup|k>>,<with|color|black|mode|math|math-display|true|x>!<with|color|black|mode|math|math-display|true|k>,<with|color|black|mode|math|math-display|true|x<rsup|k>>,<with|color|black|mode|math|math-display|true|<math-up|below><around*|(|x,k|)>>,<with|color|black|mode|math|math-display|true|<math-up|above><around*|(|x,k|)>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <frac|x|y>,<tfrac|x|y>,<dfrac|x|y>,<frac*|x|y>,x/y;<with|mode|prog| //
      fractions>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<frac|x|y>>,<with|color|black|mode|math|math-display|true|<frac|x|y>>,<with|color|black|mode|math|math-display|true|<frac|x|y>>,<with|color|black|mode|math|math-display|true|<frac|x|y>>,<with|color|black|mode|math|math-display|true|<frac|x|y>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      189\<div\>30;<text|<verbatim| // exact division p%q, yields Pure
      rationals>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<frac|<with|math-font-family|rm|63>|<with|math-font-family|rm|10>>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <binom|n-1|k-1>+<binom|n-1|k>;<text|<verbatim| // binomials>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<math-up|binom><around*|(|n-1,k-1|)>+<math-up|binom><around*|(|n-1,k|)>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <matrix|<tformat|<table|<row|<cell|a>|<cell|b>>|<row|<cell|b>|<cell|-a>>>>>,
      <tabular*|<tformat|<table|<row|<cell|a>|<cell|b>>|<row|<cell|b>|<cell|-a>>>>>,
      <block*|<tformat|<table|<row|<cell|a>|<cell|b>>|<row|<cell|b>|<cell|-a>>>>>;<text|<verbatim|
      // matrices and tables (various formats)>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|(|<tabular*|<tformat|<table|<row|<cell|a>|<cell|b>>|<row|<cell|b>|<cell|-a>>>>>|)>>,<with|color|black|mode|math|math-display|true|<around*|(|<tabular*|<tformat|<table|<row|<cell|a>|<cell|b>>|<row|<cell|b>|<cell|-a>>>>>|)>>,<with|color|black|mode|math|math-display|true|<around*|(|<tabular*|<tformat|<table|<row|<cell|a>|<cell|b>>|<row|<cell|b>|<cell|-a>>>>>|)>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <det|<tformat|<table|<row|<cell|a>|<cell|b>>|<row|<cell|b>|<cell|-a>>>>>;<text|<verbatim|
      // determinants>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|-<around*|(|a<rsup|2>+b<rsup|2>|)>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <matrix|<tformat|<table|<row|<cell|a>|<cell|b>|<cell|c>>>>>,
      <matrix|<tformat|<table|<row|<cell|a>>|<row|<cell|b>>|<row|<cell|c>>>>>;<text|<verbatim|
      // vectors>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|(|<tabular*|<tformat|<table|<row|<cell|a>|<cell|b>|<cell|c>>>>>|)>>,<with|color|black|mode|math|math-display|true|<around*|(|<tabular*|<tformat|<table|<row|<cell|a>>|<row|<cell|b>>|<row|<cell|c>>>>>|)>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      exp<around*|(|x|)>*\<alpha\>+\<beta\>;<text|<verbatim| // arithmetic>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|e<rsup|x>*\<alpha\>+\<beta\>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <sqrt|x<rsup|2>+y<rsup|2>>, <sqrt|x|3>;<text|<verbatim| // roots>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<sqrt|x<rsup|2>+y<rsup|2>>>,<with|color|black|mode|math|math-display|true|<sqrt|x|<space|0.25spc>3>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      \<neg\>A\<wedge\><around*|(|B\<vee\>C|)>;<text|<verbatim| // logic>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|\<neg\><around*|(|A|)>\<wedge\><around*|(|B\<vee\>C|)>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      x\<gtr\>y, x\<less\>y, x\<geqslant\>y,x\<leqslant\>y,x\<longequal\>y,x\<neq\>y;<text|<verbatim|
      // comparisons>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|x\<gtr\>y>,<with|color|black|mode|math|math-display|true|x\<less\>y>,<with|color|black|mode|math|math-display|true|x\<geq\>y>,<with|color|black|mode|math|math-display|true|x\<leq\>y>,<with|color|black|mode|math|math-display|true|x\<longequal\>y>,<with|color|black|mode|math|math-display|true|x\<neq\>y>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <rprime|'><around*|(|x\<equiv\>y, x\<nequiv\>y|)>;<text|<verbatim| //
      syntactic equality (=== / ~== in Pure)>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|x>===<with|color|black|mode|math|math-display|true|y>,<with|color|black|mode|math|math-display|true|x>~==<with|color|black|mode|math|math-display|true|y>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      eval ans;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|0>,<with|color|black|mode|math|math-display|true|1>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <around*|[|1,2,3|]>;<text|<verbatim| // lists>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>2<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>3|]>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      1\<ldots\>10; 1:3\<ldots\>11;<text|<verbatim| // arithmetic sequences>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>2<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>3<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>4<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>5<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>6<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>7<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>8<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>9<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|10>|]>>

      <with|color|black|mode|math|math-display|true|<around*|[|1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>3<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>5<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>7<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>9<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|11>|]>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <around*|[|a+1 <mid|\|> a=1\<ldots\>10;a mod 2|]>;<text|<verbatim| //
      comprehensions>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|2<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>4<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>6<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>8<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|10>|]>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <around*|(|a,b+1|)>; <around*|[|a,b+1|]>;
      <around*|\<langle\>|a,b+1|\<rangle\>>;
      <around*|\<llbracket\>|a,b+1|\<rrbracket\>>;
      <around*|\<lfloor\>|n/2|\<rfloor\>>; <around*|\<lceil\>|n/2|\<rceil\>>;
      <around*|\||x|\|>; <around*|\<\|\|\>|x|\<\|\|\>>;<text|<verbatim| //
      various brackets>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|a>,<with|color|black|mode|math|math-display|true|b+1>

      <with|color|black|mode|math|math-display|true|<around*|[|a<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>b+1|]>>

      <with|color|black|mode|math|math-display|true|a>,<with|color|black|mode|math|math-display|true|b+1>

      <with|color|black|mode|math|math-display|true|<around*|[|a<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>b+1|]>>

      <with|color|black|mode|math|math-display|true|<math-up|floor><around*|(|<frac|n|2>|)>>

      <with|color|black|mode|math|math-display|true|<math-up|ceiling><around*|(|<frac|n|2>|)>>

      <with|color|black|mode|math|math-display|true|<math-up|abs><around*|(|x|)>>

      <with|color|black|mode|math|math-display|true|<math-up|norm><around*|(|x|)>>
    </unfolded-io-math>

    <\input-math>
      \<gtr\>\ 
    <|input-math>
      let declare<space|1spc>operator <around*|[|hat,tilde,bar,vect,check,breve,dot,ddot,acute,grave|]>;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <wide|x|^>;<wide|x|~>;<wide|x|\<bar\>>;<wide|x|\<vect\>>;<wide|x|\<check\>>;<wide|x|\<breve\>>;<wide|x|\<dot\>>;<wide|x|\<ddot\>>;<wide|x|\<acute\>>;<wide|x|\<grave\>>;<rprime|'>x;<rprime|''>x;
      <neg|x>;\<sim\>x;<text|<verbatim| // accents, primes, etc.>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<math-up|hat><around*|(|x|)>>

      <with|color|black|mode|math|math-display|true|<math-up|tilde><around*|(|x|)>>

      <with|color|black|mode|math|math-display|true|<math-up|bar><around*|(|x|)>>

      <with|color|black|mode|math|math-display|true|<math-up|vect><around*|(|x|)>>

      <with|color|black|mode|math|math-display|true|<math-up|check><around*|(|x|)>>

      <with|color|black|mode|math|math-display|true|<math-up|breve><around*|(|x|)>>

      <with|color|black|mode|math|math-display|true|<math-up|dot><around*|(|x|)>>

      <with|color|black|mode|math|math-display|true|<math-up|ddot><around*|(|x|)>>

      <with|color|black|mode|math|math-display|true|<math-up|acute><around*|(|x|)>>

      <with|color|black|mode|math|math-display|true|<math-up|grave><around*|(|x|)>>

      <with|color|black|mode|math|math-display|true|x>

      '<with|color|black|mode|math|math-display|true|x>

      <with|color|black|mode|math|math-display|true|\<neg\><around*|(|x|)>>

      <with|color|black|mode|math|math-display|true|\<neg\><around*|(|x|)>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      x\<oplus\>y;x\<ominus\>y;x\<otimes\>y;x\<oslash\>y;x\<pm\>y;x\<mp\>y;x\<div\>y;x\<cap\>y;x\<cup\>y;x\<uplus\>y;<text|<verbatim|
      // infix operators>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|x> oplus
      <with|color|black|mode|math|math-display|true|y>

      <with|color|black|mode|math|math-display|true|x> ominus
      <with|color|black|mode|math|math-display|true|y>

      <with|color|black|mode|math|math-display|true|x> otimes
      <with|color|black|mode|math|math-display|true|y>

      <with|color|black|mode|math|math-display|true|x> oslash
      <with|color|black|mode|math|math-display|true|y>

      <with|color|black|mode|math|math-display|true|x> pm
      <with|color|black|mode|math|math-display|true|y>

      <with|color|black|mode|math|math-display|true|x> mp
      <with|color|black|mode|math|math-display|true|y>

      <with|color|black|mode|math|math-display|true|x>%<with|color|black|mode|math|math-display|true|y>

      <with|color|black|mode|math|math-display|true|x> cap
      <with|color|black|mode|math|math-display|true|y>

      <with|color|black|mode|math|math-display|true|x> cup
      <with|color|black|mode|math|math-display|true|y>

      <with|color|black|mode|math|math-display|true|x> uplus
      <with|color|black|mode|math|math-display|true|y>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      \<alpha\>;\<Gamma\>;\<b-up-Z\>;\<b-z\>;\<b-0\>;\<cal-C\>;\<frak-F\>;\<frak-u\>,\<frak-v\>,\<frak-w\>;\<bbb-Q\>;<text|<verbatim|
      // Greek symbols, special glyphs>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|\<alpha\>>

      <with|color|black|mode|math|math-display|true|\<Gamma\>>

      <with|color|black|mode|math|math-display|true|Z>

      <with|color|black|mode|math|math-display|true|z>

      <with|color|black|mode|math|math-display|true|0>

      <with|color|black|mode|math|math-display|true|C>

      <with|color|black|mode|math|math-display|true|F>

      <with|color|black|mode|math|math-display|true|u>,<with|color|black|mode|math|math-display|true|v>,<with|color|black|mode|math|math-display|true|w>

      <with|color|black|mode|math|math-display|true|math-font-family|rm|QQ>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <math-bf|foo>,<math-it|bar>,<math-sl|baz>,<math-ss|gnu>,<math-tt|gna>,<math-up|gnats>;<text|<verbatim|
      // special markup>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|math-font-family|rm|foo>,<with|color|black|mode|math|math-display|true|math-font-family|rm|bar>,<with|color|black|mode|math|math-display|true|math-font-family|rm|baz>,<with|color|black|mode|math|math-display|true|math-font-family|rm|gnu>,<with|color|black|mode|math|math-display|true|math-font-family|rm|gna>,<with|color|black|mode|math|math-display|true|math-font-family|rm|gnats>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <really-tiny|A,B>, <tiny|A,B>, <very-small|A,B>, <small|A,B>,
      <normal-size|A,B>, <large|A,B>, <very-large|A,B>, <huge|A,B>,
      <really-huge|A,B>;<text|<verbatim| // various sizes>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|A>,<with|color|black|mode|math|math-display|true|B>,<with|color|black|mode|math|math-display|true|A>,<with|color|black|mode|math|math-display|true|B>,<with|color|black|mode|math|math-display|true|A>,<with|color|black|mode|math|math-display|true|B>,<with|color|black|mode|math|math-display|true|A>,<with|color|black|mode|math|math-display|true|B>,<with|color|black|mode|math|math-display|true|A>,<with|color|black|mode|math|math-display|true|B>,<with|color|black|mode|math|math-display|true|A>,<with|color|black|mode|math|math-display|true|B>,<with|color|black|mode|math|math-display|true|A>,<with|color|black|mode|math|math-display|true|B>,<with|color|black|mode|math|math-display|true|A>,<with|color|black|mode|math|math-display|true|B>,<with|color|black|mode|math|math-display|true|A>,<with|color|black|mode|math|math-display|true|B>
    </unfolded-io-math>
  </session>

  More examples using list and matrix comprehensions (these are all plain
  Pure evaluations, Reduce is only used for the pretty-printing
  here):<\footnote>
    Note that in order to get the single vertical bar <verbatim|\|> in math
    mode, you'll have to type either <key|Shift+F5 \|> or <key|Alt+M \|> (the
    latter gives you a ``big'' <verbatim|\|> symbol which automatically
    expands with the brackets surrounding it).
  </footnote>

  <\session|pure|math>
    <\input>
      \<gtr\>\ 
    <|input>
      <math|<around*|\<\|\|\>|X\<colons\>matrix|\<\|\|\>> = <sqrt|sum
      <around*|[|x<rsup|2><mid|\|> x=X|]>>;>
    </input>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      <math|<around*|\<\|\|\>|<matrix|<tformat|<table|<row|<cell|1>|<cell|2>|<cell|3>|<cell|4>>>>>|\<\|\|\>>;>
    <|unfolded-io>
      <with|color|black|mode|math|math-display|true|5.47722557505>
    </unfolded-io>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      <math|<around*|[|2*x+1<mid|\|>x=1\<ldots\>5|]>;>
    <|unfolded-io>
      <with|color|black|mode|math|math-display|true|<around*|[|3<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>5<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>7<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>9<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|11>|]>>
    </unfolded-io>

    <\input-math>
      \<gtr\>\ 
    <|input-math>
      eye n = <matrix|<tformat|<table|<row|<cell|i\<longequal\>j<mid|\|>i=1\<ldots\>n;j=1\<ldots\>n>>>>>;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      eye 3;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|(|<tabular*|<tformat|<table|<row|<cell|1>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|1>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|1>>>>>|)>>
    </unfolded-io-math>
  </session>

  Here's an example of an infinite list, a prime sieve:

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      <math-bf|let> P=sieve (2\<ldots\>\<infty\>)
      <math-bf|with><space|1spc>sieve(p:<math-it|qs>) = p :sieve[q<mid|\|>q =
      <math-it|qs>; q <math-ss|mod> p] & <math-bf|end>;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      P!!<around*|(|0\<ldots\>20|)>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|2<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>3<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>5<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>7<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|11><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|13><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|17><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|19><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|23><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|29><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|31><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|37><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|41><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|43><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|47><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|53><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|59><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|61><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|67><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|71><space|0.25spc><space|0.25spc>|\<nobracket\>>>

      <with|color|black|mode|math|math-display|true|<around*|\<nobracket\>|<with|math-font-family|rm|,<space|0.25spc>>73|]>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      list <around*|(|take 20 <around*|(|drop 100 P|)>|)>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|<with|math-font-family|rm|547><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|557><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|563><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|569><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|571><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|577><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|587><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|593><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|599><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|601><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|607><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|613><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|617><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|619><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|631><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>|\<nobracket\>>>

      <with|color|black|mode|math|math-display|true|<around*|\<nobracket\>|641<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|643><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|647><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|653><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|659>|]>>
    </unfolded-io-math>
  </session>

  <subsection|Trees>

  <TeXmacs> has a nice and convenient notation for labelled trees. These are
  handled gracefully in Pure as well:

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      let declare operator tree;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <tree|a|b|c|<tree|x|y|z>>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<math-up|tree><around*|(|a,b,c,<math-up|tree><around*|(|x,y,z|)>|)>>
    </unfolded-io-math>
  </session>

  Because <verbatim|tree> is variadic (a tree may have any number of
  subtrees), it's denoted as an uncurried function in Pure. The first
  argument of <verbatim|tree> is always the label of the root node, the
  remaining arguments are the subtrees and/or leaves beneath the root node.
  The simplest way to translate this into a nested Pure list for easier
  processing is to just define <verbatim|tree> as the standard Pure function
  <verbatim|list>:

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      tree=list;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <tree|a|b|c|<tree|x|y|z>>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|a<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>b<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>c<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><around*|[|x<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>y<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>z|]>|]>>
    </unfolded-io-math>
  </session>

  This corresponds to a preorder traversal of the tree. If you prefer to have
  the labels of the branches as separate arguments then you might use a
  definition like the following instead:

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      clear tree
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      declare operator branch;
    <|unfolded-io-math>
      ()
    </unfolded-io-math>

    <\input-math>
      \<gtr\>\ 
    <|input-math>
      tree <around*|(|x,<math-it|ys>\<colons\>tuple|)>=branch x
      <around*|(|list <math-it|ys>|)>; tree <around*|(|x,y|)>=branch x
      <around*|[|y|]>;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <tree|a|b|c|<tree|x|y|z>>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<math-up|branch><around*|(|a,<around*|[|b<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>c<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><math-up|branch><around*|(|x,<around*|[|y<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>z|]>|)>|]>|)>>
    </unfolded-io-math>
  </session>

  Note that the way we defined <verbatim|tree>, <verbatim|branch> is in fact
  a curried constructor; the uncurried notation is an artifact of the
  pretty-printing here. As a verbatim Pure term the result looks like this:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      verb ans;
    <|unfolded-io-math>
      branch a [b,c,branch x [y,z]]
    </unfolded-io-math>
  </session>

  If the trees denote valid Pure terms then you might wish to get rid of all
  the extra baggage and just translate them to plain Pure applications.
  Here's a third variation of <verbatim|tree> which does this:

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      clear tree
    </input-math>

    <\input-math>
      \<gtr\>\ 
    <|input-math>
      tree x=foldl1 <around*|(|$|)> <around*|(|list x|)>;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <tree|f|a|b|<tree|<around*|(|\<times\>|)>|y|z>>;
    <|unfolded-io-math>
      \;

      *** f declared operator\ 

      <with|color|black|mode|math|math-display|true|f*<around*|(|a,b,y*z|)>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      verb ans;
    <|unfolded-io-math>
      f a b (y*z)
    </unfolded-io-math>
  </session>

  With this definition of <verbatim|tree> you can now enter arbitrary Pure
  expressions as trees if you like:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <tree|<around*|(|^|)>|<tree|<around*|(|+|)>|a|b>|2>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|a<rsup|2>+2*a*b+b<rsup|2>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      verb ans;
    <|unfolded-io-math>
      (a+b)^2
    </unfolded-io-math>
  </session>

  <subsection|Lists>

  List and vector/matrix data can be exchanged between Pure and Reduce in a
  seamless fashion. This makes it easy to inspect and manipulate compound
  results returned by Reduce, such as lists of partial fractions:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      let p=2/<around*|(|<around*|(|x+1|)><rsup|2>*<around*|(|x+2|)>|)>; p;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<frac|2|x<rsup|3>+4*x<rsup|2>+5*x+2>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      let off exp; p;<text|<verbatim| // expansion switched off>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<frac|2|<around*|(|x+2|)>*<around*|(|x+1|)><rsup|2>>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      let pfs = ?:pf p<space|1spc>x; pfs;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|<frac|2|x+2><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><frac|-2|x+1><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><frac|2|<around*|(|x+1|)><rsup|2>>|]>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      map <around*|(|\\y\<rightarrow\>df y<space|1spc>x|)> pfs;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|<frac|-2|<around*|(|x+2|)><rsup|2>><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><frac|2|<around*|(|x+1|)><rsup|2>><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><frac|-4|<around*|(|x+1|)><rsup|3>>|]>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      let on exp; ans;<text|<verbatim| // expansion switched back on again>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|<frac|-2|x<rsup|2>+4*x+4><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><frac|2|x<rsup|2>+2*x+1><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><frac|-4|x<rsup|3>+3*x<rsup|2>+3*x+1>|]>>
    </unfolded-io-math>
  </session>

  Let's consider another typical example, equation solving:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      let<space|1spc>eqn=log<around*|(|sin<around*|(|x+3|)>|)><rsup|5>\<longequal\>8;
      eqn;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|log <around*|(|sin
      <around*|(|x+3|)>|)><rsup|5>\<longequal\>8>
    </unfolded-io-math>

    <\input-math>
      \<gtr\>\ 
    <|input-math>
      let solns=?:solve eqn<space|1spc>x;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      #solns; take 2 solns;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|10>

      <with|color|black|mode|math|math-display|true|<around*|[|x\<longequal\>2*<math-up|arbint><around*|(|5|)>*\<pi\>+arcsin
      <around*|(|<frac|exp <around*|(|2<rsup|3/5>*cos
      <around*|(|<frac|2*\<pi\>|5>|)>|)>|exp <around*|(|2<rsup|3/5>*sin
      <around*|(|<frac|2*\<pi\>|5>|)>*i|)>>|)>-3<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>x\<longequal\>2*<math-up|arbint><around*|(|5|)>*\<pi\>-arcsin
      <around*|(|<frac|exp <around*|(|2<rsup|3/5>*cos
      <around*|(|<frac|2*\<pi\>|5>|)>|)>|exp <around*|(|2<rsup|3/5>*sin
      <around*|(|<frac|2*\<pi\>|5>|)>*i|)>>|)>+\<pi\>-3|]>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      let solns=?:reduce_with <around*|[|arbint\<Rightarrow\>cst
      0|]><space|1spc>solns; take 2 solns;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|x\<longequal\>arcsin
      <around*|(|<frac|exp <around*|(|2<rsup|3/5>*cos
      <around*|(|<frac|2*\<pi\>|5>|)>|)>|exp <around*|(|2<rsup|3/5>*sin
      <around*|(|<frac|2*\<pi\>|5>|)>*i|)>>|)>-3<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>x\<longequal\>-arcsin
      <around*|(|<frac|exp <around*|(|2<rsup|3/5>*cos
      <around*|(|<frac|2*\<pi\>|5>|)>|)>|exp <around*|(|2<rsup|3/5>*sin
      <around*|(|<frac|2*\<pi\>|5>|)>*i|)>>|)>+\<pi\>-3|]>>
    </unfolded-io-math>

    <\input-math>
      \<gtr\>\ 
    <|input-math>
      check \ <around*|(|u\<longequal\>v|)>
      <around*|(|x\<longequal\>y|)>=eval<around*|(|?:reduce_with
      <around*|[|x\<Rightarrow\>y|]> <around*|\||u-v|\|>|)>;
    </input-math>

    <\input-math>
      \<gtr\>\ 
    <|input-math>
      \<Delta\> s=check eqn<space|1spc>s;let \<varepsilon\>=10<rsup|-8>;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <around*|[|y<mid|\|>x\<longequal\>y=solns;\<Delta\><around*|(|x\<longequal\>y|)>\<longequal\>0|]>;<text|<verbatim|
      // exact zeros>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|arcsin
      <around*|(|e<rsup|2<rsup|3/5>>|)>-3<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>-arcsin
      <around*|(|e<rsup|2<rsup|3/5>>|)>+\<pi\>-3|]>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <around*|[|y<mid|\|> s@<around*|(|x\<longequal\>y|)>=solns;\<Delta\>
      s\<neq\>0\<wedge\>\<Delta\> s\<leqslant\>\<varepsilon\>|]>;<text|<verbatim|
      // inexact zeros>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|arcsin
      <around*|(|exp <around*|(|2<rsup|3/5>*cos
      <around*|(|<frac|2*\<pi\>|5>|)>+2<rsup|3/5>*sin
      <around*|(|<frac|2*\<pi\>|5>|)>*i|)>|)>-3|]>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <around*|[|y\<Rightarrow\>\<Delta\> s<mid|\|>
      s@<around*|(|x\<longequal\>y|)>=solns;\<Delta\>
      s\<gtr\>\<varepsilon\>|]>;<text|<verbatim| // what's up with these??>>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|arcsin
      <around*|(|<frac|exp <around*|(|2<rsup|3/5>*cos
      <around*|(|<frac|2*\<pi\>|5>|)>|)>|exp
      <around*|(|<around*|(|2<rsup|3/5>*sin
      <around*|(|<frac|2*\<pi\>|5>|)>|)>*i|)>>|)>-3\<Rightarrow\><with|math-font-family|rm|7.8764><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><around*|(|-arcsin
      <around*|(|<frac|exp <around*|(|2<rsup|3/5>*cos
      <around*|(|<frac|2*\<pi\>|5>|)>|)>|exp
      <around*|(|<around*|(|2<rsup|3/5>*sin
      <around*|(|<frac|2*\<pi\>|5>|)>|)>*i|)>>|)>+\<pi\>|)>-3\<Rightarrow\><with|math-font-family|rm|7.8764><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>|\<nobracket\>>>

      <with|color|black|mode|math|math-display|true|arcsin
      <around*|(|<frac|1|exp <around*|(|2<rsup|3/5>*cos
      <around*|(|<frac|\<pi\>|5>|)>+<around*|(|2<rsup|3/5>*sin
      <around*|(|<frac|\<pi\>|5>|)>|)>*i|)>>|)>-3\<Rightarrow\><with|math-font-family|rm|7.8764><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><around*|(|-arcsin
      <around*|(|<frac|1|exp <around*|(|2<rsup|3/5>*cos
      <around*|(|<frac|\<pi\>|5>|)>+<around*|(|2<rsup|3/5>*sin
      <around*|(|<frac|\<pi\>|5>|)>|)>*i|)>>|)>+\<pi\>|)>-3\<Rightarrow\><with|math-font-family|rm|7.8764><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>>

      <with|color|black|mode|math|math-display|true|arcsin
      <around*|(|<frac|exp <around*|(|<around*|(|2<rsup|3/5>*sin
      <around*|(|<frac|\<pi\>|5>|)>|)>*i|)>|e<rsup|2<rsup|3/5>*cos
      <around*|(|<frac|\<pi\>|5>|)>>>|)>-3\<Rightarrow\><with|math-font-family|rm|7.8764><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><around*|(|-arcsin
      <around*|(|<frac|exp <around*|(|<around*|(|2<rsup|3/5>*sin
      <around*|(|<frac|\<pi\>|5>|)>|)>*i|)>|e<rsup|2<rsup|3/5>*cos
      <around*|(|<frac|\<pi\>|5>|)>>>|)>+\<pi\>|)>-3\<Rightarrow\><with|math-font-family|rm|7.8764><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>>

      <with|color|black|mode|math|math-display|true|<around*|\<nobracket\>|<around*|(|-arcsin
      <around*|(|exp <around*|(|2<rsup|3/5>*cos
      <around*|(|<frac|2*\<pi\>|5>|)>+<around*|(|2<rsup|3/5>*sin
      <around*|(|<frac|2*\<pi\>|5>|)>|)>*i|)>|)>+\<pi\>|)>-3\<Rightarrow\><with|math-font-family|rm|7.8764>|]>>
    </unfolded-io-math>
  </session>

  <subsection|Big operators (integrals, limits, sums, etc.)>

  Big operators (<samp|Insert \| Symbol \| Big operator> in math mode) are
  mapped to corresponding Pure expressions, generally using a
  Reduce-compatible form:

  <\session|pure|math>
    \;

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <big|int>sin x \<mathd\>x;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|-cos <around*|(|x|)>>
    </unfolded-io-math>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      reduce::load "defint"; // we need this for the definite integrals
    <|unfolded-io>
      <with|color|black|mode|math|math-display|true|0>
    </unfolded-io>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <big|int><rsub|a><rsup|b>x<rsup|2>\<mathd\>x;<big|intlim><rsub|a><rsup|b>x<rsup|2>\<mathd\>x;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<frac|-a<rsup|3>+b<rsup|3>|3>>

      <with|color|black|mode|math|math-display|true|<frac|-a<rsup|3>+b<rsup|3>|3>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      lim<rsub|x\<rightarrow\>0><around*|(|1/x|)>,
      lim<rsub|x\<rightarrow\>\<infty\>><around*|(|x*sin<around*|(|1/x|)>|)>,lim<rsub|x\<rightarrow\>\<infty\>><frac|1|x>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|\<infty\>>,<with|color|black|mode|math|math-display|true|1>,<with|color|black|mode|math|math-display|true|0>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <big|int>sin x \<mathd\>x,<big|int><rsub|a><rsup|b>x<rsup|2>\<mathd\>x,<big|intlim><rsub|a><rsup|b>x<rsup|2>\<mathd\>x;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|-cos
      <around*|(|x|)>>,<with|color|black|mode|math|math-display|true|<frac|-a<rsup|3>+b<rsup|3>|3>>,<with|color|black|mode|math|math-display|true|<frac|-a<rsup|3>+b<rsup|3>|3>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <big|sum><rsub|k=1><rsup|n><around*|(|2*k-1|)>,<big|prod><rsub|k=1><rsup|n><around*|(|2*k-1|)>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|n<rsup|2>>,<with|color|black|mode|math|math-display|true|<frac|2*\<gamma\>*<around*|(|2*n|)>|2<rsup|n>*\<gamma\><around*|(|n|)>>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <big|sum><rsub|k=0><rsup|n-1><around*|(|a+k*r|)>,
      <big|prod><rsub|k=1><rsup|n><frac|k|k+2>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<frac|n*<around*|(|2*a+n*r-r|)>|2>>,<with|color|black|mode|math|math-display|true|<frac|2|n<rsup|2>+3*n+2>>
    </unfolded-io-math>
  </session>

  Sums and products with known (i.e., non-symbolic) bounds are translated to
  the appropriate aggregates of Pure list comprehensions so that they can be
  computed directly in Pure:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <big|sum><rsup|5><rsub|k=1><around*|(|2*k-1|)>,<big|prod><rsup|5><rsub|k=1><around*|(|2*k-1|)>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|25>,<with|color|black|mode|math|math-display|true|945>
    </unfolded-io-math>
  </session>

  This is always the case if the entire generator clause is given as a
  subscript and the superscript is absent:

  <\session|pure|math>
    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      <math|<big|sum><rsub|k=1\<ldots\>5><around*|(|2*k-1|)>,<big|prod><rsub|k=1\<ldots\>5><around*|(|2*k-1|)>;>
    <|unfolded-io>
      <with|color|black|mode|math|math-display|true|25>,<with|color|black|mode|math|math-display|true|945>
    </unfolded-io>
  </session>

  Note that the above is equivalent to the following verbatim Pure code:

  <\verbatim-code>
    sum [(2*k-1)\|k=1..5], prod [(2*k-1)\|k=1..5];
  </verbatim-code>

  The same holds for a number of other big operators, such as the big wedge
  and vee, which have no counterpart in Reduce. These aren't predefined in
  Pure either, but we can implement some useful Pure operations with them,
  for instance:

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      bigwedge=foldl <around*|(|\<wedge\>|)> true;bigvee=foldl
      <around*|(|\<vee\>|)> false;
    </input-math>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      <math|<around*|\<nobracket\>|<big|wedge><rsub|k=1><rsup|n><around*|(|x<rsub|k-1>\<geqslant\>0|)>,<big|vee><rsub|k=1><rsup|n><around*|(|x<rsub|k-1>\<less\>0|)>|\<nobracket\>>
      <math-bf|when> x=-3\<ldots\>3; n=#x <math-bf|end>;>
    <|unfolded-io>
      <with|color|black|mode|math|math-display|true|0>,<with|color|black|mode|math|math-display|true|1>
    </unfolded-io>
  </session>

  <subsection|Differentials and integrals>

  Both differentials and integrals can be specified using customary
  mathematical notation which gets translated to invocations of the Reduce
  <verbatim|df> and <verbatim|int> operators (the latter is actually named
  <verbatim|intg> in Pure, to avoid a name clash with the built-in Pure
  function <verbatim|int>). They are constructed according to the following
  syntactical rules:

  <\itemize>
    <item>The differential operator is written as <math|d*x>, which may be
    denoted either as a function application (with a space between <math|d>
    and <math|x>) or as a product with an (invisible) multiplication sign
    <verbatim|*> between <math|d> and <math|x>. Instead of <math|d>, you can
    also use the upright d symbol (<verbatim|\\mathd> or <verbatim|d>
    <key|Tab Tab> in math input mode), in which case no delimiter between d
    and <math|x> is needed. In the case of differentials you may also use the
    partial symbol <math|\<partial\>> (<verbatim|\\partial> or <verbatim|d>
    <key|Tab Tab Tab>) instead.

    <item>Integrals take the form <math|<big|int>f*\<mathd\>*x>
    (<verbatim|\\big int> or <key|Shift+F5 I>) with the appropriate
    delimiters between <math|f>, <math|\<mathd\>> and <math|x> (either
    invisible multiplication signs or spaces; again these may be omitted if
    the special upright d symbol is used).

    <item>Differentials are written as a quotient
    <math|\<mathd\>f/\<mathd\>x>, using either the <verbatim|/> operator or
    an explicit fraction (<verbatim|\\frac> or <key|Alt+F>).<\footnote>
      Note that in the former case the denominator <math|\<mathd\>*x> has to
      be parenthesized if it is written in multiplicative form. This is
      because the multiplication operators including <verbatim|*> and
      <verbatim|/> are left-associative in Pure, so <verbatim|d*f/d*x> will
      be parsed as <verbatim|((d*f)/d)*x> rather than <verbatim|(d*f)/(d*x)>.
      This pitfall can be avoided by just using an explicit fraction instead.
    </footnote> Higher-order differentials may be denoted either as an
    application <math|\<mathd\> k f/\<mathd\> x k> or with a superscript
    <math|\<mathd\><rsup|k>f/\<mathd\>x<rsup|k>>. In either case, multiple
    differentiation variables can be given as a product of the corresponding
    differential terms in the denominator, such as
    <math|\<partial\><rsup|2>f/<around*|(|\<partial\>x*\<partial\>y|)>>.
    Moreover, the notation <math|\<mathd\>/\<mathd\>x*f> (with a
    multiplication sign between <math|\<mathd\>/\<mathd\>x*> and <math|f>) is
    provided as an alternative to <math|\<mathd\>f/\<mathd\>x>.

    <item>Note that if <math|f> or <math|x> are compound expressions, you may
    have to put them in parentheses according to the rules of Pure syntax.
    (If multiplication signs are used as delimiters and both <math|f> and
    <math|x> are either symbols or function applications, this is usually
    unnecessary since these bind stronger than both multiplication and
    exponents.)
  </itemize>

  Of course, in either case you may also just write the corresponding
  Pure/Reduce call, which is often easier to type, but doesn't nearly look as
  nice and mathematical. It is also instructive to take a look at how Reduce
  itself renders calls to <verbatim|intg> and <verbatim|df>; you can always
  copy such output to the input line again and it should just work. Here are
  some examples.

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      let declare<space|1spc>depend <around*|[|f,x|]>;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      df f x 2, intg f x;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<frac|\<partial\><rsup|2>*f|\<partial\>*x<rsup|2>>>,<with|color|black|mode|math|math-display|true|<big|int>f*<space|0.25spc>d*<space|0.25spc>x>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      \<partial\><rsup|2>*f/\<partial\>x<rsup|2>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<frac|\<partial\><rsup|2>*f|\<partial\>*x<rsup|2>>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <big|int>2*f<around*|(|x|)>\<mathd\>x;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|2*<big|int>f<around*|(|x|)>*<space|0.25spc>d*<space|0.25spc>x>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <big|int>2*f<around*|(|x|)>\<mathd\> <around*|(|cos x|)>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|2*cos
      <around*|(|x|)>*f<around*|(|x|)>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      \<mathd\><rsup|2><around*|(|x<rsup|3>|)>/\<mathd\>x<rsup|2>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|6*x>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <frac|\<partial\><rsup|9><around*|(|x<rsup|2>*y<rsup|3>*z<rsup|4>|)>|\<partial\>x<rsup|2>*\<partial\>y<rsup|3>*\<partial\>z<rsup|4>>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|288>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      \<mathd\>/\<mathd\>x*<around*|(|x+y|)><rsup|5>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|5*<around*|(|x<rsup|4>+4*x<rsup|3>*y+6*x<rsup|2>*y<rsup|2>+4*x*y<rsup|3>+y<rsup|4>|)>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      \<mathd\>/\<mathd\>x*<around*|(|sin<around*|(|x|)>*cos<around*|(|x|)>|)>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|cos
      <around*|(|x|)><rsup|2>-sin <around*|(|x|)><rsup|2>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <big|int>sin<around*|(|2*x|)>\<mathd\>x;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<frac|-cos
      <around*|(|2*x|)>|2>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <around*|\<nobracket\>|<big|int>x<rsup|2>*<around|(|a*x+b|)><rsup|n>\<mathd\>x|\<nobracket\>>
      <math-bf|when> b=0 <math-bf|end>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<frac|x<rsup|n>*a<rsup|n>*x<rsup|3>|n+3>>
    </unfolded-io-math>
  </session>

  It is often convenient to abbreviate parametric Reduce expressions using
  Pure functions. We'll learn about different ways to enter Pure functions in
  math mode below, but for the moment it suffices to know that the simplest
  form is just <math|f <space|0.2spc>x<rsub|1><space|0.2spc>\<cdots\><space|0.2spc>x<rsub|n>=<math-it|rhs>>
  where <math|f> is the name of the function,
  <math|x<rsub|1>,\<ldots\>,x<rsub|n>> are the parameters and <em|rhs> is the
  right-hand side (the body) of the definition. Note the missing parentheses
  around the parameters. Pure uses the curried notation for function
  applications where the parameters simply follow the function, similar to
  shell command syntax. For compatibility with Reduce, function calls in
  <em|Reduce> expressions can also be specified in the usual uncurried form
  <math|f<around*|(|x<rsub|1>,\<ldots\>,x<rsub|n>|)>>, but Pure definitions
  and expressions generally use the curried form. For instance:

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      I<space|1spc>a<space|1spc>b<space|1spc>n=?<big|int>x<rsup|2>*<around|(|a*x+b|)><rsup|n>\<mathd\>x;
    </input-math>
  </session>

  Note that we employed the <verbatim|?> operator here so that the
  <verbatim|I> function produces a simplified result rather than just a
  literal integral which then needs to be computed when pretty-printed.

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      I a b n;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<frac|<around*|(|a*x+b|)><rsup|n>*<around*|(|a<rsup|3>*n<rsup|2>*x<rsup|3>+3*a<rsup|3>*n*x<rsup|3>+2*a<rsup|3>*x<rsup|3>+a<rsup|2>*b*n<rsup|2>*x<rsup|2>+a<rsup|2>*b*n*x<rsup|2>-2*a*b<rsup|2>*n*x+2*b<rsup|3>|)>|a<rsup|3>*<around*|(|n<rsup|3>+6*n<rsup|2>+<with|math-font-family|rm|11>*n+6|)>>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      I a b 0;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<frac|x<rsup|3>|3>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      I 0 b n;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<frac|b<rsup|n>*x<rsup|3>|3>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      I a 0 k;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<frac|x<rsup|k>*a<rsup|k>*x<rsup|3>|k+3>>
    </unfolded-io-math>
  </session>

  <subsection|Programming>

  We've already seen various simple kinds of Pure programs (i.e., function
  definitions) throughout this section. One important thing to note here is
  that all supported math elements not only work in expressions to be
  evaluated, but also when defining functions, on <em|both> sides of the
  definition. We can make good use of this to make Pure code look like real
  mathematical formulas. For instance, let's define a prettier notation for
  the list slicing operator (<verbatim|!!> in Pure). We'd actually like to
  write an ordinary index in math mode, like this:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <around*|(|<math-it|xs>|)><rsub|1\<ldots\>n>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|math-font-family|rm|xs>!(<with|color|black|mode|math|math-display|true|1>..<with|color|black|mode|math|math-display|true|n>)
    </unfolded-io-math>
  </session>

  As you can see, this kind of expression isn't readily defined in Pure, so
  we can do it ourselves:

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      <around*|(|<math-it|xs>\<colons\>list|)><rsub|<math-it|ys>\<colons\>list>=<math-it|xs>!!<math-it|ys>;
    </input-math>
  </session>

  That's it. Now we can write:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <around*|(|"a"\<ldots\>"z"|)><rsub|10\<ldots\>16>;
    <|unfolded-io-math>
      ["k","l","m","n","o","p","q"]
    </unfolded-io-math>

    <\input-math>
      \<gtr\>\ 
    <|input-math>
      <math-bf|let> P=sieve (2\<ldots\>\<infty\>)
      <math-bf|with><space|1spc>sieve(p:<math-it|qs>) = p :sieve[q<mid|\|>q =
      <math-it|qs>; q <math-ss|mod> p] & <math-bf|end>;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      P<rsub|99\<ldots\>117>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|<with|math-font-family|rm|541><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|547><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|557><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|563><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|569><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|571><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|577><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|587><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|593><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|599><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|601><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|607><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|613><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|617><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|619><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>|\<nobracket\>>>

      <with|color|black|mode|math|math-display|true|<around*|\<nobracket\>|631<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|641><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|643><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|647>|]>>
    </unfolded-io-math>
  </session>

  Let's consider another example, the binomials:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <binom|n|k>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<math-up|binom><around*|(|n,k|)>>
    </unfolded-io-math>
  </session>

  This function isn't predefined in Pure either, so let's do that now. To get
  nicely aligned equations, we'll use an equation array this time. This is
  available as <verbatim|\\eqnarray> in math mode; similarly, the binomials
  can be entered with <verbatim|\\binom> in math mode:

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      <\eqnarray*>
        <tformat|<table|<row|<cell|<binom|n\<colons\>int|k\<colons\>int>>|<cell|=>|<cell|<binom|n-1|k-1>+<binom|n-1|k><space|1spc><math-bf|if><space|1spc>n\<gtr\>k\<wedge\>k\<gtr\>0;>>|<row|<cell|>|<cell|=>|<cell|1<space|1spc><math-bf|otherwise>;>>>>
      </eqnarray*>
    </input-math>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      show binom
    <|unfolded-io>
      binom n::int k::int = binom (n-1) (k-1)+binom (n-1) k if
      n\<gtr\>k&&k\<gtr\>0;

      binom n::int k::int = 1;
    </unfolded-io>
  </session>

  Let's calculate the first five rows of the Pascal triangle to see that it
  works:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <around*|[|<around*|[|<binom|n|k><mid|\|>k=0\<ldots\>n|]><mid|\|>n=0\<ldots\>5|]>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|<around*|[|1|]><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><around*|[|1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1|]><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><around*|[|1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>2<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1|]><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><around*|[|1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>3<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>3<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1|]><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><around*|[|1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>4<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>6<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>4<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1|]><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><around*|[|1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>5<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|10><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|10><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>5<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1|]>|]>>
    </unfolded-io-math>
  </session>

  Of course, the text book formula we used above isn't the best way to
  implement binomials. The following algorithm employing factorials is much
  faster; it also uses bigints to prevent wrapover.

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      clear binom<text|<verbatim|>>
    </input-math>

    <\input-math>
      \<gtr\>\ 
    <|input-math>
      <binom|n\<colons\>int|k\<colons\>int>=<around*|(|<big|prod><rsub|i=k+1<math-up|L>><rsup|n>i|)>
      div<around*|(|<big|prod><rsub|i=1<math-up|L>><rsup|n-k>i|)>;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <binom|30|14>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|145422675>
    </unfolded-io-math>
  </session>

  As we already saw in the prime sieve example, Pure can deal with \Plazy\Q
  lists (called <em|streams> in functional programming parlance) just fine.
  So let's be bold and just define the infinite stream of <em|all> rows of
  the Pascal triangle. This is easily done with a nested list comprehension
  in Pure:

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      binomials =<around*|[|<around*|[|<binom|n|k><mid|\|>k=0\<ldots\>n|]><mid|\|>n=0\<ldots\>\<infty\>|]>;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      binomials; binomials<rsub|0\<ldots\>5>; binomials<rsub|30>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|1|]>>:#\<less\>thunk
      0x7ff6b44e0ef0\<gtr\>

      <with|color|black|mode|math|math-display|true|<around*|[|<around*|[|1|]><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><around*|[|1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1|]><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><around*|[|1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>2<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1|]><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><around*|[|1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>3<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>3<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1|]><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><around*|[|1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>4<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>6<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>4<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1|]><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><around*|[|1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>5<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|10><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|10><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>5<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1|]>|]>>

      <with|color|black|mode|math|math-display|true|<around*|[|1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|30><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|435><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|4060><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|27405><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|142506><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|593775><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|2035800><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|5852925><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|14307150><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>|\<nobracket\>>>

      <with|color|black|mode|math|math-display|true|30045015<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|54627300><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|86493225><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|119759850><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|145422675><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|155117520><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|145422675><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>>

      <with|color|black|mode|math|math-display|true|119759850<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|86493225><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|54627300><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|30045015><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|14307150><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|5852925><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|2035800><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|593775><space|0.25spc><space|0.25spc>>

      <with|color|black|mode|math|math-display|true|<around*|\<nobracket\>|<with|math-font-family|rm|,<space|0.25spc>>142506<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|27405><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|4060><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|435><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|30><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1|]>>
    </unfolded-io-math>
  </session>

  Sometimes we may want to align subterms in expressions or definitions, in
  order to improve the readability of a formula. <TeXmacs> provides the
  <samp|stack> construct for this purpose, which arranges stuff in rows and
  columns pretty much like a matrix. The Pure converter simply traverses this
  construct in row-major order. Thus the \ <math|<stack|<tformat|<table|<row|<cell|x>|<cell|y>>|<row|<cell|z>|<cell|t>>>>>>
  stack will expand to just <verbatim|x y z t> in Pure. This can be used, in
  particular, to align the parts of an equation or comprehension. For
  instance:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <around*|[|<binom|n|k><mid|\|><stack|<tformat|<cwith|1|-1|3|3|cell-halign|l>|<table|<row|<cell|n>|<cell|=>|<cell|0\<ldots\>5;>>|<row|<cell|k>|<cell|=>|<cell|0\<ldots\>n>>>>>|]>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>2<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>3<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>3<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>4<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>6<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>4<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>5<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|10><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|10><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>5<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1|]>>
    </unfolded-io-math>
  </session>

  Note that the above produces exactly the same result as the following
  linear notation:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <around*|[|<binom|n|k><mid|\|>n=0\<ldots\>5;k=0\<ldots\>n|]>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|[|1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>2<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>3<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>3<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>4<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>6<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>4<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>5<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|10><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc><with|math-font-family|rm|10><space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>5<space|0.25spc><with|math-font-family|rm|,<space|0.25spc>><space|0.25spc>1|]>>
    </unfolded-io-math>
  </session>

  Moreover, the <TeXmacs> <samp|choice> construct can be used to write Pure
  function definitions involving guards in a compact and pretty way. For
  instance, here's another definition of the factorial, this time entered in
  math mode:<\footnote>
    Note that the <strong|if> keyword is mandatory here, as it is required by
    the Pure syntax (as are the semicolons). The <strong|otherwise> keyword
    is just syntactic sugar, however, although it often improves readability.
  </footnote>

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      fact<around*|(|n|)> = <choice|<tformat|<table|<row|<cell|1>|<cell|<math-bf|if
      >n\<leqslant\>0>>|<row|<cell|n\<times\>fact<around*|(|n-1|)>>|<cell|<math-bf|otherwise>>>>>>;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      map fact <around*|(|0\<ldots\>12|)>;
    <|unfolded-io-math>
      [<with|color|black|mode|math|math-display|true|1>,<with|color|black|mode|math|math-display|true|1>,<with|color|black|mode|math|math-display|true|2>,<with|color|black|mode|math|math-display|true|6>,<with|color|black|mode|math|math-display|true|24>,<with|color|black|mode|math|math-display|true|120>,<with|color|black|mode|math|math-display|true|720>,<with|color|black|mode|math|math-display|true|5040>,<with|color|black|mode|math|math-display|true|40320>,<with|color|black|mode|math|math-display|true|362880>,<with|color|black|mode|math|math-display|true|3628800>,<with|color|black|mode|math|math-display|true|39916800>,479001600]
    </unfolded-io-math>
  </session>

  The above definition is in fact equivalent to the following verbatim Pure
  code (which isn't all that unreadable either, as Pure's function definition
  syntax already mimics mathematical notation very closely):

  <\verbatim-code>
    fact(n) = 1 if n\<less\>=0; = n*fact(n-1) otherwise;
  </verbatim-code>

  Of course, the same construct can also be used to define local functions:

  <\session|pure|math>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      map fact <around*|(|0\<ldots\>12|)><space|1spc><math-bf|with><space|1spc>fact<around*|(|n|)>
      = <choice|<tformat|<table|<row|<cell|1>|<cell|<math-bf|if
      >n\<leqslant\>0>>|<row|<cell|n\<times\>fact<around*|(|n-1|)>>|<cell|<math-bf|otherwise>>>>>><math-bf|end>;
    <|unfolded-io-math>
      [<with|color|black|mode|math|math-display|true|1>,<with|color|black|mode|math|math-display|true|1>,<with|color|black|mode|math|math-display|true|2>,<with|color|black|mode|math|math-display|true|6>,<with|color|black|mode|math|math-display|true|24>,<with|color|black|mode|math|math-display|true|120>,<with|color|black|mode|math|math-display|true|720>,<with|color|black|mode|math|math-display|true|5040>,<with|color|black|mode|math|math-display|true|40320>,<with|color|black|mode|math|math-display|true|362880>,<with|color|black|mode|math|math-display|true|3628800>,<with|color|black|mode|math|math-display|true|39916800>,479001600]
    </unfolded-io-math>
  </session>

  Last but not least, the <samp|choice> construct can also be used with
  Pure's pattern-matching <verbatim|case> expressions. Note that the closing
  <verbatim|end> of the <verbatim|case> expression is omitted, the
  <samp|choice> construct supplies it automatically.

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      <around*|\||<math-it|xs>\<colons\>list|\|>=<math-bf|case>
      <math-it|xs><space|0.8spc><math-bf|of><space|0.8spc><choice|<tformat|<table|<row|<cell|<around*|[|
      |]>>|<cell|=>|<cell|0>|<cell|>>|<row|<cell|x:<math-it|xs>>|<cell|=>|<cell|1+<around*|\||<math-it|xs>|\|>>|<cell|<math-bf|otherwise>>>>>>;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <around*|\||1:3\<ldots\>100|\|>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|50>
    </unfolded-io-math>
  </session>

  This defines <math|<around*|\||<math-it|xs>|\|>> (a.k.a. <verbatim|abs xs>
  in Pure notation) to compute the size of a list <em|xs> (similar to what
  Pure's <verbatim|#> operator does). For instance, let's count the number of
  primes up to 5000 (this may take a little while; alas, our definition of
  the prime sieve isn't very efficient!):

  <\session|pure|math>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      <math-bf|let> P=sieve (2\<ldots\>\<infty\>)
      <math-bf|with><space|1spc>sieve(p:<math-it|qs>) = p :sieve[q<mid|\|>q =
      <math-it|qs>; q <math-ss|mod> p] & <math-bf|end>;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <around*|\||takewhile <around*|(|\<leqslant\>5000|)> P|\|>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|669>
    </unfolded-io-math>
  </session>

  <subsection|Caveats>

  <TeXmacs> doesn't know anything about Pure syntax; as far as it is
  concerned, Pure's functions, operators and keywords are just text. So there
  are situations in which you may have to help the converter along by adding
  parentheses to disambiguate the parsing. This is true, in particular, for
  big operators (integrals, sums, etc., especially in conjunction with Pure
  <verbatim|with> and <verbatim|when> clauses) and differentials. Even an
  invisible bracket (shortcut: <key|( Space>) will be good enough. For
  instance:

  <\session|pure|caveats>
    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      let math;
    <|unfolded-io>
      Reduce (Free CSL version), 03-Nov-12 ...
    </unfolded-io>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      \<mathd\>x<rsup|2>/\<mathd\>x;
    <|unfolded-io-math>
      \;

      *** d declared operator\ 

      <with|color|black|mode|math|math-display|true|d<around*|(|x|)>>
    </unfolded-io-math>
  </session>

  Note the missing bracket around <math|x<rsup|2>>. As <verbatim|verb>
  reveals, this yields <verbatim|(d x)^2> instead of <verbatim|d (x^2)>
  (which is what we want):

  <\session|pure|caveats>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      verb ans;
    <|unfolded-io-math>
      d x^2/d x
    </unfolded-io-math>
  </session>

  The remedy is to just parenthesize the <math|x<rsup|2>> term:

  <\session|pure|caveats>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      \<mathd\><around*|\<nobracket\>|<around*|(|x<rsup|2>|)>|\<nobracket\>>/\<mathd\>x;<text|
      // use parentheses around <math|x<rsup|2>> to disambiguate>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|2*x>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      \<mathd\><around*|\<nobracket\>|x<rsup|2>|\<nobracket\>>/\<mathd\>x;<text|
      // even an invisible bracket around <math|x<rsup|2>> does the trick>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|2*x>
    </unfolded-io-math>
  </session>

  Here's another snippet which produces a strange error:

  <\session|pure|caveats>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <big|sum><rsub|k=1\<ldots\>n><around*|(|2*k-1|)>,<big|prod><rsub|k=1\<ldots\>n><around*|(|2*k-1|)>
      <math-bf|when >n = 5<math-bf| end>;
    <|unfolded-io-math>
      <\errput>
        \<less\>stdin\<gtr\>, line 6: syntax error, unexpected '\|',
        expecting end
      </errput>
    </unfolded-io-math>
  </session>

  The tuple (comma operator) binds stronger than the <verbatim|when> clause,
  so this looks like valid Pure syntax. What went wrong? Unfortunately, we
  can't use <verbatim|verb> to reveal how Pure parsed the expression here,
  because it couldn't! But there's a neat trick to show us what exactly
  <TeXmacs> fed into the Pure interpreter: just copy and paste the entire
  expression to another input line operated in verbatim input mode. We get:

  <\session|pure|dummy>
    <\input>
      \<gtr\>\ 
    <|input>
      sum [(2*k-1)\|k=1..n],prod [(2*k-1) when n \|k=1..n]= 5 end;
    </input>
  </session>

  Note that for <TeXmacs> the \P<math|<around*|(|2*k-1|)> <math-bf|when >n>\Q
  part looks like any other ordinary term belonging under the product on the
  right, which is followed by an equals sign and another term
  \P<math|5<math-bf| end>>\Q. This makes perfect sense for <TeXmacs>, but
  it's not valid Pure syntax. This wouldn't normally be a problem (Pure would
  be able to reparse the expression correctly anyway), if it wasn't for the
  <math|<big|prod>>operator which translates to a Pure list comprehension. So
  the \P<math|<around*|(|2*k-1|)> <math-bf|when >n>\Q part ended up in this
  list comprehension where it doesn't belong, hence the somewhat surprising
  syntax error.

  Placing brackets around either the entire tuple or just the product on the
  right correctly resolves the ambiguity. In this case, we might as well use
  visible parentheses, since they make the expression easier to parse for
  human readers, too:

  <\session|pure|caveats>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <around*|(|<big|sum><rsub|k=1\<ldots\>n><around*|(|2*k-1|)>,<big|prod><rsub|k=1\<ldots\>n><around*|(|2*k-1|)>|)>
      <math-bf|when >n = 5<math-bf| end>;
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|25>,<with|color|black|mode|math|math-display|true|945>
    </unfolded-io-math>
  </session>

  We can copy/paste the modified expression to a verbatim input line again,
  to confirm that it was converted correctly this time:

  <\session|pure|dummy>
    <\input>
      \<gtr\>\ 
    <|input>
      (sum [(2*k-1)\|k=1..n],prod [(2*k-1)\|k=1..n]) when n = 5 end;
    </input>
  </session>

  <section|Pure and Octave>

  It's also possible to call Octave from Pure in order to do numeric
  calculations, and use the math output mode to handle the pretty-printing
  via Reduce. To do this, you also need to have the <verbatim|pure-octave>
  package installed. For instance:

  <\session|pure|octave>
    <\output>
      \;

      \ __ \\ \ \| \ \ \| \ __\| _ \\ \ \ \ Pure 0.56
      (x86_64-unknown-linux-gnu)

      \ \| \ \ \| \| \ \ \| \| \ \ \ __/ \ \ \ Copyright (c) 2008-2012 by
      Albert Graef

      \ .__/ \\__,_\|_\| \ \\___\| \ \ \ (Type 'help' for help, 'help
      copying'

      _\| \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ for license
      information.)

      \;

      Loaded prelude from /usr/lib/pure/prelude.pure.

      \;
    </output>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      using octave; let math;
    <|unfolded-io>
      Reduce (Free CSL version), 03-Nov-12 ...
    </unfolded-io>

    <\input-math>
      \<gtr\>\ 
    <|input-math>
      <\eqnarray>
        <tformat|<table|<row|<cell|eig x>|<cell|=>|<cell|octave_call "eig"
        1<space|1spc><around*|(|dmatrix x|)>;>>|<row|<cell|eig2<space|1spc>x>|<cell|=>|<cell|octave_call
        "eig" 2<space|1spc><around*|(|dmatrix x|)>;>>>>
      </eqnarray>
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      eig <matrix|<tformat|<table|<row|<cell|1>|<cell|2>>|<row|<cell|3>|<cell|4>>>>>;<text|
      // eigenvalues only>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|(|<tabular*|<tformat|<table|<row|<cell|-0.372281323269>>|<row|<cell|5.37228132327>>>>>|)>>
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      eig2 <matrix|<tformat|<table|<row|<cell|1>|<cell|2>>|<row|<cell|3>|<cell|4>>>>>;<text|//
      eigenvectors and diagonalized matrix>
    <|unfolded-io-math>
      <with|color|black|mode|math|math-display|true|<around*|(|<tabular*|<tformat|<table|<row|<cell|-0.824564840132>|<cell|-0.415973557919>>|<row|<cell|0.565767464969>|<cell|-0.909376709132>>>>>|)>>,<with|color|black|mode|math|math-display|true|<around*|(|<tabular*|<tformat|<table|<row|<cell|-0.372281323269>|<cell|0>>|<row|<cell|0>|<cell|5.37228132327>>>>>|)>>
    </unfolded-io-math>
  </session>

  It goes without saying that this is pretty useful if a problem calls for a
  mix of symbolic and numeric algorithms. It's also possible to call back
  into Pure from Octave, and thereby into Reduce. To do this, you need to
  wrap up the computation as a Pure function which in turn uses <verbatim|?>
  or <verbatim|?:> to invoke Reduce. Just to illustrate how this works,
  here's a (somewhat contrived) example where we call the Reduce transpose
  function <verbatim|tp> from Octave:

  <\session|pure|octave>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      tp x\<colons\>matrix=?tp<around*|(|x|)>;
    </input-math>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      octave_call "pure_call" 1 ("tp",{1,2;3,4});
    <|unfolded-io>
      <with|color|black|mode|math|math-display|true|<around*|(|<tabular*|<tformat|<table|<row|<cell|1>|<cell|3>>|<row|<cell|2>|<cell|4>>>>>|)>>
    </unfolded-io>

    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      let octave_eval "pure_call('tp',[1 2;3 4])"; // Octave output!
    <|unfolded-io>
      ans =

      \;

      \ \ \ 1 \ \ 3

      \ \ \ 2 \ \ 4
    </unfolded-io>
  </session>

  In a similar fashion you might, e.g., have Octave call Pure to solve an
  equation which Octave itself can't handle.

  With the <verbatim|gnuplot.pure> module included in the latest version of
  the <verbatim|pure-octave> package, you can also make good use of Octave's
  Gnuplot interface. There's a convenience function named <verbatim|psplot>
  in the <verbatim|texmacs> module which grabs an Octave plot in PostScript
  format and pipes it into <TeXmacs> so that it gets inserted directly into
  the session output. (The <verbatim|psplot> function is in fact just a
  little wrapper around the Octave <verbatim|print> function and the
  <verbatim|ps> function from the <verbatim|texmacs> module described in the
  following section.)

  For instance, here's how to do a basic function plot. We have to import the
  <verbatim|gnuplot> module and, since we're doing all calculations in Pure
  here, we also need the <verbatim|math> module for the <verbatim|sin> and
  <verbatim|cos> functions. Also note that the Octave plotting functions are
  all in their own <verbatim|gnuplot> namespace, so for convenience we import
  this namespace. The <verbatim|gnuplot> module also provides various utility
  functions such as <verbatim|linspace> which we use here to generate a
  vector of <math|x> values for the plot.

  <\session|pure|octave>
    <\input-math>
      \<gtr\>\ 
    <|input-math>
      <math-bf|using> gnuplot,math;<math-bf|using namespace> gnuplot;
    </input-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <math-bf|let> x=linspace<around*|(|0,4*\<pi\>|)>;<math-bf|let>
      fig1=plot<around*|(|x,map sin x,x,map cos x|)>;axis "tight";
    <|unfolded-io-math>
      ()
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      psplot<around*|(||)>;
    <|unfolded-io-math>
      <image|<tuple|<#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>|ps>||||>

      "/tmp/oct-7P9aFt.eps"
    </unfolded-io-math>
  </session>

  As you can see, the <verbatim|psplot> function also returns the name of the
  PostScript file it generated, which is a temporary file by default. It's
  also possible to explicitly specify a filename and other options understood
  by the <verbatim|gnuplot::print> command. For instance:

  <\session|pure|octave>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      <math-bf|let> fig2=sombrero<around*|(||)>;psplot "sombrero.eps";
    <|unfolded-io-math>
      <image|<tuple|<#252150532D41646F62652D322E3020455053462D322E300A25255469746C653A20736F6D627265726F2E6570730A252543726561746F723A20676E75706C6F7420342E362070617463686C6576656C20310A25254372656174696F6E446174653A20536174204E6F762031302032333A30303A323620323031320A2525446F63756D656E74466F6E74733A20286174656E64290A2525426F756E64696E67426F783A20353020353020343130203238390A2525456E64436F6D6D656E74730A2525426567696E50726F6C6F670A2F676E7564696374203235362064696374206465660A676E756469637420626567696E0A250A252054686520666F6C6C6F77696E6720747275652F66616C736520666C616773206D6179206265206564697465642062792068616E6420696620646573697265642E0A252054686520756E6974206C696E6520776964746820616E6420677261797363616C6520696D6167652067616D6D6120636F7272656374696F6E206D617920616C736F206265206368616E6765642E0A250A2F436F6C6F722066616C7365206465660A2F426C61636B746578742066616C7365206465660A2F536F6C69642066616C7365206465660A2F446173686C656E6774682031206465660A2F4C616E6473636170652066616C7365206465660A2F4C6576656C312074727565206465660A2F526F756E6465642066616C7365206465660A2F436C6970546F426F756E64696E67426F782066616C7365206465660A2F53757070726573735044464D61726B2066616C7365206465660A2F5472616E73706172656E745061747465726E732066616C7365206465660A2F676E756C696E65776964746820352E303030206465660A2F757365726C696E65776964746820676E756C696E657769647468206465660A2F47616D6D6120312E30206465660A2F4261636B67726F756E64436F6C6F72207B2D312E303030202D312E303030202D312E3030307D206465660A250A2F767368696674202D3636206465660A2F646C31207B0A202031302E3020446173686C656E677468206D756C206D756C0A2020526F756E646564207B2063757272656E746C696E65776964746820302E3735206D756C20737562206475702030206C65207B20706F7020302E3031207D206966207D2069660A7D206465660A2F646C32207B0A202031302E3020446173686C656E677468206D756C206D756C0A2020526F756E646564207B2063757272656E746C696E65776964746820302E3735206D756C20616464207D2069660A7D206465660A2F6870745F2033312E35206465660A2F7670745F2033312E35206465660A2F687074206870745F206465660A2F767074207670745F206465660A2F646F636C6970207B0A2020436C6970546F426F756E64696E67426F78207B0A202020206E657770617468203530203530206D6F7665746F20343130203530206C696E65746F2034313020323839206C696E65746F20353020323839206C696E65746F20636C6F7365706174680A20202020636C69700A20207D2069660A7D206465660A250A2520476E75706C6F742050726F6C6F672056657273696F6E20342E36202853657074656D6265722032303132290A250A252F53757070726573735044464D61726B2074727565206465660A250A2F4D207B6D6F7665746F7D2062696E64206465660A2F4C207B6C696E65746F7D2062696E64206465660A2F52207B726D6F7665746F7D2062696E64206465660A2F56207B726C696E65746F7D2062696E64206465660A2F4E207B6E657770617468206D6F7665746F7D2062696E64206465660A2F5A207B636C6F7365706174687D2062696E64206465660A2F43207B736574726762636F6C6F727D2062696E64206465660A2F66207B726C696E65746F2066696C6C7D2062696E64206465660A2F67207B736574677261797D2062696E64206465660A2F4773686F77207B73686F777D2064656620202025204D6179206265207265646566696E6564206C6174657220696E207468652066696C6520746F20737570706F7274205554462D380A2F76707432207670742032206D756C206465660A2F68707432206870742032206D756C206465660A2F4C73686F77207B63757272656E74706F696E74207374726F6B65204D2030207673686966742052200A09426C61636B74657874207B6773617665203020736574677261792073686F772067726573746F72657D207B73686F777D206966656C73657D206465660A2F5273686F77207B63757272656E74706F696E74207374726F6B65204D2064757020737472696E67776964746820706F70206E65672076736869667420520A09426C61636B74657874207B6773617665203020736574677261792073686F772067726573746F72657D207B73686F777D206966656C73657D206465660A2F4373686F77207B63757272656E74706F696E74207374726F6B65204D2064757020737472696E67776964746820706F70202D3220646976207673686966742052200A09426C61636B74657874207B6773617665203020736574677261792073686F772067726573746F72657D207B73686F777D206966656C73657D206465660A2F5550207B647570207670745F206D756C202F767074206578636820646566206870745F206D756C202F6870742065786368206465660A20202F68707432206870742032206D756C20646566202F76707432207670742032206D756C206465667D206465660A2F444C207B436F6C6F72207B736574726762636F6C6F7220536F6C6964207B706F70205B5D7D206966203020736574646173687D0A207B706F7020706F7020706F702030207365746772617920536F6C6964207B706F70205B5D7D206966203020736574646173687D206966656C73657D206465660A2F424C207B7374726F6B6520757365726C696E6577696474682032206D756C207365746C696E6577696474680A09526F756E646564207B31207365746C696E656A6F696E2031207365746C696E656361707D2069667D206465660A2F414C207B7374726F6B6520757365726C696E657769647468203220646976207365746C696E6577696474680A09526F756E646564207B31207365746C696E656A6F696E2031207365746C696E656361707D2069667D206465660A2F554C207B64757020676E756C696E657769647468206D756C202F757365726C696E6577696474682065786368206465660A096475702031206C74207B706F7020317D206966203130206D756C202F75646C2065786368206465667D206465660A2F504C207B7374726F6B6520757365726C696E657769647468207365746C696E6577696474680A09526F756E646564207B31207365746C696E656A6F696E2031207365746C696E656361707D2069667D206465660A332E38207365746D697465726C696D69740A252044656661756C74204C696E6520636F6C6F72730A2F4C4377207B31203120317D206465660A2F4C4362207B30203020307D206465660A2F4C4361207B30203020307D206465660A2F4C4330207B31203020307D206465660A2F4C4331207B30203120307D206465660A2F4C4332207B30203020317D206465660A2F4C4333207B31203020317D206465660A2F4C4334207B30203120317D206465660A2F4C4335207B31203120307D206465660A2F4C4336207B30203020307D206465660A2F4C4337207B3120302E3320307D206465660A2F4C4338207B302E3520302E3520302E357D206465660A252044656661756C74204C696E652054797065730A2F4C5477207B504C205B5D203120736574677261797D206465660A2F4C5462207B424C205B5D204C436220444C7D206465660A2F4C5461207B414C205B312075646C206D756C20322075646C206D756C5D20302073657464617368204C436120736574726762636F6C6F727D206465660A2F4C5430207B504C205B5D204C433020444C7D206465660A2F4C5431207B504C205B3420646C31203220646C325D204C433120444C7D206465660A2F4C5432207B504C205B3220646C31203320646C325D204C433220444C7D206465660A2F4C5433207B504C205B3120646C3120312E3520646C325D204C433320444C7D206465660A2F4C5434207B504C205B3620646C31203220646C32203120646C31203220646C325D204C433420444C7D206465660A2F4C5435207B504C205B3320646C31203320646C32203120646C31203320646C325D204C433520444C7D206465660A2F4C5436207B504C205B3220646C31203220646C32203220646C31203620646C325D204C433620444C7D206465660A2F4C5437207B504C205B3120646C31203220646C32203620646C31203220646C32203120646C31203220646C325D204C433720444C7D206465660A2F4C5438207B504C205B3220646C31203220646C32203220646C31203220646C32203220646C31203220646C32203220646C31203420646C325D204C433820444C7D206465660A2F506E74207B7374726F6B65205B5D203020736574646173682067736176652031207365746C696E65636170204D203020302056207374726F6B652067726573746F72657D206465660A2F446961207B7374726F6B65205B5D20302073657464617368203220636F70792076707420616464204D0A2020687074206E656720767074206E656720562068707420767074206E656720560A202068707420767074205620687074206E656720767074205620636C6F736570617468207374726F6B650A2020506E747D206465660A2F506C73207B7374726F6B65205B5D203020736574646173682076707420737562204D2030207670743220560A202063757272656E74706F696E74207374726F6B65204D0A2020687074206E656720767074206E65672052206870743220302056207374726F6B650A207D206465660A2F426F78207B7374726F6B65205B5D20302073657464617368203220636F70792065786368206870742073756220657863682076707420616464204D0A2020302076707432206E656720562068707432203020562030207670743220560A202068707432206E65672030205620636C6F736570617468207374726F6B650A2020506E747D206465660A2F437273207B7374726F6B65205B5D203020736574646173682065786368206870742073756220657863682076707420616464204D0A2020687074322076707432206E656720562063757272656E74706F696E74207374726F6B65204D0A202068707432206E656720302052206870743220767074322056207374726F6B657D206465660A2F54726955207B7374726F6B65205B5D20302073657464617368203220636F70792076707420312E3132206D756C20616464204D0A2020687074206E656720767074202D312E3632206D756C20560A20206870742032206D756C203020560A2020687074206E65672076707420312E3632206D756C205620636C6F736570617468207374726F6B650A2020506E747D206465660A2F53746172207B3220636F707920506C73204372737D206465660A2F426F7846207B7374726F6B65205B5D203020736574646173682065786368206870742073756220657863682076707420616464204D0A2020302076707432206E656720562068707432203020562030207670743220560A202068707432206E65672030205620636C6F7365706174682066696C6C7D206465660A2F5472695546207B7374726F6B65205B5D203020736574646173682076707420312E3132206D756C20616464204D0A2020687074206E656720767074202D312E3632206D756C20560A20206870742032206D756C203020560A2020687074206E65672076707420312E3632206D756C205620636C6F7365706174682066696C6C7D206465660A2F54726944207B7374726F6B65205B5D20302073657464617368203220636F70792076707420312E3132206D756C20737562204D0A2020687074206E65672076707420312E3632206D756C20560A20206870742032206D756C203020560A2020687074206E656720767074202D312E3632206D756C205620636C6F736570617468207374726F6B650A2020506E747D206465660A2F5472694446207B7374726F6B65205B5D203020736574646173682076707420312E3132206D756C20737562204D0A2020687074206E65672076707420312E3632206D756C20560A20206870742032206D756C203020560A2020687074206E656720767074202D312E3632206D756C205620636C6F7365706174682066696C6C7D206465660A2F44696146207B7374726F6B65205B5D203020736574646173682076707420616464204D0A2020687074206E656720767074206E656720562068707420767074206E656720560A202068707420767074205620687074206E656720767074205620636C6F7365706174682066696C6C7D206465660A2F50656E74207B7374726F6B65205B5D20302073657464617368203220636F70792067736176650A20207472616E736C617465203020687074204D2034207B373220726F74617465203020687074204C7D207265706561740A2020636C6F736570617468207374726F6B652067726573746F726520506E747D206465660A2F50656E7446207B7374726F6B65205B5D203020736574646173682067736176650A20207472616E736C617465203020687074204D2034207B373220726F74617465203020687074204C7D207265706561740A2020636C6F7365706174682066696C6C2067726573746F72657D206465660A2F436972636C65207B7374726F6B65205B5D20302073657464617368203220636F70790A202068707420302033363020617263207374726F6B6520506E747D206465660A2F436972636C6546207B7374726F6B65205B5D2030207365746461736820687074203020333630206172632066696C6C7D206465660A2F4330207B424C205B5D20302073657464617368203220636F7079206D6F7665746F2076707420393020343530206172637D2062696E64206465660A2F4331207B424C205B5D20302073657464617368203220636F7079206D6F7665746F0A093220636F70792076707420302039302061726320636C6F7365706174682066696C6C0A097670742030203336302061726320636C6F7365706174687D2062696E64206465660A2F4332207B424C205B5D20302073657464617368203220636F7079206D6F7665746F0A093220636F707920767074203930203138302061726320636C6F7365706174682066696C6C0A097670742030203336302061726320636C6F7365706174687D2062696E64206465660A2F4333207B424C205B5D20302073657464617368203220636F7079206D6F7665746F0A093220636F7079207670742030203138302061726320636C6F7365706174682066696C6C0A097670742030203336302061726320636C6F7365706174687D2062696E64206465660A2F4334207B424C205B5D20302073657464617368203220636F7079206D6F7665746F0A093220636F70792076707420313830203237302061726320636C6F7365706174682066696C6C0A097670742030203336302061726320636C6F7365706174687D2062696E64206465660A2F4335207B424C205B5D20302073657464617368203220636F7079206D6F7665746F0A093220636F7079207670742030203930206172630A093220636F7079206D6F7665746F0A093220636F70792076707420313830203237302061726320636C6F7365706174682066696C6C0A09767074203020333630206172637D2062696E64206465660A2F4336207B424C205B5D20302073657464617368203220636F7079206D6F7665746F0A093220636F707920767074203930203237302061726320636C6F7365706174682066696C6C0A097670742030203336302061726320636C6F7365706174687D2062696E64206465660A2F4337207B424C205B5D20302073657464617368203220636F7079206D6F7665746F0A093220636F7079207670742030203237302061726320636C6F7365706174682066696C6C0A097670742030203336302061726320636C6F7365706174687D2062696E64206465660A2F4338207B424C205B5D20302073657464617368203220636F7079206D6F7665746F0A093220636F70792076707420323730203336302061726320636C6F7365706174682066696C6C0A097670742030203336302061726320636C6F7365706174687D2062696E64206465660A2F4339207B424C205B5D20302073657464617368203220636F7079206D6F7665746F0A093220636F70792076707420323730203435302061726320636C6F7365706174682066696C6C0A097670742030203336302061726320636C6F7365706174687D2062696E64206465660A2F433130207B424C205B5D20302073657464617368203220636F7079203220636F7079206D6F7665746F2076707420323730203336302061726320636C6F7365706174682066696C6C0A093220636F7079206D6F7665746F0A093220636F707920767074203930203138302061726320636C6F7365706174682066696C6C0A097670742030203336302061726320636C6F7365706174687D2062696E64206465660A2F433131207B424C205B5D20302073657464617368203220636F7079206D6F7665746F0A093220636F7079207670742030203138302061726320636C6F7365706174682066696C6C0A093220636F7079206D6F7665746F0A093220636F70792076707420323730203336302061726320636C6F7365706174682066696C6C0A097670742030203336302061726320636C6F7365706174687D2062696E64206465660A2F433132207B424C205B5D20302073657464617368203220636F7079206D6F7665746F0A093220636F70792076707420313830203336302061726320636C6F7365706174682066696C6C0A097670742030203336302061726320636C6F7365706174687D2062696E64206465660A2F433133207B424C205B5D20302073657464617368203220636F7079206D6F7665746F0A093220636F70792076707420302039302061726320636C6F7365706174682066696C6C0A093220636F7079206D6F7665746F0A093220636F70792076707420313830203336302061726320636C6F7365706174682066696C6C0A097670742030203336302061726320636C6F7365706174687D2062696E64206465660A2F433134207B424C205B5D20302073657464617368203220636F7079206D6F7665746F0A093220636F707920767074203930203336302061726320636C6F7365706174682066696C6C0A09767074203020333630206172637D2062696E64206465660A2F433135207B424C205B5D20302073657464617368203220636F7079207670742030203336302061726320636C6F7365706174682066696C6C0A097670742030203336302061726320636C6F7365706174687D2062696E64206465660A2F526563207B6E6577706174682034203220726F6C6C206D6F7665746F203120696E646578203020726C696E65746F2030206578636820726C696E65746F0A096E6567203020726C696E65746F20636C6F7365706174687D2062696E64206465660A2F537175617265207B647570205265637D2062696E64206465660A2F42737175617265207B767074207375622065786368207670742073756220657863682076707432205371756172657D2062696E64206465660A2F5330207B424C205B5D20302073657464617368203220636F7079206D6F7665746F20302076707420726C696E65746F20424C20427371756172657D2062696E64206465660A2F5331207B424C205B5D20302073657464617368203220636F707920767074205371756172652066696C6C20427371756172657D2062696E64206465660A2F5332207B424C205B5D20302073657464617368203220636F707920657863682076707420737562206578636820767074205371756172652066696C6C20427371756172657D2062696E64206465660A2F5333207B424C205B5D20302073657464617368203220636F7079206578636820767074207375622065786368207670743220767074205265632066696C6C20427371756172657D2062696E64206465660A2F5334207B424C205B5D20302073657464617368203220636F7079206578636820767074207375622065786368207670742073756220767074205371756172652066696C6C20427371756172657D2062696E64206465660A2F5335207B424C205B5D20302073657464617368203220636F7079203220636F707920767074205371756172652066696C6C0A096578636820767074207375622065786368207670742073756220767074205371756172652066696C6C20427371756172657D2062696E64206465660A2F5336207B424C205B5D20302073657464617368203220636F70792065786368207670742073756220657863682076707420737562207670742076707432205265632066696C6C20427371756172657D2062696E64206465660A2F5337207B424C205B5D20302073657464617368203220636F70792065786368207670742073756220657863682076707420737562207670742076707432205265632066696C6C0A093220636F707920767074205371756172652066696C6C20427371756172657D2062696E64206465660A2F5338207B424C205B5D20302073657464617368203220636F7079207670742073756220767074205371756172652066696C6C20427371756172657D2062696E64206465660A2F5339207B424C205B5D20302073657464617368203220636F70792076707420737562207670742076707432205265632066696C6C20427371756172657D2062696E64206465660A2F533130207B424C205B5D20302073657464617368203220636F7079207670742073756220767074205371756172652066696C6C203220636F707920657863682076707420737562206578636820767074205371756172652066696C6C0A09427371756172657D2062696E64206465660A2F533131207B424C205B5D20302073657464617368203220636F7079207670742073756220767074205371756172652066696C6C203220636F7079206578636820767074207375622065786368207670743220767074205265632066696C6C0A09427371756172657D2062696E64206465660A2F533132207B424C205B5D20302073657464617368203220636F70792065786368207670742073756220657863682076707420737562207670743220767074205265632066696C6C20427371756172657D2062696E64206465660A2F533133207B424C205B5D20302073657464617368203220636F70792065786368207670742073756220657863682076707420737562207670743220767074205265632066696C6C0A093220636F707920767074205371756172652066696C6C20427371756172657D2062696E64206465660A2F533134207B424C205B5D20302073657464617368203220636F70792065786368207670742073756220657863682076707420737562207670743220767074205265632066696C6C0A093220636F707920657863682076707420737562206578636820767074205371756172652066696C6C20427371756172657D2062696E64206465660A2F533135207B424C205B5D20302073657464617368203220636F707920427371756172652066696C6C20427371756172657D2062696E64206465660A2F4430207B6773617665207472616E736C61746520343520726F7461746520302030205330207374726F6B652067726573746F72657D2062696E64206465660A2F4431207B6773617665207472616E736C61746520343520726F7461746520302030205331207374726F6B652067726573746F72657D2062696E64206465660A2F4432207B6773617665207472616E736C61746520343520726F7461746520302030205332207374726F6B652067726573746F72657D2062696E64206465660A2F4433207B6773617665207472616E736C61746520343520726F7461746520302030205333207374726F6B652067726573746F72657D2062696E64206465660A2F4434207B6773617665207472616E736C61746520343520726F7461746520302030205334207374726F6B652067726573746F72657D2062696E64206465660A2F4435207B6773617665207472616E736C61746520343520726F7461746520302030205335207374726F6B652067726573746F72657D2062696E64206465660A2F4436207B6773617665207472616E736C61746520343520726F7461746520302030205336207374726F6B652067726573746F72657D2062696E64206465660A2F4437207B6773617665207472616E736C61746520343520726F7461746520302030205337207374726F6B652067726573746F72657D2062696E64206465660A2F4438207B6773617665207472616E736C61746520343520726F7461746520302030205338207374726F6B652067726573746F72657D2062696E64206465660A2F4439207B6773617665207472616E736C61746520343520726F7461746520302030205339207374726F6B652067726573746F72657D2062696E64206465660A2F443130207B6773617665207472616E736C61746520343520726F746174652030203020533130207374726F6B652067726573746F72657D2062696E64206465660A2F443131207B6773617665207472616E736C61746520343520726F746174652030203020533131207374726F6B652067726573746F72657D2062696E64206465660A2F443132207B6773617665207472616E736C61746520343520726F746174652030203020533132207374726F6B652067726573746F72657D2062696E64206465660A2F443133207B6773617665207472616E736C61746520343520726F746174652030203020533133207374726F6B652067726573746F72657D2062696E64206465660A2F443134207B6773617665207472616E736C61746520343520726F746174652030203020533134207374726F6B652067726573746F72657D2062696E64206465660A2F443135207B6773617665207472616E736C61746520343520726F746174652030203020533135207374726F6B652067726573746F72657D2062696E64206465660A2F44696145207B7374726F6B65205B5D203020736574646173682076707420616464204D0A2020687074206E656720767074206E656720562068707420767074206E656720560A202068707420767074205620687074206E656720767074205620636C6F736570617468207374726F6B657D206465660A2F426F7845207B7374726F6B65205B5D203020736574646173682065786368206870742073756220657863682076707420616464204D0A2020302076707432206E656720562068707432203020562030207670743220560A202068707432206E65672030205620636C6F736570617468207374726F6B657D206465660A2F5472695545207B7374726F6B65205B5D203020736574646173682076707420312E3132206D756C20616464204D0A2020687074206E656720767074202D312E3632206D756C20560A20206870742032206D756C203020560A2020687074206E65672076707420312E3632206D756C205620636C6F736570617468207374726F6B657D206465660A2F5472694445207B7374726F6B65205B5D203020736574646173682076707420312E3132206D756C20737562204D0A2020687074206E65672076707420312E3632206D756C20560A20206870742032206D756C203020560A2020687074206E656720767074202D312E3632206D756C205620636C6F736570617468207374726F6B657D206465660A2F50656E7445207B7374726F6B65205B5D203020736574646173682067736176650A20207472616E736C617465203020687074204D2034207B373220726F74617465203020687074204C7D207265706561740A2020636C6F736570617468207374726F6B652067726573746F72657D206465660A2F4369726345207B7374726F6B65205B5D20302073657464617368200A202068707420302033363020617263207374726F6B657D206465660A2F4F7061717565207B677361766520636C6F736570617468203120736574677261792066696C6C2067726573746F72652030207365746772617920636C6F7365706174687D206465660A2F44696157207B7374726F6B65205B5D203020736574646173682076707420616464204D0A2020687074206E656720767074206E656720562068707420767074206E656720560A202068707420767074205620687074206E6567207670742056204F7061717565207374726F6B657D206465660A2F426F7857207B7374726F6B65205B5D203020736574646173682065786368206870742073756220657863682076707420616464204D0A2020302076707432206E656720562068707432203020562030207670743220560A202068707432206E656720302056204F7061717565207374726F6B657D206465660A2F5472695557207B7374726F6B65205B5D203020736574646173682076707420312E3132206D756C20616464204D0A2020687074206E656720767074202D312E3632206D756C20560A20206870742032206D756C203020560A2020687074206E65672076707420312E3632206D756C2056204F7061717565207374726F6B657D206465660A2F5472694457207B7374726F6B65205B5D203020736574646173682076707420312E3132206D756C20737562204D0A2020687074206E65672076707420312E3632206D756C20560A20206870742032206D756C203020560A2020687074206E656720767074202D312E3632206D756C2056204F7061717565207374726F6B657D206465660A2F50656E7457207B7374726F6B65205B5D203020736574646173682067736176650A20207472616E736C617465203020687074204D2034207B373220726F74617465203020687074204C7D207265706561740A20204F7061717565207374726F6B652067726573746F72657D206465660A2F4369726357207B7374726F6B65205B5D20302073657464617368200A202068707420302033363020617263204F7061717565207374726F6B657D206465660A2F426F7846696C6C207B677361766520526563203120736574677261792066696C6C2067726573746F72657D206465660A2F44656E73697479207B0A20202F46696C6C64656E2065786368206465660A202063757272656E74726762636F6C6F720A20202F436F6C42206578636820646566202F436F6C47206578636820646566202F436F6C522065786368206465660A20202F436F6C5220436F6C522046696C6C64656E206D756C2046696C6C64656E20737562203120616464206465660A20202F436F6C4720436F6C472046696C6C64656E206D756C2046696C6C64656E20737562203120616464206465660A20202F436F6C4220436F6C422046696C6C64656E206D756C2046696C6C64656E20737562203120616464206465660A2020436F6C5220436F6C4720436F6C4220736574726762636F6C6F727D206465660A2F426F78436F6C46696C6C207B67736176652052656320506F6C7946696C6C7D206465660A2F506F6C7946696C6C207B67736176652044656E736974792066696C6C2067726573746F72652067726573746F72657D206465660A2F68207B726C696E65746F20726C696E65746F20726C696E65746F20677361766520636C6F7365706174682066696C6C2067726573746F72657D2062696E64206465660A250A2520506F7374536372697074204C6576656C2031205061747465726E2046696C6C20726F7574696E6520666F722072656374616E676C65730A252055736167653A207820792077206820732061205858205061747465726E46696C6C0A2509782C79203D206C6F776572206C65667420636F726E6572206F6620626F7820746F2062652066696C6C65640A2509772C68203D20776964746820616E6420686569676874206F6620626F780A2509202061203D20616E676C6520696E2064656772656573206265747765656E206C696E657320616E6420782D617869730A2509205858203D20302F3120666F72206E6F2F7965732063726F73732D68617463680A250A2F5061747465726E46696C6C207B6773617665202F504661205B2039203220726F6C6C205D206465660A20205046612030206765742050466120322067657420322064697620616464205046612031206765742050466120332067657420322064697620616464207472616E736C6174650A2020504661203220676574202D322064697620504661203320676574202D32206469762050466120322067657420504661203320676574205265630A20205472616E73706172656E745061747465726E73207B7D207B6773617665203120736574677261792066696C6C2067726573746F72657D206966656C73650A2020636C69700A202063757272656E746C696E65776964746820302E35206D756C207365746C696E6577696474680A20202F5046732050466120322067657420647570206D756C2050466120332067657420647570206D756C206164642073717274206465660A2020302030204D2050466120352067657420726F7461746520504673202D322064697620647570207472616E736C6174650A202030203120504673205046612034206765742064697620312061646420666C6F6F72206376690A097B504661203420676574206D756C2030204D20302050467320567D20666F720A20203020504661203620676574206E65207B0A0930203120504673205046612034206765742064697620312061646420666C6F6F72206376690A097B504661203420676574206D756C20302032203120726F6C6C204D20504673203020567D20666F720A207D2069660A20207374726F6B652067726573746F72657D206465660A250A2F6C616E67756167656C6576656C2077686572650A207B706F70206C616E67756167656C6576656C7D207B317D206966656C73650A2032206C740A097B2F496E746572707265744C6576656C312074727565206465667D0A097B2F496E746572707265744C6576656C31204C6576656C31206465667D0A206966656C73650A250A2520506F7374536372697074206C6576656C2032207061747465726E2066696C6C20646566696E6974696F6E730A250A2F4C6576656C325061747465726E46696C6C207B0A2F54696C65387838207B2F5061696E74547970652032202F5061747465726E547970652031202F54696C696E67547970652031202F42426F78205B302030203820385D202F58537465702038202F595374657020387D0A0962696E64206465660A2F4B656570436F6C6F72207B63757272656E74726762636F6C6F72205B2F5061747465726E202F4465766963655247425D20736574636F6C6F7273706163657D2062696E64206465660A3C3C2054696C653878380A202F5061696E7450726F63207B302E35207365746C696E65776964746820706F7020302030204D20382038204C20302038204D20382030204C207374726F6B657D200A3E3E206D6174726978206D616B657061747465726E0A2F506174312065786368206465660A3C3C2054696C653878380A202F5061696E7450726F63207B302E35207365746C696E65776964746820706F7020302030204D20382038204C20302038204D20382030204C207374726F6B650A09302034204D20342038204C20382034204C20342030204C20302034204C207374726F6B657D0A3E3E206D6174726978206D616B657061747465726E0A2F506174322065786368206465660A3C3C2054696C653878380A202F5061696E7450726F63207B302E35207365746C696E65776964746820706F7020302030204D20302038204C0A09382038204C20382030204C20302030204C2066696C6C7D0A3E3E206D6174726978206D616B657061747465726E0A2F506174332065786368206465660A3C3C2054696C653878380A202F5061696E7450726F63207B302E35207365746C696E65776964746820706F70202D342038204D2038202D34204C0A0930203132204D2031322030204C207374726F6B657D0A3E3E206D6174726978206D616B657061747465726E0A2F506174342065786368206465660A3C3C2054696C653878380A202F5061696E7450726F63207B302E35207365746C696E65776964746820706F70202D342030204D2038203132204C0A0930202D34204D2031322038204C207374726F6B657D0A3E3E206D6174726978206D616B657061747465726E0A2F506174352065786368206465660A3C3C2054696C653878380A202F5061696E7450726F63207B302E35207365746C696E65776964746820706F70202D322038204D2034202D34204C0A0930203132204D2038202D34204C2034203132204D2031302030204C207374726F6B657D0A3E3E206D6174726978206D616B657061747465726E0A2F506174362065786368206465660A3C3C2054696C653878380A202F5061696E7450726F63207B302E35207365746C696E65776964746820706F70202D322030204D2034203132204C0A0930202D34204D2038203132204C2034202D34204D2031302038204C207374726F6B657D0A3E3E206D6174726978206D616B657061747465726E0A2F506174372065786368206465660A3C3C2054696C653878380A202F5061696E7450726F63207B302E35207365746C696E65776964746820706F702038202D32204D202D342034204C0A0931322030204D202D342038204C2031322034204D2030203130204C207374726F6B657D0A3E3E206D6174726978206D616B657061747465726E0A2F506174382065786368206465660A3C3C2054696C653878380A202F5061696E7450726F63207B302E35207365746C696E65776964746820706F702030202D32204D2031322034204C0A092D342030204D2031322038204C202D342034204D2038203130204C207374726F6B657D0A3E3E206D6174726978206D616B657061747465726E0A2F506174392065786368206465660A2F5061747465726E31207B5061747465726E42676E64204B656570436F6C6F722050617431207365747061747465726E7D2062696E64206465660A2F5061747465726E32207B5061747465726E42676E64204B656570436F6C6F722050617432207365747061747465726E7D2062696E64206465660A2F5061747465726E33207B5061747465726E42676E64204B656570436F6C6F722050617433207365747061747465726E7D2062696E64206465660A2F5061747465726E34207B5061747465726E42676E64204B656570436F6C6F72204C616E647363617065207B506174357D207B506174347D206966656C7365207365747061747465726E7D2062696E64206465660A2F5061747465726E35207B5061747465726E42676E64204B656570436F6C6F72204C616E647363617065207B506174347D207B506174357D206966656C7365207365747061747465726E7D2062696E64206465660A2F5061747465726E36207B5061747465726E42676E64204B656570436F6C6F72204C616E647363617065207B506174397D207B506174367D206966656C7365207365747061747465726E7D2062696E64206465660A2F5061747465726E37207B5061747465726E42676E64204B656570436F6C6F72204C616E647363617065207B506174387D207B506174377D206966656C7365207365747061747465726E7D2062696E64206465660A7D206465660A250A250A25456E64206F6620506F7374536372697074204C6576656C203220636F64650A250A2F5061747465726E42676E64207B0A20205472616E73706172656E745061747465726E73207B7D207B6773617665203120736574677261792066696C6C2067726573746F72657D206966656C73650A7D206465660A250A25205375627374697475746520666F72204C6576656C2032207061747465726E2066696C6C20636F64657320776974680A2520677261797363616C65206966204C6576656C203220737570706F7274206973206E6F742073656C65637465642E0A250A2F4C6576656C315061747465726E46696C6C207B0A2F5061747465726E31207B302E3235302044656E736974797D2062696E64206465660A2F5061747465726E32207B302E3530302044656E736974797D2062696E64206465660A2F5061747465726E33207B302E3735302044656E736974797D2062696E64206465660A2F5061747465726E34207B302E3132352044656E736974797D2062696E64206465660A2F5061747465726E35207B302E3337352044656E736974797D2062696E64206465660A2F5061747465726E36207B302E3632352044656E736974797D2062696E64206465660A2F5061747465726E37207B302E3837352044656E736974797D2062696E64206465660A7D206465660A250A25204E6F77207465737420666F7220737570706F7274206F66204C6576656C203220636F64650A250A4C6576656C31207B4C6576656C315061747465726E46696C6C7D207B4C6576656C325061747465726E46696C6C7D206966656C73650A250A2F53796D626F6C2D4F626C69717565202F53796D626F6C2066696E64666F6E74205B312030202E3136372031203020305D206D616B65666F6E740A647570206C656E677468206469637420626567696E207B3120696E646578202F464944206571207B706F7020706F707D207B6465667D206966656C73657D20666F72616C6C0A63757272656E746469637420656E6420646566696E65666F6E7420706F700A2F4D4673686F77207B0A2020207B2064757020352067657420332067650A20202020207B2035206765742033206571207B67736176657D207B67726573746F72657D206966656C7365207D0A20202020207B647570206475702030206765742066696E64666F6E742065786368203120676574207363616C65666F6E7420736574666F6E740A20202020205B2063757272656E74706F696E74205D206578636820647570203220676574203020657863682052206475702035206765742032206E65207B6475702064757020360A20202020206765742065786368203420676574207B4773686F777D207B737472696E67776964746820706F70203020527D206966656C7365207D69662064757020352067657420302065710A20202020207B647570203320676574207B3220676574206E656720302065786368205220706F707D207B706F7020616C6F616420706F70204D7D206966656C73657D207B64757020350A20202020206765742031206571207B647570203220676574206578636820647570203320676574206578636820362067657420737472696E67776964746820706F70202D32206469760A2020202020647570203020527D207B64757020362067657420737472696E67776964746820706F70202D3220646976203020522036206765740A202020202073686F77203220696E646578207B616C6F616420706F70204D206E65672033202D3120726F6C6C206E6567205220706F7020706F707D207B706F7020706F7020706F700A2020202020706F7020616C6F616420706F70204D7D206966656C7365207D6966656C7365207D6966656C7365207D0A20202020206966656C7365207D0A202020666F72616C6C7D206465660A2F47737769647468207B6475702074797065202F737472696E6774797065206571207B737472696E6777696474687D207B706F7020286E2920737472696E6777696474687D206966656C73657D206465660A2F4D467769647468207B302065786368207B206475702035206765742033206765207B2035206765742033206571207B2030207D207B20706F70207D206966656C7365207D0A207B6475702033206765747B647570206475702030206765742066696E64666F6E742065786368203120676574207363616C65666F6E7420736574666F6E740A20202020203620676574204773776964746820706F70206164647D207B706F707D206966656C73657D206966656C73657D20666F72616C6C7D206465660A2F4D4C73686F77207B2063757272656E74706F696E74207374726F6B65204D0A202030206578636820520A2020426C61636B74657874207B677361766520302073657467726179204D4673686F772067726573746F72657D207B4D4673686F777D206966656C7365207D2062696E64206465660A2F4D5273686F77207B2063757272656E74706F696E74207374726F6B65204D0A20206578636820647570204D467769647468206E65672033202D3120726F6C6C20520A2020426C61636B74657874207B677361766520302073657467726179204D4673686F772067726573746F72657D207B4D4673686F777D206966656C7365207D2062696E64206465660A2F4D4373686F77207B2063757272656E74706F696E74207374726F6B65204D0A20206578636820647570204D467769647468202D32206469762033202D3120726F6C6C20520A2020426C61636B74657874207B677361766520302073657467726179204D4673686F772067726573746F72657D207B4D4673686F777D206966656C7365207D2062696E64206465660A2F585973617665202020207B205B2820292031203220747275652066616C736520332028295D207D2062696E64206465660A2F5859726573746F7265207B205B2820292031203220747275652066616C736520342028295D207D2062696E64206465660A4C6576656C312053757070726573735044464D61726B206F72200A7B7D207B0A2F53446963742031302064696374206465660A73797374656D64696374202F7064666D61726B206B6E6F776E206E6F74207B0A20207573657264696374202F7064666D61726B2073797374656D64696374202F636C656172746F6D61726B20676574207075740A7D2069660A534469637420626567696E205B0A20202F5469746C652028736F6D627265726F2E657073290A20202F5375626A6563742028676E75706C6F7420706C6F74290A20202F43726561746F722028676E75706C6F7420342E362070617463686C6576656C2031290A20202F417574686F7220286167290A2520202F50726F64756365722028676E75706C6F74290A2520202F4B6579776F7264732028290A20202F4372656174696F6E446174652028536174204E6F762031302032333A30303A32362032303132290A20202F444F43494E464F207064666D61726B0A656E640A7D206966656C73650A656E640A2525456E6450726F6C6F670A2525506167653A203120310A676E756469637420626567696E0A67736176650A646F636C69700A3530203530207472616E736C6174650A302E30353020302E303530207363616C650A3020736574677261790A6E6577706174680A2848656C766574696361292066696E64666F6E7420323030207363616C65666F6E7420736574666F6E740A4261636B67726F756E64436F6C6F722030206C742033203120726F6C6C2030206C7420657863682030206C74206F72206F72206E6F74207B4261636B67726F756E64436F6C6F72204320312E3030302030203020373230302E303020343739382E303020426F78436F6C46696C6C7D2069660A6773617665202520636F6C6F75722070616C6574746520626567696E0A2F6D6178636F6C6F7273203634206465660A2F48535632524742207B2020657863682064757020302E30206571207B706F70206578636820706F7020647570206475707D202520616368726F6D6174696320677261790A20207B202F48535673206578636820646566202F4853567620657863682064656620362E30206D756C2064757020666C6F6F72206475702033203120726F6C6C207375620A20202020202F48535666206578636820646566202F4853566920657863682063766920646566202F48535670204853567620312E30204853567320737562206D756C206465660A09202F48535671204853567620312E3020485356732048535666206D756C20737562206D756C20646566200A09202F48535674204853567620312E30204853567320312E30204853566620737562206D756C20737562206D756C206465660A09202F4853566920485356692036206D6F642064656620302048535669206571207B48535676204853567420485356707D0A09207B312048535669206571207B48535671204853567620485356707D7B322048535669206571207B48535670204853567620485356747D0A09207B332048535669206571207B48535670204853567120485356767D7B342048535669206571207B48535674204853567020485356767D0A09207B48535676204853567020485356717D206966656C73657D206966656C73657D206966656C73657D206966656C73657D206966656C73650A20207D206966656C73657D206465660A2F436F6E73747261696E207B0A20206475702030206C74207B30206578636820706F707D7B6475702031206774207B31206578636820706F707D2069667D206966656C73657D206465660A2F59495132524742207B0A20203320636F7079202D312E373032206D756C2065786368202D312E313035206D756C206164642061646420436F6E73747261696E2034203120726F6C6C0A20203320636F7079202D302E363437206D756C2065786368202D302E323732206D756C206164642061646420436F6E73747261696E2035203120726F6C6C0A2020302E363231206D756C2065786368202D302E393536206D756C206164642061646420436F6E73747261696E2033203120726F6C6C207D206465660A2F434D5932524742207B202031206578636820737562206578636820312065786368207375622033203220726F6C6C20312065786368207375622033203120726F6C6C2065786368207D206465660A2F58595A32524742207B20203320636F7079202D302E39303137206D756C2065786368202D302E31313837206D756C20616464206578636820302E30353835206D756C2065786368206164640A2020436F6E73747261696E2034203120726F6C6C203320636F7079202D302E30323739206D756C206578636820312E393939206D756C2061646420657863680A20202D302E39383434206D756C2061646420436F6E73747261696E2035203120726F6C6C202D302E32383931206D756C2065786368202D302E35333338206D756C206164640A20206578636820312E3931206D756C20657863682061646420436F6E73747261696E2033203120726F6C6C7D206465660A2F53656C6563745370616365207B436F6C6F725370616365202848535629206571207B485356325247427D7B436F6C6F725370616365202858595A29206571207B0A202058595A325247427D7B436F6C6F7253706163652028434D5929206571207B434D59325247427D7B436F6C6F725370616365202859495129206571207B594951325247427D0A202069667D206966656C73657D206966656C73657D206966656C73657D206465660A2F496E746572706F6C61746564436F6C6F722074727565206465660A2F67726179696E646578207B2F676964782030206465660A20207B4772617941206769647820676574206772617976206765207B657869747D206966202F676964782067696478203120616464206465667D206C6F6F707D206465660A2F64676478207B6772617976204772617941206769647820676574207375622047726179412067696478203120737562206765740A2020477261794120676964782067657420737562206469767D20646566200A2F72656476616C7565207B5265644120676964782067657420526564412067696478203120737562206765740A20205265644120676964782067657420737562206467647876616C206D756C206164647D206465660A2F677265656E76616C7565207B477265656E4120676964782067657420477265656E412067696478203120737562206765740A2020477265656E4120676964782067657420737562206467647876616C206D756C206164647D206465660A2F626C756576616C7565207B426C75654120676964782067657420426C7565412067696478203120737562206765740A2020426C75654120676964782067657420737562206467647876616C206D756C206164647D206465660A2F696E746572706F6C617465207B0A202067726179696E64657820677261797620477261794120676964782067657420737562206162732031652D35206C650A202020207B5265644120676964782067657420477265656E4120676964782067657420426C7565412067696478206765747D0A202020207B2F6467647876616C2064676478206465662072656476616C756520677265656E76616C756520626C756576616C75657D206966656C73657D206465660A2F4772617941205B30202E30313539202E30333137202E30343736202E30363335202E30373934202E30393532202E31313131202E313237202E31343239202E31353837202E31373436200A20202E31393035202E32303633202E32323232202E32333831202E323534202E32363938202E32383537202E33303136202E33313735202E33333333202E33343932202E33363531200A20202E333831202E33393638202E34313237202E34323836202E34343434202E34363033202E34373632202E34393231202E35303739202E35323338202E35333937202E35353536200A20202E35373134202E35383733202E36303332202E363139202E36333439202E36353038202E36363637202E36383235202E36393834202E37313433202E37333032202E373436200A20202E37363139202E37373738202E37393337202E38303935202E38323534202E38343133202E38353731202E383733202E38383839202E39303438202E39323036202E39333635200A20202E39353234202E39363833202E393834312031205D206465660A2F52656441205B3020302030203020302030203020302030203020302030203020302030203020302030203020302030203020302030202E30323338202E30383733202E31353038200A20202E32313433202E32373738202E33343133202E34303438202E34363833202E35333137202E35393532202E36353837202E37323232202E37383537202E38343932202E39313237200A20202E393736322031203120312031203120312031203120312031203120312031203120312031202E39343434202E383831202E38313735202E373534202E36393035202E363237200A20202E35363335202E35205D206465660A2F477265656E41205B302030203020302030203020302030202E30303739202E30373134202E31333439202E31393834202E32363139202E33323534202E33383839202E34353234200A20202E35313539202E35373934202E36343239202E37303633202E37363938202E38333333202E38393638202E393630332031203120312031203120312031203120312031203120312031200A20203120312031202E39363033202E38393638202E38333333202E37363938202E37303633202E36343239202E35373934202E35313539202E34353234202E33383839202E33323534200A20202E32363139202E31393834202E31333439202E30373134202E3030373920302030203020302030203020302030205D206465660A2F426C756541205B2E35202E35363335202E363237202E36393035202E373534202E38313735202E383831202E393434342031203120312031203120312031203120312031203120312031200A20203120312031202E39373632202E39313237202E38343932202E37383537202E37323232202E36353837202E35393532202E35333137202E34363833202E34303438202E33343133200A20202E32373738202E32313433202E31353038202E30383733202E303233382030203020302030203020302030203020302030203020302030203020302030203020302030203020302030200A2020302030205D206465660A2F706D3364726F756E64207B6D6178636F6C6F72732030206774207B64757020312067650A097B706F7020317D207B6D6178636F6C6F7273206D756C20666C6F6F72206D6178636F6C6F7273203120737562206469767D206966656C73657D2069667D206465660A2F706D336447616D6D6120312E3020312E352047616D6D61206D756C20646976206465660A2F436F6C6F725370616365202852474229206465660A436F6C6F7220496E746572706F6C61746564436F6C6F72206F72207B202520434F4C4F55522076732E2047524159206D61700A2020496E746572706F6C61746564436F6C6F72207B20252520496E746572706F6C6174696F6E2076732E205247422D466F726D756C610A202020202F67207B7374726F6B6520706D3364726F756E64202F677261797620657863682064656620696E746572706F6C6174650A202020202020202053656C656374537061636520736574726762636F6C6F727D2062696E64206465660A20207D7B0A20202F67207B7374726F6B6520706D3364726F756E64206475702063463720436F6E73747261696E2065786368206475702063463520436F6E73747261696E2065786368206346313520436F6E73747261696E200A2020202020202053656C656374537061636520736574726762636F6C6F727D2062696E64206465660A20207D206966656C73650A7D7B0A20202F67207B7374726F6B6520706D3364726F756E6420706D336447616D6D612065787020736574677261797D2062696E64206465660A7D206966656C73650A302E35303020554C0A4C54620A302E35303020554C0A4C54620A3935392031363136204D0A323938382036393520560A363234312031343036204D0A333934372032333131204C0A3935392031363136204D0A30203139373620560A333934372032333131204D0A30203139373620560A363234312031343036204D0A30203139373620560A3935392033353932204D0A323938382036393520560A363234312033333832204D0A333934372034323837204C0A7374726F6B650A4C54610A3332353320373131204D0A3935392031363136204C0A7374726F6B650A4C54620A3332353320373131204D0A2D383920333520560A7374726F6B650A302E303020302E303020302E30302043203333373320363331204D0A5B205B287B7D29203230302E3020302E3020747275652074727565203020282D3130295D0A5D202D36362E37204D4C73686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A3935392031363136204D0A3839202D333520560A7374726F6B650A4C54610A3339393920383834204D0A313730362031373930204C0A7374726F6B650A4C54620A3339393920383834204D0A2D383920333520560A7374726F6B650A302E303020302E303020302E30302043203431323020383035204D0A5B205B287B7D29203230302E3020302E3020747275652074727565203020282D35295D0A5D202D36362E37204D4C73686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A313730362031373930204D0A3839202D333520560A7374726F6B650A4C54610A343734362031303538204D0A323435342031393634204C0A7374726F6B650A4C54620A343734362031303538204D0A2D383820333520560A7374726F6B650A302E303020302E303020302E30302043203438363720393739204D0A5B205B287B7D29203230302E3020302E30207472756520747275652030202830295D0A5D202D36362E37204D4C73686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A323435342031393634204D0A3838202D333520560A7374726F6B650A4C54610A353439342031323332204D0A333230312032313337204C0A7374726F6B650A4C54620A353439342031323332204D0A2D383920333520560A7374726F6B650A302E303020302E303020302E3030204320353631342031313533204D0A5B205B287B7D29203230302E3020302E30207472756520747275652030202835295D0A5D202D36362E37204D4C73686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A333230312032313337204D0A3839202D333520560A7374726F6B650A4C54610A363234312031343036204D0A333934372032333131204C0A7374726F6B650A4C54620A363234312031343036204D0A2D383920333520560A7374726F6B650A302E303020302E303020302E3030204320363336322031333236204D0A5B205B287B7D29203230302E3020302E3020747275652074727565203020283130295D0A5D202D36362E37204D4C73686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A333934372032333131204D0A3839202D333520560A7374726F6B650A4C54610A3332353320373131204D0A323938382036393520560A7374726F6B650A4C54620A3332353320373131204D0A373020313620560A7374726F6B650A302E303020302E303020302E30302043203331353820363734204D0A5B205B287B7D29203230302E3020302E3020747275652074727565203020282D3130295D0A5D202D36362E37204D4373686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A363234312031343036204D0A2D3730202D313720560A7374726F6B650A4C54610A3236373920393337204D0A323938392036393520560A7374726F6B650A4C54620A3236373920393337204D0A373020313620560A7374726F6B650A302E303020302E303020302E30302043203235383420393030204D0A5B205B287B7D29203230302E3020302E3020747275652074727565203020282D35295D0A5D202D36362E37204D4373686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A353636382031363332204D0A2D3730202D313620560A7374726F6B650A4C54610A323130362031313633204D0A323938382036393520560A7374726F6B650A4C54620A323130362031313633204D0A373020313720560A7374726F6B650A302E303020302E303020302E3030204320323031312031313237204D0A5B205B287B7D29203230302E3020302E30207472756520747275652030202830295D0A5D202D36362E37204D4373686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A353039342031383538204D0A2D3730202D313620560A7374726F6B650A4C54610A313533322031333930204D0A323938392036393520560A7374726F6B650A4C54620A313533322031333930204D0A373020313620560A7374726F6B650A302E303020302E303020302E3030204320313433372031333533204D0A5B205B287B7D29203230302E3020302E30207472756520747275652030202835295D0A5D202D36362E37204D4373686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A343532312032303835204D0A2D3730202D313620560A7374726F6B650A4C54610A3935392031363136204D0A323938382036393520560A7374726F6B650A4C54620A3935392031363136204D0A373020313720560A7374726F6B650A302E303020302E303020302E30302043203836342031353739204D0A5B205B287B7D29203230302E3020302E3020747275652074727565203020283130295D0A5D202D36362E37204D4373686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A333934372032333131204D0A2D3730202D313620560A7374726F6B650A4C54610A3935392031363136204D0A323938382036393520560A363234312031343036204C0A7374726F6B650A4C54620A3935392031363136204D0A3838203020560A7374726F6B650A302E303020302E303020302E30302043203833332031363136204D0A5B205B287B7D29203230302E3020302E3020747275652074727565203020282D302E34295D0A5D202D36362E37204D5273686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A363234312031343036204D0A2D3838203020560A7374726F6B650A4C54610A3935392031383939204D0A323938382036393420560A363234312031363838204C0A7374726F6B650A4C54620A3935392031383939204D0A3838203020560A7374726F6B650A302E303020302E303020302E30302043203833332031383939204D0A5B205B287B7D29203230302E3020302E3020747275652074727565203020282D302E32295D0A5D202D36362E37204D5273686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A363234312031363838204D0A2D3838203020560A7374726F6B650A4C54610A3935392032313831204D0A323938382036393420560A363234312031393730204C0A7374726F6B650A4C54620A3935392032313831204D0A3838203020560A7374726F6B650A302E303020302E303020302E30302043203833332032313831204D0A5B205B287B7D29203230302E3020302E30207472756520747275652030202830295D0A5D202D36362E37204D5273686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A363234312031393730204D0A2D3838203020560A7374726F6B650A4C54610A3935392032343634204D0A323938382036393420560A363234312032323533204C0A7374726F6B650A4C54620A3935392032343634204D0A3838203020560A7374726F6B650A302E303020302E303020302E30302043203833332032343634204D0A5B205B287B7D29203230302E3020302E302074727565207472756520302028302E32295D0A5D202D36362E37204D5273686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A363234312032323533204D0A2D3838203020560A7374726F6B650A4C54610A3935392032373435204D0A323938382036393520560A363234312032353334204C0A7374726F6B650A4C54620A3935392032373435204D0A3838203020560A7374726F6B650A302E303020302E303020302E30302043203833332032373435204D0A5B205B287B7D29203230302E3020302E302074727565207472756520302028302E34295D0A5D202D36362E37204D5273686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A363234312032353334204D0A2D3838203020560A7374726F6B650A4C54610A3935392033303238204D0A323938382036393420560A363234312032383137204C0A7374726F6B650A4C54620A3935392033303238204D0A3838203020560A7374726F6B650A302E303020302E303020302E30302043203833332033303238204D0A5B205B287B7D29203230302E3020302E302074727565207472756520302028302E36295D0A5D202D36362E37204D5273686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A363234312032383137204D0A2D3838203020560A7374726F6B650A4C54610A3935392033333130204D0A323938382036393520560A363234312033303939204C0A7374726F6B650A4C54620A3935392033333130204D0A3838203020560A7374726F6B650A302E303020302E303020302E30302043203833332033333130204D0A5B205B287B7D29203230302E3020302E302074727565207472756520302028302E38295D0A5D202D36362E37204D5273686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A363234312033303939204D0A2D3838203020560A7374726F6B650A4C54610A3935392033353932204D0A323938382036393520560A363234312033333832204C0A7374726F6B650A4C54620A3935392033353932204D0A3838203020560A7374726F6B650A302E303020302E303020302E30302043203833332033353932204D0A5B205B287B7D29203230302E3020302E30207472756520747275652030202831295D0A5D202D36362E37204D5273686F770A302E35303020554C0A4C54620A302E35303020554C0A4C54620A363234312033333832204D0A2D3838203020560A312E3030302055500A2520426567696E20706C6F742023310A7374726F6B650A4C54300A302E303020302E303020302E3030204320302E35303020554C0A4C54300A302E303020302E303020302E30302043202520456E6420706C6F742023310A2E31303433206720677361766520333932342032353639204E202D3630202D31332056202D343620313720562036302032332056203120506F6C7946696C6C0A302E35303020554C0A4C54300A302E303020302E303020302E3030204320333932342032353639204D0A2D343620323720560A2D3630202D323320560A3436202D313720560A363020313320560A2E31313036206720677361766520333836342032353536204E202D3630202D332056202D3436203720562036302031332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333836342032353536204D0A2D343620313720560A2D3630202D313320560A3436202D3720560A3630203320560A2E31313036206720677361766520333936392032353531204E202D3539202D332056202D3436203820562036302031332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333936392032353531204D0A2D343520313820560A2D3630202D313320560A3436202D3820560A3539203320560A2E31323232206720677361766520333830342032353533204E202D363020362056202D3436202D34205620363020352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333830342032353533204D0A2D3436203720560A2D3630202D3520560A3436203420560A3630202D3620560A2E313233206720677361766520333931302032353438204E202D363020382056202D3436202D33205620363020332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333931302032353438204D0A2D3436203820560A2D3630202D3320560A3436203320560A3630202D3820560A2E31323232206720677361766520343031352032353432204E202D353920382056202D3436202D32205620353920332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343031352032353432204D0A2D3436203920560A2D3539202D3320560A3436203220560A3539202D3820560A2E313338206720677361766520333734342032353539204E202D36302031332056202D3435202D31332056203539202D342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333734342032353539204D0A2D3436202D3420560A2D3539203420560A343520313320560A3630202D313320560A2E31343032206720677361766520333835302032353536204E202D36302031352056202D3436202D31322056203630202D362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333835302032353536204D0A2D3436202D3320560A2D3630203620560A343620313220560A3630202D313520560A2E31343032206720677361766520333935362032353530204E202D36302031372056202D3436202D31312056203630202D382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333935362032353530204D0A2D3436202D3220560A2D3630203820560A343620313120560A3630202D313720560A2E313338206720677361766520343036312032353432204E202D36302031372056202D3435202D392056203539202D382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343036312032353432204D0A2D3436203020560A2D3539203820560A3435203920560A3630202D313720560A2E31353638206720677361766520333638342032353732204E202D35392031382056202D3435202D32312056203539202D31302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333638342032353732204D0A2D3435202D313320560A2D353920313020560A343520323120560A3539202D313820560A2E31363038206720677361766520333739302032353731204E202D36302032322056202D3436202D32312056203630202D31332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333739302032353731204D0A2D3436202D313220560A2D363020313320560A343620323120560A3630202D323220560A2E31363231206720677361766520333839362032353637204E202D36302032342056202D3436202D32302056203630202D31352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333839362032353637204D0A2D3436202D313120560A2D363020313520560A343620323020560A3630202D323420560A2E31363038206720677361766520343030312032353539204E202D35392032352056202D3436202D31372056203630202D31372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343030312032353539204D0A2D3435202D3920560A2D363020313720560A343620313720560A3539202D323520560A2E31353638206720677361766520343130372032353438204E202D36302032352056202D3436202D31342056203630202D31372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343130372032353438204D0A2D3436202D3620560A2D363020313720560A343620313420560A3630202D323520560A2E31373731206720677361766520333632352032353930204E202D35392032312056202D3436202D32382056203630202D31342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333632352032353930204D0A2D3435202D323120560A2D363020313420560A343620323820560A3539202D323120560A2E313833206720677361766520333733302032353933204E202D35392032342056202D3436202D32372056203539202D31382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333733302032353933204D0A2D3436202D323120560A2D353920313820560A343620323720560A3539202D323420560A2E313836206720677361766520333833362032353931204E202D36302032372056202D3436202D32352056203630202D32322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333833362032353931204D0A2D3436202D323020560A2D363020323220560A343620323520560A3630202D323720560A2E313836206720677361766520333934322032353834204E202D36302033302056202D3436202D32332056203630202D32342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333934322032353834204D0A2D3436202D313720560A2D363020323420560A343620323320560A3630202D333020560A2E313833206720677361766520343034372032353733204E202D35392033322056202D3436202D32312056203539202D32352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343034372032353733204D0A2D3436202D313420560A2D353920323520560A343620323120560A3539202D333220560A2E31373731206720677361766520343135332032353538204E202D36302033322056202D3436202D31372056203630202D32352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343135332032353538204D0A2D3436202D313020560A2D363020323520560A343620313720560A3630202D333220560A2E31393736206720677361766520333536362032363131204E202D36302032322056202D3436202D33322056203630202D31382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333536362032363131204D0A2D3436202D323820560A2D363020313820560A343620333220560A3630202D323220560A2E32303533206720677361766520333637312032363137204E202D36302032352056202D3435202D33312056203539202D32312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333637312032363137204D0A2D3436202D323720560A2D353920323120560A343520333120560A3630202D323520560A2E3231206720677361766520333737362032363138204E202D36302032382056202D3435202D32392056203539202D32342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333737362032363138204D0A2D3436202D323520560A2D353920323420560A343520323920560A3630202D323820560A2E32313136206720677361766520333838322032363134204E202D36302033302056202D3436202D32362056203630202D32372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333838322032363134204D0A2D3436202D323320560A2D363020323720560A343620323620560A3630202D333020560A2E3231206720677361766520333938382032363035204E202D36302033322056202D3436202D32332056203630202D33302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333938382032363035204D0A2D3436202D323120560A2D363020333020560A343620323320560A3630202D333220560A2E323137206720677361766520333530362032363333204E202D36302031392056202D3436202D33342056203630202D31372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333530362032363333204D0A2D3436202D333220560A2D363020313720560A343620333420560A3630202D313920560A2E31393736206720677361766520343139392032353731204E202D36302033362056202D3436202D31372056203630202D33322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343139392032353731204D0A2D3436202D313320560A2D363020333220560A343620313720560A3630202D333620560A2E32303533206720677361766520343039332032353930204E202D36302033352056202D3435202D32302056203539202D33322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343039332032353930204D0A2D3436202D313720560A2D353920333220560A343520323020560A3630202D333520560A2E32323633206720677361766520333631312032363432204E202D35392032322056202D3436202D33312056203630202D32322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333631312032363432204D0A2D3435202D333120560A2D363020323220560A343620333120560A3539202D323220560A2E32333233206720677361766520333731362032363436204E202D35392032342056202D3436202D32382056203630202D32352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333731362032363436204D0A2D3435202D323920560A2D363020323520560A343620323820560A3539202D323420560A2E32333533206720677361766520333832322032363434204E202D36302032372056202D3436202D32352056203630202D32382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333832322032363434204D0A2D3436202D323620560A2D363020323820560A343620323520560A3630202D323720560A2E32333435206720677361766520333434362032363532204E202D35392031362056202D3436202D33332056203539202D31372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333434362032363532204D0A2D3436202D333420560A2D353920313720560A343620333320560A3539202D313620560A2E32333533206720677361766520333932382032363337204E202D36302033302056202D3436202D32332056203630202D33302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333932382032363337204D0A2D3436202D323320560A2D363020333020560A343620323320560A3630202D333020560A2E323137206720677361766520343234352032353835204E202D36302033382056202D3436202D31362056203630202D33362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343234352032353835204D0A2D3436202D313420560A2D363020333620560A343620313620560A3630202D333820560A2E32333233206720677361766520343033332032363235204E202D35392033322056202D3436202D32302056203630202D33322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343033332032363235204D0A2D3435202D323020560A2D363020333220560A343620323020560A3539202D333220560A2E32323633206720677361766520343133392032363037204E202D36302033362056202D3436202D31382056203630202D33352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343133392032363037204D0A2D3436202D313720560A2D363020333520560A343620313820560A3630202D333620560A2E32343436206720677361766520333535322032363634204E202D36302031372056202D3436202D32392056203630202D31392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333535322032363634204D0A2D3436202D333120560A2D363020313920560A343620323920560A3630202D313720560A2E32353134206720677361766520333635372032363730204E202D35392031392056202D3436202D32352056203539202D32322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333635372032363730204D0A2D3436202D323820560A2D353920323220560A343620323520560A3539202D313920560A2E32343934206720677361766520333338372032363638204E202D36302031322056202D3436202D33312056203630202D31342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333338372032363638204D0A2D3436202D333320560A2D363020313420560A343620333120560A3630202D313220560A2E32353533206720677361766520333736322032363731204E202D36302032302056202D3435202D32312056203539202D32342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333736322032363731204D0A2D3436202D323520560A2D353920323420560A343520323120560A3630202D323020560A2E32353636206720677361766520333836382032363637204E202D36302032322056202D3436202D31382056203630202D32372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333836382032363637204D0A2D3436202D323320560A2D363020323720560A343620313820560A3630202D323220560A2E32353937206720677361766520333439322032363831204E202D36302031322056202D3435202D32352056203539202D31362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333439322032363831204D0A2D3436202D323920560A2D353920313620560A343520323520560A3630202D313220560A2E32353533206720677361766520333937342032363537204E202D36302032362056202D3436202D31362056203630202D33302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333937342032363537204D0A2D3436202D323020560A2D363020333020560A343620313620560A3630202D323620560A2E32333435206720677361766520343239312032353937204E202D36302033382056202D3436202D31322056203630202D33382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343239312032353937204D0A2D3436202D313220560A2D363020333820560A343620313220560A3630202D333820560A2E32353134206720677361766520343037392032363433204E202D36302032392056202D3435202D31352056203539202D33322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343037392032363433204D0A2D3436202D313820560A2D353920333220560A343520313520560A3630202D323920560A2E32343436206720677361766520343138352032363233204E202D36302033332056202D3436202D31332056203630202D33362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343138352032363233204D0A2D3436202D313620560A2D363020333620560A343620313320560A3630202D333320560A2E32363635206720677361766520333539382032363839204E202D36302031322056202D3436202D32302056203630202D31372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333539382032363839204D0A2D3436202D323520560A2D363020313720560A343620323020560A3630202D313220560A2E32363134206720677361766520333332372032363830204E202D363020372056202D3436202D32372056203630202D31312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333332372032363830204D0A2D3436202D333120560A2D363020313120560A343620323720560A3630202D3720560A2E32373035206720677361766520333730322032363931204E202D35392031332056202D3435202D31352056203539202D31392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333730322032363931204D0A2D3435202D323120560A2D353920313920560A343520313520560A3539202D313320560A2E32373233206720677361766520333830382032363839204E202D36302031342056202D3436202D31322056203630202D32302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333830382032363839204D0A2D3436202D313820560A2D363020323020560A343620313220560A3630202D313420560A2E323731206720677361766520333433322032363933204E202D353920362056202D3436202D31392056203630202D31322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333433322032363933204D0A2D3435202D323520560A2D363020313220560A343620313920560A3539202D3620560A2E32373233206720677361766520333931342032363833204E202D36302031352056202D3436202D392056203630202D32322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333931342032363833204D0A2D3436202D313620560A2D363020323220560A3436203920560A3630202D313520560A2E32373035206720677361766520343031392032363732204E202D35392031392056202D3436202D382056203630202D32362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343031392032363732204D0A2D3435202D313520560A2D363020323620560A3436203820560A3539202D313920560A2E32343934206720677361766520343333362032363037204E202D35392033352056202D3436202D372056203630202D33382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343333362032363037204D0A2D3435202D313020560A2D363020333820560A3436203720560A3539202D333520560A2E32373638206720677361766520333533382032373031204E202D363020342056202D3436202D31322056203630202D31322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333533382032373031204D0A2D3436202D323020560A2D363020313220560A343620313220560A3630202D3420560A2E32363635206720677361766520343132352032363536204E202D36302032342056202D3436202D382056203630202D32392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343132352032363536204D0A2D3436202D313320560A2D363020323920560A3436203820560A3630202D323420560A2E32353937206720677361766520343233312032363335204E202D36302032392056202D3436202D382056203630202D33332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343233312032363335204D0A2D3436202D313220560A2D363020333320560A3436203820560A3630202D323920560A2E32373035206720677361766520333236372032363837204E202D363020312056202D3436202D32312056203630202D372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333236372032363837204D0A2D3436202D323720560A2D3630203720560A343620323120560A3630202D3120560A2E3238206720677361766520333634332032373034204E202D353920322056202D3436202D352056203630202D31322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333634332032373034204D0A2D3435202D313520560A2D363020313220560A3436203520560A3539202D3220560A2E32373835206720677361766520333337332032363939204E202D3630202D312056202D3436202D31312056203630202D372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333337332032363939204D0A2D3436202D313920560A2D3630203720560A343620313120560A3630203120560A2E32383135206720677361766520333734382032373033204E202D353920312056202D343620302056203539202D31332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333734382032373033204D0A2D3436202D313220560A2D353920313320560A3436203020560A3539202D3120560A2E32383139206720677361766520333835342032363938204E202D363020332056202D343620322056203630202D31342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333835342032363938204D0A2D3436202D3920560A2D363020313420560A3436202D3220560A3630202D3320560A2E32383235206720677361766520333437382032373035204E202D3630202D342056202D3435202D322056203539202D362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333437382032373035204D0A2D3436202D313220560A2D3539203620560A3435203220560A3630203420560A2E32373638206720677361766520333230372032363838204E202D3630202D332056202D3436202D31352056203630202D332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333230372032363838204D0A2D3436202D323120560A2D3630203320560A343620313520560A3630203320560A2E32383135206720677361766520333936302032363931204E202D363020352056202D343620322056203630202D31352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333936302032363931204D0A2D3436202D3820560A2D363020313520560A3436202D3220560A3630202D3520560A2E32383338206720677361766520333538342032373036204E202D3630202D372056202D343620362056203630202D342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333538342032373036204D0A2D3436202D3520560A2D3630203420560A3436202D3620560A3630203720560A2E3238206720677361766520343036352032363830204E202D353920392056202D343620322056203539202D31392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343036352032363830204D0A2D3436202D3820560A2D353920313920560A3436202D3220560A3539202D3920560A2E32363134206720677361766520343338322032363133204E202D35392033322056202D3436202D332056203539202D33352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343338322032363133204D0A2D3436202D3620560A2D353920333520560A3436203320560A3539202D333220560A2E32373638206720677361766520343137312032363634204E202D36302031352056202D343620312056203630202D32342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343137312032363634204D0A2D3436202D3820560A2D363020323420560A3436202D3120560A3630202D313520560A2E323731206720677361766520343237372032363432204E202D36302032332056202D3436202D312056203630202D32392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343237372032363432204D0A2D3436202D3720560A2D363020323920560A3436203120560A3630202D323320560A2E32383338206720677361766520333638392032373034204E202D3630202D31302056202D34352031322056203539202D322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333638392032373034204D0A2D3436203020560A2D3539203220560A3435202D313220560A363020313020560A2E32383237206720677361766520333331332032363938204E202D3630202D372056202D3436202D332056203630202D312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333331332032363938204D0A2D3436202D313120560A2D3630203120560A3436203320560A3630203720560A2E32383335206720677361766520333739342032373031204E202D3630202D31312056202D34352031342056203539202D312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333739342032373031204D0A2D3436203220560A2D3539203120560A3435202D313420560A363020313120560A2E30313236206720677361766520333631392032313135204E202D3539202D34362056202D343620363620562036302035382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333631392032313135204D0A2D343520373820560A2D3630202D353820560A3436202D363620560A353920343620560A2E32383338206720677361766520333431382032373031204E202D3539202D31322056202D34362039205620363020312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333431382032373031204D0A2D3435202D3220560A2D3630202D3120560A3436202D3920560A353920313220560A2E30303838206720677361766520333732352032313036204E202D3630202D34382056202D343620353720562036302036312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333732352032313036204D0A2D343620373020560A2D3630202D363120560A3436202D353720560A363020343820560A2E30333133206720677361766520333637392032313736204E202D3630202D36312056202D343520373820562035392036372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333637392032313736204D0A2D343620383420560A2D3539202D363720560A3435202D373820560A363020363120560A2E30323138206720677361766520333531342032313335204E202D3539202D34362056202D343620373920562035392035342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333531342032313335204D0A2D343620383720560A2D3539202D353420560A3436202D373920560A353920343620560A2E32383335206720677361766520333930302032363936204E202D3630202D31302056202D34362031352056203630202D332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333930302032363936204D0A2D3436203220560A2D3630203320560A3436202D313520560A363020313020560A2E32383232206720677361766520333532342032363939204E202D3630202D31372056202D3436203139205620363020342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333532342032363939204D0A2D3436203620560A2D3630202D3420560A3436202D313920560A363020313720560A2E30323835206720677361766520333738342032313732204E202D3539202D36362056202D343620373020562036302037342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333738342032313732204D0A2D343520373820560A2D3630202D373420560A3436202D373020560A353920363620560A2E32383038206720677361766520333134372032363835204E202D3539202D372056202D3436202D39205620353920312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333134372032363835204D0A2D3436202D313520560A2D3539202D3120560A3436203920560A3539203720560A2E30343034206720677361766520333537342032313933204E202D3630202D35382056202D343620383720562036302036322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333537342032313933204D0A2D343620393120560A2D3630202D363220560A3436202D383720560A363020353820560A2E30303838206720677361766520333833302032313037204E202D3539202D35332056202D343620353220562035392036362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333833302032313037204D0A2D343620363520560A2D3539202D363620560A3436202D353220560A353920353320560A2E32373935206720677361766520333632392032363934204E202D3539202D32312056202D3436203236205620363020372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333632392032363934204D0A2D343520313220560A2D3630202D3720560A3436202D323620560A353920323120560A2E32383338206720677361766520343030362032363839204E202D3630202D372056202D34362031342056203630202D352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343030362032363839204D0A2D3436203220560A2D3630203520560A3436202D313420560A3630203720560A2E30303937206720677361766520333435352032303839204E202D3630202D33352056202D343620363920562036302034352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333435352032303839204D0A2D343620373920560A2D3630202D343520560A3436202D363920560A363020333520560A2E30303235206720677361766520333536302032303639204E202D3630202D33312056202D343520353120562035392034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333536302032303639204D0A2D343620363620560A2D3539202D343620560A3435202D353120560A363020333120560A2E30353837206720677361766520333733392032323530204E202D3630202D37342056202D343620383420562036302037362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333733392032323530204D0A2D343620383620560A2D3630202D373620560A3436202D383420560A363020373420560A2E30363537206720677361766520333633332032323630204E202D3539202D36372056202D343620393120562036302036382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333633332032323630204D0A2D343520393220560A2D3630202D363820560A3436202D393120560A353920363720560A2E32373733206720677361766520333733342032363930204E202D3539202D32352056202D343620323920562036302031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333733342032363930204D0A2D343520313420560A2D3630202D313020560A3436202D323920560A353920323520560A2E32383339206720677361766520333235332032363931204E202D3630202D31322056202D34362036205620363020332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333235332032363931204D0A2D3436202D3320560A2D3630202D3320560A3436202D3620560A363020313220560A2E30333133206720677361766520333839302032313830204E202D3630202D37332056202D343620363520562036302038302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333839302032313830204D0A2D343620373220560A2D3630202D383020560A3436202D363520560A363020373320560A2E30303034206720677361766520333636352032303538204E202D3630202D32382056202D343520333920562035392034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333636352032303538204D0A2D343620353720560A2D3539202D343620560A3435202D333920560A363020323820560A2E30353639206720677361766520333436382032323232204E202D3539202D35342056202D343620393720562036302035352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333436382032323232204D0A2D343520393820560A2D3630202D353520560A3436202D393720560A353920353420560A2E32383338206720677361766520343131312032363739204E202D3630202D312056202D34352031312056203539202D392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343131312032363739204D0A2D3436203120560A2D3539203920560A3435202D313120560A3630203120560A2E30383033206720677361766520333532382032323834204E202D3630202D36322056202D343520393820562035392036322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333532382032323834204D0A2D343620393820560A2D3539202D363220560A3435202D393820560A363020363220560A2E30353837206720677361766520333834342032323532204E202D3630202D38302056202D343520373820562035392038312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333834342032323532204D0A2D343620373920560A2D3539202D383120560A3435202D373820560A363020383020560A2E30333839206720677361766520333430392032313638204E202D3630202D34352056202D343620393220562036302035302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333430392032313638204D0A2D343620393720560A2D3630202D353020560A3436202D393220560A363020343520560A2E32383135206720677361766520333335392032363839204E202D3630202D31382056202D3436203230205620363020372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333335392032363839204D0A2D3436203920560A2D3630202D3720560A3436202D323020560A363020313820560A2E32373635206720677361766520333834302032363836204E202D3630202D32372056202D343620333120562036302031312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333834302032363836204D0A2D343620313520560A2D3630202D313120560A3436202D333120560A363020323720560A2E30393731206720677361766520333639332032333336204E202D3630202D37362056202D343520393220562035392037322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333639332032333336204D0A2D343620383820560A2D3539202D373220560A3435202D393220560A363020373620560A2E323736206720677361766520333436342032363832204E202D3539202D32352056202D343620333220562035392031322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333436342032363832204D0A2D343620313920560A2D3539202D313220560A3436202D333220560A353920323520560A2E30313236206720677361766520333933362032313138204E202D3630202D36312056202D343620353020562036302037332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333933362032313138204D0A2D343620363220560A2D3630202D373320560A3436202D353020560A363020363120560A2E32363936206720677361766520333537302032363733204E202D3630202D33312056202D343620343020562036302031372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333537302032363733204D0A2D343620323620560A2D3630202D313720560A3436202D343020560A363020333120560A2E30303031206720677361766520333737312032303534204E202D3630202D32392056202D343620333320562036302034382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333737312032303534204D0A2D343620353220560A2D3630202D343820560A3436202D333320560A363020323920560A2E32383235206720677361766520343231372032363635204E202D363020362056202D343620382056203630202D31352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343231372032363635204D0A2D3436202D3120560A2D363020313520560A3436202D3820560A3630202D3620560A2E31303834206720677361766520333538382032333532204E202D3630202D36382056202D343620393820562036302036342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333538382032333532204D0A2D343620393420560A2D3630202D363420560A3436202D393820560A363020363820560A2E32363432206720677361766520333637352032363635204E202D3630202D33362056202D343520343420562035392032312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333637352032363635204D0A2D343620323920560A2D3539202D323120560A3435202D343420560A363020333620560A2E30393333206720677361766520333739382032333331204E202D3539202D38312056202D343620383620562036302037382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333739382032333331204D0A2D343520383320560A2D3630202D373820560A3436202D383620560A353920383120560A2E32373035206720677361766520343432382032363136204E202D36302032362056202D343520332056203539202D33322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343432382032363136204D0A2D3436202D3320560A2D353920333220560A3435202D3320560A3630202D323620560A2E32373835206720677361766520343332332032363435204E202D36302031352056202D343620352056203630202D32332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343332332032363435204D0A2D3436202D3320560A2D363020323320560A3436202D3520560A3630202D313520560A2E30323537206720677361766520333334392032313233204E202D3630202D33372056202D343620383720562036302034322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333334392032313233204D0A2D343620393220560A2D3630202D343220560A3436202D383720560A363020333720560A2E303033206720677361766520333339352032303534204E202D3630202D32352056202D343620353720562036302033372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333339352032303534204D0A2D343620363920560A2D3630202D333720560A3436202D353720560A363020323520560A2E32373733206720677361766520333934362032363832204E202D3630202D32352056202D343620323920562036302031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333934362032363832204D0A2D343620313420560A2D3630202D313020560A3436202D323920560A363020323520560A2E32363132206720677361766520333738302032363539204E202D3539202D34302056202D343620343620562035392032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333738302032363539204D0A2D343620333120560A2D3539202D323520560A3436202D343620560A353920343020560A2E31343032206720677361766520333634372032343234204E202D3539202D37322056202D343620393420562035392036322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333634372032343234204D0A2D343620383420560A2D3539202D363220560A3436202D393420560A353920373220560A2E32343537206720677361766520333631352032363239204E202D3539202D34362056202D343620353920562036302033312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333631352032363239204D0A2D343520343420560A2D3630202D333120560A3436202D353920560A353920343620560A2E30303034206720677361766520333837362032303537204E202D3630202D33352056202D343520333220562035392035332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333837362032303537204D0A2D343620353020560A2D3539202D353320560A3435202D333220560A363020333520560A2E31333238206720677361766520333735332032343134204E202D3630202D37382056202D343620383820562036302037312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333735332032343134204D0A2D343620383120560A2D3630202D373120560A3436202D383820560A363020373820560A2E323833206720677361766520333038382032363738204E202D3630202D31302056202D3436202D33205620363020342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333038382032363738204D0A2D3436202D3920560A2D3630202D3420560A3436203320560A363020313020560A2E32333933206720677361766520333732312032363139204E202D3630202D35312056202D343620363120562036302033362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333732312032363139204D0A2D343620343620560A2D3630202D333620560A3436202D363120560A363020353120560A2E31373338206720677361766520333730372032343935204E202D3630202D37312056202D343620383420562036302036302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333730372032343935204D0A2D343620373320560A2D3630202D363020560A3436202D383420560A363020373120560A2E32313237206720677361766520333636312032353638204E202D3630202D36302056202D343520373520562035392034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333636312032353638204D0A2D343620363120560A2D3539202D343620560A3435202D373520560A363020363020560A30206720677361766520333530302032303338204E202D3539202D31382056202D343620333420562036302033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333530302032303338204D0A2D343520353120560A2D3630202D333520560A3436202D333420560A353920313820560A2E31383338206720677361766520333630312032353038204E202D3539202D36322056202D343620383520562036302035322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333630312032353038204D0A2D343520373520560A2D3630202D353220560A3436202D383520560A353920363220560A2E32323335206720677361766520333535362032353833204E202D3630202D35322056202D343620373320562036302033382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333535362032353833204D0A2D343620353920560A2D3630202D333820560A3436202D373320560A363020353220560A2E32353533206720677361766520333531302032363432204E202D3630202D33382056202D343520353320562035392032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333531302032363432204D0A2D343620343020560A2D3539202D323520560A3435202D353320560A363020333820560A2E31353437206720677361766520333534322032343436204E202D3630202D36342056202D343520393520562035392035342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333534322032343436204D0A2D343620383520560A2D3539202D353420560A3435202D393520560A363020363420560A2E31323732206720677361766520333438322032333832204E202D3539202D36322056202D34362031303220562036302035352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333438322032333832204D0A2D343520393520560A2D3630202D353520560A3436202D31303220560A353920363220560A2E30363537206720677361766520333935302032323637204E202D3630202D38372056202D343620373220562036302038382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333935302032323637204D0A2D343620373320560A2D3630202D383820560A3436202D373220560A363020383720560A2E31303237206720677361766520333432332032333230204E202D3630202D35352056202D34362031303420562036302035332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333432332032333230204D0A2D34362031303220560A2D3630202D353320560A3436202D31303420560A363020353520560A2E32363132206720677361766520333838362032363537204E202D3630202D34322056202D343620343420562036302032372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333838362032363537204D0A2D343620323920560A2D3630202D323720560A3436202D343420560A363020343220560A2E32363634206720677361766520333430352032363537204E202D3630202D33302056202D343620343420562036302031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333430352032363537204D0A2D343620333220560A2D3630202D313820560A3436202D343420560A363020333020560A2E323337206720677361766520333832362032363135204E202D3630202D35352056202D343520353920562035392034302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333832362032363135204D0A2D343620343420560A2D3539202D343020560A3435202D353920560A363020353520560A2E323037206720677361766520333736362032353630204E202D3539202D36352056202D343620373320562036302035312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333736362032353630204D0A2D343520353920560A2D3630202D353120560A3436202D373320560A353920363520560A2E30393731206720677361766520333930342032333430204E202D3630202D38382056202D343620373920562036302038352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333930342032333430204D0A2D343620373620560A2D3630202D383520560A3436202D373920560A363020383820560A2E30343034206720677361766520333939362032323031204E202D3630202D38332056202D343620363220562036302038372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333939362032323031204D0A2D343620363620560A2D3630202D383720560A3436202D363220560A363020383320560A2E32373935206720677361766520343035312032363738204E202D3539202D32322056202D3436203236205620363020372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343035312032363738204D0A2D343520313120560A2D3630202D3720560A3436202D323620560A353920323220560A2E31333238206720677361766520333835382032343136204E202D3630202D38352056202D343520383320562035392037372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333835382032343136204D0A2D343620373520560A2D3539202D373720560A3435202D383320560A363020383520560A2E31373034206720677361766520333831322032343931204E202D3539202D37372056202D343620383120562035392036352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333831322032343931204D0A2D343620363920560A2D3539202D363520560A3436202D383120560A353920373720560A2E32383239206720677361766520333139332032363739204E202D3630202D31352056202D3435203134205620353920372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333139332032363739204D0A2D3436203620560A2D3539202D3720560A3435202D313420560A363020313520560A2E30383231206720677361766520333336332032323635204E202D3630202D35302056202D34362031303520562036302034392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333336332032323635204D0A2D34362031303420560A2D3630202D343920560A3436202D31303520560A363020353020560A2E32373635206720677361766520333239392032363731204E202D3630202D32322056202D343620333020562036302031322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333239392032363731204D0A2D343620323020560A2D3630202D313220560A3436202D333020560A363020323220560A2E303137206720677361766520333238392032303836204E202D3630202D32392056202D343620383120562036302033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333238392032303836204D0A2D343620383720560A2D3630202D333520560A3436202D383120560A363020323920560A2E31393936206720677361766520333439362032353331204E202D3539202D35342056202D343620383320562035392034342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333439362032353331204D0A2D343620373320560A2D3539202D343420560A3436202D383320560A353920353420560A2E32333831206720677361766520333435302032363034204E202D3539202D34342056202D343620363720562036302033302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333435302032363034204D0A2D343520353320560A2D3630202D333020560A3436202D363720560A353920343420560A2E30303235206720677361766520333938322032303638204E202D3630202D34372056202D343620333620562036302036312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333938322032303638204D0A2D343620353020560A2D3630202D363120560A3436202D333620560A363020343720560A2E30303235206720677361766520333630352032303330204E202D3539202D31302056202D343620313820562036302033312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333630352032303330204D0A2D343520333920560A2D3630202D333120560A3436202D313820560A353920313020560A2E31373535206720677361766520333433372032343737204E202D3630202D35352056202D343620393320562036302034352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333433372032343737204D0A2D343620383320560A2D3630202D343520560A3436202D393320560A363020353520560A2E30323138206720677361766520343034322032313432204E202D3630202D37342056202D343620353020562036302038332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343034322032313432204D0A2D343620353920560A2D3630202D383320560A3436202D353020560A363020373420560A2E323037206720677361766520333837322032353539204E202D3630202D36382056202D343620363920562036302035352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333837322032353539204D0A2D343620353620560A2D3630202D353520560A3436202D363920560A363020363820560A2E30363537206720677361766520333330332032323135204E202D3630202D34322056202D34362031303520562036302034322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333330332032323135204D0A2D34362031303520560A2D3630202D343220560A3436202D31303520560A363020343220560A2E32363432206720677361766520333939322032363536204E202D3630202D34302056202D343620343120562036302032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333939322032363536204D0A2D343620323620560A2D3630202D323520560A3436202D343120560A363020343020560A2E32333933206720677361766520333933322032363136204E202D3630202D35372056202D343620353620562036302034322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333933322032363136204D0A2D343620343120560A2D3630202D343220560A3436202D353620560A363020353720560A2E32383232206720677361766520343135372032363731204E202D3630202D31342056202D3436203231205620363020312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343135372032363731204D0A2D3436203820560A2D3630202D3120560A3436202D323120560A363020313420560A2E32313936206720677361766520333339312032353630204E202D3630202D34352056202D343620373820562036302033342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333339312032353630204D0A2D343620363720560A2D3630202D333420560A3436202D373820560A363020343520560A2E32353434206720677361766520333334352032363237204E202D3630202D33342056202D343620353620562036302032322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333334352032363237204D0A2D343620343420560A2D3630202D323220560A3436202D353620560A363020333420560A2E30303034206720677361766520333333352032303239204E202D3630202D31382056202D343620343620562036302032392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333333352032303239204D0A2D343620353720560A2D3630202D323920560A3436202D343620560A363020313820560A2E31373338206720677361766520333931382032343937204E202D3630202D38312056202D343620373520562036302036382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333931382032343937204D0A2D343620363220560A2D3630202D363820560A3436202D373520560A363020383120560A2E31353239206720677361766520333337372032343232204E202D3630202D35332056202D34362031303120562036302034352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333337372032343232204D0A2D343620393320560A2D3630202D343520560A3436202D31303120560A363020353320560A2E30303533206720677361766520333731312032303235204E202D3630202D352056202D343620313020562036302032382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333731312032303235204D0A2D343620333320560A2D3630202D323820560A3436202D313020560A3630203520560A2E31343032206720677361766520333936342032343239204E202D3630202D38392056202D343620373620562036302038312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333936342032343239204D0A2D343620363820560A2D3630202D383120560A3436202D373620560A363020383920560A2E30313136206720677361766520333232392032303537204E202D3539202D32332056202D343620373620562035392032382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333232392032303537204D0A2D343620383120560A2D3539202D323820560A3436202D373620560A353920323320560A2E32383338206720677361766520333032382032363638204E202D3630202D31322056202D34362032205620363020372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333032382032363638204D0A2D3436202D3320560A2D3630202D3720560A3436202D3220560A363020313220560A2E31303834206720677361766520343031302032333631204E202D3630202D39342056202D343620373320562036302038392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343031302032333631204D0A2D343620363820560A2D3630202D383920560A3436202D373320560A363020393420560A2E32363936206720677361766520333233392032363439204E202D3630202D32362056202D343620343120562036302031352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333233392032363439204D0A2D343620333020560A2D3630202D313520560A3436202D343120560A363020323620560A2E32383338206720677361766520343236332032363630204E202D3630202D352056202D34362031362056203630202D362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343236332032363630204D0A2D3436203520560A2D3630203620560A3436202D313620560A3630203520560A2E30353335206720677361766520333234332032313733204E202D3630202D33352056202D34352031303320562035392033372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333234332032313733204D0A2D34362031303520560A2D3539202D333720560A3435202D31303320560A363020333520560A2E31333238206720677361766520333331372032333639204E202D3630202D34392056202D34362031303620562036302034342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333331372032333639204D0A2D34362031303120560A2D3630202D343420560A3436202D31303620560A363020343920560A2E32363936206720677361766520343039372032363537204E202D3539202D33362056202D343620333520562035392032322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343039372032363537204D0A2D343620323120560A2D3539202D323220560A3436202D333520560A353920333620560A2E30303937206720677361766520343038382032303933204E202D3630202D36342056202D343620333920562036302037342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343038382032303933204D0A2D343620343920560A2D3630202D373420560A3436202D333920560A363020363420560A2E30303331206720677361766520333434312032303230204E202D3630202D392056202D343620313820562036302032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333434312032303230204D0A2D343620333420560A2D3630202D323520560A3436202D313820560A3630203920560A2E30303533206720677361766520333831362032303232204E202D3539202D362056202D3436203920562036302032392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333831362032303232204D0A2D343520333220560A2D3630202D323920560A3436202D3920560A3539203620560A2E32343537206720677361766520343033382032363231204E202D3630202D35352056202D343620353020562036302034302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343033382032363231204D0A2D343620333520560A2D3630202D343020560A3436202D353020560A363020353520560A2E32313237206720677361766520333937382032353636204E202D3630202D36392056202D343620363220562036302035372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333937382032353636204D0A2D343620353020560A2D3630202D353720560A3436202D363220560A363020363920560A2E32303131206720677361766520333333312032353135204E202D3630202D34352056202D343620383620562036302033372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333333312032353135204D0A2D343620373820560A2D3630202D333720560A3436202D383620560A363020343520560A2E32343135206720677361766520333238352032353933204E202D3630202D33372056202D343620363720562036302032362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333238352032353933204D0A2D343620353620560A2D3630202D323620560A3436202D363720560A363020333720560A2E32383035206720677361766520333133332032363634204E202D3539202D31382056202D343620323220562036302031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333133332032363634204D0A2D343520313420560A2D3630202D313020560A3436202D323220560A353920313820560A2E30383033206720677361766520343035362032323935204E202D3630202D39342056202D343620363620562036302039342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343035362032323935204D0A2D343620363620560A2D3630202D393420560A3436202D363620560A363020393420560A2E32383237206720677361766520343336382032363432204E202D353920372056202D34362031312056203630202D31352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343336382032363432204D0A2D3435203320560A2D363020313520560A3436202D313120560A3539202D3720560A2E30303235206720677361766520333932322032303231204E202D3630202D31342056202D343620313520562036302033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333932322032303231204D0A2D343620333620560A2D3630202D333520560A3436202D313520560A363020313420560A2E32373638206720677361766520343437342032363135204E202D36302032302056202D343620372056203630202D32362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343437342032363135204D0A2D3436203120560A2D363020323620560A3436202D3720560A3630202D323020560A2E31313539206720677361766520333235372032333230204E202D3630202D34322056202D34352031303820562035392034302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333235372032333230204D0A2D34362031303620560A2D3539202D343020560A3435202D31303820560A363020343220560A2E30353639206720677361766520343130312032323335204E202D3539202D39332056202D343620353920562036302039342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343130312032323335204D0A2D343520363020560A2D3630202D393420560A3436202D353920560A353920393320560A30206720677361766520343032382032303239204E202D3630202D33302056202D343620323220562036302034372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343032382032303239204D0A2D343620333920560A2D3630202D343720560A3436202D323220560A363020333020560A2E31383338206720677361766520343032342032353130204E202D3630202D38312056202D343620363820562036302036392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343032342032353130204D0A2D343620353620560A2D3630202D363920560A3436202D363820560A363020383120560A2E31383338206720677361766520333237312032343730204E202D3630202D34342056202D343620393420562036302033362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333237312032343730204D0A2D343620383620560A2D3630202D333620560A3436202D393420560A363020343420560A2E30343532206720677361766520333138332032313338204E202D3539202D32382056202D34362031303120562036302033302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333138332032313338204D0A2D34352031303320560A2D3630202D333020560A3436202D31303120560A353920323820560A2E32323836206720677361766520333232352032353536204E202D3630202D33362056202D343520373620562035392032372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333232352032353536204D0A2D343620363720560A2D3539202D323720560A3435202D373620560A363020333620560A2E323632206720677361766520333137392032363233204E202D3539202D32372056202D343620353020562035392031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333137392032363233204D0A2D343620343120560A2D3539202D313820560A3436202D353020560A353920323720560A2E323736206720677361766520343230332032363535204E202D3630202D32372056202D343620323920562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343230332032363535204D0A2D343620313620560A2D3630202D313420560A3436202D323920560A363020323720560A30206720677361766520333237352032303131204E202D3630202D31352056202D343520333820562035392032332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333237352032303131204D0A2D343620343620560A2D3539202D323320560A3435202D333820560A363020313520560A2E30303838206720677361766520333137302032303334204E202D3630202D31392056202D343620373320562036302032322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333137302032303334204D0A2D343620373620560A2D3630202D323220560A3436202D373320560A363020313920560A2E32353533206720677361766520343134332032363238204E202D3630202D35302056202D343520343320562035392033362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343134332032363238204D0A2D343620323920560A2D3539202D333620560A3435202D343320560A363020353020560A2E32323335206720677361766520343038332032353738204E202D3539202D36382056202D343620353620562036302035352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343038332032353738204D0A2D343520343320560A2D3630202D353520560A3436202D353620560A353920363820560A2E31353437206720677361766520343037302032343532204E202D3630202D39312056202D343620363820562036302038312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343037302032343532204D0A2D343620353820560A2D3630202D383120560A3436202D363820560A363020393120560A2E30313331206720677361766520333534362032303230204E202D353920342056202D3436202D3420562035392031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333534362032303230204D0A2D343620313820560A2D3539202D313820560A3436203420560A3539202D3420560A2E30333839206720677361766520343134372032313831204E202D3539202D38382056202D343620343920562035392039332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343134372032313831204D0A2D343620353420560A2D3539202D393320560A3436202D343920560A353920383820560A2E31303237206720677361766520333139372032323738204E202D3539202D33372056202D34362031313020562036302033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333139372032323738204D0A2D34352031303820560A2D3630202D333520560A3436202D31313020560A353920333720560A2E303033206720677361766520343133332032303533204E202D3539202D35332056202D343620323920562036302036342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343133332032303533204D0A2D343520343020560A2D3630202D363420560A3436202D323920560A353920353320560A2E32383338206720677361766520323936382032363536204E202D3630202D31342056202D34362037205620363020392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323936382032363536204D0A2D3436203220560A2D3630202D3920560A3436202D3720560A363020313420560A2E32373733206720677361766520333037342032363436204E202D3630202D32302056202D343620333020562036302031322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333037342032363436204D0A2D343620323220560A2D3630202D313220560A3436202D333020560A363020323020560A2E31363837206720677361766520333231312032343236204E202D3539202D34302056202D34362031303120562035392033332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333231312032343236204D0A2D343620393420560A2D3539202D333320560A3436202D31303120560A353920343020560A2E31323732206720677361766520343131352032333932204E202D3539202D39372056202D343620363620562036302039312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343131352032333932204D0A2D343520363020560A2D3630202D393120560A3436202D363620560A353920393720560A2E32383135206720677361766520343330392032363439204E202D3630202D31362056202D3436203232205620363020352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343330392032363439204D0A2D343620313120560A2D3630202D3520560A3436202D323220560A363020313620560A2E32313639206720677361766520333136352032353230204E202D3539202D33332056202D343620383220562036302032372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333136352032353230204D0A2D343520373620560A2D3630202D323720560A3436202D383220560A353920333320560A2E32353434206720677361766520333132302032353936204E202D3630202D32372056202D343620353720562036302032302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333132302032353936204D0A2D343620353020560A2D3630202D323020560A3436202D353720560A363020323720560A2E30303933206720677361766520333338312032303131204E202D3630202D332056202D3436203320562036302031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333338312032303131204D0A2D343620313820560A2D3630202D313820560A3436202D3320560A3630203320560A2E30343034206720677361766520333132342032313130204E202D3630202D32322056202D343620393920562036302032342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333132342032313130204D0A2D34362031303120560A2D3630202D323420560A3436202D393920560A363020323220560A2E31393936206720677361766520343132392032353331204E202D3539202D37392056202D343620353820562035392036382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343132392032353331204D0A2D343620343720560A2D3539202D363820560A3436202D353820560A353920373920560A2E31303237206720677361766520343136312032333335204E202D3630202D3130302056202D343520363020562035392039372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343136312032333335204D0A2D343620353720560A2D3539202D393720560A3435202D363020560A36302031303020560A2E30323537206720677361766520343139332032313335204E202D3630202D38322056202D343520343020562035392038382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343139332032313335204D0A2D343620343620560A2D3539202D383820560A3435202D343020560A363020383220560A2E303233206720677361766520333635312032303230204E202D35392031372056202D3436202D313720562035392031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333635312032303230204D0A2D343620313020560A2D3539202D313020560A343620313720560A3539202D313720560A2E30393333206720677361766520333133382032323431204E202D3630202D33302056202D34362031313120562036302032392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333133382032323431204D0A2D34362031313020560A2D3630202D323920560A3436202D31313120560A363020333020560A2E32363634206720677361766520343234392032363333204E202D3630202D34302056202D343620333520562036302032372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343234392032363333204D0A2D343620323220560A2D3630202D323720560A3436202D333520560A363020343020560A2E32333831206720677361766520343138392032353933204E202D3630202D36322056202D343620343720562036302035302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343138392032353933204D0A2D343620333520560A2D3630202D353020560A3436202D343720560A363020363220560A2E32383339206720677361766520343431342032363335204E202D3539202D322056202D34362031362056203539202D372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343431342032363335204D0A2D3436203720560A2D3539203720560A3436202D313620560A3539203220560A2E31353635206720677361766520333135322032333836204E202D3630202D33352056202D34362031303520562036302033312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333135322032333836204D0A2D34362031303120560A2D3630202D333120560A3436202D31303520560A363020333520560A2E30303035206720677361766520333231352031393936204E202D3539202D31332056202D343620333220562036302031392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333231352031393936204D0A2D343520333820560A2D3630202D313920560A3436202D333220560A353920313320560A2E30303739206720677361766520333131302032303135204E202D3630202D31352056202D343620373120562036302031372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333131302032303135204D0A2D343620373320560A2D3630202D313720560A3436202D373120560A363020313520560A2E32383038206720677361766520343532302032363130204E202D36302031342056202D34362031312056203630202D32302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343532302032363130204D0A2D3436203520560A2D363020323020560A3436202D313120560A3630202D313420560A2E32373431206720677361766520333031342032363236204E202D3630202D31392056202D343620333520562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333031342032363236204D0A2D343620333020560A2D3630202D313420560A3436202D333520560A363020313920560A2E30303331206720677361766520343037342032303030204E202D3630202D31342056202D343620313320562036302033302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343037342032303030204D0A2D343620323920560A2D3630202D333020560A3436202D313320560A363020313420560A2E32383335206720677361766520323930382032363432204E202D3630202D31352056202D343520313020562035392031322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323930382032363432204D0A2D3436203720560A2D3539202D313220560A3435202D313020560A363020313520560A2E31373535206720677361766520343137352032343832204E202D3630202D39302056202D343520363020562035392037392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343137352032343832204D0A2D343620343920560A2D3539202D373920560A3435202D363020560A363020393020560A2E30383231206720677361766520343230372032323832204E202D3630202D3130312056202D34362035342056203630203130302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343230372032323832204D0A2D343620353320560A2D3630202D31303020560A3436202D353420560A36302031303120560A2E303237206720677361766520333735372032303136204E202D36302032342056202D3436202D3230205620363020352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333735372032303136204D0A2D3436203920560A2D3630202D3520560A343620323020560A3630202D323420560A2E30313331206720677361766520333936382031393939204E202D363020382056202D3436203020562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333936382031393939204D0A2D343620323220560A2D3630202D313420560A3436203020560A3630202D3820560A2E323037206720677361766520333130362032343837204E202D3630202D33312056202D343620383820562036302032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333130362032343837204D0A2D343620383220560A2D3630202D323520560A3436202D383820560A363020333120560A2E32343737206720677361766520333036302032353639204E202D3630202D32352056202D343620363320562036302031392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333036302032353639204D0A2D343620353720560A2D3630202D313920560A3436202D363320560A363020323520560A2E30303034206720677361766520343137392032303139204E202D3539202D34322056202D343620323320562035392035332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343137392032303139204D0A2D343620333420560A2D3539202D353320560A3436202D323320560A353920343220560A2E303233206720677361766520333836322032303037204E202D35392032312056202D3436202D3132205620353920362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333836322032303037204D0A2D343620313520560A2D3539202D3620560A343620313220560A3539202D323120560A2E32373635206720677361766520343335352032363333204E202D3630202D32372056202D343620323720562036302031362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343335352032363333204D0A2D343620313620560A2D3630202D313620560A3436202D323720560A363020323720560A2E30333839206720677361766520333036342032303838204E202D3630202D31372056202D343620393920562036302031372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333036342032303838204D0A2D343620393920560A2D3630202D313720560A3436202D393920560A363020313720560A2E303137206720677361766520343233392032303936204E202D3630202D37372056202D343620333420562036302038322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343233392032303936204D0A2D343620333920560A2D3630202D383220560A3436202D333420560A363020373720560A2E30383737206720677361766520333037382032323131204E202D3630202D32342056202D34362031313220562036302032332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333037382032323131204D0A2D34362031313120560A2D3630202D323320560A3436202D31313220560A363020323420560A2E32353434206720677361766520343239352032363036204E202D3630202D35312056202D343620333820562036302034302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343239352032363036204D0A2D343620323720560A2D3630202D343020560A3436202D333820560A363020353120560A2E32313936206720677361766520343233352032353535204E202D3630202D37332056202D343620343920562036302036322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343233352032353535204D0A2D343620333820560A2D3630202D363220560A3436202D343920560A363020373320560A2E31343735206720677361766520333039322032333531204E202D3630202D32392056202D34362031303820562036302032362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333039322032333531204D0A2D34362031303520560A2D3630202D323620560A3436202D31303820560A363020323920560A2E31353239206720677361766520343232312032343332204E202D3630202D39372056202D343620353720562036302039302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343232312032343332204D0A2D343620353020560A2D3630202D393020560A3436202D353720560A363020393720560A2E30323931206720677361766520333438372032303234204E202D36302031342056202D3436202D3237205620363020392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333438372032303234204D0A2D3436202D3420560A2D3630202D3920560A343620323720560A3630202D313420560A2E30363537206720677361766520343235332032323335204E202D3630202D3130302056202D34362034362056203630203130312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343235332032323335204D0A2D343620343720560A2D3630202D31303120560A3436202D343620560A36302031303020560A2E30313631206720677361766520333332312032303038204E202D3630202D322056202D3436202D313020562036302031352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333332312032303038204D0A2D3436203320560A2D3630202D313520560A343620313020560A3630203220560A2E30303037206720677361766520333135362031393833204E202D3630202D31332056202D343620333020562036302031352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333135362031393833204D0A2D343620333220560A2D3630202D313520560A3436202D333020560A363020313320560A2E30303838206720677361766520333035302032303030204E202D3630202D31322056202D343620373220562036302031312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333035302032303030204D0A2D343620373120560A2D3630202D313120560A3436202D373220560A363020313220560A2E32373134206720677361766520323935342032363037204E202D3630202D31392056202D343620333920562036302031352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323935342032363037204D0A2D343620333520560A2D3630202D313520560A3436202D333920560A363020313920560A2E32383239206720677361766520343436302032363234204E202D3630202D31312056202D3435203230205620353920322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343436302032363234204D0A2D343620313120560A2D3539202D3220560A3435202D323020560A363020313120560A2E31393936206720677361766520333034362032343536204E202D3630202D32362056202D343620393120562036302032332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333034362032343536204D0A2D343620383820560A2D3630202D323320560A3436202D393120560A363020323620560A2E32343235206720677361766520333030302032353434204E202D3630202D32332056202D343620363720562036302031392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333030302032353434204D0A2D343620363320560A2D3630202D313920560A3436202D363720560A363020323320560A2E32383332206720677361766520323834382032363237204E202D3539202D31342056202D343620313220562036302031322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323834382032363237204D0A2D343520313020560A2D3630202D313220560A3436202D313220560A353920313420560A2E31333238206720677361766520343236372032333834204E202D3630202D3130322056202D343620353320562036302039372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343236372032333834204D0A2D343620343820560A2D3630202D393720560A3436202D353320560A36302031303220560A2E32303131206720677361766520343238312032353134204E202D3630202D38322056202D343620353020562036302037332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343238312032353134204D0A2D343620343120560A2D3630202D373320560A3436202D353020560A363020383220560A2E323833206720677361766520343536362032363032204E202D363020372056202D34362031352056203630202D31342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343536362032363032204D0A2D3436203820560A2D363020313420560A3436202D313520560A3630202D3720560A2E313432206720677361766520333033322032333232204E202D3630202D32332056202D34362031303920562036302032322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333033322032333232204D0A2D34362031303820560A2D3630202D323220560A3436202D31303920560A363020323320560A2E30383538206720677361766520333031382032313837204E202D3630202D31372056202D34362031313220562036302031372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333031382032313837204D0A2D34362031313220560A2D3630202D313720560A3436202D31313220560A363020313720560A2E30313136206720677361766520343238352032303634204E202D3630202D37322056202D343620323720562036302037372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343238352032303634204D0A2D343620333220560A2D3630202D373720560A3436202D323720560A363020373220560A2E32363936206720677361766520343430302032363133204E202D3539202D33362056202D343620323920562036302032372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343430302032363133204D0A2D343520323020560A2D3630202D323720560A3436202D323920560A353920333620560A2E32343135206720677361766520343334312032353737204E202D3630202D36332056202D343620343120562036302035312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343334312032353737204D0A2D343620323920560A2D3630202D353120560A3436202D343120560A363020363320560A2E30353335206720677361766520343239392032313935204E202D3630202D39392056202D34362033392056203630203130302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343239392032313935204D0A2D343620343020560A2D3630202D31303020560A3436202D333920560A363020393920560A2E30343034206720677361766520333030342032303731204E202D3630202D31312056202D34362031303020562036302031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333030342032303731204D0A2D343620393920560A2D3630202D313020560A3436202D31303020560A363020313120560A30206720677361766520343232352031393932204E202D3630202D33342056202D343520313920562035392034322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343232352031393932204D0A2D343620323720560A2D3539202D343220560A3435202D313920560A363020333420560A2E30303933206720677361766520343132302031393737204E202D363020312056202D3436203820562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343132302031393737204D0A2D343620323320560A2D3630202D313420560A3436202D3820560A3630202D3120560A2E30343938206720677361766520333539322032303337204E202D36302033322056202D3435202D34352056203539202D342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333539322032303337204D0A2D3436202D313720560A2D3539203420560A343520343520560A3630202D333220560A2E32363936206720677361766520323839342032353838204E202D3539202D31372056202D343620343220562035392031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323839342032353838204D0A2D343620333920560A2D3539202D313420560A3436202D343220560A353920313720560A2E30303035206720677361766520333039362031393730204E202D3630202D31352056202D343620333320562036302031322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333039362031393730204D0A2D343620333020560A2D3630202D313220560A3436202D333320560A363020313520560A2E313935206720677361766520323938362032343330204E202D3630202D32322056202D343620393320562036302032302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323938362032343330204D0A2D343620393120560A2D3630202D323020560A3436202D393320560A363020323220560A2E32333933206720677361766520323934302032353231204E202D3630202D32302056202D343520373020562035392031372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323934302032353231204D0A2D343620363720560A2D3539202D313720560A3435202D373020560A363020323020560A2E31313539206720677361766520343331332032333430204E202D3630202D3130352056202D34362034372056203630203130322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343331332032333430204D0A2D343620343420560A2D3630202D31303220560A3436202D343720560A36302031303520560A2E30323131206720677361766520333236312032303036204E202D3539202D362056202D3436202D313720562035392031332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333236312032303036204D0A2D3436202D313020560A2D3539202D313320560A343620313720560A3539203620560A2E32383331206720677361766520323738392032363133204E202D3630202D31342056202D343620313320562036302031332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323738392032363133204D0A2D343620313220560A2D3630202D313320560A3436202D313320560A363020313420560A2E31383338206720677361766520343332372032343735204E202D3630202D39312056202D343620343820562036302038322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343332372032343735204D0A2D343620333920560A2D3630202D383220560A3436202D343820560A363020393120560A2E30313136206720677361766520323939302031393838204E202D3630202D392056202D3435203735205620353920362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323939302031393838204D0A2D343620373220560A2D3539202D3620560A3435202D373520560A3630203920560A2E30323931206720677361766520343031342031393836204E202D36302033312056202D3436202D31302056203630202D382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343031342031393836204D0A2D343620313320560A2D3630203820560A343620313020560A3630202D333120560A2E32383035206720677361766520343530362032363039204E202D3630202D31382056202D343620323220562036302031312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343530362032363039204D0A2D343620313520560A2D3630202D313120560A3436202D323220560A363020313820560A2E31343032206720677361766520323937322032323939204E202D3630202D31372056202D34362031303920562036302031372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323937322032323939204D0A2D34362031303920560A2D3630202D313720560A3436202D31303920560A363020313720560A2E30343639206720677361766520333432372032303338204E202D36302031362056202D3436202D3436205620363020332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333432372032303338204D0A2D3436202D323720560A2D3630202D3320560A343620343620560A3630202D313620560A2E30343532206720677361766520343334352032313630204E202D3630202D39362056202D343620333220562036302039392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343334352032313630204D0A2D343620333520560A2D3630202D393920560A3436202D333220560A363020393620560A2E323632206720677361766520343434362032353931204E202D3630202D34362056202D343520333220562035392033362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343434362032353931204D0A2D343620323220560A2D3539202D333620560A3435202D333220560A363020343620560A2E32323836206720677361766520343338362032353435204E202D3539202D37302056202D343620333920562036302036332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343338362032353435204D0A2D343520333220560A2D3630202D363320560A3436202D333920560A353920373020560A2E30383737206720677361766520323935382032313730204E202D3630202D31302056202D34352031313120562035392031312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323935382032313730204D0A2D34362031313220560A2D3539202D313120560A3435202D31313120560A363020313020560A2E30303838206720677361766520343333312032303337204E202D3630202D36382056202D343620323320562036302037322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343333312032303337204D0A2D343620323720560A2D3630202D373220560A3436202D323320560A363020363820560A2E30363237206720677361766520333639372032303430204E202D36302034372056202D3435202D35302056203539202D31372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333639372032303430204D0A2D3436202D323020560A2D353920313720560A343520353020560A3630202D343720560A2E32383338206720677361766520343631322032353930204E202D363020322056202D34362031372056203630202D372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343631322032353930204D0A2D343620313220560A2D3630203720560A3436202D313720560A3630202D3220560A2E30343938206720677361766520333930382032303037204E202D36302034392056202D3435202D32382056203539202D32312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333930382032303037204D0A2D3436203020560A2D353920323120560A343520323820560A3630202D343920560A2E31303237206720677361766520343335392032333031204E202D3630202D3130362056202D34362034302056203630203130352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343335392032333031204D0A2D343620333920560A2D3630202D31303520560A3436202D343020560A36302031303620560A2E30343532206720677361766520323934342032303630204E202D3539202D362056202D343620313031205620353920352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323934342032303630204D0A2D34362031303020560A2D3539202D3520560A3436202D31303120560A3539203620560A2E323639206720677361766520323833352032353731204E202D3630202D31342056202D343620343220562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323833352032353731204D0A2D343620343220560A2D3630202D313420560A3436202D343220560A363020313420560A2E31393334206720677361766520323932362032343038204E202D3630202D31372056202D343520393520562035392031352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323932362032343038204D0A2D343620393320560A2D3539202D313520560A3435202D393520560A363020313720560A2E32333831206720677361766520323838302032353031204E202D3539202D31352056202D343620373120562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323838302032353031204D0A2D343520373020560A2D3630202D313420560A3436202D373120560A353920313520560A30206720677361766520333033362031393535204E202D3630202D31342056202D3436203338205620363020392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333033362031393535204D0A2D343620333320560A2D3630202D3920560A3436202D333820560A363020313420560A2E30303035206720677361766520343237312031393639204E202D3630202D32382056202D343620313720562036302033342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343237312031393639204D0A2D343620323320560A2D3630202D333420560A3436202D313720560A363020323820560A2E31363837206720677361766520343337332032343337204E202D3630202D39372056202D343620343420562036302039312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343337332032343337204D0A2D343620333820560A2D3630202D393120560A3436202D343420560A363020393720560A2E30363237206720677361766520333830332032303238204E202D36302035352056202D3436202D34332056203630202D32342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333830332032303238204D0A2D3436202D313220560A2D363020323420560A343620343320560A3630202D353520560A2E32383332206720677361766520323732392032353939204E202D3630202D31342056202D343620313220562036302031352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323732392032353939204D0A2D343620313320560A2D3630202D313520560A3436202D313220560A363020313420560A2E303233206720677361766520333230322032303030204E202D3630202D31302056202D3436202D323020562036302031332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333230322032303030204D0A2D3436202D313720560A2D3630202D313320560A343620323020560A363020313020560A2E30313631206720677361766520343136352031393538204E202D35392031342056202D343620362056203630202D312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343136352031393538204D0A2D343520313920560A2D3630203120560A3436202D3620560A3539202D313420560A2E313432206720677361766520323931322032323832204E202D3539202D31312056202D34362031303920562035392031312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323931322032323832204D0A2D34362031303920560A2D3539202D313120560A3436202D31303920560A353920313120560A2E32373733206720677361766520343535322032353932204E202D3630202D32352056202D343620323420562036302031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343535322032353932204D0A2D343620313720560A2D3630202D313820560A3436202D323420560A363020323520560A2E303137206720677361766520323933302031393739204E202D3539202D352056202D34362038312056203630202D312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323933302031393739204D0A2D343520373520560A2D3630203120560A3436202D383120560A3539203520560A2E32353434206720677361766520343439322032353637204E202D3630202D35332056202D343620333120562036302034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343439322032353637204D0A2D343620323420560A2D3630202D343620560A3436202D333120560A363020353320560A2E32313639206720677361766520343433322032353134204E202D3539202D37372056202D343620333820562035392037302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343433322032353134204D0A2D343620333120560A2D3539202D373020560A3436202D333820560A353920373720560A2E30343034206720677361766520343339312032313333204E202D3630202D39362056202D343620323720562036302039362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343339312032313333204D0A2D343620323720560A2D3630202D393620560A3436202D323720560A363020393620560A2E30393333206720677361766520343430352032323637204E202D3630202D3130372056202D34362033352056203630203130362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343430352032323637204D0A2D343620333420560A2D3630202D31303620560A3436202D333520560A36302031303720560A2E30393333206720677361766520323839382032313630204E202D3539202D352056202D343620313132205620363020342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323839382032313630204D0A2D34352031313120560A2D3630202D3420560A3436202D31313220560A3539203520560A2E30303739206720677361766520343337372032303137204E202D3630202D36372056202D343620313920562036302036382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343337372032303137204D0A2D343620323020560A2D3630202D363820560A3436202D313920560A363020363720560A2E31353635206720677361766520343431382032343032204E202D3539202D3130312056202D343620333920562036302039372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343431382032343032204D0A2D343520333520560A2D3630202D393720560A3436202D333920560A35392031303120560A2E32363936206720677361766520323737352032353537204E202D3630202D31332056202D343620343120562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323737352032353537204D0A2D343620343220560A2D3630202D313420560A3436202D343120560A363020313320560A2E30303034206720677361766520323937362031393431204E202D3630202D31342056202D3435203437205620353920352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323937362031393431204D0A2D343620333820560A2D3539202D3520560A3435202D343720560A363020313420560A2E313935206720677361766520323836362032333931204E202D3539202D31312056202D343620393420562036302031322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323836362032333931204D0A2D343520393520560A2D3630202D313220560A3436202D393420560A353920313120560A2E32333933206720677361766520323832312032343836204E202D3630202D31322056202D343620373020562036302031332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323832312032343836204D0A2D343620373120560A2D3630202D313320560A3436202D373020560A363020313220560A2E32383338206720677361766520343635382032353737204E202D3630202D332056202D34362031382056203630202D322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343635382032353737204D0A2D343620313320560A2D3630203220560A3436202D313820560A3630203320560A2E30323131206720677361766520333134322031393930204E202D3630202D31372056202D3436202D313820562036302031352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333134322031393930204D0A2D3436202D323020560A2D3630202D313520560A343620313820560A363020313720560A2E30363237206720677361766520333336372032303534204E202D36302031342056202D3436202D3632205620363020322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333336372032303534204D0A2D3436202D343620560A2D3630202D3220560A343620363220560A3630202D313420560A2E32383335206720677361766520323636392032353835204E202D3630202D31332056202D343620313020562036302031352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323636392032353835204D0A2D343620313220560A2D3630202D313520560A3436202D313020560A363020313320560A2E30383134206720677361766520333533322032303639204E202D35392034312056202D3436202D37322056203630202D31342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333533322032303639204D0A2D3435202D343520560A2D363020313420560A343620373220560A3539202D343120560A2E30353335206720677361766520323838352032303534204E202D363020312056202D3436203130332056203630202D332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323838352032303534204D0A2D34362031303120560A2D3630203320560A3436202D31303320560A3630202D3120560A2E30343639206720677361766520343036302031393738204E202D36302035312056202D3436202D31322056203630202D33312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343036302031393738204D0A2D3436203820560A2D363020333120560A343620313220560A3630202D353120560A2E30303037206720677361766520343331372031393530204E202D3630202D32372056202D343620313820562036302032382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343331372031393530204D0A2D343620313920560A2D3630202D323820560A3436202D313820560A363020323720560A2E323037206720677361766520343437382032343836204E202D3630202D38342056202D343520333520562035392037372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343437382032343836204D0A2D343620323820560A2D3539202D373720560A3435202D333520560A363020383420560A2E31343735206720677361766520323835332032323731204E202D3630202D342056202D343620313037205620363020362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323835332032323731204D0A2D34362031303920560A2D3630202D3620560A3436202D31303720560A3630203420560A2E32373431206720677361766520343539382032353734204E202D3630202D33302056202D343620323320562036302032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343539382032353734204D0A2D343620313820560A2D3630202D323520560A3436202D323320560A363020333020560A2E32343737206720677361766520343533382032353434204E202D3630202D35382056202D343620323820562036302035332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343533382032353434204D0A2D343620323320560A2D3630202D353320560A3436202D323820560A363020353820560A2E30333839206720677361766520343433372032313131204E202D3630202D39342056202D343620323020562036302039362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343433372032313131204D0A2D343620323220560A2D3630202D393620560A3436202D323020560A363020393420560A2E30383737206720677361766520343435302032323430204E202D3539202D3130372056202D34362032372056203630203130372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343435302032323430204D0A2D343520323720560A2D3630202D31303720560A3436202D323720560A35392031303720560A2E30323131206720677361766520343231312031393431204E202D36302032322056202D343520392056203539202D31342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343231312031393431204D0A2D343620313720560A2D353920313420560A3435202D3920560A3630202D323220560A2E31343735206720677361766520343436342032333731204E202D3539202D3130342056202D34362033342056203539203130312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343436342032333731204D0A2D343620333120560A2D3539202D31303120560A3436202D333420560A35392031303420560A2E30313631206720677361766520333038322031393733204E202D3630202D32332056202D3436202D3920562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333038322031393733204D0A2D3436202D313820560A2D3630202D313420560A3436203920560A363020323320560A2E32373134206720677361766520323731352032353434204E202D3630202D31312056202D343620333920562036302031332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323731352032353434204D0A2D343620343120560A2D3630202D313320560A3436202D333920560A363020313120560A2E30323537206720677361766520323837312031393734204E202D363020312056202D34362038372056203630202D372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323837312031393734204D0A2D343620383120560A2D3630203720560A3436202D383720560A3630202D3120560A2E303033206720677361766520323931362031393237204E202D3539202D392056202D34362035372056203630202D312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323931362031393237204D0A2D343520343720560A2D3630203120560A3436202D353720560A3539203920560A2E31393936206720677361766520323830372032333830204E202D3630202D362056202D3436203932205620363020382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323830372032333830204D0A2D343620393420560A2D3630202D3820560A3436202D393220560A3630203620560A2E32343235206720677361766520323736312032343734204E202D3630202D382056202D343620363720562036302031312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323736312032343734204D0A2D343620373020560A2D3630202D313120560A3436202D363720560A3630203820560A2E31303237206720677361766520323833392032313535204E202D363020332056202D3436203131302056203630202D312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323833392032313535204D0A2D34362031313220560A2D3630203120560A3436202D31313020560A3630202D3320560A2E32383338206720677361766520323630392032353732204E202D3630202D31342056202D3435203720562035392031372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323630392032353732204D0A2D343620313020560A2D3539202D313720560A3435202D3720560A363020313420560A2E30303838206720677361766520343432332032303031204E202D3630202D36382056202D343620313720562036302036372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343432332032303031204D0A2D343620313620560A2D3630202D363720560A3436202D313720560A363020363820560A2E32383335206720677361766520343730332032353632204E202D3539202D362056202D3436203138205620363020332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343730332032353632204D0A2D343520313520560A2D3630202D3320560A3436202D313820560A3539203620560A2E30383134206720677361766520333935342032303137204E202D36302037362056202D3436202D33372056203630202D34392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333935342032303137204D0A2D3436202D313020560A2D363020343920560A343620333720560A3630202D373620560A2E30373336206720677361766520333330372032303638204E202D363020342056202D3435202D3732205620353920362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333330372032303638204D0A2D3436202D363220560A2D3539202D3620560A343520373220560A3630202D3420560A2E30303035206720677361766520343336332031393333204E202D3630202D32382056202D343620313820562036302032372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343336332031393333204D0A2D343620313720560A2D3630202D323720560A3436202D313820560A363020323820560A2E313038206720677361766520333633372032303837204E202D35392036342056202D3436202D38322056203630202D33322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333633372032303837204D0A2D3435202D353020560A2D363020333220560A343620383220560A3539202D363420560A2E30303933206720677361766520333032322031393530204E202D3630202D32352056202D3436203220562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333032322031393530204D0A2D3436202D3920560A2D3630202D313420560A3436202D3220560A363020323520560A2E31393936206720677361766520343532342032343539204E202D3630202D38382056202D343620333120562036302038342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343532342032343539204D0A2D343620323720560A2D3630202D383420560A3436202D333120560A363020383820560A2E30363537206720677361766520323832352032303535204E202D363020372056202D3436203130342056203630202D382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323832352032303535204D0A2D34362031303320560A2D3630203820560A3436202D31303420560A3630202D3720560A2E32373134206720677361766520343634342032353536204E202D3630202D33352056202D343620323320562036302033302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343634342032353536204D0A2D343620313820560A2D3630202D333020560A3436202D323320560A363020333520560A2E32343235206720677361766520343538342032353231204E202D3630202D36322056202D343620323720562036302035382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343538342032353231204D0A2D343620323320560A2D3630202D353820560A3436202D323720560A363020363220560A2E31353635206720677361766520323739332032323637204E202D363020312056202D343620313035205620363020312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323739332032323637204D0A2D34362031303720560A2D3630202D3120560A3436202D31303520560A3630202D3120560A2E313432206720677361766520343531302032333435204E202D3630202D3130352056202D34352032372056203539203130342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343531302032333435204D0A2D343620323620560A2D3539202D31303420560A3435202D323720560A36302031303520560A2E30383538206720677361766520343439362032323139204E202D3539202D3130382056202D34362032322056203539203130372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343439362032323139204D0A2D343620323120560A2D3539202D31303720560A3436202D323220560A35392031303820560A2E32373431206720677361766520323635352032353333204E202D3630202D392056202D343620333420562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323635352032353333204D0A2D343620333920560A2D3630202D313420560A3436202D333420560A3630203920560A2E30343034206720677361766520343438322032303936204E202D3539202D39352056202D343620313620562036302039342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343438322032303936204D0A2D343520313520560A2D3630202D393420560A3436202D313620560A353920393520560A2E313038206720677361766520333834382032303536204E202D35392038372056202D3436202D36302056203630202D35352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333834382032303536204D0A2D3435202D323820560A2D363020353520560A343620363020560A3539202D383720560A2E32383338206720677361766520323534392032353538204E202D3539202D31332056202D3436203220562036302031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323534392032353538204D0A2D3435203720560A2D3630202D313820560A3436202D3220560A353920313320560A2E303233206720677361766520343235372031393233204E202D36302032352056202D34362031352056203630202D32322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343235372031393233204D0A2D343620313820560A2D363020323220560A3436202D313520560A3630202D323520560A2E30363237206720677361766520343130362031393732204E202D36302036362056202D3436202D392056203630202D35312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343130362031393732204D0A2D3436203620560A2D363020353120560A3436203920560A3630202D363620560A2E313138206720677361766520333734332032303833204E202D36302038312056202D3436202D37372056203630202D34372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333734332032303833204D0A2D3436202D343320560A2D363020343720560A343620373720560A3630202D383120560A2E323037206720677361766520323734372032333734204E202D3630202D312056202D3436203838205620363020352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323734372032333734204D0A2D343620393220560A2D3630202D3520560A3436202D383820560A3630203120560A2E32343737206720677361766520323730312032343636204E202D3630202D352056202D3436203633205620363020392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323730312032343636204D0A2D343620363720560A2D3630202D3920560A3436202D363320560A3630203520560A2E30303937206720677361766520323835372031393138204E202D3630202D322056202D34362036382056203630202D392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323835372031393138204D0A2D343620353720560A2D3630203920560A3436202D363820560A3630203220560A2E30303331206720677361766520323936322031393235204E202D3539202D32352056202D3436203138205620353920392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323936322031393235204D0A2D3436203220560A2D3539202D3920560A3436202D313820560A353920323520560A2E31313239206720677361766520333437332032313130204E202D36302034302056202D3436202D39362056203630202D31362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333437332032313130204D0A2D3436202D373220560A2D363020313620560A343620393620560A3630202D343020560A2E32383332206720677361766520343734392032353435204E202D3539202D382056202D3436203139205620353920362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343734392032353435204D0A2D343620313720560A2D3539202D3620560A3436202D313920560A3539203820560A2E31313539206720677361766520323737392032313538204E202D363020382056202D3436203130392056203630202D372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323737392032313538204D0A2D34362031313020560A2D3630203720560A3436202D31303920560A3630202D3820560A2E30333839206720677361766520323831312031393735204E202D363020392056202D34362039322056203630202D31342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323831312031393735204D0A2D343620383720560A2D363020313420560A3436202D393220560A3630202D3920560A2E30373734206720677361766520333234372032303732204E202D3539202D372056202D3436202D373520562036302031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333234372032303732204D0A2D3435202D373220560A2D3630202D313020560A343620373520560A3539203720560A2E30313136206720677361766520343436382031393931204E202D3539202D37312056202D343620313320562036302036382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343436382031393931204D0A2D343520313020560A2D3630202D363820560A3436202D313320560A353920373120560A2E313935206720677361766520343537302032343335204E202D3630202D39302056202D343620323620562036302038382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343537302032343335204D0A2D343620323420560A2D3630202D383820560A3436202D323620560A363020393020560A30206720677361766520343430392031393230204E202D3630202D33342056202D343620313920562036302032382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343430392031393230204D0A2D343620313320560A2D3630202D323820560A3436202D313920560A363020333420560A2E32363936206720677361766520343639302032353337204E202D3630202D33372056202D343620323120562036302033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343639302032353337204D0A2D343620313920560A2D3630202D333520560A3436202D323120560A363020333720560A2E32333933206720677361766520343633302032353030204E202D3630202D36352056202D343620323420562036302036322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343633302032353030204D0A2D343620323120560A2D3630202D363220560A3436202D323420560A363020363520560A2E323833206720677361766520323439302032353435204E202D3630202D31362056202D3436202D3320562036302032312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323439302032353435204D0A2D3436203220560A2D3630202D323120560A3436203320560A363020313620560A30206720677361766520323930332031393030204E202D3630202D31392056202D3436203335205620363020322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323930332031393030204D0A2D343620313820560A2D3630202D3220560A3436202D333520560A363020313920560A2E31343032206720677361766520343535362032333234204E202D3630202D3130352056202D34362032312056203630203130352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343535362032333234204D0A2D343620323120560A2D3630202D31303520560A3436202D323120560A36302031303520560A2E32373733206720677361766520323539352032353234204E202D3539202D392056202D343620333020562035392031332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323539352032353234204D0A2D343620333420560A2D3539202D313320560A3436202D333020560A3539203920560A2E31363837206720677361766520323733332032323638204E202D363020372056202D3436203130312056203630202D332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323733332032323638204D0A2D34362031303520560A2D3630203320560A3436202D31303120560A3630202D3720560A2E30383737206720677361766520343534322032323034204E202D3630202D3130382056202D34352031352056203539203130382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343534322032323034204D0A2D343620313520560A2D3539202D31303820560A3435202D313520560A36302031303820560A2E30323131206720677361766520343330332031393035204E202D36302032312056202D34362032322056203630202D32352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343330332031393035204D0A2D343620313820560A2D363020323520560A3436202D323220560A3630202D323120560A2E30383231206720677361766520323736352032303632204E202D36302031342056202D3436203130352056203630202D31352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323736352032303632204D0A2D34362031303420560A2D363020313520560A3436202D31303520560A3630202D313420560A2E30373336206720677361766520333138382032303635204E202D3630202D32302056202D3436202D373220562036302031372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333138382032303635204D0A2D3436202D373520560A2D3630202D313720560A343620373220560A363020323020560A2E32313639206720677361766520323638372032333733204E202D363020332056202D3436203833205620363020322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323638372032333733204D0A2D343620383820560A2D3630202D3220560A3436202D383320560A3630202D3320560A2E32353434206720677361766520323634312032343631204E202D3630202D322056202D3435203536205620353920392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323634312032343631204D0A2D343620363320560A2D3539202D3920560A3435202D353620560A3630203220560A2E30343532206720677361766520343532382032303838204E202D3630202D39372056202D343520313020562035392039352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343532382032303838204D0A2D3436203820560A2D3539202D393520560A3435202D313020560A363020393720560A2E32383331206720677361766520343739352032353237204E202D3630202D382056202D3435203138205620353920382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343739352032353237204D0A2D343620313820560A2D3539202D3820560A3435202D313820560A3630203820560A2E30323138206720677361766520323739372031393136204E202D363020362056202D34362037392056203630202D31372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323739372031393136204D0A2D343620363820560A2D363020313720560A3436202D373920560A3630202D3620560A2E30373336206720677361766520343135312031393633204E202D35392037362056202D3436202D312056203630202D36362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343135312031393633204D0A2D3435203920560A2D363020363620560A3436203120560A3539202D373620560A2E31313239206720677361766520343030302032303239204E202D3630203130302056202D3436202D33362056203630202D37362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343030302032303239204D0A2D3436202D313220560A2D363020373620560A343620333620560A3630202D31303020560A2E32383038206720677361766520323433302032353239204E202D3630202D31372056202D3436202D313020562036302032342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323433302032353239204D0A2D3436202D3320560A2D3630202D323420560A343620313020560A363020313720560A2E31393334206720677361766520343631362032343135204E202D3630202D39312056202D343620323120562036302039302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343631362032343135204D0A2D343620323020560A2D3630202D393020560A3436202D323120560A363020393120560A2E30363237206720677361766520333132382032303435204E202D3630202D33332056202D3436202D363220562036302032332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333132382032303435204D0A2D3436202D373220560A2D3630202D323320560A343620363220560A363020333320560A2E30303034206720677361766520343435352031393131204E202D3630202D34332056202D343620313820562036302033342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343435352031393131204D0A2D3436203920560A2D3630202D333420560A3436202D313820560A363020343320560A2E31333238206720677361766520323731392032313636204E202D36302031352056202D3436203130362056203630202D31322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323731392032313636204D0A2D34362031303920560A2D363020313220560A3436202D31303620560A3630202D313520560A2E30303235206720677361766520323834332031383831204E202D3630202D31302056202D34362035312056203630202D362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323834332031383831204D0A2D343620333520560A2D3630203620560A3436202D353120560A363020313020560A2E323639206720677361766520343733352032353139204E202D3539202D33372056202D343620313820562036302033372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343733352032353139204D0A2D343520313820560A2D3630202D333720560A3436202D313820560A353920333720560A2E32333831206720677361766520343637362032343832204E202D3630202D36372056202D343620323020562036302036352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343637362032343832204D0A2D343620313820560A2D3630202D363520560A3436202D323020560A363020363720560A2E32383035206720677361766520323533362032353135204E202D3630202D382056202D343620323220562036302031362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323533362032353135204D0A2D343620333020560A2D3630202D313620560A3436202D323220560A3630203820560A2E303137206720677361766520343531342031393837204E202D3539202D37362056202D3436203920562035392037312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343531342031393837204D0A2D3436203420560A2D3539202D373120560A3436202D3920560A353920373620560A2E30343639206720677361766520333036382032303132204E202D3630202D34312056202D3436202D343620562036302032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333036382032303132204D0A2D3436202D363220560A2D3630202D323520560A343620343620560A363020343120560A2E30313631206720677361766520343334392031383836204E202D36302031332056202D34362032372056203630202D32312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343334392031383836204D0A2D343620313920560A2D363020323120560A3436202D323720560A3630202D313320560A2E30353639206720677361766520323735312031393834204E202D36302031372056202D34362039372056203630202D32322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323735312031393834204D0A2D343620393220560A2D363020323220560A3436202D393720560A3630202D313720560A2E31333935206720677361766520333431332032313530204E202D36302033322056202D3436202D3131342056203630202D31342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333431332032313530204D0A2D3436202D393620560A2D363020313420560A34362031313420560A3630202D333220560A2E313432206720677361766520343630322032333038204E202D3630202D3130342056202D34362031352056203630203130352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343630322032333038204D0A2D343620313620560A2D3630202D31303520560A3436202D313520560A36302031303420560A2E31353732206720677361766520333537382032313531204E202D35392037312056202D3436202D3131322056203539202D34312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333537382032313531204D0A2D3436202D383220560A2D353920343120560A34362031313220560A3539202D373120560A2E30323931206720677361766520333030382031393731204E202D3630202D34342056202D3435202D323720562035392032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333030382031393731204D0A2D3436202D343620560A2D3539202D323520560A343520323720560A363020343420560A2E31383338206720677361766520323637332032323735204E202D36302031322056202D34352039352056203539202D362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323637332032323735204D0A2D34362031303120560A2D3539203620560A3435202D393520560A3630202D313220560A2E32323836206720677361766520323632372032333736204E202D353920362056202D3436203736205620353920312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323632372032333736204D0A2D343620383320560A2D3539202D3120560A3436202D373620560A3539202D3620560A2E323632206720677361766520323538312032343539204E202D3539202D312056202D3436203439205620363020382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323538312032343539204D0A2D343520353620560A2D3630202D3820560A3436202D343920560A3539203120560A2E32373638206720677361766520323337302032353132204E202D3630202D32302056202D3436202D313620562036302032362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323337302032353132204D0A2D3436202D313020560A2D3630202D323620560A343620313620560A363020323020560A2E30393333206720677361766520343538382032313935204E202D3630202D3130372056202D343620382056203630203130382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343538382032313935204D0A2D3436203920560A2D3630202D31303820560A3436202D3820560A36302031303720560A2E30313331206720677361766520323934382031393237204E202D3539202D34322056202D3436202D3420562036302031392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323934382031393237204D0A2D3435202D323720560A2D3630202D313920560A3436203420560A353920343220560A2E32383332206720677361766520343834312032353039204E202D3630202D382056202D3436203138205620363020382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343834312032353039204D0A2D343620313820560A2D3630202D3820560A3436202D313820560A3630203820560A2E31303237206720677361766520323730352032303736204E202D36302032322056202D3435203130342056203539202D32312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323730352032303736204D0A2D34362031303520560A2D353920323120560A3435202D31303420560A3630202D323220560A2E30353335206720677361766520343537342032303836204E202D3630202D39392056202D3436203420562036302039372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343537342032303836204D0A2D3436203220560A2D3630202D393720560A3436202D3420560A363020393920560A2E313935206720677361766520343636322032333939204E202D3630202D39312056202D343620313620562036302039312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343636322032333939204D0A2D343620313620560A2D3630202D393120560A3436202D313620560A363020393120560A2E30373734206720677361766520343139372031393438204E202D35392037392056202D34362031322056203539202D37362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343139372031393438204D0A2D343620313520560A2D353920373620560A3436202D313220560A3539202D373920560A2E32383239206720677361766520323437362032353037204E202D3630202D392056202D343620313420562036302031372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323437362032353037204D0A2D343620323220560A2D3630202D313720560A3436202D313420560A3630203920560A2E31353732206720677361766520333839342032303933204E202D3539203131362056202D3436202D36362056203539202D38372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333839342032303933204D0A2D3436202D333720560A2D353920383720560A343620363620560A3539202D31313620560A2E30303933206720677361766520343339352031383638204E202D363020322056202D34362032392056203630202D31332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343339352031383638204D0A2D343620313820560A2D363020313320560A3436202D323920560A3630202D3220560A2E303033206720677361766520343530302031393038204E202D3539202D35332056202D343620313320562036302034332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343530302031393038204D0A2D3435203320560A2D3630202D343320560A3436202D313320560A353920353320560A2E30303235206720677361766520323838392031383835204E202D3630202D33322056202D343620313820562036302031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323838392031383835204D0A2D3436202D3420560A2D3630202D313020560A3436202D313820560A363020333220560A2E32373035206720677361766520323331302032343932204E202D3539202D32352056202D3436202D323220562035392033312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323331302032343932204D0A2D3436202D313620560A2D3539202D333120560A343620323220560A353920323520560A2E32363936206720677361766520343738312032353031204E202D3539202D33362056202D343620313720562035392033372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343738312032353031204D0A2D343620313820560A2D3539202D333720560A3436202D313720560A353920333620560A2E32333933206720677361766520343732322032343635204E202D3630202D36362056202D343620313620562036302036372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343732322032343635204D0A2D343620313720560A2D3630202D363720560A3436202D313620560A363020363620560A2E30313236206720677361766520323738332031383731204E202D363020342056202D34362036362056203630202D31392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323738332031383731204D0A2D343620353120560A2D363020313920560A3436202D363620560A3630202D3420560A2E30343034206720677361766520323733372031393232204E202D36302031392056202D34362038362056203630202D32362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323733372031393232204D0A2D343620373920560A2D363020323620560A3436202D383620560A3630202D313920560A2E313833206720677361766520333638332032313634204E202D36302039382056202D3435202D3131312056203539202D36342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333638332032313634204D0A2D3436202D373720560A2D353920363420560A34352031313120560A3630202D393820560A2E31353239206720677361766520323635392032313831204E202D35392032312056202D3436203130312056203539202D31362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323635392032313831204D0A2D34362031303620560A2D353920313620560A3436202D31303120560A3539202D323120560A2E31343735206720677361766520343634382032323938204E202D3630202D3130332056202D343620392056203630203130342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343634382032323938204D0A2D343620313020560A2D3630202D31303420560A3436202D3920560A36302031303320560A2E30323537206720677361766520343536302031393930204E202D3630202D38322056202D3435203320562035392037362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343536302031393930204D0A2D3436202D3320560A2D3539202D373620560A3435202D3320560A363020383220560A2E32363936206720677361766520323532322032343538204E202D3630202D312056202D3436203431205620363020392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323532322032343538204D0A2D343620343920560A2D3630202D3920560A3436202D343120560A3630203120560A2E32363134206720677361766520323235312032343637204E202D3630202D32392056202D3436202D323720562036302033342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323235312032343637204D0A2D3436202D323220560A2D3630202D333420560A343620323720560A363020323920560A2E313833206720677361766520333738392032313433204E202D3630203131352056202D3436202D39342056203630202D38312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333738392032313433204D0A2D3436202D363020560A2D363020383120560A343620393420560A3630202D31313520560A2E31353732206720677361766520333335332032313832204E202D36302031362056202D3436202D3132362056203630202D342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333335332032313832204D0A2D3436202D31313420560A2D3630203420560A34362031323620560A3630202D313620560A2E32303131206720677361766520323631332032323837204E202D35392031362056202D34362038382056203630202D392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323631332032323837204D0A2D343520393520560A2D3630203920560A3436202D383820560A3539202D313620560A2E32343135206720677361766520323536382032333832204E202D363020392056202D3436203636205620363020312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323536382032333832204D0A2D343620373620560A2D3630202D3120560A3436202D363620560A3630202D3920560A2E31333935206720677361766520343034362032303338204E202D3630203131382056202D3436202D32372056203630202D3130302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343034362032303338204D0A2D3436202D3920560A2D36302031303020560A343620323720560A3630202D31313820560A2E32383339206720677361766520323431362032343938204E202D3630202D31322056202D3436203620562036302032302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323431362032343938204D0A2D343620313420560A2D3630202D323020560A3436202D3620560A363020313220560A2E30303034206720677361766520323832392031383533204E202D3630202D31382056202D34362034302056203630202D342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323832392031383533204D0A2D343620313820560A2D3630203420560A3436202D343020560A363020313820560A2E32383335206720677361766520343838372032343930204E202D3630202D362056202D3436203137205620363020382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343838372032343930204D0A2D343620313920560A2D3630202D3820560A3436202D313720560A3630203620560A2E30383033206720677361766520323639312032303031204E202D36302032362056202D34352039392056203539202D32382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323639312032303031204D0A2D343620393720560A2D353920323820560A3435202D393920560A3630202D323620560A2E30373336206720677361766520343234332031393236204E202D36302037372056202D34352032342056203539202D37392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343234332031393236204D0A2D343620323220560A2D353920373920560A3435202D323420560A3630202D373720560A2E30303331206720677361766520343434312031383535204E202D3630202D31342056202D34362032392056203630202D322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343434312031383535204D0A2D343620313320560A2D3630203220560A3436202D323920560A363020313420560A2E31303237206720677361766520343633342032313932204E202D3630202D3130362056202D343620322056203630203130372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343633342032313932204D0A2D3436203320560A2D3630202D31303720560A3436202D3220560A36302031303620560A2E32343934206720677361766520323139312032343338204E202D3630202D33352056202D3436202D333120562036302033392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323139312032343338204D0A2D3436202D323720560A2D3630202D333920560A343620333120560A363020333520560A2E31393936206720677361766520343730382032333836204E202D3630202D38382056202D343620313020562036302039312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343730382032333836204D0A2D343620313320560A2D3630202D393120560A3436202D313020560A363020383820560A2E32373134206720677361766520343832372032343834204E202D3630202D33342056202D343520313520562035392033362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343832372032343834204D0A2D343620313720560A2D3539202D333620560A3435202D313520560A363020333420560A2E32343235206720677361766520343736372032343530204E202D3539202D36342056202D343620313320562036302036362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343736372032343530204D0A2D343520313520560A2D3630202D363620560A3436202D313320560A353920363420560A2E32333435206720677361766520323133312032343033204E202D3630202D33392056202D3436202D333420562036302034322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323133312032343033204D0A2D3436202D333120560A2D3630202D343220560A343620333420560A363020333920560A2E31323732206720677361766520323634352032303938204E202D35392032382056202D3436203130312056203630202D32352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323634352032303938204D0A2D34352031303420560A2D363020323520560A3436202D31303120560A3539202D323820560A2E30363537206720677361766520343632302032303930204E202D3630202D3130302056202D3436202D3320562036302039392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343632302032303930204D0A2D3436202D3420560A2D3630202D393920560A3436203320560A36302031303020560A2E30303937206720677361766520343534362031393132204E202D3539202D36342056202D3436203720562035392035332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343534362031393132204D0A2D3436202D3420560A2D3539202D353320560A3436202D3720560A353920363420560A2E323137206720677361766520323037312032333634204E202D3630202D34342056202D3435202D333420562035392034342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323037312032333634204D0A2D3436202D333420560A2D3539202D343420560A343520333420560A363020343420560A2E30363237206720677361766520343238392031383939204E202D36302036372056202D34362033372056203630202D37372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343238392031383939204D0A2D343620323720560A2D363020373720560A3436202D333720560A3630202D363720560A2E32383237206720677361766520323335362032343836204E202D3630202D31362056202D3435202D3320562035392032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323335362032343836204D0A2D3436203620560A2D3539202D323520560A3435203320560A363020313620560A2E32373635206720677361766520323436322032343537204E202D3630202D322056202D343620333120562036302031322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323436322032343537204D0A2D343620343120560A2D3630202D313220560A3436202D333120560A3630203220560A2E32303431206720677361766520333531392032323232204E202D36302036362056202D3436202D3133382056203630202D34302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333531392032323232204D0A2D3436202D31313220560A2D363020343020560A34362031333820560A3630202D363620560A2E31363334206720677361766520333239332032313938204E202D3630202D332056202D3435202D313330205620353920372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333239332032313938204D0A2D3436202D31323620560A2D3539202D3720560A34352031333020560A3630203320560A2E30333133206720677361766520323732332031383735204E202D36302031382056202D34352037372056203539202D32392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323732332031383735204D0A2D343620363620560A2D353920323920560A3435202D373720560A3630202D313820560A2E31393736206720677361766520323031312032333230204E202D3539202D34382056202D3436202D333220562036302034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323031312032333230204D0A2D3435202D333420560A2D3630202D343620560A343620333220560A353920343820560A2E31353635206720677361766520343639342032323933204E202D3630202D3130312056202D343620332056203630203130332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343639342032323933204D0A2D3436203520560A2D3630202D31303320560A3436202D3320560A36302031303120560A2E31373535206720677361766520323630302032323032204E202D36302032352056202D34362039342056203630202D31382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323630302032323032204D0A2D34362031303120560A2D363020313820560A3436202D393420560A3630202D323520560A30206720677361766520343438372031383438204E202D3630202D33302056202D343620323320562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343438372031383438204D0A2D3436203720560A2D3630202D313420560A3436202D323320560A363020333020560A2E31373731206720677361766520313935322032323732204E202D3630202D34392056202D3436202D323820562036302034352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313935322032323732204D0A2D3436202D333220560A2D3630202D343520560A343620323820560A363020343920560A2E32383338206720677361766520343933332032343639204E202D3630202D322056202D3436203137205620363020362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343933332032343639204D0A2D343620323120560A2D3630202D3620560A3436202D313720560A3630203220560A2E303233206720677361766520323933352031393330204E202D3630202D36302056202D3436202D313720562036302033322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323933352031393330204D0A2D3436202D343520560A2D3630202D333220560A343620313720560A363020363020560A2E30303838206720677361766520323736392031383335204E202D363020312056202D34362035372056203630202D31382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323736392031383335204D0A2D343620343020560A2D363020313820560A3436202D353720560A3630202D3120560A2E32313936206720677361766520323535342032333033204E202D36302031382056202D34362037382056203630202D382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323535342032333033204D0A2D343620383820560A2D3630203820560A3436202D373820560A3630202D313820560A2E32353434206720677361766520323530382032333931204E202D363020382056202D3436203536205620363020322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323530382032333931204D0A2D343620363620560A2D3630202D3220560A3436202D353620560A3630202D3820560A2E31353638206720677361766520313839322032323233204E202D3630202D34392056202D3436202D323120562036302034322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313839322032323233204D0A2D3436202D323820560A2D3630202D343220560A343620323120560A363020343920560A2E30303533206720677361766520323837352031383730204E202D3630202D34342056202D3436203920562036302031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323837352031383730204D0A2D3436202D313720560A2D3630202D313820560A3436202D3920560A363020343420560A2E30363537206720677361766520323637372031393431204E202D35392032392056202D34362039322056203539202D33352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323637372031393431204D0A2D343620383620560A2D353920333520560A3436202D393220560A3539202D323920560A2E30343639206720677361766520343333352031383730204E202D36302035302056202D34362034362056203630202D36372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343333352031383730204D0A2D343620323920560A2D363020363720560A3436202D343620560A3630202D353020560A2E30333839206720677361766520343630362032303030204E202D3630202D38382056202D3436202D3420562036302038322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343630362032303030204D0A2D3436202D313020560A2D3630202D383220560A3436203420560A363020383820560A2E313338206720677361766520313833322032313734204E202D3630202D34362056202D3436202D313320562036302033382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313833322032313734204D0A2D3436202D323120560A2D3630202D333820560A343620313320560A363020343620560A2E30343938206720677361766520323939342031393938204E202D3539202D36382056202D3436202D343520562035392034322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323939342031393938204D0A2D3436202D373120560A2D3539202D343220560A343620343520560A353920363820560A2E32373835206720677361766520323239362032343730204E202D3539202D32312056202D3436202D313120562036302032392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323239362032343730204D0A2D3435202D3320560A2D3630202D323920560A343620313120560A353920323120560A2E31353732206720677361766520333233332032313935204E202D3539202D32352056202D3436202D31323520562036302032302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333233332032313935204D0A2D3435202D31333020560A2D3630202D323020560A34362031323520560A353920323520560A2E323037206720677361766520343735342032333737204E202D3630202D38342056202D3436203520562036302038382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343735342032333737204D0A2D3436203920560A2D3630202D383820560A3436202D3520560A363020383420560A2E31313539206720677361766520343638302032313935204E202D3630202D3130352056202D3436202D342056203630203130362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343638302032313935204D0A2D3436202D3320560A2D3630202D31303620560A3436203420560A36302031303520560A2E31353732206720677361766520343039322032303339204E202D3630203133302056202D3436202D31332056203630202D3131382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343039322032303339204D0A2D3436202D3120560A2D36302031313820560A343620313320560A3630202D31333020560A2E32373431206720677361766520343837332032343637204E202D3630202D33312056202D343620313420562036302033342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343837332032343637204D0A2D343620313720560A2D3630202D333420560A3436202D313420560A363020333120560A2E32343737206720677361766520343831332032343336204E202D3539202D35392056202D3436203920562035392036342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343831332032343336204D0A2D343620313420560A2D3539202D363420560A3436202D3920560A353920353920560A2E30383134206720677361766520333035342032303636204E202D3630202D36382056202D3436202D373120562036302034342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333035342032303636204D0A2D3436202D393520560A2D3630202D343420560A343620373120560A363020363820560A2E31323232206720677361766520313737322032313238204E202D3630202D34312056202D3435202D3320562035392033312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313737322032313238204D0A2D3436202D313320560A2D3539202D333120560A3435203320560A363020343120560A2E31333935206720677361766520333137342032313730204E202D3630202D34342056202D3436202D31313420562036302033332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333137342032313730204D0A2D3436202D31323520560A2D3630202D333320560A34362031313420560A363020343420560A2E31313239206720677361766520333131342032313236204E202D3630202D36302056202D3436202D393520562036302034312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333131342032313236204D0A2D3436202D31313420560A2D3630202D343120560A343620393520560A363020363020560A2E30323931206720677361766520343338312031383431204E202D36302033312056202D34362034382056203630202D35302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343338312031383431204D0A2D343620323920560A2D363020353020560A3436202D343820560A3630202D333120560A2E31303834206720677361766520323633312032303237204E202D35392033352056202D34362039372056203630202D33332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323633312032303237204D0A2D343520393920560A2D363020333320560A3436202D393720560A3539202D333520560A2E32383135206720677361766520323430322032343535204E202D3630202D352056202D343620323020562036302031362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323430322032343535204D0A2D343620333120560A2D3630202D313620560A3436202D323020560A3630203520560A2E32303431206720677361766520333934302032313239204E202D3630203134332056202D3435202D36332056203539202D3131362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333934302032313239204D0A2D3436202D333620560A2D35392031313620560A343520363320560A3630202D31343320560A2E30303031206720677361766520323831352031383236204E202D3630202D32332056202D34362033332056203630202D312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323831352031383236204D0A2D3436203920560A2D3630203120560A3436202D333320560A363020323320560A2E323731206720677361766520323233372032343439204E202D3630202D32372056202D3436202D313920562036302033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323233372032343439204D0A2D3436202D313120560A2D3630202D333520560A343620313920560A363020323720560A2E31313036206720677361766520313731322032303837204E202D3539202D33342056202D3436203720562036302032342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313731322032303837204D0A2D3435202D3320560A2D3630202D323420560A3436202D3720560A353920333420560A2E32383338206720677361766520343937392032343436204E202D363020332056202D3436203138205620363020322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343937392032343436204D0A2D343620323320560A2D3630202D3220560A3436202D313820560A3630202D3320560A2E30303235206720677361766520343533322031383531204E202D3539202D34372056202D343620313420562036302033302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343533322031383531204D0A2D3435202D3320560A2D3630202D333020560A3436202D313420560A353920343720560A2E31353437206720677361766520323538362032313236204E202D36302033332056202D34362039362056203630202D32382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323538362032313236204D0A2D34362031303120560A2D363020323820560A3436202D393620560A3630202D333320560A2E30383231206720677361766520343636362032313031204E202D3630202D3130312056202D3436202D31302056203630203130302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343636362032313031204D0A2D3436202D313120560A2D3630202D31303020560A343620313020560A36302031303120560A2E30313331206720677361766520343432372031383138204E202D363020382056202D34362034362056203630202D33312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343432372031383138204D0A2D343620323320560A2D363020333120560A3436202D343620560A3630202D3820560A2E32363634206720677361766520323434382032333939204E202D363020372056202D3436203434205620363020352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323434382032333939204D0A2D343620353620560A2D3630202D3520560A3436202D343420560A3630202D3720560A2E31363837206720677361766520343734302032323932204E202D3630202D39372056202D3436202D332056203630203130312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343734302032323932204D0A2D3436203120560A2D3630202D31303120560A3436203320560A363020393720560A2E30323138206720677361766520343539322031393235204E202D3630202D37342056202D3435202D3320562035392036342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343539322031393235204D0A2D3436202D313320560A2D3539202D363420560A3435203320560A363020373420560A2E32353937206720677361766520323137372032343232204E202D3630202D33332056202D3436202D323520562036302033392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323137372032343232204D0A2D3436202D313920560A2D3630202D333920560A343620323520560A363020333320560A2E31393936206720677361766520323534302032323237204E202D36302032382056202D34362038342056203630202D31382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323534302032323237204D0A2D343620393420560A2D363020313820560A3436202D383420560A3630202D323820560A2E32333831206720677361766520323439342032333231204E202D36302031382056202D34362036372056203630202D372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323439342032333231204D0A2D343620373820560A2D3630203720560A3436202D363720560A3630202D313820560A2E30323835206720677361766520323730392031383336204E202D35392032302056202D34362037302056203539202D33332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323730392031383336204D0A2D343620353720560A2D353920333320560A3436202D373020560A3539202D323020560A2E32353039206720677361766520333632332032323632204E202D3539203130332056202D3435202D3134332056203539202D37312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333632332032323632204D0A2D3435202D31313120560A2D353920373120560A34352031343320560A3539202D31303320560A2E31303433206720677361766520313635332032303533204E202D3630202D32342056202D343620313720562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313635332032303533204D0A2D3436203720560A2D3630202D313420560A3436202D313720560A363020323420560A2E32383338206720677361766520323334322032343530204E202D3539202D31302056202D3436203920562035392032312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323334322032343530204D0A2D343620323020560A2D3539202D323120560A3436202D3920560A353920313020560A2E32343436206720677361766520323131372032333839204E202D3630202D34302056202D3436202D323920562036302034342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323131372032333839204D0A2D3436202D323520560A2D3630202D343420560A343620323920560A363020343020560A2E32373733206720677361766520343931392032343439204E202D3630202D32352056202D343620313220562036302033312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343931392032343439204D0A2D343620313820560A2D3630202D333120560A3436202D313220560A363020323520560A2E30353837206720677361766520323636332031383933204E202D35392033332056202D34362038342056203630202D34302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323636332031383933204D0A2D343520373720560A2D363020343020560A3436202D383420560A3539202D333320560A2E32353434206720677361766520343835392032343234204E202D3630202D35342056202D3435203720562035392035392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343835392032343234204D0A2D343620313220560A2D3539202D353920560A3435202D3720560A363020353420560A2E32313639206720677361766520343739392032333730204E202D3539202D37382056202D3436203120562036302038342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343739392032333730204D0A2D3435203720560A2D3630202D383420560A3436202D3120560A353920373820560A2E31363334206720677361766520343133382032303237204E202D3630203133342056202D343620382056203630202D3133302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343133382032303237204D0A2D343620313220560A2D36302031333020560A3436202D3820560A3630202D31333420560A2E32323633206720677361766520323035372032333439204E202D3630202D34362056202D3435202D333120562035392034382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323035372032333439204D0A2D3436202D323920560A2D3539202D343820560A343520333120560A363020343620560A2E32343236206720677361766520333435392032323838204E202D36302035332056202D3436202D3135392056203630202D33322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333435392032323838204D0A2D3436202D31333820560A2D363020333220560A34362031353920560A3630202D353320560A2E30303235206720677361766520343437332031383034204E202D3630202D31342056202D34362033362056203630202D382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343437332031383034204D0A2D343620313420560A2D3630203820560A3436202D333620560A363020313420560A2E30303838206720677361766520323735352031383033204E202D363020312056202D34352035322056203539202D32302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323735352031383033204D0A2D343620333320560A2D353920323020560A3435202D353220560A3630202D3120560A2E32303533206720677361766520313939372032333033204E202D3539202D34392056202D3436202D333120562036302034392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313939372032333033204D0A2D3435202D333120560A2D3630202D343920560A343620333120560A353920343920560A2E30353639206720677361766520343635322032303138204E202D3630202D39332056202D3436202D313320562036302038382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343635322032303138204D0A2D3436202D313820560A2D3630202D383820560A343620313320560A363020393320560A2E313833206720677361766520313933382032323534204E202D3630202D35332056202D3436202D323720562036302034392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313933382032323534204D0A2D3436202D333120560A2D3630202D343920560A343620323720560A363020353320560A2E31333238206720677361766520343732362032323033204E202D3630202D3130322056202D3436202D31312056203630203130352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343732362032323033204D0A2D3436202D3820560A2D3630202D31303520560A343620313120560A36302031303220560A2E30303533206720677361766520323836312031383435204E202D3630202D35312056202D3436203920562036302032332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323836312031383435204D0A2D3436202D313920560A2D3630202D323320560A3436202D3920560A363020353120560A2E32353039206720677361766520333833352032323039204E202D3630203134372056202D3436202D39382056203630202D3131352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333833352032323039204D0A2D3436202D363620560A2D36302031313520560A343620393820560A3630202D31343720560A2E30393731206720677361766520323631382031393730204E202D36302034302056202D34362039322056203630202D34302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323631382031393730204D0A2D343620393220560A2D363020343020560A3436202D393220560A3630202D343020560A2E31363038206720677361766520313837382032323031204E202D3630202D35322056202D3436202D323120562036302034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313837382032323031204D0A2D3436202D323720560A2D3630202D343620560A343620323120560A363020353220560A2E323833206720677361766520353032352032343231204E202D363020382056202D34362032302056203630202D332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353032352032343231204D0A2D343620323520560A2D3630203320560A3436202D323020560A3630202D3820560A2E31343032206720677361766520313831382032313439204E202D3630202D34392056202D3436202D313320562036302034312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313831382032313439204D0A2D3436202D323120560A2D3630202D343120560A343620313320560A363020343920560A2E303237206720677361766520323932312031393230204E202D3630202D37352056202D3436202D313920562036302034342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323932312031393230204D0A2D3436202D353020560A2D3630202D343420560A343620313920560A363020373520560A2E32383235206720677361766520323238332032343430204E202D3630202D31362056202D3436202D3220562036302032372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323238332032343430204D0A2D3436203920560A2D3630202D323720560A3436203220560A363020313620560A2E313034206720677361766520313539332032303239204E202D3630202D31352056202D3436203238205620363020342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313539332032303239204D0A2D343620313720560A2D3630202D3420560A3436202D323820560A363020313520560A2E323736206720677361766520323338382032343036204E202D363020322056202D343520333220562035392031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323338382032343036204D0A2D343620343420560A2D3539202D313020560A3435202D333220560A3630202D3220560A2E32363739206720677361766520333732392032323538204E202D3630203133322056202D3436202D3132382056203630202D39382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333732392032323538204D0A2D3436202D393420560A2D363020393820560A34362031323820560A3630202D31333220560A2E313233206720677361766520313735382032313030204E202D3539202D34342056202D3436202D3320562035392033342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313735382032313030204D0A2D3436202D313320560A2D3539202D333420560A3436203320560A353920343420560A2E31343032206720677361766520323537322032303632204E202D36302034302056202D34362039332056203630202D33362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323537322032303632204D0A2D343620393720560A2D363020333620560A3436202D393320560A3630202D343020560A2E31353732206720677361766520343138332032303033204E202D3539203132392056202D34362032392056203630202D3133342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343138332032303033204D0A2D343520323420560A2D36302031333420560A3436202D323920560A3539202D31323920560A2E30313236206720677361766520343537382031383635204E202D3539202D36322056202D3436203120562035392034372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343537382031383635204D0A2D3436202D313420560A2D3539202D343720560A3436202D3120560A353920363220560A2E30303034206720677361766520323830312031373934204E202D3630202D32332056202D34362033332056203630202D312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323830312031373934204D0A2D3436203920560A2D3630203120560A3436202D333320560A363020323320560A2E31383338206720677361766520343738352032323934204E202D3539202D39312056202D3436202D3820562036302039372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343738352032323934204D0A2D3435202D3220560A2D3630202D393720560A3436203820560A353920393120560A2E31383338206720677361766520323532362032313539204E202D36302033362056202D34362038372056203630202D32372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323532362032313539204D0A2D343620393620560A2D363020323720560A3436202D383720560A3630202D333620560A2E32323335206720677361766520323438302032323535204E202D36302032372056202D34362037332056203630202D31362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323438302032323535204D0A2D343620383420560A2D363020313620560A3436202D373320560A3630202D323720560A2E32353533206720677361766520323433342032333339204E202D36302031362056202D34362035332056203630202D322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323433342032333339204D0A2D343620363720560A2D3630203220560A3436202D353320560A3630202D313620560A2E32383035206720677361766520343936352032343239204E202D3630202D31382056202D343620313320562036302032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343936352032343239204D0A2D343620323020560A2D3630202D323520560A3436202D313320560A363020313820560A2E31313036206720677361766520313639392032303536204E202D3630202D33352056202D3436203820562036302032342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313639392032303536204D0A2D3436202D3320560A2D3630202D323420560A3436202D3820560A363020333520560A2E31303237206720677361766520343731322032313138204E202D3630202D3130302056202D3436202D31382056203630203130312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343731322032313138204D0A2D3436202D313720560A2D3630202D31303120560A343620313820560A36302031303020560A2E30303034206720677361766520343531392031383033204E202D3630202D33352056202D343620323220562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343531392031383033204D0A2D3436203120560A2D3630202D313420560A3436202D323220560A363020333520560A2E32373638206720677361766520323232332032343234204E202D3630202D32342056202D3436202D313120562036302033332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323232332032343234204D0A2D3436202D3220560A2D3630202D333320560A343620313120560A363020323420560A2E323632206720677361766520343930352032343131204E202D3630202D34362056202D3436203520562036302035342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343930352032343131204D0A2D343620313320560A2D3630202D353420560A3436202D3520560A363020343620560A2E32323836206720677361766520343834352032333635204E202D3630202D37312056202D3435202D3220562035392037382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343834352032333635204D0A2D3436203520560A2D3539202D373820560A3435203220560A363020373120560A2E30363237206720677361766520323938302032303132204E202D3539202D39322056202D3436202D353020562036302036302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323938302032303132204D0A2D3435202D383220560A2D3630202D363020560A343620353020560A353920393220560A2E31333935206720677361766520343232392031393636204E202D3539203131382056202D34362034382056203539202D3132392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343232392031393636204D0A2D343620333720560A2D35392031323920560A3436202D343820560A3539202D31313820560A2E32343236206720677361766520333938362032313536204E202D3630203136342056202D3436202D34382056203630202D3134332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333938362032313536204D0A2D3436202D323720560A2D36302031343320560A343620343820560A3630202D31363420560A2E32383038206720677361766520353037302032333934204E202D35392031332056202D34362032322056203630202D382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353037302032333934204D0A2D343520323720560A2D3630203820560A3436202D323220560A3539202D313320560A2E30343034206720677361766520343633382031393437204E202D3630202D38322056202D3436202D313420562036302037342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343633382031393437204D0A2D3436202D323220560A2D3630202D373420560A343620313420560A363020383220560A2E31313239206720677361766520343237352031393230204E202D3630203130302056202D34352036342056203539202D3131382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343237352031393230204D0A2D343620343620560A2D35392031313820560A3435202D363420560A3630202D31303020560A2E30343938206720677361766520343336372031383236204E202D36302034392056202D34362037332056203630202D37362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343336372031383236204D0A2D343620343620560A2D363020373620560A3436202D373320560A3630202D343920560A2E30383134206720677361766520343332312031383732204E202D36302037362056202D34362037322056203630202D3130302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343332312031383732204D0A2D343620343820560A2D36302031303020560A3436202D373220560A3630202D373620560A2E303233206720677361766520343431332031373930204E202D36302032312056202D34362036342056203630202D34392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343431332031373930204D0A2D343620333620560A2D363020343920560A3436202D363420560A3630202D323120560A2E32383232206720677361766520323332382032343038204E202D3539202D332056202D343620313920562036302031362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323332382032343038204D0A2D343520333220560A2D3630202D313620560A3436202D313920560A3539203320560A2E30353837206720677361766520323635302031383536204E202D36302033382056202D34362037382056203630202D34362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323635302031383536204D0A2D343620373020560A2D363020343620560A3436202D373820560A3630202D333820560A2E32363635206720677361766520323136332032343030204E202D3630202D33322056202D3436202D313920562036302034302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323136332032343030204D0A2D3436202D313120560A2D3630202D343020560A343620313920560A363020333220560A2E31303432206720677361766520313633392032303231204E202D3630202D32352056202D343620313820562036302031352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313633392032303231204D0A2D3436203820560A2D3630202D313520560A3436202D313820560A363020323520560A2E30333133206720677361766520323639352031383034204E202D35392032352056202D34362036352056203630202D33382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323639352031383034204D0A2D343520353220560A2D363020333820560A3436202D363520560A3539202D323520560A2E32363739206720677361766520333339392032333431204E202D36302032392056202D3436202D3137322056203630202D31362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333339392032333431204D0A2D3436202D31353920560A2D363020313620560A34362031373220560A3630202D323920560A2E31353239206720677361766520343737322032323135204E202D3630202D39372056202D3436202D31372056203630203130322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343737322032323135204D0A2D3436202D313220560A2D3630202D31303220560A343620313720560A363020393720560A2E30393333206720677361766520323630342031393236204E202D36302034362056202D34362038362056203630202D34382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323630342031393236204D0A2D343620383420560A2D363020343820560A3436202D383620560A3630202D343620560A2E32353134206720677361766520323130332032333638204E202D3630202D33392056202D3436202D323620562036302034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323130332032333638204D0A2D3436202D313920560A2D3630202D343620560A343620323620560A363020333920560A2E30303235206720677361766520323834372031383036204E202D3630202D34392056202D343620313420562036302032332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323834372031383036204D0A2D3436202D313220560A2D3630202D323320560A3436202D313420560A363020343920560A2E30303533206720677361766520343435392031373638204E202D3630202D352056202D34362034382056203630202D32312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343435392031373638204D0A2D343620323220560A2D363020323120560A3436202D343820560A3630203520560A2E313038206720677361766520333034302032313131204E202D3630202D39392056202D3435202D383220562035392036382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333034302032313131204D0A2D3436202D31313320560A2D3539202D363820560A343520383220560A363020393920560A2E30383033206720677361766520343639382032303432204E202D3630202D39352056202D3436202D323220562036302039332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343639382032303432204D0A2D3436202D323420560A2D3630202D393320560A343620323220560A363020393520560A2E30313236206720677361766520323734312031373731204E202D363020382056202D34352035302056203539202D32352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323734312031373731204D0A2D343620333320560A2D353920323520560A3435202D353020560A3630202D3820560A2E32333233206720677361766520323034332032333239204E202D3539202D34372056202D3436202D323820562035392034392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323034332032333239204D0A2D3436202D323620560A2D3539202D343920560A343620323820560A353920343720560A2E32383239206720677361766520353031312032343037204E202D3630202D31302056202D343620313420562036302031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353031312032343037204D0A2D343620323220560A2D3630202D313820560A3436202D313420560A363020313020560A2E3231206720677361766520313938342032323832204E202D3630202D35322056202D3436202D323920562036302035332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313938342032323832204D0A2D3436202D323820560A2D3630202D353320560A343620323920560A363020353220560A2E313836206720677361766520313932342032323330204E202D3630202D35362056202D3436202D323520562036302035322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313932342032323330204D0A2D3436202D323920560A2D3630202D353220560A343620323520560A363020353620560A2E31333238206720677361766520323535382032303130204E202D36302034382056202D34362038382056203630202D34342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323535382032303130204D0A2D343620393220560A2D363020343420560A3436202D383820560A3630202D343820560A2E31363231206720677361766520313836342032313734204E202D3630202D35352056202D3436202D313920562036302034392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313836342032313734204D0A2D3436202D323520560A2D3630202D343920560A343620313920560A363020353520560A2E32373638206720677361766520353131362032333632204E202D35392032302056202D34362032352056203539202D31332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353131362032333632204D0A2D343620333220560A2D353920313320560A3436202D323520560A3539202D323020560A2E32363936206720677361766520323337342032333535204E202D36302031302056202D3435203430205620353920332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323337342032333535204D0A2D343620353320560A2D3539202D3320560A3435202D343020560A3630202D313020560A2E31343032206720677361766520313830342032313139204E202D3630202D35312056202D3435202D313220562035392034342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313830342032313139204D0A2D3436202D313920560A2D3539202D343420560A343520313220560A363020353120560A2E303233206720677361766520323930372031383838204E202D3630202D38322056202D3436202D313220562036302035312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323930372031383838204D0A2D3436202D343320560A2D3630202D353120560A343620313220560A363020383220560A2E32303131206720677361766520343833312032323938204E202D3539202D38332056202D3436202D313220562035392039312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343833312032323938204D0A2D3436202D3420560A2D3539202D393120560A343620313220560A353920383320560A2E30303838206720677361766520343536342031383137204E202D3539202D35332056202D3436203420562036302033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343536342031383137204D0A2D3435202D313420560A2D3630202D333520560A3436202D3420560A353920353320560A2E31373338206720677361766520323531322032313032204E202D36302034342056202D34362038352056203630202D33362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323531322032313032204D0A2D343620393320560A2D363020333620560A3436202D383520560A3630202D343420560A2E32383338206720677361766520323236392032343035204E202D3630202D31312056202D3436203620562036302032342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323236392032343035204D0A2D343620313920560A2D3630202D323420560A3436202D3620560A363020313120560A2E31323232206720677361766520313734342032303638204E202D3539202D34352056202D3436202D3220562036302033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313734342032303638204D0A2D3435202D313220560A2D3630202D333520560A3436203220560A353920343520560A2E32313237206720677361766520323436362032313935204E202D36302033362056202D34362037352056203630202D32342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323436362032313935204D0A2D343620383720560A2D363020323420560A3436202D373520560A3630202D333620560A2E32343537206720677361766520323432302032323832204E202D36302032342056202D34362035392056203630202D31302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323432302032323832204D0A2D343620373320560A2D363020313020560A3436202D353920560A3630202D323420560A2E32363936206720677361766520343935312032333937204E202D3630202D33372056202D3436203520562036302034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343935312032333937204D0A2D343620313420560A2D3630202D343620560A3436202D3520560A363020333720560A2E32343135206720677361766520343839312032333630204E202D3630202D36322056202D3436202D3420562036302037312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343839312032333630204D0A2D3436203520560A2D3630202D373120560A3436203420560A363020363220560A2E33313339206720677361766520333536342032333635204E202D35392039342056202D3436202D3137312056203630202D36362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333536342032333635204D0A2D3435202D31343320560A2D363020363620560A34362031373120560A3539202D393420560A2E30333133206720677361766520343632342031383930204E202D3630202D37332056202D3435202D313420562035392036322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343632342031383930204D0A2D3436202D323520560A2D3539202D363220560A343520313420560A363020373320560A2E30303235206720677361766520323738372031373537204E202D3630202D31342056202D34362033362056203630202D382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323738372031373537204D0A2D343620313420560A2D3630203820560A3436202D333620560A363020313420560A2E32373637206720677361766520333333392032333730204E202D363020322056202D3436202D313737205620363020332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333333392032333730204D0A2D3436202D31373220560A2D3630202D3320560A34362031373720560A3630202D3220560A2E31353732206720677361766520333130302032323035204E202D3630202D39342056202D3436202D31313320562036302036382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333130302032323035204D0A2D3436202D31333920560A2D3630202D363820560A34362031313320560A363020393420560A2E31323732206720677361766520343735382032313339204E202D3630202D39372056202D3436202D32342056203630203130302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343735382032313339204D0A2D3436202D323120560A2D3630202D31303020560A343620323420560A363020393720560A2E31303936206720677361766520313638352032303233204E202D3630202D33362056202D3436203920562036302032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313638352032303233204D0A2D3436202D3220560A2D3630202D323520560A3436202D3920560A363020333620560A2E30303031206720677361766520343530352031373634204E202D3630202D32392056202D3436203238205620363020352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343530352031373634204D0A2D3436203420560A2D3630202D3520560A3436202D323820560A363020323920560A2E32373035206720677361766520353136322032333237204E202D36302032362056202D34352032392056203539202D32302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353136322032333237204D0A2D343620333520560A2D353920323020560A3435202D323920560A3630202D323620560A2E3238206720677361766520323230392032333934204E202D3630202D32312056202D3436202D3520562036302033322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323230392032333934204D0A2D3436203620560A2D3630202D333220560A3436203520560A363020323120560A2E32363739206720677361766520343033322032313639204E202D3630203137362056202D3436202D32352056203630202D3136342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343033322032313639204D0A2D3436202D313320560A2D36302031363420560A343620323520560A3630202D31373620560A2E32383339206720677361766520353035372032333832204E202D3630202D312056202D343620313620562036302031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353035372032333832204D0A2D343620323520560A2D3630202D313020560A3436202D313620560A3630203120560A2E32303431206720677361766520333136302032323835204E202D3630202D38302056202D3436202D31333920562036302036302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333136302032323835204D0A2D3436202D31353920560A2D3630202D363020560A34362031333920560A363020383020560A2E30363537206720677361766520343638342031393737204E202D3630202D38372056202D3436202D323520562036302038322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343638342031393737204D0A2D3436202D333020560A2D3630202D383220560A343620323520560A363020383720560A2E32363739206720677361766520333237392032333732204E202D3539202D32392056202D3436202D31373320562035392032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333237392032333732204D0A2D3436202D31373720560A2D3539202D323520560A34362031373320560A353920323920560A2E32343236206720677361766520333232302032333433204E202D3630202D35382056202D3436202D31353920562036302034342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333232302032333433204D0A2D3436202D31373320560A2D3630202D343420560A34362031353920560A363020353820560A2E32373935206720677361766520323331342032333635204E202D353920332056202D343620323620562036302031312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323331342032333635204D0A2D343520343020560A2D3630202D313120560A3436202D323620560A3539202D3320560A2E33313339206720677361766520333838302032323732204E202D3539203137342056202D3436202D39302056203630202D3134372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333838302032323732204D0A2D3435202D363320560A2D36302031343720560A343620393020560A3539202D31373420560A2E30363237206720677361766520323936372031393937204E202D3630202D3130392056202D3436202D343320562036302037352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323936372031393937204D0A2D3436202D373720560A2D3630202D373520560A343620343320560A36302031303920560A2E31373535206720677361766520343831372032323238204E202D3539202D38392056202D3436202D323120562036302039372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343831372032323238204D0A2D3435202D313320560A2D3630202D393720560A343620323120560A353920383920560A2E30363537206720677361766520323633362031383239204E202D36302034352056202D34362037322056203630202D35322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323633362031383239204D0A2D343620363520560A2D363020353220560A3436202D373220560A3630202D343520560A2E32373035206720677361766520323134392032333733204E202D3630202D33302056202D3436202D313420562036302033392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323134392032333733204D0A2D3436202D3520560A2D3630202D333920560A343620313420560A363020333020560A2E303237206720677361766520343339392031373633204E202D36302032332056202D34362038302056203630202D35352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343339392031373633204D0A2D343620343820560A2D363020353520560A3436202D383020560A3630202D323320560A2E30393731206720677361766520323539302031383934204E202D36302035322056202D34362038302056203630202D35342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323539302031383934204D0A2D343620373820560A2D363020353420560A3436202D383020560A3630202D353220560A30206720677361766520323833332031373537204E202D3630202D33362056202D343620323220562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323833332031373537204D0A2D3436203020560A2D3630202D313420560A3436202D323220560A363020333620560A2E32363134206720677361766520353230382032323838204E202D36302033322056202D34362033332056203630202D32362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353230382032323838204D0A2D343620333920560A2D363020323620560A3436202D333320560A3630202D333220560A2E32373635206720677361766520343939372032333831204E202D3630202D32372056202D3436203620562036302033372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343939372032333831204D0A2D343620313620560A2D3630202D333720560A3436202D3620560A363020323720560A2E30313331206720677361766520323839332031383334204E202D3630202D37372056202D3436203020562036302034392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323839332031383334204D0A2D3436202D323820560A2D3630202D343920560A3436203020560A363020373720560A2E30343034206720677361766520323638312031373739204E202D35392033332056202D34362036322056203630202D34352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323638312031373739204D0A2D343520353020560A2D363020343520560A3436202D363220560A3539202D333320560A2E32353434206720677361766520343933372032333534204E202D3630202D35322056202D3436202D3420562036302036322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343933372032333534204D0A2D3436203620560A2D3630202D363220560A3436203420560A363020353220560A2E32313936206720677361766520343837372032333032204E202D3630202D37342056202D3435202D313320562035392038332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343837372032333032204D0A2D3436202D3420560A2D3539202D383320560A343520313320560A363020373420560A2E30303533206720677361766520343434352031373335204E202D3630202D342056202D34362035352056203630202D32332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343434352031373335204D0A2D343620323820560A2D363020323320560A3436202D353520560A3630203420560A2E32363432206720677361766520323336302032333036204E202D35392031382056202D34362034342056203539202D332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323336302032333036204D0A2D343620353920560A2D3539203320560A3436202D343420560A3539202D313820560A2E32353533206720677361766520323038392032333433204E202D3630202D34302056202D3435202D323120562035392034372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323038392032333433204D0A2D3436202D313420560A2D3539202D343720560A343520323120560A363020343020560A2E31333238206720677361766520323534342031393732204E202D36302035342056202D34362038322056203630202D35302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323534342031393732204D0A2D343620383620560A2D363020353020560A3436202D383220560A3630202D353420560A2E31303834206720677361766520343734342032303731204E202D3630202D39342056202D3436202D333020562036302039352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343734342032303731204D0A2D3436202D323920560A2D3630202D393520560A343620333020560A363020393420560A2E31363038206720677361766520313835302032313432204E202D3630202D35372056202D3436202D313720562036302035312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313835302032313432204D0A2D3436202D323320560A2D3630202D353120560A343620313720560A363020353720560A2E313338206720677361766520313739302032303835204E202D3539202D35332056202D3436202D3920562035392034352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313739302032303835204D0A2D3436202D313720560A2D3539202D343520560A3436203920560A353920353320560A2E32333533206720677361766520323032392032333033204E202D3539202D34382056202D3436202D323520562036302035322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323032392032333033204D0A2D3435202D323120560A2D3630202D353220560A343620323520560A353920343820560A2E32313136206720677361766520313937302032323535204E202D3630202D35352056202D3436202D323620562036302035362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313937302032323535204D0A2D3436202D323520560A2D3630202D353620560A343620323620560A363020353520560A2E313836206720677361766520313931302032323030204E202D3630202D35382056202D3436202D323320562036302035352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313931302032323030204D0A2D3436202D323620560A2D3630202D353520560A343620323320560A363020353820560A2E31373034206720677361766520323439382032303538204E202D36302035302056202D34362038312056203630202D34332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323439382032303538204D0A2D343620383820560A2D363020343320560A3436202D383120560A3630202D353020560A2E323037206720677361766520323435322032313436204E202D36302034332056202D34362037342056203630202D33322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323435322032313436204D0A2D343620383520560A2D363020333220560A3436202D373420560A3630202D343320560A2E32333933206720677361766520323430362032323331204E202D36302033322056202D34352036312056203539202D31382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323430362032323331204D0A2D343620373520560A2D353920313820560A3435202D363120560A3630202D333220560A2E30363237206720677361766520343335332031383131204E202D36302035352056202D34362039362056203630202D38372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343335332031383131204D0A2D343620363420560A2D363020383720560A3436202D393620560A3630202D353520560A2E32383237206720677361766520353130322032333533204E202D353920372056202D3436203231205620363020312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353130322032333533204D0A2D343520323920560A2D3630202D3120560A3436202D323120560A3539202D3720560A2E30323138206720677361766520323732372031373433204E202D35392031392056202D34362035302056203539202D33332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323732372031373433204D0A2D343620333620560A2D353920333320560A3436202D353020560A3539202D313920560A2E31313938206720677361766520313733312032303332204E202D3630202D34352056202D3436203020562036302033362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313733312032303332204D0A2D3436202D3920560A2D3630202D333620560A3436203020560A363020343520560A2E30303838206720677361766520343535302031373830204E202D3539202D34382056202D3436203320562036302032392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343535302031373830204D0A2D3435202D313620560A2D3630202D323920560A3436202D3320560A353920343820560A2E33353433206720677361766520333636392032333930204E202D3630203133332056202D3435202D3135382056203539202D3130332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333636392032333930204D0A2D3436202D31323820560A2D35392031303320560A34352031353820560A3630202D31333320560A2E30323835206720677361766520343631302031383436204E202D3630202D36362056202D3435202D313620562035392035332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343631302031383436204D0A2D3436202D323920560A2D3539202D353320560A343520313620560A363020363620560A2E32383338206720677361766520323235352032333638204E202D3630202D362056202D343620313120562036302032312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323235352032333638204D0A2D343620323620560A2D3630202D323120560A3436202D313120560A3630203620560A2E32343934206720677361766520353235342032323436204E202D36302033352056202D34362033392056203630202D33322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353235342032323436204D0A2D343620343220560A2D363020333220560A3436202D333920560A3630202D333520560A2E33353433206720677361766520333737352032333536204E202D3630203136332056202D3436202D3132392056203630202D3133322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333737352032333536204D0A2D3436202D393820560A2D36302031333220560A34362031323920560A3630202D31363320560A2E32373637206720677361766520343037382032313631204E202D3630203138312056202D343620332056203630202D3137362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343037382032313631204D0A2D3436203820560A2D36302031373620560A3436202D3320560A3630202D31383120560A2E31353437206720677361766520343830342032313632204E202D3630202D39312056202D3436202D323920562036302039372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343830342032313632204D0A2D3436202D323320560A2D3630202D393720560A343620323920560A363020393120560A2E313038206720677361766520343330372031383735204E202D36302038372056202D3435203130322056203539202D3131362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343330372031383735204D0A2D343620373320560A2D35392031313620560A3435202D31303220560A3630202D383720560A2E313138206720677361766520333032362032313233204E202D3539202D3132362056202D3436202D373720562035392039322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333032362032313233204D0A2D3436202D31313120560A2D3539202D393220560A343620373720560A35392031323620560A2E30353837206720677361766520343637302031393236204E202D3630202D38302056202D3436202D323920562036302037332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343637302031393236204D0A2D3436202D333620560A2D3630202D373320560A343620323920560A363020383020560A2E30303034206720677361766520343439312031373332204E202D3630202D32382056202D3436203237205620363020342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343439312031373332204D0A2D3436203320560A2D3630202D3420560A3436202D323720560A363020323820560A2E30303937206720677361766520323737332031373231204E202D363020322056202D34352033392056203539202D31392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323737332031373231204D0A2D343620323220560A2D353920313920560A3435202D333920560A3630202D3220560A2E30343938206720677361766520323935332031393438204E202D3630202D3131342056202D3436202D323820562036302038322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323935332031393438204D0A2D3436202D363020560A2D3630202D383220560A343620323820560A36302031313420560A2E30303331206720677361766520323837392031373637204E202D3630202D35392056202D343620313320562036302033362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323837392031373637204D0A2D3436202D313020560A2D3630202D333620560A3436202D313320560A363020353920560A2E32333435206720677361766520353330302032313939204E202D36302033382056202D34362034342056203630202D33352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353330302032313939204D0A2D343620343720560A2D363020333520560A3436202D343420560A3630202D333820560A2E32383135206720677361766520353034332032333630204E202D3630202D31362056202D343620313020562036302032372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353034332032333630204D0A2D343620323120560A2D3630202D323720560A3436202D313020560A363020313620560A2E32383135206720677361766520323139352032333632204E202D3630202D31382056202D3436202D3120562036302033302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323139352032333632204D0A2D343620313120560A2D3630202D333020560A3436203120560A363020313820560A2E32373733206720677361766520323330312032333234204E202D363020392056202D3436203239205620363020362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323330312032333234204D0A2D343620343420560A2D3630202D3620560A3436202D323920560A3630202D3920560A2E32373835206720677361766520353134382032333230204E202D35392031352056202D34362032352056203539202D372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353134382032333230204D0A2D343620333320560A2D3539203720560A3436202D323520560A3539202D313520560A2E33363439206720677361766520333530352032343539204E202D36302037332056202D3436202D3139312056203630202D35332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333530352032343539204D0A2D3436202D31373120560A2D363020353320560A34362031393120560A3630202D373320560A2E31393936206720677361766520343836332032323432204E202D3539202D38302056202D3436202D323320562035392038392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343836332032323432204D0A2D3436202D313420560A2D3539202D383920560A343620323320560A353920383020560A2E31353732206720677361766520343236312031393438204E202D3539203131362056202D34362039392056203539202D3134332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343236312031393438204D0A2D343620373220560A2D35392031343320560A3436202D393920560A3539202D31313620560A2E32363739206720677361766520343132342032313332204E202D3630203137372056202D34362033332056203630202D3138312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343132342032313332204D0A2D343620323920560A2D36302031383120560A3436202D333320560A3630202D31373720560A2E32363634206720677361766520343938332032333434204E202D3630202D34302056202D3436202D3220562036302035322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343938332032333434204D0A2D343620313020560A2D3630202D353220560A3436203220560A363020343020560A2E32333831206720677361766520343932332032333034204E202D3630202D36322056202D3436202D313420562036302037342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343932332032333034204D0A2D3436202D3220560A2D3630202D373420560A343620313420560A363020363220560A2E30393731206720677361766520343733302032303134204E202D3630202D38382056202D3436202D333620562036302038372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343733302032303134204D0A2D3436202D333720560A2D3630202D383720560A343620333620560A363020383820560A2E323137206720677361766520353334362032313531204E202D36302033382056202D34362034382056203630202D33382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353334362032313531204D0A2D343620343820560A2D363020333820560A3436202D343820560A3630202D333820560A2E32303431206720677361766520343231352032303230204E202D3539203134332056202D34362038342056203630202D3136332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343231352032303230204D0A2D343520363420560A2D36302031363320560A3436202D383420560A3539202D31343320560A2E32343236206720677361766520343137302032303834204E202D3630203136332056202D34362036322056203630202D3137372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343137302032303834204D0A2D343620343820560A2D36302031373720560A3436202D363220560A3630202D31363320560A2E32373233206720677361766520323133352032333434204E202D3630202D33302056202D3436202D313120562036302034302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323133352032333434204D0A2D3436202D3120560A2D3630202D343020560A343620313120560A363020333020560A2E303233206720677361766520343338352031373331204E202D36302031362056202D34362038372056203630202D34382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343338352031373331204D0A2D343620353520560A2D363020343820560A3436202D383720560A3630202D313620560A2E32363132206720677361766520323334362032323633204E202D35392032342056202D34362034362056203630202D392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323334362032323633204D0A2D343520363120560A2D3630203920560A3436202D343620560A3539202D323420560A2E30303235206720677361766520343433312031373034204E202D3630202D31302056202D34362035332056203630202D31362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343433312031373034204D0A2D343620323720560A2D363020313620560A3436202D353320560A363020313020560A2E303033206720677361766520323831392031373038204E202D3630202D31342056202D34362032392056203630202D322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323831392031373038204D0A2D343620313320560A2D3630203220560A3436202D323920560A363020313420560A2E31333337206720677361766520313737362032303436204E202D3539202D35332056202D3436202D3620562036302034352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313737362032303436204D0A2D3435202D313420560A2D3630202D343520560A3436203620560A353920353320560A2E31353638206720677361766520313833362032313035204E202D3630202D35392056202D3435202D313420562035392035332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313833362032313035204D0A2D3436202D323020560A2D3539202D353320560A343520313420560A363020353920560A2E32353636206720677361766520323037352032333134204E202D3539202D34312056202D3436202D313820562035392034382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323037352032333134204D0A2D3436202D313120560A2D3539202D343820560A343620313820560A353920343120560A2E31303834206720677361766520323537362031383734204E202D36302036302056202D34362037322056203630202D36302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323537362031383734204D0A2D343620373220560A2D363020363020560A3436202D373220560A3630202D363020560A2E31393736206720677361766520353339322032313031204E202D36302033362056202D34362035322056203630202D33382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353339322032313031204D0A2D343620353020560A2D363020333820560A3436202D353220560A3630202D333620560A2E313833206720677361766520313839362032313636204E202D3630202D36312056202D3436202D323020562036302035372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313839362032313636204D0A2D3436202D323420560A2D3630202D353720560A343620323020560A363020363120560A2E323337206720677361766520323339322032313839204E202D35392033382056202D34362036302056203539202D32342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323339322032313839204D0A2D343620373420560A2D353920323420560A3436202D363020560A3539202D333820560A2E31343032206720677361766520323533302031393436204E202D36302036302056202D34362037362056203630202D35362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323533302031393436204D0A2D343620383020560A2D363020353620560A3436202D373620560A3630202D363020560A2E30323931206720677361766520323933392031383730204E202D3630202D3130332056202D3436202D313020562036302037372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323933392031383730204D0A2D3436202D333620560A2D3630202D373720560A343620313020560A36302031303320560A2E32333533206720677361766520323031362032323733204E202D3630202D35302056202D3436202D323320562036302035352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323031362032323733204D0A2D3436202D313820560A2D3630202D353520560A343620323320560A363020353020560A2E3231206720677361766520313935362032323233204E202D3630202D35372056202D3436202D323420562036302035382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313935362032323233204D0A2D3436202D323320560A2D3630202D353820560A343620323420560A363020353720560A2E30383033206720677361766520323632322031383132204E202D36302035352056202D34362036372056203630202D36302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323632322031383132204D0A2D343620363220560A2D363020363020560A3436202D363720560A3630202D353520560A2E31373338206720677361766520323438342032303236204E202D36302035362056202D34362037352056203630202D34392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323438342032303236204D0A2D343620383220560A2D363020343920560A3436202D373520560A3630202D353620560A2E323037206720677361766520323433382032313038204E202D36302034392056202D34352037302056203539202D33382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323433382032313038204D0A2D343620383120560A2D353920333820560A3435202D373020560A3630202D343920560A2E323731206720677361766520353139342032323831204E202D36302032332056202D34352033312056203539202D31352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353139342032323831204D0A2D343620333920560A2D353920313520560A3435202D333120560A3630202D323320560A2E31343032206720677361766520343739302032313033204E202D3630202D38392056202D3436202D333720562036302039342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343739302032313033204D0A2D3436202D333220560A2D3630202D393420560A343620333720560A363020383920560A2E32383338206720677361766520353038392032333335204E202D3630202D352056202D343620313420562036302031362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353038392032333335204D0A2D343620323520560A2D3630202D313620560A3436202D313420560A3630203520560A2E33363439206720677361766520333932362032333230204E202D3630203139352056202D3435202D36392056203539202D3137342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333932362032333230204D0A2D3436202D343820560A2D35392031373420560A343520363920560A3630202D31393520560A2E32383335206720677361766520323234312032333333204E202D3630202D342056202D343620313520562036302031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323234312032333333204D0A2D343620323920560A2D3630202D313820560A3436202D313520560A3630203420560A2E30333133206720677361766520343539362031383134204E202D3539202D36312056202D3436202D323120562035392034382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343539362031383134204D0A2D3436202D333420560A2D3539202D343820560A343620323120560A353920363120560A2E313833206720677361766520333038362032323533204E202D3630202D3133302056202D3436202D31313120562036302039392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333038362032323533204D0A2D3436202D31343220560A2D3630202D393920560A34362031313120560A36302031333020560A2E30353639206720677361766520323636382031373632204E202D36302034372056202D34362035382056203630202D35352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323636382031373632204D0A2D343620353020560A2D363020353520560A3436202D353820560A3630202D343720560A2E31373731206720677361766520353433382032303532204E202D36302033322056202D34362035332056203630202D33362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353433382032303532204D0A2D343620343920560A2D363020333620560A3436202D353320560A3630202D333220560A2E30313236206720677361766520343533372031373533204E202D3630202D34362056202D3436202D3320562036302032382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343533372031373533204D0A2D3436202D323120560A2D3630202D323820560A3436203320560A363020343620560A2E30363237206720677361766520343333392031373836204E202D36302034382056202D3436203131332056203630202D38312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343333392031373836204D0A2D343620383020560A2D363020383120560A3436202D31313320560A3630202D343820560A2E30353837206720677361766520343635362031383837204E202D3630202D37332056202D3436202D333420562036302036362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343635362031383837204D0A2D3436202D343120560A2D3630202D363620560A343620333420560A363020373320560A2E31383338206720677361766520343834392032313835204E202D3539202D38322056202D3436202D333220562036302039312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343834392032313835204D0A2D3435202D323320560A2D3630202D393120560A343620333220560A353920383220560A2E31353638206720677361766520353438332032303035204E202D35392032362056202D34362035332056203630202D33322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353438332032303035204D0A2D343520343720560A2D363020333220560A3436202D353320560A3539202D323620560A2E30303933206720677361766520323932352031373739204E202D3630202D37392056202D3436203820562036302035392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323932352031373739204D0A2D3436202D313220560A2D3630202D353920560A3436202D3820560A363020373920560A2E313038206720677361766520333031322032303931204E202D3539202D3134332056202D3436202D36302056203630203130392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333031322032303931204D0A2D3435202D393420560A2D3630202D31303920560A343620363020560A35392031343320560A2E32353937206720677361766520353234302032323337204E202D36302032392056202D34362033382056203630202D32332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353234302032323337204D0A2D343620343420560A2D363020323320560A3436202D333820560A3630202D323920560A2E30333839206720677361766520323731332031373233204E202D35392033372056202D34362034392056203630202D34372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323731332031373233204D0A2D343520333920560A2D363020343720560A3436202D343920560A3539202D333720560A2E30303034206720677361766520323836352031373030204E202D3630202D32392056202D343620323320562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323836352031373030204D0A2D3436203820560A2D3630202D313420560A3436202D323320560A363020323920560A2E323736206720677361766520353032392032333330204E202D3630202D32372056202D3436203120562036302034302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353032392032333330204D0A2D343620313420560A2D3630202D343020560A3436202D3120560A363020323720560A2E30303235206720677361766520343437372031373037204E202D3630202D33312056202D343620313820562036302031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343437372031373037204D0A2D3436202D3320560A2D3630202D313020560A3436202D313820560A363020333120560A2E32353533206720677361766520343936392032333033204E202D3630202D35302056202D3436202D313120562036302036322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343936392032333033204D0A2D3436203120560A2D3630202D363220560A343620313120560A363020353020560A2E32323335206720677361766520343930392032323533204E202D3630202D36382056202D3435202D323320562035392038302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343930392032323533204D0A2D3436202D313120560A2D3539202D383020560A343520323320560A363020363820560A2E32383139206720677361766520323138312032333239204E202D3630202D31362056202D3436203120562036302033302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323138312032333239204D0A2D343620313520560A2D3630202D333020560A3436202D3120560A363020313620560A2E32373635206720677361766520323238372032323837204E202D36302031322056202D3436203330205620363020342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323238372032323837204D0A2D343620343620560A2D3630202D3420560A3436202D333020560A3630202D313220560A2E30313331206720677361766520343337312031363934204E202D363020342056202D34362038312056203630202D33322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343337312031363934204D0A2D343620353320560A2D363020333220560A3436202D383120560A3630202D3420560A2E30393333206720677361766520343731362031393639204E202D3630202D38322056202D3436202D343120562036302038302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343731362031393639204D0A2D3436202D343320560A2D3630202D383020560A343620343120560A363020383220560A2E313338206720677361766520353532392031393633204E202D36302031382056202D34352035302056203539202D32362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353532392031393633204D0A2D343620343220560A2D353920323620560A3435202D353020560A3630202D313820560A2E33393831206720677361766520333434352032353332204E202D36302034332056202D3436202D3230352056203630202D32392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333434352032353332204D0A2D3436202D31393120560A2D363020323920560A34362032303520560A3630202D343320560A2E32383235206720677361766520353133342032333034204E202D353920362056202D3436203230205620363020352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353133342032333034204D0A2D343520333120560A2D3630202D3520560A3436202D323020560A3539202D3620560A2E32343436206720677361766520353238362032313839204E202D36302033332056202D34362034342056203630202D32392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353238362032313839204D0A2D343620343820560A2D363020323920560A3436202D343420560A3630202D333320560A2E30323537206720677361766520323735392031363934204E202D35392032352056202D34362034312056203539202D33372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323735392031363934204D0A2D343620323920560A2D353920333720560A3436202D343120560A3539202D323520560A2E32373233206720677361766520323132312032333133204E202D3630202D33312056202D3435202D3920562035392034312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323132312032333133204D0A2D3436203120560A2D3539202D343120560A3435203920560A363020333120560A30206720677361766520343431372031363736204E202D3630202D31392056202D34362034312056203630202D342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343431372031363736204D0A2D343620313820560A2D3630203420560A3436202D343120560A363020313920560A2E31353033206720677361766520313832322032303633204E202D3630202D36302056202D3435202D313020562035392035332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313832322032303633204D0A2D3436202D313720560A2D3539202D353320560A343520313020560A363020363020560A2E313138206720677361766520343239332031383636204E202D36302038312056202D3435203133302056203539202D3131352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343239332031383636204D0A2D343620393620560A2D35392031313520560A3435202D31333020560A3630202D383120560A2E32353039206720677361766520333134362032333736204E202D3630202D3132332056202D3436202D31343220562036302039342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333134362032333736204D0A2D3436202D31373120560A2D3630202D393420560A34362031343220560A36302031323320560A2E32363132206720677361766520323333332032323237204E202D36302032382056202D34362034342056203630202D31322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323333332032323237204D0A2D343620363020560A2D363020313220560A3436202D343420560A3630202D323820560A2E31323232206720677361766520353537352031393238204E202D363020372056202D34362034362056203630202D31382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353537352031393238204D0A2D343620333520560A2D363020313820560A3436202D343620560A3630202D3720560A2E31333238206720677361766520343737362032303534204E202D3630202D38352056202D3436202D343320562036302038382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343737362032303534204D0A2D3436202D343020560A2D3630202D383820560A343620343320560A363020383520560A2E31373731206720677361766520313838322032313235204E202D3630202D36322056202D3436202D313720562036302035392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313838322032313235204D0A2D3436202D323020560A2D3630202D353920560A343620313720560A363020363220560A2E30383134206720677361766520323939382032303135204E202D3539202D3134352056202D3436202D33362056203630203131342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323939382032303135204D0A2D3435202D363720560A2D3630202D31313420560A343620333620560A35392031343520560A2E32323633206720677361766520353333322032313337204E202D36302033362056202D34362034392056203630202D33332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353333322032313337204D0A2D343620353220560A2D363020333320560A3436202D343920560A3630202D333620560A2E32353533206720677361766520323036312032323832204E202D3539202D34332056202D3436202D313620562036302035302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323036312032323832204D0A2D3435202D3920560A2D3630202D353020560A343620313620560A353920343320560A2E32333233206720677361766520323030322032323339204E202D3630202D35332056202D3436202D323020562036302035372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323030322032323339204D0A2D3436202D313620560A2D3630202D353720560A343620323020560A363020353320560A2E32303533206720677361766520313934322032313836204E202D3630202D36312056202D3436202D323020562036302036312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313934322032313836204D0A2D3436202D323020560A2D3630202D363120560A343620323020560A363020363120560A2E34333334206720677361766520333630392032353233204E202D3539203132322056202D3435202D3138362056203539202D39342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333630392032353233204D0A2D3435202D31353820560A2D353920393420560A34352031383620560A3539202D31323220560A30206720677361766520323931312031363934204E202D3630202D34322056202D343620313920562036302032392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323931312031363934204D0A2D3436203620560A2D3630202D323920560A3436202D313920560A363020343220560A2E32333933206720677361766520323337382032313537204E202D35392034322056202D34362035362056203630202D32382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323337382032313537204D0A2D343520373020560A2D363020323820560A3436202D353620560A3539202D343220560A2E30343938206720677361766520343332352031373437204E202D36302033322056202D3435203131392056203539202D36342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343332352031373437204D0A2D343620383720560A2D353920363420560A3435202D31313920560A3630202D333220560A2E32383232206720677361766520353037352032333130204E202D3630202D31352056202D3436203820562036302032372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353037352032333130204D0A2D343620323020560A2D3630202D323720560A3436202D3820560A363020313520560A2E32303533206720677361766520353337382032303834204E202D36302033352056202D34362035342056203630202D33362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353337382032303834204D0A2D343620353320560A2D363020333620560A3436202D353420560A3630202D333520560A2E32313237206720677361766520323432342032303832204E202D35392035332056202D34362036342056203539202D34322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323432342032303832204D0A2D343620373520560A2D353920343220560A3436202D363420560A3539202D353320560A2E30343639206720677361766520323938352031393036204E202D3630202D3132372056202D3436202D31322056203630203130332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323938352031393036204D0A2D3436202D333620560A2D3630202D31303320560A343620313220560A36302031323720560A2E32383335206720677361766520323232372032323939204E202D3630202D322056202D343620313620562036302031362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323232372032323939204D0A2D343620333020560A2D3630202D313620560A3436202D313620560A3630203220560A2E32373638206720677361766520353138302032323636204E202D35392031362056202D34362032382056203539202D362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353138302032323636204D0A2D343620333820560A2D3539203620560A3436202D323820560A3539202D313620560A2E303137206720677361766520323830352031363731204E202D36302031352056202D34352033332056203539202D32352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323830352031363731204D0A2D343620323320560A2D353920323520560A3435202D333320560A3630202D313520560A2E31373338206720677361766520343833352032313334204E202D3539202D38302056202D3436202D343020562036302038392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343833352032313334204D0A2D3435202D333120560A2D3630202D383920560A343620343020560A353920383020560A2E31383338206720677361766520323437302032303036204E202D36302036312056202D34352036382056203539202D35332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323437302032303036204D0A2D343620373620560A2D353920353320560A3435202D363820560A3630202D363120560A2E31353437206720677361766520323531362031393334204E202D36302036352056202D34362036382056203630202D36312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323531362031393334204D0A2D343620373220560A2D363020363120560A3436202D363820560A3630202D363520560A2E34333334206720677361766520333832312032343436204E202D3630203139312056202D3436202D3131382056203630202D3136332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333832312032343436204D0A2D3436202D393020560A2D36302031363320560A34362031313820560A3630202D31393120560A2E30313631206720677361766520323937312031373838204E202D3630202D39342056202D3436203620562036302037392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323937312031373838204D0A2D3436202D3920560A2D3630202D373920560A3436202D3620560A363020393420560A2E31313036206720677361766520353632312031393030204E202D3630202D332056202D34362033382056203630202D372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353632312031393030204D0A2D343620323820560A2D3630203720560A3436202D333820560A3630203320560A2E30343034206720677361766520343538322031373934204E202D3539202D35372056202D3436202D333020562036302034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343538322031373934204D0A2D3435202D343120560A2D3630202D343620560A343620333020560A353920353720560A2E34303937206720677361766520333338352032353735204E202D363020362056202D3436202D3230392056203630202D322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333338352032353735204D0A2D3436202D32303520560A2D3630203220560A34362032303920560A3630202D3620560A2E313833206720677361766520353432342032303331204E202D36302033312056202D34362035372056203630202D33352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353432342032303331204D0A2D343620353320560A2D363020333520560A3436202D353720560A3630202D333120560A2E33393831206720677361766520333937322032333435204E202D3630203230392056202D3436202D33392056203630202D3139352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333937322032333435204D0A2D3436202D323520560A2D36302031393520560A343620333920560A3630202D32303920560A2E31323732206720677361766520323536322031383637204E202D36302036372056202D34362036352056203630202D36352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323536322031383637204D0A2D343620363720560A2D363020363520560A3436202D363520560A3630202D363720560A2E32363936206720677361766520353031352032323935204E202D3630202D33352056202D3436202D3720562036302035302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353031352032323935204D0A2D3436203820560A2D3630202D353020560A3436203720560A363020333520560A2E30303331206720677361766520343335372031363537204E202D3630202D382056202D34352036332056203539202D31342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343335372031363537204D0A2D343620343120560A2D353920313420560A3435202D363320560A3630203820560A2E32343537206720677361766520343935352032323630204E202D3630202D35352056202D3436202D323020562036302036382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343935352032323630204D0A2D3436202D3720560A2D3630202D363820560A343620323020560A363020353520560A2E32313237206720677361766520343839352032323035204E202D3630202D37312056202D3435202D333120562035392038322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343839352032323035204D0A2D3436202D323020560A2D3539202D383220560A343520333120560A363020373120560A2E33313339206720677361766520333230362032343737204E202D3630202D3130312056202D3436202D31373120562036302038302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333230362032343737204D0A2D3436202D31393220560A2D3630202D383020560A34362031373120560A36302031303120560A2E30323138206720677361766520343532332031373337204E202D3630202D34362056202D3436202D313520562036302033312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343532332031373337204D0A2D3436202D333020560A2D3630202D333120560A343620313520560A363020343620560A2E30363537206720677361766520343634322031383632204E202D3630202D36382056202D3435202D343120562035392036312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343634322031383632204D0A2D3436202D343820560A2D3539202D363120560A343520343120560A363020363820560A2E31303237206720677361766520323630382031383039204E202D36302036352056202D34362036302056203630202D36372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323630382031383039204D0A2D343620353820560A2D363020363720560A3436202D363020560A3630202D363520560A2E31363038206720677361766520353436392031393831204E202D35392032352056202D34362035362056203630202D33312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353436392031393831204D0A2D343520353020560A2D363020333120560A3436202D353620560A3539202D323520560A2E313833206720677361766520333037322032323531204E202D3630202D3136302056202D3435202D39342056203539203132362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333037322032323531204D0A2D3436202D31323820560A2D3539202D31323620560A343520393420560A36302031363020560A2E313833206720677361766520343234372031393632204E202D3539203131352056202D3436203133342056203630202D3134372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343234372031393632204D0A2D34352031303220560A2D36302031343720560A3436202D31333420560A3539202D31313520560A2E33393831206720677361766520333332352032353831204E202D3630202D33342056202D3435202D32303420562035392032392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333332352032353831204D0A2D3436202D32303920560A2D3539202D323920560A34352032303420560A363020333420560A2E33363439206720677361766520333236352032353437204E202D3539202D37302056202D3436202D31393220562036302035382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333236352032353437204D0A2D3435202D32303420560A2D3630202D353820560A34362031393220560A353920373020560A2E32363635206720677361766520353232362032323232204E202D36302032342056202D34352033362056203539202D31362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353232362032323232204D0A2D343620343420560A2D353920313620560A3435202D333620560A3630202D323420560A2E32383135206720677361766520323136372032323937204E202D3630202D31372056202D3436203220562036302033312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323136372032323937204D0A2D343620313620560A2D3630202D333120560A3436202D3220560A363020313720560A2E343538206720677361766520333731352032353139204E202D3630203136342056202D3436202D3136302056203630202D3133332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333731352032353139204D0A2D3436202D31323920560A2D36302031333320560A34362031363020560A3630202D31363420560A2E30303035206720677361766520323935372031363835204E202D3630202D35302056202D343620313720562036302034322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323935372031363835204D0A2D3436203920560A2D3630202D343220560A3436202D313720560A363020353020560A2E30303937206720677361766520343436332031363931204E202D3630202D33352056202D3436203120562036302031392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343436332031363931204D0A2D3436202D313520560A2D3630202D313920560A3436202D3120560A363020333520560A2E30323931206720677361766520343331312031363938204E202D35392031342056202D3436203130382056203539202D34312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343331312031363938204D0A2D343620383120560A2D353920343120560A3436202D31303820560A3539202D313420560A2E32373733206720677361766520323237332032323535204E202D36302031342056202D3436203238205620363020322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323237332032323535204D0A2D343620343420560A2D3630202D3220560A3436202D323820560A3630202D313420560A2E30393731206720677361766520343730322031393337204E202D3630202D37352056202D3436202D343820562036302037332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343730322031393337204D0A2D3436202D353020560A2D3630202D373320560A343620343820560A363020373520560A2E30383231206720677361766520323635342031373630204E202D36302036302056202D34362035342056203630202D36352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323635342031373630204D0A2D343620343920560A2D363020363520560A3436202D353420560A3630202D363020560A2E30313136206720677361766520323835312031363532204E202D363020362056202D34362032382056203630202D31352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323835312031363532204D0A2D343620313920560A2D363020313520560A3436202D323820560A3630202D3620560A2E31343032206720677361766520353531352031393335204E202D35392031372056202D34362035342056203539202D32352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353531352031393335204D0A2D343620343620560A2D353920323520560A3436202D353420560A3539202D313720560A2E32383338206720677361766520353132312032323832204E202D3630202D322056202D343620313520562036302031352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353132312032323832204D0A2D343620323820560A2D3630202D313520560A3436202D313520560A3630203220560A2E31303433206720677361766520353636372031383832204E202D3630202D31342056202D3436203239205620363020332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353636372031383832204D0A2D343620313820560A2D3630202D3320560A3436202D323920560A363020313420560A2E31363834206720677361766520313836382032303830204E202D3630202D36342056202D3436202D313320562036302036302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313836382032303830204D0A2D3436202D313720560A2D3630202D363020560A343620313320560A363020363420560A2E32373035206720677361766520323130372032323830204E202D3539202D33332056202D3436202D3820562035392034332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323130372032323830204D0A2D3436203220560A2D3539202D343320560A3436203820560A353920333320560A2E32353134206720677361766520353237322032313733204E202D36302032392056202D34362034342056203630202D32342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353237322032313733204D0A2D343620343920560A2D363020323420560A3436202D343420560A3630202D323920560A2E31333238206720677361766520343736322032303136204E202D3630202D37392056202D3436202D353020562036302038322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343736322032303136204D0A2D3436202D343720560A2D3630202D383220560A343620353020560A363020373920560A2E313038206720677361766520343237392031383334204E202D35392036342056202D3436203134372056203539202D39382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343237392031383334204D0A2D34362031313320560A2D353920393820560A3436202D31343720560A3539202D363420560A2E31393736206720677361766520313932382032313433204E202D3630202D36332056202D3436202D313720562036302036322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313932382032313433204D0A2D3436202D313820560A2D3630202D363220560A343620313720560A363020363320560A2E32353134206720677361766520323034382032323437204E202D3630202D34362056202D3436202D313520562036302035332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323034382032323437204D0A2D3436202D3820560A2D3630202D353320560A343620313520560A363020343620560A2E32323633206720677361766520313938382032323031204E202D3630202D35382056202D3436202D313820562036302036312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313938382032323031204D0A2D3436202D313520560A2D3630202D363120560A343620313820560A363020353820560A2E303033206720677361766520343430332031363536204E202D3630202D32352056202D3436203138205620363020382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343430332031363536204D0A2D3436203120560A2D3630202D3820560A3436202D313820560A363020323520560A2E30363537206720677361766520323730302031373139204E202D36302035352056202D34362034362056203630202D36302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323730302031373139204D0A2D343620343120560A2D363020363020560A3436202D343620560A3630202D353520560A2E313233206720677361766520353536312031383937204E202D363020382056202D34352034372056203539202D31372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353536312031383937204D0A2D343620333820560A2D353920313720560A3435202D343720560A3630202D3820560A2E32363432206720677361766520323331392032313939204E202D36302032392056202D34362034312056203630202D31342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323331392032313939204D0A2D343620353620560A2D363020313420560A3436202D343120560A3630202D323920560A2E30303933206720677361766520343239372031363439204E202D3539202D332056202D34362038322056203630202D31362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343239372031363439204D0A2D343520363320560A2D363020313620560A3436202D383220560A3539203320560A2E30323131206720677361766520333031372031373839204E202D3630202D3130342056202D3436203920562036302039342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333031372031373839204D0A2D3436202D3120560A2D3630202D393420560A3436202D3920560A36302031303420560A2E32333233206720677361766520353331382032313139204E202D36302033322056202D34362035312056203630202D32392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353331382032313139204D0A2D343620353420560A2D363020323920560A3436202D353120560A3630202D333220560A2E32353039206720677361766520343230322032303634204E202D3630203134372056202D3436203132372056203630202D3137352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343230322032303634204D0A2D343620393920560A2D36302031373520560A3436202D31323720560A3630202D31343720560A2E32373935206720677361766520353036312032323830204E202D3630202D32312056202D3436203120562036302033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353036312032323830204D0A2D343620313520560A2D3630202D333520560A3436202D3120560A363020323120560A2E31373034206720677361766520343832322032303932204E202D3630202D37362056202D3436202D343720562036302038352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343832322032303932204D0A2D3436202D333820560A2D3630202D383520560A343620343720560A363020373620560A2E34303937206720677361766520343031382032333432204E202D3630203231342056202D3436202D322056203630202D3230392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343031382032333432204D0A2D3436203320560A2D36302032303920560A3436203220560A3630202D32313420560A2E30303037206720677361766520333030332031363730204E202D3630202D35322056202D343620313720562036302035302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333030332031363730204D0A2D343620313520560A2D3630202D353020560A3436202D313720560A363020353220560A2E30303838206720677361766520323839372031363335204E202D363020312056202D34362032322056203630202D362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323839372031363335204D0A2D343620313720560A2D3630203620560A3436202D323220560A3630202D3120560A2E32383338206720677361766520323231332032323639204E202D3630202D332056202D343620313420562036302031372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323231332032323639204D0A2D343620323820560A2D3630202D313720560A3436202D313420560A3630203320560A2E32343537206720677361766520323336352032313335204E202D36302034332056202D34362035302056203630202D32392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323336352032313335204D0A2D343620363420560A2D363020323920560A3436202D353020560A3630202D343320560A2E31353732206720677361766520333035382032313839204E202D3630202D3137342056202D3435202D36372056203539203134332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333035382032313839204D0A2D3436202D393820560A2D3539202D31343320560A343520363720560A36302031373420560A2E30363237206720677361766520333033302031393334204E202D3539202D3134362056202D3436202D392056203630203132372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333033302031393334204D0A2D3435202D323820560A2D3630202D31323720560A3436203920560A35392031343620560A2E3238206720677361766520353136362032323436204E202D35392031302056202D3436203234205620363020322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353136362032323436204D0A2D343520333620560A2D3630202D3220560A3436202D323420560A3539202D313020560A2E323037206720677361766520343838312032313632204E202D3539202D37302056202D3436202D333820562035392038302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343838312032313632204D0A2D3436202D323820560A2D3539202D383020560A343620333820560A353920373020560A2E3231206720677361766520353336342032303632204E202D36302033332056202D34362035362056203630202D33322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353336342032303632204D0A2D343620353720560A2D363020333220560A3436202D353620560A3630202D333320560A2E32363432206720677361766520353030312032323539204E202D3630202D34302056202D3436202D313420562036302035352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353030312032323539204D0A2D3436203120560A2D3630202D353520560A343620313420560A363020343020560A2E32333933206720677361766520343934312032323139204E202D3630202D35372056202D3436202D323820562036302037312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343934312032323139204D0A2D3436202D313420560A2D3630202D373120560A343620323820560A363020353720560A2E30353335206720677361766520323734352031363836204E202D35392034392056202D34362033392056203630202D35352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323734352031363836204D0A2D343520333320560A2D363020353520560A3436202D333920560A3539202D343920560A2E31313036206720677361766520353630372031383638204E202D3630202D332056202D34362034302056203630202D382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353630372031383638204D0A2D343620323920560A2D3630203820560A3436202D343020560A3630203320560A2E30303034206720677361766520343334332031363331204E202D3539202D31392056202D3436203334205620353920332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343334332031363331204D0A2D343620313820560A2D3539202D3320560A3436202D333420560A353920313920560A2E313034206720677361766520353731332031383733204E202D3630202D32332056202D343620313820562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353731332031383733204D0A2D3436203920560A2D3630202D313420560A3436202D313820560A363020323320560A2E32323335206720677361766520323431302032303637204E202D35392035352056202D34362035362056203630202D34332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323431302032303637204D0A2D343520363820560A2D363020343320560A3436202D353620560A3539202D353520560A2E31313239206720677361766520333034342032303737204E202D3539202D3137312056202D3436202D33362056203539203134352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333034342032303737204D0A2D3436202D363220560A2D3539202D31343520560A343620333620560A35392031373120560A2E313836206720677361766520353431302032303036204E202D36302032392056202D34362036302056203630202D33332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353431302032303036204D0A2D343620353620560A2D363020333320560A3436202D363020560A3630202D323920560A2E30383134206720677361766520343236352031373739204E202D35392034312056202D3436203134382056203630202D37302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343236352031373739204D0A2D34352031313920560A2D363020373020560A3436202D31343820560A3539202D343120560A2E33313339206720677361766520343135362032313633204E202D3630203137352056202D3436203130362056203630202D3139372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343135362032313633204D0A2D343620383420560A2D36302031393720560A3436202D31303620560A3630202D31373520560A2E33363439206720677361766520343131302032323437204E202D3630203139372056202D34362037342056203630202D3230392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343131302032323437204D0A2D343620363220560A2D36302032303920560A3436202D373420560A3630202D31393720560A2E33393831206720677361766520343036342032333039204E202D3630203230392056202D34362033382056203630202D3231342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343036342032333039204D0A2D343620333320560A2D36302032313420560A3436202D333820560A3630202D32303920560A2E31393936206720677361766520323435362031393939204E202D36302036332056202D34352036302056203539202D35352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323435362031393939204D0A2D343620363820560A2D353920353520560A3435202D363020560A3630202D363320560A2E31363231206720677361766520353435362031393532204E202D36302032342056202D34362035392056203630202D32392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353435362031393532204D0A2D343620353420560A2D363020323920560A3436202D353920560A3630202D323420560A2E3238206720677361766520323135332032323636204E202D3630202D32312056202D3435203220562035392033332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323135332032323636204D0A2D343620313420560A2D3539202D333320560A3435202D3220560A363020323120560A2E34393638206720677361766520333535302032363435204E202D35392039352056202D3436202D3230382056203630202D37332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333535302032363435204D0A2D3435202D31383620560A2D363020373320560A34362032303820560A3539202D393520560A2E30353639206720677361766520343536392031373837204E202D3630202D35342056202D3436202D343220562036302034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343536392031373837204D0A2D3436202D353020560A2D3630202D343620560A343620343220560A363020353420560A2E30343639206720677361766520343235322031373132204E202D36302031362056202D3436203133322056203630202D34302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343235322031373132204D0A2D34362031303820560A2D363020343020560A3436202D31333220560A3630202D313620560A2E32363739206720677361766520333133322032343133204E202D3630202D3136322056202D3436202D3132382056203630203133302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333133322032343133204D0A2D3436202D31363020560A2D3630202D31333020560A34362031323820560A36302031363220560A2E32373035206720677361766520353231322032323032204E202D36302031392056202D34352033352056203539202D31302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353231322032323032204D0A2D343620343420560A2D353920313020560A3435202D333520560A3630202D313920560A2E30383033206720677361766520343632382031383439204E202D3539202D36322056202D3436202D353020562035392035372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343632382031383439204D0A2D3436202D353520560A2D3539202D353720560A343620353020560A353920363220560A2E31373535206720677361766520323530322031393334204E202D36302036392056202D34362035392056203630202D36332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323530322031393334204D0A2D343620363520560A2D363020363320560A3436202D353920560A3630202D363920560A2E32373935206720677361766520323235392032323238204E202D36302031322056202D3436203236205620363020332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323235392032323238204D0A2D343620343120560A2D3630202D3320560A3436202D323620560A3630202D313220560A2E303233206720677361766520333036322031373737204E202D3539202D3130372056202D34362031352056203630203130342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333036322031373737204D0A2D343520313220560A2D3630202D31303420560A3436202D313520560A35392031303720560A2E31343032206720677361766520353530312031393035204E202D35392031352056202D34362035362056203630202D32342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353530312031393035204D0A2D343520343720560A2D363020323420560A3436202D353620560A3539202D313520560A2E30333839206720677361766520343530392031373333204E202D3630202D34352056202D3436202D333220562036302033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343530392031373333204D0A2D3436202D343220560A2D3630202D333520560A343620333220560A363020343520560A2E30343532206720677361766520323739312031363538204E202D35392034342056202D34362033332056203539202D34392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323739312031363538204D0A2D343620323820560A2D353920343920560A3436202D333320560A3539202D343420560A2E31383638206720677361766520313931342032303935204E202D3630202D36352056202D3436202D313420562036302036342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313931342032303935204D0A2D3436202D313520560A2D3630202D363420560A343620313420560A363020363520560A2E30313631206720677361766520343233382031363436204E202D3630202D332056202D34362039392056203630202D31342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343233382031363436204D0A2D343620383220560A2D363020313420560A3436202D393920560A3630203320560A2E30303035206720677361766520333034392031363438204E202D3630202D34392056202D343620313920562036302035322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333034392031363438204D0A2D343620323220560A2D3630202D353220560A3436202D313920560A363020343920560A2E30303739206720677361766520323934332031363138204E202D3630202D322056202D34362032302056203630202D312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323934332031363138204D0A2D343620313720560A2D3630203120560A3436202D323020560A3630203220560A30206720677361766520343238342031363132204E202D3630202D31342056202D3436203435205620363020332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343238342031363132204D0A2D343620333420560A2D3630202D3320560A3436202D343520560A363020313420560A2E32383338206720677361766520353130372032323536204E202D3630202D382056202D343620313120562036302032312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353130372032323536204D0A2D343620323420560A2D3630202D323120560A3436202D313120560A3630203820560A2E32363635206720677361766520323039332032323435204E202D3539202D33372056202D3436202D3720562036302034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323039332032323435204D0A2D3435203220560A2D3630202D343620560A3436203720560A353920333720560A2E31303432206720677361766520353635332031383530204E202D3630202D31342056202D3436203239205620363020332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353635332031383530204D0A2D343620313820560A2D3630202D3320560A3436202D323920560A363020313420560A2E31303834206720677361766520343638382031393138204E202D3630202D36392056202D3436202D353520562036302036382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343638382031393138204D0A2D3436202D353620560A2D3630202D363820560A343620353520560A363020363920560A2E32343436206720677361766520323033342032323038204E202D3630202D35312056202D3436202D313420562036302035382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323033342032323038204D0A2D3436202D3720560A2D3630202D353820560A343620313420560A363020353120560A2E323137206720677361766520313937342032313537204E202D3630202D36322056202D3436202D313520562036302036332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313937342032313537204D0A2D3436202D313420560A2D3630202D363320560A343620313520560A363020363220560A2E31353239206720677361766520323534382031383734204E202D36302037322056202D34362035372056203630202D36392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323534382031383734204D0A2D343620363020560A2D363020363920560A3436202D353720560A3630202D373220560A2E313833206720677361766520343233332031393437204E202D35392039382056202D3436203136342056203630202D3133322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343233332031393437204D0A2D34352031333020560A2D36302031333220560A3436202D31363420560A3539202D393820560A2E30323537206720677361766520343434392031363838204E202D3630202D33362056202D3436202D323120562036302032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343434392031363838204D0A2D3436202D333220560A2D3630202D323520560A343620323120560A363020333620560A2E32353533206720677361766520353235382032313531204E202D36302032362056202D34362034342056203630202D31392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353235382032313531204D0A2D343620353120560A2D363020313920560A3436202D343420560A3630202D323620560A2E31323232206720677361766520353534372031383635204E202D353920362056202D34362034392056203539202D31352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353534372031383635204D0A2D343620343020560A2D353920313520560A3436202D343920560A3539202D3620560A2E31343032206720677361766520343734382031393930204E202D3630202D37322056202D3436202D353620562036302037352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343734382031393930204D0A2D3436202D353320560A2D3630202D373520560A343620353620560A363020373220560A2E34393638206720677361766520333836362032353135204E202D3539203231332056202D3436202D39312056203630202D3139312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333836362032353135204D0A2D3435202D363920560A2D36302031393120560A343620393120560A3539202D32313320560A2E31333238206720677361766520323539342031383230204E202D36302037332056202D34362035332056203630202D37322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323539342031383230204D0A2D343620353420560A2D363020373220560A3436202D353320560A3630202D373320560A2E32373733206720677361766520353034372032323438204E202D3630202D32352056202D3436202D3420562036302034302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353034372032323438204D0A2D343620313120560A2D3630202D343020560A3436203420560A363020323520560A2E32363936206720677361766520323330352032313738204E202D36302032372056202D34362033352056203630202D31322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323330352032313738204D0A2D343620353020560A2D363020313220560A3436202D333520560A3630202D323720560A2E31373338206720677361766520343830382032303630204E202D3630202D37302056202D3436202D353320562036302037392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343830382032303630204D0A2D3436202D343420560A2D3630202D373920560A343620353320560A363020373020560A2E30373336206720677361766520333037362031393436204E202D3539202D3135372056202D3436202D312056203539203134362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333037362031393436204D0A2D3436202D313220560A2D3539202D31343620560A3436203120560A35392031353720560A2E32333533206720677361766520353330342032303935204E202D36302032392056202D34362035332056203630202D32362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353330342032303935204D0A2D343620353620560A2D363020323620560A3436202D353320560A3630202D323920560A2E30323131206720677361766520333130382031373532204E202D3539202D3130342056202D34362032322056203539203130372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333130382031373532204D0A2D343620323520560A2D3539202D31303720560A3436202D323220560A35392031303420560A2E303137206720677361766520343338392031363532204E202D3630202D32392056202D3435202D313120562035392031392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343338392031363532204D0A2D3436202D323120560A2D3539202D313920560A343520313120560A363020323920560A2E30303035206720677361766520343232342031353938204E202D3630202D31332056202D3436203533205620363020352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343232342031353938204D0A2D343620343520560A2D3630202D3520560A3436202D353320560A363020313320560A2E30343034206720677361766520323833372031363336204E202D36302034302056202D34352032362056203539202D34342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323833372031363336204D0A2D343620323220560A2D353920343420560A3435202D323620560A3630202D343020560A2E32383338206720677361766520323139392032323430204E202D3630202D362056202D343620313120562036302032312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323139392032323430204D0A2D343620323620560A2D3630202D323120560A3436202D313120560A3630203620560A2E32363132206720677361766520343938372032323233204E202D3630202D34322056202D3436202D313920562036302035372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343938372032323233204D0A2D3436202D3420560A2D3630202D353720560A343620313920560A363020343220560A2E323337206720677361766520343932372032313831204E202D3630202D35352056202D3435202D333420562035392037302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343932372032313831204D0A2D3436202D313920560A2D3539202D373020560A343520333420560A363020353520560A2E323037206720677361766520343836372032313236204E202D3539202D36362056202D3436202D343420562036302037362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343836372032313236204D0A2D3435202D333420560A2D3630202D373620560A343620343420560A353920363620560A2E32383135206720677361766520353135322032323231204E202D353920352056202D3436203232205620363020382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353135322032323231204D0A2D343520333520560A2D3630202D3820560A3436202D323220560A3539202D3520560A2E31313539206720677361766520323634302031373734204E202D36302037322056202D34362034372056203630202D37332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323634302031373734204D0A2D343620343620560A2D363020373320560A3436202D343720560A3630202D373220560A2E32313136206720677361766520353335302032303335204E202D36302033302056202D34362035392056203630202D32392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353335302032303335204D0A2D343620363020560A2D363020323920560A3436202D353920560A3630202D333020560A2E31303936206720677361766520353539332031383336204E202D3630202D342056202D34352033392056203539202D362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353539332031383336204D0A2D343620323920560A2D3539203620560A3435202D333920560A3630203420560A30206720677361766520333039342031363232204E202D3539202D34322056202D343620313920562036302034392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333039342031363232204D0A2D343520323620560A2D3630202D343920560A3436202D313920560A353920343220560A2E30303838206720677361766520323938392031353939204E202D363020302056202D3436203137205620363020322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323938392031353939204D0A2D343620313920560A2D3630202D3220560A3436202D313720560A3630203020560A2E30323131206720677361766520343137382031363433204E202D3630202D352056202D3436203130382056203630202D342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343137382031363433204D0A2D343620393920560A2D3630203420560A3436202D31303820560A3630203520560A2E32353533206720677361766520323335312032313232204E202D36302034312056202D34362034322056203630202D32372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323335312032313232204D0A2D343620353620560A2D363020323720560A3436202D343220560A3630202D343120560A2E313836206720677361766520353339362031393736204E202D36302032372056202D34362036322056203630202D33302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353339362031393736204D0A2D343620353920560A2D363020333020560A3436202D363220560A3630202D323720560A2E32373638206720677361766520323133392032323334204E202D3630202D32362056202D3435203020562035392033372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323133392032323334204D0A2D343620313120560A2D3539202D333720560A3435203020560A363020323620560A2E31363038206720677361766520353434322031393230204E202D36302032322056202D34362036312056203630202D32372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353434322031393230204D0A2D343620353620560A2D363020323720560A3436202D363120560A3630202D323220560A2E30313136206720677361766520343332392031363233204E202D3539202D32342056202D3436202D3120562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343332392031363233204D0A2D3435202D313120560A2D3630202D313420560A3436203120560A353920323420560A2E31353732206720677361766520343232302031383938204E202D36302037302056202D3436203137392056203630202D3130322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343232302031383938204D0A2D34362031343720560A2D36302031303220560A3436202D31373920560A3630202D373020560A2E30363237206720677361766520343139322031373238204E202D36302031342056202D3436203135302056203630202D33322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343139322031373238204D0A2D34362031333220560A2D363020333220560A3436202D31353020560A3630202D313420560A2E30313631206720677361766520333135342031373136204E202D3630202D39342056202D34352032362056203539203130342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333135342031373136204D0A2D343620333620560A2D3539202D31303420560A3435202D323620560A363020393420560A2E31303237206720677361766520323638362031373335204E202D36302037302056202D34362034312056203630202D37322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323638362031373335204D0A2D343620333920560A2D363020373220560A3436202D343120560A3630202D373020560A2E32303436206720677361766520313936302032313037204E202D3630202D36352056202D3436202D313220562036302036352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320313936302032313037204D0A2D3436202D313220560A2D3630202D363520560A343620313220560A363020363520560A2E33353433206720677361766520333139322032353632204E202D3630202D3134392056202D3436202D3136302056203630203132332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333139322032353632204D0A2D3436202D31383620560A2D3630202D31323320560A34362031363020560A36302031343920560A2E30303037206720677361766520343136342031353835204E202D3630202D31342056202D343620353720562036302031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343136342031353835204D0A2D343620353320560A2D3630202D313020560A3436202D353720560A363020313420560A2E32353937206720677361766520323037392032323038204E202D3539202D34332056202D3436202D3820562036302035312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323037392032323038204D0A2D3435203020560A2D3630202D353120560A3436203820560A353920343320560A2E32333435206720677361766520323032302032313635204E202D3630202D35382056202D3436202D313220562036302036322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323032302032313635204D0A2D3436202D3820560A2D3630202D363220560A343620313220560A363020353820560A2E32333831206720677361766520323339362032303632204E202D35392035332056202D34362034382056203630202D34312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323339362032303632204D0A2D343520363020560A2D363020343120560A3436202D343820560A3539202D353320560A2E32353039206720677361766520333131382032333831204E202D3630202D3139322056202D3436202D39382056203630203136302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333131382032333831204D0A2D3436202D31333020560A2D3630202D31363020560A343620393820560A36302031393220560A2E31333935206720677361766520333039302032313235204E202D3630202D3139312056202D3435202D32382056203539203137312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333039302032313235204D0A2D3436202D343820560A2D3539202D31373120560A343520323820560A36302031393120560A2E313338206720677361766520353438382031383731204E202D36302031342056202D34362035372056203630202D32322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353438382031383731204D0A2D343620343920560A2D363020323220560A3436202D353720560A3630202D313420560A2E32373233206720677361766520353139382032313737204E202D35392031352056202D34362033342056203539202D352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353139382032313737204D0A2D343620343420560A2D3539203520560A3436202D333420560A3539202D313520560A2E31313239206720677361766520343230362031383230204E202D36302034302056202D3436203137352056203630202D36372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343230362031383230204D0A2D34362031343820560A2D363020363720560A3436202D31373520560A3630202D343020560A2E353532206720677361766520333635352032363833204E202D3539203134382056202D3436202D3138362056203539202D3132322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333635352032363833204D0A2D3436202D31363020560A2D35392031323220560A34362031383620560A3539202D31343820560A2E30333839206720677361766520323838332031363136204E202D36302033392056202D34362032312056203630202D34302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323838332031363136204D0A2D343620323020560A2D363020343020560A3436202D323120560A3630202D333920560A2E32383232206720677361766520323234352032323035204E202D363020382056202D3436203231205620363020362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323234352032323035204D0A2D343620333520560A2D3630202D3620560A3436202D323120560A3630202D3820560A2E32383335206720677361766520353039332032323236204E202D3630202D31302056202D3436203720562036302032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353039332032323236204D0A2D343620323220560A2D3630202D323520560A3436202D3720560A363020313020560A2E35333738206720677361766520333439312032373430204E202D36302035372056202D3436202D3232322056203630202D34332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333439312032373430204D0A2D3436202D32303820560A2D363020343320560A34362032323220560A3630202D353720560A2E30373734206720677361766520333132322031393339204E202D3630202D3136322056202D34352031322056203539203135372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333132322031393339204D0A2D3436203720560A2D3539202D31353720560A3435202D313220560A36302031363220560A2E32363739206720677361766520343138382032303737204E202D3630203133322056202D3436203136362056203630202D3136342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343138382032303737204D0A2D34362031333420560A2D36302031363420560A3436202D31363620560A3630202D31333220560A2E30303933206720677361766520333230302031363730204E202D3630202D37382056202D343620333020562036302039342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333230302031363730204D0A2D343620343620560A2D3630202D393420560A3436202D333020560A363020373820560A2E353532206720677361766520333736312032363337204E202D3630203139302056202D3436202D3134342056203630202D3136342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333736312032363337204D0A2D3436202D31313820560A2D36302031363420560A34362031343420560A3630202D31393020560A2E303233206720677361766520343131382031363338204E202D3630202D31302056202D343620313131205620363020372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343131382031363338204D0A2D34362031303820560A2D3630202D3720560A3436202D31313120560A363020313020560A2E30303034206720677361766520333134302031353932204E202D3630202D32392056202D343520313720562035392034322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333134302031353932204D0A2D343620333020560A2D3539202D343220560A3435202D313720560A363020323920560A2E32313936206720677361766520323434322032303033204E202D35392036322056202D34362035302056203539202D35332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323434322032303033204D0A2D343620353920560A2D353920353320560A3436202D353020560A3539202D363220560A2E30303838206720677361766520343237302031353939204E202D3630202D31382056202D3436203420562036302031332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343237302031353939204D0A2D3436202D3120560A2D3630202D313320560A3436202D3420560A363020313820560A2E31313938206720677361766520353533332031383332204E202D353920332056202D34362035302056203630202D31342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353533332031383332204D0A2D343520333920560A2D363020313420560A3436202D353020560A3539202D3320560A2E32303431206720677361766520333130342032323830204E202D3630202D3230332056202D3436202D36322056203630203137342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333130342032323830204D0A2D3436202D393120560A2D3630202D31373420560A343620363220560A36302032303320560A2E30313136206720677361766520333033352031353830204E202D363020362056202D3436203133205620363020302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333033352031353830204D0A2D343620313920560A2D3630203020560A3436202D313320560A3630202D3620560A2E32353636206720677361766520353234342032313234204E202D36302032332056202D34352034352056203539202D31352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353234342032313234204D0A2D343620353320560A2D353920313520560A3435202D343520560A3630202D323320560A2E31303237206720677361766520343631342031383530204E202D3539202D35362056202D3436202D363120562036302035342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343631342031383530204D0A2D3435202D363320560A2D3630202D353420560A343620363120560A353920353620560A2E30393333206720677361766520323733322031373032204E202D36302036392056202D34362033342056203630202D37302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323733322031373032204D0A2D343620333320560A2D363020373020560A3436202D333420560A3630202D363920560A2E31323732206720677361766520343637342031393131204E202D3630202D36312056202D3435202D363320562035392036322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343637342031393131204D0A2D3436202D363220560A2D3539202D363220560A343520363320560A363020363120560A2E30383231206720677361766520343535352031373934204E202D3630202D35302056202D3436202D353620562036302034352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343535352031373934204D0A2D3436202D363120560A2D3630202D343520560A343620353620560A363020353020560A2E32373635206720677361766520353033332032323136204E202D3630202D32362056202D3436202D3920562036302034322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353033332032323136204D0A2D3436203720560A2D3630202D343220560A3436203920560A363020323620560A2E30303035206720677361766520343130342031353731204E202D3630202D31342056202D343620353320562036302031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343130342031353731204D0A2D343620353720560A2D3630202D313820560A3436202D353320560A363020313420560A2E30303331206720677361766520333234362031363232204E202D3630202D35392056202D343620323920562036302037382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333234362031363232204D0A2D343620343820560A2D3630202D373820560A3436202D323920560A363020353920560A2E32303131206720677361766520323438382031393436204E202D36302036392056202D34352035302056203539202D36322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323438382031393436204D0A2D343620353720560A2D353920363220560A3435202D353020560A3630202D363920560A2E31353437206720677361766520343733342031393735204E202D3630202D36342056202D3436202D363220562036302036392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343733342031393735204D0A2D3436202D353720560A2D3630202D363920560A343620363220560A363020363420560A2E32333533206720677361766520353239302032303635204E202D36302032372056202D34362035352056203630202D32332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353239302032303635204D0A2D343620353920560A2D363020323320560A3436202D353520560A3630202D323720560A2E32383235206720677361766520323138352032323133204E202D3630202D31332056202D3436203820562036302032362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323138352032323133204D0A2D343620323120560A2D3630202D323620560A3436202D3820560A363020313320560A2E323736206720677361766520323239312032313633204E202D36302032312056202D34362032392056203630202D382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323239312032313633204D0A2D343620343220560A2D3630203820560A3436202D323920560A3630202D323120560A2E30363537206720677361766520343439352031373434204E202D3630202D34322056202D3436202D353020562036302033362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343439352031373434204D0A2D3436202D353620560A2D3630202D333620560A343620353020560A363020343220560A2E32363132206720677361766520343937332032313930204E202D3630202D34312056202D3436202D323320562036302035352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343937332032313930204D0A2D3436202D3920560A2D3630202D353520560A343620323320560A363020343120560A2E31383338206720677361766520343739342032303338204E202D3630202D36332056202D3436202D353720562036302037322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343739342032303338204D0A2D3436202D343820560A2D3630202D373220560A343620353720560A363020363320560A2E30323131206720677361766520343035382031363238204E202D3630202D31382056202D34352031303920562035392032302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343035382031363238204D0A2D34362031313120560A2D3539202D323020560A3435202D31303920560A363020313820560A2E30373336206720677361766520333136382031393130204E202D3630202D3135382056202D34362032352056203630203136322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333136382031393130204D0A2D343620323920560A2D3630202D31363220560A3436202D323520560A36302031353820560A2E32333933206720677361766520343931332032313439204E202D3539202D35312056202D3436202D333820562035392036362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343931332032313439204D0A2D3436202D323320560A2D3539202D363620560A343620333820560A353920353120560A2E32313237206720677361766520343835342032303938204E202D3630202D36302056202D3436202D343820562036302037302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343835342032303938204D0A2D3436202D333820560A2D3630202D373020560A343620343820560A363020363020560A2E3231206720677361766520353333362032303033204E202D36302032382056202D34362036312056203630202D32372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353333362032303033204D0A2D343620363220560A2D363020323720560A3436202D363120560A3630202D323820560A2E35333738206720677361766520333931322032353534204E202D3539203232362056202D3436202D35322056203539202D3231332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333931322032353534204D0A2D3436202D333920560A2D35392032313320560A343620353220560A3539202D32323620560A2E32383139206720677361766520353133392032313932204E202D363020332056202D343620323120562036302031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353133392032313932204D0A2D343620333420560A2D3630202D313020560A3436202D323120560A3630202D3320560A2E30373336206720677361766520343133322031373432204E202D363020342056202D3436203136322056203630202D31362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343133322031373432204D0A2D34362031353020560A2D363020313620560A3436202D31363220560A3630202D3420560A2E34333334206720677361766520333235322032363835204E202D3630202D3132332056202D3436202D3138362056203630203130312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333235322032363835204D0A2D3436202D32303820560A2D3630202D31303120560A34362031383620560A36302031323320560A2E30303739206720677361766520343231302031353831204E202D3630202D31362056202D3436203620562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343231302031353831204D0A2D3436203420560A2D3630202D313420560A3436202D3620560A363020313620560A2E30343034206720677361766520323932392031353939204E202D36302034312056202D34362031352056203630202D33392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323932392031353939204D0A2D343620313720560A2D363020333920560A3436202D313520560A3630202D343120560A2E313833206720677361766520353338322031393432204E202D36302032342056202D34362036352056203630202D32382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353338322031393432204D0A2D343620363120560A2D363020323820560A3436202D363520560A3630202D323420560A2E31383338206720677361766520323533342031383933204E202D36302037342056202D34362034382056203630202D36392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323533342031383933204D0A2D343620353320560A2D363020363920560A3436202D343820560A3630202D373420560A2E323731206720677361766520323132352032323030204E202D3539202D33342056202D3436202D3120562035392034332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323132352032323030204D0A2D3436203820560A2D3539202D343320560A3436203120560A353920333420560A2E30353335206720677361766520343433352031373032204E202D3630202D33352056202D3436202D343420562036302032392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343433352031373032204D0A2D3436202D353020560A2D3630202D323920560A343620343420560A363020333520560A2E31353638206720677361766520353432382031383835204E202D36302031382056202D34362036332056203630202D32342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353432382031383835204D0A2D343620353720560A2D363020323420560A3436202D363320560A3630202D313820560A2E353532206720677361766520333433312032373937204E202D36302031302056202D3436202D3232362056203630202D362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333433312032373937204D0A2D3436202D32323220560A2D3630203620560A34362032323620560A3630202D313020560A2E32343934206720677361766520323036362032313636204E202D3630202D35312056202D3436202D3820562036302035382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323036362032313636204D0A2D3436202D3120560A2D3630202D353820560A3436203820560A363020353120560A2E32323039206720677361766520323030362032313135204E202D3630202D36332056202D3436202D313020562036302036352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323030362032313135204D0A2D3436202D3820560A2D3630202D363520560A343620313020560A363020363320560A2E30383737206720677361766520323737372031363736204E202D35392036372056202D34362032382056203630202D36392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323737372031363736204D0A2D343520323620560A2D363020363920560A3436202D323820560A3539202D363720560A2E30313631206720677361766520333939382031363130204E202D3539202D32322056202D343620393820562036302033332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333939382031363130204D0A2D34352031303920560A2D3630202D333320560A3436202D393820560A353920323220560A30206720677361766520343034342031353537204E202D3539202D31352056202D343620343620562035392032322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343034342031353537204D0A2D343620353320560A2D3539202D323220560A3436202D343620560A353920313520560A2E303033206720677361766520333138362031353633204E202D3630202D31342056202D343620313420562036302032392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333138362031353633204D0A2D343620323920560A2D3630202D323920560A3436202D313420560A363020313420560A2E30363237206720677361766520333231342031383632204E202D3630202D3134362056202D34362033362056203630203135382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333231342031383632204D0A2D343620343820560A2D3630202D31353820560A3436202D333620560A36302031343620560A30206720677361766520333239322031353736204E202D3630202D33362056202D343620323320562036302035392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333239322031353736204D0A2D343620343620560A2D3630202D353920560A3436202D323320560A363020333620560A2E32363634206720677361766520323333372032313135204E202D36302033342056202D34362033352056203630202D32312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323333372032313135204D0A2D343620343820560A2D363020323120560A3436202D333520560A3630202D333420560A2E30343639206720677361766520333236302031373938204E202D3630202D3132382056202D34362034362056203630203134362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333236302031373938204D0A2D343620363420560A2D3630202D31343620560A3436202D343620560A36302031323820560A2E30313331206720677361766520333335322031363533204E202D3630202D37372056202D34362034362056203630203130332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333335322031363533204D0A2D343620373220560A2D3630202D31303320560A3436202D343620560A363020373720560A2E30323931206720677361766520333330362031373235204E202D3630202D3130332056202D34362034382056203630203132382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333330362031373235204D0A2D343620373320560A2D3630202D31323820560A3436202D343820560A36302031303320560A2E31333337206720677361766520353437342031383335204E202D36302031302056202D34362035382056203630202D31382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353437342031383335204D0A2D343620353020560A2D363020313820560A3436202D353820560A3630202D313020560A2E303137206720677361766520333038302031353633204E202D35392031342056202D343620392056203630202D362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333038302031353633204D0A2D343520313720560A2D3630203620560A3436202D3920560A3539202D313420560A2E35333738206720677361766520333337312032383037204E202D3630202D33382056202D3436202D32323220562036302033342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333337312032383037204D0A2D3436202D32323620560A2D3630202D333420560A34362032323220560A363020333820560A2E34393638206720677361766520333331312032373639204E202D3539202D38342056202D3436202D32303820562035392037302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333331312032373639204D0A2D3436202D32323220560A2D3539202D373020560A34362032303820560A353920383420560A2E30303933206720677361766520333933392031353838204E202D3630202D32362056202D343620383320562036302034312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333933392031353838204D0A2D343620393820560A2D3630202D343120560A3436202D383320560A363020323620560A2E31353732206720677361766520333133362032313530204E202D3630202D3230342056202D3436202D31322056203630203139312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333133362032313530204D0A2D3436202D323520560A2D3630202D31393120560A343620313220560A36302032303420560A2E31363837206720677361766520323538302031383436204E202D36302037372056202D34362034342056203630202D37342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323538302031383436204D0A2D343620343720560A2D363020373420560A3436202D343420560A3630202D373720560A2E33353433206720677361766520343134322032323131204E202D3630203136342056202D3436203135332056203630202D3139302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343134322032323131204D0A2D34362031323720560A2D36302031393020560A3436202D31353320560A3630202D31363420560A2E32373233206720677361766520353138342032313437204E202D35392031332056202D34362033352056203630202D332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353138342032313437204D0A2D343520343520560A2D3630203320560A3436202D333520560A3539202D313320560A2E30343532206720677361766520343337352031363637204E202D3630202D32382056202D3435202D343020562035392032342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343337352031363637204D0A2D3436202D343420560A2D3539202D323420560A343520343020560A363020323820560A2E30303235206720677361766520333339372031353839204E202D3539202D34392056202D343620333620562036302037372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333339372031353839204D0A2D343520363420560A2D3630202D373720560A3436202D333620560A353920343920560A2E32383335206720677361766520353037392032313935204E202D3630202D31312056202D3436203620562036302032362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353037392032313935204D0A2D343620323120560A2D3630202D323620560A3436202D3620560A363020313120560A2E32383338206720677361766520323233312032313834204E202D363020302056202D343620313620562036302031332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323233312032313834204D0A2D343620323920560A2D3630202D313320560A3436202D313620560A3630203020560A2E30303838206720677361766520343135302031353635204E202D3630202D31322056202D3436203420562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343135302031353635204D0A2D3436203620560A2D3630202D313420560A3436202D3420560A363020313220560A2E32353039206720677361766520343137342032303435204E202D3630203130322056202D3436203139362056203630202D3133342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343137342032303435204D0A2D34362031363420560A2D36302031333420560A3436202D31393620560A3630202D31303220560A2E31333935206720677361766520343134362031383630204E202D36302033322056202D3436203139352056203630202D35322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343134362031383630204D0A2D34362031373520560A2D363020353220560A3436202D31393520560A3630202D333220560A2E30303331206720677361766520333837392031353632204E202D3630202D32342056202D343620363320562036302034342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333837392031353632204D0A2D343620383320560A2D3630202D343420560A3436202D363320560A363020323420560A2E30373734206720677361766520343037322031373436204E202D3630202D372056202D343520313636205620353920332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343037322031373436204D0A2D34362031363220560A2D3539202D3320560A3435202D31363620560A3630203720560A2E30303034206720677361766520333938352031353432204E202D3630202D31332056202D343620333320562036302032362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333938352031353432204D0A2D343620343620560A2D3630202D323620560A3436202D333320560A363020313320560A2E32353434206720677361766520323338332032303635204E202D36302034362056202D34362033382056203630202D33342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323338332032303635204D0A2D343620353020560A2D363020333420560A3436202D333820560A3630202D343620560A2E32353533206720677361766520353233302032303932204E202D35392032312056202D34362034372056203539202D31332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353233302032303932204D0A2D343620353520560A2D353920313320560A3436202D343720560A3539202D323120560A2E30303533206720677361766520333530332031353931204E202D3630202D35312056202D343620343920562036302038322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333530332031353931204D0A2D343620383020560A2D3630202D383220560A3436202D343920560A363020353120560A2E30343532206720677361766520323937352031353836204E202D36302034342056202D34362031302056203630202D34312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323937352031353836204D0A2D343620313320560A2D363020343120560A3436202D313020560A3630202D343420560A2E30383538206720677361766520323832332031363535204E202D36302036372056202D34352032312056203539202D36372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323832332031363535204D0A2D343620323120560A2D353920363720560A3435202D323120560A3630202D363720560A2E31353635206720677361766520323632362031383035204E202D36302037392056202D34362033392056203630202D37372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323632362031383035204D0A2D343620343120560A2D363020373720560A3436202D333920560A3630202D373920560A2E30343034206720677361766520343331352031363339204E202D3539202D32322056202D3436202D333620562036302031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343331352031363339204D0A2D3435202D343020560A2D3630202D313820560A343620333620560A353920323220560A2E33353433206720677361766520333137382032353732204E202D3630202D3139312056202D3436202D3133302056203630203136322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333137382032353732204D0A2D3436202D31353920560A2D3630202D31363220560A34362031333020560A36302031393120560A2E32373733206720677361766520353031392032313834204E202D3630202D32352056202D3436202D313020562036302034312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353031392032313834204D0A2D3436203620560A2D3630202D343120560A343620313020560A363020323520560A2E30303533206720677361766520333630382031353830204E202D3539202D34342056202D343620353520562036302037362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333630382031353830204D0A2D343520383720560A2D3630202D373620560A3436202D353520560A353920343420560A2E32333233206720677361766520353237362032303331204E202D36302032342056202D34352035382056203539202D32312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353237362032303331204D0A2D343620363120560A2D353920323120560A3435202D353820560A3630202D323420560A2E32373835206720677361766520323137312032313834204E202D3630202D32332056202D3435203520562035392033342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323137312032313834204D0A2D343620313620560A2D3539202D333420560A3435202D3520560A363020323320560A2E353532206720677361766520333935382032353536204E202D3630203233302056202D3435202D362056203539202D3232362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333935382032353536204D0A2D3436202D3220560A2D35392032323620560A3435203620560A3630202D32333020560A2E32303431206720677361766520343136302031393638204E202D36302036372056202D3436203230372056203630202D39352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343136302031393638204D0A2D34362031373920560A2D363020393520560A3436202D32303720560A3630202D363720560A2E30313331206720677361766520333737332031363031204E202D3630202D34322056202D343520383120562035392036392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333737332031363031204D0A2D34362031303820560A2D3539202D363920560A3435202D383120560A363020343220560A2E30303235206720677361766520333731332031353539204E202D3539202D33322056202D343620353320562036302036302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333731332031353539204D0A2D343520383120560A2D3630202D363020560A3436202D353320560A353920333220560A2E30373336206720677361766520343031322031373339204E202D3539202D32302056202D34362031363220562036302032342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343031322031373339204D0A2D34352031363620560A2D3630202D323420560A3436202D31363220560A353920323020560A2E30303937206720677361766520333233322031353430204E202D363020322056202D3436203720562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333233322031353430204D0A2D343620323320560A2D3630202D313420560A3436202D3720560A3630202D3220560A2E30303235206720677361766520333333382031353430204E202D3630202D31342056202D343620313420562036302033362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333333382031353430204D0A2D343620333620560A2D3630202D333620560A3436202D313420560A363020313420560A2E32303533206720677361766520353332322031393636204E202D36302032352056202D34362036342056203630202D32342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353332322031393636204D0A2D343620363520560A2D363020323420560A3436202D363420560A3630202D323520560A2E303233206720677361766520333435372031363731204E202D3630202D38322056202D34352036342056203539203131342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333435372031363731204D0A2D343620393620560A2D3539202D31313420560A3435202D363420560A363020383220560A30206720677361766520333831392031353338204E202D3630202D32302056202D343620343120562036302034322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333831392031353338204D0A2D343620363320560A2D3630202D343220560A3436202D343120560A363020323020560A2E32363134206720677361766520323131312032313631204E202D3539202D34342056202D3436202D3220562036302035312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323131312032313631204D0A2D3435203520560A2D3630202D353120560A3436203220560A353920343420560A2E32333533206720677361766520323035322032313137204E202D3630202D35382056202D3436202D3720562036302036332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323035322032313137204D0A2D3436202D3220560A2D3630202D363320560A3436203720560A363020353820560A2E31373731206720677361766520353336382031393033204E202D36302032312056202D34362036372056203630202D32352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353336382031393033204D0A2D343620363320560A2D363020323520560A3436202D363720560A3630202D323120560A2E30323931206720677361766520333833332031363435204E202D3630202D34342056202D34362031303820562036302036382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333833332031363435204D0A2D34362031333220560A2D3630202D363820560A3436202D31303820560A363020343420560A2E34333334206720677361766520343039362032333338204E202D3630203139302056202D3436203132372056203630202D3231312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343039362032333338204D0A2D34362031303620560A2D36302032313120560A3436202D31323720560A3630202D31393020560A2E30313136206720677361766520343039302031353533204E202D3630202D392056202D3435202D3220562035392031352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343039302031353533204D0A2D3436203420560A2D3539202D313520560A3435203220560A3630203920560A2E32343135206720677361766520323432382032303135204E202D35392035352056202D34362034312056203630202D34362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323432382032303135204D0A2D343520353020560A2D363020343620560A3436202D343120560A3539202D353520560A2E30303034206720677361766520333434332031353430204E202D3539202D32322056202D343620323220562035392034392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333434332031353430204D0A2D343620343920560A2D3539202D343920560A3436202D323220560A353920323220560A2E32363432206720677361766520343935392032313539204E202D3630202D33362056202D3435202D323520562035392035312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343935392032313539204D0A2D3436202D313020560A2D3539202D353120560A343520323520560A363020333620560A2E32383135206720677361766520353132352032313630204E202D363020322056202D343620323220562036302031312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353132352032313630204D0A2D343620333520560A2D3630202D313120560A3436202D323220560A3630202D3220560A2E30363237206720677361766520333935332031373139204E202D3630202D33332056202D34362031353020562036302034352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333935332031373139204D0A2D34362031363220560A2D3630202D343520560A3436202D31353020560A363020333320560A2E30343639206720677361766520333839332031363836204E202D3630202D34312056202D34362031333220562036302035392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333839332031363836204D0A2D34362031353020560A2D3630202D353920560A3436202D31333220560A363020343120560A2E32383135206720677361766520323237372032313439204E202D36302031332056202D3436203232205620363020302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323237372032313439204D0A2D343620333520560A2D3630203020560A3436202D323220560A3630202D313320560A2E31353033206720677361766520353431342031383435204E202D36302031352056202D34362036342056203630202D32312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353431342031383435204D0A2D343620353820560A2D363020323120560A3436202D363420560A3630202D313520560A2E30323537206720677361766520333132362031353439204E202D35392032352056202D343620332056203539202D31342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333132362031353439204D0A2D343620313420560A2D353920313420560A3436202D3320560A3539202D323520560A2E32343537206720677361766520343839392032313233204E202D3539202D34362056202D3436202D333920562036302036302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343839392032313233204D0A2D3435202D323520560A2D3630202D363020560A343620333920560A353920343620560A2E31363334206720677361766520333138322032313438204E202D3630202D3230392056202D343620372056203630203230342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333138322032313438204D0A2D3436203220560A2D3630202D32303420560A3436202D3720560A36302032303920560A2E30303031206720677361766520333534392031353336204E202D3630202D32332056202D343620323720562036302035312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333534392031353336204D0A2D343620353520560A2D3630202D353120560A3436202D323720560A363020323320560A2E32343236206720677361766520333135302032333439204E202D3630202D3232342056202D3436202D34382056203630203230332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333135302032333439204D0A2D3436202D363920560A2D3630202D32303320560A343620343820560A36302032323420560A2E303033206720677361766520333932352031353239204E202D3630202D392056202D343620313820562036302032342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333932352031353239204D0A2D343620333320560A2D3630202D323420560A3436202D313820560A3630203920560A2E32323335206720677361766520343834302032303737204E202D3630202D35322056202D3436202D353020562036302036332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343834302032303737204D0A2D3436202D333920560A2D3630202D363320560A343620353020560A363020353220560A2E31393936206720677361766520343738302032303235204E202D3630202D35352056202D3436202D353920562036302036342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343738302032303235204D0A2D3436202D353020560A2D3630202D363420560A343620353920560A363020353520560A2E31343735206720677361766520323637322031373731204E202D36302037392056202D34362033342056203630202D37392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323637322031373731204D0A2D343620333420560A2D363020373920560A3436202D333420560A3630202D373920560A2E34393638206720677361766520343035302032343434204E202D3630203231312056202D34362038392056203630202D3232362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343035302032343434204D0A2D343620373420560A2D36302032323620560A3436202D383920560A3630202D32313120560A2E35333738206720677361766520343030342032353138204E202D3630203232362056202D34362034322056203630202D3233302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343030342032353138204D0A2D343620333820560A2D36302032333020560A3436202D343220560A3630202D32323620560A2E31373535206720677361766520343732302031393730204E202D3630202D35352056202D3436202D363520562036302036312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343732302031393730204D0A2D3436202D353920560A2D3630202D363120560A343620363520560A363020353520560A2E30333839206720677361766520343235362031363137204E202D3630202D31372056202D3436202D333520562036302031362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343235362031363137204D0A2D3436202D333620560A2D3630202D313620560A343620333520560A363020313720560A2E31353239206720677361766520343636302031393135204E202D3630202D35332056202D3435202D363820562035392035362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343636302031393135204D0A2D3436202D363520560A2D3539202D353620560A343520363820560A363020353320560A2E303233206720677361766520333636382031363430204E202D3630202D36302056202D343520383720562035392039322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333636382031363430204D0A2D34362031313920560A2D3539202D393220560A3435202D383720560A363020363020560A2E36323638206720677361766520333539362032383331204E202D3539203131352056202D3436202D3230362056203539202D39352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333539362032383331204D0A2D3436202D31383620560A2D353920393520560A34362032303620560A3539202D31313520560A2E303237206720677361766520333536332031363637204E202D3630202D37362056202D34362038302056203630203130392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333536332031363637204D0A2D34362031313320560A2D3630202D31303920560A3436202D383020560A363020373620560A2E30343938206720677361766520333431312031373637204E202D3539202D3131342056202D34362037322056203539203134352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333431312031373637204D0A2D34362031303320560A2D3539202D31343520560A3436202D373220560A35392031313420560A2E31333238206720677361766520343630302031383632204E202D3539202D34392056202D3436202D363920562036302035302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343630302031383632204D0A2D3435202D363820560A2D3630202D353020560A343620363920560A353920343920560A2E30303034206720677361766520333635342031353237204E202D3539202D31382056202D343620323720562035392034342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333635342031353237204D0A2D343620353320560A2D3539202D343420560A3436202D323720560A353920313820560A2E32323836206720677361766520323437342031393637204E202D35392036332056202D34362034302056203539202D35352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323437342031393637204D0A2D343620343820560A2D353920353520560A3436202D343020560A3539202D363320560A2E30383737206720677361766520323836392031363430204E202D36302036372056202D34362031352056203630202D36372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323836392031363430204D0A2D343620313520560A2D363020363720560A3436202D313520560A3630202D363720560A2E33313339206720677361766520333136342032343939204E202D3630202D3231392056202D3436202D39312056203630203139322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333136342032343939204D0A2D3436202D31313820560A2D3630202D31393220560A343620393120560A36302032313920560A2E32373035206720677361766520353137312032313133204E202D36302031322056202D34362033372056203630202D322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353137312032313133204D0A2D343620343720560A2D3630203220560A3436202D333720560A3630202D313220560A2E31313539206720677361766520343534312031383133204E202D3630202D34332056202D3436202D363820562036302034322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343534312031383133204D0A2D3436202D363920560A2D3630202D343220560A343620363820560A363020343320560A2E30353335206720677361766520333032312031353737204E202D36302034392056202D343620342056203630202D34342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333032312031353737204D0A2D3436203920560A2D363020343420560A3436202D3420560A3630202D343920560A2E30303235206720677361766520333735392031353138204E202D3539202D392056202D343620313820562035392033322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333735392031353138204D0A2D343620343120560A2D3539202D333220560A3436202D313820560A3539203920560A2E31353732206720677361766520343038362031383932204E202D36302031362056202D3436203230392056203630202D33302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343038362031383932204D0A2D34362031393520560A2D363020333020560A3436202D32303920560A3630202D313620560A2E32383237206720677361766520323231372032313632204E202D3630202D31322056202D343620313120562036302032332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323231372032313632204D0A2D343620323220560A2D3630202D323320560A3436202D313120560A363020313220560A2E36323638206720677361766520333830372032373238204E202D3630203230392056202D3436202D3131302056203630202D3139302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333830372032373238204D0A2D3436202D393120560A2D36302031393020560A34362031313020560A3630202D32303920560A2E32383338206720677361766520353036352032313632204E202D3630202D31302056202D3436203720562036302032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353036352032313632204D0A2D343620323220560A2D3630202D323520560A3436202D3720560A363020313020560A2E32373635206720677361766520323332332032313131204E202D36302032342056202D34362032372056203630202D31332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323332332032313131204D0A2D343620333820560A2D363020313320560A3436202D323720560A3630202D323420560A2E30383134206720677361766520333336352031383730204E202D3539202D3134352056202D34362037332056203630203137302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333336352031383730204D0A2D343520393820560A2D3630202D31373020560A3436202D373320560A35392031343520560A2E303137206720677361766520343033302031353434204E202D3539202D352056202D3436202D313020562036302031332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343033302031353434204D0A2D3435202D3220560A2D3630202D313320560A343620313020560A3539203520560A2E31353732206720677361766520333232382032313134204E202D3630202D3230342056202D34362032392056203630203230392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333232382032313134204D0A2D343620333420560A2D3630202D32303920560A3436202D323920560A36302032303420560A2E31303237206720677361766520343438312031373730204E202D3630202D33362056202D3436202D363720562036302033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343438312031373730204D0A2D3436202D363820560A2D3630202D333520560A343620363720560A363020333620560A2E32353134206720677361766520353231362032303535204E202D35392031392056202D34362035312056203630202D31322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353231362032303535204D0A2D343520353820560A2D363020313220560A3436202D353120560A3539202D313920560A2E313432206720677361766520323731382031373433204E202D36302038302056202D34362032372056203630202D37392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323731382031373433204D0A2D343620323820560A2D363020373920560A3436202D323720560A3630202D383020560A2E30343938206720677361766520333732372031373039204E202D3539202D36392056202D34362031313920562035392039382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333732372031373039204D0A2D34362031343820560A2D3539202D393820560A3436202D31313920560A353920363920560A2E30343034206720677361766520343139362031363030204E202D3630202D31312056202D3436202D333620562036302031322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343139362031363030204D0A2D3436202D333520560A2D3630202D313220560A343620333620560A363020313120560A2E31313239206720677361766520333332302031393638204E202D3630202D3137302056202D34362036342056203630203139312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333332302031393638204D0A2D343620383520560A2D3630202D31393120560A3436202D363420560A36302031373020560A2E31333935206720677361766520333237342032303533204E202D3630202D3139312056202D34362034382056203630203230342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333237342032303533204D0A2D343620363120560A2D3630202D32303420560A3436202D343820560A36302031393120560A2E30313236206720677361766520333338342031353138204E202D363020372056202D3436203120562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333338342031353138204D0A2D343620323220560A2D3630202D313420560A3436202D3120560A3630202D3720560A2E30323138206720677361766520333237382031353236204E202D36302031392056202D3436202D332056203630202D322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333237382031353236204D0A2D343620313420560A2D3630203220560A3436203320560A3630202D313920560A2E32373035206720677361766520323135372032313530204E202D3539202D33352056202D3436203220562035392034342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323135372032313530204D0A2D343620313120560A2D3539202D343420560A3436202D3220560A353920333520560A2E32313639206720677361766520323532302031393233204E202D36302036392056202D34352033382056203539202D36332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323532302031393233204D0A2D343620343420560A2D353920363320560A3435202D333820560A3630202D363920560A2E30303937206720677361766520333836352031353230204E202D3630202D332056202D3436203120562036302032302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333836352031353230204D0A2D343620313820560A2D3630202D323020560A3436202D3120560A3630203320560A2E32343734206720677361766520323039382032313135204E202D3630202D35342056202D3436202D3220562036302035382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323039382032313135204D0A2D3436203220560A2D3630202D353820560A3436203220560A363020353420560A2E32323633206720677361766520353236322031393931204E202D35392032322056202D34362036312056203539202D31392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353236322031393931204D0A2D343620363420560A2D353920313920560A3436202D363120560A3539202D323220560A2E30303838206720677361766520333438392031353133204E202D363020312056202D3435203420562035392032322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333438392031353133204D0A2D343620323720560A2D3539202D323220560A3435202D3420560A3630202D3120560A2E31393736206720677361766520353330382031393234204E202D36302032312056202D34352036382056203539202D32322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353330382031393234204D0A2D343620363720560A2D353920323220560A3435202D363820560A3630202D323120560A2E31363834206720677361766520353335342031383630204E202D36302031372056202D34362036382056203630202D32312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353335342031383630204D0A2D343620363420560A2D363020323120560A3436202D363820560A3630202D313720560A2E30363237206720677361766520333531372031373830204E202D3630202D3130392056202D34362039362056203630203134332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333531372031373830204D0A2D34362031333020560A2D3630202D31343320560A3436202D393620560A36302031303920560A2E32373935206720677361766520353030352032313532204E202D3630202D32312056202D3436202D3820562036302033362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353030352032313532204D0A2D3436203720560A2D3630202D333620560A3436203820560A363020323120560A2E30303838206720677361766520333539352031353039204E202D363020312056202D3436203320562036302032332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333539352031353039204D0A2D343620323720560A2D3630202D323320560A3436202D3320560A3630202D3120560A2E30393333206720677361766520343432312031373334204E202D3630202D33302056202D3436202D363520562036302032382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343432312031373334204D0A2D3436202D363720560A2D3630202D323820560A343620363520560A363020333020560A2E33353433206720677361766520343132382032323039204E202D3630203133342056202D3436203139362056203630202D3136342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343132382032323039204D0A2D34362031363620560A2D36302031363420560A3436202D31393620560A3630202D31333420560A2E30333839206720677361766520333137322031353432204E202D36302033372056202D3435202D352056203539202D32352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333137322031353432204D0A2D3436203720560A2D353920323520560A3435203520560A3630202D333720560A2E36353837206720677361766520333730312032383237204E202D3630203136392056202D3435202D3136352056203539202D3134382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333730312032383237204D0A2D3436202D31343420560A2D35392031343820560A34352031363520560A3630202D31363920560A2E32363936206720677361766520323336392032303730204E202D36302033352056202D34362033302056203630202D32342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323336392032303730204D0A2D343620343120560A2D363020323420560A3436202D333020560A3630202D333520560A2E30363237206720677361766520333632322031373539204E202D3539202D39322056202D3436203131332056203630203132362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333632322031373539204D0A2D34352031343720560A2D3630202D31323620560A3436202D31313320560A353920393220560A2E3238206720677361766520353131312032313235204E202D363020322056202D343620323520562036302031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353131312032313235204D0A2D343620333720560A2D3630202D313020560A3436202D323520560A3630202D3220560A2E30393333206720677361766520323931352031363330204E202D36302036392056202D343620382056203630202D36372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323931352031363330204D0A2D343620313020560A2D363020363720560A3436202D3820560A3630202D363920560A2E31363334206720677361766520343032362031393038204E202D3539202D332056202D3436203231332056203539202D312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343032362031393038204D0A2D34362032303920560A2D3539203120560A3436202D32313320560A3539203320560A2E30383134206720677361766520333738372031373737204E202D3630202D36382056202D34362031343820562036302039342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333738372031373737204D0A2D34362031373420560A2D3630202D393420560A3436202D31343820560A363020363820560A2E343538206720677361766520333233382032373438204E202D3630202D3137362056202D3436202D3135392056203630203134392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333233382032373438204D0A2D3436202D31383620560A2D3630202D31343920560A34362031353920560A36302031373620560A2E30313236206720677361766520333730302031353039204E202D363020332056202D3435202D3320562035392031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333730302031353039204D0A2D343620313820560A2D3539202D313820560A3435203320560A3630202D3320560A2E32383339206720677361766520323236332032313335204E202D3630202D312056202D343620313620562036302031322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323236332032313335204D0A2D343620323720560A2D3630202D313220560A3436202D313620560A3630203120560A2E323037206720677361766520323536362031383834204E202D36302037332056202D34362033352056203630202D36392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323536362031383834204D0A2D343620333920560A2D363020363920560A3436202D333520560A3630202D373320560A2E32363936206720677361766520343934352032313331204E202D3539202D33312056202D3436202D323320562035392034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343934352032313331204D0A2D3436202D3820560A2D3539202D343620560A343620323320560A353920333120560A2E30323537206720677361766520333937312031353339204E202D363020312056202D3436202D3230205620363020392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333937312031353339204D0A2D3436202D313020560A2D3630202D3920560A343620323020560A3630202D3120560A2E31343032206720677361766520323736332031373232204E202D35392038302056202D34362032312056203630202D38302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323736332031373232204D0A2D343520323120560A2D363020383020560A3436202D323120560A3539202D383020560A2E30343532206720677361766520343133362031353839204E202D3630202D352056202D3436202D3430205620363020392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343133362031353839204D0A2D3436202D333620560A2D3630202D3920560A343620343020560A3630203520560A2E30383737206720677361766520343336312031373034204E202D3539202D32342056202D3436202D363320562035392032322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343336312031373034204D0A2D3436202D363520560A2D3539202D323220560A343620363320560A353920323420560A2E32343236206720677361766520343130302032303335204E202D36302035322056202D3436203232392056203630202D37342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343130302032303335204D0A2D34362032303720560A2D363020373420560A3436202D32323920560A3630202D353220560A2E30363537206720677361766520333036372031353734204E202D36302035352056202D3436202D332056203630202D34392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333036372031353734204D0A2D3436203320560A2D363020343920560A3436203320560A3630202D353520560A2E32353533206720677361766520343838362032313030204E202D3630202D33392056202D3436202D333620562036302035322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343838362032313030204D0A2D3436202D323320560A2D3630202D353220560A343620333620560A363020333920560A2E32363739206720677361766520333139362032333838204E202D3630202D3233382056202D3436202D32352056203630203232342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333139362032333838204D0A2D3436202D333920560A2D3630202D32323420560A343620323520560A36302032333820560A2E31313239206720677361766520333834372031383336204E202D3630202D35392056202D34362031373420562036302038312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333834372031383336204D0A2D34362031393620560A2D3630202D383120560A3436202D31373420560A363020353920560A2E32363635206720677361766520353135372032303734204E202D36302031322056202D34362034312056203630202D322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353135372032303734204D0A2D343620353120560A2D3630203220560A3436202D343120560A3630202D313220560A2E31353732206720677361766520333936372031393035204E202D3630202D32342056202D34362032303820562036302032392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333936372031393035204D0A2D34362032313320560A2D3630202D323920560A3436202D32303820560A363020323420560A2E31333935206720677361766520333930372031383831204E202D3630202D34352056202D34362031393620562036302035372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333930372031383831204D0A2D34362032303820560A2D3630202D353720560A3436202D31393620560A363020343520560A2E30323138206720677361766520333830352031353137204E202D363020372056202D3435202D3135205620353920392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333830352031353137204D0A2D3436203120560A2D3539202D3920560A343520313520560A3630202D3720560A2E323632206720677361766520323431352032303330204E202D36302034342056202D34362033312056203630202D33352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323431352032303330204D0A2D343620343020560A2D363020333520560A3436202D333120560A3630202D343420560A2E32373638206720677361766520323230332032313334204E202D3630202D32362056202D3435203720562035392033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323230332032313334204D0A2D343620313620560A2D3539202D333520560A3435202D3720560A363020323620560A2E32333831206720677361766520343832362032303631204E202D3630202D34332056202D3436202D343820562036302035352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343832362032303631204D0A2D3436202D333620560A2D3630202D353520560A343620343820560A363020343320560A2E33313339206720677361766520343131342032313437204E202D36302039352056202D3436203232332056203630202D3132322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343131342032313437204D0A2D34362031393620560A2D36302031323220560A3436202D32323320560A3630202D393520560A2E32353732206720677361766520323134332032313038204E202D3539202D34382056202D3436203120562036302035342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323134332032313038204D0A2D3435203720560A2D3630202D353420560A3436202D3120560A353920343820560A2E32343436206720677361766520353230332032303133204E202D36302031372056202D34362035362056203630202D31322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353230332032303133204D0A2D343620363120560A2D363020313220560A3436202D353620560A3630202D313720560A2E32383338206720677361766520353035312032313237204E202D3630202D372056202D343620313120562036302032312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353035312032313237204D0A2D343620323520560A2D3630202D323120560A3436202D313120560A3630203720560A2E313038206720677361766520333437312031393130204E202D3630202D3134332056202D3436203130332056203630203137352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333437312031393130204D0A2D34362031333520560A2D3630202D31373520560A3436202D31303320560A36302031343320560A2E32313936206720677361766520343736362032303138204E202D3630202D34362056202D3436202D353720562036302035352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343736362032303138204D0A2D3436202D343820560A2D3630202D353520560A343620353720560A363020343620560A2E363735206720677361766520333533372032393436204E202D36302036392056202D3436202D3231382056203630202D35372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333533372032393436204D0A2D3436202D32303620560A2D363020353720560A34362032313820560A3630202D363920560A2E31393936206720677361766520323631322031383530204E202D36302037362056202D34362033312056203630202D37332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323631322031383530204D0A2D343620333420560A2D363020373320560A3436202D333120560A3630202D373620560A2E323137206720677361766520353234382031393435204E202D35392032302056202D34362036352056203630202D31372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353234382031393435204D0A2D343520363820560A2D363020313720560A3436202D363520560A3539202D323020560A2E30333133206720677361766520333432392031353134204E202D35392032352056202D3436202D31342056203630202D372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333432392031353134204D0A2D3435203420560A2D3630203720560A343620313420560A3539202D323520560A2E31383638206720677361766520353239342031383737204E202D36302031382056202D34352037302056203539202D32302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353239342031383737204D0A2D343620363820560A2D353920323020560A3435202D373020560A3630202D313820560A2E30383538206720677361766520343330322031363830204E202D3630202D31372056202D3436202D363320562036302031372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343330322031363830204D0A2D3436202D363320560A2D3630202D313720560A343620363320560A363020313720560A2E30343034206720677361766520333332342031353235204E202D36302033342056202D3436202D31342056203630202D31392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333332342031353235204D0A2D3436203120560A2D363020313920560A343620313420560A3630202D333420560A2E32303131206720677361766520343730362031393732204E202D3630202D34362056202D3436202D363420562036302035332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343730362031393732204D0A2D3436202D353720560A2D3630202D353320560A343620363420560A363020343620560A2E32383239206720677361766520323330392032313035204E202D363020392056202D3436203230205620363020312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323330392032313035204D0A2D343620333020560A2D3630202D3120560A3436202D323020560A3630202D3920560A2E30323835206720677361766520333533352031353130204E202D36302032302056202D3436202D31362056203630202D312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333533352031353130204D0A2D3436203320560A2D3630203120560A343620313620560A3630202D323020560A2E31383338206720677361766520343634362031393236204E202D3539202D34332056202D3436202D373020562035392034392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343634362031393236204D0A2D3436202D363420560A2D3539202D343920560A343620373020560A353920343320560A2E31303237206720677361766520323936312031363236204E202D36302037312056202D343620322056203630202D36392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323936312031363236204D0A2D3436203420560A2D363020363920560A3436202D3220560A3630202D373120560A2E30353335206720677361766520343037362031353834204E202D353920302056202D3436202D3435205620353920352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343037362031353834204D0A2D3436202D343020560A2D3539202D3520560A343620343520560A3539203020560A2E313432206720677361766520323830392031373037204E202D35392038302056202D34362031352056203539202D38302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323830392031373037204D0A2D343620313520560A2D353920383020560A3436202D313520560A3539202D383020560A2E313038206720677361766520333638312031383537204E202D3539202D39382056202D3435203134372056203539203133302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333638312031383537204D0A2D34352031373920560A2D3539202D31333020560A3435202D31343720560A353920393820560A2E30353639206720677361766520333231382031353435204E202D36302034372056202D3436202D31332056203630202D33372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333231382031353435204D0A2D3436202D3320560A2D363020333720560A343620313320560A3630202D343720560A2E30333839206720677361766520333931312031353430204E202D363020392056202D3436202D3332205620363020332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333931312031353430204D0A2D3436202D323020560A2D3630202D3320560A343620333220560A3630202D3920560A2E32353434206720677361766520323436302031393932204E202D35392035312056202D34362033312056203630202D34342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323436302031393932204D0A2D343520333820560A2D363020343420560A3436202D333120560A3539202D353120560A2E30333133206720677361766520333634302031353132204E202D35392031392056202D3436202D32312056203630202D312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333634302031353132204D0A2D3435202D3320560A2D3630203120560A343620323120560A3539202D313920560A2E32383232206720677361766520343939312032313230204E202D3630202D31372056202D3435202D3320562035392033312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343939312032313230204D0A2D343620313120560A2D3539202D333120560A3435203320560A363020313720560A2E31363837206720677361766520343538372031383833204E202D3630202D34302056202D3436202D373320562036302034332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343538372031383833204D0A2D3436202D373020560A2D3630202D343320560A343620373320560A363020343020560A2E363735206720677361766520333835332032373830204E202D3630203232322056202D3436202D36352056203630202D3230392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333835332032373830204D0A2D3436202D353220560A2D36302032303920560A343620363520560A3630202D32323220560A2E313138206720677361766520333537372031393036204E202D3630202D3132362056202D3436203133302056203630203136302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333537372031393036204D0A2D34362031363420560A2D3630202D31363020560A3436202D31333020560A36302031323620560A2E32373638206720677361766520353039372032303836204E202D363020342056202D3436203330205620363020372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353039372032303836204D0A2D343620343120560A2D3630202D3720560A3436202D333020560A3630202D3420560A2E353532206720677361766520333239372032383930204E202D3539202D3134322056202D3436202D3138362056203630203132332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333239372032383930204D0A2D3435202D32303520560A2D3630202D31323320560A34362031383620560A35392031343220560A2E343538206720677361766520343038322032333735204E202D3630203136342056202D3436203137392056203630202D3139302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343038322032333735204D0A2D34362031353320560A2D36302031393020560A3436202D31373920560A3630202D31363420560A2E313935206720677361766520323635382031383233204E202D36302037372056202D34362032362056203630202D37362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323635382031383233204D0A2D343620323720560A2D363020373620560A3436202D323620560A3630202D373720560A2E32383038206720677361766520323234392032313134204E202D3630202D31382056202D343620313220562036302032362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323234392032313134204D0A2D343620323020560A2D3630202D323620560A3436202D313220560A363020313820560A2E34333334206720677361766520333232342032373136204E202D3630202D3231372056202D3436202D3131382056203630203139312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333232342032373136204D0A2D3436202D31343420560A2D3630202D31393120560A34362031313820560A36302032313720560A2E31353732206720677361766520333432352032303435204E202D3630202D3137352056202D34352039382056203539203230332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333432352032303435204D0A2D34362031323620560A2D3539202D32303320560A3435202D393820560A36302031373520560A2E30383737206720677361766520343234322031363633204E202D3630202D31312056202D3436202D363320562036302031312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343234322031363633204D0A2D3436202D363320560A2D3630202D313120560A343620363320560A363020313120560A2E33363439206720677361766520333231302032353839204E202D3630202D3234302056202D3436202D36392056203630203231392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333231302032353839204D0A2D3436202D393020560A2D3630202D32313920560A343620363920560A36302032343020560A2E32373637206720677361766520333234322032333930204E202D3630202D3234322056202D343620322056203630203233382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333234322032333930204D0A2D3436202D3220560A2D3630202D32333820560A3436202D3220560A36302032343220560A2E30383231206720677361766520333131322031353739204E202D35392036302056202D3436202D31302056203630202D35352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333131322031353739204D0A2D3435202D3520560A2D363020353520560A343620313020560A3539202D363020560A2E31353635206720677361766520343532372031383433204E202D3630202D33352056202D3436202D373420562036302033362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343532372031383433204D0A2D3436202D373320560A2D3630202D333620560A343620373420560A363020333520560A2E30343034206720677361766520333734352031353234204E202D35392031382056202D3436202D33302056203630202D332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333734352031353234204D0A2D3435202D313520560A2D3630203320560A343620333020560A3539202D313820560A2E32383035206720677361766520323335352032303734204E202D36302031382056202D34362032322056203630202D392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323335352032303734204D0A2D343620333120560A2D3630203920560A3436202D323220560A3630202D313820560A2E32363438206720677361766520323138392032303936204E202D3539202D34312056202D3436203520562035392034382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323138392032303936204D0A2D343620313220560A2D3539202D343820560A3436202D3520560A353920343120560A2E32353937206720677361766520353134332032303330204E202D36302031322056202D34362034382056203630202D342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353134332032303330204D0A2D343620353620560A2D3630203420560A3436202D343820560A3630202D313220560A2E323736206720677361766520343933312032313033204E202D3539202D32342056202D3436202D313820562036302033392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343933312032313033204D0A2D3435202D3320560A2D3630202D333920560A343620313820560A353920323420560A2E32363739206720677361766520343034302032303837204E202D36302033302056202D3435203234322056203539202D34332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343034302032303837204D0A2D34362032323920560A2D353920343320560A3435202D32343220560A3630202D333020560A2E36393137206720677361766520333437372033303135204E202D36302031352056202D3436202D3232332056203630202D31302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333437372033303135204D0A2D3436202D32313820560A2D363020313020560A34362032323320560A3630202D313520560A2E32343737206720677361766520323530362031393537204E202D36302035362056202D34352033302056203539202D35312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323530362031393537204D0A2D343620333520560A2D353920353120560A3435202D333020560A3630202D353620560A2E32333435206720677361766520353138392031393635204E202D36302031362056202D34362036312056203630202D31322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353138392031393635204D0A2D343620363520560A2D363020313220560A3436202D363120560A3630202D313620560A2E32303436206720677361766520353233342031383935204E202D35392031362056202D34362037302056203630202D31362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353233342031383935204D0A2D343520373020560A2D363020313620560A3436202D373020560A3539202D313620560A2E363735206720677361766520333431372033303330204E202D3630202D34332056202D3436202D32313820562036302033382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333431372033303330204D0A2D3436202D32323320560A2D3630202D333820560A34362032313820560A363020343320560A2E36323638206720677361766520333335372032393837204E202D3630202D39372056202D3435202D32303520562035392038342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333335372032393837204D0A2D3436202D32313820560A2D3539202D383420560A34352032303520560A363020393720560A2E31343735206720677361766520343436372031383038204E202D3630202D32392056202D3436202D373520562036302033302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343436372031383038204D0A2D3436202D373420560A2D3630202D333020560A343620373520560A363020323920560A2E30363537206720677361766520343031372031353834204E202D363020372056202D3436202D35312056203630202D312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343031372031353834204D0A2D3436202D343520560A2D3630203120560A343620353120560A3630202D3720560A2E32303431206720677361766520333337392032313731204E202D3539202D3230332056202D34362038352056203630203232342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333337392032313731204D0A2D34352031303620560A2D3630202D32323420560A3436202D383520560A35392032303320560A2E31343735206720677361766520323835352031363939204E202D36302037392056202D343520392056203539202D38302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323835352031363939204D0A2D3436203820560A2D353920383020560A3435202D3920560A3630202D373920560A2E32343236206720677361766520333333342032323737204E202D3630202D3232342056202D34362036312056203630203233382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333333342032323737204D0A2D343620373520560A2D3630202D32333820560A3436202D363120560A36302032323420560A2E32363739206720677361766520333238382032333532204E202D3630202D3233382056202D34362033342056203630203234322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333238382032333532204D0A2D343620333820560A2D3630202D32343220560A3436202D333420560A36302032333820560A2E31353732206720677361766520333734312031393531204E202D3630202D39342056202D3435203137392056203539203132322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333734312031393531204D0A2D34362032303720560A2D3539202D31323220560A3435202D31373920560A363020393420560A2E32383235206720677361766520353033372032303930204E202D3630202D342056202D343620313720562036302031372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353033372032303930204D0A2D343620333020560A2D3630202D313720560A3436202D313720560A3630203420560A2E32363634206720677361766520343837322032303739204E202D3630202D33312056202D3436202D333020562036302034332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343837322032303739204D0A2D3436202D313820560A2D3630202D343320560A343620333020560A363020333120560A2E31393334206720677361766520323730342031383032204E202D36302037372056202D34362032312056203630202D37372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323730342031383032204D0A2D343620323120560A2D363020373720560A3436202D323120560A3630202D373720560A2E30353639206720677361766520333835312031353439204E202D36302031372056202D3436202D34322056203630202D372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333835312031353439204D0A2D3436202D333220560A2D3630203720560A343620343220560A3630202D313720560A2E31313539206720677361766520333030372031363239204E202D36302037322056202D3436202D342056203630202D37312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333030372031363239204D0A2D3436202D3320560A2D363020373120560A3436203420560A3630202D373220560A2E30393333206720677361766520343138322031363532204E202D3630202D342056202D3436202D3634205620363020352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343138322031363532204D0A2D3436202D363320560A2D3630202D3520560A343620363420560A3630203420560A2E30363537206720677361766520333337302031353339204E202D36302034352056202D3436202D32352056203630202D33342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333337302031353339204D0A2D3436202D313420560A2D363020333420560A343620323520560A3630202D343520560A2E30353837206720677361766520333437352031353330204E202D35392033382056202D3436202D32392056203539202D32352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333437352031353330204D0A2D3436202D313620560A2D353920323520560A343620323920560A3539202D333820560A2E323833206720677361766520323239352032303932204E202D3630202D31302056202D343620313420562036302031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323239352032303932204D0A2D343620323220560A2D3630202D313820560A3436202D313420560A363020313020560A2E32373733206720677361766520323430312032303433204E202D36302032352056202D34362032342056203630202D31382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323430312032303433204D0A2D343620333120560A2D363020313820560A3436202D323420560A3630202D323520560A2E32353434206720677361766520343831322032303438204E202D3630202D33342056202D3436202D343220562036302034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343831322032303438204D0A2D3436202D333020560A2D3630202D343620560A343620343220560A363020333420560A2E32343235206720677361766520323535322031393236204E202D36302036302056202D34362032372056203630202D35362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323535322031393236204D0A2D343620333120560A2D363020353620560A3436202D323720560A3630202D363020560A2E313432206720677361766520343430372031373739204E202D3630202D32342056202D3435202D373520562035392032342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343430372031373739204D0A2D3436202D373520560A2D3539202D323420560A343520373520560A363020323420560A2E30383033206720677361766520333236342031353539204E202D36302035352056202D3436202D32322056203630202D34372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333236342031353539204D0A2D3436202D313420560A2D363020343720560A343620323220560A3630202D353520560A2E353532206720677361766520343033362032353238204E202D3630203139302056202D3436203134372056203630202D3231302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343033362032353238204D0A2D34362031323720560A2D36302032313020560A3436202D31343720560A3630202D31393020560A2E30353837206720677361766520333538312031353331204E202D36302033332056202D3436202D33342056203630202D32302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333538312031353331204D0A2D3436202D323120560A2D363020323020560A343620333420560A3630202D333320560A2E36393137206720677361766520333839382032373836204E202D3539203232372056202D3436202D31312056203630202D3232322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333839382032373836204D0A2D3435202D3620560A2D36302032323220560A343620313120560A3539202D32323720560A2E323731206720677361766520353038332032303432204E202D363020362056202D3436203338205620363020342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353038332032303432204D0A2D343620343820560A2D3630202D3420560A3436202D333820560A3630202D3620560A2E32373035206720677361766520323233352032303832204E202D3630202D33352056202D3435203820562035392034312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323233352032303832204D0A2D343620313420560A2D3539202D343120560A3435202D3820560A363020333520560A2E32373637206720677361766520333938302032313137204E202D353920312056202D3436203234372056203630202D362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333938302032313137204D0A2D34352032343220560A2D3630203620560A3436202D32343720560A3539202D3120560A2E37343334206720677361766520333634312032393936204E202D3539203133322056202D3435202D3138322056203539202D3131352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333634312032393936204D0A2D3435202D31363520560A2D35392031313520560A34352031383220560A3539202D31333220560A2E32343135206720677361766520343735322032303134204E202D3630202D33362056202D3436202D353220562036302034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343735322032303134204D0A2D3436202D343220560A2D3630202D343620560A343620353220560A363020333620560A2E313833206720677361766520333533312032303730204E202D3630202D3136302056202D3436203133352056203630203139312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333533312032303730204D0A2D34362031363620560A2D3630202D31393120560A3436202D31333520560A36302031363020560A2E32383338206720677361766520343937372032303836204E202D3630202D31322056202D3435203520562035392032342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343937372032303836204D0A2D343620313720560A2D3539202D323420560A3435202D3520560A363020313220560A2E32303431206720677361766520333830312032303332204E202D3630202D38312056202D3436203230372056203630203130322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333830312032303332204D0A2D34362032323820560A2D3630202D31303220560A3436202D32303720560A363020383120560A2E34333334206720677361766520343036382032333433204E202D3630203132322056202D3436203232312056203630202D3134372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343036382032333433204D0A2D34362031393620560A2D36302031343720560A3436202D32323120560A3630202D31323220560A2E33363439206720677361766520343035342032323432204E202D36302037342056202D3436203234332056203630202D39342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343035342032323432204D0A2D34362032323320560A2D363020393420560A3436202D32343320560A3630202D373420560A2E37343334206720677361766520333734372032393337204E202D3630203138372056202D3436202D3132382056203630202D3136392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333734372032393337204D0A2D3436202D31313020560A2D36302031363920560A34362031323820560A3630202D31383720560A2E32343934206720677361766520353132392031393831204E202D36302031322056202D34362035352056203630202D362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353132392031393831204D0A2D343620363120560A2D3630203620560A3436202D353520560A3630202D313220560A2E30363537206720677361766520333638362031353432204E202D36302033302056202D3435202D34312056203539202D31392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333638362031353432204D0A2D3436202D333020560A2D353920313920560A343520343120560A3630202D333020560A2E31303237206720677361766520333135382031353932204E202D35392036342056202D3436202D31372056203539202D36302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333135382031353932204D0A2D3436202D313320560A2D353920363020560A343620313720560A3539202D363420560A2E313833206720677361766520333633362032303336204E202D3539202D3133302056202D3436203136342056203630203136322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333633362032303336204D0A2D34352031393620560A2D3630202D31363220560A3436202D31363420560A35392031333020560A2E36323638206720677361766520333939302032363535204E202D3630203231302056202D3435203130312056203539202D3232322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333939302032363535204D0A2D343620383920560A2D35392032323220560A3435202D31303120560A3630202D32313020560A2E363735206720677361766520333934342032373434204E202D3539203232322056202D34362034372056203539202D3232372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333934342032373434204D0A2D343620343220560A2D35392032323720560A3436202D343720560A3539202D32323220560A2E32323039206720677361766520353137352031393131204E202D36302031352056202D34362036372056203630202D31322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353137352031393131204D0A2D343620373020560A2D363020313220560A3436202D363720560A3630202D313520560A2E32363739206720677361766520333932312032313138204E202D3630202D32392056202D34362032343220562036302033342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333932312032313138204D0A2D34362032343720560A2D3630202D333420560A3436202D32343220560A363020323920560A2E32343236206720677361766520333836312032303839204E202D3630202D35372056202D34362032323820562036302037312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333836312032303839204D0A2D34362032343220560A2D3630202D373120560A3436202D32323820560A363020353720560A2E32323836206720677361766520343639322031393738204E202D3630202D33362056202D3435202D353920562035392034332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343639322031393738204D0A2D3436202D353220560A2D3539202D343320560A343520353920560A363020333620560A2E30383231206720677361766520333935372031353931204E202D36302031342056202D3436202D35362056203630202D392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333935372031353931204D0A2D3436202D353120560A2D3630203920560A343620353620560A3630202D313420560A2E31343032206720677361766520343334372031373535204E202D3539202D31372056202D3436202D373520562036302031372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343334372031373535204D0A2D3435202D373520560A2D3630202D313720560A343620373520560A353920313720560A2E313935206720677361766520323735302031373837204E202D36302037372056202D34362031352056203630202D37372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323735302031373837204D0A2D343620313520560A2D363020373720560A3436202D313520560A3630202D373720560A2E31353635206720677361766520323930312031363937204E202D36302037382056202D343620332056203630202D37392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323930312031363937204D0A2D3436203220560A2D363020373920560A3436202D3320560A3630202D373820560A2E32373431206720677361766520323434362032303133204E202D35392033312056202D34362032342056203630202D32352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323434362032303133204D0A2D343520333020560A2D363020323520560A3436202D323420560A3539202D333120560A2E31303237206720677361766520343132322031363438204E202D363020322056202D3435202D3636205620353920302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343132322031363438204D0A2D3436202D363420560A2D3539203020560A343520363620560A3630202D3220560A2E32383338206720677361766520323334312032303638204E202D3630202D332056202D343620313720562036302031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323334312032303638204D0A2D343620323420560A2D3630202D313020560A3436202D313720560A3630203320560A2E32333933206720677361766520323539382031393030204E202D36302036322056202D34362032342056203630202D36302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323539382031393030204D0A2D343620323620560A2D363020363020560A3436202D323420560A3630202D363220560A2E32383135206720677361766520343931372032303734204E202D3539202D31382056202D3436202D3820562036302033312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343931372032303734204D0A2D3435203520560A2D3630202D333120560A3436203820560A353920313820560A2E32313639206720677361766520343633322031393432204E202D3539202D33342056202D3436202D363520562036302034302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343633322031393432204D0A2D3435202D353920560A2D3630202D343020560A343620363520560A353920333420560A2E33393831206720677361766520333235362032363431204E202D3630202D3235332056202D3436202D33392056203630203234302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333235362032363431204D0A2D3436202D353220560A2D3630202D32343020560A343620333920560A36302032353320560A2E32373835206720677361766520353032332032303438204E202D3630202D312056202D343620323720562036302031322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353032332032303438204D0A2D343620333820560A2D3630202D313220560A3436202D323720560A3630203120560A2E30383033206720677361766520333739312031353636204E202D35392032362056202D3436202D35302056203539202D31382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333739312031353636204D0A2D3436202D343220560A2D353920313820560A343620353020560A3539202D323620560A2E31333238206720677361766520333035332031363339204E202D36302037332056202D3436202D31312056203630202D37322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333035332031363339204D0A2D3436202D313020560A2D363020373220560A343620313120560A3630202D373320560A2E32373435206720677361766520323238312032303635204E202D3630202D33302056202D343620313220562036302033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323238312032303635204D0A2D343620313720560A2D3630202D333520560A3436202D313220560A363020333020560A2E353532206720677361766520333238342032393133204E202D3630202D3139372056202D3436202D3134342056203630203137362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333238342032393133204D0A2D3436202D31363520560A2D3630202D31373620560A34362031343420560A36302031393720560A2E323037206720677361766520343537332031393038204E202D3630202D33312056202D3436202D363920562036302033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343537332031393038204D0A2D3436202D363520560A2D3630202D333520560A343620363920560A363020333120560A2E313432206720677361766520343238382031373338204E202D3630202D31302056202D3436202D373620562036302031312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343238382031373338204D0A2D3436202D373520560A2D3630202D313120560A343620373620560A363020313020560A2E32363134206720677361766520353036392031393933204E202D363020362056202D3436203438205620363020312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353036392031393933204D0A2D343620353520560A2D3630202D3120560A3436202D343820560A3630202D3620560A2E32373635206720677361766520343835382032303536204E202D3630202D32322056202D3436202D323020562036302033342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343835382032303536204D0A2D3436202D3820560A2D3630202D333420560A343620323020560A363020323220560A2E32373134206720677361766520323439322031393836204E202D35392033362056202D34362032322056203539202D33312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323439322031393836204D0A2D343620323720560A2D353920333120560A3436202D323220560A3539202D333620560A2E30393731206720677361766520333431362031353638204E202D36302035322056202D3436202D33362056203630202D34352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333431362031353638204D0A2D3436202D323920560A2D363020343520560A343620333620560A3630202D353220560A2E32333533206720677361766520353131352031393236204E202D36302031302056202D34362036332056203630202D362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353131352031393236204D0A2D343620363720560A2D3630203620560A3436202D363320560A3630202D313020560A2E32353039206720677361766520333438352032323336204E202D3630202D3139312056202D3436203132362056203630203231392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333438352032323336204D0A2D34362031353420560A2D3630202D32313920560A3436202D31323620560A36302031393120560A2E32383338206720677361766520323338372032303434204E202D363020332056202D3436203138205620363020332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323338372032303434204D0A2D343620323420560A2D3630202D3320560A3436202D313820560A3630202D3320560A2E32333831206720677361766520323634342031383739204E202D36302036332056202D34362032302056203630202D36322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323634342031383739204D0A2D343620323120560A2D363020363220560A3436202D323020560A3630202D363320560A2E31393936206720677361766520323739352031373738204E202D35392037362056202D34362031302056203630202D37372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323739352031373738204D0A2D3435203920560A2D363020373720560A3436202D313020560A3539202D373620560A2E30393333206720677361766520333532312031353634204E202D36302034352056202D3435202D34312056203539202D33382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333532312031353634204D0A2D3436202D333420560A2D353920333820560A343520343120560A3630202D343520560A2E31303834206720677361766520333331302031353834204E202D36302036302056202D3436202D33302056203630202D35352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333331302031353834204D0A2D3436202D323520560A2D363020353520560A343620333020560A3630202D363020560A2E31313539206720677361766520343036322031363530204E202D353920392056202D3436202D36382056203630202D372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343036322031363530204D0A2D3435202D363620560A2D3630203720560A343620363820560A3539202D3920560A2E31393936206720677361766520343531332031383737204E202D3630202D32372056202D3436202D373120562036302032392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343531332031383737204D0A2D3436202D363920560A2D3630202D323920560A343620373120560A363020323720560A2E32383237206720677361766520343936332032303437204E202D3539202D372056202D343620313620562035392031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343936332032303437204D0A2D343620323720560A2D3539202D313820560A3436202D313620560A3539203720560A2E31363837206720677361766520323934372031373031204E202D36302037372056202D3436202D332056203630202D37382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323934372031373031204D0A2D3436202D3420560A2D363020373820560A3436203320560A3630202D373720560A2E31303237206720677361766520333839372031363035204E202D36302032322056202D3436202D36312056203630202D31372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333839372031363035204D0A2D3436202D353620560A2D363020313720560A343620363120560A3630202D323220560A2E34393638206720677361766520333237302032383236204E202D3630202D3233372056202D3436202D39302056203630203231372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333237302032383236204D0A2D3436202D31313020560A2D3630202D32313720560A343620393020560A36302032333720560A2E32363936206720677361766520343739382032303334204E202D3630202D32362056202D3436202D333020562036302033362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343739382032303334204D0A2D3436202D323020560A2D3630202D333620560A343620333020560A363020323620560A2E30393731206720677361766520333632362031353732204E202D35392034302056202D3436202D34382056203630202D33332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333632362031353732204D0A2D3435202D343120560A2D363020333320560A343620343820560A3539202D343020560A2E31323732206720677361766520333230342031363134204E202D36302036362056202D3435202D32342056203539202D36342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333230342031363134204D0A2D3436202D323220560A2D353920363420560A343520323420560A3630202D363620560A2E32353039206720677361766520333639352032313538204E202D3539202D3132322056202D3435203139362056203539203135302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333639352032313538204D0A2D34352032323420560A2D3539202D31353020560A3435202D31393620560A35392031323220560A2E32373732206720677361766520323332372032303437204E202D3630202D32352056202D343620313320562036302033302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323332372032303437204D0A2D343620313820560A2D3630202D333020560A3436202D313320560A363020323520560A2E31343735206720677361766520343232382031373238204E202D3630202D352056202D3436202D3735205620363020342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343232382031373238204D0A2D3436202D373620560A2D3630202D3420560A343620373520560A3630203520560A2E33393831206720677361766520333939342032333136204E202D35392034332056202D3436203235372056203539202D35372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333939342032333136204D0A2D34362032343320560A2D353920353720560A3436202D32353720560A3539202D343320560A2E34303937206720677361766520333330322032363437204E202D3630202D3235372056202D3436202D322056203630203235332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333330322032363437204D0A2D3436202D3620560A2D3630202D32353320560A3436203220560A36302032353720560A2E32363936206720677361766520323533382031393632204E202D36302033392056202D34352032312056203539202D33362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323533382031393632204D0A2D343620323420560A2D353920333620560A3435202D323120560A3630202D333920560A2E313935206720677361766520343435332031383530204E202D3630202D32322056202D3436202D373320562036302032342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343435332031383530204D0A2D3436202D373120560A2D3630202D323420560A343620373320560A363020323220560A2E32373035206720677361766520353030392031393939204E202D363020322056202D3435203339205620353920372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353030392031393939204D0A2D343620343820560A2D3539202D3720560A3435202D333920560A3630202D3220560A2E323632206720677361766520343733382032303038204E202D3630202D32372056202D3436202D333920562036302033362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343733382032303038204D0A2D3436202D333020560A2D3630202D333620560A343620333920560A363020323720560A2E37393738206720677361766520333538322033313238204E202D35392038302056202D3436202D3139332056203630202D36392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333538322033313238204D0A2D3435202D31383220560A2D363020363920560A34362031393320560A3539202D383020560A2E353532206720677361766520343032322032353339204E202D3630203134372056202D3436203230322056203630202D3137302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343032322032353339204D0A2D34362031373920560A2D36302031373020560A3436202D32303220560A3630202D31343720560A2E32383335206720677361766520323433332032303232204E202D363020372056202D34362031382056203630202D332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323433332032303232204D0A2D343620323220560A2D3630203320560A3436202D313820560A3630202D3720560A2E33313339206720677361766520333433392032333930204E202D3630202D3231392056202D3435203130362056203539203233392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333433392032333930204D0A2D34362031323620560A2D3539202D32333920560A3435202D31303620560A36302032313920560A2E32363739206720677361766520333539312032323332204E202D3630202D3136322056202D3436203136362056203630203139322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333539312032323332204D0A2D34362031393620560A2D3630202D31393220560A3436202D31363620560A36302031363220560A2E31303834206720677361766520333733322031353932204E202D36302033352056202D3436202D35352056203630202D33302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333733322031353932204D0A2D3436202D353020560A2D363020333020560A343620353520560A3630202D333520560A2E31353239206720677361766520333039392031363536204E202D36302037332056202D3436202D31372056203630202D37332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333039392031363536204D0A2D3436202D313720560A2D363020373320560A343620313720560A3630202D373320560A2E32383339206720677361766520343930342032303430204E202D3630202D31322056202D3436203620562036302032322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343930342032303430204D0A2D343620313620560A2D3630202D323220560A3436202D3620560A363020313220560A2E32333933206720677361766520323639302031383634204E202D36302036322056202D34362031362056203630202D36332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323639302031383634204D0A2D343620313520560A2D363020363320560A3436202D313620560A3630202D363220560A2E32343734206720677361766520353035352031393336204E202D363020372056202D34362035382056203630202D322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320353035352031393336204D0A2D343620363320560A2D3630203220560A3436202D353820560A3630202D3720560A2E323037206720677361766520323834312031373735204E202D35392037332056202D343620362056203539202D37362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323834312031373735204D0A2D3436203320560A2D353920373620560A3436202D3620560A3539202D373320560A2E33363439206720677361766520333339332032353136204E202D3539202D3233392056202D34362037352056203539203235332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333339332032353136204D0A2D343620383920560A2D3539202D32353320560A3436202D373520560A35392032333920560A2E33393831206720677361766520333334372032363035204E202D3539202D3235332056202D34362033382056203630203235372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333334372032363035204D0A2D343520343220560A2D3630202D32353720560A3436202D333820560A35392032353320560A2E37393738206720677361766520333739332033303032204E202D3630203139372056202D3436202D37352056203630202D3138372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333739332033303032204D0A2D3436202D363520560A2D36302031383720560A343620373520560A3630202D31393720560A2E32353434206720677361766520343637382031393831204E202D3539202D32372056202D3436202D343620562035392033342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343637382031393831204D0A2D3436202D333920560A2D3539202D333420560A343620343620560A353920323720560A2E31333238206720677361766520343030332031363539204E202D36302031352056202D3436202D36392056203630202D31342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343030332031363539204D0A2D3436202D363820560A2D363020313420560A343620363920560A3630202D313520560A2E36353837206720677361766520333334332033303732204E202D3539202D3135392056202D3436202D3136352056203539203134322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333334332033303732204D0A2D3436202D31383220560A2D3539202D31343220560A34362031363520560A35392031353920560A2E31393334206720677361766520343339332031383238204E202D3539202D31362056202D3436202D373420562035392031372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343339332031383238204D0A2D3436202D373320560A2D3539202D313720560A343620373420560A353920313620560A2E32373839206720677361766520323337332032303239204E202D3630202D32322056202D343620313520562036302032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323337332032303239204D0A2D343620313820560A2D3630202D323520560A3436202D313520560A363020323220560A2E33313339206720677361766520333735352032323630204E202D3630202D3130322056202D3435203232342056203539203132322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333735352032323630204D0A2D34362032343420560A2D3539202D31323220560A3435202D32323420560A36302031303220560A2E31353635206720677361766520343136382031373233204E202D363020322056202D3436202D37352056203630202D322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343136382031373233204D0A2D3436202D373520560A2D3630203220560A343620373520560A3630202D3220560A2E34393638206720677361766520343030382032343635204E202D36302039342056202D3435203234322056203539202D3131352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343030382032343635204D0A2D34362032323120560A2D35392031313520560A3435202D32343220560A3630202D393420560A2E323639206720677361766520323538342031393432204E202D36302033392056202D34362032302056203630202D33392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323538342031393432204D0A2D343620323020560A2D363020333920560A3436202D323020560A3630202D333920560A2E31383338206720677361766520323939332031373132204E202D36302037342056202D3436202D382056203630202D37372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323939332031373132204D0A2D3436202D313120560A2D363020373720560A3436203820560A3630202D373420560A2E32383239206720677361766520343834342032303238204E202D3630202D31352056202D3436202D3520562036302032362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343834342032303238204D0A2D3436203620560A2D3630202D323620560A3436203520560A363020313520560A2E32373638206720677361766520343934392032303031204E202D3539202D332056202D343620333020562036302031322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343934392032303031204D0A2D343520333920560A2D3630202D313220560A3436202D333020560A3539203320560A2E31323732206720677361766520333833372031363237204E202D36302032382056202D3435202D36332056203539202D32362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333833372031363237204D0A2D3436202D363120560A2D353920323620560A343520363320560A3630202D323820560A2E34303937206720677361766520333933352032333539204E202D363020362056202D3436203236312056203630202D31302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333933352032333539204D0A2D34362032353720560A2D363020313020560A3436202D32363120560A3630202D3620560A2E32343737206720677361766520343631392031393534204E202D3630202D32352056202D3436202D353220562036302033312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343631392031393534204D0A2D3436202D343620560A2D3630202D333120560A343620353220560A363020323520560A2E32383332206720677361766520323437382032303031204E202D353920392056202D34362031392056203630202D372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323437382032303031204D0A2D343520323120560A2D3630203720560A3436202D313920560A3539202D3920560A2E31333238206720677361766520333436312031363039204E202D35392035342056202D3436202D34332056203630202D35322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333436312031363039204D0A2D3435202D343120560A2D363020353220560A343620343320560A3539202D353420560A2E31343032206720677361766520333335362031363230204E202D36302036302056202D3436202D33362056203630202D36302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333335362031363230204D0A2D3436202D333620560A2D363020363020560A343620333620560A3630202D363020560A2E32343235206720677361766520323733362031383534204E202D36302036302056202D34362031322056203630202D36322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323733362031383534204D0A2D343620313020560A2D363020363220560A3436202D313220560A3630202D363020560A2E32353732206720677361766520343939352031393433204E202D353920332056202D3436203532205620353920332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343939352031393433204D0A2D343620353820560A2D3539202D3320560A3436202D353220560A3539202D3320560A2E33393831206720677361766520333837352032333635204E202D3630202D33342056202D34362032353720562036302033382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333837352032333635204D0A2D34362032363120560A2D3630202D333820560A3436202D32353720560A363020333420560A2E33363439206720677361766520333831352032333331204E202D3630202D37312056202D34362032343420562036302038342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333831352032333331204D0A2D34362032353720560A2D3630202D383420560A3436202D32343420560A363020373120560A2E38313635206720677361766520333532332033323038204E202D36302031382056202D3436202D3139362056203630202D31352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333532332033323038204D0A2D3436202D31393320560A2D363020313520560A34362031393620560A3630202D313820560A2E31353437206720677361766520333235302031363434204E202D36302036352056202D3436202D32392056203630202D36362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333235302031363434204D0A2D3436202D333020560A2D363020363620560A343620323920560A3630202D363520560A2E31333238206720677361766520333536372031363132204E202D36302034372056202D3436202D35302056203630202D34352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333536372031363132204D0A2D3436202D343820560A2D363020343520560A343620353020560A3630202D343720560A2E38333536206720677361766520333638372033313234204E202D3630203134352056202D3435202D3134312056203539202D3133322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333638372033313234204D0A2D3436202D31323820560A2D35392031333220560A34352031343120560A3630202D31343520560A2E313935206720677361766520343333342031383132204E202D3630202D31312056202D3436202D373320562036302031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343333342031383132204D0A2D3436202D373420560A2D3630202D313020560A343620373320560A363020313120560A2E37393738206720677361766520333436332033323236204E202D3630202D34362056202D3436202D31393320562036302034332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333436332033323236204D0A2D3436202D31393620560A2D3630202D343320560A34362031393320560A363020343620560A2E37343334206720677361766520333430332033313830204E202D3630202D3130382056202D3436202D31383220562036302039372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333430332033313830204D0A2D3436202D31393320560A2D3630202D393720560A34362031383220560A36302031303820560A2E32383035206720677361766520343738342032303133204E202D3630202D31382056202D3436202D313420562036302032372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343738342032303133204D0A2D3436202D3520560A2D3630202D323720560A343620313420560A363020313820560A2E32313639206720677361766520323838372031373738204E202D36302036392056202D343520312056203539202D37332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323838372031373738204D0A2D3436202D3320560A2D353920373320560A3435202D3120560A3630202D363920560A2E32343235206720677361766520343535392031393239204E202D3630202D32332056202D3436202D353620562036302032372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343535392031393239204D0A2D3436202D353220560A2D3630202D323720560A343620353620560A363020323320560A2E32373938206720677361766520323431392032303130204E202D3630202D32302056202D343620313720562036302032322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323431392032303130204D0A2D343620313920560A2D3630202D323220560A3436202D313720560A363020323020560A2E36353837206720677361766520333937362032373138204E202D3630203137302056202D3435203136332056203539202D3138362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333937362032373138204D0A2D34362031343720560A2D35392031383620560A3435202D31363320560A3630202D31373020560A2E32383038206720677361766520343839302031393938204E202D3630202D372056202D343620323220562036302031352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343839302031393938204D0A2D343620333020560A2D3630202D313520560A3436202D323220560A3630203720560A2E31373535206720677361766520333134342031363830204E202D35392036392056202D3436202D32302056203630202D37332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333134342031363830204D0A2D3435202D323420560A2D363020373320560A343620323020560A3539202D363920560A2E31343032206720677361766520333637322031363237204E202D36302034312056202D3435202D35362056203539202D34302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333637322031363237204D0A2D3436202D353520560A2D353920343020560A343520353620560A3630202D343120560A2E32363936206720677361766520323633302031393236204E202D36302033382056202D34362031372056203630202D33392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323633302031393236204D0A2D343620313620560A2D363020333920560A3436202D313720560A3630202D333820560A2E31363837206720677361766520343130382031373235204E202D363020372056202D3435202D37332056203539202D392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343130382031373235204D0A2D3436202D373520560A2D3539203920560A343520373320560A3630202D3720560A2E35333738206720677361766520333331352032383931204E202D3539202D3235302056202D3436202D35322056203630203233372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333331352032383931204D0A2D3435202D363520560A2D3630202D32333720560A343620353220560A35392032353020560A2E31353239206720677361766520333934332031363734204E202D36302032312056202D3436202D36382056203630202D32322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333934332031363734204D0A2D3436202D363920560A2D363020323220560A343620363820560A3630202D323120560A2E38313635206720677361766520333833392033303133204E202D3630203230302056202D3436202D31342056203630202D3139372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333833392033303133204D0A2D3436202D313120560A2D36302031393720560A343620313420560A3630202D32303020560A2E33353433206720677361766520333534352032343238204E202D3630202D3139322056202D3436203135342056203630203231372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333534352032343238204D0A2D34362031373920560A2D3630202D32313720560A3436202D31353420560A36302031393220560A2E32383331206720677361766520323532342031393831204E202D35392031312056202D34362031382056203539202D392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323532342031393831204D0A2D343620323020560A2D3539203920560A3436202D313820560A3539202D313120560A2E32373733206720677361766520343732342031393935204E202D3630202D32302056202D3435202D323120562035392032372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343732342031393935204D0A2D3436202D313420560A2D3539202D323720560A343520323120560A363020323020560A2E33353433206720677361766520333635302032333832204E202D3539202D3135302056202D3436203139362056203539203137352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333635302032333832204D0A2D34362032323120560A2D3539202D31373520560A3436202D31393620560A35392031353020560A2E32363438206720677361766520343933362031393436204E202D3630202D312056202D3436203436205620363020372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343933362031393436204D0A2D343620353220560A2D3630202D3720560A3436202D343620560A3630203120560A2E32333933206720677361766520343439392031393036204E202D3630202D32302056202D3436202D353820562036302032322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343439392031393036204D0A2D3436202D353620560A2D3630202D323220560A343620353820560A363020323020560A2E36323638206720677361766520333332392033303430204E202D3539202D3231342056202D3436202D3131302056203630203139372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333332392033303430204D0A2D3435202D31323720560A2D3630202D31393720560A34362031313020560A35392032313420560A2E31393936206720677361766520343237342031383031204E202D3630202D362056202D3436202D3732205620363020352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343237342031383031204D0A2D3436202D373320560A2D3630202D3520560A343620373220560A3630203620560A2E32303131206720677361766520333033392031373239204E202D36302036392056202D3436202D31322056203630202D37342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333033392031373239204D0A2D3436202D313720560A2D363020373420560A343620313220560A3630202D363920560A2E32343737206720677361766520323738322031383438204E202D36302035362056202D34362031302056203630202D36302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323738322031383438204D0A2D3436203620560A2D363020363020560A3436202D313020560A3630202D353620560A2E37343334206720677361766520333933302032383635204E202D3539203138362056202D3436203131322056203630202D3139372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333933302032383635204D0A2D34352031303120560A2D36302031393720560A3436202D31313220560A3539202D31383620560A2E37393738206720677361766520333838352032393636204E202D3630203139372056202D34362035302056203630202D3230302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333838352032393636204D0A2D343620343720560A2D36302032303020560A3436202D353020560A3630202D31393720560A2E31353437206720677361766520333737372031363535204E202D35392033332056202D3436202D36312056203630202D33352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333737372031363535204D0A2D3435202D363320560A2D363020333520560A343620363120560A3539202D333320560A2E323833206720677361766520343833302031393931204E202D3630202D31302056202D343620313420562036302031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343833302031393931204D0A2D343620323220560A2D3630202D313820560A3436202D313420560A363020313020560A2E3238206720677361766520323436352031393932204E202D3630202D31392056202D343620313720562036302032302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323436352031393932204D0A2D343620313820560A2D3630202D323020560A3436202D313720560A363020313920560A2E32373431206720677361766520343636342031393735204E202D3539202D31392056202D3436202D323720562036302032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343636342031393735204D0A2D3435202D323120560A2D3630202D323520560A343620323720560A353920313920560A2E32373134206720677361766520323637362031393134204E202D36302033352056202D34362031352056203630202D33382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323637362031393134204D0A2D343620313220560A2D363020333820560A3436202D313520560A3630202D333520560A2E32323836206720677361766520323933332031373836204E202D36302036332056202D3436202D322056203630202D36392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323933332031373836204D0A2D3436202D3820560A2D363020363920560A3436203220560A3630202D363320560A2E32333831206720677361766520343433392031383836204E202D3630202D31352056202D3435202D353920562035392031362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343433392031383836204D0A2D3436202D353820560A2D3539202D313620560A343520353920560A363020313520560A2E32383332206720677361766520323537302031393634204E202D36302031302056202D34352031382056203539202D31312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323537302031393634204D0A2D343620313720560A2D353920313120560A3435202D313820560A3630202D313020560A2E35333738206720677361766520333934382032353539204E202D35392035372056202D3436203235342056203630202D36392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333934382032353539204D0A2D34352032343220560A2D363020363920560A3436202D32353420560A3539202D353720560A2E31383338206720677361766520343034382031373332204E202D35392031322056202D3436202D37302056203630202D31352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343034382031373332204D0A2D3435202D373320560A2D363020313520560A343620373020560A3539202D313220560A2E31373338206720677361766520333430322031363633204E202D36302035372056202D3436202D34302056203630202D36302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333430322031363633204D0A2D3436202D343320560A2D363020363020560A343620343020560A3630202D353720560A2E32373035206720677361766520343837362031393435204E202D3630202D342056202D343620343020562036302031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343837362031393435204D0A2D343620343620560A2D3630202D313020560A3436202D343020560A3630203420560A2E31383338206720677361766520333239362031363830204E202D36302036312056202D3436202D33322056203630202D36352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333239362031363830204D0A2D3436202D333620560A2D363020363520560A343620333220560A3630202D363120560A2E31373034206720677361766520333530372031363539204E202D36302035312056202D3435202D34372056203539202D35342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333530372031363539204D0A2D3436202D353020560A2D353920353420560A343520343720560A3630202D353120560A2E323037206720677361766520343231342031373935204E202D3630202D322056202D3436202D36382056203630202D322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343231342031373935204D0A2D3436202D373220560A2D3630203220560A343620363820560A3630203220560A2E34333334206720677361766520333439392032363037204E202D3630202D3231372056202D3436203132362056203630203233382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333439392032363037204D0A2D34362031343720560A2D3630202D32333820560A3436202D31323620560A36302032313720560A2E32383338206720677361766520343737302031393831204E202D3630202D31332056202D3436203720562036302032302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343737302031393831204D0A2D343620313420560A2D3630202D323020560A3436202D3720560A363020313320560A2E31373535206720677361766520333838332031363935204E202D36302032352056202D3436202D36352056203630202D32382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333838332031363935204D0A2D3436202D363820560A2D363020323820560A343620363520560A3630202D323520560A2E353532206720677361766520333336312032393032204E202D3539202D3235352056202D3436202D362056203539203235302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333336312032393032204D0A2D3436202D313120560A2D3539202D32353020560A3436203620560A35392032353520560A2E36323638206720677361766520333936322032363836204E202D3539203131352056202D3436203231382056203539202D3133312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333936322032363836204D0A2D34362032303220560A2D35392031333120560A3436202D32313820560A3539202D31313520560A2E32373134206720677361766520343630352031393536204E202D3630202D31392056202D3436202D333120562036302032332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343630352031393536204D0A2D3436202D323720560A2D3630202D323320560A343620333120560A363020313920560A2E31393936206720677361766520333139302031373039204E202D36302036342056202D3435202D32342056203539202D36392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333139302031373039204D0A2D3436202D323920560A2D353920363920560A343520323420560A3630202D363420560A2E32353434206720677361766520323832372031383437204E202D35392035312056202D343620362056203630202D35362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323832372031383437204D0A2D3435203120560A2D363020353620560A3436202D3620560A3539202D353120560A2E31373338206720677361766520333631322031363638204E202D35392034342056202D3436202D35332056203630202D34372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333631322031363638204D0A2D3435202D353620560A2D363020343720560A343620353320560A3539202D343420560A2E32373938206720677361766520323531302031393734204E202D3539202D32302056202D343620313920562036302031392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323531302031393734204D0A2D343520313820560A2D3630202D313920560A3436202D313920560A353920323020560A2E32333933206720677361766520343337392031383731204E202D3539202D31322056202D3436202D353820562036302031312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343337392031383731204D0A2D3435202D353920560A2D3630202D313120560A343620353820560A353920313220560A2E34333334206720677361766520333730392032353034204E202D3539202D3132322056202D3436203232312056203539203134322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333730392032353034204D0A2D34362032343120560A2D3539202D31343220560A3436202D32323120560A35392031323220560A2E34393638206720677361766520333435332032373534204E202D3630202D3233382056202D34362038392056203630203235302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333435332032373534204D0A2D34362031303120560A2D3630202D32353020560A3436202D383920560A36302032333820560A2E35333738206720677361766520333430372032383535204E202D3630202D3235302056202D34352034322056203539203235352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333430372032383535204D0A2D343620343720560A2D3539202D32353520560A3435202D343220560A36302032353020560A2E32313936206720677361766520333038352031373439204E202D36302036322056202D3436202D31332056203630202D36392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333038352031373439204D0A2D3436202D323020560A2D363020363920560A343620313320560A3630202D363220560A2E32373431206720677361766520323732322031393034204E202D36302033322056202D34362031332056203630202D33352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323732322031393034204D0A2D343620313020560A2D363020333520560A3436202D313320560A3630202D333220560A2E38393438206720677361766520333632372033323639204E202D35382038372056202D3436202D3134382056203539202D38302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333632372033323639204D0A2D3435202D31343120560A2D353920383020560A34362031343820560A3538202D383720560A2E32383335206720677361766520323631362031393439204E202D363020372056202D34362031382056203630202D31302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323631362031393439204D0A2D343620313520560A2D363020313020560A3436202D313820560A3630202D3720560A2E32373435206720677361766520343831362031393431204E202D3630202D372056202D343620333420562036302031332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343831362031393431204D0A2D343620343020560A2D3630202D313320560A3436202D333420560A3630203720560A2E32383338206720677361766520343731302031393638204E202D3539202D31332056202D3436203120562035392031392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343731302031393638204D0A2D3436203720560A2D3539202D313920560A3436202D3120560A353920313320560A2E31383338206720677361766520333731382031363838204E202D36302033372056202D3436202D35372056203630202D34312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333731382031363838204D0A2D3436202D363120560A2D363020343120560A343620353720560A3630202D333720560A2E32363936206720677361766520343534352031393337204E202D3630202D31372056202D3436202D333420562036302032302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343534352031393337204D0A2D3436202D333120560A2D3630202D323020560A343620333420560A363020313720560A2E38393438206720677361766520333733332033313939204E202D3630203135332056202D3436202D38332056203630202D3134352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333733332033313939204D0A2D3436202D373520560A2D36302031343520560A343620383320560A3630202D31353320560A2E353532206720677361766520333838392032363136204E202D36302031302056202D3436203235392056203630202D31352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333838392032363136204D0A2D34362032353420560A2D363020313520560A3436202D32353920560A3630202D313020560A2E32343135206720677361766520323937392031373938204E202D36302035352056202D3436202D342056203630202D36332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323937392031373938204D0A2D3436202D313220560A2D363020363320560A3436203420560A3630202D353520560A2E32313639206720677361766520343135342031373933204E202D363020342056202D3436202D36352056203630202D372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343135342031373933204D0A2D3436202D363820560A2D3630203720560A343620363520560A3630202D3420560A2E32303131206720677361766520333938392031373434204E202D36302031362056202D3436202D36352056203630202D32312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333938392031373434204D0A2D3436202D373020560A2D363020323120560A343620363520560A3630202D313620560A2E37343334206720677361766520333338392033323133204E202D3630202D3137332056202D3435202D3132372056203539203135392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333338392033323133204D0A2D3436202D31343120560A2D3539202D31353920560A34352031323720560A36302031373320560A2E35333738206720677361766520333832392032363236204E202D3630202D33382056202D34362032353420562036302034332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333832392032363236204D0A2D34362032353920560A2D3630202D343320560A3436202D32353420560A363020333820560A2E34393638206720677361766520333736392032353838204E202D3630202D38342056202D34362032343120562036302039372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333736392032353838204D0A2D34362032353420560A2D3630202D393720560A3436202D32343120560A363020383420560A2E343538206720677361766520333630342032363033204E202D3539202D3137352056202D3436203137392056203630203139372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333630342032363033204D0A2D34352032303120560A2D3630202D31393720560A3436202D31373920560A35392031373520560A2E32373839206720677361766520323535362031393536204E202D3539202D32322056202D343620323020562035392032302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323535362031393536204D0A2D343620313820560A2D3539202D323020560A3436202D323020560A353920323220560A2E32343235206720677361766520343332302031383539204E202D3630202D392056202D3436202D3535205620363020362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343332302031383539204D0A2D3436202D353820560A2D3630202D3620560A343620353520560A3630203920560A2E323632206720677361766520323837332031383439204E202D35392034342056202D343620352056203539202D35312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323837332031383439204D0A2D3436202D3220560A2D353920353120560A3436202D3520560A3539202D343420560A2E32383335206720677361766520343635312031393535204E202D3630202D31352056202D3436202D3320562036302031392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343635312031393535204D0A2D3436203120560A2D3630202D313920560A3436203320560A363020313520560A2E31393936206720677361766520333832332031373230204E202D36302032372056202D3435202D35392056203539202D33332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333832332031373230204D0A2D3436202D363520560A2D353920333320560A343520353920560A3630202D323720560A2E32373732206720677361766520343735362031393334204E202D3630202D392056202D343520333020562035392031332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343735362031393334204D0A2D343620333420560A2D3539202D313320560A3435202D333020560A3630203920560A2E323639206720677361766520343438352031393230204E202D3630202D31352056202D3436202D333420562036302031352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343438352031393230204D0A2D3436202D333420560A2D3630202D313520560A343620333420560A363020313520560A2E363735206720677361766520333337352033313136204E202D3630202D3232352056202D3435202D36352056203539203231342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333337352033313136204D0A2D3436202D373620560A2D3539202D32313420560A343520363520560A36302032323520560A2E32383338206720677361766520323636322031393336204E202D363020332056202D34362031372056203630202D372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323636322031393336204D0A2D343620313320560A2D3630203720560A3436202D313720560A3630202D3320560A2E32373733206720677361766520323736382031383938204E202D36302032352056202D34362031332056203630202D33322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323736382031383938204D0A2D3436203620560A2D363020333220560A3436202D313320560A3630202D323520560A2E32313237206720677361766520333334322031373230204E202D36302035332056202D3436202D33322056203630202D36312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333334322031373230204D0A2D3436202D343020560A2D363020363120560A343620333220560A3630202D353320560A2E323037206720677361766520333434372031373130204E202D35392034392056202D3436202D33392056203630202D35372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333434372031373130204D0A2D3435202D343720560A2D363020353720560A343620333920560A3539202D343920560A2E32323335206720677361766520333233362031373431204E202D36302035352056202D3436202D32332056203630202D36342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333233362031373431204D0A2D3436202D333220560A2D363020363420560A343620323320560A3630202D353520560A2E37343334206720677361766520333931362032383838204E202D3539203133312056202D3436203137372056203630202D3134352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333931362032383838204D0A2D34352031363320560A2D36302031343520560A3436202D31373720560A3539202D31333120560A2E39313531206720677361766520333536392033333536204E202D36302032312056202D3436202D3135312056203630202D31382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333536392033333536204D0A2D3436202D31343820560A2D363020313820560A34362031353120560A3630202D323120560A2E323037206720677361766520333535332031373132204E202D36302034332056202D3436202D34352056203630202D35312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333535332031373132204D0A2D3436202D353320560A2D363020353120560A343620343520560A3630202D343320560A2E32333831206720677361766520333133302031373733204E202D35392035322056202D3436202D31342056203630202D36322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333133302031373733204D0A2D3435202D323420560A2D363020363220560A343620313420560A3539202D353220560A2E32323836206720677361766520343039342031373937204E202D353920362056202D3436202D35392056203539202D31322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343039342031373937204D0A2D3436202D363520560A2D353920313220560A343620353920560A3539202D3620560A2E38393438206720677361766520333530392033333737204E202D3630202D34392056202D3436202D31343820562036302034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333530392033333737204D0A2D3436202D31353120560A2D3630202D343620560A34362031343820560A363020343920560A2E38333536206720677361766520333434392033333238204E202D3630202D3131352056202D3436202D3134312056203630203130382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333434392033333238204D0A2D3436202D31343820560A2D3630202D31303820560A34362031343120560A36302031313520560A2E32373732206720677361766520323630322031393339204E202D3630202D32362056202D343520323120562035392032322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323630322031393339204D0A2D343620313720560A2D3539202D323220560A3435202D323120560A363020323620560A2E32343737206720677361766520343236302031383530204E202D3630202D352056202D3436202D3532205620363020322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343236302031383530204D0A2D3436202D353520560A2D3630202D3220560A343620353220560A3630203520560A2E32383332206720677361766520343539312031393430204E202D3630202D31342056202D3436202D3620562036302031372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343539312031393430204D0A2D3436202D3320560A2D3630202D313720560A3436203620560A363020313420560A2E32373839206720677361766520343639362031393235204E202D3539202D31312056202D343620323620562036302031352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343639362031393235204D0A2D343520333020560A2D3630202D313520560A3436202D323620560A353920313120560A2E32363936206720677361766520343432352031393035204E202D3630202D31322056202D3435202D333420562035392031322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343432352031393035204D0A2D3436202D333420560A2D3539202D313220560A343520333420560A363020313220560A2E32313936206720677361766520333932392031373630204E202D36302031382056202D3436202D35382056203630202D32352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333932392031373630204D0A2D3436202D363520560A2D363020323520560A343620353820560A3630202D313820560A2E32353434206720677361766520333032352031383131204E202D36302034362056202D3436202D342056203630202D35352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333032352031383131204D0A2D3436202D313320560A2D363020353520560A3436203420560A3630202D343620560A2E32313237206720677361766520333635382031373235204E202D35392033352056202D3436202D34382056203539202D34342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333635382031373235204D0A2D3436202D353720560A2D353920343420560A343620343820560A3539202D333520560A2E39313531206720677361766520333737392033323133204E202D3630203135362056202D3436202D31372056203630202D3135332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333737392033323133204D0A2D3436202D313420560A2D36302031353320560A343620313720560A3630202D31353620560A2E363735206720677361766520333930332032383031204E202D36302036392056202D3436203232392056203630202D38302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333930332032383031204D0A2D34362032313820560A2D363020383020560A3436202D32323920560A3630202D363920560A2E32383338206720677361766520323730382031393233204E202D3630202D332056202D34362031392056203630202D332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323730382031393233204D0A2D343620313320560A2D3630203320560A3436202D313920560A3630203320560A2E32363936206720677361766520323931392031383533204E202D36302033352056202D343520352056203539202D34342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323931392031383533204D0A2D3436202D3420560A2D353920343420560A3435202D3520560A3630202D333520560A2E32383035206720677361766520323831342031383933204E202D36302031382056202D34362031322056203630202D32352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323831342031383933204D0A2D3436203520560A2D363020323520560A3436202D313220560A3630202D313820560A2E38333536206720677361766520333837312033303531204E202D3630203134352056202D3436203132302056203630202D3135332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333837312033303531204D0A2D34362031313220560A2D36302031353320560A3436202D31323020560A3630202D31343520560A2E38393438206720677361766520333832352033313633204E202D3630203135332056202D34362035332056203630202D3135362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333832352033313633204D0A2D343620353020560A2D36302031353620560A3436202D353320560A3630202D31353320560A2E353532206720677361766520333535392032383034204E202D3630202D3139372056202D3436203134372056203630203231342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333535392032383034204D0A2D34362031363420560A2D3630202D32313420560A3436202D31343720560A36302031393720560A2E32383331206720677361766520343533312031393236204E202D3630202D31342056202D3436202D3720562036302031352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343533312031393236204D0A2D3436202D3620560A2D3630202D313520560A3436203720560A363020313420560A2E32323335206720677361766520333736332031373437204E202D35392032382056202D3436202D35302056203630202D33372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333736332031373437204D0A2D3435202D353920560A2D363020333720560A343620353020560A3539202D323820560A2E32373435206720677361766520323634382031393230204E202D3630202D32392056202D343620323220562036302032362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323634382031393230204D0A2D343620313920560A2D3630202D323620560A3436202D323220560A363020323920560A2E353532206720677361766520333636332032373435204E202D3539202D3134322056202D3435203230312056203539203136302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333636332032373435204D0A2D34352032313920560A2D3539202D31363020560A3435202D32303120560A35392031343220560A2E32373938206720677361766520343633372031393134204E202D3630202D31322056202D343620323420562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343633372031393134204D0A2D343620323620560A2D3630202D313420560A3436202D323420560A363020313220560A2E32353434206720677361766520343230302031383435204E202D3630202D322056202D3436202D34362056203630202D342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343230302031383435204D0A2D3436202D353220560A2D3630203420560A343620343620560A3630203220560A2E32373134206720677361766520343336352031383933204E202D3539202D31312056202D3436202D3332205620363020392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343336352031383933204D0A2D3435202D333420560A2D3630202D3920560A343620333220560A353920313120560A2E36393137206720677361766520333432312033313330204E202D3630202D3232382056202D3436202D31312056203630203232352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333432312033313330204D0A2D3436202D313420560A2D3630202D32323520560A343620313120560A36302032323820560A2E32343135206720677361766520343033352031383033204E202D363020382056202D3436202D35312056203630202D31362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343033352031383033204D0A2D3436202D353920560A2D363020313620560A343620353120560A3630202D3820560A2E39353639206720677361766520333637332033333532204E202D36302039332056202D3434202D38392056203538202D38372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333637332033333532204D0A2D3436202D383320560A2D353820383720560A343420383920560A3630202D393320560A2E32343537206720677361766520333238322031373733204E202D36302034332056202D3436202D32302056203630202D35352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333238322031373733204D0A2D3436202D333220560A2D363020353520560A343620323020560A3630202D343320560A2E323833206720677361766520323735342031393131204E202D3630202D31302056202D3436203139205620363020332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323735342031393131204D0A2D343620313220560A2D3630202D3320560A3436202D313920560A363020313020560A2E36323638206720677361766520333531332032393638204E202D3630202D3231342056202D3436203130312056203630203232352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333531332032393638204D0A2D34362031313220560A2D3630202D32323520560A3436202D31303120560A36302032313420560A2E363735206720677361766520333436372033303830204E202D3630202D3232352056202D34362034372056203630203232382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333436372033303830204D0A2D343620353020560A2D3630202D32323820560A3436202D343720560A36302032323520560A2E32333933206720677361766520333338382031373539204E202D36302034312056202D3436202D32372056203630202D35332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333338382031373539204D0A2D3436202D333920560A2D363020353320560A343620323720560A3630202D343120560A2E32353533206720677361766520333137362031373936204E202D35392034312056202D3436202D31322056203539202D35322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333137362031373936204D0A2D3436202D323320560A2D353920353220560A343620313220560A3539202D343120560A2E32333831206720677361766520333836392031373738204E202D36302031382056202D3436202D34392056203630202D32372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333836392031373738204D0A2D3436202D353820560A2D363020323720560A343620343920560A3630202D313820560A2E32363634206720677361766520333037312031383235204E202D36302033352056202D3436202D332056203630202D34362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333037312031383235204D0A2D3436202D313420560A2D363020343620560A3436203320560A3630202D333520560A2E323337206720677361766520333439332031373535204E202D35392033372056202D3436202D33332056203539202D34392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333439332031373535204D0A2D3436202D343520560A2D353920343920560A343620333320560A3539202D333720560A2E32383332206720677361766520343437312031393132204E202D3630202D31342056202D3436202D3520562036302031322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343437312031393132204D0A2D3436202D3720560A2D3630202D313220560A3436203520560A363020313420560A2E32383239206720677361766520323835392031383838204E202D353920392056202D34362031342056203630202D31382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323835392031383838204D0A2D3435203520560A2D363020313820560A3436202D313420560A3539202D3920560A2E32373635206720677361766520323936352031383537204E202D36302032342056202D343620372056203630202D33352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323936352031383537204D0A2D3436202D3420560A2D363020333520560A3436202D3720560A3630202D323420560A2E36393137206720677361766520333834332032383730204E202D36302031352056202D3436203233322056203630202D31382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333834332032383730204D0A2D34362032323920560A2D363020313820560A3436202D32333220560A3630202D313520560A2E37393738206720677361766520333433352033323936204E202D3630202D3138302056202D3436202D37362056203630203137332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333433352033323936204D0A2D3436202D383320560A2D3630202D31373320560A343620373620560A36302031383020560A2E3238206720677361766520343537372031393032204E202D3630202D31342056202D343620323420562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343537372031393032204D0A2D343620323420560A2D3630202D313420560A3436202D323420560A363020313420560A2E32373035206720677361766520323639342031393031204E202D3630202D33352056202D343620323520562036302032392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323639342031393031204D0A2D343620313920560A2D3630202D323920560A3436202D323520560A363020333520560A2E32373431206720677361766520343330362031383832204E202D3630202D392056202D3436202D3238205620363020352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343330362031383832204D0A2D3436202D333220560A2D3630202D3520560A343620323820560A3630203920560A2E363735206720677361766520333738332032383835204E202D3630202D34332056202D34362032323920562036302034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333738332032383835204D0A2D34362032333220560A2D3630202D343620560A3436202D32323920560A363020343320560A2E36323638206720677361766520333732332032383432204E202D3630202D39372056202D3435203231392056203539203130372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333732332032383432204D0A2D34362032323920560A2D3539202D31303720560A3435202D32313920560A363020393720560A2E32333933206720677361766520333539392031373630204E202D36302033322056202D3436202D33372056203630202D34332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333539392031373630204D0A2D3436202D343820560A2D363020343320560A343620333720560A3630202D333220560A2E323632206720677361766520343134302031383433204E202D3630202D312056202D3435202D33392056203539202D362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343134302031383433204D0A2D3436202D343620560A2D3539203620560A343520333920560A3630203120560A2E32353434206720677361766520333937352031383131204E202D363020382056202D3436202D34312056203630202D31382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333937352031383131204D0A2D3436202D353120560A2D363020313820560A343620343120560A3630202D3820560A2E32343537206720677361766520333730342031373735204E202D36302032342056202D3435202D33392056203539202D33352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333730342031373735204D0A2D3436202D353020560A2D353920333520560A343520333920560A3630202D323420560A2E32383038206720677361766520323830302031383937204E202D3630202D31382056202D343620323220562036302031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323830302031383937204D0A2D343620313420560A2D3630202D313020560A3436202D323220560A363020313820560A2E32383335206720677361766520343431312031383938204E202D3539202D31332056202D3436202D3320562035392031312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343431312031383938204D0A2D3436202D3520560A2D3539202D313120560A3436203320560A353920313320560A2E37393738206720677361766520333835372033303139204E202D36302038302056202D3436203138352056203630202D38382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333835372033303139204D0A2D34362031373720560A2D363020383820560A3436202D31383520560A3630202D383020560A2E32373938206720677361766520343531372031383838204E202D3630202D31342056202D343620323420562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343531372031383838204D0A2D343620323420560A2D3630202D313420560A3436202D323420560A363020313420560A2E32363438206720677361766520323734302031383739204E202D3630202D34312056202D343620323820562036302033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323734302031383739204D0A2D343620323220560A2D3630202D333520560A3436202D323820560A363020343120560A2E32383339206720677361766520323930352031383831204E202D3630202D312056202D34352031372056203539202D392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323930352031383831204D0A2D3436203720560A2D3539203920560A3435202D313720560A3630203120560A2E32373733206720677361766520343234362031383733204E202D3630202D392056202D3436202D3231205620363020322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343234362031383733204D0A2D3436202D323820560A2D3630202D3220560A343620323120560A3630203920560A2E39373833206720677361766520333631332033343435204E202D35382032332056202D3436202D39312056203630202D32312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333631332033343435204D0A2D3434202D383920560A2D363020323120560A343620393120560A3538202D323320560A2E32383135206720677361766520333031312031383630204E202D36302031322056202D343620392056203630202D32342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333031312031383630204D0A2D3436202D3320560A2D363020323420560A3436202D3920560A3630202D313220560A2E36353837206720677361766520333631382032393634204E202D3539202D3136302056202D3436203136342056203630203137322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333631382032393634204D0A2D34352031373620560A2D3630202D31373220560A3436202D31363420560A35392031363020560A2E32353533206720677361766520333830392031373936204E202D35392031352056202D3436202D33362056203539202D32382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333830392031373936204D0A2D3436202D343920560A2D353920323820560A343620333620560A3539202D313520560A2E323736206720677361766520333131372031383337204E202D36302032312056202D343620322056203630202D33352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333131372031383337204D0A2D3436202D313220560A2D363020333520560A3436202D3220560A3630202D323120560A2E39353639206720677361766520333535352033343638204E202D3630202D35312056202D3436202D383920562036302034392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333535352033343638204D0A2D3436202D393120560A2D3630202D343920560A343620383920560A363020353120560A2E38393438206720677361766520333439352033343137204E202D3630202D3132312056202D3436202D38332056203630203131352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333439352033343137204D0A2D3436202D383920560A2D3630202D31313520560A343620383320560A36302031323120560A2E32363936206720677361766520333232322031383136204E202D36302032372056202D3435202D362056203539202D34312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333232322031383136204D0A2D3436202D323020560A2D353920343120560A3435203620560A3630202D323720560A2E32363432206720677361766520333332382031383030204E202D36302032392056202D3436202D31332056203630202D34332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333332382031383030204D0A2D3436202D323720560A2D363020343320560A343620313320560A3630202D323920560A2E32363936206720677361766520343038302031383432204E202D3539202D312056202D3436202D33302056203630202D382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343038302031383432204D0A2D3435202D333920560A2D3630203820560A343620333020560A3539203120560A2E39373833206720677361766520333731392033333639204E202D36302039352056202D3436202D31392056203630202D39332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333731392033333639204D0A2D3436202D313720560A2D363020393320560A343620313920560A3630202D393520560A2E32363132206720677361766520333433342031373932204E202D36302032382056202D3436202D32302056203630202D34312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333433342031373932204D0A2D3436202D333320560A2D363020343120560A343620323020560A3630202D323820560A2E32383338206720677361766520343335322031383835204E202D3630202D31342056202D34362032205620363020392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343335322031383835204D0A2D3436202D3320560A2D3630202D3920560A3436202D3220560A363020313420560A2E32373638206720677361766520323834352031383830204E202D3539202D32362056202D343620323520562036302031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323834352031383830204D0A2D343520313720560A2D3630202D313820560A3436202D323520560A353920323620560A2E32373839206720677361766520343435372031383734204E202D3630202D31362056202D343520323720562035392031332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343435372031383734204D0A2D343620323420560A2D3539202D313320560A3435202D323720560A363020313620560A2E32363132206720677361766520333533392031373932204E202D36302032342056202D3435202D32342056203539202D33372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333533392031373932204D0A2D3436202D333720560A2D353920333720560A343520323420560A3630202D323420560A2E32353732206720677361766520323738362031383534204E202D3630202D34372056202D343620333120562036302034312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323738362031383534204D0A2D343620323520560A2D3630202D343120560A3436202D333120560A363020343720560A2E38313635206720677361766520333438312033333133204E202D3630202D3138332056202D3436202D31342056203630203138302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333438312033333133204D0A2D3436202D313720560A2D3630202D31383020560A343620313420560A36302031383320560A2E38393438206720677361766520333831312033313936204E202D36302038382056202D3436203132352056203630202D39332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333831312033313936204D0A2D34362031323020560A2D363020393320560A3436202D31323520560A3630202D383820560A2E39353639206720677361766520333736352033333136204E202D36302039332056202D34362035352056203630202D39352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333736352033333136204D0A2D343620353320560A2D363020393520560A3436202D353520560A3630202D393320560A2E32363634206720677361766520333931352031383139204E202D363020372056202D3436202D33302056203630202D31382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333931352031383139204D0A2D3436202D343120560A2D363020313820560A343620333020560A3630202D3720560A2E32383035206720677361766520343138362031383634204E202D3630202D382056202D3436202D3134205620363020312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343138362031383634204D0A2D3436202D323120560A2D3630202D3120560A343620313420560A3630203820560A2E32383237206720677361766520323935312031383732204E202D3630202D31322056202D3436203230205620363020312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323935312031383732204D0A2D3436203920560A2D3630202D3120560A3436202D323020560A363020313220560A2E32363432206720677361766520333634342031373939204E202D35392031382056202D3436202D32352056203630202D33322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333634342031373939204D0A2D3435202D333920560A2D363020333220560A343620323520560A3539202D313820560A2E37343334206720677361766520333537332033313430204E202D3630202D3137322056202D3436203131322056203630203138302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333537332033313430204D0A2D34362031323020560A2D3630202D31383020560A3436202D31313220560A36302031373220560A2E37393738206720677361766520333532372033323630204E202D3630202D3138302056202D34362035302056203630203138332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333532372033323630204D0A2D343620353320560A2D3630202D31383320560A3436202D353020560A36302031383020560A2E38313635206720677361766520333739372033303939204E202D36302031382056202D3436203138382056203630202D32312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333739372033303939204D0A2D34362031383520560A2D363020323120560A3436202D31383820560A3630202D313820560A2E32383338206720677361766520333035372031383538204E202D363020302056202D34362031342056203630202D31322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333035372031383538204D0A2D3436203220560A2D363020313220560A3436202D313420560A3630203020560A2E32383338206720677361766520343239322031383731204E202D3630202D31342056202D34362037205620363020392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343239322031383731204D0A2D3436203220560A2D3630202D3920560A3436202D3720560A363020313420560A2E32373732206720677361766520343339372031383538204E202D3539202D31362056202D343620323920562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343339372031383538204D0A2D343520323720560A2D3630202D313420560A3436202D323920560A353920313620560A2E37393738206720677361766520333733372033313137204E202D3630202D34362056202D34362031383520562036302034392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333733372033313137204D0A2D34362031383820560A2D3630202D343920560A3436202D31383520560A363020343620560A2E37343334206720677361766520333637372033303731204E202D3539202D3130372056202D3435203137362056203538203131362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333637372033303731204D0A2D34362031383520560A2D3538202D31313620560A3435202D31373620560A35392031303720560A2E32373635206720677361766520343032312031383431204E202D3630202D322056202D3436202D32302056203630202D382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343032312031383431204D0A2D3436202D333020560A2D3630203820560A343620323020560A3630203220560A2E32373035206720677361766520323839312031383630204E202D3539202D33352056202D343620323920562035392032362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323839312031383630204D0A2D343620323020560A2D3539202D323620560A3436202D323920560A353920333520560A2E32343734206720677361766520323833322031383235204E202D3630202D35332056202D343620333520562036302034372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323833322031383235204D0A2D343620323920560A2D3630202D343720560A3436202D333520560A363020353320560A2E32363936206720677361766520333735302031383131204E202D36302031312056202D3436202D32332056203630202D32342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333735302031383131204D0A2D3436202D333620560A2D363020323420560A343620323320560A3630202D313120560A2E32383232206720677361766520333136322031383433204E202D353920382056202D343620372056203630202D32312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333136322031383433204D0A2D3435202D3620560A2D363020323120560A3436202D3720560A3539202D3820560A2E32373935206720677361766520333236382031383239204E202D36302031332056202D343620312056203630202D32372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333236382031383239204D0A2D3436202D313320560A2D363020323720560A3436202D3120560A3630202D313320560A2E32373733206720677361766520333337342031383230204E202D36302031342056202D3436202D352056203630202D32392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333337342031383230204D0A2D3436202D323020560A2D363020323920560A3436203520560A3630202D313420560A2E32383239206720677361766520343132362031383536204E202D3539202D31302056202D3436202D35205620353920312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343132362031383536204D0A2D3436202D313420560A2D3539202D3120560A3436203520560A353920313020560A2E32373835206720677361766520323939372031383538204E202D3630202D32332056202D343620323520562036302031322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323939372031383538204D0A2D343620313420560A2D3630202D313220560A3436202D323520560A363020323320560A31206720677361766520333635392033343634204E202D35392032332056202D3435202D31392056203538202D32332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333635392033343634204D0A2D3436202D313920560A2D353820323320560A343520313920560A3539202D323320560A2E323736206720677361766520333835352031383236204E202D363020332056202D3435202D31382056203539202D31352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333835352031383236204D0A2D3436202D333020560A2D353920313520560A343520313820560A3630202D3320560A2E39373833206720677361766520333630302033343837204E202D3539202D35312056202D3436202D313920562036302035312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333630302033343837204D0A2D3435202D313920560A2D3630202D353120560A343620313920560A353920353120560A2E39313531206720677361766520333534312033343336204E202D3630202D3132332056202D3436202D31372056203630203132312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333534312033343336204D0A2D3436202D313920560A2D3630202D31323120560A343620313720560A36302031323320560A2E32373635206720677361766520333437392031383136204E202D35392031322056202D3436202D382056203630202D32382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333437392031383136204D0A2D3435202D323420560A2D363020323820560A3436203820560A3539202D313220560A2E32373435206720677361766520343333382031383432204E202D3630202D31392056202D343620333420562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343333382031383432204D0A2D343620323920560A2D3630202D313420560A3436202D333420560A363020313920560A2E323833206720677361766520343233322031383537204E202D3630202D31352056202D3436203134205620363020382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343233322031383537204D0A2D3436203720560A2D3630202D3820560A3436202D313420560A363020313520560A2E32363134206720677361766520323933372031383335204E202D3630202D34342056202D343520333420562035392033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323933372031383335204D0A2D343620323520560A2D3539202D333520560A3435202D333420560A363020343420560A2E32333533206720677361766520323837372031373931204E202D3539202D35382056202D343620333920562036302035332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323837372031373931204D0A2D343520333420560A2D3630202D353320560A3436202D333920560A353920353820560A2E39313531206720677361766520333735312033323834204E202D36302032312056202D3436203132372056203630202D32332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333735312033323834204D0A2D34362031323520560A2D363020323320560A3436202D31323720560A3630202D323120560A2E39373833206720677361766520333730352033343039204E202D36302032332056202D34352035352056203539202D32332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333730352033343039204D0A2D343620353520560A2D353920323320560A3435202D353520560A3630202D323320560A2E32373733206720677361766520333538352031383137204E202D363020382056202D3436202D392056203630202D32342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333538352031383137204D0A2D3436202D323520560A2D363020323420560A3436203920560A3630202D3820560A2E32383235206720677361766520333130332031383531204E202D3630202D31342056202D3436203231205620363020302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333130332031383531204D0A2D3436203720560A2D3630203020560A3436202D323120560A363020313420560A2E38393438206720677361766520333639312033333035204E202D3630202D34392056202D34342031323520562035382035312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333639312033333035204D0A2D34362031323720560A2D3538202D353120560A3434202D31323520560A363020343920560A2E39353639206720677361766520333634352033343332204E202D3538202D35312056202D343620353520562035392035312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333634352033343332204D0A2D343520353520560A2D3539202D353120560A3436202D353520560A353820353120560A2E38333536206720677361766520333633312033323536204E202D3538202D3131362056202D3436203132302056203630203132312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333633312033323536204D0A2D34342031323520560A2D3630202D31323120560A3436202D31323020560A35382031313620560A2E38393438206720677361766520333538372033333831204E202D3630202D3132312056202D34362035332056203630203132332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333538372033333831204D0A2D343620353520560A2D3630202D31323320560A3436202D353320560A36302031323120560A2E32383135206720677361766520333936312031383339204E202D3630202D352056202D3436202D382056203630202D372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333936312031383339204D0A2D3436202D323020560A2D3630203720560A3436203820560A3630203520560A2E32383338206720677361766520333230382031383432204E202D3539202D372056202D34362031362056203539202D382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333230382031383432204D0A2D3436203120560A2D3539203820560A3436202D313620560A3539203720560A2E32373935206720677361766520333639302031383232204E202D363020332056202D3435202D382056203539202D31382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333639302031383232204D0A2D3436202D323320560A2D353920313820560A3435203820560A3630202D3320560A2E32383339206720677361766520343036372031383436204E202D3630202D31322056202D34362035205620363020322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343036372031383436204D0A2D3436202D3520560A2D3630202D3220560A3436202D3520560A363020313220560A2E323731206720677361766520333034332031383337204E202D3630202D33332056202D343620333120562036302032332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333034332031383337204D0A2D343620323120560A2D3630202D323320560A3436202D333120560A363020333320560A2E32373035206720677361766520343237382031383233204E202D3630202D32312056202D343620343020562036302031352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343237382031383233204D0A2D343620333420560A2D3630202D313520560A3436202D343020560A363020323120560A2E32343934206720677361766520323938332031383034204E202D3630202D35312056202D343620333820562036302034342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323938332031383034204D0A2D343620333120560A2D3630202D343420560A3436202D333820560A363020353120560A2E32323039206720677361766520323932332031373533204E202D3539202D36332056202D343620343320562035392035382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323932332031373533204D0A2D343620333820560A2D3539202D353820560A3436202D343320560A353920363320560A2E32383038206720677361766520343137322031383432204E202D3630202D31382056202D343520323220562035392031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343137322031383432204D0A2D343620313420560A2D3539202D313020560A3435202D323220560A363020313820560A2E32383338206720677361766520333331342031383334204E202D3630202D332056202D34362031312056203630202D31332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333331342031383334204D0A2D3436202D3520560A2D363020313320560A3436202D313120560A3630203320560A2E32383232206720677361766520333739352031383239204E202D3539202D342056202D3436202D332056203630202D31312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333739352031383239204D0A2D3435202D313820560A2D363020313120560A3436203320560A3539203420560A2E32383335206720677361766520333432302031383238204E202D3630202D322056202D343620382056203630202D31342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333432302031383238204D0A2D3436202D3820560A2D363020313420560A3436202D3820560A3630203220560A2E32373638206720677361766520333134392031383335204E202D3630202D32362056202D343620323820562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333134392031383335204D0A2D343620313620560A2D3630202D313420560A3436202D323820560A363020323620560A2E32383338206720677361766520333930312031383334204E202D3630202D31302056202D343620352056203630202D332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333930312031383334204D0A2D3436202D3820560A2D3630203320560A3436202D3520560A363020313020560A2E32383335206720677361766520333532352031383235204E202D3539202D332056202D343620362056203539202D31322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333532352031383235204D0A2D3436202D3920560A2D353920313220560A3436202D3620560A3539203320560A2E32363438206720677361766520343231382031383032204E202D3630202D32332056202D343620343520562036302031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343231382031383032204D0A2D343620343020560A2D3630202D313820560A3436202D343520560A363020323320560A2E32303436206720677361766520323936392031373039204E202D3630202D36352056202D343520343620562035392036332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320323936392031373039204D0A2D343620343420560A2D3539202D363320560A3435202D343620560A363020363520560A2E32353937206720677361766520333038392031383039204E202D3630202D34332056202D343620333820562036302033332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333038392031383039204D0A2D343620323820560A2D3630202D333320560A3436202D333820560A363020343320560A2E32333435206720677361766520333032392031373636204E202D3630202D35372056202D343620343420562036302035312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333032392031373636204D0A2D343620333820560A2D3630202D353120560A3436202D343420560A363020353720560A2E32383237206720677361766520343030372031383334204E202D3630202D31362056202D3436203136205620363020352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343030372031383334204D0A2D3436203520560A2D3630202D3520560A3436202D313620560A363020313620560A2E32373638206720677361766520343131322031383234204E202D3539202D32302056202D343620333020562036302031322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343131322031383234204D0A2D343520323220560A2D3630202D313220560A3436202D333020560A353920323020560A2E3238206720677361766520333235342031383331204E202D3630202D32302056202D3435203234205620353920372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333235342031383331204D0A2D343620313120560A2D3539202D3720560A3435202D323420560A363020323020560A2E32383338206720677361766520333633302031383235204E202D3539202D362056202D343620362056203630202D382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333633302031383235204D0A2D3435202D3820560A2D3630203820560A3436202D3620560A3539203620560A2E32383135206720677361766520333336302031383236204E202D3630202D31372056202D3436203232205620363020332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333336302031383236204D0A2D3436203820560A2D3630202D3320560A3436202D323220560A363020313720560A2E32383338206720677361766520333733362031383235204E202D3630202D31312056202D34362031312056203630202D332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333733362031383235204D0A2D3436202D3320560A2D3630203320560A3436202D313120560A363020313120560A2E31383638206720677361766520333031352031363631204E202D3630202D36362056202D343620343920562036302036352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333031352031363631204D0A2D343620343820560A2D3630202D363520560A3436202D343920560A363020363620560A2E32363635206720677361766520333139342031383131204E202D3539202D33372056202D343620333520562036302032362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333139342031383131204D0A2D343520323420560A2D3630202D323620560A3436202D333520560A353920333720560A2E32353732206720677361766520343135382031373739204E202D3539202D32372056202D343620353220562035392032302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343135382031373739204D0A2D343620343520560A2D3539202D323020560A3436202D353220560A353920323720560A2E32343436206720677361766520333133352031373734204E202D3630202D35322056202D343620343420562036302034332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333133352031373734204D0A2D343620333520560A2D3630202D343320560A3436202D343420560A363020353220560A2E323137206720677361766520333037352031373232204E202D3630202D36312056202D343620343820562036302035372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333037352031373232204D0A2D343620343420560A2D3630202D353720560A3436202D343820560A363020363120560A2E32383235206720677361766520333834312031383234204E202D3539202D31362056202D3436203137205620353920342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333834312031383234204D0A2D3436203520560A2D3539202D3420560A3436202D313720560A353920313620560A2E32383139206720677361766520333436362031383232204E202D3630202D31362056202D3436203230205620363020322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333436362031383232204D0A2D3436203620560A2D3630202D3220560A3436202D323020560A363020313620560A2E32373035206720677361766520343035332031383034204E202D3630202D32352056202D343620333920562036302031362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343035332031383034204D0A2D343620333020560A2D3630202D313620560A3436202D333920560A363020323520560A2E32373835206720677361766520333934372031383138204E202D3630202D32312056202D343620323720562036302031302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333934372031383138204D0A2D343620313620560A2D3630202D313020560A3436202D323720560A363020323120560A2E31363834206720677361766520333036312031363039204E202D3630202D36342056202D343620353020562036302036362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333036312031363039204D0A2D343620353220560A2D3630202D363620560A3436202D353020560A363020363420560A2E32373035206720677361766520333330302031383039204E202D3630202D33332056202D343620333520562036302032302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333330302031383039204D0A2D343620323220560A2D3630202D323020560A3436202D333520560A363020333320560A2E32383135206720677361766520333537312031383139204E202D3630202D31382056202D3435203231205620353920332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333537312031383139204D0A2D3436203620560A2D3539202D3320560A3435202D323120560A363020313820560A2E32343734206720677361766520343039392031373532204E202D3630202D33312056202D343620353820562036302032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343039392031373532204D0A2D343620353220560A2D3630202D323520560A3436202D353820560A363020333120560A2E31393736206720677361766520333132312031363732204E202D3630202D36332056202D343620353220562036302036312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333132312031363732204D0A2D343620353020560A2D3630202D363120560A3436202D353220560A363020363320560A2E32353134206720677361766520333234302031373736204E202D3539202D34362056202D343620343420562035392033372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333234302031373736204D0A2D343620333520560A2D3539202D333720560A3436202D343420560A353920343620560A2E32323633206720677361766520333138312031373330204E202D3630202D35382056202D343620353020562036302035322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333138312031373330204D0A2D343620343420560A2D3630202D353220560A3436202D353020560A363020353820560A2E3238206720677361766520333637362031383134204E202D3630202D32302056202D3435203235205620353920362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333637362031383134204D0A2D343620313120560A2D3539202D3620560A3435202D323520560A363020323020560A2E32373233206720677361766520333430362031383036204E202D3630202D33312056202D343620333420562036302031372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333430362031383036204D0A2D343620323020560A2D3630202D313720560A3436202D333420560A363020333120560A2E32363134206720677361766520333939332031373739204E202D3630202D33302056202D343620343820562036302032312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333939332031373739204D0A2D343620333920560A2D3630202D323120560A3436202D343820560A363020333020560A2E31353033206720677361766520333130372031353536204E202D3630202D36302056202D343620343920562036302036342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333130372031353536204D0A2D343620353320560A2D3630202D363420560A3436202D343920560A363020363020560A2E32373638206720677361766520333738322031383038204E202D3630202D32342056202D343620333020562036302031312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333738322031383038204D0A2D343620313720560A2D3630202D313120560A3436202D333020560A363020323420560A2E323731206720677361766520333838372031373937204E202D3630202D32372056202D343520333820562035392031362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333838372031373937204D0A2D343620323720560A2D3539202D313620560A3435202D333820560A363020323720560A2E31373731206720677361766520333136372031363138204E202D3630202D36322056202D343620353320562036302036332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333136372031363138204D0A2D343620353420560A2D3630202D363320560A3436202D353320560A363020363220560A2E32333533206720677361766520343033392031373231204E202D3630202D33352056202D343620363320562036302033302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320343033392031373231204D0A2D343620353820560A2D3630202D333020560A3436202D363320560A363020333520560A2E32353533206720677361766520333334362031373735204E202D3630202D34332056202D343620343420562036302033332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333334362031373735204D0A2D343620333420560A2D3630202D333320560A3436202D343420560A363020343320560A2E32373233206720677361766520333531312031383031204E202D3539202D33302056202D343620333520562036302031362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333531312031383031204D0A2D343520323120560A2D3630202D313620560A3436202D333520560A353920333020560A2E32333233206720677361766520333238362031373332204E202D3630202D35332056202D343520353120562035392034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333238362031373332204D0A2D343620343420560A2D3539202D343620560A3435202D353120560A363020353320560A2E32303533206720677361766520333232362031363739204E202D3539202D36312056202D343620353420562036302035382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333232362031363739204D0A2D343520353120560A2D3630202D353820560A3436202D353420560A353920363120560A2E32373035206720677361766520333631362031373934204E202D3539202D33302056202D343620333720562036302031382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333631362031373934204D0A2D343520323520560A2D3630202D313820560A3436202D333720560A353920333020560A2E32343934206720677361766520333933332031373439204E202D3630202D33342056202D343620353520562036302032372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333933332031373439204D0A2D343620343820560A2D3630202D323720560A3436202D353520560A363020333420560A2E31333337206720677361766520333135332031353033204E202D3630202D35342056202D343620343720562036302036302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333135332031353033204D0A2D343620353320560A2D3630202D363020560A3436202D343720560A363020353420560A2E31353638206720677361766520333231322031353632204E202D3539202D35392056202D343620353320562036302036322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333231322031353632204D0A2D343520353620560A2D3630202D363220560A3436202D353320560A353920353920560A2E32353636206720677361766520333435322031373731204E202D3630202D34312056202D343620343520562036302033312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333435322031373731204D0A2D343620333520560A2D3630202D333120560A3436202D343520560A363020343120560A2E32363635206720677361766520333732322031373834204E202D3630202D33322056202D343620343220562036302032302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333732322031373834204D0A2D343620333020560A2D3630202D323020560A3436202D343220560A363020333220560A2E32353937206720677361766520333832372031373730204E202D3539202D33332056202D343620343720562036302032342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333832372031373730204D0A2D343520333820560A2D3630202D323420560A3436202D343720560A353920333320560A2E32323039206720677361766520333937392031363836204E202D3630202D33382056202D343620363720562036302033342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333937392031363836204D0A2D343620363320560A2D3630202D333420560A3436202D363720560A363020333820560A2E313833206720677361766520333237322031363232204E202D3630202D36302056202D343520353620562035392036312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333237322031363232204D0A2D343620353720560A2D3539202D363120560A3435202D353620560A363020363020560A2E32333533206720677361766520333339322031373330204E202D3630202D35312056202D343620353320562036302034332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333339322031373330204D0A2D343620343520560A2D3630202D343320560A3436202D353320560A363020353120560A2E3231206720677361766520333333322031363739204E202D3630202D35372056202D343620353720562036302035332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333333322031363739204D0A2D343620353320560A2D3630202D353320560A3436202D353720560A363020353720560A2E32353533206720677361766520333535372031373634204E202D3539202D34302056202D343620343720562035392033302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333535372031373634204D0A2D343620333720560A2D3539202D333020560A3436202D343720560A353920343020560A2E32333435206720677361766520333837332031373135204E202D3630202D34302056202D343520363220562035392033332056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333837332031373135204D0A2D343620353520560A2D3539202D333320560A3435202D363220560A363020343020560A2E32303436206720677361766520333931392031363438204E202D3630202D34322056202D343620363920562036302034302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333931392031363438204D0A2D343620363720560A2D3630202D343020560A3436202D363920560A363020343220560A2E32353134206720677361766520333636322031373532204E202D3630202D33392056202D343520353120562035392033302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333636322031373532204D0A2D343620343220560A2D3539202D333020560A3435202D353120560A363020333920560A2E31363038206720677361766520333331382031353633204E202D3630202D35372056202D343620353620562036302036302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333331382031353633204D0A2D343620353920560A2D3630202D363020560A3436202D353620560A363020353720560A2E313338206720677361766520333235382031353036204E202D3539202D35342056202D343620353120562035392035392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333235382031353036204D0A2D343620353620560A2D3539202D353920560A3436202D353120560A353920353420560A2E32343436206720677361766520333736382031373337204E202D3630202D34302056202D343620353520562036302033322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333736382031373337204D0A2D343620343720560A2D3630202D333220560A3436202D353520560A363020343020560A2E32333533206720677361766520333439382031373234204E202D3630202D34392056202D343620353520562036302034312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333439382031373234204D0A2D343620343720560A2D3630202D343120560A3436202D353520560A363020343920560A2E32313136206720677361766520333433382031363735204E202D3630202D35342056202D343620353820562036302035312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333433382031363735204D0A2D343620353520560A2D3630202D353120560A3436202D353820560A363020353420560A2E313836206720677361766520333337382031363231204E202D3630202D35382056202D343620353920562036302035372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333337382031363231204D0A2D343620353820560A2D3630202D353720560A3436202D353920560A363020353820560A2E323137206720677361766520333831332031363735204E202D3539202D34342056202D343620363620562036302034302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333831332031363735204D0A2D343520363220560A2D3630202D343020560A3436202D363620560A353920343420560A2E32333233206720677361766520333630322031373133204E202D3539202D34372056202D343520353820562035392034302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333630322031373133204D0A2D343520353120560A2D3539202D343020560A3435202D353820560A353920343720560A2E31383638206720677361766520333835392031363036204E202D3539202D34352056202D343620373020562035392034342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333835392031363036204D0A2D343620363920560A2D3539202D343420560A3436202D373020560A353920343520560A2E32323633206720677361766520333730382031363937204E202D3630202D34362056202D343620363220562036302033392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333730382031363937204D0A2D343620353520560A2D3630202D333920560A3436202D363220560A363020343620560A2E31313938206720677361766520333139392031343532204E202D3630202D34352056202D343620343220562036302035342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333139392031343532204D0A2D343620353120560A2D3630202D353420560A3436202D343220560A363020343520560A2E3231206720677361766520333534332031363636204E202D3539202D35322056202D343620363120562036302034392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333534332031363636204D0A2D343520353820560A2D3630202D343920560A3436202D363120560A353920353220560A2E313836206720677361766520333438342031363134204E202D3630202D35352056202D343620363220562036302035342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333438342031363134204D0A2D343620363120560A2D3630202D353420560A3436202D363220560A363020353520560A2E31363231206720677361766520333432342031353539204E202D3630202D35352056202D343620353920562036302035382056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333432342031353539204D0A2D343620363220560A2D3630202D353820560A3436202D353920560A363020353520560A2E31393736206720677361766520333735342031363331204E202D3630202D34372056202D343620363720562036302034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333735342031363331204D0A2D343620363620560A2D3630202D343620560A3436202D363720560A363020343720560A2E32303533206720677361766520333634382031363531204E202D3539202D35302056202D343620363520562035392034372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333634382031363531204D0A2D343620363220560A2D3539202D343720560A3436202D363520560A353920353020560A2E31343032206720677361766520333336342031353034204E202D3630202D35322056202D343620353420562036302035372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333336342031353034204D0A2D343620353920560A2D3630202D353720560A3436202D353420560A363020353220560A2E313833206720677361766520333538392031363031204E202D3630202D35322056202D343520363520562035392035322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333538392031363031204D0A2D343620363520560A2D3539202D353220560A3435202D363520560A363020353220560A2E31363834206720677361766520333830302031353631204E202D3630202D34352056202D343620363820562036302034372056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333830302031353631204D0A2D343620373020560A2D3630202D343720560A3436202D363820560A363020343520560A2E31373731206720677361766520333639342031353834204E202D3630202D34392056202D343520363620562035392035302056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333639342031353834204D0A2D343620363720560A2D3539202D353020560A3435202D363620560A363020343920560A2E31363038206720677361766520333532392031353439204E202D3539202D35322056202D343620363220562036302035352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333532392031353439204D0A2D343520363520560A2D3630202D353520560A3436202D363220560A353920353220560A2E31323232206720677361766520333330342031343532204E202D3630202D34352056202D343520343520562035392035342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333330342031343532204D0A2D343620353420560A2D3539202D353420560A3435202D343520560A363020343520560A2E31353638206720677361766520333633342031353335204E202D3539202D34392056202D343620363320562036302035322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333633342031353335204D0A2D343520363620560A2D3630202D353220560A3436202D363320560A353920343920560A2E31343032206720677361766520333437302031343937204E202D3630202D34392056202D343620353620562036302035352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333437302031343937204D0A2D343620363220560A2D3630202D353520560A3436202D353620560A363020343920560A2E31353033206720677361766520333734302031353136204E202D3630202D34352056202D343620363420562036302034392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333734302031353136204D0A2D343620363820560A2D3630202D343920560A3436202D363420560A363020343520560A2E313338206720677361766520333537352031343836204E202D3539202D34362056202D343620353720562035392035322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333537352031343836204D0A2D343620363320560A2D3539202D353220560A3436202D353720560A353920343620560A2E313233206720677361766520333431302031343438204E202D3630202D34342056202D343620343820562036302035322056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333431302031343438204D0A2D343620353620560A2D3630202D353220560A3436202D343820560A363020343420560A2E31333337206720677361766520333638302031343731204E202D3630202D34332056202D343520353820562035392034392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333638302031343731204D0A2D343620363420560A2D3539202D343920560A3435202D353820560A363020343320560A2E31303936206720677361766520333234342031343037204E202D3539202D33352056202D343620333520562036302034352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333234342031343037204D0A2D343520343520560A2D3630202D343520560A3436202D333520560A353920333520560A2E31323232206720677361766520333531362031343430204E202D3630202D34312056202D343620343920562036302034392056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333531362031343430204D0A2D343620353720560A2D3630202D343920560A3436202D343920560A363020343120560A2E31313938206720677361766520333632302031343238204E202D3539202D33382056202D343520353020562035392034362056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333632302031343238204D0A2D343520353820560A2D3539202D343620560A3435202D353020560A353920333820560A2E31313036206720677361766520333335302031343034204E202D3630202D33352056202D343620333820562036302034352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333335302031343034204D0A2D343620343820560A2D3630202D343520560A3436202D333820560A363020333520560A2E31313036206720677361766520333435362031333939204E202D3630202D33342056202D343620333920562036302034342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333435362031333939204D0A2D343620343920560A2D3630202D343420560A3436202D333920560A363020333420560A2E31303936206720677361766520333536312031333930204E202D3539202D33312056202D343620343020562036302034312056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333536312031333930204D0A2D343520353020560A2D3630202D343120560A3436202D343020560A353920333120560A2E31303432206720677361766520333239302031333639204E202D3539202D32352056202D343620323820562035392033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333239302031333639204D0A2D343620333820560A2D3539202D333520560A3436202D323820560A353920323520560A2E31303433206720677361766520333339362031333635204E202D3630202D32352056202D343620323920562036302033352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333339362031333635204D0A2D343620333920560A2D3630202D333520560A3436202D323920560A363020323520560A2E31303432206720677361766520333530322031333539204E202D3630202D32332056202D343620323920562036302033342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333530322031333539204D0A2D343620343020560A2D3630202D333420560A3436202D323920560A363020323320560A2E313034206720677361766520333333362031333430204E202D3630202D31342056202D343520313820562035392032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333333362031333430204D0A2D343620323920560A2D3539202D323520560A3435202D313820560A363020313420560A2E313034206720677361766520333434322031333336204E202D3630202D31342056202D343620313820562036302032352056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333434322031333336204D0A2D343620323920560A2D3630202D323520560A3436202D313820560A363020313420560A2E31303935206720677361766520333338322031333232204E202D3630202D352056202D3436203920562036302031342056203120506F6C7946696C6C0A7374726F6B650A4C54300A302E303020302E303020302E3030204320333338322031333232204D0A2D343620313820560A2D3630202D313420560A3436202D3920560A3630203520560A7374726F6B650A4C54620A363234312031343036204D0A3332353320373131204C0A3935392031363136204D0A3332353320373131204C0A312E3030302055500A7374726F6B650A67726573746F7265202520636F6C6F75722070616C6574746520656E640A7374726F6B650A67726573746F72650A656E640A73686F77706167650A2525547261696C65720A2525446F63756D656E74466F6E74733A2048656C7665746963610A>|ps>||||>

      "sombrero.eps"
    </unfolded-io-math>
  </session>

  The given filename is interpreted relative to the current directory of the
  interpreter (which is normally the directory in which <TeXmacs> was
  started).

  You can also display the Gnuplot window for 3d viewing, and hide it again,
  as follows (these operations aren't part of Octave's plot functions, but
  are provided as convenience functions in the <verbatim|gnuplot> module):\ 

  <\session|pure|octave>
    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      popup<around*|(||)>;
    <|unfolded-io-math>
      ()
    </unfolded-io-math>

    <\unfolded-io-math>
      \<gtr\>\ 
    <|unfolded-io-math>
      popdn<around*|(||)>;
    <|unfolded-io-math>
      ()
    </unfolded-io-math>
  </session>

  Octave's Gnuplot interface is very comprehensive. Please refer to the
  <hlink|Octave manual|http://www.gnu.org/software/octave/doc/interpreter/>
  for a description of the provided plotting functions. Most of the plotting
  examples given in the Octave documentation can be translated to Pure in a
  fairly straightforward manner. More examples can be found in the
  <verbatim|pure-octave> package.

  <section|PostScript Output>

  Like the Python plugin, Pure can pipe PostScript graphics directly into
  <TeXmacs>. This is done with the <verbatim|ps> function from the
  <verbatim|texmacs> module which takes either verbatim PostScript code
  (indicated by a <verbatim|%!> header) or a PostScript filename as its
  string argument. In the latter case, if the PostScript filename doesn't
  have a slash in it, it is searched for in all directories on the
  <verbatim|TEXMACS_DOC_PATH>, and a <verbatim|.eps> or <verbatim|.ps> suffix
  is added automatically when needed. Otherwise the filename is interpreted
  relative to the current directory of the interpreter (which is normally the
  directory in which <TeXmacs> was started).

  Here is a simple example illustrating verbatim PostScript code:

  <\session|pure|postscript>
    <\unfolded-io>
      \<gtr\>\ 
    <|unfolded-io>
      ps "%!\\n%%BoundingBox: 195 295 405 405\\n/Times-Roman findfont 20
      scalefont setfont newpath 200 300 moveto 200 0 rlineto 0 100 rlineto
      -200 0 rlineto 0 -100 rlineto 235 345 moveto (Hello, world!) show
      closepath stroke showpage";
    <|unfolded-io>
      <image|<tuple|<#25210A2525426F756E64696E67426F783A203139352032393520343035203430350A2F54696D65732D526F6D616E2066696E64666F6E74203230207363616C65666F6E7420736574666F6E74206E6577706174682032303020333030206D6F7665746F20323030203020726C696E65746F20302031303020726C696E65746F202D323030203020726C696E65746F2030202D31303020726C696E65746F2032333520333435206D6F7665746F202848656C6C6F2C20776F726C6421292073686F7720636C6F736570617468207374726F6B652073686F7770616765>|ps>||||>

      ()
    </unfolded-io>
  </session>

  <section|Pure Scripting>

  Last but not least, Pure can also be used as a <em|scripting language> in
  <TeXmacs>. This is done by enabling the <samp|Document \| Scripts \| Pure>
  option (or <samp|Document \| Scripts \| Pure-math> if you prefer math
  output; this is what we use here). This enables a few additional options in
  the <samp|Pure> plugin menu, as well as the <samp|Insert \| Link> menu and
  the corresponding toolbar button. These facilities are described in more
  detail at the end of the \P<TeXmacs> \ as an interface\Q section in the
  <TeXmacs> online help, so we only give a few basic examples here.

  For instance, you can just select any valid Pure expression in the text and
  evaluate it with the <samp|Evaluate> option of the <samp|Pure> menu or
  <key|Ctrl+Return> like this: <math|<around*|(|a+b|)><rsup|2>>
  <math|\<rightarrow\>> <with|color|black|mode|math|math-display|true|a<rsup|2>+2*a*b+b<rsup|2>>.
  It's also possible to create an <em|executable switch> such as
  <script-input|pure-script-math|default|<math|df<around*|(|<around*|(|x+y|)><rsup|3>,x|)>>|<with|color|black|mode|math|math-display|true|3*<around*|(|x<rsup|2>+2*x*y+y<rsup|2>|)>>>
  which can be toggled between input and computed result by pressing
  <key|Return> inside the field (try it!).

  Note that as an additional convenience, the scripting plugins accept a
  simple expression without the trailing semicolon as input. This is in
  contrast to the regular Pure plugins which allow you to enter definitions
  and expressions spanning multiple input lines, but also require you to
  terminate each input item with a semicolon. With the scripting plugins the
  terminating semicolon is optional and will be added automatically when
  needed, but it also doesn't hurt if you type it anyway:
  <script-input|pure-script-math|default|<math|df<around*|(|<around*|(|x+y|)><rsup|3>,x|)>;>|<with|color|black|mode|math|math-display|true|3*<around*|(|x<rsup|2>+2*x*y+y<rsup|2>|)>>>

  There's also the possibility to work with <em|executable fields> and
  <em|spreadsheets>. These offer the advantage that fields may depend on
  other fields in the same document.<\footnote>
    Note that the spreadsheet functionality requires <TeXmacs> 1.0.7.15 or
    later to work. Also be warned that, at least at the time of this writing,
    this might become <em|very> slow in large documents; however, it's
    possible to work around this limitation by breaking your document into
    smaller include files.
  </footnote> For instance, here is an example of a textual spreadsheet
  (<samp|Insert \| Table \| Textual spreadsheet>) showing some Pure and
  Reduce calculations. Type <key|Return> in the cells of the last column to
  reveal the underlying Pure formulas; also try changing some of the values
  in the <verbatim|b> and <verbatim|c> columns and hitting <key|Return> to
  recompute the corresponding values in the last column.

  <with|font-base-size|12|<\calc-table|table1>
    <\with|par-mode|center>
      <textual-table|<tformat|<cwith|1|1|1|-1|cell-background|pastel
      yellow>|<cwith|2|-1|1|-1|cell-hyphen|n>|<cwith|2|2|1|-1|cell-bborder|0>|<cwith|1|-1|1|1|cell-width|>|<cwith|1|-1|1|1|cell-hmode|auto>|<cwith|4|4|1|-1|cell-bborder|0>|<cwith|1|-1|1|1|cell-background|pastel
      yellow>|<cwith|2|-1|4|4|cell-background|pastel
      green>|<table|<row|<cell|<cell-inert|a1|a1>>|<cell|<cell-inert|b1|b>>|<cell|<cell-inert|c1|c>>|<cell|<cell-inert|d1|d>>>|<row|<cell|<cell-inert|a2|2>>|<cell|<cell-inert|b2|1>>|<cell|<cell-inert|c2|12>>|<cell|<cell-output|d2|=
      fact (b2+c2) with fact n = if n\<gtr\>0 then n*fact(n-1) else 1
      end|1932053504>>>|<row|<cell|<cell-inert|a3|3>>|<cell|<cell-inert|b3|17>>|<cell|<cell-inert|c3|33>>|<cell|<cell-output|d3|='(b3+c3)|<with|color|black|mode|math|math-display|true|50>>>>|<row|<cell|<cell-inert|a4|4>>|<cell|<cell-inert|b4|<math|sin
      <around*|(|x<rsup|2>|)>>>>|<cell|<cell-inert|c4|<math|x>>>|<cell|<cell-output|d4|=?df
      b4 c4|<with|color|black|mode|math|math-display|true|2*cos
      <around*|(|x<rsup|2>|)>*x>>>>|<row|<cell|<cell-inert|a5|5>>|<cell|<cell-inert|b5|<math|<around*|(|x+y|)><rsup|3>>>>|<cell|<cell-inert|c5|<math|x>>>|<cell|<cell-output|d5|=?df
      b5 c5|<with|color|black|mode|math|math-display|true|3*<around*|(|x<rsup|2>+2*x*y+y<rsup|2>|)>>>>>>>>
    </with>
  </calc-table>>

  You can also refer to a table field in text like this:
  <with|font-base-size|12|<calc-output|field3|<calc-ref|table1-d4>|<with|color|black|mode|math|math-display|true|2*cos
  <around*|(|x<rsup|2>|)>*x>>>. Here we set the Ref field of the table to
  <verbatim|table1>; the reference to cell <verbatim|d4> can then be entered
  with the following series of key strokes: <key|\\ ! \\ ?>
  <verbatim|table1-d4> <key|Return>.

  Executable fields can be used to run arbitrary Pure code. For instance,
  here's the PostScript example from the previous section as a field (again,
  you can hit <key|Return> on the field to reveal the actual Pure code):

  <\with|par-mode|center>
    <calc-output|field1|let ps "%!\\n%%BoundingBox: 195 295 405
    405\\n/Times-Roman findfont 20 scalefont setfont newpath 200 300 moveto
    200 0 rlineto 0 100 rlineto -200 0 rlineto 0 -100 rlineto 235 345 moveto
    (Hello, world!) show closepath stroke
    showpage";|<image|<tuple|<#25210A2525426F756E64696E67426F783A203139352032393520343035203430350A2F54696D65732D526F6D616E2066696E64666F6E74203230207363616C65666F6E7420736574666F6E74206E6577706174682032303020333030206D6F7665746F20323030203020726C696E65746F20302031303020726C696E65746F202D323030203020726C696E65746F2030202D31303020726C696E65746F2032333520333435206D6F7665746F202848656C6C6F2C20776F726C6421292073686F7720636C6F736570617468207374726F6B652073686F7770616765>|ps>||||>>
  </with>

  Note that scripting by default uses its own instance of the Pure
  interpreter which is separate from all Pure sessions that might be included
  in the same document. But with executable switches it's possible to hook
  into any Pure session, so that you can use variables and functions defined
  or imported in that session. To do this, you'll have to create an
  executable switch for a specific session type (<samp|Insert \| Fold \|
  Executable>). (Also note that in this case the expressions <em|must> be
  terminated with a semicolon, just like in a regular Pure session.) For
  instance, the following switch hooks into the Octave session from above:

  \;

  <\with|par-mode|center>
    <script-output|pure|octave|<math|eig2
    <matrix|<tformat|<table|<row|<cell|1>|<cell|2>>|<row|<cell|3>|<cell|4>>>>>;>|<with|color|black|mode|math|math-display|true|<around*|(|<tabular*|<tformat|<table|<row|<cell|-0.824564840132>|<cell|-0.415973557919>>|<row|<cell|0.565767464969>|<cell|-0.909376709132>>>>>|)>>,<with|color|black|mode|math|math-display|true|<around*|(|<tabular*|<tformat|<table|<row|<cell|-0.372281323269>|<cell|0>>|<row|<cell|0>|<cell|5.37228132327>>>>>|)>>>
  </with>

  \;

  In the same fashion we can also reproduce the plot of the sombrero:

  <\with|par-mode|center>
    <script-output|pure|octave|<math|<math-bf|let>
    fig2=sombrero<around*|(||)>;<math-bf|let>
    psplot<around*|(||)>;>|<image|<tuple|<#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