// A Bison parser, made by GNU Bison 3.0.4.

// Skeleton implementation for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.


// First part of user declarations.
#line 32 "parser.yy" // lalr1.cc:404

#include <iostream>
#include <string>
#include "parserdefs.hh"
#include "printer.hh"
#include "util.hh"

// Get rid of silly warnings in bison-generated position.hh.
#pragma GCC diagnostic ignored "-Wparentheses"

#define restricted_action(task,cleanup) \
  try { if (interp.nerrs == 0) {task;} else {cleanup;} } \
  catch (err &e) { error(yyloc, e.what()); } \
  interp.nerrs = 0;

#define action(task,cleanup) \
  try { if (interp.restricted) throw err("operation not implemented"); \
        else if (interp.nerrs == 0) {task;} else {cleanup;} } \
  catch (err &e) { error(yyloc, e.what()); } \
  interp.nerrs = 0;

#define parser_action(task,cleanup) \
  try { task; }	catch (err &e) { cleanup; error(yyloc, e.what()); YYERROR; }

#define dummy_expr expr(interp.symtab.anon_sym)

#define priv_def (interp.active_namespaces.empty()?false:interp.active_namespaces.front().priv)

using namespace std;

class interpreter;

#line 69 "./parser.cc" // lalr1.cc:404

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

#include "parser.hh"

// User implementation prologue.
#line 115 "parser.yy" // lalr1.cc:412

// Work around undefined symbols in C++ parsers generated with Bison 3.0.
// NOTE: This setting should be determined automatically when the parser is
// regenerated.
#if HAVE_BISON30
#define yychar yyla.type
#define yylloc yyla.location
#define yyloc yylhs.location
#endif

#include "lexerdefs.hh"
#include "interpreter.hh"
static int extern_priv;
static void mangle_fname(string& name);

#line 98 "./parser.cc" // lalr1.cc:412


#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> // FIXME: INFRINGES ON USER NAME SPACE.
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K].location)
/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

# ifndef YYLLOC_DEFAULT
#  define YYLLOC_DEFAULT(Current, Rhs, N)                               \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).begin  = YYRHSLOC (Rhs, 1).begin;                   \
          (Current).end    = YYRHSLOC (Rhs, N).end;                     \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).begin = (Current).end = YYRHSLOC (Rhs, 0).end;      \
        }                                                               \
    while (/*CONSTCOND*/ false)
# endif


// Suppress unused-variable warnings by "using" E.
#define YYUSE(E) ((void) (E))

// Enable debugging if requested.
#if YYDEBUG

// A pseudo ostream that takes yydebug_ into account.
# define YYCDEBUG if (yydebug_) (*yycdebug_)

# define YY_SYMBOL_PRINT(Title, Symbol)         \
  do {                                          \
    if (yydebug_)                               \
    {                                           \
      *yycdebug_ << Title << ' ';               \
      yy_print_ (*yycdebug_, Symbol);           \
      *yycdebug_ << std::endl;                  \
    }                                           \
  } while (false)

# define YY_REDUCE_PRINT(Rule)          \
  do {                                  \
    if (yydebug_)                       \
      yy_reduce_print_ (Rule);          \
  } while (false)

# define YY_STACK_PRINT()               \
  do {                                  \
    if (yydebug_)                       \
      yystack_print_ ();                \
  } while (false)

#else // !YYDEBUG

# define YYCDEBUG if (false) std::cerr
# define YY_SYMBOL_PRINT(Title, Symbol)  YYUSE(Symbol)
# define YY_REDUCE_PRINT(Rule)           static_cast<void>(0)
# define YY_STACK_PRINT()                static_cast<void>(0)

#endif // !YYDEBUG

#define yyerrok         (yyerrstatus_ = 0)
#define yyclearin       (yyla.clear ())

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYRECOVERING()  (!!yyerrstatus_)


namespace yy {
#line 184 "./parser.cc" // lalr1.cc:479

  /* Return YYSTR after stripping away unnecessary quotes and
     backslashes, so that it's suitable for yyerror.  The heuristic is
     that double-quoting is unnecessary unless the string contains an
     apostrophe, a comma, or backslash (other than backslash-backslash).
     YYSTR is taken from yytname.  */
  std::string
  parser::yytnamerr_ (const char *yystr)
  {
    if (*yystr == '"')
      {
        std::string yyr = "";
        char const *yyp = yystr;

        for (;;)
          switch (*++yyp)
            {
            case '\'':
            case ',':
              goto do_not_strip_quotes;

            case '\\':
              if (*++yyp != '\\')
                goto do_not_strip_quotes;
              // Fall through.
            default:
              yyr += *yyp;
              break;

            case '"':
              return yyr;
            }
      do_not_strip_quotes: ;
      }

    return yystr;
  }


  /// Build a parser object.
  parser::parser (interpreter& interp_yyarg)
    :
#if YYDEBUG
      yydebug_ (false),
      yycdebug_ (&std::cerr),
#endif
      interp (interp_yyarg)
  {}

  parser::~parser ()
  {}


  /*---------------.
  | Symbol types.  |
  `---------------*/

  inline
  parser::syntax_error::syntax_error (const location_type& l, const std::string& m)
    : std::runtime_error (m)
    , location (l)
  {}

  // basic_symbol.
  template <typename Base>
  inline
  parser::basic_symbol<Base>::basic_symbol ()
    : value ()
  {}

  template <typename Base>
  inline
  parser::basic_symbol<Base>::basic_symbol (const basic_symbol& other)
    : Base (other)
    , value ()
    , location (other.location)
  {
    value = other.value;
  }


  template <typename Base>
  inline
  parser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, const semantic_type& v, const location_type& l)
    : Base (t)
    , value (v)
    , location (l)
  {}


  /// Constructor for valueless symbols.
  template <typename Base>
  inline
  parser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, const location_type& l)
    : Base (t)
    , value ()
    , location (l)
  {}

  template <typename Base>
  inline
  parser::basic_symbol<Base>::~basic_symbol ()
  {
    clear ();
  }

  template <typename Base>
  inline
  void
  parser::basic_symbol<Base>::clear ()
  {
    Base::clear ();
  }

  template <typename Base>
  inline
  bool
  parser::basic_symbol<Base>::empty () const
  {
    return Base::type_get () == empty_symbol;
  }

  template <typename Base>
  inline
  void
  parser::basic_symbol<Base>::move (basic_symbol& s)
  {
    super_type::move(s);
    value = s.value;
    location = s.location;
  }

  // by_type.
  inline
  parser::by_type::by_type ()
    : type (empty_symbol)
  {}

  inline
  parser::by_type::by_type (const by_type& other)
    : type (other.type)
  {}

  inline
  parser::by_type::by_type (token_type t)
    : type (yytranslate_ (t))
  {}

  inline
  void
  parser::by_type::clear ()
  {
    type = empty_symbol;
  }

  inline
  void
  parser::by_type::move (by_type& that)
  {
    type = that.type;
    that.clear ();
  }

  inline
  int
  parser::by_type::type_get () const
  {
    return type;
  }


  // by_state.
  inline
  parser::by_state::by_state ()
    : state (empty_state)
  {}

  inline
  parser::by_state::by_state (const by_state& other)
    : state (other.state)
  {}

  inline
  void
  parser::by_state::clear ()
  {
    state = empty_state;
  }

  inline
  void
  parser::by_state::move (by_state& that)
  {
    state = that.state;
    that.clear ();
  }

  inline
  parser::by_state::by_state (state_type s)
    : state (s)
  {}

  inline
  parser::symbol_number_type
  parser::by_state::type_get () const
  {
    if (state == empty_state)
      return empty_symbol;
    else
      return yystos_[state];
  }

  inline
  parser::stack_symbol_type::stack_symbol_type ()
  {}


  inline
  parser::stack_symbol_type::stack_symbol_type (state_type s, symbol_type& that)
    : super_type (s, that.location)
  {
    value = that.value;
    // that is emptied.
    that.type = empty_symbol;
  }

  inline
  parser::stack_symbol_type&
  parser::stack_symbol_type::operator= (const stack_symbol_type& that)
  {
    state = that.state;
    value = that.value;
    location = that.location;
    return *this;
  }


  template <typename Base>
  inline
  void
  parser::yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const
  {
    if (yymsg)
      YY_SYMBOL_PRINT (yymsg, yysym);

    // User destructor.
    switch (yysym.type_get ())
    {
            case 25: // "left outfix operator"

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.xval); }
#line 437 "./parser.cc" // lalr1.cc:614
        break;

      case 26: // "right outfix operator"

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.xval); }
#line 444 "./parser.cc" // lalr1.cc:614
        break;

      case 27: // "infix operator"

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.xval); }
#line 451 "./parser.cc" // lalr1.cc:614
        break;

      case 28: // "infixl operator"

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.xval); }
#line 458 "./parser.cc" // lalr1.cc:614
        break;

      case 29: // "infixr operator"

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.xval); }
#line 465 "./parser.cc" // lalr1.cc:614
        break;

      case 30: // "prefix operator"

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.xval); }
#line 472 "./parser.cc" // lalr1.cc:614
        break;

      case 31: // "postfix operator"

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.xval); }
#line 479 "./parser.cc" // lalr1.cc:614
        break;

      case 39: // "identifier"

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.sval); }
#line 486 "./parser.cc" // lalr1.cc:614
        break;

      case 41: // "string"

#line 210 "parser.yy" // lalr1.cc:614
        { free((yysym.value.csval)); }
#line 493 "./parser.cc" // lalr1.cc:614
        break;

      case 43: // "bigint"

#line 209 "parser.yy" // lalr1.cc:614
        { mpz_clear(*(yysym.value.zval)); free((yysym.value.zval)); }
#line 500 "./parser.cc" // lalr1.cc:614
        break;

      case 44: // "converted bigint"

#line 209 "parser.yy" // lalr1.cc:614
        { mpz_clear(*(yysym.value.zval)); free((yysym.value.zval)); }
#line 507 "./parser.cc" // lalr1.cc:614
        break;

      case 76: // fixity

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.info); }
#line 514 "./parser.cc" // lalr1.cc:614
        break;

      case 79: // ids

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.slval); }
#line 521 "./parser.cc" // lalr1.cc:614
        break;

      case 80: // fnames

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.slval); }
#line 528 "./parser.cc" // lalr1.cc:614
        break;

      case 81: // fname

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.sval); }
#line 535 "./parser.cc" // lalr1.cc:614
        break;

      case 84: // name_xsyms_list

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.smlval); }
#line 542 "./parser.cc" // lalr1.cc:614
        break;

      case 85: // name_xsyms

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.smval); }
#line 549 "./parser.cc" // lalr1.cc:614
        break;

      case 87: // xsyms

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.ilval); }
#line 556 "./parser.cc" // lalr1.cc:614
        break;

      case 88: // name

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.sval); }
#line 563 "./parser.cc" // lalr1.cc:614
        break;

      case 91: // opt_ctypes

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.sloval); }
#line 570 "./parser.cc" // lalr1.cc:614
        break;

      case 92: // ctypes

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.sloval); }
#line 577 "./parser.cc" // lalr1.cc:614
        break;

      case 93: // ctype

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.sval); }
#line 584 "./parser.cc" // lalr1.cc:614
        break;

      case 95: // optalias

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.sval); }
#line 591 "./parser.cc" // lalr1.cc:614
        break;

      case 96: // expr

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.xval); }
#line 598 "./parser.cc" // lalr1.cc:614
        break;

      case 97: // args

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.xlval); }
#line 605 "./parser.cc" // lalr1.cc:614
        break;

      case 98: // simple

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.opstk); }
#line 612 "./parser.cc" // lalr1.cc:614
        break;

      case 99: // prim

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.xval); }
#line 619 "./parser.cc" // lalr1.cc:614
        break;

      case 100: // comp_clauses

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.clauselval); }
#line 626 "./parser.cc" // lalr1.cc:614
        break;

      case 101: // comp_clause_list

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.clauselval); }
#line 633 "./parser.cc" // lalr1.cc:614
        break;

      case 103: // rows

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.xllval); }
#line 640 "./parser.cc" // lalr1.cc:614
        break;

      case 104: // row_list

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.xllval); }
#line 647 "./parser.cc" // lalr1.cc:614
        break;

      case 105: // row

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.xlval); }
#line 654 "./parser.cc" // lalr1.cc:614
        break;

      case 106: // rule

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.rlval); }
#line 661 "./parser.cc" // lalr1.cc:614
        break;

      case 107: // lhs

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.xlval); }
#line 668 "./parser.cc" // lalr1.cc:614
        break;

      case 108: // rhs

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.rhsval); }
#line 675 "./parser.cc" // lalr1.cc:614
        break;

      case 109: // qual_rhs

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.rhsval); }
#line 682 "./parser.cc" // lalr1.cc:614
        break;

      case 110: // rules

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.rinfo); }
#line 689 "./parser.cc" // lalr1.cc:614
        break;

      case 111: // rulel

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.rinfo); }
#line 696 "./parser.cc" // lalr1.cc:614
        break;

      case 112: // pat_rules

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.prinfo); }
#line 703 "./parser.cc" // lalr1.cc:614
        break;

      case 113: // pat_rulel

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.prinfo); }
#line 710 "./parser.cc" // lalr1.cc:614
        break;

      case 114: // simple_rule

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.rval); }
#line 717 "./parser.cc" // lalr1.cc:614
        break;

      case 115: // simple_rules

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.rlval); }
#line 724 "./parser.cc" // lalr1.cc:614
        break;

      case 116: // simple_rulel

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.rlval); }
#line 731 "./parser.cc" // lalr1.cc:614
        break;

      case 117: // type_rule

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.rlval); }
#line 738 "./parser.cc" // lalr1.cc:614
        break;

      case 118: // macro_rule

#line 203 "parser.yy" // lalr1.cc:614
        { delete (yysym.value.rlval); }
#line 745 "./parser.cc" // lalr1.cc:614
        break;


      default:
        break;
    }
  }

#if YYDEBUG
  template <typename Base>
  void
  parser::yy_print_ (std::ostream& yyo,
                                     const basic_symbol<Base>& yysym) const
  {
    std::ostream& yyoutput = yyo;
    YYUSE (yyoutput);
    symbol_number_type yytype = yysym.type_get ();
    // Avoid a (spurious) G++ 4.8 warning about "array subscript is
    // below array bounds".
    if (yysym.empty ())
      std::abort ();
    yyo << (yytype < yyntokens_ ? "token" : "nterm")
        << ' ' << yytname_[yytype] << " ("
        << yysym.location << ": ";
    switch (yytype)
    {
            case 39: // "identifier"

#line 211 "parser.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.sval); }
#line 776 "./parser.cc" // lalr1.cc:636
        break;

      case 41: // "string"

#line 216 "parser.yy" // lalr1.cc:636
        { debug_stream() << (yysym.value.csval); }
#line 783 "./parser.cc" // lalr1.cc:636
        break;

      case 42: // "integer"

#line 216 "parser.yy" // lalr1.cc:636
        { debug_stream() << (yysym.value.ival); }
#line 790 "./parser.cc" // lalr1.cc:636
        break;

      case 43: // "bigint"

#line 217 "parser.yy" // lalr1.cc:636
        { char *s = mpz_get_str(NULL, 10, *(yysym.value.zval));
           debug_stream() << s; free(s); }
#line 798 "./parser.cc" // lalr1.cc:636
        break;

      case 44: // "converted bigint"

#line 217 "parser.yy" // lalr1.cc:636
        { char *s = mpz_get_str(NULL, 10, *(yysym.value.zval));
           debug_stream() << s; free(s); }
#line 806 "./parser.cc" // lalr1.cc:636
        break;

      case 45: // "floating point number"

#line 216 "parser.yy" // lalr1.cc:636
        { debug_stream() << (yysym.value.dval); }
#line 813 "./parser.cc" // lalr1.cc:636
        break;

      case 81: // fname

#line 211 "parser.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.sval); }
#line 820 "./parser.cc" // lalr1.cc:636
        break;

      case 88: // name

#line 211 "parser.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.sval); }
#line 827 "./parser.cc" // lalr1.cc:636
        break;

      case 93: // ctype

#line 211 "parser.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.sval); }
#line 834 "./parser.cc" // lalr1.cc:636
        break;

      case 95: // optalias

#line 211 "parser.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.sval); }
#line 841 "./parser.cc" // lalr1.cc:636
        break;

      case 96: // expr

#line 211 "parser.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.xval); }
#line 848 "./parser.cc" // lalr1.cc:636
        break;

      case 97: // args

#line 211 "parser.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.xlval); }
#line 855 "./parser.cc" // lalr1.cc:636
        break;

      case 99: // prim

#line 211 "parser.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.xval); }
#line 862 "./parser.cc" // lalr1.cc:636
        break;

      case 106: // rule

#line 211 "parser.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.rlval); }
#line 869 "./parser.cc" // lalr1.cc:636
        break;

      case 107: // lhs

#line 211 "parser.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.xlval); }
#line 876 "./parser.cc" // lalr1.cc:636
        break;

      case 108: // rhs

#line 213 "parser.yy" // lalr1.cc:636
        { debug_stream() << (yysym.value.rhsval)->r; }
#line 883 "./parser.cc" // lalr1.cc:636
        break;

      case 109: // qual_rhs

#line 213 "parser.yy" // lalr1.cc:636
        { debug_stream() << (yysym.value.rhsval)->r; }
#line 890 "./parser.cc" // lalr1.cc:636
        break;

      case 110: // rules

#line 214 "parser.yy" // lalr1.cc:636
        { debug_stream() << (yysym.value.rinfo)->e; }
#line 897 "./parser.cc" // lalr1.cc:636
        break;

      case 111: // rulel

#line 214 "parser.yy" // lalr1.cc:636
        { debug_stream() << (yysym.value.rinfo)->e; }
#line 904 "./parser.cc" // lalr1.cc:636
        break;

      case 112: // pat_rules

#line 215 "parser.yy" // lalr1.cc:636
        { debug_stream() << (yysym.value.prinfo)->rl; }
#line 911 "./parser.cc" // lalr1.cc:636
        break;

      case 113: // pat_rulel

#line 215 "parser.yy" // lalr1.cc:636
        { debug_stream() << (yysym.value.prinfo)->rl; }
#line 918 "./parser.cc" // lalr1.cc:636
        break;

      case 114: // simple_rule

#line 211 "parser.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.rval); }
#line 925 "./parser.cc" // lalr1.cc:636
        break;

      case 115: // simple_rules

#line 211 "parser.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.rlval); }
#line 932 "./parser.cc" // lalr1.cc:636
        break;

      case 116: // simple_rulel

#line 211 "parser.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.rlval); }
#line 939 "./parser.cc" // lalr1.cc:636
        break;

      case 117: // type_rule

#line 211 "parser.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.rlval); }
#line 946 "./parser.cc" // lalr1.cc:636
        break;

      case 118: // macro_rule

#line 211 "parser.yy" // lalr1.cc:636
        { debug_stream() << *(yysym.value.rlval); }
#line 953 "./parser.cc" // lalr1.cc:636
        break;


      default:
        break;
    }
    yyo << ')';
  }
#endif

  inline
  void
  parser::yypush_ (const char* m, state_type s, symbol_type& sym)
  {
    stack_symbol_type t (s, sym);
    yypush_ (m, t);
  }

  inline
  void
  parser::yypush_ (const char* m, stack_symbol_type& s)
  {
    if (m)
      YY_SYMBOL_PRINT (m, s);
    yystack_.push (s);
  }

  inline
  void
  parser::yypop_ (unsigned int n)
  {
    yystack_.pop (n);
  }

#if YYDEBUG
  std::ostream&
  parser::debug_stream () const
  {
    return *yycdebug_;
  }

  void
  parser::set_debug_stream (std::ostream& o)
  {
    yycdebug_ = &o;
  }


  parser::debug_level_type
  parser::debug_level () const
  {
    return yydebug_;
  }

  void
  parser::set_debug_level (debug_level_type l)
  {
    yydebug_ = l;
  }
#endif // YYDEBUG

  inline parser::state_type
  parser::yy_lr_goto_state_ (state_type yystate, int yysym)
  {
    int yyr = yypgoto_[yysym - yyntokens_] + yystate;
    if (0 <= yyr && yyr <= yylast_ && yycheck_[yyr] == yystate)
      return yytable_[yyr];
    else
      return yydefgoto_[yysym - yyntokens_];
  }

  inline bool
  parser::yy_pact_value_is_default_ (int yyvalue)
  {
    return yyvalue == yypact_ninf_;
  }

  inline bool
  parser::yy_table_value_is_error_ (int yyvalue)
  {
    return yyvalue == yytable_ninf_;
  }

  int
  parser::parse ()
  {
    // State.
    int yyn;
    /// Length of the RHS of the rule being reduced.
    int yylen = 0;

    // Error handling.
    int yynerrs_ = 0;
    int yyerrstatus_ = 0;

    /// The lookahead symbol.
    symbol_type yyla;

    /// The locations where the error started and ended.
    stack_symbol_type yyerror_range[3];

    /// The return value of parse ().
    int yyresult;

    // FIXME: This shoud be completely indented.  It is not yet to
    // avoid gratuitous conflicts when merging into the master branch.
    try
      {
    YYCDEBUG << "Starting parse" << std::endl;


    // User initialization code.
    #line 72 "parser.yy" // lalr1.cc:741
{
  static string stdin_source = "<stdin>";
  // Initialize the initial location.
  if (interp.source.empty())
    yyla.location.begin.filename = yyla.location.end.filename = &stdin_source;
  else
    yyla.location.begin.filename = yyla.location.end.filename = &interp.source;
}

#line 1076 "./parser.cc" // lalr1.cc:741

    /* Initialize the stack.  The initial state will be set in
       yynewstate, since the latter expects the semantical and the
       location values to have been already stored, initialize these
       stacks with a primary value.  */
    yystack_.clear ();
    yypush_ (YY_NULLPTR, 0, yyla);

    // A new symbol was pushed on the stack.
  yynewstate:
    YYCDEBUG << "Entering state " << yystack_[0].state << std::endl;

    // Accept?
    if (yystack_[0].state == yyfinal_)
      goto yyacceptlab;

    goto yybackup;

    // Backup.
  yybackup:

    // Try to take a decision without lookahead.
    yyn = yypact_[yystack_[0].state];
    if (yy_pact_value_is_default_ (yyn))
      goto yydefault;

    // Read a lookahead token.
    if (yyla.empty ())
      {
        YYCDEBUG << "Reading a token: ";
        try
          {
            yyla.type = yytranslate_ (yylex (&yyla.value, &yyla.location, interp));
          }
        catch (const syntax_error& yyexc)
          {
            error (yyexc);
            goto yyerrlab1;
          }
      }
    YY_SYMBOL_PRINT ("Next token is", yyla);

    /* If the proper action on seeing token YYLA.TYPE is to reduce or
       to detect an error, take that action.  */
    yyn += yyla.type_get ();
    if (yyn < 0 || yylast_ < yyn || yycheck_[yyn] != yyla.type_get ())
      goto yydefault;

    // Reduce or error.
    yyn = yytable_[yyn];
    if (yyn <= 0)
      {
        if (yy_table_value_is_error_ (yyn))
          goto yyerrlab;
        yyn = -yyn;
        goto yyreduce;
      }

    // Count tokens shifted since error; after three, turn off error status.
    if (yyerrstatus_)
      --yyerrstatus_;

    // Shift the lookahead token.
    yypush_ ("Shifting", yyn, yyla);
    goto yynewstate;

  /*-----------------------------------------------------------.
  | yydefault -- do the default action for the current state.  |
  `-----------------------------------------------------------*/
  yydefault:
    yyn = yydefact_[yystack_[0].state];
    if (yyn == 0)
      goto yyerrlab;
    goto yyreduce;

  /*-----------------------------.
  | yyreduce -- Do a reduction.  |
  `-----------------------------*/
  yyreduce:
    yylen = yyr2_[yyn];
    {
      stack_symbol_type yylhs;
      yylhs.state = yy_lr_goto_state_(yystack_[yylen].state, yyr1_[yyn]);
      /* If YYLEN is nonzero, implement the default value of the
         action: '$$ = $1'.  Otherwise, use the top of the stack.

         Otherwise, the following line sets YYLHS.VALUE to garbage.
         This behavior is undocumented and Bison users should not rely
         upon it.  */
      if (yylen)
        yylhs.value = yystack_[yylen - 1].value;
      else
        yylhs.value = yystack_[0].value;

      // Compute the default @$.
      {
        slice<stack_symbol_type, stack_type> slice (yystack_, yylen);
        YYLLOC_DEFAULT (yylhs.location, slice, yylen);
      }

      // Perform the reduction.
      YY_REDUCE_PRINT (yyn);
      try
        {
          switch (yyn)
            {
  case 5:
#line 236 "parser.yy" // lalr1.cc:859
    { interp.nerrs = yyerrstatus_ = 0; interp.declare_op = false;
  interp.symtab.clean_namespaces(); }
#line 1187 "./parser.cc" // lalr1.cc:859
    break;

  case 8:
#line 246 "parser.yy" // lalr1.cc:859
    { interp.nerrs = yyerrstatus_ = 0; interp.declare_op = false;
  interp.symtab.clean_namespaces(); }
#line 1194 "./parser.cc" // lalr1.cc:859
    break;

  case 9:
#line 251 "parser.yy" // lalr1.cc:859
    { interp.line = yylloc.begin.line; interp.column = yylloc.begin.column; }
#line 1200 "./parser.cc" // lalr1.cc:859
    break;

  case 11:
#line 257 "parser.yy" // lalr1.cc:859
    { interp.loc = &yyloc;
  if (!interp.tags) { restricted_action(interp.exec((yystack_[1].value.xval)), delete (yystack_[1].value.xval)); }
  else delete (yystack_[1].value.xval); }
#line 1208 "./parser.cc" // lalr1.cc:859
    break;

  case 12:
#line 261 "parser.yy" // lalr1.cc:859
    { interp.loc = &yyloc;
  if (!interp.tags) { restricted_action(interp.parse((yystack_[1].value.xval)), delete (yystack_[1].value.xval)); }
  else delete (yystack_[1].value.xval);
  // We only parse a single expression in this mode, bail out.
  if (yychar > 0 && interp.nerrs == 0)
    error(yylloc, "syntax error, expected end of file");
  YYACCEPT; }
#line 1220 "./parser.cc" // lalr1.cc:859
    break;

  case 13:
#line 269 "parser.yy" // lalr1.cc:859
    { interp.loc = &yyloc; action(interp.define((yystack_[1].value.rval)), delete (yystack_[1].value.rval)); }
#line 1226 "./parser.cc" // lalr1.cc:859
    break;

  case 14:
#line 271 "parser.yy" // lalr1.cc:859
    { interp.loc = &yyloc; action(interp.define_const((yystack_[1].value.rval)), delete (yystack_[1].value.rval)); }
#line 1232 "./parser.cc" // lalr1.cc:859
    break;

  case 15:
#line 273 "parser.yy" // lalr1.cc:859
    { interp.loc = &yyloc; action(interp.add_macro_rules((yystack_[1].value.rlval)), delete (yystack_[1].value.rlval)); }
#line 1238 "./parser.cc" // lalr1.cc:859
    break;

  case 16:
#line 275 "parser.yy" // lalr1.cc:859
    { expr *id = 0;
  string *s = new string(*(yystack_[0].value.sval));
  try { id = interp.mksym_expr(s); }
  catch (err &e) {
    interp.error(yyloc, e.what());
  }
  if (id && id->is_fun()) {
    // This will promote the symbol to the proper namespace if it hasn't been
    // declared yet.
    interp.checkvars(*id);
    interp.symtab.sym(id->tag()).unresolved = false;
    interp.typeenv[id->tag()];
    (yylhs.value.ival) = id->tag();
  } else {
    error(yylloc, "error in interface declaration (invalid type identifier)");
    (yylhs.value.ival) = 0;
  }
  if (id) delete id;
}
#line 1262 "./parser.cc" // lalr1.cc:859
    break;

  case 17:
#line 294 "parser.yy" // lalr1.cc:859
    { (yylhs.value.ival) = (yystack_[1].value.ival); }
#line 1268 "./parser.cc" // lalr1.cc:859
    break;

  case 18:
#line 295 "parser.yy" // lalr1.cc:859
    { int32_t tag = (yystack_[5].value.ival), count = (yystack_[2].value.ival);
  delete (yystack_[6].value.sval);
  if (tag) interp.finalize_interface_rules(interp.typeenv, tag, count);
}
#line 1277 "./parser.cc" // lalr1.cc:859
    break;

  case 19:
#line 300 "parser.yy" // lalr1.cc:859
    { interp.loc = &yyloc;
  action(interp.add_type_rules(interp.typeenv, (yystack_[1].value.rlval)), delete (yystack_[1].value.rlval)); }
#line 1284 "./parser.cc" // lalr1.cc:859
    break;

  case 20:
#line 303 "parser.yy" // lalr1.cc:859
    { interp.loc = &yyloc;
  rulel *rl = 0;
  bool headless = (yystack_[1].value.rlval)->front().lhs.is_null();
  action(interp.add_rules(interp.globenv,
  (rl = interp.default_lhs(interp.last, (yystack_[1].value.rlval))), headless, true),
  if (rl) delete rl); }
#line 1295 "./parser.cc" // lalr1.cc:859
    break;

  case 21:
#line 310 "parser.yy" // lalr1.cc:859
    { if ((yystack_[0].value.info)->special && (yystack_[0].value.info)->fix != nonfix && (yystack_[0].value.info)->fix != outfix &&
      (yystack_[0].value.info)->prec >= PREC_MAX) {
    error(yylloc, "invalid fixity declaration"); (yystack_[0].value.info)->prec = 0;
  } }
#line 1304 "./parser.cc" // lalr1.cc:859
    break;

  case 22:
#line 315 "parser.yy" // lalr1.cc:859
    { interp.declare_op = false;
  action(interp.declare((yystack_[3].value.info)->priv, (yystack_[3].value.info)->prec, (yystack_[3].value.info)->fix, (yystack_[1].value.slval)), );
  if (interp.tags) interp.add_tags((yystack_[1].value.slval));
  delete (yystack_[1].value.slval); delete (yystack_[3].value.info); }
#line 1313 "./parser.cc" // lalr1.cc:859
    break;

  case 23:
#line 320 "parser.yy" // lalr1.cc:859
    { action(interp.run(*(yystack_[1].value.slval)), {}); delete (yystack_[1].value.slval); }
#line 1319 "./parser.cc" // lalr1.cc:859
    break;

  case 24:
#line 321 "parser.yy" // lalr1.cc:859
    { interp.declare_op = false; }
#line 1325 "./parser.cc" // lalr1.cc:859
    break;

  case 25:
#line 322 "parser.yy" // lalr1.cc:859
    { action(interp.run((yystack_[3].value.ival), *(yystack_[1].value.slval)), {}); delete (yystack_[1].value.slval); }
#line 1331 "./parser.cc" // lalr1.cc:859
    break;

  case 26:
#line 324 "parser.yy" // lalr1.cc:859
    { if (interp.active_namespaces.empty()) {
    action(interp.set_namespace((yystack_[2].value.sval), (yystack_[1].value.ival)), );
  } else
    error(yylloc, "namespace declaration is not permitted here");
}
#line 1341 "./parser.cc" // lalr1.cc:859
    break;

  case 27:
#line 330 "parser.yy" // lalr1.cc:859
    { if (interp.active_namespaces.empty()) {
    action(interp.clear_namespace((yystack_[1].value.ival)), );
  } else
    error(yylloc, "namespace declaration is not permitted here");
}
#line 1351 "./parser.cc" // lalr1.cc:859
    break;

  case 28:
#line 336 "parser.yy" // lalr1.cc:859
    { action(interp.push_namespace(new string(*(yystack_[2].value.sval)), (yystack_[1].value.ival)), ); }
#line 1357 "./parser.cc" // lalr1.cc:859
    break;

  case 29:
#line 338 "parser.yy" // lalr1.cc:859
    { interp.pop_namespace(); delete (yystack_[6].value.sval); }
#line 1363 "./parser.cc" // lalr1.cc:859
    break;

  case 30:
#line 340 "parser.yy" // lalr1.cc:859
    { action(interp.using_namespaces((yystack_[1].value.smlval)), ); }
#line 1369 "./parser.cc" // lalr1.cc:859
    break;

  case 31:
#line 342 "parser.yy" // lalr1.cc:859
    { action(interp.using_namespaces(), ); }
#line 1375 "./parser.cc" // lalr1.cc:859
    break;

  case 32:
#line 343 "parser.yy" // lalr1.cc:859
    { interp.declare_op = false; extern_priv = (yystack_[1].value.ival); }
#line 1381 "./parser.cc" // lalr1.cc:859
    break;

  case 34:
#line 344 "parser.yy" // lalr1.cc:859
    { extern_priv = -1; }
#line 1387 "./parser.cc" // lalr1.cc:859
    break;

  case 36:
#line 346 "parser.yy" // lalr1.cc:859
    { action(interp.inline_code(false, interp.xcode), {}); interp.xcode.clear(); }
#line 1393 "./parser.cc" // lalr1.cc:859
    break;

  case 37:
#line 347 "parser.yy" // lalr1.cc:859
    { interp.declare_op = false; }
#line 1399 "./parser.cc" // lalr1.cc:859
    break;

  case 38:
#line 348 "parser.yy" // lalr1.cc:859
    { action(interp.inline_code((yystack_[2].value.ival), interp.xcode), {}); interp.xcode.clear(); }
#line 1405 "./parser.cc" // lalr1.cc:859
    break;

  case 39:
#line 356 "parser.yy" // lalr1.cc:859
    { (yylhs.value.info) = new sym_info(true, priv_def,(yystack_[0].value.ival),(yystack_[1].value.fix));
			  interp.declare_op = true; }
#line 1412 "./parser.cc" // lalr1.cc:859
    break;

  case 40:
#line 358 "parser.yy" // lalr1.cc:859
    { (yylhs.value.info) = new sym_info(true, priv_def,mpz_get_si(*(yystack_[0].value.zval)),(yystack_[1].value.fix));
			  free((yystack_[0].value.zval)); interp.declare_op = true; }
#line 1419 "./parser.cc" // lalr1.cc:859
    break;

  case 41:
#line 360 "parser.yy" // lalr1.cc:859
    { symbol& sym = interp.symtab.sym((yystack_[1].value.ival));
			  (yylhs.value.info) = new sym_info(true, priv_def,sym.prec,(yystack_[3].value.fix));
			  interp.declare_op = true; }
#line 1427 "./parser.cc" // lalr1.cc:859
    break;

  case 42:
#line 363 "parser.yy" // lalr1.cc:859
    { (yylhs.value.info) = new sym_info(true, priv_def,PREC_MAX,outfix);
			  interp.declare_op = true; }
#line 1434 "./parser.cc" // lalr1.cc:859
    break;

  case 43:
#line 365 "parser.yy" // lalr1.cc:859
    { (yylhs.value.info) = new sym_info(true, priv_def,PREC_MAX,nonfix);
			  interp.declare_op = true; }
#line 1441 "./parser.cc" // lalr1.cc:859
    break;

  case 44:
#line 367 "parser.yy" // lalr1.cc:859
    { (yylhs.value.info) = new sym_info(true, (yystack_[2].value.ival),(yystack_[0].value.ival),(yystack_[1].value.fix));
			  interp.declare_op = true; }
#line 1448 "./parser.cc" // lalr1.cc:859
    break;

  case 45:
#line 369 "parser.yy" // lalr1.cc:859
    { (yylhs.value.info) = new sym_info(true, (yystack_[2].value.ival),mpz_get_si(*(yystack_[0].value.zval)),(yystack_[1].value.fix));
			  free((yystack_[0].value.zval)); interp.declare_op = true; }
#line 1455 "./parser.cc" // lalr1.cc:859
    break;

  case 46:
#line 371 "parser.yy" // lalr1.cc:859
    { symbol& sym = interp.symtab.sym((yystack_[1].value.ival));
			  (yylhs.value.info) = new sym_info(true, (yystack_[4].value.ival),sym.prec,(yystack_[3].value.fix));
			  interp.declare_op = true; }
#line 1463 "./parser.cc" // lalr1.cc:859
    break;

  case 47:
#line 374 "parser.yy" // lalr1.cc:859
    { (yylhs.value.info) = new sym_info(true, (yystack_[1].value.ival),PREC_MAX,outfix); }
#line 1469 "./parser.cc" // lalr1.cc:859
    break;

  case 48:
#line 375 "parser.yy" // lalr1.cc:859
    { (yylhs.value.info) = new sym_info(true, (yystack_[1].value.ival),PREC_MAX,nonfix); }
#line 1475 "./parser.cc" // lalr1.cc:859
    break;

  case 49:
#line 376 "parser.yy" // lalr1.cc:859
    { (yylhs.value.info) = new sym_info(false, (yystack_[0].value.ival),PREC_MAX,infix); }
#line 1481 "./parser.cc" // lalr1.cc:859
    break;

  case 50:
#line 380 "parser.yy" // lalr1.cc:859
    { (yylhs.value.ival) = (yystack_[0].value.xval)->tag(); delete (yystack_[0].value.xval); }
#line 1487 "./parser.cc" // lalr1.cc:859
    break;

  case 51:
#line 381 "parser.yy" // lalr1.cc:859
    { (yylhs.value.ival) = (yystack_[0].value.xval)->tag(); delete (yystack_[0].value.xval); }
#line 1493 "./parser.cc" // lalr1.cc:859
    break;

  case 52:
#line 382 "parser.yy" // lalr1.cc:859
    { (yylhs.value.ival) = (yystack_[0].value.xval)->tag(); delete (yystack_[0].value.xval); }
#line 1499 "./parser.cc" // lalr1.cc:859
    break;

  case 53:
#line 383 "parser.yy" // lalr1.cc:859
    { (yylhs.value.ival) = (yystack_[0].value.xval)->tag(); delete (yystack_[0].value.xval); }
#line 1505 "./parser.cc" // lalr1.cc:859
    break;

  case 54:
#line 384 "parser.yy" // lalr1.cc:859
    { (yylhs.value.ival) = (yystack_[0].value.xval)->tag(); delete (yystack_[0].value.xval); }
#line 1511 "./parser.cc" // lalr1.cc:859
    break;

  case 55:
#line 388 "parser.yy" // lalr1.cc:859
    { (yylhs.value.ival) = false; interp.declare_op = true; }
#line 1517 "./parser.cc" // lalr1.cc:859
    break;

  case 56:
#line 389 "parser.yy" // lalr1.cc:859
    { (yylhs.value.ival) = true;  interp.declare_op = true; }
#line 1523 "./parser.cc" // lalr1.cc:859
    break;

  case 57:
#line 394 "parser.yy" // lalr1.cc:859
    { (yylhs.value.slval) = new list<string>; (yylhs.value.slval)->push_back(*(yystack_[0].value.sval)); delete (yystack_[0].value.sval); }
#line 1529 "./parser.cc" // lalr1.cc:859
    break;

  case 58:
#line 396 "parser.yy" // lalr1.cc:859
    { (yylhs.value.slval) = (yystack_[1].value.slval); (yylhs.value.slval)->push_back(*(yystack_[0].value.sval)); delete (yystack_[0].value.sval); }
#line 1535 "./parser.cc" // lalr1.cc:859
    break;

  case 59:
#line 401 "parser.yy" // lalr1.cc:859
    { (yylhs.value.slval) = new list<string>; (yylhs.value.slval)->push_back(*(yystack_[0].value.sval)); delete (yystack_[0].value.sval); }
#line 1541 "./parser.cc" // lalr1.cc:859
    break;

  case 60:
#line 403 "parser.yy" // lalr1.cc:859
    { (yylhs.value.slval) = (yystack_[2].value.slval); (yylhs.value.slval)->push_back(*(yystack_[0].value.sval)); delete (yystack_[0].value.sval); }
#line 1547 "./parser.cc" // lalr1.cc:859
    break;

  case 61:
#line 407 "parser.yy" // lalr1.cc:859
    { (yylhs.value.sval) = (yystack_[0].value.sval); mangle_fname(*(yylhs.value.sval)); }
#line 1553 "./parser.cc" // lalr1.cc:859
    break;

  case 62:
#line 408 "parser.yy" // lalr1.cc:859
    { char *s = fromutf8((yystack_[0].value.csval)); free((yystack_[0].value.csval));
			  (yylhs.value.sval) = new string(s); free(s); }
#line 1560 "./parser.cc" // lalr1.cc:859
    break;

  case 63:
#line 413 "parser.yy" // lalr1.cc:859
    { (yylhs.value.ival) = 0; }
#line 1566 "./parser.cc" // lalr1.cc:859
    break;

  case 64:
#line 414 "parser.yy" // lalr1.cc:859
    { interp.xsym_prefix = 0; }
#line 1572 "./parser.cc" // lalr1.cc:859
    break;

  case 65:
#line 415 "parser.yy" // lalr1.cc:859
    { int32_t g = interp.symtab.sym((yystack_[2].value.ival)).g;
			  if (g != 0 && g == (yystack_[1].value.ival))
			    (yylhs.value.ival) = (yystack_[2].value.ival);
			  else {
			    string msg;
			    if (g == 0) {
			      string id = interp.symtab.sym((yystack_[2].value.ival)).s;
			      msg = "syntax error, unexpected '"+id+
				"', expecting outfix operator";
			    } else {
			      string id = interp.symtab.sym((yystack_[1].value.ival)).s;
			      string rid = interp.symtab.sym(g).s;
			      msg = "syntax error, unexpected '"+id+
				"', expecting '"+rid+"'";
			    }
			    interp.error(yyloc, msg);
			    YYERROR;
			  } }
#line 1595 "./parser.cc" // lalr1.cc:859
    break;

  case 66:
#line 437 "parser.yy" // lalr1.cc:859
    { (yylhs.value.smlval) = new list< pair< string, list<int32_t> > >;
  (yylhs.value.smlval)->push_back(*(yystack_[0].value.smval)); delete (yystack_[0].value.smval); }
#line 1602 "./parser.cc" // lalr1.cc:859
    break;

  case 67:
#line 440 "parser.yy" // lalr1.cc:859
    { (yylhs.value.smlval) = (yystack_[2].value.smlval); (yylhs.value.smlval)->push_back(*(yystack_[0].value.smval)); delete (yystack_[0].value.smval); }
#line 1608 "./parser.cc" // lalr1.cc:859
    break;

  case 68:
#line 445 "parser.yy" // lalr1.cc:859
    { (yylhs.value.smval) = new pair< string, list<int32_t> >(*(yystack_[0].value.sval), list<int32_t>()); delete (yystack_[0].value.sval); }
#line 1614 "./parser.cc" // lalr1.cc:859
    break;

  case 69:
#line 446 "parser.yy" // lalr1.cc:859
    { interp.xsym_prefix = (yystack_[1].value.sval); }
#line 1620 "./parser.cc" // lalr1.cc:859
    break;

  case 70:
#line 447 "parser.yy" // lalr1.cc:859
    { (yylhs.value.smval) = new pair< string, list<int32_t> >(*(yystack_[4].value.sval), *(yystack_[1].value.ilval)); delete (yystack_[4].value.sval); delete (yystack_[1].value.ilval); }
#line 1626 "./parser.cc" // lalr1.cc:859
    break;

  case 71:
#line 452 "parser.yy" // lalr1.cc:859
    { (yylhs.value.ilval) = new list<int32_t>; (yylhs.value.ilval)->push_back((yystack_[0].value.ival)); }
#line 1632 "./parser.cc" // lalr1.cc:859
    break;

  case 72:
#line 454 "parser.yy" // lalr1.cc:859
    { (yylhs.value.ilval) = (yystack_[1].value.ilval); (yylhs.value.ilval)->push_back((yystack_[0].value.ival)); }
#line 1638 "./parser.cc" // lalr1.cc:859
    break;

  case 73:
#line 459 "parser.yy" // lalr1.cc:859
    { (yylhs.value.sval) = (yystack_[0].value.sval); if ((yylhs.value.sval)->compare(0, 2, "::") == 0) (yylhs.value.sval)->erase(0, 2); }
#line 1644 "./parser.cc" // lalr1.cc:859
    break;

  case 74:
#line 461 "parser.yy" // lalr1.cc:859
    { (yylhs.value.sval) = new string((yystack_[0].value.csval)); free((yystack_[0].value.csval));
  if ((yylhs.value.sval)->compare(0, 2, "::") == 0) (yylhs.value.sval)->erase(0, 2); }
#line 1651 "./parser.cc" // lalr1.cc:859
    break;

  case 77:
#line 472 "parser.yy" // lalr1.cc:859
    { action(interp.declare_extern(extern_priv, *(yystack_[4].value.sval), *(yystack_[5].value.sval), (yystack_[2].value.sloval)->second, (yystack_[2].value.sloval)->first,
			       0, *(yystack_[0].value.sval)), {});
  if (interp.tags) interp.add_tags(*(yystack_[4].value.sval), *(yystack_[0].value.sval));
  delete (yystack_[5].value.sval); delete (yystack_[4].value.sval); delete (yystack_[2].value.sloval); delete (yystack_[0].value.sval); }
#line 1660 "./parser.cc" // lalr1.cc:859
    break;

  case 78:
#line 480 "parser.yy" // lalr1.cc:859
    { (yylhs.value.sloval) = new pair < bool, list<string> >; (yylhs.value.sloval)->first = false; }
#line 1666 "./parser.cc" // lalr1.cc:859
    break;

  case 79:
#line 482 "parser.yy" // lalr1.cc:859
    { (yylhs.value.sloval) = new pair < bool, list<string> >; (yylhs.value.sloval)->first = true; }
#line 1672 "./parser.cc" // lalr1.cc:859
    break;

  case 81:
#line 485 "parser.yy" // lalr1.cc:859
    { (yylhs.value.sloval) = (yystack_[2].value.sloval); (yylhs.value.sloval)->first = true; }
#line 1678 "./parser.cc" // lalr1.cc:859
    break;

  case 82:
#line 490 "parser.yy" // lalr1.cc:859
    { (yylhs.value.sloval) = new pair < bool, list<string> >; (yylhs.value.sloval)->second.push_back(*(yystack_[1].value.sval)); delete (yystack_[1].value.sval); }
#line 1684 "./parser.cc" // lalr1.cc:859
    break;

  case 83:
#line 492 "parser.yy" // lalr1.cc:859
    { (yylhs.value.sloval) = (yystack_[3].value.sloval); (yylhs.value.sloval)->second.push_back(*(yystack_[1].value.sval)); delete (yystack_[1].value.sval); }
#line 1690 "./parser.cc" // lalr1.cc:859
    break;

  case 85:
#line 497 "parser.yy" // lalr1.cc:859
    { (yylhs.value.sval) = (yystack_[1].value.sval); *(yylhs.value.sval) += "*"; }
#line 1696 "./parser.cc" // lalr1.cc:859
    break;

  case 87:
#line 502 "parser.yy" // lalr1.cc:859
    { delete (yystack_[0].value.sval); }
#line 1702 "./parser.cc" // lalr1.cc:859
    break;

  case 88:
#line 506 "parser.yy" // lalr1.cc:859
    { (yylhs.value.sval) = new string; }
#line 1708 "./parser.cc" // lalr1.cc:859
    break;

  case 89:
#line 507 "parser.yy" // lalr1.cc:859
    { (yylhs.value.sval) = (yystack_[0].value.sval); }
#line 1714 "./parser.cc" // lalr1.cc:859
    break;

  case 90:
#line 517 "parser.yy" // lalr1.cc:859
    { parser_action((yylhs.value.xval) = interp.mksimple_expr((yystack_[0].value.opstk)), delete (yystack_[0].value.opstk)); }
#line 1720 "./parser.cc" // lalr1.cc:859
    break;

  case 91:
#line 519 "parser.yy" // lalr1.cc:859
    { try { (yylhs.value.xval) = interp.mklambda_expr((yystack_[2].value.xlval), (yystack_[0].value.xval)); }
  catch (err &e) { interp.error(yyloc, e.what()); (yylhs.value.xval) = new dummy_expr; } }
#line 1727 "./parser.cc" // lalr1.cc:859
    break;

  case 92:
#line 522 "parser.yy" // lalr1.cc:859
    { try { (yylhs.value.xval) = interp.mkcase_expr((yystack_[3].value.xval), new rulel((yystack_[1].value.prinfo)->rl)); delete (yystack_[1].value.prinfo); }
  catch (err &e) { interp.error(yyloc, e.what()); delete (yystack_[1].value.prinfo); (yylhs.value.xval) = new dummy_expr; } }
#line 1734 "./parser.cc" // lalr1.cc:859
    break;

  case 93:
#line 525 "parser.yy" // lalr1.cc:859
    { try { (yylhs.value.xval) = interp.mkwhen_expr((yystack_[3].value.xval), (yystack_[1].value.rlval)); }
  catch (err &e) { interp.error(yyloc, e.what()); (yylhs.value.xval) = new dummy_expr; } }
#line 1741 "./parser.cc" // lalr1.cc:859
    break;

  case 94:
#line 528 "parser.yy" // lalr1.cc:859
    { try { (yylhs.value.xval) = interp.mkwith_expr((yystack_[3].value.xval), new env((yystack_[1].value.rinfo)->e)); delete (yystack_[1].value.rinfo); }
  catch (err &e) { interp.error(yyloc, e.what()); delete (yystack_[1].value.rinfo); (yylhs.value.xval) = new dummy_expr; } }
#line 1748 "./parser.cc" // lalr1.cc:859
    break;

  case 95:
#line 531 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xval) = interp.mkcond_expr((yystack_[4].value.xval), (yystack_[2].value.xval), (yystack_[0].value.xval)); }
#line 1754 "./parser.cc" // lalr1.cc:859
    break;

  case 96:
#line 536 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xlval) = new exprl; (yylhs.value.xlval)->push_back(*(yystack_[0].value.xval)); delete (yystack_[0].value.xval); }
#line 1760 "./parser.cc" // lalr1.cc:859
    break;

  case 97:
#line 538 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xlval) = (yystack_[1].value.xlval); (yylhs.value.xlval)->push_back(*(yystack_[0].value.xval)); delete (yystack_[0].value.xval); }
#line 1766 "./parser.cc" // lalr1.cc:859
    break;

  case 98:
#line 547 "parser.yy" // lalr1.cc:859
    { (yylhs.value.opstk) = (new OpStack())->push_arg((yystack_[0].value.xval)); }
#line 1772 "./parser.cc" // lalr1.cc:859
    break;

  case 99:
#line 548 "parser.yy" // lalr1.cc:859
    { (yylhs.value.opstk) = (new OpStack())->push_op((yystack_[0].value.xval)); }
#line 1778 "./parser.cc" // lalr1.cc:859
    break;

  case 100:
#line 549 "parser.yy" // lalr1.cc:859
    { (yylhs.value.opstk) = (yystack_[1].value.opstk)->push_arg((yystack_[0].value.xval)); }
#line 1784 "./parser.cc" // lalr1.cc:859
    break;

  case 101:
#line 550 "parser.yy" // lalr1.cc:859
    { (yylhs.value.opstk) = (yystack_[1].value.opstk)->push_op((yystack_[0].value.xval)); }
#line 1790 "./parser.cc" // lalr1.cc:859
    break;

  case 102:
#line 551 "parser.yy" // lalr1.cc:859
    { (yylhs.value.opstk) = (yystack_[1].value.opstk)->push_op((yystack_[0].value.xval)); }
#line 1796 "./parser.cc" // lalr1.cc:859
    break;

  case 103:
#line 552 "parser.yy" // lalr1.cc:859
    { (yylhs.value.opstk) = (yystack_[1].value.opstk)->push_op((yystack_[0].value.xval)); }
#line 1802 "./parser.cc" // lalr1.cc:859
    break;

  case 104:
#line 553 "parser.yy" // lalr1.cc:859
    { (yylhs.value.opstk) = (yystack_[1].value.opstk)->push_op((yystack_[0].value.xval)); }
#line 1808 "./parser.cc" // lalr1.cc:859
    break;

  case 105:
#line 554 "parser.yy" // lalr1.cc:859
    { (yylhs.value.opstk) = (yystack_[1].value.opstk)->push_op((yystack_[0].value.xval)); }
#line 1814 "./parser.cc" // lalr1.cc:859
    break;

  case 106:
#line 560 "parser.yy" // lalr1.cc:859
    { try { (yylhs.value.xval) = interp.mksym_expr((yystack_[0].value.sval)); }
			  catch (err &e) {
			    interp.error(yyloc, e.what());
			    (yylhs.value.xval) = new dummy_expr;
			  } }
#line 1824 "./parser.cc" // lalr1.cc:859
    break;

  case 107:
#line 565 "parser.yy" // lalr1.cc:859
    { try { (yylhs.value.xval) = interp.mksym_expr((yystack_[1].value.sval), (yystack_[0].value.ival)); }
			  catch (err &e) {
			    interp.error(yyloc, e.what());
			    (yylhs.value.xval) = new dummy_expr;
			  } }
#line 1834 "./parser.cc" // lalr1.cc:859
    break;

  case 108:
#line 570 "parser.yy" // lalr1.cc:859
    { try { (yylhs.value.xval) = interp.mkas_expr((yystack_[2].value.sval), (yystack_[0].value.xval)); }
			  catch (err &e) {
			    interp.error(yyloc, e.what());
			    (yylhs.value.xval) = (yystack_[0].value.xval);
			  } }
#line 1844 "./parser.cc" // lalr1.cc:859
    break;

  case 109:
#line 575 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xval) = new expr(EXPR::INT, (yystack_[0].value.ival)); }
#line 1850 "./parser.cc" // lalr1.cc:859
    break;

  case 110:
#line 576 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xval) = new expr(EXPR::BIGINT, *(yystack_[0].value.zval), true); free((yystack_[0].value.zval)); }
#line 1856 "./parser.cc" // lalr1.cc:859
    break;

  case 111:
#line 577 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xval) = new expr(EXPR::BIGINT, *(yystack_[0].value.zval)); free((yystack_[0].value.zval)); }
#line 1862 "./parser.cc" // lalr1.cc:859
    break;

  case 112:
#line 578 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xval) = new expr(EXPR::DBL, (yystack_[0].value.dval)); }
#line 1868 "./parser.cc" // lalr1.cc:859
    break;

  case 113:
#line 579 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xval) = new expr(EXPR::STR, (yystack_[0].value.csval)); }
#line 1874 "./parser.cc" // lalr1.cc:859
    break;

  case 114:
#line 580 "parser.yy" // lalr1.cc:859
    { int32_t g = interp.symtab.sym((yystack_[2].value.xval)->tag()).g;
			  assert(g != 0);
			  if (g == (yystack_[0].value.xval)->tag()) {
			    if (interp.symtab.sym((yystack_[2].value.xval)->tag()).ns) {
			      // special namespace bracket
			      delete (yystack_[2].value.xval);
			      (yylhs.value.xval) = (yystack_[1].value.xval);
			      interp.symtab.pop_namespace();
			    } else
			      (yylhs.value.xval) = interp.mkexpr((yystack_[2].value.xval), (yystack_[1].value.xval));
			    delete (yystack_[0].value.xval);
			  } else {
			    string id = interp.symtab.sym((yystack_[0].value.xval)->tag()).s;
			    string rid = interp.symtab.sym(g).s;
			    string msg = "syntax error, unexpected '"+id+
			      "', expecting '"+rid+"'";
			    interp.error(yyloc, msg);
			    YYERROR;
			  } }
#line 1898 "./parser.cc" // lalr1.cc:859
    break;

  case 115:
#line 599 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xval) = new expr(EXPR::MATRIX, (yystack_[1].value.xllval)); }
#line 1904 "./parser.cc" // lalr1.cc:859
    break;

  case 116:
#line 601 "parser.yy" // lalr1.cc:859
    { try { (yylhs.value.xval) = interp.mkmatcomp_expr((yystack_[3].value.xval), (yystack_[1].value.clauselval)); }
			  catch (err &e) {
			    interp.error(yyloc, e.what());
			    (yylhs.value.xval) = new dummy_expr;
			  } }
#line 1914 "./parser.cc" // lalr1.cc:859
    break;

  case 117:
#line 606 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xval) = interp.mklist_expr((yystack_[1].value.xval)); }
#line 1920 "./parser.cc" // lalr1.cc:859
    break;

  case 118:
#line 607 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xval) = new expr(interp.symtab.nil_sym().f); }
#line 1926 "./parser.cc" // lalr1.cc:859
    break;

  case 119:
#line 609 "parser.yy" // lalr1.cc:859
    { try { (yylhs.value.xval) = interp.mklistcomp_expr((yystack_[3].value.xval), (yystack_[1].value.clauselval)); }
			  catch (err &e) {
			    interp.error(yyloc, e.what());
			    (yylhs.value.xval) = new dummy_expr;
			  } }
#line 1936 "./parser.cc" // lalr1.cc:859
    break;

  case 120:
#line 614 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xval) = (yystack_[1].value.xval);
			  if ((yylhs.value.xval)->is_pair()) (yylhs.value.xval)->flags() |= EXPR::PAREN; }
#line 1943 "./parser.cc" // lalr1.cc:859
    break;

  case 121:
#line 616 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xval) = new expr(interp.symtab.void_sym().f); }
#line 1949 "./parser.cc" // lalr1.cc:859
    break;

  case 122:
#line 617 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xval) = (yystack_[1].value.xval); }
#line 1955 "./parser.cc" // lalr1.cc:859
    break;

  case 123:
#line 618 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xval) = (yystack_[1].value.xval); }
#line 1961 "./parser.cc" // lalr1.cc:859
    break;

  case 124:
#line 619 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xval) = (yystack_[1].value.xval); }
#line 1967 "./parser.cc" // lalr1.cc:859
    break;

  case 125:
#line 620 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xval) = (yystack_[1].value.xval); }
#line 1973 "./parser.cc" // lalr1.cc:859
    break;

  case 126:
#line 621 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xval) = (yystack_[1].value.xval); }
#line 1979 "./parser.cc" // lalr1.cc:859
    break;

  case 127:
#line 622 "parser.yy" // lalr1.cc:859
    { int32_t g = interp.symtab.sym((yystack_[2].value.xval)->tag()).g;
			  assert(g != 0);
			  if (g == (yystack_[1].value.xval)->tag()) {
			    (yylhs.value.xval) = (yystack_[2].value.xval);
			    delete (yystack_[1].value.xval);
			  } else {
			    string id = interp.symtab.sym((yystack_[1].value.xval)->tag()).s;
			    string rid = interp.symtab.sym(g).s;
			    string msg = "syntax error, unexpected '"+id+
			      "', expecting '"+rid+"'";
			    interp.error(yyloc, msg);
			    YYERROR;
			  } }
#line 1997 "./parser.cc" // lalr1.cc:859
    break;

  case 128:
#line 640 "parser.yy" // lalr1.cc:859
    { expr *x; parser_action(x = interp.mksimple_expr((yystack_[2].value.opstk)),
			 (delete (yystack_[2].value.opstk), delete (yystack_[1].value.xval)));
  (yylhs.value.xval) = interp.mklsect((yystack_[1].value.xval), x); }
#line 2005 "./parser.cc" // lalr1.cc:859
    break;

  case 129:
#line 644 "parser.yy" // lalr1.cc:859
    { expr *x; parser_action(x = interp.mksimple_expr((yystack_[2].value.opstk)),
			 (delete (yystack_[2].value.opstk), delete (yystack_[1].value.xval)));
  (yylhs.value.xval) = interp.mklsect((yystack_[1].value.xval), x); }
#line 2013 "./parser.cc" // lalr1.cc:859
    break;

  case 130:
#line 648 "parser.yy" // lalr1.cc:859
    { expr *x; parser_action(x = interp.mksimple_expr((yystack_[2].value.opstk)),
			 (delete (yystack_[2].value.opstk), delete (yystack_[1].value.xval)));
  (yylhs.value.xval) = interp.mklsect((yystack_[1].value.xval), x); }
#line 2021 "./parser.cc" // lalr1.cc:859
    break;

  case 131:
#line 652 "parser.yy" // lalr1.cc:859
    { expr *x; parser_action(x = interp.mksimple_expr((yystack_[2].value.opstk)),
			 (delete (yystack_[2].value.opstk), delete (yystack_[1].value.xval)));
  (yylhs.value.xval) = interp.mklsect((yystack_[1].value.xval), x); }
#line 2029 "./parser.cc" // lalr1.cc:859
    break;

  case 132:
#line 659 "parser.yy" // lalr1.cc:859
    { expr *x; parser_action(x = interp.mksimple_expr((yystack_[1].value.opstk)),
			 (delete (yystack_[2].value.xval), delete (yystack_[1].value.opstk)));
  (yylhs.value.xval) = interp.mkrsect((yystack_[2].value.xval), x); }
#line 2037 "./parser.cc" // lalr1.cc:859
    break;

  case 133:
#line 663 "parser.yy" // lalr1.cc:859
    { expr *x; parser_action(x = interp.mksimple_expr((yystack_[1].value.opstk)),
			 (delete (yystack_[2].value.xval), delete (yystack_[1].value.opstk)));
  (yylhs.value.xval) = interp.mkrsect((yystack_[2].value.xval), x); }
#line 2045 "./parser.cc" // lalr1.cc:859
    break;

  case 134:
#line 667 "parser.yy" // lalr1.cc:859
    { expr *x; parser_action(x = interp.mksimple_expr((yystack_[1].value.opstk)),
			 (delete (yystack_[2].value.xval), delete (yystack_[1].value.opstk)));
  (yylhs.value.xval) = interp.mkrsect((yystack_[2].value.xval), x); }
#line 2053 "./parser.cc" // lalr1.cc:859
    break;

  case 136:
#line 675 "parser.yy" // lalr1.cc:859
    { (yylhs.value.clauselval) = (yystack_[1].value.clauselval); }
#line 2059 "./parser.cc" // lalr1.cc:859
    break;

  case 137:
#line 680 "parser.yy" // lalr1.cc:859
    { (yylhs.value.clauselval) = new comp_clause_list; (yylhs.value.clauselval)->push_back(*(yystack_[0].value.clauseval)); delete (yystack_[0].value.clauseval); }
#line 2065 "./parser.cc" // lalr1.cc:859
    break;

  case 138:
#line 682 "parser.yy" // lalr1.cc:859
    { (yylhs.value.clauselval) = (yystack_[2].value.clauselval); (yylhs.value.clauselval)->push_back(*(yystack_[0].value.clauseval)); delete (yystack_[0].value.clauseval); }
#line 2071 "./parser.cc" // lalr1.cc:859
    break;

  case 139:
#line 687 "parser.yy" // lalr1.cc:859
    { (yylhs.value.clauseval) = new comp_clause(*(yystack_[0].value.xval), expr()); delete (yystack_[0].value.xval); }
#line 2077 "./parser.cc" // lalr1.cc:859
    break;

  case 140:
#line 689 "parser.yy" // lalr1.cc:859
    { (yylhs.value.clauseval) = new comp_clause(*(yystack_[2].value.xval), *(yystack_[0].value.xval)); delete (yystack_[2].value.xval); delete (yystack_[0].value.xval); }
#line 2083 "./parser.cc" // lalr1.cc:859
    break;

  case 142:
#line 694 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xllval) = (yystack_[1].value.xllval); }
#line 2089 "./parser.cc" // lalr1.cc:859
    break;

  case 143:
#line 695 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xllval) = new exprll; }
#line 2095 "./parser.cc" // lalr1.cc:859
    break;

  case 144:
#line 700 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xllval) = new exprll; (yylhs.value.xllval)->push_back(*(yystack_[0].value.xlval)); delete (yystack_[0].value.xlval); }
#line 2101 "./parser.cc" // lalr1.cc:859
    break;

  case 145:
#line 702 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xllval) = (yystack_[2].value.xllval); (yylhs.value.xllval)->push_back(*(yystack_[0].value.xlval)); delete (yystack_[0].value.xlval); }
#line 2107 "./parser.cc" // lalr1.cc:859
    break;

  case 146:
#line 706 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xlval) = interp.mkrow_exprl((yystack_[0].value.xval)); }
#line 2113 "./parser.cc" // lalr1.cc:859
    break;

  case 147:
#line 717 "parser.yy" // lalr1.cc:859
    { (yylhs.value.rlval) = new rulel;
  for (exprl::iterator l = (yystack_[2].value.xlval)->begin(), end = (yystack_[2].value.xlval)->end(); l != end; l++)
    (yylhs.value.rlval)->push_back(rule(*l, (yystack_[0].value.rhsval)->rhs(), (yystack_[0].value.rhsval)->qual()));
  delete (yystack_[2].value.xlval); delete (yystack_[0].value.rhsval); }
#line 2122 "./parser.cc" // lalr1.cc:859
    break;

  case 148:
#line 722 "parser.yy" // lalr1.cc:859
    { (yylhs.value.rlval) = new rulel(1, rule(expr(), (yystack_[0].value.rhsval)->rhs(), (yystack_[0].value.rhsval)->qual())); delete (yystack_[0].value.rhsval); }
#line 2128 "./parser.cc" // lalr1.cc:859
    break;

  case 149:
#line 727 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xlval) = new exprl; (yylhs.value.xlval)->push_back(*(yystack_[0].value.xval)); delete (yystack_[0].value.xval); }
#line 2134 "./parser.cc" // lalr1.cc:859
    break;

  case 150:
#line 729 "parser.yy" // lalr1.cc:859
    { (yylhs.value.xlval) = (yystack_[2].value.xlval); (yylhs.value.xlval)->push_back(*(yystack_[0].value.xval)); delete (yystack_[0].value.xval); }
#line 2140 "./parser.cc" // lalr1.cc:859
    break;

  case 151:
#line 733 "parser.yy" // lalr1.cc:859
    { (yylhs.value.rhsval) = new rhs_info((yystack_[0].value.xval)); }
#line 2146 "./parser.cc" // lalr1.cc:859
    break;

  case 153:
#line 738 "parser.yy" // lalr1.cc:859
    { (yylhs.value.rhsval) = new rhs_info((yystack_[1].value.xval)); }
#line 2152 "./parser.cc" // lalr1.cc:859
    break;

  case 154:
#line 740 "parser.yy" // lalr1.cc:859
    { expr *x; parser_action(x = interp.mksimple_expr((yystack_[0].value.opstk)),
			 (delete (yystack_[2].value.xval), delete (yystack_[0].value.opstk)));
  (yylhs.value.rhsval) = new rhs_info((yystack_[2].value.xval), x); }
#line 2160 "./parser.cc" // lalr1.cc:859
    break;

  case 155:
#line 744 "parser.yy" // lalr1.cc:859
    { (yylhs.value.rhsval) = (yystack_[3].value.rhsval);
  if ((yylhs.value.rhsval)->q) {
    (yylhs.value.rhsval)->r = interp.mkcond1_expr((yylhs.value.rhsval)->q, (yylhs.value.rhsval)->r); (yylhs.value.rhsval)->q = 0;
  }
  try {
    expr *x = interp.mkwhen_expr((yylhs.value.rhsval)->r, (yystack_[1].value.rlval));
    (yylhs.value.rhsval)->r = x;
  } catch (err &e) {
    interp.error(yyloc, e.what());
  }
}
#line 2176 "./parser.cc" // lalr1.cc:859
    break;

  case 156:
#line 756 "parser.yy" // lalr1.cc:859
    { (yylhs.value.rhsval) = (yystack_[3].value.rhsval);
  if ((yylhs.value.rhsval)->q) {
    (yylhs.value.rhsval)->r = interp.mkcond1_expr((yylhs.value.rhsval)->q, (yylhs.value.rhsval)->r); (yylhs.value.rhsval)->q = 0;
  }
  try {
    expr *x = interp.mkwith_expr((yylhs.value.rhsval)->r, new env((yystack_[1].value.rinfo)->e)); delete (yystack_[1].value.rinfo);
    (yylhs.value.rhsval)->r = x;
  } catch (err &e) {
    interp.error(yyloc, e.what());
  }
}
#line 2192 "./parser.cc" // lalr1.cc:859
    break;

  case 158:
#line 771 "parser.yy" // lalr1.cc:859
    { (yylhs.value.rinfo) = (yystack_[1].value.rinfo); }
#line 2198 "./parser.cc" // lalr1.cc:859
    break;

  case 159:
#line 776 "parser.yy" // lalr1.cc:859
    { (yylhs.value.rinfo) = new rule_info;
  rulel *rl = 0;
  try {
    rl = interp.default_lhs((yylhs.value.rinfo)->l, (yystack_[0].value.rlval));
    interp.add_rules((yylhs.value.rinfo)->e, rl);
  }
  catch (err &e) { if (rl) delete rl; interp.error(yyloc, e.what()); } }
#line 2210 "./parser.cc" // lalr1.cc:859
    break;

  case 160:
#line 784 "parser.yy" // lalr1.cc:859
    { (yylhs.value.rinfo) = (yystack_[2].value.rinfo);
  rulel *rl = 0;
  try {
    rl = interp.default_lhs((yylhs.value.rinfo)->l, (yystack_[0].value.rlval));
    interp.add_rules((yylhs.value.rinfo)->e, rl);
  }
  catch (err &e) { if (rl) delete rl; interp.error(yyloc, e.what()); } }
#line 2222 "./parser.cc" // lalr1.cc:859
    break;

  case 162:
#line 797 "parser.yy" // lalr1.cc:859
    { (yylhs.value.prinfo) = (yystack_[1].value.prinfo); }
#line 2228 "./parser.cc" // lalr1.cc:859
    break;

  case 163:
#line 802 "parser.yy" // lalr1.cc:859
    { (yylhs.value.prinfo) = new pat_rule_info;
  rulel *rl = 0;
  try {
    rl = interp.default_lhs((yylhs.value.prinfo)->l, (yystack_[0].value.rlval));
    interp.add_rules((yylhs.value.prinfo)->rl, rl, true);
  }
  catch (err &e) { if (rl) delete rl; interp.error(yyloc, e.what()); } }
#line 2240 "./parser.cc" // lalr1.cc:859
    break;

  case 164:
#line 810 "parser.yy" // lalr1.cc:859
    { (yylhs.value.prinfo) = (yystack_[2].value.prinfo);
  rulel *rl = 0;
  try {
    rl = interp.default_lhs((yylhs.value.prinfo)->l, (yystack_[0].value.rlval));
    interp.add_rules((yylhs.value.prinfo)->rl, rl, true);
  }
  catch (err &e) { if (rl) delete rl; interp.error(yyloc, e.what()); } }
#line 2252 "./parser.cc" // lalr1.cc:859
    break;

  case 165:
#line 824 "parser.yy" // lalr1.cc:859
    { (yylhs.value.rval) = new rule(*(yystack_[2].value.xval), *(yystack_[0].value.xval)); delete (yystack_[2].value.xval); delete (yystack_[0].value.xval); }
#line 2258 "./parser.cc" // lalr1.cc:859
    break;

  case 166:
#line 826 "parser.yy" // lalr1.cc:859
    { expr *x = new expr(interp.symtab.anon_sym);
  (yylhs.value.rval) = new rule(*x, *(yystack_[0].value.xval)); delete x; delete (yystack_[0].value.xval); }
#line 2265 "./parser.cc" // lalr1.cc:859
    break;

  case 168:
#line 832 "parser.yy" // lalr1.cc:859
    { (yylhs.value.rlval) = (yystack_[1].value.rlval); }
#line 2271 "./parser.cc" // lalr1.cc:859
    break;

  case 169:
#line 837 "parser.yy" // lalr1.cc:859
    { (yylhs.value.rlval) = new rulel; try { interp.add_simple_rule(*(yylhs.value.rlval), (yystack_[0].value.rval)); }
  catch (err &e) { interp.error(yyloc, e.what()); } }
#line 2278 "./parser.cc" // lalr1.cc:859
    break;

  case 170:
#line 840 "parser.yy" // lalr1.cc:859
    { (yylhs.value.rlval) = (yystack_[2].value.rlval); try { interp.add_simple_rule(*(yylhs.value.rlval), (yystack_[0].value.rval)); }
  catch (err &e) { interp.error(yyloc, e.what()); } }
#line 2285 "./parser.cc" // lalr1.cc:859
    break;

  case 171:
#line 851 "parser.yy" // lalr1.cc:859
    { (yylhs.value.rlval) = new rulel;
  for (exprl::iterator l = (yystack_[0].value.xlval)->begin(), end = (yystack_[0].value.xlval)->end(); l != end; l++) {
    if (l->is_fun()) {
      // Just declare the symbol so that the compiler knows about it.
      // This will promote the symbol to the proper namespace if it hasn't
      // been declared yet.
      interp.checkvars(*l);
      interp.symtab.sym(l->tag()).unresolved = false;
      if ((interp.verbose&verbosity::defs) != 0)
	cout << "type " << *l << ";\n";
      interp.typeenv[l->tag()];
    } else
      // assume rhs = true
      (yylhs.value.rlval)->push_back(rule(*l, expr(EXPR::INT, 1)));
  }
  delete (yystack_[0].value.xlval); }
#line 2306 "./parser.cc" // lalr1.cc:859
    break;

  case 172:
#line 868 "parser.yy" // lalr1.cc:859
    { (yylhs.value.rlval) = new rulel;
  for (exprl::iterator l = (yystack_[2].value.xlval)->begin(), end = (yystack_[2].value.xlval)->end(); l != end; l++)
    (yylhs.value.rlval)->push_back(rule(*l, (yystack_[0].value.rhsval)->rhs(), (yystack_[0].value.rhsval)->qual()));
  delete (yystack_[2].value.xlval); delete (yystack_[0].value.rhsval); }
#line 2315 "./parser.cc" // lalr1.cc:859
    break;

  case 173:
#line 879 "parser.yy" // lalr1.cc:859
    { (yylhs.value.rlval) = new rulel;
  for (exprl::iterator l = (yystack_[2].value.xlval)->begin(), end = (yystack_[2].value.xlval)->end(); l != end; l++)
    (yylhs.value.rlval)->push_back(rule(*l, *(yystack_[0].value.xval)));
  delete (yystack_[2].value.xlval); delete (yystack_[0].value.xval); }
#line 2324 "./parser.cc" // lalr1.cc:859
    break;

  case 174:
#line 894 "parser.yy" // lalr1.cc:859
    { (yylhs.value.ival) = 0; }
#line 2330 "./parser.cc" // lalr1.cc:859
    break;

  case 175:
#line 896 "parser.yy" // lalr1.cc:859
    { interp.loc = &yyloc;
  int32_t tag = (yystack_[2].value.ival), count = 0;
  if (tag) {
    action((interp.add_interface_rule(interp.typeenv, tag, *(yystack_[0].value.xval)), count++), );
  }
  (yylhs.value.ival) = count;
}
#line 2342 "./parser.cc" // lalr1.cc:859
    break;

  case 176:
#line 904 "parser.yy" // lalr1.cc:859
    { (yylhs.value.ival) = (yystack_[3].value.ival)+(yystack_[1].value.ival); delete (yystack_[2].value.xval); }
#line 2348 "./parser.cc" // lalr1.cc:859
    break;

  case 177:
#line 906 "parser.yy" // lalr1.cc:859
    { const symbol &sym = interp.symtab.checksym(*(yystack_[0].value.sval));
  interp.loc = &yyloc;
  int32_t tag = (yystack_[3].value.ival), iface = sym.f, count = 0;
  if (tag) {
    action((count = interp.add_sub_interface(interp.typeenv, tag, iface)), );
  }
  (yylhs.value.ival) = count;
}
#line 2361 "./parser.cc" // lalr1.cc:859
    break;

  case 178:
#line 915 "parser.yy" // lalr1.cc:859
    { (yylhs.value.ival) = (yystack_[4].value.ival)+(yystack_[1].value.ival); delete (yystack_[2].value.sval); }
#line 2367 "./parser.cc" // lalr1.cc:859
    break;


#line 2371 "./parser.cc" // lalr1.cc:859
            default:
              break;
            }
        }
      catch (const syntax_error& yyexc)
        {
          error (yyexc);
          YYERROR;
        }
      YY_SYMBOL_PRINT ("-> $$ =", yylhs);
      yypop_ (yylen);
      yylen = 0;
      YY_STACK_PRINT ();

      // Shift the result of the reduction.
      yypush_ (YY_NULLPTR, yylhs);
    }
    goto yynewstate;

  /*--------------------------------------.
  | yyerrlab -- here on detecting error.  |
  `--------------------------------------*/
  yyerrlab:
    // If not already recovering from an error, report this error.
    if (!yyerrstatus_)
      {
        ++yynerrs_;
        error (yyla.location, yysyntax_error_ (yystack_[0].state, yyla));
      }


    yyerror_range[1].location = yyla.location;
    if (yyerrstatus_ == 3)
      {
        /* If just tried and failed to reuse lookahead token after an
           error, discard it.  */

        // Return failure if at end of input.
        if (yyla.type_get () == yyeof_)
          YYABORT;
        else if (!yyla.empty ())
          {
            yy_destroy_ ("Error: discarding", yyla);
            yyla.clear ();
          }
      }

    // Else will try to reuse lookahead token after shifting the error token.
    goto yyerrlab1;


  /*---------------------------------------------------.
  | yyerrorlab -- error raised explicitly by YYERROR.  |
  `---------------------------------------------------*/
  yyerrorlab:

    /* Pacify compilers like GCC when the user code never invokes
       YYERROR and the label yyerrorlab therefore never appears in user
       code.  */
    if (false)
      goto yyerrorlab;
    yyerror_range[1].location = yystack_[yylen - 1].location;
    /* Do not reclaim the symbols of the rule whose action triggered
       this YYERROR.  */
    yypop_ (yylen);
    yylen = 0;
    goto yyerrlab1;

  /*-------------------------------------------------------------.
  | yyerrlab1 -- common code for both syntax error and YYERROR.  |
  `-------------------------------------------------------------*/
  yyerrlab1:
    yyerrstatus_ = 3;   // Each real token shifted decrements this.
    {
      stack_symbol_type error_token;
      for (;;)
        {
          yyn = yypact_[yystack_[0].state];
          if (!yy_pact_value_is_default_ (yyn))
            {
              yyn += yyterror_;
              if (0 <= yyn && yyn <= yylast_ && yycheck_[yyn] == yyterror_)
                {
                  yyn = yytable_[yyn];
                  if (0 < yyn)
                    break;
                }
            }

          // Pop the current state because it cannot handle the error token.
          if (yystack_.size () == 1)
            YYABORT;

          yyerror_range[1].location = yystack_[0].location;
          yy_destroy_ ("Error: popping", yystack_[0]);
          yypop_ ();
          YY_STACK_PRINT ();
        }

      yyerror_range[2].location = yyla.location;
      YYLLOC_DEFAULT (error_token.location, yyerror_range, 2);

      // Shift the error token.
      error_token.state = yyn;
      yypush_ ("Shifting", error_token);
    }
    goto yynewstate;

    // Accept.
  yyacceptlab:
    yyresult = 0;
    goto yyreturn;

    // Abort.
  yyabortlab:
    yyresult = 1;
    goto yyreturn;

  yyreturn:
    if (!yyla.empty ())
      yy_destroy_ ("Cleanup: discarding lookahead", yyla);

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYABORT or YYACCEPT.  */
    yypop_ (yylen);
    while (1 < yystack_.size ())
      {
        yy_destroy_ ("Cleanup: popping", yystack_[0]);
        yypop_ ();
      }

    return yyresult;
  }
    catch (...)
      {
        YYCDEBUG << "Exception caught: cleaning lookahead and stack"
                 << std::endl;
        // Do not try to display the values of the reclaimed symbols,
        // as their printer might throw an exception.
        if (!yyla.empty ())
          yy_destroy_ (YY_NULLPTR, yyla);

        while (1 < yystack_.size ())
          {
            yy_destroy_ (YY_NULLPTR, yystack_[0]);
            yypop_ ();
          }
        throw;
      }
  }

  void
  parser::error (const syntax_error& yyexc)
  {
    error (yyexc.location, yyexc.what());
  }

  // Generate an error message.
  std::string
  parser::yysyntax_error_ (state_type yystate, const symbol_type& yyla) const
  {
    // Number of reported tokens (one for the "unexpected", one per
    // "expected").
    size_t yycount = 0;
    // Its maximum.
    enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
    // Arguments of yyformat.
    char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];

    /* There are many possibilities here to consider:
       - If this state is a consistent state with a default action, then
         the only way this function was invoked is if the default action
         is an error action.  In that case, don't check for expected
         tokens because there are none.
       - The only way there can be no lookahead present (in yyla) is
         if this state is a consistent state with a default action.
         Thus, detecting the absence of a lookahead is sufficient to
         determine that there is no unexpected or expected token to
         report.  In that case, just report a simple "syntax error".
       - Don't assume there isn't a lookahead just because this state is
         a consistent state with a default action.  There might have
         been a previous inconsistent state, consistent state with a
         non-default action, or user semantic action that manipulated
         yyla.  (However, yyla is currently not documented for users.)
       - Of course, the expected token list depends on states to have
         correct lookahead information, and it depends on the parser not
         to perform extra reductions after fetching a lookahead from the
         scanner and before detecting a syntax error.  Thus, state
         merging (from LALR or IELR) and default reductions corrupt the
         expected token list.  However, the list is correct for
         canonical LR with one exception: it will still contain any
         token that will not be accepted due to an error action in a
         later state.
    */
    if (!yyla.empty ())
      {
        int yytoken = yyla.type_get ();
        yyarg[yycount++] = yytname_[yytoken];
        int yyn = yypact_[yystate];
        if (!yy_pact_value_is_default_ (yyn))
          {
            /* Start YYX at -YYN if negative to avoid negative indexes in
               YYCHECK.  In other words, skip the first -YYN actions for
               this state because they are default actions.  */
            int yyxbegin = yyn < 0 ? -yyn : 0;
            // Stay within bounds of both yycheck and yytname.
            int yychecklim = yylast_ - yyn + 1;
            int yyxend = yychecklim < yyntokens_ ? yychecklim : yyntokens_;
            for (int yyx = yyxbegin; yyx < yyxend; ++yyx)
              if (yycheck_[yyx + yyn] == yyx && yyx != yyterror_
                  && !yy_table_value_is_error_ (yytable_[yyx + yyn]))
                {
                  if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                    {
                      yycount = 1;
                      break;
                    }
                  else
                    yyarg[yycount++] = yytname_[yyx];
                }
          }
      }

    char const* yyformat = YY_NULLPTR;
    switch (yycount)
      {
#define YYCASE_(N, S)                         \
        case N:                               \
          yyformat = S;                       \
        break
        YYCASE_(0, YY_("syntax error"));
        YYCASE_(1, YY_("syntax error, unexpected %s"));
        YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
        YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
        YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
        YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
      }

    std::string yyres;
    // Argument number.
    size_t yyi = 0;
    for (char const* yyp = yyformat; *yyp; ++yyp)
      if (yyp[0] == '%' && yyp[1] == 's' && yyi < yycount)
        {
          yyres += yytnamerr_ (yyarg[yyi++]);
          ++yyp;
        }
      else
        yyres += *yyp;
    return yyres;
  }


  const short int parser::yypact_ninf_ = -240;

  const signed char parser::yytable_ninf_ = -50;

  const short int
  parser::yypact_[] =
  {
     173,   -15,     5,  -240,  -240,  -240,  -240,   305,  -240,  -240,
    -240,  -240,   150,   409,   409,   409,   409,     1,   409,   409,
      10,   103,  -240,   409,  -240,   409,  -240,    61,  -240,  -240,
    -240,  -240,  -240,   341,   409,   677,   409,    59,  -240,  -240,
      86,    50,   107,  -240,    32,   100,  -240,  -240,   237,   199,
     116,    45,    22,    72,    78,   140,    94,  -240,   119,    91,
      38,  -240,  -240,  -240,   138,  -240,  -240,  -240,  -240,   112,
      -6,   130,   145,   110,  -240,   677,   363,   567,   589,   611,
      34,   104,  -240,     4,   545,   218,  -240,   215,   633,  -240,
       2,   144,   139,  -240,  -240,    -1,   169,  -240,  -240,   163,
    -240,   202,   409,   387,  -240,  -240,  -240,  -240,  -240,  -240,
    -240,  -240,   409,   409,  -240,  -240,  -240,  -240,  -240,   195,
     409,  -240,   409,  -240,  -240,   409,  -240,   240,   387,   409,
    -240,   152,  -240,   197,   185,  -240,   185,   222,  -240,   -12,
    -240,   158,  -240,    35,  -240,  -240,  -240,   223,  -240,   443,
    -240,   477,  -240,   511,  -240,  -240,  -240,   236,   242,   243,
     244,   655,  -240,   409,   387,   409,  -240,   409,  -240,   409,
     409,  -240,  -240,   -18,  -240,  -240,   237,   130,  -240,  -240,
     258,   249,  -240,   281,   250,  -240,   199,  -240,   199,   199,
    -240,  -240,  -240,   285,   254,   224,  -240,   241,  -240,   226,
    -240,   265,  -240,  -240,  -240,   130,   256,  -240,  -240,  -240,
    -240,  -240,  -240,  -240,  -240,  -240,   107,   304,   307,   199,
      36,   262,   274,  -240,   199,  -240,   263,  -240,  -240,   275,
     227,  -240,   409,  -240,   387,  -240,  -240,   387,   409,  -240,
     291,  -240,   282,   247,  -240,   106,  -240,  -240,   409,  -240,
     409,  -240,  -240,  -240,  -240,  -240,    23,  -240,  -240,  -240,
      46,  -240,   276,   317,  -240,  -240,   283,   284,    43,   199,
    -240,   298,   289,   199,  -240,  -240,  -240,   290,  -240,   286,
     133,  -240,  -240,  -240,  -240,   293,  -240,   306,  -240,  -240,
      43,   302,  -240,  -240,  -240,  -240
  };

  const unsigned char
  parser::yydefact_[] =
  {
       0,     0,     9,     5,     1,     3,     4,     0,    56,    55,
      43,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    63,    34,     0,    99,     0,    36,   106,   113,   109,
     111,   110,   112,     0,     0,     0,   143,     0,    10,    21,
      37,   149,    90,    98,     0,     0,    39,    40,     0,   149,
       0,     0,   166,     0,     0,   171,     0,    16,     0,     0,
       0,    61,    62,    24,     0,    59,    73,    74,    64,     0,
      63,     0,     0,     0,   107,     0,     0,     0,     0,     0,
      99,     0,   121,     0,    90,   151,   148,   152,     0,    96,
     146,     0,   141,   144,   118,     0,     0,    48,    47,     0,
      32,     0,     0,     0,    11,   105,   103,   104,   102,   101,
     100,    20,     0,     0,    50,    51,    52,    53,    54,     0,
       0,    15,     0,    14,    13,     0,    19,     0,     0,     0,
      31,     0,    66,    68,     0,    23,     0,     0,    27,     0,
      84,     0,    75,     0,   114,    12,   108,     0,   122,     0,
     123,     0,   124,     0,   125,   126,   120,   105,   103,   104,
     102,     0,   153,     0,     0,     0,    97,     0,   115,   142,
       0,   117,    57,     0,    44,    45,     0,     0,    38,   169,
       0,   167,   159,     0,   157,   147,   150,    41,   173,   165,
     172,    17,   163,     0,   161,     0,    30,     0,    69,     0,
      60,     0,    28,    26,    35,     0,     0,    85,   127,   132,
     133,   134,   128,   129,   130,   131,   154,     0,     0,    91,
     139,     0,   135,   137,   146,   145,     0,    58,    22,     0,
       0,    93,   168,    94,   158,   174,    92,   162,     0,    67,
       0,    25,     0,     0,    76,    78,   155,   156,     0,   116,
     136,   119,    46,    33,   170,   160,     0,   164,    95,    71,
       0,    65,     0,     9,     6,    79,     0,    80,    86,   140,
     138,     0,     0,   175,    72,    70,     8,     0,     7,    88,
       0,    87,    82,   177,    18,     0,    29,     0,    77,    81,
      86,     0,   176,    89,    83,   178
  };

  const short int
  parser::yypgoto_[] =
  {
    -240,  -240,  -240,  -211,  -240,  -240,  -240,  -240,  -240,  -240,
    -240,  -240,  -240,  -240,  -240,   176,   333,  -240,   229,   220,
     288,  -240,  -240,   164,  -240,  -240,   343,   190,   168,  -240,
    -240,  -239,    84,  -240,    -7,  -240,   -32,   -25,   205,  -240,
     127,  -240,  -240,   209,    -5,   268,   -97,  -240,   217,  -240,
    -240,  -240,   -11,   231,  -240,  -240,  -240,  -240,  -240,  -240
  };

  const short int
  parser::yydefgoto_[] =
  {
      -1,     2,   263,     6,     7,    38,   127,   235,    96,   134,
     243,   177,    71,   101,    39,   119,    40,   173,    64,    65,
      69,   137,   131,   132,   240,   260,   133,   141,   142,   266,
     267,   143,   282,   288,    49,    88,    42,    43,   221,   222,
     223,    91,    92,    93,   182,    45,    86,    87,   183,   184,
     193,   194,   179,   180,   181,    56,    51,   256,   285,   291
  };

  const short int
  parser::yytable_[] =
  {
      41,    84,    44,    53,    54,     4,   268,    52,    52,   202,
      89,    58,    59,     8,     9,   185,    72,   110,    73,   102,
     103,   227,   102,   103,   102,   103,    83,    85,   190,    90,
      95,   228,   264,    60,     3,   271,    18,   203,   272,    19,
      57,   290,   102,   103,    68,   149,   151,   153,    23,    61,
     146,    62,   278,    24,     5,   156,   102,   103,   170,   110,
     171,   167,    27,   166,    28,    29,    30,    31,    32,    72,
     102,   103,    18,    33,   206,    19,   122,    66,    35,    67,
      36,   111,   281,    37,    23,   154,   274,   130,   207,    24,
     248,    97,    98,    99,   121,    52,   207,   275,    27,   104,
      28,    29,    30,    31,    32,    85,   186,    74,   129,    33,
     100,   102,   103,   188,    35,   189,    36,    75,    85,    37,
      94,   123,   195,   192,   110,   -49,   110,   124,   110,   216,
     102,   103,    23,   128,   105,   106,   107,   108,   109,   102,
     103,   265,    66,   126,    67,   140,    27,   145,    28,    29,
      30,    31,    32,    68,   112,   155,    52,    33,   219,   113,
     220,   138,   224,   220,    36,   102,   103,    37,   289,   140,
     120,   144,   140,    -2,     1,   113,    -2,    -2,    -2,    -2,
      -2,    -2,    -2,    -2,    -2,    -2,    -2,   135,   169,    -2,
     136,   110,    46,    47,   125,    -2,    -2,    -2,    -2,   113,
      48,   196,   168,    -2,   197,   174,   175,   204,   172,    -2,
     205,    -2,    -2,   176,    -2,    -2,    -2,    -2,    -2,   102,
     103,   254,    -2,    -2,    61,    52,    62,    -2,    -2,   255,
      -2,   258,   257,    -2,   161,   163,   164,   162,   102,   103,
     178,   269,   238,   220,   102,   103,   187,   198,   262,   273,
      -9,    -9,    -9,    -9,    -9,    -9,    -9,    -9,    -9,    -9,
      -9,   191,   201,    -9,   114,   115,   116,   117,   118,    -9,
      -9,    -9,    -9,   231,   208,   241,   253,    -9,   136,   205,
      66,    50,    67,    -9,    55,    -9,    -9,   212,    -9,    -9,
      -9,    -9,    -9,   213,   214,   215,   233,    -9,   232,   234,
     236,    -9,    -9,   237,    -9,   242,   245,    -9,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,   246,
     249,    19,   247,   250,   251,   276,   252,    20,    21,    22,
      23,   259,   277,   261,   279,    24,   280,   283,   284,   286,
     287,    25,   292,    26,    27,   293,    28,    29,    30,    31,
      32,   295,   229,    63,    18,    33,   200,    19,   139,    34,
      35,   239,    36,   199,    70,    37,    76,   230,    77,    78,
      79,    80,    81,   244,   294,   226,    18,   270,   225,    19,
      27,   218,    28,    29,    30,    31,    32,     0,    23,   147,
       0,    33,    82,    24,   217,     0,    35,     0,    36,     0,
      18,    37,    27,    19,    28,    29,    30,    31,    32,     0,
       0,     0,    23,    33,     0,     0,     0,    24,    35,     0,
      36,     0,    18,    37,     0,    19,    27,     0,    28,    29,
      30,    31,    32,     0,    23,     0,     0,    33,     0,    24,
       0,    34,    35,     0,    36,     0,     0,    37,    27,     0,
      28,    29,    30,    31,    32,     0,     0,     0,     0,    33,
       0,     0,     0,     0,    35,     0,    36,     0,    23,    37,
     105,   106,   107,   108,   109,     0,     0,     0,     0,     0,
       0,     0,    27,     0,    28,    29,    30,    31,    32,     0,
       0,     0,     0,    33,   209,     0,     0,     0,     0,     0,
      36,     0,    23,    37,   105,   106,   107,   108,   109,     0,
       0,     0,     0,     0,     0,     0,    27,     0,    28,    29,
      30,    31,    32,     0,     0,     0,     0,    33,   210,     0,
       0,     0,     0,     0,    36,     0,    23,    37,   105,   106,
     107,   108,   109,     0,     0,     0,     0,     0,     0,     0,
      27,     0,    28,    29,    30,    31,    32,     0,     0,     0,
       0,    33,   211,     0,     0,     0,     0,     0,    36,     0,
      23,    37,   157,   158,   159,   160,   109,     0,     0,     0,
       0,     0,     0,     0,    27,     0,    28,    29,    30,    31,
      32,     0,    23,     0,     0,    33,     0,    24,     0,     0,
       0,     0,    36,     0,     0,    37,    27,     0,    28,    29,
      30,    31,    32,     0,    23,     0,     0,    33,   148,    24,
       0,     0,     0,     0,    36,     0,     0,    37,    27,     0,
      28,    29,    30,    31,    32,     0,    23,     0,     0,    33,
     150,    24,     0,     0,     0,     0,    36,     0,     0,    37,
      27,     0,    28,    29,    30,    31,    32,     0,    23,     0,
       0,    33,   152,     0,     0,   165,     0,     0,    36,     0,
       0,    37,    27,     0,    28,    29,    30,    31,    32,     0,
      23,     0,     0,    33,     0,    24,     0,     0,     0,     0,
      36,     0,     0,    37,    27,     0,    28,    29,    30,    31,
      32,     0,    23,     0,     0,    33,     0,     0,     0,     0,
       0,     0,    36,     0,     0,    37,    27,     0,    28,    29,
      30,    31,    32,     0,     0,     0,     0,    33,     0,     0,
       0,     0,     0,     0,    36,     0,     0,    37
  };

  const short int
  parser::yycheck_[] =
  {
       7,    33,     7,    14,    15,     0,   245,    14,    15,    21,
      35,    18,    19,     3,     4,   112,    23,    42,    25,    20,
      21,    39,    20,    21,    20,    21,    33,    34,   125,    36,
      37,    49,   243,    23,    49,    12,    13,    49,    15,    16,
      39,   280,    20,    21,    50,    77,    78,    79,    25,    39,
      75,    41,   263,    30,    49,    51,    20,    21,    59,    84,
      61,    59,    39,    88,    41,    42,    43,    44,    45,    76,
      20,    21,    13,    50,    39,    16,    54,    39,    55,    41,
      57,    49,    39,    60,    25,    51,    40,    49,    53,    30,
      54,     5,     6,     7,    49,   102,    53,    51,    39,    49,
      41,    42,    43,    44,    45,   112,   113,    46,    17,    50,
      24,    20,    21,   120,    55,   122,    57,    56,   125,    60,
      61,    49,   129,   128,   149,    39,   151,    49,   153,   161,
      20,    21,    25,    14,    27,    28,    29,    30,    31,    20,
      21,    35,    39,    49,    41,    39,    39,    37,    41,    42,
      43,    44,    45,    50,    54,    51,   163,    50,   165,    59,
     167,    49,   169,   170,    57,    20,    21,    60,    35,    39,
      54,    26,    39,     0,     1,    59,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    49,    49,    16,
      52,   216,    42,    43,    54,    22,    23,    24,    25,    59,
      50,    49,    58,    30,    52,    42,    43,    49,    39,    36,
      52,    38,    39,    50,    41,    42,    43,    44,    45,    20,
      21,   232,    49,    50,    39,   232,    41,    54,    55,   234,
      57,   238,   237,    60,    16,    20,    21,    19,    20,    21,
      38,   248,    18,   250,    20,    21,    51,    50,     1,   256,
       3,     4,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    21,    40,    16,    27,    28,    29,    30,    31,    22,
      23,    24,    25,    15,    51,    49,    49,    30,    52,    52,
      39,    13,    41,    36,    16,    38,    39,    51,    41,    42,
      43,    44,    45,    51,    51,    51,    15,    50,    49,    49,
      15,    54,    55,    49,    57,    40,    50,    60,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    15,
      58,    16,    15,    49,    61,    49,    51,    22,    23,    24,
      25,    40,    15,    51,    51,    30,    52,    39,    49,    49,
      54,    36,    49,    38,    39,    39,    41,    42,    43,    44,
      45,    49,   176,    20,    13,    50,   136,    16,    70,    54,
      55,   197,    57,   134,    21,    60,    25,   177,    27,    28,
      29,    30,    31,   205,   290,   170,    13,   250,   169,    16,
      39,   164,    41,    42,    43,    44,    45,    -1,    25,    26,
      -1,    50,    51,    30,   163,    -1,    55,    -1,    57,    -1,
      13,    60,    39,    16,    41,    42,    43,    44,    45,    -1,
      -1,    -1,    25,    50,    -1,    -1,    -1,    30,    55,    -1,
      57,    -1,    13,    60,    -1,    16,    39,    -1,    41,    42,
      43,    44,    45,    -1,    25,    -1,    -1,    50,    -1,    30,
      -1,    54,    55,    -1,    57,    -1,    -1,    60,    39,    -1,
      41,    42,    43,    44,    45,    -1,    -1,    -1,    -1,    50,
      -1,    -1,    -1,    -1,    55,    -1,    57,    -1,    25,    60,
      27,    28,    29,    30,    31,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    39,    -1,    41,    42,    43,    44,    45,    -1,
      -1,    -1,    -1,    50,    51,    -1,    -1,    -1,    -1,    -1,
      57,    -1,    25,    60,    27,    28,    29,    30,    31,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    39,    -1,    41,    42,
      43,    44,    45,    -1,    -1,    -1,    -1,    50,    51,    -1,
      -1,    -1,    -1,    -1,    57,    -1,    25,    60,    27,    28,
      29,    30,    31,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      39,    -1,    41,    42,    43,    44,    45,    -1,    -1,    -1,
      -1,    50,    51,    -1,    -1,    -1,    -1,    -1,    57,    -1,
      25,    60,    27,    28,    29,    30,    31,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    39,    -1,    41,    42,    43,    44,
      45,    -1,    25,    -1,    -1,    50,    -1,    30,    -1,    -1,
      -1,    -1,    57,    -1,    -1,    60,    39,    -1,    41,    42,
      43,    44,    45,    -1,    25,    -1,    -1,    50,    51,    30,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    60,    39,    -1,
      41,    42,    43,    44,    45,    -1,    25,    -1,    -1,    50,
      51,    30,    -1,    -1,    -1,    -1,    57,    -1,    -1,    60,
      39,    -1,    41,    42,    43,    44,    45,    -1,    25,    -1,
      -1,    50,    51,    -1,    -1,    32,    -1,    -1,    57,    -1,
      -1,    60,    39,    -1,    41,    42,    43,    44,    45,    -1,
      25,    -1,    -1,    50,    -1,    30,    -1,    -1,    -1,    -1,
      57,    -1,    -1,    60,    39,    -1,    41,    42,    43,    44,
      45,    -1,    25,    -1,    -1,    50,    -1,    -1,    -1,    -1,
      -1,    -1,    57,    -1,    -1,    60,    39,    -1,    41,    42,
      43,    44,    45,    -1,    -1,    -1,    -1,    50,    -1,    -1,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    60
  };

  const unsigned char
  parser::yystos_[] =
  {
       0,     1,    63,    49,     0,    49,    65,    66,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    16,
      22,    23,    24,    25,    30,    36,    38,    39,    41,    42,
      43,    44,    45,    50,    54,    55,    57,    60,    67,    76,
      78,    96,    98,    99,   106,   107,    42,    43,    50,    96,
     107,   118,    96,   114,   114,   107,   117,    39,    96,    96,
      23,    39,    41,    78,    80,    81,    39,    41,    50,    82,
      88,    74,    96,    96,    46,    56,    25,    27,    28,    29,
      30,    31,    51,    96,    98,    96,   108,   109,    97,    99,
      96,   103,   104,   105,    61,    96,    70,     5,     6,     7,
      24,    75,    20,    21,    49,    27,    28,    29,    30,    31,
      99,    49,    54,    59,    27,    28,    29,    30,    31,    77,
      54,    49,    54,    49,    49,    54,    49,    68,    14,    17,
      49,    84,    85,    88,    71,    49,    52,    83,    49,    82,
      39,    89,    90,    93,    26,    37,    99,    26,    51,    98,
      51,    98,    51,    98,    51,    51,    51,    27,    28,    29,
      30,    16,    19,    20,    21,    32,    99,    59,    58,    49,
      59,    61,    39,    79,    42,    43,    50,    73,    38,   114,
     115,   116,   106,   110,   111,   108,    96,    51,    96,    96,
     108,    21,   106,   112,   113,    96,    49,    52,    50,    80,
      81,    40,    21,    49,    49,    52,    39,    53,    51,    51,
      51,    51,    51,    51,    51,    51,    98,   115,   110,    96,
      96,   100,   101,   102,    96,   105,   100,    39,    49,    77,
      89,    15,    49,    15,    49,    69,    15,    49,    18,    85,
      86,    49,    40,    72,    90,    50,    15,    15,    54,    58,
      49,    61,    51,    49,   114,   106,   119,   106,    96,    40,
      87,    51,     1,    64,    65,    35,    91,    92,    93,    96,
     102,    12,    15,    96,    40,    51,    49,    15,    65,    51,
      52,    39,    94,    39,    49,   120,    49,    54,    95,    35,
      93,   121,    49,    39,    94,    49
  };

  const unsigned char
  parser::yyr1_[] =
  {
       0,    62,    63,    63,    63,    63,    64,    64,    64,    66,
      65,    67,    67,    67,    67,    67,    68,    69,    67,    67,
      67,    70,    67,    67,    71,    67,    67,    67,    72,    67,
      67,    67,    73,    67,    74,    67,    67,    75,    67,    76,
      76,    76,    76,    76,    76,    76,    76,    76,    76,    76,
      77,    77,    77,    77,    77,    78,    78,    79,    79,    80,
      80,    81,    81,    82,    83,    82,    84,    84,    85,    86,
      85,    87,    87,    88,    88,    89,    89,    90,    91,    91,
      91,    91,    92,    92,    93,    93,    94,    94,    95,    95,
      96,    96,    96,    96,    96,    96,    97,    97,    98,    98,
      98,    98,    98,    98,    98,    98,    99,    99,    99,    99,
      99,    99,    99,    99,    99,    99,    99,    99,    99,    99,
      99,    99,    99,    99,    99,    99,    99,    99,    99,    99,
      99,    99,    99,    99,    99,   100,   100,   101,   101,   102,
     102,   103,   103,   103,   104,   104,   105,   106,   106,   107,
     107,   108,   108,   109,   109,   109,   109,   110,   110,   111,
     111,   112,   112,   113,   113,   114,   114,   115,   115,   116,
     116,   117,   117,   118,   119,   120,   119,   121,   119
  };

  const unsigned char
  parser::yyr2_[] =
  {
       0,     2,     0,     2,     2,     2,     1,     2,     2,     0,
       2,     2,     3,     3,     3,     3,     0,     0,     8,     3,
       2,     0,     4,     3,     0,     5,     4,     3,     0,     8,
       4,     3,     0,     5,     0,     4,     1,     0,     3,     2,
       2,     4,     1,     1,     3,     3,     5,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       3,     1,     1,     0,     0,     5,     1,     3,     1,     0,
       5,     1,     2,     1,     1,     1,     3,     6,     0,     1,
       1,     3,     2,     4,     1,     2,     0,     1,     0,     2,
       1,     4,     5,     4,     4,     6,     1,     2,     1,     1,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     1,
       1,     1,     1,     1,     3,     3,     5,     3,     2,     5,
       3,     2,     3,     3,     3,     3,     3,     4,     4,     4,
       4,     4,     4,     4,     4,     1,     2,     1,     3,     1,
       3,     1,     2,     0,     1,     3,     1,     3,     2,     1,
       3,     1,     1,     2,     3,     4,     4,     1,     2,     1,
       3,     1,     2,     1,     3,     3,     1,     1,     2,     1,
       3,     1,     3,     3,     0,     0,     4,     0,     5
  };



  // YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
  // First, the terminals, then, starting at \a yyntokens_, nonterminals.
  const char*
  const parser::yytname_[] =
  {
  "\"end of file\"", "error", "$undefined", "\"private\"", "\"public\"",
  "\"nonfix\"", "\"outfix\"", "\"fixity\"", "\"def\"", "\"const\"",
  "\"let\"", "\"type\"", "\"interface\"", "\"case\"", "\"of\"", "\"end\"",
  "\"if\"", "\"then\"", "\"else\"", "\"otherwise\"", "\"when\"",
  "\"with\"", "\"using\"", "\"namespace\"", "\"extern\"",
  "\"left outfix operator\"", "\"right outfix operator\"",
  "\"infix operator\"", "\"infixl operator\"", "\"infixr operator\"",
  "\"prefix operator\"", "\"postfix operator\"", "\"->\"",
  "\"invalid character\"", "\"bad token\"", "\"...\"", "ESCAPE",
  "\"end of input\"", "\"code section\"", "\"identifier\"", "\"symbol\"",
  "\"string\"", "\"integer\"", "\"bigint\"", "\"converted bigint\"",
  "\"floating point number\"", "\"type tag\"", "\"namespace brackets\"",
  "\"simple expression\"", "';'", "'('", "')'", "','", "'*'", "'='",
  "'\\\\'", "'@'", "'{'", "'}'", "'|'", "'['", "']'", "$accept", "source",
  "items", "item_pos", "$@1", "item", "@2", "@3", "$@4", "$@5", "$@6",
  "$@7", "$@8", "$@9", "fixity", "op", "scope", "ids", "fnames", "fname",
  "opt_brackets", "$@10", "name_xsyms_list", "name_xsyms", "$@11", "xsyms",
  "name", "prototypes", "prototype", "opt_ctypes", "ctypes", "ctype",
  "optname", "optalias", "expr", "args", "simple", "prim", "comp_clauses",
  "comp_clause_list", "comp_clause", "rows", "row_list", "row", "rule",
  "lhs", "rhs", "qual_rhs", "rules", "rulel", "pat_rules", "pat_rulel",
  "simple_rule", "simple_rules", "simple_rulel", "type_rule", "macro_rule",
  "interface_rules", "@12", "@13", YY_NULLPTR
  };

#if YYDEBUG
  const unsigned short int
  parser::yyrline_[] =
  {
       0,   231,   231,   233,   234,   235,   243,   244,   245,   251,
     251,   256,   260,   268,   270,   272,   275,   294,   274,   299,
     302,   310,   309,   319,   321,   321,   323,   329,   336,   335,
     339,   341,   343,   343,   344,   344,   345,   347,   347,   356,
     358,   360,   363,   365,   367,   369,   371,   374,   375,   376,
     380,   381,   382,   383,   384,   388,   389,   393,   395,   400,
     402,   407,   408,   413,   414,   414,   436,   439,   444,   446,
     446,   451,   453,   458,   460,   466,   467,   471,   480,   481,
     483,   484,   489,   491,   496,   497,   500,   502,   506,   507,
     516,   518,   521,   524,   527,   530,   535,   537,   547,   548,
     549,   550,   551,   552,   553,   554,   560,   565,   570,   575,
     576,   577,   578,   579,   580,   599,   600,   606,   607,   608,
     614,   616,   617,   618,   619,   620,   621,   622,   639,   643,
     647,   651,   658,   662,   666,   674,   675,   679,   681,   686,
     688,   693,   694,   695,   699,   701,   706,   716,   721,   726,
     728,   733,   734,   738,   739,   743,   755,   770,   771,   775,
     783,   796,   797,   801,   809,   823,   825,   831,   832,   836,
     839,   850,   867,   878,   894,   896,   895,   906,   905
  };

  // Print the state stack on the debug stream.
  void
  parser::yystack_print_ ()
  {
    *yycdebug_ << "Stack now";
    for (stack_type::const_iterator
           i = yystack_.begin (),
           i_end = yystack_.end ();
         i != i_end; ++i)
      *yycdebug_ << ' ' << i->state;
    *yycdebug_ << std::endl;
  }

  // Report on the debug stream that the rule \a yyrule is going to be reduced.
  void
  parser::yy_reduce_print_ (int yyrule)
  {
    unsigned int yylno = yyrline_[yyrule];
    int yynrhs = yyr2_[yyrule];
    // Print the symbols being reduced, and their result.
    *yycdebug_ << "Reducing stack by rule " << yyrule - 1
               << " (line " << yylno << "):" << std::endl;
    // The symbols being reduced.
    for (int yyi = 0; yyi < yynrhs; yyi++)
      YY_SYMBOL_PRINT ("   $" << yyi + 1 << " =",
                       yystack_[(yynrhs) - (yyi + 1)]);
  }
#endif // YYDEBUG

  // Symbol number corresponding to token number t.
  inline
  parser::token_number_type
  parser::yytranslate_ (int t)
  {
    static
    const token_number_type
    translate_table[] =
    {
     0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      50,    51,    53,     2,    52,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    49,
       2,    54,     2,     2,    56,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    60,    55,    61,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    57,    59,    58,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48
    };
    const unsigned int user_token_number_max_ = 303;
    const token_number_type undef_token_ = 2;

    if (static_cast<int>(t) <= yyeof_)
      return yyeof_;
    else if (static_cast<unsigned int> (t) <= user_token_number_max_)
      return translate_table[t];
    else
      return undef_token_;
  }


} // yy
#line 3100 "./parser.cc" // lalr1.cc:1167
#line 918 "parser.yy" // lalr1.cc:1168


void
yy::parser::error (const yy::parser::location_type& l,
		   const string& m)
{
  interp.error(l, m);
}

static void mangle_fname(string& name)
{
  size_t pos = name.find("::");
  while (pos != string::npos) {
    name.replace(pos, 2, "/");
    pos = name.find("::", pos);
  }
  name += ".pure";
}
